/**************************************************************************/
/*                                                                        */
/*                                 OCaml                                  */
/*                                                                        */
/*                 David Allsopp, OCaml Labs, Cambridge.                  */
/*                                                                        */
/*   Copyright 2017 MetaStack Solutions Ltd.                              */
/*                                                                        */
/*   All rights reserved.  This file is distributed under the terms of    */
/*   the GNU Lesser General Public License version 2.1, with the          */
/*   special exception on linking described in the file LICENSE.          */
/*                                                                        */
/**************************************************************************/

#include <caml/mlvalues.h>
#include "unixsupport.h"

CAMLprim value unix_isatty(value fd)
{
  DWORD lpMode;
  HANDLE hFile = Handle_val(fd);
  return (Val_bool((GetFileType(hFile) == FILE_TYPE_CHAR)
                   && GetConsoleMode(hFile, &lpMode)));
}
