/*----------------------------------------------------------------------------*/
/*                                                                            */
/* Copyright (c) 1995, 2004 IBM Corporation. All rights reserved.             */
/* Copyright (c) 2005-2009 Rexx Language Association. All rights reserved.    */
/*                                                                            */
/* This program and the accompanying materials are made available under       */
/* the terms of the Common Public License v1.0 which accompanies this         */
/* distribution. A copy is also available at the following address:           */
/* http://www.oorexx.org/license.html                          */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or                 */
/* without modification, are permitted provided that the following            */
/* conditions are met:                                                        */
/*                                                                            */
/* Redistributions of source code must retain the above copyright             */
/* notice, this list of conditions and the following disclaimer.              */
/* Redistributions in binary form must reproduce the above copyright          */
/* notice, this list of conditions and the following disclaimer in            */
/* the documentation and/or other materials provided with the distribution.   */
/*                                                                            */
/* Neither the name of Rexx Language Association nor the names                */
/* of its contributors may be used to endorse or promote products             */
/* derived from this software without specific prior written permission.      */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS          */
/* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT   */
/* OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,      */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,        */
/* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     */
/* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    */
/* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         */
/* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               */
/*                                                                            */
/*----------------------------------------------------------------------------*/
class ESource;               // Forward declaration
class OrxScript;             // Forward declaration
class OrxEvent;              // Forward declaration


#ifndef ORXEVENTS_HPP
#define ORXEVENTS_HPP


#include "orxscrpt.hpp"



class OrxEvent {

public:
  //Constructor
  OrxEvent(OrxScript *Script, FILE *LogFile);
  //Destructor
  ~OrxEvent();

  STDMETHODIMP OrxEvent::CheckEvent(LPCOLESTR Code, IDispatch **pbIDispatch);
  STDMETHODIMP AddEvent(OLECHAR *pName,LPCOLESTR Code, DISPID SinkDispID, DWORD Flags, IDispatch **pbIDispatch);
//   OrxASEvent -- Object Rexx AddScriptlet Event
// handles IActiveScript::AddScriptlet events.
/*      These are global.  The Event will go on a chain (linked list) of events,
 *  but until that event is found, these must stay "above" the Event Chain.  */
  STDMETHODIMP AddEvent(LPCOLESTR ItemName,LPCOLESTR SubItemName, LPCOLESTR EventName, DISPID SinkDispID);
  STDMETHODIMP ConnectEvents();
  STDMETHODIMP DisconnectEvents();
  STDMETHODIMP FindEvent(LPCOLESTR ItemName,LPCOLESTR SubItemName, LPCOLESTR EventName, DISPID *SinkDispID);

private:
  LooseLinkedList *EventSourceChain;
  OrxScript      *Engine;
  FILE           *logfile;
  };


/*  The structures, classes, datatypes defined here are an
  attempt to straighten out the gnarly system to handle events.
  Events in MS parlance are a Source and a Sink.
  The Source generates the event, and the Sink acts on it.  This
  is not a true event, there is no interruption of service on the
  Sink.  The event notification comes through the IDispatch
  interface of the Sink.  However, the DispID to execute was not
  generated by the Sink, it was created by the Source.  Instead
  of telling the Sink which one of its DispIDs to execute, the
  Source is telling the Sink which Source DispID is firing.
    Obviously, the Source and Sink DispIDs can overlap.  There
  must be a translator to map the Source DispID (theirs) to the
  Sink DispID (ours).  Until that translation is made, then the
  Source DispID cannot come through the autmation IDispatch of
  the Sink.  It must come through an IDispatch specially designed
  to make this mapping.
    If Source and Sink can have DispIDs that overlap, then
  multiple Sources could have DispIDs that overlap.  Therefore,
  each source that we connect to must be kept seperate, and have
  its own IDispatch for mapping.
    As the Sink, we connect to the Source through the Advise()
  method of the IConnectionPoint Interface.  At that time the Sink
  passes the Source the address of the IUnknown to use.  If that
  method were expanded to also accept the DispID to use, and if
  the Source passed its DispID as the first parameter to the Sink
  when it invokes the Sink using the Sinks DispID, then all of this
  would go away.  The Sink would only need 1 (ONE) IDispatch! Not
  one for automation, and one for every Source......"
*/

/*
 *    This is the Rosetta Stone of the event system.  It maps
 *  all of the Source DispIDs (theirs) to the Sink DispIDs (ours).
 *  A Source can potentially have several functions, each with a
 *  different DispID, per container.  One of these is created
 *  for each function we are told to map.  (One ESource is
 *  created per container.)
 *
 *  N.B.  This structure does not store the Source's DISPID.
 *  That DispID is converted to character form, and is used
 *  as the name to identify this structure.  This makes the
 *  lookup in Invoke() or InvokeEx() work with existing
 *  LinkedList functionality.
 */
typedef struct EVENTMAP_struct {
  BSTR    SourceEventName;
  DISPID  Sink;
  } EMAP, *PEMAP;




/*
 *    This is the Event Source.  In MS parlance, this is where we
 *  "source" the event.  One of these is created for every container.
 *  When the container invokes us with their DispID, we translate
 *  it into our own DispID here, and invoke ourselves with the correct
 *  DispID.
 */
class ESource : public  LLLContent, public IDispatchEx {

friend class OrxEvent;

public:
  //Constructor
  ESource();

  //Destructor
  ~ESource();


  /***** LLLContent Methods *****/
  void SetListState(LLLState Status) {LLLContent::SetListState(Status);}

  /***** IUnknown Methods *****/
  STDMETHODIMP QueryInterface(REFIID riid, void**ppvObj);
  STDMETHODIMP_(ULONG) AddRef();
  STDMETHODIMP_(ULONG) Release();


  /***** IDispatch Methods *****/
  // Always returns 0.
  STDMETHODIMP GetTypeInfoCount(
   /* [out] */ UINT *pTInfo);
  //  Not implemented.
  STDMETHODIMP GetTypeInfo(
   /* [in]  */ UINT pTInfo,
   /* [in]  */ LCID plcid,
   /* [out] */ ITypeInfo** pTypeInfo);
  STDMETHODIMP GetIDsOfNames(
   /* [in]  */ REFIID riid,
   /* [in]  */ OLECHAR** pNames,
   /* [in]  */ UINT pNamesCount,
   /* [in]  */ LCID plcid,
   /* [out] */ DISPID* pbDispID);
  STDMETHODIMP Invoke(
   /* [in]  */ DISPID pDispID,
   /* [in]  */ REFIID riid,
   /* [in]  */ LCID plcid,
   /* [in]  */ WORD pFlags,
   /* [in]  */ DISPPARAMS* pDispParams,
   /* [out] */ VARIANT* pVarResult,
   /* [out] */ EXCEPINFO* pExcepInfo,
   /* [out] */ UINT* pArgErr);



  /***** IDispatchEx Methods *****/
  /******************************************************************************
  *  GetDispID -- returns the DispID for a member, without having to construct
  *  an array first.  It also allows for the support of Dynamic Objects
  *  by adding them to our name space.
  *    GetDispID's support of 'Dynamic Objects', which we are not supporting
  *  right now, is triggerred by fdexNameEnsure.  If this flag is set,
  *  then the routine returns E_NOTIMPL.
  ******************************************************************************/
  virtual HRESULT STDMETHODCALLTYPE GetDispID(
    /* [in] */ BSTR pName,
    /* [in] */ DWORD pFlags,               // Derived from fdexName... defines.
    /* [out] */ DISPID __RPC_FAR *pbDispID);

  /******************************************************************************
  *  InvokeEx -- is for support of 'Dynamic Objects', which
  *  we are not supporting right now.  It always returns E_NOTIMPL.
  ******************************************************************************/
  virtual /* [local] */ HRESULT STDMETHODCALLTYPE InvokeEx(
    /* [in] */ DISPID pDispID,
    /* [in] */ LCID lcid,
    /* [in] */ WORD pFlags,                // Derived from the regular DISPATCH...
                                           // defines + DISPATCH_CONSTRUCT.
    /* [in] */ DISPPARAMS __RPC_FAR *pArgs,
    /* [out] */ VARIANT __RPC_FAR *pbResults,
    /* [out] */ EXCEPINFO __RPC_FAR *pbErrInfo,
    /* [unique][in] */ IServiceProvider __RPC_FAR *pCaller);

  /******************************************************************************
  *  DeleteMemberByName -- is for support of 'Dynamic Objects', which
  *  we are not supporting right now.  It always returns E_NOTIMPL.
  ******************************************************************************/
  virtual HRESULT STDMETHODCALLTYPE DeleteMemberByName(
    /* [in] */ BSTR pName,
    /* [in] */ DWORD pFlags);              // Derived from fdexName... defines.

  /******************************************************************************
  *  DeleteMemberByDispID -- is for support of 'Dynamic Objects', which
  *  we are not supporting right now.  It always returns E_NOTIMPL.
  ******************************************************************************/
  virtual HRESULT STDMETHODCALLTYPE DeleteMemberByDispID(
    /* [in] */ DISPID pDispID);

  virtual HRESULT STDMETHODCALLTYPE GetMemberProperties(
    /* [in] */ DISPID pDispID,
    /* [in] */ DWORD pFetchFlag,           // Derived from ???... defines.
    /* [out] */ DWORD __RPC_FAR *pbProperties); // Derived from fdexProp... defines.

  /******************************************************************************
  *  GetMemberName --  the error DISP_E_MEMBERNOTFOUND is returned,
  *   and pbName points to a ZLS (Zero Length String L"").
  ******************************************************************************/
  virtual HRESULT STDMETHODCALLTYPE GetMemberName(
    /* [in] */ DISPID pDispID,
    /* [out] */ BSTR __RPC_FAR *pbName);

  virtual HRESULT STDMETHODCALLTYPE GetNextDispID(
    /* [in] */ DWORD pFlags,               // Derived from fdexEnum... defines.
    /* [in] */ DISPID pDispID,             // Previous DispID returned.
    /* [out] */ DISPID __RPC_FAR *pbDispID);

  /******************************************************************************
  *  GetNameSpaceParent -- is for support of 'Dynamic Objects', which
  *  we are not supporting right now.  It always returns E_NOTIMPL.
  ******************************************************************************/
  virtual HRESULT STDMETHODCALLTYPE GetNameSpaceParent(
    /* [out] */ IUnknown __RPC_FAR *__RPC_FAR *pbIUnknown);




  /*  Methods in addition to the one necessary to implement COM.   */
  STDMETHODIMP AddMap(
   /* [in]  */ char *Name,
   /* [out] */ PEMAP *pbNewMap);

  STDMETHODIMP FindEvent(
   /* [in]  */ DISPID Source,
   /* [out] */ PEMAP *pbNewMap);

// This method is for the ParseProcedure Events
  STDMETHODIMP InitEvent(
   /* [in]  */ OLECHAR   *Name,
   /* [in]  */ LPCOLESTR  Code,
   /* [in]  */ DISPID     SinkDispID,
   /* [in]  */ OrxScript *ORexxScript,
   /* [in]  */ FILE      *LogFile);

//  These methods are to support the AddScriptlet Events
  STDMETHODIMP InitEvent(
   /* [in]  */ IDispatch *SourceDispatch,
   /* [in]  */ OrxScript *ORexxScript,
   /* [in]  */ FILE      *LogFile);

  STDMETHODIMP SetMap(
   /* [in]  */ LPCOLESTR pName,
   /* [in]  */ DISPID SinkDispID);

  STDMETHODIMP FindMap(
   /* [in]  */ LPCOLESTR Event,
   /* [out] */ DISPID *SinkDispID);



private:
  LinkedList EventFunctionMap;
  enum       EType{ParseProcedure,AddScriptlet};
  EType      EventType;
  int        ulRefCount;
  FILE      *logfile;
  OrxScript *Engine;

//  What follows is for ParseProcedure
  OLECHAR   *EventName;
  OLECHAR   *Code;
  int        CodeLen;
  DWORD      Flags;
  int        InvokeCount;


//  What follows is for Add Scriptlet
  IDispatch *Source;
  GUID       SourceGUID;
  IConnectionPointContainer *Container;
  IConnectionPoint *ConnectionPoint;
  DWORD      Cookie;
  BOOL       Connected;

  STDMETHODIMP GetTypeInfo(
   /* [out] */ ITypeInfo **pbTypeInfo);

  STDMETHODIMP CommonInvoke(
    /* [in] */ DISPID pDispID,
    /* [in] */ LCID lcid,
    /* [in] */ WORD pFlags,                // Derived from ... defines.
    /* [in] */ DISPPARAMS __RPC_FAR *pArgs,
    /* [out] */ VARIANT __RPC_FAR *pbResults,
    /* [out] */ EXCEPINFO __RPC_FAR *pbErrInfo);

  };


#endif    // ifndef ORXEVENTS_HPP
