// This file has been generated by Py++.

#include "boost/python.hpp"
#include "bindings/geometric.h"
#include "PRM.pypp.hpp"

namespace bp = boost::python;

struct PRM_wrapper : ompl::geometric::PRM, bp::wrapper< ompl::geometric::PRM > {

    PRM_wrapper(::ompl::base::SpaceInformationPtr const & si, bool starStrategy=false )
    : ompl::geometric::PRM( si, starStrategy )
      , bp::wrapper< ompl::geometric::PRM >(){
        // constructor
    
    }

    long unsigned int addMilestone( ::ompl::base::State * state ){
        return ompl::geometric::PRM::addMilestone( boost::python::ptr(state) );
    }

    bool addedNewSolution(  ) const {
        return ompl::geometric::PRM::addedNewSolution(  );
    }

    void checkForSolution( ::ompl::base::PlannerTerminationCondition const & ptc, ::ompl::base::PathPtr & solution ){
        ompl::geometric::PRM::checkForSolution( boost::ref(ptc), solution );
    }

    virtual void clear(  ) {
        if( bp::override func_clear = this->get_override( "clear" ) )
            func_clear(  );
        else{
            this->ompl::geometric::PRM::clear(  );
        }
    }
    
    void default_clear(  ) {
        ompl::geometric::PRM::clear( );
    }

    ::ompl::base::PathPtr constructSolution( long unsigned int const & start, long unsigned int const & goal ){
        return ompl::geometric::PRM::constructSolution( start, goal );
    }

    ::ompl::base::Cost costHeuristic( long unsigned int u, long unsigned int v ) const {
        return ompl::geometric::PRM::costHeuristic( u, v );
    }

    double distanceFunction( long unsigned int const a, long unsigned int const b ) const {
        return ompl::geometric::PRM::distanceFunction( a, b );
    }

    void freeMemory(  ){
        ompl::geometric::PRM::freeMemory(  );
    }

    ::std::string getBestCost(  ) const {
        return ompl::geometric::PRM::getBestCost(  );
    }

    ::std::string getEdgeCountString(  ) const {
        return ompl::geometric::PRM::getEdgeCountString(  );
    }

    ::std::string getIterationCount(  ) const {
        return ompl::geometric::PRM::getIterationCount(  );
    }

    ::std::string getMilestoneCountString(  ) const {
        return ompl::geometric::PRM::getMilestoneCountString(  );
    }

    virtual void getPlannerData( ::ompl::base::PlannerData & data ) const  {
        if( bp::override func_getPlannerData = this->get_override( "getPlannerData" ) )
            func_getPlannerData( boost::ref(data) );
        else{
            this->ompl::geometric::PRM::getPlannerData( boost::ref(data) );
        }
    }
    
    void default_getPlannerData( ::ompl::base::PlannerData & data ) const  {
        ompl::geometric::PRM::getPlannerData( boost::ref(data) );
    }

    bool sameComponent( long unsigned int m1, long unsigned int m2 ){
        return ompl::geometric::PRM::sameComponent( m1, m2 );
    }

    virtual void setProblemDefinition( ::ompl::base::ProblemDefinitionPtr const & pdef ) {
        if( bp::override func_setProblemDefinition = this->get_override( "setProblemDefinition" ) )
            func_setProblemDefinition( pdef );
        else{
            this->ompl::geometric::PRM::setProblemDefinition( pdef );
        }
    }
    
    void default_setProblemDefinition( ::ompl::base::ProblemDefinitionPtr const & pdef ) {
        ompl::geometric::PRM::setProblemDefinition( pdef );
    }

    virtual void setup(  ) {
        if( bp::override func_setup = this->get_override( "setup" ) )
            func_setup(  );
        else{
            this->ompl::geometric::PRM::setup(  );
        }
    }
    
    void default_setup(  ) {
        ompl::geometric::PRM::setup( );
    }

    void uniteComponents( long unsigned int m1, long unsigned int m2 ){
        ompl::geometric::PRM::uniteComponents( m1, m2 );
    }

    virtual void checkValidity(  ) {
        if( bp::override func_checkValidity = this->get_override( "checkValidity" ) )
            func_checkValidity(  );
        else{
            this->ompl::base::Planner::checkValidity(  );
        }
    }
    
    void default_checkValidity(  ) {
        ompl::base::Planner::checkValidity( );
    }

    virtual ::ompl::base::PlannerStatus solve( ::ompl::base::PlannerTerminationCondition const & ptc ) {
                    if( bp::override func_solve = this->get_override( "solve" ) )
                        return func_solve( boost::ref(ptc) );
                    else{
                        return default_solve( boost::ref(ptc) );
                    }
                }
    
                ::ompl::base::PlannerStatus default_solve( ::ompl::base::PlannerTerminationCondition const & ptc );

};

/*********************************************************************
* Software License Agreement (BSD License)
*
*  Copyright (c) 2011, Rice University
*  All rights reserved.
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*   * Redistributions of source code must retain the above copyright
*     notice, this list of conditions and the following disclaimer.
*   * Redistributions in binary form must reproduce the above
*     copyright notice, this list of conditions and the following
*     disclaimer in the documentation and/or other materials provided
*     with the distribution.
*   * Neither the name of the Rice University nor the names of its
*     contributors may be used to endorse or promote products derived
*     from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
*  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
*  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
*  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
*  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
*  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
*  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
*  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
*  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
*  POSSIBILITY OF SUCH DAMAGE.
*********************************************************************/

/* Author: Ioan Sucan, James D. Marble */

ompl::base::PlannerStatus PRM_wrapper::default_solve(const ompl::base::PlannerTerminationCondition& ptc)
{
    using namespace ompl;

    checkValidity();

    static const unsigned int MAX_RANDOM_BOUNCE_STEPS   = 5;
    base::GoalSampleableRegion *goal = dynamic_cast<base::GoalSampleableRegion*>(pdef_->getGoal().get());

    if (!goal)
    {
        OMPL_ERROR("Goal undefined or unknown type of goal");
        return base::PlannerStatus::UNRECOGNIZED_GOAL_TYPE;
    }

    // Add the valid start states as milestones
    while (const base::State *st = pis_.nextStart())
        startM_.push_back(addMilestone(si_->cloneState(st)));

    if (startM_.size() == 0)
    {
        OMPL_ERROR("There are no valid initial states!");
        return base::PlannerStatus::INVALID_START;
    }

    if (!goal->couldSample())
    {
        OMPL_ERROR("Insufficient states in sampleable goal region");
        return base::PlannerStatus::INVALID_GOAL;
    }

    // Ensure there is at least one valid goal state
    if (goal->maxSampleCount() > goalM_.size() || goalM_.empty())
    {
        const base::State *st = goalM_.empty() ? pis_.nextGoal(ptc) : pis_.nextGoal();
        if (st)
            goalM_.push_back(addMilestone(si_->cloneState(st)));

        if (goalM_.empty())
        {
            OMPL_ERROR("Unable to find any valid goal states");
            return base::PlannerStatus::INVALID_GOAL;
        }
    }

    if (!sampler_)
        sampler_ = si_->allocValidStateSampler();
    if (!simpleSampler_)
        simpleSampler_ = si_->allocStateSampler();

    unsigned int nrStartStates = boost::num_vertices(g_);
    OMPL_INFORM("Starting with %u states", nrStartStates);

    std::vector<base::State*> xstates(MAX_RANDOM_BOUNCE_STEPS);
    si_->allocStates(xstates);
    bool grow = true;

    // Reset addedNewSolution_ member
    addedNewSolution_ = false;
    base::PathPtr sln;
    sln.reset();

    double roadmap_build_time = 0.05;
    while (ptc == false && !addedNewSolution_)
    {
        // Check for any new goal states
        if (goal->maxSampleCount() > goalM_.size())
        {
            const base::State *st = pis_.nextGoal();
            if (st)
                goalM_.push_back(addMilestone(si_->cloneState(st)));
        }

        // maintain a 2:1 ratio for growing/expansion of roadmap
        // call growRoadmap() twice as long for every call of expandRoadmap()
        if (grow)
            ompl::geometric::PRM::growRoadmap(base::plannerOrTerminationCondition(ptc, base::timedPlannerTerminationCondition(2.0*roadmap_build_time)), xstates[0]);
        else
            ompl::geometric::PRM::expandRoadmap(base::plannerOrTerminationCondition(ptc, base::timedPlannerTerminationCondition(roadmap_build_time)), xstates);
        grow = !grow;

        // Check for a solution
        addedNewSolution_ = maybeConstructSolution (startM_, goalM_, sln);
    }

    OMPL_INFORM("Created %u states", boost::num_vertices(g_) - nrStartStates);

    if (sln)
    {
        if(addedNewSolution_)
            pdef_->addSolutionPath (sln);
        else
            // the solution is exact, but not as short as we'd like it to be
            pdef_->addSolutionPath (sln, true, 0.0);
    }

    si_->freeStates(xstates);

    // Return true if any solution was found.
    return sln ? (addedNewSolution_ ? base::PlannerStatus::EXACT_SOLUTION : base::PlannerStatus::APPROXIMATE_SOLUTION) : base::PlannerStatus::TIMEOUT;
}

void register_PRM_class(){

    { //::ompl::geometric::PRM
        typedef bp::class_< PRM_wrapper, bp::bases< ::ompl::base::Planner >, boost::noncopyable > PRM_exposer_t;
        PRM_exposer_t PRM_exposer = PRM_exposer_t( "PRM", bp::init< ompl::base::SpaceInformationPtr const &, bp::optional< bool > >(( bp::arg("si"), bp::arg("starStrategy")=(bool)(false) )) );
        bp::scope PRM_scope( PRM_exposer );
        { //::ompl::geometric::PRM::vertex_state_t
            typedef bp::class_< ompl::geometric::PRM::vertex_state_t > vertex_state_t_exposer_t;
            vertex_state_t_exposer_t vertex_state_t_exposer = vertex_state_t_exposer_t( "vertex_state_t" );
            bp::scope vertex_state_t_scope( vertex_state_t_exposer );
        }
        { //::ompl::geometric::PRM::vertex_successful_connection_attempts_t
            typedef bp::class_< ompl::geometric::PRM::vertex_successful_connection_attempts_t > vertex_successful_connection_attempts_t_exposer_t;
            vertex_successful_connection_attempts_t_exposer_t vertex_successful_connection_attempts_t_exposer = vertex_successful_connection_attempts_t_exposer_t( "vertex_successful_connection_attempts_t" );
            bp::scope vertex_successful_connection_attempts_t_scope( vertex_successful_connection_attempts_t_exposer );
        }
        { //::ompl::geometric::PRM::vertex_total_connection_attempts_t
            typedef bp::class_< ompl::geometric::PRM::vertex_total_connection_attempts_t > vertex_total_connection_attempts_t_exposer_t;
            vertex_total_connection_attempts_t_exposer_t vertex_total_connection_attempts_t_exposer = vertex_total_connection_attempts_t_exposer_t( "vertex_total_connection_attempts_t" );
            bp::scope vertex_total_connection_attempts_t_scope( vertex_total_connection_attempts_t_exposer );
        }
        bp::implicitly_convertible< ompl::base::SpaceInformationPtr const &, ompl::geometric::PRM >();
        { //::ompl::geometric::PRM::addMilestone
        
            typedef long unsigned int ( PRM_wrapper::*addMilestone_function_type )( ::ompl::base::State * ) ;
            
            PRM_exposer.def( 
                "addMilestone"
                , addMilestone_function_type( &PRM_wrapper::addMilestone )
                , ( bp::arg("state") ) );
        
        }
        { //::ompl::geometric::PRM::addedNewSolution
        
            typedef bool ( PRM_wrapper::*addedNewSolution_function_type )(  ) const;
            
            PRM_exposer.def( 
                "addedNewSolution"
                , addedNewSolution_function_type( &PRM_wrapper::addedNewSolution ) );
        
        }
        { //::ompl::geometric::PRM::checkForSolution
        
            typedef void ( PRM_wrapper::*checkForSolution_function_type )( ::ompl::base::PlannerTerminationCondition const &,::ompl::base::PathPtr & ) ;
            
            PRM_exposer.def( 
                "checkForSolution"
                , checkForSolution_function_type( &PRM_wrapper::checkForSolution )
                , ( bp::arg("ptc"), bp::arg("solution") ) );
        
        }
        { //::ompl::geometric::PRM::clear
        
            typedef void ( ::ompl::geometric::PRM::*clear_function_type )(  ) ;
            typedef void ( PRM_wrapper::*default_clear_function_type )(  ) ;
            
            PRM_exposer.def( 
                "clear"
                , clear_function_type(&::ompl::geometric::PRM::clear)
                , default_clear_function_type(&PRM_wrapper::default_clear) );
        
        }
        { //::ompl::geometric::PRM::clearQuery
        
            typedef void ( ::ompl::geometric::PRM::*clearQuery_function_type )(  ) ;
            
            PRM_exposer.def( 
                "clearQuery"
                , clearQuery_function_type( &::ompl::geometric::PRM::clearQuery ) );
        
        }
        { //::ompl::geometric::PRM::constructRoadmap
        
            typedef void ( ::ompl::geometric::PRM::*constructRoadmap_function_type )( ::ompl::base::PlannerTerminationCondition const & ) ;
            
            PRM_exposer.def( 
                "constructRoadmap"
                , constructRoadmap_function_type( &::ompl::geometric::PRM::constructRoadmap )
                , ( bp::arg("ptc") ) );
        
        }
        { //::ompl::geometric::PRM::constructSolution
        
            typedef ::ompl::base::PathPtr ( PRM_wrapper::*constructSolution_function_type )( long unsigned int const &,long unsigned int const & ) ;
            
            PRM_exposer.def( 
                "constructSolution"
                , constructSolution_function_type( &PRM_wrapper::constructSolution )
                , ( bp::arg("start"), bp::arg("goal") ) );
        
        }
        { //::ompl::geometric::PRM::costHeuristic
        
            typedef ::ompl::base::Cost ( PRM_wrapper::*costHeuristic_function_type )( long unsigned int,long unsigned int ) const;
            
            PRM_exposer.def( 
                "costHeuristic"
                , costHeuristic_function_type( &PRM_wrapper::costHeuristic )
                , ( bp::arg("u"), bp::arg("v") ) );
        
        }
        { //::ompl::geometric::PRM::distanceFunction
        
            typedef double ( PRM_wrapper::*distanceFunction_function_type )( long unsigned int const,long unsigned int const ) const;
            
            PRM_exposer.def( 
                "distanceFunction"
                , distanceFunction_function_type( &PRM_wrapper::distanceFunction )
                , ( bp::arg("a"), bp::arg("b") ) );
        
        }
        { //::ompl::geometric::PRM::edgeCount
        
            typedef long unsigned int ( ::ompl::geometric::PRM::*edgeCount_function_type )(  ) const;
            
            PRM_exposer.def( 
                "edgeCount"
                , edgeCount_function_type( &::ompl::geometric::PRM::edgeCount ) );
        
        }
        { //::ompl::geometric::PRM::expandRoadmap
        
            typedef void ( ::ompl::geometric::PRM::*expandRoadmap_function_type )( double ) ;
            
            PRM_exposer.def( 
                "expandRoadmap"
                , expandRoadmap_function_type( &::ompl::geometric::PRM::expandRoadmap )
                , ( bp::arg("expandTime") ) );
        
        }
        { //::ompl::geometric::PRM::expandRoadmap
        
            typedef void ( ::ompl::geometric::PRM::*expandRoadmap_function_type )( ::ompl::base::PlannerTerminationCondition const & ) ;
            
            PRM_exposer.def( 
                "expandRoadmap"
                , expandRoadmap_function_type( &::ompl::geometric::PRM::expandRoadmap )
                , ( bp::arg("ptc") ) );
        
        }
        { //::ompl::geometric::PRM::freeMemory
        
            typedef void ( PRM_wrapper::*freeMemory_function_type )(  ) ;
            
            PRM_exposer.def( 
                "freeMemory"
                , freeMemory_function_type( &PRM_wrapper::freeMemory ) );
        
        }
        { //::ompl::geometric::PRM::getBestCost
        
            typedef ::std::string ( PRM_wrapper::*getBestCost_function_type )(  ) const;
            
            PRM_exposer.def( 
                "getBestCost"
                , getBestCost_function_type( &PRM_wrapper::getBestCost ) );
        
        }
        { //::ompl::geometric::PRM::getEdgeCountString
        
            typedef ::std::string ( PRM_wrapper::*getEdgeCountString_function_type )(  ) const;
            
            PRM_exposer.def( 
                "getEdgeCountString"
                , getEdgeCountString_function_type( &PRM_wrapper::getEdgeCountString ) );
        
        }
        { //::ompl::geometric::PRM::getIterationCount
        
            typedef ::std::string ( PRM_wrapper::*getIterationCount_function_type )(  ) const;
            
            PRM_exposer.def( 
                "getIterationCount"
                , getIterationCount_function_type( &PRM_wrapper::getIterationCount ) );
        
        }
        { //::ompl::geometric::PRM::getMilestoneCountString
        
            typedef ::std::string ( PRM_wrapper::*getMilestoneCountString_function_type )(  ) const;
            
            PRM_exposer.def( 
                "getMilestoneCountString"
                , getMilestoneCountString_function_type( &PRM_wrapper::getMilestoneCountString ) );
        
        }
        { //::ompl::geometric::PRM::getNearestNeighbors
        
            typedef ::boost::shared_ptr< ompl::NearestNeighbors< unsigned long > > const & ( ::ompl::geometric::PRM::*getNearestNeighbors_function_type )(  ) ;
            
            PRM_exposer.def( 
                "getNearestNeighbors"
                , getNearestNeighbors_function_type( &::ompl::geometric::PRM::getNearestNeighbors )
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::ompl::geometric::PRM::getPlannerData
        
            typedef void ( ::ompl::geometric::PRM::*getPlannerData_function_type )( ::ompl::base::PlannerData & ) const;
            typedef void ( PRM_wrapper::*default_getPlannerData_function_type )( ::ompl::base::PlannerData & ) const;
            
            PRM_exposer.def( 
                "getPlannerData"
                , getPlannerData_function_type(&::ompl::geometric::PRM::getPlannerData)
                , default_getPlannerData_function_type(&PRM_wrapper::default_getPlannerData)
                , ( bp::arg("data") ) );
        
        }
        { //::ompl::geometric::PRM::getRoadmap
        
            typedef ::boost::adjacency_list< boost::vecS, boost::vecS, boost::undirectedS, boost::property< ompl::geometric::PRM::vertex_state_t, ompl::base::State*, boost::property< ompl::geometric::PRM::vertex_total_connection_attempts_t, unsigned long, boost::property< ompl::geometric::PRM::vertex_successful_connection_attempts_t, unsigned long, boost::property< boost::vertex_predecessor_t, unsigned long, boost::property< boost::vertex_rank_t, unsigned long, boost::no_property > > > > >, boost::property< boost::edge_weight_t, ompl::base::Cost, boost::no_property >, boost::no_property, boost::listS > const & ( ::ompl::geometric::PRM::*getRoadmap_function_type )(  ) const;
            
            PRM_exposer.def( 
                "getRoadmap"
                , getRoadmap_function_type( &::ompl::geometric::PRM::getRoadmap )
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::ompl::geometric::PRM::growRoadmap
        
            typedef void ( ::ompl::geometric::PRM::*growRoadmap_function_type )( double ) ;
            
            PRM_exposer.def( 
                "growRoadmap"
                , growRoadmap_function_type( &::ompl::geometric::PRM::growRoadmap )
                , ( bp::arg("growTime") ) );
        
        }
        { //::ompl::geometric::PRM::growRoadmap
        
            typedef void ( ::ompl::geometric::PRM::*growRoadmap_function_type )( ::ompl::base::PlannerTerminationCondition const & ) ;
            
            PRM_exposer.def( 
                "growRoadmap"
                , growRoadmap_function_type( &::ompl::geometric::PRM::growRoadmap )
                , ( bp::arg("ptc") ) );
        
        }
        { //::ompl::geometric::PRM::milestoneCount
        
            typedef long unsigned int ( ::ompl::geometric::PRM::*milestoneCount_function_type )(  ) const;
            
            PRM_exposer.def( 
                "milestoneCount"
                , milestoneCount_function_type( &::ompl::geometric::PRM::milestoneCount ) );
        
        }
        { //::ompl::geometric::PRM::sameComponent
        
            typedef bool ( PRM_wrapper::*sameComponent_function_type )( long unsigned int,long unsigned int ) ;
            
            PRM_exposer.def( 
                "sameComponent"
                , sameComponent_function_type( &PRM_wrapper::sameComponent )
                , ( bp::arg("m1"), bp::arg("m2") ) );
        
        }
        { //::ompl::geometric::PRM::setConnectionFilter
        
            typedef void ( ::ompl::geometric::PRM::*setConnectionFilter_function_type )( ::boost::function< bool (unsigned long const&, unsigned long const&) > const & ) ;
            
            PRM_exposer.def( 
                "setConnectionFilter"
                , setConnectionFilter_function_type( &::ompl::geometric::PRM::setConnectionFilter )
                , ( bp::arg("connectionFilter") ) );
        
        }
        { //::ompl::geometric::PRM::setConnectionStrategy
        
            typedef void ( ::ompl::geometric::PRM::*setConnectionStrategy_function_type )( ::boost::function< std::vector<unsigned long, std::allocator<unsigned long> > const& (unsigned long) > const & ) ;
            
            PRM_exposer.def( 
                "setConnectionStrategy"
                , setConnectionStrategy_function_type( &::ompl::geometric::PRM::setConnectionStrategy )
                , ( bp::arg("connectionStrategy") ) );
        
        }
        { //::ompl::geometric::PRM::setMaxNearestNeighbors
        
            typedef void ( ::ompl::geometric::PRM::*setMaxNearestNeighbors_function_type )( unsigned int ) ;
            
            PRM_exposer.def( 
                "setMaxNearestNeighbors"
                , setMaxNearestNeighbors_function_type( &::ompl::geometric::PRM::setMaxNearestNeighbors )
                , ( bp::arg("k") ) );
        
        }
        { //::ompl::geometric::PRM::setProblemDefinition
        
            typedef void ( ::ompl::geometric::PRM::*setProblemDefinition_function_type )( ::ompl::base::ProblemDefinitionPtr const & ) ;
            typedef void ( PRM_wrapper::*default_setProblemDefinition_function_type )( ::ompl::base::ProblemDefinitionPtr const & ) ;
            
            PRM_exposer.def( 
                "setProblemDefinition"
                , setProblemDefinition_function_type(&::ompl::geometric::PRM::setProblemDefinition)
                , default_setProblemDefinition_function_type(&PRM_wrapper::default_setProblemDefinition)
                , ( bp::arg("pdef") ) );
        
        }
        { //::ompl::geometric::PRM::setup
        
            typedef void ( ::ompl::geometric::PRM::*setup_function_type )(  ) ;
            typedef void ( PRM_wrapper::*default_setup_function_type )(  ) ;
            
            PRM_exposer.def( 
                "setup"
                , setup_function_type(&::ompl::geometric::PRM::setup)
                , default_setup_function_type(&PRM_wrapper::default_setup) );
        
        }
        { //::ompl::geometric::PRM::uniteComponents
        
            typedef void ( PRM_wrapper::*uniteComponents_function_type )( long unsigned int,long unsigned int ) ;
            
            PRM_exposer.def( 
                "uniteComponents"
                , uniteComponents_function_type( &PRM_wrapper::uniteComponents )
                , ( bp::arg("m1"), bp::arg("m2") ) );
        
        }
        PRM_exposer.def("solve",
                    (::ompl::base::PlannerStatus(::ompl::geometric::PRM::*)( ::ompl::base::PlannerTerminationCondition const &))(&PRM_wrapper::solve),
                    (::ompl::base::PlannerStatus(PRM_wrapper::*)( ::ompl::base::PlannerTerminationCondition const & ))(&PRM_wrapper::default_solve), bp::arg("ptc") );
        PRM_exposer.def("solve", (::ompl::base::PlannerStatus(::ompl::base::Planner::*)( double ))(&::ompl::base::Planner::solve), (bp::arg("solveTime")) );
        PRM_exposer.def("checkValidity",&::ompl::base::Planner::checkValidity,
                        &PRM_wrapper::default_checkValidity );
    }

}
