// This file has been generated by Py++.

#include "boost/python.hpp"
#include "bindings/base.h"
#include "StateSpace.pypp.hpp"

namespace bp = boost::python;

struct StateSpace_wrapper : ompl::base::StateSpace, bp::wrapper< ompl::base::StateSpace > {

    StateSpace_wrapper( )
    : ompl::base::StateSpace( )
      , bp::wrapper< ompl::base::StateSpace >(){
        // null constructor
    
    }

    virtual ::ompl::base::StateSamplerPtr allocDefaultStateSampler(  ) const {
        bp::override func_allocDefaultStateSampler = this->get_override( "allocDefaultStateSampler" );
        return func_allocDefaultStateSampler(  );
    }

    virtual ::ompl::base::State * allocState(  ) const {
        bp::override func_allocState = this->get_override( "allocState" );
        return func_allocState(  );
    }

    virtual ::ompl::base::StateSamplerPtr allocStateSampler(  ) const  {
        if( bp::override func_allocStateSampler = this->get_override( "allocStateSampler" ) )
            return func_allocStateSampler(  );
        else{
            return this->ompl::base::StateSpace::allocStateSampler(  );
        }
    }
    
    ::ompl::base::StateSamplerPtr default_allocStateSampler(  ) const  {
        return ompl::base::StateSpace::allocStateSampler( );
    }

    virtual ::ompl::base::StateSamplerPtr allocSubspaceStateSampler( ::ompl::base::StateSpace const * subspace ) const  {
        if( bp::override func_allocSubspaceStateSampler = this->get_override( "allocSubspaceStateSampler" ) )
            return func_allocSubspaceStateSampler( boost::python::ptr(subspace) );
        else{
            return this->ompl::base::StateSpace::allocSubspaceStateSampler( boost::python::ptr(subspace) );
        }
    }
    
    ::ompl::base::StateSamplerPtr default_allocSubspaceStateSampler( ::ompl::base::StateSpace const * subspace ) const  {
        return ompl::base::StateSpace::allocSubspaceStateSampler( boost::python::ptr(subspace) );
    }

    virtual void computeLocations(  ) {
        if( bp::override func_computeLocations = this->get_override( "computeLocations" ) )
            func_computeLocations(  );
        else{
            this->ompl::base::StateSpace::computeLocations(  );
        }
    }
    
    void default_computeLocations(  ) {
        ompl::base::StateSpace::computeLocations( );
    }

    virtual void copyState( ::ompl::base::State * destination, ::ompl::base::State const * source ) const {
        bp::override func_copyState = this->get_override( "copyState" );
        func_copyState( boost::python::ptr(destination), boost::python::ptr(source) );
    }

    virtual void deserialize( ::ompl::base::State * state, void const * serialization ) const  {
        if( bp::override func_deserialize = this->get_override( "deserialize" ) )
            func_deserialize( boost::python::ptr(state), serialization );
        else{
            this->ompl::base::StateSpace::deserialize( boost::python::ptr(state), serialization );
        }
    }
    
    void default_deserialize( ::ompl::base::State * state, void const * serialization ) const  {
        ompl::base::StateSpace::deserialize( boost::python::ptr(state), serialization );
    }

    virtual double distance( ::ompl::base::State const * state1, ::ompl::base::State const * state2 ) const {
        bp::override func_distance = this->get_override( "distance" );
        return func_distance( boost::python::ptr(state1), boost::python::ptr(state2) );
    }

    virtual void enforceBounds( ::ompl::base::State * state ) const {
        bp::override func_enforceBounds = this->get_override( "enforceBounds" );
        func_enforceBounds( boost::python::ptr(state) );
    }

    virtual bool equalStates( ::ompl::base::State const * state1, ::ompl::base::State const * state2 ) const {
        bp::override func_equalStates = this->get_override( "equalStates" );
        return func_equalStates( boost::python::ptr(state1), boost::python::ptr(state2) );
    }

    virtual void freeState( ::ompl::base::State * state ) const {
        bp::override func_freeState = this->get_override( "freeState" );
        func_freeState( boost::python::ptr(state) );
    }

    virtual unsigned int getDimension(  ) const {
        bp::override func_getDimension = this->get_override( "getDimension" );
        return func_getDimension(  );
    }

    virtual double getLongestValidSegmentFraction(  ) const  {
        if( bp::override func_getLongestValidSegmentFraction = this->get_override( "getLongestValidSegmentFraction" ) )
            return func_getLongestValidSegmentFraction(  );
        else{
            return this->ompl::base::StateSpace::getLongestValidSegmentFraction(  );
        }
    }
    
    double default_getLongestValidSegmentFraction(  ) const  {
        return ompl::base::StateSpace::getLongestValidSegmentFraction( );
    }

    virtual double getMaximumExtent(  ) const {
        bp::override func_getMaximumExtent = this->get_override( "getMaximumExtent" );
        return func_getMaximumExtent(  );
    }

    virtual double getMeasure(  ) const {
        bp::override func_getMeasure = this->get_override( "getMeasure" );
        return func_getMeasure(  );
    }

    virtual unsigned int getSerializationLength(  ) const  {
        if( bp::override func_getSerializationLength = this->get_override( "getSerializationLength" ) )
            return func_getSerializationLength(  );
        else{
            return this->ompl::base::StateSpace::getSerializationLength(  );
        }
    }
    
    unsigned int default_getSerializationLength(  ) const  {
        return ompl::base::StateSpace::getSerializationLength( );
    }

    virtual bool hasSymmetricDistance(  ) const  {
        if( bp::override func_hasSymmetricDistance = this->get_override( "hasSymmetricDistance" ) )
            return func_hasSymmetricDistance(  );
        else{
            return this->ompl::base::StateSpace::hasSymmetricDistance(  );
        }
    }
    
    bool default_hasSymmetricDistance(  ) const  {
        return ompl::base::StateSpace::hasSymmetricDistance( );
    }

    virtual bool hasSymmetricInterpolate(  ) const  {
        if( bp::override func_hasSymmetricInterpolate = this->get_override( "hasSymmetricInterpolate" ) )
            return func_hasSymmetricInterpolate(  );
        else{
            return this->ompl::base::StateSpace::hasSymmetricInterpolate(  );
        }
    }
    
    bool default_hasSymmetricInterpolate(  ) const  {
        return ompl::base::StateSpace::hasSymmetricInterpolate( );
    }

    virtual void interpolate( ::ompl::base::State const * from, ::ompl::base::State const * to, double const t, ::ompl::base::State * state ) const {
        bp::override func_interpolate = this->get_override( "interpolate" );
        func_interpolate( boost::python::ptr(from), boost::python::ptr(to), t, boost::python::ptr(state) );
    }

    virtual bool isCompound(  ) const  {
        if( bp::override func_isCompound = this->get_override( "isCompound" ) )
            return func_isCompound(  );
        else{
            return this->ompl::base::StateSpace::isCompound(  );
        }
    }
    
    bool default_isCompound(  ) const  {
        return ompl::base::StateSpace::isCompound( );
    }

    virtual bool isDiscrete(  ) const  {
        if( bp::override func_isDiscrete = this->get_override( "isDiscrete" ) )
            return func_isDiscrete(  );
        else{
            return this->ompl::base::StateSpace::isDiscrete(  );
        }
    }
    
    bool default_isDiscrete(  ) const  {
        return ompl::base::StateSpace::isDiscrete( );
    }

    virtual bool isHybrid(  ) const  {
        if( bp::override func_isHybrid = this->get_override( "isHybrid" ) )
            return func_isHybrid(  );
        else{
            return this->ompl::base::StateSpace::isHybrid(  );
        }
    }
    
    bool default_isHybrid(  ) const  {
        return ompl::base::StateSpace::isHybrid( );
    }

    virtual bool isMetricSpace(  ) const  {
        if( bp::override func_isMetricSpace = this->get_override( "isMetricSpace" ) )
            return func_isMetricSpace(  );
        else{
            return this->ompl::base::StateSpace::isMetricSpace(  );
        }
    }
    
    bool default_isMetricSpace(  ) const  {
        return ompl::base::StateSpace::isMetricSpace( );
    }

    virtual void registerProjections(  ) {
        if( bp::override func_registerProjections = this->get_override( "registerProjections" ) )
            func_registerProjections(  );
        else{
            this->ompl::base::StateSpace::registerProjections(  );
        }
    }
    
    void default_registerProjections(  ) {
        ompl::base::StateSpace::registerProjections( );
    }

    virtual void sanityChecks( double zero, double eps, unsigned int flags ) const  {
        if( bp::override func_sanityChecks = this->get_override( "sanityChecks" ) )
            func_sanityChecks( zero, eps, flags );
        else{
            this->ompl::base::StateSpace::sanityChecks( zero, eps, flags );
        }
    }
    
    void default_sanityChecks( double zero, double eps, unsigned int flags ) const  {
        ompl::base::StateSpace::sanityChecks( zero, eps, flags );
    }

    virtual void sanityChecks(  ) const  {
        if( bp::override func_sanityChecks = this->get_override( "sanityChecks" ) )
            func_sanityChecks(  );
        else{
            this->ompl::base::StateSpace::sanityChecks(  );
        }
    }
    
    void default_sanityChecks(  ) const  {
        ompl::base::StateSpace::sanityChecks( );
    }

    virtual bool satisfiesBounds( ::ompl::base::State const * state ) const {
        bp::override func_satisfiesBounds = this->get_override( "satisfiesBounds" );
        return func_satisfiesBounds( boost::python::ptr(state) );
    }

    virtual void serialize( void * serialization, ::ompl::base::State const * state ) const  {
        if( bp::override func_serialize = this->get_override( "serialize" ) )
            func_serialize( serialization, boost::python::ptr(state) );
        else{
            this->ompl::base::StateSpace::serialize( serialization, boost::python::ptr(state) );
        }
    }
    
    void default_serialize( void * serialization, ::ompl::base::State const * state ) const  {
        ompl::base::StateSpace::serialize( serialization, boost::python::ptr(state) );
    }

    virtual void setLongestValidSegmentFraction( double segmentFraction ) {
        if( bp::override func_setLongestValidSegmentFraction = this->get_override( "setLongestValidSegmentFraction" ) )
            func_setLongestValidSegmentFraction( segmentFraction );
        else{
            this->ompl::base::StateSpace::setLongestValidSegmentFraction( segmentFraction );
        }
    }
    
    void default_setLongestValidSegmentFraction( double segmentFraction ) {
        ompl::base::StateSpace::setLongestValidSegmentFraction( segmentFraction );
    }

    virtual void setup(  ) {
        if( bp::override func_setup = this->get_override( "setup" ) )
            func_setup(  );
        else{
            this->ompl::base::StateSpace::setup(  );
        }
    }
    
    void default_setup(  ) {
        ompl::base::StateSpace::setup( );
    }

    virtual unsigned int validSegmentCount( ::ompl::base::State const * state1, ::ompl::base::State const * state2 ) const  {
        if( bp::override func_validSegmentCount = this->get_override( "validSegmentCount" ) )
            return func_validSegmentCount( boost::python::ptr(state1), boost::python::ptr(state2) );
        else{
            return this->ompl::base::StateSpace::validSegmentCount( boost::python::ptr(state1), boost::python::ptr(state2) );
        }
    }
    
    unsigned int default_validSegmentCount( ::ompl::base::State const * state1, ::ompl::base::State const * state2 ) const  {
        return ompl::base::StateSpace::validSegmentCount( boost::python::ptr(state1), boost::python::ptr(state2) );
    }

};

std::string __printSettings(::ompl::base::StateSpace* obj)
{
    std::ostringstream s;
    obj->printSettings(s);
    return s.str();
}

std::string __printState(::ompl::base::StateSpace* space, ompl::base::State* state)
        {
            std::ostringstream s;
            space->printState(state, s);
            return s.str();
        }

std::string __printProjections(::ompl::base::StateSpace* obj)
        {
            std::ostringstream s;
            obj->printProjections(s);
            return s.str();
        }

std::string DiagramWrapper(::ompl::base::StateSpace* obj)
        {
            std::ostringstream s;
            obj->Diagram(s);
            return s.str();
        }

std::string ListWrapper(::ompl::base::StateSpace* obj)
        {
            std::ostringstream s;
            obj->List(s);
            return s.str();
        }

void register_StateSpace_class(){

    { //::ompl::base::StateSpace
        typedef bp::class_< StateSpace_wrapper, boost::noncopyable > StateSpace_exposer_t;
        StateSpace_exposer_t StateSpace_exposer = StateSpace_exposer_t( "StateSpace", bp::init< >() );
        bp::scope StateSpace_scope( StateSpace_exposer );
        bp::enum_< ompl::base::StateSpace::SanityChecks>("SanityChecks")
            .value("STATESPACE_DISTANCE_DIFFERENT_STATES", ompl::base::StateSpace::STATESPACE_DISTANCE_DIFFERENT_STATES)
            .value("STATESPACE_DISTANCE_SYMMETRIC", ompl::base::StateSpace::STATESPACE_DISTANCE_SYMMETRIC)
            .value("STATESPACE_INTERPOLATION", ompl::base::StateSpace::STATESPACE_INTERPOLATION)
            .value("STATESPACE_TRIANGLE_INEQUALITY", ompl::base::StateSpace::STATESPACE_TRIANGLE_INEQUALITY)
            .value("STATESPACE_DISTANCE_BOUND", ompl::base::StateSpace::STATESPACE_DISTANCE_BOUND)
            .value("STATESPACE_RESPECT_BOUNDS", ompl::base::StateSpace::STATESPACE_RESPECT_BOUNDS)
            .value("STATESPACE_ENFORCE_BOUNDS_NO_OP", ompl::base::StateSpace::STATESPACE_ENFORCE_BOUNDS_NO_OP)
            .value("STATESPACE_SERIALIZATION", ompl::base::StateSpace::STATESPACE_SERIALIZATION)
            .export_values()
            ;
        { //::ompl::base::StateSpace::SubstateLocation
            typedef bp::class_< ompl::base::StateSpace::SubstateLocation > SubstateLocation_exposer_t;
            SubstateLocation_exposer_t SubstateLocation_exposer = SubstateLocation_exposer_t( "SubstateLocation" );
            bp::scope SubstateLocation_scope( SubstateLocation_exposer );
            SubstateLocation_exposer.def_readwrite( "chain", &ompl::base::StateSpace::SubstateLocation::chain );
        }
        { //::ompl::base::StateSpace::ValueLocation
            typedef bp::class_< ompl::base::StateSpace::ValueLocation > ValueLocation_exposer_t;
            ValueLocation_exposer_t ValueLocation_exposer = ValueLocation_exposer_t( "ValueLocation" );
            bp::scope ValueLocation_scope( ValueLocation_exposer );
            ValueLocation_exposer.def_readwrite( "index", &ompl::base::StateSpace::ValueLocation::index );
            ValueLocation_exposer.def_readwrite( "stateLocation", &ompl::base::StateSpace::ValueLocation::stateLocation );
        }
        { //::ompl::base::StateSpace::allocDefaultStateSampler
        
            typedef ::ompl::base::StateSamplerPtr ( ::ompl::base::StateSpace::*allocDefaultStateSampler_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "allocDefaultStateSampler"
                , bp::pure_virtual( allocDefaultStateSampler_function_type(&::ompl::base::StateSpace::allocDefaultStateSampler) ) );
        
        }
        { //::ompl::base::StateSpace::allocState
        
            typedef ::ompl::base::State * ( ::ompl::base::StateSpace::*allocState_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "allocState"
                , bp::pure_virtual( allocState_function_type(&::ompl::base::StateSpace::allocState) )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::ompl::base::StateSpace::allocStateSampler
        
            typedef ::ompl::base::StateSamplerPtr ( ::ompl::base::StateSpace::*allocStateSampler_function_type )(  ) const;
            typedef ::ompl::base::StateSamplerPtr ( StateSpace_wrapper::*default_allocStateSampler_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "allocStateSampler"
                , allocStateSampler_function_type(&::ompl::base::StateSpace::allocStateSampler)
                , default_allocStateSampler_function_type(&StateSpace_wrapper::default_allocStateSampler) );
        
        }
        { //::ompl::base::StateSpace::allocSubspaceStateSampler
        
            typedef ::ompl::base::StateSamplerPtr ( ::ompl::base::StateSpace::*allocSubspaceStateSampler_function_type )( ::ompl::base::StateSpacePtr const & ) const;
            
            StateSpace_exposer.def( 
                "allocSubspaceStateSampler"
                , allocSubspaceStateSampler_function_type( &::ompl::base::StateSpace::allocSubspaceStateSampler )
                , ( bp::arg("subspace") ) );
        
        }
        { //::ompl::base::StateSpace::allocSubspaceStateSampler
        
            typedef ::ompl::base::StateSamplerPtr ( ::ompl::base::StateSpace::*allocSubspaceStateSampler_function_type )( ::ompl::base::StateSpace const * ) const;
            typedef ::ompl::base::StateSamplerPtr ( StateSpace_wrapper::*default_allocSubspaceStateSampler_function_type )( ::ompl::base::StateSpace const * ) const;
            
            StateSpace_exposer.def( 
                "allocSubspaceStateSampler"
                , allocSubspaceStateSampler_function_type(&::ompl::base::StateSpace::allocSubspaceStateSampler)
                , default_allocSubspaceStateSampler_function_type(&StateSpace_wrapper::default_allocSubspaceStateSampler)
                , ( bp::arg("subspace") ) );
        
        }
        { //::ompl::base::StateSpace::as
        
            typedef ::ompl::base::RealVectorStateSpace * ( ::ompl::base::StateSpace::*as_function_type )(  ) ;
            
            StateSpace_exposer.def( 
                "as"
                , as_function_type( &::ompl::base::StateSpace::as )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::ompl::base::StateSpace::as
        
            typedef ::ompl::base::RealVectorStateSpace const * ( ::ompl::base::StateSpace::*as_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "as"
                , as_function_type( &::ompl::base::StateSpace::as )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::ompl::base::StateSpace::clearStateSamplerAllocator
        
            typedef void ( ::ompl::base::StateSpace::*clearStateSamplerAllocator_function_type )(  ) ;
            
            StateSpace_exposer.def( 
                "clearStateSamplerAllocator"
                , clearStateSamplerAllocator_function_type( &::ompl::base::StateSpace::clearStateSamplerAllocator ) );
        
        }
        { //::ompl::base::StateSpace::computeLocations
        
            typedef void ( ::ompl::base::StateSpace::*computeLocations_function_type )(  ) ;
            typedef void ( StateSpace_wrapper::*default_computeLocations_function_type )(  ) ;
            
            StateSpace_exposer.def( 
                "computeLocations"
                , computeLocations_function_type(&::ompl::base::StateSpace::computeLocations)
                , default_computeLocations_function_type(&StateSpace_wrapper::default_computeLocations) );
        
        }
        { //::ompl::base::StateSpace::computeSignature
        
            typedef void ( ::ompl::base::StateSpace::*computeSignature_function_type )( ::std::vector< int > & ) const;
            
            StateSpace_exposer.def( 
                "computeSignature"
                , computeSignature_function_type( &::ompl::base::StateSpace::computeSignature )
                , ( bp::arg("signature") ) );
        
        }
        { //::ompl::base::StateSpace::copyFromReals
        
            typedef void ( ::ompl::base::StateSpace::*copyFromReals_function_type )( ::ompl::base::State *,::std::vector< double > const & ) const;
            
            StateSpace_exposer.def( 
                "copyFromReals"
                , copyFromReals_function_type( &::ompl::base::StateSpace::copyFromReals )
                , ( bp::arg("destination"), bp::arg("reals") ) );
        
        }
        { //::ompl::base::StateSpace::copyState
        
            typedef void ( ::ompl::base::StateSpace::*copyState_function_type )( ::ompl::base::State *,::ompl::base::State const * ) const;
            
            StateSpace_exposer.def( 
                "copyState"
                , bp::pure_virtual( copyState_function_type(&::ompl::base::StateSpace::copyState) )
                , ( bp::arg("destination"), bp::arg("source") ) );
        
        }
        { //::ompl::base::StateSpace::copyToReals
        
            typedef void ( ::ompl::base::StateSpace::*copyToReals_function_type )( ::std::vector< double > &,::ompl::base::State const * ) const;
            
            StateSpace_exposer.def( 
                "copyToReals"
                , copyToReals_function_type( &::ompl::base::StateSpace::copyToReals )
                , ( bp::arg("reals"), bp::arg("source") ) );
        
        }
        { //::ompl::base::StateSpace::covers
        
            typedef bool ( ::ompl::base::StateSpace::*covers_function_type )( ::ompl::base::StateSpacePtr const & ) const;
            
            StateSpace_exposer.def( 
                "covers"
                , covers_function_type( &::ompl::base::StateSpace::covers )
                , ( bp::arg("other") ) );
        
        }
        { //::ompl::base::StateSpace::covers
        
            typedef bool ( ::ompl::base::StateSpace::*covers_function_type )( ::ompl::base::StateSpace const * ) const;
            
            StateSpace_exposer.def( 
                "covers"
                , covers_function_type( &::ompl::base::StateSpace::covers )
                , ( bp::arg("other") ) );
        
        }
        { //::ompl::base::StateSpace::deserialize
        
            typedef void ( ::ompl::base::StateSpace::*deserialize_function_type )( ::ompl::base::State *,void const * ) const;
            typedef void ( StateSpace_wrapper::*default_deserialize_function_type )( ::ompl::base::State *,void const * ) const;
            
            StateSpace_exposer.def( 
                "deserialize"
                , deserialize_function_type(&::ompl::base::StateSpace::deserialize)
                , default_deserialize_function_type(&StateSpace_wrapper::default_deserialize)
                , ( bp::arg("state"), bp::arg("serialization") ) );
        
        }
        { //::ompl::base::StateSpace::diagram
        
            typedef void ( ::ompl::base::StateSpace::*diagram_function_type )( ::std::ostream & ) const;
            
            StateSpace_exposer.def( 
                "diagram"
                , diagram_function_type( &::ompl::base::StateSpace::diagram )
                , ( bp::arg("out") ) );
        
        }
        { //::ompl::base::StateSpace::distance
        
            typedef double ( ::ompl::base::StateSpace::*distance_function_type )( ::ompl::base::State const *,::ompl::base::State const * ) const;
            
            StateSpace_exposer.def( 
                "distance"
                , bp::pure_virtual( distance_function_type(&::ompl::base::StateSpace::distance) )
                , ( bp::arg("state1"), bp::arg("state2") ) );
        
        }
        { //::ompl::base::StateSpace::enforceBounds
        
            typedef void ( ::ompl::base::StateSpace::*enforceBounds_function_type )( ::ompl::base::State * ) const;
            
            StateSpace_exposer.def( 
                "enforceBounds"
                , bp::pure_virtual( enforceBounds_function_type(&::ompl::base::StateSpace::enforceBounds) )
                , ( bp::arg("state") ) );
        
        }
        { //::ompl::base::StateSpace::equalStates
        
            typedef bool ( ::ompl::base::StateSpace::*equalStates_function_type )( ::ompl::base::State const *,::ompl::base::State const * ) const;
            
            StateSpace_exposer.def( 
                "equalStates"
                , bp::pure_virtual( equalStates_function_type(&::ompl::base::StateSpace::equalStates) )
                , ( bp::arg("state1"), bp::arg("state2") ) );
        
        }
        { //::ompl::base::StateSpace::freeState
        
            typedef void ( ::ompl::base::StateSpace::*freeState_function_type )( ::ompl::base::State * ) const;
            
            StateSpace_exposer.def( 
                "freeState"
                , bp::pure_virtual( freeState_function_type(&::ompl::base::StateSpace::freeState) )
                , ( bp::arg("state") ) );
        
        }
        { //::ompl::base::StateSpace::getCommonSubspaces
        
            typedef void ( ::ompl::base::StateSpace::*getCommonSubspaces_function_type )( ::ompl::base::StateSpacePtr const &,::std::vector< std::string > & ) const;
            
            StateSpace_exposer.def( 
                "getCommonSubspaces"
                , getCommonSubspaces_function_type( &::ompl::base::StateSpace::getCommonSubspaces )
                , ( bp::arg("other"), bp::arg("subspaces") ) );
        
        }
        { //::ompl::base::StateSpace::getCommonSubspaces
        
            typedef void ( ::ompl::base::StateSpace::*getCommonSubspaces_function_type )( ::ompl::base::StateSpace const *,::std::vector< std::string > & ) const;
            
            StateSpace_exposer.def( 
                "getCommonSubspaces"
                , getCommonSubspaces_function_type( &::ompl::base::StateSpace::getCommonSubspaces )
                , ( bp::arg("other"), bp::arg("subspaces") ) );
        
        }
        { //::ompl::base::StateSpace::getDefaultProjection
        
            typedef ::ompl::base::ProjectionEvaluatorPtr ( ::ompl::base::StateSpace::*getDefaultProjection_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "getDefaultProjection"
                , getDefaultProjection_function_type( &::ompl::base::StateSpace::getDefaultProjection ) );
        
        }
        { //::ompl::base::StateSpace::getDimension
        
            typedef unsigned int ( ::ompl::base::StateSpace::*getDimension_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "getDimension"
                , bp::pure_virtual( getDimension_function_type(&::ompl::base::StateSpace::getDimension) ) );
        
        }
        { //::ompl::base::StateSpace::getLongestValidSegmentFraction
        
            typedef double ( ::ompl::base::StateSpace::*getLongestValidSegmentFraction_function_type )(  ) const;
            typedef double ( StateSpace_wrapper::*default_getLongestValidSegmentFraction_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "getLongestValidSegmentFraction"
                , getLongestValidSegmentFraction_function_type(&::ompl::base::StateSpace::getLongestValidSegmentFraction)
                , default_getLongestValidSegmentFraction_function_type(&StateSpace_wrapper::default_getLongestValidSegmentFraction) );
        
        }
        { //::ompl::base::StateSpace::getLongestValidSegmentLength
        
            typedef double ( ::ompl::base::StateSpace::*getLongestValidSegmentLength_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "getLongestValidSegmentLength"
                , getLongestValidSegmentLength_function_type( &::ompl::base::StateSpace::getLongestValidSegmentLength ) );
        
        }
        { //::ompl::base::StateSpace::getMaximumExtent
        
            typedef double ( ::ompl::base::StateSpace::*getMaximumExtent_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "getMaximumExtent"
                , bp::pure_virtual( getMaximumExtent_function_type(&::ompl::base::StateSpace::getMaximumExtent) ) );
        
        }
        { //::ompl::base::StateSpace::getMeasure
        
            typedef double ( ::ompl::base::StateSpace::*getMeasure_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "getMeasure"
                , bp::pure_virtual( getMeasure_function_type(&::ompl::base::StateSpace::getMeasure) ) );
        
        }
        { //::ompl::base::StateSpace::getName
        
            typedef ::std::string const & ( ::ompl::base::StateSpace::*getName_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "getName"
                , getName_function_type( &::ompl::base::StateSpace::getName )
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::ompl::base::StateSpace::getProjection
        
            typedef ::ompl::base::ProjectionEvaluatorPtr ( ::ompl::base::StateSpace::*getProjection_function_type )( ::std::string const & ) const;
            
            StateSpace_exposer.def( 
                "getProjection"
                , getProjection_function_type( &::ompl::base::StateSpace::getProjection )
                , ( bp::arg("name") ) );
        
        }
        { //::ompl::base::StateSpace::getRegisteredProjections
        
            typedef ::std::map< std::string, boost::shared_ptr<ompl::base::ProjectionEvaluator> > const & ( ::ompl::base::StateSpace::*getRegisteredProjections_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "getRegisteredProjections"
                , getRegisteredProjections_function_type( &::ompl::base::StateSpace::getRegisteredProjections )
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::ompl::base::StateSpace::getSerializationLength
        
            typedef unsigned int ( ::ompl::base::StateSpace::*getSerializationLength_function_type )(  ) const;
            typedef unsigned int ( StateSpace_wrapper::*default_getSerializationLength_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "getSerializationLength"
                , getSerializationLength_function_type(&::ompl::base::StateSpace::getSerializationLength)
                , default_getSerializationLength_function_type(&StateSpace_wrapper::default_getSerializationLength) );
        
        }
        { //::ompl::base::StateSpace::getSubstateAtLocation
        
            typedef ::ompl::base::State * ( ::ompl::base::StateSpace::*getSubstateAtLocation_function_type )( ::ompl::base::State *,::ompl::base::StateSpace::SubstateLocation const & ) const;
            
            StateSpace_exposer.def( 
                "getSubstateAtLocation"
                , getSubstateAtLocation_function_type( &::ompl::base::StateSpace::getSubstateAtLocation )
                , ( bp::arg("state"), bp::arg("loc") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::ompl::base::StateSpace::getSubstateAtLocation
        
            typedef ::ompl::base::State const * ( ::ompl::base::StateSpace::*getSubstateAtLocation_function_type )( ::ompl::base::State const *,::ompl::base::StateSpace::SubstateLocation const & ) const;
            
            StateSpace_exposer.def( 
                "getSubstateAtLocation"
                , getSubstateAtLocation_function_type( &::ompl::base::StateSpace::getSubstateAtLocation )
                , ( bp::arg("state"), bp::arg("loc") )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::ompl::base::StateSpace::getSubstateLocationsByName
        
            typedef ::std::map< std::string, ompl::base::StateSpace::SubstateLocation > const & ( ::ompl::base::StateSpace::*getSubstateLocationsByName_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "getSubstateLocationsByName"
                , getSubstateLocationsByName_function_type( &::ompl::base::StateSpace::getSubstateLocationsByName )
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::ompl::base::StateSpace::getType
        
            typedef int ( ::ompl::base::StateSpace::*getType_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "getType"
                , getType_function_type( &::ompl::base::StateSpace::getType ) );
        
        }
        { //::ompl::base::StateSpace::getValidSegmentCountFactor
        
            typedef unsigned int ( ::ompl::base::StateSpace::*getValidSegmentCountFactor_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "getValidSegmentCountFactor"
                , getValidSegmentCountFactor_function_type( &::ompl::base::StateSpace::getValidSegmentCountFactor ) );
        
        }
        { //::ompl::base::StateSpace::hasDefaultProjection
        
            typedef bool ( ::ompl::base::StateSpace::*hasDefaultProjection_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "hasDefaultProjection"
                , hasDefaultProjection_function_type( &::ompl::base::StateSpace::hasDefaultProjection ) );
        
        }
        { //::ompl::base::StateSpace::hasProjection
        
            typedef bool ( ::ompl::base::StateSpace::*hasProjection_function_type )( ::std::string const & ) const;
            
            StateSpace_exposer.def( 
                "hasProjection"
                , hasProjection_function_type( &::ompl::base::StateSpace::hasProjection )
                , ( bp::arg("name") ) );
        
        }
        { //::ompl::base::StateSpace::hasSymmetricDistance
        
            typedef bool ( ::ompl::base::StateSpace::*hasSymmetricDistance_function_type )(  ) const;
            typedef bool ( StateSpace_wrapper::*default_hasSymmetricDistance_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "hasSymmetricDistance"
                , hasSymmetricDistance_function_type(&::ompl::base::StateSpace::hasSymmetricDistance)
                , default_hasSymmetricDistance_function_type(&StateSpace_wrapper::default_hasSymmetricDistance) );
        
        }
        { //::ompl::base::StateSpace::hasSymmetricInterpolate
        
            typedef bool ( ::ompl::base::StateSpace::*hasSymmetricInterpolate_function_type )(  ) const;
            typedef bool ( StateSpace_wrapper::*default_hasSymmetricInterpolate_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "hasSymmetricInterpolate"
                , hasSymmetricInterpolate_function_type(&::ompl::base::StateSpace::hasSymmetricInterpolate)
                , default_hasSymmetricInterpolate_function_type(&StateSpace_wrapper::default_hasSymmetricInterpolate) );
        
        }
        { //::ompl::base::StateSpace::includes
        
            typedef bool ( ::ompl::base::StateSpace::*includes_function_type )( ::ompl::base::StateSpacePtr const & ) const;
            
            StateSpace_exposer.def( 
                "includes"
                , includes_function_type( &::ompl::base::StateSpace::includes )
                , ( bp::arg("other") ) );
        
        }
        { //::ompl::base::StateSpace::includes
        
            typedef bool ( ::ompl::base::StateSpace::*includes_function_type )( ::ompl::base::StateSpace const * ) const;
            
            StateSpace_exposer.def( 
                "includes"
                , includes_function_type( &::ompl::base::StateSpace::includes )
                , ( bp::arg("other") ) );
        
        }
        { //::ompl::base::StateSpace::interpolate
        
            typedef void ( ::ompl::base::StateSpace::*interpolate_function_type )( ::ompl::base::State const *,::ompl::base::State const *,double const,::ompl::base::State * ) const;
            
            StateSpace_exposer.def( 
                "interpolate"
                , bp::pure_virtual( interpolate_function_type(&::ompl::base::StateSpace::interpolate) )
                , ( bp::arg("from"), bp::arg("to"), bp::arg("t"), bp::arg("state") ) );
        
        }
        { //::ompl::base::StateSpace::isCompound
        
            typedef bool ( ::ompl::base::StateSpace::*isCompound_function_type )(  ) const;
            typedef bool ( StateSpace_wrapper::*default_isCompound_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "isCompound"
                , isCompound_function_type(&::ompl::base::StateSpace::isCompound)
                , default_isCompound_function_type(&StateSpace_wrapper::default_isCompound) );
        
        }
        { //::ompl::base::StateSpace::isDiscrete
        
            typedef bool ( ::ompl::base::StateSpace::*isDiscrete_function_type )(  ) const;
            typedef bool ( StateSpace_wrapper::*default_isDiscrete_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "isDiscrete"
                , isDiscrete_function_type(&::ompl::base::StateSpace::isDiscrete)
                , default_isDiscrete_function_type(&StateSpace_wrapper::default_isDiscrete) );
        
        }
        { //::ompl::base::StateSpace::isHybrid
        
            typedef bool ( ::ompl::base::StateSpace::*isHybrid_function_type )(  ) const;
            typedef bool ( StateSpace_wrapper::*default_isHybrid_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "isHybrid"
                , isHybrid_function_type(&::ompl::base::StateSpace::isHybrid)
                , default_isHybrid_function_type(&StateSpace_wrapper::default_isHybrid) );
        
        }
        { //::ompl::base::StateSpace::isMetricSpace
        
            typedef bool ( ::ompl::base::StateSpace::*isMetricSpace_function_type )(  ) const;
            typedef bool ( StateSpace_wrapper::*default_isMetricSpace_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "isMetricSpace"
                , isMetricSpace_function_type(&::ompl::base::StateSpace::isMetricSpace)
                , default_isMetricSpace_function_type(&StateSpace_wrapper::default_isMetricSpace) );
        
        }
        { //::ompl::base::StateSpace::list
        
            typedef void ( ::ompl::base::StateSpace::*list_function_type )( ::std::ostream & ) const;
            
            StateSpace_exposer.def( 
                "list"
                , list_function_type( &::ompl::base::StateSpace::list )
                , ( bp::arg("out") ) );
        
        }
        { //::ompl::base::StateSpace::params
        
            typedef ::ompl::base::ParamSet & ( ::ompl::base::StateSpace::*params_function_type )(  ) ;
            
            StateSpace_exposer.def( 
                "params"
                , params_function_type( &::ompl::base::StateSpace::params )
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::ompl::base::StateSpace::params
        
            typedef ::ompl::base::ParamSet const & ( ::ompl::base::StateSpace::*params_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "params"
                , params_function_type( &::ompl::base::StateSpace::params )
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::ompl::base::StateSpace::registerDefaultProjection
        
            typedef void ( ::ompl::base::StateSpace::*registerDefaultProjection_function_type )( ::ompl::base::ProjectionEvaluatorPtr const & ) ;
            
            StateSpace_exposer.def( 
                "registerDefaultProjection"
                , registerDefaultProjection_function_type( &::ompl::base::StateSpace::registerDefaultProjection )
                , ( bp::arg("projection") ) );
        
        }
        { //::ompl::base::StateSpace::registerProjection
        
            typedef void ( ::ompl::base::StateSpace::*registerProjection_function_type )( ::std::string const &,::ompl::base::ProjectionEvaluatorPtr const & ) ;
            
            StateSpace_exposer.def( 
                "registerProjection"
                , registerProjection_function_type( &::ompl::base::StateSpace::registerProjection )
                , ( bp::arg("name"), bp::arg("projection") ) );
        
        }
        { //::ompl::base::StateSpace::registerProjections
        
            typedef void ( ::ompl::base::StateSpace::*registerProjections_function_type )(  ) ;
            typedef void ( StateSpace_wrapper::*default_registerProjections_function_type )(  ) ;
            
            StateSpace_exposer.def( 
                "registerProjections"
                , registerProjections_function_type(&::ompl::base::StateSpace::registerProjections)
                , default_registerProjections_function_type(&StateSpace_wrapper::default_registerProjections) );
        
        }
        { //::ompl::base::StateSpace::sanityChecks
        
            typedef void ( ::ompl::base::StateSpace::*sanityChecks_function_type )( double,double,unsigned int ) const;
            typedef void ( StateSpace_wrapper::*default_sanityChecks_function_type )( double,double,unsigned int ) const;
            
            StateSpace_exposer.def( 
                "sanityChecks"
                , sanityChecks_function_type(&::ompl::base::StateSpace::sanityChecks)
                , default_sanityChecks_function_type(&StateSpace_wrapper::default_sanityChecks)
                , ( bp::arg("zero"), bp::arg("eps"), bp::arg("flags") ) );
        
        }
        { //::ompl::base::StateSpace::sanityChecks
        
            typedef void ( ::ompl::base::StateSpace::*sanityChecks_function_type )(  ) const;
            typedef void ( StateSpace_wrapper::*default_sanityChecks_function_type )(  ) const;
            
            StateSpace_exposer.def( 
                "sanityChecks"
                , sanityChecks_function_type(&::ompl::base::StateSpace::sanityChecks)
                , default_sanityChecks_function_type(&StateSpace_wrapper::default_sanityChecks) );
        
        }
        { //::ompl::base::StateSpace::satisfiesBounds
        
            typedef bool ( ::ompl::base::StateSpace::*satisfiesBounds_function_type )( ::ompl::base::State const * ) const;
            
            StateSpace_exposer.def( 
                "satisfiesBounds"
                , bp::pure_virtual( satisfiesBounds_function_type(&::ompl::base::StateSpace::satisfiesBounds) )
                , ( bp::arg("state") ) );
        
        }
        { //::ompl::base::StateSpace::serialize
        
            typedef void ( ::ompl::base::StateSpace::*serialize_function_type )( void *,::ompl::base::State const * ) const;
            typedef void ( StateSpace_wrapper::*default_serialize_function_type )( void *,::ompl::base::State const * ) const;
            
            StateSpace_exposer.def( 
                "serialize"
                , serialize_function_type(&::ompl::base::StateSpace::serialize)
                , default_serialize_function_type(&StateSpace_wrapper::default_serialize)
                , ( bp::arg("serialization"), bp::arg("state") ) );
        
        }
        { //::ompl::base::StateSpace::setLongestValidSegmentFraction
        
            typedef void ( ::ompl::base::StateSpace::*setLongestValidSegmentFraction_function_type )( double ) ;
            typedef void ( StateSpace_wrapper::*default_setLongestValidSegmentFraction_function_type )( double ) ;
            
            StateSpace_exposer.def( 
                "setLongestValidSegmentFraction"
                , setLongestValidSegmentFraction_function_type(&::ompl::base::StateSpace::setLongestValidSegmentFraction)
                , default_setLongestValidSegmentFraction_function_type(&StateSpace_wrapper::default_setLongestValidSegmentFraction)
                , ( bp::arg("segmentFraction") ) );
        
        }
        { //::ompl::base::StateSpace::setName
        
            typedef void ( ::ompl::base::StateSpace::*setName_function_type )( ::std::string const & ) ;
            
            StateSpace_exposer.def( 
                "setName"
                , setName_function_type( &::ompl::base::StateSpace::setName )
                , ( bp::arg("name") ) );
        
        }
        { //::ompl::base::StateSpace::setStateSamplerAllocator
        
            typedef void ( ::ompl::base::StateSpace::*setStateSamplerAllocator_function_type )( ::ompl::base::StateSamplerAllocator const & ) ;
            
            StateSpace_exposer.def( 
                "setStateSamplerAllocator"
                , setStateSamplerAllocator_function_type( &::ompl::base::StateSpace::setStateSamplerAllocator )
                , ( bp::arg("ssa") ) );
        
        }
        { //::ompl::base::StateSpace::setValidSegmentCountFactor
        
            typedef void ( ::ompl::base::StateSpace::*setValidSegmentCountFactor_function_type )( unsigned int ) ;
            
            StateSpace_exposer.def( 
                "setValidSegmentCountFactor"
                , setValidSegmentCountFactor_function_type( &::ompl::base::StateSpace::setValidSegmentCountFactor )
                , ( bp::arg("factor") ) );
        
        }
        { //::ompl::base::StateSpace::setup
        
            typedef void ( ::ompl::base::StateSpace::*setup_function_type )(  ) ;
            typedef void ( StateSpace_wrapper::*default_setup_function_type )(  ) ;
            
            StateSpace_exposer.def( 
                "setup"
                , setup_function_type(&::ompl::base::StateSpace::setup)
                , default_setup_function_type(&StateSpace_wrapper::default_setup) );
        
        }
        { //::ompl::base::StateSpace::validSegmentCount
        
            typedef unsigned int ( ::ompl::base::StateSpace::*validSegmentCount_function_type )( ::ompl::base::State const *,::ompl::base::State const * ) const;
            typedef unsigned int ( StateSpace_wrapper::*default_validSegmentCount_function_type )( ::ompl::base::State const *,::ompl::base::State const * ) const;
            
            StateSpace_exposer.def( 
                "validSegmentCount"
                , validSegmentCount_function_type(&::ompl::base::StateSpace::validSegmentCount)
                , default_validSegmentCount_function_type(&StateSpace_wrapper::default_validSegmentCount)
                , ( bp::arg("state1"), bp::arg("state2") ) );
        
        }
        bp::register_ptr_to_python< boost::shared_ptr< ompl::base::StateSpace > >();
        bp::implicitly_convertible< boost::shared_ptr< ompl::base::CompoundStateSpace >, boost::shared_ptr< ompl::base::StateSpace > >();
        bp::implicitly_convertible< boost::shared_ptr< ompl::base::SE3StateSpace >, boost::shared_ptr< ompl::base::StateSpace > >();
        bp::implicitly_convertible< boost::shared_ptr< ompl::base::SE2StateSpace >, boost::shared_ptr< ompl::base::StateSpace > >();
        bp::implicitly_convertible< boost::shared_ptr< ompl::base::DubinsStateSpace >, boost::shared_ptr< ompl::base::StateSpace > >();
        bp::implicitly_convertible< boost::shared_ptr< ompl::base::ReedsSheppStateSpace >, boost::shared_ptr< ompl::base::StateSpace > >();
        bp::implicitly_convertible< boost::shared_ptr< ompl::base::SO3StateSpace >, boost::shared_ptr< ompl::base::StateSpace > >();
        bp::implicitly_convertible< boost::shared_ptr< ompl::base::DiscreteStateSpace >, boost::shared_ptr< ompl::base::StateSpace > >();
        bp::implicitly_convertible< boost::shared_ptr< ompl::base::SO2StateSpace >, boost::shared_ptr< ompl::base::StateSpace > >();
        bp::implicitly_convertible< boost::shared_ptr< ompl::base::RealVectorStateSpace >, boost::shared_ptr< ompl::base::StateSpace > >();
        bp::implicitly_convertible< boost::shared_ptr< ompl::base::TimeStateSpace >, boost::shared_ptr< ompl::base::StateSpace > >();
        StateSpace_exposer.def("settings", &__printSettings);
        StateSpace_exposer.def("string", &__printState);
        StateSpace_exposer.def("projections", &__printProjections);
        StateSpace_exposer.def("Diagram", &DiagramWrapper);
        StateSpace_exposer.def("List", &ListWrapper);
    }

}
