// This file has been generated by Py++.

#include "boost/python.hpp"
#include "bindings/base.h"
#include "DubinsStateSpace.pypp.hpp"

namespace bp = boost::python;

struct DubinsStateSpace_wrapper : ompl::base::DubinsStateSpace, bp::wrapper< ompl::base::DubinsStateSpace > {

    DubinsStateSpace_wrapper(double turningRadius=1.0e+0, bool isSymmetric=false )
    : ompl::base::DubinsStateSpace( turningRadius, isSymmetric )
      , bp::wrapper< ompl::base::DubinsStateSpace >(){
        // constructor
    
    }

    virtual double distance( ::ompl::base::State const * state1, ::ompl::base::State const * state2 ) const  {
        if( bp::override func_distance = this->get_override( "distance" ) )
            return func_distance( boost::python::ptr(state1), boost::python::ptr(state2) );
        else{
            return this->ompl::base::DubinsStateSpace::distance( boost::python::ptr(state1), boost::python::ptr(state2) );
        }
    }
    
    double default_distance( ::ompl::base::State const * state1, ::ompl::base::State const * state2 ) const  {
        return ompl::base::DubinsStateSpace::distance( boost::python::ptr(state1), boost::python::ptr(state2) );
    }

    virtual bool hasSymmetricDistance(  ) const  {
        if( bp::override func_hasSymmetricDistance = this->get_override( "hasSymmetricDistance" ) )
            return func_hasSymmetricDistance(  );
        else{
            return this->ompl::base::DubinsStateSpace::hasSymmetricDistance(  );
        }
    }
    
    bool default_hasSymmetricDistance(  ) const  {
        return ompl::base::DubinsStateSpace::hasSymmetricDistance( );
    }

    virtual bool hasSymmetricInterpolate(  ) const  {
        if( bp::override func_hasSymmetricInterpolate = this->get_override( "hasSymmetricInterpolate" ) )
            return func_hasSymmetricInterpolate(  );
        else{
            return this->ompl::base::DubinsStateSpace::hasSymmetricInterpolate(  );
        }
    }
    
    bool default_hasSymmetricInterpolate(  ) const  {
        return ompl::base::DubinsStateSpace::hasSymmetricInterpolate( );
    }

    virtual void interpolate( ::ompl::base::State const * from, ::ompl::base::State const * to, double const t, ::ompl::base::State * state ) const  {
        if( bp::override func_interpolate = this->get_override( "interpolate" ) )
            func_interpolate( boost::python::ptr(from), boost::python::ptr(to), t, boost::python::ptr(state) );
        else{
            this->ompl::base::DubinsStateSpace::interpolate( boost::python::ptr(from), boost::python::ptr(to), t, boost::python::ptr(state) );
        }
    }
    
    void default_interpolate( ::ompl::base::State const * from, ::ompl::base::State const * to, double const t, ::ompl::base::State * state ) const  {
        ompl::base::DubinsStateSpace::interpolate( boost::python::ptr(from), boost::python::ptr(to), t, boost::python::ptr(state) );
    }

    virtual void interpolate( ::ompl::base::State const * from, ::ompl::base::State const * to, double const t, bool & firstTime, ::ompl::base::DubinsStateSpace::DubinsPath & path, ::ompl::base::State * state ) const  {
        if( bp::override func_interpolate = this->get_override( "interpolate" ) )
            func_interpolate( boost::python::ptr(from), boost::python::ptr(to), t, firstTime, boost::ref(path), boost::python::ptr(state) );
        else{
            this->ompl::base::DubinsStateSpace::interpolate( boost::python::ptr(from), boost::python::ptr(to), t, firstTime, boost::ref(path), boost::python::ptr(state) );
        }
    }
    
    void default_interpolate( ::ompl::base::State const * from, ::ompl::base::State const * to, double const t, bool & firstTime, ::ompl::base::DubinsStateSpace::DubinsPath & path, ::ompl::base::State * state ) const  {
        ompl::base::DubinsStateSpace::interpolate( boost::python::ptr(from), boost::python::ptr(to), t, firstTime, boost::ref(path), boost::python::ptr(state) );
    }

    virtual void interpolate( ::ompl::base::State const * from, ::ompl::base::DubinsStateSpace::DubinsPath const & path, double const t, ::ompl::base::State * state ) const {
        if( bp::override func_interpolate = this->get_override( "interpolate" ) )
            func_interpolate( boost::python::ptr(from), boost::ref(path), t, boost::python::ptr(state) );
        else{
            this->ompl::base::DubinsStateSpace::interpolate( boost::python::ptr(from), boost::ref(path), t, boost::python::ptr(state) );
        }
    }
    
    virtual void default_interpolate( ::ompl::base::State const * from, ::ompl::base::DubinsStateSpace::DubinsPath const & path, double const t, ::ompl::base::State * state ) const {
        ompl::base::DubinsStateSpace::interpolate( boost::python::ptr(from), boost::ref(path), t, boost::python::ptr(state) );
    }

    virtual bool isMetricSpace(  ) const  {
        if( bp::override func_isMetricSpace = this->get_override( "isMetricSpace" ) )
            return func_isMetricSpace(  );
        else{
            return this->ompl::base::DubinsStateSpace::isMetricSpace(  );
        }
    }
    
    bool default_isMetricSpace(  ) const  {
        return ompl::base::DubinsStateSpace::isMetricSpace( );
    }

    virtual void sanityChecks(  ) const  {
        if( bp::override func_sanityChecks = this->get_override( "sanityChecks" ) )
            func_sanityChecks(  );
        else{
            this->ompl::base::DubinsStateSpace::sanityChecks(  );
        }
    }
    
    void default_sanityChecks(  ) const  {
        ompl::base::DubinsStateSpace::sanityChecks( );
    }

    virtual ::ompl::base::StateSamplerPtr allocDefaultStateSampler(  ) const  {
        if( bp::override func_allocDefaultStateSampler = this->get_override( "allocDefaultStateSampler" ) )
            return func_allocDefaultStateSampler(  );
        else{
            return this->ompl::base::CompoundStateSpace::allocDefaultStateSampler(  );
        }
    }
    
    ::ompl::base::StateSamplerPtr default_allocDefaultStateSampler(  ) const  {
        return ompl::base::CompoundStateSpace::allocDefaultStateSampler( );
    }

    virtual ::ompl::base::State * allocState(  ) const  {
        if( bp::override func_allocState = this->get_override( "allocState" ) )
            return func_allocState(  );
        else{
            return this->ompl::base::SE2StateSpace::allocState(  );
        }
    }
    
    ::ompl::base::State * default_allocState(  ) const  {
        return ompl::base::SE2StateSpace::allocState( );
    }

    void allocStateComponents( ::ompl::base::CompoundState * state ) const {
        ompl::base::CompoundStateSpace::allocStateComponents( boost::python::ptr(state) );
    }

    virtual ::ompl::base::StateSamplerPtr allocStateSampler(  ) const  {
        if( bp::override func_allocStateSampler = this->get_override( "allocStateSampler" ) )
            return func_allocStateSampler(  );
        else{
            return this->ompl::base::StateSpace::allocStateSampler(  );
        }
    }
    
    ::ompl::base::StateSamplerPtr default_allocStateSampler(  ) const  {
        return ompl::base::StateSpace::allocStateSampler( );
    }

    virtual ::ompl::base::StateSamplerPtr allocSubspaceStateSampler( ::ompl::base::StateSpace const * subspace ) const  {
        if( bp::override func_allocSubspaceStateSampler = this->get_override( "allocSubspaceStateSampler" ) )
            return func_allocSubspaceStateSampler( boost::python::ptr(subspace) );
        else{
            return this->ompl::base::CompoundStateSpace::allocSubspaceStateSampler( boost::python::ptr(subspace) );
        }
    }
    
    ::ompl::base::StateSamplerPtr default_allocSubspaceStateSampler( ::ompl::base::StateSpace const * subspace ) const  {
        return ompl::base::CompoundStateSpace::allocSubspaceStateSampler( boost::python::ptr(subspace) );
    }

    virtual void computeLocations(  ) {
        if( bp::override func_computeLocations = this->get_override( "computeLocations" ) )
            func_computeLocations(  );
        else{
            this->ompl::base::CompoundStateSpace::computeLocations(  );
        }
    }
    
    void default_computeLocations(  ) {
        ompl::base::CompoundStateSpace::computeLocations( );
    }

    virtual void copyState( ::ompl::base::State * destination, ::ompl::base::State const * source ) const  {
        if( bp::override func_copyState = this->get_override( "copyState" ) )
            func_copyState( boost::python::ptr(destination), boost::python::ptr(source) );
        else{
            this->ompl::base::CompoundStateSpace::copyState( boost::python::ptr(destination), boost::python::ptr(source) );
        }
    }
    
    void default_copyState( ::ompl::base::State * destination, ::ompl::base::State const * source ) const  {
        ompl::base::CompoundStateSpace::copyState( boost::python::ptr(destination), boost::python::ptr(source) );
    }

    virtual void deserialize( ::ompl::base::State * state, void const * serialization ) const  {
        if( bp::override func_deserialize = this->get_override( "deserialize" ) )
            func_deserialize( boost::python::ptr(state), serialization );
        else{
            this->ompl::base::CompoundStateSpace::deserialize( boost::python::ptr(state), serialization );
        }
    }
    
    void default_deserialize( ::ompl::base::State * state, void const * serialization ) const  {
        ompl::base::CompoundStateSpace::deserialize( boost::python::ptr(state), serialization );
    }

    virtual void enforceBounds( ::ompl::base::State * state ) const  {
        if( bp::override func_enforceBounds = this->get_override( "enforceBounds" ) )
            func_enforceBounds( boost::python::ptr(state) );
        else{
            this->ompl::base::CompoundStateSpace::enforceBounds( boost::python::ptr(state) );
        }
    }
    
    void default_enforceBounds( ::ompl::base::State * state ) const  {
        ompl::base::CompoundStateSpace::enforceBounds( boost::python::ptr(state) );
    }

    virtual bool equalStates( ::ompl::base::State const * state1, ::ompl::base::State const * state2 ) const  {
        if( bp::override func_equalStates = this->get_override( "equalStates" ) )
            return func_equalStates( boost::python::ptr(state1), boost::python::ptr(state2) );
        else{
            return this->ompl::base::CompoundStateSpace::equalStates( boost::python::ptr(state1), boost::python::ptr(state2) );
        }
    }
    
    bool default_equalStates( ::ompl::base::State const * state1, ::ompl::base::State const * state2 ) const  {
        return ompl::base::CompoundStateSpace::equalStates( boost::python::ptr(state1), boost::python::ptr(state2) );
    }

    virtual void freeState( ::ompl::base::State * state ) const  {
        if( bp::override func_freeState = this->get_override( "freeState" ) )
            func_freeState( boost::python::ptr(state) );
        else{
            this->ompl::base::SE2StateSpace::freeState( boost::python::ptr(state) );
        }
    }
    
    void default_freeState( ::ompl::base::State * state ) const  {
        ompl::base::SE2StateSpace::freeState( boost::python::ptr(state) );
    }

    virtual unsigned int getDimension(  ) const  {
        if( bp::override func_getDimension = this->get_override( "getDimension" ) )
            return func_getDimension(  );
        else{
            return this->ompl::base::CompoundStateSpace::getDimension(  );
        }
    }
    
    unsigned int default_getDimension(  ) const  {
        return ompl::base::CompoundStateSpace::getDimension( );
    }

    virtual double getLongestValidSegmentFraction(  ) const  {
        if( bp::override func_getLongestValidSegmentFraction = this->get_override( "getLongestValidSegmentFraction" ) )
            return func_getLongestValidSegmentFraction(  );
        else{
            return this->ompl::base::StateSpace::getLongestValidSegmentFraction(  );
        }
    }
    
    double default_getLongestValidSegmentFraction(  ) const  {
        return ompl::base::StateSpace::getLongestValidSegmentFraction( );
    }

    virtual double getMaximumExtent(  ) const  {
        if( bp::override func_getMaximumExtent = this->get_override( "getMaximumExtent" ) )
            return func_getMaximumExtent(  );
        else{
            return this->ompl::base::CompoundStateSpace::getMaximumExtent(  );
        }
    }
    
    double default_getMaximumExtent(  ) const  {
        return ompl::base::CompoundStateSpace::getMaximumExtent( );
    }

    virtual double getMeasure(  ) const  {
        if( bp::override func_getMeasure = this->get_override( "getMeasure" ) )
            return func_getMeasure(  );
        else{
            return this->ompl::base::CompoundStateSpace::getMeasure(  );
        }
    }
    
    double default_getMeasure(  ) const  {
        return ompl::base::CompoundStateSpace::getMeasure( );
    }

    virtual unsigned int getSerializationLength(  ) const  {
        if( bp::override func_getSerializationLength = this->get_override( "getSerializationLength" ) )
            return func_getSerializationLength(  );
        else{
            return this->ompl::base::CompoundStateSpace::getSerializationLength(  );
        }
    }
    
    unsigned int default_getSerializationLength(  ) const  {
        return ompl::base::CompoundStateSpace::getSerializationLength( );
    }

    virtual bool isCompound(  ) const  {
        if( bp::override func_isCompound = this->get_override( "isCompound" ) )
            return func_isCompound(  );
        else{
            return this->ompl::base::CompoundStateSpace::isCompound(  );
        }
    }
    
    bool default_isCompound(  ) const  {
        return ompl::base::CompoundStateSpace::isCompound( );
    }

    virtual bool isDiscrete(  ) const  {
        if( bp::override func_isDiscrete = this->get_override( "isDiscrete" ) )
            return func_isDiscrete(  );
        else{
            return this->ompl::base::StateSpace::isDiscrete(  );
        }
    }
    
    bool default_isDiscrete(  ) const  {
        return ompl::base::StateSpace::isDiscrete( );
    }

    virtual bool isHybrid(  ) const  {
        if( bp::override func_isHybrid = this->get_override( "isHybrid" ) )
            return func_isHybrid(  );
        else{
            return this->ompl::base::CompoundStateSpace::isHybrid(  );
        }
    }
    
    bool default_isHybrid(  ) const  {
        return ompl::base::CompoundStateSpace::isHybrid( );
    }

    virtual void registerProjections(  ) {
        if( bp::override func_registerProjections = this->get_override( "registerProjections" ) )
            func_registerProjections(  );
        else{
            this->ompl::base::SE2StateSpace::registerProjections(  );
        }
    }
    
    void default_registerProjections(  ) {
        ompl::base::SE2StateSpace::registerProjections( );
    }

    virtual void sanityChecks( double zero, double eps, unsigned int flags ) const  {
        if( bp::override func_sanityChecks = this->get_override( "sanityChecks" ) )
            func_sanityChecks( zero, eps, flags );
        else{
            this->ompl::base::StateSpace::sanityChecks( zero, eps, flags );
        }
    }
    
    void default_sanityChecks( double zero, double eps, unsigned int flags ) const  {
        ompl::base::StateSpace::sanityChecks( zero, eps, flags );
    }

    virtual bool satisfiesBounds( ::ompl::base::State const * state ) const  {
        if( bp::override func_satisfiesBounds = this->get_override( "satisfiesBounds" ) )
            return func_satisfiesBounds( boost::python::ptr(state) );
        else{
            return this->ompl::base::CompoundStateSpace::satisfiesBounds( boost::python::ptr(state) );
        }
    }
    
    bool default_satisfiesBounds( ::ompl::base::State const * state ) const  {
        return ompl::base::CompoundStateSpace::satisfiesBounds( boost::python::ptr(state) );
    }

    virtual void serialize( void * serialization, ::ompl::base::State const * state ) const  {
        if( bp::override func_serialize = this->get_override( "serialize" ) )
            func_serialize( serialization, boost::python::ptr(state) );
        else{
            this->ompl::base::CompoundStateSpace::serialize( serialization, boost::python::ptr(state) );
        }
    }
    
    void default_serialize( void * serialization, ::ompl::base::State const * state ) const  {
        ompl::base::CompoundStateSpace::serialize( serialization, boost::python::ptr(state) );
    }

    virtual void setLongestValidSegmentFraction( double segmentFraction ) {
        if( bp::override func_setLongestValidSegmentFraction = this->get_override( "setLongestValidSegmentFraction" ) )
            func_setLongestValidSegmentFraction( segmentFraction );
        else{
            this->ompl::base::CompoundStateSpace::setLongestValidSegmentFraction( segmentFraction );
        }
    }
    
    void default_setLongestValidSegmentFraction( double segmentFraction ) {
        ompl::base::CompoundStateSpace::setLongestValidSegmentFraction( segmentFraction );
    }

    virtual void setup(  ) {
        if( bp::override func_setup = this->get_override( "setup" ) )
            func_setup(  );
        else{
            this->ompl::base::CompoundStateSpace::setup(  );
        }
    }
    
    void default_setup(  ) {
        ompl::base::CompoundStateSpace::setup( );
    }

    virtual unsigned int validSegmentCount( ::ompl::base::State const * state1, ::ompl::base::State const * state2 ) const  {
        if( bp::override func_validSegmentCount = this->get_override( "validSegmentCount" ) )
            return func_validSegmentCount( boost::python::ptr(state1), boost::python::ptr(state2) );
        else{
            return this->ompl::base::CompoundStateSpace::validSegmentCount( boost::python::ptr(state1), boost::python::ptr(state2) );
        }
    }
    
    unsigned int default_validSegmentCount( ::ompl::base::State const * state1, ::ompl::base::State const * state2 ) const  {
        return ompl::base::CompoundStateSpace::validSegmentCount( boost::python::ptr(state1), boost::python::ptr(state2) );
    }

};

void register_DubinsStateSpace_class(){

    { //::ompl::base::DubinsStateSpace
        typedef bp::class_< DubinsStateSpace_wrapper, bp::bases< ompl::base::SE2StateSpace >, boost::noncopyable > DubinsStateSpace_exposer_t;
        DubinsStateSpace_exposer_t DubinsStateSpace_exposer = DubinsStateSpace_exposer_t( "DubinsStateSpace", bp::init< bp::optional< double, bool > >(( bp::arg("turningRadius")=1.0e+0, bp::arg("isSymmetric")=(bool)(false) )) );
        bp::scope DubinsStateSpace_scope( DubinsStateSpace_exposer );
        bp::implicitly_convertible< double, ompl::base::DubinsStateSpace >();
        { //::ompl::base::DubinsStateSpace::distance
        
            typedef double ( ::ompl::base::DubinsStateSpace::*distance_function_type )( ::ompl::base::State const *,::ompl::base::State const * ) const;
            typedef double ( DubinsStateSpace_wrapper::*default_distance_function_type )( ::ompl::base::State const *,::ompl::base::State const * ) const;
            
            DubinsStateSpace_exposer.def( 
                "distance"
                , distance_function_type(&::ompl::base::DubinsStateSpace::distance)
                , default_distance_function_type(&DubinsStateSpace_wrapper::default_distance)
                , ( bp::arg("state1"), bp::arg("state2") ) );
        
        }
        { //::ompl::base::DubinsStateSpace::hasSymmetricDistance
        
            typedef bool ( ::ompl::base::DubinsStateSpace::*hasSymmetricDistance_function_type )(  ) const;
            typedef bool ( DubinsStateSpace_wrapper::*default_hasSymmetricDistance_function_type )(  ) const;
            
            DubinsStateSpace_exposer.def( 
                "hasSymmetricDistance"
                , hasSymmetricDistance_function_type(&::ompl::base::DubinsStateSpace::hasSymmetricDistance)
                , default_hasSymmetricDistance_function_type(&DubinsStateSpace_wrapper::default_hasSymmetricDistance) );
        
        }
        { //::ompl::base::DubinsStateSpace::hasSymmetricInterpolate
        
            typedef bool ( ::ompl::base::DubinsStateSpace::*hasSymmetricInterpolate_function_type )(  ) const;
            typedef bool ( DubinsStateSpace_wrapper::*default_hasSymmetricInterpolate_function_type )(  ) const;
            
            DubinsStateSpace_exposer.def( 
                "hasSymmetricInterpolate"
                , hasSymmetricInterpolate_function_type(&::ompl::base::DubinsStateSpace::hasSymmetricInterpolate)
                , default_hasSymmetricInterpolate_function_type(&DubinsStateSpace_wrapper::default_hasSymmetricInterpolate) );
        
        }
        { //::ompl::base::DubinsStateSpace::interpolate
        
            typedef void ( ::ompl::base::DubinsStateSpace::*interpolate_function_type )( ::ompl::base::State const *,::ompl::base::State const *,double const,::ompl::base::State * ) const;
            typedef void ( DubinsStateSpace_wrapper::*default_interpolate_function_type )( ::ompl::base::State const *,::ompl::base::State const *,double const,::ompl::base::State * ) const;
            
            DubinsStateSpace_exposer.def( 
                "interpolate"
                , interpolate_function_type(&::ompl::base::DubinsStateSpace::interpolate)
                , default_interpolate_function_type(&DubinsStateSpace_wrapper::default_interpolate)
                , ( bp::arg("from"), bp::arg("to"), bp::arg("t"), bp::arg("state") ) );
        
        }
        { //::ompl::base::DubinsStateSpace::interpolate
        
            typedef void ( ::ompl::base::DubinsStateSpace::*interpolate_function_type )( ::ompl::base::State const *,::ompl::base::State const *,double const,bool &,::ompl::base::DubinsStateSpace::DubinsPath &,::ompl::base::State * ) const;
            typedef void ( DubinsStateSpace_wrapper::*default_interpolate_function_type )( ::ompl::base::State const *,::ompl::base::State const *,double const,bool &,::ompl::base::DubinsStateSpace::DubinsPath &,::ompl::base::State * ) const;
            
            DubinsStateSpace_exposer.def( 
                "interpolate"
                , interpolate_function_type(&::ompl::base::DubinsStateSpace::interpolate)
                , default_interpolate_function_type(&DubinsStateSpace_wrapper::default_interpolate)
                , ( bp::arg("from"), bp::arg("to"), bp::arg("t"), bp::arg("firstTime"), bp::arg("path"), bp::arg("state") ) );
        
        }
        { //::ompl::base::DubinsStateSpace::interpolate
        
            typedef void ( DubinsStateSpace_wrapper::*interpolate_function_type )( ::ompl::base::State const *,::ompl::base::DubinsStateSpace::DubinsPath const &,double const,::ompl::base::State * ) const;
            
            DubinsStateSpace_exposer.def( 
                "interpolate"
                , interpolate_function_type( &DubinsStateSpace_wrapper::default_interpolate )
                , ( bp::arg("from"), bp::arg("path"), bp::arg("t"), bp::arg("state") ) );
        
        }
        { //::ompl::base::DubinsStateSpace::isMetricSpace
        
            typedef bool ( ::ompl::base::DubinsStateSpace::*isMetricSpace_function_type )(  ) const;
            typedef bool ( DubinsStateSpace_wrapper::*default_isMetricSpace_function_type )(  ) const;
            
            DubinsStateSpace_exposer.def( 
                "isMetricSpace"
                , isMetricSpace_function_type(&::ompl::base::DubinsStateSpace::isMetricSpace)
                , default_isMetricSpace_function_type(&DubinsStateSpace_wrapper::default_isMetricSpace) );
        
        }
        { //::ompl::base::DubinsStateSpace::sanityChecks
        
            typedef void ( ::ompl::base::DubinsStateSpace::*sanityChecks_function_type )(  ) const;
            typedef void ( DubinsStateSpace_wrapper::*default_sanityChecks_function_type )(  ) const;
            
            DubinsStateSpace_exposer.def( 
                "sanityChecks"
                , sanityChecks_function_type(&::ompl::base::DubinsStateSpace::sanityChecks)
                , default_sanityChecks_function_type(&DubinsStateSpace_wrapper::default_sanityChecks) );
        
        }
        { //::ompl::base::CompoundStateSpace::allocDefaultStateSampler
        
            typedef ::ompl::base::StateSamplerPtr ( ::ompl::base::CompoundStateSpace::*allocDefaultStateSampler_function_type )(  ) const;
            typedef ::ompl::base::StateSamplerPtr ( DubinsStateSpace_wrapper::*default_allocDefaultStateSampler_function_type )(  ) const;
            
            DubinsStateSpace_exposer.def( 
                "allocDefaultStateSampler"
                , allocDefaultStateSampler_function_type(&::ompl::base::CompoundStateSpace::allocDefaultStateSampler)
                , default_allocDefaultStateSampler_function_type(&DubinsStateSpace_wrapper::default_allocDefaultStateSampler) );
        
        }
        { //::ompl::base::SE2StateSpace::allocState
        
            typedef ::ompl::base::State * ( ::ompl::base::SE2StateSpace::*allocState_function_type )(  ) const;
            typedef ::ompl::base::State * ( DubinsStateSpace_wrapper::*default_allocState_function_type )(  ) const;
            
            DubinsStateSpace_exposer.def( 
                "allocState"
                , allocState_function_type(&::ompl::base::SE2StateSpace::allocState)
                , default_allocState_function_type(&DubinsStateSpace_wrapper::default_allocState)
                , bp::return_value_policy< bp::reference_existing_object >() );
        
        }
        { //::ompl::base::CompoundStateSpace::allocStateComponents
        
            typedef void ( DubinsStateSpace_wrapper::*allocStateComponents_function_type )( ::ompl::base::CompoundState * ) const;
            
            DubinsStateSpace_exposer.def( 
                "allocStateComponents"
                , allocStateComponents_function_type( &DubinsStateSpace_wrapper::allocStateComponents )
                , ( bp::arg("state") ) );
        
        }
        { //::ompl::base::StateSpace::allocStateSampler
        
            typedef ::ompl::base::StateSamplerPtr ( ::ompl::base::StateSpace::*allocStateSampler_function_type )(  ) const;
            typedef ::ompl::base::StateSamplerPtr ( DubinsStateSpace_wrapper::*default_allocStateSampler_function_type )(  ) const;
            
            DubinsStateSpace_exposer.def( 
                "allocStateSampler"
                , allocStateSampler_function_type(&::ompl::base::StateSpace::allocStateSampler)
                , default_allocStateSampler_function_type(&DubinsStateSpace_wrapper::default_allocStateSampler) );
        
        }
        { //::ompl::base::CompoundStateSpace::allocSubspaceStateSampler
        
            typedef ::ompl::base::StateSamplerPtr ( ::ompl::base::CompoundStateSpace::*allocSubspaceStateSampler_function_type )( ::ompl::base::StateSpace const * ) const;
            typedef ::ompl::base::StateSamplerPtr ( DubinsStateSpace_wrapper::*default_allocSubspaceStateSampler_function_type )( ::ompl::base::StateSpace const * ) const;
            
            DubinsStateSpace_exposer.def( 
                "allocSubspaceStateSampler"
                , allocSubspaceStateSampler_function_type(&::ompl::base::CompoundStateSpace::allocSubspaceStateSampler)
                , default_allocSubspaceStateSampler_function_type(&DubinsStateSpace_wrapper::default_allocSubspaceStateSampler)
                , ( bp::arg("subspace") ) );
        
        }
        { //::ompl::base::CompoundStateSpace::computeLocations
        
            typedef void ( ::ompl::base::CompoundStateSpace::*computeLocations_function_type )(  ) ;
            typedef void ( DubinsStateSpace_wrapper::*default_computeLocations_function_type )(  ) ;
            
            DubinsStateSpace_exposer.def( 
                "computeLocations"
                , computeLocations_function_type(&::ompl::base::CompoundStateSpace::computeLocations)
                , default_computeLocations_function_type(&DubinsStateSpace_wrapper::default_computeLocations) );
        
        }
        { //::ompl::base::CompoundStateSpace::copyState
        
            typedef void ( ::ompl::base::CompoundStateSpace::*copyState_function_type )( ::ompl::base::State *,::ompl::base::State const * ) const;
            typedef void ( DubinsStateSpace_wrapper::*default_copyState_function_type )( ::ompl::base::State *,::ompl::base::State const * ) const;
            
            DubinsStateSpace_exposer.def( 
                "copyState"
                , copyState_function_type(&::ompl::base::CompoundStateSpace::copyState)
                , default_copyState_function_type(&DubinsStateSpace_wrapper::default_copyState)
                , ( bp::arg("destination"), bp::arg("source") ) );
        
        }
        { //::ompl::base::CompoundStateSpace::deserialize
        
            typedef void ( ::ompl::base::CompoundStateSpace::*deserialize_function_type )( ::ompl::base::State *,void const * ) const;
            typedef void ( DubinsStateSpace_wrapper::*default_deserialize_function_type )( ::ompl::base::State *,void const * ) const;
            
            DubinsStateSpace_exposer.def( 
                "deserialize"
                , deserialize_function_type(&::ompl::base::CompoundStateSpace::deserialize)
                , default_deserialize_function_type(&DubinsStateSpace_wrapper::default_deserialize)
                , ( bp::arg("state"), bp::arg("serialization") ) );
        
        }
        { //::ompl::base::CompoundStateSpace::enforceBounds
        
            typedef void ( ::ompl::base::CompoundStateSpace::*enforceBounds_function_type )( ::ompl::base::State * ) const;
            typedef void ( DubinsStateSpace_wrapper::*default_enforceBounds_function_type )( ::ompl::base::State * ) const;
            
            DubinsStateSpace_exposer.def( 
                "enforceBounds"
                , enforceBounds_function_type(&::ompl::base::CompoundStateSpace::enforceBounds)
                , default_enforceBounds_function_type(&DubinsStateSpace_wrapper::default_enforceBounds)
                , ( bp::arg("state") ) );
        
        }
        { //::ompl::base::CompoundStateSpace::equalStates
        
            typedef bool ( ::ompl::base::CompoundStateSpace::*equalStates_function_type )( ::ompl::base::State const *,::ompl::base::State const * ) const;
            typedef bool ( DubinsStateSpace_wrapper::*default_equalStates_function_type )( ::ompl::base::State const *,::ompl::base::State const * ) const;
            
            DubinsStateSpace_exposer.def( 
                "equalStates"
                , equalStates_function_type(&::ompl::base::CompoundStateSpace::equalStates)
                , default_equalStates_function_type(&DubinsStateSpace_wrapper::default_equalStates)
                , ( bp::arg("state1"), bp::arg("state2") ) );
        
        }
        { //::ompl::base::SE2StateSpace::freeState
        
            typedef void ( ::ompl::base::SE2StateSpace::*freeState_function_type )( ::ompl::base::State * ) const;
            typedef void ( DubinsStateSpace_wrapper::*default_freeState_function_type )( ::ompl::base::State * ) const;
            
            DubinsStateSpace_exposer.def( 
                "freeState"
                , freeState_function_type(&::ompl::base::SE2StateSpace::freeState)
                , default_freeState_function_type(&DubinsStateSpace_wrapper::default_freeState)
                , ( bp::arg("state") ) );
        
        }
        { //::ompl::base::CompoundStateSpace::getDimension
        
            typedef unsigned int ( ::ompl::base::CompoundStateSpace::*getDimension_function_type )(  ) const;
            typedef unsigned int ( DubinsStateSpace_wrapper::*default_getDimension_function_type )(  ) const;
            
            DubinsStateSpace_exposer.def( 
                "getDimension"
                , getDimension_function_type(&::ompl::base::CompoundStateSpace::getDimension)
                , default_getDimension_function_type(&DubinsStateSpace_wrapper::default_getDimension) );
        
        }
        { //::ompl::base::StateSpace::getLongestValidSegmentFraction
        
            typedef double ( ::ompl::base::StateSpace::*getLongestValidSegmentFraction_function_type )(  ) const;
            typedef double ( DubinsStateSpace_wrapper::*default_getLongestValidSegmentFraction_function_type )(  ) const;
            
            DubinsStateSpace_exposer.def( 
                "getLongestValidSegmentFraction"
                , getLongestValidSegmentFraction_function_type(&::ompl::base::StateSpace::getLongestValidSegmentFraction)
                , default_getLongestValidSegmentFraction_function_type(&DubinsStateSpace_wrapper::default_getLongestValidSegmentFraction) );
        
        }
        { //::ompl::base::CompoundStateSpace::getMaximumExtent
        
            typedef double ( ::ompl::base::CompoundStateSpace::*getMaximumExtent_function_type )(  ) const;
            typedef double ( DubinsStateSpace_wrapper::*default_getMaximumExtent_function_type )(  ) const;
            
            DubinsStateSpace_exposer.def( 
                "getMaximumExtent"
                , getMaximumExtent_function_type(&::ompl::base::CompoundStateSpace::getMaximumExtent)
                , default_getMaximumExtent_function_type(&DubinsStateSpace_wrapper::default_getMaximumExtent) );
        
        }
        { //::ompl::base::CompoundStateSpace::getMeasure
        
            typedef double ( ::ompl::base::CompoundStateSpace::*getMeasure_function_type )(  ) const;
            typedef double ( DubinsStateSpace_wrapper::*default_getMeasure_function_type )(  ) const;
            
            DubinsStateSpace_exposer.def( 
                "getMeasure"
                , getMeasure_function_type(&::ompl::base::CompoundStateSpace::getMeasure)
                , default_getMeasure_function_type(&DubinsStateSpace_wrapper::default_getMeasure) );
        
        }
        { //::ompl::base::CompoundStateSpace::getSerializationLength
        
            typedef unsigned int ( ::ompl::base::CompoundStateSpace::*getSerializationLength_function_type )(  ) const;
            typedef unsigned int ( DubinsStateSpace_wrapper::*default_getSerializationLength_function_type )(  ) const;
            
            DubinsStateSpace_exposer.def( 
                "getSerializationLength"
                , getSerializationLength_function_type(&::ompl::base::CompoundStateSpace::getSerializationLength)
                , default_getSerializationLength_function_type(&DubinsStateSpace_wrapper::default_getSerializationLength) );
        
        }
        { //::ompl::base::CompoundStateSpace::isCompound
        
            typedef bool ( ::ompl::base::CompoundStateSpace::*isCompound_function_type )(  ) const;
            typedef bool ( DubinsStateSpace_wrapper::*default_isCompound_function_type )(  ) const;
            
            DubinsStateSpace_exposer.def( 
                "isCompound"
                , isCompound_function_type(&::ompl::base::CompoundStateSpace::isCompound)
                , default_isCompound_function_type(&DubinsStateSpace_wrapper::default_isCompound) );
        
        }
        { //::ompl::base::StateSpace::isDiscrete
        
            typedef bool ( ::ompl::base::StateSpace::*isDiscrete_function_type )(  ) const;
            typedef bool ( DubinsStateSpace_wrapper::*default_isDiscrete_function_type )(  ) const;
            
            DubinsStateSpace_exposer.def( 
                "isDiscrete"
                , isDiscrete_function_type(&::ompl::base::StateSpace::isDiscrete)
                , default_isDiscrete_function_type(&DubinsStateSpace_wrapper::default_isDiscrete) );
        
        }
        { //::ompl::base::CompoundStateSpace::isHybrid
        
            typedef bool ( ::ompl::base::CompoundStateSpace::*isHybrid_function_type )(  ) const;
            typedef bool ( DubinsStateSpace_wrapper::*default_isHybrid_function_type )(  ) const;
            
            DubinsStateSpace_exposer.def( 
                "isHybrid"
                , isHybrid_function_type(&::ompl::base::CompoundStateSpace::isHybrid)
                , default_isHybrid_function_type(&DubinsStateSpace_wrapper::default_isHybrid) );
        
        }
        { //::ompl::base::SE2StateSpace::registerProjections
        
            typedef void ( ::ompl::base::SE2StateSpace::*registerProjections_function_type )(  ) ;
            typedef void ( DubinsStateSpace_wrapper::*default_registerProjections_function_type )(  ) ;
            
            DubinsStateSpace_exposer.def( 
                "registerProjections"
                , registerProjections_function_type(&::ompl::base::SE2StateSpace::registerProjections)
                , default_registerProjections_function_type(&DubinsStateSpace_wrapper::default_registerProjections) );
        
        }
        { //::ompl::base::StateSpace::sanityChecks
        
            typedef void ( ::ompl::base::StateSpace::*sanityChecks_function_type )( double,double,unsigned int ) const;
            typedef void ( DubinsStateSpace_wrapper::*default_sanityChecks_function_type )( double,double,unsigned int ) const;
            
            DubinsStateSpace_exposer.def( 
                "sanityChecks"
                , sanityChecks_function_type(&::ompl::base::StateSpace::sanityChecks)
                , default_sanityChecks_function_type(&DubinsStateSpace_wrapper::default_sanityChecks)
                , ( bp::arg("zero"), bp::arg("eps"), bp::arg("flags") ) );
        
        }
        { //::ompl::base::CompoundStateSpace::satisfiesBounds
        
            typedef bool ( ::ompl::base::CompoundStateSpace::*satisfiesBounds_function_type )( ::ompl::base::State const * ) const;
            typedef bool ( DubinsStateSpace_wrapper::*default_satisfiesBounds_function_type )( ::ompl::base::State const * ) const;
            
            DubinsStateSpace_exposer.def( 
                "satisfiesBounds"
                , satisfiesBounds_function_type(&::ompl::base::CompoundStateSpace::satisfiesBounds)
                , default_satisfiesBounds_function_type(&DubinsStateSpace_wrapper::default_satisfiesBounds)
                , ( bp::arg("state") ) );
        
        }
        { //::ompl::base::CompoundStateSpace::serialize
        
            typedef void ( ::ompl::base::CompoundStateSpace::*serialize_function_type )( void *,::ompl::base::State const * ) const;
            typedef void ( DubinsStateSpace_wrapper::*default_serialize_function_type )( void *,::ompl::base::State const * ) const;
            
            DubinsStateSpace_exposer.def( 
                "serialize"
                , serialize_function_type(&::ompl::base::CompoundStateSpace::serialize)
                , default_serialize_function_type(&DubinsStateSpace_wrapper::default_serialize)
                , ( bp::arg("serialization"), bp::arg("state") ) );
        
        }
        { //::ompl::base::CompoundStateSpace::setLongestValidSegmentFraction
        
            typedef void ( ::ompl::base::CompoundStateSpace::*setLongestValidSegmentFraction_function_type )( double ) ;
            typedef void ( DubinsStateSpace_wrapper::*default_setLongestValidSegmentFraction_function_type )( double ) ;
            
            DubinsStateSpace_exposer.def( 
                "setLongestValidSegmentFraction"
                , setLongestValidSegmentFraction_function_type(&::ompl::base::CompoundStateSpace::setLongestValidSegmentFraction)
                , default_setLongestValidSegmentFraction_function_type(&DubinsStateSpace_wrapper::default_setLongestValidSegmentFraction)
                , ( bp::arg("segmentFraction") ) );
        
        }
        { //::ompl::base::CompoundStateSpace::setup
        
            typedef void ( ::ompl::base::CompoundStateSpace::*setup_function_type )(  ) ;
            typedef void ( DubinsStateSpace_wrapper::*default_setup_function_type )(  ) ;
            
            DubinsStateSpace_exposer.def( 
                "setup"
                , setup_function_type(&::ompl::base::CompoundStateSpace::setup)
                , default_setup_function_type(&DubinsStateSpace_wrapper::default_setup) );
        
        }
        { //::ompl::base::CompoundStateSpace::validSegmentCount
        
            typedef unsigned int ( ::ompl::base::CompoundStateSpace::*validSegmentCount_function_type )( ::ompl::base::State const *,::ompl::base::State const * ) const;
            typedef unsigned int ( DubinsStateSpace_wrapper::*default_validSegmentCount_function_type )( ::ompl::base::State const *,::ompl::base::State const * ) const;
            
            DubinsStateSpace_exposer.def( 
                "validSegmentCount"
                , validSegmentCount_function_type(&::ompl::base::CompoundStateSpace::validSegmentCount)
                , default_validSegmentCount_function_type(&DubinsStateSpace_wrapper::default_validSegmentCount)
                , ( bp::arg("state1"), bp::arg("state2") ) );
        
        }
    }

}
