#!/bin/bash

#-------------------------------------------------------
#  generator for xmp_coarray_getsub.h
#  *** OPTIMIZATION ROUTINE ***
#-------------------------------------------------------

#--------------------
#  sub
#--------------------
echo72 () {
    str="$1                                                                        "
    str=`echo "$str" | cut -c -72`"&"
    echo "$str"
}

print_subroutine_scalar() {
    tk="$1"
    typekind="$2"

    echo   '!-----------------------------------------------------------------------'
    echo   "      subroutine xmpf_coarray_getsub0d_${tk}(descptr, coindex, mold, dst)"
    echo   '!-----------------------------------------------------------------------'
    echo   '      integer(8), intent(in) :: descptr'
    echo   '      integer, intent(in) :: coindex'
    echo   "      ${typekind}, intent(in) :: mold, dst"
    echo   '      end subroutine'
    echo   ''
}


print_subroutine_array() {
    tk="$1"
    typekind="$2"

    echo    '!-----------------------------------------------------------------------'
    echo    "      subroutine xmpf_coarray_getsub${DIM}d_${tk}(descptr, coindex, mold, dst)"
    echo    '!-----------------------------------------------------------------------'
    echo    '      integer(8), intent(in) :: descptr'
    echo    '      integer, intent(in) :: coindex'

    echo -n "      ${typekind}, intent(in) :: mold("
    sep=''
    for i in `seq 1 ${DIM}`; do
        echo -n "${sep}:"
        sep=','
    done
    echo    ')'

    echo -n "      ${typekind}, intent(in) :: dst("
    sep=''
    for i in `seq 1 ${DIM}`; do
        echo -n "${sep}:"
        sep=','
    done
    echo    ')'

    echo    '      end subroutine'
    echo   ''
}


print_subroutine() {
    case ${DIM} in
        0) print_subroutine_scalar "$@" ;;
        *) print_subroutine_array  "$@" ;;
    esac
}


#--------------------
#  main
#--------------------
TARGET=$1

echo "!! This file is automatically generated by $0"
echo '!! GETSUB INTERFACE (OPTIMIZATION)'
echo '!!'
echo '!! RESTRICTIONS in XMP/F'
echo '!!  - Quadruple precision real and complex are not supported.'
echo '!!  - The number of array dimensions cannot exceed 7.'
echo '!!'
echo ''
echo '      interface xmpf_coarray_getsub_generic'
echo ''

for DIM in `seq 0 7`
do
    if test "sxace-nec-superux" != "$TARGET"; then    ## integer(2) cannot be used on SX-ACE
	print_subroutine i2  "integer(2)"
    fi
    print_subroutine i4  "integer(4)"      
    print_subroutine i8  "integer(8)"
    if test "sxace-nec-superux" != "$TARGET"; then    ## logical(2) cannot be used on SX-ACE
	print_subroutine l2  "logical(2)"
    fi
    print_subroutine l4  "logical(4)"      
    print_subroutine l8  "logical(8)"      
    print_subroutine r4  "real(4)"         
    print_subroutine r8  "real(8)"         
    print_subroutine z8  "complex(4)"      
    print_subroutine z16 "complex(8)"      
    print_subroutine cn  "character(*)" 
done

echo '      end interface'
echo ''

exit
