MODULE ISO_FORTRAN_ENV
  TYPE LOCK_TYPE
  END type LOCK_TYPE
  INTEGER, PARAMETER :: ATOMIC_INT_KIND = 8
  INTEGER, PARAMETER :: ATOMIC_LOGICAL_KIND = 8

  INTEGER, PARAMETER :: CHARACTER_STORAGE_SIZE = 8
  INTEGER, PARAMETER :: ERROR_UNIT = 0
  INTEGER, PARAMETER :: FILE_STORAGE_SIZE = 8
  INTEGER, PARAMETER :: INPUT_UNIT = 5
  INTEGER, PARAMETER :: IOSTAT_END = -1
  INTEGER, PARAMETER :: IOSTAT_EOR = -2
  INTEGER, PARAMETER :: NUMERIC_STORAGE_SIZE = 32
  INTEGER, PARAMETER :: OUTPUT_UNIT = 6
  INTEGER, PARAMETER :: IOSTAT_INQUIRE_INTERNAL_UNIT = 99
    
  INTEGER, PARAMETER :: INT8 = 1
  INTEGER, PARAMETER :: INT16 = 2
  INTEGER, PARAMETER :: INT32 = 4
  INTEGER, PARAMETER :: INT64 = 8
  INTEGER, PARAMETER :: LOGICAL8 = 1
  INTEGER, PARAMETER :: LOGICAL16 = 2
  INTEGER, PARAMETER :: LOGICAL32 = 4
  INTEGER, PARAMETER :: LOGICAL64 = 8
  INTEGER, PARAMETER :: REAL32 = 4
  INTEGER, PARAMETER :: REAL64 = 8
  INTEGER, PARAMETER :: REAL128 = 16 
  INTEGER, PARAMETER :: INTEGER_KINDS(4) = (/INT8, INT16, INT32, INT64/)
  INTEGER, PARAMETER :: LOGICAL_KINDS(4) = (/LOGICAL8, LOGICAL16, LOGICAL32, LOGICAL64/)
  INTEGER, PARAMETER :: REAL_KINDS(3) =  (/REAL32, REAL64, REAL128/)

  ! Probably have to be adapted on the fly to the platform
  ! Just basics ones for a first draft
  INTEGER, PARAMETER :: C1 = SELECTED_CHAR_KIND('ascii')
  INTEGER, PARAMETER :: C2 = SELECTED_CHAR_KIND('JIS_0213')
  INTEGER, PARAMETER :: C3 = SELECTED_CHAR_KIND('UCS_2')
  INTEGER, PARAMETER :: C4 = SELECTED_CHAR_KIND('ISO_10646')
  INTEGER, PARAMETER :: CHARACTER_KINDS(4) = (/C1, C2, C3, C4/)

  CONTAINS

  FUNCTION COMPILER_OPTIONS()
    CHARACTER(LEN=1) :: COMPILER_OPTIONS
  END FUNCTION COMPILER_OPTIONS

  FUNCTION COMPILER_VERSION()
    CHARACTER(LEN=1) :: COMPILER_VERSION
  END FUNCTION COMPILER_VERSION

END MODULE ISO_FORTRAN_ENV
