# XMP/C and XMP/Fortran
## Using GASNet for coarray, lock/unlock, and post/wait (local-view operations)
The Omni compiler uses GASNet for local-view operations, and also uses MPI library for global-view operations.
However, GASNet cannot use MPI communication except for mpi-conduit at the same time.
(In detail, please read a section "MPI Interoperability" in README of GASNet)

Therefore, when using both local-view and global-view operations at the same time,
XMP application may not be executed.
If you want to use both local-view and global-view operations in one application,
you need to use xmp_sync_all() or barrier directive to divide communication.

---
  /* ... local-view program ... */

  xmp_sync_all(&status);

  /* ... global-view program ... */

 #pragma xmp barrier

  /* ... local-view program ... */
---

## On the K computer, FX100, and FX10
* The number of coarrays in an application is 508 or less
* An application cannot be used in more than 82,944 processes
* Post tag value is between 0 and 14 (0 <= tag <= 14)

## The "in" and "out" clauses of the gmove directives
* The target of the gmove in/out directives must be declared as a module variable or
  a variable with the SAVE attribute in XMP/F, or as an external variable in XMP/C

## Support only 64-bit compiler
The Omni compiler assumes that it is compiled with a 64-bit compiler.

## Maximum number of dimensions of XMP/Fortran array
In XMP/Fortran, number of dimensions of arrays is up to 7.

# How to use Fortran module file from XMP/Fortran program
To use a Fortran module file (*.mod),
the omni compiler should create an XMP/Fortran module file (*.xmod) from the Fortran module file.
The XMP/Fortran module file is a particular file for using the Fortran module file.

To create the XMP/Fortran module file, the omni compiler provides "T_Module" command.
The T_Module command supports the Fortran module file generated by gfortran-4.4, 4.7, and 4.9.
To build the T_Module command, you add "--enable-mod2xmod" option to "./configure".
Note that the build process of T_Module needs "mpfr" and "gmp".

```
$ ./configure --enable-mod2xmod
```

For example, to generate "test.xmod" from "test.mod", you execute as follows.

```
$ T_module test.mod
```
