/*
 * The Relaxer artifact
 * Copyright (c) 2000-2003, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package xcodeml.f.binding.gen;

import xcodeml.binding.*;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>XbfFselectCaseStatement</b> is generated from XcodeML_F.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element java:extends="xcodeml.f.XmfObj" java:implements="xcodeml.binding.IXbStatement" name="FselectCaseStatement">
 *   <ref name="defAttrSourceLine"/>
 *   <ref name="defAttrConstructName"/>
 *   <ref name="value"/>
 *   <zeroOrMore>
 *     <ref name="FcaseLabel"/>
 *   </zeroOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element java:extends="xcodeml.f.XmfObj" java:implements="xcodeml.binding.IXbStatement" name="FselectCaseStatement"&gt;
 *   &lt;ref name="defAttrSourceLine"/&gt;
 *   &lt;ref name="defAttrConstructName"/&gt;
 *   &lt;ref name="value"/&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="FcaseLabel"/&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version XcodeML_F.rng (Mon Jan 23 20:53:33 JST 2012)
 * @author  Relaxer 1.0 (http://www.relaxer.org)
 */
public class XbfFselectCaseStatement extends xcodeml.f.XmfObj implements java.io.Serializable, Cloneable, xcodeml.binding.IXbStatement, IRVisitable, IRNode, IXbfDefModelStatementChoice {
    private String lineno_;
    private String endlineno_;
    private String rawlineno_;
    private String file_;
    private String constructName_;
    private XbfValue value_;
    // List<XbfFcaseLabel>
    private java.util.List fcaseLabel_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>XbfFselectCaseStatement</code>.
     *
     */
    public XbfFselectCaseStatement() {
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code>.
     *
     * @param source
     */
    public XbfFselectCaseStatement(XbfFselectCaseStatement source) {
        setup(source);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public XbfFselectCaseStatement(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public XbfFselectCaseStatement(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public XbfFselectCaseStatement(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public XbfFselectCaseStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public XbfFselectCaseStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public XbfFselectCaseStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public XbfFselectCaseStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public XbfFselectCaseStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>XbfFselectCaseStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public XbfFselectCaseStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>XbfFselectCaseStatement</code> by the XbfFselectCaseStatement <code>source</code>.
     *
     * @param source
     */
    public void setup(XbfFselectCaseStatement source) {
        int size;
        setLineno(source.getLineno());
        setEndlineno(source.getEndlineno());
        setRawlineno(source.getRawlineno());
        setFile(source.getFile());
        setConstructName(source.getConstructName());
        if (source.value_ != null) {
            setValue((XbfValue)source.getValue().clone());
        }
        this.fcaseLabel_.clear();
        size = source.fcaseLabel_.size();
        for (int i = 0;i < size;i++) {
            addFcaseLabel((XbfFcaseLabel)source.getFcaseLabel(i).clone());
        }
    }

    /**
     * Initializes the <code>XbfFselectCaseStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>XbfFselectCaseStatement</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>XbfFselectCaseStatement</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IXcodeML_FFactory factory = XcodeML_FFactory.getFactory();
        RStack stack = new RStack(element);
        lineno_ = URelaxer.getAttributePropertyAsString(element, "lineno");
        endlineno_ = URelaxer.getAttributePropertyAsString(element, "endlineno");
        rawlineno_ = URelaxer.getAttributePropertyAsString(element, "rawlineno");
        file_ = URelaxer.getAttributePropertyAsString(element, "file");
        constructName_ = URelaxer.getAttributePropertyAsString(element, "construct_name");
        setValue(factory.createXbfValue(stack));
        fcaseLabel_.clear();
        while (true) {
            if (XbfFcaseLabel.isMatch(stack)) {
                addFcaseLabel(factory.createXbfFcaseLabel(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        IXcodeML_FFactory factory = XcodeML_FFactory.getFactory();
        return (factory.createXbfFselectCaseStatement(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("FselectCaseStatement");
        int size;
        if (this.lineno_ != null) {
            URelaxer.setAttributePropertyByString(element, "lineno", this.lineno_);
        }
        if (this.endlineno_ != null) {
            URelaxer.setAttributePropertyByString(element, "endlineno", this.endlineno_);
        }
        if (this.rawlineno_ != null) {
            URelaxer.setAttributePropertyByString(element, "rawlineno", this.rawlineno_);
        }
        if (this.file_ != null) {
            URelaxer.setAttributePropertyByString(element, "file", this.file_);
        }
        if (this.constructName_ != null) {
            URelaxer.setAttributePropertyByString(element, "construct_name", this.constructName_);
        }
        this.value_.makeElement(element);
        size = this.fcaseLabel_.size();
        for (int i = 0;i < size;i++) {
            XbfFcaseLabel value = (XbfFcaseLabel)this.fcaseLabel_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>XbfFselectCaseStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>XbfFselectCaseStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>XbfFselectCaseStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>XbfFselectCaseStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>XbfFselectCaseStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>XbfFselectCaseStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>lineno</b>.
     *
     * @return String
     */
    public final String getLineno() {
        return (lineno_);
    }

    /**
     * Sets the String property <b>lineno</b>.
     *
     * @param lineno
     */
    public final void setLineno(String lineno) {
        this.lineno_ = lineno;
    }

    /**
     * Gets the String property <b>endlineno</b>.
     *
     * @return String
     */
    public final String getEndlineno() {
        return (endlineno_);
    }

    /**
     * Sets the String property <b>endlineno</b>.
     *
     * @param endlineno
     */
    public final void setEndlineno(String endlineno) {
        this.endlineno_ = endlineno;
    }

    /**
     * Gets the String property <b>rawlineno</b>.
     *
     * @return String
     */
    public final String getRawlineno() {
        return (rawlineno_);
    }

    /**
     * Sets the String property <b>rawlineno</b>.
     *
     * @param rawlineno
     */
    public final void setRawlineno(String rawlineno) {
        this.rawlineno_ = rawlineno;
    }

    /**
     * Gets the String property <b>file</b>.
     *
     * @return String
     */
    public final String getFile() {
        return (file_);
    }

    /**
     * Sets the String property <b>file</b>.
     *
     * @param file
     */
    public final void setFile(String file) {
        this.file_ = file;
    }

    /**
     * Gets the String property <b>constructName</b>.
     *
     * @return String
     */
    public final String getConstructName() {
        return (constructName_);
    }

    /**
     * Sets the String property <b>constructName</b>.
     *
     * @param constructName
     */
    public final void setConstructName(String constructName) {
        this.constructName_ = constructName;
    }

    /**
     * Gets the XbfValue property <b>value</b>.
     *
     * @return XbfValue
     */
    public final XbfValue getValue() {
        return (value_);
    }

    /**
     * Sets the XbfValue property <b>value</b>.
     *
     * @param value
     */
    public final void setValue(XbfValue value) {
        this.value_ = value;
        if (value != null) {
            value.rSetParentRNode(this);
        }
    }

    /**
     * Gets the XbfFcaseLabel property <b>FcaseLabel</b>.
     *
     * @return XbfFcaseLabel[]
     */
    public final XbfFcaseLabel[] getFcaseLabel() {
        XbfFcaseLabel[] array = new XbfFcaseLabel[fcaseLabel_.size()];
        return ((XbfFcaseLabel[])fcaseLabel_.toArray(array));
    }

    /**
     * Sets the XbfFcaseLabel property <b>FcaseLabel</b>.
     *
     * @param fcaseLabel
     */
    public final void setFcaseLabel(XbfFcaseLabel[] fcaseLabel) {
        this.fcaseLabel_.clear();
        for (int i = 0;i < fcaseLabel.length;i++) {
            addFcaseLabel(fcaseLabel[i]);
        }
        for (int i = 0;i < fcaseLabel.length;i++) {
            fcaseLabel[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the XbfFcaseLabel property <b>FcaseLabel</b>.
     *
     * @param fcaseLabel
     */
    public final void setFcaseLabel(XbfFcaseLabel fcaseLabel) {
        this.fcaseLabel_.clear();
        addFcaseLabel(fcaseLabel);
        if (fcaseLabel != null) {
            fcaseLabel.rSetParentRNode(this);
        }
    }

    /**
     * Adds the XbfFcaseLabel property <b>FcaseLabel</b>.
     *
     * @param fcaseLabel
     */
    public final void addFcaseLabel(XbfFcaseLabel fcaseLabel) {
        this.fcaseLabel_.add(fcaseLabel);
        if (fcaseLabel != null) {
            fcaseLabel.rSetParentRNode(this);
        }
    }

    /**
     * Adds the XbfFcaseLabel property <b>FcaseLabel</b>.
     *
     * @param fcaseLabel
     */
    public final void addFcaseLabel(XbfFcaseLabel[] fcaseLabel) {
        for (int i = 0;i < fcaseLabel.length;i++) {
            addFcaseLabel(fcaseLabel[i]);
        }
        for (int i = 0;i < fcaseLabel.length;i++) {
            fcaseLabel[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the XbfFcaseLabel property <b>FcaseLabel</b>.
     *
     * @return int
     */
    public final int sizeFcaseLabel() {
        return (fcaseLabel_.size());
    }

    /**
     * Gets the XbfFcaseLabel property <b>FcaseLabel</b> by index.
     *
     * @param index
     * @return XbfFcaseLabel
     */
    public final XbfFcaseLabel getFcaseLabel(int index) {
        return ((XbfFcaseLabel)fcaseLabel_.get(index));
    }

    /**
     * Sets the XbfFcaseLabel property <b>FcaseLabel</b> by index.
     *
     * @param index
     * @param fcaseLabel
     */
    public final void setFcaseLabel(int index, XbfFcaseLabel fcaseLabel) {
        this.fcaseLabel_.set(index, fcaseLabel);
        if (fcaseLabel != null) {
            fcaseLabel.rSetParentRNode(this);
        }
    }

    /**
     * Adds the XbfFcaseLabel property <b>FcaseLabel</b> by index.
     *
     * @param index
     * @param fcaseLabel
     */
    public final void addFcaseLabel(int index, XbfFcaseLabel fcaseLabel) {
        this.fcaseLabel_.add(index, fcaseLabel);
        if (fcaseLabel != null) {
            fcaseLabel.rSetParentRNode(this);
        }
    }

    /**
     * Remove the XbfFcaseLabel property <b>FcaseLabel</b> by index.
     *
     * @param index
     */
    public final void removeFcaseLabel(int index) {
        this.fcaseLabel_.remove(index);
    }

    /**
     * Remove the XbfFcaseLabel property <b>FcaseLabel</b> by object.
     *
     * @param fcaseLabel
     */
    public final void removeFcaseLabel(XbfFcaseLabel fcaseLabel) {
        this.fcaseLabel_.remove(fcaseLabel);
    }

    /**
     * Clear the XbfFcaseLabel property <b>FcaseLabel</b>.
     *
     */
    public final void clearFcaseLabel() {
        this.fcaseLabel_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<FselectCaseStatement");
        if (lineno_ != null) {
            buffer.append(" lineno=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getLineno())));
            buffer.append("\"");
        }
        if (endlineno_ != null) {
            buffer.append(" endlineno=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getEndlineno())));
            buffer.append("\"");
        }
        if (rawlineno_ != null) {
            buffer.append(" rawlineno=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getRawlineno())));
            buffer.append("\"");
        }
        if (file_ != null) {
            buffer.append(" file=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getFile())));
            buffer.append("\"");
        }
        if (constructName_ != null) {
            buffer.append(" construct_name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getConstructName())));
            buffer.append("\"");
        }
        buffer.append(">");
        value_.makeTextElement(buffer);
        size = this.fcaseLabel_.size();
        for (int i = 0;i < size;i++) {
            XbfFcaseLabel value = (XbfFcaseLabel)this.fcaseLabel_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</FselectCaseStatement>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<FselectCaseStatement");
        if (lineno_ != null) {
            buffer.write(" lineno=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getLineno())));
            buffer.write("\"");
        }
        if (endlineno_ != null) {
            buffer.write(" endlineno=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getEndlineno())));
            buffer.write("\"");
        }
        if (rawlineno_ != null) {
            buffer.write(" rawlineno=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getRawlineno())));
            buffer.write("\"");
        }
        if (file_ != null) {
            buffer.write(" file=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getFile())));
            buffer.write("\"");
        }
        if (constructName_ != null) {
            buffer.write(" construct_name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getConstructName())));
            buffer.write("\"");
        }
        buffer.write(">");
        value_.makeTextElement(buffer);
        size = this.fcaseLabel_.size();
        for (int i = 0;i < size;i++) {
            XbfFcaseLabel value = (XbfFcaseLabel)this.fcaseLabel_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</FselectCaseStatement>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<FselectCaseStatement");
        if (lineno_ != null) {
            buffer.print(" lineno=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getLineno())));
            buffer.print("\"");
        }
        if (endlineno_ != null) {
            buffer.print(" endlineno=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getEndlineno())));
            buffer.print("\"");
        }
        if (rawlineno_ != null) {
            buffer.print(" rawlineno=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getRawlineno())));
            buffer.print("\"");
        }
        if (file_ != null) {
            buffer.print(" file=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getFile())));
            buffer.print("\"");
        }
        if (constructName_ != null) {
            buffer.print(" construct_name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getConstructName())));
            buffer.print("\"");
        }
        buffer.print(">");
        value_.makeTextElement(buffer);
        size = this.fcaseLabel_.size();
        for (int i = 0;i < size;i++) {
            XbfFcaseLabel value = (XbfFcaseLabel)this.fcaseLabel_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</FselectCaseStatement>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getLinenoAsString() {
        return (URelaxer.getString(getLineno()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getEndlinenoAsString() {
        return (URelaxer.getString(getEndlineno()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getRawlinenoAsString() {
        return (URelaxer.getString(getRawlineno()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFileAsString() {
        return (URelaxer.getString(getFile()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getConstructNameAsString() {
        return (URelaxer.getString(getConstructName()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setLinenoByString(String string) {
        setLineno(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setEndlinenoByString(String string) {
        setEndlineno(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setRawlinenoByString(String string) {
        setRawlineno(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFileByString(String string) {
        setFile(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setConstructNameByString(String string) {
        setConstructName(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        if (value_ != null) {
            classNodes.add(value_);
        }
        classNodes.addAll(fcaseLabel_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>XbfFselectCaseStatement</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "FselectCaseStatement")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!XbfValue.isMatchHungry(target)) {
            return (false);
        }
        $match$ = true;
        while (true) {
            if (!XbfFcaseLabel.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>XbfFselectCaseStatement</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>XbfFselectCaseStatement</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
