/*
 * The Relaxer artifact
 * Copyright (c) 2000-2003, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package xcodeml.f.binding.gen;

import xcodeml.binding.*;

/**
 * DefaultXcodeML_FFactory is generated by Relaxer based on XcodeML_F.rng.
 *
 * @version XcodeML_F.rng 1.0 (Mon Jan 23 20:53:33 JST 2012)
 * @author  Relaxer 1.0 (http://www.relaxer.org)
 */
public class DefaultXcodeML_FFactory extends AbstractXcodeML_FFactory {

    /**
     * Creates a default <code>XbfXcodeProgram</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfXcodeProgram
     */
    public XbfXcodeProgram createXbfXcodeProgram() {
        return (new XbfXcodeProgram());
    }

    /**
     * Creates a default <code>XbfTypeTable</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfTypeTable
     */
    public XbfTypeTable createXbfTypeTable() {
        return (new XbfTypeTable());
    }

    /**
     * Creates a default <code>XbfFfunctionType</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFfunctionType
     */
    public XbfFfunctionType createXbfFfunctionType() {
        return (new XbfFfunctionType());
    }

    /**
     * Creates a default <code>XbfParams</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfParams
     */
    public XbfParams createXbfParams() {
        return (new XbfParams());
    }

    /**
     * Creates a default <code>XbfName</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfName
     */
    public XbfName createXbfName() {
        return (new XbfName());
    }

    /**
     * Creates a default <code>XbfFbasicType</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFbasicType
     */
    public XbfFbasicType createXbfFbasicType() {
        return (new XbfFbasicType());
    }

    /**
     * Creates a default <code>XbfKind</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfKind
     */
    public XbfKind createXbfKind() {
        return (new XbfKind());
    }

    /**
     * Creates a default <code>XbfFarrayRef</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFarrayRef
     */
    public XbfFarrayRef createXbfFarrayRef() {
        return (new XbfFarrayRef());
    }

    /**
     * Creates a default <code>XbfVarRef</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfVarRef
     */
    public XbfVarRef createXbfVarRef() {
        return (new XbfVarRef());
    }

    /**
     * Creates a default <code>XbfFcharacterRef</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFcharacterRef
     */
    public XbfFcharacterRef createXbfFcharacterRef() {
        return (new XbfFcharacterRef());
    }

    /**
     * Creates a default <code>XbfIndexRange</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfIndexRange
     */
    public XbfIndexRange createXbfIndexRange() {
        return (new XbfIndexRange());
    }

    /**
     * Creates a default <code>XbfLowerBound</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfLowerBound
     */
    public XbfLowerBound createXbfLowerBound() {
        return (new XbfLowerBound());
    }

    /**
     * Creates a default <code>XbfUpperBound</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfUpperBound
     */
    public XbfUpperBound createXbfUpperBound() {
        return (new XbfUpperBound());
    }

    /**
     * Creates a default <code>XbfStep</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfStep
     */
    public XbfStep createXbfStep() {
        return (new XbfStep());
    }

    /**
     * Creates a default <code>XbfFmemberRef</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFmemberRef
     */
    public XbfFmemberRef createXbfFmemberRef() {
        return (new XbfFmemberRef());
    }

    /**
     * Creates a default <code>XbfFcoArrayRef</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFcoArrayRef
     */
    public XbfFcoArrayRef createXbfFcoArrayRef() {
        return (new XbfFcoArrayRef());
    }

    /**
     * Creates a default <code>XbfArrayIndex</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfArrayIndex
     */
    public XbfArrayIndex createXbfArrayIndex() {
        return (new XbfArrayIndex());
    }

    /**
     * Creates a default <code>XbfVar</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfVar
     */
    public XbfVar createXbfVar() {
        return (new XbfVar());
    }

    /**
     * Creates a default <code>XbfFarrayConstructor</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFarrayConstructor
     */
    public XbfFarrayConstructor createXbfFarrayConstructor() {
        return (new XbfFarrayConstructor());
    }

    /**
     * Creates a default <code>XbfFdoLoop</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFdoLoop
     */
    public XbfFdoLoop createXbfFdoLoop() {
        return (new XbfFdoLoop());
    }

    /**
     * Creates a default <code>XbfValue</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfValue
     */
    public XbfValue createXbfValue() {
        return (new XbfValue());
    }

    /**
     * Creates a default <code>XbfRepeatCount</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfRepeatCount
     */
    public XbfRepeatCount createXbfRepeatCount() {
        return (new XbfRepeatCount());
    }

    /**
     * Creates a default <code>XbfFintConstant</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFintConstant
     */
    public XbfFintConstant createXbfFintConstant() {
        return (new XbfFintConstant());
    }

    /**
     * Creates a default <code>XbfFrealConstant</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFrealConstant
     */
    public XbfFrealConstant createXbfFrealConstant() {
        return (new XbfFrealConstant());
    }

    /**
     * Creates a default <code>XbfFcharacterConstant</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFcharacterConstant
     */
    public XbfFcharacterConstant createXbfFcharacterConstant() {
        return (new XbfFcharacterConstant());
    }

    /**
     * Creates a default <code>XbfFlogicalConstant</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFlogicalConstant
     */
    public XbfFlogicalConstant createXbfFlogicalConstant() {
        return (new XbfFlogicalConstant());
    }

    /**
     * Creates a default <code>XbfFcomplexConstant</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFcomplexConstant
     */
    public XbfFcomplexConstant createXbfFcomplexConstant() {
        return (new XbfFcomplexConstant());
    }

    /**
     * Creates a default <code>XbfFstructConstructor</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFstructConstructor
     */
    public XbfFstructConstructor createXbfFstructConstructor() {
        return (new XbfFstructConstructor());
    }

    /**
     * Creates a default <code>XbfFunctionCall</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFunctionCall
     */
    public XbfFunctionCall createXbfFunctionCall() {
        return (new XbfFunctionCall());
    }

    /**
     * Creates a default <code>XbfArguments</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfArguments
     */
    public XbfArguments createXbfArguments() {
        return (new XbfArguments());
    }

    /**
     * Creates a default <code>XbfNamedValue</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfNamedValue
     */
    public XbfNamedValue createXbfNamedValue() {
        return (new XbfNamedValue());
    }

    /**
     * Creates a default <code>XbfUserUnaryExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfUserUnaryExpr
     */
    public XbfUserUnaryExpr createXbfUserUnaryExpr() {
        return (new XbfUserUnaryExpr());
    }

    /**
     * Creates a default <code>XbfUserBinaryExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfUserBinaryExpr
     */
    public XbfUserBinaryExpr createXbfUserBinaryExpr() {
        return (new XbfUserBinaryExpr());
    }

    /**
     * Creates a default <code>XbfLogNotExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfLogNotExpr
     */
    public XbfLogNotExpr createXbfLogNotExpr() {
        return (new XbfLogNotExpr());
    }

    /**
     * Creates a default <code>XbfFfunction</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFfunction
     */
    public XbfFfunction createXbfFfunction() {
        return (new XbfFfunction());
    }

    /**
     * Creates a default <code>XbfLogNEQExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfLogNEQExpr
     */
    public XbfLogNEQExpr createXbfLogNEQExpr() {
        return (new XbfLogNEQExpr());
    }

    /**
     * Creates a default <code>XbfLogGTExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfLogGTExpr
     */
    public XbfLogGTExpr createXbfLogGTExpr() {
        return (new XbfLogGTExpr());
    }

    /**
     * Creates a default <code>XbfLogNEQVExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfLogNEQVExpr
     */
    public XbfLogNEQVExpr createXbfLogNEQVExpr() {
        return (new XbfLogNEQVExpr());
    }

    /**
     * Creates a default <code>XbfPlusExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfPlusExpr
     */
    public XbfPlusExpr createXbfPlusExpr() {
        return (new XbfPlusExpr());
    }

    /**
     * Creates a default <code>XbfMinusExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfMinusExpr
     */
    public XbfMinusExpr createXbfMinusExpr() {
        return (new XbfMinusExpr());
    }

    /**
     * Creates a default <code>XbfMulExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfMulExpr
     */
    public XbfMulExpr createXbfMulExpr() {
        return (new XbfMulExpr());
    }

    /**
     * Creates a default <code>XbfDivExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfDivExpr
     */
    public XbfDivExpr createXbfDivExpr() {
        return (new XbfDivExpr());
    }

    /**
     * Creates a default <code>XbfFpowerExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFpowerExpr
     */
    public XbfFpowerExpr createXbfFpowerExpr() {
        return (new XbfFpowerExpr());
    }

    /**
     * Creates a default <code>XbfFconcatExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFconcatExpr
     */
    public XbfFconcatExpr createXbfFconcatExpr() {
        return (new XbfFconcatExpr());
    }

    /**
     * Creates a default <code>XbfLogEQExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfLogEQExpr
     */
    public XbfLogEQExpr createXbfLogEQExpr() {
        return (new XbfLogEQExpr());
    }

    /**
     * Creates a default <code>XbfLogGEExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfLogGEExpr
     */
    public XbfLogGEExpr createXbfLogGEExpr() {
        return (new XbfLogGEExpr());
    }

    /**
     * Creates a default <code>XbfLogLEExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfLogLEExpr
     */
    public XbfLogLEExpr createXbfLogLEExpr() {
        return (new XbfLogLEExpr());
    }

    /**
     * Creates a default <code>XbfLogLTExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfLogLTExpr
     */
    public XbfLogLTExpr createXbfLogLTExpr() {
        return (new XbfLogLTExpr());
    }

    /**
     * Creates a default <code>XbfLogAndExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfLogAndExpr
     */
    public XbfLogAndExpr createXbfLogAndExpr() {
        return (new XbfLogAndExpr());
    }

    /**
     * Creates a default <code>XbfLogOrExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfLogOrExpr
     */
    public XbfLogOrExpr createXbfLogOrExpr() {
        return (new XbfLogOrExpr());
    }

    /**
     * Creates a default <code>XbfLogEQVExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfLogEQVExpr
     */
    public XbfLogEQVExpr createXbfLogEQVExpr() {
        return (new XbfLogEQVExpr());
    }

    /**
     * Creates a default <code>XbfUnaryMinusExpr</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfUnaryMinusExpr
     */
    public XbfUnaryMinusExpr createXbfUnaryMinusExpr() {
        return (new XbfUnaryMinusExpr());
    }

    /**
     * Creates a default <code>XbfLen</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfLen
     */
    public XbfLen createXbfLen() {
        return (new XbfLen());
    }

    /**
     * Creates a default <code>XbfCoShape</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfCoShape
     */
    public XbfCoShape createXbfCoShape() {
        return (new XbfCoShape());
    }

    /**
     * Creates a default <code>XbfFstructType</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFstructType
     */
    public XbfFstructType createXbfFstructType() {
        return (new XbfFstructType());
    }

    /**
     * Creates a default <code>XbfSymbols</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfSymbols
     */
    public XbfSymbols createXbfSymbols() {
        return (new XbfSymbols());
    }

    /**
     * Creates a default <code>XbfId</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfId
     */
    public XbfId createXbfId() {
        return (new XbfId());
    }

    /**
     * Creates a default <code>XbfGlobalSymbols</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfGlobalSymbols
     */
    public XbfGlobalSymbols createXbfGlobalSymbols() {
        return (new XbfGlobalSymbols());
    }

    /**
     * Creates a default <code>XbfGlobalDeclarations</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfGlobalDeclarations
     */
    public XbfGlobalDeclarations createXbfGlobalDeclarations() {
        return (new XbfGlobalDeclarations());
    }

    /**
     * Creates a default <code>XbfFfunctionDefinition</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFfunctionDefinition
     */
    public XbfFfunctionDefinition createXbfFfunctionDefinition() {
        return (new XbfFfunctionDefinition());
    }

    /**
     * Creates a default <code>XbfDeclarations</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfDeclarations
     */
    public XbfDeclarations createXbfDeclarations() {
        return (new XbfDeclarations());
    }

    /**
     * Creates a default <code>XbfVarDecl</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfVarDecl
     */
    public XbfVarDecl createXbfVarDecl() {
        return (new XbfVarDecl());
    }

    /**
     * Creates a default <code>XbfExternDecl</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfExternDecl
     */
    public XbfExternDecl createXbfExternDecl() {
        return (new XbfExternDecl());
    }

    /**
     * Creates a default <code>XbfFuseDecl</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFuseDecl
     */
    public XbfFuseDecl createXbfFuseDecl() {
        return (new XbfFuseDecl());
    }

    /**
     * Creates a default <code>XbfRename</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfRename
     */
    public XbfRename createXbfRename() {
        return (new XbfRename());
    }

    /**
     * Creates a default <code>XbfFuseOnlyDecl</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFuseOnlyDecl
     */
    public XbfFuseOnlyDecl createXbfFuseOnlyDecl() {
        return (new XbfFuseOnlyDecl());
    }

    /**
     * Creates a default <code>XbfRenamable</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfRenamable
     */
    public XbfRenamable createXbfRenamable() {
        return (new XbfRenamable());
    }

    /**
     * Creates a default <code>XbfFinterfaceDecl</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFinterfaceDecl
     */
    public XbfFinterfaceDecl createXbfFinterfaceDecl() {
        return (new XbfFinterfaceDecl());
    }

    /**
     * Creates a default <code>XbfFfunctionDecl</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFfunctionDecl
     */
    public XbfFfunctionDecl createXbfFfunctionDecl() {
        return (new XbfFfunctionDecl());
    }

    /**
     * Creates a default <code>XbfFmoduleProcedureDecl</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFmoduleProcedureDecl
     */
    public XbfFmoduleProcedureDecl createXbfFmoduleProcedureDecl() {
        return (new XbfFmoduleProcedureDecl());
    }

    /**
     * Creates a default <code>XbfFnamelistDecl</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFnamelistDecl
     */
    public XbfFnamelistDecl createXbfFnamelistDecl() {
        return (new XbfFnamelistDecl());
    }

    /**
     * Creates a default <code>XbfVarList</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfVarList
     */
    public XbfVarList createXbfVarList() {
        return (new XbfVarList());
    }

    /**
     * Creates a default <code>XbfFequivalenceDecl</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFequivalenceDecl
     */
    public XbfFequivalenceDecl createXbfFequivalenceDecl() {
        return (new XbfFequivalenceDecl());
    }

    /**
     * Creates a default <code>XbfFcommonDecl</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFcommonDecl
     */
    public XbfFcommonDecl createXbfFcommonDecl() {
        return (new XbfFcommonDecl());
    }

    /**
     * Creates a default <code>XbfFstructDecl</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFstructDecl
     */
    public XbfFstructDecl createXbfFstructDecl() {
        return (new XbfFstructDecl());
    }

    /**
     * Creates a default <code>XbfFentryDecl</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFentryDecl
     */
    public XbfFentryDecl createXbfFentryDecl() {
        return (new XbfFentryDecl());
    }

    /**
     * Creates a default <code>XbfFdataDecl</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFdataDecl
     */
    public XbfFdataDecl createXbfFdataDecl() {
        return (new XbfFdataDecl());
    }

    /**
     * Creates a default <code>XbfValueList</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfValueList
     */
    public XbfValueList createXbfValueList() {
        return (new XbfValueList());
    }

    /**
     * Creates a default <code>XbfFpragmaStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFpragmaStatement
     */
    public XbfFpragmaStatement createXbfFpragmaStatement() {
        return (new XbfFpragmaStatement());
    }

    /**
     * Creates a default <code>XbfBody</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfBody
     */
    public XbfBody createXbfBody() {
        return (new XbfBody());
    }

    /**
     * Creates a default <code>XbfGotoStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfGotoStatement
     */
    public XbfGotoStatement createXbfGotoStatement() {
        return (new XbfGotoStatement());
    }

    /**
     * Creates a default <code>XbfFpauseStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFpauseStatement
     */
    public XbfFpauseStatement createXbfFpauseStatement() {
        return (new XbfFpauseStatement());
    }

    /**
     * Creates a default <code>XbfFcycleStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFcycleStatement
     */
    public XbfFcycleStatement createXbfFcycleStatement() {
        return (new XbfFcycleStatement());
    }

    /**
     * Creates a default <code>XbfFreadStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFreadStatement
     */
    public XbfFreadStatement createXbfFreadStatement() {
        return (new XbfFreadStatement());
    }

    /**
     * Creates a default <code>XbfNamedValueList</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfNamedValueList
     */
    public XbfNamedValueList createXbfNamedValueList() {
        return (new XbfNamedValueList());
    }

    /**
     * Creates a default <code>XbfFcloseStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFcloseStatement
     */
    public XbfFcloseStatement createXbfFcloseStatement() {
        return (new XbfFcloseStatement());
    }

    /**
     * Creates a default <code>XbfFopenStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFopenStatement
     */
    public XbfFopenStatement createXbfFopenStatement() {
        return (new XbfFopenStatement());
    }

    /**
     * Creates a default <code>XbfFassignStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFassignStatement
     */
    public XbfFassignStatement createXbfFassignStatement() {
        return (new XbfFassignStatement());
    }

    /**
     * Creates a default <code>XbfExprStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfExprStatement
     */
    public XbfExprStatement createXbfExprStatement() {
        return (new XbfExprStatement());
    }

    /**
     * Creates a default <code>XbfFpointerAssignStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFpointerAssignStatement
     */
    public XbfFpointerAssignStatement createXbfFpointerAssignStatement() {
        return (new XbfFpointerAssignStatement());
    }

    /**
     * Creates a default <code>XbfFifStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFifStatement
     */
    public XbfFifStatement createXbfFifStatement() {
        return (new XbfFifStatement());
    }

    /**
     * Creates a default <code>XbfCondition</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfCondition
     */
    public XbfCondition createXbfCondition() {
        return (new XbfCondition());
    }

    /**
     * Creates a default <code>XbfThen</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfThen
     */
    public XbfThen createXbfThen() {
        return (new XbfThen());
    }

    /**
     * Creates a default <code>XbfElse</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfElse
     */
    public XbfElse createXbfElse() {
        return (new XbfElse());
    }

    /**
     * Creates a default <code>XbfFdoStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFdoStatement
     */
    public XbfFdoStatement createXbfFdoStatement() {
        return (new XbfFdoStatement());
    }

    /**
     * Creates a default <code>XbfFdoWhileStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFdoWhileStatement
     */
    public XbfFdoWhileStatement createXbfFdoWhileStatement() {
        return (new XbfFdoWhileStatement());
    }

    /**
     * Creates a default <code>XbfContinueStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfContinueStatement
     */
    public XbfContinueStatement createXbfContinueStatement() {
        return (new XbfContinueStatement());
    }

    /**
     * Creates a default <code>XbfFexitStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFexitStatement
     */
    public XbfFexitStatement createXbfFexitStatement() {
        return (new XbfFexitStatement());
    }

    /**
     * Creates a default <code>XbfFreturnStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFreturnStatement
     */
    public XbfFreturnStatement createXbfFreturnStatement() {
        return (new XbfFreturnStatement());
    }

    /**
     * Creates a default <code>XbfStatementLabel</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfStatementLabel
     */
    public XbfStatementLabel createXbfStatementLabel() {
        return (new XbfStatementLabel());
    }

    /**
     * Creates a default <code>XbfFselectCaseStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFselectCaseStatement
     */
    public XbfFselectCaseStatement createXbfFselectCaseStatement() {
        return (new XbfFselectCaseStatement());
    }

    /**
     * Creates a default <code>XbfFcaseLabel</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFcaseLabel
     */
    public XbfFcaseLabel createXbfFcaseLabel() {
        return (new XbfFcaseLabel());
    }

    /**
     * Creates a default <code>XbfFwhereStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFwhereStatement
     */
    public XbfFwhereStatement createXbfFwhereStatement() {
        return (new XbfFwhereStatement());
    }

    /**
     * Creates a default <code>XbfFstopStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFstopStatement
     */
    public XbfFstopStatement createXbfFstopStatement() {
        return (new XbfFstopStatement());
    }

    /**
     * Creates a default <code>XbfFwriteStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFwriteStatement
     */
    public XbfFwriteStatement createXbfFwriteStatement() {
        return (new XbfFwriteStatement());
    }

    /**
     * Creates a default <code>XbfFprintStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFprintStatement
     */
    public XbfFprintStatement createXbfFprintStatement() {
        return (new XbfFprintStatement());
    }

    /**
     * Creates a default <code>XbfFrewindStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFrewindStatement
     */
    public XbfFrewindStatement createXbfFrewindStatement() {
        return (new XbfFrewindStatement());
    }

    /**
     * Creates a default <code>XbfFendFileStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFendFileStatement
     */
    public XbfFendFileStatement createXbfFendFileStatement() {
        return (new XbfFendFileStatement());
    }

    /**
     * Creates a default <code>XbfFbackspaceStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFbackspaceStatement
     */
    public XbfFbackspaceStatement createXbfFbackspaceStatement() {
        return (new XbfFbackspaceStatement());
    }

    /**
     * Creates a default <code>XbfFinquireStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFinquireStatement
     */
    public XbfFinquireStatement createXbfFinquireStatement() {
        return (new XbfFinquireStatement());
    }

    /**
     * Creates a default <code>XbfFformatDecl</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFformatDecl
     */
    public XbfFformatDecl createXbfFformatDecl() {
        return (new XbfFformatDecl());
    }

    /**
     * Creates a default <code>XbfFallocateStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFallocateStatement
     */
    public XbfFallocateStatement createXbfFallocateStatement() {
        return (new XbfFallocateStatement());
    }

    /**
     * Creates a default <code>XbfAlloc</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfAlloc
     */
    public XbfAlloc createXbfAlloc() {
        return (new XbfAlloc());
    }

    /**
     * Creates a default <code>XbfFdeallocateStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFdeallocateStatement
     */
    public XbfFdeallocateStatement createXbfFdeallocateStatement() {
        return (new XbfFdeallocateStatement());
    }

    /**
     * Creates a default <code>XbfFnullifyStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFnullifyStatement
     */
    public XbfFnullifyStatement createXbfFnullifyStatement() {
        return (new XbfFnullifyStatement());
    }

    /**
     * Creates a default <code>XbfFcontainsStatement</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFcontainsStatement
     */
    public XbfFcontainsStatement createXbfFcontainsStatement() {
        return (new XbfFcontainsStatement());
    }

    /**
     * Creates a default <code>XbfText</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfText
     */
    public XbfText createXbfText() {
        return (new XbfText());
    }

    /**
     * Creates a default <code>XbfFmoduleDefinition</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFmoduleDefinition
     */
    public XbfFmoduleDefinition createXbfFmoduleDefinition() {
        return (new XbfFmoduleDefinition());
    }

    /**
     * Creates a default <code>XbfFblockDataDefinition</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFblockDataDefinition
     */
    public XbfFblockDataDefinition createXbfFblockDataDefinition() {
        return (new XbfFblockDataDefinition());
    }

    /**
     * Creates a default <code>XbfDefModelArraySubscriptSequence1</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfDefModelArraySubscriptSequence1
     */
    public XbfDefModelArraySubscriptSequence1 createXbfDefModelArraySubscriptSequence1() {
        return (new XbfDefModelArraySubscriptSequence1());
    }

    /**
     * Creates a default <code>XbfFequivalenceDeclSequence</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFequivalenceDeclSequence
     */
    public XbfFequivalenceDeclSequence createXbfFequivalenceDeclSequence() {
        return (new XbfFequivalenceDeclSequence());
    }

    /**
     * Creates a default <code>XbfFdataDeclSequence</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFdataDeclSequence
     */
    public XbfFdataDeclSequence createXbfFdataDeclSequence() {
        return (new XbfFdataDeclSequence());
    }

    /**
     * Creates a default <code>XbfGotoStatementSequence</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfGotoStatementSequence
     */
    public XbfGotoStatementSequence createXbfGotoStatementSequence() {
        return (new XbfGotoStatementSequence());
    }

    /**
     * Creates a default <code>XbfFdoStatementSequence</code>.
     * This method is a hook method of the AbstractXcodeML_FFactory.
     *
     * @return XbfFdoStatementSequence
     */
    public XbfFdoStatementSequence createXbfFdoStatementSequence() {
        return (new XbfFdoStatementSequence());
    }
}
