/*
 * The Relaxer artifact
 * Copyright (c) 2000-2003, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package xcodeml.c.binding.gen;

import xcodeml.binding.*;

import java.io.*;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * IXcodeML_CFactory is generated by Relaxer based on XcodeML_C.rng.
 *
 * @version XcodeML_C.rng 1.0 (Thu Feb 02 16:55:19 JST 2012)
 * @author  Relaxer 1.0 (http://www.relaxer.org)
 */
public interface IXcodeML_CFactory {
    /**
     * Sets a <b>errorHandler</b>.
     *
     * @param errorHandler
     */
    void setErrorHandler(org.xml.sax.ErrorHandler errorHandler);

    /**
     * Gets a <b>errorHandler</b>.
     *
     * @return org.xml.sax.ErrorHandler
     */
    org.xml.sax.ErrorHandler getErrorHandler();

    /**
     * Sets a <b>entityResolver</b>.
     *
     * @param entityResolver
     */
    void setEntityResolver(org.xml.sax.EntityResolver entityResolver);

    /**
     * Gets a <b>entityResolver</b>.
     *
     * @return org.xml.sax.EntityResolver
     */
    org.xml.sax.EntityResolver getEntityResolver();

    /**
     * Sets a <b>baseUri</b>.
     *
     * @param baseUri
     */
    void setBaseUri(String baseUri);

    /**
     * Gets a <b>baseUri</b>.
     *
     * @return String
     */
    String getBaseUri();

    /**
     * Creates a <code>Object</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    Object create(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    Object create(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    Object create(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    Object create(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    Object create(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    Object create(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the Object <code>source</code>.
     *
     * @param source
     * @return Object
     */
    Object create(Object source);

    /**
     * Creates a <code>Object</code> by the Document <code>dom</code>.
     *
     * @param doc
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    Object create(Document doc) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>Object</code> by the Element <code>element</code>.
     *
     * @param element
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    Object create(Element element) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcXcodeProgram</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXcodeProgram
     */
    XbcXcodeProgram createXbcXcodeProgram(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcTypeTable</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeTable
     */
    XbcTypeTable createXbcTypeTable(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionType</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionType
     */
    XbcFunctionType createXbcFunctionType(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAttributes</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttributes
     */
    XbcGccAttributes createXbcGccAttributes(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAttribute</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttribute
     */
    XbcGccAttribute createXbcGccAttribute(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBuiltinOp</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBuiltinOp
     */
    XbcBuiltinOp createXbcBuiltinOp(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayRef
     */
    XbcArrayRef createXbcArrayRef(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayAddr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayAddr
     */
    XbcArrayAddr createXbcArrayAddr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionCall</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionCall
     */
    XbcFunctionCall createXbcFunctionCall(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunction</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunction
     */
    XbcFunction createXbcFunction(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArguments</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArguments
     */
    XbcArguments createXbcArguments(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccCompoundExpr
     */
    XbcGccCompoundExpr createXbcGccCompoundExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundStatement
     */
    XbcCompoundStatement createXbcCompoundStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSymbols</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSymbols
     */
    XbcSymbols createXbcSymbols(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcId</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcId
     */
    XbcId createXbcId(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcName</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcName
     */
    XbcName createXbcName(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcValue</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcValue
     */
    XbcValue createXbcValue(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSubArrayRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSubArrayRef
     */
    XbcSubArrayRef createXbcSubArrayRef(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayRef
     */
    XbcCoArrayRef createXbcCoArrayRef(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVar</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVar
     */
    XbcVar createXbcVar(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberRef
     */
    XbcMemberRef createXbcMemberRef(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCastExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCastExpr
     */
    XbcCastExpr createXbcCastExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStringConstant</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStringConstant
     */
    XbcStringConstant createXbcStringConstant(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVarAddr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarAddr
     */
    XbcVarAddr createXbcVarAddr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueExpr
     */
    XbcCompoundValueExpr createXbcCompoundValueExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueAddrExpr
     */
    XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcXmpDescOf</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXmpDescOf
     */
    XbcXmpDescOf createXbcXmpDescOf(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIntConstant</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIntConstant
     */
    XbcIntConstant createXbcIntConstant(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFloatConstant</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFloatConstant
     */
    XbcFloatConstant createXbcFloatConstant(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLonglongConstant</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLonglongConstant
     */
    XbcLonglongConstant createXbcLonglongConstant(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMoeConstant</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMoeConstant
     */
    XbcMoeConstant createXbcMoeConstant(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFuncAddr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFuncAddr
     */
    XbcFuncAddr createXbcFuncAddr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSizeOfExpr
     */
    XbcSizeOfExpr createXbcSizeOfExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayAssignExpr
     */
    XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcModExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcModExpr
     */
    XbcModExpr createXbcModExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitOrExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitOrExpr
     */
    XbcBitOrExpr createXbcBitOrExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogOrExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogOrExpr
     */
    XbcLogOrExpr createXbcLogOrExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPlusExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPlusExpr
     */
    XbcPlusExpr createXbcPlusExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgPlusExpr
     */
    XbcAsgPlusExpr createXbcAsgPlusExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgModExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgModExpr
     */
    XbcAsgModExpr createXbcAsgModExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitOrExpr
     */
    XbcAsgBitOrExpr createXbcAsgBitOrExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogGTExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGTExpr
     */
    XbcLogGTExpr createXbcLogGTExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCondExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondExpr
     */
    XbcCondExpr createXbcCondExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMinusExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMinusExpr
     */
    XbcMinusExpr createXbcMinusExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAddrOfExpr
     */
    XbcAddrOfExpr createXbcAddrOfExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLshiftExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLshiftExpr
     */
    XbcLshiftExpr createXbcLshiftExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcRshiftExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcRshiftExpr
     */
    XbcRshiftExpr createXbcRshiftExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitXorExpr
     */
    XbcAsgBitXorExpr createXbcAsgBitXorExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogEQExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogEQExpr
     */
    XbcLogEQExpr createXbcLogEQExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNEQExpr
     */
    XbcLogNEQExpr createXbcLogNEQExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogGEExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGEExpr
     */
    XbcLogGEExpr createXbcLogGEExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogLTExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLTExpr
     */
    XbcLogLTExpr createXbcLogLTExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAlignOfExpr
     */
    XbcGccAlignOfExpr createXbcGccAlignOfExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAssignExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAssignExpr
     */
    XbcAssignExpr createXbcAssignExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMulExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMulExpr
     */
    XbcMulExpr createXbcMulExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDivExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDivExpr
     */
    XbcDivExpr createXbcDivExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMulExpr
     */
    XbcAsgMulExpr createXbcAsgMulExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgRshiftExpr
     */
    XbcAsgRshiftExpr createXbcAsgRshiftExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitAndExpr
     */
    XbcAsgBitAndExpr createXbcAsgBitAndExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogLEExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLEExpr
     */
    XbcLogLEExpr createXbcLogLEExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogAndExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogAndExpr
     */
    XbcLogAndExpr createXbcLogAndExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCommaExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCommaExpr
     */
    XbcCommaExpr createXbcCommaExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgDivExpr
     */
    XbcAsgDivExpr createXbcAsgDivExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccLabelAddr
     */
    XbcGccLabelAddr createXbcGccLabelAddr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitAndExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitAndExpr
     */
    XbcBitAndExpr createXbcBitAndExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitXorExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitXorExpr
     */
    XbcBitXorExpr createXbcBitXorExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMinusExpr
     */
    XbcAsgMinusExpr createXbcAsgMinusExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgLshiftExpr
     */
    XbcAsgLshiftExpr createXbcAsgLshiftExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberAddr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberAddr
     */
    XbcMemberAddr createXbcMemberAddr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayRef
     */
    XbcMemberArrayRef createXbcMemberArrayRef(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayAddr
     */
    XbcMemberArrayAddr createXbcMemberArrayAddr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcTypeName</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeName
     */
    XbcTypeName createXbcTypeName(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPointerRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerRef
     */
    XbcPointerRef createXbcPointerRef(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnaryMinusExpr
     */
    XbcUnaryMinusExpr createXbcUnaryMinusExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitNotExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitNotExpr
     */
    XbcBitNotExpr createXbcBitNotExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogNotExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNotExpr
     */
    XbcLogNotExpr createXbcLogNotExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostIncrExpr
     */
    XbcPostIncrExpr createXbcPostIncrExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostDecrExpr
     */
    XbcPostDecrExpr createXbcPostDecrExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreIncrExpr
     */
    XbcPreIncrExpr createXbcPreIncrExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreDecrExpr
     */
    XbcPreDecrExpr createXbcPreDecrExpr(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIndexRange</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIndexRange
     */
    XbcIndexRange createXbcIndexRange(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLowerBound</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLowerBound
     */
    XbcLowerBound createXbcLowerBound(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUpperBound</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUpperBound
     */
    XbcUpperBound createXbcUpperBound(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStep</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStep
     */
    XbcStep createXbcStep(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDesignatedValue</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDesignatedValue
     */
    XbcDesignatedValue createXbcDesignatedValue(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValue</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValue
     */
    XbcCompoundValue createXbcCompoundValue(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitField</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitField
     */
    XbcBitField createXbcBitField(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPragma</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPragma
     */
    XbcPragma createXbcPragma(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcText</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcText
     */
    XbcText createXbcText(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDeclarations</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDeclarations
     */
    XbcDeclarations createXbcDeclarations(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDefinition
     */
    XbcFunctionDefinition createXbcFunctionDefinition(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcParams</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcParams
     */
    XbcParams createXbcParams(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBody</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBody
     */
    XbcBody createXbcBody(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmStatement
     */
    XbcGccAsmStatement createXbcGccAsmStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperands
     */
    XbcGccAsmOperands createXbcGccAsmOperands(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperand
     */
    XbcGccAsmOperand createXbcGccAsmOperand(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmClobbers
     */
    XbcGccAsmClobbers createXbcGccAsmClobbers(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcForStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcForStatement
     */
    XbcForStatement createXbcForStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcInit</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcInit
     */
    XbcInit createXbcInit(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCondition</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondition
     */
    XbcCondition createXbcCondition(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIter</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIter
     */
    XbcIter createXbcIter(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIfStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIfStatement
     */
    XbcIfStatement createXbcIfStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcThen</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcThen
     */
    XbcThen createXbcThen(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcElse</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcElse
     */
    XbcElse createXbcElse(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcWhileStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcWhileStatement
     */
    XbcWhileStatement createXbcWhileStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDoStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDoStatement
     */
    XbcDoStatement createXbcDoStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSwitchStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSwitchStatement
     */
    XbcSwitchStatement createXbcSwitchStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccRangedCaseLabel
     */
    XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStatementLabel</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStatementLabel
     */
    XbcStatementLabel createXbcStatementLabel(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCaseLabel</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCaseLabel
     */
    XbcCaseLabel createXbcCaseLabel(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBreakStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBreakStatement
     */
    XbcBreakStatement createXbcBreakStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcContinueStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcContinueStatement
     */
    XbcContinueStatement createXbcContinueStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcReturnStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcReturnStatement
     */
    XbcReturnStatement createXbcReturnStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGotoStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGotoStatement
     */
    XbcGotoStatement createXbcGotoStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDefaultLabel</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDefaultLabel
     */
    XbcDefaultLabel createXbcDefaultLabel(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcExprStatement</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcExprStatement
     */
    XbcExprStatement createXbcExprStatement(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVarDecl</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarDecl
     */
    XbcVarDecl createXbcVarDecl(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsm</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsm
     */
    XbcGccAsm createXbcGccAsm(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionDecl</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDecl
     */
    XbcFunctionDecl createXbcFunctionDecl(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccMemberDesignator
     */
    XbcGccMemberDesignator createXbcGccMemberDesignator(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayType</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayType
     */
    XbcArrayType createXbcArrayType(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArraySize</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArraySize
     */
    XbcArraySize createXbcArraySize(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBasicType</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBasicType
     */
    XbcBasicType createXbcBasicType(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPointerType</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerType
     */
    XbcPointerType createXbcPointerType(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStructType</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStructType
     */
    XbcStructType createXbcStructType(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUnionType</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnionType
     */
    XbcUnionType createXbcUnionType(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcEnumType</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcEnumType
     */
    XbcEnumType createXbcEnumType(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayType</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayType
     */
    XbcCoArrayType createXbcCoArrayType(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalSymbols
     */
    XbcGlobalSymbols createXbcGlobalSymbols(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalDeclarations
     */
    XbcGlobalDeclarations createXbcGlobalDeclarations(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmDefinition
     */
    XbcGccAsmDefinition createXbcGccAsmDefinition(File file) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcXcodeProgram</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXcodeProgram
     */
    XbcXcodeProgram createXbcXcodeProgram(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcTypeTable</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeTable
     */
    XbcTypeTable createXbcTypeTable(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionType</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionType
     */
    XbcFunctionType createXbcFunctionType(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAttributes</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttributes
     */
    XbcGccAttributes createXbcGccAttributes(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAttribute</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttribute
     */
    XbcGccAttribute createXbcGccAttribute(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBuiltinOp</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBuiltinOp
     */
    XbcBuiltinOp createXbcBuiltinOp(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayRef
     */
    XbcArrayRef createXbcArrayRef(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayAddr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayAddr
     */
    XbcArrayAddr createXbcArrayAddr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionCall</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionCall
     */
    XbcFunctionCall createXbcFunctionCall(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunction</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunction
     */
    XbcFunction createXbcFunction(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArguments</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArguments
     */
    XbcArguments createXbcArguments(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccCompoundExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccCompoundExpr
     */
    XbcGccCompoundExpr createXbcGccCompoundExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundStatement
     */
    XbcCompoundStatement createXbcCompoundStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSymbols</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSymbols
     */
    XbcSymbols createXbcSymbols(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcId</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcId
     */
    XbcId createXbcId(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcName</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcName
     */
    XbcName createXbcName(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcValue</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcValue
     */
    XbcValue createXbcValue(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSubArrayRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSubArrayRef
     */
    XbcSubArrayRef createXbcSubArrayRef(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayRef
     */
    XbcCoArrayRef createXbcCoArrayRef(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVar</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVar
     */
    XbcVar createXbcVar(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberRef
     */
    XbcMemberRef createXbcMemberRef(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCastExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCastExpr
     */
    XbcCastExpr createXbcCastExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStringConstant</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStringConstant
     */
    XbcStringConstant createXbcStringConstant(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVarAddr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarAddr
     */
    XbcVarAddr createXbcVarAddr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValueExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueExpr
     */
    XbcCompoundValueExpr createXbcCompoundValueExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueAddrExpr
     */
    XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcXmpDescOf</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXmpDescOf
     */
    XbcXmpDescOf createXbcXmpDescOf(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIntConstant</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIntConstant
     */
    XbcIntConstant createXbcIntConstant(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFloatConstant</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFloatConstant
     */
    XbcFloatConstant createXbcFloatConstant(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLonglongConstant</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLonglongConstant
     */
    XbcLonglongConstant createXbcLonglongConstant(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMoeConstant</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMoeConstant
     */
    XbcMoeConstant createXbcMoeConstant(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFuncAddr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFuncAddr
     */
    XbcFuncAddr createXbcFuncAddr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSizeOfExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSizeOfExpr
     */
    XbcSizeOfExpr createXbcSizeOfExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayAssignExpr
     */
    XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcModExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcModExpr
     */
    XbcModExpr createXbcModExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitOrExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitOrExpr
     */
    XbcBitOrExpr createXbcBitOrExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogOrExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogOrExpr
     */
    XbcLogOrExpr createXbcLogOrExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPlusExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPlusExpr
     */
    XbcPlusExpr createXbcPlusExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgPlusExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgPlusExpr
     */
    XbcAsgPlusExpr createXbcAsgPlusExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgModExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgModExpr
     */
    XbcAsgModExpr createXbcAsgModExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitOrExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitOrExpr
     */
    XbcAsgBitOrExpr createXbcAsgBitOrExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogGTExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGTExpr
     */
    XbcLogGTExpr createXbcLogGTExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCondExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondExpr
     */
    XbcCondExpr createXbcCondExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMinusExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMinusExpr
     */
    XbcMinusExpr createXbcMinusExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAddrOfExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAddrOfExpr
     */
    XbcAddrOfExpr createXbcAddrOfExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLshiftExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLshiftExpr
     */
    XbcLshiftExpr createXbcLshiftExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcRshiftExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcRshiftExpr
     */
    XbcRshiftExpr createXbcRshiftExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitXorExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitXorExpr
     */
    XbcAsgBitXorExpr createXbcAsgBitXorExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogEQExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogEQExpr
     */
    XbcLogEQExpr createXbcLogEQExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogNEQExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNEQExpr
     */
    XbcLogNEQExpr createXbcLogNEQExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogGEExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGEExpr
     */
    XbcLogGEExpr createXbcLogGEExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogLTExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLTExpr
     */
    XbcLogLTExpr createXbcLogLTExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAlignOfExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAlignOfExpr
     */
    XbcGccAlignOfExpr createXbcGccAlignOfExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAssignExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAssignExpr
     */
    XbcAssignExpr createXbcAssignExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMulExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMulExpr
     */
    XbcMulExpr createXbcMulExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDivExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDivExpr
     */
    XbcDivExpr createXbcDivExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgMulExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMulExpr
     */
    XbcAsgMulExpr createXbcAsgMulExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgRshiftExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgRshiftExpr
     */
    XbcAsgRshiftExpr createXbcAsgRshiftExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitAndExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitAndExpr
     */
    XbcAsgBitAndExpr createXbcAsgBitAndExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogLEExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLEExpr
     */
    XbcLogLEExpr createXbcLogLEExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogAndExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogAndExpr
     */
    XbcLogAndExpr createXbcLogAndExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCommaExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCommaExpr
     */
    XbcCommaExpr createXbcCommaExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgDivExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgDivExpr
     */
    XbcAsgDivExpr createXbcAsgDivExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccLabelAddr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccLabelAddr
     */
    XbcGccLabelAddr createXbcGccLabelAddr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitAndExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitAndExpr
     */
    XbcBitAndExpr createXbcBitAndExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitXorExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitXorExpr
     */
    XbcBitXorExpr createXbcBitXorExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgMinusExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMinusExpr
     */
    XbcAsgMinusExpr createXbcAsgMinusExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgLshiftExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgLshiftExpr
     */
    XbcAsgLshiftExpr createXbcAsgLshiftExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberAddr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberAddr
     */
    XbcMemberAddr createXbcMemberAddr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberArrayRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayRef
     */
    XbcMemberArrayRef createXbcMemberArrayRef(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberArrayAddr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayAddr
     */
    XbcMemberArrayAddr createXbcMemberArrayAddr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcTypeName</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeName
     */
    XbcTypeName createXbcTypeName(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPointerRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerRef
     */
    XbcPointerRef createXbcPointerRef(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUnaryMinusExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnaryMinusExpr
     */
    XbcUnaryMinusExpr createXbcUnaryMinusExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitNotExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitNotExpr
     */
    XbcBitNotExpr createXbcBitNotExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogNotExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNotExpr
     */
    XbcLogNotExpr createXbcLogNotExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPostIncrExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostIncrExpr
     */
    XbcPostIncrExpr createXbcPostIncrExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPostDecrExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostDecrExpr
     */
    XbcPostDecrExpr createXbcPostDecrExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPreIncrExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreIncrExpr
     */
    XbcPreIncrExpr createXbcPreIncrExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPreDecrExpr</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreDecrExpr
     */
    XbcPreDecrExpr createXbcPreDecrExpr(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIndexRange</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIndexRange
     */
    XbcIndexRange createXbcIndexRange(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLowerBound</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLowerBound
     */
    XbcLowerBound createXbcLowerBound(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUpperBound</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUpperBound
     */
    XbcUpperBound createXbcUpperBound(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStep</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStep
     */
    XbcStep createXbcStep(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDesignatedValue</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDesignatedValue
     */
    XbcDesignatedValue createXbcDesignatedValue(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValue</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValue
     */
    XbcCompoundValue createXbcCompoundValue(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitField</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitField
     */
    XbcBitField createXbcBitField(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPragma</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPragma
     */
    XbcPragma createXbcPragma(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcText</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcText
     */
    XbcText createXbcText(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDeclarations</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDeclarations
     */
    XbcDeclarations createXbcDeclarations(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionDefinition</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDefinition
     */
    XbcFunctionDefinition createXbcFunctionDefinition(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcParams</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcParams
     */
    XbcParams createXbcParams(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBody</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBody
     */
    XbcBody createXbcBody(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmStatement
     */
    XbcGccAsmStatement createXbcGccAsmStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmOperands</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperands
     */
    XbcGccAsmOperands createXbcGccAsmOperands(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmOperand</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperand
     */
    XbcGccAsmOperand createXbcGccAsmOperand(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmClobbers</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmClobbers
     */
    XbcGccAsmClobbers createXbcGccAsmClobbers(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcForStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcForStatement
     */
    XbcForStatement createXbcForStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcInit</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcInit
     */
    XbcInit createXbcInit(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCondition</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondition
     */
    XbcCondition createXbcCondition(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIter</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIter
     */
    XbcIter createXbcIter(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIfStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIfStatement
     */
    XbcIfStatement createXbcIfStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcThen</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcThen
     */
    XbcThen createXbcThen(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcElse</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcElse
     */
    XbcElse createXbcElse(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcWhileStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcWhileStatement
     */
    XbcWhileStatement createXbcWhileStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDoStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDoStatement
     */
    XbcDoStatement createXbcDoStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSwitchStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSwitchStatement
     */
    XbcSwitchStatement createXbcSwitchStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccRangedCaseLabel
     */
    XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStatementLabel</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStatementLabel
     */
    XbcStatementLabel createXbcStatementLabel(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCaseLabel</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCaseLabel
     */
    XbcCaseLabel createXbcCaseLabel(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBreakStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBreakStatement
     */
    XbcBreakStatement createXbcBreakStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcContinueStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcContinueStatement
     */
    XbcContinueStatement createXbcContinueStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcReturnStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcReturnStatement
     */
    XbcReturnStatement createXbcReturnStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGotoStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGotoStatement
     */
    XbcGotoStatement createXbcGotoStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDefaultLabel</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDefaultLabel
     */
    XbcDefaultLabel createXbcDefaultLabel(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcExprStatement</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcExprStatement
     */
    XbcExprStatement createXbcExprStatement(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVarDecl</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarDecl
     */
    XbcVarDecl createXbcVarDecl(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsm</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsm
     */
    XbcGccAsm createXbcGccAsm(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionDecl</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDecl
     */
    XbcFunctionDecl createXbcFunctionDecl(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccMemberDesignator</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccMemberDesignator
     */
    XbcGccMemberDesignator createXbcGccMemberDesignator(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayType</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayType
     */
    XbcArrayType createXbcArrayType(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArraySize</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArraySize
     */
    XbcArraySize createXbcArraySize(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBasicType</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBasicType
     */
    XbcBasicType createXbcBasicType(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPointerType</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerType
     */
    XbcPointerType createXbcPointerType(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStructType</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStructType
     */
    XbcStructType createXbcStructType(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUnionType</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnionType
     */
    XbcUnionType createXbcUnionType(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcEnumType</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcEnumType
     */
    XbcEnumType createXbcEnumType(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayType</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayType
     */
    XbcCoArrayType createXbcCoArrayType(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGlobalSymbols</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalSymbols
     */
    XbcGlobalSymbols createXbcGlobalSymbols(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGlobalDeclarations</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalDeclarations
     */
    XbcGlobalDeclarations createXbcGlobalDeclarations(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmDefinition</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmDefinition
     */
    XbcGccAsmDefinition createXbcGccAsmDefinition(String uri) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcXcodeProgram</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXcodeProgram
     */
    XbcXcodeProgram createXbcXcodeProgram(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcTypeTable</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeTable
     */
    XbcTypeTable createXbcTypeTable(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionType</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionType
     */
    XbcFunctionType createXbcFunctionType(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAttributes</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttributes
     */
    XbcGccAttributes createXbcGccAttributes(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAttribute</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttribute
     */
    XbcGccAttribute createXbcGccAttribute(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBuiltinOp</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBuiltinOp
     */
    XbcBuiltinOp createXbcBuiltinOp(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayRef
     */
    XbcArrayRef createXbcArrayRef(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayAddr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayAddr
     */
    XbcArrayAddr createXbcArrayAddr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionCall</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionCall
     */
    XbcFunctionCall createXbcFunctionCall(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunction</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunction
     */
    XbcFunction createXbcFunction(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArguments</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArguments
     */
    XbcArguments createXbcArguments(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccCompoundExpr
     */
    XbcGccCompoundExpr createXbcGccCompoundExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundStatement
     */
    XbcCompoundStatement createXbcCompoundStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSymbols</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSymbols
     */
    XbcSymbols createXbcSymbols(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcId</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcId
     */
    XbcId createXbcId(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcName</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcName
     */
    XbcName createXbcName(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcValue</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcValue
     */
    XbcValue createXbcValue(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSubArrayRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSubArrayRef
     */
    XbcSubArrayRef createXbcSubArrayRef(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayRef
     */
    XbcCoArrayRef createXbcCoArrayRef(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVar</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVar
     */
    XbcVar createXbcVar(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberRef
     */
    XbcMemberRef createXbcMemberRef(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCastExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCastExpr
     */
    XbcCastExpr createXbcCastExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStringConstant</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStringConstant
     */
    XbcStringConstant createXbcStringConstant(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVarAddr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarAddr
     */
    XbcVarAddr createXbcVarAddr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueExpr
     */
    XbcCompoundValueExpr createXbcCompoundValueExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueAddrExpr
     */
    XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcXmpDescOf</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXmpDescOf
     */
    XbcXmpDescOf createXbcXmpDescOf(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIntConstant</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIntConstant
     */
    XbcIntConstant createXbcIntConstant(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFloatConstant</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFloatConstant
     */
    XbcFloatConstant createXbcFloatConstant(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLonglongConstant</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLonglongConstant
     */
    XbcLonglongConstant createXbcLonglongConstant(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMoeConstant</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMoeConstant
     */
    XbcMoeConstant createXbcMoeConstant(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFuncAddr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFuncAddr
     */
    XbcFuncAddr createXbcFuncAddr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSizeOfExpr
     */
    XbcSizeOfExpr createXbcSizeOfExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayAssignExpr
     */
    XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcModExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcModExpr
     */
    XbcModExpr createXbcModExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitOrExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitOrExpr
     */
    XbcBitOrExpr createXbcBitOrExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogOrExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogOrExpr
     */
    XbcLogOrExpr createXbcLogOrExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPlusExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPlusExpr
     */
    XbcPlusExpr createXbcPlusExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgPlusExpr
     */
    XbcAsgPlusExpr createXbcAsgPlusExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgModExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgModExpr
     */
    XbcAsgModExpr createXbcAsgModExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitOrExpr
     */
    XbcAsgBitOrExpr createXbcAsgBitOrExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogGTExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGTExpr
     */
    XbcLogGTExpr createXbcLogGTExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCondExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondExpr
     */
    XbcCondExpr createXbcCondExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMinusExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMinusExpr
     */
    XbcMinusExpr createXbcMinusExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAddrOfExpr
     */
    XbcAddrOfExpr createXbcAddrOfExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLshiftExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLshiftExpr
     */
    XbcLshiftExpr createXbcLshiftExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcRshiftExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcRshiftExpr
     */
    XbcRshiftExpr createXbcRshiftExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitXorExpr
     */
    XbcAsgBitXorExpr createXbcAsgBitXorExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogEQExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogEQExpr
     */
    XbcLogEQExpr createXbcLogEQExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNEQExpr
     */
    XbcLogNEQExpr createXbcLogNEQExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogGEExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGEExpr
     */
    XbcLogGEExpr createXbcLogGEExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogLTExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLTExpr
     */
    XbcLogLTExpr createXbcLogLTExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAlignOfExpr
     */
    XbcGccAlignOfExpr createXbcGccAlignOfExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAssignExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAssignExpr
     */
    XbcAssignExpr createXbcAssignExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMulExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMulExpr
     */
    XbcMulExpr createXbcMulExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDivExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDivExpr
     */
    XbcDivExpr createXbcDivExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMulExpr
     */
    XbcAsgMulExpr createXbcAsgMulExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgRshiftExpr
     */
    XbcAsgRshiftExpr createXbcAsgRshiftExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitAndExpr
     */
    XbcAsgBitAndExpr createXbcAsgBitAndExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogLEExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLEExpr
     */
    XbcLogLEExpr createXbcLogLEExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogAndExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogAndExpr
     */
    XbcLogAndExpr createXbcLogAndExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCommaExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCommaExpr
     */
    XbcCommaExpr createXbcCommaExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgDivExpr
     */
    XbcAsgDivExpr createXbcAsgDivExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccLabelAddr
     */
    XbcGccLabelAddr createXbcGccLabelAddr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitAndExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitAndExpr
     */
    XbcBitAndExpr createXbcBitAndExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitXorExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitXorExpr
     */
    XbcBitXorExpr createXbcBitXorExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMinusExpr
     */
    XbcAsgMinusExpr createXbcAsgMinusExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgLshiftExpr
     */
    XbcAsgLshiftExpr createXbcAsgLshiftExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberAddr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberAddr
     */
    XbcMemberAddr createXbcMemberAddr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayRef
     */
    XbcMemberArrayRef createXbcMemberArrayRef(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayAddr
     */
    XbcMemberArrayAddr createXbcMemberArrayAddr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcTypeName</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeName
     */
    XbcTypeName createXbcTypeName(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPointerRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerRef
     */
    XbcPointerRef createXbcPointerRef(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnaryMinusExpr
     */
    XbcUnaryMinusExpr createXbcUnaryMinusExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitNotExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitNotExpr
     */
    XbcBitNotExpr createXbcBitNotExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogNotExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNotExpr
     */
    XbcLogNotExpr createXbcLogNotExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostIncrExpr
     */
    XbcPostIncrExpr createXbcPostIncrExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostDecrExpr
     */
    XbcPostDecrExpr createXbcPostDecrExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreIncrExpr
     */
    XbcPreIncrExpr createXbcPreIncrExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreDecrExpr
     */
    XbcPreDecrExpr createXbcPreDecrExpr(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIndexRange</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIndexRange
     */
    XbcIndexRange createXbcIndexRange(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLowerBound</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLowerBound
     */
    XbcLowerBound createXbcLowerBound(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUpperBound</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUpperBound
     */
    XbcUpperBound createXbcUpperBound(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStep</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStep
     */
    XbcStep createXbcStep(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDesignatedValue</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDesignatedValue
     */
    XbcDesignatedValue createXbcDesignatedValue(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValue</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValue
     */
    XbcCompoundValue createXbcCompoundValue(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitField</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitField
     */
    XbcBitField createXbcBitField(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPragma</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPragma
     */
    XbcPragma createXbcPragma(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcText</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcText
     */
    XbcText createXbcText(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDeclarations</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDeclarations
     */
    XbcDeclarations createXbcDeclarations(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDefinition
     */
    XbcFunctionDefinition createXbcFunctionDefinition(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcParams</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcParams
     */
    XbcParams createXbcParams(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBody</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBody
     */
    XbcBody createXbcBody(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmStatement
     */
    XbcGccAsmStatement createXbcGccAsmStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperands
     */
    XbcGccAsmOperands createXbcGccAsmOperands(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperand
     */
    XbcGccAsmOperand createXbcGccAsmOperand(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmClobbers
     */
    XbcGccAsmClobbers createXbcGccAsmClobbers(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcForStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcForStatement
     */
    XbcForStatement createXbcForStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcInit</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcInit
     */
    XbcInit createXbcInit(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCondition</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondition
     */
    XbcCondition createXbcCondition(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIter</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIter
     */
    XbcIter createXbcIter(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIfStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIfStatement
     */
    XbcIfStatement createXbcIfStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcThen</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcThen
     */
    XbcThen createXbcThen(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcElse</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcElse
     */
    XbcElse createXbcElse(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcWhileStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcWhileStatement
     */
    XbcWhileStatement createXbcWhileStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDoStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDoStatement
     */
    XbcDoStatement createXbcDoStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSwitchStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSwitchStatement
     */
    XbcSwitchStatement createXbcSwitchStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccRangedCaseLabel
     */
    XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStatementLabel</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStatementLabel
     */
    XbcStatementLabel createXbcStatementLabel(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCaseLabel</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCaseLabel
     */
    XbcCaseLabel createXbcCaseLabel(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBreakStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBreakStatement
     */
    XbcBreakStatement createXbcBreakStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcContinueStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcContinueStatement
     */
    XbcContinueStatement createXbcContinueStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcReturnStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcReturnStatement
     */
    XbcReturnStatement createXbcReturnStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGotoStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGotoStatement
     */
    XbcGotoStatement createXbcGotoStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDefaultLabel</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDefaultLabel
     */
    XbcDefaultLabel createXbcDefaultLabel(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcExprStatement</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcExprStatement
     */
    XbcExprStatement createXbcExprStatement(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVarDecl</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarDecl
     */
    XbcVarDecl createXbcVarDecl(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsm</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsm
     */
    XbcGccAsm createXbcGccAsm(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionDecl</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDecl
     */
    XbcFunctionDecl createXbcFunctionDecl(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccMemberDesignator
     */
    XbcGccMemberDesignator createXbcGccMemberDesignator(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayType</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayType
     */
    XbcArrayType createXbcArrayType(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArraySize</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArraySize
     */
    XbcArraySize createXbcArraySize(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBasicType</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBasicType
     */
    XbcBasicType createXbcBasicType(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPointerType</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerType
     */
    XbcPointerType createXbcPointerType(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStructType</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStructType
     */
    XbcStructType createXbcStructType(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUnionType</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnionType
     */
    XbcUnionType createXbcUnionType(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcEnumType</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcEnumType
     */
    XbcEnumType createXbcEnumType(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayType</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayType
     */
    XbcCoArrayType createXbcCoArrayType(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalSymbols
     */
    XbcGlobalSymbols createXbcGlobalSymbols(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalDeclarations
     */
    XbcGlobalDeclarations createXbcGlobalDeclarations(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmDefinition
     */
    XbcGccAsmDefinition createXbcGccAsmDefinition(URL url) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcXcodeProgram</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXcodeProgram
     */
    XbcXcodeProgram createXbcXcodeProgram(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcTypeTable</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeTable
     */
    XbcTypeTable createXbcTypeTable(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionType</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionType
     */
    XbcFunctionType createXbcFunctionType(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAttributes</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttributes
     */
    XbcGccAttributes createXbcGccAttributes(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAttribute</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttribute
     */
    XbcGccAttribute createXbcGccAttribute(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBuiltinOp</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBuiltinOp
     */
    XbcBuiltinOp createXbcBuiltinOp(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayRef
     */
    XbcArrayRef createXbcArrayRef(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayAddr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayAddr
     */
    XbcArrayAddr createXbcArrayAddr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionCall</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionCall
     */
    XbcFunctionCall createXbcFunctionCall(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunction</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunction
     */
    XbcFunction createXbcFunction(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArguments</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArguments
     */
    XbcArguments createXbcArguments(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccCompoundExpr
     */
    XbcGccCompoundExpr createXbcGccCompoundExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundStatement
     */
    XbcCompoundStatement createXbcCompoundStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSymbols</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSymbols
     */
    XbcSymbols createXbcSymbols(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcId</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcId
     */
    XbcId createXbcId(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcName</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcName
     */
    XbcName createXbcName(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcValue</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcValue
     */
    XbcValue createXbcValue(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSubArrayRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSubArrayRef
     */
    XbcSubArrayRef createXbcSubArrayRef(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayRef
     */
    XbcCoArrayRef createXbcCoArrayRef(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVar</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVar
     */
    XbcVar createXbcVar(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberRef
     */
    XbcMemberRef createXbcMemberRef(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCastExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCastExpr
     */
    XbcCastExpr createXbcCastExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStringConstant</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStringConstant
     */
    XbcStringConstant createXbcStringConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVarAddr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarAddr
     */
    XbcVarAddr createXbcVarAddr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueExpr
     */
    XbcCompoundValueExpr createXbcCompoundValueExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueAddrExpr
     */
    XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcXmpDescOf</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXmpDescOf
     */
    XbcXmpDescOf createXbcXmpDescOf(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIntConstant</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIntConstant
     */
    XbcIntConstant createXbcIntConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFloatConstant</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFloatConstant
     */
    XbcFloatConstant createXbcFloatConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLonglongConstant</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLonglongConstant
     */
    XbcLonglongConstant createXbcLonglongConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMoeConstant</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMoeConstant
     */
    XbcMoeConstant createXbcMoeConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFuncAddr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFuncAddr
     */
    XbcFuncAddr createXbcFuncAddr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSizeOfExpr
     */
    XbcSizeOfExpr createXbcSizeOfExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayAssignExpr
     */
    XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcModExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcModExpr
     */
    XbcModExpr createXbcModExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitOrExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitOrExpr
     */
    XbcBitOrExpr createXbcBitOrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogOrExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogOrExpr
     */
    XbcLogOrExpr createXbcLogOrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPlusExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPlusExpr
     */
    XbcPlusExpr createXbcPlusExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgPlusExpr
     */
    XbcAsgPlusExpr createXbcAsgPlusExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgModExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgModExpr
     */
    XbcAsgModExpr createXbcAsgModExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitOrExpr
     */
    XbcAsgBitOrExpr createXbcAsgBitOrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogGTExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGTExpr
     */
    XbcLogGTExpr createXbcLogGTExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCondExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondExpr
     */
    XbcCondExpr createXbcCondExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMinusExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMinusExpr
     */
    XbcMinusExpr createXbcMinusExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAddrOfExpr
     */
    XbcAddrOfExpr createXbcAddrOfExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLshiftExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLshiftExpr
     */
    XbcLshiftExpr createXbcLshiftExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcRshiftExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcRshiftExpr
     */
    XbcRshiftExpr createXbcRshiftExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitXorExpr
     */
    XbcAsgBitXorExpr createXbcAsgBitXorExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogEQExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogEQExpr
     */
    XbcLogEQExpr createXbcLogEQExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNEQExpr
     */
    XbcLogNEQExpr createXbcLogNEQExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogGEExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGEExpr
     */
    XbcLogGEExpr createXbcLogGEExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogLTExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLTExpr
     */
    XbcLogLTExpr createXbcLogLTExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAlignOfExpr
     */
    XbcGccAlignOfExpr createXbcGccAlignOfExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAssignExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAssignExpr
     */
    XbcAssignExpr createXbcAssignExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMulExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMulExpr
     */
    XbcMulExpr createXbcMulExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDivExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDivExpr
     */
    XbcDivExpr createXbcDivExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMulExpr
     */
    XbcAsgMulExpr createXbcAsgMulExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgRshiftExpr
     */
    XbcAsgRshiftExpr createXbcAsgRshiftExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitAndExpr
     */
    XbcAsgBitAndExpr createXbcAsgBitAndExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogLEExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLEExpr
     */
    XbcLogLEExpr createXbcLogLEExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogAndExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogAndExpr
     */
    XbcLogAndExpr createXbcLogAndExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCommaExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCommaExpr
     */
    XbcCommaExpr createXbcCommaExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgDivExpr
     */
    XbcAsgDivExpr createXbcAsgDivExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccLabelAddr
     */
    XbcGccLabelAddr createXbcGccLabelAddr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitAndExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitAndExpr
     */
    XbcBitAndExpr createXbcBitAndExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitXorExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitXorExpr
     */
    XbcBitXorExpr createXbcBitXorExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMinusExpr
     */
    XbcAsgMinusExpr createXbcAsgMinusExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgLshiftExpr
     */
    XbcAsgLshiftExpr createXbcAsgLshiftExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberAddr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberAddr
     */
    XbcMemberAddr createXbcMemberAddr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayRef
     */
    XbcMemberArrayRef createXbcMemberArrayRef(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayAddr
     */
    XbcMemberArrayAddr createXbcMemberArrayAddr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcTypeName</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeName
     */
    XbcTypeName createXbcTypeName(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPointerRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerRef
     */
    XbcPointerRef createXbcPointerRef(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnaryMinusExpr
     */
    XbcUnaryMinusExpr createXbcUnaryMinusExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitNotExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitNotExpr
     */
    XbcBitNotExpr createXbcBitNotExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogNotExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNotExpr
     */
    XbcLogNotExpr createXbcLogNotExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostIncrExpr
     */
    XbcPostIncrExpr createXbcPostIncrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostDecrExpr
     */
    XbcPostDecrExpr createXbcPostDecrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreIncrExpr
     */
    XbcPreIncrExpr createXbcPreIncrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreDecrExpr
     */
    XbcPreDecrExpr createXbcPreDecrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIndexRange</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIndexRange
     */
    XbcIndexRange createXbcIndexRange(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLowerBound</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLowerBound
     */
    XbcLowerBound createXbcLowerBound(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUpperBound</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUpperBound
     */
    XbcUpperBound createXbcUpperBound(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStep</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStep
     */
    XbcStep createXbcStep(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDesignatedValue</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDesignatedValue
     */
    XbcDesignatedValue createXbcDesignatedValue(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValue</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValue
     */
    XbcCompoundValue createXbcCompoundValue(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitField</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitField
     */
    XbcBitField createXbcBitField(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPragma</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPragma
     */
    XbcPragma createXbcPragma(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcText</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcText
     */
    XbcText createXbcText(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDeclarations</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDeclarations
     */
    XbcDeclarations createXbcDeclarations(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDefinition
     */
    XbcFunctionDefinition createXbcFunctionDefinition(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcParams</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcParams
     */
    XbcParams createXbcParams(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBody</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBody
     */
    XbcBody createXbcBody(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmStatement
     */
    XbcGccAsmStatement createXbcGccAsmStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperands
     */
    XbcGccAsmOperands createXbcGccAsmOperands(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperand
     */
    XbcGccAsmOperand createXbcGccAsmOperand(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmClobbers
     */
    XbcGccAsmClobbers createXbcGccAsmClobbers(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcForStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcForStatement
     */
    XbcForStatement createXbcForStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcInit</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcInit
     */
    XbcInit createXbcInit(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCondition</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondition
     */
    XbcCondition createXbcCondition(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIter</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIter
     */
    XbcIter createXbcIter(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIfStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIfStatement
     */
    XbcIfStatement createXbcIfStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcThen</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcThen
     */
    XbcThen createXbcThen(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcElse</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcElse
     */
    XbcElse createXbcElse(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcWhileStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcWhileStatement
     */
    XbcWhileStatement createXbcWhileStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDoStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDoStatement
     */
    XbcDoStatement createXbcDoStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSwitchStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSwitchStatement
     */
    XbcSwitchStatement createXbcSwitchStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccRangedCaseLabel
     */
    XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStatementLabel</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStatementLabel
     */
    XbcStatementLabel createXbcStatementLabel(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCaseLabel</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCaseLabel
     */
    XbcCaseLabel createXbcCaseLabel(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBreakStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBreakStatement
     */
    XbcBreakStatement createXbcBreakStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcContinueStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcContinueStatement
     */
    XbcContinueStatement createXbcContinueStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcReturnStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcReturnStatement
     */
    XbcReturnStatement createXbcReturnStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGotoStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGotoStatement
     */
    XbcGotoStatement createXbcGotoStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDefaultLabel</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDefaultLabel
     */
    XbcDefaultLabel createXbcDefaultLabel(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcExprStatement</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcExprStatement
     */
    XbcExprStatement createXbcExprStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVarDecl</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarDecl
     */
    XbcVarDecl createXbcVarDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsm</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsm
     */
    XbcGccAsm createXbcGccAsm(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionDecl</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDecl
     */
    XbcFunctionDecl createXbcFunctionDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccMemberDesignator
     */
    XbcGccMemberDesignator createXbcGccMemberDesignator(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayType</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayType
     */
    XbcArrayType createXbcArrayType(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArraySize</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArraySize
     */
    XbcArraySize createXbcArraySize(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBasicType</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBasicType
     */
    XbcBasicType createXbcBasicType(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPointerType</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerType
     */
    XbcPointerType createXbcPointerType(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStructType</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStructType
     */
    XbcStructType createXbcStructType(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUnionType</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnionType
     */
    XbcUnionType createXbcUnionType(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcEnumType</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcEnumType
     */
    XbcEnumType createXbcEnumType(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayType</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayType
     */
    XbcCoArrayType createXbcCoArrayType(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalSymbols
     */
    XbcGlobalSymbols createXbcGlobalSymbols(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalDeclarations
     */
    XbcGlobalDeclarations createXbcGlobalDeclarations(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmDefinition
     */
    XbcGccAsmDefinition createXbcGccAsmDefinition(InputStream in) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcXcodeProgram</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXcodeProgram
     */
    XbcXcodeProgram createXbcXcodeProgram(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcTypeTable</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeTable
     */
    XbcTypeTable createXbcTypeTable(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionType</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionType
     */
    XbcFunctionType createXbcFunctionType(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAttributes</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttributes
     */
    XbcGccAttributes createXbcGccAttributes(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAttribute</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttribute
     */
    XbcGccAttribute createXbcGccAttribute(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBuiltinOp</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBuiltinOp
     */
    XbcBuiltinOp createXbcBuiltinOp(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayRef
     */
    XbcArrayRef createXbcArrayRef(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayAddr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayAddr
     */
    XbcArrayAddr createXbcArrayAddr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionCall</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionCall
     */
    XbcFunctionCall createXbcFunctionCall(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunction</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunction
     */
    XbcFunction createXbcFunction(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArguments</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArguments
     */
    XbcArguments createXbcArguments(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccCompoundExpr
     */
    XbcGccCompoundExpr createXbcGccCompoundExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundStatement
     */
    XbcCompoundStatement createXbcCompoundStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSymbols</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSymbols
     */
    XbcSymbols createXbcSymbols(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcId</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcId
     */
    XbcId createXbcId(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcName</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcName
     */
    XbcName createXbcName(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcValue</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcValue
     */
    XbcValue createXbcValue(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSubArrayRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSubArrayRef
     */
    XbcSubArrayRef createXbcSubArrayRef(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayRef
     */
    XbcCoArrayRef createXbcCoArrayRef(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVar</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVar
     */
    XbcVar createXbcVar(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberRef
     */
    XbcMemberRef createXbcMemberRef(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCastExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCastExpr
     */
    XbcCastExpr createXbcCastExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStringConstant</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStringConstant
     */
    XbcStringConstant createXbcStringConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVarAddr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarAddr
     */
    XbcVarAddr createXbcVarAddr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueExpr
     */
    XbcCompoundValueExpr createXbcCompoundValueExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueAddrExpr
     */
    XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcXmpDescOf</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXmpDescOf
     */
    XbcXmpDescOf createXbcXmpDescOf(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIntConstant</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIntConstant
     */
    XbcIntConstant createXbcIntConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFloatConstant</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFloatConstant
     */
    XbcFloatConstant createXbcFloatConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLonglongConstant</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLonglongConstant
     */
    XbcLonglongConstant createXbcLonglongConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMoeConstant</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMoeConstant
     */
    XbcMoeConstant createXbcMoeConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFuncAddr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFuncAddr
     */
    XbcFuncAddr createXbcFuncAddr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSizeOfExpr
     */
    XbcSizeOfExpr createXbcSizeOfExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayAssignExpr
     */
    XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcModExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcModExpr
     */
    XbcModExpr createXbcModExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitOrExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitOrExpr
     */
    XbcBitOrExpr createXbcBitOrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogOrExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogOrExpr
     */
    XbcLogOrExpr createXbcLogOrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPlusExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPlusExpr
     */
    XbcPlusExpr createXbcPlusExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgPlusExpr
     */
    XbcAsgPlusExpr createXbcAsgPlusExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgModExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgModExpr
     */
    XbcAsgModExpr createXbcAsgModExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitOrExpr
     */
    XbcAsgBitOrExpr createXbcAsgBitOrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogGTExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGTExpr
     */
    XbcLogGTExpr createXbcLogGTExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCondExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondExpr
     */
    XbcCondExpr createXbcCondExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMinusExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMinusExpr
     */
    XbcMinusExpr createXbcMinusExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAddrOfExpr
     */
    XbcAddrOfExpr createXbcAddrOfExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLshiftExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLshiftExpr
     */
    XbcLshiftExpr createXbcLshiftExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcRshiftExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcRshiftExpr
     */
    XbcRshiftExpr createXbcRshiftExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitXorExpr
     */
    XbcAsgBitXorExpr createXbcAsgBitXorExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogEQExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogEQExpr
     */
    XbcLogEQExpr createXbcLogEQExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNEQExpr
     */
    XbcLogNEQExpr createXbcLogNEQExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogGEExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGEExpr
     */
    XbcLogGEExpr createXbcLogGEExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogLTExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLTExpr
     */
    XbcLogLTExpr createXbcLogLTExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAlignOfExpr
     */
    XbcGccAlignOfExpr createXbcGccAlignOfExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAssignExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAssignExpr
     */
    XbcAssignExpr createXbcAssignExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMulExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMulExpr
     */
    XbcMulExpr createXbcMulExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDivExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDivExpr
     */
    XbcDivExpr createXbcDivExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMulExpr
     */
    XbcAsgMulExpr createXbcAsgMulExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgRshiftExpr
     */
    XbcAsgRshiftExpr createXbcAsgRshiftExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitAndExpr
     */
    XbcAsgBitAndExpr createXbcAsgBitAndExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogLEExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLEExpr
     */
    XbcLogLEExpr createXbcLogLEExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogAndExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogAndExpr
     */
    XbcLogAndExpr createXbcLogAndExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCommaExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCommaExpr
     */
    XbcCommaExpr createXbcCommaExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgDivExpr
     */
    XbcAsgDivExpr createXbcAsgDivExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccLabelAddr
     */
    XbcGccLabelAddr createXbcGccLabelAddr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitAndExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitAndExpr
     */
    XbcBitAndExpr createXbcBitAndExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitXorExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitXorExpr
     */
    XbcBitXorExpr createXbcBitXorExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMinusExpr
     */
    XbcAsgMinusExpr createXbcAsgMinusExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgLshiftExpr
     */
    XbcAsgLshiftExpr createXbcAsgLshiftExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberAddr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberAddr
     */
    XbcMemberAddr createXbcMemberAddr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayRef
     */
    XbcMemberArrayRef createXbcMemberArrayRef(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayAddr
     */
    XbcMemberArrayAddr createXbcMemberArrayAddr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcTypeName</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeName
     */
    XbcTypeName createXbcTypeName(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPointerRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerRef
     */
    XbcPointerRef createXbcPointerRef(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnaryMinusExpr
     */
    XbcUnaryMinusExpr createXbcUnaryMinusExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitNotExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitNotExpr
     */
    XbcBitNotExpr createXbcBitNotExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogNotExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNotExpr
     */
    XbcLogNotExpr createXbcLogNotExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostIncrExpr
     */
    XbcPostIncrExpr createXbcPostIncrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostDecrExpr
     */
    XbcPostDecrExpr createXbcPostDecrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreIncrExpr
     */
    XbcPreIncrExpr createXbcPreIncrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreDecrExpr
     */
    XbcPreDecrExpr createXbcPreDecrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIndexRange</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIndexRange
     */
    XbcIndexRange createXbcIndexRange(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLowerBound</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLowerBound
     */
    XbcLowerBound createXbcLowerBound(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUpperBound</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUpperBound
     */
    XbcUpperBound createXbcUpperBound(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStep</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStep
     */
    XbcStep createXbcStep(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDesignatedValue</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDesignatedValue
     */
    XbcDesignatedValue createXbcDesignatedValue(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValue</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValue
     */
    XbcCompoundValue createXbcCompoundValue(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitField</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitField
     */
    XbcBitField createXbcBitField(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPragma</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPragma
     */
    XbcPragma createXbcPragma(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcText</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcText
     */
    XbcText createXbcText(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDeclarations</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDeclarations
     */
    XbcDeclarations createXbcDeclarations(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDefinition
     */
    XbcFunctionDefinition createXbcFunctionDefinition(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcParams</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcParams
     */
    XbcParams createXbcParams(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBody</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBody
     */
    XbcBody createXbcBody(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmStatement
     */
    XbcGccAsmStatement createXbcGccAsmStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperands
     */
    XbcGccAsmOperands createXbcGccAsmOperands(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperand
     */
    XbcGccAsmOperand createXbcGccAsmOperand(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmClobbers
     */
    XbcGccAsmClobbers createXbcGccAsmClobbers(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcForStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcForStatement
     */
    XbcForStatement createXbcForStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcInit</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcInit
     */
    XbcInit createXbcInit(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCondition</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondition
     */
    XbcCondition createXbcCondition(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIter</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIter
     */
    XbcIter createXbcIter(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIfStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIfStatement
     */
    XbcIfStatement createXbcIfStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcThen</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcThen
     */
    XbcThen createXbcThen(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcElse</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcElse
     */
    XbcElse createXbcElse(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcWhileStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcWhileStatement
     */
    XbcWhileStatement createXbcWhileStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDoStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDoStatement
     */
    XbcDoStatement createXbcDoStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSwitchStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSwitchStatement
     */
    XbcSwitchStatement createXbcSwitchStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccRangedCaseLabel
     */
    XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStatementLabel</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStatementLabel
     */
    XbcStatementLabel createXbcStatementLabel(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCaseLabel</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCaseLabel
     */
    XbcCaseLabel createXbcCaseLabel(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBreakStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBreakStatement
     */
    XbcBreakStatement createXbcBreakStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcContinueStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcContinueStatement
     */
    XbcContinueStatement createXbcContinueStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcReturnStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcReturnStatement
     */
    XbcReturnStatement createXbcReturnStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGotoStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGotoStatement
     */
    XbcGotoStatement createXbcGotoStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDefaultLabel</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDefaultLabel
     */
    XbcDefaultLabel createXbcDefaultLabel(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcExprStatement</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcExprStatement
     */
    XbcExprStatement createXbcExprStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVarDecl</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarDecl
     */
    XbcVarDecl createXbcVarDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsm</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsm
     */
    XbcGccAsm createXbcGccAsm(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionDecl</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDecl
     */
    XbcFunctionDecl createXbcFunctionDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccMemberDesignator
     */
    XbcGccMemberDesignator createXbcGccMemberDesignator(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayType</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayType
     */
    XbcArrayType createXbcArrayType(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArraySize</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArraySize
     */
    XbcArraySize createXbcArraySize(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBasicType</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBasicType
     */
    XbcBasicType createXbcBasicType(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPointerType</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerType
     */
    XbcPointerType createXbcPointerType(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStructType</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStructType
     */
    XbcStructType createXbcStructType(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUnionType</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnionType
     */
    XbcUnionType createXbcUnionType(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcEnumType</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcEnumType
     */
    XbcEnumType createXbcEnumType(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayType</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayType
     */
    XbcCoArrayType createXbcCoArrayType(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalSymbols
     */
    XbcGlobalSymbols createXbcGlobalSymbols(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalDeclarations
     */
    XbcGlobalDeclarations createXbcGlobalDeclarations(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmDefinition
     */
    XbcGccAsmDefinition createXbcGccAsmDefinition(InputSource is) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcXcodeProgram</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXcodeProgram
     */
    XbcXcodeProgram createXbcXcodeProgram(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcTypeTable</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeTable
     */
    XbcTypeTable createXbcTypeTable(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionType</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionType
     */
    XbcFunctionType createXbcFunctionType(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAttributes</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttributes
     */
    XbcGccAttributes createXbcGccAttributes(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAttribute</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttribute
     */
    XbcGccAttribute createXbcGccAttribute(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBuiltinOp</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBuiltinOp
     */
    XbcBuiltinOp createXbcBuiltinOp(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayRef
     */
    XbcArrayRef createXbcArrayRef(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayAddr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayAddr
     */
    XbcArrayAddr createXbcArrayAddr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionCall</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionCall
     */
    XbcFunctionCall createXbcFunctionCall(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunction</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunction
     */
    XbcFunction createXbcFunction(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArguments</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArguments
     */
    XbcArguments createXbcArguments(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccCompoundExpr
     */
    XbcGccCompoundExpr createXbcGccCompoundExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundStatement
     */
    XbcCompoundStatement createXbcCompoundStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSymbols</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSymbols
     */
    XbcSymbols createXbcSymbols(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcId</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcId
     */
    XbcId createXbcId(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcName</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcName
     */
    XbcName createXbcName(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcValue</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcValue
     */
    XbcValue createXbcValue(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSubArrayRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSubArrayRef
     */
    XbcSubArrayRef createXbcSubArrayRef(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayRef
     */
    XbcCoArrayRef createXbcCoArrayRef(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVar</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVar
     */
    XbcVar createXbcVar(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberRef
     */
    XbcMemberRef createXbcMemberRef(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCastExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCastExpr
     */
    XbcCastExpr createXbcCastExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStringConstant</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStringConstant
     */
    XbcStringConstant createXbcStringConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVarAddr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarAddr
     */
    XbcVarAddr createXbcVarAddr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueExpr
     */
    XbcCompoundValueExpr createXbcCompoundValueExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueAddrExpr
     */
    XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcXmpDescOf</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXmpDescOf
     */
    XbcXmpDescOf createXbcXmpDescOf(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIntConstant</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIntConstant
     */
    XbcIntConstant createXbcIntConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFloatConstant</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFloatConstant
     */
    XbcFloatConstant createXbcFloatConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLonglongConstant</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLonglongConstant
     */
    XbcLonglongConstant createXbcLonglongConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMoeConstant</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMoeConstant
     */
    XbcMoeConstant createXbcMoeConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFuncAddr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFuncAddr
     */
    XbcFuncAddr createXbcFuncAddr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSizeOfExpr
     */
    XbcSizeOfExpr createXbcSizeOfExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayAssignExpr
     */
    XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcModExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcModExpr
     */
    XbcModExpr createXbcModExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitOrExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitOrExpr
     */
    XbcBitOrExpr createXbcBitOrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogOrExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogOrExpr
     */
    XbcLogOrExpr createXbcLogOrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPlusExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPlusExpr
     */
    XbcPlusExpr createXbcPlusExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgPlusExpr
     */
    XbcAsgPlusExpr createXbcAsgPlusExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgModExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgModExpr
     */
    XbcAsgModExpr createXbcAsgModExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitOrExpr
     */
    XbcAsgBitOrExpr createXbcAsgBitOrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogGTExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGTExpr
     */
    XbcLogGTExpr createXbcLogGTExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCondExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondExpr
     */
    XbcCondExpr createXbcCondExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMinusExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMinusExpr
     */
    XbcMinusExpr createXbcMinusExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAddrOfExpr
     */
    XbcAddrOfExpr createXbcAddrOfExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLshiftExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLshiftExpr
     */
    XbcLshiftExpr createXbcLshiftExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcRshiftExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcRshiftExpr
     */
    XbcRshiftExpr createXbcRshiftExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitXorExpr
     */
    XbcAsgBitXorExpr createXbcAsgBitXorExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogEQExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogEQExpr
     */
    XbcLogEQExpr createXbcLogEQExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNEQExpr
     */
    XbcLogNEQExpr createXbcLogNEQExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogGEExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGEExpr
     */
    XbcLogGEExpr createXbcLogGEExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogLTExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLTExpr
     */
    XbcLogLTExpr createXbcLogLTExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAlignOfExpr
     */
    XbcGccAlignOfExpr createXbcGccAlignOfExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAssignExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAssignExpr
     */
    XbcAssignExpr createXbcAssignExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMulExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMulExpr
     */
    XbcMulExpr createXbcMulExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDivExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDivExpr
     */
    XbcDivExpr createXbcDivExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMulExpr
     */
    XbcAsgMulExpr createXbcAsgMulExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgRshiftExpr
     */
    XbcAsgRshiftExpr createXbcAsgRshiftExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitAndExpr
     */
    XbcAsgBitAndExpr createXbcAsgBitAndExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogLEExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLEExpr
     */
    XbcLogLEExpr createXbcLogLEExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogAndExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogAndExpr
     */
    XbcLogAndExpr createXbcLogAndExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCommaExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCommaExpr
     */
    XbcCommaExpr createXbcCommaExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgDivExpr
     */
    XbcAsgDivExpr createXbcAsgDivExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccLabelAddr
     */
    XbcGccLabelAddr createXbcGccLabelAddr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitAndExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitAndExpr
     */
    XbcBitAndExpr createXbcBitAndExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitXorExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitXorExpr
     */
    XbcBitXorExpr createXbcBitXorExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMinusExpr
     */
    XbcAsgMinusExpr createXbcAsgMinusExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgLshiftExpr
     */
    XbcAsgLshiftExpr createXbcAsgLshiftExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberAddr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberAddr
     */
    XbcMemberAddr createXbcMemberAddr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayRef
     */
    XbcMemberArrayRef createXbcMemberArrayRef(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayAddr
     */
    XbcMemberArrayAddr createXbcMemberArrayAddr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcTypeName</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeName
     */
    XbcTypeName createXbcTypeName(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPointerRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerRef
     */
    XbcPointerRef createXbcPointerRef(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnaryMinusExpr
     */
    XbcUnaryMinusExpr createXbcUnaryMinusExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitNotExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitNotExpr
     */
    XbcBitNotExpr createXbcBitNotExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLogNotExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNotExpr
     */
    XbcLogNotExpr createXbcLogNotExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostIncrExpr
     */
    XbcPostIncrExpr createXbcPostIncrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostDecrExpr
     */
    XbcPostDecrExpr createXbcPostDecrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreIncrExpr
     */
    XbcPreIncrExpr createXbcPreIncrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreDecrExpr
     */
    XbcPreDecrExpr createXbcPreDecrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIndexRange</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIndexRange
     */
    XbcIndexRange createXbcIndexRange(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcLowerBound</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLowerBound
     */
    XbcLowerBound createXbcLowerBound(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUpperBound</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUpperBound
     */
    XbcUpperBound createXbcUpperBound(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStep</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStep
     */
    XbcStep createXbcStep(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDesignatedValue</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDesignatedValue
     */
    XbcDesignatedValue createXbcDesignatedValue(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCompoundValue</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValue
     */
    XbcCompoundValue createXbcCompoundValue(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBitField</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitField
     */
    XbcBitField createXbcBitField(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPragma</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPragma
     */
    XbcPragma createXbcPragma(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcText</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcText
     */
    XbcText createXbcText(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDeclarations</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDeclarations
     */
    XbcDeclarations createXbcDeclarations(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDefinition
     */
    XbcFunctionDefinition createXbcFunctionDefinition(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcParams</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcParams
     */
    XbcParams createXbcParams(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBody</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBody
     */
    XbcBody createXbcBody(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmStatement
     */
    XbcGccAsmStatement createXbcGccAsmStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperands
     */
    XbcGccAsmOperands createXbcGccAsmOperands(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperand
     */
    XbcGccAsmOperand createXbcGccAsmOperand(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmClobbers
     */
    XbcGccAsmClobbers createXbcGccAsmClobbers(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcForStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcForStatement
     */
    XbcForStatement createXbcForStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcInit</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcInit
     */
    XbcInit createXbcInit(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCondition</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondition
     */
    XbcCondition createXbcCondition(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIter</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIter
     */
    XbcIter createXbcIter(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcIfStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIfStatement
     */
    XbcIfStatement createXbcIfStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcThen</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcThen
     */
    XbcThen createXbcThen(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcElse</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcElse
     */
    XbcElse createXbcElse(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcWhileStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcWhileStatement
     */
    XbcWhileStatement createXbcWhileStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDoStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDoStatement
     */
    XbcDoStatement createXbcDoStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcSwitchStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSwitchStatement
     */
    XbcSwitchStatement createXbcSwitchStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccRangedCaseLabel
     */
    XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStatementLabel</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStatementLabel
     */
    XbcStatementLabel createXbcStatementLabel(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCaseLabel</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCaseLabel
     */
    XbcCaseLabel createXbcCaseLabel(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBreakStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBreakStatement
     */
    XbcBreakStatement createXbcBreakStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcContinueStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcContinueStatement
     */
    XbcContinueStatement createXbcContinueStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcReturnStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcReturnStatement
     */
    XbcReturnStatement createXbcReturnStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGotoStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGotoStatement
     */
    XbcGotoStatement createXbcGotoStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcDefaultLabel</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDefaultLabel
     */
    XbcDefaultLabel createXbcDefaultLabel(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcExprStatement</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcExprStatement
     */
    XbcExprStatement createXbcExprStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcVarDecl</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarDecl
     */
    XbcVarDecl createXbcVarDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsm</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsm
     */
    XbcGccAsm createXbcGccAsm(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcFunctionDecl</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDecl
     */
    XbcFunctionDecl createXbcFunctionDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccMemberDesignator
     */
    XbcGccMemberDesignator createXbcGccMemberDesignator(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArrayType</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayType
     */
    XbcArrayType createXbcArrayType(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcArraySize</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArraySize
     */
    XbcArraySize createXbcArraySize(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcBasicType</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBasicType
     */
    XbcBasicType createXbcBasicType(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcPointerType</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerType
     */
    XbcPointerType createXbcPointerType(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcStructType</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStructType
     */
    XbcStructType createXbcStructType(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcUnionType</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnionType
     */
    XbcUnionType createXbcUnionType(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcEnumType</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcEnumType
     */
    XbcEnumType createXbcEnumType(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcCoArrayType</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayType
     */
    XbcCoArrayType createXbcCoArrayType(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalSymbols
     */
    XbcGlobalSymbols createXbcGlobalSymbols(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalDeclarations
     */
    XbcGlobalDeclarations createXbcGlobalDeclarations(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmDefinition
     */
    XbcGccAsmDefinition createXbcGccAsmDefinition(Reader reader) throws IOException, SAXException, ParserConfigurationException;

    /**
     * Creates a <code>XbcXcodeProgram</code>.
     *
     * @return XbcXcodeProgram
     */
    XbcXcodeProgram createXbcXcodeProgram();

    /**
     * Creates a <code>XbcTypeTable</code>.
     *
     * @return XbcTypeTable
     */
    XbcTypeTable createXbcTypeTable();

    /**
     * Creates a <code>XbcFunctionType</code>.
     *
     * @return XbcFunctionType
     */
    XbcFunctionType createXbcFunctionType();

    /**
     * Creates a <code>XbcGccAttributes</code>.
     *
     * @return XbcGccAttributes
     */
    XbcGccAttributes createXbcGccAttributes();

    /**
     * Creates a <code>XbcGccAttribute</code>.
     *
     * @return XbcGccAttribute
     */
    XbcGccAttribute createXbcGccAttribute();

    /**
     * Creates a <code>XbcBuiltinOp</code>.
     *
     * @return XbcBuiltinOp
     */
    XbcBuiltinOp createXbcBuiltinOp();

    /**
     * Creates a <code>XbcArrayRef</code>.
     *
     * @return XbcArrayRef
     */
    XbcArrayRef createXbcArrayRef();

    /**
     * Creates a <code>XbcArrayAddr</code>.
     *
     * @return XbcArrayAddr
     */
    XbcArrayAddr createXbcArrayAddr();

    /**
     * Creates a <code>XbcFunctionCall</code>.
     *
     * @return XbcFunctionCall
     */
    XbcFunctionCall createXbcFunctionCall();

    /**
     * Creates a <code>XbcFunction</code>.
     *
     * @return XbcFunction
     */
    XbcFunction createXbcFunction();

    /**
     * Creates a <code>XbcArguments</code>.
     *
     * @return XbcArguments
     */
    XbcArguments createXbcArguments();

    /**
     * Creates a <code>XbcGccCompoundExpr</code>.
     *
     * @return XbcGccCompoundExpr
     */
    XbcGccCompoundExpr createXbcGccCompoundExpr();

    /**
     * Creates a <code>XbcCompoundStatement</code>.
     *
     * @return XbcCompoundStatement
     */
    XbcCompoundStatement createXbcCompoundStatement();

    /**
     * Creates a <code>XbcSymbols</code>.
     *
     * @return XbcSymbols
     */
    XbcSymbols createXbcSymbols();

    /**
     * Creates a <code>XbcId</code>.
     *
     * @return XbcId
     */
    XbcId createXbcId();

    /**
     * Creates a <code>XbcName</code>.
     *
     * @return XbcName
     */
    XbcName createXbcName();

    /**
     * Creates a <code>XbcValue</code>.
     *
     * @return XbcValue
     */
    XbcValue createXbcValue();

    /**
     * Creates a <code>XbcSubArrayRef</code>.
     *
     * @return XbcSubArrayRef
     */
    XbcSubArrayRef createXbcSubArrayRef();

    /**
     * Creates a <code>XbcCoArrayRef</code>.
     *
     * @return XbcCoArrayRef
     */
    XbcCoArrayRef createXbcCoArrayRef();

    /**
     * Creates a <code>XbcVar</code>.
     *
     * @return XbcVar
     */
    XbcVar createXbcVar();

    /**
     * Creates a <code>XbcMemberRef</code>.
     *
     * @return XbcMemberRef
     */
    XbcMemberRef createXbcMemberRef();

    /**
     * Creates a <code>XbcCastExpr</code>.
     *
     * @return XbcCastExpr
     */
    XbcCastExpr createXbcCastExpr();

    /**
     * Creates a <code>XbcStringConstant</code>.
     *
     * @return XbcStringConstant
     */
    XbcStringConstant createXbcStringConstant();

    /**
     * Creates a <code>XbcVarAddr</code>.
     *
     * @return XbcVarAddr
     */
    XbcVarAddr createXbcVarAddr();

    /**
     * Creates a <code>XbcCompoundValueExpr</code>.
     *
     * @return XbcCompoundValueExpr
     */
    XbcCompoundValueExpr createXbcCompoundValueExpr();

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code>.
     *
     * @return XbcCompoundValueAddrExpr
     */
    XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr();

    /**
     * Creates a <code>XbcXmpDescOf</code>.
     *
     * @return XbcXmpDescOf
     */
    XbcXmpDescOf createXbcXmpDescOf();

    /**
     * Creates a <code>XbcIntConstant</code>.
     *
     * @return XbcIntConstant
     */
    XbcIntConstant createXbcIntConstant();

    /**
     * Creates a <code>XbcFloatConstant</code>.
     *
     * @return XbcFloatConstant
     */
    XbcFloatConstant createXbcFloatConstant();

    /**
     * Creates a <code>XbcLonglongConstant</code>.
     *
     * @return XbcLonglongConstant
     */
    XbcLonglongConstant createXbcLonglongConstant();

    /**
     * Creates a <code>XbcMoeConstant</code>.
     *
     * @return XbcMoeConstant
     */
    XbcMoeConstant createXbcMoeConstant();

    /**
     * Creates a <code>XbcFuncAddr</code>.
     *
     * @return XbcFuncAddr
     */
    XbcFuncAddr createXbcFuncAddr();

    /**
     * Creates a <code>XbcSizeOfExpr</code>.
     *
     * @return XbcSizeOfExpr
     */
    XbcSizeOfExpr createXbcSizeOfExpr();

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code>.
     *
     * @return XbcCoArrayAssignExpr
     */
    XbcCoArrayAssignExpr createXbcCoArrayAssignExpr();

    /**
     * Creates a <code>XbcModExpr</code>.
     *
     * @return XbcModExpr
     */
    XbcModExpr createXbcModExpr();

    /**
     * Creates a <code>XbcBitOrExpr</code>.
     *
     * @return XbcBitOrExpr
     */
    XbcBitOrExpr createXbcBitOrExpr();

    /**
     * Creates a <code>XbcLogOrExpr</code>.
     *
     * @return XbcLogOrExpr
     */
    XbcLogOrExpr createXbcLogOrExpr();

    /**
     * Creates a <code>XbcPlusExpr</code>.
     *
     * @return XbcPlusExpr
     */
    XbcPlusExpr createXbcPlusExpr();

    /**
     * Creates a <code>XbcAsgPlusExpr</code>.
     *
     * @return XbcAsgPlusExpr
     */
    XbcAsgPlusExpr createXbcAsgPlusExpr();

    /**
     * Creates a <code>XbcAsgModExpr</code>.
     *
     * @return XbcAsgModExpr
     */
    XbcAsgModExpr createXbcAsgModExpr();

    /**
     * Creates a <code>XbcAsgBitOrExpr</code>.
     *
     * @return XbcAsgBitOrExpr
     */
    XbcAsgBitOrExpr createXbcAsgBitOrExpr();

    /**
     * Creates a <code>XbcLogGTExpr</code>.
     *
     * @return XbcLogGTExpr
     */
    XbcLogGTExpr createXbcLogGTExpr();

    /**
     * Creates a <code>XbcCondExpr</code>.
     *
     * @return XbcCondExpr
     */
    XbcCondExpr createXbcCondExpr();

    /**
     * Creates a <code>XbcMinusExpr</code>.
     *
     * @return XbcMinusExpr
     */
    XbcMinusExpr createXbcMinusExpr();

    /**
     * Creates a <code>XbcAddrOfExpr</code>.
     *
     * @return XbcAddrOfExpr
     */
    XbcAddrOfExpr createXbcAddrOfExpr();

    /**
     * Creates a <code>XbcLshiftExpr</code>.
     *
     * @return XbcLshiftExpr
     */
    XbcLshiftExpr createXbcLshiftExpr();

    /**
     * Creates a <code>XbcRshiftExpr</code>.
     *
     * @return XbcRshiftExpr
     */
    XbcRshiftExpr createXbcRshiftExpr();

    /**
     * Creates a <code>XbcAsgBitXorExpr</code>.
     *
     * @return XbcAsgBitXorExpr
     */
    XbcAsgBitXorExpr createXbcAsgBitXorExpr();

    /**
     * Creates a <code>XbcLogEQExpr</code>.
     *
     * @return XbcLogEQExpr
     */
    XbcLogEQExpr createXbcLogEQExpr();

    /**
     * Creates a <code>XbcLogNEQExpr</code>.
     *
     * @return XbcLogNEQExpr
     */
    XbcLogNEQExpr createXbcLogNEQExpr();

    /**
     * Creates a <code>XbcLogGEExpr</code>.
     *
     * @return XbcLogGEExpr
     */
    XbcLogGEExpr createXbcLogGEExpr();

    /**
     * Creates a <code>XbcLogLTExpr</code>.
     *
     * @return XbcLogLTExpr
     */
    XbcLogLTExpr createXbcLogLTExpr();

    /**
     * Creates a <code>XbcGccAlignOfExpr</code>.
     *
     * @return XbcGccAlignOfExpr
     */
    XbcGccAlignOfExpr createXbcGccAlignOfExpr();

    /**
     * Creates a <code>XbcAssignExpr</code>.
     *
     * @return XbcAssignExpr
     */
    XbcAssignExpr createXbcAssignExpr();

    /**
     * Creates a <code>XbcMulExpr</code>.
     *
     * @return XbcMulExpr
     */
    XbcMulExpr createXbcMulExpr();

    /**
     * Creates a <code>XbcDivExpr</code>.
     *
     * @return XbcDivExpr
     */
    XbcDivExpr createXbcDivExpr();

    /**
     * Creates a <code>XbcAsgMulExpr</code>.
     *
     * @return XbcAsgMulExpr
     */
    XbcAsgMulExpr createXbcAsgMulExpr();

    /**
     * Creates a <code>XbcAsgRshiftExpr</code>.
     *
     * @return XbcAsgRshiftExpr
     */
    XbcAsgRshiftExpr createXbcAsgRshiftExpr();

    /**
     * Creates a <code>XbcAsgBitAndExpr</code>.
     *
     * @return XbcAsgBitAndExpr
     */
    XbcAsgBitAndExpr createXbcAsgBitAndExpr();

    /**
     * Creates a <code>XbcLogLEExpr</code>.
     *
     * @return XbcLogLEExpr
     */
    XbcLogLEExpr createXbcLogLEExpr();

    /**
     * Creates a <code>XbcLogAndExpr</code>.
     *
     * @return XbcLogAndExpr
     */
    XbcLogAndExpr createXbcLogAndExpr();

    /**
     * Creates a <code>XbcCommaExpr</code>.
     *
     * @return XbcCommaExpr
     */
    XbcCommaExpr createXbcCommaExpr();

    /**
     * Creates a <code>XbcAsgDivExpr</code>.
     *
     * @return XbcAsgDivExpr
     */
    XbcAsgDivExpr createXbcAsgDivExpr();

    /**
     * Creates a <code>XbcGccLabelAddr</code>.
     *
     * @return XbcGccLabelAddr
     */
    XbcGccLabelAddr createXbcGccLabelAddr();

    /**
     * Creates a <code>XbcBitAndExpr</code>.
     *
     * @return XbcBitAndExpr
     */
    XbcBitAndExpr createXbcBitAndExpr();

    /**
     * Creates a <code>XbcBitXorExpr</code>.
     *
     * @return XbcBitXorExpr
     */
    XbcBitXorExpr createXbcBitXorExpr();

    /**
     * Creates a <code>XbcAsgMinusExpr</code>.
     *
     * @return XbcAsgMinusExpr
     */
    XbcAsgMinusExpr createXbcAsgMinusExpr();

    /**
     * Creates a <code>XbcAsgLshiftExpr</code>.
     *
     * @return XbcAsgLshiftExpr
     */
    XbcAsgLshiftExpr createXbcAsgLshiftExpr();

    /**
     * Creates a <code>XbcMemberAddr</code>.
     *
     * @return XbcMemberAddr
     */
    XbcMemberAddr createXbcMemberAddr();

    /**
     * Creates a <code>XbcMemberArrayRef</code>.
     *
     * @return XbcMemberArrayRef
     */
    XbcMemberArrayRef createXbcMemberArrayRef();

    /**
     * Creates a <code>XbcMemberArrayAddr</code>.
     *
     * @return XbcMemberArrayAddr
     */
    XbcMemberArrayAddr createXbcMemberArrayAddr();

    /**
     * Creates a <code>XbcTypeName</code>.
     *
     * @return XbcTypeName
     */
    XbcTypeName createXbcTypeName();

    /**
     * Creates a <code>XbcPointerRef</code>.
     *
     * @return XbcPointerRef
     */
    XbcPointerRef createXbcPointerRef();

    /**
     * Creates a <code>XbcUnaryMinusExpr</code>.
     *
     * @return XbcUnaryMinusExpr
     */
    XbcUnaryMinusExpr createXbcUnaryMinusExpr();

    /**
     * Creates a <code>XbcBitNotExpr</code>.
     *
     * @return XbcBitNotExpr
     */
    XbcBitNotExpr createXbcBitNotExpr();

    /**
     * Creates a <code>XbcLogNotExpr</code>.
     *
     * @return XbcLogNotExpr
     */
    XbcLogNotExpr createXbcLogNotExpr();

    /**
     * Creates a <code>XbcPostIncrExpr</code>.
     *
     * @return XbcPostIncrExpr
     */
    XbcPostIncrExpr createXbcPostIncrExpr();

    /**
     * Creates a <code>XbcPostDecrExpr</code>.
     *
     * @return XbcPostDecrExpr
     */
    XbcPostDecrExpr createXbcPostDecrExpr();

    /**
     * Creates a <code>XbcPreIncrExpr</code>.
     *
     * @return XbcPreIncrExpr
     */
    XbcPreIncrExpr createXbcPreIncrExpr();

    /**
     * Creates a <code>XbcPreDecrExpr</code>.
     *
     * @return XbcPreDecrExpr
     */
    XbcPreDecrExpr createXbcPreDecrExpr();

    /**
     * Creates a <code>XbcIndexRange</code>.
     *
     * @return XbcIndexRange
     */
    XbcIndexRange createXbcIndexRange();

    /**
     * Creates a <code>XbcLowerBound</code>.
     *
     * @return XbcLowerBound
     */
    XbcLowerBound createXbcLowerBound();

    /**
     * Creates a <code>XbcUpperBound</code>.
     *
     * @return XbcUpperBound
     */
    XbcUpperBound createXbcUpperBound();

    /**
     * Creates a <code>XbcStep</code>.
     *
     * @return XbcStep
     */
    XbcStep createXbcStep();

    /**
     * Creates a <code>XbcDesignatedValue</code>.
     *
     * @return XbcDesignatedValue
     */
    XbcDesignatedValue createXbcDesignatedValue();

    /**
     * Creates a <code>XbcCompoundValue</code>.
     *
     * @return XbcCompoundValue
     */
    XbcCompoundValue createXbcCompoundValue();

    /**
     * Creates a <code>XbcBitField</code>.
     *
     * @return XbcBitField
     */
    XbcBitField createXbcBitField();

    /**
     * Creates a <code>XbcPragma</code>.
     *
     * @return XbcPragma
     */
    XbcPragma createXbcPragma();

    /**
     * Creates a <code>XbcText</code>.
     *
     * @return XbcText
     */
    XbcText createXbcText();

    /**
     * Creates a <code>XbcDeclarations</code>.
     *
     * @return XbcDeclarations
     */
    XbcDeclarations createXbcDeclarations();

    /**
     * Creates a <code>XbcFunctionDefinition</code>.
     *
     * @return XbcFunctionDefinition
     */
    XbcFunctionDefinition createXbcFunctionDefinition();

    /**
     * Creates a <code>XbcParams</code>.
     *
     * @return XbcParams
     */
    XbcParams createXbcParams();

    /**
     * Creates a <code>XbcBody</code>.
     *
     * @return XbcBody
     */
    XbcBody createXbcBody();

    /**
     * Creates a <code>XbcGccAsmStatement</code>.
     *
     * @return XbcGccAsmStatement
     */
    XbcGccAsmStatement createXbcGccAsmStatement();

    /**
     * Creates a <code>XbcGccAsmOperands</code>.
     *
     * @return XbcGccAsmOperands
     */
    XbcGccAsmOperands createXbcGccAsmOperands();

    /**
     * Creates a <code>XbcGccAsmOperand</code>.
     *
     * @return XbcGccAsmOperand
     */
    XbcGccAsmOperand createXbcGccAsmOperand();

    /**
     * Creates a <code>XbcGccAsmClobbers</code>.
     *
     * @return XbcGccAsmClobbers
     */
    XbcGccAsmClobbers createXbcGccAsmClobbers();

    /**
     * Creates a <code>XbcForStatement</code>.
     *
     * @return XbcForStatement
     */
    XbcForStatement createXbcForStatement();

    /**
     * Creates a <code>XbcInit</code>.
     *
     * @return XbcInit
     */
    XbcInit createXbcInit();

    /**
     * Creates a <code>XbcCondition</code>.
     *
     * @return XbcCondition
     */
    XbcCondition createXbcCondition();

    /**
     * Creates a <code>XbcIter</code>.
     *
     * @return XbcIter
     */
    XbcIter createXbcIter();

    /**
     * Creates a <code>XbcIfStatement</code>.
     *
     * @return XbcIfStatement
     */
    XbcIfStatement createXbcIfStatement();

    /**
     * Creates a <code>XbcThen</code>.
     *
     * @return XbcThen
     */
    XbcThen createXbcThen();

    /**
     * Creates a <code>XbcElse</code>.
     *
     * @return XbcElse
     */
    XbcElse createXbcElse();

    /**
     * Creates a <code>XbcWhileStatement</code>.
     *
     * @return XbcWhileStatement
     */
    XbcWhileStatement createXbcWhileStatement();

    /**
     * Creates a <code>XbcDoStatement</code>.
     *
     * @return XbcDoStatement
     */
    XbcDoStatement createXbcDoStatement();

    /**
     * Creates a <code>XbcSwitchStatement</code>.
     *
     * @return XbcSwitchStatement
     */
    XbcSwitchStatement createXbcSwitchStatement();

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code>.
     *
     * @return XbcGccRangedCaseLabel
     */
    XbcGccRangedCaseLabel createXbcGccRangedCaseLabel();

    /**
     * Creates a <code>XbcStatementLabel</code>.
     *
     * @return XbcStatementLabel
     */
    XbcStatementLabel createXbcStatementLabel();

    /**
     * Creates a <code>XbcCaseLabel</code>.
     *
     * @return XbcCaseLabel
     */
    XbcCaseLabel createXbcCaseLabel();

    /**
     * Creates a <code>XbcBreakStatement</code>.
     *
     * @return XbcBreakStatement
     */
    XbcBreakStatement createXbcBreakStatement();

    /**
     * Creates a <code>XbcContinueStatement</code>.
     *
     * @return XbcContinueStatement
     */
    XbcContinueStatement createXbcContinueStatement();

    /**
     * Creates a <code>XbcReturnStatement</code>.
     *
     * @return XbcReturnStatement
     */
    XbcReturnStatement createXbcReturnStatement();

    /**
     * Creates a <code>XbcGotoStatement</code>.
     *
     * @return XbcGotoStatement
     */
    XbcGotoStatement createXbcGotoStatement();

    /**
     * Creates a <code>XbcDefaultLabel</code>.
     *
     * @return XbcDefaultLabel
     */
    XbcDefaultLabel createXbcDefaultLabel();

    /**
     * Creates a <code>XbcExprStatement</code>.
     *
     * @return XbcExprStatement
     */
    XbcExprStatement createXbcExprStatement();

    /**
     * Creates a <code>XbcVarDecl</code>.
     *
     * @return XbcVarDecl
     */
    XbcVarDecl createXbcVarDecl();

    /**
     * Creates a <code>XbcGccAsm</code>.
     *
     * @return XbcGccAsm
     */
    XbcGccAsm createXbcGccAsm();

    /**
     * Creates a <code>XbcFunctionDecl</code>.
     *
     * @return XbcFunctionDecl
     */
    XbcFunctionDecl createXbcFunctionDecl();

    /**
     * Creates a <code>XbcGccMemberDesignator</code>.
     *
     * @return XbcGccMemberDesignator
     */
    XbcGccMemberDesignator createXbcGccMemberDesignator();

    /**
     * Creates a <code>XbcArrayType</code>.
     *
     * @return XbcArrayType
     */
    XbcArrayType createXbcArrayType();

    /**
     * Creates a <code>XbcArraySize</code>.
     *
     * @return XbcArraySize
     */
    XbcArraySize createXbcArraySize();

    /**
     * Creates a <code>XbcBasicType</code>.
     *
     * @return XbcBasicType
     */
    XbcBasicType createXbcBasicType();

    /**
     * Creates a <code>XbcPointerType</code>.
     *
     * @return XbcPointerType
     */
    XbcPointerType createXbcPointerType();

    /**
     * Creates a <code>XbcStructType</code>.
     *
     * @return XbcStructType
     */
    XbcStructType createXbcStructType();

    /**
     * Creates a <code>XbcUnionType</code>.
     *
     * @return XbcUnionType
     */
    XbcUnionType createXbcUnionType();

    /**
     * Creates a <code>XbcEnumType</code>.
     *
     * @return XbcEnumType
     */
    XbcEnumType createXbcEnumType();

    /**
     * Creates a <code>XbcCoArrayType</code>.
     *
     * @return XbcCoArrayType
     */
    XbcCoArrayType createXbcCoArrayType();

    /**
     * Creates a <code>XbcGlobalSymbols</code>.
     *
     * @return XbcGlobalSymbols
     */
    XbcGlobalSymbols createXbcGlobalSymbols();

    /**
     * Creates a <code>XbcGlobalDeclarations</code>.
     *
     * @return XbcGlobalDeclarations
     */
    XbcGlobalDeclarations createXbcGlobalDeclarations();

    /**
     * Creates a <code>XbcGccAsmDefinition</code>.
     *
     * @return XbcGccAsmDefinition
     */
    XbcGccAsmDefinition createXbcGccAsmDefinition();

    /**
     * Creates a <code>XbcXcodeProgram</code> by the XbcXcodeProgram <code>source</code>.
     *
     * @param source
     * @return XbcXcodeProgram
     */
    XbcXcodeProgram createXbcXcodeProgram(XbcXcodeProgram source);

    /**
     * Creates a <code>XbcTypeTable</code> by the XbcTypeTable <code>source</code>.
     *
     * @param source
     * @return XbcTypeTable
     */
    XbcTypeTable createXbcTypeTable(XbcTypeTable source);

    /**
     * Creates a <code>XbcFunctionType</code> by the XbcFunctionType <code>source</code>.
     *
     * @param source
     * @return XbcFunctionType
     */
    XbcFunctionType createXbcFunctionType(XbcFunctionType source);

    /**
     * Creates a <code>XbcGccAttributes</code> by the XbcGccAttributes <code>source</code>.
     *
     * @param source
     * @return XbcGccAttributes
     */
    XbcGccAttributes createXbcGccAttributes(XbcGccAttributes source);

    /**
     * Creates a <code>XbcGccAttribute</code> by the XbcGccAttribute <code>source</code>.
     *
     * @param source
     * @return XbcGccAttribute
     */
    XbcGccAttribute createXbcGccAttribute(XbcGccAttribute source);

    /**
     * Creates a <code>XbcBuiltinOp</code> by the XbcBuiltinOp <code>source</code>.
     *
     * @param source
     * @return XbcBuiltinOp
     */
    XbcBuiltinOp createXbcBuiltinOp(XbcBuiltinOp source);

    /**
     * Creates a <code>XbcArrayRef</code> by the XbcArrayRef <code>source</code>.
     *
     * @param source
     * @return XbcArrayRef
     */
    XbcArrayRef createXbcArrayRef(XbcArrayRef source);

    /**
     * Creates a <code>XbcArrayAddr</code> by the XbcArrayAddr <code>source</code>.
     *
     * @param source
     * @return XbcArrayAddr
     */
    XbcArrayAddr createXbcArrayAddr(XbcArrayAddr source);

    /**
     * Creates a <code>XbcFunctionCall</code> by the XbcFunctionCall <code>source</code>.
     *
     * @param source
     * @return XbcFunctionCall
     */
    XbcFunctionCall createXbcFunctionCall(XbcFunctionCall source);

    /**
     * Creates a <code>XbcFunction</code> by the XbcFunction <code>source</code>.
     *
     * @param source
     * @return XbcFunction
     */
    XbcFunction createXbcFunction(XbcFunction source);

    /**
     * Creates a <code>XbcArguments</code> by the XbcArguments <code>source</code>.
     *
     * @param source
     * @return XbcArguments
     */
    XbcArguments createXbcArguments(XbcArguments source);

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the XbcGccCompoundExpr <code>source</code>.
     *
     * @param source
     * @return XbcGccCompoundExpr
     */
    XbcGccCompoundExpr createXbcGccCompoundExpr(XbcGccCompoundExpr source);

    /**
     * Creates a <code>XbcCompoundStatement</code> by the XbcCompoundStatement <code>source</code>.
     *
     * @param source
     * @return XbcCompoundStatement
     */
    XbcCompoundStatement createXbcCompoundStatement(XbcCompoundStatement source);

    /**
     * Creates a <code>XbcSymbols</code> by the XbcSymbols <code>source</code>.
     *
     * @param source
     * @return XbcSymbols
     */
    XbcSymbols createXbcSymbols(XbcSymbols source);

    /**
     * Creates a <code>XbcId</code> by the XbcId <code>source</code>.
     *
     * @param source
     * @return XbcId
     */
    XbcId createXbcId(XbcId source);

    /**
     * Creates a <code>XbcName</code> by the XbcName <code>source</code>.
     *
     * @param source
     * @return XbcName
     */
    XbcName createXbcName(XbcName source);

    /**
     * Creates a <code>XbcValue</code> by the XbcValue <code>source</code>.
     *
     * @param source
     * @return XbcValue
     */
    XbcValue createXbcValue(XbcValue source);

    /**
     * Creates a <code>XbcSubArrayRef</code> by the XbcSubArrayRef <code>source</code>.
     *
     * @param source
     * @return XbcSubArrayRef
     */
    XbcSubArrayRef createXbcSubArrayRef(XbcSubArrayRef source);

    /**
     * Creates a <code>XbcCoArrayRef</code> by the XbcCoArrayRef <code>source</code>.
     *
     * @param source
     * @return XbcCoArrayRef
     */
    XbcCoArrayRef createXbcCoArrayRef(XbcCoArrayRef source);

    /**
     * Creates a <code>XbcVar</code> by the XbcVar <code>source</code>.
     *
     * @param source
     * @return XbcVar
     */
    XbcVar createXbcVar(XbcVar source);

    /**
     * Creates a <code>XbcMemberRef</code> by the XbcMemberRef <code>source</code>.
     *
     * @param source
     * @return XbcMemberRef
     */
    XbcMemberRef createXbcMemberRef(XbcMemberRef source);

    /**
     * Creates a <code>XbcCastExpr</code> by the XbcCastExpr <code>source</code>.
     *
     * @param source
     * @return XbcCastExpr
     */
    XbcCastExpr createXbcCastExpr(XbcCastExpr source);

    /**
     * Creates a <code>XbcStringConstant</code> by the XbcStringConstant <code>source</code>.
     *
     * @param source
     * @return XbcStringConstant
     */
    XbcStringConstant createXbcStringConstant(XbcStringConstant source);

    /**
     * Creates a <code>XbcVarAddr</code> by the XbcVarAddr <code>source</code>.
     *
     * @param source
     * @return XbcVarAddr
     */
    XbcVarAddr createXbcVarAddr(XbcVarAddr source);

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the XbcCompoundValueExpr <code>source</code>.
     *
     * @param source
     * @return XbcCompoundValueExpr
     */
    XbcCompoundValueExpr createXbcCompoundValueExpr(XbcCompoundValueExpr source);

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the XbcCompoundValueAddrExpr <code>source</code>.
     *
     * @param source
     * @return XbcCompoundValueAddrExpr
     */
    XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(XbcCompoundValueAddrExpr source);

    /**
     * Creates a <code>XbcXmpDescOf</code> by the XbcXmpDescOf <code>source</code>.
     *
     * @param source
     * @return XbcXmpDescOf
     */
    XbcXmpDescOf createXbcXmpDescOf(XbcXmpDescOf source);

    /**
     * Creates a <code>XbcIntConstant</code> by the XbcIntConstant <code>source</code>.
     *
     * @param source
     * @return XbcIntConstant
     */
    XbcIntConstant createXbcIntConstant(XbcIntConstant source);

    /**
     * Creates a <code>XbcFloatConstant</code> by the XbcFloatConstant <code>source</code>.
     *
     * @param source
     * @return XbcFloatConstant
     */
    XbcFloatConstant createXbcFloatConstant(XbcFloatConstant source);

    /**
     * Creates a <code>XbcLonglongConstant</code> by the XbcLonglongConstant <code>source</code>.
     *
     * @param source
     * @return XbcLonglongConstant
     */
    XbcLonglongConstant createXbcLonglongConstant(XbcLonglongConstant source);

    /**
     * Creates a <code>XbcMoeConstant</code> by the XbcMoeConstant <code>source</code>.
     *
     * @param source
     * @return XbcMoeConstant
     */
    XbcMoeConstant createXbcMoeConstant(XbcMoeConstant source);

    /**
     * Creates a <code>XbcFuncAddr</code> by the XbcFuncAddr <code>source</code>.
     *
     * @param source
     * @return XbcFuncAddr
     */
    XbcFuncAddr createXbcFuncAddr(XbcFuncAddr source);

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the XbcSizeOfExpr <code>source</code>.
     *
     * @param source
     * @return XbcSizeOfExpr
     */
    XbcSizeOfExpr createXbcSizeOfExpr(XbcSizeOfExpr source);

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the XbcCoArrayAssignExpr <code>source</code>.
     *
     * @param source
     * @return XbcCoArrayAssignExpr
     */
    XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(XbcCoArrayAssignExpr source);

    /**
     * Creates a <code>XbcModExpr</code> by the XbcModExpr <code>source</code>.
     *
     * @param source
     * @return XbcModExpr
     */
    XbcModExpr createXbcModExpr(XbcModExpr source);

    /**
     * Creates a <code>XbcBitOrExpr</code> by the XbcBitOrExpr <code>source</code>.
     *
     * @param source
     * @return XbcBitOrExpr
     */
    XbcBitOrExpr createXbcBitOrExpr(XbcBitOrExpr source);

    /**
     * Creates a <code>XbcLogOrExpr</code> by the XbcLogOrExpr <code>source</code>.
     *
     * @param source
     * @return XbcLogOrExpr
     */
    XbcLogOrExpr createXbcLogOrExpr(XbcLogOrExpr source);

    /**
     * Creates a <code>XbcPlusExpr</code> by the XbcPlusExpr <code>source</code>.
     *
     * @param source
     * @return XbcPlusExpr
     */
    XbcPlusExpr createXbcPlusExpr(XbcPlusExpr source);

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the XbcAsgPlusExpr <code>source</code>.
     *
     * @param source
     * @return XbcAsgPlusExpr
     */
    XbcAsgPlusExpr createXbcAsgPlusExpr(XbcAsgPlusExpr source);

    /**
     * Creates a <code>XbcAsgModExpr</code> by the XbcAsgModExpr <code>source</code>.
     *
     * @param source
     * @return XbcAsgModExpr
     */
    XbcAsgModExpr createXbcAsgModExpr(XbcAsgModExpr source);

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the XbcAsgBitOrExpr <code>source</code>.
     *
     * @param source
     * @return XbcAsgBitOrExpr
     */
    XbcAsgBitOrExpr createXbcAsgBitOrExpr(XbcAsgBitOrExpr source);

    /**
     * Creates a <code>XbcLogGTExpr</code> by the XbcLogGTExpr <code>source</code>.
     *
     * @param source
     * @return XbcLogGTExpr
     */
    XbcLogGTExpr createXbcLogGTExpr(XbcLogGTExpr source);

    /**
     * Creates a <code>XbcCondExpr</code> by the XbcCondExpr <code>source</code>.
     *
     * @param source
     * @return XbcCondExpr
     */
    XbcCondExpr createXbcCondExpr(XbcCondExpr source);

    /**
     * Creates a <code>XbcMinusExpr</code> by the XbcMinusExpr <code>source</code>.
     *
     * @param source
     * @return XbcMinusExpr
     */
    XbcMinusExpr createXbcMinusExpr(XbcMinusExpr source);

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the XbcAddrOfExpr <code>source</code>.
     *
     * @param source
     * @return XbcAddrOfExpr
     */
    XbcAddrOfExpr createXbcAddrOfExpr(XbcAddrOfExpr source);

    /**
     * Creates a <code>XbcLshiftExpr</code> by the XbcLshiftExpr <code>source</code>.
     *
     * @param source
     * @return XbcLshiftExpr
     */
    XbcLshiftExpr createXbcLshiftExpr(XbcLshiftExpr source);

    /**
     * Creates a <code>XbcRshiftExpr</code> by the XbcRshiftExpr <code>source</code>.
     *
     * @param source
     * @return XbcRshiftExpr
     */
    XbcRshiftExpr createXbcRshiftExpr(XbcRshiftExpr source);

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the XbcAsgBitXorExpr <code>source</code>.
     *
     * @param source
     * @return XbcAsgBitXorExpr
     */
    XbcAsgBitXorExpr createXbcAsgBitXorExpr(XbcAsgBitXorExpr source);

    /**
     * Creates a <code>XbcLogEQExpr</code> by the XbcLogEQExpr <code>source</code>.
     *
     * @param source
     * @return XbcLogEQExpr
     */
    XbcLogEQExpr createXbcLogEQExpr(XbcLogEQExpr source);

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the XbcLogNEQExpr <code>source</code>.
     *
     * @param source
     * @return XbcLogNEQExpr
     */
    XbcLogNEQExpr createXbcLogNEQExpr(XbcLogNEQExpr source);

    /**
     * Creates a <code>XbcLogGEExpr</code> by the XbcLogGEExpr <code>source</code>.
     *
     * @param source
     * @return XbcLogGEExpr
     */
    XbcLogGEExpr createXbcLogGEExpr(XbcLogGEExpr source);

    /**
     * Creates a <code>XbcLogLTExpr</code> by the XbcLogLTExpr <code>source</code>.
     *
     * @param source
     * @return XbcLogLTExpr
     */
    XbcLogLTExpr createXbcLogLTExpr(XbcLogLTExpr source);

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the XbcGccAlignOfExpr <code>source</code>.
     *
     * @param source
     * @return XbcGccAlignOfExpr
     */
    XbcGccAlignOfExpr createXbcGccAlignOfExpr(XbcGccAlignOfExpr source);

    /**
     * Creates a <code>XbcAssignExpr</code> by the XbcAssignExpr <code>source</code>.
     *
     * @param source
     * @return XbcAssignExpr
     */
    XbcAssignExpr createXbcAssignExpr(XbcAssignExpr source);

    /**
     * Creates a <code>XbcMulExpr</code> by the XbcMulExpr <code>source</code>.
     *
     * @param source
     * @return XbcMulExpr
     */
    XbcMulExpr createXbcMulExpr(XbcMulExpr source);

    /**
     * Creates a <code>XbcDivExpr</code> by the XbcDivExpr <code>source</code>.
     *
     * @param source
     * @return XbcDivExpr
     */
    XbcDivExpr createXbcDivExpr(XbcDivExpr source);

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the XbcAsgMulExpr <code>source</code>.
     *
     * @param source
     * @return XbcAsgMulExpr
     */
    XbcAsgMulExpr createXbcAsgMulExpr(XbcAsgMulExpr source);

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the XbcAsgRshiftExpr <code>source</code>.
     *
     * @param source
     * @return XbcAsgRshiftExpr
     */
    XbcAsgRshiftExpr createXbcAsgRshiftExpr(XbcAsgRshiftExpr source);

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the XbcAsgBitAndExpr <code>source</code>.
     *
     * @param source
     * @return XbcAsgBitAndExpr
     */
    XbcAsgBitAndExpr createXbcAsgBitAndExpr(XbcAsgBitAndExpr source);

    /**
     * Creates a <code>XbcLogLEExpr</code> by the XbcLogLEExpr <code>source</code>.
     *
     * @param source
     * @return XbcLogLEExpr
     */
    XbcLogLEExpr createXbcLogLEExpr(XbcLogLEExpr source);

    /**
     * Creates a <code>XbcLogAndExpr</code> by the XbcLogAndExpr <code>source</code>.
     *
     * @param source
     * @return XbcLogAndExpr
     */
    XbcLogAndExpr createXbcLogAndExpr(XbcLogAndExpr source);

    /**
     * Creates a <code>XbcCommaExpr</code> by the XbcCommaExpr <code>source</code>.
     *
     * @param source
     * @return XbcCommaExpr
     */
    XbcCommaExpr createXbcCommaExpr(XbcCommaExpr source);

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the XbcAsgDivExpr <code>source</code>.
     *
     * @param source
     * @return XbcAsgDivExpr
     */
    XbcAsgDivExpr createXbcAsgDivExpr(XbcAsgDivExpr source);

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the XbcGccLabelAddr <code>source</code>.
     *
     * @param source
     * @return XbcGccLabelAddr
     */
    XbcGccLabelAddr createXbcGccLabelAddr(XbcGccLabelAddr source);

    /**
     * Creates a <code>XbcBitAndExpr</code> by the XbcBitAndExpr <code>source</code>.
     *
     * @param source
     * @return XbcBitAndExpr
     */
    XbcBitAndExpr createXbcBitAndExpr(XbcBitAndExpr source);

    /**
     * Creates a <code>XbcBitXorExpr</code> by the XbcBitXorExpr <code>source</code>.
     *
     * @param source
     * @return XbcBitXorExpr
     */
    XbcBitXorExpr createXbcBitXorExpr(XbcBitXorExpr source);

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the XbcAsgMinusExpr <code>source</code>.
     *
     * @param source
     * @return XbcAsgMinusExpr
     */
    XbcAsgMinusExpr createXbcAsgMinusExpr(XbcAsgMinusExpr source);

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the XbcAsgLshiftExpr <code>source</code>.
     *
     * @param source
     * @return XbcAsgLshiftExpr
     */
    XbcAsgLshiftExpr createXbcAsgLshiftExpr(XbcAsgLshiftExpr source);

    /**
     * Creates a <code>XbcMemberAddr</code> by the XbcMemberAddr <code>source</code>.
     *
     * @param source
     * @return XbcMemberAddr
     */
    XbcMemberAddr createXbcMemberAddr(XbcMemberAddr source);

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the XbcMemberArrayRef <code>source</code>.
     *
     * @param source
     * @return XbcMemberArrayRef
     */
    XbcMemberArrayRef createXbcMemberArrayRef(XbcMemberArrayRef source);

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the XbcMemberArrayAddr <code>source</code>.
     *
     * @param source
     * @return XbcMemberArrayAddr
     */
    XbcMemberArrayAddr createXbcMemberArrayAddr(XbcMemberArrayAddr source);

    /**
     * Creates a <code>XbcTypeName</code> by the XbcTypeName <code>source</code>.
     *
     * @param source
     * @return XbcTypeName
     */
    XbcTypeName createXbcTypeName(XbcTypeName source);

    /**
     * Creates a <code>XbcPointerRef</code> by the XbcPointerRef <code>source</code>.
     *
     * @param source
     * @return XbcPointerRef
     */
    XbcPointerRef createXbcPointerRef(XbcPointerRef source);

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the XbcUnaryMinusExpr <code>source</code>.
     *
     * @param source
     * @return XbcUnaryMinusExpr
     */
    XbcUnaryMinusExpr createXbcUnaryMinusExpr(XbcUnaryMinusExpr source);

    /**
     * Creates a <code>XbcBitNotExpr</code> by the XbcBitNotExpr <code>source</code>.
     *
     * @param source
     * @return XbcBitNotExpr
     */
    XbcBitNotExpr createXbcBitNotExpr(XbcBitNotExpr source);

    /**
     * Creates a <code>XbcLogNotExpr</code> by the XbcLogNotExpr <code>source</code>.
     *
     * @param source
     * @return XbcLogNotExpr
     */
    XbcLogNotExpr createXbcLogNotExpr(XbcLogNotExpr source);

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the XbcPostIncrExpr <code>source</code>.
     *
     * @param source
     * @return XbcPostIncrExpr
     */
    XbcPostIncrExpr createXbcPostIncrExpr(XbcPostIncrExpr source);

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the XbcPostDecrExpr <code>source</code>.
     *
     * @param source
     * @return XbcPostDecrExpr
     */
    XbcPostDecrExpr createXbcPostDecrExpr(XbcPostDecrExpr source);

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the XbcPreIncrExpr <code>source</code>.
     *
     * @param source
     * @return XbcPreIncrExpr
     */
    XbcPreIncrExpr createXbcPreIncrExpr(XbcPreIncrExpr source);

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the XbcPreDecrExpr <code>source</code>.
     *
     * @param source
     * @return XbcPreDecrExpr
     */
    XbcPreDecrExpr createXbcPreDecrExpr(XbcPreDecrExpr source);

    /**
     * Creates a <code>XbcIndexRange</code> by the XbcIndexRange <code>source</code>.
     *
     * @param source
     * @return XbcIndexRange
     */
    XbcIndexRange createXbcIndexRange(XbcIndexRange source);

    /**
     * Creates a <code>XbcLowerBound</code> by the XbcLowerBound <code>source</code>.
     *
     * @param source
     * @return XbcLowerBound
     */
    XbcLowerBound createXbcLowerBound(XbcLowerBound source);

    /**
     * Creates a <code>XbcUpperBound</code> by the XbcUpperBound <code>source</code>.
     *
     * @param source
     * @return XbcUpperBound
     */
    XbcUpperBound createXbcUpperBound(XbcUpperBound source);

    /**
     * Creates a <code>XbcStep</code> by the XbcStep <code>source</code>.
     *
     * @param source
     * @return XbcStep
     */
    XbcStep createXbcStep(XbcStep source);

    /**
     * Creates a <code>XbcDesignatedValue</code> by the XbcDesignatedValue <code>source</code>.
     *
     * @param source
     * @return XbcDesignatedValue
     */
    XbcDesignatedValue createXbcDesignatedValue(XbcDesignatedValue source);

    /**
     * Creates a <code>XbcCompoundValue</code> by the XbcCompoundValue <code>source</code>.
     *
     * @param source
     * @return XbcCompoundValue
     */
    XbcCompoundValue createXbcCompoundValue(XbcCompoundValue source);

    /**
     * Creates a <code>XbcBitField</code> by the XbcBitField <code>source</code>.
     *
     * @param source
     * @return XbcBitField
     */
    XbcBitField createXbcBitField(XbcBitField source);

    /**
     * Creates a <code>XbcPragma</code> by the XbcPragma <code>source</code>.
     *
     * @param source
     * @return XbcPragma
     */
    XbcPragma createXbcPragma(XbcPragma source);

    /**
     * Creates a <code>XbcText</code> by the XbcText <code>source</code>.
     *
     * @param source
     * @return XbcText
     */
    XbcText createXbcText(XbcText source);

    /**
     * Creates a <code>XbcDeclarations</code> by the XbcDeclarations <code>source</code>.
     *
     * @param source
     * @return XbcDeclarations
     */
    XbcDeclarations createXbcDeclarations(XbcDeclarations source);

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the XbcFunctionDefinition <code>source</code>.
     *
     * @param source
     * @return XbcFunctionDefinition
     */
    XbcFunctionDefinition createXbcFunctionDefinition(XbcFunctionDefinition source);

    /**
     * Creates a <code>XbcParams</code> by the XbcParams <code>source</code>.
     *
     * @param source
     * @return XbcParams
     */
    XbcParams createXbcParams(XbcParams source);

    /**
     * Creates a <code>XbcBody</code> by the XbcBody <code>source</code>.
     *
     * @param source
     * @return XbcBody
     */
    XbcBody createXbcBody(XbcBody source);

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the XbcGccAsmStatement <code>source</code>.
     *
     * @param source
     * @return XbcGccAsmStatement
     */
    XbcGccAsmStatement createXbcGccAsmStatement(XbcGccAsmStatement source);

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the XbcGccAsmOperands <code>source</code>.
     *
     * @param source
     * @return XbcGccAsmOperands
     */
    XbcGccAsmOperands createXbcGccAsmOperands(XbcGccAsmOperands source);

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the XbcGccAsmOperand <code>source</code>.
     *
     * @param source
     * @return XbcGccAsmOperand
     */
    XbcGccAsmOperand createXbcGccAsmOperand(XbcGccAsmOperand source);

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the XbcGccAsmClobbers <code>source</code>.
     *
     * @param source
     * @return XbcGccAsmClobbers
     */
    XbcGccAsmClobbers createXbcGccAsmClobbers(XbcGccAsmClobbers source);

    /**
     * Creates a <code>XbcForStatement</code> by the XbcForStatement <code>source</code>.
     *
     * @param source
     * @return XbcForStatement
     */
    XbcForStatement createXbcForStatement(XbcForStatement source);

    /**
     * Creates a <code>XbcInit</code> by the XbcInit <code>source</code>.
     *
     * @param source
     * @return XbcInit
     */
    XbcInit createXbcInit(XbcInit source);

    /**
     * Creates a <code>XbcCondition</code> by the XbcCondition <code>source</code>.
     *
     * @param source
     * @return XbcCondition
     */
    XbcCondition createXbcCondition(XbcCondition source);

    /**
     * Creates a <code>XbcIter</code> by the XbcIter <code>source</code>.
     *
     * @param source
     * @return XbcIter
     */
    XbcIter createXbcIter(XbcIter source);

    /**
     * Creates a <code>XbcIfStatement</code> by the XbcIfStatement <code>source</code>.
     *
     * @param source
     * @return XbcIfStatement
     */
    XbcIfStatement createXbcIfStatement(XbcIfStatement source);

    /**
     * Creates a <code>XbcThen</code> by the XbcThen <code>source</code>.
     *
     * @param source
     * @return XbcThen
     */
    XbcThen createXbcThen(XbcThen source);

    /**
     * Creates a <code>XbcElse</code> by the XbcElse <code>source</code>.
     *
     * @param source
     * @return XbcElse
     */
    XbcElse createXbcElse(XbcElse source);

    /**
     * Creates a <code>XbcWhileStatement</code> by the XbcWhileStatement <code>source</code>.
     *
     * @param source
     * @return XbcWhileStatement
     */
    XbcWhileStatement createXbcWhileStatement(XbcWhileStatement source);

    /**
     * Creates a <code>XbcDoStatement</code> by the XbcDoStatement <code>source</code>.
     *
     * @param source
     * @return XbcDoStatement
     */
    XbcDoStatement createXbcDoStatement(XbcDoStatement source);

    /**
     * Creates a <code>XbcSwitchStatement</code> by the XbcSwitchStatement <code>source</code>.
     *
     * @param source
     * @return XbcSwitchStatement
     */
    XbcSwitchStatement createXbcSwitchStatement(XbcSwitchStatement source);

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the XbcGccRangedCaseLabel <code>source</code>.
     *
     * @param source
     * @return XbcGccRangedCaseLabel
     */
    XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(XbcGccRangedCaseLabel source);

    /**
     * Creates a <code>XbcStatementLabel</code> by the XbcStatementLabel <code>source</code>.
     *
     * @param source
     * @return XbcStatementLabel
     */
    XbcStatementLabel createXbcStatementLabel(XbcStatementLabel source);

    /**
     * Creates a <code>XbcCaseLabel</code> by the XbcCaseLabel <code>source</code>.
     *
     * @param source
     * @return XbcCaseLabel
     */
    XbcCaseLabel createXbcCaseLabel(XbcCaseLabel source);

    /**
     * Creates a <code>XbcBreakStatement</code> by the XbcBreakStatement <code>source</code>.
     *
     * @param source
     * @return XbcBreakStatement
     */
    XbcBreakStatement createXbcBreakStatement(XbcBreakStatement source);

    /**
     * Creates a <code>XbcContinueStatement</code> by the XbcContinueStatement <code>source</code>.
     *
     * @param source
     * @return XbcContinueStatement
     */
    XbcContinueStatement createXbcContinueStatement(XbcContinueStatement source);

    /**
     * Creates a <code>XbcReturnStatement</code> by the XbcReturnStatement <code>source</code>.
     *
     * @param source
     * @return XbcReturnStatement
     */
    XbcReturnStatement createXbcReturnStatement(XbcReturnStatement source);

    /**
     * Creates a <code>XbcGotoStatement</code> by the XbcGotoStatement <code>source</code>.
     *
     * @param source
     * @return XbcGotoStatement
     */
    XbcGotoStatement createXbcGotoStatement(XbcGotoStatement source);

    /**
     * Creates a <code>XbcDefaultLabel</code> by the XbcDefaultLabel <code>source</code>.
     *
     * @param source
     * @return XbcDefaultLabel
     */
    XbcDefaultLabel createXbcDefaultLabel(XbcDefaultLabel source);

    /**
     * Creates a <code>XbcExprStatement</code> by the XbcExprStatement <code>source</code>.
     *
     * @param source
     * @return XbcExprStatement
     */
    XbcExprStatement createXbcExprStatement(XbcExprStatement source);

    /**
     * Creates a <code>XbcVarDecl</code> by the XbcVarDecl <code>source</code>.
     *
     * @param source
     * @return XbcVarDecl
     */
    XbcVarDecl createXbcVarDecl(XbcVarDecl source);

    /**
     * Creates a <code>XbcGccAsm</code> by the XbcGccAsm <code>source</code>.
     *
     * @param source
     * @return XbcGccAsm
     */
    XbcGccAsm createXbcGccAsm(XbcGccAsm source);

    /**
     * Creates a <code>XbcFunctionDecl</code> by the XbcFunctionDecl <code>source</code>.
     *
     * @param source
     * @return XbcFunctionDecl
     */
    XbcFunctionDecl createXbcFunctionDecl(XbcFunctionDecl source);

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the XbcGccMemberDesignator <code>source</code>.
     *
     * @param source
     * @return XbcGccMemberDesignator
     */
    XbcGccMemberDesignator createXbcGccMemberDesignator(XbcGccMemberDesignator source);

    /**
     * Creates a <code>XbcArrayType</code> by the XbcArrayType <code>source</code>.
     *
     * @param source
     * @return XbcArrayType
     */
    XbcArrayType createXbcArrayType(XbcArrayType source);

    /**
     * Creates a <code>XbcArraySize</code> by the XbcArraySize <code>source</code>.
     *
     * @param source
     * @return XbcArraySize
     */
    XbcArraySize createXbcArraySize(XbcArraySize source);

    /**
     * Creates a <code>XbcBasicType</code> by the XbcBasicType <code>source</code>.
     *
     * @param source
     * @return XbcBasicType
     */
    XbcBasicType createXbcBasicType(XbcBasicType source);

    /**
     * Creates a <code>XbcPointerType</code> by the XbcPointerType <code>source</code>.
     *
     * @param source
     * @return XbcPointerType
     */
    XbcPointerType createXbcPointerType(XbcPointerType source);

    /**
     * Creates a <code>XbcStructType</code> by the XbcStructType <code>source</code>.
     *
     * @param source
     * @return XbcStructType
     */
    XbcStructType createXbcStructType(XbcStructType source);

    /**
     * Creates a <code>XbcUnionType</code> by the XbcUnionType <code>source</code>.
     *
     * @param source
     * @return XbcUnionType
     */
    XbcUnionType createXbcUnionType(XbcUnionType source);

    /**
     * Creates a <code>XbcEnumType</code> by the XbcEnumType <code>source</code>.
     *
     * @param source
     * @return XbcEnumType
     */
    XbcEnumType createXbcEnumType(XbcEnumType source);

    /**
     * Creates a <code>XbcCoArrayType</code> by the XbcCoArrayType <code>source</code>.
     *
     * @param source
     * @return XbcCoArrayType
     */
    XbcCoArrayType createXbcCoArrayType(XbcCoArrayType source);

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the XbcGlobalSymbols <code>source</code>.
     *
     * @param source
     * @return XbcGlobalSymbols
     */
    XbcGlobalSymbols createXbcGlobalSymbols(XbcGlobalSymbols source);

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the XbcGlobalDeclarations <code>source</code>.
     *
     * @param source
     * @return XbcGlobalDeclarations
     */
    XbcGlobalDeclarations createXbcGlobalDeclarations(XbcGlobalDeclarations source);

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the XbcGccAsmDefinition <code>source</code>.
     *
     * @param source
     * @return XbcGccAsmDefinition
     */
    XbcGccAsmDefinition createXbcGccAsmDefinition(XbcGccAsmDefinition source);

    /**
     * Creates a <code>XbcXcodeProgram</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcXcodeProgram
     */
    XbcXcodeProgram createXbcXcodeProgram(Document doc);

    /**
     * Creates a <code>XbcTypeTable</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcTypeTable
     */
    XbcTypeTable createXbcTypeTable(Document doc);

    /**
     * Creates a <code>XbcFunctionType</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcFunctionType
     */
    XbcFunctionType createXbcFunctionType(Document doc);

    /**
     * Creates a <code>XbcGccAttributes</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcGccAttributes
     */
    XbcGccAttributes createXbcGccAttributes(Document doc);

    /**
     * Creates a <code>XbcGccAttribute</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcGccAttribute
     */
    XbcGccAttribute createXbcGccAttribute(Document doc);

    /**
     * Creates a <code>XbcBuiltinOp</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcBuiltinOp
     */
    XbcBuiltinOp createXbcBuiltinOp(Document doc);

    /**
     * Creates a <code>XbcArrayRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcArrayRef
     */
    XbcArrayRef createXbcArrayRef(Document doc);

    /**
     * Creates a <code>XbcArrayAddr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcArrayAddr
     */
    XbcArrayAddr createXbcArrayAddr(Document doc);

    /**
     * Creates a <code>XbcFunctionCall</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcFunctionCall
     */
    XbcFunctionCall createXbcFunctionCall(Document doc);

    /**
     * Creates a <code>XbcFunction</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcFunction
     */
    XbcFunction createXbcFunction(Document doc);

    /**
     * Creates a <code>XbcArguments</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcArguments
     */
    XbcArguments createXbcArguments(Document doc);

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcGccCompoundExpr
     */
    XbcGccCompoundExpr createXbcGccCompoundExpr(Document doc);

    /**
     * Creates a <code>XbcCompoundStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcCompoundStatement
     */
    XbcCompoundStatement createXbcCompoundStatement(Document doc);

    /**
     * Creates a <code>XbcSymbols</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcSymbols
     */
    XbcSymbols createXbcSymbols(Document doc);

    /**
     * Creates a <code>XbcId</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcId
     */
    XbcId createXbcId(Document doc);

    /**
     * Creates a <code>XbcName</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcName
     */
    XbcName createXbcName(Document doc);

    /**
     * Creates a <code>XbcValue</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcValue
     */
    XbcValue createXbcValue(Document doc);

    /**
     * Creates a <code>XbcSubArrayRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcSubArrayRef
     */
    XbcSubArrayRef createXbcSubArrayRef(Document doc);

    /**
     * Creates a <code>XbcCoArrayRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcCoArrayRef
     */
    XbcCoArrayRef createXbcCoArrayRef(Document doc);

    /**
     * Creates a <code>XbcVar</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcVar
     */
    XbcVar createXbcVar(Document doc);

    /**
     * Creates a <code>XbcMemberRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcMemberRef
     */
    XbcMemberRef createXbcMemberRef(Document doc);

    /**
     * Creates a <code>XbcCastExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcCastExpr
     */
    XbcCastExpr createXbcCastExpr(Document doc);

    /**
     * Creates a <code>XbcStringConstant</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcStringConstant
     */
    XbcStringConstant createXbcStringConstant(Document doc);

    /**
     * Creates a <code>XbcVarAddr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcVarAddr
     */
    XbcVarAddr createXbcVarAddr(Document doc);

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcCompoundValueExpr
     */
    XbcCompoundValueExpr createXbcCompoundValueExpr(Document doc);

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcCompoundValueAddrExpr
     */
    XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(Document doc);

    /**
     * Creates a <code>XbcXmpDescOf</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcXmpDescOf
     */
    XbcXmpDescOf createXbcXmpDescOf(Document doc);

    /**
     * Creates a <code>XbcIntConstant</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcIntConstant
     */
    XbcIntConstant createXbcIntConstant(Document doc);

    /**
     * Creates a <code>XbcFloatConstant</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcFloatConstant
     */
    XbcFloatConstant createXbcFloatConstant(Document doc);

    /**
     * Creates a <code>XbcLonglongConstant</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcLonglongConstant
     */
    XbcLonglongConstant createXbcLonglongConstant(Document doc);

    /**
     * Creates a <code>XbcMoeConstant</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcMoeConstant
     */
    XbcMoeConstant createXbcMoeConstant(Document doc);

    /**
     * Creates a <code>XbcFuncAddr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcFuncAddr
     */
    XbcFuncAddr createXbcFuncAddr(Document doc);

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcSizeOfExpr
     */
    XbcSizeOfExpr createXbcSizeOfExpr(Document doc);

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcCoArrayAssignExpr
     */
    XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(Document doc);

    /**
     * Creates a <code>XbcModExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcModExpr
     */
    XbcModExpr createXbcModExpr(Document doc);

    /**
     * Creates a <code>XbcBitOrExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcBitOrExpr
     */
    XbcBitOrExpr createXbcBitOrExpr(Document doc);

    /**
     * Creates a <code>XbcLogOrExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcLogOrExpr
     */
    XbcLogOrExpr createXbcLogOrExpr(Document doc);

    /**
     * Creates a <code>XbcPlusExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcPlusExpr
     */
    XbcPlusExpr createXbcPlusExpr(Document doc);

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcAsgPlusExpr
     */
    XbcAsgPlusExpr createXbcAsgPlusExpr(Document doc);

    /**
     * Creates a <code>XbcAsgModExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcAsgModExpr
     */
    XbcAsgModExpr createXbcAsgModExpr(Document doc);

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcAsgBitOrExpr
     */
    XbcAsgBitOrExpr createXbcAsgBitOrExpr(Document doc);

    /**
     * Creates a <code>XbcLogGTExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcLogGTExpr
     */
    XbcLogGTExpr createXbcLogGTExpr(Document doc);

    /**
     * Creates a <code>XbcCondExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcCondExpr
     */
    XbcCondExpr createXbcCondExpr(Document doc);

    /**
     * Creates a <code>XbcMinusExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcMinusExpr
     */
    XbcMinusExpr createXbcMinusExpr(Document doc);

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcAddrOfExpr
     */
    XbcAddrOfExpr createXbcAddrOfExpr(Document doc);

    /**
     * Creates a <code>XbcLshiftExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcLshiftExpr
     */
    XbcLshiftExpr createXbcLshiftExpr(Document doc);

    /**
     * Creates a <code>XbcRshiftExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcRshiftExpr
     */
    XbcRshiftExpr createXbcRshiftExpr(Document doc);

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcAsgBitXorExpr
     */
    XbcAsgBitXorExpr createXbcAsgBitXorExpr(Document doc);

    /**
     * Creates a <code>XbcLogEQExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcLogEQExpr
     */
    XbcLogEQExpr createXbcLogEQExpr(Document doc);

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcLogNEQExpr
     */
    XbcLogNEQExpr createXbcLogNEQExpr(Document doc);

    /**
     * Creates a <code>XbcLogGEExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcLogGEExpr
     */
    XbcLogGEExpr createXbcLogGEExpr(Document doc);

    /**
     * Creates a <code>XbcLogLTExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcLogLTExpr
     */
    XbcLogLTExpr createXbcLogLTExpr(Document doc);

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcGccAlignOfExpr
     */
    XbcGccAlignOfExpr createXbcGccAlignOfExpr(Document doc);

    /**
     * Creates a <code>XbcAssignExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcAssignExpr
     */
    XbcAssignExpr createXbcAssignExpr(Document doc);

    /**
     * Creates a <code>XbcMulExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcMulExpr
     */
    XbcMulExpr createXbcMulExpr(Document doc);

    /**
     * Creates a <code>XbcDivExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcDivExpr
     */
    XbcDivExpr createXbcDivExpr(Document doc);

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcAsgMulExpr
     */
    XbcAsgMulExpr createXbcAsgMulExpr(Document doc);

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcAsgRshiftExpr
     */
    XbcAsgRshiftExpr createXbcAsgRshiftExpr(Document doc);

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcAsgBitAndExpr
     */
    XbcAsgBitAndExpr createXbcAsgBitAndExpr(Document doc);

    /**
     * Creates a <code>XbcLogLEExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcLogLEExpr
     */
    XbcLogLEExpr createXbcLogLEExpr(Document doc);

    /**
     * Creates a <code>XbcLogAndExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcLogAndExpr
     */
    XbcLogAndExpr createXbcLogAndExpr(Document doc);

    /**
     * Creates a <code>XbcCommaExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcCommaExpr
     */
    XbcCommaExpr createXbcCommaExpr(Document doc);

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcAsgDivExpr
     */
    XbcAsgDivExpr createXbcAsgDivExpr(Document doc);

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcGccLabelAddr
     */
    XbcGccLabelAddr createXbcGccLabelAddr(Document doc);

    /**
     * Creates a <code>XbcBitAndExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcBitAndExpr
     */
    XbcBitAndExpr createXbcBitAndExpr(Document doc);

    /**
     * Creates a <code>XbcBitXorExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcBitXorExpr
     */
    XbcBitXorExpr createXbcBitXorExpr(Document doc);

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcAsgMinusExpr
     */
    XbcAsgMinusExpr createXbcAsgMinusExpr(Document doc);

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcAsgLshiftExpr
     */
    XbcAsgLshiftExpr createXbcAsgLshiftExpr(Document doc);

    /**
     * Creates a <code>XbcMemberAddr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcMemberAddr
     */
    XbcMemberAddr createXbcMemberAddr(Document doc);

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcMemberArrayRef
     */
    XbcMemberArrayRef createXbcMemberArrayRef(Document doc);

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcMemberArrayAddr
     */
    XbcMemberArrayAddr createXbcMemberArrayAddr(Document doc);

    /**
     * Creates a <code>XbcTypeName</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcTypeName
     */
    XbcTypeName createXbcTypeName(Document doc);

    /**
     * Creates a <code>XbcPointerRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcPointerRef
     */
    XbcPointerRef createXbcPointerRef(Document doc);

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcUnaryMinusExpr
     */
    XbcUnaryMinusExpr createXbcUnaryMinusExpr(Document doc);

    /**
     * Creates a <code>XbcBitNotExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcBitNotExpr
     */
    XbcBitNotExpr createXbcBitNotExpr(Document doc);

    /**
     * Creates a <code>XbcLogNotExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcLogNotExpr
     */
    XbcLogNotExpr createXbcLogNotExpr(Document doc);

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcPostIncrExpr
     */
    XbcPostIncrExpr createXbcPostIncrExpr(Document doc);

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcPostDecrExpr
     */
    XbcPostDecrExpr createXbcPostDecrExpr(Document doc);

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcPreIncrExpr
     */
    XbcPreIncrExpr createXbcPreIncrExpr(Document doc);

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcPreDecrExpr
     */
    XbcPreDecrExpr createXbcPreDecrExpr(Document doc);

    /**
     * Creates a <code>XbcIndexRange</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcIndexRange
     */
    XbcIndexRange createXbcIndexRange(Document doc);

    /**
     * Creates a <code>XbcLowerBound</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcLowerBound
     */
    XbcLowerBound createXbcLowerBound(Document doc);

    /**
     * Creates a <code>XbcUpperBound</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcUpperBound
     */
    XbcUpperBound createXbcUpperBound(Document doc);

    /**
     * Creates a <code>XbcStep</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcStep
     */
    XbcStep createXbcStep(Document doc);

    /**
     * Creates a <code>XbcDesignatedValue</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcDesignatedValue
     */
    XbcDesignatedValue createXbcDesignatedValue(Document doc);

    /**
     * Creates a <code>XbcCompoundValue</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcCompoundValue
     */
    XbcCompoundValue createXbcCompoundValue(Document doc);

    /**
     * Creates a <code>XbcBitField</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcBitField
     */
    XbcBitField createXbcBitField(Document doc);

    /**
     * Creates a <code>XbcPragma</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcPragma
     */
    XbcPragma createXbcPragma(Document doc);

    /**
     * Creates a <code>XbcText</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcText
     */
    XbcText createXbcText(Document doc);

    /**
     * Creates a <code>XbcDeclarations</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcDeclarations
     */
    XbcDeclarations createXbcDeclarations(Document doc);

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcFunctionDefinition
     */
    XbcFunctionDefinition createXbcFunctionDefinition(Document doc);

    /**
     * Creates a <code>XbcParams</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcParams
     */
    XbcParams createXbcParams(Document doc);

    /**
     * Creates a <code>XbcBody</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcBody
     */
    XbcBody createXbcBody(Document doc);

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcGccAsmStatement
     */
    XbcGccAsmStatement createXbcGccAsmStatement(Document doc);

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcGccAsmOperands
     */
    XbcGccAsmOperands createXbcGccAsmOperands(Document doc);

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcGccAsmOperand
     */
    XbcGccAsmOperand createXbcGccAsmOperand(Document doc);

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcGccAsmClobbers
     */
    XbcGccAsmClobbers createXbcGccAsmClobbers(Document doc);

    /**
     * Creates a <code>XbcForStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcForStatement
     */
    XbcForStatement createXbcForStatement(Document doc);

    /**
     * Creates a <code>XbcInit</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcInit
     */
    XbcInit createXbcInit(Document doc);

    /**
     * Creates a <code>XbcCondition</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcCondition
     */
    XbcCondition createXbcCondition(Document doc);

    /**
     * Creates a <code>XbcIter</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcIter
     */
    XbcIter createXbcIter(Document doc);

    /**
     * Creates a <code>XbcIfStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcIfStatement
     */
    XbcIfStatement createXbcIfStatement(Document doc);

    /**
     * Creates a <code>XbcThen</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcThen
     */
    XbcThen createXbcThen(Document doc);

    /**
     * Creates a <code>XbcElse</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcElse
     */
    XbcElse createXbcElse(Document doc);

    /**
     * Creates a <code>XbcWhileStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcWhileStatement
     */
    XbcWhileStatement createXbcWhileStatement(Document doc);

    /**
     * Creates a <code>XbcDoStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcDoStatement
     */
    XbcDoStatement createXbcDoStatement(Document doc);

    /**
     * Creates a <code>XbcSwitchStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcSwitchStatement
     */
    XbcSwitchStatement createXbcSwitchStatement(Document doc);

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcGccRangedCaseLabel
     */
    XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(Document doc);

    /**
     * Creates a <code>XbcStatementLabel</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcStatementLabel
     */
    XbcStatementLabel createXbcStatementLabel(Document doc);

    /**
     * Creates a <code>XbcCaseLabel</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcCaseLabel
     */
    XbcCaseLabel createXbcCaseLabel(Document doc);

    /**
     * Creates a <code>XbcBreakStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcBreakStatement
     */
    XbcBreakStatement createXbcBreakStatement(Document doc);

    /**
     * Creates a <code>XbcContinueStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcContinueStatement
     */
    XbcContinueStatement createXbcContinueStatement(Document doc);

    /**
     * Creates a <code>XbcReturnStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcReturnStatement
     */
    XbcReturnStatement createXbcReturnStatement(Document doc);

    /**
     * Creates a <code>XbcGotoStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcGotoStatement
     */
    XbcGotoStatement createXbcGotoStatement(Document doc);

    /**
     * Creates a <code>XbcDefaultLabel</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcDefaultLabel
     */
    XbcDefaultLabel createXbcDefaultLabel(Document doc);

    /**
     * Creates a <code>XbcExprStatement</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcExprStatement
     */
    XbcExprStatement createXbcExprStatement(Document doc);

    /**
     * Creates a <code>XbcVarDecl</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcVarDecl
     */
    XbcVarDecl createXbcVarDecl(Document doc);

    /**
     * Creates a <code>XbcGccAsm</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcGccAsm
     */
    XbcGccAsm createXbcGccAsm(Document doc);

    /**
     * Creates a <code>XbcFunctionDecl</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcFunctionDecl
     */
    XbcFunctionDecl createXbcFunctionDecl(Document doc);

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcGccMemberDesignator
     */
    XbcGccMemberDesignator createXbcGccMemberDesignator(Document doc);

    /**
     * Creates a <code>XbcArrayType</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcArrayType
     */
    XbcArrayType createXbcArrayType(Document doc);

    /**
     * Creates a <code>XbcArraySize</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcArraySize
     */
    XbcArraySize createXbcArraySize(Document doc);

    /**
     * Creates a <code>XbcBasicType</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcBasicType
     */
    XbcBasicType createXbcBasicType(Document doc);

    /**
     * Creates a <code>XbcPointerType</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcPointerType
     */
    XbcPointerType createXbcPointerType(Document doc);

    /**
     * Creates a <code>XbcStructType</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcStructType
     */
    XbcStructType createXbcStructType(Document doc);

    /**
     * Creates a <code>XbcUnionType</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcUnionType
     */
    XbcUnionType createXbcUnionType(Document doc);

    /**
     * Creates a <code>XbcEnumType</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcEnumType
     */
    XbcEnumType createXbcEnumType(Document doc);

    /**
     * Creates a <code>XbcCoArrayType</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcCoArrayType
     */
    XbcCoArrayType createXbcCoArrayType(Document doc);

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcGlobalSymbols
     */
    XbcGlobalSymbols createXbcGlobalSymbols(Document doc);

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcGlobalDeclarations
     */
    XbcGlobalDeclarations createXbcGlobalDeclarations(Document doc);

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the Document <code>doc</code>.
     *
     * @param doc
     * @return XbcGccAsmDefinition
     */
    XbcGccAsmDefinition createXbcGccAsmDefinition(Document doc);

    /**
     * Creates a <code>XbcXcodeProgram</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcXcodeProgram
     */
    XbcXcodeProgram createXbcXcodeProgram(Element element);

    /**
     * Creates a <code>XbcTypeTable</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcTypeTable
     */
    XbcTypeTable createXbcTypeTable(Element element);

    /**
     * Creates a <code>XbcFunctionType</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcFunctionType
     */
    XbcFunctionType createXbcFunctionType(Element element);

    /**
     * Creates a <code>XbcGccAttributes</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcGccAttributes
     */
    XbcGccAttributes createXbcGccAttributes(Element element);

    /**
     * Creates a <code>XbcGccAttribute</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcGccAttribute
     */
    XbcGccAttribute createXbcGccAttribute(Element element);

    /**
     * Creates a <code>XbcBuiltinOp</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcBuiltinOp
     */
    XbcBuiltinOp createXbcBuiltinOp(Element element);

    /**
     * Creates a <code>XbcArrayRef</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcArrayRef
     */
    XbcArrayRef createXbcArrayRef(Element element);

    /**
     * Creates a <code>XbcArrayAddr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcArrayAddr
     */
    XbcArrayAddr createXbcArrayAddr(Element element);

    /**
     * Creates a <code>XbcFunctionCall</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcFunctionCall
     */
    XbcFunctionCall createXbcFunctionCall(Element element);

    /**
     * Creates a <code>XbcFunction</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcFunction
     */
    XbcFunction createXbcFunction(Element element);

    /**
     * Creates a <code>XbcArguments</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcArguments
     */
    XbcArguments createXbcArguments(Element element);

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcGccCompoundExpr
     */
    XbcGccCompoundExpr createXbcGccCompoundExpr(Element element);

    /**
     * Creates a <code>XbcCompoundStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcCompoundStatement
     */
    XbcCompoundStatement createXbcCompoundStatement(Element element);

    /**
     * Creates a <code>XbcSymbols</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcSymbols
     */
    XbcSymbols createXbcSymbols(Element element);

    /**
     * Creates a <code>XbcId</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcId
     */
    XbcId createXbcId(Element element);

    /**
     * Creates a <code>XbcName</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcName
     */
    XbcName createXbcName(Element element);

    /**
     * Creates a <code>XbcValue</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcValue
     */
    XbcValue createXbcValue(Element element);

    /**
     * Creates a <code>XbcSubArrayRef</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcSubArrayRef
     */
    XbcSubArrayRef createXbcSubArrayRef(Element element);

    /**
     * Creates a <code>XbcCoArrayRef</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcCoArrayRef
     */
    XbcCoArrayRef createXbcCoArrayRef(Element element);

    /**
     * Creates a <code>XbcVar</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcVar
     */
    XbcVar createXbcVar(Element element);

    /**
     * Creates a <code>XbcMemberRef</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcMemberRef
     */
    XbcMemberRef createXbcMemberRef(Element element);

    /**
     * Creates a <code>XbcCastExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcCastExpr
     */
    XbcCastExpr createXbcCastExpr(Element element);

    /**
     * Creates a <code>XbcStringConstant</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcStringConstant
     */
    XbcStringConstant createXbcStringConstant(Element element);

    /**
     * Creates a <code>XbcVarAddr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcVarAddr
     */
    XbcVarAddr createXbcVarAddr(Element element);

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcCompoundValueExpr
     */
    XbcCompoundValueExpr createXbcCompoundValueExpr(Element element);

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcCompoundValueAddrExpr
     */
    XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(Element element);

    /**
     * Creates a <code>XbcXmpDescOf</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcXmpDescOf
     */
    XbcXmpDescOf createXbcXmpDescOf(Element element);

    /**
     * Creates a <code>XbcIntConstant</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcIntConstant
     */
    XbcIntConstant createXbcIntConstant(Element element);

    /**
     * Creates a <code>XbcFloatConstant</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcFloatConstant
     */
    XbcFloatConstant createXbcFloatConstant(Element element);

    /**
     * Creates a <code>XbcLonglongConstant</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcLonglongConstant
     */
    XbcLonglongConstant createXbcLonglongConstant(Element element);

    /**
     * Creates a <code>XbcMoeConstant</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcMoeConstant
     */
    XbcMoeConstant createXbcMoeConstant(Element element);

    /**
     * Creates a <code>XbcFuncAddr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcFuncAddr
     */
    XbcFuncAddr createXbcFuncAddr(Element element);

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcSizeOfExpr
     */
    XbcSizeOfExpr createXbcSizeOfExpr(Element element);

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcCoArrayAssignExpr
     */
    XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(Element element);

    /**
     * Creates a <code>XbcModExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcModExpr
     */
    XbcModExpr createXbcModExpr(Element element);

    /**
     * Creates a <code>XbcBitOrExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcBitOrExpr
     */
    XbcBitOrExpr createXbcBitOrExpr(Element element);

    /**
     * Creates a <code>XbcLogOrExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcLogOrExpr
     */
    XbcLogOrExpr createXbcLogOrExpr(Element element);

    /**
     * Creates a <code>XbcPlusExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcPlusExpr
     */
    XbcPlusExpr createXbcPlusExpr(Element element);

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcAsgPlusExpr
     */
    XbcAsgPlusExpr createXbcAsgPlusExpr(Element element);

    /**
     * Creates a <code>XbcAsgModExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcAsgModExpr
     */
    XbcAsgModExpr createXbcAsgModExpr(Element element);

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcAsgBitOrExpr
     */
    XbcAsgBitOrExpr createXbcAsgBitOrExpr(Element element);

    /**
     * Creates a <code>XbcLogGTExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcLogGTExpr
     */
    XbcLogGTExpr createXbcLogGTExpr(Element element);

    /**
     * Creates a <code>XbcCondExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcCondExpr
     */
    XbcCondExpr createXbcCondExpr(Element element);

    /**
     * Creates a <code>XbcMinusExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcMinusExpr
     */
    XbcMinusExpr createXbcMinusExpr(Element element);

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcAddrOfExpr
     */
    XbcAddrOfExpr createXbcAddrOfExpr(Element element);

    /**
     * Creates a <code>XbcLshiftExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcLshiftExpr
     */
    XbcLshiftExpr createXbcLshiftExpr(Element element);

    /**
     * Creates a <code>XbcRshiftExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcRshiftExpr
     */
    XbcRshiftExpr createXbcRshiftExpr(Element element);

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcAsgBitXorExpr
     */
    XbcAsgBitXorExpr createXbcAsgBitXorExpr(Element element);

    /**
     * Creates a <code>XbcLogEQExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcLogEQExpr
     */
    XbcLogEQExpr createXbcLogEQExpr(Element element);

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcLogNEQExpr
     */
    XbcLogNEQExpr createXbcLogNEQExpr(Element element);

    /**
     * Creates a <code>XbcLogGEExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcLogGEExpr
     */
    XbcLogGEExpr createXbcLogGEExpr(Element element);

    /**
     * Creates a <code>XbcLogLTExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcLogLTExpr
     */
    XbcLogLTExpr createXbcLogLTExpr(Element element);

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcGccAlignOfExpr
     */
    XbcGccAlignOfExpr createXbcGccAlignOfExpr(Element element);

    /**
     * Creates a <code>XbcAssignExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcAssignExpr
     */
    XbcAssignExpr createXbcAssignExpr(Element element);

    /**
     * Creates a <code>XbcMulExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcMulExpr
     */
    XbcMulExpr createXbcMulExpr(Element element);

    /**
     * Creates a <code>XbcDivExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcDivExpr
     */
    XbcDivExpr createXbcDivExpr(Element element);

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcAsgMulExpr
     */
    XbcAsgMulExpr createXbcAsgMulExpr(Element element);

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcAsgRshiftExpr
     */
    XbcAsgRshiftExpr createXbcAsgRshiftExpr(Element element);

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcAsgBitAndExpr
     */
    XbcAsgBitAndExpr createXbcAsgBitAndExpr(Element element);

    /**
     * Creates a <code>XbcLogLEExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcLogLEExpr
     */
    XbcLogLEExpr createXbcLogLEExpr(Element element);

    /**
     * Creates a <code>XbcLogAndExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcLogAndExpr
     */
    XbcLogAndExpr createXbcLogAndExpr(Element element);

    /**
     * Creates a <code>XbcCommaExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcCommaExpr
     */
    XbcCommaExpr createXbcCommaExpr(Element element);

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcAsgDivExpr
     */
    XbcAsgDivExpr createXbcAsgDivExpr(Element element);

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcGccLabelAddr
     */
    XbcGccLabelAddr createXbcGccLabelAddr(Element element);

    /**
     * Creates a <code>XbcBitAndExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcBitAndExpr
     */
    XbcBitAndExpr createXbcBitAndExpr(Element element);

    /**
     * Creates a <code>XbcBitXorExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcBitXorExpr
     */
    XbcBitXorExpr createXbcBitXorExpr(Element element);

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcAsgMinusExpr
     */
    XbcAsgMinusExpr createXbcAsgMinusExpr(Element element);

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcAsgLshiftExpr
     */
    XbcAsgLshiftExpr createXbcAsgLshiftExpr(Element element);

    /**
     * Creates a <code>XbcMemberAddr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcMemberAddr
     */
    XbcMemberAddr createXbcMemberAddr(Element element);

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcMemberArrayRef
     */
    XbcMemberArrayRef createXbcMemberArrayRef(Element element);

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcMemberArrayAddr
     */
    XbcMemberArrayAddr createXbcMemberArrayAddr(Element element);

    /**
     * Creates a <code>XbcTypeName</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcTypeName
     */
    XbcTypeName createXbcTypeName(Element element);

    /**
     * Creates a <code>XbcPointerRef</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcPointerRef
     */
    XbcPointerRef createXbcPointerRef(Element element);

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcUnaryMinusExpr
     */
    XbcUnaryMinusExpr createXbcUnaryMinusExpr(Element element);

    /**
     * Creates a <code>XbcBitNotExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcBitNotExpr
     */
    XbcBitNotExpr createXbcBitNotExpr(Element element);

    /**
     * Creates a <code>XbcLogNotExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcLogNotExpr
     */
    XbcLogNotExpr createXbcLogNotExpr(Element element);

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcPostIncrExpr
     */
    XbcPostIncrExpr createXbcPostIncrExpr(Element element);

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcPostDecrExpr
     */
    XbcPostDecrExpr createXbcPostDecrExpr(Element element);

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcPreIncrExpr
     */
    XbcPreIncrExpr createXbcPreIncrExpr(Element element);

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcPreDecrExpr
     */
    XbcPreDecrExpr createXbcPreDecrExpr(Element element);

    /**
     * Creates a <code>XbcIndexRange</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcIndexRange
     */
    XbcIndexRange createXbcIndexRange(Element element);

    /**
     * Creates a <code>XbcLowerBound</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcLowerBound
     */
    XbcLowerBound createXbcLowerBound(Element element);

    /**
     * Creates a <code>XbcUpperBound</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcUpperBound
     */
    XbcUpperBound createXbcUpperBound(Element element);

    /**
     * Creates a <code>XbcStep</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcStep
     */
    XbcStep createXbcStep(Element element);

    /**
     * Creates a <code>XbcDesignatedValue</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcDesignatedValue
     */
    XbcDesignatedValue createXbcDesignatedValue(Element element);

    /**
     * Creates a <code>XbcCompoundValue</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcCompoundValue
     */
    XbcCompoundValue createXbcCompoundValue(Element element);

    /**
     * Creates a <code>XbcBitField</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcBitField
     */
    XbcBitField createXbcBitField(Element element);

    /**
     * Creates a <code>XbcPragma</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcPragma
     */
    XbcPragma createXbcPragma(Element element);

    /**
     * Creates a <code>XbcText</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcText
     */
    XbcText createXbcText(Element element);

    /**
     * Creates a <code>XbcDeclarations</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcDeclarations
     */
    XbcDeclarations createXbcDeclarations(Element element);

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcFunctionDefinition
     */
    XbcFunctionDefinition createXbcFunctionDefinition(Element element);

    /**
     * Creates a <code>XbcParams</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcParams
     */
    XbcParams createXbcParams(Element element);

    /**
     * Creates a <code>XbcBody</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcBody
     */
    XbcBody createXbcBody(Element element);

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcGccAsmStatement
     */
    XbcGccAsmStatement createXbcGccAsmStatement(Element element);

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcGccAsmOperands
     */
    XbcGccAsmOperands createXbcGccAsmOperands(Element element);

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcGccAsmOperand
     */
    XbcGccAsmOperand createXbcGccAsmOperand(Element element);

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcGccAsmClobbers
     */
    XbcGccAsmClobbers createXbcGccAsmClobbers(Element element);

    /**
     * Creates a <code>XbcForStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcForStatement
     */
    XbcForStatement createXbcForStatement(Element element);

    /**
     * Creates a <code>XbcInit</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcInit
     */
    XbcInit createXbcInit(Element element);

    /**
     * Creates a <code>XbcCondition</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcCondition
     */
    XbcCondition createXbcCondition(Element element);

    /**
     * Creates a <code>XbcIter</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcIter
     */
    XbcIter createXbcIter(Element element);

    /**
     * Creates a <code>XbcIfStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcIfStatement
     */
    XbcIfStatement createXbcIfStatement(Element element);

    /**
     * Creates a <code>XbcThen</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcThen
     */
    XbcThen createXbcThen(Element element);

    /**
     * Creates a <code>XbcElse</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcElse
     */
    XbcElse createXbcElse(Element element);

    /**
     * Creates a <code>XbcWhileStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcWhileStatement
     */
    XbcWhileStatement createXbcWhileStatement(Element element);

    /**
     * Creates a <code>XbcDoStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcDoStatement
     */
    XbcDoStatement createXbcDoStatement(Element element);

    /**
     * Creates a <code>XbcSwitchStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcSwitchStatement
     */
    XbcSwitchStatement createXbcSwitchStatement(Element element);

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcGccRangedCaseLabel
     */
    XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(Element element);

    /**
     * Creates a <code>XbcStatementLabel</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcStatementLabel
     */
    XbcStatementLabel createXbcStatementLabel(Element element);

    /**
     * Creates a <code>XbcCaseLabel</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcCaseLabel
     */
    XbcCaseLabel createXbcCaseLabel(Element element);

    /**
     * Creates a <code>XbcBreakStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcBreakStatement
     */
    XbcBreakStatement createXbcBreakStatement(Element element);

    /**
     * Creates a <code>XbcContinueStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcContinueStatement
     */
    XbcContinueStatement createXbcContinueStatement(Element element);

    /**
     * Creates a <code>XbcReturnStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcReturnStatement
     */
    XbcReturnStatement createXbcReturnStatement(Element element);

    /**
     * Creates a <code>XbcGotoStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcGotoStatement
     */
    XbcGotoStatement createXbcGotoStatement(Element element);

    /**
     * Creates a <code>XbcDefaultLabel</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcDefaultLabel
     */
    XbcDefaultLabel createXbcDefaultLabel(Element element);

    /**
     * Creates a <code>XbcExprStatement</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcExprStatement
     */
    XbcExprStatement createXbcExprStatement(Element element);

    /**
     * Creates a <code>XbcVarDecl</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcVarDecl
     */
    XbcVarDecl createXbcVarDecl(Element element);

    /**
     * Creates a <code>XbcGccAsm</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcGccAsm
     */
    XbcGccAsm createXbcGccAsm(Element element);

    /**
     * Creates a <code>XbcFunctionDecl</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcFunctionDecl
     */
    XbcFunctionDecl createXbcFunctionDecl(Element element);

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcGccMemberDesignator
     */
    XbcGccMemberDesignator createXbcGccMemberDesignator(Element element);

    /**
     * Creates a <code>XbcArrayType</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcArrayType
     */
    XbcArrayType createXbcArrayType(Element element);

    /**
     * Creates a <code>XbcArraySize</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcArraySize
     */
    XbcArraySize createXbcArraySize(Element element);

    /**
     * Creates a <code>XbcBasicType</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcBasicType
     */
    XbcBasicType createXbcBasicType(Element element);

    /**
     * Creates a <code>XbcPointerType</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcPointerType
     */
    XbcPointerType createXbcPointerType(Element element);

    /**
     * Creates a <code>XbcStructType</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcStructType
     */
    XbcStructType createXbcStructType(Element element);

    /**
     * Creates a <code>XbcUnionType</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcUnionType
     */
    XbcUnionType createXbcUnionType(Element element);

    /**
     * Creates a <code>XbcEnumType</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcEnumType
     */
    XbcEnumType createXbcEnumType(Element element);

    /**
     * Creates a <code>XbcCoArrayType</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcCoArrayType
     */
    XbcCoArrayType createXbcCoArrayType(Element element);

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcGlobalSymbols
     */
    XbcGlobalSymbols createXbcGlobalSymbols(Element element);

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcGlobalDeclarations
     */
    XbcGlobalDeclarations createXbcGlobalDeclarations(Element element);

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the Element <code>element</code>.
     *
     * @param element
     * @return XbcGccAsmDefinition
     */
    XbcGccAsmDefinition createXbcGccAsmDefinition(Element element);

    /**
     * Creates a <code>XbcXcodeProgram</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcXcodeProgram
     */
    XbcXcodeProgram createXbcXcodeProgram(RStack stack);

    /**
     * Creates a <code>XbcTypeTable</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcTypeTable
     */
    XbcTypeTable createXbcTypeTable(RStack stack);

    /**
     * Creates a <code>XbcFunctionType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcFunctionType
     */
    XbcFunctionType createXbcFunctionType(RStack stack);

    /**
     * Creates a <code>XbcGccAttributes</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcGccAttributes
     */
    XbcGccAttributes createXbcGccAttributes(RStack stack);

    /**
     * Creates a <code>XbcGccAttribute</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcGccAttribute
     */
    XbcGccAttribute createXbcGccAttribute(RStack stack);

    /**
     * Creates a <code>XbcBuiltinOp</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcBuiltinOp
     */
    XbcBuiltinOp createXbcBuiltinOp(RStack stack);

    /**
     * Creates a <code>XbcArrayRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcArrayRef
     */
    XbcArrayRef createXbcArrayRef(RStack stack);

    /**
     * Creates a <code>XbcArrayAddr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcArrayAddr
     */
    XbcArrayAddr createXbcArrayAddr(RStack stack);

    /**
     * Creates a <code>XbcFunctionCall</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcFunctionCall
     */
    XbcFunctionCall createXbcFunctionCall(RStack stack);

    /**
     * Creates a <code>XbcFunction</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcFunction
     */
    XbcFunction createXbcFunction(RStack stack);

    /**
     * Creates a <code>XbcArguments</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcArguments
     */
    XbcArguments createXbcArguments(RStack stack);

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcGccCompoundExpr
     */
    XbcGccCompoundExpr createXbcGccCompoundExpr(RStack stack);

    /**
     * Creates a <code>XbcCompoundStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcCompoundStatement
     */
    XbcCompoundStatement createXbcCompoundStatement(RStack stack);

    /**
     * Creates a <code>XbcSymbols</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcSymbols
     */
    XbcSymbols createXbcSymbols(RStack stack);

    /**
     * Creates a <code>XbcId</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcId
     */
    XbcId createXbcId(RStack stack);

    /**
     * Creates a <code>XbcName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcName
     */
    XbcName createXbcName(RStack stack);

    /**
     * Creates a <code>XbcValue</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcValue
     */
    XbcValue createXbcValue(RStack stack);

    /**
     * Creates a <code>XbcSubArrayRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcSubArrayRef
     */
    XbcSubArrayRef createXbcSubArrayRef(RStack stack);

    /**
     * Creates a <code>XbcCoArrayRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcCoArrayRef
     */
    XbcCoArrayRef createXbcCoArrayRef(RStack stack);

    /**
     * Creates a <code>XbcVar</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcVar
     */
    XbcVar createXbcVar(RStack stack);

    /**
     * Creates a <code>XbcMemberRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcMemberRef
     */
    XbcMemberRef createXbcMemberRef(RStack stack);

    /**
     * Creates a <code>XbcCastExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcCastExpr
     */
    XbcCastExpr createXbcCastExpr(RStack stack);

    /**
     * Creates a <code>XbcStringConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcStringConstant
     */
    XbcStringConstant createXbcStringConstant(RStack stack);

    /**
     * Creates a <code>XbcVarAddr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcVarAddr
     */
    XbcVarAddr createXbcVarAddr(RStack stack);

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcCompoundValueExpr
     */
    XbcCompoundValueExpr createXbcCompoundValueExpr(RStack stack);

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcCompoundValueAddrExpr
     */
    XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(RStack stack);

    /**
     * Creates a <code>XbcXmpDescOf</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcXmpDescOf
     */
    XbcXmpDescOf createXbcXmpDescOf(RStack stack);

    /**
     * Creates a <code>XbcIntConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcIntConstant
     */
    XbcIntConstant createXbcIntConstant(RStack stack);

    /**
     * Creates a <code>XbcFloatConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcFloatConstant
     */
    XbcFloatConstant createXbcFloatConstant(RStack stack);

    /**
     * Creates a <code>XbcLonglongConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcLonglongConstant
     */
    XbcLonglongConstant createXbcLonglongConstant(RStack stack);

    /**
     * Creates a <code>XbcMoeConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcMoeConstant
     */
    XbcMoeConstant createXbcMoeConstant(RStack stack);

    /**
     * Creates a <code>XbcFuncAddr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcFuncAddr
     */
    XbcFuncAddr createXbcFuncAddr(RStack stack);

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcSizeOfExpr
     */
    XbcSizeOfExpr createXbcSizeOfExpr(RStack stack);

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcCoArrayAssignExpr
     */
    XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(RStack stack);

    /**
     * Creates a <code>XbcModExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcModExpr
     */
    XbcModExpr createXbcModExpr(RStack stack);

    /**
     * Creates a <code>XbcBitOrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcBitOrExpr
     */
    XbcBitOrExpr createXbcBitOrExpr(RStack stack);

    /**
     * Creates a <code>XbcLogOrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcLogOrExpr
     */
    XbcLogOrExpr createXbcLogOrExpr(RStack stack);

    /**
     * Creates a <code>XbcPlusExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcPlusExpr
     */
    XbcPlusExpr createXbcPlusExpr(RStack stack);

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcAsgPlusExpr
     */
    XbcAsgPlusExpr createXbcAsgPlusExpr(RStack stack);

    /**
     * Creates a <code>XbcAsgModExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcAsgModExpr
     */
    XbcAsgModExpr createXbcAsgModExpr(RStack stack);

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcAsgBitOrExpr
     */
    XbcAsgBitOrExpr createXbcAsgBitOrExpr(RStack stack);

    /**
     * Creates a <code>XbcLogGTExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcLogGTExpr
     */
    XbcLogGTExpr createXbcLogGTExpr(RStack stack);

    /**
     * Creates a <code>XbcCondExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcCondExpr
     */
    XbcCondExpr createXbcCondExpr(RStack stack);

    /**
     * Creates a <code>XbcMinusExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcMinusExpr
     */
    XbcMinusExpr createXbcMinusExpr(RStack stack);

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcAddrOfExpr
     */
    XbcAddrOfExpr createXbcAddrOfExpr(RStack stack);

    /**
     * Creates a <code>XbcLshiftExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcLshiftExpr
     */
    XbcLshiftExpr createXbcLshiftExpr(RStack stack);

    /**
     * Creates a <code>XbcRshiftExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcRshiftExpr
     */
    XbcRshiftExpr createXbcRshiftExpr(RStack stack);

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcAsgBitXorExpr
     */
    XbcAsgBitXorExpr createXbcAsgBitXorExpr(RStack stack);

    /**
     * Creates a <code>XbcLogEQExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcLogEQExpr
     */
    XbcLogEQExpr createXbcLogEQExpr(RStack stack);

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcLogNEQExpr
     */
    XbcLogNEQExpr createXbcLogNEQExpr(RStack stack);

    /**
     * Creates a <code>XbcLogGEExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcLogGEExpr
     */
    XbcLogGEExpr createXbcLogGEExpr(RStack stack);

    /**
     * Creates a <code>XbcLogLTExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcLogLTExpr
     */
    XbcLogLTExpr createXbcLogLTExpr(RStack stack);

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcGccAlignOfExpr
     */
    XbcGccAlignOfExpr createXbcGccAlignOfExpr(RStack stack);

    /**
     * Creates a <code>XbcAssignExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcAssignExpr
     */
    XbcAssignExpr createXbcAssignExpr(RStack stack);

    /**
     * Creates a <code>XbcMulExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcMulExpr
     */
    XbcMulExpr createXbcMulExpr(RStack stack);

    /**
     * Creates a <code>XbcDivExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcDivExpr
     */
    XbcDivExpr createXbcDivExpr(RStack stack);

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcAsgMulExpr
     */
    XbcAsgMulExpr createXbcAsgMulExpr(RStack stack);

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcAsgRshiftExpr
     */
    XbcAsgRshiftExpr createXbcAsgRshiftExpr(RStack stack);

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcAsgBitAndExpr
     */
    XbcAsgBitAndExpr createXbcAsgBitAndExpr(RStack stack);

    /**
     * Creates a <code>XbcLogLEExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcLogLEExpr
     */
    XbcLogLEExpr createXbcLogLEExpr(RStack stack);

    /**
     * Creates a <code>XbcLogAndExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcLogAndExpr
     */
    XbcLogAndExpr createXbcLogAndExpr(RStack stack);

    /**
     * Creates a <code>XbcCommaExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcCommaExpr
     */
    XbcCommaExpr createXbcCommaExpr(RStack stack);

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcAsgDivExpr
     */
    XbcAsgDivExpr createXbcAsgDivExpr(RStack stack);

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcGccLabelAddr
     */
    XbcGccLabelAddr createXbcGccLabelAddr(RStack stack);

    /**
     * Creates a <code>XbcBitAndExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcBitAndExpr
     */
    XbcBitAndExpr createXbcBitAndExpr(RStack stack);

    /**
     * Creates a <code>XbcBitXorExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcBitXorExpr
     */
    XbcBitXorExpr createXbcBitXorExpr(RStack stack);

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcAsgMinusExpr
     */
    XbcAsgMinusExpr createXbcAsgMinusExpr(RStack stack);

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcAsgLshiftExpr
     */
    XbcAsgLshiftExpr createXbcAsgLshiftExpr(RStack stack);

    /**
     * Creates a <code>XbcMemberAddr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcMemberAddr
     */
    XbcMemberAddr createXbcMemberAddr(RStack stack);

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcMemberArrayRef
     */
    XbcMemberArrayRef createXbcMemberArrayRef(RStack stack);

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcMemberArrayAddr
     */
    XbcMemberArrayAddr createXbcMemberArrayAddr(RStack stack);

    /**
     * Creates a <code>XbcTypeName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcTypeName
     */
    XbcTypeName createXbcTypeName(RStack stack);

    /**
     * Creates a <code>XbcPointerRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcPointerRef
     */
    XbcPointerRef createXbcPointerRef(RStack stack);

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcUnaryMinusExpr
     */
    XbcUnaryMinusExpr createXbcUnaryMinusExpr(RStack stack);

    /**
     * Creates a <code>XbcBitNotExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcBitNotExpr
     */
    XbcBitNotExpr createXbcBitNotExpr(RStack stack);

    /**
     * Creates a <code>XbcLogNotExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcLogNotExpr
     */
    XbcLogNotExpr createXbcLogNotExpr(RStack stack);

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcPostIncrExpr
     */
    XbcPostIncrExpr createXbcPostIncrExpr(RStack stack);

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcPostDecrExpr
     */
    XbcPostDecrExpr createXbcPostDecrExpr(RStack stack);

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcPreIncrExpr
     */
    XbcPreIncrExpr createXbcPreIncrExpr(RStack stack);

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcPreDecrExpr
     */
    XbcPreDecrExpr createXbcPreDecrExpr(RStack stack);

    /**
     * Creates a <code>XbcIndexRange</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcIndexRange
     */
    XbcIndexRange createXbcIndexRange(RStack stack);

    /**
     * Creates a <code>XbcLowerBound</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcLowerBound
     */
    XbcLowerBound createXbcLowerBound(RStack stack);

    /**
     * Creates a <code>XbcUpperBound</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcUpperBound
     */
    XbcUpperBound createXbcUpperBound(RStack stack);

    /**
     * Creates a <code>XbcStep</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcStep
     */
    XbcStep createXbcStep(RStack stack);

    /**
     * Creates a <code>XbcDesignatedValue</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcDesignatedValue
     */
    XbcDesignatedValue createXbcDesignatedValue(RStack stack);

    /**
     * Creates a <code>XbcCompoundValue</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcCompoundValue
     */
    XbcCompoundValue createXbcCompoundValue(RStack stack);

    /**
     * Creates a <code>XbcBitField</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcBitField
     */
    XbcBitField createXbcBitField(RStack stack);

    /**
     * Creates a <code>XbcPragma</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcPragma
     */
    XbcPragma createXbcPragma(RStack stack);

    /**
     * Creates a <code>XbcText</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcText
     */
    XbcText createXbcText(RStack stack);

    /**
     * Creates a <code>XbcDeclarations</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcDeclarations
     */
    XbcDeclarations createXbcDeclarations(RStack stack);

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcFunctionDefinition
     */
    XbcFunctionDefinition createXbcFunctionDefinition(RStack stack);

    /**
     * Creates a <code>XbcParams</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcParams
     */
    XbcParams createXbcParams(RStack stack);

    /**
     * Creates a <code>XbcBody</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcBody
     */
    XbcBody createXbcBody(RStack stack);

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcGccAsmStatement
     */
    XbcGccAsmStatement createXbcGccAsmStatement(RStack stack);

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcGccAsmOperands
     */
    XbcGccAsmOperands createXbcGccAsmOperands(RStack stack);

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcGccAsmOperand
     */
    XbcGccAsmOperand createXbcGccAsmOperand(RStack stack);

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcGccAsmClobbers
     */
    XbcGccAsmClobbers createXbcGccAsmClobbers(RStack stack);

    /**
     * Creates a <code>XbcForStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcForStatement
     */
    XbcForStatement createXbcForStatement(RStack stack);

    /**
     * Creates a <code>XbcInit</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcInit
     */
    XbcInit createXbcInit(RStack stack);

    /**
     * Creates a <code>XbcCondition</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcCondition
     */
    XbcCondition createXbcCondition(RStack stack);

    /**
     * Creates a <code>XbcIter</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcIter
     */
    XbcIter createXbcIter(RStack stack);

    /**
     * Creates a <code>XbcIfStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcIfStatement
     */
    XbcIfStatement createXbcIfStatement(RStack stack);

    /**
     * Creates a <code>XbcThen</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcThen
     */
    XbcThen createXbcThen(RStack stack);

    /**
     * Creates a <code>XbcElse</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcElse
     */
    XbcElse createXbcElse(RStack stack);

    /**
     * Creates a <code>XbcWhileStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcWhileStatement
     */
    XbcWhileStatement createXbcWhileStatement(RStack stack);

    /**
     * Creates a <code>XbcDoStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcDoStatement
     */
    XbcDoStatement createXbcDoStatement(RStack stack);

    /**
     * Creates a <code>XbcSwitchStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcSwitchStatement
     */
    XbcSwitchStatement createXbcSwitchStatement(RStack stack);

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcGccRangedCaseLabel
     */
    XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(RStack stack);

    /**
     * Creates a <code>XbcStatementLabel</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcStatementLabel
     */
    XbcStatementLabel createXbcStatementLabel(RStack stack);

    /**
     * Creates a <code>XbcCaseLabel</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcCaseLabel
     */
    XbcCaseLabel createXbcCaseLabel(RStack stack);

    /**
     * Creates a <code>XbcBreakStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcBreakStatement
     */
    XbcBreakStatement createXbcBreakStatement(RStack stack);

    /**
     * Creates a <code>XbcContinueStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcContinueStatement
     */
    XbcContinueStatement createXbcContinueStatement(RStack stack);

    /**
     * Creates a <code>XbcReturnStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcReturnStatement
     */
    XbcReturnStatement createXbcReturnStatement(RStack stack);

    /**
     * Creates a <code>XbcGotoStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcGotoStatement
     */
    XbcGotoStatement createXbcGotoStatement(RStack stack);

    /**
     * Creates a <code>XbcDefaultLabel</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcDefaultLabel
     */
    XbcDefaultLabel createXbcDefaultLabel(RStack stack);

    /**
     * Creates a <code>XbcExprStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcExprStatement
     */
    XbcExprStatement createXbcExprStatement(RStack stack);

    /**
     * Creates a <code>XbcVarDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcVarDecl
     */
    XbcVarDecl createXbcVarDecl(RStack stack);

    /**
     * Creates a <code>XbcGccAsm</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcGccAsm
     */
    XbcGccAsm createXbcGccAsm(RStack stack);

    /**
     * Creates a <code>XbcFunctionDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcFunctionDecl
     */
    XbcFunctionDecl createXbcFunctionDecl(RStack stack);

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcGccMemberDesignator
     */
    XbcGccMemberDesignator createXbcGccMemberDesignator(RStack stack);

    /**
     * Creates a <code>XbcArrayType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcArrayType
     */
    XbcArrayType createXbcArrayType(RStack stack);

    /**
     * Creates a <code>XbcArraySize</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcArraySize
     */
    XbcArraySize createXbcArraySize(RStack stack);

    /**
     * Creates a <code>XbcBasicType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcBasicType
     */
    XbcBasicType createXbcBasicType(RStack stack);

    /**
     * Creates a <code>XbcPointerType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcPointerType
     */
    XbcPointerType createXbcPointerType(RStack stack);

    /**
     * Creates a <code>XbcStructType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcStructType
     */
    XbcStructType createXbcStructType(RStack stack);

    /**
     * Creates a <code>XbcUnionType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcUnionType
     */
    XbcUnionType createXbcUnionType(RStack stack);

    /**
     * Creates a <code>XbcEnumType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcEnumType
     */
    XbcEnumType createXbcEnumType(RStack stack);

    /**
     * Creates a <code>XbcCoArrayType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcCoArrayType
     */
    XbcCoArrayType createXbcCoArrayType(RStack stack);

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcGlobalSymbols
     */
    XbcGlobalSymbols createXbcGlobalSymbols(RStack stack);

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcGlobalDeclarations
     */
    XbcGlobalDeclarations createXbcGlobalDeclarations(RStack stack);

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return XbcGccAsmDefinition
     */
    XbcGccAsmDefinition createXbcGccAsmDefinition(RStack stack);
}
