/*
 * The Relaxer artifact
 * Copyright (c) 2000-2003, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package xcodeml.c.binding.gen;

import xcodeml.binding.*;

/**
 * DefaultXcodeML_CFactory is generated by Relaxer based on XcodeML_C.rng.
 *
 * @version XcodeML_C.rng 1.0 (Thu Feb 02 16:55:20 JST 2012)
 * @author  Relaxer 1.0 (http://www.relaxer.org)
 */
public class DefaultXcodeML_CFactory extends AbstractXcodeML_CFactory {

    /**
     * Creates a default <code>XbcXcodeProgram</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcXcodeProgram
     */
    public XbcXcodeProgram createXbcXcodeProgram() {
        return (new XbcXcodeProgram());
    }

    /**
     * Creates a default <code>XbcTypeTable</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcTypeTable
     */
    public XbcTypeTable createXbcTypeTable() {
        return (new XbcTypeTable());
    }

    /**
     * Creates a default <code>XbcFunctionType</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcFunctionType
     */
    public XbcFunctionType createXbcFunctionType() {
        return (new XbcFunctionType());
    }

    /**
     * Creates a default <code>XbcGccAttributes</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcGccAttributes
     */
    public XbcGccAttributes createXbcGccAttributes() {
        return (new XbcGccAttributes());
    }

    /**
     * Creates a default <code>XbcGccAttribute</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcGccAttribute
     */
    public XbcGccAttribute createXbcGccAttribute() {
        return (new XbcGccAttribute());
    }

    /**
     * Creates a default <code>XbcBuiltinOp</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcBuiltinOp
     */
    public XbcBuiltinOp createXbcBuiltinOp() {
        return (new XbcBuiltinOp());
    }

    /**
     * Creates a default <code>XbcArrayRef</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcArrayRef
     */
    public XbcArrayRef createXbcArrayRef() {
        return (new XbcArrayRef());
    }

    /**
     * Creates a default <code>XbcArrayAddr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcArrayAddr
     */
    public XbcArrayAddr createXbcArrayAddr() {
        return (new XbcArrayAddr());
    }

    /**
     * Creates a default <code>XbcFunctionCall</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcFunctionCall
     */
    public XbcFunctionCall createXbcFunctionCall() {
        return (new XbcFunctionCall());
    }

    /**
     * Creates a default <code>XbcFunction</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcFunction
     */
    public XbcFunction createXbcFunction() {
        return (new XbcFunction());
    }

    /**
     * Creates a default <code>XbcArguments</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcArguments
     */
    public XbcArguments createXbcArguments() {
        return (new XbcArguments());
    }

    /**
     * Creates a default <code>XbcGccCompoundExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcGccCompoundExpr
     */
    public XbcGccCompoundExpr createXbcGccCompoundExpr() {
        return (new XbcGccCompoundExpr());
    }

    /**
     * Creates a default <code>XbcCompoundStatement</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcCompoundStatement
     */
    public XbcCompoundStatement createXbcCompoundStatement() {
        return (new XbcCompoundStatement());
    }

    /**
     * Creates a default <code>XbcSymbols</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcSymbols
     */
    public XbcSymbols createXbcSymbols() {
        return (new XbcSymbols());
    }

    /**
     * Creates a default <code>XbcId</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcId
     */
    public XbcId createXbcId() {
        return (new XbcId());
    }

    /**
     * Creates a default <code>XbcName</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcName
     */
    public XbcName createXbcName() {
        return (new XbcName());
    }

    /**
     * Creates a default <code>XbcValue</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcValue
     */
    public XbcValue createXbcValue() {
        return (new XbcValue());
    }

    /**
     * Creates a default <code>XbcSubArrayRef</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcSubArrayRef
     */
    public XbcSubArrayRef createXbcSubArrayRef() {
        return (new XbcSubArrayRef());
    }

    /**
     * Creates a default <code>XbcCoArrayRef</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcCoArrayRef
     */
    public XbcCoArrayRef createXbcCoArrayRef() {
        return (new XbcCoArrayRef());
    }

    /**
     * Creates a default <code>XbcVar</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcVar
     */
    public XbcVar createXbcVar() {
        return (new XbcVar());
    }

    /**
     * Creates a default <code>XbcMemberRef</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcMemberRef
     */
    public XbcMemberRef createXbcMemberRef() {
        return (new XbcMemberRef());
    }

    /**
     * Creates a default <code>XbcCastExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcCastExpr
     */
    public XbcCastExpr createXbcCastExpr() {
        return (new XbcCastExpr());
    }

    /**
     * Creates a default <code>XbcStringConstant</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcStringConstant
     */
    public XbcStringConstant createXbcStringConstant() {
        return (new XbcStringConstant());
    }

    /**
     * Creates a default <code>XbcVarAddr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcVarAddr
     */
    public XbcVarAddr createXbcVarAddr() {
        return (new XbcVarAddr());
    }

    /**
     * Creates a default <code>XbcCompoundValueExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcCompoundValueExpr
     */
    public XbcCompoundValueExpr createXbcCompoundValueExpr() {
        return (new XbcCompoundValueExpr());
    }

    /**
     * Creates a default <code>XbcCompoundValueAddrExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcCompoundValueAddrExpr
     */
    public XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr() {
        return (new XbcCompoundValueAddrExpr());
    }

    /**
     * Creates a default <code>XbcXmpDescOf</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcXmpDescOf
     */
    public XbcXmpDescOf createXbcXmpDescOf() {
        return (new XbcXmpDescOf());
    }

    /**
     * Creates a default <code>XbcIntConstant</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcIntConstant
     */
    public XbcIntConstant createXbcIntConstant() {
        return (new XbcIntConstant());
    }

    /**
     * Creates a default <code>XbcFloatConstant</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcFloatConstant
     */
    public XbcFloatConstant createXbcFloatConstant() {
        return (new XbcFloatConstant());
    }

    /**
     * Creates a default <code>XbcLonglongConstant</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcLonglongConstant
     */
    public XbcLonglongConstant createXbcLonglongConstant() {
        return (new XbcLonglongConstant());
    }

    /**
     * Creates a default <code>XbcMoeConstant</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcMoeConstant
     */
    public XbcMoeConstant createXbcMoeConstant() {
        return (new XbcMoeConstant());
    }

    /**
     * Creates a default <code>XbcFuncAddr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcFuncAddr
     */
    public XbcFuncAddr createXbcFuncAddr() {
        return (new XbcFuncAddr());
    }

    /**
     * Creates a default <code>XbcSizeOfExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcSizeOfExpr
     */
    public XbcSizeOfExpr createXbcSizeOfExpr() {
        return (new XbcSizeOfExpr());
    }

    /**
     * Creates a default <code>XbcCoArrayAssignExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcCoArrayAssignExpr
     */
    public XbcCoArrayAssignExpr createXbcCoArrayAssignExpr() {
        return (new XbcCoArrayAssignExpr());
    }

    /**
     * Creates a default <code>XbcModExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcModExpr
     */
    public XbcModExpr createXbcModExpr() {
        return (new XbcModExpr());
    }

    /**
     * Creates a default <code>XbcBitOrExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcBitOrExpr
     */
    public XbcBitOrExpr createXbcBitOrExpr() {
        return (new XbcBitOrExpr());
    }

    /**
     * Creates a default <code>XbcLogOrExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcLogOrExpr
     */
    public XbcLogOrExpr createXbcLogOrExpr() {
        return (new XbcLogOrExpr());
    }

    /**
     * Creates a default <code>XbcPlusExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcPlusExpr
     */
    public XbcPlusExpr createXbcPlusExpr() {
        return (new XbcPlusExpr());
    }

    /**
     * Creates a default <code>XbcAsgPlusExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcAsgPlusExpr
     */
    public XbcAsgPlusExpr createXbcAsgPlusExpr() {
        return (new XbcAsgPlusExpr());
    }

    /**
     * Creates a default <code>XbcAsgModExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcAsgModExpr
     */
    public XbcAsgModExpr createXbcAsgModExpr() {
        return (new XbcAsgModExpr());
    }

    /**
     * Creates a default <code>XbcAsgBitOrExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcAsgBitOrExpr
     */
    public XbcAsgBitOrExpr createXbcAsgBitOrExpr() {
        return (new XbcAsgBitOrExpr());
    }

    /**
     * Creates a default <code>XbcLogGTExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcLogGTExpr
     */
    public XbcLogGTExpr createXbcLogGTExpr() {
        return (new XbcLogGTExpr());
    }

    /**
     * Creates a default <code>XbcCondExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcCondExpr
     */
    public XbcCondExpr createXbcCondExpr() {
        return (new XbcCondExpr());
    }

    /**
     * Creates a default <code>XbcMinusExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcMinusExpr
     */
    public XbcMinusExpr createXbcMinusExpr() {
        return (new XbcMinusExpr());
    }

    /**
     * Creates a default <code>XbcAddrOfExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcAddrOfExpr
     */
    public XbcAddrOfExpr createXbcAddrOfExpr() {
        return (new XbcAddrOfExpr());
    }

    /**
     * Creates a default <code>XbcLshiftExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcLshiftExpr
     */
    public XbcLshiftExpr createXbcLshiftExpr() {
        return (new XbcLshiftExpr());
    }

    /**
     * Creates a default <code>XbcRshiftExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcRshiftExpr
     */
    public XbcRshiftExpr createXbcRshiftExpr() {
        return (new XbcRshiftExpr());
    }

    /**
     * Creates a default <code>XbcAsgBitXorExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcAsgBitXorExpr
     */
    public XbcAsgBitXorExpr createXbcAsgBitXorExpr() {
        return (new XbcAsgBitXorExpr());
    }

    /**
     * Creates a default <code>XbcLogEQExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcLogEQExpr
     */
    public XbcLogEQExpr createXbcLogEQExpr() {
        return (new XbcLogEQExpr());
    }

    /**
     * Creates a default <code>XbcLogNEQExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcLogNEQExpr
     */
    public XbcLogNEQExpr createXbcLogNEQExpr() {
        return (new XbcLogNEQExpr());
    }

    /**
     * Creates a default <code>XbcLogGEExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcLogGEExpr
     */
    public XbcLogGEExpr createXbcLogGEExpr() {
        return (new XbcLogGEExpr());
    }

    /**
     * Creates a default <code>XbcLogLTExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcLogLTExpr
     */
    public XbcLogLTExpr createXbcLogLTExpr() {
        return (new XbcLogLTExpr());
    }

    /**
     * Creates a default <code>XbcGccAlignOfExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcGccAlignOfExpr
     */
    public XbcGccAlignOfExpr createXbcGccAlignOfExpr() {
        return (new XbcGccAlignOfExpr());
    }

    /**
     * Creates a default <code>XbcAssignExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcAssignExpr
     */
    public XbcAssignExpr createXbcAssignExpr() {
        return (new XbcAssignExpr());
    }

    /**
     * Creates a default <code>XbcMulExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcMulExpr
     */
    public XbcMulExpr createXbcMulExpr() {
        return (new XbcMulExpr());
    }

    /**
     * Creates a default <code>XbcDivExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcDivExpr
     */
    public XbcDivExpr createXbcDivExpr() {
        return (new XbcDivExpr());
    }

    /**
     * Creates a default <code>XbcAsgMulExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcAsgMulExpr
     */
    public XbcAsgMulExpr createXbcAsgMulExpr() {
        return (new XbcAsgMulExpr());
    }

    /**
     * Creates a default <code>XbcAsgRshiftExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcAsgRshiftExpr
     */
    public XbcAsgRshiftExpr createXbcAsgRshiftExpr() {
        return (new XbcAsgRshiftExpr());
    }

    /**
     * Creates a default <code>XbcAsgBitAndExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcAsgBitAndExpr
     */
    public XbcAsgBitAndExpr createXbcAsgBitAndExpr() {
        return (new XbcAsgBitAndExpr());
    }

    /**
     * Creates a default <code>XbcLogLEExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcLogLEExpr
     */
    public XbcLogLEExpr createXbcLogLEExpr() {
        return (new XbcLogLEExpr());
    }

    /**
     * Creates a default <code>XbcLogAndExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcLogAndExpr
     */
    public XbcLogAndExpr createXbcLogAndExpr() {
        return (new XbcLogAndExpr());
    }

    /**
     * Creates a default <code>XbcCommaExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcCommaExpr
     */
    public XbcCommaExpr createXbcCommaExpr() {
        return (new XbcCommaExpr());
    }

    /**
     * Creates a default <code>XbcAsgDivExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcAsgDivExpr
     */
    public XbcAsgDivExpr createXbcAsgDivExpr() {
        return (new XbcAsgDivExpr());
    }

    /**
     * Creates a default <code>XbcGccLabelAddr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcGccLabelAddr
     */
    public XbcGccLabelAddr createXbcGccLabelAddr() {
        return (new XbcGccLabelAddr());
    }

    /**
     * Creates a default <code>XbcBitAndExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcBitAndExpr
     */
    public XbcBitAndExpr createXbcBitAndExpr() {
        return (new XbcBitAndExpr());
    }

    /**
     * Creates a default <code>XbcBitXorExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcBitXorExpr
     */
    public XbcBitXorExpr createXbcBitXorExpr() {
        return (new XbcBitXorExpr());
    }

    /**
     * Creates a default <code>XbcAsgMinusExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcAsgMinusExpr
     */
    public XbcAsgMinusExpr createXbcAsgMinusExpr() {
        return (new XbcAsgMinusExpr());
    }

    /**
     * Creates a default <code>XbcAsgLshiftExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcAsgLshiftExpr
     */
    public XbcAsgLshiftExpr createXbcAsgLshiftExpr() {
        return (new XbcAsgLshiftExpr());
    }

    /**
     * Creates a default <code>XbcMemberAddr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcMemberAddr
     */
    public XbcMemberAddr createXbcMemberAddr() {
        return (new XbcMemberAddr());
    }

    /**
     * Creates a default <code>XbcMemberArrayRef</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcMemberArrayRef
     */
    public XbcMemberArrayRef createXbcMemberArrayRef() {
        return (new XbcMemberArrayRef());
    }

    /**
     * Creates a default <code>XbcMemberArrayAddr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcMemberArrayAddr
     */
    public XbcMemberArrayAddr createXbcMemberArrayAddr() {
        return (new XbcMemberArrayAddr());
    }

    /**
     * Creates a default <code>XbcTypeName</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcTypeName
     */
    public XbcTypeName createXbcTypeName() {
        return (new XbcTypeName());
    }

    /**
     * Creates a default <code>XbcPointerRef</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcPointerRef
     */
    public XbcPointerRef createXbcPointerRef() {
        return (new XbcPointerRef());
    }

    /**
     * Creates a default <code>XbcUnaryMinusExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcUnaryMinusExpr
     */
    public XbcUnaryMinusExpr createXbcUnaryMinusExpr() {
        return (new XbcUnaryMinusExpr());
    }

    /**
     * Creates a default <code>XbcBitNotExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcBitNotExpr
     */
    public XbcBitNotExpr createXbcBitNotExpr() {
        return (new XbcBitNotExpr());
    }

    /**
     * Creates a default <code>XbcLogNotExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcLogNotExpr
     */
    public XbcLogNotExpr createXbcLogNotExpr() {
        return (new XbcLogNotExpr());
    }

    /**
     * Creates a default <code>XbcPostIncrExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcPostIncrExpr
     */
    public XbcPostIncrExpr createXbcPostIncrExpr() {
        return (new XbcPostIncrExpr());
    }

    /**
     * Creates a default <code>XbcPostDecrExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcPostDecrExpr
     */
    public XbcPostDecrExpr createXbcPostDecrExpr() {
        return (new XbcPostDecrExpr());
    }

    /**
     * Creates a default <code>XbcPreIncrExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcPreIncrExpr
     */
    public XbcPreIncrExpr createXbcPreIncrExpr() {
        return (new XbcPreIncrExpr());
    }

    /**
     * Creates a default <code>XbcPreDecrExpr</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcPreDecrExpr
     */
    public XbcPreDecrExpr createXbcPreDecrExpr() {
        return (new XbcPreDecrExpr());
    }

    /**
     * Creates a default <code>XbcIndexRange</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcIndexRange
     */
    public XbcIndexRange createXbcIndexRange() {
        return (new XbcIndexRange());
    }

    /**
     * Creates a default <code>XbcLowerBound</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcLowerBound
     */
    public XbcLowerBound createXbcLowerBound() {
        return (new XbcLowerBound());
    }

    /**
     * Creates a default <code>XbcUpperBound</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcUpperBound
     */
    public XbcUpperBound createXbcUpperBound() {
        return (new XbcUpperBound());
    }

    /**
     * Creates a default <code>XbcStep</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcStep
     */
    public XbcStep createXbcStep() {
        return (new XbcStep());
    }

    /**
     * Creates a default <code>XbcDesignatedValue</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcDesignatedValue
     */
    public XbcDesignatedValue createXbcDesignatedValue() {
        return (new XbcDesignatedValue());
    }

    /**
     * Creates a default <code>XbcCompoundValue</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcCompoundValue
     */
    public XbcCompoundValue createXbcCompoundValue() {
        return (new XbcCompoundValue());
    }

    /**
     * Creates a default <code>XbcBitField</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcBitField
     */
    public XbcBitField createXbcBitField() {
        return (new XbcBitField());
    }

    /**
     * Creates a default <code>XbcPragma</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcPragma
     */
    public XbcPragma createXbcPragma() {
        return (new XbcPragma());
    }

    /**
     * Creates a default <code>XbcText</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcText
     */
    public XbcText createXbcText() {
        return (new XbcText());
    }

    /**
     * Creates a default <code>XbcDeclarations</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcDeclarations
     */
    public XbcDeclarations createXbcDeclarations() {
        return (new XbcDeclarations());
    }

    /**
     * Creates a default <code>XbcFunctionDefinition</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcFunctionDefinition
     */
    public XbcFunctionDefinition createXbcFunctionDefinition() {
        return (new XbcFunctionDefinition());
    }

    /**
     * Creates a default <code>XbcParams</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcParams
     */
    public XbcParams createXbcParams() {
        return (new XbcParams());
    }

    /**
     * Creates a default <code>XbcBody</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcBody
     */
    public XbcBody createXbcBody() {
        return (new XbcBody());
    }

    /**
     * Creates a default <code>XbcGccAsmStatement</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcGccAsmStatement
     */
    public XbcGccAsmStatement createXbcGccAsmStatement() {
        return (new XbcGccAsmStatement());
    }

    /**
     * Creates a default <code>XbcGccAsmOperands</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcGccAsmOperands
     */
    public XbcGccAsmOperands createXbcGccAsmOperands() {
        return (new XbcGccAsmOperands());
    }

    /**
     * Creates a default <code>XbcGccAsmOperand</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcGccAsmOperand
     */
    public XbcGccAsmOperand createXbcGccAsmOperand() {
        return (new XbcGccAsmOperand());
    }

    /**
     * Creates a default <code>XbcGccAsmClobbers</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcGccAsmClobbers
     */
    public XbcGccAsmClobbers createXbcGccAsmClobbers() {
        return (new XbcGccAsmClobbers());
    }

    /**
     * Creates a default <code>XbcForStatement</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcForStatement
     */
    public XbcForStatement createXbcForStatement() {
        return (new XbcForStatement());
    }

    /**
     * Creates a default <code>XbcInit</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcInit
     */
    public XbcInit createXbcInit() {
        return (new XbcInit());
    }

    /**
     * Creates a default <code>XbcCondition</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcCondition
     */
    public XbcCondition createXbcCondition() {
        return (new XbcCondition());
    }

    /**
     * Creates a default <code>XbcIter</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcIter
     */
    public XbcIter createXbcIter() {
        return (new XbcIter());
    }

    /**
     * Creates a default <code>XbcIfStatement</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcIfStatement
     */
    public XbcIfStatement createXbcIfStatement() {
        return (new XbcIfStatement());
    }

    /**
     * Creates a default <code>XbcThen</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcThen
     */
    public XbcThen createXbcThen() {
        return (new XbcThen());
    }

    /**
     * Creates a default <code>XbcElse</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcElse
     */
    public XbcElse createXbcElse() {
        return (new XbcElse());
    }

    /**
     * Creates a default <code>XbcWhileStatement</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcWhileStatement
     */
    public XbcWhileStatement createXbcWhileStatement() {
        return (new XbcWhileStatement());
    }

    /**
     * Creates a default <code>XbcDoStatement</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcDoStatement
     */
    public XbcDoStatement createXbcDoStatement() {
        return (new XbcDoStatement());
    }

    /**
     * Creates a default <code>XbcSwitchStatement</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcSwitchStatement
     */
    public XbcSwitchStatement createXbcSwitchStatement() {
        return (new XbcSwitchStatement());
    }

    /**
     * Creates a default <code>XbcGccRangedCaseLabel</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcGccRangedCaseLabel
     */
    public XbcGccRangedCaseLabel createXbcGccRangedCaseLabel() {
        return (new XbcGccRangedCaseLabel());
    }

    /**
     * Creates a default <code>XbcStatementLabel</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcStatementLabel
     */
    public XbcStatementLabel createXbcStatementLabel() {
        return (new XbcStatementLabel());
    }

    /**
     * Creates a default <code>XbcCaseLabel</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcCaseLabel
     */
    public XbcCaseLabel createXbcCaseLabel() {
        return (new XbcCaseLabel());
    }

    /**
     * Creates a default <code>XbcBreakStatement</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcBreakStatement
     */
    public XbcBreakStatement createXbcBreakStatement() {
        return (new XbcBreakStatement());
    }

    /**
     * Creates a default <code>XbcContinueStatement</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcContinueStatement
     */
    public XbcContinueStatement createXbcContinueStatement() {
        return (new XbcContinueStatement());
    }

    /**
     * Creates a default <code>XbcReturnStatement</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcReturnStatement
     */
    public XbcReturnStatement createXbcReturnStatement() {
        return (new XbcReturnStatement());
    }

    /**
     * Creates a default <code>XbcGotoStatement</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcGotoStatement
     */
    public XbcGotoStatement createXbcGotoStatement() {
        return (new XbcGotoStatement());
    }

    /**
     * Creates a default <code>XbcDefaultLabel</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcDefaultLabel
     */
    public XbcDefaultLabel createXbcDefaultLabel() {
        return (new XbcDefaultLabel());
    }

    /**
     * Creates a default <code>XbcExprStatement</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcExprStatement
     */
    public XbcExprStatement createXbcExprStatement() {
        return (new XbcExprStatement());
    }

    /**
     * Creates a default <code>XbcVarDecl</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcVarDecl
     */
    public XbcVarDecl createXbcVarDecl() {
        return (new XbcVarDecl());
    }

    /**
     * Creates a default <code>XbcGccAsm</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcGccAsm
     */
    public XbcGccAsm createXbcGccAsm() {
        return (new XbcGccAsm());
    }

    /**
     * Creates a default <code>XbcFunctionDecl</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcFunctionDecl
     */
    public XbcFunctionDecl createXbcFunctionDecl() {
        return (new XbcFunctionDecl());
    }

    /**
     * Creates a default <code>XbcGccMemberDesignator</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcGccMemberDesignator
     */
    public XbcGccMemberDesignator createXbcGccMemberDesignator() {
        return (new XbcGccMemberDesignator());
    }

    /**
     * Creates a default <code>XbcArrayType</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcArrayType
     */
    public XbcArrayType createXbcArrayType() {
        return (new XbcArrayType());
    }

    /**
     * Creates a default <code>XbcArraySize</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcArraySize
     */
    public XbcArraySize createXbcArraySize() {
        return (new XbcArraySize());
    }

    /**
     * Creates a default <code>XbcBasicType</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcBasicType
     */
    public XbcBasicType createXbcBasicType() {
        return (new XbcBasicType());
    }

    /**
     * Creates a default <code>XbcPointerType</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcPointerType
     */
    public XbcPointerType createXbcPointerType() {
        return (new XbcPointerType());
    }

    /**
     * Creates a default <code>XbcStructType</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcStructType
     */
    public XbcStructType createXbcStructType() {
        return (new XbcStructType());
    }

    /**
     * Creates a default <code>XbcUnionType</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcUnionType
     */
    public XbcUnionType createXbcUnionType() {
        return (new XbcUnionType());
    }

    /**
     * Creates a default <code>XbcEnumType</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcEnumType
     */
    public XbcEnumType createXbcEnumType() {
        return (new XbcEnumType());
    }

    /**
     * Creates a default <code>XbcCoArrayType</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcCoArrayType
     */
    public XbcCoArrayType createXbcCoArrayType() {
        return (new XbcCoArrayType());
    }

    /**
     * Creates a default <code>XbcGlobalSymbols</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcGlobalSymbols
     */
    public XbcGlobalSymbols createXbcGlobalSymbols() {
        return (new XbcGlobalSymbols());
    }

    /**
     * Creates a default <code>XbcGlobalDeclarations</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcGlobalDeclarations
     */
    public XbcGlobalDeclarations createXbcGlobalDeclarations() {
        return (new XbcGlobalDeclarations());
    }

    /**
     * Creates a default <code>XbcGccAsmDefinition</code>.
     * This method is a hook method of the AbstractXcodeML_CFactory.
     *
     * @return XbcGccAsmDefinition
     */
    public XbcGccAsmDefinition createXbcGccAsmDefinition() {
        return (new XbcGccAsmDefinition());
    }
}
