/*
 * The Relaxer artifact
 * Copyright (c) 2000-2003, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package xcodeml.c.binding.gen;

import xcodeml.binding.*;

import java.io.*;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * AbstractXcodeML_CFactory is generated by Relaxer based on XcodeML_C.rng.
 *
 * @version XcodeML_C.rng 1.0 (Thu Feb 02 16:55:19 JST 2012)
 * @author  Relaxer 1.0 (http://www.relaxer.org)
 */
public abstract class AbstractXcodeML_CFactory implements IXcodeML_CFactory {
    protected org.xml.sax.ErrorHandler errorHandler;
    protected org.xml.sax.EntityResolver entityResolver;
    protected String baseUri;

    /**
     * Sets a <b>errorHandler</b>.
     *
     * @param errorHandler
     */
    public void setErrorHandler(org.xml.sax.ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    /**
     * Gets a <b>errorHandler</b>.
     *
     * @return org.xml.sax.ErrorHandler
     */
    public org.xml.sax.ErrorHandler getErrorHandler() {
        return (errorHandler);
    }

    /**
     * Sets a <b>entityResolver</b>.
     *
     * @param entityResolver
     */
    public void setEntityResolver(org.xml.sax.EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    /**
     * Gets a <b>entityResolver</b>.
     *
     * @return org.xml.sax.EntityResolver
     */
    public org.xml.sax.EntityResolver getEntityResolver() {
        return (entityResolver);
    }

    /**
     * Sets a <b>baseUri</b>.
     *
     * @param baseUri
     */
    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    /**
     * Gets a <b>baseUri</b>.
     *
     * @return String
     */
    public String getBaseUri() {
        return (baseUri);
    }

    /**
     * Creates a <code>Object</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(File file) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(String uri) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(URL url) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the copy <code>Object</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return Object
     */
    public Object create(Object source) {
        if (source instanceof XbcXcodeProgram) {
            XbcXcodeProgram node = createXbcXcodeProgram();
            node.setup((XbcXcodeProgram)source);
            return(node);
        } else if (source instanceof XbcTypeTable) {
            XbcTypeTable node = createXbcTypeTable();
            node.setup((XbcTypeTable)source);
            return(node);
        } else if (source instanceof XbcFunctionType) {
            XbcFunctionType node = createXbcFunctionType();
            node.setup((XbcFunctionType)source);
            return(node);
        } else if (source instanceof XbcGccAttributes) {
            XbcGccAttributes node = createXbcGccAttributes();
            node.setup((XbcGccAttributes)source);
            return(node);
        } else if (source instanceof XbcGccAttribute) {
            XbcGccAttribute node = createXbcGccAttribute();
            node.setup((XbcGccAttribute)source);
            return(node);
        } else if (source instanceof XbcBuiltinOp) {
            XbcBuiltinOp node = createXbcBuiltinOp();
            node.setup((XbcBuiltinOp)source);
            return(node);
        } else if (source instanceof XbcArrayRef) {
            XbcArrayRef node = createXbcArrayRef();
            node.setup((XbcArrayRef)source);
            return(node);
        } else if (source instanceof XbcArrayAddr) {
            XbcArrayAddr node = createXbcArrayAddr();
            node.setup((XbcArrayAddr)source);
            return(node);
        } else if (source instanceof XbcFunctionCall) {
            XbcFunctionCall node = createXbcFunctionCall();
            node.setup((XbcFunctionCall)source);
            return(node);
        } else if (source instanceof XbcFunction) {
            XbcFunction node = createXbcFunction();
            node.setup((XbcFunction)source);
            return(node);
        } else if (source instanceof XbcArguments) {
            XbcArguments node = createXbcArguments();
            node.setup((XbcArguments)source);
            return(node);
        } else if (source instanceof XbcGccCompoundExpr) {
            XbcGccCompoundExpr node = createXbcGccCompoundExpr();
            node.setup((XbcGccCompoundExpr)source);
            return(node);
        } else if (source instanceof XbcCompoundStatement) {
            XbcCompoundStatement node = createXbcCompoundStatement();
            node.setup((XbcCompoundStatement)source);
            return(node);
        } else if (source instanceof XbcSymbols) {
            XbcSymbols node = createXbcSymbols();
            node.setup((XbcSymbols)source);
            return(node);
        } else if (source instanceof XbcId) {
            XbcId node = createXbcId();
            node.setup((XbcId)source);
            return(node);
        } else if (source instanceof XbcName) {
            XbcName node = createXbcName();
            node.setup((XbcName)source);
            return(node);
        } else if (source instanceof XbcValue) {
            XbcValue node = createXbcValue();
            node.setup((XbcValue)source);
            return(node);
        } else if (source instanceof XbcSubArrayRef) {
            XbcSubArrayRef node = createXbcSubArrayRef();
            node.setup((XbcSubArrayRef)source);
            return(node);
        } else if (source instanceof XbcCoArrayRef) {
            XbcCoArrayRef node = createXbcCoArrayRef();
            node.setup((XbcCoArrayRef)source);
            return(node);
        } else if (source instanceof XbcVar) {
            XbcVar node = createXbcVar();
            node.setup((XbcVar)source);
            return(node);
        } else if (source instanceof XbcMemberRef) {
            XbcMemberRef node = createXbcMemberRef();
            node.setup((XbcMemberRef)source);
            return(node);
        } else if (source instanceof XbcCastExpr) {
            XbcCastExpr node = createXbcCastExpr();
            node.setup((XbcCastExpr)source);
            return(node);
        } else if (source instanceof XbcStringConstant) {
            XbcStringConstant node = createXbcStringConstant();
            node.setup((XbcStringConstant)source);
            return(node);
        } else if (source instanceof XbcVarAddr) {
            XbcVarAddr node = createXbcVarAddr();
            node.setup((XbcVarAddr)source);
            return(node);
        } else if (source instanceof XbcCompoundValueExpr) {
            XbcCompoundValueExpr node = createXbcCompoundValueExpr();
            node.setup((XbcCompoundValueExpr)source);
            return(node);
        } else if (source instanceof XbcCompoundValueAddrExpr) {
            XbcCompoundValueAddrExpr node = createXbcCompoundValueAddrExpr();
            node.setup((XbcCompoundValueAddrExpr)source);
            return(node);
        } else if (source instanceof XbcXmpDescOf) {
            XbcXmpDescOf node = createXbcXmpDescOf();
            node.setup((XbcXmpDescOf)source);
            return(node);
        } else if (source instanceof XbcIntConstant) {
            XbcIntConstant node = createXbcIntConstant();
            node.setup((XbcIntConstant)source);
            return(node);
        } else if (source instanceof XbcFloatConstant) {
            XbcFloatConstant node = createXbcFloatConstant();
            node.setup((XbcFloatConstant)source);
            return(node);
        } else if (source instanceof XbcLonglongConstant) {
            XbcLonglongConstant node = createXbcLonglongConstant();
            node.setup((XbcLonglongConstant)source);
            return(node);
        } else if (source instanceof XbcMoeConstant) {
            XbcMoeConstant node = createXbcMoeConstant();
            node.setup((XbcMoeConstant)source);
            return(node);
        } else if (source instanceof XbcFuncAddr) {
            XbcFuncAddr node = createXbcFuncAddr();
            node.setup((XbcFuncAddr)source);
            return(node);
        } else if (source instanceof XbcSizeOfExpr) {
            XbcSizeOfExpr node = createXbcSizeOfExpr();
            node.setup((XbcSizeOfExpr)source);
            return(node);
        } else if (source instanceof XbcCoArrayAssignExpr) {
            XbcCoArrayAssignExpr node = createXbcCoArrayAssignExpr();
            node.setup((XbcCoArrayAssignExpr)source);
            return(node);
        } else if (source instanceof XbcModExpr) {
            XbcModExpr node = createXbcModExpr();
            node.setup((XbcModExpr)source);
            return(node);
        } else if (source instanceof XbcBitOrExpr) {
            XbcBitOrExpr node = createXbcBitOrExpr();
            node.setup((XbcBitOrExpr)source);
            return(node);
        } else if (source instanceof XbcLogOrExpr) {
            XbcLogOrExpr node = createXbcLogOrExpr();
            node.setup((XbcLogOrExpr)source);
            return(node);
        } else if (source instanceof XbcPlusExpr) {
            XbcPlusExpr node = createXbcPlusExpr();
            node.setup((XbcPlusExpr)source);
            return(node);
        } else if (source instanceof XbcAsgPlusExpr) {
            XbcAsgPlusExpr node = createXbcAsgPlusExpr();
            node.setup((XbcAsgPlusExpr)source);
            return(node);
        } else if (source instanceof XbcAsgModExpr) {
            XbcAsgModExpr node = createXbcAsgModExpr();
            node.setup((XbcAsgModExpr)source);
            return(node);
        } else if (source instanceof XbcAsgBitOrExpr) {
            XbcAsgBitOrExpr node = createXbcAsgBitOrExpr();
            node.setup((XbcAsgBitOrExpr)source);
            return(node);
        } else if (source instanceof XbcLogGTExpr) {
            XbcLogGTExpr node = createXbcLogGTExpr();
            node.setup((XbcLogGTExpr)source);
            return(node);
        } else if (source instanceof XbcCondExpr) {
            XbcCondExpr node = createXbcCondExpr();
            node.setup((XbcCondExpr)source);
            return(node);
        } else if (source instanceof XbcMinusExpr) {
            XbcMinusExpr node = createXbcMinusExpr();
            node.setup((XbcMinusExpr)source);
            return(node);
        } else if (source instanceof XbcAddrOfExpr) {
            XbcAddrOfExpr node = createXbcAddrOfExpr();
            node.setup((XbcAddrOfExpr)source);
            return(node);
        } else if (source instanceof XbcLshiftExpr) {
            XbcLshiftExpr node = createXbcLshiftExpr();
            node.setup((XbcLshiftExpr)source);
            return(node);
        } else if (source instanceof XbcRshiftExpr) {
            XbcRshiftExpr node = createXbcRshiftExpr();
            node.setup((XbcRshiftExpr)source);
            return(node);
        } else if (source instanceof XbcAsgBitXorExpr) {
            XbcAsgBitXorExpr node = createXbcAsgBitXorExpr();
            node.setup((XbcAsgBitXorExpr)source);
            return(node);
        } else if (source instanceof XbcLogEQExpr) {
            XbcLogEQExpr node = createXbcLogEQExpr();
            node.setup((XbcLogEQExpr)source);
            return(node);
        } else if (source instanceof XbcLogNEQExpr) {
            XbcLogNEQExpr node = createXbcLogNEQExpr();
            node.setup((XbcLogNEQExpr)source);
            return(node);
        } else if (source instanceof XbcLogGEExpr) {
            XbcLogGEExpr node = createXbcLogGEExpr();
            node.setup((XbcLogGEExpr)source);
            return(node);
        } else if (source instanceof XbcLogLTExpr) {
            XbcLogLTExpr node = createXbcLogLTExpr();
            node.setup((XbcLogLTExpr)source);
            return(node);
        } else if (source instanceof XbcGccAlignOfExpr) {
            XbcGccAlignOfExpr node = createXbcGccAlignOfExpr();
            node.setup((XbcGccAlignOfExpr)source);
            return(node);
        } else if (source instanceof XbcAssignExpr) {
            XbcAssignExpr node = createXbcAssignExpr();
            node.setup((XbcAssignExpr)source);
            return(node);
        } else if (source instanceof XbcMulExpr) {
            XbcMulExpr node = createXbcMulExpr();
            node.setup((XbcMulExpr)source);
            return(node);
        } else if (source instanceof XbcDivExpr) {
            XbcDivExpr node = createXbcDivExpr();
            node.setup((XbcDivExpr)source);
            return(node);
        } else if (source instanceof XbcAsgMulExpr) {
            XbcAsgMulExpr node = createXbcAsgMulExpr();
            node.setup((XbcAsgMulExpr)source);
            return(node);
        } else if (source instanceof XbcAsgRshiftExpr) {
            XbcAsgRshiftExpr node = createXbcAsgRshiftExpr();
            node.setup((XbcAsgRshiftExpr)source);
            return(node);
        } else if (source instanceof XbcAsgBitAndExpr) {
            XbcAsgBitAndExpr node = createXbcAsgBitAndExpr();
            node.setup((XbcAsgBitAndExpr)source);
            return(node);
        } else if (source instanceof XbcLogLEExpr) {
            XbcLogLEExpr node = createXbcLogLEExpr();
            node.setup((XbcLogLEExpr)source);
            return(node);
        } else if (source instanceof XbcLogAndExpr) {
            XbcLogAndExpr node = createXbcLogAndExpr();
            node.setup((XbcLogAndExpr)source);
            return(node);
        } else if (source instanceof XbcCommaExpr) {
            XbcCommaExpr node = createXbcCommaExpr();
            node.setup((XbcCommaExpr)source);
            return(node);
        } else if (source instanceof XbcAsgDivExpr) {
            XbcAsgDivExpr node = createXbcAsgDivExpr();
            node.setup((XbcAsgDivExpr)source);
            return(node);
        } else if (source instanceof XbcGccLabelAddr) {
            XbcGccLabelAddr node = createXbcGccLabelAddr();
            node.setup((XbcGccLabelAddr)source);
            return(node);
        } else if (source instanceof XbcBitAndExpr) {
            XbcBitAndExpr node = createXbcBitAndExpr();
            node.setup((XbcBitAndExpr)source);
            return(node);
        } else if (source instanceof XbcBitXorExpr) {
            XbcBitXorExpr node = createXbcBitXorExpr();
            node.setup((XbcBitXorExpr)source);
            return(node);
        } else if (source instanceof XbcAsgMinusExpr) {
            XbcAsgMinusExpr node = createXbcAsgMinusExpr();
            node.setup((XbcAsgMinusExpr)source);
            return(node);
        } else if (source instanceof XbcAsgLshiftExpr) {
            XbcAsgLshiftExpr node = createXbcAsgLshiftExpr();
            node.setup((XbcAsgLshiftExpr)source);
            return(node);
        } else if (source instanceof XbcMemberAddr) {
            XbcMemberAddr node = createXbcMemberAddr();
            node.setup((XbcMemberAddr)source);
            return(node);
        } else if (source instanceof XbcMemberArrayRef) {
            XbcMemberArrayRef node = createXbcMemberArrayRef();
            node.setup((XbcMemberArrayRef)source);
            return(node);
        } else if (source instanceof XbcMemberArrayAddr) {
            XbcMemberArrayAddr node = createXbcMemberArrayAddr();
            node.setup((XbcMemberArrayAddr)source);
            return(node);
        } else if (source instanceof XbcTypeName) {
            XbcTypeName node = createXbcTypeName();
            node.setup((XbcTypeName)source);
            return(node);
        } else if (source instanceof XbcPointerRef) {
            XbcPointerRef node = createXbcPointerRef();
            node.setup((XbcPointerRef)source);
            return(node);
        } else if (source instanceof XbcUnaryMinusExpr) {
            XbcUnaryMinusExpr node = createXbcUnaryMinusExpr();
            node.setup((XbcUnaryMinusExpr)source);
            return(node);
        } else if (source instanceof XbcBitNotExpr) {
            XbcBitNotExpr node = createXbcBitNotExpr();
            node.setup((XbcBitNotExpr)source);
            return(node);
        } else if (source instanceof XbcLogNotExpr) {
            XbcLogNotExpr node = createXbcLogNotExpr();
            node.setup((XbcLogNotExpr)source);
            return(node);
        } else if (source instanceof XbcPostIncrExpr) {
            XbcPostIncrExpr node = createXbcPostIncrExpr();
            node.setup((XbcPostIncrExpr)source);
            return(node);
        } else if (source instanceof XbcPostDecrExpr) {
            XbcPostDecrExpr node = createXbcPostDecrExpr();
            node.setup((XbcPostDecrExpr)source);
            return(node);
        } else if (source instanceof XbcPreIncrExpr) {
            XbcPreIncrExpr node = createXbcPreIncrExpr();
            node.setup((XbcPreIncrExpr)source);
            return(node);
        } else if (source instanceof XbcPreDecrExpr) {
            XbcPreDecrExpr node = createXbcPreDecrExpr();
            node.setup((XbcPreDecrExpr)source);
            return(node);
        } else if (source instanceof XbcIndexRange) {
            XbcIndexRange node = createXbcIndexRange();
            node.setup((XbcIndexRange)source);
            return(node);
        } else if (source instanceof XbcLowerBound) {
            XbcLowerBound node = createXbcLowerBound();
            node.setup((XbcLowerBound)source);
            return(node);
        } else if (source instanceof XbcUpperBound) {
            XbcUpperBound node = createXbcUpperBound();
            node.setup((XbcUpperBound)source);
            return(node);
        } else if (source instanceof XbcStep) {
            XbcStep node = createXbcStep();
            node.setup((XbcStep)source);
            return(node);
        } else if (source instanceof XbcDesignatedValue) {
            XbcDesignatedValue node = createXbcDesignatedValue();
            node.setup((XbcDesignatedValue)source);
            return(node);
        } else if (source instanceof XbcCompoundValue) {
            XbcCompoundValue node = createXbcCompoundValue();
            node.setup((XbcCompoundValue)source);
            return(node);
        } else if (source instanceof XbcBitField) {
            XbcBitField node = createXbcBitField();
            node.setup((XbcBitField)source);
            return(node);
        } else if (source instanceof XbcPragma) {
            XbcPragma node = createXbcPragma();
            node.setup((XbcPragma)source);
            return(node);
        } else if (source instanceof XbcText) {
            XbcText node = createXbcText();
            node.setup((XbcText)source);
            return(node);
        } else if (source instanceof XbcDeclarations) {
            XbcDeclarations node = createXbcDeclarations();
            node.setup((XbcDeclarations)source);
            return(node);
        } else if (source instanceof XbcFunctionDefinition) {
            XbcFunctionDefinition node = createXbcFunctionDefinition();
            node.setup((XbcFunctionDefinition)source);
            return(node);
        } else if (source instanceof XbcParams) {
            XbcParams node = createXbcParams();
            node.setup((XbcParams)source);
            return(node);
        } else if (source instanceof XbcBody) {
            XbcBody node = createXbcBody();
            node.setup((XbcBody)source);
            return(node);
        } else if (source instanceof XbcGccAsmStatement) {
            XbcGccAsmStatement node = createXbcGccAsmStatement();
            node.setup((XbcGccAsmStatement)source);
            return(node);
        } else if (source instanceof XbcGccAsmOperands) {
            XbcGccAsmOperands node = createXbcGccAsmOperands();
            node.setup((XbcGccAsmOperands)source);
            return(node);
        } else if (source instanceof XbcGccAsmOperand) {
            XbcGccAsmOperand node = createXbcGccAsmOperand();
            node.setup((XbcGccAsmOperand)source);
            return(node);
        } else if (source instanceof XbcGccAsmClobbers) {
            XbcGccAsmClobbers node = createXbcGccAsmClobbers();
            node.setup((XbcGccAsmClobbers)source);
            return(node);
        } else if (source instanceof XbcForStatement) {
            XbcForStatement node = createXbcForStatement();
            node.setup((XbcForStatement)source);
            return(node);
        } else if (source instanceof XbcInit) {
            XbcInit node = createXbcInit();
            node.setup((XbcInit)source);
            return(node);
        } else if (source instanceof XbcCondition) {
            XbcCondition node = createXbcCondition();
            node.setup((XbcCondition)source);
            return(node);
        } else if (source instanceof XbcIter) {
            XbcIter node = createXbcIter();
            node.setup((XbcIter)source);
            return(node);
        } else if (source instanceof XbcIfStatement) {
            XbcIfStatement node = createXbcIfStatement();
            node.setup((XbcIfStatement)source);
            return(node);
        } else if (source instanceof XbcThen) {
            XbcThen node = createXbcThen();
            node.setup((XbcThen)source);
            return(node);
        } else if (source instanceof XbcElse) {
            XbcElse node = createXbcElse();
            node.setup((XbcElse)source);
            return(node);
        } else if (source instanceof XbcWhileStatement) {
            XbcWhileStatement node = createXbcWhileStatement();
            node.setup((XbcWhileStatement)source);
            return(node);
        } else if (source instanceof XbcDoStatement) {
            XbcDoStatement node = createXbcDoStatement();
            node.setup((XbcDoStatement)source);
            return(node);
        } else if (source instanceof XbcSwitchStatement) {
            XbcSwitchStatement node = createXbcSwitchStatement();
            node.setup((XbcSwitchStatement)source);
            return(node);
        } else if (source instanceof XbcGccRangedCaseLabel) {
            XbcGccRangedCaseLabel node = createXbcGccRangedCaseLabel();
            node.setup((XbcGccRangedCaseLabel)source);
            return(node);
        } else if (source instanceof XbcStatementLabel) {
            XbcStatementLabel node = createXbcStatementLabel();
            node.setup((XbcStatementLabel)source);
            return(node);
        } else if (source instanceof XbcCaseLabel) {
            XbcCaseLabel node = createXbcCaseLabel();
            node.setup((XbcCaseLabel)source);
            return(node);
        } else if (source instanceof XbcBreakStatement) {
            XbcBreakStatement node = createXbcBreakStatement();
            node.setup((XbcBreakStatement)source);
            return(node);
        } else if (source instanceof XbcContinueStatement) {
            XbcContinueStatement node = createXbcContinueStatement();
            node.setup((XbcContinueStatement)source);
            return(node);
        } else if (source instanceof XbcReturnStatement) {
            XbcReturnStatement node = createXbcReturnStatement();
            node.setup((XbcReturnStatement)source);
            return(node);
        } else if (source instanceof XbcGotoStatement) {
            XbcGotoStatement node = createXbcGotoStatement();
            node.setup((XbcGotoStatement)source);
            return(node);
        } else if (source instanceof XbcDefaultLabel) {
            XbcDefaultLabel node = createXbcDefaultLabel();
            node.setup((XbcDefaultLabel)source);
            return(node);
        } else if (source instanceof XbcExprStatement) {
            XbcExprStatement node = createXbcExprStatement();
            node.setup((XbcExprStatement)source);
            return(node);
        } else if (source instanceof XbcVarDecl) {
            XbcVarDecl node = createXbcVarDecl();
            node.setup((XbcVarDecl)source);
            return(node);
        } else if (source instanceof XbcGccAsm) {
            XbcGccAsm node = createXbcGccAsm();
            node.setup((XbcGccAsm)source);
            return(node);
        } else if (source instanceof XbcFunctionDecl) {
            XbcFunctionDecl node = createXbcFunctionDecl();
            node.setup((XbcFunctionDecl)source);
            return(node);
        } else if (source instanceof XbcGccMemberDesignator) {
            XbcGccMemberDesignator node = createXbcGccMemberDesignator();
            node.setup((XbcGccMemberDesignator)source);
            return(node);
        } else if (source instanceof XbcArrayType) {
            XbcArrayType node = createXbcArrayType();
            node.setup((XbcArrayType)source);
            return(node);
        } else if (source instanceof XbcArraySize) {
            XbcArraySize node = createXbcArraySize();
            node.setup((XbcArraySize)source);
            return(node);
        } else if (source instanceof XbcBasicType) {
            XbcBasicType node = createXbcBasicType();
            node.setup((XbcBasicType)source);
            return(node);
        } else if (source instanceof XbcPointerType) {
            XbcPointerType node = createXbcPointerType();
            node.setup((XbcPointerType)source);
            return(node);
        } else if (source instanceof XbcStructType) {
            XbcStructType node = createXbcStructType();
            node.setup((XbcStructType)source);
            return(node);
        } else if (source instanceof XbcUnionType) {
            XbcUnionType node = createXbcUnionType();
            node.setup((XbcUnionType)source);
            return(node);
        } else if (source instanceof XbcEnumType) {
            XbcEnumType node = createXbcEnumType();
            node.setup((XbcEnumType)source);
            return(node);
        } else if (source instanceof XbcCoArrayType) {
            XbcCoArrayType node = createXbcCoArrayType();
            node.setup((XbcCoArrayType)source);
            return(node);
        } else if (source instanceof XbcGlobalSymbols) {
            XbcGlobalSymbols node = createXbcGlobalSymbols();
            node.setup((XbcGlobalSymbols)source);
            return(node);
        } else if (source instanceof XbcGlobalDeclarations) {
            XbcGlobalDeclarations node = createXbcGlobalDeclarations();
            node.setup((XbcGlobalDeclarations)source);
            return(node);
        } else if (source instanceof XbcGccAsmDefinition) {
            XbcGccAsmDefinition node = createXbcGccAsmDefinition();
            node.setup((XbcGccAsmDefinition)source);
            return(node);
        } else {
            return (null);
        }
    }

    /**
     * Creates a <code>Object</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(Document doc) throws IOException, SAXException, ParserConfigurationException {
        Object node = create(doc.getDocumentElement());
        return (node);
    }

    /**
     * Creates a <code>Object</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return Object
     */
    public Object create(Element element) throws IOException, SAXException, ParserConfigurationException {
        if (XbcXcodeProgram.isMatch(element)) {
            XbcXcodeProgram node = createXbcXcodeProgram();
            node.setup(element);
            return(node);
        } else if (XbcTypeTable.isMatch(element)) {
            XbcTypeTable node = createXbcTypeTable();
            node.setup(element);
            return(node);
        } else if (XbcFunctionType.isMatch(element)) {
            XbcFunctionType node = createXbcFunctionType();
            node.setup(element);
            return(node);
        } else if (XbcGccAttributes.isMatch(element)) {
            XbcGccAttributes node = createXbcGccAttributes();
            node.setup(element);
            return(node);
        } else if (XbcGccAttribute.isMatch(element)) {
            XbcGccAttribute node = createXbcGccAttribute();
            node.setup(element);
            return(node);
        } else if (XbcBuiltinOp.isMatch(element)) {
            XbcBuiltinOp node = createXbcBuiltinOp();
            node.setup(element);
            return(node);
        } else if (XbcArrayRef.isMatch(element)) {
            XbcArrayRef node = createXbcArrayRef();
            node.setup(element);
            return(node);
        } else if (XbcArrayAddr.isMatch(element)) {
            XbcArrayAddr node = createXbcArrayAddr();
            node.setup(element);
            return(node);
        } else if (XbcFunctionCall.isMatch(element)) {
            XbcFunctionCall node = createXbcFunctionCall();
            node.setup(element);
            return(node);
        } else if (XbcFunction.isMatch(element)) {
            XbcFunction node = createXbcFunction();
            node.setup(element);
            return(node);
        } else if (XbcArguments.isMatch(element)) {
            XbcArguments node = createXbcArguments();
            node.setup(element);
            return(node);
        } else if (XbcGccCompoundExpr.isMatch(element)) {
            XbcGccCompoundExpr node = createXbcGccCompoundExpr();
            node.setup(element);
            return(node);
        } else if (XbcCompoundStatement.isMatch(element)) {
            XbcCompoundStatement node = createXbcCompoundStatement();
            node.setup(element);
            return(node);
        } else if (XbcSymbols.isMatch(element)) {
            XbcSymbols node = createXbcSymbols();
            node.setup(element);
            return(node);
        } else if (XbcId.isMatch(element)) {
            XbcId node = createXbcId();
            node.setup(element);
            return(node);
        } else if (XbcName.isMatch(element)) {
            XbcName node = createXbcName();
            node.setup(element);
            return(node);
        } else if (XbcValue.isMatch(element)) {
            XbcValue node = createXbcValue();
            node.setup(element);
            return(node);
        } else if (XbcSubArrayRef.isMatch(element)) {
            XbcSubArrayRef node = createXbcSubArrayRef();
            node.setup(element);
            return(node);
        } else if (XbcCoArrayRef.isMatch(element)) {
            XbcCoArrayRef node = createXbcCoArrayRef();
            node.setup(element);
            return(node);
        } else if (XbcVar.isMatch(element)) {
            XbcVar node = createXbcVar();
            node.setup(element);
            return(node);
        } else if (XbcMemberRef.isMatch(element)) {
            XbcMemberRef node = createXbcMemberRef();
            node.setup(element);
            return(node);
        } else if (XbcCastExpr.isMatch(element)) {
            XbcCastExpr node = createXbcCastExpr();
            node.setup(element);
            return(node);
        } else if (XbcStringConstant.isMatch(element)) {
            XbcStringConstant node = createXbcStringConstant();
            node.setup(element);
            return(node);
        } else if (XbcVarAddr.isMatch(element)) {
            XbcVarAddr node = createXbcVarAddr();
            node.setup(element);
            return(node);
        } else if (XbcCompoundValueExpr.isMatch(element)) {
            XbcCompoundValueExpr node = createXbcCompoundValueExpr();
            node.setup(element);
            return(node);
        } else if (XbcCompoundValueAddrExpr.isMatch(element)) {
            XbcCompoundValueAddrExpr node = createXbcCompoundValueAddrExpr();
            node.setup(element);
            return(node);
        } else if (XbcXmpDescOf.isMatch(element)) {
            XbcXmpDescOf node = createXbcXmpDescOf();
            node.setup(element);
            return(node);
        } else if (XbcIntConstant.isMatch(element)) {
            XbcIntConstant node = createXbcIntConstant();
            node.setup(element);
            return(node);
        } else if (XbcFloatConstant.isMatch(element)) {
            XbcFloatConstant node = createXbcFloatConstant();
            node.setup(element);
            return(node);
        } else if (XbcLonglongConstant.isMatch(element)) {
            XbcLonglongConstant node = createXbcLonglongConstant();
            node.setup(element);
            return(node);
        } else if (XbcMoeConstant.isMatch(element)) {
            XbcMoeConstant node = createXbcMoeConstant();
            node.setup(element);
            return(node);
        } else if (XbcFuncAddr.isMatch(element)) {
            XbcFuncAddr node = createXbcFuncAddr();
            node.setup(element);
            return(node);
        } else if (XbcSizeOfExpr.isMatch(element)) {
            XbcSizeOfExpr node = createXbcSizeOfExpr();
            node.setup(element);
            return(node);
        } else if (XbcCoArrayAssignExpr.isMatch(element)) {
            XbcCoArrayAssignExpr node = createXbcCoArrayAssignExpr();
            node.setup(element);
            return(node);
        } else if (XbcModExpr.isMatch(element)) {
            XbcModExpr node = createXbcModExpr();
            node.setup(element);
            return(node);
        } else if (XbcBitOrExpr.isMatch(element)) {
            XbcBitOrExpr node = createXbcBitOrExpr();
            node.setup(element);
            return(node);
        } else if (XbcLogOrExpr.isMatch(element)) {
            XbcLogOrExpr node = createXbcLogOrExpr();
            node.setup(element);
            return(node);
        } else if (XbcPlusExpr.isMatch(element)) {
            XbcPlusExpr node = createXbcPlusExpr();
            node.setup(element);
            return(node);
        } else if (XbcAsgPlusExpr.isMatch(element)) {
            XbcAsgPlusExpr node = createXbcAsgPlusExpr();
            node.setup(element);
            return(node);
        } else if (XbcAsgModExpr.isMatch(element)) {
            XbcAsgModExpr node = createXbcAsgModExpr();
            node.setup(element);
            return(node);
        } else if (XbcAsgBitOrExpr.isMatch(element)) {
            XbcAsgBitOrExpr node = createXbcAsgBitOrExpr();
            node.setup(element);
            return(node);
        } else if (XbcLogGTExpr.isMatch(element)) {
            XbcLogGTExpr node = createXbcLogGTExpr();
            node.setup(element);
            return(node);
        } else if (XbcCondExpr.isMatch(element)) {
            XbcCondExpr node = createXbcCondExpr();
            node.setup(element);
            return(node);
        } else if (XbcMinusExpr.isMatch(element)) {
            XbcMinusExpr node = createXbcMinusExpr();
            node.setup(element);
            return(node);
        } else if (XbcAddrOfExpr.isMatch(element)) {
            XbcAddrOfExpr node = createXbcAddrOfExpr();
            node.setup(element);
            return(node);
        } else if (XbcLshiftExpr.isMatch(element)) {
            XbcLshiftExpr node = createXbcLshiftExpr();
            node.setup(element);
            return(node);
        } else if (XbcRshiftExpr.isMatch(element)) {
            XbcRshiftExpr node = createXbcRshiftExpr();
            node.setup(element);
            return(node);
        } else if (XbcAsgBitXorExpr.isMatch(element)) {
            XbcAsgBitXorExpr node = createXbcAsgBitXorExpr();
            node.setup(element);
            return(node);
        } else if (XbcLogEQExpr.isMatch(element)) {
            XbcLogEQExpr node = createXbcLogEQExpr();
            node.setup(element);
            return(node);
        } else if (XbcLogNEQExpr.isMatch(element)) {
            XbcLogNEQExpr node = createXbcLogNEQExpr();
            node.setup(element);
            return(node);
        } else if (XbcLogGEExpr.isMatch(element)) {
            XbcLogGEExpr node = createXbcLogGEExpr();
            node.setup(element);
            return(node);
        } else if (XbcLogLTExpr.isMatch(element)) {
            XbcLogLTExpr node = createXbcLogLTExpr();
            node.setup(element);
            return(node);
        } else if (XbcGccAlignOfExpr.isMatch(element)) {
            XbcGccAlignOfExpr node = createXbcGccAlignOfExpr();
            node.setup(element);
            return(node);
        } else if (XbcAssignExpr.isMatch(element)) {
            XbcAssignExpr node = createXbcAssignExpr();
            node.setup(element);
            return(node);
        } else if (XbcMulExpr.isMatch(element)) {
            XbcMulExpr node = createXbcMulExpr();
            node.setup(element);
            return(node);
        } else if (XbcDivExpr.isMatch(element)) {
            XbcDivExpr node = createXbcDivExpr();
            node.setup(element);
            return(node);
        } else if (XbcAsgMulExpr.isMatch(element)) {
            XbcAsgMulExpr node = createXbcAsgMulExpr();
            node.setup(element);
            return(node);
        } else if (XbcAsgRshiftExpr.isMatch(element)) {
            XbcAsgRshiftExpr node = createXbcAsgRshiftExpr();
            node.setup(element);
            return(node);
        } else if (XbcAsgBitAndExpr.isMatch(element)) {
            XbcAsgBitAndExpr node = createXbcAsgBitAndExpr();
            node.setup(element);
            return(node);
        } else if (XbcLogLEExpr.isMatch(element)) {
            XbcLogLEExpr node = createXbcLogLEExpr();
            node.setup(element);
            return(node);
        } else if (XbcLogAndExpr.isMatch(element)) {
            XbcLogAndExpr node = createXbcLogAndExpr();
            node.setup(element);
            return(node);
        } else if (XbcCommaExpr.isMatch(element)) {
            XbcCommaExpr node = createXbcCommaExpr();
            node.setup(element);
            return(node);
        } else if (XbcAsgDivExpr.isMatch(element)) {
            XbcAsgDivExpr node = createXbcAsgDivExpr();
            node.setup(element);
            return(node);
        } else if (XbcGccLabelAddr.isMatch(element)) {
            XbcGccLabelAddr node = createXbcGccLabelAddr();
            node.setup(element);
            return(node);
        } else if (XbcBitAndExpr.isMatch(element)) {
            XbcBitAndExpr node = createXbcBitAndExpr();
            node.setup(element);
            return(node);
        } else if (XbcBitXorExpr.isMatch(element)) {
            XbcBitXorExpr node = createXbcBitXorExpr();
            node.setup(element);
            return(node);
        } else if (XbcAsgMinusExpr.isMatch(element)) {
            XbcAsgMinusExpr node = createXbcAsgMinusExpr();
            node.setup(element);
            return(node);
        } else if (XbcAsgLshiftExpr.isMatch(element)) {
            XbcAsgLshiftExpr node = createXbcAsgLshiftExpr();
            node.setup(element);
            return(node);
        } else if (XbcMemberAddr.isMatch(element)) {
            XbcMemberAddr node = createXbcMemberAddr();
            node.setup(element);
            return(node);
        } else if (XbcMemberArrayRef.isMatch(element)) {
            XbcMemberArrayRef node = createXbcMemberArrayRef();
            node.setup(element);
            return(node);
        } else if (XbcMemberArrayAddr.isMatch(element)) {
            XbcMemberArrayAddr node = createXbcMemberArrayAddr();
            node.setup(element);
            return(node);
        } else if (XbcTypeName.isMatch(element)) {
            XbcTypeName node = createXbcTypeName();
            node.setup(element);
            return(node);
        } else if (XbcPointerRef.isMatch(element)) {
            XbcPointerRef node = createXbcPointerRef();
            node.setup(element);
            return(node);
        } else if (XbcUnaryMinusExpr.isMatch(element)) {
            XbcUnaryMinusExpr node = createXbcUnaryMinusExpr();
            node.setup(element);
            return(node);
        } else if (XbcBitNotExpr.isMatch(element)) {
            XbcBitNotExpr node = createXbcBitNotExpr();
            node.setup(element);
            return(node);
        } else if (XbcLogNotExpr.isMatch(element)) {
            XbcLogNotExpr node = createXbcLogNotExpr();
            node.setup(element);
            return(node);
        } else if (XbcPostIncrExpr.isMatch(element)) {
            XbcPostIncrExpr node = createXbcPostIncrExpr();
            node.setup(element);
            return(node);
        } else if (XbcPostDecrExpr.isMatch(element)) {
            XbcPostDecrExpr node = createXbcPostDecrExpr();
            node.setup(element);
            return(node);
        } else if (XbcPreIncrExpr.isMatch(element)) {
            XbcPreIncrExpr node = createXbcPreIncrExpr();
            node.setup(element);
            return(node);
        } else if (XbcPreDecrExpr.isMatch(element)) {
            XbcPreDecrExpr node = createXbcPreDecrExpr();
            node.setup(element);
            return(node);
        } else if (XbcIndexRange.isMatch(element)) {
            XbcIndexRange node = createXbcIndexRange();
            node.setup(element);
            return(node);
        } else if (XbcLowerBound.isMatch(element)) {
            XbcLowerBound node = createXbcLowerBound();
            node.setup(element);
            return(node);
        } else if (XbcUpperBound.isMatch(element)) {
            XbcUpperBound node = createXbcUpperBound();
            node.setup(element);
            return(node);
        } else if (XbcStep.isMatch(element)) {
            XbcStep node = createXbcStep();
            node.setup(element);
            return(node);
        } else if (XbcDesignatedValue.isMatch(element)) {
            XbcDesignatedValue node = createXbcDesignatedValue();
            node.setup(element);
            return(node);
        } else if (XbcCompoundValue.isMatch(element)) {
            XbcCompoundValue node = createXbcCompoundValue();
            node.setup(element);
            return(node);
        } else if (XbcBitField.isMatch(element)) {
            XbcBitField node = createXbcBitField();
            node.setup(element);
            return(node);
        } else if (XbcPragma.isMatch(element)) {
            XbcPragma node = createXbcPragma();
            node.setup(element);
            return(node);
        } else if (XbcText.isMatch(element)) {
            XbcText node = createXbcText();
            node.setup(element);
            return(node);
        } else if (XbcDeclarations.isMatch(element)) {
            XbcDeclarations node = createXbcDeclarations();
            node.setup(element);
            return(node);
        } else if (XbcFunctionDefinition.isMatch(element)) {
            XbcFunctionDefinition node = createXbcFunctionDefinition();
            node.setup(element);
            return(node);
        } else if (XbcParams.isMatch(element)) {
            XbcParams node = createXbcParams();
            node.setup(element);
            return(node);
        } else if (XbcBody.isMatch(element)) {
            XbcBody node = createXbcBody();
            node.setup(element);
            return(node);
        } else if (XbcGccAsmStatement.isMatch(element)) {
            XbcGccAsmStatement node = createXbcGccAsmStatement();
            node.setup(element);
            return(node);
        } else if (XbcGccAsmOperands.isMatch(element)) {
            XbcGccAsmOperands node = createXbcGccAsmOperands();
            node.setup(element);
            return(node);
        } else if (XbcGccAsmOperand.isMatch(element)) {
            XbcGccAsmOperand node = createXbcGccAsmOperand();
            node.setup(element);
            return(node);
        } else if (XbcGccAsmClobbers.isMatch(element)) {
            XbcGccAsmClobbers node = createXbcGccAsmClobbers();
            node.setup(element);
            return(node);
        } else if (XbcForStatement.isMatch(element)) {
            XbcForStatement node = createXbcForStatement();
            node.setup(element);
            return(node);
        } else if (XbcInit.isMatch(element)) {
            XbcInit node = createXbcInit();
            node.setup(element);
            return(node);
        } else if (XbcCondition.isMatch(element)) {
            XbcCondition node = createXbcCondition();
            node.setup(element);
            return(node);
        } else if (XbcIter.isMatch(element)) {
            XbcIter node = createXbcIter();
            node.setup(element);
            return(node);
        } else if (XbcIfStatement.isMatch(element)) {
            XbcIfStatement node = createXbcIfStatement();
            node.setup(element);
            return(node);
        } else if (XbcThen.isMatch(element)) {
            XbcThen node = createXbcThen();
            node.setup(element);
            return(node);
        } else if (XbcElse.isMatch(element)) {
            XbcElse node = createXbcElse();
            node.setup(element);
            return(node);
        } else if (XbcWhileStatement.isMatch(element)) {
            XbcWhileStatement node = createXbcWhileStatement();
            node.setup(element);
            return(node);
        } else if (XbcDoStatement.isMatch(element)) {
            XbcDoStatement node = createXbcDoStatement();
            node.setup(element);
            return(node);
        } else if (XbcSwitchStatement.isMatch(element)) {
            XbcSwitchStatement node = createXbcSwitchStatement();
            node.setup(element);
            return(node);
        } else if (XbcGccRangedCaseLabel.isMatch(element)) {
            XbcGccRangedCaseLabel node = createXbcGccRangedCaseLabel();
            node.setup(element);
            return(node);
        } else if (XbcStatementLabel.isMatch(element)) {
            XbcStatementLabel node = createXbcStatementLabel();
            node.setup(element);
            return(node);
        } else if (XbcCaseLabel.isMatch(element)) {
            XbcCaseLabel node = createXbcCaseLabel();
            node.setup(element);
            return(node);
        } else if (XbcBreakStatement.isMatch(element)) {
            XbcBreakStatement node = createXbcBreakStatement();
            node.setup(element);
            return(node);
        } else if (XbcContinueStatement.isMatch(element)) {
            XbcContinueStatement node = createXbcContinueStatement();
            node.setup(element);
            return(node);
        } else if (XbcReturnStatement.isMatch(element)) {
            XbcReturnStatement node = createXbcReturnStatement();
            node.setup(element);
            return(node);
        } else if (XbcGotoStatement.isMatch(element)) {
            XbcGotoStatement node = createXbcGotoStatement();
            node.setup(element);
            return(node);
        } else if (XbcDefaultLabel.isMatch(element)) {
            XbcDefaultLabel node = createXbcDefaultLabel();
            node.setup(element);
            return(node);
        } else if (XbcExprStatement.isMatch(element)) {
            XbcExprStatement node = createXbcExprStatement();
            node.setup(element);
            return(node);
        } else if (XbcVarDecl.isMatch(element)) {
            XbcVarDecl node = createXbcVarDecl();
            node.setup(element);
            return(node);
        } else if (XbcGccAsm.isMatch(element)) {
            XbcGccAsm node = createXbcGccAsm();
            node.setup(element);
            return(node);
        } else if (XbcFunctionDecl.isMatch(element)) {
            XbcFunctionDecl node = createXbcFunctionDecl();
            node.setup(element);
            return(node);
        } else if (XbcGccMemberDesignator.isMatch(element)) {
            XbcGccMemberDesignator node = createXbcGccMemberDesignator();
            node.setup(element);
            return(node);
        } else if (XbcArrayType.isMatch(element)) {
            XbcArrayType node = createXbcArrayType();
            node.setup(element);
            return(node);
        } else if (XbcArraySize.isMatch(element)) {
            XbcArraySize node = createXbcArraySize();
            node.setup(element);
            return(node);
        } else if (XbcBasicType.isMatch(element)) {
            XbcBasicType node = createXbcBasicType();
            node.setup(element);
            return(node);
        } else if (XbcPointerType.isMatch(element)) {
            XbcPointerType node = createXbcPointerType();
            node.setup(element);
            return(node);
        } else if (XbcStructType.isMatch(element)) {
            XbcStructType node = createXbcStructType();
            node.setup(element);
            return(node);
        } else if (XbcUnionType.isMatch(element)) {
            XbcUnionType node = createXbcUnionType();
            node.setup(element);
            return(node);
        } else if (XbcEnumType.isMatch(element)) {
            XbcEnumType node = createXbcEnumType();
            node.setup(element);
            return(node);
        } else if (XbcCoArrayType.isMatch(element)) {
            XbcCoArrayType node = createXbcCoArrayType();
            node.setup(element);
            return(node);
        } else if (XbcGlobalSymbols.isMatch(element)) {
            XbcGlobalSymbols node = createXbcGlobalSymbols();
            node.setup(element);
            return(node);
        } else if (XbcGlobalDeclarations.isMatch(element)) {
            XbcGlobalDeclarations node = createXbcGlobalDeclarations();
            node.setup(element);
            return(node);
        } else if (XbcGccAsmDefinition.isMatch(element)) {
            XbcGccAsmDefinition node = createXbcGccAsmDefinition();
            node.setup(element);
            return(node);
        } else {
            return (null);
        }
    }

    /**
     * Creates a <code>XbcXcodeProgram</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXcodeProgram
     */
    public XbcXcodeProgram createXbcXcodeProgram(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcXcodeProgram xbcXcodeProgram_ = createXbcXcodeProgram();
        xbcXcodeProgram_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcXcodeProgram_);
    }

    /**
     * Creates a <code>XbcTypeTable</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeTable
     */
    public XbcTypeTable createXbcTypeTable(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcTypeTable xbcTypeTable_ = createXbcTypeTable();
        xbcTypeTable_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcTypeTable_);
    }

    /**
     * Creates a <code>XbcFunctionType</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionType
     */
    public XbcFunctionType createXbcFunctionType(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionType xbcFunctionType_ = createXbcFunctionType();
        xbcFunctionType_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionType_);
    }

    /**
     * Creates a <code>XbcGccAttributes</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttributes
     */
    public XbcGccAttributes createXbcGccAttributes(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAttributes xbcGccAttributes_ = createXbcGccAttributes();
        xbcGccAttributes_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAttributes_);
    }

    /**
     * Creates a <code>XbcGccAttribute</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttribute
     */
    public XbcGccAttribute createXbcGccAttribute(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAttribute xbcGccAttribute_ = createXbcGccAttribute();
        xbcGccAttribute_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAttribute_);
    }

    /**
     * Creates a <code>XbcBuiltinOp</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBuiltinOp
     */
    public XbcBuiltinOp createXbcBuiltinOp(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcBuiltinOp xbcBuiltinOp_ = createXbcBuiltinOp();
        xbcBuiltinOp_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBuiltinOp_);
    }

    /**
     * Creates a <code>XbcArrayRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayRef
     */
    public XbcArrayRef createXbcArrayRef(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayRef xbcArrayRef_ = createXbcArrayRef();
        xbcArrayRef_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayRef_);
    }

    /**
     * Creates a <code>XbcArrayAddr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayAddr
     */
    public XbcArrayAddr createXbcArrayAddr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayAddr xbcArrayAddr_ = createXbcArrayAddr();
        xbcArrayAddr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayAddr_);
    }

    /**
     * Creates a <code>XbcFunctionCall</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionCall
     */
    public XbcFunctionCall createXbcFunctionCall(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionCall xbcFunctionCall_ = createXbcFunctionCall();
        xbcFunctionCall_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionCall_);
    }

    /**
     * Creates a <code>XbcFunction</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunction
     */
    public XbcFunction createXbcFunction(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcFunction xbcFunction_ = createXbcFunction();
        xbcFunction_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunction_);
    }

    /**
     * Creates a <code>XbcArguments</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArguments
     */
    public XbcArguments createXbcArguments(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcArguments xbcArguments_ = createXbcArguments();
        xbcArguments_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArguments_);
    }

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccCompoundExpr
     */
    public XbcGccCompoundExpr createXbcGccCompoundExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcGccCompoundExpr xbcGccCompoundExpr_ = createXbcGccCompoundExpr();
        xbcGccCompoundExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccCompoundExpr_);
    }

    /**
     * Creates a <code>XbcCompoundStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundStatement
     */
    public XbcCompoundStatement createXbcCompoundStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundStatement xbcCompoundStatement_ = createXbcCompoundStatement();
        xbcCompoundStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundStatement_);
    }

    /**
     * Creates a <code>XbcSymbols</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSymbols
     */
    public XbcSymbols createXbcSymbols(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcSymbols xbcSymbols_ = createXbcSymbols();
        xbcSymbols_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSymbols_);
    }

    /**
     * Creates a <code>XbcId</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcId
     */
    public XbcId createXbcId(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcId xbcId_ = createXbcId();
        xbcId_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcId_);
    }

    /**
     * Creates a <code>XbcName</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcName
     */
    public XbcName createXbcName(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcName xbcName_ = createXbcName();
        xbcName_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcName_);
    }

    /**
     * Creates a <code>XbcValue</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcValue
     */
    public XbcValue createXbcValue(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcValue xbcValue_ = createXbcValue();
        xbcValue_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcValue_);
    }

    /**
     * Creates a <code>XbcSubArrayRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSubArrayRef
     */
    public XbcSubArrayRef createXbcSubArrayRef(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcSubArrayRef xbcSubArrayRef_ = createXbcSubArrayRef();
        xbcSubArrayRef_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSubArrayRef_);
    }

    /**
     * Creates a <code>XbcCoArrayRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayRef
     */
    public XbcCoArrayRef createXbcCoArrayRef(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayRef xbcCoArrayRef_ = createXbcCoArrayRef();
        xbcCoArrayRef_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayRef_);
    }

    /**
     * Creates a <code>XbcVar</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVar
     */
    public XbcVar createXbcVar(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcVar xbcVar_ = createXbcVar();
        xbcVar_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVar_);
    }

    /**
     * Creates a <code>XbcMemberRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberRef
     */
    public XbcMemberRef createXbcMemberRef(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberRef xbcMemberRef_ = createXbcMemberRef();
        xbcMemberRef_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberRef_);
    }

    /**
     * Creates a <code>XbcCastExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCastExpr
     */
    public XbcCastExpr createXbcCastExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcCastExpr xbcCastExpr_ = createXbcCastExpr();
        xbcCastExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCastExpr_);
    }

    /**
     * Creates a <code>XbcStringConstant</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStringConstant
     */
    public XbcStringConstant createXbcStringConstant(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcStringConstant xbcStringConstant_ = createXbcStringConstant();
        xbcStringConstant_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStringConstant_);
    }

    /**
     * Creates a <code>XbcVarAddr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarAddr
     */
    public XbcVarAddr createXbcVarAddr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcVarAddr xbcVarAddr_ = createXbcVarAddr();
        xbcVarAddr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVarAddr_);
    }

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueExpr
     */
    public XbcCompoundValueExpr createXbcCompoundValueExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValueExpr xbcCompoundValueExpr_ = createXbcCompoundValueExpr();
        xbcCompoundValueExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValueExpr_);
    }

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueAddrExpr
     */
    public XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValueAddrExpr xbcCompoundValueAddrExpr_ = createXbcCompoundValueAddrExpr();
        xbcCompoundValueAddrExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValueAddrExpr_);
    }

    /**
     * Creates a <code>XbcXmpDescOf</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXmpDescOf
     */
    public XbcXmpDescOf createXbcXmpDescOf(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcXmpDescOf xbcXmpDescOf_ = createXbcXmpDescOf();
        xbcXmpDescOf_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcXmpDescOf_);
    }

    /**
     * Creates a <code>XbcIntConstant</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIntConstant
     */
    public XbcIntConstant createXbcIntConstant(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcIntConstant xbcIntConstant_ = createXbcIntConstant();
        xbcIntConstant_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIntConstant_);
    }

    /**
     * Creates a <code>XbcFloatConstant</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFloatConstant
     */
    public XbcFloatConstant createXbcFloatConstant(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcFloatConstant xbcFloatConstant_ = createXbcFloatConstant();
        xbcFloatConstant_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFloatConstant_);
    }

    /**
     * Creates a <code>XbcLonglongConstant</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLonglongConstant
     */
    public XbcLonglongConstant createXbcLonglongConstant(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcLonglongConstant xbcLonglongConstant_ = createXbcLonglongConstant();
        xbcLonglongConstant_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLonglongConstant_);
    }

    /**
     * Creates a <code>XbcMoeConstant</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMoeConstant
     */
    public XbcMoeConstant createXbcMoeConstant(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcMoeConstant xbcMoeConstant_ = createXbcMoeConstant();
        xbcMoeConstant_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMoeConstant_);
    }

    /**
     * Creates a <code>XbcFuncAddr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFuncAddr
     */
    public XbcFuncAddr createXbcFuncAddr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcFuncAddr xbcFuncAddr_ = createXbcFuncAddr();
        xbcFuncAddr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFuncAddr_);
    }

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSizeOfExpr
     */
    public XbcSizeOfExpr createXbcSizeOfExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcSizeOfExpr xbcSizeOfExpr_ = createXbcSizeOfExpr();
        xbcSizeOfExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSizeOfExpr_);
    }

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayAssignExpr
     */
    public XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayAssignExpr xbcCoArrayAssignExpr_ = createXbcCoArrayAssignExpr();
        xbcCoArrayAssignExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayAssignExpr_);
    }

    /**
     * Creates a <code>XbcModExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcModExpr
     */
    public XbcModExpr createXbcModExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcModExpr xbcModExpr_ = createXbcModExpr();
        xbcModExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcModExpr_);
    }

    /**
     * Creates a <code>XbcBitOrExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitOrExpr
     */
    public XbcBitOrExpr createXbcBitOrExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcBitOrExpr xbcBitOrExpr_ = createXbcBitOrExpr();
        xbcBitOrExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogOrExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogOrExpr
     */
    public XbcLogOrExpr createXbcLogOrExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcLogOrExpr xbcLogOrExpr_ = createXbcLogOrExpr();
        xbcLogOrExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogOrExpr_);
    }

    /**
     * Creates a <code>XbcPlusExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPlusExpr
     */
    public XbcPlusExpr createXbcPlusExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcPlusExpr xbcPlusExpr_ = createXbcPlusExpr();
        xbcPlusExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgPlusExpr
     */
    public XbcAsgPlusExpr createXbcAsgPlusExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgPlusExpr xbcAsgPlusExpr_ = createXbcAsgPlusExpr();
        xbcAsgPlusExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgModExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgModExpr
     */
    public XbcAsgModExpr createXbcAsgModExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgModExpr xbcAsgModExpr_ = createXbcAsgModExpr();
        xbcAsgModExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgModExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitOrExpr
     */
    public XbcAsgBitOrExpr createXbcAsgBitOrExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitOrExpr xbcAsgBitOrExpr_ = createXbcAsgBitOrExpr();
        xbcAsgBitOrExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogGTExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGTExpr
     */
    public XbcLogGTExpr createXbcLogGTExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcLogGTExpr xbcLogGTExpr_ = createXbcLogGTExpr();
        xbcLogGTExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogGTExpr_);
    }

    /**
     * Creates a <code>XbcCondExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondExpr
     */
    public XbcCondExpr createXbcCondExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcCondExpr xbcCondExpr_ = createXbcCondExpr();
        xbcCondExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCondExpr_);
    }

    /**
     * Creates a <code>XbcMinusExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMinusExpr
     */
    public XbcMinusExpr createXbcMinusExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcMinusExpr xbcMinusExpr_ = createXbcMinusExpr();
        xbcMinusExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMinusExpr_);
    }

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAddrOfExpr
     */
    public XbcAddrOfExpr createXbcAddrOfExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcAddrOfExpr xbcAddrOfExpr_ = createXbcAddrOfExpr();
        xbcAddrOfExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAddrOfExpr_);
    }

    /**
     * Creates a <code>XbcLshiftExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLshiftExpr
     */
    public XbcLshiftExpr createXbcLshiftExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcLshiftExpr xbcLshiftExpr_ = createXbcLshiftExpr();
        xbcLshiftExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLshiftExpr_);
    }

    /**
     * Creates a <code>XbcRshiftExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcRshiftExpr
     */
    public XbcRshiftExpr createXbcRshiftExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcRshiftExpr xbcRshiftExpr_ = createXbcRshiftExpr();
        xbcRshiftExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitXorExpr
     */
    public XbcAsgBitXorExpr createXbcAsgBitXorExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitXorExpr xbcAsgBitXorExpr_ = createXbcAsgBitXorExpr();
        xbcAsgBitXorExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitXorExpr_);
    }

    /**
     * Creates a <code>XbcLogEQExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogEQExpr
     */
    public XbcLogEQExpr createXbcLogEQExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcLogEQExpr xbcLogEQExpr_ = createXbcLogEQExpr();
        xbcLogEQExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogEQExpr_);
    }

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNEQExpr
     */
    public XbcLogNEQExpr createXbcLogNEQExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcLogNEQExpr xbcLogNEQExpr_ = createXbcLogNEQExpr();
        xbcLogNEQExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogNEQExpr_);
    }

    /**
     * Creates a <code>XbcLogGEExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGEExpr
     */
    public XbcLogGEExpr createXbcLogGEExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcLogGEExpr xbcLogGEExpr_ = createXbcLogGEExpr();
        xbcLogGEExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogGEExpr_);
    }

    /**
     * Creates a <code>XbcLogLTExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLTExpr
     */
    public XbcLogLTExpr createXbcLogLTExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcLogLTExpr xbcLogLTExpr_ = createXbcLogLTExpr();
        xbcLogLTExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogLTExpr_);
    }

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAlignOfExpr
     */
    public XbcGccAlignOfExpr createXbcGccAlignOfExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAlignOfExpr xbcGccAlignOfExpr_ = createXbcGccAlignOfExpr();
        xbcGccAlignOfExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAlignOfExpr_);
    }

    /**
     * Creates a <code>XbcAssignExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAssignExpr
     */
    public XbcAssignExpr createXbcAssignExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcAssignExpr xbcAssignExpr_ = createXbcAssignExpr();
        xbcAssignExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAssignExpr_);
    }

    /**
     * Creates a <code>XbcMulExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMulExpr
     */
    public XbcMulExpr createXbcMulExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcMulExpr xbcMulExpr_ = createXbcMulExpr();
        xbcMulExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMulExpr_);
    }

    /**
     * Creates a <code>XbcDivExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDivExpr
     */
    public XbcDivExpr createXbcDivExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcDivExpr xbcDivExpr_ = createXbcDivExpr();
        xbcDivExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDivExpr_);
    }

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMulExpr
     */
    public XbcAsgMulExpr createXbcAsgMulExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgMulExpr xbcAsgMulExpr_ = createXbcAsgMulExpr();
        xbcAsgMulExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgMulExpr_);
    }

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgRshiftExpr
     */
    public XbcAsgRshiftExpr createXbcAsgRshiftExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgRshiftExpr xbcAsgRshiftExpr_ = createXbcAsgRshiftExpr();
        xbcAsgRshiftExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitAndExpr
     */
    public XbcAsgBitAndExpr createXbcAsgBitAndExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitAndExpr xbcAsgBitAndExpr_ = createXbcAsgBitAndExpr();
        xbcAsgBitAndExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitAndExpr_);
    }

    /**
     * Creates a <code>XbcLogLEExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLEExpr
     */
    public XbcLogLEExpr createXbcLogLEExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcLogLEExpr xbcLogLEExpr_ = createXbcLogLEExpr();
        xbcLogLEExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogLEExpr_);
    }

    /**
     * Creates a <code>XbcLogAndExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogAndExpr
     */
    public XbcLogAndExpr createXbcLogAndExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcLogAndExpr xbcLogAndExpr_ = createXbcLogAndExpr();
        xbcLogAndExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogAndExpr_);
    }

    /**
     * Creates a <code>XbcCommaExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCommaExpr
     */
    public XbcCommaExpr createXbcCommaExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcCommaExpr xbcCommaExpr_ = createXbcCommaExpr();
        xbcCommaExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCommaExpr_);
    }

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgDivExpr
     */
    public XbcAsgDivExpr createXbcAsgDivExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgDivExpr xbcAsgDivExpr_ = createXbcAsgDivExpr();
        xbcAsgDivExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgDivExpr_);
    }

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccLabelAddr
     */
    public XbcGccLabelAddr createXbcGccLabelAddr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcGccLabelAddr xbcGccLabelAddr_ = createXbcGccLabelAddr();
        xbcGccLabelAddr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccLabelAddr_);
    }

    /**
     * Creates a <code>XbcBitAndExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitAndExpr
     */
    public XbcBitAndExpr createXbcBitAndExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcBitAndExpr xbcBitAndExpr_ = createXbcBitAndExpr();
        xbcBitAndExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitAndExpr_);
    }

    /**
     * Creates a <code>XbcBitXorExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitXorExpr
     */
    public XbcBitXorExpr createXbcBitXorExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcBitXorExpr xbcBitXorExpr_ = createXbcBitXorExpr();
        xbcBitXorExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitXorExpr_);
    }

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMinusExpr
     */
    public XbcAsgMinusExpr createXbcAsgMinusExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgMinusExpr xbcAsgMinusExpr_ = createXbcAsgMinusExpr();
        xbcAsgMinusExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgMinusExpr_);
    }

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgLshiftExpr
     */
    public XbcAsgLshiftExpr createXbcAsgLshiftExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgLshiftExpr xbcAsgLshiftExpr_ = createXbcAsgLshiftExpr();
        xbcAsgLshiftExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgLshiftExpr_);
    }

    /**
     * Creates a <code>XbcMemberAddr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberAddr
     */
    public XbcMemberAddr createXbcMemberAddr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberAddr xbcMemberAddr_ = createXbcMemberAddr();
        xbcMemberAddr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberAddr_);
    }

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayRef
     */
    public XbcMemberArrayRef createXbcMemberArrayRef(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberArrayRef xbcMemberArrayRef_ = createXbcMemberArrayRef();
        xbcMemberArrayRef_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberArrayRef_);
    }

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayAddr
     */
    public XbcMemberArrayAddr createXbcMemberArrayAddr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberArrayAddr xbcMemberArrayAddr_ = createXbcMemberArrayAddr();
        xbcMemberArrayAddr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberArrayAddr_);
    }

    /**
     * Creates a <code>XbcTypeName</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeName
     */
    public XbcTypeName createXbcTypeName(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcTypeName xbcTypeName_ = createXbcTypeName();
        xbcTypeName_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcTypeName_);
    }

    /**
     * Creates a <code>XbcPointerRef</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerRef
     */
    public XbcPointerRef createXbcPointerRef(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcPointerRef xbcPointerRef_ = createXbcPointerRef();
        xbcPointerRef_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPointerRef_);
    }

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnaryMinusExpr
     */
    public XbcUnaryMinusExpr createXbcUnaryMinusExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcUnaryMinusExpr xbcUnaryMinusExpr_ = createXbcUnaryMinusExpr();
        xbcUnaryMinusExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbcBitNotExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitNotExpr
     */
    public XbcBitNotExpr createXbcBitNotExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcBitNotExpr xbcBitNotExpr_ = createXbcBitNotExpr();
        xbcBitNotExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitNotExpr_);
    }

    /**
     * Creates a <code>XbcLogNotExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNotExpr
     */
    public XbcLogNotExpr createXbcLogNotExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcLogNotExpr xbcLogNotExpr_ = createXbcLogNotExpr();
        xbcLogNotExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogNotExpr_);
    }

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostIncrExpr
     */
    public XbcPostIncrExpr createXbcPostIncrExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcPostIncrExpr xbcPostIncrExpr_ = createXbcPostIncrExpr();
        xbcPostIncrExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPostIncrExpr_);
    }

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostDecrExpr
     */
    public XbcPostDecrExpr createXbcPostDecrExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcPostDecrExpr xbcPostDecrExpr_ = createXbcPostDecrExpr();
        xbcPostDecrExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPostDecrExpr_);
    }

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreIncrExpr
     */
    public XbcPreIncrExpr createXbcPreIncrExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcPreIncrExpr xbcPreIncrExpr_ = createXbcPreIncrExpr();
        xbcPreIncrExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPreIncrExpr_);
    }

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreDecrExpr
     */
    public XbcPreDecrExpr createXbcPreDecrExpr(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcPreDecrExpr xbcPreDecrExpr_ = createXbcPreDecrExpr();
        xbcPreDecrExpr_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPreDecrExpr_);
    }

    /**
     * Creates a <code>XbcIndexRange</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIndexRange
     */
    public XbcIndexRange createXbcIndexRange(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcIndexRange xbcIndexRange_ = createXbcIndexRange();
        xbcIndexRange_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIndexRange_);
    }

    /**
     * Creates a <code>XbcLowerBound</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLowerBound
     */
    public XbcLowerBound createXbcLowerBound(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcLowerBound xbcLowerBound_ = createXbcLowerBound();
        xbcLowerBound_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLowerBound_);
    }

    /**
     * Creates a <code>XbcUpperBound</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUpperBound
     */
    public XbcUpperBound createXbcUpperBound(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcUpperBound xbcUpperBound_ = createXbcUpperBound();
        xbcUpperBound_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUpperBound_);
    }

    /**
     * Creates a <code>XbcStep</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStep
     */
    public XbcStep createXbcStep(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcStep xbcStep_ = createXbcStep();
        xbcStep_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStep_);
    }

    /**
     * Creates a <code>XbcDesignatedValue</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDesignatedValue
     */
    public XbcDesignatedValue createXbcDesignatedValue(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcDesignatedValue xbcDesignatedValue_ = createXbcDesignatedValue();
        xbcDesignatedValue_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDesignatedValue_);
    }

    /**
     * Creates a <code>XbcCompoundValue</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValue
     */
    public XbcCompoundValue createXbcCompoundValue(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValue xbcCompoundValue_ = createXbcCompoundValue();
        xbcCompoundValue_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValue_);
    }

    /**
     * Creates a <code>XbcBitField</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitField
     */
    public XbcBitField createXbcBitField(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcBitField xbcBitField_ = createXbcBitField();
        xbcBitField_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitField_);
    }

    /**
     * Creates a <code>XbcPragma</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPragma
     */
    public XbcPragma createXbcPragma(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcPragma xbcPragma_ = createXbcPragma();
        xbcPragma_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPragma_);
    }

    /**
     * Creates a <code>XbcText</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcText
     */
    public XbcText createXbcText(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcText xbcText_ = createXbcText();
        xbcText_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcText_);
    }

    /**
     * Creates a <code>XbcDeclarations</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDeclarations
     */
    public XbcDeclarations createXbcDeclarations(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcDeclarations xbcDeclarations_ = createXbcDeclarations();
        xbcDeclarations_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDeclarations_);
    }

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDefinition
     */
    public XbcFunctionDefinition createXbcFunctionDefinition(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionDefinition xbcFunctionDefinition_ = createXbcFunctionDefinition();
        xbcFunctionDefinition_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionDefinition_);
    }

    /**
     * Creates a <code>XbcParams</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcParams
     */
    public XbcParams createXbcParams(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcParams xbcParams_ = createXbcParams();
        xbcParams_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcParams_);
    }

    /**
     * Creates a <code>XbcBody</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBody
     */
    public XbcBody createXbcBody(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcBody xbcBody_ = createXbcBody();
        xbcBody_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBody_);
    }

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmStatement
     */
    public XbcGccAsmStatement createXbcGccAsmStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmStatement xbcGccAsmStatement_ = createXbcGccAsmStatement();
        xbcGccAsmStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmStatement_);
    }

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperands
     */
    public XbcGccAsmOperands createXbcGccAsmOperands(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmOperands xbcGccAsmOperands_ = createXbcGccAsmOperands();
        xbcGccAsmOperands_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmOperands_);
    }

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperand
     */
    public XbcGccAsmOperand createXbcGccAsmOperand(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmOperand xbcGccAsmOperand_ = createXbcGccAsmOperand();
        xbcGccAsmOperand_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmOperand_);
    }

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmClobbers
     */
    public XbcGccAsmClobbers createXbcGccAsmClobbers(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmClobbers xbcGccAsmClobbers_ = createXbcGccAsmClobbers();
        xbcGccAsmClobbers_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmClobbers_);
    }

    /**
     * Creates a <code>XbcForStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcForStatement
     */
    public XbcForStatement createXbcForStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcForStatement xbcForStatement_ = createXbcForStatement();
        xbcForStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcForStatement_);
    }

    /**
     * Creates a <code>XbcInit</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcInit
     */
    public XbcInit createXbcInit(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcInit xbcInit_ = createXbcInit();
        xbcInit_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcInit_);
    }

    /**
     * Creates a <code>XbcCondition</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondition
     */
    public XbcCondition createXbcCondition(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcCondition xbcCondition_ = createXbcCondition();
        xbcCondition_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCondition_);
    }

    /**
     * Creates a <code>XbcIter</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIter
     */
    public XbcIter createXbcIter(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcIter xbcIter_ = createXbcIter();
        xbcIter_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIter_);
    }

    /**
     * Creates a <code>XbcIfStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIfStatement
     */
    public XbcIfStatement createXbcIfStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcIfStatement xbcIfStatement_ = createXbcIfStatement();
        xbcIfStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIfStatement_);
    }

    /**
     * Creates a <code>XbcThen</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcThen
     */
    public XbcThen createXbcThen(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcThen xbcThen_ = createXbcThen();
        xbcThen_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcThen_);
    }

    /**
     * Creates a <code>XbcElse</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcElse
     */
    public XbcElse createXbcElse(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcElse xbcElse_ = createXbcElse();
        xbcElse_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcElse_);
    }

    /**
     * Creates a <code>XbcWhileStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcWhileStatement
     */
    public XbcWhileStatement createXbcWhileStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcWhileStatement xbcWhileStatement_ = createXbcWhileStatement();
        xbcWhileStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcWhileStatement_);
    }

    /**
     * Creates a <code>XbcDoStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDoStatement
     */
    public XbcDoStatement createXbcDoStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcDoStatement xbcDoStatement_ = createXbcDoStatement();
        xbcDoStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDoStatement_);
    }

    /**
     * Creates a <code>XbcSwitchStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSwitchStatement
     */
    public XbcSwitchStatement createXbcSwitchStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcSwitchStatement xbcSwitchStatement_ = createXbcSwitchStatement();
        xbcSwitchStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSwitchStatement_);
    }

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccRangedCaseLabel
     */
    public XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcGccRangedCaseLabel xbcGccRangedCaseLabel_ = createXbcGccRangedCaseLabel();
        xbcGccRangedCaseLabel_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccRangedCaseLabel_);
    }

    /**
     * Creates a <code>XbcStatementLabel</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStatementLabel
     */
    public XbcStatementLabel createXbcStatementLabel(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcStatementLabel xbcStatementLabel_ = createXbcStatementLabel();
        xbcStatementLabel_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStatementLabel_);
    }

    /**
     * Creates a <code>XbcCaseLabel</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCaseLabel
     */
    public XbcCaseLabel createXbcCaseLabel(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcCaseLabel xbcCaseLabel_ = createXbcCaseLabel();
        xbcCaseLabel_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCaseLabel_);
    }

    /**
     * Creates a <code>XbcBreakStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBreakStatement
     */
    public XbcBreakStatement createXbcBreakStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcBreakStatement xbcBreakStatement_ = createXbcBreakStatement();
        xbcBreakStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBreakStatement_);
    }

    /**
     * Creates a <code>XbcContinueStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcContinueStatement
     */
    public XbcContinueStatement createXbcContinueStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcContinueStatement xbcContinueStatement_ = createXbcContinueStatement();
        xbcContinueStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcContinueStatement_);
    }

    /**
     * Creates a <code>XbcReturnStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcReturnStatement
     */
    public XbcReturnStatement createXbcReturnStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcReturnStatement xbcReturnStatement_ = createXbcReturnStatement();
        xbcReturnStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcReturnStatement_);
    }

    /**
     * Creates a <code>XbcGotoStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGotoStatement
     */
    public XbcGotoStatement createXbcGotoStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcGotoStatement xbcGotoStatement_ = createXbcGotoStatement();
        xbcGotoStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGotoStatement_);
    }

    /**
     * Creates a <code>XbcDefaultLabel</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDefaultLabel
     */
    public XbcDefaultLabel createXbcDefaultLabel(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcDefaultLabel xbcDefaultLabel_ = createXbcDefaultLabel();
        xbcDefaultLabel_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDefaultLabel_);
    }

    /**
     * Creates a <code>XbcExprStatement</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcExprStatement
     */
    public XbcExprStatement createXbcExprStatement(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcExprStatement xbcExprStatement_ = createXbcExprStatement();
        xbcExprStatement_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcExprStatement_);
    }

    /**
     * Creates a <code>XbcVarDecl</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarDecl
     */
    public XbcVarDecl createXbcVarDecl(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcVarDecl xbcVarDecl_ = createXbcVarDecl();
        xbcVarDecl_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVarDecl_);
    }

    /**
     * Creates a <code>XbcGccAsm</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsm
     */
    public XbcGccAsm createXbcGccAsm(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsm xbcGccAsm_ = createXbcGccAsm();
        xbcGccAsm_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsm_);
    }

    /**
     * Creates a <code>XbcFunctionDecl</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDecl
     */
    public XbcFunctionDecl createXbcFunctionDecl(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionDecl xbcFunctionDecl_ = createXbcFunctionDecl();
        xbcFunctionDecl_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionDecl_);
    }

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccMemberDesignator
     */
    public XbcGccMemberDesignator createXbcGccMemberDesignator(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcGccMemberDesignator xbcGccMemberDesignator_ = createXbcGccMemberDesignator();
        xbcGccMemberDesignator_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccMemberDesignator_);
    }

    /**
     * Creates a <code>XbcArrayType</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayType
     */
    public XbcArrayType createXbcArrayType(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayType xbcArrayType_ = createXbcArrayType();
        xbcArrayType_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayType_);
    }

    /**
     * Creates a <code>XbcArraySize</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArraySize
     */
    public XbcArraySize createXbcArraySize(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcArraySize xbcArraySize_ = createXbcArraySize();
        xbcArraySize_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArraySize_);
    }

    /**
     * Creates a <code>XbcBasicType</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBasicType
     */
    public XbcBasicType createXbcBasicType(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcBasicType xbcBasicType_ = createXbcBasicType();
        xbcBasicType_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBasicType_);
    }

    /**
     * Creates a <code>XbcPointerType</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerType
     */
    public XbcPointerType createXbcPointerType(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcPointerType xbcPointerType_ = createXbcPointerType();
        xbcPointerType_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPointerType_);
    }

    /**
     * Creates a <code>XbcStructType</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStructType
     */
    public XbcStructType createXbcStructType(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcStructType xbcStructType_ = createXbcStructType();
        xbcStructType_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStructType_);
    }

    /**
     * Creates a <code>XbcUnionType</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnionType
     */
    public XbcUnionType createXbcUnionType(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcUnionType xbcUnionType_ = createXbcUnionType();
        xbcUnionType_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUnionType_);
    }

    /**
     * Creates a <code>XbcEnumType</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcEnumType
     */
    public XbcEnumType createXbcEnumType(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcEnumType xbcEnumType_ = createXbcEnumType();
        xbcEnumType_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcEnumType_);
    }

    /**
     * Creates a <code>XbcCoArrayType</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayType
     */
    public XbcCoArrayType createXbcCoArrayType(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayType xbcCoArrayType_ = createXbcCoArrayType();
        xbcCoArrayType_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayType_);
    }

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalSymbols
     */
    public XbcGlobalSymbols createXbcGlobalSymbols(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcGlobalSymbols xbcGlobalSymbols_ = createXbcGlobalSymbols();
        xbcGlobalSymbols_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGlobalSymbols_);
    }

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalDeclarations
     */
    public XbcGlobalDeclarations createXbcGlobalDeclarations(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcGlobalDeclarations xbcGlobalDeclarations_ = createXbcGlobalDeclarations();
        xbcGlobalDeclarations_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the File <code>file</code>.
     * This method is a template method for concrete classes.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmDefinition
     */
    public XbcGccAsmDefinition createXbcGccAsmDefinition(File file) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmDefinition xbcGccAsmDefinition_ = createXbcGccAsmDefinition();
        xbcGccAsmDefinition_.setup(UJAXP.getDocument(file, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmDefinition_);
    }

    /**
     * Creates a <code>XbcXcodeProgram</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXcodeProgram
     */
    public XbcXcodeProgram createXbcXcodeProgram(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcXcodeProgram xbcXcodeProgram_ = createXbcXcodeProgram();
        xbcXcodeProgram_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcXcodeProgram_);
    }

    /**
     * Creates a <code>XbcTypeTable</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeTable
     */
    public XbcTypeTable createXbcTypeTable(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcTypeTable xbcTypeTable_ = createXbcTypeTable();
        xbcTypeTable_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcTypeTable_);
    }

    /**
     * Creates a <code>XbcFunctionType</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionType
     */
    public XbcFunctionType createXbcFunctionType(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionType xbcFunctionType_ = createXbcFunctionType();
        xbcFunctionType_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionType_);
    }

    /**
     * Creates a <code>XbcGccAttributes</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttributes
     */
    public XbcGccAttributes createXbcGccAttributes(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAttributes xbcGccAttributes_ = createXbcGccAttributes();
        xbcGccAttributes_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAttributes_);
    }

    /**
     * Creates a <code>XbcGccAttribute</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttribute
     */
    public XbcGccAttribute createXbcGccAttribute(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAttribute xbcGccAttribute_ = createXbcGccAttribute();
        xbcGccAttribute_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAttribute_);
    }

    /**
     * Creates a <code>XbcBuiltinOp</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBuiltinOp
     */
    public XbcBuiltinOp createXbcBuiltinOp(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcBuiltinOp xbcBuiltinOp_ = createXbcBuiltinOp();
        xbcBuiltinOp_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBuiltinOp_);
    }

    /**
     * Creates a <code>XbcArrayRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayRef
     */
    public XbcArrayRef createXbcArrayRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayRef xbcArrayRef_ = createXbcArrayRef();
        xbcArrayRef_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayRef_);
    }

    /**
     * Creates a <code>XbcArrayAddr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayAddr
     */
    public XbcArrayAddr createXbcArrayAddr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayAddr xbcArrayAddr_ = createXbcArrayAddr();
        xbcArrayAddr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayAddr_);
    }

    /**
     * Creates a <code>XbcFunctionCall</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionCall
     */
    public XbcFunctionCall createXbcFunctionCall(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionCall xbcFunctionCall_ = createXbcFunctionCall();
        xbcFunctionCall_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionCall_);
    }

    /**
     * Creates a <code>XbcFunction</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunction
     */
    public XbcFunction createXbcFunction(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcFunction xbcFunction_ = createXbcFunction();
        xbcFunction_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunction_);
    }

    /**
     * Creates a <code>XbcArguments</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArguments
     */
    public XbcArguments createXbcArguments(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcArguments xbcArguments_ = createXbcArguments();
        xbcArguments_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArguments_);
    }

    /**
     * Creates a <code>XbcGccCompoundExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccCompoundExpr
     */
    public XbcGccCompoundExpr createXbcGccCompoundExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcGccCompoundExpr xbcGccCompoundExpr_ = createXbcGccCompoundExpr();
        xbcGccCompoundExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccCompoundExpr_);
    }

    /**
     * Creates a <code>XbcCompoundStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundStatement
     */
    public XbcCompoundStatement createXbcCompoundStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundStatement xbcCompoundStatement_ = createXbcCompoundStatement();
        xbcCompoundStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundStatement_);
    }

    /**
     * Creates a <code>XbcSymbols</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSymbols
     */
    public XbcSymbols createXbcSymbols(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcSymbols xbcSymbols_ = createXbcSymbols();
        xbcSymbols_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSymbols_);
    }

    /**
     * Creates a <code>XbcId</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcId
     */
    public XbcId createXbcId(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcId xbcId_ = createXbcId();
        xbcId_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcId_);
    }

    /**
     * Creates a <code>XbcName</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcName
     */
    public XbcName createXbcName(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcName xbcName_ = createXbcName();
        xbcName_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcName_);
    }

    /**
     * Creates a <code>XbcValue</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcValue
     */
    public XbcValue createXbcValue(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcValue xbcValue_ = createXbcValue();
        xbcValue_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcValue_);
    }

    /**
     * Creates a <code>XbcSubArrayRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSubArrayRef
     */
    public XbcSubArrayRef createXbcSubArrayRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcSubArrayRef xbcSubArrayRef_ = createXbcSubArrayRef();
        xbcSubArrayRef_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSubArrayRef_);
    }

    /**
     * Creates a <code>XbcCoArrayRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayRef
     */
    public XbcCoArrayRef createXbcCoArrayRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayRef xbcCoArrayRef_ = createXbcCoArrayRef();
        xbcCoArrayRef_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayRef_);
    }

    /**
     * Creates a <code>XbcVar</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVar
     */
    public XbcVar createXbcVar(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcVar xbcVar_ = createXbcVar();
        xbcVar_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVar_);
    }

    /**
     * Creates a <code>XbcMemberRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberRef
     */
    public XbcMemberRef createXbcMemberRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberRef xbcMemberRef_ = createXbcMemberRef();
        xbcMemberRef_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberRef_);
    }

    /**
     * Creates a <code>XbcCastExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCastExpr
     */
    public XbcCastExpr createXbcCastExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcCastExpr xbcCastExpr_ = createXbcCastExpr();
        xbcCastExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCastExpr_);
    }

    /**
     * Creates a <code>XbcStringConstant</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStringConstant
     */
    public XbcStringConstant createXbcStringConstant(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcStringConstant xbcStringConstant_ = createXbcStringConstant();
        xbcStringConstant_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStringConstant_);
    }

    /**
     * Creates a <code>XbcVarAddr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarAddr
     */
    public XbcVarAddr createXbcVarAddr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcVarAddr xbcVarAddr_ = createXbcVarAddr();
        xbcVarAddr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVarAddr_);
    }

    /**
     * Creates a <code>XbcCompoundValueExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueExpr
     */
    public XbcCompoundValueExpr createXbcCompoundValueExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValueExpr xbcCompoundValueExpr_ = createXbcCompoundValueExpr();
        xbcCompoundValueExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValueExpr_);
    }

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueAddrExpr
     */
    public XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValueAddrExpr xbcCompoundValueAddrExpr_ = createXbcCompoundValueAddrExpr();
        xbcCompoundValueAddrExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValueAddrExpr_);
    }

    /**
     * Creates a <code>XbcXmpDescOf</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXmpDescOf
     */
    public XbcXmpDescOf createXbcXmpDescOf(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcXmpDescOf xbcXmpDescOf_ = createXbcXmpDescOf();
        xbcXmpDescOf_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcXmpDescOf_);
    }

    /**
     * Creates a <code>XbcIntConstant</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIntConstant
     */
    public XbcIntConstant createXbcIntConstant(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcIntConstant xbcIntConstant_ = createXbcIntConstant();
        xbcIntConstant_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIntConstant_);
    }

    /**
     * Creates a <code>XbcFloatConstant</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFloatConstant
     */
    public XbcFloatConstant createXbcFloatConstant(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcFloatConstant xbcFloatConstant_ = createXbcFloatConstant();
        xbcFloatConstant_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFloatConstant_);
    }

    /**
     * Creates a <code>XbcLonglongConstant</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLonglongConstant
     */
    public XbcLonglongConstant createXbcLonglongConstant(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcLonglongConstant xbcLonglongConstant_ = createXbcLonglongConstant();
        xbcLonglongConstant_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLonglongConstant_);
    }

    /**
     * Creates a <code>XbcMoeConstant</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMoeConstant
     */
    public XbcMoeConstant createXbcMoeConstant(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcMoeConstant xbcMoeConstant_ = createXbcMoeConstant();
        xbcMoeConstant_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMoeConstant_);
    }

    /**
     * Creates a <code>XbcFuncAddr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFuncAddr
     */
    public XbcFuncAddr createXbcFuncAddr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcFuncAddr xbcFuncAddr_ = createXbcFuncAddr();
        xbcFuncAddr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFuncAddr_);
    }

    /**
     * Creates a <code>XbcSizeOfExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSizeOfExpr
     */
    public XbcSizeOfExpr createXbcSizeOfExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcSizeOfExpr xbcSizeOfExpr_ = createXbcSizeOfExpr();
        xbcSizeOfExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSizeOfExpr_);
    }

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayAssignExpr
     */
    public XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayAssignExpr xbcCoArrayAssignExpr_ = createXbcCoArrayAssignExpr();
        xbcCoArrayAssignExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayAssignExpr_);
    }

    /**
     * Creates a <code>XbcModExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcModExpr
     */
    public XbcModExpr createXbcModExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcModExpr xbcModExpr_ = createXbcModExpr();
        xbcModExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcModExpr_);
    }

    /**
     * Creates a <code>XbcBitOrExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitOrExpr
     */
    public XbcBitOrExpr createXbcBitOrExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcBitOrExpr xbcBitOrExpr_ = createXbcBitOrExpr();
        xbcBitOrExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogOrExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogOrExpr
     */
    public XbcLogOrExpr createXbcLogOrExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcLogOrExpr xbcLogOrExpr_ = createXbcLogOrExpr();
        xbcLogOrExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogOrExpr_);
    }

    /**
     * Creates a <code>XbcPlusExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPlusExpr
     */
    public XbcPlusExpr createXbcPlusExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcPlusExpr xbcPlusExpr_ = createXbcPlusExpr();
        xbcPlusExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgPlusExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgPlusExpr
     */
    public XbcAsgPlusExpr createXbcAsgPlusExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgPlusExpr xbcAsgPlusExpr_ = createXbcAsgPlusExpr();
        xbcAsgPlusExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgModExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgModExpr
     */
    public XbcAsgModExpr createXbcAsgModExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgModExpr xbcAsgModExpr_ = createXbcAsgModExpr();
        xbcAsgModExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgModExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitOrExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitOrExpr
     */
    public XbcAsgBitOrExpr createXbcAsgBitOrExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitOrExpr xbcAsgBitOrExpr_ = createXbcAsgBitOrExpr();
        xbcAsgBitOrExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogGTExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGTExpr
     */
    public XbcLogGTExpr createXbcLogGTExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcLogGTExpr xbcLogGTExpr_ = createXbcLogGTExpr();
        xbcLogGTExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogGTExpr_);
    }

    /**
     * Creates a <code>XbcCondExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondExpr
     */
    public XbcCondExpr createXbcCondExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcCondExpr xbcCondExpr_ = createXbcCondExpr();
        xbcCondExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCondExpr_);
    }

    /**
     * Creates a <code>XbcMinusExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMinusExpr
     */
    public XbcMinusExpr createXbcMinusExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcMinusExpr xbcMinusExpr_ = createXbcMinusExpr();
        xbcMinusExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMinusExpr_);
    }

    /**
     * Creates a <code>XbcAddrOfExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAddrOfExpr
     */
    public XbcAddrOfExpr createXbcAddrOfExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcAddrOfExpr xbcAddrOfExpr_ = createXbcAddrOfExpr();
        xbcAddrOfExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAddrOfExpr_);
    }

    /**
     * Creates a <code>XbcLshiftExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLshiftExpr
     */
    public XbcLshiftExpr createXbcLshiftExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcLshiftExpr xbcLshiftExpr_ = createXbcLshiftExpr();
        xbcLshiftExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLshiftExpr_);
    }

    /**
     * Creates a <code>XbcRshiftExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcRshiftExpr
     */
    public XbcRshiftExpr createXbcRshiftExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcRshiftExpr xbcRshiftExpr_ = createXbcRshiftExpr();
        xbcRshiftExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitXorExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitXorExpr
     */
    public XbcAsgBitXorExpr createXbcAsgBitXorExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitXorExpr xbcAsgBitXorExpr_ = createXbcAsgBitXorExpr();
        xbcAsgBitXorExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitXorExpr_);
    }

    /**
     * Creates a <code>XbcLogEQExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogEQExpr
     */
    public XbcLogEQExpr createXbcLogEQExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcLogEQExpr xbcLogEQExpr_ = createXbcLogEQExpr();
        xbcLogEQExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogEQExpr_);
    }

    /**
     * Creates a <code>XbcLogNEQExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNEQExpr
     */
    public XbcLogNEQExpr createXbcLogNEQExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcLogNEQExpr xbcLogNEQExpr_ = createXbcLogNEQExpr();
        xbcLogNEQExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogNEQExpr_);
    }

    /**
     * Creates a <code>XbcLogGEExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGEExpr
     */
    public XbcLogGEExpr createXbcLogGEExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcLogGEExpr xbcLogGEExpr_ = createXbcLogGEExpr();
        xbcLogGEExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogGEExpr_);
    }

    /**
     * Creates a <code>XbcLogLTExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLTExpr
     */
    public XbcLogLTExpr createXbcLogLTExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcLogLTExpr xbcLogLTExpr_ = createXbcLogLTExpr();
        xbcLogLTExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogLTExpr_);
    }

    /**
     * Creates a <code>XbcGccAlignOfExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAlignOfExpr
     */
    public XbcGccAlignOfExpr createXbcGccAlignOfExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAlignOfExpr xbcGccAlignOfExpr_ = createXbcGccAlignOfExpr();
        xbcGccAlignOfExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAlignOfExpr_);
    }

    /**
     * Creates a <code>XbcAssignExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAssignExpr
     */
    public XbcAssignExpr createXbcAssignExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcAssignExpr xbcAssignExpr_ = createXbcAssignExpr();
        xbcAssignExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAssignExpr_);
    }

    /**
     * Creates a <code>XbcMulExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMulExpr
     */
    public XbcMulExpr createXbcMulExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcMulExpr xbcMulExpr_ = createXbcMulExpr();
        xbcMulExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMulExpr_);
    }

    /**
     * Creates a <code>XbcDivExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDivExpr
     */
    public XbcDivExpr createXbcDivExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcDivExpr xbcDivExpr_ = createXbcDivExpr();
        xbcDivExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDivExpr_);
    }

    /**
     * Creates a <code>XbcAsgMulExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMulExpr
     */
    public XbcAsgMulExpr createXbcAsgMulExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgMulExpr xbcAsgMulExpr_ = createXbcAsgMulExpr();
        xbcAsgMulExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgMulExpr_);
    }

    /**
     * Creates a <code>XbcAsgRshiftExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgRshiftExpr
     */
    public XbcAsgRshiftExpr createXbcAsgRshiftExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgRshiftExpr xbcAsgRshiftExpr_ = createXbcAsgRshiftExpr();
        xbcAsgRshiftExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitAndExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitAndExpr
     */
    public XbcAsgBitAndExpr createXbcAsgBitAndExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitAndExpr xbcAsgBitAndExpr_ = createXbcAsgBitAndExpr();
        xbcAsgBitAndExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitAndExpr_);
    }

    /**
     * Creates a <code>XbcLogLEExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLEExpr
     */
    public XbcLogLEExpr createXbcLogLEExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcLogLEExpr xbcLogLEExpr_ = createXbcLogLEExpr();
        xbcLogLEExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogLEExpr_);
    }

    /**
     * Creates a <code>XbcLogAndExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogAndExpr
     */
    public XbcLogAndExpr createXbcLogAndExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcLogAndExpr xbcLogAndExpr_ = createXbcLogAndExpr();
        xbcLogAndExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogAndExpr_);
    }

    /**
     * Creates a <code>XbcCommaExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCommaExpr
     */
    public XbcCommaExpr createXbcCommaExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcCommaExpr xbcCommaExpr_ = createXbcCommaExpr();
        xbcCommaExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCommaExpr_);
    }

    /**
     * Creates a <code>XbcAsgDivExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgDivExpr
     */
    public XbcAsgDivExpr createXbcAsgDivExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgDivExpr xbcAsgDivExpr_ = createXbcAsgDivExpr();
        xbcAsgDivExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgDivExpr_);
    }

    /**
     * Creates a <code>XbcGccLabelAddr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccLabelAddr
     */
    public XbcGccLabelAddr createXbcGccLabelAddr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcGccLabelAddr xbcGccLabelAddr_ = createXbcGccLabelAddr();
        xbcGccLabelAddr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccLabelAddr_);
    }

    /**
     * Creates a <code>XbcBitAndExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitAndExpr
     */
    public XbcBitAndExpr createXbcBitAndExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcBitAndExpr xbcBitAndExpr_ = createXbcBitAndExpr();
        xbcBitAndExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitAndExpr_);
    }

    /**
     * Creates a <code>XbcBitXorExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitXorExpr
     */
    public XbcBitXorExpr createXbcBitXorExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcBitXorExpr xbcBitXorExpr_ = createXbcBitXorExpr();
        xbcBitXorExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitXorExpr_);
    }

    /**
     * Creates a <code>XbcAsgMinusExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMinusExpr
     */
    public XbcAsgMinusExpr createXbcAsgMinusExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgMinusExpr xbcAsgMinusExpr_ = createXbcAsgMinusExpr();
        xbcAsgMinusExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgMinusExpr_);
    }

    /**
     * Creates a <code>XbcAsgLshiftExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgLshiftExpr
     */
    public XbcAsgLshiftExpr createXbcAsgLshiftExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgLshiftExpr xbcAsgLshiftExpr_ = createXbcAsgLshiftExpr();
        xbcAsgLshiftExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgLshiftExpr_);
    }

    /**
     * Creates a <code>XbcMemberAddr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberAddr
     */
    public XbcMemberAddr createXbcMemberAddr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberAddr xbcMemberAddr_ = createXbcMemberAddr();
        xbcMemberAddr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberAddr_);
    }

    /**
     * Creates a <code>XbcMemberArrayRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayRef
     */
    public XbcMemberArrayRef createXbcMemberArrayRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberArrayRef xbcMemberArrayRef_ = createXbcMemberArrayRef();
        xbcMemberArrayRef_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberArrayRef_);
    }

    /**
     * Creates a <code>XbcMemberArrayAddr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayAddr
     */
    public XbcMemberArrayAddr createXbcMemberArrayAddr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberArrayAddr xbcMemberArrayAddr_ = createXbcMemberArrayAddr();
        xbcMemberArrayAddr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberArrayAddr_);
    }

    /**
     * Creates a <code>XbcTypeName</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeName
     */
    public XbcTypeName createXbcTypeName(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcTypeName xbcTypeName_ = createXbcTypeName();
        xbcTypeName_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcTypeName_);
    }

    /**
     * Creates a <code>XbcPointerRef</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerRef
     */
    public XbcPointerRef createXbcPointerRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcPointerRef xbcPointerRef_ = createXbcPointerRef();
        xbcPointerRef_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPointerRef_);
    }

    /**
     * Creates a <code>XbcUnaryMinusExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnaryMinusExpr
     */
    public XbcUnaryMinusExpr createXbcUnaryMinusExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcUnaryMinusExpr xbcUnaryMinusExpr_ = createXbcUnaryMinusExpr();
        xbcUnaryMinusExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbcBitNotExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitNotExpr
     */
    public XbcBitNotExpr createXbcBitNotExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcBitNotExpr xbcBitNotExpr_ = createXbcBitNotExpr();
        xbcBitNotExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitNotExpr_);
    }

    /**
     * Creates a <code>XbcLogNotExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNotExpr
     */
    public XbcLogNotExpr createXbcLogNotExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcLogNotExpr xbcLogNotExpr_ = createXbcLogNotExpr();
        xbcLogNotExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogNotExpr_);
    }

    /**
     * Creates a <code>XbcPostIncrExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostIncrExpr
     */
    public XbcPostIncrExpr createXbcPostIncrExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcPostIncrExpr xbcPostIncrExpr_ = createXbcPostIncrExpr();
        xbcPostIncrExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPostIncrExpr_);
    }

    /**
     * Creates a <code>XbcPostDecrExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostDecrExpr
     */
    public XbcPostDecrExpr createXbcPostDecrExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcPostDecrExpr xbcPostDecrExpr_ = createXbcPostDecrExpr();
        xbcPostDecrExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPostDecrExpr_);
    }

    /**
     * Creates a <code>XbcPreIncrExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreIncrExpr
     */
    public XbcPreIncrExpr createXbcPreIncrExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcPreIncrExpr xbcPreIncrExpr_ = createXbcPreIncrExpr();
        xbcPreIncrExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPreIncrExpr_);
    }

    /**
     * Creates a <code>XbcPreDecrExpr</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreDecrExpr
     */
    public XbcPreDecrExpr createXbcPreDecrExpr(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcPreDecrExpr xbcPreDecrExpr_ = createXbcPreDecrExpr();
        xbcPreDecrExpr_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPreDecrExpr_);
    }

    /**
     * Creates a <code>XbcIndexRange</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIndexRange
     */
    public XbcIndexRange createXbcIndexRange(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcIndexRange xbcIndexRange_ = createXbcIndexRange();
        xbcIndexRange_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIndexRange_);
    }

    /**
     * Creates a <code>XbcLowerBound</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLowerBound
     */
    public XbcLowerBound createXbcLowerBound(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcLowerBound xbcLowerBound_ = createXbcLowerBound();
        xbcLowerBound_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLowerBound_);
    }

    /**
     * Creates a <code>XbcUpperBound</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUpperBound
     */
    public XbcUpperBound createXbcUpperBound(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcUpperBound xbcUpperBound_ = createXbcUpperBound();
        xbcUpperBound_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUpperBound_);
    }

    /**
     * Creates a <code>XbcStep</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStep
     */
    public XbcStep createXbcStep(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcStep xbcStep_ = createXbcStep();
        xbcStep_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStep_);
    }

    /**
     * Creates a <code>XbcDesignatedValue</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDesignatedValue
     */
    public XbcDesignatedValue createXbcDesignatedValue(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcDesignatedValue xbcDesignatedValue_ = createXbcDesignatedValue();
        xbcDesignatedValue_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDesignatedValue_);
    }

    /**
     * Creates a <code>XbcCompoundValue</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValue
     */
    public XbcCompoundValue createXbcCompoundValue(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValue xbcCompoundValue_ = createXbcCompoundValue();
        xbcCompoundValue_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValue_);
    }

    /**
     * Creates a <code>XbcBitField</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitField
     */
    public XbcBitField createXbcBitField(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcBitField xbcBitField_ = createXbcBitField();
        xbcBitField_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitField_);
    }

    /**
     * Creates a <code>XbcPragma</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPragma
     */
    public XbcPragma createXbcPragma(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcPragma xbcPragma_ = createXbcPragma();
        xbcPragma_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPragma_);
    }

    /**
     * Creates a <code>XbcText</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcText
     */
    public XbcText createXbcText(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcText xbcText_ = createXbcText();
        xbcText_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcText_);
    }

    /**
     * Creates a <code>XbcDeclarations</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDeclarations
     */
    public XbcDeclarations createXbcDeclarations(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcDeclarations xbcDeclarations_ = createXbcDeclarations();
        xbcDeclarations_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDeclarations_);
    }

    /**
     * Creates a <code>XbcFunctionDefinition</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDefinition
     */
    public XbcFunctionDefinition createXbcFunctionDefinition(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionDefinition xbcFunctionDefinition_ = createXbcFunctionDefinition();
        xbcFunctionDefinition_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionDefinition_);
    }

    /**
     * Creates a <code>XbcParams</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcParams
     */
    public XbcParams createXbcParams(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcParams xbcParams_ = createXbcParams();
        xbcParams_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcParams_);
    }

    /**
     * Creates a <code>XbcBody</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBody
     */
    public XbcBody createXbcBody(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcBody xbcBody_ = createXbcBody();
        xbcBody_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBody_);
    }

    /**
     * Creates a <code>XbcGccAsmStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmStatement
     */
    public XbcGccAsmStatement createXbcGccAsmStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmStatement xbcGccAsmStatement_ = createXbcGccAsmStatement();
        xbcGccAsmStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmStatement_);
    }

    /**
     * Creates a <code>XbcGccAsmOperands</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperands
     */
    public XbcGccAsmOperands createXbcGccAsmOperands(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmOperands xbcGccAsmOperands_ = createXbcGccAsmOperands();
        xbcGccAsmOperands_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmOperands_);
    }

    /**
     * Creates a <code>XbcGccAsmOperand</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperand
     */
    public XbcGccAsmOperand createXbcGccAsmOperand(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmOperand xbcGccAsmOperand_ = createXbcGccAsmOperand();
        xbcGccAsmOperand_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmOperand_);
    }

    /**
     * Creates a <code>XbcGccAsmClobbers</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmClobbers
     */
    public XbcGccAsmClobbers createXbcGccAsmClobbers(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmClobbers xbcGccAsmClobbers_ = createXbcGccAsmClobbers();
        xbcGccAsmClobbers_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmClobbers_);
    }

    /**
     * Creates a <code>XbcForStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcForStatement
     */
    public XbcForStatement createXbcForStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcForStatement xbcForStatement_ = createXbcForStatement();
        xbcForStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcForStatement_);
    }

    /**
     * Creates a <code>XbcInit</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcInit
     */
    public XbcInit createXbcInit(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcInit xbcInit_ = createXbcInit();
        xbcInit_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcInit_);
    }

    /**
     * Creates a <code>XbcCondition</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondition
     */
    public XbcCondition createXbcCondition(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcCondition xbcCondition_ = createXbcCondition();
        xbcCondition_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCondition_);
    }

    /**
     * Creates a <code>XbcIter</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIter
     */
    public XbcIter createXbcIter(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcIter xbcIter_ = createXbcIter();
        xbcIter_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIter_);
    }

    /**
     * Creates a <code>XbcIfStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIfStatement
     */
    public XbcIfStatement createXbcIfStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcIfStatement xbcIfStatement_ = createXbcIfStatement();
        xbcIfStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIfStatement_);
    }

    /**
     * Creates a <code>XbcThen</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcThen
     */
    public XbcThen createXbcThen(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcThen xbcThen_ = createXbcThen();
        xbcThen_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcThen_);
    }

    /**
     * Creates a <code>XbcElse</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcElse
     */
    public XbcElse createXbcElse(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcElse xbcElse_ = createXbcElse();
        xbcElse_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcElse_);
    }

    /**
     * Creates a <code>XbcWhileStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcWhileStatement
     */
    public XbcWhileStatement createXbcWhileStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcWhileStatement xbcWhileStatement_ = createXbcWhileStatement();
        xbcWhileStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcWhileStatement_);
    }

    /**
     * Creates a <code>XbcDoStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDoStatement
     */
    public XbcDoStatement createXbcDoStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcDoStatement xbcDoStatement_ = createXbcDoStatement();
        xbcDoStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDoStatement_);
    }

    /**
     * Creates a <code>XbcSwitchStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSwitchStatement
     */
    public XbcSwitchStatement createXbcSwitchStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcSwitchStatement xbcSwitchStatement_ = createXbcSwitchStatement();
        xbcSwitchStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSwitchStatement_);
    }

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccRangedCaseLabel
     */
    public XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcGccRangedCaseLabel xbcGccRangedCaseLabel_ = createXbcGccRangedCaseLabel();
        xbcGccRangedCaseLabel_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccRangedCaseLabel_);
    }

    /**
     * Creates a <code>XbcStatementLabel</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStatementLabel
     */
    public XbcStatementLabel createXbcStatementLabel(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcStatementLabel xbcStatementLabel_ = createXbcStatementLabel();
        xbcStatementLabel_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStatementLabel_);
    }

    /**
     * Creates a <code>XbcCaseLabel</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCaseLabel
     */
    public XbcCaseLabel createXbcCaseLabel(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcCaseLabel xbcCaseLabel_ = createXbcCaseLabel();
        xbcCaseLabel_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCaseLabel_);
    }

    /**
     * Creates a <code>XbcBreakStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBreakStatement
     */
    public XbcBreakStatement createXbcBreakStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcBreakStatement xbcBreakStatement_ = createXbcBreakStatement();
        xbcBreakStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBreakStatement_);
    }

    /**
     * Creates a <code>XbcContinueStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcContinueStatement
     */
    public XbcContinueStatement createXbcContinueStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcContinueStatement xbcContinueStatement_ = createXbcContinueStatement();
        xbcContinueStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcContinueStatement_);
    }

    /**
     * Creates a <code>XbcReturnStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcReturnStatement
     */
    public XbcReturnStatement createXbcReturnStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcReturnStatement xbcReturnStatement_ = createXbcReturnStatement();
        xbcReturnStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcReturnStatement_);
    }

    /**
     * Creates a <code>XbcGotoStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGotoStatement
     */
    public XbcGotoStatement createXbcGotoStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcGotoStatement xbcGotoStatement_ = createXbcGotoStatement();
        xbcGotoStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGotoStatement_);
    }

    /**
     * Creates a <code>XbcDefaultLabel</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDefaultLabel
     */
    public XbcDefaultLabel createXbcDefaultLabel(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcDefaultLabel xbcDefaultLabel_ = createXbcDefaultLabel();
        xbcDefaultLabel_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDefaultLabel_);
    }

    /**
     * Creates a <code>XbcExprStatement</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcExprStatement
     */
    public XbcExprStatement createXbcExprStatement(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcExprStatement xbcExprStatement_ = createXbcExprStatement();
        xbcExprStatement_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcExprStatement_);
    }

    /**
     * Creates a <code>XbcVarDecl</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarDecl
     */
    public XbcVarDecl createXbcVarDecl(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcVarDecl xbcVarDecl_ = createXbcVarDecl();
        xbcVarDecl_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVarDecl_);
    }

    /**
     * Creates a <code>XbcGccAsm</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsm
     */
    public XbcGccAsm createXbcGccAsm(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsm xbcGccAsm_ = createXbcGccAsm();
        xbcGccAsm_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsm_);
    }

    /**
     * Creates a <code>XbcFunctionDecl</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDecl
     */
    public XbcFunctionDecl createXbcFunctionDecl(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionDecl xbcFunctionDecl_ = createXbcFunctionDecl();
        xbcFunctionDecl_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionDecl_);
    }

    /**
     * Creates a <code>XbcGccMemberDesignator</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccMemberDesignator
     */
    public XbcGccMemberDesignator createXbcGccMemberDesignator(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcGccMemberDesignator xbcGccMemberDesignator_ = createXbcGccMemberDesignator();
        xbcGccMemberDesignator_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccMemberDesignator_);
    }

    /**
     * Creates a <code>XbcArrayType</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayType
     */
    public XbcArrayType createXbcArrayType(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayType xbcArrayType_ = createXbcArrayType();
        xbcArrayType_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayType_);
    }

    /**
     * Creates a <code>XbcArraySize</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArraySize
     */
    public XbcArraySize createXbcArraySize(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcArraySize xbcArraySize_ = createXbcArraySize();
        xbcArraySize_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArraySize_);
    }

    /**
     * Creates a <code>XbcBasicType</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBasicType
     */
    public XbcBasicType createXbcBasicType(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcBasicType xbcBasicType_ = createXbcBasicType();
        xbcBasicType_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBasicType_);
    }

    /**
     * Creates a <code>XbcPointerType</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerType
     */
    public XbcPointerType createXbcPointerType(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcPointerType xbcPointerType_ = createXbcPointerType();
        xbcPointerType_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPointerType_);
    }

    /**
     * Creates a <code>XbcStructType</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStructType
     */
    public XbcStructType createXbcStructType(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcStructType xbcStructType_ = createXbcStructType();
        xbcStructType_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStructType_);
    }

    /**
     * Creates a <code>XbcUnionType</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnionType
     */
    public XbcUnionType createXbcUnionType(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcUnionType xbcUnionType_ = createXbcUnionType();
        xbcUnionType_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUnionType_);
    }

    /**
     * Creates a <code>XbcEnumType</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcEnumType
     */
    public XbcEnumType createXbcEnumType(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcEnumType xbcEnumType_ = createXbcEnumType();
        xbcEnumType_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcEnumType_);
    }

    /**
     * Creates a <code>XbcCoArrayType</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayType
     */
    public XbcCoArrayType createXbcCoArrayType(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayType xbcCoArrayType_ = createXbcCoArrayType();
        xbcCoArrayType_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayType_);
    }

    /**
     * Creates a <code>XbcGlobalSymbols</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalSymbols
     */
    public XbcGlobalSymbols createXbcGlobalSymbols(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcGlobalSymbols xbcGlobalSymbols_ = createXbcGlobalSymbols();
        xbcGlobalSymbols_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGlobalSymbols_);
    }

    /**
     * Creates a <code>XbcGlobalDeclarations</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalDeclarations
     */
    public XbcGlobalDeclarations createXbcGlobalDeclarations(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcGlobalDeclarations xbcGlobalDeclarations_ = createXbcGlobalDeclarations();
        xbcGlobalDeclarations_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbcGccAsmDefinition</code>
     * by the String representation of URI <code>uri</code>.
     * This method is a template method for concrete classes.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmDefinition
     */
    public XbcGccAsmDefinition createXbcGccAsmDefinition(String uri) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmDefinition xbcGccAsmDefinition_ = createXbcGccAsmDefinition();
        xbcGccAsmDefinition_.setup(UJAXP.getDocument(uri, baseUri, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmDefinition_);
    }

    /**
     * Creates a <code>XbcXcodeProgram</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXcodeProgram
     */
    public XbcXcodeProgram createXbcXcodeProgram(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcXcodeProgram xbcXcodeProgram_ = createXbcXcodeProgram();
        xbcXcodeProgram_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcXcodeProgram_);
    }

    /**
     * Creates a <code>XbcTypeTable</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeTable
     */
    public XbcTypeTable createXbcTypeTable(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcTypeTable xbcTypeTable_ = createXbcTypeTable();
        xbcTypeTable_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcTypeTable_);
    }

    /**
     * Creates a <code>XbcFunctionType</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionType
     */
    public XbcFunctionType createXbcFunctionType(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionType xbcFunctionType_ = createXbcFunctionType();
        xbcFunctionType_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionType_);
    }

    /**
     * Creates a <code>XbcGccAttributes</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttributes
     */
    public XbcGccAttributes createXbcGccAttributes(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAttributes xbcGccAttributes_ = createXbcGccAttributes();
        xbcGccAttributes_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAttributes_);
    }

    /**
     * Creates a <code>XbcGccAttribute</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttribute
     */
    public XbcGccAttribute createXbcGccAttribute(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAttribute xbcGccAttribute_ = createXbcGccAttribute();
        xbcGccAttribute_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAttribute_);
    }

    /**
     * Creates a <code>XbcBuiltinOp</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBuiltinOp
     */
    public XbcBuiltinOp createXbcBuiltinOp(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcBuiltinOp xbcBuiltinOp_ = createXbcBuiltinOp();
        xbcBuiltinOp_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBuiltinOp_);
    }

    /**
     * Creates a <code>XbcArrayRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayRef
     */
    public XbcArrayRef createXbcArrayRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayRef xbcArrayRef_ = createXbcArrayRef();
        xbcArrayRef_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayRef_);
    }

    /**
     * Creates a <code>XbcArrayAddr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayAddr
     */
    public XbcArrayAddr createXbcArrayAddr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayAddr xbcArrayAddr_ = createXbcArrayAddr();
        xbcArrayAddr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayAddr_);
    }

    /**
     * Creates a <code>XbcFunctionCall</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionCall
     */
    public XbcFunctionCall createXbcFunctionCall(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionCall xbcFunctionCall_ = createXbcFunctionCall();
        xbcFunctionCall_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionCall_);
    }

    /**
     * Creates a <code>XbcFunction</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunction
     */
    public XbcFunction createXbcFunction(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcFunction xbcFunction_ = createXbcFunction();
        xbcFunction_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunction_);
    }

    /**
     * Creates a <code>XbcArguments</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArguments
     */
    public XbcArguments createXbcArguments(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcArguments xbcArguments_ = createXbcArguments();
        xbcArguments_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArguments_);
    }

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccCompoundExpr
     */
    public XbcGccCompoundExpr createXbcGccCompoundExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcGccCompoundExpr xbcGccCompoundExpr_ = createXbcGccCompoundExpr();
        xbcGccCompoundExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccCompoundExpr_);
    }

    /**
     * Creates a <code>XbcCompoundStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundStatement
     */
    public XbcCompoundStatement createXbcCompoundStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundStatement xbcCompoundStatement_ = createXbcCompoundStatement();
        xbcCompoundStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundStatement_);
    }

    /**
     * Creates a <code>XbcSymbols</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSymbols
     */
    public XbcSymbols createXbcSymbols(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcSymbols xbcSymbols_ = createXbcSymbols();
        xbcSymbols_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSymbols_);
    }

    /**
     * Creates a <code>XbcId</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcId
     */
    public XbcId createXbcId(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcId xbcId_ = createXbcId();
        xbcId_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcId_);
    }

    /**
     * Creates a <code>XbcName</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcName
     */
    public XbcName createXbcName(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcName xbcName_ = createXbcName();
        xbcName_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcName_);
    }

    /**
     * Creates a <code>XbcValue</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcValue
     */
    public XbcValue createXbcValue(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcValue xbcValue_ = createXbcValue();
        xbcValue_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcValue_);
    }

    /**
     * Creates a <code>XbcSubArrayRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSubArrayRef
     */
    public XbcSubArrayRef createXbcSubArrayRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcSubArrayRef xbcSubArrayRef_ = createXbcSubArrayRef();
        xbcSubArrayRef_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSubArrayRef_);
    }

    /**
     * Creates a <code>XbcCoArrayRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayRef
     */
    public XbcCoArrayRef createXbcCoArrayRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayRef xbcCoArrayRef_ = createXbcCoArrayRef();
        xbcCoArrayRef_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayRef_);
    }

    /**
     * Creates a <code>XbcVar</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVar
     */
    public XbcVar createXbcVar(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcVar xbcVar_ = createXbcVar();
        xbcVar_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVar_);
    }

    /**
     * Creates a <code>XbcMemberRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberRef
     */
    public XbcMemberRef createXbcMemberRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberRef xbcMemberRef_ = createXbcMemberRef();
        xbcMemberRef_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberRef_);
    }

    /**
     * Creates a <code>XbcCastExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCastExpr
     */
    public XbcCastExpr createXbcCastExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcCastExpr xbcCastExpr_ = createXbcCastExpr();
        xbcCastExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCastExpr_);
    }

    /**
     * Creates a <code>XbcStringConstant</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStringConstant
     */
    public XbcStringConstant createXbcStringConstant(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcStringConstant xbcStringConstant_ = createXbcStringConstant();
        xbcStringConstant_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStringConstant_);
    }

    /**
     * Creates a <code>XbcVarAddr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarAddr
     */
    public XbcVarAddr createXbcVarAddr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcVarAddr xbcVarAddr_ = createXbcVarAddr();
        xbcVarAddr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVarAddr_);
    }

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueExpr
     */
    public XbcCompoundValueExpr createXbcCompoundValueExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValueExpr xbcCompoundValueExpr_ = createXbcCompoundValueExpr();
        xbcCompoundValueExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValueExpr_);
    }

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueAddrExpr
     */
    public XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValueAddrExpr xbcCompoundValueAddrExpr_ = createXbcCompoundValueAddrExpr();
        xbcCompoundValueAddrExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValueAddrExpr_);
    }

    /**
     * Creates a <code>XbcXmpDescOf</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXmpDescOf
     */
    public XbcXmpDescOf createXbcXmpDescOf(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcXmpDescOf xbcXmpDescOf_ = createXbcXmpDescOf();
        xbcXmpDescOf_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcXmpDescOf_);
    }

    /**
     * Creates a <code>XbcIntConstant</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIntConstant
     */
    public XbcIntConstant createXbcIntConstant(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcIntConstant xbcIntConstant_ = createXbcIntConstant();
        xbcIntConstant_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIntConstant_);
    }

    /**
     * Creates a <code>XbcFloatConstant</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFloatConstant
     */
    public XbcFloatConstant createXbcFloatConstant(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcFloatConstant xbcFloatConstant_ = createXbcFloatConstant();
        xbcFloatConstant_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFloatConstant_);
    }

    /**
     * Creates a <code>XbcLonglongConstant</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLonglongConstant
     */
    public XbcLonglongConstant createXbcLonglongConstant(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcLonglongConstant xbcLonglongConstant_ = createXbcLonglongConstant();
        xbcLonglongConstant_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLonglongConstant_);
    }

    /**
     * Creates a <code>XbcMoeConstant</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMoeConstant
     */
    public XbcMoeConstant createXbcMoeConstant(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcMoeConstant xbcMoeConstant_ = createXbcMoeConstant();
        xbcMoeConstant_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMoeConstant_);
    }

    /**
     * Creates a <code>XbcFuncAddr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFuncAddr
     */
    public XbcFuncAddr createXbcFuncAddr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcFuncAddr xbcFuncAddr_ = createXbcFuncAddr();
        xbcFuncAddr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFuncAddr_);
    }

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSizeOfExpr
     */
    public XbcSizeOfExpr createXbcSizeOfExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcSizeOfExpr xbcSizeOfExpr_ = createXbcSizeOfExpr();
        xbcSizeOfExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSizeOfExpr_);
    }

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayAssignExpr
     */
    public XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayAssignExpr xbcCoArrayAssignExpr_ = createXbcCoArrayAssignExpr();
        xbcCoArrayAssignExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayAssignExpr_);
    }

    /**
     * Creates a <code>XbcModExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcModExpr
     */
    public XbcModExpr createXbcModExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcModExpr xbcModExpr_ = createXbcModExpr();
        xbcModExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcModExpr_);
    }

    /**
     * Creates a <code>XbcBitOrExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitOrExpr
     */
    public XbcBitOrExpr createXbcBitOrExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcBitOrExpr xbcBitOrExpr_ = createXbcBitOrExpr();
        xbcBitOrExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogOrExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogOrExpr
     */
    public XbcLogOrExpr createXbcLogOrExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcLogOrExpr xbcLogOrExpr_ = createXbcLogOrExpr();
        xbcLogOrExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogOrExpr_);
    }

    /**
     * Creates a <code>XbcPlusExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPlusExpr
     */
    public XbcPlusExpr createXbcPlusExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcPlusExpr xbcPlusExpr_ = createXbcPlusExpr();
        xbcPlusExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgPlusExpr
     */
    public XbcAsgPlusExpr createXbcAsgPlusExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgPlusExpr xbcAsgPlusExpr_ = createXbcAsgPlusExpr();
        xbcAsgPlusExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgModExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgModExpr
     */
    public XbcAsgModExpr createXbcAsgModExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgModExpr xbcAsgModExpr_ = createXbcAsgModExpr();
        xbcAsgModExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgModExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitOrExpr
     */
    public XbcAsgBitOrExpr createXbcAsgBitOrExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitOrExpr xbcAsgBitOrExpr_ = createXbcAsgBitOrExpr();
        xbcAsgBitOrExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogGTExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGTExpr
     */
    public XbcLogGTExpr createXbcLogGTExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcLogGTExpr xbcLogGTExpr_ = createXbcLogGTExpr();
        xbcLogGTExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogGTExpr_);
    }

    /**
     * Creates a <code>XbcCondExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondExpr
     */
    public XbcCondExpr createXbcCondExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcCondExpr xbcCondExpr_ = createXbcCondExpr();
        xbcCondExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCondExpr_);
    }

    /**
     * Creates a <code>XbcMinusExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMinusExpr
     */
    public XbcMinusExpr createXbcMinusExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcMinusExpr xbcMinusExpr_ = createXbcMinusExpr();
        xbcMinusExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMinusExpr_);
    }

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAddrOfExpr
     */
    public XbcAddrOfExpr createXbcAddrOfExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcAddrOfExpr xbcAddrOfExpr_ = createXbcAddrOfExpr();
        xbcAddrOfExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAddrOfExpr_);
    }

    /**
     * Creates a <code>XbcLshiftExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLshiftExpr
     */
    public XbcLshiftExpr createXbcLshiftExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcLshiftExpr xbcLshiftExpr_ = createXbcLshiftExpr();
        xbcLshiftExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLshiftExpr_);
    }

    /**
     * Creates a <code>XbcRshiftExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcRshiftExpr
     */
    public XbcRshiftExpr createXbcRshiftExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcRshiftExpr xbcRshiftExpr_ = createXbcRshiftExpr();
        xbcRshiftExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitXorExpr
     */
    public XbcAsgBitXorExpr createXbcAsgBitXorExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitXorExpr xbcAsgBitXorExpr_ = createXbcAsgBitXorExpr();
        xbcAsgBitXorExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitXorExpr_);
    }

    /**
     * Creates a <code>XbcLogEQExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogEQExpr
     */
    public XbcLogEQExpr createXbcLogEQExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcLogEQExpr xbcLogEQExpr_ = createXbcLogEQExpr();
        xbcLogEQExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogEQExpr_);
    }

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNEQExpr
     */
    public XbcLogNEQExpr createXbcLogNEQExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcLogNEQExpr xbcLogNEQExpr_ = createXbcLogNEQExpr();
        xbcLogNEQExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogNEQExpr_);
    }

    /**
     * Creates a <code>XbcLogGEExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGEExpr
     */
    public XbcLogGEExpr createXbcLogGEExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcLogGEExpr xbcLogGEExpr_ = createXbcLogGEExpr();
        xbcLogGEExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogGEExpr_);
    }

    /**
     * Creates a <code>XbcLogLTExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLTExpr
     */
    public XbcLogLTExpr createXbcLogLTExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcLogLTExpr xbcLogLTExpr_ = createXbcLogLTExpr();
        xbcLogLTExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogLTExpr_);
    }

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAlignOfExpr
     */
    public XbcGccAlignOfExpr createXbcGccAlignOfExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAlignOfExpr xbcGccAlignOfExpr_ = createXbcGccAlignOfExpr();
        xbcGccAlignOfExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAlignOfExpr_);
    }

    /**
     * Creates a <code>XbcAssignExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAssignExpr
     */
    public XbcAssignExpr createXbcAssignExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcAssignExpr xbcAssignExpr_ = createXbcAssignExpr();
        xbcAssignExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAssignExpr_);
    }

    /**
     * Creates a <code>XbcMulExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMulExpr
     */
    public XbcMulExpr createXbcMulExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcMulExpr xbcMulExpr_ = createXbcMulExpr();
        xbcMulExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMulExpr_);
    }

    /**
     * Creates a <code>XbcDivExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDivExpr
     */
    public XbcDivExpr createXbcDivExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcDivExpr xbcDivExpr_ = createXbcDivExpr();
        xbcDivExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDivExpr_);
    }

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMulExpr
     */
    public XbcAsgMulExpr createXbcAsgMulExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgMulExpr xbcAsgMulExpr_ = createXbcAsgMulExpr();
        xbcAsgMulExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgMulExpr_);
    }

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgRshiftExpr
     */
    public XbcAsgRshiftExpr createXbcAsgRshiftExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgRshiftExpr xbcAsgRshiftExpr_ = createXbcAsgRshiftExpr();
        xbcAsgRshiftExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitAndExpr
     */
    public XbcAsgBitAndExpr createXbcAsgBitAndExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitAndExpr xbcAsgBitAndExpr_ = createXbcAsgBitAndExpr();
        xbcAsgBitAndExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitAndExpr_);
    }

    /**
     * Creates a <code>XbcLogLEExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLEExpr
     */
    public XbcLogLEExpr createXbcLogLEExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcLogLEExpr xbcLogLEExpr_ = createXbcLogLEExpr();
        xbcLogLEExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogLEExpr_);
    }

    /**
     * Creates a <code>XbcLogAndExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogAndExpr
     */
    public XbcLogAndExpr createXbcLogAndExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcLogAndExpr xbcLogAndExpr_ = createXbcLogAndExpr();
        xbcLogAndExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogAndExpr_);
    }

    /**
     * Creates a <code>XbcCommaExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCommaExpr
     */
    public XbcCommaExpr createXbcCommaExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcCommaExpr xbcCommaExpr_ = createXbcCommaExpr();
        xbcCommaExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCommaExpr_);
    }

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgDivExpr
     */
    public XbcAsgDivExpr createXbcAsgDivExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgDivExpr xbcAsgDivExpr_ = createXbcAsgDivExpr();
        xbcAsgDivExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgDivExpr_);
    }

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccLabelAddr
     */
    public XbcGccLabelAddr createXbcGccLabelAddr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcGccLabelAddr xbcGccLabelAddr_ = createXbcGccLabelAddr();
        xbcGccLabelAddr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccLabelAddr_);
    }

    /**
     * Creates a <code>XbcBitAndExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitAndExpr
     */
    public XbcBitAndExpr createXbcBitAndExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcBitAndExpr xbcBitAndExpr_ = createXbcBitAndExpr();
        xbcBitAndExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitAndExpr_);
    }

    /**
     * Creates a <code>XbcBitXorExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitXorExpr
     */
    public XbcBitXorExpr createXbcBitXorExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcBitXorExpr xbcBitXorExpr_ = createXbcBitXorExpr();
        xbcBitXorExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitXorExpr_);
    }

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMinusExpr
     */
    public XbcAsgMinusExpr createXbcAsgMinusExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgMinusExpr xbcAsgMinusExpr_ = createXbcAsgMinusExpr();
        xbcAsgMinusExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgMinusExpr_);
    }

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgLshiftExpr
     */
    public XbcAsgLshiftExpr createXbcAsgLshiftExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgLshiftExpr xbcAsgLshiftExpr_ = createXbcAsgLshiftExpr();
        xbcAsgLshiftExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgLshiftExpr_);
    }

    /**
     * Creates a <code>XbcMemberAddr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberAddr
     */
    public XbcMemberAddr createXbcMemberAddr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberAddr xbcMemberAddr_ = createXbcMemberAddr();
        xbcMemberAddr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberAddr_);
    }

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayRef
     */
    public XbcMemberArrayRef createXbcMemberArrayRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberArrayRef xbcMemberArrayRef_ = createXbcMemberArrayRef();
        xbcMemberArrayRef_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberArrayRef_);
    }

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayAddr
     */
    public XbcMemberArrayAddr createXbcMemberArrayAddr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberArrayAddr xbcMemberArrayAddr_ = createXbcMemberArrayAddr();
        xbcMemberArrayAddr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberArrayAddr_);
    }

    /**
     * Creates a <code>XbcTypeName</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeName
     */
    public XbcTypeName createXbcTypeName(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcTypeName xbcTypeName_ = createXbcTypeName();
        xbcTypeName_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcTypeName_);
    }

    /**
     * Creates a <code>XbcPointerRef</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerRef
     */
    public XbcPointerRef createXbcPointerRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcPointerRef xbcPointerRef_ = createXbcPointerRef();
        xbcPointerRef_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPointerRef_);
    }

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnaryMinusExpr
     */
    public XbcUnaryMinusExpr createXbcUnaryMinusExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcUnaryMinusExpr xbcUnaryMinusExpr_ = createXbcUnaryMinusExpr();
        xbcUnaryMinusExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbcBitNotExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitNotExpr
     */
    public XbcBitNotExpr createXbcBitNotExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcBitNotExpr xbcBitNotExpr_ = createXbcBitNotExpr();
        xbcBitNotExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitNotExpr_);
    }

    /**
     * Creates a <code>XbcLogNotExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNotExpr
     */
    public XbcLogNotExpr createXbcLogNotExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcLogNotExpr xbcLogNotExpr_ = createXbcLogNotExpr();
        xbcLogNotExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogNotExpr_);
    }

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostIncrExpr
     */
    public XbcPostIncrExpr createXbcPostIncrExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcPostIncrExpr xbcPostIncrExpr_ = createXbcPostIncrExpr();
        xbcPostIncrExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPostIncrExpr_);
    }

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostDecrExpr
     */
    public XbcPostDecrExpr createXbcPostDecrExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcPostDecrExpr xbcPostDecrExpr_ = createXbcPostDecrExpr();
        xbcPostDecrExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPostDecrExpr_);
    }

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreIncrExpr
     */
    public XbcPreIncrExpr createXbcPreIncrExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcPreIncrExpr xbcPreIncrExpr_ = createXbcPreIncrExpr();
        xbcPreIncrExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPreIncrExpr_);
    }

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreDecrExpr
     */
    public XbcPreDecrExpr createXbcPreDecrExpr(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcPreDecrExpr xbcPreDecrExpr_ = createXbcPreDecrExpr();
        xbcPreDecrExpr_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPreDecrExpr_);
    }

    /**
     * Creates a <code>XbcIndexRange</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIndexRange
     */
    public XbcIndexRange createXbcIndexRange(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcIndexRange xbcIndexRange_ = createXbcIndexRange();
        xbcIndexRange_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIndexRange_);
    }

    /**
     * Creates a <code>XbcLowerBound</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLowerBound
     */
    public XbcLowerBound createXbcLowerBound(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcLowerBound xbcLowerBound_ = createXbcLowerBound();
        xbcLowerBound_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLowerBound_);
    }

    /**
     * Creates a <code>XbcUpperBound</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUpperBound
     */
    public XbcUpperBound createXbcUpperBound(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcUpperBound xbcUpperBound_ = createXbcUpperBound();
        xbcUpperBound_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUpperBound_);
    }

    /**
     * Creates a <code>XbcStep</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStep
     */
    public XbcStep createXbcStep(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcStep xbcStep_ = createXbcStep();
        xbcStep_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStep_);
    }

    /**
     * Creates a <code>XbcDesignatedValue</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDesignatedValue
     */
    public XbcDesignatedValue createXbcDesignatedValue(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcDesignatedValue xbcDesignatedValue_ = createXbcDesignatedValue();
        xbcDesignatedValue_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDesignatedValue_);
    }

    /**
     * Creates a <code>XbcCompoundValue</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValue
     */
    public XbcCompoundValue createXbcCompoundValue(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValue xbcCompoundValue_ = createXbcCompoundValue();
        xbcCompoundValue_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValue_);
    }

    /**
     * Creates a <code>XbcBitField</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitField
     */
    public XbcBitField createXbcBitField(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcBitField xbcBitField_ = createXbcBitField();
        xbcBitField_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitField_);
    }

    /**
     * Creates a <code>XbcPragma</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPragma
     */
    public XbcPragma createXbcPragma(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcPragma xbcPragma_ = createXbcPragma();
        xbcPragma_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPragma_);
    }

    /**
     * Creates a <code>XbcText</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcText
     */
    public XbcText createXbcText(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcText xbcText_ = createXbcText();
        xbcText_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcText_);
    }

    /**
     * Creates a <code>XbcDeclarations</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDeclarations
     */
    public XbcDeclarations createXbcDeclarations(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcDeclarations xbcDeclarations_ = createXbcDeclarations();
        xbcDeclarations_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDeclarations_);
    }

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDefinition
     */
    public XbcFunctionDefinition createXbcFunctionDefinition(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionDefinition xbcFunctionDefinition_ = createXbcFunctionDefinition();
        xbcFunctionDefinition_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionDefinition_);
    }

    /**
     * Creates a <code>XbcParams</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcParams
     */
    public XbcParams createXbcParams(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcParams xbcParams_ = createXbcParams();
        xbcParams_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcParams_);
    }

    /**
     * Creates a <code>XbcBody</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBody
     */
    public XbcBody createXbcBody(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcBody xbcBody_ = createXbcBody();
        xbcBody_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBody_);
    }

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmStatement
     */
    public XbcGccAsmStatement createXbcGccAsmStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmStatement xbcGccAsmStatement_ = createXbcGccAsmStatement();
        xbcGccAsmStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmStatement_);
    }

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperands
     */
    public XbcGccAsmOperands createXbcGccAsmOperands(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmOperands xbcGccAsmOperands_ = createXbcGccAsmOperands();
        xbcGccAsmOperands_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmOperands_);
    }

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperand
     */
    public XbcGccAsmOperand createXbcGccAsmOperand(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmOperand xbcGccAsmOperand_ = createXbcGccAsmOperand();
        xbcGccAsmOperand_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmOperand_);
    }

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmClobbers
     */
    public XbcGccAsmClobbers createXbcGccAsmClobbers(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmClobbers xbcGccAsmClobbers_ = createXbcGccAsmClobbers();
        xbcGccAsmClobbers_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmClobbers_);
    }

    /**
     * Creates a <code>XbcForStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcForStatement
     */
    public XbcForStatement createXbcForStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcForStatement xbcForStatement_ = createXbcForStatement();
        xbcForStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcForStatement_);
    }

    /**
     * Creates a <code>XbcInit</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcInit
     */
    public XbcInit createXbcInit(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcInit xbcInit_ = createXbcInit();
        xbcInit_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcInit_);
    }

    /**
     * Creates a <code>XbcCondition</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondition
     */
    public XbcCondition createXbcCondition(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcCondition xbcCondition_ = createXbcCondition();
        xbcCondition_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCondition_);
    }

    /**
     * Creates a <code>XbcIter</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIter
     */
    public XbcIter createXbcIter(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcIter xbcIter_ = createXbcIter();
        xbcIter_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIter_);
    }

    /**
     * Creates a <code>XbcIfStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIfStatement
     */
    public XbcIfStatement createXbcIfStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcIfStatement xbcIfStatement_ = createXbcIfStatement();
        xbcIfStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIfStatement_);
    }

    /**
     * Creates a <code>XbcThen</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcThen
     */
    public XbcThen createXbcThen(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcThen xbcThen_ = createXbcThen();
        xbcThen_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcThen_);
    }

    /**
     * Creates a <code>XbcElse</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcElse
     */
    public XbcElse createXbcElse(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcElse xbcElse_ = createXbcElse();
        xbcElse_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcElse_);
    }

    /**
     * Creates a <code>XbcWhileStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcWhileStatement
     */
    public XbcWhileStatement createXbcWhileStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcWhileStatement xbcWhileStatement_ = createXbcWhileStatement();
        xbcWhileStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcWhileStatement_);
    }

    /**
     * Creates a <code>XbcDoStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDoStatement
     */
    public XbcDoStatement createXbcDoStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcDoStatement xbcDoStatement_ = createXbcDoStatement();
        xbcDoStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDoStatement_);
    }

    /**
     * Creates a <code>XbcSwitchStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSwitchStatement
     */
    public XbcSwitchStatement createXbcSwitchStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcSwitchStatement xbcSwitchStatement_ = createXbcSwitchStatement();
        xbcSwitchStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSwitchStatement_);
    }

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccRangedCaseLabel
     */
    public XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcGccRangedCaseLabel xbcGccRangedCaseLabel_ = createXbcGccRangedCaseLabel();
        xbcGccRangedCaseLabel_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccRangedCaseLabel_);
    }

    /**
     * Creates a <code>XbcStatementLabel</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStatementLabel
     */
    public XbcStatementLabel createXbcStatementLabel(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcStatementLabel xbcStatementLabel_ = createXbcStatementLabel();
        xbcStatementLabel_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStatementLabel_);
    }

    /**
     * Creates a <code>XbcCaseLabel</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCaseLabel
     */
    public XbcCaseLabel createXbcCaseLabel(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcCaseLabel xbcCaseLabel_ = createXbcCaseLabel();
        xbcCaseLabel_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCaseLabel_);
    }

    /**
     * Creates a <code>XbcBreakStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBreakStatement
     */
    public XbcBreakStatement createXbcBreakStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcBreakStatement xbcBreakStatement_ = createXbcBreakStatement();
        xbcBreakStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBreakStatement_);
    }

    /**
     * Creates a <code>XbcContinueStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcContinueStatement
     */
    public XbcContinueStatement createXbcContinueStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcContinueStatement xbcContinueStatement_ = createXbcContinueStatement();
        xbcContinueStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcContinueStatement_);
    }

    /**
     * Creates a <code>XbcReturnStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcReturnStatement
     */
    public XbcReturnStatement createXbcReturnStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcReturnStatement xbcReturnStatement_ = createXbcReturnStatement();
        xbcReturnStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcReturnStatement_);
    }

    /**
     * Creates a <code>XbcGotoStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGotoStatement
     */
    public XbcGotoStatement createXbcGotoStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcGotoStatement xbcGotoStatement_ = createXbcGotoStatement();
        xbcGotoStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGotoStatement_);
    }

    /**
     * Creates a <code>XbcDefaultLabel</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDefaultLabel
     */
    public XbcDefaultLabel createXbcDefaultLabel(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcDefaultLabel xbcDefaultLabel_ = createXbcDefaultLabel();
        xbcDefaultLabel_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDefaultLabel_);
    }

    /**
     * Creates a <code>XbcExprStatement</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcExprStatement
     */
    public XbcExprStatement createXbcExprStatement(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcExprStatement xbcExprStatement_ = createXbcExprStatement();
        xbcExprStatement_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcExprStatement_);
    }

    /**
     * Creates a <code>XbcVarDecl</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarDecl
     */
    public XbcVarDecl createXbcVarDecl(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcVarDecl xbcVarDecl_ = createXbcVarDecl();
        xbcVarDecl_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVarDecl_);
    }

    /**
     * Creates a <code>XbcGccAsm</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsm
     */
    public XbcGccAsm createXbcGccAsm(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsm xbcGccAsm_ = createXbcGccAsm();
        xbcGccAsm_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsm_);
    }

    /**
     * Creates a <code>XbcFunctionDecl</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDecl
     */
    public XbcFunctionDecl createXbcFunctionDecl(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionDecl xbcFunctionDecl_ = createXbcFunctionDecl();
        xbcFunctionDecl_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionDecl_);
    }

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccMemberDesignator
     */
    public XbcGccMemberDesignator createXbcGccMemberDesignator(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcGccMemberDesignator xbcGccMemberDesignator_ = createXbcGccMemberDesignator();
        xbcGccMemberDesignator_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccMemberDesignator_);
    }

    /**
     * Creates a <code>XbcArrayType</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayType
     */
    public XbcArrayType createXbcArrayType(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayType xbcArrayType_ = createXbcArrayType();
        xbcArrayType_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayType_);
    }

    /**
     * Creates a <code>XbcArraySize</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArraySize
     */
    public XbcArraySize createXbcArraySize(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcArraySize xbcArraySize_ = createXbcArraySize();
        xbcArraySize_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArraySize_);
    }

    /**
     * Creates a <code>XbcBasicType</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBasicType
     */
    public XbcBasicType createXbcBasicType(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcBasicType xbcBasicType_ = createXbcBasicType();
        xbcBasicType_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBasicType_);
    }

    /**
     * Creates a <code>XbcPointerType</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerType
     */
    public XbcPointerType createXbcPointerType(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcPointerType xbcPointerType_ = createXbcPointerType();
        xbcPointerType_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPointerType_);
    }

    /**
     * Creates a <code>XbcStructType</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStructType
     */
    public XbcStructType createXbcStructType(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcStructType xbcStructType_ = createXbcStructType();
        xbcStructType_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStructType_);
    }

    /**
     * Creates a <code>XbcUnionType</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnionType
     */
    public XbcUnionType createXbcUnionType(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcUnionType xbcUnionType_ = createXbcUnionType();
        xbcUnionType_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUnionType_);
    }

    /**
     * Creates a <code>XbcEnumType</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcEnumType
     */
    public XbcEnumType createXbcEnumType(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcEnumType xbcEnumType_ = createXbcEnumType();
        xbcEnumType_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcEnumType_);
    }

    /**
     * Creates a <code>XbcCoArrayType</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayType
     */
    public XbcCoArrayType createXbcCoArrayType(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayType xbcCoArrayType_ = createXbcCoArrayType();
        xbcCoArrayType_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayType_);
    }

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalSymbols
     */
    public XbcGlobalSymbols createXbcGlobalSymbols(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcGlobalSymbols xbcGlobalSymbols_ = createXbcGlobalSymbols();
        xbcGlobalSymbols_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGlobalSymbols_);
    }

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalDeclarations
     */
    public XbcGlobalDeclarations createXbcGlobalDeclarations(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcGlobalDeclarations xbcGlobalDeclarations_ = createXbcGlobalDeclarations();
        xbcGlobalDeclarations_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the URL <code>url</code>.
     * This method is a template method for concrete classes.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmDefinition
     */
    public XbcGccAsmDefinition createXbcGccAsmDefinition(URL url) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmDefinition xbcGccAsmDefinition_ = createXbcGccAsmDefinition();
        xbcGccAsmDefinition_.setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmDefinition_);
    }

    /**
     * Creates a <code>XbcXcodeProgram</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXcodeProgram
     */
    public XbcXcodeProgram createXbcXcodeProgram(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcXcodeProgram xbcXcodeProgram_ = createXbcXcodeProgram();
        xbcXcodeProgram_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcXcodeProgram_);
    }

    /**
     * Creates a <code>XbcTypeTable</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeTable
     */
    public XbcTypeTable createXbcTypeTable(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcTypeTable xbcTypeTable_ = createXbcTypeTable();
        xbcTypeTable_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcTypeTable_);
    }

    /**
     * Creates a <code>XbcFunctionType</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionType
     */
    public XbcFunctionType createXbcFunctionType(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionType xbcFunctionType_ = createXbcFunctionType();
        xbcFunctionType_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionType_);
    }

    /**
     * Creates a <code>XbcGccAttributes</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttributes
     */
    public XbcGccAttributes createXbcGccAttributes(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAttributes xbcGccAttributes_ = createXbcGccAttributes();
        xbcGccAttributes_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAttributes_);
    }

    /**
     * Creates a <code>XbcGccAttribute</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttribute
     */
    public XbcGccAttribute createXbcGccAttribute(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAttribute xbcGccAttribute_ = createXbcGccAttribute();
        xbcGccAttribute_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAttribute_);
    }

    /**
     * Creates a <code>XbcBuiltinOp</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBuiltinOp
     */
    public XbcBuiltinOp createXbcBuiltinOp(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcBuiltinOp xbcBuiltinOp_ = createXbcBuiltinOp();
        xbcBuiltinOp_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBuiltinOp_);
    }

    /**
     * Creates a <code>XbcArrayRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayRef
     */
    public XbcArrayRef createXbcArrayRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayRef xbcArrayRef_ = createXbcArrayRef();
        xbcArrayRef_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayRef_);
    }

    /**
     * Creates a <code>XbcArrayAddr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayAddr
     */
    public XbcArrayAddr createXbcArrayAddr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayAddr xbcArrayAddr_ = createXbcArrayAddr();
        xbcArrayAddr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayAddr_);
    }

    /**
     * Creates a <code>XbcFunctionCall</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionCall
     */
    public XbcFunctionCall createXbcFunctionCall(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionCall xbcFunctionCall_ = createXbcFunctionCall();
        xbcFunctionCall_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionCall_);
    }

    /**
     * Creates a <code>XbcFunction</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunction
     */
    public XbcFunction createXbcFunction(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcFunction xbcFunction_ = createXbcFunction();
        xbcFunction_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunction_);
    }

    /**
     * Creates a <code>XbcArguments</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArguments
     */
    public XbcArguments createXbcArguments(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcArguments xbcArguments_ = createXbcArguments();
        xbcArguments_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArguments_);
    }

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccCompoundExpr
     */
    public XbcGccCompoundExpr createXbcGccCompoundExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcGccCompoundExpr xbcGccCompoundExpr_ = createXbcGccCompoundExpr();
        xbcGccCompoundExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccCompoundExpr_);
    }

    /**
     * Creates a <code>XbcCompoundStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundStatement
     */
    public XbcCompoundStatement createXbcCompoundStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundStatement xbcCompoundStatement_ = createXbcCompoundStatement();
        xbcCompoundStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundStatement_);
    }

    /**
     * Creates a <code>XbcSymbols</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSymbols
     */
    public XbcSymbols createXbcSymbols(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcSymbols xbcSymbols_ = createXbcSymbols();
        xbcSymbols_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSymbols_);
    }

    /**
     * Creates a <code>XbcId</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcId
     */
    public XbcId createXbcId(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcId xbcId_ = createXbcId();
        xbcId_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcId_);
    }

    /**
     * Creates a <code>XbcName</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcName
     */
    public XbcName createXbcName(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcName xbcName_ = createXbcName();
        xbcName_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcName_);
    }

    /**
     * Creates a <code>XbcValue</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcValue
     */
    public XbcValue createXbcValue(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcValue xbcValue_ = createXbcValue();
        xbcValue_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcValue_);
    }

    /**
     * Creates a <code>XbcSubArrayRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSubArrayRef
     */
    public XbcSubArrayRef createXbcSubArrayRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcSubArrayRef xbcSubArrayRef_ = createXbcSubArrayRef();
        xbcSubArrayRef_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSubArrayRef_);
    }

    /**
     * Creates a <code>XbcCoArrayRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayRef
     */
    public XbcCoArrayRef createXbcCoArrayRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayRef xbcCoArrayRef_ = createXbcCoArrayRef();
        xbcCoArrayRef_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayRef_);
    }

    /**
     * Creates a <code>XbcVar</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVar
     */
    public XbcVar createXbcVar(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcVar xbcVar_ = createXbcVar();
        xbcVar_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVar_);
    }

    /**
     * Creates a <code>XbcMemberRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberRef
     */
    public XbcMemberRef createXbcMemberRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberRef xbcMemberRef_ = createXbcMemberRef();
        xbcMemberRef_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberRef_);
    }

    /**
     * Creates a <code>XbcCastExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCastExpr
     */
    public XbcCastExpr createXbcCastExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcCastExpr xbcCastExpr_ = createXbcCastExpr();
        xbcCastExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCastExpr_);
    }

    /**
     * Creates a <code>XbcStringConstant</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStringConstant
     */
    public XbcStringConstant createXbcStringConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcStringConstant xbcStringConstant_ = createXbcStringConstant();
        xbcStringConstant_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStringConstant_);
    }

    /**
     * Creates a <code>XbcVarAddr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarAddr
     */
    public XbcVarAddr createXbcVarAddr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcVarAddr xbcVarAddr_ = createXbcVarAddr();
        xbcVarAddr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVarAddr_);
    }

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueExpr
     */
    public XbcCompoundValueExpr createXbcCompoundValueExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValueExpr xbcCompoundValueExpr_ = createXbcCompoundValueExpr();
        xbcCompoundValueExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValueExpr_);
    }

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueAddrExpr
     */
    public XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValueAddrExpr xbcCompoundValueAddrExpr_ = createXbcCompoundValueAddrExpr();
        xbcCompoundValueAddrExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValueAddrExpr_);
    }

    /**
     * Creates a <code>XbcXmpDescOf</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXmpDescOf
     */
    public XbcXmpDescOf createXbcXmpDescOf(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcXmpDescOf xbcXmpDescOf_ = createXbcXmpDescOf();
        xbcXmpDescOf_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcXmpDescOf_);
    }

    /**
     * Creates a <code>XbcIntConstant</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIntConstant
     */
    public XbcIntConstant createXbcIntConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcIntConstant xbcIntConstant_ = createXbcIntConstant();
        xbcIntConstant_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIntConstant_);
    }

    /**
     * Creates a <code>XbcFloatConstant</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFloatConstant
     */
    public XbcFloatConstant createXbcFloatConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcFloatConstant xbcFloatConstant_ = createXbcFloatConstant();
        xbcFloatConstant_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFloatConstant_);
    }

    /**
     * Creates a <code>XbcLonglongConstant</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLonglongConstant
     */
    public XbcLonglongConstant createXbcLonglongConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcLonglongConstant xbcLonglongConstant_ = createXbcLonglongConstant();
        xbcLonglongConstant_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLonglongConstant_);
    }

    /**
     * Creates a <code>XbcMoeConstant</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMoeConstant
     */
    public XbcMoeConstant createXbcMoeConstant(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcMoeConstant xbcMoeConstant_ = createXbcMoeConstant();
        xbcMoeConstant_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMoeConstant_);
    }

    /**
     * Creates a <code>XbcFuncAddr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFuncAddr
     */
    public XbcFuncAddr createXbcFuncAddr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcFuncAddr xbcFuncAddr_ = createXbcFuncAddr();
        xbcFuncAddr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFuncAddr_);
    }

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSizeOfExpr
     */
    public XbcSizeOfExpr createXbcSizeOfExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcSizeOfExpr xbcSizeOfExpr_ = createXbcSizeOfExpr();
        xbcSizeOfExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSizeOfExpr_);
    }

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayAssignExpr
     */
    public XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayAssignExpr xbcCoArrayAssignExpr_ = createXbcCoArrayAssignExpr();
        xbcCoArrayAssignExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayAssignExpr_);
    }

    /**
     * Creates a <code>XbcModExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcModExpr
     */
    public XbcModExpr createXbcModExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcModExpr xbcModExpr_ = createXbcModExpr();
        xbcModExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcModExpr_);
    }

    /**
     * Creates a <code>XbcBitOrExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitOrExpr
     */
    public XbcBitOrExpr createXbcBitOrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcBitOrExpr xbcBitOrExpr_ = createXbcBitOrExpr();
        xbcBitOrExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogOrExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogOrExpr
     */
    public XbcLogOrExpr createXbcLogOrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcLogOrExpr xbcLogOrExpr_ = createXbcLogOrExpr();
        xbcLogOrExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogOrExpr_);
    }

    /**
     * Creates a <code>XbcPlusExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPlusExpr
     */
    public XbcPlusExpr createXbcPlusExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcPlusExpr xbcPlusExpr_ = createXbcPlusExpr();
        xbcPlusExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgPlusExpr
     */
    public XbcAsgPlusExpr createXbcAsgPlusExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgPlusExpr xbcAsgPlusExpr_ = createXbcAsgPlusExpr();
        xbcAsgPlusExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgModExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgModExpr
     */
    public XbcAsgModExpr createXbcAsgModExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgModExpr xbcAsgModExpr_ = createXbcAsgModExpr();
        xbcAsgModExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgModExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitOrExpr
     */
    public XbcAsgBitOrExpr createXbcAsgBitOrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitOrExpr xbcAsgBitOrExpr_ = createXbcAsgBitOrExpr();
        xbcAsgBitOrExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogGTExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGTExpr
     */
    public XbcLogGTExpr createXbcLogGTExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcLogGTExpr xbcLogGTExpr_ = createXbcLogGTExpr();
        xbcLogGTExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogGTExpr_);
    }

    /**
     * Creates a <code>XbcCondExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondExpr
     */
    public XbcCondExpr createXbcCondExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcCondExpr xbcCondExpr_ = createXbcCondExpr();
        xbcCondExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCondExpr_);
    }

    /**
     * Creates a <code>XbcMinusExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMinusExpr
     */
    public XbcMinusExpr createXbcMinusExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcMinusExpr xbcMinusExpr_ = createXbcMinusExpr();
        xbcMinusExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMinusExpr_);
    }

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAddrOfExpr
     */
    public XbcAddrOfExpr createXbcAddrOfExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcAddrOfExpr xbcAddrOfExpr_ = createXbcAddrOfExpr();
        xbcAddrOfExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAddrOfExpr_);
    }

    /**
     * Creates a <code>XbcLshiftExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLshiftExpr
     */
    public XbcLshiftExpr createXbcLshiftExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcLshiftExpr xbcLshiftExpr_ = createXbcLshiftExpr();
        xbcLshiftExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLshiftExpr_);
    }

    /**
     * Creates a <code>XbcRshiftExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcRshiftExpr
     */
    public XbcRshiftExpr createXbcRshiftExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcRshiftExpr xbcRshiftExpr_ = createXbcRshiftExpr();
        xbcRshiftExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitXorExpr
     */
    public XbcAsgBitXorExpr createXbcAsgBitXorExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitXorExpr xbcAsgBitXorExpr_ = createXbcAsgBitXorExpr();
        xbcAsgBitXorExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitXorExpr_);
    }

    /**
     * Creates a <code>XbcLogEQExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogEQExpr
     */
    public XbcLogEQExpr createXbcLogEQExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcLogEQExpr xbcLogEQExpr_ = createXbcLogEQExpr();
        xbcLogEQExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogEQExpr_);
    }

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNEQExpr
     */
    public XbcLogNEQExpr createXbcLogNEQExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcLogNEQExpr xbcLogNEQExpr_ = createXbcLogNEQExpr();
        xbcLogNEQExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogNEQExpr_);
    }

    /**
     * Creates a <code>XbcLogGEExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGEExpr
     */
    public XbcLogGEExpr createXbcLogGEExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcLogGEExpr xbcLogGEExpr_ = createXbcLogGEExpr();
        xbcLogGEExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogGEExpr_);
    }

    /**
     * Creates a <code>XbcLogLTExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLTExpr
     */
    public XbcLogLTExpr createXbcLogLTExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcLogLTExpr xbcLogLTExpr_ = createXbcLogLTExpr();
        xbcLogLTExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogLTExpr_);
    }

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAlignOfExpr
     */
    public XbcGccAlignOfExpr createXbcGccAlignOfExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAlignOfExpr xbcGccAlignOfExpr_ = createXbcGccAlignOfExpr();
        xbcGccAlignOfExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAlignOfExpr_);
    }

    /**
     * Creates a <code>XbcAssignExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAssignExpr
     */
    public XbcAssignExpr createXbcAssignExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcAssignExpr xbcAssignExpr_ = createXbcAssignExpr();
        xbcAssignExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAssignExpr_);
    }

    /**
     * Creates a <code>XbcMulExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMulExpr
     */
    public XbcMulExpr createXbcMulExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcMulExpr xbcMulExpr_ = createXbcMulExpr();
        xbcMulExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMulExpr_);
    }

    /**
     * Creates a <code>XbcDivExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDivExpr
     */
    public XbcDivExpr createXbcDivExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcDivExpr xbcDivExpr_ = createXbcDivExpr();
        xbcDivExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDivExpr_);
    }

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMulExpr
     */
    public XbcAsgMulExpr createXbcAsgMulExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgMulExpr xbcAsgMulExpr_ = createXbcAsgMulExpr();
        xbcAsgMulExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgMulExpr_);
    }

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgRshiftExpr
     */
    public XbcAsgRshiftExpr createXbcAsgRshiftExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgRshiftExpr xbcAsgRshiftExpr_ = createXbcAsgRshiftExpr();
        xbcAsgRshiftExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitAndExpr
     */
    public XbcAsgBitAndExpr createXbcAsgBitAndExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitAndExpr xbcAsgBitAndExpr_ = createXbcAsgBitAndExpr();
        xbcAsgBitAndExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitAndExpr_);
    }

    /**
     * Creates a <code>XbcLogLEExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLEExpr
     */
    public XbcLogLEExpr createXbcLogLEExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcLogLEExpr xbcLogLEExpr_ = createXbcLogLEExpr();
        xbcLogLEExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogLEExpr_);
    }

    /**
     * Creates a <code>XbcLogAndExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogAndExpr
     */
    public XbcLogAndExpr createXbcLogAndExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcLogAndExpr xbcLogAndExpr_ = createXbcLogAndExpr();
        xbcLogAndExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogAndExpr_);
    }

    /**
     * Creates a <code>XbcCommaExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCommaExpr
     */
    public XbcCommaExpr createXbcCommaExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcCommaExpr xbcCommaExpr_ = createXbcCommaExpr();
        xbcCommaExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCommaExpr_);
    }

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgDivExpr
     */
    public XbcAsgDivExpr createXbcAsgDivExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgDivExpr xbcAsgDivExpr_ = createXbcAsgDivExpr();
        xbcAsgDivExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgDivExpr_);
    }

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccLabelAddr
     */
    public XbcGccLabelAddr createXbcGccLabelAddr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcGccLabelAddr xbcGccLabelAddr_ = createXbcGccLabelAddr();
        xbcGccLabelAddr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccLabelAddr_);
    }

    /**
     * Creates a <code>XbcBitAndExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitAndExpr
     */
    public XbcBitAndExpr createXbcBitAndExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcBitAndExpr xbcBitAndExpr_ = createXbcBitAndExpr();
        xbcBitAndExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitAndExpr_);
    }

    /**
     * Creates a <code>XbcBitXorExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitXorExpr
     */
    public XbcBitXorExpr createXbcBitXorExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcBitXorExpr xbcBitXorExpr_ = createXbcBitXorExpr();
        xbcBitXorExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitXorExpr_);
    }

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMinusExpr
     */
    public XbcAsgMinusExpr createXbcAsgMinusExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgMinusExpr xbcAsgMinusExpr_ = createXbcAsgMinusExpr();
        xbcAsgMinusExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgMinusExpr_);
    }

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgLshiftExpr
     */
    public XbcAsgLshiftExpr createXbcAsgLshiftExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgLshiftExpr xbcAsgLshiftExpr_ = createXbcAsgLshiftExpr();
        xbcAsgLshiftExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgLshiftExpr_);
    }

    /**
     * Creates a <code>XbcMemberAddr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberAddr
     */
    public XbcMemberAddr createXbcMemberAddr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberAddr xbcMemberAddr_ = createXbcMemberAddr();
        xbcMemberAddr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberAddr_);
    }

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayRef
     */
    public XbcMemberArrayRef createXbcMemberArrayRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberArrayRef xbcMemberArrayRef_ = createXbcMemberArrayRef();
        xbcMemberArrayRef_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberArrayRef_);
    }

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayAddr
     */
    public XbcMemberArrayAddr createXbcMemberArrayAddr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberArrayAddr xbcMemberArrayAddr_ = createXbcMemberArrayAddr();
        xbcMemberArrayAddr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberArrayAddr_);
    }

    /**
     * Creates a <code>XbcTypeName</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeName
     */
    public XbcTypeName createXbcTypeName(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcTypeName xbcTypeName_ = createXbcTypeName();
        xbcTypeName_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcTypeName_);
    }

    /**
     * Creates a <code>XbcPointerRef</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerRef
     */
    public XbcPointerRef createXbcPointerRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcPointerRef xbcPointerRef_ = createXbcPointerRef();
        xbcPointerRef_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPointerRef_);
    }

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnaryMinusExpr
     */
    public XbcUnaryMinusExpr createXbcUnaryMinusExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcUnaryMinusExpr xbcUnaryMinusExpr_ = createXbcUnaryMinusExpr();
        xbcUnaryMinusExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbcBitNotExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitNotExpr
     */
    public XbcBitNotExpr createXbcBitNotExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcBitNotExpr xbcBitNotExpr_ = createXbcBitNotExpr();
        xbcBitNotExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitNotExpr_);
    }

    /**
     * Creates a <code>XbcLogNotExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNotExpr
     */
    public XbcLogNotExpr createXbcLogNotExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcLogNotExpr xbcLogNotExpr_ = createXbcLogNotExpr();
        xbcLogNotExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogNotExpr_);
    }

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostIncrExpr
     */
    public XbcPostIncrExpr createXbcPostIncrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcPostIncrExpr xbcPostIncrExpr_ = createXbcPostIncrExpr();
        xbcPostIncrExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPostIncrExpr_);
    }

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostDecrExpr
     */
    public XbcPostDecrExpr createXbcPostDecrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcPostDecrExpr xbcPostDecrExpr_ = createXbcPostDecrExpr();
        xbcPostDecrExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPostDecrExpr_);
    }

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreIncrExpr
     */
    public XbcPreIncrExpr createXbcPreIncrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcPreIncrExpr xbcPreIncrExpr_ = createXbcPreIncrExpr();
        xbcPreIncrExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPreIncrExpr_);
    }

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreDecrExpr
     */
    public XbcPreDecrExpr createXbcPreDecrExpr(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcPreDecrExpr xbcPreDecrExpr_ = createXbcPreDecrExpr();
        xbcPreDecrExpr_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPreDecrExpr_);
    }

    /**
     * Creates a <code>XbcIndexRange</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIndexRange
     */
    public XbcIndexRange createXbcIndexRange(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcIndexRange xbcIndexRange_ = createXbcIndexRange();
        xbcIndexRange_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIndexRange_);
    }

    /**
     * Creates a <code>XbcLowerBound</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLowerBound
     */
    public XbcLowerBound createXbcLowerBound(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcLowerBound xbcLowerBound_ = createXbcLowerBound();
        xbcLowerBound_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLowerBound_);
    }

    /**
     * Creates a <code>XbcUpperBound</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUpperBound
     */
    public XbcUpperBound createXbcUpperBound(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcUpperBound xbcUpperBound_ = createXbcUpperBound();
        xbcUpperBound_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUpperBound_);
    }

    /**
     * Creates a <code>XbcStep</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStep
     */
    public XbcStep createXbcStep(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcStep xbcStep_ = createXbcStep();
        xbcStep_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStep_);
    }

    /**
     * Creates a <code>XbcDesignatedValue</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDesignatedValue
     */
    public XbcDesignatedValue createXbcDesignatedValue(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcDesignatedValue xbcDesignatedValue_ = createXbcDesignatedValue();
        xbcDesignatedValue_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDesignatedValue_);
    }

    /**
     * Creates a <code>XbcCompoundValue</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValue
     */
    public XbcCompoundValue createXbcCompoundValue(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValue xbcCompoundValue_ = createXbcCompoundValue();
        xbcCompoundValue_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValue_);
    }

    /**
     * Creates a <code>XbcBitField</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitField
     */
    public XbcBitField createXbcBitField(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcBitField xbcBitField_ = createXbcBitField();
        xbcBitField_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitField_);
    }

    /**
     * Creates a <code>XbcPragma</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPragma
     */
    public XbcPragma createXbcPragma(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcPragma xbcPragma_ = createXbcPragma();
        xbcPragma_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPragma_);
    }

    /**
     * Creates a <code>XbcText</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcText
     */
    public XbcText createXbcText(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcText xbcText_ = createXbcText();
        xbcText_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcText_);
    }

    /**
     * Creates a <code>XbcDeclarations</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDeclarations
     */
    public XbcDeclarations createXbcDeclarations(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcDeclarations xbcDeclarations_ = createXbcDeclarations();
        xbcDeclarations_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDeclarations_);
    }

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDefinition
     */
    public XbcFunctionDefinition createXbcFunctionDefinition(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionDefinition xbcFunctionDefinition_ = createXbcFunctionDefinition();
        xbcFunctionDefinition_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionDefinition_);
    }

    /**
     * Creates a <code>XbcParams</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcParams
     */
    public XbcParams createXbcParams(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcParams xbcParams_ = createXbcParams();
        xbcParams_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcParams_);
    }

    /**
     * Creates a <code>XbcBody</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBody
     */
    public XbcBody createXbcBody(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcBody xbcBody_ = createXbcBody();
        xbcBody_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBody_);
    }

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmStatement
     */
    public XbcGccAsmStatement createXbcGccAsmStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmStatement xbcGccAsmStatement_ = createXbcGccAsmStatement();
        xbcGccAsmStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmStatement_);
    }

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperands
     */
    public XbcGccAsmOperands createXbcGccAsmOperands(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmOperands xbcGccAsmOperands_ = createXbcGccAsmOperands();
        xbcGccAsmOperands_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmOperands_);
    }

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperand
     */
    public XbcGccAsmOperand createXbcGccAsmOperand(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmOperand xbcGccAsmOperand_ = createXbcGccAsmOperand();
        xbcGccAsmOperand_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmOperand_);
    }

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmClobbers
     */
    public XbcGccAsmClobbers createXbcGccAsmClobbers(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmClobbers xbcGccAsmClobbers_ = createXbcGccAsmClobbers();
        xbcGccAsmClobbers_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmClobbers_);
    }

    /**
     * Creates a <code>XbcForStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcForStatement
     */
    public XbcForStatement createXbcForStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcForStatement xbcForStatement_ = createXbcForStatement();
        xbcForStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcForStatement_);
    }

    /**
     * Creates a <code>XbcInit</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcInit
     */
    public XbcInit createXbcInit(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcInit xbcInit_ = createXbcInit();
        xbcInit_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcInit_);
    }

    /**
     * Creates a <code>XbcCondition</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondition
     */
    public XbcCondition createXbcCondition(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcCondition xbcCondition_ = createXbcCondition();
        xbcCondition_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCondition_);
    }

    /**
     * Creates a <code>XbcIter</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIter
     */
    public XbcIter createXbcIter(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcIter xbcIter_ = createXbcIter();
        xbcIter_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIter_);
    }

    /**
     * Creates a <code>XbcIfStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIfStatement
     */
    public XbcIfStatement createXbcIfStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcIfStatement xbcIfStatement_ = createXbcIfStatement();
        xbcIfStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIfStatement_);
    }

    /**
     * Creates a <code>XbcThen</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcThen
     */
    public XbcThen createXbcThen(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcThen xbcThen_ = createXbcThen();
        xbcThen_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcThen_);
    }

    /**
     * Creates a <code>XbcElse</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcElse
     */
    public XbcElse createXbcElse(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcElse xbcElse_ = createXbcElse();
        xbcElse_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcElse_);
    }

    /**
     * Creates a <code>XbcWhileStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcWhileStatement
     */
    public XbcWhileStatement createXbcWhileStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcWhileStatement xbcWhileStatement_ = createXbcWhileStatement();
        xbcWhileStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcWhileStatement_);
    }

    /**
     * Creates a <code>XbcDoStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDoStatement
     */
    public XbcDoStatement createXbcDoStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcDoStatement xbcDoStatement_ = createXbcDoStatement();
        xbcDoStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDoStatement_);
    }

    /**
     * Creates a <code>XbcSwitchStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSwitchStatement
     */
    public XbcSwitchStatement createXbcSwitchStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcSwitchStatement xbcSwitchStatement_ = createXbcSwitchStatement();
        xbcSwitchStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSwitchStatement_);
    }

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccRangedCaseLabel
     */
    public XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcGccRangedCaseLabel xbcGccRangedCaseLabel_ = createXbcGccRangedCaseLabel();
        xbcGccRangedCaseLabel_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccRangedCaseLabel_);
    }

    /**
     * Creates a <code>XbcStatementLabel</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStatementLabel
     */
    public XbcStatementLabel createXbcStatementLabel(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcStatementLabel xbcStatementLabel_ = createXbcStatementLabel();
        xbcStatementLabel_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStatementLabel_);
    }

    /**
     * Creates a <code>XbcCaseLabel</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCaseLabel
     */
    public XbcCaseLabel createXbcCaseLabel(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcCaseLabel xbcCaseLabel_ = createXbcCaseLabel();
        xbcCaseLabel_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCaseLabel_);
    }

    /**
     * Creates a <code>XbcBreakStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBreakStatement
     */
    public XbcBreakStatement createXbcBreakStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcBreakStatement xbcBreakStatement_ = createXbcBreakStatement();
        xbcBreakStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBreakStatement_);
    }

    /**
     * Creates a <code>XbcContinueStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcContinueStatement
     */
    public XbcContinueStatement createXbcContinueStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcContinueStatement xbcContinueStatement_ = createXbcContinueStatement();
        xbcContinueStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcContinueStatement_);
    }

    /**
     * Creates a <code>XbcReturnStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcReturnStatement
     */
    public XbcReturnStatement createXbcReturnStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcReturnStatement xbcReturnStatement_ = createXbcReturnStatement();
        xbcReturnStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcReturnStatement_);
    }

    /**
     * Creates a <code>XbcGotoStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGotoStatement
     */
    public XbcGotoStatement createXbcGotoStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcGotoStatement xbcGotoStatement_ = createXbcGotoStatement();
        xbcGotoStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGotoStatement_);
    }

    /**
     * Creates a <code>XbcDefaultLabel</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDefaultLabel
     */
    public XbcDefaultLabel createXbcDefaultLabel(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcDefaultLabel xbcDefaultLabel_ = createXbcDefaultLabel();
        xbcDefaultLabel_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDefaultLabel_);
    }

    /**
     * Creates a <code>XbcExprStatement</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcExprStatement
     */
    public XbcExprStatement createXbcExprStatement(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcExprStatement xbcExprStatement_ = createXbcExprStatement();
        xbcExprStatement_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcExprStatement_);
    }

    /**
     * Creates a <code>XbcVarDecl</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarDecl
     */
    public XbcVarDecl createXbcVarDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcVarDecl xbcVarDecl_ = createXbcVarDecl();
        xbcVarDecl_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVarDecl_);
    }

    /**
     * Creates a <code>XbcGccAsm</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsm
     */
    public XbcGccAsm createXbcGccAsm(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsm xbcGccAsm_ = createXbcGccAsm();
        xbcGccAsm_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsm_);
    }

    /**
     * Creates a <code>XbcFunctionDecl</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDecl
     */
    public XbcFunctionDecl createXbcFunctionDecl(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionDecl xbcFunctionDecl_ = createXbcFunctionDecl();
        xbcFunctionDecl_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionDecl_);
    }

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccMemberDesignator
     */
    public XbcGccMemberDesignator createXbcGccMemberDesignator(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcGccMemberDesignator xbcGccMemberDesignator_ = createXbcGccMemberDesignator();
        xbcGccMemberDesignator_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccMemberDesignator_);
    }

    /**
     * Creates a <code>XbcArrayType</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayType
     */
    public XbcArrayType createXbcArrayType(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayType xbcArrayType_ = createXbcArrayType();
        xbcArrayType_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayType_);
    }

    /**
     * Creates a <code>XbcArraySize</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArraySize
     */
    public XbcArraySize createXbcArraySize(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcArraySize xbcArraySize_ = createXbcArraySize();
        xbcArraySize_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArraySize_);
    }

    /**
     * Creates a <code>XbcBasicType</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBasicType
     */
    public XbcBasicType createXbcBasicType(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcBasicType xbcBasicType_ = createXbcBasicType();
        xbcBasicType_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBasicType_);
    }

    /**
     * Creates a <code>XbcPointerType</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerType
     */
    public XbcPointerType createXbcPointerType(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcPointerType xbcPointerType_ = createXbcPointerType();
        xbcPointerType_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPointerType_);
    }

    /**
     * Creates a <code>XbcStructType</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStructType
     */
    public XbcStructType createXbcStructType(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcStructType xbcStructType_ = createXbcStructType();
        xbcStructType_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStructType_);
    }

    /**
     * Creates a <code>XbcUnionType</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnionType
     */
    public XbcUnionType createXbcUnionType(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcUnionType xbcUnionType_ = createXbcUnionType();
        xbcUnionType_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUnionType_);
    }

    /**
     * Creates a <code>XbcEnumType</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcEnumType
     */
    public XbcEnumType createXbcEnumType(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcEnumType xbcEnumType_ = createXbcEnumType();
        xbcEnumType_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcEnumType_);
    }

    /**
     * Creates a <code>XbcCoArrayType</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayType
     */
    public XbcCoArrayType createXbcCoArrayType(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayType xbcCoArrayType_ = createXbcCoArrayType();
        xbcCoArrayType_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayType_);
    }

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalSymbols
     */
    public XbcGlobalSymbols createXbcGlobalSymbols(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcGlobalSymbols xbcGlobalSymbols_ = createXbcGlobalSymbols();
        xbcGlobalSymbols_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGlobalSymbols_);
    }

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalDeclarations
     */
    public XbcGlobalDeclarations createXbcGlobalDeclarations(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcGlobalDeclarations xbcGlobalDeclarations_ = createXbcGlobalDeclarations();
        xbcGlobalDeclarations_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the InputStream <code>in</code>.
     * This method is a template method for concrete classes.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmDefinition
     */
    public XbcGccAsmDefinition createXbcGccAsmDefinition(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmDefinition xbcGccAsmDefinition_ = createXbcGccAsmDefinition();
        xbcGccAsmDefinition_.setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmDefinition_);
    }

    /**
     * Creates a <code>XbcXcodeProgram</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXcodeProgram
     */
    public XbcXcodeProgram createXbcXcodeProgram(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcXcodeProgram xbcXcodeProgram_ = createXbcXcodeProgram();
        xbcXcodeProgram_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcXcodeProgram_);
    }

    /**
     * Creates a <code>XbcTypeTable</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeTable
     */
    public XbcTypeTable createXbcTypeTable(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcTypeTable xbcTypeTable_ = createXbcTypeTable();
        xbcTypeTable_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcTypeTable_);
    }

    /**
     * Creates a <code>XbcFunctionType</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionType
     */
    public XbcFunctionType createXbcFunctionType(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionType xbcFunctionType_ = createXbcFunctionType();
        xbcFunctionType_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionType_);
    }

    /**
     * Creates a <code>XbcGccAttributes</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttributes
     */
    public XbcGccAttributes createXbcGccAttributes(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAttributes xbcGccAttributes_ = createXbcGccAttributes();
        xbcGccAttributes_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAttributes_);
    }

    /**
     * Creates a <code>XbcGccAttribute</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttribute
     */
    public XbcGccAttribute createXbcGccAttribute(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAttribute xbcGccAttribute_ = createXbcGccAttribute();
        xbcGccAttribute_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAttribute_);
    }

    /**
     * Creates a <code>XbcBuiltinOp</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBuiltinOp
     */
    public XbcBuiltinOp createXbcBuiltinOp(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcBuiltinOp xbcBuiltinOp_ = createXbcBuiltinOp();
        xbcBuiltinOp_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBuiltinOp_);
    }

    /**
     * Creates a <code>XbcArrayRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayRef
     */
    public XbcArrayRef createXbcArrayRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayRef xbcArrayRef_ = createXbcArrayRef();
        xbcArrayRef_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayRef_);
    }

    /**
     * Creates a <code>XbcArrayAddr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayAddr
     */
    public XbcArrayAddr createXbcArrayAddr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayAddr xbcArrayAddr_ = createXbcArrayAddr();
        xbcArrayAddr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayAddr_);
    }

    /**
     * Creates a <code>XbcFunctionCall</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionCall
     */
    public XbcFunctionCall createXbcFunctionCall(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionCall xbcFunctionCall_ = createXbcFunctionCall();
        xbcFunctionCall_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionCall_);
    }

    /**
     * Creates a <code>XbcFunction</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunction
     */
    public XbcFunction createXbcFunction(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcFunction xbcFunction_ = createXbcFunction();
        xbcFunction_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunction_);
    }

    /**
     * Creates a <code>XbcArguments</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArguments
     */
    public XbcArguments createXbcArguments(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcArguments xbcArguments_ = createXbcArguments();
        xbcArguments_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArguments_);
    }

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccCompoundExpr
     */
    public XbcGccCompoundExpr createXbcGccCompoundExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcGccCompoundExpr xbcGccCompoundExpr_ = createXbcGccCompoundExpr();
        xbcGccCompoundExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccCompoundExpr_);
    }

    /**
     * Creates a <code>XbcCompoundStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundStatement
     */
    public XbcCompoundStatement createXbcCompoundStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundStatement xbcCompoundStatement_ = createXbcCompoundStatement();
        xbcCompoundStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundStatement_);
    }

    /**
     * Creates a <code>XbcSymbols</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSymbols
     */
    public XbcSymbols createXbcSymbols(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcSymbols xbcSymbols_ = createXbcSymbols();
        xbcSymbols_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSymbols_);
    }

    /**
     * Creates a <code>XbcId</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcId
     */
    public XbcId createXbcId(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcId xbcId_ = createXbcId();
        xbcId_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcId_);
    }

    /**
     * Creates a <code>XbcName</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcName
     */
    public XbcName createXbcName(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcName xbcName_ = createXbcName();
        xbcName_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcName_);
    }

    /**
     * Creates a <code>XbcValue</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcValue
     */
    public XbcValue createXbcValue(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcValue xbcValue_ = createXbcValue();
        xbcValue_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcValue_);
    }

    /**
     * Creates a <code>XbcSubArrayRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSubArrayRef
     */
    public XbcSubArrayRef createXbcSubArrayRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcSubArrayRef xbcSubArrayRef_ = createXbcSubArrayRef();
        xbcSubArrayRef_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSubArrayRef_);
    }

    /**
     * Creates a <code>XbcCoArrayRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayRef
     */
    public XbcCoArrayRef createXbcCoArrayRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayRef xbcCoArrayRef_ = createXbcCoArrayRef();
        xbcCoArrayRef_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayRef_);
    }

    /**
     * Creates a <code>XbcVar</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVar
     */
    public XbcVar createXbcVar(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcVar xbcVar_ = createXbcVar();
        xbcVar_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVar_);
    }

    /**
     * Creates a <code>XbcMemberRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberRef
     */
    public XbcMemberRef createXbcMemberRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberRef xbcMemberRef_ = createXbcMemberRef();
        xbcMemberRef_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberRef_);
    }

    /**
     * Creates a <code>XbcCastExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCastExpr
     */
    public XbcCastExpr createXbcCastExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcCastExpr xbcCastExpr_ = createXbcCastExpr();
        xbcCastExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCastExpr_);
    }

    /**
     * Creates a <code>XbcStringConstant</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStringConstant
     */
    public XbcStringConstant createXbcStringConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcStringConstant xbcStringConstant_ = createXbcStringConstant();
        xbcStringConstant_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStringConstant_);
    }

    /**
     * Creates a <code>XbcVarAddr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarAddr
     */
    public XbcVarAddr createXbcVarAddr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcVarAddr xbcVarAddr_ = createXbcVarAddr();
        xbcVarAddr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVarAddr_);
    }

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueExpr
     */
    public XbcCompoundValueExpr createXbcCompoundValueExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValueExpr xbcCompoundValueExpr_ = createXbcCompoundValueExpr();
        xbcCompoundValueExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValueExpr_);
    }

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueAddrExpr
     */
    public XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValueAddrExpr xbcCompoundValueAddrExpr_ = createXbcCompoundValueAddrExpr();
        xbcCompoundValueAddrExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValueAddrExpr_);
    }

    /**
     * Creates a <code>XbcXmpDescOf</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXmpDescOf
     */
    public XbcXmpDescOf createXbcXmpDescOf(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcXmpDescOf xbcXmpDescOf_ = createXbcXmpDescOf();
        xbcXmpDescOf_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcXmpDescOf_);
    }

    /**
     * Creates a <code>XbcIntConstant</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIntConstant
     */
    public XbcIntConstant createXbcIntConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcIntConstant xbcIntConstant_ = createXbcIntConstant();
        xbcIntConstant_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIntConstant_);
    }

    /**
     * Creates a <code>XbcFloatConstant</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFloatConstant
     */
    public XbcFloatConstant createXbcFloatConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcFloatConstant xbcFloatConstant_ = createXbcFloatConstant();
        xbcFloatConstant_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFloatConstant_);
    }

    /**
     * Creates a <code>XbcLonglongConstant</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLonglongConstant
     */
    public XbcLonglongConstant createXbcLonglongConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcLonglongConstant xbcLonglongConstant_ = createXbcLonglongConstant();
        xbcLonglongConstant_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLonglongConstant_);
    }

    /**
     * Creates a <code>XbcMoeConstant</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMoeConstant
     */
    public XbcMoeConstant createXbcMoeConstant(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcMoeConstant xbcMoeConstant_ = createXbcMoeConstant();
        xbcMoeConstant_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMoeConstant_);
    }

    /**
     * Creates a <code>XbcFuncAddr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFuncAddr
     */
    public XbcFuncAddr createXbcFuncAddr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcFuncAddr xbcFuncAddr_ = createXbcFuncAddr();
        xbcFuncAddr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFuncAddr_);
    }

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSizeOfExpr
     */
    public XbcSizeOfExpr createXbcSizeOfExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcSizeOfExpr xbcSizeOfExpr_ = createXbcSizeOfExpr();
        xbcSizeOfExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSizeOfExpr_);
    }

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayAssignExpr
     */
    public XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayAssignExpr xbcCoArrayAssignExpr_ = createXbcCoArrayAssignExpr();
        xbcCoArrayAssignExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayAssignExpr_);
    }

    /**
     * Creates a <code>XbcModExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcModExpr
     */
    public XbcModExpr createXbcModExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcModExpr xbcModExpr_ = createXbcModExpr();
        xbcModExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcModExpr_);
    }

    /**
     * Creates a <code>XbcBitOrExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitOrExpr
     */
    public XbcBitOrExpr createXbcBitOrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcBitOrExpr xbcBitOrExpr_ = createXbcBitOrExpr();
        xbcBitOrExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogOrExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogOrExpr
     */
    public XbcLogOrExpr createXbcLogOrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcLogOrExpr xbcLogOrExpr_ = createXbcLogOrExpr();
        xbcLogOrExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogOrExpr_);
    }

    /**
     * Creates a <code>XbcPlusExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPlusExpr
     */
    public XbcPlusExpr createXbcPlusExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcPlusExpr xbcPlusExpr_ = createXbcPlusExpr();
        xbcPlusExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgPlusExpr
     */
    public XbcAsgPlusExpr createXbcAsgPlusExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgPlusExpr xbcAsgPlusExpr_ = createXbcAsgPlusExpr();
        xbcAsgPlusExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgModExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgModExpr
     */
    public XbcAsgModExpr createXbcAsgModExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgModExpr xbcAsgModExpr_ = createXbcAsgModExpr();
        xbcAsgModExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgModExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitOrExpr
     */
    public XbcAsgBitOrExpr createXbcAsgBitOrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitOrExpr xbcAsgBitOrExpr_ = createXbcAsgBitOrExpr();
        xbcAsgBitOrExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogGTExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGTExpr
     */
    public XbcLogGTExpr createXbcLogGTExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcLogGTExpr xbcLogGTExpr_ = createXbcLogGTExpr();
        xbcLogGTExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogGTExpr_);
    }

    /**
     * Creates a <code>XbcCondExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondExpr
     */
    public XbcCondExpr createXbcCondExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcCondExpr xbcCondExpr_ = createXbcCondExpr();
        xbcCondExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCondExpr_);
    }

    /**
     * Creates a <code>XbcMinusExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMinusExpr
     */
    public XbcMinusExpr createXbcMinusExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcMinusExpr xbcMinusExpr_ = createXbcMinusExpr();
        xbcMinusExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMinusExpr_);
    }

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAddrOfExpr
     */
    public XbcAddrOfExpr createXbcAddrOfExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcAddrOfExpr xbcAddrOfExpr_ = createXbcAddrOfExpr();
        xbcAddrOfExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAddrOfExpr_);
    }

    /**
     * Creates a <code>XbcLshiftExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLshiftExpr
     */
    public XbcLshiftExpr createXbcLshiftExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcLshiftExpr xbcLshiftExpr_ = createXbcLshiftExpr();
        xbcLshiftExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLshiftExpr_);
    }

    /**
     * Creates a <code>XbcRshiftExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcRshiftExpr
     */
    public XbcRshiftExpr createXbcRshiftExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcRshiftExpr xbcRshiftExpr_ = createXbcRshiftExpr();
        xbcRshiftExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitXorExpr
     */
    public XbcAsgBitXorExpr createXbcAsgBitXorExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitXorExpr xbcAsgBitXorExpr_ = createXbcAsgBitXorExpr();
        xbcAsgBitXorExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitXorExpr_);
    }

    /**
     * Creates a <code>XbcLogEQExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogEQExpr
     */
    public XbcLogEQExpr createXbcLogEQExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcLogEQExpr xbcLogEQExpr_ = createXbcLogEQExpr();
        xbcLogEQExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogEQExpr_);
    }

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNEQExpr
     */
    public XbcLogNEQExpr createXbcLogNEQExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcLogNEQExpr xbcLogNEQExpr_ = createXbcLogNEQExpr();
        xbcLogNEQExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogNEQExpr_);
    }

    /**
     * Creates a <code>XbcLogGEExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGEExpr
     */
    public XbcLogGEExpr createXbcLogGEExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcLogGEExpr xbcLogGEExpr_ = createXbcLogGEExpr();
        xbcLogGEExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogGEExpr_);
    }

    /**
     * Creates a <code>XbcLogLTExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLTExpr
     */
    public XbcLogLTExpr createXbcLogLTExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcLogLTExpr xbcLogLTExpr_ = createXbcLogLTExpr();
        xbcLogLTExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogLTExpr_);
    }

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAlignOfExpr
     */
    public XbcGccAlignOfExpr createXbcGccAlignOfExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAlignOfExpr xbcGccAlignOfExpr_ = createXbcGccAlignOfExpr();
        xbcGccAlignOfExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAlignOfExpr_);
    }

    /**
     * Creates a <code>XbcAssignExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAssignExpr
     */
    public XbcAssignExpr createXbcAssignExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcAssignExpr xbcAssignExpr_ = createXbcAssignExpr();
        xbcAssignExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAssignExpr_);
    }

    /**
     * Creates a <code>XbcMulExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMulExpr
     */
    public XbcMulExpr createXbcMulExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcMulExpr xbcMulExpr_ = createXbcMulExpr();
        xbcMulExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMulExpr_);
    }

    /**
     * Creates a <code>XbcDivExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDivExpr
     */
    public XbcDivExpr createXbcDivExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcDivExpr xbcDivExpr_ = createXbcDivExpr();
        xbcDivExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDivExpr_);
    }

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMulExpr
     */
    public XbcAsgMulExpr createXbcAsgMulExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgMulExpr xbcAsgMulExpr_ = createXbcAsgMulExpr();
        xbcAsgMulExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgMulExpr_);
    }

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgRshiftExpr
     */
    public XbcAsgRshiftExpr createXbcAsgRshiftExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgRshiftExpr xbcAsgRshiftExpr_ = createXbcAsgRshiftExpr();
        xbcAsgRshiftExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitAndExpr
     */
    public XbcAsgBitAndExpr createXbcAsgBitAndExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitAndExpr xbcAsgBitAndExpr_ = createXbcAsgBitAndExpr();
        xbcAsgBitAndExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitAndExpr_);
    }

    /**
     * Creates a <code>XbcLogLEExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLEExpr
     */
    public XbcLogLEExpr createXbcLogLEExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcLogLEExpr xbcLogLEExpr_ = createXbcLogLEExpr();
        xbcLogLEExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogLEExpr_);
    }

    /**
     * Creates a <code>XbcLogAndExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogAndExpr
     */
    public XbcLogAndExpr createXbcLogAndExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcLogAndExpr xbcLogAndExpr_ = createXbcLogAndExpr();
        xbcLogAndExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogAndExpr_);
    }

    /**
     * Creates a <code>XbcCommaExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCommaExpr
     */
    public XbcCommaExpr createXbcCommaExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcCommaExpr xbcCommaExpr_ = createXbcCommaExpr();
        xbcCommaExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCommaExpr_);
    }

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgDivExpr
     */
    public XbcAsgDivExpr createXbcAsgDivExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgDivExpr xbcAsgDivExpr_ = createXbcAsgDivExpr();
        xbcAsgDivExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgDivExpr_);
    }

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccLabelAddr
     */
    public XbcGccLabelAddr createXbcGccLabelAddr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcGccLabelAddr xbcGccLabelAddr_ = createXbcGccLabelAddr();
        xbcGccLabelAddr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccLabelAddr_);
    }

    /**
     * Creates a <code>XbcBitAndExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitAndExpr
     */
    public XbcBitAndExpr createXbcBitAndExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcBitAndExpr xbcBitAndExpr_ = createXbcBitAndExpr();
        xbcBitAndExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitAndExpr_);
    }

    /**
     * Creates a <code>XbcBitXorExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitXorExpr
     */
    public XbcBitXorExpr createXbcBitXorExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcBitXorExpr xbcBitXorExpr_ = createXbcBitXorExpr();
        xbcBitXorExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitXorExpr_);
    }

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMinusExpr
     */
    public XbcAsgMinusExpr createXbcAsgMinusExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgMinusExpr xbcAsgMinusExpr_ = createXbcAsgMinusExpr();
        xbcAsgMinusExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgMinusExpr_);
    }

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgLshiftExpr
     */
    public XbcAsgLshiftExpr createXbcAsgLshiftExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgLshiftExpr xbcAsgLshiftExpr_ = createXbcAsgLshiftExpr();
        xbcAsgLshiftExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgLshiftExpr_);
    }

    /**
     * Creates a <code>XbcMemberAddr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberAddr
     */
    public XbcMemberAddr createXbcMemberAddr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberAddr xbcMemberAddr_ = createXbcMemberAddr();
        xbcMemberAddr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberAddr_);
    }

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayRef
     */
    public XbcMemberArrayRef createXbcMemberArrayRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberArrayRef xbcMemberArrayRef_ = createXbcMemberArrayRef();
        xbcMemberArrayRef_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberArrayRef_);
    }

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayAddr
     */
    public XbcMemberArrayAddr createXbcMemberArrayAddr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberArrayAddr xbcMemberArrayAddr_ = createXbcMemberArrayAddr();
        xbcMemberArrayAddr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberArrayAddr_);
    }

    /**
     * Creates a <code>XbcTypeName</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeName
     */
    public XbcTypeName createXbcTypeName(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcTypeName xbcTypeName_ = createXbcTypeName();
        xbcTypeName_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcTypeName_);
    }

    /**
     * Creates a <code>XbcPointerRef</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerRef
     */
    public XbcPointerRef createXbcPointerRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcPointerRef xbcPointerRef_ = createXbcPointerRef();
        xbcPointerRef_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPointerRef_);
    }

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnaryMinusExpr
     */
    public XbcUnaryMinusExpr createXbcUnaryMinusExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcUnaryMinusExpr xbcUnaryMinusExpr_ = createXbcUnaryMinusExpr();
        xbcUnaryMinusExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbcBitNotExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitNotExpr
     */
    public XbcBitNotExpr createXbcBitNotExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcBitNotExpr xbcBitNotExpr_ = createXbcBitNotExpr();
        xbcBitNotExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitNotExpr_);
    }

    /**
     * Creates a <code>XbcLogNotExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNotExpr
     */
    public XbcLogNotExpr createXbcLogNotExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcLogNotExpr xbcLogNotExpr_ = createXbcLogNotExpr();
        xbcLogNotExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogNotExpr_);
    }

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostIncrExpr
     */
    public XbcPostIncrExpr createXbcPostIncrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcPostIncrExpr xbcPostIncrExpr_ = createXbcPostIncrExpr();
        xbcPostIncrExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPostIncrExpr_);
    }

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostDecrExpr
     */
    public XbcPostDecrExpr createXbcPostDecrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcPostDecrExpr xbcPostDecrExpr_ = createXbcPostDecrExpr();
        xbcPostDecrExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPostDecrExpr_);
    }

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreIncrExpr
     */
    public XbcPreIncrExpr createXbcPreIncrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcPreIncrExpr xbcPreIncrExpr_ = createXbcPreIncrExpr();
        xbcPreIncrExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPreIncrExpr_);
    }

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreDecrExpr
     */
    public XbcPreDecrExpr createXbcPreDecrExpr(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcPreDecrExpr xbcPreDecrExpr_ = createXbcPreDecrExpr();
        xbcPreDecrExpr_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPreDecrExpr_);
    }

    /**
     * Creates a <code>XbcIndexRange</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIndexRange
     */
    public XbcIndexRange createXbcIndexRange(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcIndexRange xbcIndexRange_ = createXbcIndexRange();
        xbcIndexRange_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIndexRange_);
    }

    /**
     * Creates a <code>XbcLowerBound</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLowerBound
     */
    public XbcLowerBound createXbcLowerBound(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcLowerBound xbcLowerBound_ = createXbcLowerBound();
        xbcLowerBound_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLowerBound_);
    }

    /**
     * Creates a <code>XbcUpperBound</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUpperBound
     */
    public XbcUpperBound createXbcUpperBound(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcUpperBound xbcUpperBound_ = createXbcUpperBound();
        xbcUpperBound_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUpperBound_);
    }

    /**
     * Creates a <code>XbcStep</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStep
     */
    public XbcStep createXbcStep(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcStep xbcStep_ = createXbcStep();
        xbcStep_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStep_);
    }

    /**
     * Creates a <code>XbcDesignatedValue</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDesignatedValue
     */
    public XbcDesignatedValue createXbcDesignatedValue(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcDesignatedValue xbcDesignatedValue_ = createXbcDesignatedValue();
        xbcDesignatedValue_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDesignatedValue_);
    }

    /**
     * Creates a <code>XbcCompoundValue</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValue
     */
    public XbcCompoundValue createXbcCompoundValue(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValue xbcCompoundValue_ = createXbcCompoundValue();
        xbcCompoundValue_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValue_);
    }

    /**
     * Creates a <code>XbcBitField</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitField
     */
    public XbcBitField createXbcBitField(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcBitField xbcBitField_ = createXbcBitField();
        xbcBitField_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitField_);
    }

    /**
     * Creates a <code>XbcPragma</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPragma
     */
    public XbcPragma createXbcPragma(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcPragma xbcPragma_ = createXbcPragma();
        xbcPragma_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPragma_);
    }

    /**
     * Creates a <code>XbcText</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcText
     */
    public XbcText createXbcText(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcText xbcText_ = createXbcText();
        xbcText_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcText_);
    }

    /**
     * Creates a <code>XbcDeclarations</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDeclarations
     */
    public XbcDeclarations createXbcDeclarations(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcDeclarations xbcDeclarations_ = createXbcDeclarations();
        xbcDeclarations_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDeclarations_);
    }

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDefinition
     */
    public XbcFunctionDefinition createXbcFunctionDefinition(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionDefinition xbcFunctionDefinition_ = createXbcFunctionDefinition();
        xbcFunctionDefinition_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionDefinition_);
    }

    /**
     * Creates a <code>XbcParams</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcParams
     */
    public XbcParams createXbcParams(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcParams xbcParams_ = createXbcParams();
        xbcParams_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcParams_);
    }

    /**
     * Creates a <code>XbcBody</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBody
     */
    public XbcBody createXbcBody(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcBody xbcBody_ = createXbcBody();
        xbcBody_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBody_);
    }

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmStatement
     */
    public XbcGccAsmStatement createXbcGccAsmStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmStatement xbcGccAsmStatement_ = createXbcGccAsmStatement();
        xbcGccAsmStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmStatement_);
    }

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperands
     */
    public XbcGccAsmOperands createXbcGccAsmOperands(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmOperands xbcGccAsmOperands_ = createXbcGccAsmOperands();
        xbcGccAsmOperands_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmOperands_);
    }

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperand
     */
    public XbcGccAsmOperand createXbcGccAsmOperand(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmOperand xbcGccAsmOperand_ = createXbcGccAsmOperand();
        xbcGccAsmOperand_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmOperand_);
    }

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmClobbers
     */
    public XbcGccAsmClobbers createXbcGccAsmClobbers(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmClobbers xbcGccAsmClobbers_ = createXbcGccAsmClobbers();
        xbcGccAsmClobbers_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmClobbers_);
    }

    /**
     * Creates a <code>XbcForStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcForStatement
     */
    public XbcForStatement createXbcForStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcForStatement xbcForStatement_ = createXbcForStatement();
        xbcForStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcForStatement_);
    }

    /**
     * Creates a <code>XbcInit</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcInit
     */
    public XbcInit createXbcInit(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcInit xbcInit_ = createXbcInit();
        xbcInit_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcInit_);
    }

    /**
     * Creates a <code>XbcCondition</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondition
     */
    public XbcCondition createXbcCondition(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcCondition xbcCondition_ = createXbcCondition();
        xbcCondition_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCondition_);
    }

    /**
     * Creates a <code>XbcIter</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIter
     */
    public XbcIter createXbcIter(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcIter xbcIter_ = createXbcIter();
        xbcIter_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIter_);
    }

    /**
     * Creates a <code>XbcIfStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIfStatement
     */
    public XbcIfStatement createXbcIfStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcIfStatement xbcIfStatement_ = createXbcIfStatement();
        xbcIfStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIfStatement_);
    }

    /**
     * Creates a <code>XbcThen</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcThen
     */
    public XbcThen createXbcThen(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcThen xbcThen_ = createXbcThen();
        xbcThen_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcThen_);
    }

    /**
     * Creates a <code>XbcElse</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcElse
     */
    public XbcElse createXbcElse(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcElse xbcElse_ = createXbcElse();
        xbcElse_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcElse_);
    }

    /**
     * Creates a <code>XbcWhileStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcWhileStatement
     */
    public XbcWhileStatement createXbcWhileStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcWhileStatement xbcWhileStatement_ = createXbcWhileStatement();
        xbcWhileStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcWhileStatement_);
    }

    /**
     * Creates a <code>XbcDoStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDoStatement
     */
    public XbcDoStatement createXbcDoStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcDoStatement xbcDoStatement_ = createXbcDoStatement();
        xbcDoStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDoStatement_);
    }

    /**
     * Creates a <code>XbcSwitchStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSwitchStatement
     */
    public XbcSwitchStatement createXbcSwitchStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcSwitchStatement xbcSwitchStatement_ = createXbcSwitchStatement();
        xbcSwitchStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSwitchStatement_);
    }

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccRangedCaseLabel
     */
    public XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcGccRangedCaseLabel xbcGccRangedCaseLabel_ = createXbcGccRangedCaseLabel();
        xbcGccRangedCaseLabel_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccRangedCaseLabel_);
    }

    /**
     * Creates a <code>XbcStatementLabel</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStatementLabel
     */
    public XbcStatementLabel createXbcStatementLabel(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcStatementLabel xbcStatementLabel_ = createXbcStatementLabel();
        xbcStatementLabel_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStatementLabel_);
    }

    /**
     * Creates a <code>XbcCaseLabel</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCaseLabel
     */
    public XbcCaseLabel createXbcCaseLabel(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcCaseLabel xbcCaseLabel_ = createXbcCaseLabel();
        xbcCaseLabel_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCaseLabel_);
    }

    /**
     * Creates a <code>XbcBreakStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBreakStatement
     */
    public XbcBreakStatement createXbcBreakStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcBreakStatement xbcBreakStatement_ = createXbcBreakStatement();
        xbcBreakStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBreakStatement_);
    }

    /**
     * Creates a <code>XbcContinueStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcContinueStatement
     */
    public XbcContinueStatement createXbcContinueStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcContinueStatement xbcContinueStatement_ = createXbcContinueStatement();
        xbcContinueStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcContinueStatement_);
    }

    /**
     * Creates a <code>XbcReturnStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcReturnStatement
     */
    public XbcReturnStatement createXbcReturnStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcReturnStatement xbcReturnStatement_ = createXbcReturnStatement();
        xbcReturnStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcReturnStatement_);
    }

    /**
     * Creates a <code>XbcGotoStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGotoStatement
     */
    public XbcGotoStatement createXbcGotoStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcGotoStatement xbcGotoStatement_ = createXbcGotoStatement();
        xbcGotoStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGotoStatement_);
    }

    /**
     * Creates a <code>XbcDefaultLabel</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDefaultLabel
     */
    public XbcDefaultLabel createXbcDefaultLabel(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcDefaultLabel xbcDefaultLabel_ = createXbcDefaultLabel();
        xbcDefaultLabel_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDefaultLabel_);
    }

    /**
     * Creates a <code>XbcExprStatement</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcExprStatement
     */
    public XbcExprStatement createXbcExprStatement(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcExprStatement xbcExprStatement_ = createXbcExprStatement();
        xbcExprStatement_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcExprStatement_);
    }

    /**
     * Creates a <code>XbcVarDecl</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarDecl
     */
    public XbcVarDecl createXbcVarDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcVarDecl xbcVarDecl_ = createXbcVarDecl();
        xbcVarDecl_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVarDecl_);
    }

    /**
     * Creates a <code>XbcGccAsm</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsm
     */
    public XbcGccAsm createXbcGccAsm(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsm xbcGccAsm_ = createXbcGccAsm();
        xbcGccAsm_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsm_);
    }

    /**
     * Creates a <code>XbcFunctionDecl</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDecl
     */
    public XbcFunctionDecl createXbcFunctionDecl(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionDecl xbcFunctionDecl_ = createXbcFunctionDecl();
        xbcFunctionDecl_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionDecl_);
    }

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccMemberDesignator
     */
    public XbcGccMemberDesignator createXbcGccMemberDesignator(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcGccMemberDesignator xbcGccMemberDesignator_ = createXbcGccMemberDesignator();
        xbcGccMemberDesignator_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccMemberDesignator_);
    }

    /**
     * Creates a <code>XbcArrayType</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayType
     */
    public XbcArrayType createXbcArrayType(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayType xbcArrayType_ = createXbcArrayType();
        xbcArrayType_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayType_);
    }

    /**
     * Creates a <code>XbcArraySize</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArraySize
     */
    public XbcArraySize createXbcArraySize(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcArraySize xbcArraySize_ = createXbcArraySize();
        xbcArraySize_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArraySize_);
    }

    /**
     * Creates a <code>XbcBasicType</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBasicType
     */
    public XbcBasicType createXbcBasicType(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcBasicType xbcBasicType_ = createXbcBasicType();
        xbcBasicType_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBasicType_);
    }

    /**
     * Creates a <code>XbcPointerType</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerType
     */
    public XbcPointerType createXbcPointerType(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcPointerType xbcPointerType_ = createXbcPointerType();
        xbcPointerType_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPointerType_);
    }

    /**
     * Creates a <code>XbcStructType</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStructType
     */
    public XbcStructType createXbcStructType(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcStructType xbcStructType_ = createXbcStructType();
        xbcStructType_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStructType_);
    }

    /**
     * Creates a <code>XbcUnionType</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnionType
     */
    public XbcUnionType createXbcUnionType(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcUnionType xbcUnionType_ = createXbcUnionType();
        xbcUnionType_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUnionType_);
    }

    /**
     * Creates a <code>XbcEnumType</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcEnumType
     */
    public XbcEnumType createXbcEnumType(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcEnumType xbcEnumType_ = createXbcEnumType();
        xbcEnumType_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcEnumType_);
    }

    /**
     * Creates a <code>XbcCoArrayType</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayType
     */
    public XbcCoArrayType createXbcCoArrayType(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayType xbcCoArrayType_ = createXbcCoArrayType();
        xbcCoArrayType_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayType_);
    }

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalSymbols
     */
    public XbcGlobalSymbols createXbcGlobalSymbols(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcGlobalSymbols xbcGlobalSymbols_ = createXbcGlobalSymbols();
        xbcGlobalSymbols_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGlobalSymbols_);
    }

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalDeclarations
     */
    public XbcGlobalDeclarations createXbcGlobalDeclarations(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcGlobalDeclarations xbcGlobalDeclarations_ = createXbcGlobalDeclarations();
        xbcGlobalDeclarations_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the InputSource <code>is</code>.
     * This method is a template method for concrete classes.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmDefinition
     */
    public XbcGccAsmDefinition createXbcGccAsmDefinition(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmDefinition xbcGccAsmDefinition_ = createXbcGccAsmDefinition();
        xbcGccAsmDefinition_.setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmDefinition_);
    }

    /**
     * Creates a <code>XbcXcodeProgram</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXcodeProgram
     */
    public XbcXcodeProgram createXbcXcodeProgram(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcXcodeProgram xbcXcodeProgram_ = createXbcXcodeProgram();
        xbcXcodeProgram_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcXcodeProgram_);
    }

    /**
     * Creates a <code>XbcTypeTable</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeTable
     */
    public XbcTypeTable createXbcTypeTable(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcTypeTable xbcTypeTable_ = createXbcTypeTable();
        xbcTypeTable_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcTypeTable_);
    }

    /**
     * Creates a <code>XbcFunctionType</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionType
     */
    public XbcFunctionType createXbcFunctionType(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionType xbcFunctionType_ = createXbcFunctionType();
        xbcFunctionType_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionType_);
    }

    /**
     * Creates a <code>XbcGccAttributes</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttributes
     */
    public XbcGccAttributes createXbcGccAttributes(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAttributes xbcGccAttributes_ = createXbcGccAttributes();
        xbcGccAttributes_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAttributes_);
    }

    /**
     * Creates a <code>XbcGccAttribute</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAttribute
     */
    public XbcGccAttribute createXbcGccAttribute(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAttribute xbcGccAttribute_ = createXbcGccAttribute();
        xbcGccAttribute_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAttribute_);
    }

    /**
     * Creates a <code>XbcBuiltinOp</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBuiltinOp
     */
    public XbcBuiltinOp createXbcBuiltinOp(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcBuiltinOp xbcBuiltinOp_ = createXbcBuiltinOp();
        xbcBuiltinOp_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBuiltinOp_);
    }

    /**
     * Creates a <code>XbcArrayRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayRef
     */
    public XbcArrayRef createXbcArrayRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayRef xbcArrayRef_ = createXbcArrayRef();
        xbcArrayRef_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayRef_);
    }

    /**
     * Creates a <code>XbcArrayAddr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayAddr
     */
    public XbcArrayAddr createXbcArrayAddr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayAddr xbcArrayAddr_ = createXbcArrayAddr();
        xbcArrayAddr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayAddr_);
    }

    /**
     * Creates a <code>XbcFunctionCall</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionCall
     */
    public XbcFunctionCall createXbcFunctionCall(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionCall xbcFunctionCall_ = createXbcFunctionCall();
        xbcFunctionCall_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionCall_);
    }

    /**
     * Creates a <code>XbcFunction</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunction
     */
    public XbcFunction createXbcFunction(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcFunction xbcFunction_ = createXbcFunction();
        xbcFunction_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunction_);
    }

    /**
     * Creates a <code>XbcArguments</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArguments
     */
    public XbcArguments createXbcArguments(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcArguments xbcArguments_ = createXbcArguments();
        xbcArguments_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArguments_);
    }

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccCompoundExpr
     */
    public XbcGccCompoundExpr createXbcGccCompoundExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcGccCompoundExpr xbcGccCompoundExpr_ = createXbcGccCompoundExpr();
        xbcGccCompoundExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccCompoundExpr_);
    }

    /**
     * Creates a <code>XbcCompoundStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundStatement
     */
    public XbcCompoundStatement createXbcCompoundStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundStatement xbcCompoundStatement_ = createXbcCompoundStatement();
        xbcCompoundStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundStatement_);
    }

    /**
     * Creates a <code>XbcSymbols</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSymbols
     */
    public XbcSymbols createXbcSymbols(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcSymbols xbcSymbols_ = createXbcSymbols();
        xbcSymbols_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSymbols_);
    }

    /**
     * Creates a <code>XbcId</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcId
     */
    public XbcId createXbcId(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcId xbcId_ = createXbcId();
        xbcId_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcId_);
    }

    /**
     * Creates a <code>XbcName</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcName
     */
    public XbcName createXbcName(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcName xbcName_ = createXbcName();
        xbcName_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcName_);
    }

    /**
     * Creates a <code>XbcValue</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcValue
     */
    public XbcValue createXbcValue(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcValue xbcValue_ = createXbcValue();
        xbcValue_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcValue_);
    }

    /**
     * Creates a <code>XbcSubArrayRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSubArrayRef
     */
    public XbcSubArrayRef createXbcSubArrayRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcSubArrayRef xbcSubArrayRef_ = createXbcSubArrayRef();
        xbcSubArrayRef_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSubArrayRef_);
    }

    /**
     * Creates a <code>XbcCoArrayRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayRef
     */
    public XbcCoArrayRef createXbcCoArrayRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayRef xbcCoArrayRef_ = createXbcCoArrayRef();
        xbcCoArrayRef_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayRef_);
    }

    /**
     * Creates a <code>XbcVar</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVar
     */
    public XbcVar createXbcVar(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcVar xbcVar_ = createXbcVar();
        xbcVar_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVar_);
    }

    /**
     * Creates a <code>XbcMemberRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberRef
     */
    public XbcMemberRef createXbcMemberRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberRef xbcMemberRef_ = createXbcMemberRef();
        xbcMemberRef_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberRef_);
    }

    /**
     * Creates a <code>XbcCastExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCastExpr
     */
    public XbcCastExpr createXbcCastExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcCastExpr xbcCastExpr_ = createXbcCastExpr();
        xbcCastExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCastExpr_);
    }

    /**
     * Creates a <code>XbcStringConstant</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStringConstant
     */
    public XbcStringConstant createXbcStringConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcStringConstant xbcStringConstant_ = createXbcStringConstant();
        xbcStringConstant_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStringConstant_);
    }

    /**
     * Creates a <code>XbcVarAddr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarAddr
     */
    public XbcVarAddr createXbcVarAddr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcVarAddr xbcVarAddr_ = createXbcVarAddr();
        xbcVarAddr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVarAddr_);
    }

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueExpr
     */
    public XbcCompoundValueExpr createXbcCompoundValueExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValueExpr xbcCompoundValueExpr_ = createXbcCompoundValueExpr();
        xbcCompoundValueExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValueExpr_);
    }

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValueAddrExpr
     */
    public XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValueAddrExpr xbcCompoundValueAddrExpr_ = createXbcCompoundValueAddrExpr();
        xbcCompoundValueAddrExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValueAddrExpr_);
    }

    /**
     * Creates a <code>XbcXmpDescOf</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcXmpDescOf
     */
    public XbcXmpDescOf createXbcXmpDescOf(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcXmpDescOf xbcXmpDescOf_ = createXbcXmpDescOf();
        xbcXmpDescOf_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcXmpDescOf_);
    }

    /**
     * Creates a <code>XbcIntConstant</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIntConstant
     */
    public XbcIntConstant createXbcIntConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcIntConstant xbcIntConstant_ = createXbcIntConstant();
        xbcIntConstant_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIntConstant_);
    }

    /**
     * Creates a <code>XbcFloatConstant</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFloatConstant
     */
    public XbcFloatConstant createXbcFloatConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcFloatConstant xbcFloatConstant_ = createXbcFloatConstant();
        xbcFloatConstant_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFloatConstant_);
    }

    /**
     * Creates a <code>XbcLonglongConstant</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLonglongConstant
     */
    public XbcLonglongConstant createXbcLonglongConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcLonglongConstant xbcLonglongConstant_ = createXbcLonglongConstant();
        xbcLonglongConstant_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLonglongConstant_);
    }

    /**
     * Creates a <code>XbcMoeConstant</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMoeConstant
     */
    public XbcMoeConstant createXbcMoeConstant(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcMoeConstant xbcMoeConstant_ = createXbcMoeConstant();
        xbcMoeConstant_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMoeConstant_);
    }

    /**
     * Creates a <code>XbcFuncAddr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFuncAddr
     */
    public XbcFuncAddr createXbcFuncAddr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcFuncAddr xbcFuncAddr_ = createXbcFuncAddr();
        xbcFuncAddr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFuncAddr_);
    }

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSizeOfExpr
     */
    public XbcSizeOfExpr createXbcSizeOfExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcSizeOfExpr xbcSizeOfExpr_ = createXbcSizeOfExpr();
        xbcSizeOfExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSizeOfExpr_);
    }

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayAssignExpr
     */
    public XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayAssignExpr xbcCoArrayAssignExpr_ = createXbcCoArrayAssignExpr();
        xbcCoArrayAssignExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayAssignExpr_);
    }

    /**
     * Creates a <code>XbcModExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcModExpr
     */
    public XbcModExpr createXbcModExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcModExpr xbcModExpr_ = createXbcModExpr();
        xbcModExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcModExpr_);
    }

    /**
     * Creates a <code>XbcBitOrExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitOrExpr
     */
    public XbcBitOrExpr createXbcBitOrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcBitOrExpr xbcBitOrExpr_ = createXbcBitOrExpr();
        xbcBitOrExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogOrExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogOrExpr
     */
    public XbcLogOrExpr createXbcLogOrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcLogOrExpr xbcLogOrExpr_ = createXbcLogOrExpr();
        xbcLogOrExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogOrExpr_);
    }

    /**
     * Creates a <code>XbcPlusExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPlusExpr
     */
    public XbcPlusExpr createXbcPlusExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcPlusExpr xbcPlusExpr_ = createXbcPlusExpr();
        xbcPlusExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgPlusExpr
     */
    public XbcAsgPlusExpr createXbcAsgPlusExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgPlusExpr xbcAsgPlusExpr_ = createXbcAsgPlusExpr();
        xbcAsgPlusExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgModExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgModExpr
     */
    public XbcAsgModExpr createXbcAsgModExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgModExpr xbcAsgModExpr_ = createXbcAsgModExpr();
        xbcAsgModExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgModExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitOrExpr
     */
    public XbcAsgBitOrExpr createXbcAsgBitOrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitOrExpr xbcAsgBitOrExpr_ = createXbcAsgBitOrExpr();
        xbcAsgBitOrExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogGTExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGTExpr
     */
    public XbcLogGTExpr createXbcLogGTExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcLogGTExpr xbcLogGTExpr_ = createXbcLogGTExpr();
        xbcLogGTExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogGTExpr_);
    }

    /**
     * Creates a <code>XbcCondExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondExpr
     */
    public XbcCondExpr createXbcCondExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcCondExpr xbcCondExpr_ = createXbcCondExpr();
        xbcCondExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCondExpr_);
    }

    /**
     * Creates a <code>XbcMinusExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMinusExpr
     */
    public XbcMinusExpr createXbcMinusExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcMinusExpr xbcMinusExpr_ = createXbcMinusExpr();
        xbcMinusExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMinusExpr_);
    }

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAddrOfExpr
     */
    public XbcAddrOfExpr createXbcAddrOfExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcAddrOfExpr xbcAddrOfExpr_ = createXbcAddrOfExpr();
        xbcAddrOfExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAddrOfExpr_);
    }

    /**
     * Creates a <code>XbcLshiftExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLshiftExpr
     */
    public XbcLshiftExpr createXbcLshiftExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcLshiftExpr xbcLshiftExpr_ = createXbcLshiftExpr();
        xbcLshiftExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLshiftExpr_);
    }

    /**
     * Creates a <code>XbcRshiftExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcRshiftExpr
     */
    public XbcRshiftExpr createXbcRshiftExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcRshiftExpr xbcRshiftExpr_ = createXbcRshiftExpr();
        xbcRshiftExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitXorExpr
     */
    public XbcAsgBitXorExpr createXbcAsgBitXorExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitXorExpr xbcAsgBitXorExpr_ = createXbcAsgBitXorExpr();
        xbcAsgBitXorExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitXorExpr_);
    }

    /**
     * Creates a <code>XbcLogEQExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogEQExpr
     */
    public XbcLogEQExpr createXbcLogEQExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcLogEQExpr xbcLogEQExpr_ = createXbcLogEQExpr();
        xbcLogEQExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogEQExpr_);
    }

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNEQExpr
     */
    public XbcLogNEQExpr createXbcLogNEQExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcLogNEQExpr xbcLogNEQExpr_ = createXbcLogNEQExpr();
        xbcLogNEQExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogNEQExpr_);
    }

    /**
     * Creates a <code>XbcLogGEExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogGEExpr
     */
    public XbcLogGEExpr createXbcLogGEExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcLogGEExpr xbcLogGEExpr_ = createXbcLogGEExpr();
        xbcLogGEExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogGEExpr_);
    }

    /**
     * Creates a <code>XbcLogLTExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLTExpr
     */
    public XbcLogLTExpr createXbcLogLTExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcLogLTExpr xbcLogLTExpr_ = createXbcLogLTExpr();
        xbcLogLTExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogLTExpr_);
    }

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAlignOfExpr
     */
    public XbcGccAlignOfExpr createXbcGccAlignOfExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAlignOfExpr xbcGccAlignOfExpr_ = createXbcGccAlignOfExpr();
        xbcGccAlignOfExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAlignOfExpr_);
    }

    /**
     * Creates a <code>XbcAssignExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAssignExpr
     */
    public XbcAssignExpr createXbcAssignExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcAssignExpr xbcAssignExpr_ = createXbcAssignExpr();
        xbcAssignExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAssignExpr_);
    }

    /**
     * Creates a <code>XbcMulExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMulExpr
     */
    public XbcMulExpr createXbcMulExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcMulExpr xbcMulExpr_ = createXbcMulExpr();
        xbcMulExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMulExpr_);
    }

    /**
     * Creates a <code>XbcDivExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDivExpr
     */
    public XbcDivExpr createXbcDivExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcDivExpr xbcDivExpr_ = createXbcDivExpr();
        xbcDivExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDivExpr_);
    }

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMulExpr
     */
    public XbcAsgMulExpr createXbcAsgMulExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgMulExpr xbcAsgMulExpr_ = createXbcAsgMulExpr();
        xbcAsgMulExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgMulExpr_);
    }

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgRshiftExpr
     */
    public XbcAsgRshiftExpr createXbcAsgRshiftExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgRshiftExpr xbcAsgRshiftExpr_ = createXbcAsgRshiftExpr();
        xbcAsgRshiftExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgBitAndExpr
     */
    public XbcAsgBitAndExpr createXbcAsgBitAndExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgBitAndExpr xbcAsgBitAndExpr_ = createXbcAsgBitAndExpr();
        xbcAsgBitAndExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgBitAndExpr_);
    }

    /**
     * Creates a <code>XbcLogLEExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogLEExpr
     */
    public XbcLogLEExpr createXbcLogLEExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcLogLEExpr xbcLogLEExpr_ = createXbcLogLEExpr();
        xbcLogLEExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogLEExpr_);
    }

    /**
     * Creates a <code>XbcLogAndExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogAndExpr
     */
    public XbcLogAndExpr createXbcLogAndExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcLogAndExpr xbcLogAndExpr_ = createXbcLogAndExpr();
        xbcLogAndExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogAndExpr_);
    }

    /**
     * Creates a <code>XbcCommaExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCommaExpr
     */
    public XbcCommaExpr createXbcCommaExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcCommaExpr xbcCommaExpr_ = createXbcCommaExpr();
        xbcCommaExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCommaExpr_);
    }

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgDivExpr
     */
    public XbcAsgDivExpr createXbcAsgDivExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgDivExpr xbcAsgDivExpr_ = createXbcAsgDivExpr();
        xbcAsgDivExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgDivExpr_);
    }

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccLabelAddr
     */
    public XbcGccLabelAddr createXbcGccLabelAddr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcGccLabelAddr xbcGccLabelAddr_ = createXbcGccLabelAddr();
        xbcGccLabelAddr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccLabelAddr_);
    }

    /**
     * Creates a <code>XbcBitAndExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitAndExpr
     */
    public XbcBitAndExpr createXbcBitAndExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcBitAndExpr xbcBitAndExpr_ = createXbcBitAndExpr();
        xbcBitAndExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitAndExpr_);
    }

    /**
     * Creates a <code>XbcBitXorExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitXorExpr
     */
    public XbcBitXorExpr createXbcBitXorExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcBitXorExpr xbcBitXorExpr_ = createXbcBitXorExpr();
        xbcBitXorExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitXorExpr_);
    }

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgMinusExpr
     */
    public XbcAsgMinusExpr createXbcAsgMinusExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgMinusExpr xbcAsgMinusExpr_ = createXbcAsgMinusExpr();
        xbcAsgMinusExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgMinusExpr_);
    }

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcAsgLshiftExpr
     */
    public XbcAsgLshiftExpr createXbcAsgLshiftExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcAsgLshiftExpr xbcAsgLshiftExpr_ = createXbcAsgLshiftExpr();
        xbcAsgLshiftExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcAsgLshiftExpr_);
    }

    /**
     * Creates a <code>XbcMemberAddr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberAddr
     */
    public XbcMemberAddr createXbcMemberAddr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberAddr xbcMemberAddr_ = createXbcMemberAddr();
        xbcMemberAddr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberAddr_);
    }

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayRef
     */
    public XbcMemberArrayRef createXbcMemberArrayRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberArrayRef xbcMemberArrayRef_ = createXbcMemberArrayRef();
        xbcMemberArrayRef_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberArrayRef_);
    }

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcMemberArrayAddr
     */
    public XbcMemberArrayAddr createXbcMemberArrayAddr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcMemberArrayAddr xbcMemberArrayAddr_ = createXbcMemberArrayAddr();
        xbcMemberArrayAddr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcMemberArrayAddr_);
    }

    /**
     * Creates a <code>XbcTypeName</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcTypeName
     */
    public XbcTypeName createXbcTypeName(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcTypeName xbcTypeName_ = createXbcTypeName();
        xbcTypeName_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcTypeName_);
    }

    /**
     * Creates a <code>XbcPointerRef</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerRef
     */
    public XbcPointerRef createXbcPointerRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcPointerRef xbcPointerRef_ = createXbcPointerRef();
        xbcPointerRef_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPointerRef_);
    }

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnaryMinusExpr
     */
    public XbcUnaryMinusExpr createXbcUnaryMinusExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcUnaryMinusExpr xbcUnaryMinusExpr_ = createXbcUnaryMinusExpr();
        xbcUnaryMinusExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbcBitNotExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitNotExpr
     */
    public XbcBitNotExpr createXbcBitNotExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcBitNotExpr xbcBitNotExpr_ = createXbcBitNotExpr();
        xbcBitNotExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitNotExpr_);
    }

    /**
     * Creates a <code>XbcLogNotExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLogNotExpr
     */
    public XbcLogNotExpr createXbcLogNotExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcLogNotExpr xbcLogNotExpr_ = createXbcLogNotExpr();
        xbcLogNotExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLogNotExpr_);
    }

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostIncrExpr
     */
    public XbcPostIncrExpr createXbcPostIncrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcPostIncrExpr xbcPostIncrExpr_ = createXbcPostIncrExpr();
        xbcPostIncrExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPostIncrExpr_);
    }

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPostDecrExpr
     */
    public XbcPostDecrExpr createXbcPostDecrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcPostDecrExpr xbcPostDecrExpr_ = createXbcPostDecrExpr();
        xbcPostDecrExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPostDecrExpr_);
    }

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreIncrExpr
     */
    public XbcPreIncrExpr createXbcPreIncrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcPreIncrExpr xbcPreIncrExpr_ = createXbcPreIncrExpr();
        xbcPreIncrExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPreIncrExpr_);
    }

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPreDecrExpr
     */
    public XbcPreDecrExpr createXbcPreDecrExpr(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcPreDecrExpr xbcPreDecrExpr_ = createXbcPreDecrExpr();
        xbcPreDecrExpr_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPreDecrExpr_);
    }

    /**
     * Creates a <code>XbcIndexRange</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIndexRange
     */
    public XbcIndexRange createXbcIndexRange(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcIndexRange xbcIndexRange_ = createXbcIndexRange();
        xbcIndexRange_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIndexRange_);
    }

    /**
     * Creates a <code>XbcLowerBound</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcLowerBound
     */
    public XbcLowerBound createXbcLowerBound(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcLowerBound xbcLowerBound_ = createXbcLowerBound();
        xbcLowerBound_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcLowerBound_);
    }

    /**
     * Creates a <code>XbcUpperBound</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUpperBound
     */
    public XbcUpperBound createXbcUpperBound(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcUpperBound xbcUpperBound_ = createXbcUpperBound();
        xbcUpperBound_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUpperBound_);
    }

    /**
     * Creates a <code>XbcStep</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStep
     */
    public XbcStep createXbcStep(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcStep xbcStep_ = createXbcStep();
        xbcStep_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStep_);
    }

    /**
     * Creates a <code>XbcDesignatedValue</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDesignatedValue
     */
    public XbcDesignatedValue createXbcDesignatedValue(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcDesignatedValue xbcDesignatedValue_ = createXbcDesignatedValue();
        xbcDesignatedValue_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDesignatedValue_);
    }

    /**
     * Creates a <code>XbcCompoundValue</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCompoundValue
     */
    public XbcCompoundValue createXbcCompoundValue(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcCompoundValue xbcCompoundValue_ = createXbcCompoundValue();
        xbcCompoundValue_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCompoundValue_);
    }

    /**
     * Creates a <code>XbcBitField</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBitField
     */
    public XbcBitField createXbcBitField(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcBitField xbcBitField_ = createXbcBitField();
        xbcBitField_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBitField_);
    }

    /**
     * Creates a <code>XbcPragma</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPragma
     */
    public XbcPragma createXbcPragma(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcPragma xbcPragma_ = createXbcPragma();
        xbcPragma_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPragma_);
    }

    /**
     * Creates a <code>XbcText</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcText
     */
    public XbcText createXbcText(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcText xbcText_ = createXbcText();
        xbcText_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcText_);
    }

    /**
     * Creates a <code>XbcDeclarations</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDeclarations
     */
    public XbcDeclarations createXbcDeclarations(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcDeclarations xbcDeclarations_ = createXbcDeclarations();
        xbcDeclarations_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDeclarations_);
    }

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDefinition
     */
    public XbcFunctionDefinition createXbcFunctionDefinition(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionDefinition xbcFunctionDefinition_ = createXbcFunctionDefinition();
        xbcFunctionDefinition_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionDefinition_);
    }

    /**
     * Creates a <code>XbcParams</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcParams
     */
    public XbcParams createXbcParams(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcParams xbcParams_ = createXbcParams();
        xbcParams_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcParams_);
    }

    /**
     * Creates a <code>XbcBody</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBody
     */
    public XbcBody createXbcBody(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcBody xbcBody_ = createXbcBody();
        xbcBody_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBody_);
    }

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmStatement
     */
    public XbcGccAsmStatement createXbcGccAsmStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmStatement xbcGccAsmStatement_ = createXbcGccAsmStatement();
        xbcGccAsmStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmStatement_);
    }

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperands
     */
    public XbcGccAsmOperands createXbcGccAsmOperands(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmOperands xbcGccAsmOperands_ = createXbcGccAsmOperands();
        xbcGccAsmOperands_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmOperands_);
    }

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmOperand
     */
    public XbcGccAsmOperand createXbcGccAsmOperand(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmOperand xbcGccAsmOperand_ = createXbcGccAsmOperand();
        xbcGccAsmOperand_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmOperand_);
    }

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmClobbers
     */
    public XbcGccAsmClobbers createXbcGccAsmClobbers(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmClobbers xbcGccAsmClobbers_ = createXbcGccAsmClobbers();
        xbcGccAsmClobbers_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmClobbers_);
    }

    /**
     * Creates a <code>XbcForStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcForStatement
     */
    public XbcForStatement createXbcForStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcForStatement xbcForStatement_ = createXbcForStatement();
        xbcForStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcForStatement_);
    }

    /**
     * Creates a <code>XbcInit</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcInit
     */
    public XbcInit createXbcInit(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcInit xbcInit_ = createXbcInit();
        xbcInit_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcInit_);
    }

    /**
     * Creates a <code>XbcCondition</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCondition
     */
    public XbcCondition createXbcCondition(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcCondition xbcCondition_ = createXbcCondition();
        xbcCondition_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCondition_);
    }

    /**
     * Creates a <code>XbcIter</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIter
     */
    public XbcIter createXbcIter(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcIter xbcIter_ = createXbcIter();
        xbcIter_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIter_);
    }

    /**
     * Creates a <code>XbcIfStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcIfStatement
     */
    public XbcIfStatement createXbcIfStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcIfStatement xbcIfStatement_ = createXbcIfStatement();
        xbcIfStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcIfStatement_);
    }

    /**
     * Creates a <code>XbcThen</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcThen
     */
    public XbcThen createXbcThen(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcThen xbcThen_ = createXbcThen();
        xbcThen_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcThen_);
    }

    /**
     * Creates a <code>XbcElse</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcElse
     */
    public XbcElse createXbcElse(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcElse xbcElse_ = createXbcElse();
        xbcElse_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcElse_);
    }

    /**
     * Creates a <code>XbcWhileStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcWhileStatement
     */
    public XbcWhileStatement createXbcWhileStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcWhileStatement xbcWhileStatement_ = createXbcWhileStatement();
        xbcWhileStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcWhileStatement_);
    }

    /**
     * Creates a <code>XbcDoStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDoStatement
     */
    public XbcDoStatement createXbcDoStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcDoStatement xbcDoStatement_ = createXbcDoStatement();
        xbcDoStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDoStatement_);
    }

    /**
     * Creates a <code>XbcSwitchStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcSwitchStatement
     */
    public XbcSwitchStatement createXbcSwitchStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcSwitchStatement xbcSwitchStatement_ = createXbcSwitchStatement();
        xbcSwitchStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcSwitchStatement_);
    }

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccRangedCaseLabel
     */
    public XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcGccRangedCaseLabel xbcGccRangedCaseLabel_ = createXbcGccRangedCaseLabel();
        xbcGccRangedCaseLabel_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccRangedCaseLabel_);
    }

    /**
     * Creates a <code>XbcStatementLabel</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStatementLabel
     */
    public XbcStatementLabel createXbcStatementLabel(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcStatementLabel xbcStatementLabel_ = createXbcStatementLabel();
        xbcStatementLabel_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStatementLabel_);
    }

    /**
     * Creates a <code>XbcCaseLabel</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCaseLabel
     */
    public XbcCaseLabel createXbcCaseLabel(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcCaseLabel xbcCaseLabel_ = createXbcCaseLabel();
        xbcCaseLabel_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCaseLabel_);
    }

    /**
     * Creates a <code>XbcBreakStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBreakStatement
     */
    public XbcBreakStatement createXbcBreakStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcBreakStatement xbcBreakStatement_ = createXbcBreakStatement();
        xbcBreakStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBreakStatement_);
    }

    /**
     * Creates a <code>XbcContinueStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcContinueStatement
     */
    public XbcContinueStatement createXbcContinueStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcContinueStatement xbcContinueStatement_ = createXbcContinueStatement();
        xbcContinueStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcContinueStatement_);
    }

    /**
     * Creates a <code>XbcReturnStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcReturnStatement
     */
    public XbcReturnStatement createXbcReturnStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcReturnStatement xbcReturnStatement_ = createXbcReturnStatement();
        xbcReturnStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcReturnStatement_);
    }

    /**
     * Creates a <code>XbcGotoStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGotoStatement
     */
    public XbcGotoStatement createXbcGotoStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcGotoStatement xbcGotoStatement_ = createXbcGotoStatement();
        xbcGotoStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGotoStatement_);
    }

    /**
     * Creates a <code>XbcDefaultLabel</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcDefaultLabel
     */
    public XbcDefaultLabel createXbcDefaultLabel(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcDefaultLabel xbcDefaultLabel_ = createXbcDefaultLabel();
        xbcDefaultLabel_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcDefaultLabel_);
    }

    /**
     * Creates a <code>XbcExprStatement</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcExprStatement
     */
    public XbcExprStatement createXbcExprStatement(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcExprStatement xbcExprStatement_ = createXbcExprStatement();
        xbcExprStatement_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcExprStatement_);
    }

    /**
     * Creates a <code>XbcVarDecl</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcVarDecl
     */
    public XbcVarDecl createXbcVarDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcVarDecl xbcVarDecl_ = createXbcVarDecl();
        xbcVarDecl_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcVarDecl_);
    }

    /**
     * Creates a <code>XbcGccAsm</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsm
     */
    public XbcGccAsm createXbcGccAsm(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsm xbcGccAsm_ = createXbcGccAsm();
        xbcGccAsm_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsm_);
    }

    /**
     * Creates a <code>XbcFunctionDecl</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcFunctionDecl
     */
    public XbcFunctionDecl createXbcFunctionDecl(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcFunctionDecl xbcFunctionDecl_ = createXbcFunctionDecl();
        xbcFunctionDecl_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcFunctionDecl_);
    }

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccMemberDesignator
     */
    public XbcGccMemberDesignator createXbcGccMemberDesignator(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcGccMemberDesignator xbcGccMemberDesignator_ = createXbcGccMemberDesignator();
        xbcGccMemberDesignator_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccMemberDesignator_);
    }

    /**
     * Creates a <code>XbcArrayType</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArrayType
     */
    public XbcArrayType createXbcArrayType(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcArrayType xbcArrayType_ = createXbcArrayType();
        xbcArrayType_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArrayType_);
    }

    /**
     * Creates a <code>XbcArraySize</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcArraySize
     */
    public XbcArraySize createXbcArraySize(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcArraySize xbcArraySize_ = createXbcArraySize();
        xbcArraySize_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcArraySize_);
    }

    /**
     * Creates a <code>XbcBasicType</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcBasicType
     */
    public XbcBasicType createXbcBasicType(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcBasicType xbcBasicType_ = createXbcBasicType();
        xbcBasicType_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcBasicType_);
    }

    /**
     * Creates a <code>XbcPointerType</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcPointerType
     */
    public XbcPointerType createXbcPointerType(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcPointerType xbcPointerType_ = createXbcPointerType();
        xbcPointerType_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcPointerType_);
    }

    /**
     * Creates a <code>XbcStructType</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcStructType
     */
    public XbcStructType createXbcStructType(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcStructType xbcStructType_ = createXbcStructType();
        xbcStructType_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcStructType_);
    }

    /**
     * Creates a <code>XbcUnionType</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcUnionType
     */
    public XbcUnionType createXbcUnionType(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcUnionType xbcUnionType_ = createXbcUnionType();
        xbcUnionType_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcUnionType_);
    }

    /**
     * Creates a <code>XbcEnumType</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcEnumType
     */
    public XbcEnumType createXbcEnumType(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcEnumType xbcEnumType_ = createXbcEnumType();
        xbcEnumType_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcEnumType_);
    }

    /**
     * Creates a <code>XbcCoArrayType</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcCoArrayType
     */
    public XbcCoArrayType createXbcCoArrayType(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcCoArrayType xbcCoArrayType_ = createXbcCoArrayType();
        xbcCoArrayType_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcCoArrayType_);
    }

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalSymbols
     */
    public XbcGlobalSymbols createXbcGlobalSymbols(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcGlobalSymbols xbcGlobalSymbols_ = createXbcGlobalSymbols();
        xbcGlobalSymbols_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGlobalSymbols_);
    }

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGlobalDeclarations
     */
    public XbcGlobalDeclarations createXbcGlobalDeclarations(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcGlobalDeclarations xbcGlobalDeclarations_ = createXbcGlobalDeclarations();
        xbcGlobalDeclarations_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the Reader <code>reader</code>.
     * This method is a template method for concrete classes.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     * @return XbcGccAsmDefinition
     */
    public XbcGccAsmDefinition createXbcGccAsmDefinition(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        XbcGccAsmDefinition xbcGccAsmDefinition_ = createXbcGccAsmDefinition();
        xbcGccAsmDefinition_.setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE, errorHandler, entityResolver));
        return (xbcGccAsmDefinition_);
    }

    /**
     * Creates a <code>XbcXcodeProgram</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcXcodeProgram
     */
    public XbcXcodeProgram createXbcXcodeProgram(XbcXcodeProgram source) {
        XbcXcodeProgram xbcXcodeProgram_ = createXbcXcodeProgram();
        xbcXcodeProgram_.setup(source);
        return (xbcXcodeProgram_);
    }

    /**
     * Creates a <code>XbcTypeTable</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcTypeTable
     */
    public XbcTypeTable createXbcTypeTable(XbcTypeTable source) {
        XbcTypeTable xbcTypeTable_ = createXbcTypeTable();
        xbcTypeTable_.setup(source);
        return (xbcTypeTable_);
    }

    /**
     * Creates a <code>XbcFunctionType</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcFunctionType
     */
    public XbcFunctionType createXbcFunctionType(XbcFunctionType source) {
        XbcFunctionType xbcFunctionType_ = createXbcFunctionType();
        xbcFunctionType_.setup(source);
        return (xbcFunctionType_);
    }

    /**
     * Creates a <code>XbcGccAttributes</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcGccAttributes
     */
    public XbcGccAttributes createXbcGccAttributes(XbcGccAttributes source) {
        XbcGccAttributes xbcGccAttributes_ = createXbcGccAttributes();
        xbcGccAttributes_.setup(source);
        return (xbcGccAttributes_);
    }

    /**
     * Creates a <code>XbcGccAttribute</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcGccAttribute
     */
    public XbcGccAttribute createXbcGccAttribute(XbcGccAttribute source) {
        XbcGccAttribute xbcGccAttribute_ = createXbcGccAttribute();
        xbcGccAttribute_.setup(source);
        return (xbcGccAttribute_);
    }

    /**
     * Creates a <code>XbcBuiltinOp</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcBuiltinOp
     */
    public XbcBuiltinOp createXbcBuiltinOp(XbcBuiltinOp source) {
        XbcBuiltinOp xbcBuiltinOp_ = createXbcBuiltinOp();
        xbcBuiltinOp_.setup(source);
        return (xbcBuiltinOp_);
    }

    /**
     * Creates a <code>XbcArrayRef</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcArrayRef
     */
    public XbcArrayRef createXbcArrayRef(XbcArrayRef source) {
        XbcArrayRef xbcArrayRef_ = createXbcArrayRef();
        xbcArrayRef_.setup(source);
        return (xbcArrayRef_);
    }

    /**
     * Creates a <code>XbcArrayAddr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcArrayAddr
     */
    public XbcArrayAddr createXbcArrayAddr(XbcArrayAddr source) {
        XbcArrayAddr xbcArrayAddr_ = createXbcArrayAddr();
        xbcArrayAddr_.setup(source);
        return (xbcArrayAddr_);
    }

    /**
     * Creates a <code>XbcFunctionCall</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcFunctionCall
     */
    public XbcFunctionCall createXbcFunctionCall(XbcFunctionCall source) {
        XbcFunctionCall xbcFunctionCall_ = createXbcFunctionCall();
        xbcFunctionCall_.setup(source);
        return (xbcFunctionCall_);
    }

    /**
     * Creates a <code>XbcFunction</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcFunction
     */
    public XbcFunction createXbcFunction(XbcFunction source) {
        XbcFunction xbcFunction_ = createXbcFunction();
        xbcFunction_.setup(source);
        return (xbcFunction_);
    }

    /**
     * Creates a <code>XbcArguments</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcArguments
     */
    public XbcArguments createXbcArguments(XbcArguments source) {
        XbcArguments xbcArguments_ = createXbcArguments();
        xbcArguments_.setup(source);
        return (xbcArguments_);
    }

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcGccCompoundExpr
     */
    public XbcGccCompoundExpr createXbcGccCompoundExpr(XbcGccCompoundExpr source) {
        XbcGccCompoundExpr xbcGccCompoundExpr_ = createXbcGccCompoundExpr();
        xbcGccCompoundExpr_.setup(source);
        return (xbcGccCompoundExpr_);
    }

    /**
     * Creates a <code>XbcCompoundStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcCompoundStatement
     */
    public XbcCompoundStatement createXbcCompoundStatement(XbcCompoundStatement source) {
        XbcCompoundStatement xbcCompoundStatement_ = createXbcCompoundStatement();
        xbcCompoundStatement_.setup(source);
        return (xbcCompoundStatement_);
    }

    /**
     * Creates a <code>XbcSymbols</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcSymbols
     */
    public XbcSymbols createXbcSymbols(XbcSymbols source) {
        XbcSymbols xbcSymbols_ = createXbcSymbols();
        xbcSymbols_.setup(source);
        return (xbcSymbols_);
    }

    /**
     * Creates a <code>XbcId</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcId
     */
    public XbcId createXbcId(XbcId source) {
        XbcId xbcId_ = createXbcId();
        xbcId_.setup(source);
        return (xbcId_);
    }

    /**
     * Creates a <code>XbcName</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcName
     */
    public XbcName createXbcName(XbcName source) {
        XbcName xbcName_ = createXbcName();
        xbcName_.setup(source);
        return (xbcName_);
    }

    /**
     * Creates a <code>XbcValue</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcValue
     */
    public XbcValue createXbcValue(XbcValue source) {
        XbcValue xbcValue_ = createXbcValue();
        xbcValue_.setup(source);
        return (xbcValue_);
    }

    /**
     * Creates a <code>XbcSubArrayRef</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcSubArrayRef
     */
    public XbcSubArrayRef createXbcSubArrayRef(XbcSubArrayRef source) {
        XbcSubArrayRef xbcSubArrayRef_ = createXbcSubArrayRef();
        xbcSubArrayRef_.setup(source);
        return (xbcSubArrayRef_);
    }

    /**
     * Creates a <code>XbcCoArrayRef</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcCoArrayRef
     */
    public XbcCoArrayRef createXbcCoArrayRef(XbcCoArrayRef source) {
        XbcCoArrayRef xbcCoArrayRef_ = createXbcCoArrayRef();
        xbcCoArrayRef_.setup(source);
        return (xbcCoArrayRef_);
    }

    /**
     * Creates a <code>XbcVar</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcVar
     */
    public XbcVar createXbcVar(XbcVar source) {
        XbcVar xbcVar_ = createXbcVar();
        xbcVar_.setup(source);
        return (xbcVar_);
    }

    /**
     * Creates a <code>XbcMemberRef</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcMemberRef
     */
    public XbcMemberRef createXbcMemberRef(XbcMemberRef source) {
        XbcMemberRef xbcMemberRef_ = createXbcMemberRef();
        xbcMemberRef_.setup(source);
        return (xbcMemberRef_);
    }

    /**
     * Creates a <code>XbcCastExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcCastExpr
     */
    public XbcCastExpr createXbcCastExpr(XbcCastExpr source) {
        XbcCastExpr xbcCastExpr_ = createXbcCastExpr();
        xbcCastExpr_.setup(source);
        return (xbcCastExpr_);
    }

    /**
     * Creates a <code>XbcStringConstant</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcStringConstant
     */
    public XbcStringConstant createXbcStringConstant(XbcStringConstant source) {
        XbcStringConstant xbcStringConstant_ = createXbcStringConstant();
        xbcStringConstant_.setup(source);
        return (xbcStringConstant_);
    }

    /**
     * Creates a <code>XbcVarAddr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcVarAddr
     */
    public XbcVarAddr createXbcVarAddr(XbcVarAddr source) {
        XbcVarAddr xbcVarAddr_ = createXbcVarAddr();
        xbcVarAddr_.setup(source);
        return (xbcVarAddr_);
    }

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcCompoundValueExpr
     */
    public XbcCompoundValueExpr createXbcCompoundValueExpr(XbcCompoundValueExpr source) {
        XbcCompoundValueExpr xbcCompoundValueExpr_ = createXbcCompoundValueExpr();
        xbcCompoundValueExpr_.setup(source);
        return (xbcCompoundValueExpr_);
    }

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcCompoundValueAddrExpr
     */
    public XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(XbcCompoundValueAddrExpr source) {
        XbcCompoundValueAddrExpr xbcCompoundValueAddrExpr_ = createXbcCompoundValueAddrExpr();
        xbcCompoundValueAddrExpr_.setup(source);
        return (xbcCompoundValueAddrExpr_);
    }

    /**
     * Creates a <code>XbcXmpDescOf</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcXmpDescOf
     */
    public XbcXmpDescOf createXbcXmpDescOf(XbcXmpDescOf source) {
        XbcXmpDescOf xbcXmpDescOf_ = createXbcXmpDescOf();
        xbcXmpDescOf_.setup(source);
        return (xbcXmpDescOf_);
    }

    /**
     * Creates a <code>XbcIntConstant</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcIntConstant
     */
    public XbcIntConstant createXbcIntConstant(XbcIntConstant source) {
        XbcIntConstant xbcIntConstant_ = createXbcIntConstant();
        xbcIntConstant_.setup(source);
        return (xbcIntConstant_);
    }

    /**
     * Creates a <code>XbcFloatConstant</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcFloatConstant
     */
    public XbcFloatConstant createXbcFloatConstant(XbcFloatConstant source) {
        XbcFloatConstant xbcFloatConstant_ = createXbcFloatConstant();
        xbcFloatConstant_.setup(source);
        return (xbcFloatConstant_);
    }

    /**
     * Creates a <code>XbcLonglongConstant</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcLonglongConstant
     */
    public XbcLonglongConstant createXbcLonglongConstant(XbcLonglongConstant source) {
        XbcLonglongConstant xbcLonglongConstant_ = createXbcLonglongConstant();
        xbcLonglongConstant_.setup(source);
        return (xbcLonglongConstant_);
    }

    /**
     * Creates a <code>XbcMoeConstant</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcMoeConstant
     */
    public XbcMoeConstant createXbcMoeConstant(XbcMoeConstant source) {
        XbcMoeConstant xbcMoeConstant_ = createXbcMoeConstant();
        xbcMoeConstant_.setup(source);
        return (xbcMoeConstant_);
    }

    /**
     * Creates a <code>XbcFuncAddr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcFuncAddr
     */
    public XbcFuncAddr createXbcFuncAddr(XbcFuncAddr source) {
        XbcFuncAddr xbcFuncAddr_ = createXbcFuncAddr();
        xbcFuncAddr_.setup(source);
        return (xbcFuncAddr_);
    }

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcSizeOfExpr
     */
    public XbcSizeOfExpr createXbcSizeOfExpr(XbcSizeOfExpr source) {
        XbcSizeOfExpr xbcSizeOfExpr_ = createXbcSizeOfExpr();
        xbcSizeOfExpr_.setup(source);
        return (xbcSizeOfExpr_);
    }

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcCoArrayAssignExpr
     */
    public XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(XbcCoArrayAssignExpr source) {
        XbcCoArrayAssignExpr xbcCoArrayAssignExpr_ = createXbcCoArrayAssignExpr();
        xbcCoArrayAssignExpr_.setup(source);
        return (xbcCoArrayAssignExpr_);
    }

    /**
     * Creates a <code>XbcModExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcModExpr
     */
    public XbcModExpr createXbcModExpr(XbcModExpr source) {
        XbcModExpr xbcModExpr_ = createXbcModExpr();
        xbcModExpr_.setup(source);
        return (xbcModExpr_);
    }

    /**
     * Creates a <code>XbcBitOrExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcBitOrExpr
     */
    public XbcBitOrExpr createXbcBitOrExpr(XbcBitOrExpr source) {
        XbcBitOrExpr xbcBitOrExpr_ = createXbcBitOrExpr();
        xbcBitOrExpr_.setup(source);
        return (xbcBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogOrExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcLogOrExpr
     */
    public XbcLogOrExpr createXbcLogOrExpr(XbcLogOrExpr source) {
        XbcLogOrExpr xbcLogOrExpr_ = createXbcLogOrExpr();
        xbcLogOrExpr_.setup(source);
        return (xbcLogOrExpr_);
    }

    /**
     * Creates a <code>XbcPlusExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcPlusExpr
     */
    public XbcPlusExpr createXbcPlusExpr(XbcPlusExpr source) {
        XbcPlusExpr xbcPlusExpr_ = createXbcPlusExpr();
        xbcPlusExpr_.setup(source);
        return (xbcPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcAsgPlusExpr
     */
    public XbcAsgPlusExpr createXbcAsgPlusExpr(XbcAsgPlusExpr source) {
        XbcAsgPlusExpr xbcAsgPlusExpr_ = createXbcAsgPlusExpr();
        xbcAsgPlusExpr_.setup(source);
        return (xbcAsgPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgModExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcAsgModExpr
     */
    public XbcAsgModExpr createXbcAsgModExpr(XbcAsgModExpr source) {
        XbcAsgModExpr xbcAsgModExpr_ = createXbcAsgModExpr();
        xbcAsgModExpr_.setup(source);
        return (xbcAsgModExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcAsgBitOrExpr
     */
    public XbcAsgBitOrExpr createXbcAsgBitOrExpr(XbcAsgBitOrExpr source) {
        XbcAsgBitOrExpr xbcAsgBitOrExpr_ = createXbcAsgBitOrExpr();
        xbcAsgBitOrExpr_.setup(source);
        return (xbcAsgBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogGTExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcLogGTExpr
     */
    public XbcLogGTExpr createXbcLogGTExpr(XbcLogGTExpr source) {
        XbcLogGTExpr xbcLogGTExpr_ = createXbcLogGTExpr();
        xbcLogGTExpr_.setup(source);
        return (xbcLogGTExpr_);
    }

    /**
     * Creates a <code>XbcCondExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcCondExpr
     */
    public XbcCondExpr createXbcCondExpr(XbcCondExpr source) {
        XbcCondExpr xbcCondExpr_ = createXbcCondExpr();
        xbcCondExpr_.setup(source);
        return (xbcCondExpr_);
    }

    /**
     * Creates a <code>XbcMinusExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcMinusExpr
     */
    public XbcMinusExpr createXbcMinusExpr(XbcMinusExpr source) {
        XbcMinusExpr xbcMinusExpr_ = createXbcMinusExpr();
        xbcMinusExpr_.setup(source);
        return (xbcMinusExpr_);
    }

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcAddrOfExpr
     */
    public XbcAddrOfExpr createXbcAddrOfExpr(XbcAddrOfExpr source) {
        XbcAddrOfExpr xbcAddrOfExpr_ = createXbcAddrOfExpr();
        xbcAddrOfExpr_.setup(source);
        return (xbcAddrOfExpr_);
    }

    /**
     * Creates a <code>XbcLshiftExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcLshiftExpr
     */
    public XbcLshiftExpr createXbcLshiftExpr(XbcLshiftExpr source) {
        XbcLshiftExpr xbcLshiftExpr_ = createXbcLshiftExpr();
        xbcLshiftExpr_.setup(source);
        return (xbcLshiftExpr_);
    }

    /**
     * Creates a <code>XbcRshiftExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcRshiftExpr
     */
    public XbcRshiftExpr createXbcRshiftExpr(XbcRshiftExpr source) {
        XbcRshiftExpr xbcRshiftExpr_ = createXbcRshiftExpr();
        xbcRshiftExpr_.setup(source);
        return (xbcRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcAsgBitXorExpr
     */
    public XbcAsgBitXorExpr createXbcAsgBitXorExpr(XbcAsgBitXorExpr source) {
        XbcAsgBitXorExpr xbcAsgBitXorExpr_ = createXbcAsgBitXorExpr();
        xbcAsgBitXorExpr_.setup(source);
        return (xbcAsgBitXorExpr_);
    }

    /**
     * Creates a <code>XbcLogEQExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcLogEQExpr
     */
    public XbcLogEQExpr createXbcLogEQExpr(XbcLogEQExpr source) {
        XbcLogEQExpr xbcLogEQExpr_ = createXbcLogEQExpr();
        xbcLogEQExpr_.setup(source);
        return (xbcLogEQExpr_);
    }

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcLogNEQExpr
     */
    public XbcLogNEQExpr createXbcLogNEQExpr(XbcLogNEQExpr source) {
        XbcLogNEQExpr xbcLogNEQExpr_ = createXbcLogNEQExpr();
        xbcLogNEQExpr_.setup(source);
        return (xbcLogNEQExpr_);
    }

    /**
     * Creates a <code>XbcLogGEExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcLogGEExpr
     */
    public XbcLogGEExpr createXbcLogGEExpr(XbcLogGEExpr source) {
        XbcLogGEExpr xbcLogGEExpr_ = createXbcLogGEExpr();
        xbcLogGEExpr_.setup(source);
        return (xbcLogGEExpr_);
    }

    /**
     * Creates a <code>XbcLogLTExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcLogLTExpr
     */
    public XbcLogLTExpr createXbcLogLTExpr(XbcLogLTExpr source) {
        XbcLogLTExpr xbcLogLTExpr_ = createXbcLogLTExpr();
        xbcLogLTExpr_.setup(source);
        return (xbcLogLTExpr_);
    }

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcGccAlignOfExpr
     */
    public XbcGccAlignOfExpr createXbcGccAlignOfExpr(XbcGccAlignOfExpr source) {
        XbcGccAlignOfExpr xbcGccAlignOfExpr_ = createXbcGccAlignOfExpr();
        xbcGccAlignOfExpr_.setup(source);
        return (xbcGccAlignOfExpr_);
    }

    /**
     * Creates a <code>XbcAssignExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcAssignExpr
     */
    public XbcAssignExpr createXbcAssignExpr(XbcAssignExpr source) {
        XbcAssignExpr xbcAssignExpr_ = createXbcAssignExpr();
        xbcAssignExpr_.setup(source);
        return (xbcAssignExpr_);
    }

    /**
     * Creates a <code>XbcMulExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcMulExpr
     */
    public XbcMulExpr createXbcMulExpr(XbcMulExpr source) {
        XbcMulExpr xbcMulExpr_ = createXbcMulExpr();
        xbcMulExpr_.setup(source);
        return (xbcMulExpr_);
    }

    /**
     * Creates a <code>XbcDivExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcDivExpr
     */
    public XbcDivExpr createXbcDivExpr(XbcDivExpr source) {
        XbcDivExpr xbcDivExpr_ = createXbcDivExpr();
        xbcDivExpr_.setup(source);
        return (xbcDivExpr_);
    }

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcAsgMulExpr
     */
    public XbcAsgMulExpr createXbcAsgMulExpr(XbcAsgMulExpr source) {
        XbcAsgMulExpr xbcAsgMulExpr_ = createXbcAsgMulExpr();
        xbcAsgMulExpr_.setup(source);
        return (xbcAsgMulExpr_);
    }

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcAsgRshiftExpr
     */
    public XbcAsgRshiftExpr createXbcAsgRshiftExpr(XbcAsgRshiftExpr source) {
        XbcAsgRshiftExpr xbcAsgRshiftExpr_ = createXbcAsgRshiftExpr();
        xbcAsgRshiftExpr_.setup(source);
        return (xbcAsgRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcAsgBitAndExpr
     */
    public XbcAsgBitAndExpr createXbcAsgBitAndExpr(XbcAsgBitAndExpr source) {
        XbcAsgBitAndExpr xbcAsgBitAndExpr_ = createXbcAsgBitAndExpr();
        xbcAsgBitAndExpr_.setup(source);
        return (xbcAsgBitAndExpr_);
    }

    /**
     * Creates a <code>XbcLogLEExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcLogLEExpr
     */
    public XbcLogLEExpr createXbcLogLEExpr(XbcLogLEExpr source) {
        XbcLogLEExpr xbcLogLEExpr_ = createXbcLogLEExpr();
        xbcLogLEExpr_.setup(source);
        return (xbcLogLEExpr_);
    }

    /**
     * Creates a <code>XbcLogAndExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcLogAndExpr
     */
    public XbcLogAndExpr createXbcLogAndExpr(XbcLogAndExpr source) {
        XbcLogAndExpr xbcLogAndExpr_ = createXbcLogAndExpr();
        xbcLogAndExpr_.setup(source);
        return (xbcLogAndExpr_);
    }

    /**
     * Creates a <code>XbcCommaExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcCommaExpr
     */
    public XbcCommaExpr createXbcCommaExpr(XbcCommaExpr source) {
        XbcCommaExpr xbcCommaExpr_ = createXbcCommaExpr();
        xbcCommaExpr_.setup(source);
        return (xbcCommaExpr_);
    }

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcAsgDivExpr
     */
    public XbcAsgDivExpr createXbcAsgDivExpr(XbcAsgDivExpr source) {
        XbcAsgDivExpr xbcAsgDivExpr_ = createXbcAsgDivExpr();
        xbcAsgDivExpr_.setup(source);
        return (xbcAsgDivExpr_);
    }

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcGccLabelAddr
     */
    public XbcGccLabelAddr createXbcGccLabelAddr(XbcGccLabelAddr source) {
        XbcGccLabelAddr xbcGccLabelAddr_ = createXbcGccLabelAddr();
        xbcGccLabelAddr_.setup(source);
        return (xbcGccLabelAddr_);
    }

    /**
     * Creates a <code>XbcBitAndExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcBitAndExpr
     */
    public XbcBitAndExpr createXbcBitAndExpr(XbcBitAndExpr source) {
        XbcBitAndExpr xbcBitAndExpr_ = createXbcBitAndExpr();
        xbcBitAndExpr_.setup(source);
        return (xbcBitAndExpr_);
    }

    /**
     * Creates a <code>XbcBitXorExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcBitXorExpr
     */
    public XbcBitXorExpr createXbcBitXorExpr(XbcBitXorExpr source) {
        XbcBitXorExpr xbcBitXorExpr_ = createXbcBitXorExpr();
        xbcBitXorExpr_.setup(source);
        return (xbcBitXorExpr_);
    }

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcAsgMinusExpr
     */
    public XbcAsgMinusExpr createXbcAsgMinusExpr(XbcAsgMinusExpr source) {
        XbcAsgMinusExpr xbcAsgMinusExpr_ = createXbcAsgMinusExpr();
        xbcAsgMinusExpr_.setup(source);
        return (xbcAsgMinusExpr_);
    }

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcAsgLshiftExpr
     */
    public XbcAsgLshiftExpr createXbcAsgLshiftExpr(XbcAsgLshiftExpr source) {
        XbcAsgLshiftExpr xbcAsgLshiftExpr_ = createXbcAsgLshiftExpr();
        xbcAsgLshiftExpr_.setup(source);
        return (xbcAsgLshiftExpr_);
    }

    /**
     * Creates a <code>XbcMemberAddr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcMemberAddr
     */
    public XbcMemberAddr createXbcMemberAddr(XbcMemberAddr source) {
        XbcMemberAddr xbcMemberAddr_ = createXbcMemberAddr();
        xbcMemberAddr_.setup(source);
        return (xbcMemberAddr_);
    }

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcMemberArrayRef
     */
    public XbcMemberArrayRef createXbcMemberArrayRef(XbcMemberArrayRef source) {
        XbcMemberArrayRef xbcMemberArrayRef_ = createXbcMemberArrayRef();
        xbcMemberArrayRef_.setup(source);
        return (xbcMemberArrayRef_);
    }

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcMemberArrayAddr
     */
    public XbcMemberArrayAddr createXbcMemberArrayAddr(XbcMemberArrayAddr source) {
        XbcMemberArrayAddr xbcMemberArrayAddr_ = createXbcMemberArrayAddr();
        xbcMemberArrayAddr_.setup(source);
        return (xbcMemberArrayAddr_);
    }

    /**
     * Creates a <code>XbcTypeName</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcTypeName
     */
    public XbcTypeName createXbcTypeName(XbcTypeName source) {
        XbcTypeName xbcTypeName_ = createXbcTypeName();
        xbcTypeName_.setup(source);
        return (xbcTypeName_);
    }

    /**
     * Creates a <code>XbcPointerRef</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcPointerRef
     */
    public XbcPointerRef createXbcPointerRef(XbcPointerRef source) {
        XbcPointerRef xbcPointerRef_ = createXbcPointerRef();
        xbcPointerRef_.setup(source);
        return (xbcPointerRef_);
    }

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcUnaryMinusExpr
     */
    public XbcUnaryMinusExpr createXbcUnaryMinusExpr(XbcUnaryMinusExpr source) {
        XbcUnaryMinusExpr xbcUnaryMinusExpr_ = createXbcUnaryMinusExpr();
        xbcUnaryMinusExpr_.setup(source);
        return (xbcUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbcBitNotExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcBitNotExpr
     */
    public XbcBitNotExpr createXbcBitNotExpr(XbcBitNotExpr source) {
        XbcBitNotExpr xbcBitNotExpr_ = createXbcBitNotExpr();
        xbcBitNotExpr_.setup(source);
        return (xbcBitNotExpr_);
    }

    /**
     * Creates a <code>XbcLogNotExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcLogNotExpr
     */
    public XbcLogNotExpr createXbcLogNotExpr(XbcLogNotExpr source) {
        XbcLogNotExpr xbcLogNotExpr_ = createXbcLogNotExpr();
        xbcLogNotExpr_.setup(source);
        return (xbcLogNotExpr_);
    }

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcPostIncrExpr
     */
    public XbcPostIncrExpr createXbcPostIncrExpr(XbcPostIncrExpr source) {
        XbcPostIncrExpr xbcPostIncrExpr_ = createXbcPostIncrExpr();
        xbcPostIncrExpr_.setup(source);
        return (xbcPostIncrExpr_);
    }

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcPostDecrExpr
     */
    public XbcPostDecrExpr createXbcPostDecrExpr(XbcPostDecrExpr source) {
        XbcPostDecrExpr xbcPostDecrExpr_ = createXbcPostDecrExpr();
        xbcPostDecrExpr_.setup(source);
        return (xbcPostDecrExpr_);
    }

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcPreIncrExpr
     */
    public XbcPreIncrExpr createXbcPreIncrExpr(XbcPreIncrExpr source) {
        XbcPreIncrExpr xbcPreIncrExpr_ = createXbcPreIncrExpr();
        xbcPreIncrExpr_.setup(source);
        return (xbcPreIncrExpr_);
    }

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcPreDecrExpr
     */
    public XbcPreDecrExpr createXbcPreDecrExpr(XbcPreDecrExpr source) {
        XbcPreDecrExpr xbcPreDecrExpr_ = createXbcPreDecrExpr();
        xbcPreDecrExpr_.setup(source);
        return (xbcPreDecrExpr_);
    }

    /**
     * Creates a <code>XbcIndexRange</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcIndexRange
     */
    public XbcIndexRange createXbcIndexRange(XbcIndexRange source) {
        XbcIndexRange xbcIndexRange_ = createXbcIndexRange();
        xbcIndexRange_.setup(source);
        return (xbcIndexRange_);
    }

    /**
     * Creates a <code>XbcLowerBound</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcLowerBound
     */
    public XbcLowerBound createXbcLowerBound(XbcLowerBound source) {
        XbcLowerBound xbcLowerBound_ = createXbcLowerBound();
        xbcLowerBound_.setup(source);
        return (xbcLowerBound_);
    }

    /**
     * Creates a <code>XbcUpperBound</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcUpperBound
     */
    public XbcUpperBound createXbcUpperBound(XbcUpperBound source) {
        XbcUpperBound xbcUpperBound_ = createXbcUpperBound();
        xbcUpperBound_.setup(source);
        return (xbcUpperBound_);
    }

    /**
     * Creates a <code>XbcStep</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcStep
     */
    public XbcStep createXbcStep(XbcStep source) {
        XbcStep xbcStep_ = createXbcStep();
        xbcStep_.setup(source);
        return (xbcStep_);
    }

    /**
     * Creates a <code>XbcDesignatedValue</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcDesignatedValue
     */
    public XbcDesignatedValue createXbcDesignatedValue(XbcDesignatedValue source) {
        XbcDesignatedValue xbcDesignatedValue_ = createXbcDesignatedValue();
        xbcDesignatedValue_.setup(source);
        return (xbcDesignatedValue_);
    }

    /**
     * Creates a <code>XbcCompoundValue</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcCompoundValue
     */
    public XbcCompoundValue createXbcCompoundValue(XbcCompoundValue source) {
        XbcCompoundValue xbcCompoundValue_ = createXbcCompoundValue();
        xbcCompoundValue_.setup(source);
        return (xbcCompoundValue_);
    }

    /**
     * Creates a <code>XbcBitField</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcBitField
     */
    public XbcBitField createXbcBitField(XbcBitField source) {
        XbcBitField xbcBitField_ = createXbcBitField();
        xbcBitField_.setup(source);
        return (xbcBitField_);
    }

    /**
     * Creates a <code>XbcPragma</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcPragma
     */
    public XbcPragma createXbcPragma(XbcPragma source) {
        XbcPragma xbcPragma_ = createXbcPragma();
        xbcPragma_.setup(source);
        return (xbcPragma_);
    }

    /**
     * Creates a <code>XbcText</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcText
     */
    public XbcText createXbcText(XbcText source) {
        XbcText xbcText_ = createXbcText();
        xbcText_.setup(source);
        return (xbcText_);
    }

    /**
     * Creates a <code>XbcDeclarations</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcDeclarations
     */
    public XbcDeclarations createXbcDeclarations(XbcDeclarations source) {
        XbcDeclarations xbcDeclarations_ = createXbcDeclarations();
        xbcDeclarations_.setup(source);
        return (xbcDeclarations_);
    }

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcFunctionDefinition
     */
    public XbcFunctionDefinition createXbcFunctionDefinition(XbcFunctionDefinition source) {
        XbcFunctionDefinition xbcFunctionDefinition_ = createXbcFunctionDefinition();
        xbcFunctionDefinition_.setup(source);
        return (xbcFunctionDefinition_);
    }

    /**
     * Creates a <code>XbcParams</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcParams
     */
    public XbcParams createXbcParams(XbcParams source) {
        XbcParams xbcParams_ = createXbcParams();
        xbcParams_.setup(source);
        return (xbcParams_);
    }

    /**
     * Creates a <code>XbcBody</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcBody
     */
    public XbcBody createXbcBody(XbcBody source) {
        XbcBody xbcBody_ = createXbcBody();
        xbcBody_.setup(source);
        return (xbcBody_);
    }

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcGccAsmStatement
     */
    public XbcGccAsmStatement createXbcGccAsmStatement(XbcGccAsmStatement source) {
        XbcGccAsmStatement xbcGccAsmStatement_ = createXbcGccAsmStatement();
        xbcGccAsmStatement_.setup(source);
        return (xbcGccAsmStatement_);
    }

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcGccAsmOperands
     */
    public XbcGccAsmOperands createXbcGccAsmOperands(XbcGccAsmOperands source) {
        XbcGccAsmOperands xbcGccAsmOperands_ = createXbcGccAsmOperands();
        xbcGccAsmOperands_.setup(source);
        return (xbcGccAsmOperands_);
    }

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcGccAsmOperand
     */
    public XbcGccAsmOperand createXbcGccAsmOperand(XbcGccAsmOperand source) {
        XbcGccAsmOperand xbcGccAsmOperand_ = createXbcGccAsmOperand();
        xbcGccAsmOperand_.setup(source);
        return (xbcGccAsmOperand_);
    }

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcGccAsmClobbers
     */
    public XbcGccAsmClobbers createXbcGccAsmClobbers(XbcGccAsmClobbers source) {
        XbcGccAsmClobbers xbcGccAsmClobbers_ = createXbcGccAsmClobbers();
        xbcGccAsmClobbers_.setup(source);
        return (xbcGccAsmClobbers_);
    }

    /**
     * Creates a <code>XbcForStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcForStatement
     */
    public XbcForStatement createXbcForStatement(XbcForStatement source) {
        XbcForStatement xbcForStatement_ = createXbcForStatement();
        xbcForStatement_.setup(source);
        return (xbcForStatement_);
    }

    /**
     * Creates a <code>XbcInit</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcInit
     */
    public XbcInit createXbcInit(XbcInit source) {
        XbcInit xbcInit_ = createXbcInit();
        xbcInit_.setup(source);
        return (xbcInit_);
    }

    /**
     * Creates a <code>XbcCondition</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcCondition
     */
    public XbcCondition createXbcCondition(XbcCondition source) {
        XbcCondition xbcCondition_ = createXbcCondition();
        xbcCondition_.setup(source);
        return (xbcCondition_);
    }

    /**
     * Creates a <code>XbcIter</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcIter
     */
    public XbcIter createXbcIter(XbcIter source) {
        XbcIter xbcIter_ = createXbcIter();
        xbcIter_.setup(source);
        return (xbcIter_);
    }

    /**
     * Creates a <code>XbcIfStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcIfStatement
     */
    public XbcIfStatement createXbcIfStatement(XbcIfStatement source) {
        XbcIfStatement xbcIfStatement_ = createXbcIfStatement();
        xbcIfStatement_.setup(source);
        return (xbcIfStatement_);
    }

    /**
     * Creates a <code>XbcThen</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcThen
     */
    public XbcThen createXbcThen(XbcThen source) {
        XbcThen xbcThen_ = createXbcThen();
        xbcThen_.setup(source);
        return (xbcThen_);
    }

    /**
     * Creates a <code>XbcElse</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcElse
     */
    public XbcElse createXbcElse(XbcElse source) {
        XbcElse xbcElse_ = createXbcElse();
        xbcElse_.setup(source);
        return (xbcElse_);
    }

    /**
     * Creates a <code>XbcWhileStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcWhileStatement
     */
    public XbcWhileStatement createXbcWhileStatement(XbcWhileStatement source) {
        XbcWhileStatement xbcWhileStatement_ = createXbcWhileStatement();
        xbcWhileStatement_.setup(source);
        return (xbcWhileStatement_);
    }

    /**
     * Creates a <code>XbcDoStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcDoStatement
     */
    public XbcDoStatement createXbcDoStatement(XbcDoStatement source) {
        XbcDoStatement xbcDoStatement_ = createXbcDoStatement();
        xbcDoStatement_.setup(source);
        return (xbcDoStatement_);
    }

    /**
     * Creates a <code>XbcSwitchStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcSwitchStatement
     */
    public XbcSwitchStatement createXbcSwitchStatement(XbcSwitchStatement source) {
        XbcSwitchStatement xbcSwitchStatement_ = createXbcSwitchStatement();
        xbcSwitchStatement_.setup(source);
        return (xbcSwitchStatement_);
    }

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcGccRangedCaseLabel
     */
    public XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(XbcGccRangedCaseLabel source) {
        XbcGccRangedCaseLabel xbcGccRangedCaseLabel_ = createXbcGccRangedCaseLabel();
        xbcGccRangedCaseLabel_.setup(source);
        return (xbcGccRangedCaseLabel_);
    }

    /**
     * Creates a <code>XbcStatementLabel</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcStatementLabel
     */
    public XbcStatementLabel createXbcStatementLabel(XbcStatementLabel source) {
        XbcStatementLabel xbcStatementLabel_ = createXbcStatementLabel();
        xbcStatementLabel_.setup(source);
        return (xbcStatementLabel_);
    }

    /**
     * Creates a <code>XbcCaseLabel</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcCaseLabel
     */
    public XbcCaseLabel createXbcCaseLabel(XbcCaseLabel source) {
        XbcCaseLabel xbcCaseLabel_ = createXbcCaseLabel();
        xbcCaseLabel_.setup(source);
        return (xbcCaseLabel_);
    }

    /**
     * Creates a <code>XbcBreakStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcBreakStatement
     */
    public XbcBreakStatement createXbcBreakStatement(XbcBreakStatement source) {
        XbcBreakStatement xbcBreakStatement_ = createXbcBreakStatement();
        xbcBreakStatement_.setup(source);
        return (xbcBreakStatement_);
    }

    /**
     * Creates a <code>XbcContinueStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcContinueStatement
     */
    public XbcContinueStatement createXbcContinueStatement(XbcContinueStatement source) {
        XbcContinueStatement xbcContinueStatement_ = createXbcContinueStatement();
        xbcContinueStatement_.setup(source);
        return (xbcContinueStatement_);
    }

    /**
     * Creates a <code>XbcReturnStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcReturnStatement
     */
    public XbcReturnStatement createXbcReturnStatement(XbcReturnStatement source) {
        XbcReturnStatement xbcReturnStatement_ = createXbcReturnStatement();
        xbcReturnStatement_.setup(source);
        return (xbcReturnStatement_);
    }

    /**
     * Creates a <code>XbcGotoStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcGotoStatement
     */
    public XbcGotoStatement createXbcGotoStatement(XbcGotoStatement source) {
        XbcGotoStatement xbcGotoStatement_ = createXbcGotoStatement();
        xbcGotoStatement_.setup(source);
        return (xbcGotoStatement_);
    }

    /**
     * Creates a <code>XbcDefaultLabel</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcDefaultLabel
     */
    public XbcDefaultLabel createXbcDefaultLabel(XbcDefaultLabel source) {
        XbcDefaultLabel xbcDefaultLabel_ = createXbcDefaultLabel();
        xbcDefaultLabel_.setup(source);
        return (xbcDefaultLabel_);
    }

    /**
     * Creates a <code>XbcExprStatement</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcExprStatement
     */
    public XbcExprStatement createXbcExprStatement(XbcExprStatement source) {
        XbcExprStatement xbcExprStatement_ = createXbcExprStatement();
        xbcExprStatement_.setup(source);
        return (xbcExprStatement_);
    }

    /**
     * Creates a <code>XbcVarDecl</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcVarDecl
     */
    public XbcVarDecl createXbcVarDecl(XbcVarDecl source) {
        XbcVarDecl xbcVarDecl_ = createXbcVarDecl();
        xbcVarDecl_.setup(source);
        return (xbcVarDecl_);
    }

    /**
     * Creates a <code>XbcGccAsm</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcGccAsm
     */
    public XbcGccAsm createXbcGccAsm(XbcGccAsm source) {
        XbcGccAsm xbcGccAsm_ = createXbcGccAsm();
        xbcGccAsm_.setup(source);
        return (xbcGccAsm_);
    }

    /**
     * Creates a <code>XbcFunctionDecl</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcFunctionDecl
     */
    public XbcFunctionDecl createXbcFunctionDecl(XbcFunctionDecl source) {
        XbcFunctionDecl xbcFunctionDecl_ = createXbcFunctionDecl();
        xbcFunctionDecl_.setup(source);
        return (xbcFunctionDecl_);
    }

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcGccMemberDesignator
     */
    public XbcGccMemberDesignator createXbcGccMemberDesignator(XbcGccMemberDesignator source) {
        XbcGccMemberDesignator xbcGccMemberDesignator_ = createXbcGccMemberDesignator();
        xbcGccMemberDesignator_.setup(source);
        return (xbcGccMemberDesignator_);
    }

    /**
     * Creates a <code>XbcArrayType</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcArrayType
     */
    public XbcArrayType createXbcArrayType(XbcArrayType source) {
        XbcArrayType xbcArrayType_ = createXbcArrayType();
        xbcArrayType_.setup(source);
        return (xbcArrayType_);
    }

    /**
     * Creates a <code>XbcArraySize</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcArraySize
     */
    public XbcArraySize createXbcArraySize(XbcArraySize source) {
        XbcArraySize xbcArraySize_ = createXbcArraySize();
        xbcArraySize_.setup(source);
        return (xbcArraySize_);
    }

    /**
     * Creates a <code>XbcBasicType</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcBasicType
     */
    public XbcBasicType createXbcBasicType(XbcBasicType source) {
        XbcBasicType xbcBasicType_ = createXbcBasicType();
        xbcBasicType_.setup(source);
        return (xbcBasicType_);
    }

    /**
     * Creates a <code>XbcPointerType</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcPointerType
     */
    public XbcPointerType createXbcPointerType(XbcPointerType source) {
        XbcPointerType xbcPointerType_ = createXbcPointerType();
        xbcPointerType_.setup(source);
        return (xbcPointerType_);
    }

    /**
     * Creates a <code>XbcStructType</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcStructType
     */
    public XbcStructType createXbcStructType(XbcStructType source) {
        XbcStructType xbcStructType_ = createXbcStructType();
        xbcStructType_.setup(source);
        return (xbcStructType_);
    }

    /**
     * Creates a <code>XbcUnionType</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcUnionType
     */
    public XbcUnionType createXbcUnionType(XbcUnionType source) {
        XbcUnionType xbcUnionType_ = createXbcUnionType();
        xbcUnionType_.setup(source);
        return (xbcUnionType_);
    }

    /**
     * Creates a <code>XbcEnumType</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcEnumType
     */
    public XbcEnumType createXbcEnumType(XbcEnumType source) {
        XbcEnumType xbcEnumType_ = createXbcEnumType();
        xbcEnumType_.setup(source);
        return (xbcEnumType_);
    }

    /**
     * Creates a <code>XbcCoArrayType</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcCoArrayType
     */
    public XbcCoArrayType createXbcCoArrayType(XbcCoArrayType source) {
        XbcCoArrayType xbcCoArrayType_ = createXbcCoArrayType();
        xbcCoArrayType_.setup(source);
        return (xbcCoArrayType_);
    }

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcGlobalSymbols
     */
    public XbcGlobalSymbols createXbcGlobalSymbols(XbcGlobalSymbols source) {
        XbcGlobalSymbols xbcGlobalSymbols_ = createXbcGlobalSymbols();
        xbcGlobalSymbols_.setup(source);
        return (xbcGlobalSymbols_);
    }

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcGlobalDeclarations
     */
    public XbcGlobalDeclarations createXbcGlobalDeclarations(XbcGlobalDeclarations source) {
        XbcGlobalDeclarations xbcGlobalDeclarations_ = createXbcGlobalDeclarations();
        xbcGlobalDeclarations_.setup(source);
        return (xbcGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the object <code>source</code>.
     * This method is a template method for concrete classes.
     *
     * @param source
     * @return XbcGccAsmDefinition
     */
    public XbcGccAsmDefinition createXbcGccAsmDefinition(XbcGccAsmDefinition source) {
        XbcGccAsmDefinition xbcGccAsmDefinition_ = createXbcGccAsmDefinition();
        xbcGccAsmDefinition_.setup(source);
        return (xbcGccAsmDefinition_);
    }

    /**
     * Creates a <code>XbcXcodeProgram</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcXcodeProgram
     */
    public XbcXcodeProgram createXbcXcodeProgram(Document doc) {
        XbcXcodeProgram xbcXcodeProgram_ = createXbcXcodeProgram();
        xbcXcodeProgram_.setup(doc);
        return (xbcXcodeProgram_);
    }

    /**
     * Creates a <code>XbcTypeTable</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcTypeTable
     */
    public XbcTypeTable createXbcTypeTable(Document doc) {
        XbcTypeTable xbcTypeTable_ = createXbcTypeTable();
        xbcTypeTable_.setup(doc);
        return (xbcTypeTable_);
    }

    /**
     * Creates a <code>XbcFunctionType</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcFunctionType
     */
    public XbcFunctionType createXbcFunctionType(Document doc) {
        XbcFunctionType xbcFunctionType_ = createXbcFunctionType();
        xbcFunctionType_.setup(doc);
        return (xbcFunctionType_);
    }

    /**
     * Creates a <code>XbcGccAttributes</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcGccAttributes
     */
    public XbcGccAttributes createXbcGccAttributes(Document doc) {
        XbcGccAttributes xbcGccAttributes_ = createXbcGccAttributes();
        xbcGccAttributes_.setup(doc);
        return (xbcGccAttributes_);
    }

    /**
     * Creates a <code>XbcGccAttribute</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcGccAttribute
     */
    public XbcGccAttribute createXbcGccAttribute(Document doc) {
        XbcGccAttribute xbcGccAttribute_ = createXbcGccAttribute();
        xbcGccAttribute_.setup(doc);
        return (xbcGccAttribute_);
    }

    /**
     * Creates a <code>XbcBuiltinOp</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcBuiltinOp
     */
    public XbcBuiltinOp createXbcBuiltinOp(Document doc) {
        XbcBuiltinOp xbcBuiltinOp_ = createXbcBuiltinOp();
        xbcBuiltinOp_.setup(doc);
        return (xbcBuiltinOp_);
    }

    /**
     * Creates a <code>XbcArrayRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcArrayRef
     */
    public XbcArrayRef createXbcArrayRef(Document doc) {
        XbcArrayRef xbcArrayRef_ = createXbcArrayRef();
        xbcArrayRef_.setup(doc);
        return (xbcArrayRef_);
    }

    /**
     * Creates a <code>XbcArrayAddr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcArrayAddr
     */
    public XbcArrayAddr createXbcArrayAddr(Document doc) {
        XbcArrayAddr xbcArrayAddr_ = createXbcArrayAddr();
        xbcArrayAddr_.setup(doc);
        return (xbcArrayAddr_);
    }

    /**
     * Creates a <code>XbcFunctionCall</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcFunctionCall
     */
    public XbcFunctionCall createXbcFunctionCall(Document doc) {
        XbcFunctionCall xbcFunctionCall_ = createXbcFunctionCall();
        xbcFunctionCall_.setup(doc);
        return (xbcFunctionCall_);
    }

    /**
     * Creates a <code>XbcFunction</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcFunction
     */
    public XbcFunction createXbcFunction(Document doc) {
        XbcFunction xbcFunction_ = createXbcFunction();
        xbcFunction_.setup(doc);
        return (xbcFunction_);
    }

    /**
     * Creates a <code>XbcArguments</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcArguments
     */
    public XbcArguments createXbcArguments(Document doc) {
        XbcArguments xbcArguments_ = createXbcArguments();
        xbcArguments_.setup(doc);
        return (xbcArguments_);
    }

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcGccCompoundExpr
     */
    public XbcGccCompoundExpr createXbcGccCompoundExpr(Document doc) {
        XbcGccCompoundExpr xbcGccCompoundExpr_ = createXbcGccCompoundExpr();
        xbcGccCompoundExpr_.setup(doc);
        return (xbcGccCompoundExpr_);
    }

    /**
     * Creates a <code>XbcCompoundStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcCompoundStatement
     */
    public XbcCompoundStatement createXbcCompoundStatement(Document doc) {
        XbcCompoundStatement xbcCompoundStatement_ = createXbcCompoundStatement();
        xbcCompoundStatement_.setup(doc);
        return (xbcCompoundStatement_);
    }

    /**
     * Creates a <code>XbcSymbols</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcSymbols
     */
    public XbcSymbols createXbcSymbols(Document doc) {
        XbcSymbols xbcSymbols_ = createXbcSymbols();
        xbcSymbols_.setup(doc);
        return (xbcSymbols_);
    }

    /**
     * Creates a <code>XbcId</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcId
     */
    public XbcId createXbcId(Document doc) {
        XbcId xbcId_ = createXbcId();
        xbcId_.setup(doc);
        return (xbcId_);
    }

    /**
     * Creates a <code>XbcName</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcName
     */
    public XbcName createXbcName(Document doc) {
        XbcName xbcName_ = createXbcName();
        xbcName_.setup(doc);
        return (xbcName_);
    }

    /**
     * Creates a <code>XbcValue</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcValue
     */
    public XbcValue createXbcValue(Document doc) {
        XbcValue xbcValue_ = createXbcValue();
        xbcValue_.setup(doc);
        return (xbcValue_);
    }

    /**
     * Creates a <code>XbcSubArrayRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcSubArrayRef
     */
    public XbcSubArrayRef createXbcSubArrayRef(Document doc) {
        XbcSubArrayRef xbcSubArrayRef_ = createXbcSubArrayRef();
        xbcSubArrayRef_.setup(doc);
        return (xbcSubArrayRef_);
    }

    /**
     * Creates a <code>XbcCoArrayRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcCoArrayRef
     */
    public XbcCoArrayRef createXbcCoArrayRef(Document doc) {
        XbcCoArrayRef xbcCoArrayRef_ = createXbcCoArrayRef();
        xbcCoArrayRef_.setup(doc);
        return (xbcCoArrayRef_);
    }

    /**
     * Creates a <code>XbcVar</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcVar
     */
    public XbcVar createXbcVar(Document doc) {
        XbcVar xbcVar_ = createXbcVar();
        xbcVar_.setup(doc);
        return (xbcVar_);
    }

    /**
     * Creates a <code>XbcMemberRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcMemberRef
     */
    public XbcMemberRef createXbcMemberRef(Document doc) {
        XbcMemberRef xbcMemberRef_ = createXbcMemberRef();
        xbcMemberRef_.setup(doc);
        return (xbcMemberRef_);
    }

    /**
     * Creates a <code>XbcCastExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcCastExpr
     */
    public XbcCastExpr createXbcCastExpr(Document doc) {
        XbcCastExpr xbcCastExpr_ = createXbcCastExpr();
        xbcCastExpr_.setup(doc);
        return (xbcCastExpr_);
    }

    /**
     * Creates a <code>XbcStringConstant</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcStringConstant
     */
    public XbcStringConstant createXbcStringConstant(Document doc) {
        XbcStringConstant xbcStringConstant_ = createXbcStringConstant();
        xbcStringConstant_.setup(doc);
        return (xbcStringConstant_);
    }

    /**
     * Creates a <code>XbcVarAddr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcVarAddr
     */
    public XbcVarAddr createXbcVarAddr(Document doc) {
        XbcVarAddr xbcVarAddr_ = createXbcVarAddr();
        xbcVarAddr_.setup(doc);
        return (xbcVarAddr_);
    }

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcCompoundValueExpr
     */
    public XbcCompoundValueExpr createXbcCompoundValueExpr(Document doc) {
        XbcCompoundValueExpr xbcCompoundValueExpr_ = createXbcCompoundValueExpr();
        xbcCompoundValueExpr_.setup(doc);
        return (xbcCompoundValueExpr_);
    }

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcCompoundValueAddrExpr
     */
    public XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(Document doc) {
        XbcCompoundValueAddrExpr xbcCompoundValueAddrExpr_ = createXbcCompoundValueAddrExpr();
        xbcCompoundValueAddrExpr_.setup(doc);
        return (xbcCompoundValueAddrExpr_);
    }

    /**
     * Creates a <code>XbcXmpDescOf</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcXmpDescOf
     */
    public XbcXmpDescOf createXbcXmpDescOf(Document doc) {
        XbcXmpDescOf xbcXmpDescOf_ = createXbcXmpDescOf();
        xbcXmpDescOf_.setup(doc);
        return (xbcXmpDescOf_);
    }

    /**
     * Creates a <code>XbcIntConstant</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcIntConstant
     */
    public XbcIntConstant createXbcIntConstant(Document doc) {
        XbcIntConstant xbcIntConstant_ = createXbcIntConstant();
        xbcIntConstant_.setup(doc);
        return (xbcIntConstant_);
    }

    /**
     * Creates a <code>XbcFloatConstant</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcFloatConstant
     */
    public XbcFloatConstant createXbcFloatConstant(Document doc) {
        XbcFloatConstant xbcFloatConstant_ = createXbcFloatConstant();
        xbcFloatConstant_.setup(doc);
        return (xbcFloatConstant_);
    }

    /**
     * Creates a <code>XbcLonglongConstant</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcLonglongConstant
     */
    public XbcLonglongConstant createXbcLonglongConstant(Document doc) {
        XbcLonglongConstant xbcLonglongConstant_ = createXbcLonglongConstant();
        xbcLonglongConstant_.setup(doc);
        return (xbcLonglongConstant_);
    }

    /**
     * Creates a <code>XbcMoeConstant</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcMoeConstant
     */
    public XbcMoeConstant createXbcMoeConstant(Document doc) {
        XbcMoeConstant xbcMoeConstant_ = createXbcMoeConstant();
        xbcMoeConstant_.setup(doc);
        return (xbcMoeConstant_);
    }

    /**
     * Creates a <code>XbcFuncAddr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcFuncAddr
     */
    public XbcFuncAddr createXbcFuncAddr(Document doc) {
        XbcFuncAddr xbcFuncAddr_ = createXbcFuncAddr();
        xbcFuncAddr_.setup(doc);
        return (xbcFuncAddr_);
    }

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcSizeOfExpr
     */
    public XbcSizeOfExpr createXbcSizeOfExpr(Document doc) {
        XbcSizeOfExpr xbcSizeOfExpr_ = createXbcSizeOfExpr();
        xbcSizeOfExpr_.setup(doc);
        return (xbcSizeOfExpr_);
    }

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcCoArrayAssignExpr
     */
    public XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(Document doc) {
        XbcCoArrayAssignExpr xbcCoArrayAssignExpr_ = createXbcCoArrayAssignExpr();
        xbcCoArrayAssignExpr_.setup(doc);
        return (xbcCoArrayAssignExpr_);
    }

    /**
     * Creates a <code>XbcModExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcModExpr
     */
    public XbcModExpr createXbcModExpr(Document doc) {
        XbcModExpr xbcModExpr_ = createXbcModExpr();
        xbcModExpr_.setup(doc);
        return (xbcModExpr_);
    }

    /**
     * Creates a <code>XbcBitOrExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcBitOrExpr
     */
    public XbcBitOrExpr createXbcBitOrExpr(Document doc) {
        XbcBitOrExpr xbcBitOrExpr_ = createXbcBitOrExpr();
        xbcBitOrExpr_.setup(doc);
        return (xbcBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogOrExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcLogOrExpr
     */
    public XbcLogOrExpr createXbcLogOrExpr(Document doc) {
        XbcLogOrExpr xbcLogOrExpr_ = createXbcLogOrExpr();
        xbcLogOrExpr_.setup(doc);
        return (xbcLogOrExpr_);
    }

    /**
     * Creates a <code>XbcPlusExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcPlusExpr
     */
    public XbcPlusExpr createXbcPlusExpr(Document doc) {
        XbcPlusExpr xbcPlusExpr_ = createXbcPlusExpr();
        xbcPlusExpr_.setup(doc);
        return (xbcPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcAsgPlusExpr
     */
    public XbcAsgPlusExpr createXbcAsgPlusExpr(Document doc) {
        XbcAsgPlusExpr xbcAsgPlusExpr_ = createXbcAsgPlusExpr();
        xbcAsgPlusExpr_.setup(doc);
        return (xbcAsgPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgModExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcAsgModExpr
     */
    public XbcAsgModExpr createXbcAsgModExpr(Document doc) {
        XbcAsgModExpr xbcAsgModExpr_ = createXbcAsgModExpr();
        xbcAsgModExpr_.setup(doc);
        return (xbcAsgModExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcAsgBitOrExpr
     */
    public XbcAsgBitOrExpr createXbcAsgBitOrExpr(Document doc) {
        XbcAsgBitOrExpr xbcAsgBitOrExpr_ = createXbcAsgBitOrExpr();
        xbcAsgBitOrExpr_.setup(doc);
        return (xbcAsgBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogGTExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcLogGTExpr
     */
    public XbcLogGTExpr createXbcLogGTExpr(Document doc) {
        XbcLogGTExpr xbcLogGTExpr_ = createXbcLogGTExpr();
        xbcLogGTExpr_.setup(doc);
        return (xbcLogGTExpr_);
    }

    /**
     * Creates a <code>XbcCondExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcCondExpr
     */
    public XbcCondExpr createXbcCondExpr(Document doc) {
        XbcCondExpr xbcCondExpr_ = createXbcCondExpr();
        xbcCondExpr_.setup(doc);
        return (xbcCondExpr_);
    }

    /**
     * Creates a <code>XbcMinusExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcMinusExpr
     */
    public XbcMinusExpr createXbcMinusExpr(Document doc) {
        XbcMinusExpr xbcMinusExpr_ = createXbcMinusExpr();
        xbcMinusExpr_.setup(doc);
        return (xbcMinusExpr_);
    }

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcAddrOfExpr
     */
    public XbcAddrOfExpr createXbcAddrOfExpr(Document doc) {
        XbcAddrOfExpr xbcAddrOfExpr_ = createXbcAddrOfExpr();
        xbcAddrOfExpr_.setup(doc);
        return (xbcAddrOfExpr_);
    }

    /**
     * Creates a <code>XbcLshiftExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcLshiftExpr
     */
    public XbcLshiftExpr createXbcLshiftExpr(Document doc) {
        XbcLshiftExpr xbcLshiftExpr_ = createXbcLshiftExpr();
        xbcLshiftExpr_.setup(doc);
        return (xbcLshiftExpr_);
    }

    /**
     * Creates a <code>XbcRshiftExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcRshiftExpr
     */
    public XbcRshiftExpr createXbcRshiftExpr(Document doc) {
        XbcRshiftExpr xbcRshiftExpr_ = createXbcRshiftExpr();
        xbcRshiftExpr_.setup(doc);
        return (xbcRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcAsgBitXorExpr
     */
    public XbcAsgBitXorExpr createXbcAsgBitXorExpr(Document doc) {
        XbcAsgBitXorExpr xbcAsgBitXorExpr_ = createXbcAsgBitXorExpr();
        xbcAsgBitXorExpr_.setup(doc);
        return (xbcAsgBitXorExpr_);
    }

    /**
     * Creates a <code>XbcLogEQExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcLogEQExpr
     */
    public XbcLogEQExpr createXbcLogEQExpr(Document doc) {
        XbcLogEQExpr xbcLogEQExpr_ = createXbcLogEQExpr();
        xbcLogEQExpr_.setup(doc);
        return (xbcLogEQExpr_);
    }

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcLogNEQExpr
     */
    public XbcLogNEQExpr createXbcLogNEQExpr(Document doc) {
        XbcLogNEQExpr xbcLogNEQExpr_ = createXbcLogNEQExpr();
        xbcLogNEQExpr_.setup(doc);
        return (xbcLogNEQExpr_);
    }

    /**
     * Creates a <code>XbcLogGEExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcLogGEExpr
     */
    public XbcLogGEExpr createXbcLogGEExpr(Document doc) {
        XbcLogGEExpr xbcLogGEExpr_ = createXbcLogGEExpr();
        xbcLogGEExpr_.setup(doc);
        return (xbcLogGEExpr_);
    }

    /**
     * Creates a <code>XbcLogLTExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcLogLTExpr
     */
    public XbcLogLTExpr createXbcLogLTExpr(Document doc) {
        XbcLogLTExpr xbcLogLTExpr_ = createXbcLogLTExpr();
        xbcLogLTExpr_.setup(doc);
        return (xbcLogLTExpr_);
    }

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcGccAlignOfExpr
     */
    public XbcGccAlignOfExpr createXbcGccAlignOfExpr(Document doc) {
        XbcGccAlignOfExpr xbcGccAlignOfExpr_ = createXbcGccAlignOfExpr();
        xbcGccAlignOfExpr_.setup(doc);
        return (xbcGccAlignOfExpr_);
    }

    /**
     * Creates a <code>XbcAssignExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcAssignExpr
     */
    public XbcAssignExpr createXbcAssignExpr(Document doc) {
        XbcAssignExpr xbcAssignExpr_ = createXbcAssignExpr();
        xbcAssignExpr_.setup(doc);
        return (xbcAssignExpr_);
    }

    /**
     * Creates a <code>XbcMulExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcMulExpr
     */
    public XbcMulExpr createXbcMulExpr(Document doc) {
        XbcMulExpr xbcMulExpr_ = createXbcMulExpr();
        xbcMulExpr_.setup(doc);
        return (xbcMulExpr_);
    }

    /**
     * Creates a <code>XbcDivExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcDivExpr
     */
    public XbcDivExpr createXbcDivExpr(Document doc) {
        XbcDivExpr xbcDivExpr_ = createXbcDivExpr();
        xbcDivExpr_.setup(doc);
        return (xbcDivExpr_);
    }

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcAsgMulExpr
     */
    public XbcAsgMulExpr createXbcAsgMulExpr(Document doc) {
        XbcAsgMulExpr xbcAsgMulExpr_ = createXbcAsgMulExpr();
        xbcAsgMulExpr_.setup(doc);
        return (xbcAsgMulExpr_);
    }

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcAsgRshiftExpr
     */
    public XbcAsgRshiftExpr createXbcAsgRshiftExpr(Document doc) {
        XbcAsgRshiftExpr xbcAsgRshiftExpr_ = createXbcAsgRshiftExpr();
        xbcAsgRshiftExpr_.setup(doc);
        return (xbcAsgRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcAsgBitAndExpr
     */
    public XbcAsgBitAndExpr createXbcAsgBitAndExpr(Document doc) {
        XbcAsgBitAndExpr xbcAsgBitAndExpr_ = createXbcAsgBitAndExpr();
        xbcAsgBitAndExpr_.setup(doc);
        return (xbcAsgBitAndExpr_);
    }

    /**
     * Creates a <code>XbcLogLEExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcLogLEExpr
     */
    public XbcLogLEExpr createXbcLogLEExpr(Document doc) {
        XbcLogLEExpr xbcLogLEExpr_ = createXbcLogLEExpr();
        xbcLogLEExpr_.setup(doc);
        return (xbcLogLEExpr_);
    }

    /**
     * Creates a <code>XbcLogAndExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcLogAndExpr
     */
    public XbcLogAndExpr createXbcLogAndExpr(Document doc) {
        XbcLogAndExpr xbcLogAndExpr_ = createXbcLogAndExpr();
        xbcLogAndExpr_.setup(doc);
        return (xbcLogAndExpr_);
    }

    /**
     * Creates a <code>XbcCommaExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcCommaExpr
     */
    public XbcCommaExpr createXbcCommaExpr(Document doc) {
        XbcCommaExpr xbcCommaExpr_ = createXbcCommaExpr();
        xbcCommaExpr_.setup(doc);
        return (xbcCommaExpr_);
    }

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcAsgDivExpr
     */
    public XbcAsgDivExpr createXbcAsgDivExpr(Document doc) {
        XbcAsgDivExpr xbcAsgDivExpr_ = createXbcAsgDivExpr();
        xbcAsgDivExpr_.setup(doc);
        return (xbcAsgDivExpr_);
    }

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcGccLabelAddr
     */
    public XbcGccLabelAddr createXbcGccLabelAddr(Document doc) {
        XbcGccLabelAddr xbcGccLabelAddr_ = createXbcGccLabelAddr();
        xbcGccLabelAddr_.setup(doc);
        return (xbcGccLabelAddr_);
    }

    /**
     * Creates a <code>XbcBitAndExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcBitAndExpr
     */
    public XbcBitAndExpr createXbcBitAndExpr(Document doc) {
        XbcBitAndExpr xbcBitAndExpr_ = createXbcBitAndExpr();
        xbcBitAndExpr_.setup(doc);
        return (xbcBitAndExpr_);
    }

    /**
     * Creates a <code>XbcBitXorExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcBitXorExpr
     */
    public XbcBitXorExpr createXbcBitXorExpr(Document doc) {
        XbcBitXorExpr xbcBitXorExpr_ = createXbcBitXorExpr();
        xbcBitXorExpr_.setup(doc);
        return (xbcBitXorExpr_);
    }

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcAsgMinusExpr
     */
    public XbcAsgMinusExpr createXbcAsgMinusExpr(Document doc) {
        XbcAsgMinusExpr xbcAsgMinusExpr_ = createXbcAsgMinusExpr();
        xbcAsgMinusExpr_.setup(doc);
        return (xbcAsgMinusExpr_);
    }

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcAsgLshiftExpr
     */
    public XbcAsgLshiftExpr createXbcAsgLshiftExpr(Document doc) {
        XbcAsgLshiftExpr xbcAsgLshiftExpr_ = createXbcAsgLshiftExpr();
        xbcAsgLshiftExpr_.setup(doc);
        return (xbcAsgLshiftExpr_);
    }

    /**
     * Creates a <code>XbcMemberAddr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcMemberAddr
     */
    public XbcMemberAddr createXbcMemberAddr(Document doc) {
        XbcMemberAddr xbcMemberAddr_ = createXbcMemberAddr();
        xbcMemberAddr_.setup(doc);
        return (xbcMemberAddr_);
    }

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcMemberArrayRef
     */
    public XbcMemberArrayRef createXbcMemberArrayRef(Document doc) {
        XbcMemberArrayRef xbcMemberArrayRef_ = createXbcMemberArrayRef();
        xbcMemberArrayRef_.setup(doc);
        return (xbcMemberArrayRef_);
    }

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcMemberArrayAddr
     */
    public XbcMemberArrayAddr createXbcMemberArrayAddr(Document doc) {
        XbcMemberArrayAddr xbcMemberArrayAddr_ = createXbcMemberArrayAddr();
        xbcMemberArrayAddr_.setup(doc);
        return (xbcMemberArrayAddr_);
    }

    /**
     * Creates a <code>XbcTypeName</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcTypeName
     */
    public XbcTypeName createXbcTypeName(Document doc) {
        XbcTypeName xbcTypeName_ = createXbcTypeName();
        xbcTypeName_.setup(doc);
        return (xbcTypeName_);
    }

    /**
     * Creates a <code>XbcPointerRef</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcPointerRef
     */
    public XbcPointerRef createXbcPointerRef(Document doc) {
        XbcPointerRef xbcPointerRef_ = createXbcPointerRef();
        xbcPointerRef_.setup(doc);
        return (xbcPointerRef_);
    }

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcUnaryMinusExpr
     */
    public XbcUnaryMinusExpr createXbcUnaryMinusExpr(Document doc) {
        XbcUnaryMinusExpr xbcUnaryMinusExpr_ = createXbcUnaryMinusExpr();
        xbcUnaryMinusExpr_.setup(doc);
        return (xbcUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbcBitNotExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcBitNotExpr
     */
    public XbcBitNotExpr createXbcBitNotExpr(Document doc) {
        XbcBitNotExpr xbcBitNotExpr_ = createXbcBitNotExpr();
        xbcBitNotExpr_.setup(doc);
        return (xbcBitNotExpr_);
    }

    /**
     * Creates a <code>XbcLogNotExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcLogNotExpr
     */
    public XbcLogNotExpr createXbcLogNotExpr(Document doc) {
        XbcLogNotExpr xbcLogNotExpr_ = createXbcLogNotExpr();
        xbcLogNotExpr_.setup(doc);
        return (xbcLogNotExpr_);
    }

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcPostIncrExpr
     */
    public XbcPostIncrExpr createXbcPostIncrExpr(Document doc) {
        XbcPostIncrExpr xbcPostIncrExpr_ = createXbcPostIncrExpr();
        xbcPostIncrExpr_.setup(doc);
        return (xbcPostIncrExpr_);
    }

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcPostDecrExpr
     */
    public XbcPostDecrExpr createXbcPostDecrExpr(Document doc) {
        XbcPostDecrExpr xbcPostDecrExpr_ = createXbcPostDecrExpr();
        xbcPostDecrExpr_.setup(doc);
        return (xbcPostDecrExpr_);
    }

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcPreIncrExpr
     */
    public XbcPreIncrExpr createXbcPreIncrExpr(Document doc) {
        XbcPreIncrExpr xbcPreIncrExpr_ = createXbcPreIncrExpr();
        xbcPreIncrExpr_.setup(doc);
        return (xbcPreIncrExpr_);
    }

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcPreDecrExpr
     */
    public XbcPreDecrExpr createXbcPreDecrExpr(Document doc) {
        XbcPreDecrExpr xbcPreDecrExpr_ = createXbcPreDecrExpr();
        xbcPreDecrExpr_.setup(doc);
        return (xbcPreDecrExpr_);
    }

    /**
     * Creates a <code>XbcIndexRange</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcIndexRange
     */
    public XbcIndexRange createXbcIndexRange(Document doc) {
        XbcIndexRange xbcIndexRange_ = createXbcIndexRange();
        xbcIndexRange_.setup(doc);
        return (xbcIndexRange_);
    }

    /**
     * Creates a <code>XbcLowerBound</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcLowerBound
     */
    public XbcLowerBound createXbcLowerBound(Document doc) {
        XbcLowerBound xbcLowerBound_ = createXbcLowerBound();
        xbcLowerBound_.setup(doc);
        return (xbcLowerBound_);
    }

    /**
     * Creates a <code>XbcUpperBound</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcUpperBound
     */
    public XbcUpperBound createXbcUpperBound(Document doc) {
        XbcUpperBound xbcUpperBound_ = createXbcUpperBound();
        xbcUpperBound_.setup(doc);
        return (xbcUpperBound_);
    }

    /**
     * Creates a <code>XbcStep</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcStep
     */
    public XbcStep createXbcStep(Document doc) {
        XbcStep xbcStep_ = createXbcStep();
        xbcStep_.setup(doc);
        return (xbcStep_);
    }

    /**
     * Creates a <code>XbcDesignatedValue</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcDesignatedValue
     */
    public XbcDesignatedValue createXbcDesignatedValue(Document doc) {
        XbcDesignatedValue xbcDesignatedValue_ = createXbcDesignatedValue();
        xbcDesignatedValue_.setup(doc);
        return (xbcDesignatedValue_);
    }

    /**
     * Creates a <code>XbcCompoundValue</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcCompoundValue
     */
    public XbcCompoundValue createXbcCompoundValue(Document doc) {
        XbcCompoundValue xbcCompoundValue_ = createXbcCompoundValue();
        xbcCompoundValue_.setup(doc);
        return (xbcCompoundValue_);
    }

    /**
     * Creates a <code>XbcBitField</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcBitField
     */
    public XbcBitField createXbcBitField(Document doc) {
        XbcBitField xbcBitField_ = createXbcBitField();
        xbcBitField_.setup(doc);
        return (xbcBitField_);
    }

    /**
     * Creates a <code>XbcPragma</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcPragma
     */
    public XbcPragma createXbcPragma(Document doc) {
        XbcPragma xbcPragma_ = createXbcPragma();
        xbcPragma_.setup(doc);
        return (xbcPragma_);
    }

    /**
     * Creates a <code>XbcText</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcText
     */
    public XbcText createXbcText(Document doc) {
        XbcText xbcText_ = createXbcText();
        xbcText_.setup(doc);
        return (xbcText_);
    }

    /**
     * Creates a <code>XbcDeclarations</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcDeclarations
     */
    public XbcDeclarations createXbcDeclarations(Document doc) {
        XbcDeclarations xbcDeclarations_ = createXbcDeclarations();
        xbcDeclarations_.setup(doc);
        return (xbcDeclarations_);
    }

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcFunctionDefinition
     */
    public XbcFunctionDefinition createXbcFunctionDefinition(Document doc) {
        XbcFunctionDefinition xbcFunctionDefinition_ = createXbcFunctionDefinition();
        xbcFunctionDefinition_.setup(doc);
        return (xbcFunctionDefinition_);
    }

    /**
     * Creates a <code>XbcParams</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcParams
     */
    public XbcParams createXbcParams(Document doc) {
        XbcParams xbcParams_ = createXbcParams();
        xbcParams_.setup(doc);
        return (xbcParams_);
    }

    /**
     * Creates a <code>XbcBody</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcBody
     */
    public XbcBody createXbcBody(Document doc) {
        XbcBody xbcBody_ = createXbcBody();
        xbcBody_.setup(doc);
        return (xbcBody_);
    }

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcGccAsmStatement
     */
    public XbcGccAsmStatement createXbcGccAsmStatement(Document doc) {
        XbcGccAsmStatement xbcGccAsmStatement_ = createXbcGccAsmStatement();
        xbcGccAsmStatement_.setup(doc);
        return (xbcGccAsmStatement_);
    }

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcGccAsmOperands
     */
    public XbcGccAsmOperands createXbcGccAsmOperands(Document doc) {
        XbcGccAsmOperands xbcGccAsmOperands_ = createXbcGccAsmOperands();
        xbcGccAsmOperands_.setup(doc);
        return (xbcGccAsmOperands_);
    }

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcGccAsmOperand
     */
    public XbcGccAsmOperand createXbcGccAsmOperand(Document doc) {
        XbcGccAsmOperand xbcGccAsmOperand_ = createXbcGccAsmOperand();
        xbcGccAsmOperand_.setup(doc);
        return (xbcGccAsmOperand_);
    }

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcGccAsmClobbers
     */
    public XbcGccAsmClobbers createXbcGccAsmClobbers(Document doc) {
        XbcGccAsmClobbers xbcGccAsmClobbers_ = createXbcGccAsmClobbers();
        xbcGccAsmClobbers_.setup(doc);
        return (xbcGccAsmClobbers_);
    }

    /**
     * Creates a <code>XbcForStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcForStatement
     */
    public XbcForStatement createXbcForStatement(Document doc) {
        XbcForStatement xbcForStatement_ = createXbcForStatement();
        xbcForStatement_.setup(doc);
        return (xbcForStatement_);
    }

    /**
     * Creates a <code>XbcInit</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcInit
     */
    public XbcInit createXbcInit(Document doc) {
        XbcInit xbcInit_ = createXbcInit();
        xbcInit_.setup(doc);
        return (xbcInit_);
    }

    /**
     * Creates a <code>XbcCondition</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcCondition
     */
    public XbcCondition createXbcCondition(Document doc) {
        XbcCondition xbcCondition_ = createXbcCondition();
        xbcCondition_.setup(doc);
        return (xbcCondition_);
    }

    /**
     * Creates a <code>XbcIter</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcIter
     */
    public XbcIter createXbcIter(Document doc) {
        XbcIter xbcIter_ = createXbcIter();
        xbcIter_.setup(doc);
        return (xbcIter_);
    }

    /**
     * Creates a <code>XbcIfStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcIfStatement
     */
    public XbcIfStatement createXbcIfStatement(Document doc) {
        XbcIfStatement xbcIfStatement_ = createXbcIfStatement();
        xbcIfStatement_.setup(doc);
        return (xbcIfStatement_);
    }

    /**
     * Creates a <code>XbcThen</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcThen
     */
    public XbcThen createXbcThen(Document doc) {
        XbcThen xbcThen_ = createXbcThen();
        xbcThen_.setup(doc);
        return (xbcThen_);
    }

    /**
     * Creates a <code>XbcElse</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcElse
     */
    public XbcElse createXbcElse(Document doc) {
        XbcElse xbcElse_ = createXbcElse();
        xbcElse_.setup(doc);
        return (xbcElse_);
    }

    /**
     * Creates a <code>XbcWhileStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcWhileStatement
     */
    public XbcWhileStatement createXbcWhileStatement(Document doc) {
        XbcWhileStatement xbcWhileStatement_ = createXbcWhileStatement();
        xbcWhileStatement_.setup(doc);
        return (xbcWhileStatement_);
    }

    /**
     * Creates a <code>XbcDoStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcDoStatement
     */
    public XbcDoStatement createXbcDoStatement(Document doc) {
        XbcDoStatement xbcDoStatement_ = createXbcDoStatement();
        xbcDoStatement_.setup(doc);
        return (xbcDoStatement_);
    }

    /**
     * Creates a <code>XbcSwitchStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcSwitchStatement
     */
    public XbcSwitchStatement createXbcSwitchStatement(Document doc) {
        XbcSwitchStatement xbcSwitchStatement_ = createXbcSwitchStatement();
        xbcSwitchStatement_.setup(doc);
        return (xbcSwitchStatement_);
    }

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcGccRangedCaseLabel
     */
    public XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(Document doc) {
        XbcGccRangedCaseLabel xbcGccRangedCaseLabel_ = createXbcGccRangedCaseLabel();
        xbcGccRangedCaseLabel_.setup(doc);
        return (xbcGccRangedCaseLabel_);
    }

    /**
     * Creates a <code>XbcStatementLabel</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcStatementLabel
     */
    public XbcStatementLabel createXbcStatementLabel(Document doc) {
        XbcStatementLabel xbcStatementLabel_ = createXbcStatementLabel();
        xbcStatementLabel_.setup(doc);
        return (xbcStatementLabel_);
    }

    /**
     * Creates a <code>XbcCaseLabel</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcCaseLabel
     */
    public XbcCaseLabel createXbcCaseLabel(Document doc) {
        XbcCaseLabel xbcCaseLabel_ = createXbcCaseLabel();
        xbcCaseLabel_.setup(doc);
        return (xbcCaseLabel_);
    }

    /**
     * Creates a <code>XbcBreakStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcBreakStatement
     */
    public XbcBreakStatement createXbcBreakStatement(Document doc) {
        XbcBreakStatement xbcBreakStatement_ = createXbcBreakStatement();
        xbcBreakStatement_.setup(doc);
        return (xbcBreakStatement_);
    }

    /**
     * Creates a <code>XbcContinueStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcContinueStatement
     */
    public XbcContinueStatement createXbcContinueStatement(Document doc) {
        XbcContinueStatement xbcContinueStatement_ = createXbcContinueStatement();
        xbcContinueStatement_.setup(doc);
        return (xbcContinueStatement_);
    }

    /**
     * Creates a <code>XbcReturnStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcReturnStatement
     */
    public XbcReturnStatement createXbcReturnStatement(Document doc) {
        XbcReturnStatement xbcReturnStatement_ = createXbcReturnStatement();
        xbcReturnStatement_.setup(doc);
        return (xbcReturnStatement_);
    }

    /**
     * Creates a <code>XbcGotoStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcGotoStatement
     */
    public XbcGotoStatement createXbcGotoStatement(Document doc) {
        XbcGotoStatement xbcGotoStatement_ = createXbcGotoStatement();
        xbcGotoStatement_.setup(doc);
        return (xbcGotoStatement_);
    }

    /**
     * Creates a <code>XbcDefaultLabel</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcDefaultLabel
     */
    public XbcDefaultLabel createXbcDefaultLabel(Document doc) {
        XbcDefaultLabel xbcDefaultLabel_ = createXbcDefaultLabel();
        xbcDefaultLabel_.setup(doc);
        return (xbcDefaultLabel_);
    }

    /**
     * Creates a <code>XbcExprStatement</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcExprStatement
     */
    public XbcExprStatement createXbcExprStatement(Document doc) {
        XbcExprStatement xbcExprStatement_ = createXbcExprStatement();
        xbcExprStatement_.setup(doc);
        return (xbcExprStatement_);
    }

    /**
     * Creates a <code>XbcVarDecl</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcVarDecl
     */
    public XbcVarDecl createXbcVarDecl(Document doc) {
        XbcVarDecl xbcVarDecl_ = createXbcVarDecl();
        xbcVarDecl_.setup(doc);
        return (xbcVarDecl_);
    }

    /**
     * Creates a <code>XbcGccAsm</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcGccAsm
     */
    public XbcGccAsm createXbcGccAsm(Document doc) {
        XbcGccAsm xbcGccAsm_ = createXbcGccAsm();
        xbcGccAsm_.setup(doc);
        return (xbcGccAsm_);
    }

    /**
     * Creates a <code>XbcFunctionDecl</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcFunctionDecl
     */
    public XbcFunctionDecl createXbcFunctionDecl(Document doc) {
        XbcFunctionDecl xbcFunctionDecl_ = createXbcFunctionDecl();
        xbcFunctionDecl_.setup(doc);
        return (xbcFunctionDecl_);
    }

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcGccMemberDesignator
     */
    public XbcGccMemberDesignator createXbcGccMemberDesignator(Document doc) {
        XbcGccMemberDesignator xbcGccMemberDesignator_ = createXbcGccMemberDesignator();
        xbcGccMemberDesignator_.setup(doc);
        return (xbcGccMemberDesignator_);
    }

    /**
     * Creates a <code>XbcArrayType</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcArrayType
     */
    public XbcArrayType createXbcArrayType(Document doc) {
        XbcArrayType xbcArrayType_ = createXbcArrayType();
        xbcArrayType_.setup(doc);
        return (xbcArrayType_);
    }

    /**
     * Creates a <code>XbcArraySize</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcArraySize
     */
    public XbcArraySize createXbcArraySize(Document doc) {
        XbcArraySize xbcArraySize_ = createXbcArraySize();
        xbcArraySize_.setup(doc);
        return (xbcArraySize_);
    }

    /**
     * Creates a <code>XbcBasicType</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcBasicType
     */
    public XbcBasicType createXbcBasicType(Document doc) {
        XbcBasicType xbcBasicType_ = createXbcBasicType();
        xbcBasicType_.setup(doc);
        return (xbcBasicType_);
    }

    /**
     * Creates a <code>XbcPointerType</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcPointerType
     */
    public XbcPointerType createXbcPointerType(Document doc) {
        XbcPointerType xbcPointerType_ = createXbcPointerType();
        xbcPointerType_.setup(doc);
        return (xbcPointerType_);
    }

    /**
     * Creates a <code>XbcStructType</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcStructType
     */
    public XbcStructType createXbcStructType(Document doc) {
        XbcStructType xbcStructType_ = createXbcStructType();
        xbcStructType_.setup(doc);
        return (xbcStructType_);
    }

    /**
     * Creates a <code>XbcUnionType</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcUnionType
     */
    public XbcUnionType createXbcUnionType(Document doc) {
        XbcUnionType xbcUnionType_ = createXbcUnionType();
        xbcUnionType_.setup(doc);
        return (xbcUnionType_);
    }

    /**
     * Creates a <code>XbcEnumType</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcEnumType
     */
    public XbcEnumType createXbcEnumType(Document doc) {
        XbcEnumType xbcEnumType_ = createXbcEnumType();
        xbcEnumType_.setup(doc);
        return (xbcEnumType_);
    }

    /**
     * Creates a <code>XbcCoArrayType</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcCoArrayType
     */
    public XbcCoArrayType createXbcCoArrayType(Document doc) {
        XbcCoArrayType xbcCoArrayType_ = createXbcCoArrayType();
        xbcCoArrayType_.setup(doc);
        return (xbcCoArrayType_);
    }

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcGlobalSymbols
     */
    public XbcGlobalSymbols createXbcGlobalSymbols(Document doc) {
        XbcGlobalSymbols xbcGlobalSymbols_ = createXbcGlobalSymbols();
        xbcGlobalSymbols_.setup(doc);
        return (xbcGlobalSymbols_);
    }

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcGlobalDeclarations
     */
    public XbcGlobalDeclarations createXbcGlobalDeclarations(Document doc) {
        XbcGlobalDeclarations xbcGlobalDeclarations_ = createXbcGlobalDeclarations();
        xbcGlobalDeclarations_.setup(doc);
        return (xbcGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the Document <code>doc</code>.
     * This method is a template method for concrete classes.
     *
     * @param doc
     * @return XbcGccAsmDefinition
     */
    public XbcGccAsmDefinition createXbcGccAsmDefinition(Document doc) {
        XbcGccAsmDefinition xbcGccAsmDefinition_ = createXbcGccAsmDefinition();
        xbcGccAsmDefinition_.setup(doc);
        return (xbcGccAsmDefinition_);
    }

    /**
     * Creates a <code>XbcXcodeProgram</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcXcodeProgram
     */
    public XbcXcodeProgram createXbcXcodeProgram(Element element) {
        XbcXcodeProgram xbcXcodeProgram_ = createXbcXcodeProgram();
        xbcXcodeProgram_.setup(element);
        return (xbcXcodeProgram_);
    }

    /**
     * Creates a <code>XbcTypeTable</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcTypeTable
     */
    public XbcTypeTable createXbcTypeTable(Element element) {
        XbcTypeTable xbcTypeTable_ = createXbcTypeTable();
        xbcTypeTable_.setup(element);
        return (xbcTypeTable_);
    }

    /**
     * Creates a <code>XbcFunctionType</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcFunctionType
     */
    public XbcFunctionType createXbcFunctionType(Element element) {
        XbcFunctionType xbcFunctionType_ = createXbcFunctionType();
        xbcFunctionType_.setup(element);
        return (xbcFunctionType_);
    }

    /**
     * Creates a <code>XbcGccAttributes</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcGccAttributes
     */
    public XbcGccAttributes createXbcGccAttributes(Element element) {
        XbcGccAttributes xbcGccAttributes_ = createXbcGccAttributes();
        xbcGccAttributes_.setup(element);
        return (xbcGccAttributes_);
    }

    /**
     * Creates a <code>XbcGccAttribute</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcGccAttribute
     */
    public XbcGccAttribute createXbcGccAttribute(Element element) {
        XbcGccAttribute xbcGccAttribute_ = createXbcGccAttribute();
        xbcGccAttribute_.setup(element);
        return (xbcGccAttribute_);
    }

    /**
     * Creates a <code>XbcBuiltinOp</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcBuiltinOp
     */
    public XbcBuiltinOp createXbcBuiltinOp(Element element) {
        XbcBuiltinOp xbcBuiltinOp_ = createXbcBuiltinOp();
        xbcBuiltinOp_.setup(element);
        return (xbcBuiltinOp_);
    }

    /**
     * Creates a <code>XbcArrayRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcArrayRef
     */
    public XbcArrayRef createXbcArrayRef(Element element) {
        XbcArrayRef xbcArrayRef_ = createXbcArrayRef();
        xbcArrayRef_.setup(element);
        return (xbcArrayRef_);
    }

    /**
     * Creates a <code>XbcArrayAddr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcArrayAddr
     */
    public XbcArrayAddr createXbcArrayAddr(Element element) {
        XbcArrayAddr xbcArrayAddr_ = createXbcArrayAddr();
        xbcArrayAddr_.setup(element);
        return (xbcArrayAddr_);
    }

    /**
     * Creates a <code>XbcFunctionCall</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcFunctionCall
     */
    public XbcFunctionCall createXbcFunctionCall(Element element) {
        XbcFunctionCall xbcFunctionCall_ = createXbcFunctionCall();
        xbcFunctionCall_.setup(element);
        return (xbcFunctionCall_);
    }

    /**
     * Creates a <code>XbcFunction</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcFunction
     */
    public XbcFunction createXbcFunction(Element element) {
        XbcFunction xbcFunction_ = createXbcFunction();
        xbcFunction_.setup(element);
        return (xbcFunction_);
    }

    /**
     * Creates a <code>XbcArguments</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcArguments
     */
    public XbcArguments createXbcArguments(Element element) {
        XbcArguments xbcArguments_ = createXbcArguments();
        xbcArguments_.setup(element);
        return (xbcArguments_);
    }

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcGccCompoundExpr
     */
    public XbcGccCompoundExpr createXbcGccCompoundExpr(Element element) {
        XbcGccCompoundExpr xbcGccCompoundExpr_ = createXbcGccCompoundExpr();
        xbcGccCompoundExpr_.setup(element);
        return (xbcGccCompoundExpr_);
    }

    /**
     * Creates a <code>XbcCompoundStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcCompoundStatement
     */
    public XbcCompoundStatement createXbcCompoundStatement(Element element) {
        XbcCompoundStatement xbcCompoundStatement_ = createXbcCompoundStatement();
        xbcCompoundStatement_.setup(element);
        return (xbcCompoundStatement_);
    }

    /**
     * Creates a <code>XbcSymbols</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcSymbols
     */
    public XbcSymbols createXbcSymbols(Element element) {
        XbcSymbols xbcSymbols_ = createXbcSymbols();
        xbcSymbols_.setup(element);
        return (xbcSymbols_);
    }

    /**
     * Creates a <code>XbcId</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcId
     */
    public XbcId createXbcId(Element element) {
        XbcId xbcId_ = createXbcId();
        xbcId_.setup(element);
        return (xbcId_);
    }

    /**
     * Creates a <code>XbcName</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcName
     */
    public XbcName createXbcName(Element element) {
        XbcName xbcName_ = createXbcName();
        xbcName_.setup(element);
        return (xbcName_);
    }

    /**
     * Creates a <code>XbcValue</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcValue
     */
    public XbcValue createXbcValue(Element element) {
        XbcValue xbcValue_ = createXbcValue();
        xbcValue_.setup(element);
        return (xbcValue_);
    }

    /**
     * Creates a <code>XbcSubArrayRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcSubArrayRef
     */
    public XbcSubArrayRef createXbcSubArrayRef(Element element) {
        XbcSubArrayRef xbcSubArrayRef_ = createXbcSubArrayRef();
        xbcSubArrayRef_.setup(element);
        return (xbcSubArrayRef_);
    }

    /**
     * Creates a <code>XbcCoArrayRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcCoArrayRef
     */
    public XbcCoArrayRef createXbcCoArrayRef(Element element) {
        XbcCoArrayRef xbcCoArrayRef_ = createXbcCoArrayRef();
        xbcCoArrayRef_.setup(element);
        return (xbcCoArrayRef_);
    }

    /**
     * Creates a <code>XbcVar</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcVar
     */
    public XbcVar createXbcVar(Element element) {
        XbcVar xbcVar_ = createXbcVar();
        xbcVar_.setup(element);
        return (xbcVar_);
    }

    /**
     * Creates a <code>XbcMemberRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcMemberRef
     */
    public XbcMemberRef createXbcMemberRef(Element element) {
        XbcMemberRef xbcMemberRef_ = createXbcMemberRef();
        xbcMemberRef_.setup(element);
        return (xbcMemberRef_);
    }

    /**
     * Creates a <code>XbcCastExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcCastExpr
     */
    public XbcCastExpr createXbcCastExpr(Element element) {
        XbcCastExpr xbcCastExpr_ = createXbcCastExpr();
        xbcCastExpr_.setup(element);
        return (xbcCastExpr_);
    }

    /**
     * Creates a <code>XbcStringConstant</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcStringConstant
     */
    public XbcStringConstant createXbcStringConstant(Element element) {
        XbcStringConstant xbcStringConstant_ = createXbcStringConstant();
        xbcStringConstant_.setup(element);
        return (xbcStringConstant_);
    }

    /**
     * Creates a <code>XbcVarAddr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcVarAddr
     */
    public XbcVarAddr createXbcVarAddr(Element element) {
        XbcVarAddr xbcVarAddr_ = createXbcVarAddr();
        xbcVarAddr_.setup(element);
        return (xbcVarAddr_);
    }

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcCompoundValueExpr
     */
    public XbcCompoundValueExpr createXbcCompoundValueExpr(Element element) {
        XbcCompoundValueExpr xbcCompoundValueExpr_ = createXbcCompoundValueExpr();
        xbcCompoundValueExpr_.setup(element);
        return (xbcCompoundValueExpr_);
    }

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcCompoundValueAddrExpr
     */
    public XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(Element element) {
        XbcCompoundValueAddrExpr xbcCompoundValueAddrExpr_ = createXbcCompoundValueAddrExpr();
        xbcCompoundValueAddrExpr_.setup(element);
        return (xbcCompoundValueAddrExpr_);
    }

    /**
     * Creates a <code>XbcXmpDescOf</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcXmpDescOf
     */
    public XbcXmpDescOf createXbcXmpDescOf(Element element) {
        XbcXmpDescOf xbcXmpDescOf_ = createXbcXmpDescOf();
        xbcXmpDescOf_.setup(element);
        return (xbcXmpDescOf_);
    }

    /**
     * Creates a <code>XbcIntConstant</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcIntConstant
     */
    public XbcIntConstant createXbcIntConstant(Element element) {
        XbcIntConstant xbcIntConstant_ = createXbcIntConstant();
        xbcIntConstant_.setup(element);
        return (xbcIntConstant_);
    }

    /**
     * Creates a <code>XbcFloatConstant</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcFloatConstant
     */
    public XbcFloatConstant createXbcFloatConstant(Element element) {
        XbcFloatConstant xbcFloatConstant_ = createXbcFloatConstant();
        xbcFloatConstant_.setup(element);
        return (xbcFloatConstant_);
    }

    /**
     * Creates a <code>XbcLonglongConstant</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcLonglongConstant
     */
    public XbcLonglongConstant createXbcLonglongConstant(Element element) {
        XbcLonglongConstant xbcLonglongConstant_ = createXbcLonglongConstant();
        xbcLonglongConstant_.setup(element);
        return (xbcLonglongConstant_);
    }

    /**
     * Creates a <code>XbcMoeConstant</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcMoeConstant
     */
    public XbcMoeConstant createXbcMoeConstant(Element element) {
        XbcMoeConstant xbcMoeConstant_ = createXbcMoeConstant();
        xbcMoeConstant_.setup(element);
        return (xbcMoeConstant_);
    }

    /**
     * Creates a <code>XbcFuncAddr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcFuncAddr
     */
    public XbcFuncAddr createXbcFuncAddr(Element element) {
        XbcFuncAddr xbcFuncAddr_ = createXbcFuncAddr();
        xbcFuncAddr_.setup(element);
        return (xbcFuncAddr_);
    }

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcSizeOfExpr
     */
    public XbcSizeOfExpr createXbcSizeOfExpr(Element element) {
        XbcSizeOfExpr xbcSizeOfExpr_ = createXbcSizeOfExpr();
        xbcSizeOfExpr_.setup(element);
        return (xbcSizeOfExpr_);
    }

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcCoArrayAssignExpr
     */
    public XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(Element element) {
        XbcCoArrayAssignExpr xbcCoArrayAssignExpr_ = createXbcCoArrayAssignExpr();
        xbcCoArrayAssignExpr_.setup(element);
        return (xbcCoArrayAssignExpr_);
    }

    /**
     * Creates a <code>XbcModExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcModExpr
     */
    public XbcModExpr createXbcModExpr(Element element) {
        XbcModExpr xbcModExpr_ = createXbcModExpr();
        xbcModExpr_.setup(element);
        return (xbcModExpr_);
    }

    /**
     * Creates a <code>XbcBitOrExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcBitOrExpr
     */
    public XbcBitOrExpr createXbcBitOrExpr(Element element) {
        XbcBitOrExpr xbcBitOrExpr_ = createXbcBitOrExpr();
        xbcBitOrExpr_.setup(element);
        return (xbcBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogOrExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcLogOrExpr
     */
    public XbcLogOrExpr createXbcLogOrExpr(Element element) {
        XbcLogOrExpr xbcLogOrExpr_ = createXbcLogOrExpr();
        xbcLogOrExpr_.setup(element);
        return (xbcLogOrExpr_);
    }

    /**
     * Creates a <code>XbcPlusExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcPlusExpr
     */
    public XbcPlusExpr createXbcPlusExpr(Element element) {
        XbcPlusExpr xbcPlusExpr_ = createXbcPlusExpr();
        xbcPlusExpr_.setup(element);
        return (xbcPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcAsgPlusExpr
     */
    public XbcAsgPlusExpr createXbcAsgPlusExpr(Element element) {
        XbcAsgPlusExpr xbcAsgPlusExpr_ = createXbcAsgPlusExpr();
        xbcAsgPlusExpr_.setup(element);
        return (xbcAsgPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgModExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcAsgModExpr
     */
    public XbcAsgModExpr createXbcAsgModExpr(Element element) {
        XbcAsgModExpr xbcAsgModExpr_ = createXbcAsgModExpr();
        xbcAsgModExpr_.setup(element);
        return (xbcAsgModExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcAsgBitOrExpr
     */
    public XbcAsgBitOrExpr createXbcAsgBitOrExpr(Element element) {
        XbcAsgBitOrExpr xbcAsgBitOrExpr_ = createXbcAsgBitOrExpr();
        xbcAsgBitOrExpr_.setup(element);
        return (xbcAsgBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogGTExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcLogGTExpr
     */
    public XbcLogGTExpr createXbcLogGTExpr(Element element) {
        XbcLogGTExpr xbcLogGTExpr_ = createXbcLogGTExpr();
        xbcLogGTExpr_.setup(element);
        return (xbcLogGTExpr_);
    }

    /**
     * Creates a <code>XbcCondExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcCondExpr
     */
    public XbcCondExpr createXbcCondExpr(Element element) {
        XbcCondExpr xbcCondExpr_ = createXbcCondExpr();
        xbcCondExpr_.setup(element);
        return (xbcCondExpr_);
    }

    /**
     * Creates a <code>XbcMinusExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcMinusExpr
     */
    public XbcMinusExpr createXbcMinusExpr(Element element) {
        XbcMinusExpr xbcMinusExpr_ = createXbcMinusExpr();
        xbcMinusExpr_.setup(element);
        return (xbcMinusExpr_);
    }

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcAddrOfExpr
     */
    public XbcAddrOfExpr createXbcAddrOfExpr(Element element) {
        XbcAddrOfExpr xbcAddrOfExpr_ = createXbcAddrOfExpr();
        xbcAddrOfExpr_.setup(element);
        return (xbcAddrOfExpr_);
    }

    /**
     * Creates a <code>XbcLshiftExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcLshiftExpr
     */
    public XbcLshiftExpr createXbcLshiftExpr(Element element) {
        XbcLshiftExpr xbcLshiftExpr_ = createXbcLshiftExpr();
        xbcLshiftExpr_.setup(element);
        return (xbcLshiftExpr_);
    }

    /**
     * Creates a <code>XbcRshiftExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcRshiftExpr
     */
    public XbcRshiftExpr createXbcRshiftExpr(Element element) {
        XbcRshiftExpr xbcRshiftExpr_ = createXbcRshiftExpr();
        xbcRshiftExpr_.setup(element);
        return (xbcRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcAsgBitXorExpr
     */
    public XbcAsgBitXorExpr createXbcAsgBitXorExpr(Element element) {
        XbcAsgBitXorExpr xbcAsgBitXorExpr_ = createXbcAsgBitXorExpr();
        xbcAsgBitXorExpr_.setup(element);
        return (xbcAsgBitXorExpr_);
    }

    /**
     * Creates a <code>XbcLogEQExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcLogEQExpr
     */
    public XbcLogEQExpr createXbcLogEQExpr(Element element) {
        XbcLogEQExpr xbcLogEQExpr_ = createXbcLogEQExpr();
        xbcLogEQExpr_.setup(element);
        return (xbcLogEQExpr_);
    }

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcLogNEQExpr
     */
    public XbcLogNEQExpr createXbcLogNEQExpr(Element element) {
        XbcLogNEQExpr xbcLogNEQExpr_ = createXbcLogNEQExpr();
        xbcLogNEQExpr_.setup(element);
        return (xbcLogNEQExpr_);
    }

    /**
     * Creates a <code>XbcLogGEExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcLogGEExpr
     */
    public XbcLogGEExpr createXbcLogGEExpr(Element element) {
        XbcLogGEExpr xbcLogGEExpr_ = createXbcLogGEExpr();
        xbcLogGEExpr_.setup(element);
        return (xbcLogGEExpr_);
    }

    /**
     * Creates a <code>XbcLogLTExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcLogLTExpr
     */
    public XbcLogLTExpr createXbcLogLTExpr(Element element) {
        XbcLogLTExpr xbcLogLTExpr_ = createXbcLogLTExpr();
        xbcLogLTExpr_.setup(element);
        return (xbcLogLTExpr_);
    }

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcGccAlignOfExpr
     */
    public XbcGccAlignOfExpr createXbcGccAlignOfExpr(Element element) {
        XbcGccAlignOfExpr xbcGccAlignOfExpr_ = createXbcGccAlignOfExpr();
        xbcGccAlignOfExpr_.setup(element);
        return (xbcGccAlignOfExpr_);
    }

    /**
     * Creates a <code>XbcAssignExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcAssignExpr
     */
    public XbcAssignExpr createXbcAssignExpr(Element element) {
        XbcAssignExpr xbcAssignExpr_ = createXbcAssignExpr();
        xbcAssignExpr_.setup(element);
        return (xbcAssignExpr_);
    }

    /**
     * Creates a <code>XbcMulExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcMulExpr
     */
    public XbcMulExpr createXbcMulExpr(Element element) {
        XbcMulExpr xbcMulExpr_ = createXbcMulExpr();
        xbcMulExpr_.setup(element);
        return (xbcMulExpr_);
    }

    /**
     * Creates a <code>XbcDivExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcDivExpr
     */
    public XbcDivExpr createXbcDivExpr(Element element) {
        XbcDivExpr xbcDivExpr_ = createXbcDivExpr();
        xbcDivExpr_.setup(element);
        return (xbcDivExpr_);
    }

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcAsgMulExpr
     */
    public XbcAsgMulExpr createXbcAsgMulExpr(Element element) {
        XbcAsgMulExpr xbcAsgMulExpr_ = createXbcAsgMulExpr();
        xbcAsgMulExpr_.setup(element);
        return (xbcAsgMulExpr_);
    }

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcAsgRshiftExpr
     */
    public XbcAsgRshiftExpr createXbcAsgRshiftExpr(Element element) {
        XbcAsgRshiftExpr xbcAsgRshiftExpr_ = createXbcAsgRshiftExpr();
        xbcAsgRshiftExpr_.setup(element);
        return (xbcAsgRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcAsgBitAndExpr
     */
    public XbcAsgBitAndExpr createXbcAsgBitAndExpr(Element element) {
        XbcAsgBitAndExpr xbcAsgBitAndExpr_ = createXbcAsgBitAndExpr();
        xbcAsgBitAndExpr_.setup(element);
        return (xbcAsgBitAndExpr_);
    }

    /**
     * Creates a <code>XbcLogLEExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcLogLEExpr
     */
    public XbcLogLEExpr createXbcLogLEExpr(Element element) {
        XbcLogLEExpr xbcLogLEExpr_ = createXbcLogLEExpr();
        xbcLogLEExpr_.setup(element);
        return (xbcLogLEExpr_);
    }

    /**
     * Creates a <code>XbcLogAndExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcLogAndExpr
     */
    public XbcLogAndExpr createXbcLogAndExpr(Element element) {
        XbcLogAndExpr xbcLogAndExpr_ = createXbcLogAndExpr();
        xbcLogAndExpr_.setup(element);
        return (xbcLogAndExpr_);
    }

    /**
     * Creates a <code>XbcCommaExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcCommaExpr
     */
    public XbcCommaExpr createXbcCommaExpr(Element element) {
        XbcCommaExpr xbcCommaExpr_ = createXbcCommaExpr();
        xbcCommaExpr_.setup(element);
        return (xbcCommaExpr_);
    }

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcAsgDivExpr
     */
    public XbcAsgDivExpr createXbcAsgDivExpr(Element element) {
        XbcAsgDivExpr xbcAsgDivExpr_ = createXbcAsgDivExpr();
        xbcAsgDivExpr_.setup(element);
        return (xbcAsgDivExpr_);
    }

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcGccLabelAddr
     */
    public XbcGccLabelAddr createXbcGccLabelAddr(Element element) {
        XbcGccLabelAddr xbcGccLabelAddr_ = createXbcGccLabelAddr();
        xbcGccLabelAddr_.setup(element);
        return (xbcGccLabelAddr_);
    }

    /**
     * Creates a <code>XbcBitAndExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcBitAndExpr
     */
    public XbcBitAndExpr createXbcBitAndExpr(Element element) {
        XbcBitAndExpr xbcBitAndExpr_ = createXbcBitAndExpr();
        xbcBitAndExpr_.setup(element);
        return (xbcBitAndExpr_);
    }

    /**
     * Creates a <code>XbcBitXorExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcBitXorExpr
     */
    public XbcBitXorExpr createXbcBitXorExpr(Element element) {
        XbcBitXorExpr xbcBitXorExpr_ = createXbcBitXorExpr();
        xbcBitXorExpr_.setup(element);
        return (xbcBitXorExpr_);
    }

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcAsgMinusExpr
     */
    public XbcAsgMinusExpr createXbcAsgMinusExpr(Element element) {
        XbcAsgMinusExpr xbcAsgMinusExpr_ = createXbcAsgMinusExpr();
        xbcAsgMinusExpr_.setup(element);
        return (xbcAsgMinusExpr_);
    }

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcAsgLshiftExpr
     */
    public XbcAsgLshiftExpr createXbcAsgLshiftExpr(Element element) {
        XbcAsgLshiftExpr xbcAsgLshiftExpr_ = createXbcAsgLshiftExpr();
        xbcAsgLshiftExpr_.setup(element);
        return (xbcAsgLshiftExpr_);
    }

    /**
     * Creates a <code>XbcMemberAddr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcMemberAddr
     */
    public XbcMemberAddr createXbcMemberAddr(Element element) {
        XbcMemberAddr xbcMemberAddr_ = createXbcMemberAddr();
        xbcMemberAddr_.setup(element);
        return (xbcMemberAddr_);
    }

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcMemberArrayRef
     */
    public XbcMemberArrayRef createXbcMemberArrayRef(Element element) {
        XbcMemberArrayRef xbcMemberArrayRef_ = createXbcMemberArrayRef();
        xbcMemberArrayRef_.setup(element);
        return (xbcMemberArrayRef_);
    }

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcMemberArrayAddr
     */
    public XbcMemberArrayAddr createXbcMemberArrayAddr(Element element) {
        XbcMemberArrayAddr xbcMemberArrayAddr_ = createXbcMemberArrayAddr();
        xbcMemberArrayAddr_.setup(element);
        return (xbcMemberArrayAddr_);
    }

    /**
     * Creates a <code>XbcTypeName</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcTypeName
     */
    public XbcTypeName createXbcTypeName(Element element) {
        XbcTypeName xbcTypeName_ = createXbcTypeName();
        xbcTypeName_.setup(element);
        return (xbcTypeName_);
    }

    /**
     * Creates a <code>XbcPointerRef</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcPointerRef
     */
    public XbcPointerRef createXbcPointerRef(Element element) {
        XbcPointerRef xbcPointerRef_ = createXbcPointerRef();
        xbcPointerRef_.setup(element);
        return (xbcPointerRef_);
    }

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcUnaryMinusExpr
     */
    public XbcUnaryMinusExpr createXbcUnaryMinusExpr(Element element) {
        XbcUnaryMinusExpr xbcUnaryMinusExpr_ = createXbcUnaryMinusExpr();
        xbcUnaryMinusExpr_.setup(element);
        return (xbcUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbcBitNotExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcBitNotExpr
     */
    public XbcBitNotExpr createXbcBitNotExpr(Element element) {
        XbcBitNotExpr xbcBitNotExpr_ = createXbcBitNotExpr();
        xbcBitNotExpr_.setup(element);
        return (xbcBitNotExpr_);
    }

    /**
     * Creates a <code>XbcLogNotExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcLogNotExpr
     */
    public XbcLogNotExpr createXbcLogNotExpr(Element element) {
        XbcLogNotExpr xbcLogNotExpr_ = createXbcLogNotExpr();
        xbcLogNotExpr_.setup(element);
        return (xbcLogNotExpr_);
    }

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcPostIncrExpr
     */
    public XbcPostIncrExpr createXbcPostIncrExpr(Element element) {
        XbcPostIncrExpr xbcPostIncrExpr_ = createXbcPostIncrExpr();
        xbcPostIncrExpr_.setup(element);
        return (xbcPostIncrExpr_);
    }

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcPostDecrExpr
     */
    public XbcPostDecrExpr createXbcPostDecrExpr(Element element) {
        XbcPostDecrExpr xbcPostDecrExpr_ = createXbcPostDecrExpr();
        xbcPostDecrExpr_.setup(element);
        return (xbcPostDecrExpr_);
    }

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcPreIncrExpr
     */
    public XbcPreIncrExpr createXbcPreIncrExpr(Element element) {
        XbcPreIncrExpr xbcPreIncrExpr_ = createXbcPreIncrExpr();
        xbcPreIncrExpr_.setup(element);
        return (xbcPreIncrExpr_);
    }

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcPreDecrExpr
     */
    public XbcPreDecrExpr createXbcPreDecrExpr(Element element) {
        XbcPreDecrExpr xbcPreDecrExpr_ = createXbcPreDecrExpr();
        xbcPreDecrExpr_.setup(element);
        return (xbcPreDecrExpr_);
    }

    /**
     * Creates a <code>XbcIndexRange</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcIndexRange
     */
    public XbcIndexRange createXbcIndexRange(Element element) {
        XbcIndexRange xbcIndexRange_ = createXbcIndexRange();
        xbcIndexRange_.setup(element);
        return (xbcIndexRange_);
    }

    /**
     * Creates a <code>XbcLowerBound</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcLowerBound
     */
    public XbcLowerBound createXbcLowerBound(Element element) {
        XbcLowerBound xbcLowerBound_ = createXbcLowerBound();
        xbcLowerBound_.setup(element);
        return (xbcLowerBound_);
    }

    /**
     * Creates a <code>XbcUpperBound</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcUpperBound
     */
    public XbcUpperBound createXbcUpperBound(Element element) {
        XbcUpperBound xbcUpperBound_ = createXbcUpperBound();
        xbcUpperBound_.setup(element);
        return (xbcUpperBound_);
    }

    /**
     * Creates a <code>XbcStep</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcStep
     */
    public XbcStep createXbcStep(Element element) {
        XbcStep xbcStep_ = createXbcStep();
        xbcStep_.setup(element);
        return (xbcStep_);
    }

    /**
     * Creates a <code>XbcDesignatedValue</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcDesignatedValue
     */
    public XbcDesignatedValue createXbcDesignatedValue(Element element) {
        XbcDesignatedValue xbcDesignatedValue_ = createXbcDesignatedValue();
        xbcDesignatedValue_.setup(element);
        return (xbcDesignatedValue_);
    }

    /**
     * Creates a <code>XbcCompoundValue</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcCompoundValue
     */
    public XbcCompoundValue createXbcCompoundValue(Element element) {
        XbcCompoundValue xbcCompoundValue_ = createXbcCompoundValue();
        xbcCompoundValue_.setup(element);
        return (xbcCompoundValue_);
    }

    /**
     * Creates a <code>XbcBitField</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcBitField
     */
    public XbcBitField createXbcBitField(Element element) {
        XbcBitField xbcBitField_ = createXbcBitField();
        xbcBitField_.setup(element);
        return (xbcBitField_);
    }

    /**
     * Creates a <code>XbcPragma</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcPragma
     */
    public XbcPragma createXbcPragma(Element element) {
        XbcPragma xbcPragma_ = createXbcPragma();
        xbcPragma_.setup(element);
        return (xbcPragma_);
    }

    /**
     * Creates a <code>XbcText</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcText
     */
    public XbcText createXbcText(Element element) {
        XbcText xbcText_ = createXbcText();
        xbcText_.setup(element);
        return (xbcText_);
    }

    /**
     * Creates a <code>XbcDeclarations</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcDeclarations
     */
    public XbcDeclarations createXbcDeclarations(Element element) {
        XbcDeclarations xbcDeclarations_ = createXbcDeclarations();
        xbcDeclarations_.setup(element);
        return (xbcDeclarations_);
    }

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcFunctionDefinition
     */
    public XbcFunctionDefinition createXbcFunctionDefinition(Element element) {
        XbcFunctionDefinition xbcFunctionDefinition_ = createXbcFunctionDefinition();
        xbcFunctionDefinition_.setup(element);
        return (xbcFunctionDefinition_);
    }

    /**
     * Creates a <code>XbcParams</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcParams
     */
    public XbcParams createXbcParams(Element element) {
        XbcParams xbcParams_ = createXbcParams();
        xbcParams_.setup(element);
        return (xbcParams_);
    }

    /**
     * Creates a <code>XbcBody</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcBody
     */
    public XbcBody createXbcBody(Element element) {
        XbcBody xbcBody_ = createXbcBody();
        xbcBody_.setup(element);
        return (xbcBody_);
    }

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcGccAsmStatement
     */
    public XbcGccAsmStatement createXbcGccAsmStatement(Element element) {
        XbcGccAsmStatement xbcGccAsmStatement_ = createXbcGccAsmStatement();
        xbcGccAsmStatement_.setup(element);
        return (xbcGccAsmStatement_);
    }

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcGccAsmOperands
     */
    public XbcGccAsmOperands createXbcGccAsmOperands(Element element) {
        XbcGccAsmOperands xbcGccAsmOperands_ = createXbcGccAsmOperands();
        xbcGccAsmOperands_.setup(element);
        return (xbcGccAsmOperands_);
    }

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcGccAsmOperand
     */
    public XbcGccAsmOperand createXbcGccAsmOperand(Element element) {
        XbcGccAsmOperand xbcGccAsmOperand_ = createXbcGccAsmOperand();
        xbcGccAsmOperand_.setup(element);
        return (xbcGccAsmOperand_);
    }

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcGccAsmClobbers
     */
    public XbcGccAsmClobbers createXbcGccAsmClobbers(Element element) {
        XbcGccAsmClobbers xbcGccAsmClobbers_ = createXbcGccAsmClobbers();
        xbcGccAsmClobbers_.setup(element);
        return (xbcGccAsmClobbers_);
    }

    /**
     * Creates a <code>XbcForStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcForStatement
     */
    public XbcForStatement createXbcForStatement(Element element) {
        XbcForStatement xbcForStatement_ = createXbcForStatement();
        xbcForStatement_.setup(element);
        return (xbcForStatement_);
    }

    /**
     * Creates a <code>XbcInit</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcInit
     */
    public XbcInit createXbcInit(Element element) {
        XbcInit xbcInit_ = createXbcInit();
        xbcInit_.setup(element);
        return (xbcInit_);
    }

    /**
     * Creates a <code>XbcCondition</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcCondition
     */
    public XbcCondition createXbcCondition(Element element) {
        XbcCondition xbcCondition_ = createXbcCondition();
        xbcCondition_.setup(element);
        return (xbcCondition_);
    }

    /**
     * Creates a <code>XbcIter</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcIter
     */
    public XbcIter createXbcIter(Element element) {
        XbcIter xbcIter_ = createXbcIter();
        xbcIter_.setup(element);
        return (xbcIter_);
    }

    /**
     * Creates a <code>XbcIfStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcIfStatement
     */
    public XbcIfStatement createXbcIfStatement(Element element) {
        XbcIfStatement xbcIfStatement_ = createXbcIfStatement();
        xbcIfStatement_.setup(element);
        return (xbcIfStatement_);
    }

    /**
     * Creates a <code>XbcThen</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcThen
     */
    public XbcThen createXbcThen(Element element) {
        XbcThen xbcThen_ = createXbcThen();
        xbcThen_.setup(element);
        return (xbcThen_);
    }

    /**
     * Creates a <code>XbcElse</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcElse
     */
    public XbcElse createXbcElse(Element element) {
        XbcElse xbcElse_ = createXbcElse();
        xbcElse_.setup(element);
        return (xbcElse_);
    }

    /**
     * Creates a <code>XbcWhileStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcWhileStatement
     */
    public XbcWhileStatement createXbcWhileStatement(Element element) {
        XbcWhileStatement xbcWhileStatement_ = createXbcWhileStatement();
        xbcWhileStatement_.setup(element);
        return (xbcWhileStatement_);
    }

    /**
     * Creates a <code>XbcDoStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcDoStatement
     */
    public XbcDoStatement createXbcDoStatement(Element element) {
        XbcDoStatement xbcDoStatement_ = createXbcDoStatement();
        xbcDoStatement_.setup(element);
        return (xbcDoStatement_);
    }

    /**
     * Creates a <code>XbcSwitchStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcSwitchStatement
     */
    public XbcSwitchStatement createXbcSwitchStatement(Element element) {
        XbcSwitchStatement xbcSwitchStatement_ = createXbcSwitchStatement();
        xbcSwitchStatement_.setup(element);
        return (xbcSwitchStatement_);
    }

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcGccRangedCaseLabel
     */
    public XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(Element element) {
        XbcGccRangedCaseLabel xbcGccRangedCaseLabel_ = createXbcGccRangedCaseLabel();
        xbcGccRangedCaseLabel_.setup(element);
        return (xbcGccRangedCaseLabel_);
    }

    /**
     * Creates a <code>XbcStatementLabel</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcStatementLabel
     */
    public XbcStatementLabel createXbcStatementLabel(Element element) {
        XbcStatementLabel xbcStatementLabel_ = createXbcStatementLabel();
        xbcStatementLabel_.setup(element);
        return (xbcStatementLabel_);
    }

    /**
     * Creates a <code>XbcCaseLabel</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcCaseLabel
     */
    public XbcCaseLabel createXbcCaseLabel(Element element) {
        XbcCaseLabel xbcCaseLabel_ = createXbcCaseLabel();
        xbcCaseLabel_.setup(element);
        return (xbcCaseLabel_);
    }

    /**
     * Creates a <code>XbcBreakStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcBreakStatement
     */
    public XbcBreakStatement createXbcBreakStatement(Element element) {
        XbcBreakStatement xbcBreakStatement_ = createXbcBreakStatement();
        xbcBreakStatement_.setup(element);
        return (xbcBreakStatement_);
    }

    /**
     * Creates a <code>XbcContinueStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcContinueStatement
     */
    public XbcContinueStatement createXbcContinueStatement(Element element) {
        XbcContinueStatement xbcContinueStatement_ = createXbcContinueStatement();
        xbcContinueStatement_.setup(element);
        return (xbcContinueStatement_);
    }

    /**
     * Creates a <code>XbcReturnStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcReturnStatement
     */
    public XbcReturnStatement createXbcReturnStatement(Element element) {
        XbcReturnStatement xbcReturnStatement_ = createXbcReturnStatement();
        xbcReturnStatement_.setup(element);
        return (xbcReturnStatement_);
    }

    /**
     * Creates a <code>XbcGotoStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcGotoStatement
     */
    public XbcGotoStatement createXbcGotoStatement(Element element) {
        XbcGotoStatement xbcGotoStatement_ = createXbcGotoStatement();
        xbcGotoStatement_.setup(element);
        return (xbcGotoStatement_);
    }

    /**
     * Creates a <code>XbcDefaultLabel</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcDefaultLabel
     */
    public XbcDefaultLabel createXbcDefaultLabel(Element element) {
        XbcDefaultLabel xbcDefaultLabel_ = createXbcDefaultLabel();
        xbcDefaultLabel_.setup(element);
        return (xbcDefaultLabel_);
    }

    /**
     * Creates a <code>XbcExprStatement</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcExprStatement
     */
    public XbcExprStatement createXbcExprStatement(Element element) {
        XbcExprStatement xbcExprStatement_ = createXbcExprStatement();
        xbcExprStatement_.setup(element);
        return (xbcExprStatement_);
    }

    /**
     * Creates a <code>XbcVarDecl</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcVarDecl
     */
    public XbcVarDecl createXbcVarDecl(Element element) {
        XbcVarDecl xbcVarDecl_ = createXbcVarDecl();
        xbcVarDecl_.setup(element);
        return (xbcVarDecl_);
    }

    /**
     * Creates a <code>XbcGccAsm</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcGccAsm
     */
    public XbcGccAsm createXbcGccAsm(Element element) {
        XbcGccAsm xbcGccAsm_ = createXbcGccAsm();
        xbcGccAsm_.setup(element);
        return (xbcGccAsm_);
    }

    /**
     * Creates a <code>XbcFunctionDecl</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcFunctionDecl
     */
    public XbcFunctionDecl createXbcFunctionDecl(Element element) {
        XbcFunctionDecl xbcFunctionDecl_ = createXbcFunctionDecl();
        xbcFunctionDecl_.setup(element);
        return (xbcFunctionDecl_);
    }

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcGccMemberDesignator
     */
    public XbcGccMemberDesignator createXbcGccMemberDesignator(Element element) {
        XbcGccMemberDesignator xbcGccMemberDesignator_ = createXbcGccMemberDesignator();
        xbcGccMemberDesignator_.setup(element);
        return (xbcGccMemberDesignator_);
    }

    /**
     * Creates a <code>XbcArrayType</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcArrayType
     */
    public XbcArrayType createXbcArrayType(Element element) {
        XbcArrayType xbcArrayType_ = createXbcArrayType();
        xbcArrayType_.setup(element);
        return (xbcArrayType_);
    }

    /**
     * Creates a <code>XbcArraySize</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcArraySize
     */
    public XbcArraySize createXbcArraySize(Element element) {
        XbcArraySize xbcArraySize_ = createXbcArraySize();
        xbcArraySize_.setup(element);
        return (xbcArraySize_);
    }

    /**
     * Creates a <code>XbcBasicType</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcBasicType
     */
    public XbcBasicType createXbcBasicType(Element element) {
        XbcBasicType xbcBasicType_ = createXbcBasicType();
        xbcBasicType_.setup(element);
        return (xbcBasicType_);
    }

    /**
     * Creates a <code>XbcPointerType</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcPointerType
     */
    public XbcPointerType createXbcPointerType(Element element) {
        XbcPointerType xbcPointerType_ = createXbcPointerType();
        xbcPointerType_.setup(element);
        return (xbcPointerType_);
    }

    /**
     * Creates a <code>XbcStructType</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcStructType
     */
    public XbcStructType createXbcStructType(Element element) {
        XbcStructType xbcStructType_ = createXbcStructType();
        xbcStructType_.setup(element);
        return (xbcStructType_);
    }

    /**
     * Creates a <code>XbcUnionType</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcUnionType
     */
    public XbcUnionType createXbcUnionType(Element element) {
        XbcUnionType xbcUnionType_ = createXbcUnionType();
        xbcUnionType_.setup(element);
        return (xbcUnionType_);
    }

    /**
     * Creates a <code>XbcEnumType</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcEnumType
     */
    public XbcEnumType createXbcEnumType(Element element) {
        XbcEnumType xbcEnumType_ = createXbcEnumType();
        xbcEnumType_.setup(element);
        return (xbcEnumType_);
    }

    /**
     * Creates a <code>XbcCoArrayType</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcCoArrayType
     */
    public XbcCoArrayType createXbcCoArrayType(Element element) {
        XbcCoArrayType xbcCoArrayType_ = createXbcCoArrayType();
        xbcCoArrayType_.setup(element);
        return (xbcCoArrayType_);
    }

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcGlobalSymbols
     */
    public XbcGlobalSymbols createXbcGlobalSymbols(Element element) {
        XbcGlobalSymbols xbcGlobalSymbols_ = createXbcGlobalSymbols();
        xbcGlobalSymbols_.setup(element);
        return (xbcGlobalSymbols_);
    }

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcGlobalDeclarations
     */
    public XbcGlobalDeclarations createXbcGlobalDeclarations(Element element) {
        XbcGlobalDeclarations xbcGlobalDeclarations_ = createXbcGlobalDeclarations();
        xbcGlobalDeclarations_.setup(element);
        return (xbcGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the Element <code>element</code>.
     * This method is a template method for concrete classes.
     *
     * @param element
     * @return XbcGccAsmDefinition
     */
    public XbcGccAsmDefinition createXbcGccAsmDefinition(Element element) {
        XbcGccAsmDefinition xbcGccAsmDefinition_ = createXbcGccAsmDefinition();
        xbcGccAsmDefinition_.setup(element);
        return (xbcGccAsmDefinition_);
    }

    /**
     * Creates a <code>XbcXcodeProgram</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcXcodeProgram
     */
    public XbcXcodeProgram createXbcXcodeProgram(RStack stack) {
        XbcXcodeProgram xbcXcodeProgram_ = createXbcXcodeProgram();
        xbcXcodeProgram_.setup(stack);
        return (xbcXcodeProgram_);
    }

    /**
     * Creates a <code>XbcTypeTable</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcTypeTable
     */
    public XbcTypeTable createXbcTypeTable(RStack stack) {
        XbcTypeTable xbcTypeTable_ = createXbcTypeTable();
        xbcTypeTable_.setup(stack);
        return (xbcTypeTable_);
    }

    /**
     * Creates a <code>XbcFunctionType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcFunctionType
     */
    public XbcFunctionType createXbcFunctionType(RStack stack) {
        XbcFunctionType xbcFunctionType_ = createXbcFunctionType();
        xbcFunctionType_.setup(stack);
        return (xbcFunctionType_);
    }

    /**
     * Creates a <code>XbcGccAttributes</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcGccAttributes
     */
    public XbcGccAttributes createXbcGccAttributes(RStack stack) {
        XbcGccAttributes xbcGccAttributes_ = createXbcGccAttributes();
        xbcGccAttributes_.setup(stack);
        return (xbcGccAttributes_);
    }

    /**
     * Creates a <code>XbcGccAttribute</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcGccAttribute
     */
    public XbcGccAttribute createXbcGccAttribute(RStack stack) {
        XbcGccAttribute xbcGccAttribute_ = createXbcGccAttribute();
        xbcGccAttribute_.setup(stack);
        return (xbcGccAttribute_);
    }

    /**
     * Creates a <code>XbcBuiltinOp</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcBuiltinOp
     */
    public XbcBuiltinOp createXbcBuiltinOp(RStack stack) {
        XbcBuiltinOp xbcBuiltinOp_ = createXbcBuiltinOp();
        xbcBuiltinOp_.setup(stack);
        return (xbcBuiltinOp_);
    }

    /**
     * Creates a <code>XbcArrayRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcArrayRef
     */
    public XbcArrayRef createXbcArrayRef(RStack stack) {
        XbcArrayRef xbcArrayRef_ = createXbcArrayRef();
        xbcArrayRef_.setup(stack);
        return (xbcArrayRef_);
    }

    /**
     * Creates a <code>XbcArrayAddr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcArrayAddr
     */
    public XbcArrayAddr createXbcArrayAddr(RStack stack) {
        XbcArrayAddr xbcArrayAddr_ = createXbcArrayAddr();
        xbcArrayAddr_.setup(stack);
        return (xbcArrayAddr_);
    }

    /**
     * Creates a <code>XbcFunctionCall</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcFunctionCall
     */
    public XbcFunctionCall createXbcFunctionCall(RStack stack) {
        XbcFunctionCall xbcFunctionCall_ = createXbcFunctionCall();
        xbcFunctionCall_.setup(stack);
        return (xbcFunctionCall_);
    }

    /**
     * Creates a <code>XbcFunction</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcFunction
     */
    public XbcFunction createXbcFunction(RStack stack) {
        XbcFunction xbcFunction_ = createXbcFunction();
        xbcFunction_.setup(stack);
        return (xbcFunction_);
    }

    /**
     * Creates a <code>XbcArguments</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcArguments
     */
    public XbcArguments createXbcArguments(RStack stack) {
        XbcArguments xbcArguments_ = createXbcArguments();
        xbcArguments_.setup(stack);
        return (xbcArguments_);
    }

    /**
     * Creates a <code>XbcGccCompoundExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcGccCompoundExpr
     */
    public XbcGccCompoundExpr createXbcGccCompoundExpr(RStack stack) {
        XbcGccCompoundExpr xbcGccCompoundExpr_ = createXbcGccCompoundExpr();
        xbcGccCompoundExpr_.setup(stack);
        return (xbcGccCompoundExpr_);
    }

    /**
     * Creates a <code>XbcCompoundStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcCompoundStatement
     */
    public XbcCompoundStatement createXbcCompoundStatement(RStack stack) {
        XbcCompoundStatement xbcCompoundStatement_ = createXbcCompoundStatement();
        xbcCompoundStatement_.setup(stack);
        return (xbcCompoundStatement_);
    }

    /**
     * Creates a <code>XbcSymbols</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcSymbols
     */
    public XbcSymbols createXbcSymbols(RStack stack) {
        XbcSymbols xbcSymbols_ = createXbcSymbols();
        xbcSymbols_.setup(stack);
        return (xbcSymbols_);
    }

    /**
     * Creates a <code>XbcId</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcId
     */
    public XbcId createXbcId(RStack stack) {
        XbcId xbcId_ = createXbcId();
        xbcId_.setup(stack);
        return (xbcId_);
    }

    /**
     * Creates a <code>XbcName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcName
     */
    public XbcName createXbcName(RStack stack) {
        XbcName xbcName_ = createXbcName();
        xbcName_.setup(stack);
        return (xbcName_);
    }

    /**
     * Creates a <code>XbcValue</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcValue
     */
    public XbcValue createXbcValue(RStack stack) {
        XbcValue xbcValue_ = createXbcValue();
        xbcValue_.setup(stack);
        return (xbcValue_);
    }

    /**
     * Creates a <code>XbcSubArrayRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcSubArrayRef
     */
    public XbcSubArrayRef createXbcSubArrayRef(RStack stack) {
        XbcSubArrayRef xbcSubArrayRef_ = createXbcSubArrayRef();
        xbcSubArrayRef_.setup(stack);
        return (xbcSubArrayRef_);
    }

    /**
     * Creates a <code>XbcCoArrayRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcCoArrayRef
     */
    public XbcCoArrayRef createXbcCoArrayRef(RStack stack) {
        XbcCoArrayRef xbcCoArrayRef_ = createXbcCoArrayRef();
        xbcCoArrayRef_.setup(stack);
        return (xbcCoArrayRef_);
    }

    /**
     * Creates a <code>XbcVar</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcVar
     */
    public XbcVar createXbcVar(RStack stack) {
        XbcVar xbcVar_ = createXbcVar();
        xbcVar_.setup(stack);
        return (xbcVar_);
    }

    /**
     * Creates a <code>XbcMemberRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcMemberRef
     */
    public XbcMemberRef createXbcMemberRef(RStack stack) {
        XbcMemberRef xbcMemberRef_ = createXbcMemberRef();
        xbcMemberRef_.setup(stack);
        return (xbcMemberRef_);
    }

    /**
     * Creates a <code>XbcCastExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcCastExpr
     */
    public XbcCastExpr createXbcCastExpr(RStack stack) {
        XbcCastExpr xbcCastExpr_ = createXbcCastExpr();
        xbcCastExpr_.setup(stack);
        return (xbcCastExpr_);
    }

    /**
     * Creates a <code>XbcStringConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcStringConstant
     */
    public XbcStringConstant createXbcStringConstant(RStack stack) {
        XbcStringConstant xbcStringConstant_ = createXbcStringConstant();
        xbcStringConstant_.setup(stack);
        return (xbcStringConstant_);
    }

    /**
     * Creates a <code>XbcVarAddr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcVarAddr
     */
    public XbcVarAddr createXbcVarAddr(RStack stack) {
        XbcVarAddr xbcVarAddr_ = createXbcVarAddr();
        xbcVarAddr_.setup(stack);
        return (xbcVarAddr_);
    }

    /**
     * Creates a <code>XbcCompoundValueExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcCompoundValueExpr
     */
    public XbcCompoundValueExpr createXbcCompoundValueExpr(RStack stack) {
        XbcCompoundValueExpr xbcCompoundValueExpr_ = createXbcCompoundValueExpr();
        xbcCompoundValueExpr_.setup(stack);
        return (xbcCompoundValueExpr_);
    }

    /**
     * Creates a <code>XbcCompoundValueAddrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcCompoundValueAddrExpr
     */
    public XbcCompoundValueAddrExpr createXbcCompoundValueAddrExpr(RStack stack) {
        XbcCompoundValueAddrExpr xbcCompoundValueAddrExpr_ = createXbcCompoundValueAddrExpr();
        xbcCompoundValueAddrExpr_.setup(stack);
        return (xbcCompoundValueAddrExpr_);
    }

    /**
     * Creates a <code>XbcXmpDescOf</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcXmpDescOf
     */
    public XbcXmpDescOf createXbcXmpDescOf(RStack stack) {
        XbcXmpDescOf xbcXmpDescOf_ = createXbcXmpDescOf();
        xbcXmpDescOf_.setup(stack);
        return (xbcXmpDescOf_);
    }

    /**
     * Creates a <code>XbcIntConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcIntConstant
     */
    public XbcIntConstant createXbcIntConstant(RStack stack) {
        XbcIntConstant xbcIntConstant_ = createXbcIntConstant();
        xbcIntConstant_.setup(stack);
        return (xbcIntConstant_);
    }

    /**
     * Creates a <code>XbcFloatConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcFloatConstant
     */
    public XbcFloatConstant createXbcFloatConstant(RStack stack) {
        XbcFloatConstant xbcFloatConstant_ = createXbcFloatConstant();
        xbcFloatConstant_.setup(stack);
        return (xbcFloatConstant_);
    }

    /**
     * Creates a <code>XbcLonglongConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcLonglongConstant
     */
    public XbcLonglongConstant createXbcLonglongConstant(RStack stack) {
        XbcLonglongConstant xbcLonglongConstant_ = createXbcLonglongConstant();
        xbcLonglongConstant_.setup(stack);
        return (xbcLonglongConstant_);
    }

    /**
     * Creates a <code>XbcMoeConstant</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcMoeConstant
     */
    public XbcMoeConstant createXbcMoeConstant(RStack stack) {
        XbcMoeConstant xbcMoeConstant_ = createXbcMoeConstant();
        xbcMoeConstant_.setup(stack);
        return (xbcMoeConstant_);
    }

    /**
     * Creates a <code>XbcFuncAddr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcFuncAddr
     */
    public XbcFuncAddr createXbcFuncAddr(RStack stack) {
        XbcFuncAddr xbcFuncAddr_ = createXbcFuncAddr();
        xbcFuncAddr_.setup(stack);
        return (xbcFuncAddr_);
    }

    /**
     * Creates a <code>XbcSizeOfExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcSizeOfExpr
     */
    public XbcSizeOfExpr createXbcSizeOfExpr(RStack stack) {
        XbcSizeOfExpr xbcSizeOfExpr_ = createXbcSizeOfExpr();
        xbcSizeOfExpr_.setup(stack);
        return (xbcSizeOfExpr_);
    }

    /**
     * Creates a <code>XbcCoArrayAssignExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcCoArrayAssignExpr
     */
    public XbcCoArrayAssignExpr createXbcCoArrayAssignExpr(RStack stack) {
        XbcCoArrayAssignExpr xbcCoArrayAssignExpr_ = createXbcCoArrayAssignExpr();
        xbcCoArrayAssignExpr_.setup(stack);
        return (xbcCoArrayAssignExpr_);
    }

    /**
     * Creates a <code>XbcModExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcModExpr
     */
    public XbcModExpr createXbcModExpr(RStack stack) {
        XbcModExpr xbcModExpr_ = createXbcModExpr();
        xbcModExpr_.setup(stack);
        return (xbcModExpr_);
    }

    /**
     * Creates a <code>XbcBitOrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcBitOrExpr
     */
    public XbcBitOrExpr createXbcBitOrExpr(RStack stack) {
        XbcBitOrExpr xbcBitOrExpr_ = createXbcBitOrExpr();
        xbcBitOrExpr_.setup(stack);
        return (xbcBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogOrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcLogOrExpr
     */
    public XbcLogOrExpr createXbcLogOrExpr(RStack stack) {
        XbcLogOrExpr xbcLogOrExpr_ = createXbcLogOrExpr();
        xbcLogOrExpr_.setup(stack);
        return (xbcLogOrExpr_);
    }

    /**
     * Creates a <code>XbcPlusExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcPlusExpr
     */
    public XbcPlusExpr createXbcPlusExpr(RStack stack) {
        XbcPlusExpr xbcPlusExpr_ = createXbcPlusExpr();
        xbcPlusExpr_.setup(stack);
        return (xbcPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgPlusExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcAsgPlusExpr
     */
    public XbcAsgPlusExpr createXbcAsgPlusExpr(RStack stack) {
        XbcAsgPlusExpr xbcAsgPlusExpr_ = createXbcAsgPlusExpr();
        xbcAsgPlusExpr_.setup(stack);
        return (xbcAsgPlusExpr_);
    }

    /**
     * Creates a <code>XbcAsgModExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcAsgModExpr
     */
    public XbcAsgModExpr createXbcAsgModExpr(RStack stack) {
        XbcAsgModExpr xbcAsgModExpr_ = createXbcAsgModExpr();
        xbcAsgModExpr_.setup(stack);
        return (xbcAsgModExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitOrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcAsgBitOrExpr
     */
    public XbcAsgBitOrExpr createXbcAsgBitOrExpr(RStack stack) {
        XbcAsgBitOrExpr xbcAsgBitOrExpr_ = createXbcAsgBitOrExpr();
        xbcAsgBitOrExpr_.setup(stack);
        return (xbcAsgBitOrExpr_);
    }

    /**
     * Creates a <code>XbcLogGTExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcLogGTExpr
     */
    public XbcLogGTExpr createXbcLogGTExpr(RStack stack) {
        XbcLogGTExpr xbcLogGTExpr_ = createXbcLogGTExpr();
        xbcLogGTExpr_.setup(stack);
        return (xbcLogGTExpr_);
    }

    /**
     * Creates a <code>XbcCondExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcCondExpr
     */
    public XbcCondExpr createXbcCondExpr(RStack stack) {
        XbcCondExpr xbcCondExpr_ = createXbcCondExpr();
        xbcCondExpr_.setup(stack);
        return (xbcCondExpr_);
    }

    /**
     * Creates a <code>XbcMinusExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcMinusExpr
     */
    public XbcMinusExpr createXbcMinusExpr(RStack stack) {
        XbcMinusExpr xbcMinusExpr_ = createXbcMinusExpr();
        xbcMinusExpr_.setup(stack);
        return (xbcMinusExpr_);
    }

    /**
     * Creates a <code>XbcAddrOfExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcAddrOfExpr
     */
    public XbcAddrOfExpr createXbcAddrOfExpr(RStack stack) {
        XbcAddrOfExpr xbcAddrOfExpr_ = createXbcAddrOfExpr();
        xbcAddrOfExpr_.setup(stack);
        return (xbcAddrOfExpr_);
    }

    /**
     * Creates a <code>XbcLshiftExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcLshiftExpr
     */
    public XbcLshiftExpr createXbcLshiftExpr(RStack stack) {
        XbcLshiftExpr xbcLshiftExpr_ = createXbcLshiftExpr();
        xbcLshiftExpr_.setup(stack);
        return (xbcLshiftExpr_);
    }

    /**
     * Creates a <code>XbcRshiftExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcRshiftExpr
     */
    public XbcRshiftExpr createXbcRshiftExpr(RStack stack) {
        XbcRshiftExpr xbcRshiftExpr_ = createXbcRshiftExpr();
        xbcRshiftExpr_.setup(stack);
        return (xbcRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitXorExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcAsgBitXorExpr
     */
    public XbcAsgBitXorExpr createXbcAsgBitXorExpr(RStack stack) {
        XbcAsgBitXorExpr xbcAsgBitXorExpr_ = createXbcAsgBitXorExpr();
        xbcAsgBitXorExpr_.setup(stack);
        return (xbcAsgBitXorExpr_);
    }

    /**
     * Creates a <code>XbcLogEQExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcLogEQExpr
     */
    public XbcLogEQExpr createXbcLogEQExpr(RStack stack) {
        XbcLogEQExpr xbcLogEQExpr_ = createXbcLogEQExpr();
        xbcLogEQExpr_.setup(stack);
        return (xbcLogEQExpr_);
    }

    /**
     * Creates a <code>XbcLogNEQExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcLogNEQExpr
     */
    public XbcLogNEQExpr createXbcLogNEQExpr(RStack stack) {
        XbcLogNEQExpr xbcLogNEQExpr_ = createXbcLogNEQExpr();
        xbcLogNEQExpr_.setup(stack);
        return (xbcLogNEQExpr_);
    }

    /**
     * Creates a <code>XbcLogGEExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcLogGEExpr
     */
    public XbcLogGEExpr createXbcLogGEExpr(RStack stack) {
        XbcLogGEExpr xbcLogGEExpr_ = createXbcLogGEExpr();
        xbcLogGEExpr_.setup(stack);
        return (xbcLogGEExpr_);
    }

    /**
     * Creates a <code>XbcLogLTExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcLogLTExpr
     */
    public XbcLogLTExpr createXbcLogLTExpr(RStack stack) {
        XbcLogLTExpr xbcLogLTExpr_ = createXbcLogLTExpr();
        xbcLogLTExpr_.setup(stack);
        return (xbcLogLTExpr_);
    }

    /**
     * Creates a <code>XbcGccAlignOfExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcGccAlignOfExpr
     */
    public XbcGccAlignOfExpr createXbcGccAlignOfExpr(RStack stack) {
        XbcGccAlignOfExpr xbcGccAlignOfExpr_ = createXbcGccAlignOfExpr();
        xbcGccAlignOfExpr_.setup(stack);
        return (xbcGccAlignOfExpr_);
    }

    /**
     * Creates a <code>XbcAssignExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcAssignExpr
     */
    public XbcAssignExpr createXbcAssignExpr(RStack stack) {
        XbcAssignExpr xbcAssignExpr_ = createXbcAssignExpr();
        xbcAssignExpr_.setup(stack);
        return (xbcAssignExpr_);
    }

    /**
     * Creates a <code>XbcMulExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcMulExpr
     */
    public XbcMulExpr createXbcMulExpr(RStack stack) {
        XbcMulExpr xbcMulExpr_ = createXbcMulExpr();
        xbcMulExpr_.setup(stack);
        return (xbcMulExpr_);
    }

    /**
     * Creates a <code>XbcDivExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcDivExpr
     */
    public XbcDivExpr createXbcDivExpr(RStack stack) {
        XbcDivExpr xbcDivExpr_ = createXbcDivExpr();
        xbcDivExpr_.setup(stack);
        return (xbcDivExpr_);
    }

    /**
     * Creates a <code>XbcAsgMulExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcAsgMulExpr
     */
    public XbcAsgMulExpr createXbcAsgMulExpr(RStack stack) {
        XbcAsgMulExpr xbcAsgMulExpr_ = createXbcAsgMulExpr();
        xbcAsgMulExpr_.setup(stack);
        return (xbcAsgMulExpr_);
    }

    /**
     * Creates a <code>XbcAsgRshiftExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcAsgRshiftExpr
     */
    public XbcAsgRshiftExpr createXbcAsgRshiftExpr(RStack stack) {
        XbcAsgRshiftExpr xbcAsgRshiftExpr_ = createXbcAsgRshiftExpr();
        xbcAsgRshiftExpr_.setup(stack);
        return (xbcAsgRshiftExpr_);
    }

    /**
     * Creates a <code>XbcAsgBitAndExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcAsgBitAndExpr
     */
    public XbcAsgBitAndExpr createXbcAsgBitAndExpr(RStack stack) {
        XbcAsgBitAndExpr xbcAsgBitAndExpr_ = createXbcAsgBitAndExpr();
        xbcAsgBitAndExpr_.setup(stack);
        return (xbcAsgBitAndExpr_);
    }

    /**
     * Creates a <code>XbcLogLEExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcLogLEExpr
     */
    public XbcLogLEExpr createXbcLogLEExpr(RStack stack) {
        XbcLogLEExpr xbcLogLEExpr_ = createXbcLogLEExpr();
        xbcLogLEExpr_.setup(stack);
        return (xbcLogLEExpr_);
    }

    /**
     * Creates a <code>XbcLogAndExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcLogAndExpr
     */
    public XbcLogAndExpr createXbcLogAndExpr(RStack stack) {
        XbcLogAndExpr xbcLogAndExpr_ = createXbcLogAndExpr();
        xbcLogAndExpr_.setup(stack);
        return (xbcLogAndExpr_);
    }

    /**
     * Creates a <code>XbcCommaExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcCommaExpr
     */
    public XbcCommaExpr createXbcCommaExpr(RStack stack) {
        XbcCommaExpr xbcCommaExpr_ = createXbcCommaExpr();
        xbcCommaExpr_.setup(stack);
        return (xbcCommaExpr_);
    }

    /**
     * Creates a <code>XbcAsgDivExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcAsgDivExpr
     */
    public XbcAsgDivExpr createXbcAsgDivExpr(RStack stack) {
        XbcAsgDivExpr xbcAsgDivExpr_ = createXbcAsgDivExpr();
        xbcAsgDivExpr_.setup(stack);
        return (xbcAsgDivExpr_);
    }

    /**
     * Creates a <code>XbcGccLabelAddr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcGccLabelAddr
     */
    public XbcGccLabelAddr createXbcGccLabelAddr(RStack stack) {
        XbcGccLabelAddr xbcGccLabelAddr_ = createXbcGccLabelAddr();
        xbcGccLabelAddr_.setup(stack);
        return (xbcGccLabelAddr_);
    }

    /**
     * Creates a <code>XbcBitAndExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcBitAndExpr
     */
    public XbcBitAndExpr createXbcBitAndExpr(RStack stack) {
        XbcBitAndExpr xbcBitAndExpr_ = createXbcBitAndExpr();
        xbcBitAndExpr_.setup(stack);
        return (xbcBitAndExpr_);
    }

    /**
     * Creates a <code>XbcBitXorExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcBitXorExpr
     */
    public XbcBitXorExpr createXbcBitXorExpr(RStack stack) {
        XbcBitXorExpr xbcBitXorExpr_ = createXbcBitXorExpr();
        xbcBitXorExpr_.setup(stack);
        return (xbcBitXorExpr_);
    }

    /**
     * Creates a <code>XbcAsgMinusExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcAsgMinusExpr
     */
    public XbcAsgMinusExpr createXbcAsgMinusExpr(RStack stack) {
        XbcAsgMinusExpr xbcAsgMinusExpr_ = createXbcAsgMinusExpr();
        xbcAsgMinusExpr_.setup(stack);
        return (xbcAsgMinusExpr_);
    }

    /**
     * Creates a <code>XbcAsgLshiftExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcAsgLshiftExpr
     */
    public XbcAsgLshiftExpr createXbcAsgLshiftExpr(RStack stack) {
        XbcAsgLshiftExpr xbcAsgLshiftExpr_ = createXbcAsgLshiftExpr();
        xbcAsgLshiftExpr_.setup(stack);
        return (xbcAsgLshiftExpr_);
    }

    /**
     * Creates a <code>XbcMemberAddr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcMemberAddr
     */
    public XbcMemberAddr createXbcMemberAddr(RStack stack) {
        XbcMemberAddr xbcMemberAddr_ = createXbcMemberAddr();
        xbcMemberAddr_.setup(stack);
        return (xbcMemberAddr_);
    }

    /**
     * Creates a <code>XbcMemberArrayRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcMemberArrayRef
     */
    public XbcMemberArrayRef createXbcMemberArrayRef(RStack stack) {
        XbcMemberArrayRef xbcMemberArrayRef_ = createXbcMemberArrayRef();
        xbcMemberArrayRef_.setup(stack);
        return (xbcMemberArrayRef_);
    }

    /**
     * Creates a <code>XbcMemberArrayAddr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcMemberArrayAddr
     */
    public XbcMemberArrayAddr createXbcMemberArrayAddr(RStack stack) {
        XbcMemberArrayAddr xbcMemberArrayAddr_ = createXbcMemberArrayAddr();
        xbcMemberArrayAddr_.setup(stack);
        return (xbcMemberArrayAddr_);
    }

    /**
     * Creates a <code>XbcTypeName</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcTypeName
     */
    public XbcTypeName createXbcTypeName(RStack stack) {
        XbcTypeName xbcTypeName_ = createXbcTypeName();
        xbcTypeName_.setup(stack);
        return (xbcTypeName_);
    }

    /**
     * Creates a <code>XbcPointerRef</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcPointerRef
     */
    public XbcPointerRef createXbcPointerRef(RStack stack) {
        XbcPointerRef xbcPointerRef_ = createXbcPointerRef();
        xbcPointerRef_.setup(stack);
        return (xbcPointerRef_);
    }

    /**
     * Creates a <code>XbcUnaryMinusExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcUnaryMinusExpr
     */
    public XbcUnaryMinusExpr createXbcUnaryMinusExpr(RStack stack) {
        XbcUnaryMinusExpr xbcUnaryMinusExpr_ = createXbcUnaryMinusExpr();
        xbcUnaryMinusExpr_.setup(stack);
        return (xbcUnaryMinusExpr_);
    }

    /**
     * Creates a <code>XbcBitNotExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcBitNotExpr
     */
    public XbcBitNotExpr createXbcBitNotExpr(RStack stack) {
        XbcBitNotExpr xbcBitNotExpr_ = createXbcBitNotExpr();
        xbcBitNotExpr_.setup(stack);
        return (xbcBitNotExpr_);
    }

    /**
     * Creates a <code>XbcLogNotExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcLogNotExpr
     */
    public XbcLogNotExpr createXbcLogNotExpr(RStack stack) {
        XbcLogNotExpr xbcLogNotExpr_ = createXbcLogNotExpr();
        xbcLogNotExpr_.setup(stack);
        return (xbcLogNotExpr_);
    }

    /**
     * Creates a <code>XbcPostIncrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcPostIncrExpr
     */
    public XbcPostIncrExpr createXbcPostIncrExpr(RStack stack) {
        XbcPostIncrExpr xbcPostIncrExpr_ = createXbcPostIncrExpr();
        xbcPostIncrExpr_.setup(stack);
        return (xbcPostIncrExpr_);
    }

    /**
     * Creates a <code>XbcPostDecrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcPostDecrExpr
     */
    public XbcPostDecrExpr createXbcPostDecrExpr(RStack stack) {
        XbcPostDecrExpr xbcPostDecrExpr_ = createXbcPostDecrExpr();
        xbcPostDecrExpr_.setup(stack);
        return (xbcPostDecrExpr_);
    }

    /**
     * Creates a <code>XbcPreIncrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcPreIncrExpr
     */
    public XbcPreIncrExpr createXbcPreIncrExpr(RStack stack) {
        XbcPreIncrExpr xbcPreIncrExpr_ = createXbcPreIncrExpr();
        xbcPreIncrExpr_.setup(stack);
        return (xbcPreIncrExpr_);
    }

    /**
     * Creates a <code>XbcPreDecrExpr</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcPreDecrExpr
     */
    public XbcPreDecrExpr createXbcPreDecrExpr(RStack stack) {
        XbcPreDecrExpr xbcPreDecrExpr_ = createXbcPreDecrExpr();
        xbcPreDecrExpr_.setup(stack);
        return (xbcPreDecrExpr_);
    }

    /**
     * Creates a <code>XbcIndexRange</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcIndexRange
     */
    public XbcIndexRange createXbcIndexRange(RStack stack) {
        XbcIndexRange xbcIndexRange_ = createXbcIndexRange();
        xbcIndexRange_.setup(stack);
        return (xbcIndexRange_);
    }

    /**
     * Creates a <code>XbcLowerBound</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcLowerBound
     */
    public XbcLowerBound createXbcLowerBound(RStack stack) {
        XbcLowerBound xbcLowerBound_ = createXbcLowerBound();
        xbcLowerBound_.setup(stack);
        return (xbcLowerBound_);
    }

    /**
     * Creates a <code>XbcUpperBound</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcUpperBound
     */
    public XbcUpperBound createXbcUpperBound(RStack stack) {
        XbcUpperBound xbcUpperBound_ = createXbcUpperBound();
        xbcUpperBound_.setup(stack);
        return (xbcUpperBound_);
    }

    /**
     * Creates a <code>XbcStep</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcStep
     */
    public XbcStep createXbcStep(RStack stack) {
        XbcStep xbcStep_ = createXbcStep();
        xbcStep_.setup(stack);
        return (xbcStep_);
    }

    /**
     * Creates a <code>XbcDesignatedValue</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcDesignatedValue
     */
    public XbcDesignatedValue createXbcDesignatedValue(RStack stack) {
        XbcDesignatedValue xbcDesignatedValue_ = createXbcDesignatedValue();
        xbcDesignatedValue_.setup(stack);
        return (xbcDesignatedValue_);
    }

    /**
     * Creates a <code>XbcCompoundValue</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcCompoundValue
     */
    public XbcCompoundValue createXbcCompoundValue(RStack stack) {
        XbcCompoundValue xbcCompoundValue_ = createXbcCompoundValue();
        xbcCompoundValue_.setup(stack);
        return (xbcCompoundValue_);
    }

    /**
     * Creates a <code>XbcBitField</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcBitField
     */
    public XbcBitField createXbcBitField(RStack stack) {
        XbcBitField xbcBitField_ = createXbcBitField();
        xbcBitField_.setup(stack);
        return (xbcBitField_);
    }

    /**
     * Creates a <code>XbcPragma</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcPragma
     */
    public XbcPragma createXbcPragma(RStack stack) {
        XbcPragma xbcPragma_ = createXbcPragma();
        xbcPragma_.setup(stack);
        return (xbcPragma_);
    }

    /**
     * Creates a <code>XbcText</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcText
     */
    public XbcText createXbcText(RStack stack) {
        XbcText xbcText_ = createXbcText();
        xbcText_.setup(stack);
        return (xbcText_);
    }

    /**
     * Creates a <code>XbcDeclarations</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcDeclarations
     */
    public XbcDeclarations createXbcDeclarations(RStack stack) {
        XbcDeclarations xbcDeclarations_ = createXbcDeclarations();
        xbcDeclarations_.setup(stack);
        return (xbcDeclarations_);
    }

    /**
     * Creates a <code>XbcFunctionDefinition</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcFunctionDefinition
     */
    public XbcFunctionDefinition createXbcFunctionDefinition(RStack stack) {
        XbcFunctionDefinition xbcFunctionDefinition_ = createXbcFunctionDefinition();
        xbcFunctionDefinition_.setup(stack);
        return (xbcFunctionDefinition_);
    }

    /**
     * Creates a <code>XbcParams</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcParams
     */
    public XbcParams createXbcParams(RStack stack) {
        XbcParams xbcParams_ = createXbcParams();
        xbcParams_.setup(stack);
        return (xbcParams_);
    }

    /**
     * Creates a <code>XbcBody</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcBody
     */
    public XbcBody createXbcBody(RStack stack) {
        XbcBody xbcBody_ = createXbcBody();
        xbcBody_.setup(stack);
        return (xbcBody_);
    }

    /**
     * Creates a <code>XbcGccAsmStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcGccAsmStatement
     */
    public XbcGccAsmStatement createXbcGccAsmStatement(RStack stack) {
        XbcGccAsmStatement xbcGccAsmStatement_ = createXbcGccAsmStatement();
        xbcGccAsmStatement_.setup(stack);
        return (xbcGccAsmStatement_);
    }

    /**
     * Creates a <code>XbcGccAsmOperands</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcGccAsmOperands
     */
    public XbcGccAsmOperands createXbcGccAsmOperands(RStack stack) {
        XbcGccAsmOperands xbcGccAsmOperands_ = createXbcGccAsmOperands();
        xbcGccAsmOperands_.setup(stack);
        return (xbcGccAsmOperands_);
    }

    /**
     * Creates a <code>XbcGccAsmOperand</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcGccAsmOperand
     */
    public XbcGccAsmOperand createXbcGccAsmOperand(RStack stack) {
        XbcGccAsmOperand xbcGccAsmOperand_ = createXbcGccAsmOperand();
        xbcGccAsmOperand_.setup(stack);
        return (xbcGccAsmOperand_);
    }

    /**
     * Creates a <code>XbcGccAsmClobbers</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcGccAsmClobbers
     */
    public XbcGccAsmClobbers createXbcGccAsmClobbers(RStack stack) {
        XbcGccAsmClobbers xbcGccAsmClobbers_ = createXbcGccAsmClobbers();
        xbcGccAsmClobbers_.setup(stack);
        return (xbcGccAsmClobbers_);
    }

    /**
     * Creates a <code>XbcForStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcForStatement
     */
    public XbcForStatement createXbcForStatement(RStack stack) {
        XbcForStatement xbcForStatement_ = createXbcForStatement();
        xbcForStatement_.setup(stack);
        return (xbcForStatement_);
    }

    /**
     * Creates a <code>XbcInit</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcInit
     */
    public XbcInit createXbcInit(RStack stack) {
        XbcInit xbcInit_ = createXbcInit();
        xbcInit_.setup(stack);
        return (xbcInit_);
    }

    /**
     * Creates a <code>XbcCondition</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcCondition
     */
    public XbcCondition createXbcCondition(RStack stack) {
        XbcCondition xbcCondition_ = createXbcCondition();
        xbcCondition_.setup(stack);
        return (xbcCondition_);
    }

    /**
     * Creates a <code>XbcIter</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcIter
     */
    public XbcIter createXbcIter(RStack stack) {
        XbcIter xbcIter_ = createXbcIter();
        xbcIter_.setup(stack);
        return (xbcIter_);
    }

    /**
     * Creates a <code>XbcIfStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcIfStatement
     */
    public XbcIfStatement createXbcIfStatement(RStack stack) {
        XbcIfStatement xbcIfStatement_ = createXbcIfStatement();
        xbcIfStatement_.setup(stack);
        return (xbcIfStatement_);
    }

    /**
     * Creates a <code>XbcThen</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcThen
     */
    public XbcThen createXbcThen(RStack stack) {
        XbcThen xbcThen_ = createXbcThen();
        xbcThen_.setup(stack);
        return (xbcThen_);
    }

    /**
     * Creates a <code>XbcElse</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcElse
     */
    public XbcElse createXbcElse(RStack stack) {
        XbcElse xbcElse_ = createXbcElse();
        xbcElse_.setup(stack);
        return (xbcElse_);
    }

    /**
     * Creates a <code>XbcWhileStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcWhileStatement
     */
    public XbcWhileStatement createXbcWhileStatement(RStack stack) {
        XbcWhileStatement xbcWhileStatement_ = createXbcWhileStatement();
        xbcWhileStatement_.setup(stack);
        return (xbcWhileStatement_);
    }

    /**
     * Creates a <code>XbcDoStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcDoStatement
     */
    public XbcDoStatement createXbcDoStatement(RStack stack) {
        XbcDoStatement xbcDoStatement_ = createXbcDoStatement();
        xbcDoStatement_.setup(stack);
        return (xbcDoStatement_);
    }

    /**
     * Creates a <code>XbcSwitchStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcSwitchStatement
     */
    public XbcSwitchStatement createXbcSwitchStatement(RStack stack) {
        XbcSwitchStatement xbcSwitchStatement_ = createXbcSwitchStatement();
        xbcSwitchStatement_.setup(stack);
        return (xbcSwitchStatement_);
    }

    /**
     * Creates a <code>XbcGccRangedCaseLabel</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcGccRangedCaseLabel
     */
    public XbcGccRangedCaseLabel createXbcGccRangedCaseLabel(RStack stack) {
        XbcGccRangedCaseLabel xbcGccRangedCaseLabel_ = createXbcGccRangedCaseLabel();
        xbcGccRangedCaseLabel_.setup(stack);
        return (xbcGccRangedCaseLabel_);
    }

    /**
     * Creates a <code>XbcStatementLabel</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcStatementLabel
     */
    public XbcStatementLabel createXbcStatementLabel(RStack stack) {
        XbcStatementLabel xbcStatementLabel_ = createXbcStatementLabel();
        xbcStatementLabel_.setup(stack);
        return (xbcStatementLabel_);
    }

    /**
     * Creates a <code>XbcCaseLabel</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcCaseLabel
     */
    public XbcCaseLabel createXbcCaseLabel(RStack stack) {
        XbcCaseLabel xbcCaseLabel_ = createXbcCaseLabel();
        xbcCaseLabel_.setup(stack);
        return (xbcCaseLabel_);
    }

    /**
     * Creates a <code>XbcBreakStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcBreakStatement
     */
    public XbcBreakStatement createXbcBreakStatement(RStack stack) {
        XbcBreakStatement xbcBreakStatement_ = createXbcBreakStatement();
        xbcBreakStatement_.setup(stack);
        return (xbcBreakStatement_);
    }

    /**
     * Creates a <code>XbcContinueStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcContinueStatement
     */
    public XbcContinueStatement createXbcContinueStatement(RStack stack) {
        XbcContinueStatement xbcContinueStatement_ = createXbcContinueStatement();
        xbcContinueStatement_.setup(stack);
        return (xbcContinueStatement_);
    }

    /**
     * Creates a <code>XbcReturnStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcReturnStatement
     */
    public XbcReturnStatement createXbcReturnStatement(RStack stack) {
        XbcReturnStatement xbcReturnStatement_ = createXbcReturnStatement();
        xbcReturnStatement_.setup(stack);
        return (xbcReturnStatement_);
    }

    /**
     * Creates a <code>XbcGotoStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcGotoStatement
     */
    public XbcGotoStatement createXbcGotoStatement(RStack stack) {
        XbcGotoStatement xbcGotoStatement_ = createXbcGotoStatement();
        xbcGotoStatement_.setup(stack);
        return (xbcGotoStatement_);
    }

    /**
     * Creates a <code>XbcDefaultLabel</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcDefaultLabel
     */
    public XbcDefaultLabel createXbcDefaultLabel(RStack stack) {
        XbcDefaultLabel xbcDefaultLabel_ = createXbcDefaultLabel();
        xbcDefaultLabel_.setup(stack);
        return (xbcDefaultLabel_);
    }

    /**
     * Creates a <code>XbcExprStatement</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcExprStatement
     */
    public XbcExprStatement createXbcExprStatement(RStack stack) {
        XbcExprStatement xbcExprStatement_ = createXbcExprStatement();
        xbcExprStatement_.setup(stack);
        return (xbcExprStatement_);
    }

    /**
     * Creates a <code>XbcVarDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcVarDecl
     */
    public XbcVarDecl createXbcVarDecl(RStack stack) {
        XbcVarDecl xbcVarDecl_ = createXbcVarDecl();
        xbcVarDecl_.setup(stack);
        return (xbcVarDecl_);
    }

    /**
     * Creates a <code>XbcGccAsm</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcGccAsm
     */
    public XbcGccAsm createXbcGccAsm(RStack stack) {
        XbcGccAsm xbcGccAsm_ = createXbcGccAsm();
        xbcGccAsm_.setup(stack);
        return (xbcGccAsm_);
    }

    /**
     * Creates a <code>XbcFunctionDecl</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcFunctionDecl
     */
    public XbcFunctionDecl createXbcFunctionDecl(RStack stack) {
        XbcFunctionDecl xbcFunctionDecl_ = createXbcFunctionDecl();
        xbcFunctionDecl_.setup(stack);
        return (xbcFunctionDecl_);
    }

    /**
     * Creates a <code>XbcGccMemberDesignator</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcGccMemberDesignator
     */
    public XbcGccMemberDesignator createXbcGccMemberDesignator(RStack stack) {
        XbcGccMemberDesignator xbcGccMemberDesignator_ = createXbcGccMemberDesignator();
        xbcGccMemberDesignator_.setup(stack);
        return (xbcGccMemberDesignator_);
    }

    /**
     * Creates a <code>XbcArrayType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcArrayType
     */
    public XbcArrayType createXbcArrayType(RStack stack) {
        XbcArrayType xbcArrayType_ = createXbcArrayType();
        xbcArrayType_.setup(stack);
        return (xbcArrayType_);
    }

    /**
     * Creates a <code>XbcArraySize</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcArraySize
     */
    public XbcArraySize createXbcArraySize(RStack stack) {
        XbcArraySize xbcArraySize_ = createXbcArraySize();
        xbcArraySize_.setup(stack);
        return (xbcArraySize_);
    }

    /**
     * Creates a <code>XbcBasicType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcBasicType
     */
    public XbcBasicType createXbcBasicType(RStack stack) {
        XbcBasicType xbcBasicType_ = createXbcBasicType();
        xbcBasicType_.setup(stack);
        return (xbcBasicType_);
    }

    /**
     * Creates a <code>XbcPointerType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcPointerType
     */
    public XbcPointerType createXbcPointerType(RStack stack) {
        XbcPointerType xbcPointerType_ = createXbcPointerType();
        xbcPointerType_.setup(stack);
        return (xbcPointerType_);
    }

    /**
     * Creates a <code>XbcStructType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcStructType
     */
    public XbcStructType createXbcStructType(RStack stack) {
        XbcStructType xbcStructType_ = createXbcStructType();
        xbcStructType_.setup(stack);
        return (xbcStructType_);
    }

    /**
     * Creates a <code>XbcUnionType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcUnionType
     */
    public XbcUnionType createXbcUnionType(RStack stack) {
        XbcUnionType xbcUnionType_ = createXbcUnionType();
        xbcUnionType_.setup(stack);
        return (xbcUnionType_);
    }

    /**
     * Creates a <code>XbcEnumType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcEnumType
     */
    public XbcEnumType createXbcEnumType(RStack stack) {
        XbcEnumType xbcEnumType_ = createXbcEnumType();
        xbcEnumType_.setup(stack);
        return (xbcEnumType_);
    }

    /**
     * Creates a <code>XbcCoArrayType</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcCoArrayType
     */
    public XbcCoArrayType createXbcCoArrayType(RStack stack) {
        XbcCoArrayType xbcCoArrayType_ = createXbcCoArrayType();
        xbcCoArrayType_.setup(stack);
        return (xbcCoArrayType_);
    }

    /**
     * Creates a <code>XbcGlobalSymbols</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcGlobalSymbols
     */
    public XbcGlobalSymbols createXbcGlobalSymbols(RStack stack) {
        XbcGlobalSymbols xbcGlobalSymbols_ = createXbcGlobalSymbols();
        xbcGlobalSymbols_.setup(stack);
        return (xbcGlobalSymbols_);
    }

    /**
     * Creates a <code>XbcGlobalDeclarations</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcGlobalDeclarations
     */
    public XbcGlobalDeclarations createXbcGlobalDeclarations(RStack stack) {
        XbcGlobalDeclarations xbcGlobalDeclarations_ = createXbcGlobalDeclarations();
        xbcGlobalDeclarations_.setup(stack);
        return (xbcGlobalDeclarations_);
    }

    /**
     * Creates a <code>XbcGccAsmDefinition</code> by the Stack <code>stack</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     * This method is a template method for concrete classes.
     *
     * @param stack
     * @return XbcGccAsmDefinition
     */
    public XbcGccAsmDefinition createXbcGccAsmDefinition(RStack stack) {
        XbcGccAsmDefinition xbcGccAsmDefinition_ = createXbcGccAsmDefinition();
        xbcGccAsmDefinition_.setup(stack);
        return (xbcGccAsmDefinition_);
    }
}
