/* 
 * $TSUKUBA_Release: Omni Compiler Version 0.9.0 $
 * $TSUKUBA_Copyright:
 *  Copyright (C) 2010-2014 University of Tsukuba, 
 *  	      2012-2014  University of Tsukuba and Riken AICS
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  * The specification of XcalableMP has been designed by the XcalableMP
 *    Specification Working Group (http://www.xcalablemp.org/).
 *  
 *  * The development of this software was partially supported by "Seamless and
 *    Highly-productive Parallel Programming Environment for
 *    High-performance computing" project funded by Ministry of Education,
 *    Culture, Sports, Science and Technology, Japan.
 *  $
 */
package xcodeml.c.binding;

import xcodeml.c.binding.gen.XbcGccAttributes;

/**
 * Concreate classes implement the interface are follows : 
 * XbcBasicType, XbcPointerType, XbcFunctionType
 * XbcArrayType, XbcStructType, XbcUnionType, XbcEnumType
 */
public interface IXbcType
{
    public String getType();
    
    public void setType(String s);
    
    /**
     * Gets a content of is_volatile attribute.
     *
     * @return a content of is_volatile attribute.
     */
    public String getIsVolatile();

    public void setIsVolatile(String enabled);
    
    /**
     * Gets a content of is_const attribute.
     *
     * @return a content of is_const attribute.
     */
    public String getIsConst();

    public void setIsConst(String enabled);
    
    /**
     * Gets a content of is_restrict attribute.
     *
     * @return a content of is_restrict attribute.
     */
    public String getIsRestrict();

    public void setIsRestrict(String enabled);

    /**
     * Gets the XbcGccAttributes property <b>gccAttributes</b>.
     *
     * @return XbcGccAttributes
     */
    public XbcGccAttributes getGccAttributes();

    public void setGccAttributes(XbcGccAttributes attrs);
}
