static char rcsid[] = "$Id$";
/* 
 * $TSUKUBA_Release: Omni Compiler Version 0.9.1 $
 * $TSUKUBA_Copyright:
 *  Copyright (C) 2010-2014 University of Tsukuba, 
 *  	      2012-2014  University of Tsukuba and Riken AICS
 *  
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version
 *  2.1 published by the Free Software Foundation.
 *  
 *  Please check the Copyright and License information in the files named
 *  COPYRIGHT and LICENSE under the top  directory of the Omni Compiler
 *  Software release kit.
 *  
 *  * The specification of XcalableMP has been designed by the XcalableMP
 *    Specification Working Group (http://www.xcalablemp.org/).
 *  
 *  * The development of this software was partially supported by "Seamless and
 *    Highly-productive Parallel Programming Environment for
 *    High-performance computing" project funded by Ministry of Education,
 *    Culture, Sports, Science and Technology, Japan.
 *  $
 */
/* critical 006:
 * ٥̾Ʊcritical֤Ǥ¾γǧ
 */

#include <omp.h>
#include "omni.h"


int	thds;
int	errors = 0;

int	data;


void
clear ()
{
  data = 0;
}


int
read_data ()
{
  return data;
}


void
write_data (int d)
{
  data = d;
}


void
check (int n)
{
  if (4<n) {
    n = 4;
  }

  if (data != n) {
    errors += 1;
  }
}


void
func_critical ()
{
  int	id = omp_get_thread_num ();
  int	i;


  #pragma omp barrier

  switch (id) {
  case 0:
    #pragma omp critical (name)
    {
      i = read_data ();
      waittime (1);
      write_data (i+1);
    }
    break;
  case 1:
    #pragma omp critical (name)
    {
      i = read_data ();
      waittime (1);
      write_data (i+1);
    }
    break;
  case 2:
    #pragma omp critical (name)
    {
      i = read_data ();
      waittime (1);
      write_data (i+1);
    }
    break;
  case 3:
    #pragma omp critical (name)
    {
      i = read_data ();
      waittime (1);
      write_data (i+1);
    }
    break;
  default:
    break;
  }
}


main ()
{
  thds = omp_get_max_threads ();
  if (thds == 1) {
    printf ("should be run this program on multi threads.\n");
    exit (0);
  }
  omp_set_dynamic (0);


  clear ();
  #pragma omp parallel
  {
    int	id = omp_get_thread_num ();
    int	i;

    #pragma omp barrier

    switch (id) {
    case 0:
      #pragma omp critical (name)
      {
	i = read_data ();
	waittime (1);
	write_data (i+1);
      }
      break;
    case 1:
      #pragma omp critical (name)
      {
	i = read_data ();
	waittime (1);
	write_data (i+1);
      }
      break;
    case 2:
      #pragma omp critical (name)
      {
        i = read_data ();
        waittime (1);
        write_data (i+1);
      }
      break;
    case 3:
      #pragma omp critical (name)
      {
        i = read_data ();
        waittime (1);
        write_data (i+1);
      }
      break;
    default:
      break;
    }
  }
  check (thds);

  clear ();
  #pragma omp parallel
  func_critical ();
  check (thds);


  clear ();
  func_critical ();
  check (1);


  if (errors == 0) {
    printf ("critical 006 : SUCCESS\n");
    return 0;
  } else {
    printf ("critical 006 : FAILED\n");
    return 1;
  }
}
