#!/bin/bash

#-------------------------------------------------------
#  generator for xmp_lib_coarray_alloc.h
#-------------------------------------------------------

#--------------------
#  sub
#--------------------
echo72 () {
    str="$1                                                                        "
    str=`echo "$str" | cut -c -72`"&"
    echo "$str"
}


print_subr_alloc() {
    tk=$1
    typekind=$2

    echo72     "      subroutine xmpf_coarray_alloc${DIM}d_${tk}(descptr, var, count,"

 case "${DIM}" in
 0) echo       "     &   element, tag, rank)" ;;
 *) echo72     "     &   element, tag, rank"
    for i in `seq 1 ${DIM}`; do
        echo72 "     &   , lb${i}, ub${i}"
    done
    echo       "     &   )" ;;
 esac

    echo       "        integer(8), intent(in) :: descptr"
    echo       "        integer(8), intent(in) :: tag"
    echo       "        integer, intent(in) :: count, element, rank"

 case "${DIM}" in
 0) ;;
 *) for i in `seq 1 ${DIM}`; do
        echo   "        integer, intent(in) :: lb${i}, ub${i}"
    done ;;
 esac

 case "${DIM}" in
 0) echo    "        ${typekind}, pointer, intent(out) :: var" ;;
 1) echo    "        ${typekind}, pointer, intent(out) :: var(:)" ;;
 *) echo -n "        ${typekind}, pointer, intent(out) :: var(:" 
    for i in `seq 2 ${DIM}`; do
        echo -n ",:"
    done
    echo    ")" ;;
 esac

    echo    "      end subroutine"
    echo
}


print_subr_dealloc() {
    tk=$1
    typekind=$2

    echo    "      subroutine xmpf_coarray_dealloc${DIM}d_${tk}(descptr, var)"
    echo    "        integer(8), intent(in) :: descptr"

 case "${DIM}" in
 0) echo    "        ${typekind}, pointer, intent(out) :: var" ;;
 1) echo    "        ${typekind}, pointer, intent(out) :: var(:)" ;;
 *) echo -n "        ${typekind}, pointer, intent(out) :: var(:"
    for i in `seq 2 ${DIM}`; do
        echo -n ",:"
    done
    echo    ")" ;;
 esac

    echo    "      end subroutine"
    echo
}


#--------------------
#  main
#--------------------
echo "!! This file is automatically generated by xmp_lib_coarray_alloc.h.sh"
echo

for DIM in `seq 0 7`
do
    echo "!-----------------------------------------------------------------------"
    echo "      interface xmpf_coarray_alloc${DIM}d"
    echo "!-----------------------------------------------------------------------"
    echo "!!!  real(kind=16) is not supported in XMP/F"
    echo "!!!  complex(kind=16) (32bytes) is not supported in XMP/F"
    echo ""

    print_subr_alloc i2  "integer(2)"      
    print_subr_alloc i4  "integer(4)"      
    print_subr_alloc i8  "integer(8)"      
    print_subr_alloc l2  "logical(2)"      
    print_subr_alloc l4  "logical(4)"      
    print_subr_alloc l8  "logical(8)"      
    print_subr_alloc r4  "real(4)"         
    print_subr_alloc r8  "real(8)"         
    print_subr_alloc z8  "complex(4)"      
    print_subr_alloc z16 "complex(8)"      
    print_subr_alloc cn  "character(element)" 

    echo "      end interface"
    echo
done

for DIM in `seq 0 7`
do
    echo "!-----------------------------------------------------------------------"
    echo "      interface xmpf_coarray_dealloc${DIM}d"
    echo "!-----------------------------------------------------------------------"
    echo "!!!  real(kind=16) is not supported in XMP/F"
    echo "!!!  complex(kind=16) (32bytes) is not supported in XMP/F"
    echo ""

    print_subr_dealloc i2  "integer(2)"      
    print_subr_dealloc i4  "integer(4)"      
    print_subr_dealloc i8  "integer(8)"      
    print_subr_dealloc l2  "logical(2)"      
    print_subr_dealloc l4  "logical(4)"      
    print_subr_dealloc l8  "logical(8)"      
    print_subr_dealloc r4  "real(4)"         
    print_subr_dealloc r8  "real(8)"         
    print_subr_dealloc z8  "complex(4)"      
    print_subr_dealloc z16 "complex(8)"      
    print_subr_dealloc cn  "character(*)" 

    echo "      end interface"
    echo
done

exit
