from asdl import pybase
from mycpp import mops
from typing import Optional, List, Tuple, Dict, Any, cast, TYPE_CHECKING

if TYPE_CHECKING:
  from _devbuild.gen.syntax_asdl import loc_t, Token, expr_t, command_t, DoubleQuoted, re_t, proc_sig_t, LiteralBlock, Func, NameType, EggexFlag
  from _devbuild.gen.runtime_asdl import Cell


from asdl import runtime  # For runtime.NO_SPID
from asdl.runtime import NewRecord, NewLeaf, TraversalState
from _devbuild.gen.hnode_asdl import color_e, hnode, hnode_e, hnode_t, Field

class y_lvalue_e(object):
  Local = 66
  Container = 2

_y_lvalue_str = {
  2: 'Container',
  66: 'Local',
}

def y_lvalue_str(tag, dot=True):
  # type: (int, bool) -> str
  v = _y_lvalue_str[tag]
  if dot:
    return "y_lvalue.%s" % v
  else:
    return v

class y_lvalue_t(pybase.CompoundObj):
  def tag(self):
    # type: () -> int
    return self._type_tag
  pass

class y_lvalue(object):
  class Container(y_lvalue_t):
    _type_tag = 2
    __slots__ = ('obj', 'index')
  
    def __init__(self, obj, index):
      # type: (value_t, value_t) -> None
      self.obj = obj
      self.index = index
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> y_lvalue.Container
      return y_lvalue.Container(cast(value_t, None), cast(value_t, None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('y_lvalue.Container')
      L = out_node.fields
  
      assert self.obj is not None
      x0 = self.obj.PrettyTree(trav=trav)
      L.append(Field('obj', x0))
  
      assert self.index is not None
      x1 = self.index.PrettyTree(trav=trav)
      L.append(Field('index', x1))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('y_lvalue.Container')
      L = out_node.fields
      assert self.obj is not None
      x0 = self.obj.AbbreviatedTree(trav=trav)
      L.append(Field('obj', x0))
  
      assert self.index is not None
      x1 = self.index.AbbreviatedTree(trav=trav)
      L.append(Field('index', x1))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  pass

class sh_lvalue_e(object):
  Var = 66
  Indexed = 2
  Keyed = 3

_sh_lvalue_str = {
  2: 'Indexed',
  3: 'Keyed',
  66: 'Var',
}

def sh_lvalue_str(tag, dot=True):
  # type: (int, bool) -> str
  v = _sh_lvalue_str[tag]
  if dot:
    return "sh_lvalue.%s" % v
  else:
    return v

class sh_lvalue_t(pybase.CompoundObj):
  def tag(self):
    # type: () -> int
    return self._type_tag
  pass

class sh_lvalue(object):
  class Indexed(sh_lvalue_t):
    _type_tag = 2
    __slots__ = ('name', 'index', 'blame_loc')
  
    def __init__(self, name, index, blame_loc):
      # type: (str, int, loc_t) -> None
      self.name = name
      self.index = index
      self.blame_loc = blame_loc
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> sh_lvalue.Indexed
      return sh_lvalue.Indexed('', -1, cast(loc_t, None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('sh_lvalue.Indexed')
      L = out_node.fields
  
      x0 = NewLeaf(self.name, color_e.StringConst)
      L.append(Field('name', x0))
  
      x1 = hnode.Leaf(str(self.index), color_e.OtherConst)
      L.append(Field('index', x1))
  
      assert self.blame_loc is not None
      x2 = self.blame_loc.PrettyTree(trav=trav)
      L.append(Field('blame_loc', x2))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('sh_lvalue.Indexed')
      L = out_node.fields
      x0 = NewLeaf(self.name, color_e.StringConst)
      L.append(Field('name', x0))
  
      x1 = hnode.Leaf(str(self.index), color_e.OtherConst)
      L.append(Field('index', x1))
  
      assert self.blame_loc is not None
      x2 = self.blame_loc.AbbreviatedTree(trav=trav)
      L.append(Field('blame_loc', x2))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Keyed(sh_lvalue_t):
    _type_tag = 3
    __slots__ = ('name', 'key', 'blame_loc')
  
    def __init__(self, name, key, blame_loc):
      # type: (str, str, loc_t) -> None
      self.name = name
      self.key = key
      self.blame_loc = blame_loc
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> sh_lvalue.Keyed
      return sh_lvalue.Keyed('', '', cast(loc_t, None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('sh_lvalue.Keyed')
      L = out_node.fields
  
      x0 = NewLeaf(self.name, color_e.StringConst)
      L.append(Field('name', x0))
  
      x1 = NewLeaf(self.key, color_e.StringConst)
      L.append(Field('key', x1))
  
      assert self.blame_loc is not None
      x2 = self.blame_loc.PrettyTree(trav=trav)
      L.append(Field('blame_loc', x2))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('sh_lvalue.Keyed')
      L = out_node.fields
      x0 = NewLeaf(self.name, color_e.StringConst)
      L.append(Field('name', x0))
  
      x1 = NewLeaf(self.key, color_e.StringConst)
      L.append(Field('key', x1))
  
      assert self.blame_loc is not None
      x2 = self.blame_loc.AbbreviatedTree(trav=trav)
      L.append(Field('blame_loc', x2))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  pass

class eggex_ops_e(object):
  No = 1
  Yes = 2

_eggex_ops_str = {
  1: 'No',
  2: 'Yes',
}

def eggex_ops_str(tag, dot=True):
  # type: (int, bool) -> str
  v = _eggex_ops_str[tag]
  if dot:
    return "eggex_ops.%s" % v
  else:
    return v

class eggex_ops_t(pybase.CompoundObj):
  def tag(self):
    # type: () -> int
    return self._type_tag
  pass

class eggex_ops__No(eggex_ops_t):
  _type_tag = 1
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('eggex_ops__No')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('eggex_ops__No')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class eggex_ops(object):
  No = eggex_ops__No()
  
  class Yes(eggex_ops_t):
    _type_tag = 2
    __slots__ = ('convert_funcs', 'convert_toks', 'capture_names')
  
    def __init__(self, convert_funcs, convert_toks, capture_names):
      # type: (List[Optional[value_t]], List[Optional[Token]], List[Optional[str]]) -> None
      self.convert_funcs = convert_funcs
      self.convert_toks = convert_toks
      self.capture_names = capture_names
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> eggex_ops.Yes
      return eggex_ops.Yes([] if alloc_lists else cast('List[Optional[value_t]]', None), [] if alloc_lists else cast('List[Optional[Token]]', None), [] if alloc_lists else cast('List[Optional[str]]', None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('eggex_ops.Yes')
      L = out_node.fields
  
      if self.convert_funcs is not None:  # List
        x0 = hnode.Array([])
        for i0 in self.convert_funcs:
          h = (hnode.Leaf("_", color_e.OtherConst) if i0 is None else
               i0.PrettyTree(trav=trav))
          x0.children.append(h)
        L.append(Field('convert_funcs', x0))
  
      if self.convert_toks is not None:  # List
        x1 = hnode.Array([])
        for i1 in self.convert_toks:
          h = (hnode.Leaf("_", color_e.OtherConst) if i1 is None else
               i1.PrettyTree(trav=trav))
          x1.children.append(h)
        L.append(Field('convert_toks', x1))
  
      if self.capture_names is not None:  # List
        x2 = hnode.Array([])
        for i2 in self.capture_names:
          x2.children.append(NewLeaf(i2, color_e.StringConst))
        L.append(Field('capture_names', x2))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('eggex_ops.Yes')
      L = out_node.fields
      if self.convert_funcs is not None:  # List
        x0 = hnode.Array([])
        for i0 in self.convert_funcs:
          h = (hnode.Leaf("_", color_e.OtherConst) if i0 is None else
               i0.AbbreviatedTree(trav=trav))
          x0.children.append(h)
        L.append(Field('convert_funcs', x0))
  
      if self.convert_toks is not None:  # List
        x1 = hnode.Array([])
        for i1 in self.convert_toks:
          h = (hnode.Leaf("_", color_e.OtherConst) if i1 is None else
               i1.AbbreviatedTree(trav=trav))
          x1.children.append(h)
        L.append(Field('convert_toks', x1))
  
      if self.capture_names is not None:  # List
        x2 = hnode.Array([])
        for i2 in self.capture_names:
          x2.children.append(NewLeaf(i2, color_e.StringConst))
        L.append(Field('capture_names', x2))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  pass

class regex_match_e(object):
  No = 1
  Yes = 67

_regex_match_str = {
  1: 'No',
  67: 'Yes',
}

def regex_match_str(tag, dot=True):
  # type: (int, bool) -> str
  v = _regex_match_str[tag]
  if dot:
    return "regex_match.%s" % v
  else:
    return v

class regex_match_t(pybase.CompoundObj):
  def tag(self):
    # type: () -> int
    return self._type_tag
  pass

class regex_match__No(regex_match_t):
  _type_tag = 1
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('regex_match__No')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('regex_match__No')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class regex_match(object):
  No = regex_match__No()
  
  pass

class value_e(object):
  Interrupted = 1
  Stdin = 2
  Undef = 3
  Str = 4
  BashArray = 5
  SparseArray = 6
  BashAssoc = 7
  Null = 8
  Bool = 9
  Int = 10
  Float = 11
  List = 12
  Dict = 13
  Obj = 68
  Eggex = 15
  Match = 67
  Expr = 17
  Command = 18
  Block = 19
  Place = 20
  Module = 21
  BuiltinFunc = 22
  BoundFunc = 23
  Proc = 24
  Func = 25
  Range = 26
  Slice = 27

_value_str = {
  1: 'Interrupted',
  2: 'Stdin',
  3: 'Undef',
  4: 'Str',
  5: 'BashArray',
  6: 'SparseArray',
  7: 'BashAssoc',
  8: 'Null',
  9: 'Bool',
  10: 'Int',
  11: 'Float',
  12: 'List',
  13: 'Dict',
  15: 'Eggex',
  17: 'Expr',
  18: 'Command',
  19: 'Block',
  20: 'Place',
  21: 'Module',
  22: 'BuiltinFunc',
  23: 'BoundFunc',
  24: 'Proc',
  25: 'Func',
  26: 'Range',
  27: 'Slice',
  67: 'Match',
  68: 'Obj',
}

def value_str(tag, dot=True):
  # type: (int, bool) -> str
  v = _value_str[tag]
  if dot:
    return "value.%s" % v
  else:
    return v

class value_t(pybase.CompoundObj):
  def tag(self):
    # type: () -> int
    return self._type_tag
  pass

class value__Interrupted(value_t):
  _type_tag = 1
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('value__Interrupted')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('value__Interrupted')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class value__Stdin(value_t):
  _type_tag = 2
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('value__Stdin')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('value__Stdin')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class value__Undef(value_t):
  _type_tag = 3
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('value__Undef')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('value__Undef')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class value__Null(value_t):
  _type_tag = 8
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('value__Null')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('value__Null')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class value(object):
  Interrupted = value__Interrupted()
  
  Stdin = value__Stdin()
  
  Undef = value__Undef()
  
  class Str(value_t):
    _type_tag = 4
    __slots__ = ('s',)
  
    def __init__(self, s):
      # type: (str) -> None
      self.s = s
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.Str
      return value.Str('')
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Str')
      L = out_node.fields
  
      x0 = NewLeaf(self.s, color_e.StringConst)
      L.append(Field('s', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Str')
      L = out_node.fields
      x0 = NewLeaf(self.s, color_e.StringConst)
      L.append(Field('s', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class BashArray(value_t):
    _type_tag = 5
    __slots__ = ('strs',)
  
    def __init__(self, strs):
      # type: (List[str]) -> None
      self.strs = strs
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.BashArray
      return value.BashArray([] if alloc_lists else cast('List[str]', None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.BashArray')
      L = out_node.fields
  
      if self.strs is not None:  # List
        x0 = hnode.Array([])
        for i0 in self.strs:
          x0.children.append(NewLeaf(i0, color_e.StringConst))
        L.append(Field('strs', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.BashArray')
      L = out_node.fields
      if self.strs is not None:  # List
        x0 = hnode.Array([])
        for i0 in self.strs:
          x0.children.append(NewLeaf(i0, color_e.StringConst))
        L.append(Field('strs', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class SparseArray(value_t):
    _type_tag = 6
    __slots__ = ('d', 'max_index')
  
    def __init__(self, d, max_index):
      # type: (Dict[mops.BigInt, str], mops.BigInt) -> None
      self.d = d
      self.max_index = max_index
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.SparseArray
      return value.SparseArray(cast('Dict[mops.BigInt, str]', None), mops.BigInt(-1))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.SparseArray')
      L = out_node.fields
  
      if self.d is not None:  # Dict
        m = hnode.Leaf("Dict", color_e.OtherConst)
        x0 = hnode.Array([m])
        for k0, v0 in self.d.iteritems():
          x0.children.append(hnode.Leaf(mops.ToStr(k0), color_e.OtherConst))
          x0.children.append(NewLeaf(v0, color_e.StringConst))
        L.append(Field('d', x0))
  
      x1 = hnode.Leaf(mops.ToStr(self.max_index), color_e.OtherConst)
      L.append(Field('max_index', x1))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.SparseArray')
      L = out_node.fields
      if self.d is not None:  # Dict
        m = hnode.Leaf("Dict", color_e.OtherConst)
        x0 = hnode.Array([m])
        for k0, v0 in self.d.iteritems():
          x0.children.append(hnode.Leaf(mops.ToStr(k0), color_e.OtherConst))
          x0.children.append(NewLeaf(v0, color_e.StringConst))
        L.append(Field('d', x0))
  
      x1 = hnode.Leaf(mops.ToStr(self.max_index), color_e.OtherConst)
      L.append(Field('max_index', x1))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class BashAssoc(value_t):
    _type_tag = 7
    __slots__ = ('d',)
  
    def __init__(self, d):
      # type: (Dict[str, str]) -> None
      self.d = d
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.BashAssoc
      return value.BashAssoc(cast('Dict[str, str]', None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.BashAssoc')
      L = out_node.fields
  
      if self.d is not None:  # Dict
        m = hnode.Leaf("Dict", color_e.OtherConst)
        x0 = hnode.Array([m])
        for k0, v0 in self.d.iteritems():
          x0.children.append(NewLeaf(k0, color_e.StringConst))
          x0.children.append(NewLeaf(v0, color_e.StringConst))
        L.append(Field('d', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.BashAssoc')
      L = out_node.fields
      if self.d is not None:  # Dict
        m = hnode.Leaf("Dict", color_e.OtherConst)
        x0 = hnode.Array([m])
        for k0, v0 in self.d.iteritems():
          x0.children.append(NewLeaf(k0, color_e.StringConst))
          x0.children.append(NewLeaf(v0, color_e.StringConst))
        L.append(Field('d', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  Null = value__Null()
  
  class Bool(value_t):
    _type_tag = 9
    __slots__ = ('b',)
  
    def __init__(self, b):
      # type: (bool) -> None
      self.b = b
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.Bool
      return value.Bool(False)
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Bool')
      L = out_node.fields
  
      x0 = hnode.Leaf('T' if self.b else 'F', color_e.OtherConst)
      L.append(Field('b', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Bool')
      L = out_node.fields
      x0 = hnode.Leaf('T' if self.b else 'F', color_e.OtherConst)
      L.append(Field('b', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Int(value_t):
    _type_tag = 10
    __slots__ = ('i',)
  
    def __init__(self, i):
      # type: (mops.BigInt) -> None
      self.i = i
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.Int
      return value.Int(mops.BigInt(-1))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Int')
      L = out_node.fields
  
      x0 = hnode.Leaf(mops.ToStr(self.i), color_e.OtherConst)
      L.append(Field('i', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Int')
      L = out_node.fields
      x0 = hnode.Leaf(mops.ToStr(self.i), color_e.OtherConst)
      L.append(Field('i', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Float(value_t):
    _type_tag = 11
    __slots__ = ('f',)
  
    def __init__(self, f):
      # type: (float) -> None
      self.f = f
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.Float
      return value.Float(0.0)
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Float')
      L = out_node.fields
  
      x0 = hnode.Leaf(str(self.f), color_e.OtherConst)
      L.append(Field('f', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Float')
      L = out_node.fields
      x0 = hnode.Leaf(str(self.f), color_e.OtherConst)
      L.append(Field('f', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class List(value_t):
    _type_tag = 12
    __slots__ = ('items',)
  
    def __init__(self, items):
      # type: (List[value_t]) -> None
      self.items = items
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.List
      return value.List([] if alloc_lists else cast('List[value_t]', None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.List')
      L = out_node.fields
  
      if self.items is not None:  # List
        x0 = hnode.Array([])
        for i0 in self.items:
          h = (hnode.Leaf("_", color_e.OtherConst) if i0 is None else
               i0.PrettyTree(trav=trav))
          x0.children.append(h)
        L.append(Field('items', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.List')
      L = out_node.fields
      if self.items is not None:  # List
        x0 = hnode.Array([])
        for i0 in self.items:
          h = (hnode.Leaf("_", color_e.OtherConst) if i0 is None else
               i0.AbbreviatedTree(trav=trav))
          x0.children.append(h)
        L.append(Field('items', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Dict(value_t):
    _type_tag = 13
    __slots__ = ('d',)
  
    def __init__(self, d):
      # type: (Dict[str, value_t]) -> None
      self.d = d
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.Dict
      return value.Dict(cast('Dict[str, value_t]', None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Dict')
      L = out_node.fields
  
      if self.d is not None:  # Dict
        m = hnode.Leaf("Dict", color_e.OtherConst)
        x0 = hnode.Array([m])
        for k0, v0 in self.d.iteritems():
          x0.children.append(NewLeaf(k0, color_e.StringConst))
          x0.children.append(v0.PrettyTree(trav=trav))
        L.append(Field('d', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Dict')
      L = out_node.fields
      if self.d is not None:  # Dict
        m = hnode.Leaf("Dict", color_e.OtherConst)
        x0 = hnode.Array([m])
        for k0, v0 in self.d.iteritems():
          x0.children.append(NewLeaf(k0, color_e.StringConst))
          x0.children.append(v0.AbbreviatedTree(trav=trav))
        L.append(Field('d', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Eggex(value_t):
    _type_tag = 15
    __slots__ = ('spliced', 'canonical_flags', 'convert_funcs', 'convert_toks',
                 'as_ere', 'capture_names')
  
    def __init__(self, spliced, canonical_flags, convert_funcs, convert_toks,
                 as_ere, capture_names):
      # type: (re_t, str, List[Optional[value_t]], List[Optional[Token]], Optional[str], List[Optional[str]]) -> None
      self.spliced = spliced
      self.canonical_flags = canonical_flags
      self.convert_funcs = convert_funcs
      self.convert_toks = convert_toks
      self.as_ere = as_ere
      self.capture_names = capture_names
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.Eggex
      return value.Eggex(cast(re_t, None), '', [] if alloc_lists else cast('List[Optional[value_t]]', None), [] if alloc_lists else cast('List[Optional[Token]]', None), cast('Optional[str]', None), [] if alloc_lists else cast('List[Optional[str]]', None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Eggex')
      L = out_node.fields
  
      assert self.spliced is not None
      x0 = self.spliced.PrettyTree(trav=trav)
      L.append(Field('spliced', x0))
  
      x1 = NewLeaf(self.canonical_flags, color_e.StringConst)
      L.append(Field('canonical_flags', x1))
  
      if self.convert_funcs is not None:  # List
        x2 = hnode.Array([])
        for i2 in self.convert_funcs:
          h = (hnode.Leaf("_", color_e.OtherConst) if i2 is None else
               i2.PrettyTree(trav=trav))
          x2.children.append(h)
        L.append(Field('convert_funcs', x2))
  
      if self.convert_toks is not None:  # List
        x3 = hnode.Array([])
        for i3 in self.convert_toks:
          h = (hnode.Leaf("_", color_e.OtherConst) if i3 is None else
               i3.PrettyTree(trav=trav))
          x3.children.append(h)
        L.append(Field('convert_toks', x3))
  
      if self.as_ere is not None:  # Optional
        x4 = NewLeaf(self.as_ere, color_e.StringConst)
        L.append(Field('as_ere', x4))
  
      if self.capture_names is not None:  # List
        x5 = hnode.Array([])
        for i5 in self.capture_names:
          x5.children.append(NewLeaf(i5, color_e.StringConst))
        L.append(Field('capture_names', x5))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Eggex')
      L = out_node.fields
      assert self.spliced is not None
      x0 = self.spliced.AbbreviatedTree(trav=trav)
      L.append(Field('spliced', x0))
  
      x1 = NewLeaf(self.canonical_flags, color_e.StringConst)
      L.append(Field('canonical_flags', x1))
  
      if self.convert_funcs is not None:  # List
        x2 = hnode.Array([])
        for i2 in self.convert_funcs:
          h = (hnode.Leaf("_", color_e.OtherConst) if i2 is None else
               i2.AbbreviatedTree(trav=trav))
          x2.children.append(h)
        L.append(Field('convert_funcs', x2))
  
      if self.convert_toks is not None:  # List
        x3 = hnode.Array([])
        for i3 in self.convert_toks:
          h = (hnode.Leaf("_", color_e.OtherConst) if i3 is None else
               i3.AbbreviatedTree(trav=trav))
          x3.children.append(h)
        L.append(Field('convert_toks', x3))
  
      if self.as_ere is not None:  # Optional
        x4 = NewLeaf(self.as_ere, color_e.StringConst)
        L.append(Field('as_ere', x4))
  
      if self.capture_names is not None:  # List
        x5 = hnode.Array([])
        for i5 in self.capture_names:
          x5.children.append(NewLeaf(i5, color_e.StringConst))
        L.append(Field('capture_names', x5))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Expr(value_t):
    _type_tag = 17
    __slots__ = ('e',)
  
    def __init__(self, e):
      # type: (expr_t) -> None
      self.e = e
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.Expr
      return value.Expr(cast(expr_t, None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Expr')
      L = out_node.fields
  
      assert self.e is not None
      x0 = self.e.PrettyTree(trav=trav)
      L.append(Field('e', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Expr')
      L = out_node.fields
      assert self.e is not None
      x0 = self.e.AbbreviatedTree(trav=trav)
      L.append(Field('e', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Command(value_t):
    _type_tag = 18
    __slots__ = ('c',)
  
    def __init__(self, c):
      # type: (command_t) -> None
      self.c = c
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.Command
      return value.Command(cast(command_t, None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Command')
      L = out_node.fields
  
      assert self.c is not None
      x0 = self.c.PrettyTree(trav=trav)
      L.append(Field('c', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Command')
      L = out_node.fields
      assert self.c is not None
      x0 = self.c.AbbreviatedTree(trav=trav)
      L.append(Field('c', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Block(value_t):
    _type_tag = 19
    __slots__ = ('block',)
  
    def __init__(self, block):
      # type: (LiteralBlock) -> None
      self.block = block
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.Block
      return value.Block(cast(LiteralBlock, None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Block')
      L = out_node.fields
  
      assert self.block is not None
      x0 = self.block.PrettyTree(trav=trav)
      L.append(Field('block', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Block')
      L = out_node.fields
      assert self.block is not None
      x0 = self.block.AbbreviatedTree(trav=trav)
      L.append(Field('block', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Place(value_t):
    _type_tag = 20
    __slots__ = ('lval', 'frame')
  
    def __init__(self, lval, frame):
      # type: (y_lvalue_t, Dict[str, Cell]) -> None
      self.lval = lval
      self.frame = frame
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.Place
      return value.Place(cast(y_lvalue_t, None), cast('Dict[str, Cell]', None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Place')
      L = out_node.fields
  
      assert self.lval is not None
      x0 = self.lval.PrettyTree(trav=trav)
      L.append(Field('lval', x0))
  
      if self.frame is not None:  # Dict
        m = hnode.Leaf("Dict", color_e.OtherConst)
        x1 = hnode.Array([m])
        for k1, v1 in self.frame.iteritems():
          x1.children.append(NewLeaf(k1, color_e.StringConst))
          x1.children.append(v1.PrettyTree(trav=trav))
        L.append(Field('frame', x1))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Place')
      L = out_node.fields
      assert self.lval is not None
      x0 = self.lval.AbbreviatedTree(trav=trav)
      L.append(Field('lval', x0))
  
      if self.frame is not None:  # Dict
        m = hnode.Leaf("Dict", color_e.OtherConst)
        x1 = hnode.Array([m])
        for k1, v1 in self.frame.iteritems():
          x1.children.append(NewLeaf(k1, color_e.StringConst))
          x1.children.append(v1.AbbreviatedTree(trav=trav))
        L.append(Field('frame', x1))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Module(value_t):
    _type_tag = 21
    __slots__ = ('defs',)
  
    def __init__(self, defs):
      # type: (Dict[str, value_t]) -> None
      self.defs = defs
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.Module
      return value.Module(cast('Dict[str, value_t]', None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Module')
      L = out_node.fields
  
      if self.defs is not None:  # Dict
        m = hnode.Leaf("Dict", color_e.OtherConst)
        x0 = hnode.Array([m])
        for k0, v0 in self.defs.iteritems():
          x0.children.append(NewLeaf(k0, color_e.StringConst))
          x0.children.append(v0.PrettyTree(trav=trav))
        L.append(Field('defs', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Module')
      L = out_node.fields
      if self.defs is not None:  # Dict
        m = hnode.Leaf("Dict", color_e.OtherConst)
        x0 = hnode.Array([m])
        for k0, v0 in self.defs.iteritems():
          x0.children.append(NewLeaf(k0, color_e.StringConst))
          x0.children.append(v0.AbbreviatedTree(trav=trav))
        L.append(Field('defs', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class BuiltinFunc(value_t):
    _type_tag = 22
    __slots__ = ('callable',)
  
    def __init__(self, callable):
      # type: (Any) -> None
      self.callable = callable
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.BuiltinFunc
      return value.BuiltinFunc(cast(Any, None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.BuiltinFunc')
      L = out_node.fields
  
      x0 = hnode.External(self.callable)
      L.append(Field('callable', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.BuiltinFunc')
      L = out_node.fields
      x0 = hnode.External(self.callable)
      L.append(Field('callable', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class BoundFunc(value_t):
    _type_tag = 23
    __slots__ = ('me', 'func')
  
    def __init__(self, me, func):
      # type: (value_t, value_t) -> None
      self.me = me
      self.func = func
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.BoundFunc
      return value.BoundFunc(cast(value_t, None), cast(value_t, None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.BoundFunc')
      L = out_node.fields
  
      assert self.me is not None
      x0 = self.me.PrettyTree(trav=trav)
      L.append(Field('me', x0))
  
      assert self.func is not None
      x1 = self.func.PrettyTree(trav=trav)
      L.append(Field('func', x1))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.BoundFunc')
      L = out_node.fields
      assert self.me is not None
      x0 = self.me.AbbreviatedTree(trav=trav)
      L.append(Field('me', x0))
  
      assert self.func is not None
      x1 = self.func.AbbreviatedTree(trav=trav)
      L.append(Field('func', x1))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Proc(value_t):
    _type_tag = 24
    __slots__ = ('name', 'name_tok', 'sig', 'body', 'defaults', 'sh_compat')
  
    def __init__(self, name, name_tok, sig, body, defaults, sh_compat):
      # type: (str, Token, proc_sig_t, command_t, Optional[ProcDefaults], bool) -> None
      self.name = name
      self.name_tok = name_tok
      self.sig = sig
      self.body = body
      self.defaults = defaults
      self.sh_compat = sh_compat
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.Proc
      return value.Proc('', cast(Token, None), cast(proc_sig_t, None), cast(command_t, None), cast('Optional[ProcDefaults]', None), False)
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Proc')
      L = out_node.fields
  
      x0 = NewLeaf(self.name, color_e.StringConst)
      L.append(Field('name', x0))
  
      assert self.name_tok is not None
      x1 = self.name_tok.PrettyTree(trav=trav)
      L.append(Field('name_tok', x1))
  
      assert self.sig is not None
      x2 = self.sig.PrettyTree(trav=trav)
      L.append(Field('sig', x2))
  
      assert self.body is not None
      x3 = self.body.PrettyTree(trav=trav)
      L.append(Field('body', x3))
  
      if self.defaults is not None:  # Optional
        x4 = self.defaults.PrettyTree(trav=trav)
        L.append(Field('defaults', x4))
  
      x5 = hnode.Leaf('T' if self.sh_compat else 'F', color_e.OtherConst)
      L.append(Field('sh_compat', x5))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Proc')
      L = out_node.fields
      x0 = NewLeaf(self.name, color_e.StringConst)
      L.append(Field('name', x0))
  
      assert self.name_tok is not None
      x1 = self.name_tok.AbbreviatedTree(trav=trav)
      L.append(Field('name_tok', x1))
  
      assert self.sig is not None
      x2 = self.sig.AbbreviatedTree(trav=trav)
      L.append(Field('sig', x2))
  
      assert self.body is not None
      x3 = self.body.AbbreviatedTree(trav=trav)
      L.append(Field('body', x3))
  
      if self.defaults is not None:  # Optional
        x4 = self.defaults.AbbreviatedTree(trav=trav)
        L.append(Field('defaults', x4))
  
      x5 = hnode.Leaf('T' if self.sh_compat else 'F', color_e.OtherConst)
      L.append(Field('sh_compat', x5))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Func(value_t):
    _type_tag = 25
    __slots__ = ('name', 'parsed', 'pos_defaults', 'named_defaults', 'module_')
  
    def __init__(self, name, parsed, pos_defaults, named_defaults, module_):
      # type: (str, Func, List[value_t], Dict[str, value_t], Optional[Dict[str, Cell]]) -> None
      self.name = name
      self.parsed = parsed
      self.pos_defaults = pos_defaults
      self.named_defaults = named_defaults
      self.module_ = module_
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.Func
      return value.Func('', cast(Func, None), [] if alloc_lists else cast('List[value_t]', None), cast('Dict[str, value_t]', None), cast('Optional[Dict[str, Cell]]', None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Func')
      L = out_node.fields
  
      x0 = NewLeaf(self.name, color_e.StringConst)
      L.append(Field('name', x0))
  
      assert self.parsed is not None
      x1 = self.parsed.PrettyTree(trav=trav)
      L.append(Field('parsed', x1))
  
      if self.pos_defaults is not None:  # List
        x2 = hnode.Array([])
        for i2 in self.pos_defaults:
          h = (hnode.Leaf("_", color_e.OtherConst) if i2 is None else
               i2.PrettyTree(trav=trav))
          x2.children.append(h)
        L.append(Field('pos_defaults', x2))
  
      if self.named_defaults is not None:  # Dict
        m = hnode.Leaf("Dict", color_e.OtherConst)
        x3 = hnode.Array([m])
        for k3, v3 in self.named_defaults.iteritems():
          x3.children.append(NewLeaf(k3, color_e.StringConst))
          x3.children.append(v3.PrettyTree(trav=trav))
        L.append(Field('named_defaults', x3))
  
      if self.module_ is not None:  # Dict
        m = hnode.Leaf("Dict", color_e.OtherConst)
        x4 = hnode.Array([m])
        for k4, v4 in self.module_.iteritems():
          x4.children.append(NewLeaf(k4, color_e.StringConst))
          x4.children.append(v4.PrettyTree(trav=trav))
        L.append(Field('module_', x4))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Func')
      L = out_node.fields
      x0 = NewLeaf(self.name, color_e.StringConst)
      L.append(Field('name', x0))
  
      assert self.parsed is not None
      x1 = self.parsed.AbbreviatedTree(trav=trav)
      L.append(Field('parsed', x1))
  
      if self.pos_defaults is not None:  # List
        x2 = hnode.Array([])
        for i2 in self.pos_defaults:
          h = (hnode.Leaf("_", color_e.OtherConst) if i2 is None else
               i2.AbbreviatedTree(trav=trav))
          x2.children.append(h)
        L.append(Field('pos_defaults', x2))
  
      if self.named_defaults is not None:  # Dict
        m = hnode.Leaf("Dict", color_e.OtherConst)
        x3 = hnode.Array([m])
        for k3, v3 in self.named_defaults.iteritems():
          x3.children.append(NewLeaf(k3, color_e.StringConst))
          x3.children.append(v3.AbbreviatedTree(trav=trav))
        L.append(Field('named_defaults', x3))
  
      if self.module_ is not None:  # Dict
        m = hnode.Leaf("Dict", color_e.OtherConst)
        x4 = hnode.Array([m])
        for k4, v4 in self.module_.iteritems():
          x4.children.append(NewLeaf(k4, color_e.StringConst))
          x4.children.append(v4.AbbreviatedTree(trav=trav))
        L.append(Field('module_', x4))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Range(value_t):
    _type_tag = 26
    __slots__ = ('lower', 'upper')
  
    def __init__(self, lower, upper):
      # type: (int, int) -> None
      self.lower = lower
      self.upper = upper
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.Range
      return value.Range(-1, -1)
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Range')
      L = out_node.fields
  
      x0 = hnode.Leaf(str(self.lower), color_e.OtherConst)
      L.append(Field('lower', x0))
  
      x1 = hnode.Leaf(str(self.upper), color_e.OtherConst)
      L.append(Field('upper', x1))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Range')
      L = out_node.fields
      x0 = hnode.Leaf(str(self.lower), color_e.OtherConst)
      L.append(Field('lower', x0))
  
      x1 = hnode.Leaf(str(self.upper), color_e.OtherConst)
      L.append(Field('upper', x1))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Slice(value_t):
    _type_tag = 27
    __slots__ = ('lower', 'upper')
  
    def __init__(self, lower, upper):
      # type: (Optional[IntBox], Optional[IntBox]) -> None
      self.lower = lower
      self.upper = upper
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> value.Slice
      return value.Slice(cast('Optional[IntBox]', None), cast('Optional[IntBox]', None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Slice')
      L = out_node.fields
  
      if self.lower is not None:  # Optional
        x0 = self.lower.PrettyTree(trav=trav)
        L.append(Field('lower', x0))
  
      if self.upper is not None:  # Optional
        x1 = self.upper.PrettyTree(trav=trav)
        L.append(Field('upper', x1))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('value.Slice')
      L = out_node.fields
      if self.lower is not None:  # Optional
        x0 = self.lower.AbbreviatedTree(trav=trav)
        L.append(Field('lower', x0))
  
      if self.upper is not None:  # Optional
        x1 = self.upper.AbbreviatedTree(trav=trav)
        L.append(Field('upper', x1))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  pass

class IntBox(pybase.CompoundObj):
  _type_tag = 64
  __slots__ = ('i',)

  def __init__(self, i):
    # type: (int) -> None
    self.i = i

  @staticmethod
  def CreateNull(alloc_lists=False):
    # type: () -> IntBox
    return IntBox(-1)

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('IntBox')
    L = out_node.fields

    x0 = hnode.Leaf(str(self.i), color_e.OtherConst)
    L.append(Field('i', x0))

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('IntBox')
    L = out_node.fields
    x0 = hnode.Leaf(str(self.i), color_e.OtherConst)
    L.append(Field('i', x0))

    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class ProcDefaults(pybase.CompoundObj):
  _type_tag = 65
  __slots__ = ('for_word', 'for_typed', 'for_named', 'for_block')

  def __init__(self, for_word, for_typed, for_named, for_block):
    # type: (Optional[List[value_t]], Optional[List[value_t]], Optional[Dict[str, value_t]], Optional[value_t]) -> None
    self.for_word = for_word
    self.for_typed = for_typed
    self.for_named = for_named
    self.for_block = for_block

  @staticmethod
  def CreateNull(alloc_lists=False):
    # type: () -> ProcDefaults
    return ProcDefaults(cast('Optional[List[value_t]]', None), cast('Optional[List[value_t]]', None), cast('Optional[Dict[str, value_t]]', None), cast('Optional[value_t]', None))

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('ProcDefaults')
    L = out_node.fields

    if self.for_word is not None:  # List
      x0 = hnode.Array([])
      for i0 in self.for_word:
        h = (hnode.Leaf("_", color_e.OtherConst) if i0 is None else
             i0.PrettyTree(trav=trav))
        x0.children.append(h)
      L.append(Field('for_word', x0))

    if self.for_typed is not None:  # List
      x1 = hnode.Array([])
      for i1 in self.for_typed:
        h = (hnode.Leaf("_", color_e.OtherConst) if i1 is None else
             i1.PrettyTree(trav=trav))
        x1.children.append(h)
      L.append(Field('for_typed', x1))

    if self.for_named is not None:  # Dict
      m = hnode.Leaf("Dict", color_e.OtherConst)
      x2 = hnode.Array([m])
      for k2, v2 in self.for_named.iteritems():
        x2.children.append(NewLeaf(k2, color_e.StringConst))
        x2.children.append(v2.PrettyTree(trav=trav))
      L.append(Field('for_named', x2))

    if self.for_block is not None:  # Optional
      x3 = self.for_block.PrettyTree(trav=trav)
      L.append(Field('for_block', x3))

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('ProcDefaults')
    L = out_node.fields
    if self.for_word is not None:  # List
      x0 = hnode.Array([])
      for i0 in self.for_word:
        h = (hnode.Leaf("_", color_e.OtherConst) if i0 is None else
             i0.AbbreviatedTree(trav=trav))
        x0.children.append(h)
      L.append(Field('for_word', x0))

    if self.for_typed is not None:  # List
      x1 = hnode.Array([])
      for i1 in self.for_typed:
        h = (hnode.Leaf("_", color_e.OtherConst) if i1 is None else
             i1.AbbreviatedTree(trav=trav))
        x1.children.append(h)
      L.append(Field('for_typed', x1))

    if self.for_named is not None:  # Dict
      m = hnode.Leaf("Dict", color_e.OtherConst)
      x2 = hnode.Array([m])
      for k2, v2 in self.for_named.iteritems():
        x2.children.append(NewLeaf(k2, color_e.StringConst))
        x2.children.append(v2.AbbreviatedTree(trav=trav))
      L.append(Field('for_named', x2))

    if self.for_block is not None:  # Optional
      x3 = self.for_block.AbbreviatedTree(trav=trav)
      L.append(Field('for_block', x3))

    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class LeftName(y_lvalue_t, sh_lvalue_t):
  _type_tag = 66
  __slots__ = ('name', 'blame_loc')

  def __init__(self, name, blame_loc):
    # type: (str, loc_t) -> None
    self.name = name
    self.blame_loc = blame_loc

  @staticmethod
  def CreateNull(alloc_lists=False):
    # type: () -> LeftName
    return LeftName('', cast(loc_t, None))

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('LeftName')
    L = out_node.fields

    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(Field('name', x0))

    assert self.blame_loc is not None
    x1 = self.blame_loc.PrettyTree(trav=trav)
    L.append(Field('blame_loc', x1))

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('LeftName')
    L = out_node.fields
    x0 = NewLeaf(self.name, color_e.StringConst)
    L.append(Field('name', x0))

    assert self.blame_loc is not None
    x1 = self.blame_loc.AbbreviatedTree(trav=trav)
    L.append(Field('blame_loc', x1))

    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class RegexMatch(regex_match_t, value_t):
  _type_tag = 67
  __slots__ = ('s', 'indices', 'ops')

  def __init__(self, s, indices, ops):
    # type: (str, List[int], eggex_ops_t) -> None
    self.s = s
    self.indices = indices
    self.ops = ops

  @staticmethod
  def CreateNull(alloc_lists=False):
    # type: () -> RegexMatch
    return RegexMatch('', [] if alloc_lists else cast('List[int]', None), cast(eggex_ops_t, None))

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('RegexMatch')
    L = out_node.fields

    x0 = NewLeaf(self.s, color_e.StringConst)
    L.append(Field('s', x0))

    if self.indices is not None:  # List
      x1 = hnode.Array([])
      for i1 in self.indices:
        x1.children.append(hnode.Leaf(str(i1), color_e.OtherConst))
      L.append(Field('indices', x1))

    assert self.ops is not None
    x2 = self.ops.PrettyTree(trav=trav)
    L.append(Field('ops', x2))

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('RegexMatch')
    L = out_node.fields
    x0 = NewLeaf(self.s, color_e.StringConst)
    L.append(Field('s', x0))

    if self.indices is not None:  # List
      x1 = hnode.Array([])
      for i1 in self.indices:
        x1.children.append(hnode.Leaf(str(i1), color_e.OtherConst))
      L.append(Field('indices', x1))

    assert self.ops is not None
    x2 = self.ops.AbbreviatedTree(trav=trav)
    L.append(Field('ops', x2))

    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class Obj(value_t):
  _type_tag = 68
  __slots__ = ('prototype', 'd')

  def __init__(self, prototype, d):
    # type: (Optional[Obj], Dict[str, value_t]) -> None
    self.prototype = prototype
    self.d = d

  @staticmethod
  def CreateNull(alloc_lists=False):
    # type: () -> Obj
    return Obj(cast('Optional[Obj]', None), cast('Dict[str, value_t]', None))

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('Obj')
    L = out_node.fields

    if self.prototype is not None:  # Optional
      x0 = self.prototype.PrettyTree(trav=trav)
      L.append(Field('prototype', x0))

    if self.d is not None:  # Dict
      m = hnode.Leaf("Dict", color_e.OtherConst)
      x1 = hnode.Array([m])
      for k1, v1 in self.d.iteritems():
        x1.children.append(NewLeaf(k1, color_e.StringConst))
        x1.children.append(v1.PrettyTree(trav=trav))
      L.append(Field('d', x1))

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('Obj')
    L = out_node.fields
    if self.prototype is not None:  # Optional
      x0 = self.prototype.AbbreviatedTree(trav=trav)
      L.append(Field('prototype', x0))

    if self.d is not None:  # Dict
      m = hnode.Leaf("Dict", color_e.OtherConst)
      x1 = hnode.Array([m])
      for k1, v1 in self.d.iteritems():
        x1.children.append(NewLeaf(k1, color_e.StringConst))
        x1.children.append(v1.AbbreviatedTree(trav=trav))
      L.append(Field('d', x1))

    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

