module clAmdBlas
  use cl

  implicit none

  private

  public ::                  &
    clAmdBlasGetVersion,     &
    clAmdBlasSetup,          &
    clAmdBlasTeardown,       &
    clAmdBlasDtrsmEx,        &
    clAmdBlasZtrsmEx,        &
    clAmdBlasDgemmEx,        &
    clAmdBlasZgemmEx,        &
    clAmdBlasDsyrkEx,        &
    clAmdBlasZherkEx

  integer, public, parameter ::     &
    clAmdBlasRowMajor        = 0,   &
    clAmdBlasColumnMajor     = 1

  integer, public, parameter ::     &
    clAmdBlasNoTrans         = 0,   &
    clAmdBlasTrans           = 1,   &
    clAmdBlasConjTrans       = 2

  integer, public, parameter ::     &
    clAmdBlasUpper           = 0,   &
    clAmdBlasLower           = 1

  integer, public, parameter ::     &
    clAmdBlasUnit            = 0,   &
    clAmdBlasNonUnit         = 1

  integer, public, parameter ::     &
    clAmdBlasLeft            = 0,   &
    clAmdBlasRight           = 1

  integer, public, parameter ::                                  &
    clAmdBlasSuccess               = CL_SUCCESS,                 &
    clAmdBlasInvalidValue          = CL_INVALID_VALUE,           &
    clAmdBlasInvalidCommandQueue   = CL_INVALID_COMMAND_QUEUE,   &
    clAmdBlasInvalidContext        = CL_INVALID_CONTEXT,         &
    clAmdBlasInvalidMemObject      = CL_INVALID_MEM_OBJECT,      &
    clAmdBlasInvalidDevice         = CL_INVALID_DEVICE,          &
    clAmdBlasInvalidEventWaitList  = CL_INVALID_EVENT_WAIT_LIST, &
    clAmdBlasOutOfResources        = CL_OUT_OF_RESOURCES,        &
    clAmdBlasOutOfHostMemory       = CL_OUT_OF_HOST_MEMORY,      &
    clAmdBlasInvalidOperation      = CL_INVALID_OPERATION,       &
    clAmdBlasCompilerNotAvailable  = CL_COMPILER_NOT_AVAILABLE,  &
    clAmdBlasBuildProgramFailure   = CL_BUILD_PROGRAM_FAILURE

  integer, public, parameter ::             &
    clAmdBlasNotImplemented        = -1024, &
    clAmdBlasNotInitialized        = -1023, &
    clAmdBlasInvalidMatA           = -1022, &
    clAmdBlasInvalidMatB           = -1021, &
    clAmdBlasInvalidMatC           = -1020, &
    clAmdBlasInvalidVecX           = -1019, &
    clAmdBlasInvalidVecY           = -1018, &
    clAmdBlasInvalidDim            = -1017, &
    clAmdBlasInvalidLeadDimA       = -1016, &
    clAmdBlasInvalidLeadDimB       = -1015, &
    clAmdBlasInvalidLeadDimC       = -1014, &
    clAmdBlasInvalidIncX           = -1013, &
    clAmdBlasInvalidIncY           = -1012, &
    clAmdBlasInsufficientMemMatA   = -1011, &
    clAmdBlasInsufficientMemMatB   = -1010, &
    clAmdBlasInsufficientMemMatC   = -1009, &
    clAmdBlasInsufficientMemVecX   = -1008, &
    clAmdBlasInsufficientMemVecY   = -1007

  ! SUPPORT FUNCTIONS

  interface clAmdBlasGetVersion 
    subroutine clamdblasgetversion_low(major, minor, patch, status)
      implicit none

      integer, intent(out) :: major
      integer, intent(out) :: minor
      integer, intent(out) :: patch
      integer, intent(out) :: status
    end subroutine clamdblasgetversion_low
  end interface clAmdBlasGetVersion

  interface clAmdBlasSetup
    subroutine clamdblassetup_low(status)
      implicit none

      integer, intent(out) :: status
    end subroutine clamdblassetup_low
  end interface clAmdBlasSetup

  interface clAmdBlasTeardown
    subroutine clamdblasteardown_low()
    end subroutine clamdblasteardown_low
  end interface clAmdBlasTeardown

  ! -------------------------------------------------

  interface clAmdBlasDtrsmEx
    subroutine clamdblasdtrsmex_low(order, side, uplo, transA, diag, M, N, alpha, A, offA, lda, B, offB, ldb, commandQueue, status)
      use cl

      implicit none

      integer,                intent(in)    :: order
      integer,                intent(in)    :: side
      integer,                intent(in)    :: uplo
      integer,                intent(in)    :: transA
      integer,                intent(in)    :: diag
      integer(8),             intent(in)    :: M
      integer(8),             intent(in)    :: N
      real(8),                intent(in)    :: alpha
      type(cl_mem),           intent(inout) :: A
      integer(8),             intent(in)    :: offA
      integer(8),             intent(in)    :: lda
      type(cl_mem),           intent(inout) :: B
      integer(8),             intent(in)    :: offB
      integer(8),             intent(in)    :: ldb 
      type(cl_command_queue), intent(inout) :: CommandQueue 
      integer,                intent(out)   :: status
    end subroutine clamdblasdtrsmex_low
  end interface clAmdBlasDtrsmEx
  
  ! -------------------------------------------------

  interface clAmdBlasZtrsmEx
    subroutine clamdblasztrsmex_low(order, side, uplo, transA, diag, M, N, alpha, A, offA, lda, B, offB, ldb, commandQueue, status)
      use cl

      implicit none

      integer,                intent(in)    :: order
      integer,                intent(in)    :: side
      integer,                intent(in)    :: uplo
      integer,                intent(in)    :: transA
      integer,                intent(in)    :: diag
      integer(8),             intent(in)    :: M
      integer(8),             intent(in)    :: N
      complex(8),             intent(in)    :: alpha
      type(cl_mem),           intent(inout) :: A
      integer(8),             intent(in)    :: offA
      integer(8),             intent(in)    :: lda
      type(cl_mem),           intent(inout) :: B
      integer(8),             intent(in)    :: offB
      integer(8),             intent(in)    :: ldb 
      type(cl_command_queue), intent(inout) :: CommandQueue 
      integer,                intent(out)   :: status
    end subroutine clamdblasztrsmex_low
  end interface clAmdBlasZtrsmEx

  ! -------------------------------------------------

  interface clAmdBlasDgemmEx
    subroutine clAmdBlasDgemmEx_low(order, transA, transB, M, N, K, &
      alpha, A, offA, lda, B, offB, ldb, beta, C, offC, ldc, commandQueue, status)
      use cl

      implicit none

      integer,                intent(in)    :: order
      integer,                intent(in)    :: transA
      integer,                intent(in)    :: transB
      integer(8),             intent(in)    :: M
      integer(8),             intent(in)    :: N
      integer(8),             intent(in)    :: K
      real(8),                intent(in)    :: alpha
      type(cl_mem),           intent(in)    :: A
      integer(8),             intent(in)    :: offA
      integer(8),             intent(in)    :: lda
      type(cl_mem),           intent(in)    :: B
      integer(8),             intent(in)    :: offB
      integer(8),             intent(in)    :: ldb
      real(8),                intent(in)    :: beta
      type(cl_mem),           intent(inout) :: C
      integer(8),             intent(in)    :: offC
      integer(8),             intent(in)    :: ldc
      type(cl_command_queue), intent(inout) :: CommandQueue 
      integer,                intent(out)   :: status
    end subroutine clAmdBlasDgemmEx_low
  end interface clAmdBlasDgemmEx

  ! -------------------------------------------------

  interface clAmdBlasZgemmEx
    subroutine clAmdBlasZgemmEx_low(order, transA, transB, M, N, K, &
      alpha, A, offA, lda, B, offB, ldb, beta, C, offC, ldc, commandQueue, status)
      use cl

      implicit none

      integer,                intent(in)    :: order
      integer,                intent(in)    :: transA
      integer,                intent(in)    :: transB
      integer(8),             intent(in)    :: M
      integer(8),             intent(in)    :: N
      integer(8),             intent(in)    :: K
      complex(8),             intent(in)    :: alpha
      type(cl_mem),           intent(in)    :: A
      integer(8),             intent(in)    :: offA
      integer(8),             intent(in)    :: lda
      type(cl_mem),           intent(in)    :: B
      integer(8),             intent(in)    :: offB
      integer(8),             intent(in)    :: ldb
      complex(8),             intent(in)    :: beta
      type(cl_mem),           intent(inout) :: C
      integer(8),             intent(in)    :: offC
      integer(8),             intent(in)    :: ldc
      type(cl_command_queue), intent(inout) :: CommandQueue 
      integer,                intent(out)   :: status
    end subroutine clAmdBlasZgemmEx_low
  end interface clAmdBlasZgemmEx

  ! -------------------------------------------------

  interface clAmdBlasDsyrkEx
    subroutine clAmdBlasDsyrkEx_low(order, uplo, transA, N, K, &
      alpha, A, offA, lda, beta, C, offC, ldc, commandQueue, status)
      use cl

      implicit none

      integer,                intent(in)    :: order
      integer,                intent(in)    :: uplo
      integer,                intent(in)    :: transA
      integer(8),             intent(in)    :: N
      integer(8),             intent(in)    :: K
      real(8),                intent(in)    :: alpha
      type(cl_mem),           intent(in)    :: A
      integer(8),             intent(in)    :: offA
      integer(8),             intent(in)    :: lda
      real(8),                intent(in)    :: beta
      type(cl_mem),           intent(inout) :: C
      integer(8),             intent(in)    :: offC
      integer(8),             intent(in)    :: ldc
      type(cl_command_queue), intent(inout) :: CommandQueue 
      integer,                intent(out)   :: status
    end subroutine clAmdBlasDsyrkEx_low
  end interface clAmdBlasDsyrkEx
  ! -------------------------------------------------

  interface clAmdBlasZherkEx
    subroutine clAmdBlasZherkEx_low(order, uplo, transA, N, K, &
      alpha, A, offA, lda, beta, C, offC, ldc, commandQueue, status)
      use cl

      implicit none

      integer,                intent(in)    :: order
      integer,                intent(in)    :: uplo
      integer,                intent(in)    :: transA
      integer(8),             intent(in)    :: N
      integer(8),             intent(in)    :: K
      real(8),                intent(in)    :: alpha
      type(cl_mem),           intent(in)    :: A
      integer(8),             intent(in)    :: offA
      integer(8),             intent(in)    :: lda
      real(8),                intent(in)    :: beta
      type(cl_mem),           intent(inout) :: C
      integer(8),             intent(in)    :: offC
      integer(8),             intent(in)    :: ldc
      type(cl_command_queue), intent(inout) :: CommandQueue 
      integer,                intent(out)   :: status
    end subroutine clAmdBlasZherkEx_low
  end interface clAmdBlasZherkEx

end module clAmdBlas
