## Copyright (C) 1995-2007 R Core Team
## Copyright (C) 2019 Andrew Janke
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; If not, see <http://www.gnu.org/licenses/>.

# This is based on the USJudgeRatings dataset from R’s datasets package

classdef USJudgeRatings < octave.internal.dataset

  methods

    function this = USJudgeRatings
      this.name = "USJudgeRatings";
      this.summary = "Lawyers’ Ratings of State Judges in the US Superior Court";
    endfunction

    function out = load (this)
      CONT = [5.7, 6.8, 7.2, 6.8, 7.3, 6.2, 10.6, 7, 7.3, 8.2, ...
        7, 6.5, 6.7, 7, 6.5, 7.3, 8, 7.7, 8.3, 9.6, 7.1, 7.6, 6.6, 6.2, 7.5, 7.8, ...
        7.1, 7.5, 7.5, 7.1, 6.6, 8.4, 6.9, 7.3, 7.7, 8.5, 6.9, 6.5, 8.3, 8.3, 9, ...
        7.1, 8.6]';
      INTG = [7.9, 8.9, 8.1, 8.8, 6.4, 8.8, 9, 5.9, 8.9, 7.9, 8, ...
        8, 8.6, 7.5, 8.1, 8, 7.6, 7.7, 8.2, 6.9, 8.2, 7.3, 7.4, 8.3, 8.7, 8.9, ...
        8.5, 9, 8.1, 9.2, 7.4, 8, 8.5, 8.9, 6.2, 8.3, 8.3, 8.2, 7.3, 8.2, 7, 8.4, ...
        7.4]';
      DMNR = [7.7, 8.8, 7.8, 8.5, 4.3, 8.7, 8.9, 4.9, 8.9, 6.7, 7.6, 7.6, ...
        8.2, 6.4, 8, 7.4, 6.6, 6.7, 7.4, 5.7, 7.7, 6.9, 6.2, 8.1, 8.5, 8.7, 8.3, ...
        8.9, 7.7, 9, 6.9, 7.9, 7.8, 8.8, 5.1, 8.1, 8, 7.7, 7, 7.8, 5.9, 8.4, 7]';
      DILG = [7.3, 8.5, 7.8, 8.8, 6.5, 8.5, 8.7, 5.1, 8.7, 8.1, 7.4, 7.2, 6.8, ...
        6.8, 8, 7.7, 7.2, 7.5, 7.8, 6.6, 7.1, 6.8, 6.2, 7.7, 8.6, 8.9, 8, 8.7, ...
        8.2, 9, 8.4, 7.9, 8.5, 8.7, 5.6, 8.3, 8.1, 7.8, 6.8, 8.3, 7, 7.7, 7.5]';
      CFMG = [7.1, 7.8, 7.5, 8.3, 6, 7.9, 8.5, 5.4, 8.6, 7.9, 7.3, 7, ...
        6.9, 6.5, 7.9, 7.3, 6.5, 7.4, 7.7, 6.9, 6.6, 6.7, 5.4, 7.4, 8.5, ...
        8.7, 7.9, 8.4, 8, 8.4, 8, 7.8, 8.1, 8.4, 5.6, 8.4, 7.9, 7.6, 7, ...
        8.4, 7, 7.5, 7.5]';
      DECI = [7.4, 8.1, 7.6, 8.5, 6.2, 8, 8.5, 5.9, ...
        8.5, 8, 7.5, 7.1, 6.6, 7, 8, 7.3, 6.5, 7.5, 7.7, 6.6, 6.6, 6.8, ...
        5.7, 7.3, 8.4, 8.8, 7.9, 8.5, 8.1, 8.6, 7.9, 7.8, 8.2, 8.5, 5.9, ...
        8.2, 7.9, 7.7, 7.1, 8.3, 7.2, 7.7, 7.7]';
      PREP = [7.1, 8, 7.5, 8.7, ...
        5.7, 8.1, 8.5, 4.8, 8.4, 7.9, 7.1, 6.9, 7.1, 6.6, 7.9, 7.3, 6.8, ...
        7.1, 7.7, 6.2, 6.7, 6.4, 5.8, 7.3, 8.5, 8.9, 7.8, 8.4, 8.2, 9.1, ...
        8.2, 7.6, 8.4, 8.5, 5.6, 8.2, 7.9, 7.7, 6.7, 7.7, 6.9, 7.8, 7.4]';
      FAMI = [7.1, 8, 7.5, 8.7, 5.7, 8, 8.5, 5.1, 8.4, 8.1, 7.2, 7, 7.3, ...
        6.8, 7.8, 7.2, 6.7, 7.3, 7.8, 6, 6.7, 6.3, 5.9, 7.3, 8.5, 9, 7.8, ...
        8.3, 8.4, 9.1, 8.4, 7.4, 8.5, 8.5, 5.6, 8.1, 7.7, 7.7, 6.7, 7.6, ...
        6.9, 8.2, 7.2]';
      ORAL = [7.1, 7.8, 7.3, 8.4, 5.1, 8, 8.6, 4.7, 8.4, ...
        7.7, 7.1, 7, 7.2, 6.3, 7.8, 7.1, 6.4, 7.1, 7.5, 5.8, 6.8, 6.3, 5.2, ...
        7.2, 8.4, 8.8, 7.8, 8.3, 8, 8.9, 7.7, 7.4, 8.1, 8.4, 5.3, 7.9, 7.6, ...
        7.5, 6.7, 7.5, 6.5, 8, 6.9]';
      WRIT = [7, 7.9, 7.4, 8.5, 5.3, 8, ...
        8.4, 4.9, 8.5, 7.8, 7.2, 7.1, 7.2, 6.6, 7.8, 7.2, 6.5, 7.3, 7.6, ...
        5.8, 6.8, 6.3, 5.8, 7.3, 8.4, 8.9, 7.7, 8.3, 8.1, 9, 7.9, 7.4, 8.3, ...
        8.4, 5.5, 8, 7.7, 7.6, 6.7, 7.7, 6.6, 8.1, 7]';
      PHYS = [8.3, 8.5, ...
        7.9, 8.8, 5.5, 8.6, 9.1, 6.8, 8.8, 8.5, 8.4, 6.9, 8.1, 6.2, 8.4, ...
        8, 6.9, 8.1, 8, 7.2, 7.5, 7.4, 4.7, 7.8, 8.7, 9, 8.3, 8.8, 8.4, ...
        8.9, 8.4, 8.1, 8.7, 8.8, 6.3, 8, 8.1, 8.5, 8, 8.1, 7.6, 8.3, 7.8]';
      RTEN = [7.8, 8.7, 7.8, 8.7, 4.8, 8.6, 9, 5, 8.8, 7.9, 7.7, 7.2, ...
        7.7, 6.5, 8, 7.6, 6.7, 7.4, 8, 6, 7.3, 6.6, 5.2, 7.6, 8.7, 9, 8.2, ...
        8.7, 8.1, 9.2, 7.5, 7.9, 8.3, 8.8, 5.3, 8.2, 8, 7.7, 7, 7.9, 6.6, ...
        8.1, 7.1]';
      Judge = {"AARONSON,L.H.", "ALEXANDER,J.M.", ...
        "ARMENTANO,A.J.", "BERDON,R.I.", "BRACKEN,J.J.", "BURNS,E.B.", ...
        "CALLAHAN,R.J.", "COHEN,S.S.", "DALY,J.J.", "DANNEHY,J.F.", ...
        "DEAN,H.H.", "DEVITA,H.J.", "DRISCOLL,P.J.", "GRILLO,A.E.", ...
        "HADDEN,W.L.JR.", "HAMILL,E.C.", "HEALEY.A.H.", "HULL,T.C.", ...
        "LEVINE,I.", "LEVISTER,R.L.", "MARTIN,L.F.", "MCGRATH,J.F.", ...
        "MIGNONE,A.F.", "MISSAL,H.M.", "MULVEY,H.M.", "NARUK,H.J.", ...
        "O\'BRIEN,F.J.", "O\'SULLIVAN,T.J.", "PASKEY,L.", "RUBINOW,J.E.", ...
        "SADEN.G.A.", "SATANIELLO,A.G.", "SHEA,D.M.", "SHEA,J.F.JR.", ...
        "SIDOR,W.J.", "SPEZIALE,J.A.", "SPONZO,M.J.", "STAPLETON,J.F.", ...
        "TESTO,R.J.", "TIERNEY,W.L.JR.", "WALL,R.A.", "WRIGHT,D.B.", ...
        "ZARRILLI,K.J."}';
      out = table (Judge, CONT, INTG, DMNR, DILG, CFMG, DECI, PREP, ...
        FAMI, ORAL, WRIT, PHYS, RTEN);
    endfunction

  endmethods

endclassdef