## Copyright (C) 1995-2007 R Core Team
## Copyright (C) 2019 Andrew Janke
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; If not, see <http://www.gnu.org/licenses/>.

# This is based on the UKLungDeaths dataset from R’s datasets package

classdef UKLungDeaths < octave.internal.dataset

  methods

    function this = UKLungDeaths
      this.name = "UKLungDeaths";
      this.summary = "Monthly Deaths from Lung Diseases in the UK";
    endfunction

    function out = load (this)
      date = [datetime(1974, 1, 1):calmonths(1):datetime(1979, 12, 1)]';
      ldeaths = [3035, 2552, 2704, 2554, 2014, 1655, 1721, 1524, 1596, ...
        2074, 2199, 2512, 2933, 2889, 2938, 2497, 1870, 1726, 1607, 1545, ...
        1396, 1787, 2076, 2837, 2787, 3891, 3179, 2011, 1636, 1580, 1489, ...
        1300, 1356, 1653, 2013, 2823, 3102, 2294, 2385, 2444, 1748, 1554, ...
        1498, 1361, 1346, 1564, 1640, 2293, 2815, 3137, 2679, 1969, 1870, ...
        1633, 1529, 1366, 1357, 1570, 1535, 2491, 3084, 2605, 2573, 2143, ...
        1693, 1504, 1461, 1354, 1333, 1492, 1781, 1915]';
      fdeaths = [901, 689, 827, 677, 522, 406, 441, 393, 387, 582, ...
        578, 666, 830, 752, 785, 664, 467, 438, 421, 412, 343, 440, 531, ...
        771, 767, 1141, 896, 532, 447, 420, 376, 330, 357, 445, 546, ...
        764, 862, 660, 663, 643, 502, 392, 411, 348, 387, 385, 411, 638, ...
        796, 853, 737, 546, 530, 446, 431, 362, 387, 430, 425, 679, 821, ...
        785, 727, 612, 478, 429, 405, 379, 393, 411, 487, 574]';
      mdeaths = [2134, 1863, 1877, 1877, 1492, 1249, 1280, 1131, 1209, ...
        1492, 1621, 1846, 2103, 2137, 2153, 1833, 1403, 1288, 1186, 1133, ...
        1053, 1347, 1545, 2066, 2020, 2750, 2283, 1479, 1189, 1160, 1113, ...
        970, 999, 1208, 1467, 2059, 2240, 1634, 1722, 1801, 1246, 1162, ...
        1087, 1013, 959, 1179, 1229, 1655, 2019, 2284, 1942, 1423, 1340, ...
        1187, 1098, 1004, 970, 1140, 1110, 1812, 2263, 1820, 1846, 1531, ...
        1215, 1075, 1056, 975, 940, 1081, 1294, 1341]';
      out = table (date, ldeaths, fdeaths, mdeaths);
    endfunction

  endmethods

endclassdef