## Copyright (C) 2012 Moreno Marzolla
##
## This file is part of the queueing toolbox.
##
## The queueing toolbox is free software: you can redistribute it and/or
## modify it under the terms of the GNU General Public License as
## published by the Free Software Foundation, either version 3 of the
## License, or (at your option) any later version.
##
## The queueing toolbox is distributed in the hope that it will be
## useful, but WITHOUT ANY WARRANTY; without even the implied warranty
## of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with the queueing toolbox. If not, see <http://www.gnu.org/licenses/>.

## Usage:
##
## octave -q grabhelp.m ../inst/
##
## scans all .m files in the given directory (e.g., ../inst/). For each
## file f, dump the help text to f.texi. The given directory must be in
## Octave search path, otherwise no help text can be located.

clear all;

global fundirs;

if (nargin != 1)
  usage("grebhelp.m [script_path]");
endif

xdir = argv(){1};
srcdir = canonicalize_file_name (xdir);
fundirs = {srcdir};

for j=1:length(fundirs)
  d = fundirs{j};
  lst = dir (d);
  for i = 1:length (lst)
    nm = lst(i).name;
    [pp ff ss] = fileparts(nm);
    if ( strcmp(ss, ".m") )
      text = get_help_text(ff);
      if ( !isempty(text) )
	texiname = [ff ".texi"];
	printf("%s -> %s\n", ff, texiname);
	fid = fopen(texiname, "wt");
	fprintf(fid,"@c -*- texinfo -*-\n\n@c Copyright (C) 2012 Moreno Marzolla\n@c This file is part of the queueing toolbox, a Queueing Networks\n@c analysis package for GNU Octave. The queueing toolbox is distributed\n@c under the terms of the GNU General Public License version 3 or later\n\n@c This file is automatically generated from %s\n@c All modifications to this file will be lost\n\n",
		nm);

	## from __makeinfo__.m in Octave
		
	## Formatting in m-files has an extra space at the beginning of
	## every line. Remove these unwanted spaces if present.  First
	## text char is "\n" delim.
	text = strrep (text, "\n ", "\n");

	## Texinfo crashes if @end tex does not appear first on the line.
	text = regexprep (text, '^ +@end tex', '@end tex', 'lineanchors');

	fprintf(fid, "%s\n", text);
	fclose(fid);
      endif
    endif
  endfor 
endfor
