/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ltfat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.ltfat.Utils;
import net.sourceforge.ltfat.thirdparty.JRangeSlider;

public class SpectFrame {
    static final int defWidth = 800;
    static final int defHeight = 400;
    static final int heightRed = 4;
    private int height = 400;
    private int width = 800;
    private JFrame jf = null;
    SpectPanel spectPanel = null;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private int cmapLen = 256;
    private byte[] colormap = null;
    IndexColorModel cm = null;
    private int sidx = 0;
    private int srunPos = 0;
    private int defSpeed = 2;
    private int spectStep = this.defSpeed * this.width / 800;
    private String popupName = "LTFAT plot";
    private double climMax = 20.0;
    private double climMin = -70.0;
    private String climUnit = "dB";
    private final Object graphicsLock = new Object();

    public void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            super.finalize();
        }
    }

    public SpectFrame() {
        this(800, 400);
    }

    public SpectFrame(final int n, final int n2) {
        this.colormap = new byte[this.cmapLen * 3];
        for (int i = 0; i < this.cmapLen; ++i) {
            this.colormap[3 * i] = (byte)i;
            this.colormap[3 * i + 1] = (byte)i;
            this.colormap[3 * i + 2] = (byte)i;
        }
        this.cm = new IndexColorModel(8, this.cmapLen, this.colormap, 0, false);
        this.runInEDT(new Runnable(){

            @Override
            public void run() {
                SpectFrame.this.jf = SpectFrame.this.initFrame(n, n2);
                SpectFrame.this.jf.pack();
            }
        });
    }

    public void requestFocus() {
        this.runInEDT(new Runnable(){

            @Override
            public void run() {
                if (SpectFrame.this.jf != null) {
                    SpectFrame.this.jf.requestFocus();
                }
            }
        });
    }

    public void setLocation(final double d, final double d2) {
        this.runInEDT(new Runnable(){

            @Override
            public void run() {
                if (SpectFrame.this.jf != null) {
                    SpectFrame.this.jf.setLocation((int)d, (int)d2);
                }
            }
        });
    }

    public void show() {
        this.runInEDT(new Runnable(){

            @Override
            public void run() {
                if (SpectFrame.this.jf != null) {
                    SpectFrame.this.jf.setVisible(true);
                }
            }
        });
    }

    public void setColormap(double[] dArray, double d, double d2) {
        if (this.colormap == null) {
            this.colormap = new byte[this.cmapLen * 3];
        }
        int n = 0;
        float f = (float)d / (float)this.cmapLen;
        for (int i = 0; i < this.cmapLen; ++i) {
            int n2 = 0;
            while ((double)n2 < d2) {
                double d3 = 255.0 * dArray[(int)(Math.floor((float)i * f) + d * (double)n2)];
                d3 = Math.min(d3, 255.0);
                d3 = Math.max(d3, 0.0);
                this.colormap[n++] = (byte)d3;
                ++n2;
            }
        }
        this.cm = new IndexColorModel(8, this.cmapLen, this.colormap, 0, false);
    }

    public void setColormap(double[][] dArray) {
        if (this.colormap == null) {
            this.colormap = new byte[this.cmapLen * 3];
        }
        int n = 0;
        int n2 = dArray.length;
        float f = (float)n2 / (float)this.cmapLen;
        for (int i = 0; i < this.cmapLen; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                double d = 255.0 * dArray[(int)Math.floor((float)i * f)][j];
                d = Math.min(d, 255.0);
                d = Math.max(d, 0.0);
                this.colormap[n++] = (byte)d;
            }
        }
        this.cm = new IndexColorModel(8, this.cmapLen, this.colormap, 0, false);
    }

    public void close() {
        if (this.jf != null) {
            this.jf.setVisible(false);
            this.jf.dispose();
        }
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    private JFrame initFrame(int n, int n2) {
        this.height = n2;
        this.width = n;
        JFrame jFrame = new JFrame("LTFAT Plot Panel");
        jFrame.setLayout(new BorderLayout());
        this.spectPanel = new SpectPanel(n, n2);
        jFrame.add(this.spectPanel);
        this.spectPanel.addWheelListener();
        JPopupMenu jPopupMenu = new JPopupMenu(this.popupName);
        JSlider jSlider = new JSlider(0, 1, 10, this.defSpeed);
        jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                SpectFrame.this.spectStep = jSlider.getValue() * 800 / 800;
            }
        });
        JRangeSlider jRangeSlider = new JRangeSlider((int)this.climMin, (int)this.climMax, (int)this.climMin, (int)this.climMax, 1);
        jRangeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JRangeSlider jRangeSlider = (JRangeSlider)changeEvent.getSource();
                SpectFrame.this.climMin = jRangeSlider.getLowValue();
                SpectFrame.this.climMax = jRangeSlider.getHighValue();
            }
        });
        JLabel jLabel = new JLabel("Speed:");
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(jSlider);
        jSlider.setPreferredSize(new Dimension(100, jSlider.getPreferredSize().height));
        jPopupMenu.add(jPanel);
        JLabel jLabel2 = new JLabel("Limits:");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jLabel2);
        jPanel2.add(jRangeSlider);
        jRangeSlider.setPreferredSize(new Dimension(100, jRangeSlider.getPreferredSize().height));
        jPopupMenu.add(jPanel2);
        this.spectPanel.addPopupMenu(jPopupMenu);
        return jFrame;
    }

    public int getHeight() {
        return this.height;
    }

    public void append(final double[] dArray, final double d, final double d2) {
        this.runInPool(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (SpectFrame.this.spectPanel == null) {
                    return;
                }
                Utils.pow(dArray);
                Utils.db(dArray);
                Float f = new Float(SpectFrame.this.climMin);
                Float f2 = new Float(SpectFrame.this.climMax);
                Utils.clipToRange(dArray, f.floatValue(), f2.floatValue());
                byte[] byArray = new byte[dArray.length];
                Utils.toByte(dArray, byArray, f.floatValue(), f2.floatValue());
                DataBufferByte dataBufferByte = new DataBufferByte(byArray, dArray.length, 0);
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, (int)d2, (int)d, 8);
                WritableRaster writableRaster = Raster.createWritableRaster(multiPixelPackedSampleModel, dataBufferByte, null);
                BufferedImage bufferedImage = new BufferedImage(SpectFrame.this.cm, writableRaster, false, null);
                Graphics2D graphics2D = SpectFrame.this.spectPanel.getGraphics2D();
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                Object object = SpectFrame.this.graphicsLock;
                synchronized (object) {
                    int n = SpectFrame.this.srunPos;
                    SpectFrame.this.srunPos = SpectFrame.this.srunPos + SpectFrame.this.spectStep;
                    if (SpectFrame.this.srunPos > SpectFrame.this.width) {
                        graphics2D.drawImage(bufferedImage, n, 4 * SpectFrame.this.height, SpectFrame.this.width, 0, 0, 0, (int)d2, (int)d, null);
                        SpectFrame.this.srunPos = SpectFrame.this.srunPos - SpectFrame.this.width;
                        n = 0;
                    }
                    graphics2D.drawImage(bufferedImage, n, 4 * SpectFrame.this.height, SpectFrame.this.srunPos, 0, 0, 0, (int)d2, (int)d, null);
                }
                SpectFrame.this.spectPanel.repaint();
            }
        });
    }

    public void append(final float[][] fArray) {
        final int n = fArray[0].length;
        final int n2 = fArray.length;
        this.runInPool(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Utils.pow(fArray);
                Utils.db(fArray);
                Float f = new Float(SpectFrame.this.climMin);
                Float f2 = new Float(SpectFrame.this.climMax);
                Utils.clipToRange(fArray, f.floatValue(), f2.floatValue());
                byte[] byArray = new byte[n * n2];
                Utils.toByte(fArray, byArray, f.floatValue(), f2.floatValue());
                DataBufferByte dataBufferByte = new DataBufferByte(byArray, n * n2, 0);
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, n, n2, 8);
                WritableRaster writableRaster = Raster.createWritableRaster(multiPixelPackedSampleModel, dataBufferByte, null);
                BufferedImage bufferedImage = new BufferedImage(SpectFrame.this.cm, writableRaster, false, null);
                Graphics2D graphics2D = SpectFrame.this.spectPanel.getGraphics2D();
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                Object object = SpectFrame.this.graphicsLock;
                synchronized (object) {
                    int n3 = SpectFrame.this.srunPos;
                    SpectFrame.this.srunPos = SpectFrame.this.srunPos + SpectFrame.this.spectStep;
                    if (SpectFrame.this.srunPos > SpectFrame.this.width) {
                        graphics2D.drawImage(bufferedImage, n3, 4 * SpectFrame.this.height, SpectFrame.this.width, 0, 0, 0, n, n2, null);
                        SpectFrame.this.srunPos = SpectFrame.this.srunPos - SpectFrame.this.width;
                        n3 = 0;
                    }
                    graphics2D.drawImage(bufferedImage, n3, 4 * SpectFrame.this.height, SpectFrame.this.srunPos, 0, 0, 0, n, n2, null);
                }
                SpectFrame.this.spectPanel.repaint();
            }
        });
    }

    public void append(double[][] dArray) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runInEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                runnable.run();
                return;
            }
            catch (Exception exception) {}
            finally {
                return;
            }
        }
        try {
            SwingUtilities.invokeLater(runnable);
            return;
        }
        catch (Exception exception) {
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void runInPool(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            System.out.println("Warning! We are on on EDT. Strange....");
        }
        try {
            this.executor.execute(runnable);
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class SpectPanel
    extends JPanel {
        private BufferedImage spectbf = null;
        private float zoom = 1.0f;

        public void addWheelListener() {
            this.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                    if (mouseWheelEvent.getWheelRotation() > 0) {
                        SpectPanel.this.zoom = (float)((double)SpectPanel.this.zoom + 0.05);
                        SpectPanel.this.zoom = Math.min(SpectPanel.this.zoom, 1.0f);
                    } else {
                        SpectPanel.this.zoom = (float)((double)SpectPanel.this.zoom - 0.05);
                        SpectPanel.this.zoom = Math.max(SpectPanel.this.zoom, 0.05f);
                    }
                }
            });
        }

        public void addPopupMenu(JPopupMenu jPopupMenu) {
            this.setComponentPopupMenu(jPopupMenu);
        }

        public SpectPanel(int n, int n2) {
            Dimension dimension = new Dimension(n, n2);
            this.setSize(dimension);
            this.setPreferredSize(dimension);
            this.spectbf = new BufferedImage(n, 4 * n2, 6);
            Graphics2D graphics2D = (Graphics2D)this.spectbf.getGraphics();
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.fillRect(0, 0, n, 4 * n2);
        }

        public void setImage(BufferedImage bufferedImage) {
            this.spectbf = bufferedImage;
        }

        protected void setZoom(float f) {
            this.zoom = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics graphics) {
            Dimension dimension = this.getSize();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            if (this.spectbf != null) {
                Object object = SpectFrame.this.graphicsLock;
                synchronized (object) {
                    int n = (int)((float)(dimension.width * SpectFrame.this.srunPos) / (float)this.spectbf.getWidth());
                    int n2 = (int)((1.0f - this.zoom) * (float)this.spectbf.getHeight());
                    graphics2D.drawImage(this.spectbf, dimension.width - n, 0, dimension.width, dimension.height, 0, n2, SpectFrame.this.srunPos, this.spectbf.getHeight(), null);
                    graphics2D.drawImage(this.spectbf, 0, 0, dimension.width - n, dimension.height, SpectFrame.this.srunPos, n2, this.spectbf.getWidth(), this.spectbf.getHeight(), null);
                }
            }
        }

        public Graphics2D getGraphics2D() {
            return (Graphics2D)this.spectbf.getGraphics();
        }
    }
}

