## DO NOT EDIT!  Generated automatically from test/libieeep1788_tests_bool.itl
## by the Interval Testing Framework for IEEE 1788.
## https://github.com/nehmeier/ITF1788/tree/29b1d1b6c3a640d4057fe86548d5e7d7c7265904
##
## Copyright 2013 - 2015 Marco Nehmeier (nehmeier@informatik.uni-wuerzburg.de)
## Copyright 2015 Oliver Heimlich
## 
## Original author: Marco Nehmeier (unit tests in libieeep1788,
##                  original license: Apache License 2.0)
## Converted into portable ITL format by Oliver Heimlich with minor corrections.
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
## 
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
## 
## You should have received a copy of the GNU General Public License
## along with this program; if not, see <http://www.gnu.org/licenses/>.
##
%!#Test library imports
%!function s = to_string (x)
%!    if (isnumeric (x))
%!        s = num2str (x);
%!    elseif (isa (x, 'infsup'))
%!        s = intervaltotext (x);
%!    elseif (isa (x, 'intval'))
%!        s = disp_ (x);
%!    else
%!        # x probably is a char.
%!        s = x;
%!    endif
%!endfunction
%!
%!function assert_warn (expected, actual)
%!    if (not (all (eq (expected, actual))))
%!        warning (["expected: ", to_string(expected), " actual value: ", to_string(actual)]);
%!    endif
%!endfunction

%!#Arithmetic library imports
%!function n = decval (dec)
%!    n = find (strcmp (dec, {"ill", "trv", "def", "dac", "com"}));
%!endfunction

%!#Preamble

## minimal_empty_test

%!test
%! assert (all (eq (isempty (infsup), true)));
%!test
%! assert (all (eq (isempty (infsup (-inf, inf)), false)));
%!test
%! assert (all (eq (isempty (infsup (1.0, 2.0)), false)));
%!test
%! assert (all (eq (isempty (infsup (-1.0, 2.0)), false)));
%!test
%! assert (all (eq (isempty (infsup (-3.0, -2.0)), false)));
%!test
%! assert (all (eq (isempty (infsup (-inf, 2.0)), false)));
%!test
%! assert (all (eq (isempty (infsup (-inf, 0.0)), false)));
%!test
%! assert (all (eq (isempty (infsup (-inf, -0.0)), false)));
%!test
%! assert (all (eq (isempty (infsup (0.0, inf)), false)));
%!test
%! assert (all (eq (isempty (infsup (-0.0, inf)), false)));
%!test
%! assert (all (eq (isempty (infsup (-0.0, 0.0)), false)));
%!test
%! assert (all (eq (isempty (infsup (0.0, -0.0)), false)));
%!test
%! assert (all (eq (isempty (infsup (0.0, 0.0)), false)));
%!test
%! assert (all (eq (isempty (infsup (-0.0, -0.0)), false)));

## minimal_empty_dec_test

%!test
%! assert (all (eq (isempty (infsupdec (empty, "trv")), true)));
%!test
%! assert (all (eq (isempty (infsupdec (-inf, inf, "def")), false)));
%!test
%! assert (all (eq (isempty (infsupdec (1.0, 2.0, "com")), false)));
%!test
%! assert (all (eq (isempty (infsupdec (-1.0, 2.0, "trv")), false)));
%!test
%! assert (all (eq (isempty (infsupdec (-3.0, -2.0, "dac")), false)));
%!test
%! assert (all (eq (isempty (infsupdec (-inf, 2.0, "trv")), false)));
%!test
%! assert (all (eq (isempty (infsupdec (-inf, 0.0, "trv")), false)));
%!test
%! assert (all (eq (isempty (infsupdec (-inf, -0.0, "trv")), false)));
%!test
%! assert (all (eq (isempty (infsupdec (0.0, inf, "def")), false)));
%!test
%! assert (all (eq (isempty (infsupdec (-0.0, inf, "trv")), false)));
%!test
%! assert (all (eq (isempty (infsupdec (-0.0, 0.0, "com")), false)));
%!test
%! assert (all (eq (isempty (infsupdec (0.0, -0.0, "trv")), false)));
%!test
%! assert (all (eq (isempty (infsupdec (0.0, 0.0, "trv")), false)));
%!test
%! assert (all (eq (isempty (infsupdec (-0.0, -0.0, "trv")), false)));

## minimal_entire_test

%!test
%! assert (all (eq (isentire (infsup), false)));
%!test
%! assert (all (eq (isentire (infsup (-inf, inf)), true)));
%!test
%! assert (all (eq (isentire (infsup (1.0, 2.0)), false)));
%!test
%! assert (all (eq (isentire (infsup (-1.0, 2.0)), false)));
%!test
%! assert (all (eq (isentire (infsup (-3.0, -2.0)), false)));
%!test
%! assert (all (eq (isentire (infsup (-inf, 2.0)), false)));
%!test
%! assert (all (eq (isentire (infsup (-inf, 0.0)), false)));
%!test
%! assert (all (eq (isentire (infsup (-inf, -0.0)), false)));
%!test
%! assert (all (eq (isentire (infsup (0.0, inf)), false)));
%!test
%! assert (all (eq (isentire (infsup (-0.0, inf)), false)));
%!test
%! assert (all (eq (isentire (infsup (-0.0, 0.0)), false)));
%!test
%! assert (all (eq (isentire (infsup (0.0, -0.0)), false)));
%!test
%! assert (all (eq (isentire (infsup (0.0, 0.0)), false)));
%!test
%! assert (all (eq (isentire (infsup (-0.0, -0.0)), false)));

## minimal_entire_dec_test

%!test
%! assert (all (eq (isentire (infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (isentire (infsupdec (-inf, inf, "trv")), true)));
%!test
%! assert (all (eq (isentire (infsupdec (-inf, inf, "def")), true)));
%!test
%! assert (all (eq (isentire (infsupdec (-inf, inf, "dac")), true)));
%!test
%! assert (all (eq (isentire (infsupdec (1.0, 2.0, "com")), false)));
%!test
%! assert (all (eq (isentire (infsupdec (-1.0, 2.0, "trv")), false)));
%!test
%! assert (all (eq (isentire (infsupdec (-3.0, -2.0, "dac")), false)));
%!test
%! assert (all (eq (isentire (infsupdec (-inf, 2.0, "trv")), false)));
%!test
%! assert (all (eq (isentire (infsupdec (-inf, 0.0, "trv")), false)));
%!test
%! assert (all (eq (isentire (infsupdec (-inf, -0.0, "trv")), false)));
%!test
%! assert (all (eq (isentire (infsupdec (0.0, inf, "def")), false)));
%!test
%! assert (all (eq (isentire (infsupdec (-0.0, inf, "trv")), false)));
%!test
%! assert (all (eq (isentire (infsupdec (-0.0, 0.0, "com")), false)));
%!test
%! assert (all (eq (isentire (infsupdec (0.0, -0.0, "trv")), false)));
%!test
%! assert (all (eq (isentire (infsupdec (0.0, 0.0, "trv")), false)));
%!test
%! assert (all (eq (isentire (infsupdec (-0.0, -0.0, "trv")), false)));

## minimal_nai_dec_test

%!test
%! assert (all (eq (isnai (infsupdec (-inf, inf, "trv")), false)));
%!test
%! assert (all (eq (isnai (infsupdec (-inf, inf, "def")), false)));
%!test
%! assert (all (eq (isnai (infsupdec (-inf, inf, "dac")), false)));
%!test
%! assert (all (eq (isnai (infsupdec (1.0, 2.0, "com")), false)));
%!test
%! assert (all (eq (isnai (infsupdec (-1.0, 2.0, "trv")), false)));
%!test
%! assert (all (eq (isnai (infsupdec (-3.0, -2.0, "dac")), false)));
%!test
%! assert (all (eq (isnai (infsupdec (-inf, 2.0, "trv")), false)));
%!test
%! assert (all (eq (isnai (infsupdec (-inf, 0.0, "trv")), false)));
%!test
%! assert (all (eq (isnai (infsupdec (-inf, -0.0, "trv")), false)));
%!test
%! assert (all (eq (isnai (infsupdec (0.0, inf, "def")), false)));
%!test
%! assert (all (eq (isnai (infsupdec (-0.0, inf, "trv")), false)));
%!test
%! assert (all (eq (isnai (infsupdec (-0.0, 0.0, "com")), false)));
%!test
%! assert (all (eq (isnai (infsupdec (0.0, -0.0, "trv")), false)));
%!test
%! assert (all (eq (isnai (infsupdec (0.0, 0.0, "trv")), false)));
%!test
%! assert (all (eq (isnai (infsupdec (-0.0, -0.0, "trv")), false)));

## minimal_equal_test

%!test
%! assert (all (eq (eq (infsup (1.0, 2.0), infsup (1.0, 2.0)), true)));
%! assert (all (eq (infsup (1.0, 2.0) == infsup (1.0, 2.0), true)));
%!test
%! assert (all (eq (eq (infsup (1.0, 2.1), infsup (1.0, 2.0)), false)));
%! assert (all (eq (infsup (1.0, 2.1) == infsup (1.0, 2.0), false)));
%!test
%! assert (all (eq (eq (infsup, infsup), true)));
%! assert (all (eq (infsup == infsup, true)));
%!test
%! assert (all (eq (eq (infsup, infsup (1.0, 2.0)), false)));
%! assert (all (eq (infsup == infsup (1.0, 2.0), false)));
%!test
%! assert (all (eq (eq (infsup (-inf, inf), infsup (-inf, inf)), true)));
%! assert (all (eq (infsup (-inf, inf) == infsup (-inf, inf), true)));
%!test
%! assert (all (eq (eq (infsup (1.0, 2.4), infsup (-inf, inf)), false)));
%! assert (all (eq (infsup (1.0, 2.4) == infsup (-inf, inf), false)));
%!test
%! assert (all (eq (eq (infsup (1.0, inf), infsup (1.0, inf)), true)));
%! assert (all (eq (infsup (1.0, inf) == infsup (1.0, inf), true)));
%!test
%! assert (all (eq (eq (infsup (1.0, 2.4), infsup (1.0, inf)), false)));
%! assert (all (eq (infsup (1.0, 2.4) == infsup (1.0, inf), false)));
%!test
%! assert (all (eq (eq (infsup (-inf, 2.0), infsup (-inf, 2.0)), true)));
%! assert (all (eq (infsup (-inf, 2.0) == infsup (-inf, 2.0), true)));
%!test
%! assert (all (eq (eq (infsup (-inf, 2.4), infsup (-inf, 2.0)), false)));
%! assert (all (eq (infsup (-inf, 2.4) == infsup (-inf, 2.0), false)));
%!test
%! assert (all (eq (eq (infsup (-2.0, 0.0), infsup (-2.0, 0.0)), true)));
%! assert (all (eq (infsup (-2.0, 0.0) == infsup (-2.0, 0.0), true)));
%!test
%! assert (all (eq (eq (infsup (-0.0, 2.0), infsup (0.0, 2.0)), true)));
%! assert (all (eq (infsup (-0.0, 2.0) == infsup (0.0, 2.0), true)));
%!test
%! assert (all (eq (eq (infsup (-0.0, -0.0), infsup (0.0, 0.0)), true)));
%! assert (all (eq (infsup (-0.0, -0.0) == infsup (0.0, 0.0), true)));
%!test
%! assert (all (eq (eq (infsup (-0.0, 0.0), infsup (0.0, 0.0)), true)));
%! assert (all (eq (infsup (-0.0, 0.0) == infsup (0.0, 0.0), true)));
%!test
%! assert (all (eq (eq (infsup (0.0, -0.0), infsup (0.0, 0.0)), true)));
%! assert (all (eq (infsup (0.0, -0.0) == infsup (0.0, 0.0), true)));

## minimal_equal_dec_test

%!test
%! assert (all (eq (eq (infsupdec (1.0, 2.0, "def"), infsupdec (1.0, 2.0, "trv")), true)));
%! assert (all (eq (infsupdec (1.0, 2.0, "def") == infsupdec (1.0, 2.0, "trv"), true)));
%!test
%! assert (all (eq (eq (infsupdec (1.0, 2.1, "trv"), infsupdec (1.0, 2.0, "trv")), false)));
%! assert (all (eq (infsupdec (1.0, 2.1, "trv") == infsupdec (1.0, 2.0, "trv"), false)));
%!test
%! assert (all (eq (eq (infsupdec (empty, "trv"), infsupdec (empty, "trv")), true)));
%! assert (all (eq (infsupdec (empty, "trv") == infsupdec (empty, "trv"), true)));
%!test
%! assert (all (eq (eq (infsupdec (empty, "trv"), infsupdec (1.0, 2.0, "trv")), false)));
%! assert (all (eq (infsupdec (empty, "trv") == infsupdec (1.0, 2.0, "trv"), false)));
%!test
%! assert (all (eq (eq (infsupdec (empty, "trv"), infsupdec (1.0, 2.0, "trv")), false)));
%! assert (all (eq (infsupdec (empty, "trv") == infsupdec (1.0, 2.0, "trv"), false)));
%!test
%! assert (all (eq (eq (infsupdec (-inf, inf, "def"), infsupdec (-inf, inf, "trv")), true)));
%! assert (all (eq (infsupdec (-inf, inf, "def") == infsupdec (-inf, inf, "trv"), true)));
%!test
%! assert (all (eq (eq (infsupdec (1.0, 2.4, "trv"), infsupdec (-inf, inf, "trv")), false)));
%! assert (all (eq (infsupdec (1.0, 2.4, "trv") == infsupdec (-inf, inf, "trv"), false)));
%!test
%! assert (all (eq (eq (infsupdec (1.0, inf, "trv"), infsupdec (1.0, inf, "trv")), true)));
%! assert (all (eq (infsupdec (1.0, inf, "trv") == infsupdec (1.0, inf, "trv"), true)));
%!test
%! assert (all (eq (eq (infsupdec (1.0, 2.4, "def"), infsupdec (1.0, inf, "trv")), false)));
%! assert (all (eq (infsupdec (1.0, 2.4, "def") == infsupdec (1.0, inf, "trv"), false)));
%!test
%! assert (all (eq (eq (infsupdec (-inf, 2.0, "trv"), infsupdec (-inf, 2.0, "trv")), true)));
%! assert (all (eq (infsupdec (-inf, 2.0, "trv") == infsupdec (-inf, 2.0, "trv"), true)));
%!test
%! assert (all (eq (eq (infsupdec (-inf, 2.4, "def"), infsupdec (-inf, 2.0, "trv")), false)));
%! assert (all (eq (infsupdec (-inf, 2.4, "def") == infsupdec (-inf, 2.0, "trv"), false)));
%!test
%! assert (all (eq (eq (infsupdec (-2.0, 0.0, "trv"), infsupdec (-2.0, 0.0, "trv")), true)));
%! assert (all (eq (infsupdec (-2.0, 0.0, "trv") == infsupdec (-2.0, 0.0, "trv"), true)));
%!test
%! assert (all (eq (eq (infsupdec (-0.0, 2.0, "def"), infsupdec (0.0, 2.0, "trv")), true)));
%! assert (all (eq (infsupdec (-0.0, 2.0, "def") == infsupdec (0.0, 2.0, "trv"), true)));
%!test
%! assert (all (eq (eq (infsupdec (-0.0, -0.0, "trv"), infsupdec (0.0, 0.0, "trv")), true)));
%! assert (all (eq (infsupdec (-0.0, -0.0, "trv") == infsupdec (0.0, 0.0, "trv"), true)));
%!test
%! assert (all (eq (eq (infsupdec (-0.0, 0.0, "def"), infsupdec (0.0, 0.0, "trv")), true)));
%! assert (all (eq (infsupdec (-0.0, 0.0, "def") == infsupdec (0.0, 0.0, "trv"), true)));
%!test
%! assert (all (eq (eq (infsupdec (0.0, -0.0, "trv"), infsupdec (0.0, 0.0, "trv")), true)));
%! assert (all (eq (infsupdec (0.0, -0.0, "trv") == infsupdec (0.0, 0.0, "trv"), true)));

## minimal_subset_test

%!test
%! assert (all (eq (subset (infsup, infsup), true)));
%!test
%! assert (all (eq (subset (infsup, infsup (0.0, 4.0)), true)));
%!test
%! assert (all (eq (subset (infsup, infsup (-0.0, 4.0)), true)));
%!test
%! assert (all (eq (subset (infsup, infsup (-0.1, 1.0)), true)));
%!test
%! assert (all (eq (subset (infsup, infsup (-0.1, 0.0)), true)));
%!test
%! assert (all (eq (subset (infsup, infsup (-0.1, -0.0)), true)));
%!test
%! assert (all (eq (subset (infsup, infsup (-inf, inf)), true)));
%!test
%! assert (all (eq (subset (infsup (0.0, 4.0), infsup), false)));
%!test
%! assert (all (eq (subset (infsup (-0.0, 4.0), infsup), false)));
%!test
%! assert (all (eq (subset (infsup (-0.1, 1.0), infsup), false)));
%!test
%! assert (all (eq (subset (infsup (-inf, inf), infsup), false)));
%!test
%! assert (all (eq (subset (infsup (0.0, 4.0), infsup (-inf, inf)), true)));
%!test
%! assert (all (eq (subset (infsup (-0.0, 4.0), infsup (-inf, inf)), true)));
%!test
%! assert (all (eq (subset (infsup (-0.1, 1.0), infsup (-inf, inf)), true)));
%!test
%! assert (all (eq (subset (infsup (-inf, inf), infsup (-inf, inf)), true)));
%!test
%! assert (all (eq (subset (infsup (1.0, 2.0), infsup (1.0, 2.0)), true)));
%!test
%! assert (all (eq (subset (infsup (1.0, 2.0), infsup (0.0, 4.0)), true)));
%!test
%! assert (all (eq (subset (infsup (1.0, 2.0), infsup (-0.0, 4.0)), true)));
%!test
%! assert (all (eq (subset (infsup (0.1, 0.2), infsup (0.0, 4.0)), true)));
%!test
%! assert (all (eq (subset (infsup (0.1, 0.2), infsup (-0.0, 4.0)), true)));
%!test
%! assert (all (eq (subset (infsup (-0.1, -0.1), infsup (-4.0, 3.4)), true)));
%!test
%! assert (all (eq (subset (infsup (0.0, 0.0), infsup (-0.0, -0.0)), true)));
%!test
%! assert (all (eq (subset (infsup (-0.0, -0.0), infsup (0.0, 0.0)), true)));
%!test
%! assert (all (eq (subset (infsup (-0.0, 0.0), infsup (0.0, 0.0)), true)));
%!test
%! assert (all (eq (subset (infsup (-0.0, 0.0), infsup (0.0, -0.0)), true)));
%!test
%! assert (all (eq (subset (infsup (0.0, -0.0), infsup (0.0, 0.0)), true)));
%!test
%! assert (all (eq (subset (infsup (0.0, -0.0), infsup (-0.0, 0.0)), true)));

## minimal_subset_dec_test

%!test
%! assert (all (eq (subset (infsupdec (empty, "trv"), infsupdec (0.0, 4.0, "trv")), true)));
%!test
%! assert (all (eq (subset (infsupdec (empty, "trv"), infsupdec (-0.0, 4.0, "def")), true)));
%!test
%! assert (all (eq (subset (infsupdec (empty, "trv"), infsupdec (-0.1, 1.0, "trv")), true)));
%!test
%! assert (all (eq (subset (infsupdec (empty, "trv"), infsupdec (-0.1, 0.0, "trv")), true)));
%!test
%! assert (all (eq (subset (infsupdec (empty, "trv"), infsupdec (-0.1, -0.0, "trv")), true)));
%!test
%! assert (all (eq (subset (infsupdec (empty, "trv"), infsupdec (-inf, inf, "trv")), true)));
%!test
%! assert (all (eq (subset (infsupdec (0.0, 4.0, "trv"), infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (subset (infsupdec (-0.0, 4.0, "def"), infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (subset (infsupdec (-0.1, 1.0, "trv"), infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (subset (infsupdec (-inf, inf, "trv"), infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (subset (infsupdec (0.0, 4.0, "trv"), infsupdec (-inf, inf, "trv")), true)));
%!test
%! assert (all (eq (subset (infsupdec (-0.0, 4.0, "trv"), infsupdec (-inf, inf, "trv")), true)));
%!test
%! assert (all (eq (subset (infsupdec (-0.1, 1.0, "trv"), infsupdec (-inf, inf, "trv")), true)));
%!test
%! assert (all (eq (subset (infsupdec (-inf, inf, "trv"), infsupdec (-inf, inf, "trv")), true)));
%!test
%! assert (all (eq (subset (infsupdec (1.0, 2.0, "trv"), infsupdec (1.0, 2.0, "trv")), true)));
%!test
%! assert (all (eq (subset (infsupdec (1.0, 2.0, "trv"), infsupdec (0.0, 4.0, "trv")), true)));
%!test
%! assert (all (eq (subset (infsupdec (1.0, 2.0, "def"), infsupdec (-0.0, 4.0, "def")), true)));
%!test
%! assert (all (eq (subset (infsupdec (0.1, 0.2, "trv"), infsupdec (0.0, 4.0, "trv")), true)));
%!test
%! assert (all (eq (subset (infsupdec (0.1, 0.2, "trv"), infsupdec (-0.0, 4.0, "def")), true)));
%!test
%! assert (all (eq (subset (infsupdec (-0.1, -0.1, "trv"), infsupdec (-4.0, 3.4, "trv")), true)));
%!test
%! assert (all (eq (subset (infsupdec (0.0, 0.0, "trv"), infsupdec (-0.0, -0.0, "trv")), true)));
%!test
%! assert (all (eq (subset (infsupdec (-0.0, -0.0, "trv"), infsupdec (0.0, 0.0, "def")), true)));
%!test
%! assert (all (eq (subset (infsupdec (-0.0, 0.0, "trv"), infsupdec (0.0, 0.0, "trv")), true)));
%!test
%! assert (all (eq (subset (infsupdec (-0.0, 0.0, "trv"), infsupdec (0.0, -0.0, "trv")), true)));
%!test
%! assert (all (eq (subset (infsupdec (0.0, -0.0, "def"), infsupdec (0.0, 0.0, "trv")), true)));
%!test
%! assert (all (eq (subset (infsupdec (0.0, -0.0, "trv"), infsupdec (-0.0, 0.0, "trv")), true)));

## minimal_less_test

%!test
%! assert (all (eq (le (infsup, infsup), true)));
%! assert (all (eq (infsup <= infsup, true)));
%!test
%! assert (all (eq (le (infsup (1.0, 2.0), infsup), false)));
%! assert (all (eq (infsup (1.0, 2.0) <= infsup, false)));
%!test
%! assert (all (eq (le (infsup, infsup (1.0, 2.0)), false)));
%! assert (all (eq (infsup <= infsup (1.0, 2.0), false)));
%!test
%! assert (all (eq (le (infsup (-inf, inf), infsup (-inf, inf)), true)));
%! assert (all (eq (infsup (-inf, inf) <= infsup (-inf, inf), true)));
%!test
%! assert (all (eq (le (infsup (1.0, 2.0), infsup (-inf, inf)), false)));
%! assert (all (eq (infsup (1.0, 2.0) <= infsup (-inf, inf), false)));
%!test
%! assert (all (eq (le (infsup (0.0, 2.0), infsup (-inf, inf)), false)));
%! assert (all (eq (infsup (0.0, 2.0) <= infsup (-inf, inf), false)));
%!test
%! assert (all (eq (le (infsup (-0.0, 2.0), infsup (-inf, inf)), false)));
%! assert (all (eq (infsup (-0.0, 2.0) <= infsup (-inf, inf), false)));
%!test
%! assert (all (eq (le (infsup (-inf, inf), infsup (1.0, 2.0)), false)));
%! assert (all (eq (infsup (-inf, inf) <= infsup (1.0, 2.0), false)));
%!test
%! assert (all (eq (le (infsup (-inf, inf), infsup (0.0, 2.0)), false)));
%! assert (all (eq (infsup (-inf, inf) <= infsup (0.0, 2.0), false)));
%!test
%! assert (all (eq (le (infsup (-inf, inf), infsup (-0.0, 2.0)), false)));
%! assert (all (eq (infsup (-inf, inf) <= infsup (-0.0, 2.0), false)));
%!test
%! assert (all (eq (le (infsup (0.0, 2.0), infsup (0.0, 2.0)), true)));
%! assert (all (eq (infsup (0.0, 2.0) <= infsup (0.0, 2.0), true)));
%!test
%! assert (all (eq (le (infsup (0.0, 2.0), infsup (-0.0, 2.0)), true)));
%! assert (all (eq (infsup (0.0, 2.0) <= infsup (-0.0, 2.0), true)));
%!test
%! assert (all (eq (le (infsup (0.0, 2.0), infsup (1.0, 2.0)), true)));
%! assert (all (eq (infsup (0.0, 2.0) <= infsup (1.0, 2.0), true)));
%!test
%! assert (all (eq (le (infsup (-0.0, 2.0), infsup (1.0, 2.0)), true)));
%! assert (all (eq (infsup (-0.0, 2.0) <= infsup (1.0, 2.0), true)));
%!test
%! assert (all (eq (le (infsup (1.0, 2.0), infsup (1.0, 2.0)), true)));
%! assert (all (eq (infsup (1.0, 2.0) <= infsup (1.0, 2.0), true)));
%!test
%! assert (all (eq (le (infsup (1.0, 2.0), infsup (3.0, 4.0)), true)));
%! assert (all (eq (infsup (1.0, 2.0) <= infsup (3.0, 4.0), true)));
%!test
%! assert (all (eq (le (infsup (1.0, 3.5), infsup (3.0, 4.0)), true)));
%! assert (all (eq (infsup (1.0, 3.5) <= infsup (3.0, 4.0), true)));
%!test
%! assert (all (eq (le (infsup (1.0, 4.0), infsup (3.0, 4.0)), true)));
%! assert (all (eq (infsup (1.0, 4.0) <= infsup (3.0, 4.0), true)));
%!test
%! assert (all (eq (le (infsup (-2.0, -1.0), infsup (-2.0, -1.0)), true)));
%! assert (all (eq (infsup (-2.0, -1.0) <= infsup (-2.0, -1.0), true)));
%!test
%! assert (all (eq (le (infsup (-3.0, -1.5), infsup (-2.0, -1.0)), true)));
%! assert (all (eq (infsup (-3.0, -1.5) <= infsup (-2.0, -1.0), true)));
%!test
%! assert (all (eq (le (infsup (0.0, 0.0), infsup (-0.0, -0.0)), true)));
%! assert (all (eq (infsup (0.0, 0.0) <= infsup (-0.0, -0.0), true)));
%!test
%! assert (all (eq (le (infsup (-0.0, -0.0), infsup (0.0, 0.0)), true)));
%! assert (all (eq (infsup (-0.0, -0.0) <= infsup (0.0, 0.0), true)));
%!test
%! assert (all (eq (le (infsup (-0.0, 0.0), infsup (0.0, 0.0)), true)));
%! assert (all (eq (infsup (-0.0, 0.0) <= infsup (0.0, 0.0), true)));
%!test
%! assert (all (eq (le (infsup (-0.0, 0.0), infsup (0.0, -0.0)), true)));
%! assert (all (eq (infsup (-0.0, 0.0) <= infsup (0.0, -0.0), true)));
%!test
%! assert (all (eq (le (infsup (0.0, -0.0), infsup (0.0, 0.0)), true)));
%! assert (all (eq (infsup (0.0, -0.0) <= infsup (0.0, 0.0), true)));
%!test
%! assert (all (eq (le (infsup (0.0, -0.0), infsup (-0.0, 0.0)), true)));
%! assert (all (eq (infsup (0.0, -0.0) <= infsup (-0.0, 0.0), true)));

## minimal_less_dec_test

%!test
%! assert (all (eq (le (infsupdec (1.0, 2.0, "trv"), infsupdec (empty, "trv")), false)));
%! assert (all (eq (infsupdec (1.0, 2.0, "trv") <= infsupdec (empty, "trv"), false)));
%!test
%! assert (all (eq (le (infsupdec (empty, "trv"), infsupdec (1.0, 2.0, "def")), false)));
%! assert (all (eq (infsupdec (empty, "trv") <= infsupdec (1.0, 2.0, "def"), false)));
%!test
%! assert (all (eq (le (infsupdec (1.0, 2.0, "trv"), infsupdec (empty, "trv")), false)));
%! assert (all (eq (infsupdec (1.0, 2.0, "trv") <= infsupdec (empty, "trv"), false)));
%!test
%! assert (all (eq (le (infsupdec (empty, "trv"), infsupdec (1.0, 2.0, "trv")), false)));
%! assert (all (eq (infsupdec (empty, "trv") <= infsupdec (1.0, 2.0, "trv"), false)));
%!test
%! assert (all (eq (le (infsupdec (-inf, inf, "trv"), infsupdec (-inf, inf, "trv")), true)));
%! assert (all (eq (infsupdec (-inf, inf, "trv") <= infsupdec (-inf, inf, "trv"), true)));
%!test
%! assert (all (eq (le (infsupdec (1.0, 2.0, "def"), infsupdec (-inf, inf, "trv")), false)));
%! assert (all (eq (infsupdec (1.0, 2.0, "def") <= infsupdec (-inf, inf, "trv"), false)));
%!test
%! assert (all (eq (le (infsupdec (0.0, 2.0, "trv"), infsupdec (-inf, inf, "trv")), false)));
%! assert (all (eq (infsupdec (0.0, 2.0, "trv") <= infsupdec (-inf, inf, "trv"), false)));
%!test
%! assert (all (eq (le (infsupdec (-0.0, 2.0, "trv"), infsupdec (-inf, inf, "trv")), false)));
%! assert (all (eq (infsupdec (-0.0, 2.0, "trv") <= infsupdec (-inf, inf, "trv"), false)));
%!test
%! assert (all (eq (le (infsupdec (-inf, inf, "trv"), infsupdec (1.0, 2.0, "trv")), false)));
%! assert (all (eq (infsupdec (-inf, inf, "trv") <= infsupdec (1.0, 2.0, "trv"), false)));
%!test
%! assert (all (eq (le (infsupdec (-inf, inf, "trv"), infsupdec (0.0, 2.0, "def")), false)));
%! assert (all (eq (infsupdec (-inf, inf, "trv") <= infsupdec (0.0, 2.0, "def"), false)));
%!test
%! assert (all (eq (le (infsupdec (-inf, inf, "trv"), infsupdec (-0.0, 2.0, "trv")), false)));
%! assert (all (eq (infsupdec (-inf, inf, "trv") <= infsupdec (-0.0, 2.0, "trv"), false)));
%!test
%! assert (all (eq (le (infsupdec (0.0, 2.0, "trv"), infsupdec (0.0, 2.0, "trv")), true)));
%! assert (all (eq (infsupdec (0.0, 2.0, "trv") <= infsupdec (0.0, 2.0, "trv"), true)));
%!test
%! assert (all (eq (le (infsupdec (0.0, 2.0, "trv"), infsupdec (-0.0, 2.0, "trv")), true)));
%! assert (all (eq (infsupdec (0.0, 2.0, "trv") <= infsupdec (-0.0, 2.0, "trv"), true)));
%!test
%! assert (all (eq (le (infsupdec (0.0, 2.0, "def"), infsupdec (1.0, 2.0, "def")), true)));
%! assert (all (eq (infsupdec (0.0, 2.0, "def") <= infsupdec (1.0, 2.0, "def"), true)));
%!test
%! assert (all (eq (le (infsupdec (-0.0, 2.0, "trv"), infsupdec (1.0, 2.0, "trv")), true)));
%! assert (all (eq (infsupdec (-0.0, 2.0, "trv") <= infsupdec (1.0, 2.0, "trv"), true)));
%!test
%! assert (all (eq (le (infsupdec (1.0, 2.0, "trv"), infsupdec (1.0, 2.0, "trv")), true)));
%! assert (all (eq (infsupdec (1.0, 2.0, "trv") <= infsupdec (1.0, 2.0, "trv"), true)));
%!test
%! assert (all (eq (le (infsupdec (1.0, 2.0, "trv"), infsupdec (3.0, 4.0, "def")), true)));
%! assert (all (eq (infsupdec (1.0, 2.0, "trv") <= infsupdec (3.0, 4.0, "def"), true)));
%!test
%! assert (all (eq (le (infsupdec (1.0, 3.5, "trv"), infsupdec (3.0, 4.0, "trv")), true)));
%! assert (all (eq (infsupdec (1.0, 3.5, "trv") <= infsupdec (3.0, 4.0, "trv"), true)));
%!test
%! assert (all (eq (le (infsupdec (1.0, 4.0, "trv"), infsupdec (3.0, 4.0, "trv")), true)));
%! assert (all (eq (infsupdec (1.0, 4.0, "trv") <= infsupdec (3.0, 4.0, "trv"), true)));
%!test
%! assert (all (eq (le (infsupdec (-2.0, -1.0, "trv"), infsupdec (-2.0, -1.0, "trv")), true)));
%! assert (all (eq (infsupdec (-2.0, -1.0, "trv") <= infsupdec (-2.0, -1.0, "trv"), true)));
%!test
%! assert (all (eq (le (infsupdec (-3.0, -1.5, "trv"), infsupdec (-2.0, -1.0, "trv")), true)));
%! assert (all (eq (infsupdec (-3.0, -1.5, "trv") <= infsupdec (-2.0, -1.0, "trv"), true)));
%!test
%! assert (all (eq (le (infsupdec (0.0, 0.0, "trv"), infsupdec (-0.0, -0.0, "trv")), true)));
%! assert (all (eq (infsupdec (0.0, 0.0, "trv") <= infsupdec (-0.0, -0.0, "trv"), true)));
%!test
%! assert (all (eq (le (infsupdec (-0.0, -0.0, "trv"), infsupdec (0.0, 0.0, "def")), true)));
%! assert (all (eq (infsupdec (-0.0, -0.0, "trv") <= infsupdec (0.0, 0.0, "def"), true)));
%!test
%! assert (all (eq (le (infsupdec (-0.0, 0.0, "trv"), infsupdec (0.0, 0.0, "trv")), true)));
%! assert (all (eq (infsupdec (-0.0, 0.0, "trv") <= infsupdec (0.0, 0.0, "trv"), true)));
%!test
%! assert (all (eq (le (infsupdec (-0.0, 0.0, "trv"), infsupdec (0.0, -0.0, "trv")), true)));
%! assert (all (eq (infsupdec (-0.0, 0.0, "trv") <= infsupdec (0.0, -0.0, "trv"), true)));
%!test
%! assert (all (eq (le (infsupdec (0.0, -0.0, "def"), infsupdec (0.0, 0.0, "trv")), true)));
%! assert (all (eq (infsupdec (0.0, -0.0, "def") <= infsupdec (0.0, 0.0, "trv"), true)));
%!test
%! assert (all (eq (le (infsupdec (0.0, -0.0, "trv"), infsupdec (-0.0, 0.0, "trv")), true)));
%! assert (all (eq (infsupdec (0.0, -0.0, "trv") <= infsupdec (-0.0, 0.0, "trv"), true)));

## minimal_precedes_test

%!test
%! assert (all (eq (precedes (infsup, infsup (3.0, 4.0)), true)));
%!test
%! assert (all (eq (precedes (infsup (3.0, 4.0), infsup), true)));
%!test
%! assert (all (eq (precedes (infsup, infsup), true)));
%!test
%! assert (all (eq (precedes (infsup (1.0, 2.0), infsup (-inf, inf)), false)));
%!test
%! assert (all (eq (precedes (infsup (0.0, 2.0), infsup (-inf, inf)), false)));
%!test
%! assert (all (eq (precedes (infsup (-0.0, 2.0), infsup (-inf, inf)), false)));
%!test
%! assert (all (eq (precedes (infsup (-inf, inf), infsup (1.0, 2.0)), false)));
%!test
%! assert (all (eq (precedes (infsup (-inf, inf), infsup (-inf, inf)), false)));
%!test
%! assert (all (eq (precedes (infsup (1.0, 2.0), infsup (3.0, 4.0)), true)));
%!test
%! assert (all (eq (precedes (infsup (1.0, 3.0), infsup (3.0, 4.0)), true)));
%!test
%! assert (all (eq (precedes (infsup (-3.0, -1.0), infsup (-1.0, 0.0)), true)));
%!test
%! assert (all (eq (precedes (infsup (-3.0, -1.0), infsup (-1.0, -0.0)), true)));
%!test
%! assert (all (eq (precedes (infsup (1.0, 3.5), infsup (3.0, 4.0)), false)));
%!test
%! assert (all (eq (precedes (infsup (1.0, 4.0), infsup (3.0, 4.0)), false)));
%!test
%! assert (all (eq (precedes (infsup (-3.0, -0.1), infsup (-1.0, 0.0)), false)));
%!test
%! assert (all (eq (precedes (infsup (0.0, 0.0), infsup (-0.0, -0.0)), true)));
%!test
%! assert (all (eq (precedes (infsup (-0.0, -0.0), infsup (0.0, 0.0)), true)));
%!test
%! assert (all (eq (precedes (infsup (-0.0, 0.0), infsup (0.0, 0.0)), true)));
%!test
%! assert (all (eq (precedes (infsup (-0.0, 0.0), infsup (0.0, -0.0)), true)));
%!test
%! assert (all (eq (precedes (infsup (0.0, -0.0), infsup (0.0, 0.0)), true)));
%!test
%! assert (all (eq (precedes (infsup (0.0, -0.0), infsup (-0.0, 0.0)), true)));

## minimal_precedes_dec_test

%!test
%! assert (all (eq (precedes (infsupdec (empty, "trv"), infsupdec (3.0, 4.0, "def")), true)));
%!test
%! assert (all (eq (precedes (infsupdec (3.0, 4.0, "trv"), infsupdec (empty, "trv")), true)));
%!test
%! assert (all (eq (precedes (infsupdec (empty, "trv"), infsupdec (3.0, 4.0, "trv")), true)));
%!test
%! assert (all (eq (precedes (infsupdec (3.0, 4.0, "trv"), infsupdec (empty, "trv")), true)));
%!test
%! assert (all (eq (precedes (infsupdec (1.0, 2.0, "trv"), infsupdec (-inf, inf, "trv")), false)));
%!test
%! assert (all (eq (precedes (infsupdec (0.0, 2.0, "trv"), infsupdec (-inf, inf, "trv")), false)));
%!test
%! assert (all (eq (precedes (infsupdec (-0.0, 2.0, "trv"), infsupdec (-inf, inf, "trv")), false)));
%!test
%! assert (all (eq (precedes (infsupdec (-inf, inf, "trv"), infsupdec (1.0, 2.0, "trv")), false)));
%!test
%! assert (all (eq (precedes (infsupdec (-inf, inf, "trv"), infsupdec (-inf, inf, "trv")), false)));
%!test
%! assert (all (eq (precedes (infsupdec (1.0, 2.0, "trv"), infsupdec (3.0, 4.0, "trv")), true)));
%!test
%! assert (all (eq (precedes (infsupdec (1.0, 3.0, "trv"), infsupdec (3.0, 4.0, "def")), true)));
%!test
%! assert (all (eq (precedes (infsupdec (-3.0, -1.0, "def"), infsupdec (-1.0, 0.0, "trv")), true)));
%!test
%! assert (all (eq (precedes (infsupdec (-3.0, -1.0, "trv"), infsupdec (-1.0, -0.0, "trv")), true)));
%!test
%! assert (all (eq (precedes (infsupdec (1.0, 3.5, "trv"), infsupdec (3.0, 4.0, "trv")), false)));
%!test
%! assert (all (eq (precedes (infsupdec (1.0, 4.0, "trv"), infsupdec (3.0, 4.0, "trv")), false)));
%!test
%! assert (all (eq (precedes (infsupdec (-3.0, -0.1, "trv"), infsupdec (-1.0, 0.0, "trv")), false)));
%!test
%! assert (all (eq (precedes (infsupdec (0.0, 0.0, "trv"), infsupdec (-0.0, -0.0, "trv")), true)));
%!test
%! assert (all (eq (precedes (infsupdec (-0.0, -0.0, "trv"), infsupdec (0.0, 0.0, "def")), true)));
%!test
%! assert (all (eq (precedes (infsupdec (-0.0, 0.0, "trv"), infsupdec (0.0, 0.0, "trv")), true)));
%!test
%! assert (all (eq (precedes (infsupdec (-0.0, 0.0, "def"), infsupdec (0.0, -0.0, "trv")), true)));
%!test
%! assert (all (eq (precedes (infsupdec (0.0, -0.0, "trv"), infsupdec (0.0, 0.0, "trv")), true)));
%!test
%! assert (all (eq (precedes (infsupdec (0.0, -0.0, "trv"), infsupdec (-0.0, 0.0, "trv")), true)));

## minimal_interior_test

%!test
%! assert (all (eq (interior (infsup, infsup), true)));
%!test
%! assert (all (eq (interior (infsup, infsup (0.0, 4.0)), true)));
%!test
%! assert (all (eq (interior (infsup (0.0, 4.0), infsup), false)));
%!test
%! assert (all (eq (interior (infsup (-inf, inf), infsup (-inf, inf)), true)));
%!test
%! assert (all (eq (interior (infsup (0.0, 4.0), infsup (-inf, inf)), true)));
%!test
%! assert (all (eq (interior (infsup, infsup (-inf, inf)), true)));
%!test
%! assert (all (eq (interior (infsup (-inf, inf), infsup (0.0, 4.0)), false)));
%!test
%! assert (all (eq (interior (infsup (0.0, 4.0), infsup (0.0, 4.0)), false)));
%!test
%! assert (all (eq (interior (infsup (1.0, 2.0), infsup (0.0, 4.0)), true)));
%!test
%! assert (all (eq (interior (infsup (-2.0, 2.0), infsup (-2.0, 4.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-0.0, -0.0), infsup (-2.0, 4.0)), true)));
%!test
%! assert (all (eq (interior (infsup (0.0, 0.0), infsup (-2.0, 4.0)), true)));
%!test
%! assert (all (eq (interior (infsup (0.0, 0.0), infsup (-0.0, -0.0)), false)));
%!test
%! assert (all (eq (interior (infsup (0.0, 4.4), infsup (0.0, 4.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-1.0, -1.0), infsup (0.0, 4.0)), false)));
%!test
%! assert (all (eq (interior (infsup (2.0, 2.0), infsup (-2.0, -1.0)), false)));

## minimal_interior_dec_test

%!test
%! assert (all (eq (interior (infsupdec (empty, "trv"), infsupdec (0.0, 4.0, "trv")), true)));
%!test
%! assert (all (eq (interior (infsupdec (0.0, 4.0, "def"), infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (interior (infsupdec (0.0, 4.0, "trv"), infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (interior (infsupdec (-inf, inf, "trv"), infsupdec (-inf, inf, "trv")), true)));
%!test
%! assert (all (eq (interior (infsupdec (0.0, 4.0, "trv"), infsupdec (-inf, inf, "trv")), true)));
%!test
%! assert (all (eq (interior (infsupdec (empty, "trv"), infsupdec (-inf, inf, "trv")), true)));
%!test
%! assert (all (eq (interior (infsupdec (-inf, inf, "trv"), infsupdec (0.0, 4.0, "trv")), false)));
%!test
%! assert (all (eq (interior (infsupdec (0.0, 4.0, "trv"), infsupdec (0.0, 4.0, "trv")), false)));
%!test
%! assert (all (eq (interior (infsupdec (1.0, 2.0, "def"), infsupdec (0.0, 4.0, "trv")), true)));
%!test
%! assert (all (eq (interior (infsupdec (-2.0, 2.0, "trv"), infsupdec (-2.0, 4.0, "def")), false)));
%!test
%! assert (all (eq (interior (infsupdec (-0.0, -0.0, "trv"), infsupdec (-2.0, 4.0, "trv")), true)));
%!test
%! assert (all (eq (interior (infsupdec (0.0, 0.0, "def"), infsupdec (-2.0, 4.0, "trv")), true)));
%!test
%! assert (all (eq (interior (infsupdec (0.0, 0.0, "trv"), infsupdec (-0.0, -0.0, "trv")), false)));
%!test
%! assert (all (eq (interior (infsupdec (0.0, 4.4, "trv"), infsupdec (0.0, 4.0, "trv")), false)));
%!test
%! assert (all (eq (interior (infsupdec (-1.0, -1.0, "trv"), infsupdec (0.0, 4.0, "def")), false)));
%!test
%! assert (all (eq (interior (infsupdec (2.0, 2.0, "def"), infsupdec (-2.0, -1.0, "trv")), false)));

## minimal_strictLess_test

%!test
%! assert (all (eq (lt (infsup, infsup), true)));
%! assert (all (eq (infsup < infsup, true)));
%!test
%! assert (all (eq (lt (infsup (1.0, 2.0), infsup), false)));
%! assert (all (eq (infsup (1.0, 2.0) < infsup, false)));
%!test
%! assert (all (eq (lt (infsup, infsup (1.0, 2.0)), false)));
%! assert (all (eq (infsup < infsup (1.0, 2.0), false)));
%!test
%! assert (all (eq (lt (infsup (-inf, inf), infsup (-inf, inf)), true)));
%! assert (all (eq (infsup (-inf, inf) < infsup (-inf, inf), true)));
%!test
%! assert (all (eq (lt (infsup (1.0, 2.0), infsup (-inf, inf)), false)));
%! assert (all (eq (infsup (1.0, 2.0) < infsup (-inf, inf), false)));
%!test
%! assert (all (eq (lt (infsup (-inf, inf), infsup (1.0, 2.0)), false)));
%! assert (all (eq (infsup (-inf, inf) < infsup (1.0, 2.0), false)));
%!test
%! assert (all (eq (lt (infsup (1.0, 2.0), infsup (1.0, 2.0)), false)));
%! assert (all (eq (infsup (1.0, 2.0) < infsup (1.0, 2.0), false)));
%!test
%! assert (all (eq (lt (infsup (1.0, 2.0), infsup (3.0, 4.0)), true)));
%! assert (all (eq (infsup (1.0, 2.0) < infsup (3.0, 4.0), true)));
%!test
%! assert (all (eq (lt (infsup (1.0, 3.5), infsup (3.0, 4.0)), true)));
%! assert (all (eq (infsup (1.0, 3.5) < infsup (3.0, 4.0), true)));
%!test
%! assert (all (eq (lt (infsup (1.0, 4.0), infsup (3.0, 4.0)), false)));
%! assert (all (eq (infsup (1.0, 4.0) < infsup (3.0, 4.0), false)));
%!test
%! assert (all (eq (lt (infsup (0.0, 4.0), infsup (0.0, 4.0)), false)));
%! assert (all (eq (infsup (0.0, 4.0) < infsup (0.0, 4.0), false)));
%!test
%! assert (all (eq (lt (infsup (-0.0, 4.0), infsup (0.0, 4.0)), false)));
%! assert (all (eq (infsup (-0.0, 4.0) < infsup (0.0, 4.0), false)));
%!test
%! assert (all (eq (lt (infsup (-2.0, -1.0), infsup (-2.0, -1.0)), false)));
%! assert (all (eq (infsup (-2.0, -1.0) < infsup (-2.0, -1.0), false)));
%!test
%! assert (all (eq (lt (infsup (-3.0, -1.5), infsup (-2.0, -1.0)), true)));
%! assert (all (eq (infsup (-3.0, -1.5) < infsup (-2.0, -1.0), true)));

## minimal_strictLess_dec_test

%!test
%! assert (all (eq (lt (infsupdec (1.0, 2.0, "trv"), infsupdec (empty, "trv")), false)));
%! assert (all (eq (infsupdec (1.0, 2.0, "trv") < infsupdec (empty, "trv"), false)));
%!test
%! assert (all (eq (lt (infsupdec (empty, "trv"), infsupdec (1.0, 2.0, "def")), false)));
%! assert (all (eq (infsupdec (empty, "trv") < infsupdec (1.0, 2.0, "def"), false)));
%!test
%! assert (all (eq (lt (infsupdec (1.0, 2.0, "def"), infsupdec (empty, "trv")), false)));
%! assert (all (eq (infsupdec (1.0, 2.0, "def") < infsupdec (empty, "trv"), false)));
%!test
%! assert (all (eq (lt (infsupdec (empty, "trv"), infsupdec (1.0, 2.0, "def")), false)));
%! assert (all (eq (infsupdec (empty, "trv") < infsupdec (1.0, 2.0, "def"), false)));
%!test
%! assert (all (eq (lt (infsupdec (-inf, inf, "trv"), infsupdec (-inf, inf, "trv")), true)));
%! assert (all (eq (infsupdec (-inf, inf, "trv") < infsupdec (-inf, inf, "trv"), true)));
%!test
%! assert (all (eq (lt (infsupdec (1.0, 2.0, "trv"), infsupdec (-inf, inf, "trv")), false)));
%! assert (all (eq (infsupdec (1.0, 2.0, "trv") < infsupdec (-inf, inf, "trv"), false)));
%!test
%! assert (all (eq (lt (infsupdec (-inf, inf, "trv"), infsupdec (1.0, 2.0, "trv")), false)));
%! assert (all (eq (infsupdec (-inf, inf, "trv") < infsupdec (1.0, 2.0, "trv"), false)));
%!test
%! assert (all (eq (lt (infsupdec (1.0, 2.0, "trv"), infsupdec (1.0, 2.0, "trv")), false)));
%! assert (all (eq (infsupdec (1.0, 2.0, "trv") < infsupdec (1.0, 2.0, "trv"), false)));
%!test
%! assert (all (eq (lt (infsupdec (1.0, 2.0, "trv"), infsupdec (3.0, 4.0, "trv")), true)));
%! assert (all (eq (infsupdec (1.0, 2.0, "trv") < infsupdec (3.0, 4.0, "trv"), true)));
%!test
%! assert (all (eq (lt (infsupdec (1.0, 3.5, "def"), infsupdec (3.0, 4.0, "trv")), true)));
%! assert (all (eq (infsupdec (1.0, 3.5, "def") < infsupdec (3.0, 4.0, "trv"), true)));
%!test
%! assert (all (eq (lt (infsupdec (1.0, 4.0, "trv"), infsupdec (3.0, 4.0, "def")), false)));
%! assert (all (eq (infsupdec (1.0, 4.0, "trv") < infsupdec (3.0, 4.0, "def"), false)));
%!test
%! assert (all (eq (lt (infsupdec (0.0, 4.0, "trv"), infsupdec (0.0, 4.0, "def")), false)));
%! assert (all (eq (infsupdec (0.0, 4.0, "trv") < infsupdec (0.0, 4.0, "def"), false)));
%!test
%! assert (all (eq (lt (infsupdec (-0.0, 4.0, "def"), infsupdec (0.0, 4.0, "trv")), false)));
%! assert (all (eq (infsupdec (-0.0, 4.0, "def") < infsupdec (0.0, 4.0, "trv"), false)));
%!test
%! assert (all (eq (lt (infsupdec (-2.0, -1.0, "def"), infsupdec (-2.0, -1.0, "def")), false)));
%! assert (all (eq (infsupdec (-2.0, -1.0, "def") < infsupdec (-2.0, -1.0, "def"), false)));
%!test
%! assert (all (eq (lt (infsupdec (-3.0, -1.5, "trv"), infsupdec (-2.0, -1.0, "trv")), true)));
%! assert (all (eq (infsupdec (-3.0, -1.5, "trv") < infsupdec (-2.0, -1.0, "trv"), true)));

## minimal_strictPrecedes_test

%!test
%! assert (all (eq (strictprecedes (infsup, infsup (3.0, 4.0)), true)));
%!test
%! assert (all (eq (strictprecedes (infsup (3.0, 4.0), infsup), true)));
%!test
%! assert (all (eq (strictprecedes (infsup, infsup), true)));
%!test
%! assert (all (eq (strictprecedes (infsup (1.0, 2.0), infsup (-inf, inf)), false)));
%!test
%! assert (all (eq (strictprecedes (infsup (-inf, inf), infsup (1.0, 2.0)), false)));
%!test
%! assert (all (eq (strictprecedes (infsup (-inf, inf), infsup (-inf, inf)), false)));
%!test
%! assert (all (eq (strictprecedes (infsup (1.0, 2.0), infsup (3.0, 4.0)), true)));
%!test
%! assert (all (eq (strictprecedes (infsup (1.0, 3.0), infsup (3.0, 4.0)), false)));
%!test
%! assert (all (eq (strictprecedes (infsup (-3.0, -1.0), infsup (-1.0, 0.0)), false)));
%!test
%! assert (all (eq (strictprecedes (infsup (-3.0, -0.0), infsup (0.0, 1.0)), false)));
%!test
%! assert (all (eq (strictprecedes (infsup (-3.0, 0.0), infsup (-0.0, 1.0)), false)));
%!test
%! assert (all (eq (strictprecedes (infsup (1.0, 3.5), infsup (3.0, 4.0)), false)));
%!test
%! assert (all (eq (strictprecedes (infsup (1.0, 4.0), infsup (3.0, 4.0)), false)));
%!test
%! assert (all (eq (strictprecedes (infsup (-3.0, -0.1), infsup (-1.0, 0.0)), false)));

## minimal_strictPrecedes_dec_test

%!test
%! assert (all (eq (strictprecedes (infsupdec (empty, "trv"), infsupdec (3.0, 4.0, "trv")), true)));
%!test
%! assert (all (eq (strictprecedes (infsupdec (3.0, 4.0, "def"), infsupdec (empty, "trv")), true)));
%!test
%! assert (all (eq (strictprecedes (infsupdec (empty, "trv"), infsupdec (3.0, 4.0, "trv")), true)));
%!test
%! assert (all (eq (strictprecedes (infsupdec (3.0, 4.0, "def"), infsupdec (empty, "trv")), true)));
%!test
%! assert (all (eq (strictprecedes (infsupdec (1.0, 2.0, "trv"), infsupdec (-inf, inf, "trv")), false)));
%!test
%! assert (all (eq (strictprecedes (infsupdec (-inf, inf, "trv"), infsupdec (1.0, 2.0, "trv")), false)));
%!test
%! assert (all (eq (strictprecedes (infsupdec (-inf, inf, "trv"), infsupdec (-inf, inf, "trv")), false)));
%!test
%! assert (all (eq (strictprecedes (infsupdec (1.0, 2.0, "trv"), infsupdec (3.0, 4.0, "trv")), true)));
%!test
%! assert (all (eq (strictprecedes (infsupdec (1.0, 3.0, "def"), infsupdec (3.0, 4.0, "trv")), false)));
%!test
%! assert (all (eq (strictprecedes (infsupdec (-3.0, -1.0, "trv"), infsupdec (-1.0, 0.0, "def")), false)));
%!test
%! assert (all (eq (strictprecedes (infsupdec (-3.0, -0.0, "def"), infsupdec (0.0, 1.0, "trv")), false)));
%!test
%! assert (all (eq (strictprecedes (infsupdec (-3.0, 0.0, "trv"), infsupdec (-0.0, 1.0, "trv")), false)));
%!test
%! assert (all (eq (strictprecedes (infsupdec (1.0, 3.5, "trv"), infsupdec (3.0, 4.0, "trv")), false)));
%!test
%! assert (all (eq (strictprecedes (infsupdec (1.0, 4.0, "trv"), infsupdec (3.0, 4.0, "def")), false)));
%!test
%! assert (all (eq (strictprecedes (infsupdec (-3.0, -0.1, "trv"), infsupdec (-1.0, 0.0, "trv")), false)));

## minimal_disjoint_test

%!test
%! assert (all (eq (disjoint (infsup, infsup (3.0, 4.0)), true)));
%!test
%! assert (all (eq (disjoint (infsup (3.0, 4.0), infsup), true)));
%!test
%! assert (all (eq (disjoint (infsup, infsup), true)));
%!test
%! assert (all (eq (disjoint (infsup (3.0, 4.0), infsup (1.0, 2.0)), true)));
%!test
%! assert (all (eq (disjoint (infsup (0.0, 0.0), infsup (-0.0, -0.0)), false)));
%!test
%! assert (all (eq (disjoint (infsup (0.0, -0.0), infsup (-0.0, 0.0)), false)));
%!test
%! assert (all (eq (disjoint (infsup (3.0, 4.0), infsup (1.0, 7.0)), false)));
%!test
%! assert (all (eq (disjoint (infsup (3.0, 4.0), infsup (-inf, inf)), false)));
%!test
%! assert (all (eq (disjoint (infsup (-inf, inf), infsup (1.0, 7.0)), false)));
%!test
%! assert (all (eq (disjoint (infsup (-inf, inf), infsup (-inf, inf)), false)));

## minimal_disjoint_dec_test

%!test
%! assert (all (eq (disjoint (infsupdec (empty, "trv"), infsupdec (3.0, 4.0, "def")), true)));
%!test
%! assert (all (eq (disjoint (infsupdec (3.0, 4.0, "trv"), infsupdec (empty, "trv")), true)));
%!test
%! assert (all (eq (disjoint (infsupdec (empty, "trv"), infsupdec (3.0, 4.0, "trv")), true)));
%!test
%! assert (all (eq (disjoint (infsupdec (3.0, 4.0, "trv"), infsupdec (empty, "trv")), true)));
%!test
%! assert (all (eq (disjoint (infsupdec (3.0, 4.0, "trv"), infsupdec (1.0, 2.0, "def")), true)));
%!test
%! assert (all (eq (disjoint (infsupdec (0.0, 0.0, "trv"), infsupdec (-0.0, -0.0, "trv")), false)));
%!test
%! assert (all (eq (disjoint (infsupdec (0.0, -0.0, "trv"), infsupdec (-0.0, 0.0, "trv")), false)));
%!test
%! assert (all (eq (disjoint (infsupdec (3.0, 4.0, "def"), infsupdec (1.0, 7.0, "def")), false)));
%!test
%! assert (all (eq (disjoint (infsupdec (3.0, 4.0, "trv"), infsupdec (-inf, inf, "trv")), false)));
%!test
%! assert (all (eq (disjoint (infsupdec (-inf, inf, "trv"), infsupdec (1.0, 7.0, "trv")), false)));
%!test
%! assert (all (eq (disjoint (infsupdec (-inf, inf, "trv"), infsupdec (-inf, inf, "trv")), false)));
