## DO NOT EDIT!  Generated automatically from test/c-xsc.itl
## by the Interval Testing Framework for IEEE 1788.
## https://github.com/nehmeier/ITF1788/tree/29b1d1b6c3a640d4057fe86548d5e7d7c7265904
##
## Copyright 1990-2000 Institut fuer Angewandte Mathematik,
##                     Universitaet Karlsruhe, Germany
##           2000-2014 Wiss. Rechnen/Softwaretechnologie
##                     Universitaet Wuppertal, Germany   
## Copyright 2015 Oliver Heimlich
## 
## Origin: unit tests in C-XSC version 2.5.4, Original license: LGPLv2+
## Converted into portable ITL format by Oliver Heimlich.
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
## 
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
## 
## You should have received a copy of the GNU General Public License
## along with this program; if not, see <http://www.gnu.org/licenses/>.
##
%!#Test library imports
%!function s = to_string (x)
%!    if (isnumeric (x))
%!        s = num2str (x);
%!    elseif (isa (x, 'infsup'))
%!        s = intervaltotext (x);
%!    elseif (isa (x, 'intval'))
%!        s = disp_ (x);
%!    else
%!        # x probably is a char.
%!        s = x;
%!    endif
%!endfunction
%!
%!function assert_warn (expected, actual)
%!    if (not (all (eq (expected, actual))))
%!        warning (["expected: ", to_string(expected), " actual value: ", to_string(actual)]);
%!    endif
%!endfunction

%!#Arithmetic library imports
%!function n = decval (dec)
%!    n = find (strcmp (dec, {"ill", "trv", "def", "dac", "com"}));
%!endfunction

%!#Preamble

## cxsc.intervaladdsub
%!# Tests A+B, B+A, A-B, B-A, -A, +A
%!test
%! assert (all (eq (infsup (10.0, 20.0) + infsup (13.0, 17.0), infsup (23.0, 37.0))));
%! assert (all (eq (plus (infsup (10.0, 20.0), infsup (13.0, 17.0)), infsup (23.0, 37.0))));
%!test
%! assert (all (eq (infsup (13.0, 17.0) + infsup (10.0, 20.0), infsup (23.0, 37.0))));
%! assert (all (eq (plus (infsup (13.0, 17.0), infsup (10.0, 20.0)), infsup (23.0, 37.0))));
%!test
%! assert (all (eq (infsup (10.0, 20.0) - infsup (13.0, 16.0), infsup (-6.0, 7.0))));
%! assert (all (eq (minus (infsup (10.0, 20.0), infsup (13.0, 16.0)), infsup (-6.0, 7.0))));
%!test
%! assert (all (eq (infsup (13.0, 16.0) - infsup (10.0, 20.0), infsup (-7.0, 6.0))));
%! assert (all (eq (minus (infsup (13.0, 16.0), infsup (10.0, 20.0)), infsup (-7.0, 6.0))));
%!test
%! assert (all (eq (-infsup (10.0, 20.0), infsup (-20.0, -10.0))));
%! assert (all (eq (uminus (infsup (10.0, 20.0)), infsup (-20.0, -10.0))));
%!test
%! assert (all (eq (+infsup (10.0, 20.0), infsup (10.0, 20.0))));
%! assert (all (eq (uplus (infsup (10.0, 20.0)), infsup (10.0, 20.0))));

## cxsc.intervalmuldiv
%!# Tests A*B, B*A, A/B, B/A
%!test
%! assert (all (eq (infsup (1.0, 2.0) .* infsup (3.0, 4.0), infsup (3.0, 8.0))));
%! assert (all (eq (times (infsup (1.0, 2.0), infsup (3.0, 4.0)), infsup (3.0, 8.0))));
%!test
%! assert (all (eq (infsup (-1.0, 2.0) .* infsup (3.0, 4.0), infsup (-4.0, 8.0))));
%! assert (all (eq (times (infsup (-1.0, 2.0), infsup (3.0, 4.0)), infsup (-4.0, 8.0))));
%!test
%! assert (all (eq (infsup (-2.0, 1.0) .* infsup (3.0, 4.0), infsup (-8.0, 4.0))));
%! assert (all (eq (times (infsup (-2.0, 1.0), infsup (3.0, 4.0)), infsup (-8.0, 4.0))));
%!test
%! assert (all (eq (infsup (-2.0, -1.0) .* infsup (3.0, 4.0), infsup (-8.0, -3.0))));
%! assert (all (eq (times (infsup (-2.0, -1.0), infsup (3.0, 4.0)), infsup (-8.0, -3.0))));
%!test
%! assert (all (eq (infsup (1.0, 2.0) .* infsup (-3.0, 4.0), infsup (-6.0, 8.0))));
%! assert (all (eq (times (infsup (1.0, 2.0), infsup (-3.0, 4.0)), infsup (-6.0, 8.0))));
%!test
%! assert (all (eq (infsup (-1.0, 2.0) .* infsup (-3.0, 4.0), infsup (-6.0, 8.0))));
%! assert (all (eq (times (infsup (-1.0, 2.0), infsup (-3.0, 4.0)), infsup (-6.0, 8.0))));
%!test
%! assert (all (eq (infsup (-2.0, 1.0) .* infsup (-3.0, 4.0), infsup (-8.0, 6.0))));
%! assert (all (eq (times (infsup (-2.0, 1.0), infsup (-3.0, 4.0)), infsup (-8.0, 6.0))));
%!test
%! assert (all (eq (infsup (-2.0, -1.0) .* infsup (-3.0, 4.0), infsup (-8.0, 6.0))));
%! assert (all (eq (times (infsup (-2.0, -1.0), infsup (-3.0, 4.0)), infsup (-8.0, 6.0))));
%!test
%! assert (all (eq (infsup (1.0, 2.0) .* infsup (-4.0, 3.0), infsup (-8.0, 6.0))));
%! assert (all (eq (times (infsup (1.0, 2.0), infsup (-4.0, 3.0)), infsup (-8.0, 6.0))));
%!test
%! assert (all (eq (infsup (-1.0, 2.0) .* infsup (-4.0, 3.0), infsup (-8.0, 6.0))));
%! assert (all (eq (times (infsup (-1.0, 2.0), infsup (-4.0, 3.0)), infsup (-8.0, 6.0))));
%!test
%! assert (all (eq (infsup (-2.0, 1.0) .* infsup (-4.0, 3.0), infsup (-6.0, 8.0))));
%! assert (all (eq (times (infsup (-2.0, 1.0), infsup (-4.0, 3.0)), infsup (-6.0, 8.0))));
%!test
%! assert (all (eq (infsup (-2.0, -1.0) .* infsup (-4.0, 3.0), infsup (-6.0, 8.0))));
%! assert (all (eq (times (infsup (-2.0, -1.0), infsup (-4.0, 3.0)), infsup (-6.0, 8.0))));
%!test
%! assert (all (eq (infsup (1.0, 2.0) .* infsup (-4.0, -3.0), infsup (-8.0, -3.0))));
%! assert (all (eq (times (infsup (1.0, 2.0), infsup (-4.0, -3.0)), infsup (-8.0, -3.0))));
%!test
%! assert (all (eq (infsup (-1.0, 2.0) .* infsup (-4.0, -3.0), infsup (-8.0, 4.0))));
%! assert (all (eq (times (infsup (-1.0, 2.0), infsup (-4.0, -3.0)), infsup (-8.0, 4.0))));
%!test
%! assert (all (eq (infsup (-2.0, -1.0) .* infsup (-4.0, -3.0), infsup (3.0, 8.0))));
%! assert (all (eq (times (infsup (-2.0, -1.0), infsup (-4.0, -3.0)), infsup (3.0, 8.0))));
%!test
%! assert (all (eq (infsup (1.0, 2.0) ./ infsup (4.0, 8.0), infsup (0.125, 0.5))));
%! assert (all (eq (rdivide (infsup (1.0, 2.0), infsup (4.0, 8.0)), infsup (0.125, 0.5))));
%!test
%! assert (all (eq (infsup (-1.0, 2.0) ./ infsup (4.0, 8.0), infsup (-0.25, 0.5))));
%! assert (all (eq (rdivide (infsup (-1.0, 2.0), infsup (4.0, 8.0)), infsup (-0.25, 0.5))));
%!test
%! assert (all (eq (infsup (-2.0, 1.0) ./ infsup (4.0, 8.0), infsup (-0.5, 0.25))));
%! assert (all (eq (rdivide (infsup (-2.0, 1.0), infsup (4.0, 8.0)), infsup (-0.5, 0.25))));
%!test
%! assert (all (eq (infsup (-2.0, -1.0) ./ infsup (4.0, 8.0), infsup (-0.5, -0.125))));
%! assert (all (eq (rdivide (infsup (-2.0, -1.0), infsup (4.0, 8.0)), infsup (-0.5, -0.125))));
%!test
%! assert (all (eq (infsup (1.0, 2.0) ./ infsup (-4.0, 8.0), infsup (-inf, inf))));
%! assert (all (eq (rdivide (infsup (1.0, 2.0), infsup (-4.0, 8.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (infsup (-1.0, 2.0) ./ infsup (-4.0, 8.0), infsup (-inf, inf))));
%! assert (all (eq (rdivide (infsup (-1.0, 2.0), infsup (-4.0, 8.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (infsup (-2.0, 1.0) ./ infsup (-4.0, 8.0), infsup (-inf, inf))));
%! assert (all (eq (rdivide (infsup (-2.0, 1.0), infsup (-4.0, 8.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (infsup (-2.0, -1.0) ./ infsup (-4.0, 8.0), infsup (-inf, inf))));
%! assert (all (eq (rdivide (infsup (-2.0, -1.0), infsup (-4.0, 8.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (infsup (1.0, 2.0) ./ infsup (-8.0, 4.0), infsup (-inf, inf))));
%! assert (all (eq (rdivide (infsup (1.0, 2.0), infsup (-8.0, 4.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (infsup (-1.0, 2.0) ./ infsup (-8.0, 4.0), infsup (-inf, inf))));
%! assert (all (eq (rdivide (infsup (-1.0, 2.0), infsup (-8.0, 4.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (infsup (-2.0, 1.0) ./ infsup (-8.0, 4.0), infsup (-inf, inf))));
%! assert (all (eq (rdivide (infsup (-2.0, 1.0), infsup (-8.0, 4.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (infsup (-2.0, -1.0) ./ infsup (-8.0, 4.0), infsup (-inf, inf))));
%! assert (all (eq (rdivide (infsup (-2.0, -1.0), infsup (-8.0, 4.0)), infsup (-inf, inf))));
%!test
%! assert (all (eq (infsup (1.0, 2.0) ./ infsup (-8.0, -4.0), infsup (-0.5, -0.125))));
%! assert (all (eq (rdivide (infsup (1.0, 2.0), infsup (-8.0, -4.0)), infsup (-0.5, -0.125))));
%!test
%! assert (all (eq (infsup (-1.0, 2.0) ./ infsup (-8.0, -4.0), infsup (-0.5, 0.25))));
%! assert (all (eq (rdivide (infsup (-1.0, 2.0), infsup (-8.0, -4.0)), infsup (-0.5, 0.25))));
%!test
%! assert (all (eq (infsup (-2.0, 1.0) ./ infsup (-8.0, -4.0), infsup (-0.25, 0.5))));
%! assert (all (eq (rdivide (infsup (-2.0, 1.0), infsup (-8.0, -4.0)), infsup (-0.25, 0.5))));
%!test
%! assert (all (eq (infsup (-2.0, -1.0) ./ infsup (-8.0, -4.0), infsup (0.125, 0.5))));
%! assert (all (eq (rdivide (infsup (-2.0, -1.0), infsup (-8.0, -4.0)), infsup (0.125, 0.5))));

## cxsc.intervalsetops
%!# Tests A|B, B|A, A&B, B&A
%!test
%! assert (all (eq (union (infsup (-2.0, 2.0), infsup (-4.0, -3.0)), infsup (-4.0, 2.0))));
%!test
%! assert (all (eq (union (infsup (-2.0, 2.0), infsup (-4.0, -1.0)), infsup (-4.0, 2.0))));
%!test
%! assert (all (eq (union (infsup (-2.0, 2.0), infsup (-4.0, 4.0)), infsup (-4.0, 4.0))));
%!test
%! assert (all (eq (union (infsup (-2.0, 2.0), infsup (-1.0, 1.0)), infsup (-2.0, 2.0))));
%!test
%! assert (all (eq (union (infsup (-2.0, 2.0), infsup (1.0, 4.0)), infsup (-2.0, 4.0))));
%!test
%! assert (all (eq (union (infsup (-2.0, 2.0), infsup (3.0, 4.0)), infsup (-2.0, 4.0))));
%!test
%! assert (all (eq (union (infsup (-4.0, -3.0), infsup (-2.0, 2.0)), infsup (-4.0, 2.0))));
%!test
%! assert (all (eq (union (infsup (-4.0, -1.0), infsup (-2.0, 2.0)), infsup (-4.0, 2.0))));
%!test
%! assert (all (eq (union (infsup (-4.0, 4.0), infsup (-2.0, 2.0)), infsup (-4.0, 4.0))));
%!test
%! assert (all (eq (union (infsup (-1.0, 1.0), infsup (-2.0, 2.0)), infsup (-2.0, 2.0))));
%!test
%! assert (all (eq (union (infsup (1.0, 4.0), infsup (-2.0, 2.0)), infsup (-2.0, 4.0))));
%!test
%! assert (all (eq (union (infsup (3.0, 4.0), infsup (-2.0, 2.0)), infsup (-2.0, 4.0))));
%!test
%! assert (all (eq (intersect (infsup (-2.0, 2.0), infsup (-4.0, -3.0)), infsup)));
%!test
%! assert (all (eq (intersect (infsup (-2.0, 2.0), infsup (-4.0, -1.0)), infsup (-2.0, -1.0))));
%!test
%! assert (all (eq (intersect (infsup (-2.0, 2.0), infsup (-4.0, 4.0)), infsup (-2.0, 2.0))));
%!test
%! assert (all (eq (intersect (infsup (-2.0, 2.0), infsup (-1.0, 1.0)), infsup (-1.0, 1.0))));
%!test
%! assert (all (eq (intersect (infsup (-2.0, 2.0), infsup (1.0, 4.0)), infsup (1.0, 2.0))));
%!test
%! assert (all (eq (intersect (infsup (-2.0, 2.0), infsup (3.0, 4.0)), infsup)));
%!test
%! assert (all (eq (intersect (infsup (-4.0, -3.0), infsup (-2.0, 2.0)), infsup)));
%!test
%! assert (all (eq (intersect (infsup (-4.0, -1.0), infsup (-2.0, 2.0)), infsup (-2.0, -1.0))));
%!test
%! assert (all (eq (intersect (infsup (-4.0, 4.0), infsup (-2.0, 2.0)), infsup (-2.0, 2.0))));
%!test
%! assert (all (eq (intersect (infsup (-1.0, 1.0), infsup (-2.0, 2.0)), infsup (-1.0, 1.0))));
%!test
%! assert (all (eq (intersect (infsup (1.0, 4.0), infsup (-2.0, 2.0)), infsup (1.0, 2.0))));
%!test
%! assert (all (eq (intersect (infsup (3.0, 4.0), infsup (-2.0, 2.0)), infsup)));

## cxsc.intervalmixsetops
%!# Tests A|B, B|A, A&B, B&A, B is scalar-type
%!test
%! assert (all (eq (union (infsup (-2.0, 2.0), infsup (-4.0, -4.0)), infsup (-4.0, 2.0))));
%!test
%! assert (all (eq (union (infsup (-2.0, 2.0), infsup (1.0, 1.0)), infsup (-2.0, 2.0))));
%!test
%! assert (all (eq (union (infsup (-2.0, 2.0), infsup (4.0, 4.0)), infsup (-2.0, 4.0))));
%!test
%! assert (all (eq (union (infsup (-4.0, -4.0), infsup (-2.0, 2.0)), infsup (-4.0, 2.0))));
%!test
%! assert (all (eq (union (infsup (1.0, 1.0), infsup (-2.0, 2.0)), infsup (-2.0, 2.0))));
%!test
%! assert (all (eq (union (infsup (4.0, 4.0), infsup (-2.0, 2.0)), infsup (-2.0, 4.0))));
%!test
%! assert (all (eq (intersect (infsup (-2.0, 2.0), infsup (-4.0, -4.0)), infsup)));
%!test
%! assert (all (eq (intersect (infsup (-2.0, 2.0), infsup (1.0, 1.0)), infsup (1.0, 1.0))));
%!test
%! assert (all (eq (intersect (infsup (-2.0, 2.0), infsup (4.0, 4.0)), infsup)));
%!test
%! assert (all (eq (intersect (infsup (-4.0, -4.0), infsup (-2.0, 2.0)), infsup)));
%!test
%! assert (all (eq (intersect (infsup (1.0, 1.0), infsup (-2.0, 2.0)), infsup (1.0, 1.0))));
%!test
%! assert (all (eq (intersect (infsup (4.0, 4.0), infsup (-2.0, 2.0)), infsup)));

## cxsc.scalarmixsetops
%!# Tests A|B, B|A, A and B are scalar-type
%!test
%! assert (all (eq (union (infsup (-2.0, -2.0), infsup (-4.0, -4.0)), infsup (-4.0, -2.0))));
%!test
%! assert (all (eq (union (infsup (-2.0, -2.0), infsup (-2.0, -2.0)), infsup (-2.0, -2.0))));
%!test
%! assert (all (eq (union (infsup (-2.0, -2.0), infsup (2.0, 2.0)), infsup (-2.0, 2.0))));
%!test
%! assert (all (eq (union (infsup (-4.0, -4.0), infsup (-2.0, -2.0)), infsup (-4.0, -2.0))));
%!test
%! assert (all (eq (union (infsup (-2.0, -2.0), infsup (-2.0, -2.0)), infsup (-2.0, -2.0))));
%!test
%! assert (all (eq (union (infsup (2.0, 2.0), infsup (-2.0, -2.0)), infsup (-2.0, 2.0))));

## cxsc.intervalsetcompops
%!# Tests A<B, A>B, A<=B, A>=B, A==B
%!test
%! assert (all (eq (interior (infsup (-1.0, 2.0), infsup (-1.0, 2.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-2.0, 1.0), infsup (-3.0, 2.0)), true)));
%!test
%! assert (all (eq (interior (infsup (-2.0, 2.0), infsup (-1.0, 1.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-2.0, 2.0), infsup (-1.0, 2.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-2.0, 2.0), infsup (-2.0, 1.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-2.0, 2.0), infsup (-2.0, 3.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-2.0, 2.0), infsup (-3.0, 2.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-1.0, 2.0), infsup (-1.0, 2.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-3.0, 2.0), infsup (-2.0, 1.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-1.0, 1.0), infsup (-2.0, 2.0)), true)));
%!test
%! assert (all (eq (interior (infsup (-1.0, 2.0), infsup (-2.0, 2.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-2.0, 1.0), infsup (-2.0, 2.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-2.0, 3.0), infsup (-2.0, 2.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-3.0, 2.0), infsup (-2.0, 2.0)), false)));
%!test
%! assert (all (eq (subset (infsup (-1.0, 2.0), infsup (-1.0, 2.0)), true)));
%!test
%! assert (all (eq (subset (infsup (-2.0, 1.0), infsup (-3.0, 2.0)), true)));
%!test
%! assert (all (eq (subset (infsup (-2.0, 2.0), infsup (-1.0, 1.0)), false)));
%!test
%! assert (all (eq (subset (infsup (-2.0, 2.0), infsup (-1.0, 2.0)), false)));
%!test
%! assert (all (eq (subset (infsup (-2.0, 2.0), infsup (-2.0, 1.0)), false)));
%!test
%! assert (all (eq (subset (infsup (-2.0, 2.0), infsup (-2.0, 3.0)), true)));
%!test
%! assert (all (eq (subset (infsup (-2.0, 2.0), infsup (-3.0, 2.0)), true)));
%!test
%! assert (all (eq (subset (infsup (-3.0, 2.0), infsup (-2.0, 1.0)), false)));
%!test
%! assert (all (eq (subset (infsup (-1.0, 1.0), infsup (-2.0, 2.0)), true)));
%!test
%! assert (all (eq (subset (infsup (-1.0, 2.0), infsup (-2.0, 2.0)), true)));
%!test
%! assert (all (eq (subset (infsup (-2.0, 1.0), infsup (-2.0, 2.0)), true)));
%!test
%! assert (all (eq (subset (infsup (-2.0, 3.0), infsup (-2.0, 2.0)), false)));
%!test
%! assert (all (eq (subset (infsup (-3.0, 2.0), infsup (-2.0, 2.0)), false)));
%!test
%! assert (all (eq (eq (infsup (-1.0, 2.0), infsup (-1.0, 2.0)), true)));
%! assert (all (eq (infsup (-1.0, 2.0) == infsup (-1.0, 2.0), true)));
%!test
%! assert (all (eq (eq (infsup (-2.0, 1.0), infsup (-3.0, 2.0)), false)));
%! assert (all (eq (infsup (-2.0, 1.0) == infsup (-3.0, 2.0), false)));
%!test
%! assert (all (eq (eq (infsup (-2.0, 2.0), infsup (-1.0, 1.0)), false)));
%! assert (all (eq (infsup (-2.0, 2.0) == infsup (-1.0, 1.0), false)));
%!test
%! assert (all (eq (eq (infsup (-2.0, 2.0), infsup (-1.0, 2.0)), false)));
%! assert (all (eq (infsup (-2.0, 2.0) == infsup (-1.0, 2.0), false)));
%!test
%! assert (all (eq (eq (infsup (-2.0, 2.0), infsup (-2.0, 1.0)), false)));
%! assert (all (eq (infsup (-2.0, 2.0) == infsup (-2.0, 1.0), false)));
%!test
%! assert (all (eq (eq (infsup (-2.0, 2.0), infsup (-2.0, 3.0)), false)));
%! assert (all (eq (infsup (-2.0, 2.0) == infsup (-2.0, 3.0), false)));
%!test
%! assert (all (eq (eq (infsup (-2.0, 2.0), infsup (-3.0, 2.0)), false)));
%! assert (all (eq (infsup (-2.0, 2.0) == infsup (-3.0, 2.0), false)));

## cxsc.intervalscalarsetcompops
%!# Tests A<B, A>B, A<=B, A>=B, A==B, B<A, B>A, B<=A, B>=A, B==A, where B is scalar
%!test
%! assert (all (eq (interior (infsup (-1.0, 2.0), infsup (-2.0, -2.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-2.0, 2.0), infsup (-2.0, -2.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-2.0, 2.0), infsup (0.0, 0.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-2.0, 2.0), infsup (2.0, 2.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-2.0, 2.0), infsup (3.0, 3.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-1.0, -1.0), infsup (1.0, 1.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-1.0, -1.0), infsup (-1.0, -1.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-2.0, -2.0), infsup (-1.0, 2.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-2.0, -2.0), infsup (-2.0, 2.0)), false)));
%!test
%! assert (all (eq (interior (infsup (0.0, 0.0), infsup (-2.0, 2.0)), true)));
%!test
%! assert (all (eq (interior (infsup (2.0, 2.0), infsup (-2.0, 2.0)), false)));
%!test
%! assert (all (eq (interior (infsup (3.0, 3.0), infsup (-2.0, 2.0)), false)));
%!test
%! assert (all (eq (interior (infsup (1.0, 1.0), infsup (-1.0, -1.0)), false)));
%!test
%! assert (all (eq (interior (infsup (-1.0, -1.0), infsup (-1.0, -1.0)), false)));
%!test
%! assert (all (eq (subset (infsup (-1.0, 2.0), infsup (-2.0, -2.0)), false)));
%!test
%! assert (all (eq (subset (infsup (-2.0, 2.0), infsup (-2.0, -2.0)), false)));
%!test
%! assert (all (eq (subset (infsup (-2.0, 2.0), infsup (0.0, 0.0)), false)));
%!test
%! assert (all (eq (subset (infsup (-2.0, 2.0), infsup (2.0, 2.0)), false)));
%!test
%! assert (all (eq (subset (infsup (-2.0, 2.0), infsup (3.0, 3.0)), false)));
%!test
%! assert (all (eq (subset (infsup (-1.0, -1.0), infsup (1.0, 1.0)), false)));
%!test
%! assert (all (eq (subset (infsup (-1.0, -1.0), infsup (-1.0, -1.0)), true)));
%!test
%! assert (all (eq (subset (infsup (-2.0, -2.0), infsup (-1.0, 2.0)), false)));
%!test
%! assert (all (eq (subset (infsup (-2.0, -2.0), infsup (-2.0, 2.0)), true)));
%!test
%! assert (all (eq (subset (infsup (0.0, 0.0), infsup (-2.0, 2.0)), true)));
%!test
%! assert (all (eq (subset (infsup (2.0, 2.0), infsup (-2.0, 2.0)), true)));
%!test
%! assert (all (eq (subset (infsup (3.0, 3.0), infsup (-2.0, 2.0)), false)));
%!test
%! assert (all (eq (subset (infsup (1.0, 1.0), infsup (-1.0, -1.0)), false)));
%!test
%! assert (all (eq (subset (infsup (-1.0, -1.0), infsup (-1.0, -1.0)), true)));
%!test
%! assert (all (eq (eq (infsup (-1.0, 2.0), infsup (-2.0, -2.0)), false)));
%! assert (all (eq (infsup (-1.0, 2.0) == infsup (-2.0, -2.0), false)));
%!test
%! assert (all (eq (eq (infsup (-2.0, 2.0), infsup (-2.0, -2.0)), false)));
%! assert (all (eq (infsup (-2.0, 2.0) == infsup (-2.0, -2.0), false)));
%!test
%! assert (all (eq (eq (infsup (-2.0, 2.0), infsup (0.0, 0.0)), false)));
%! assert (all (eq (infsup (-2.0, 2.0) == infsup (0.0, 0.0), false)));
%!test
%! assert (all (eq (eq (infsup (-2.0, 2.0), infsup (2.0, 2.0)), false)));
%! assert (all (eq (infsup (-2.0, 2.0) == infsup (2.0, 2.0), false)));
%!test
%! assert (all (eq (eq (infsup (-2.0, 2.0), infsup (3.0, 3.0)), false)));
%! assert (all (eq (infsup (-2.0, 2.0) == infsup (3.0, 3.0), false)));
%!test
%! assert (all (eq (eq (infsup (-1.0, -1.0), infsup (1.0, 1.0)), false)));
%! assert (all (eq (infsup (-1.0, -1.0) == infsup (1.0, 1.0), false)));
%!test
%! assert (all (eq (eq (infsup (-1.0, -1.0), infsup (-1.0, -1.0)), true)));
%! assert (all (eq (infsup (-1.0, -1.0) == infsup (-1.0, -1.0), true)));

## cxsc.intervalstdfunc

%!test
%! assert (all (eq (sqr (infsup (11.0, 11.0)), infsup (121.0, 121.0))));
%!test
%! assert (all (eq (sqr (infsup (0.0, 0.0)), infsup (0.0, 0.0))));
%!test
%! assert (all (eq (sqr (infsup (-9.0, -9.0)), infsup (81.0, 81.0))));
%!test
%! assert (all (eq (realsqrt (infsup (121.0, 121.0)), infsup (11.0, 11.0))));
%!test
%! assert (all (eq (realsqrt (infsup (0.0, 0.0)), infsup (0.0, 0.0))));
%!test
%! assert (all (eq (realsqrt (infsup (81.0, 81.0)), infsup (9.0, 9.0))));
%!test
%! assert (all (eq (nthroot (infsup (27.0, 27.0), 3), 3.0)));
%!test
%! assert (all (eq (nthroot (infsup (0.0, 0.0), 4), 0.0)));
%!test
%! assert (all (eq (nthroot (infsup (1024.0, 1024.0), 10), 2.0)));
%!test
%! assert (all (eq (pow (infsup (2.0, 2.0), infsup (2.0, 2.0)), infsup (4.0, 4.0))));
%!test
%! assert (all (eq (pow (infsup (4.0, 4.0), infsup (5.0, 5.0)), infsup (1024.0, 1024.0))));
%!# Negativ geht noch nicht
%!test
%! assert (all (eq (pow (infsup (2.0, 2.0), infsup (3.0, 3.0)), infsup (8.0, 8.0))));
