## DO NOT EDIT!  Generated automatically from test/atan2.itl
## by the Interval Testing Framework for IEEE 1788.
## https://github.com/nehmeier/ITF1788/tree/29b1d1b6c3a640d4057fe86548d5e7d7c7265904
##
## Copyright 2015 Oliver Heimlich
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
## 
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
## 
## You should have received a copy of the GNU General Public License
## along with this program; if not, see <http://www.gnu.org/licenses/>.
##
%!#Test library imports
%!function s = to_string (x)
%!    if (isnumeric (x))
%!        s = num2str (x);
%!    elseif (isa (x, 'infsup'))
%!        s = intervaltotext (x);
%!    elseif (isa (x, 'intval'))
%!        s = disp_ (x);
%!    else
%!        # x probably is a char.
%!        s = x;
%!    endif
%!endfunction
%!
%!function assert_warn (expected, actual)
%!    if (not (all (eq (expected, actual))))
%!        warning (["expected: ", to_string(expected), " actual value: ", to_string(actual)]);
%!    endif
%!endfunction

%!#Arithmetic library imports
%!function n = decval (dec)
%!    n = find (strcmp (dec, {"ill", "trv", "def", "dac", "com"}));
%!endfunction

%!#Preamble

## minimal.atan2_test

%!test
%! assert (all (eq (atan2 (infsup, infsup), infsup)));
%!test
%! assert (all (eq (atan2 (infsup, infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (atan2 (infsup (-inf, inf), infsup), infsup)));
%!test
%! assert (all (eq (atan2 (infsup (0.0, 0.0), infsup (0.0, 0.0)), infsup)));
%!test
%! assert (all (eq (atan2 (infsup (-inf, inf), infsup (-inf, inf)), infsup (-3.141592653589793560e+00, 3.141592653589793560e+00))));
%!test
%! assert (all (eq (atan2 (infsup (0.0, 0.0), infsup (-inf, 0.0)), infsup (3.141592653589793116e+00, 3.141592653589793560e+00))));
%!test
%! assert (all (eq (atan2 (infsup (0.0, 0.0), infsup (0.0, inf)), infsup (0.0, 0.0))));
%!test
%! assert (all (eq (atan2 (infsup (0.0, inf), infsup (0.0, 0.0)), infsup (1.570796326794896558e+00, 1.570796326794896780e+00))));
%!test
%! assert (all (eq (atan2 (infsup (-inf, 0.0), infsup (0.0, 0.0)), infsup (-1.570796326794896780e+00, -1.570796326794896558e+00))));
%!test
%! assert (all (eq (atan2 (infsup (-2.225073858507201383e-308, 0.0), infsup (-2.225073858507201383e-308, -2.225073858507201383e-308)), infsup (-3.141592653589793560e+00, 3.141592653589793560e+00))));
%!test
%! assert (all (eq (atan2 (infsup (1.0, 1.0), infsup (-1.0, -1.0)), infsup (2.356194490192344837e+00, 2.356194490192345281e+00))));
%!test
%! assert (all (eq (atan2 (infsup (1.0, 1.0), infsup (1.0, 1.0)), infsup (7.853981633974482790e-01, 7.853981633974483900e-01))));
%!test
%! assert (all (eq (atan2 (infsup (-1.0, -1.0), infsup (1.0, 1.0)), infsup (-7.853981633974483900e-01, -7.853981633974482790e-01))));
%!test
%! assert (all (eq (atan2 (infsup (-1.0, -1.0), infsup (-1.0, -1.0)), infsup (-2.356194490192345281e+00, -2.356194490192344837e+00))));
%!test
%! assert (all (eq (atan2 (infsup (-2.225073858507201383e-308, 2.225073858507201383e-308), infsup (-2.225073858507201383e-308, -2.225073858507201383e-308)), infsup (-3.141592653589793560e+00, 3.141592653589793560e+00))));
%!test
%! assert (all (eq (atan2 (infsup (-2.225073858507201383e-308, 2.225073858507201383e-308), infsup (2.225073858507201383e-308, 2.225073858507201383e-308)), infsup (-7.853981633974483900e-01, 7.853981633974483900e-01))));
%!test
%! assert (all (eq (atan2 (infsup (-2.225073858507201383e-308, -2.225073858507201383e-308), infsup (-2.225073858507201383e-308, 2.225073858507201383e-308)), infsup (-2.356194490192345281e+00, -7.853981633974482790e-01))));
%!test
%! assert (all (eq (atan2 (infsup (2.225073858507201383e-308, 2.225073858507201383e-308), infsup (-2.225073858507201383e-308, 2.225073858507201383e-308)), infsup (7.853981633974482790e-01, 2.356194490192345281e+00))));
%!test
%! assert (all (eq (atan2 (infsup (-2.0, 2.0), infsup (-3.0, -1.0)), infsup (-3.141592653589793560e+00, 3.141592653589793560e+00))));
%!test
%! assert (all (eq (atan2 (infsup (0.0, 2.0), infsup (-3.0, -1.0)), infsup (2.034443935795702707e+00, 3.141592653589793560e+00))));
%!test
%! assert (all (eq (atan2 (infsup (1.0, 3.0), infsup (-3.0, -1.0)), infsup (1.892546881191538688e+00, 2.819842099193151430e+00))));
%!test
%! assert (all (eq (atan2 (infsup (1.0, 3.0), infsup (-2.0, 0.0)), infsup (1.570796326794896558e+00, 2.677945044588987411e+00))));
%!test
%! assert (all (eq (atan2 (infsup (1.0, 3.0), infsup (-2.0, 2.0)), infsup (4.636476090008060935e-01, 2.677945044588987411e+00))));
%!test
%! assert (all (eq (atan2 (infsup (1.0, 3.0), infsup (0.0, 2.0)), infsup (4.636476090008060935e-01, 1.570796326794896780e+00))));
%!test
%! assert (all (eq (atan2 (infsup (1.0, 3.0), infsup (1.0, 3.0)), infsup (3.217505543966421855e-01, 1.249045772398254428e+00))));
%!test
%! assert (all (eq (atan2 (infsup (0.0, 2.0), infsup (1.0, 3.0)), infsup (0.000000000000000000e+00, 1.107148717794090631e+00))));
%!test
%! assert (all (eq (atan2 (infsup (-2.0, 2.0), infsup (1.0, 3.0)), infsup (-1.107148717794090631e+00, 1.107148717794090631e+00))));
%!test
%! assert (all (eq (atan2 (infsup (-2.0, 0.0), infsup (1.0, 3.0)), infsup (-1.107148717794090631e+00, 0.000000000000000000e+00))));
%!test
%! assert (all (eq (atan2 (infsup (-3.0, -1.0), infsup (1.0, 3.0)), infsup (-1.249045772398254428e+00, -3.217505543966421855e-01))));
%!test
%! assert (all (eq (atan2 (infsup (-3.0, -1.0), infsup (0.0, 2.0)), infsup (-1.570796326794896780e+00, -4.636476090008060935e-01))));
%!test
%! assert (all (eq (atan2 (infsup (-3.0, -1.0), infsup (-2.0, 2.0)), infsup (-2.677945044588987411e+00, -4.636476090008060935e-01))));
%!test
%! assert (all (eq (atan2 (infsup (-3.0, -1.0), infsup (-2.0, 0.0)), infsup (-2.677945044588987411e+00, -1.570796326794896558e+00))));
%!test
%! assert (all (eq (atan2 (infsup (-3.0, -1.0), infsup (-3.0, -1.0)), infsup (-2.819842099193151430e+00, -1.892546881191538688e+00))));
%!test
%! assert (all (eq (atan2 (infsup (-2.0, 0.0), infsup (-3.0, -1.0)), infsup (-3.141592653589793560e+00, 3.141592653589793560e+00))));
%!test
%! assert (all (eq (atan2 (infsup (-5.0, 0.0), infsup (-5.0, 0.0)), infsup (-3.141592653589793560e+00, 3.141592653589793560e+00))));
%!test
%! assert (all (eq (atan2 (infsup (0.0, 5.0), infsup (-5.0, 0.0)), infsup (1.570796326794896558e+00, 3.141592653589793560e+00))));
%!test
%! assert (all (eq (atan2 (infsup (0.0, 5.0), infsup (0.0, 5.0)), infsup (0.000000000000000000e+00, 1.570796326794896780e+00))));
%!test
%! assert (all (eq (atan2 (infsup (-5.0, 0.0), infsup (0.0, 5.0)), infsup (-1.570796326794896780e+00, 0.000000000000000000e+00))));
