## DO NOT EDIT!  Generated automatically from test/libieeep1788_tests_rec_bool.itl
## by the Interval Testing Framework for IEEE 1788.
## https://github.com/nehmeier/ITF1788/tree/09c37dc3a884ee2e1989e0e2b2f34324087a5199
##
## Copyright 2013 - 2015 Marco Nehmeier (nehmeier@informatik.uni-wuerzburg.de)
## Copyright 2015 Oliver Heimlich (oheim@posteo.de)
## 
## Original author: Marco Nehmeier (unit tests in libieeep1788)
## Converted into portable ITL format by Oliver Heimlich with minor corrections.
## 
## Licensed under the Apache License, Version 2.0 (the "License");
## you may not use this file except in compliance with the License.
## You may obtain a copy of the License at
## 
##     http://www.apache.org/licenses/LICENSE-2.0
## 
## Unless required by applicable law or agreed to in writing, software
## distributed under the License is distributed on an "AS IS" BASIS,
## WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
## See the License for the specific language governing permissions and
## limitations under the License.
##
%!#Test library imports
%!function s = to_string (x)
%!    if (isnumeric (x))
%!        s = num2str (x);
%!    elseif (isa (x, 'infsup'))
%!        s = intervaltotext (x);
%!    elseif (isa (x, 'intval'))
%!        s = disp_ (x);
%!    else
%!        # x probably is a char.
%!        s = x;
%!    endif
%!endfunction
%!
%!function assert_warn (expected, actual)
%!    if (not (all (eq (expected, actual))))
%!        warning (["expected: ", to_string(expected), " actual value: ", to_string(actual)]);
%!    endif
%!endfunction

%!#Arithmetic library imports
%!function n = decval (dec)
%!    n = find (strcmp (dec, {"ill", "trv", "def", "dac", "com"}));
%!endfunction

%!#Preamble

## minimal_isCommonInterval_test

%!test
%! assert (all (eq (iscommoninterval (infsup (-27.0, -27.0)), true)));
%!test
%! assert (all (eq (iscommoninterval (infsup (-27.0, 0.0)), true)));
%!test
%! assert (all (eq (iscommoninterval (infsup (0.0, 0.0)), true)));
%!test
%! assert (all (eq (iscommoninterval (infsup (-0.0, -0.0)), true)));
%!test
%! assert (all (eq (iscommoninterval (infsup (-0.0, 0.0)), true)));
%!test
%! assert (all (eq (iscommoninterval (infsup (0.0, -0.0)), true)));
%!test
%! assert (all (eq (iscommoninterval (infsup (5.0, 12.4)), true)));
%!test
%! assert (all (eq (iscommoninterval (infsup (-1.797693134862315708e+308, 1.797693134862315708e+308)), true)));
%!test
%! assert (all (eq (iscommoninterval (infsup (-inf, inf)), false)));
%!test
%! assert (all (eq (iscommoninterval (infsup), false)));
%!test
%! assert (all (eq (iscommoninterval (infsup (-inf, 0.0)), false)));
%!test
%! assert (all (eq (iscommoninterval (infsup (0.0, inf)), false)));

## minimal_isCommonInterval_dec_test

%!test
%! assert (all (eq (iscommoninterval (infsupdec (-27.0, -27.0, "com")), true)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (-27.0, 0.0, "com")), true)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (0.0, 0.0, "com")), true)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (-0.0, -0.0, "com")), true)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (-0.0, 0.0, "com")), true)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (0.0, -0.0, "com")), true)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (5.0, 12.4, "com")), true)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "com")), true)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (-27.0, -27.0, "trv")), true)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (-27.0, 0.0, "def")), true)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (0.0, 0.0, "dac")), true)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (-0.0, -0.0, "trv")), true)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (-0.0, 0.0, "def")), true)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (0.0, -0.0, "dac")), true)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (5.0, 12.4, "def")), true)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (-1.797693134862315708e+308, 1.797693134862315708e+308, "trv")), true)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (entire, "dac")), false)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (-inf, 0.0, "trv")), false)));
%!test
%! assert (all (eq (iscommoninterval (infsupdec (0.0, inf, "def")), false)));

## minimal_isSingleton_test

%!test
%! assert (all (eq (issingleton (infsup (-27.0, -27.0)), true)));
%!test
%! assert (all (eq (issingleton (infsup (-2.0, -2.0)), true)));
%!test
%! assert (all (eq (issingleton (infsup (12.0, 12.0)), true)));
%!test
%! assert (all (eq (issingleton (infsup (17.1, 17.1)), true)));
%!test
%! assert (all (eq (issingleton (infsup (-0.0, -0.0)), true)));
%!test
%! assert (all (eq (issingleton (infsup (0.0, 0.0)), true)));
%!test
%! assert (all (eq (issingleton (infsup (-0.0, 0.0)), true)));
%!test
%! assert (all (eq (issingleton (infsup (0.0, -0.0)), true)));
%!test
%! assert (all (eq (issingleton (infsup), false)));
%!test
%! assert (all (eq (issingleton (infsup (-inf, inf)), false)));
%!test
%! assert (all (eq (issingleton (infsup (-1.0, 0.0)), false)));
%!test
%! assert (all (eq (issingleton (infsup (-1.0, -0.5)), false)));
%!test
%! assert (all (eq (issingleton (infsup (1.0, 2.0)), false)));
%!test
%! assert (all (eq (issingleton (infsup (-inf, -1.797693134862315708e+308)), false)));
%!test
%! assert (all (eq (issingleton (infsup (-1.0, inf)), false)));

## minimal_isSingleton_dec_test

%!test
%! assert (all (eq (issingleton (infsupdec (-27.0, -27.0, "def")), true)));
%!test
%! assert (all (eq (issingleton (infsupdec (-2.0, -2.0, "trv")), true)));
%!test
%! assert (all (eq (issingleton (infsupdec (12.0, 12.0, "dac")), true)));
%!test
%! assert (all (eq (issingleton (infsupdec (17.1, 17.1, "com")), true)));
%!test
%! assert (all (eq (issingleton (infsupdec (-0.0, -0.0, "def")), true)));
%!test
%! assert (all (eq (issingleton (infsupdec (0.0, 0.0, "com")), true)));
%!test
%! assert (all (eq (issingleton (infsupdec (-0.0, 0.0, "def")), true)));
%!test
%! assert (all (eq (issingleton (infsupdec (0.0, -0.0, "dac")), true)));
%!test
%! assert (all (eq (issingleton (infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (issingleton (infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (issingleton (infsupdec (entire, "def")), false)));
%!test
%! assert (all (eq (issingleton (infsupdec (-1.0, 0.0, "dac")), false)));
%!test
%! assert (all (eq (issingleton (infsupdec (-1.0, -0.5, "com")), false)));
%!test
%! assert (all (eq (issingleton (infsupdec (1.0, 2.0, "def")), false)));
%!test
%! assert (all (eq (issingleton (infsupdec (-inf, -1.797693134862315708e+308, "dac")), false)));
%!test
%! assert (all (eq (issingleton (infsupdec (-1.0, inf, "trv")), false)));

## minimal_isMember_test

%!test
%! assert (all (eq (ismember (-27.0, infsup (-27.0, -27.0)), true)));
%!test
%! assert (all (eq (ismember (-27.0, infsup (-27.0, 0.0)), true)));
%!test
%! assert (all (eq (ismember (-7.0, infsup (-27.0, 0.0)), true)));
%!test
%! assert (all (eq (ismember (0.0, infsup (-27.0, 0.0)), true)));
%!test
%! assert (all (eq (ismember (-0.0, infsup (0.0, 0.0)), true)));
%!test
%! assert (all (eq (ismember (0.0, infsup (0.0, 0.0)), true)));
%!test
%! assert (all (eq (ismember (0.0, infsup (-0.0, -0.0)), true)));
%!test
%! assert (all (eq (ismember (0.0, infsup (-0.0, 0.0)), true)));
%!test
%! assert (all (eq (ismember (0.0, infsup (0.0, -0.0)), true)));
%!test
%! assert (all (eq (ismember (5.0, infsup (5.0, 12.4)), true)));
%!test
%! assert (all (eq (ismember (6.3, infsup (5.0, 12.4)), true)));
%!test
%! assert (all (eq (ismember (12.4, infsup (5.0, 12.4)), true)));
%!test
%! assert (all (eq (ismember (0.0, infsup (-inf, inf)), true)));
%!test
%! assert (all (eq (ismember (5.0, infsup (-inf, inf)), true)));
%!test
%! assert (all (eq (ismember (6.3, infsup (-inf, inf)), true)));
%!test
%! assert (all (eq (ismember (12.4, infsup (-inf, inf)), true)));
%!test
%! assert (all (eq (ismember (-71.0, infsup (-27.0, 0.0)), false)));
%!test
%! assert (all (eq (ismember (0.1, infsup (-27.0, 0.0)), false)));
%!test
%! assert (all (eq (ismember (-0.01, infsup (0.0, 0.0)), false)));
%!test
%! assert (all (eq (ismember (0.000001, infsup (0.0, 0.0)), false)));
%!test
%! assert (all (eq (ismember (111110.0, infsup (-0.0, -0.0)), false)));
%!test
%! assert (all (eq (ismember (4.9, infsup (5.0, 12.4)), false)));
%!test
%! assert (all (eq (ismember (-6.3, infsup (5.0, 12.4)), false)));
%!test
%! assert (all (eq (ismember (0.0, infsup), false)));
%!test
%! assert (all (eq (ismember (-4535.3, infsup), false)));
%!test
%! assert (all (eq (ismember (-inf, infsup), false)));
%!test
%! assert (all (eq (ismember (inf, infsup), false)));
%!test
%! assert (all (eq (ismember (-inf, infsup (-inf, inf)), false)));
%!test
%! assert (all (eq (ismember (inf, infsup (-inf, inf)), false)));

## minimal_isMember_dec_test

%!test
%! assert (all (eq (ismember (-27.0, infsupdec (-27.0, -27.0, "trv")), true)));
%!test
%! assert (all (eq (ismember (-27.0, infsupdec (-27.0, 0.0, "def")), true)));
%!test
%! assert (all (eq (ismember (-7.0, infsupdec (-27.0, 0.0, "dac")), true)));
%!test
%! assert (all (eq (ismember (0.0, infsupdec (-27.0, 0.0, "com")), true)));
%!test
%! assert (all (eq (ismember (-0.0, infsupdec (0.0, 0.0, "trv")), true)));
%!test
%! assert (all (eq (ismember (0.0, infsupdec (0.0, 0.0, "def")), true)));
%!test
%! assert (all (eq (ismember (0.0, infsupdec (-0.0, -0.0, "dac")), true)));
%!test
%! assert (all (eq (ismember (0.0, infsupdec (-0.0, 0.0, "com")), true)));
%!test
%! assert (all (eq (ismember (0.0, infsupdec (0.0, -0.0, "trv")), true)));
%!test
%! assert (all (eq (ismember (5.0, infsupdec (5.0, 12.4, "def")), true)));
%!test
%! assert (all (eq (ismember (6.3, infsupdec (5.0, 12.4, "dac")), true)));
%!test
%! assert (all (eq (ismember (12.4, infsupdec (5.0, 12.4, "com")), true)));
%!test
%! assert (all (eq (ismember (0.0, infsupdec (entire, "trv")), true)));
%!test
%! assert (all (eq (ismember (5.0, infsupdec (entire, "def")), true)));
%!test
%! assert (all (eq (ismember (6.3, infsupdec (entire, "dac")), true)));
%!test
%! assert (all (eq (ismember (12.4, infsupdec (entire, "trv")), true)));
%!test
%! assert (all (eq (ismember (-71.0, infsupdec (-27.0, 0.0, "trv")), false)));
%!test
%! assert (all (eq (ismember (0.1, infsupdec (-27.0, 0.0, "def")), false)));
%!test
%! assert (all (eq (ismember (-0.01, infsupdec (0.0, 0.0, "dac")), false)));
%!test
%! assert (all (eq (ismember (0.000001, infsupdec (0.0, 0.0, "com")), false)));
%!test
%! assert (all (eq (ismember (111110.0, infsupdec (-0.0, -0.0, "trv")), false)));
%!test
%! assert (all (eq (ismember (4.9, infsupdec (5.0, 12.4, "def")), false)));
%!test
%! assert (all (eq (ismember (-6.3, infsupdec (5.0, 12.4, "dac")), false)));
%!test
%! assert (all (eq (ismember (0.0, infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (ismember (0.0, infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (ismember (-4535.3, infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (ismember (-4535.3, infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (ismember (-inf, infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (ismember (-inf, infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (ismember (inf, infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (ismember (inf, infsupdec (empty, "trv")), false)));
%!test
%! assert (all (eq (ismember (-inf, infsupdec (entire, "trv")), false)));
%!test
%! assert (all (eq (ismember (inf, infsupdec (entire, "def")), false)));
