## DO NOT EDIT!  Generated automatically from test/libieeep1788_tests_mul_rev.itl
## by the Interval Testing Framework for IEEE 1788.
## https://github.com/nehmeier/ITF1788/tree/09c37dc3a884ee2e1989e0e2b2f34324087a5199
##
## Copyright 2013 - 2015 Marco Nehmeier (nehmeier@informatik.uni-wuerzburg.de)
## Copyright 2015 Oliver Heimlich (oheim@posteo.de)
## 
## Original author: Marco Nehmeier (unit tests in libieeep1788)
## Converted into portable ITL format by Oliver Heimlich with minor corrections.
## 
## Licensed under the Apache License, Version 2.0 (the "License");
## you may not use this file except in compliance with the License.
## You may obtain a copy of the License at
## 
##     http://www.apache.org/licenses/LICENSE-2.0
## 
## Unless required by applicable law or agreed to in writing, software
## distributed under the License is distributed on an "AS IS" BASIS,
## WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
## See the License for the specific language governing permissions and
## limitations under the License.
##
%!#Test library imports
%!function s = to_string (x)
%!    if (isnumeric (x))
%!        s = num2str (x);
%!    elseif (isa (x, 'infsup'))
%!        s = intervaltotext (x);
%!    elseif (isa (x, 'intval'))
%!        s = disp_ (x);
%!    else
%!        # x probably is a char.
%!        s = x;
%!    endif
%!endfunction
%!
%!function assert_warn (expected, actual)
%!    if (not (all (eq (expected, actual))))
%!        warning (["expected: ", to_string(expected), " actual value: ", to_string(actual)]);
%!    endif
%!endfunction

%!#Arithmetic library imports
%!function n = decval (dec)
%!    n = find (strcmp (dec, {"ill", "trv", "def", "dac", "com"}));
%!endfunction

%!#Preamble

## minimal_mulRevToPair_test

%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup, infsup (1.0, 2.0)), infsup)));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup, infsup (1.0, 2.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (1.0, 2.0), infsup), infsup)));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (1.0, 2.0), infsup), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup, infsup), infsup)));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup, infsup), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, -0.1), infsup (-2.1, -0.4)), infsup (2.000000000000000111e-01, 2.100000000000000000e+01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, -0.1), infsup (-2.1, -0.4)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 0.0), infsup (-2.1, -0.4)), infsup (2.000000000000000111e-01, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 0.0), infsup (-2.1, -0.4)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 1.1), infsup (-2.1, -0.4)), infsup (-inf, -3.636363636363635909e-01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 1.1), infsup (-2.1, -0.4)), infsup (2.000000000000000111e-01, inf))));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 1.1), infsup (-2.1, -0.4)), infsup (-inf, -3.636363636363635909e-01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 1.1), infsup (-2.1, -0.4)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, 1.1), infsup (-2.1, -0.4)), infsup (-2.100000000000000284e+02, -3.636363636363635909e-01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, 1.1), infsup (-2.1, -0.4)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 0.0), infsup (-2.1, -0.4)), infsup)));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 0.0), infsup (-2.1, -0.4)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, -0.1), infsup (-2.1, -0.4)), infsup (0.0, 2.100000000000000000e+01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, -0.1), infsup (-2.1, -0.4)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 0.0), infsup (-2.1, -0.4)), infsup (0.0, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 0.0), infsup (-2.1, -0.4)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 1.1), infsup (-2.1, -0.4)), infsup (-inf, -3.636363636363635909e-01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 1.1), infsup (-2.1, -0.4)), infsup (0.0, inf))));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, inf), infsup (-2.1, -0.4)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, inf), infsup (-2.1, -0.4)), infsup (2.000000000000000111e-01, inf))));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, inf), infsup (-2.1, -0.4)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, inf), infsup (-2.1, -0.4)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, inf), infsup (-2.1, -0.4)), infsup (-2.100000000000000284e+02, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, inf), infsup (-2.1, -0.4)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, inf), infsup (-2.1, -0.4)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, inf), infsup (-2.1, -0.4)), infsup (0.0, inf))));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, -0.1), infsup (-2.1, 0.0)), infsup (0.0, 2.100000000000000000e+01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, -0.1), infsup (-2.1, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 0.0), infsup (-2.1, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 0.0), infsup (-2.1, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 1.1), infsup (-2.1, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 1.1), infsup (-2.1, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 1.1), infsup (-2.1, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 1.1), infsup (-2.1, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, 1.1), infsup (-2.1, 0.0)), infsup (-2.100000000000000284e+02, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, 1.1), infsup (-2.1, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 0.0), infsup (-2.1, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 0.0), infsup (-2.1, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, -0.1), infsup (-2.1, 0.0)), infsup (0.0, 2.100000000000000000e+01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, -0.1), infsup (-2.1, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 0.0), infsup (-2.1, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 0.0), infsup (-2.1, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 1.1), infsup (-2.1, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 1.1), infsup (-2.1, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, inf), infsup (-2.1, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, inf), infsup (-2.1, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, inf), infsup (-2.1, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, inf), infsup (-2.1, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, inf), infsup (-2.1, 0.0)), infsup (-2.100000000000000284e+02, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, inf), infsup (-2.1, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, inf), infsup (-2.1, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, inf), infsup (-2.1, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, -0.1), infsup (-2.1, 0.12)), infsup (-1.199999999999999956e+00, 2.100000000000000000e+01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, -0.1), infsup (-2.1, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 0.0), infsup (-2.1, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 0.0), infsup (-2.1, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 1.1), infsup (-2.1, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 1.1), infsup (-2.1, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 1.1), infsup (-2.1, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 1.1), infsup (-2.1, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, 1.1), infsup (-2.1, 0.12)), infsup (-2.100000000000000284e+02, 1.200000000000000000e+01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, 1.1), infsup (-2.1, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 0.0), infsup (-2.1, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 0.0), infsup (-2.1, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, -0.1), infsup (-2.1, 0.12)), infsup (-1.199999999999999956e+00, 2.100000000000000000e+01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, -0.1), infsup (-2.1, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 0.0), infsup (-2.1, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 0.0), infsup (-2.1, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 1.1), infsup (-2.1, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 1.1), infsup (-2.1, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, inf), infsup (-2.1, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, inf), infsup (-2.1, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, inf), infsup (-2.1, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, inf), infsup (-2.1, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, inf), infsup (-2.1, 0.12)), infsup (-2.100000000000000284e+02, 1.200000000000000000e+01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, inf), infsup (-2.1, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, inf), infsup (-2.1, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, inf), infsup (-2.1, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, -0.1), infsup (0.0, 0.12)), infsup (-1.199999999999999956e+00, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, -0.1), infsup (0.0, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 0.0), infsup (0.0, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 0.0), infsup (0.0, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 1.1), infsup (0.0, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 1.1), infsup (0.0, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 1.1), infsup (0.0, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 1.1), infsup (0.0, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, 1.1), infsup (0.0, 0.12)), infsup (0.0, 1.200000000000000000e+01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, 1.1), infsup (0.0, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 0.0), infsup (0.0, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 0.0), infsup (0.0, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, -0.1), infsup (0.0, 0.12)), infsup (-1.199999999999999956e+00, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, -0.1), infsup (0.0, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 0.0), infsup (0.0, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 0.0), infsup (0.0, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 1.1), infsup (0.0, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 1.1), infsup (0.0, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, inf), infsup (0.0, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, inf), infsup (0.0, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, inf), infsup (0.0, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, inf), infsup (0.0, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, inf), infsup (0.0, 0.12)), infsup (0.0, 1.200000000000000000e+01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, inf), infsup (0.0, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, inf), infsup (0.0, 0.12)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, inf), infsup (0.0, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, -0.1), infsup (0.01, 0.12)), infsup (-1.199999999999999956e+00, -5.000000000000000104e-03))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, -0.1), infsup (0.01, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 0.0), infsup (0.01, 0.12)), infsup (-inf, -5.000000000000000104e-03))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 0.0), infsup (0.01, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 1.1), infsup (0.01, 0.12)), infsup (-inf, -5.000000000000000104e-03))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 1.1), infsup (0.01, 0.12)), infsup (9.090909090909088733e-03, inf))));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 1.1), infsup (0.01, 0.12)), infsup (9.090909090909088733e-03, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 1.1), infsup (0.01, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, 1.1), infsup (0.01, 0.12)), infsup (9.090909090909088733e-03, 1.200000000000000000e+01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, 1.1), infsup (0.01, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 0.0), infsup (0.01, 0.12)), infsup)));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 0.0), infsup (0.01, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, -0.1), infsup (0.01, 0.12)), infsup (-1.199999999999999956e+00, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, -0.1), infsup (0.01, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 0.0), infsup (0.01, 0.12)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 0.0), infsup (0.01, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 1.1), infsup (0.01, 0.12)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 1.1), infsup (0.01, 0.12)), infsup (9.090909090909088733e-03, inf))));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, inf), infsup (0.01, 0.12)), infsup (-inf, -5.000000000000000104e-03))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, inf), infsup (0.01, 0.12)), infsup (0.0, inf))));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, inf), infsup (0.01, 0.12)), infsup (0.0, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, inf), infsup (0.01, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, inf), infsup (0.01, 0.12)), infsup (0.0, 1.200000000000000000e+01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, inf), infsup (0.01, 0.12)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, inf), infsup (0.01, 0.12)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, inf), infsup (0.01, 0.12)), infsup (0.0, inf))));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, -0.1), infsup (0.0, 0.0)), infsup (0.0, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, -0.1), infsup (0.0, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 0.0), infsup (0.0, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 0.0), infsup (0.0, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 1.1), infsup (0.0, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 1.1), infsup (0.0, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 1.1), infsup (0.0, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 1.1), infsup (0.0, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, 1.1), infsup (0.0, 0.0)), infsup (0.0, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, 1.1), infsup (0.0, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 0.0), infsup (0.0, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 0.0), infsup (0.0, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, -0.1), infsup (0.0, 0.0)), infsup (0.0, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, -0.1), infsup (0.0, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 0.0), infsup (0.0, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 0.0), infsup (0.0, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 1.1), infsup (0.0, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 1.1), infsup (0.0, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, inf), infsup (0.0, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, inf), infsup (0.0, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, inf), infsup (0.0, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, inf), infsup (0.0, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, inf), infsup (0.0, 0.0)), infsup (0.0, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, inf), infsup (0.0, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, inf), infsup (0.0, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, inf), infsup (0.0, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, -0.1), infsup (-inf, -0.1)), infsup (5.000000000000000278e-02, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, -0.1), infsup (-inf, -0.1)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 0.0), infsup (-inf, -0.1)), infsup (5.000000000000000278e-02, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 0.0), infsup (-inf, -0.1)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 1.1), infsup (-inf, -0.1)), infsup (-inf, -9.090909090909089774e-02))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 1.1), infsup (-inf, -0.1)), infsup (5.000000000000000278e-02, inf))));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 1.1), infsup (-inf, -0.1)), infsup (-inf, -9.090909090909089774e-02))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 1.1), infsup (-inf, -0.1)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, 1.1), infsup (-inf, -0.1)), infsup (-inf, -9.090909090909089774e-02))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, 1.1), infsup (-inf, -0.1)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 0.0), infsup (-inf, -0.1)), infsup)));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 0.0), infsup (-inf, -0.1)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, -0.1), infsup (-inf, -0.1)), infsup (0.0, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, -0.1), infsup (-inf, -0.1)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 0.0), infsup (-inf, -0.1)), infsup (0.0, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 0.0), infsup (-inf, -0.1)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 1.1), infsup (-inf, -0.1)), infsup (-inf, -9.090909090909089774e-02))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 1.1), infsup (-inf, -0.1)), infsup (0.0, inf))));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, inf), infsup (-inf, -0.1)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, inf), infsup (-inf, -0.1)), infsup (5.000000000000000278e-02, inf))));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, inf), infsup (-inf, -0.1)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, inf), infsup (-inf, -0.1)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, inf), infsup (-inf, -0.1)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, inf), infsup (-inf, -0.1)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, inf), infsup (-inf, -0.1)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, inf), infsup (-inf, -0.1)), infsup (0.0, inf))));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, -0.1), infsup (-inf, 0.0)), infsup (0.0, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, -0.1), infsup (-inf, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 0.0), infsup (-inf, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 0.0), infsup (-inf, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 1.1), infsup (-inf, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 1.1), infsup (-inf, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 1.1), infsup (-inf, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 1.1), infsup (-inf, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, 1.1), infsup (-inf, 0.0)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, 1.1), infsup (-inf, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 0.0), infsup (-inf, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 0.0), infsup (-inf, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, -0.1), infsup (-inf, 0.0)), infsup (0.0, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, -0.1), infsup (-inf, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 0.0), infsup (-inf, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 0.0), infsup (-inf, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 1.1), infsup (-inf, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 1.1), infsup (-inf, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, inf), infsup (-inf, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, inf), infsup (-inf, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, inf), infsup (-inf, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, inf), infsup (-inf, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, inf), infsup (-inf, 0.0)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, inf), infsup (-inf, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, inf), infsup (-inf, 0.0)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, inf), infsup (-inf, 0.0)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, -0.1), infsup (-inf, 0.3)), infsup (-3.000000000000000000e+00, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, -0.1), infsup (-inf, 0.3)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 0.0), infsup (-inf, 0.3)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 0.0), infsup (-inf, 0.3)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 1.1), infsup (-inf, 0.3)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 1.1), infsup (-inf, 0.3)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 1.1), infsup (-inf, 0.3)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 1.1), infsup (-inf, 0.3)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, 1.1), infsup (-inf, 0.3)), infsup (-inf, 3.000000000000000000e+01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, 1.1), infsup (-inf, 0.3)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 0.0), infsup (-inf, 0.3)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 0.0), infsup (-inf, 0.3)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, -0.1), infsup (-inf, 0.3)), infsup (-3.000000000000000000e+00, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, -0.1), infsup (-inf, 0.3)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 0.0), infsup (-inf, 0.3)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 0.0), infsup (-inf, 0.3)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 1.1), infsup (-inf, 0.3)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 1.1), infsup (-inf, 0.3)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, inf), infsup (-inf, 0.3)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, inf), infsup (-inf, 0.3)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, inf), infsup (-inf, 0.3)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, inf), infsup (-inf, 0.3)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, inf), infsup (-inf, 0.3)), infsup (-inf, 3.000000000000000000e+01))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, inf), infsup (-inf, 0.3)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, inf), infsup (-inf, 0.3)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, inf), infsup (-inf, 0.3)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, -0.1), infsup (-0.21, inf)), infsup (-inf, 2.100000000000000089e+00))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, -0.1), infsup (-0.21, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 0.0), infsup (-0.21, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 0.0), infsup (-0.21, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 1.1), infsup (-0.21, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 1.1), infsup (-0.21, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 1.1), infsup (-0.21, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 1.1), infsup (-0.21, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, 1.1), infsup (-0.21, inf)), infsup (-2.100000000000000000e+01, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, 1.1), infsup (-0.21, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 0.0), infsup (-0.21, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 0.0), infsup (-0.21, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, -0.1), infsup (-0.21, inf)), infsup (-inf, 2.100000000000000089e+00))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, -0.1), infsup (-0.21, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 0.0), infsup (-0.21, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 0.0), infsup (-0.21, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 1.1), infsup (-0.21, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 1.1), infsup (-0.21, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, inf), infsup (-0.21, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, inf), infsup (-0.21, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, inf), infsup (-0.21, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, inf), infsup (-0.21, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, inf), infsup (-0.21, inf)), infsup (-2.100000000000000000e+01, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, inf), infsup (-0.21, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, inf), infsup (-0.21, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, inf), infsup (-0.21, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, -0.1), infsup (0.0, inf)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, -0.1), infsup (0.0, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 0.0), infsup (0.0, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 0.0), infsup (0.0, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 1.1), infsup (0.0, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 1.1), infsup (0.0, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 1.1), infsup (0.0, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 1.1), infsup (0.0, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, 1.1), infsup (0.0, inf)), infsup (0.0, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, 1.1), infsup (0.0, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 0.0), infsup (0.0, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 0.0), infsup (0.0, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, -0.1), infsup (0.0, inf)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, -0.1), infsup (0.0, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 0.0), infsup (0.0, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 0.0), infsup (0.0, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 1.1), infsup (0.0, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 1.1), infsup (0.0, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, inf), infsup (0.0, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, inf), infsup (0.0, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, inf), infsup (0.0, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, inf), infsup (0.0, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, inf), infsup (0.0, inf)), infsup (0.0, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, inf), infsup (0.0, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, inf), infsup (0.0, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, inf), infsup (0.0, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, -0.1), infsup (0.04, inf)), infsup (-inf, -2.000000000000000042e-02))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, -0.1), infsup (0.04, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 0.0), infsup (0.04, inf)), infsup (-inf, -2.000000000000000042e-02))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 0.0), infsup (0.04, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 1.1), infsup (0.04, inf)), infsup (-inf, -2.000000000000000042e-02))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 1.1), infsup (0.04, inf)), infsup (3.636363636363635493e-02, inf))));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 1.1), infsup (0.04, inf)), infsup (3.636363636363635493e-02, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 1.1), infsup (0.04, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, 1.1), infsup (0.04, inf)), infsup (3.636363636363635493e-02, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, 1.1), infsup (0.04, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 0.0), infsup (0.04, inf)), infsup)));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 0.0), infsup (0.04, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, -0.1), infsup (0.04, inf)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, -0.1), infsup (0.04, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 0.0), infsup (0.04, inf)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 0.0), infsup (0.04, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 1.1), infsup (0.04, inf)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 1.1), infsup (0.04, inf)), infsup (3.636363636363635493e-02, inf))));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, inf), infsup (0.04, inf)), infsup (-inf, -2.000000000000000042e-02))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, inf), infsup (0.04, inf)), infsup (0.0, inf))));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, inf), infsup (0.04, inf)), infsup (0.0, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, inf), infsup (0.04, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, inf), infsup (0.04, inf)), infsup (0.0, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, inf), infsup (0.04, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, inf), infsup (0.04, inf)), infsup (-inf, 0.0))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, inf), infsup (0.04, inf)), infsup (0.0, inf))));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, -0.1), infsup (-inf, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, -0.1), infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 0.0), infsup (-inf, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 0.0), infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, 1.1), infsup (-inf, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, 1.1), infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 1.1), infsup (-inf, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 1.1), infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, 1.1), infsup (-inf, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, 1.1), infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, 0.0), infsup (-inf, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, 0.0), infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, -0.1), infsup (-inf, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, -0.1), infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 0.0), infsup (-inf, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 0.0), infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, 1.1), infsup (-inf, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, 1.1), infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-2.0, inf), infsup (-inf, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-2.0, inf), infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.0, inf), infsup (-inf, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.0, inf), infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (0.01, inf), infsup (-inf, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (0.01, inf), infsup (-inf, inf)), infsup)));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsup (-inf, inf), infsup (-inf, inf)), infsup (-inf, inf))));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsup (-inf, inf), infsup (-inf, inf)), infsup)));

## minimal_mulRevToPair_dec_test

%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (empty, "trv"), infsupdec (1.0, 2.0, "def")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (empty, "trv"), infsupdec (1.0, 2.0, "def"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (empty, "trv"), infsupdec (1.0, 2.0, "def")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (empty, "trv"), infsupdec (1.0, 2.0, "def"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (1.0, 2.0, "com"), infsupdec (empty, "trv")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (1.0, 2.0, "com"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (1.0, 2.0, "com"), infsupdec (empty, "trv")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (1.0, 2.0, "com"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (empty, "trv"), infsupdec (empty, "trv")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (empty, "trv"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (empty, "trv"), infsupdec (empty, "trv")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (empty, "trv"), infsupdec (empty, "trv"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "com"), infsupdec (-2.1, -0.4, "com")), infsupdec (2.000000000000000111e-01, 2.100000000000000000e+01, "com"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "com"), infsupdec (-2.1, -0.4, "com"))) {1}, decorationpart (infsupdec (2.000000000000000111e-01, 2.100000000000000000e+01, "com")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "com"), infsupdec (-2.1, -0.4, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "com"), infsupdec (-2.1, -0.4, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-2.1, -0.4, "com")), infsupdec (2.000000000000000111e-01, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-2.1, -0.4, "com"))) {1}, decorationpart (infsupdec (2.000000000000000111e-01, inf, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-2.1, -0.4, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-2.1, -0.4, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "com"), infsupdec (-2.1, -0.4, "dac")), infsupdec (-inf, -3.636363636363635909e-01, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "com"), infsupdec (-2.1, -0.4, "dac"))) {1}, decorationpart (infsupdec (-inf, -3.636363636363635909e-01, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "com"), infsupdec (-2.1, -0.4, "dac")), infsupdec (2.000000000000000111e-01, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "com"), infsupdec (-2.1, -0.4, "dac"))) {1}, decorationpart (infsupdec (2.000000000000000111e-01, inf, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "trv"), infsupdec (-2.1, -0.4, "def")), infsupdec (-inf, -3.636363636363635909e-01, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "trv"), infsupdec (-2.1, -0.4, "def"))) {1}, decorationpart (infsupdec (-inf, -3.636363636363635909e-01, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "trv"), infsupdec (-2.1, -0.4, "def")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "trv"), infsupdec (-2.1, -0.4, "def"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "com"), infsupdec (-2.1, -0.4, "com")), infsupdec (-2.100000000000000284e+02, -3.636363636363635909e-01, "com"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "com"), infsupdec (-2.1, -0.4, "com"))) {1}, decorationpart (infsupdec (-2.100000000000000284e+02, -3.636363636363635909e-01, "com")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "com"), infsupdec (-2.1, -0.4, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "com"), infsupdec (-2.1, -0.4, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-2.1, -0.4, "def")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-2.1, -0.4, "def"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-2.1, -0.4, "def")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-2.1, -0.4, "def"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-2.1, -0.4, "dac")), infsupdec (0.0, 2.100000000000000000e+01, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-2.1, -0.4, "dac"))) {1}, decorationpart (infsupdec (0.0, 2.100000000000000000e+01, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-2.1, -0.4, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-2.1, -0.4, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "def"), infsupdec (-2.1, -0.4, "com")), infsupdec (0.0, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "def"), infsupdec (-2.1, -0.4, "com"))) {1}, decorationpart (infsupdec (0.0, inf, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "def"), infsupdec (-2.1, -0.4, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "def"), infsupdec (-2.1, -0.4, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "trv"), infsupdec (-2.1, -0.4, "def")), infsupdec (-inf, -3.636363636363635909e-01, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "trv"), infsupdec (-2.1, -0.4, "def"))) {1}, decorationpart (infsupdec (-inf, -3.636363636363635909e-01, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "trv"), infsupdec (-2.1, -0.4, "def")), infsupdec (0.0, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "trv"), infsupdec (-2.1, -0.4, "def"))) {1}, decorationpart (infsupdec (0.0, inf, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-2.1, -0.4, "dac")), infsupdec (-inf, 0.0, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-2.1, -0.4, "dac"))) {1}, decorationpart (infsupdec (-inf, 0.0, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-2.1, -0.4, "dac")), infsupdec (2.000000000000000111e-01, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-2.1, -0.4, "dac"))) {1}, decorationpart (infsupdec (2.000000000000000111e-01, inf, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "def"), infsupdec (-2.1, -0.4, "com")), infsupdec (-inf, 0.0, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "def"), infsupdec (-2.1, -0.4, "com"))) {1}, decorationpart (infsupdec (-inf, 0.0, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "def"), infsupdec (-2.1, -0.4, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "def"), infsupdec (-2.1, -0.4, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "def"), infsupdec (-2.1, -0.4, "def")), infsupdec (-2.100000000000000284e+02, 0.0, "def"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "def"), infsupdec (-2.1, -0.4, "def"))) {1}, decorationpart (infsupdec (-2.100000000000000284e+02, 0.0, "def")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "def"), infsupdec (-2.1, -0.4, "def")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "def"), infsupdec (-2.1, -0.4, "def"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-2.1, -0.4, "dac")), infsupdec (-inf, 0.0, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-2.1, -0.4, "dac"))) {1}, decorationpart (infsupdec (-inf, 0.0, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-2.1, -0.4, "dac")), infsupdec (0.0, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-2.1, -0.4, "dac"))) {1}, decorationpart (infsupdec (0.0, inf, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (0.0, 2.100000000000000000e+01, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (0.0, 2.100000000000000000e+01, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (-2.100000000000000284e+02, 0.0, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (-2.100000000000000284e+02, 0.0, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (0.0, 2.100000000000000000e+01, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (0.0, 2.100000000000000000e+01, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (-2.100000000000000284e+02, 0.0, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (-2.100000000000000284e+02, 0.0, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-2.1, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-2.1, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (-1.199999999999999956e+00, 2.100000000000000000e+01, "def"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (-1.199999999999999956e+00, 2.100000000000000000e+01, "def")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (-2.100000000000000284e+02, 1.200000000000000000e+01, "def"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (-2.100000000000000284e+02, 1.200000000000000000e+01, "def")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (-1.199999999999999956e+00, 2.100000000000000000e+01, "def"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (-1.199999999999999956e+00, 2.100000000000000000e+01, "def")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (-2.100000000000000284e+02, 1.200000000000000000e+01, "def"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (-2.100000000000000284e+02, 1.200000000000000000e+01, "def")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (entire, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (entire, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (entire, "def"), infsupdec (-2.1, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (entire, "def"), infsupdec (-2.1, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "com"), infsupdec (0.0, 0.12, "com")), infsupdec (-1.199999999999999956e+00, 0.0, "com"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "com"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (-1.199999999999999956e+00, 0.0, "com")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "com"), infsupdec (0.0, 0.12, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "com"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "com"), infsupdec (0.0, 0.12, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "com"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "com"), infsupdec (0.0, 0.12, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "com"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "com"), infsupdec (0.0, 0.12, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "com"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "com"), infsupdec (0.0, 0.12, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "com"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "com"), infsupdec (0.0, 0.12, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "com"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "com"), infsupdec (0.0, 0.12, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "com"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "com"), infsupdec (0.0, 0.12, "com")), infsupdec (0.0, 1.200000000000000000e+01, "com"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "com"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (0.0, 1.200000000000000000e+01, "com")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "com"), infsupdec (0.0, 0.12, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "com"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "com"), infsupdec (0.0, 0.12, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "com"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "com"), infsupdec (0.0, 0.12, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "com"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.0, 0.12, "com")), infsupdec (-1.199999999999999956e+00, 0.0, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (-1.199999999999999956e+00, 0.0, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.0, 0.12, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.0, 0.12, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.0, 0.12, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.0, 0.12, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.0, 0.12, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.0, 0.12, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.0, 0.12, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.0, 0.12, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.0, 0.12, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.0, 0.12, "com")), infsupdec (0.0, 1.200000000000000000e+01, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (0.0, 1.200000000000000000e+01, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.0, 0.12, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.0, 0.12, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.0, 0.12, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.0, 0.12, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (-1.199999999999999956e+00, -5.000000000000000104e-03, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (-1.199999999999999956e+00, -5.000000000000000104e-03, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (-inf, -5.000000000000000104e-03, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (-inf, -5.000000000000000104e-03, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (-inf, -5.000000000000000104e-03, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (-inf, -5.000000000000000104e-03, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (9.090909090909088733e-03, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (9.090909090909088733e-03, inf, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (9.090909090909088733e-03, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (9.090909090909088733e-03, inf, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (9.090909090909088733e-03, 1.200000000000000000e+01, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (9.090909090909088733e-03, 1.200000000000000000e+01, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (-1.199999999999999956e+00, 0.0, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (-1.199999999999999956e+00, 0.0, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (-inf, 0.0, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (-inf, 0.0, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (-inf, 0.0, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (-inf, 0.0, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (9.090909090909088733e-03, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (9.090909090909088733e-03, inf, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (-inf, -5.000000000000000104e-03, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (-inf, -5.000000000000000104e-03, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (0.0, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (0.0, inf, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (0.0, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (0.0, inf, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (0.0, 1.200000000000000000e+01, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (0.0, 1.200000000000000000e+01, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (-inf, 0.0, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (-inf, 0.0, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.01, 0.12, "dac")), infsupdec (0.0, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.01, 0.12, "dac"))) {1}, decorationpart (infsupdec (0.0, inf, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "com"), infsupdec (0.0, 0.0, "com")), infsupdec (0.0, 0.0, "com"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "com"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (0.0, 0.0, "com")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "com"), infsupdec (0.0, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "com"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "com"), infsupdec (0.0, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "com"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "com"), infsupdec (0.0, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "com"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "com"), infsupdec (0.0, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "com"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "com"), infsupdec (0.0, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "com"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "com"), infsupdec (0.0, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "com"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "com"), infsupdec (0.0, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "com"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "com"), infsupdec (0.0, 0.0, "com")), infsupdec (0.0, 0.0, "com"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "com"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (0.0, 0.0, "com")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "com"), infsupdec (0.0, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "com"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "com"), infsupdec (0.0, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "com"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "com"), infsupdec (0.0, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "com"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.0, 0.0, "com")), infsupdec (0.0, 0.0, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (0.0, 0.0, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.0, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.0, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.0, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.0, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.0, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.0, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.0, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.0, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.0, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.0, 0.0, "com")), infsupdec (0.0, 0.0, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (0.0, 0.0, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.0, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.0, 0.0, "com")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.0, 0.0, "com")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.0, 0.0, "com"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (5.000000000000000278e-02, inf, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (5.000000000000000278e-02, inf, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (5.000000000000000278e-02, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (5.000000000000000278e-02, inf, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (-inf, -9.090909090909089774e-02, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (-inf, -9.090909090909089774e-02, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (5.000000000000000278e-02, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (5.000000000000000278e-02, inf, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (-inf, -9.090909090909089774e-02, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (-inf, -9.090909090909089774e-02, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (-inf, -9.090909090909089774e-02, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (-inf, -9.090909090909089774e-02, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (0.0, inf, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (0.0, inf, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (0.0, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (0.0, inf, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (-inf, -9.090909090909089774e-02, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (-inf, -9.090909090909089774e-02, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (0.0, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (0.0, inf, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (-inf, 0.0, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (-inf, 0.0, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (5.000000000000000278e-02, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (5.000000000000000278e-02, inf, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (-inf, 0.0, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (-inf, 0.0, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (-inf, 0.0, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (-inf, 0.0, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (-inf, 0.0, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (-inf, 0.0, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-inf, -0.1, "dac")), infsupdec (0.0, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-inf, -0.1, "dac"))) {1}, decorationpart (infsupdec (0.0, inf, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (0.0, inf, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (0.0, inf, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (-inf, 0.0, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (-inf, 0.0, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (0.0, inf, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (0.0, inf, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (-inf, 0.0, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (-inf, 0.0, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-inf, 0.0, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-inf, 0.0, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (-3.000000000000000000e+00, inf, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (-3.000000000000000000e+00, inf, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (-inf, 3.000000000000000000e+01, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (-inf, 3.000000000000000000e+01, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (-3.000000000000000000e+00, inf, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (-3.000000000000000000e+00, inf, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (-inf, 3.000000000000000000e+01, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (-inf, 3.000000000000000000e+01, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-inf, 0.3, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-inf, 0.3, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (-inf, 2.100000000000000089e+00, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (-inf, 2.100000000000000089e+00, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (-2.100000000000000000e+01, inf, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (-2.100000000000000000e+01, inf, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (-inf, 2.100000000000000089e+00, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (-inf, 2.100000000000000089e+00, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (-2.100000000000000000e+01, inf, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (-2.100000000000000000e+01, inf, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-0.21, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (-0.21, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (-inf, 0.0, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (-inf, 0.0, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (0.0, inf, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (0.0, inf, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (-inf, 0.0, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (-inf, 0.0, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (0.0, inf, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (0.0, inf, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.0, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.0, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (-inf, -2.000000000000000042e-02, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (-inf, -2.000000000000000042e-02, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (-inf, -2.000000000000000042e-02, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (-inf, -2.000000000000000042e-02, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (-inf, -2.000000000000000042e-02, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (-inf, -2.000000000000000042e-02, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (3.636363636363635493e-02, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (3.636363636363635493e-02, inf, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (3.636363636363635493e-02, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (3.636363636363635493e-02, inf, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (3.636363636363635493e-02, inf, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (3.636363636363635493e-02, inf, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (-inf, 0.0, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (-inf, 0.0, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (-inf, 0.0, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (-inf, 0.0, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (-inf, 0.0, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (-inf, 0.0, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (3.636363636363635493e-02, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (3.636363636363635493e-02, inf, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (-inf, -2.000000000000000042e-02, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (-inf, -2.000000000000000042e-02, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (0.0, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (0.0, inf, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (0.0, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (0.0, inf, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (0.0, inf, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (0.0, inf, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (-inf, 0.0, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (-inf, 0.0, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.04, inf, "dac")), infsupdec (0.0, inf, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (0.04, inf, "dac"))) {1}, decorationpart (infsupdec (0.0, inf, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (entire, "dac")), infsupdec (entire, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (entire, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (entire, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, -0.1, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (entire, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (entire, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 0.0, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (entire, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (entire, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, 1.1, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (entire, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (entire, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 1.1, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (entire, "dac")), infsupdec (entire, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (entire, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (entire, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, 1.1, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (entire, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (entire, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, 0.0, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (entire, "dac")), infsupdec (entire, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (entire, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (entire, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, -0.1, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (entire, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (entire, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 0.0, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (entire, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (entire, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-inf, 1.1, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (entire, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (entire, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (-2.0, inf, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (entire, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (entire, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.0, inf, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (entire, "dac")), infsupdec (entire, "dac"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (entire, "dac")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (entire, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (0.01, inf, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
%!test
%! assert (all (eq (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (entire, "dac")), infsupdec (entire, "trv"))));
%! assert (all (eq (decorationpart (nthargout(1, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (entire, "trv")) {1})));
%! assert (all (eq (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (entire, "dac")), infsupdec (empty, "trv"))));
%! assert (all (eq (decorationpart (nthargout(2, 2, @mulrev, infsupdec (entire, "dac"), infsupdec (entire, "dac"))) {1}, decorationpart (infsupdec (empty, "trv")) {1})));
