##
## Copyright 2013 - 2015 Marco Nehmeier (nehmeier@informatik.uni-wuerzburg.de)
## Copyright 2015 Oliver Heimlich (oheim@posteo.de)
## 
## Original author: Marco Nehmeier (unit tests in libieeep1788)
## Converted into portable ITL format by Oliver Heimlich with minor corrections.
## 
## Licensed under the Apache License, Version 2.0 (the "License");
## you may not use this file except in compliance with the License.
## You may obtain a copy of the License at
## 
##     http://www.apache.org/licenses/LICENSE-2.0
## 
## Unless required by applicable law or agreed to in writing, software
## distributed under the License is distributed on an "AS IS" BASIS,
## WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
## See the License for the specific language governing permissions and
## limitations under the License.
##
%! ## Test library imports
%!function s = to_string (x)
%!    if (isnumeric (x))
%!        s = num2str (x);
%!    elseif (isa (x, 'infsup'))
%!        s = intervaltotext (x);
%!    else
%!        # x probably is a char.
%!        s = x;
%!    endif
%!endfunction
%
%!function n = decval (dec)
%! n = find (strcmp (dec, {"ill", "trv", "def", "dac", "com"}));
%!endfunction

%!test "minimal_overlap_test";
%! assert (all (eq (...
%!    overlap (infsup (), infsup ()), ...
%!    "bothEmpty")))
%! assert (all (eq (...
%!    overlap (infsup (), infsup (1.0, 2.0)), ...
%!    "firstEmpty")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 2.0), infsup ()), ...
%!    "secondEmpty")))
%! assert (all (eq (...
%!    overlap (infsup (-inf, 2.0), infsup (3.0, inf)), ...
%!    "before")))
%! assert (all (eq (...
%!    overlap (infsup (-inf, 2.0), infsup (3.0, 4.0)), ...
%!    "before")))
%! assert (all (eq (...
%!    overlap (infsup (2.0, 2.0), infsup (3.0, 4.0)), ...
%!    "before")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 2.0), infsup (3.0, 4.0)), ...
%!    "before")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 2.0), infsup (3.0, 3.0)), ...
%!    "before")))
%! assert (all (eq (...
%!    overlap (infsup (2.0, 2.0), infsup (3.0, 3.0)), ...
%!    "before")))
%! assert (all (eq (...
%!    overlap (infsup (2.0, 2.0), infsup (3.0, inf)), ...
%!    "before")))
%! assert (all (eq (...
%!    overlap (infsup (-inf, 2.0), infsup (2.0, 3.0)), ...
%!    "meets")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 2.0), infsup (2.0, 3.0)), ...
%!    "meets")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 2.0), infsup (2.0, inf)), ...
%!    "meets")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 2.0), infsup (1.5, 2.5)), ...
%!    "overlaps")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 2.0), infsup (1.0, inf)), ...
%!    "starts")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 2.0), infsup (1.0, 3.0)), ...
%!    "starts")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 1.0), infsup (1.0, 3.0)), ...
%!    "starts")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 2.0), infsup (-inf, inf)), ...
%!    "containedBy")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 2.0), infsup (-inf, 3.0)), ...
%!    "containedBy")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 2.0), infsup (0.0, 3.0)), ...
%!    "containedBy")))
%! assert (all (eq (...
%!    overlap (infsup (2.0, 2.0), infsup (0.0, 3.0)), ...
%!    "containedBy")))
%! assert (all (eq (...
%!    overlap (infsup (2.0, 2.0), infsup (0.0, inf)), ...
%!    "containedBy")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 2.0), infsup (-inf, 2.0)), ...
%!    "finishes")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 2.0), infsup (0.0, 2.0)), ...
%!    "finishes")))
%! assert (all (eq (...
%!    overlap (infsup (2.0, 2.0), infsup (0.0, 2.0)), ...
%!    "finishes")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 2.0), infsup (1.0, 2.0)), ...
%!    "equals")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 1.0), infsup (1.0, 1.0)), ...
%!    "equals")))
%! assert (all (eq (...
%!    overlap (infsup (-inf, 1.0), infsup (-inf, 1.0)), ...
%!    "equals")))
%! assert (all (eq (...
%!    overlap (infsup (-inf, inf), infsup (-inf, inf)), ...
%!    "equals")))
%! assert (all (eq (...
%!    overlap (infsup (3.0, 4.0), infsup (2.0, 2.0)), ...
%!    "after")))
%! assert (all (eq (...
%!    overlap (infsup (3.0, 4.0), infsup (1.0, 2.0)), ...
%!    "after")))
%! assert (all (eq (...
%!    overlap (infsup (3.0, 3.0), infsup (1.0, 2.0)), ...
%!    "after")))
%! assert (all (eq (...
%!    overlap (infsup (3.0, 3.0), infsup (2.0, 2.0)), ...
%!    "after")))
%! assert (all (eq (...
%!    overlap (infsup (3.0, inf), infsup (2.0, 2.0)), ...
%!    "after")))
%! assert (all (eq (...
%!    overlap (infsup (2.0, 3.0), infsup (1.0, 2.0)), ...
%!    "metBy")))
%! assert (all (eq (...
%!    overlap (infsup (2.0, 3.0), infsup (-inf, 2.0)), ...
%!    "metBy")))
%! assert (all (eq (...
%!    overlap (infsup (1.5, 2.5), infsup (1.0, 2.0)), ...
%!    "overlappedBy")))
%! assert (all (eq (...
%!    overlap (infsup (1.5, 2.5), infsup (-inf, 2.0)), ...
%!    "overlappedBy")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, inf), infsup (1.0, 2.0)), ...
%!    "startedBy")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 3.0), infsup (1.0, 2.0)), ...
%!    "startedBy")))
%! assert (all (eq (...
%!    overlap (infsup (1.0, 3.0), infsup (1.0, 1.0)), ...
%!    "startedBy")))
%! assert (all (eq (...
%!    overlap (infsup (-inf, 3.0), infsup (1.0, 2.0)), ...
%!    "contains")))
%! assert (all (eq (...
%!    overlap (infsup (-inf, inf), infsup (1.0, 2.0)), ...
%!    "contains")))
%! assert (all (eq (...
%!    overlap (infsup (0.0, 3.0), infsup (1.0, 2.0)), ...
%!    "contains")))
%! assert (all (eq (...
%!    overlap (infsup (0.0, 3.0), infsup (2.0, 2.0)), ...
%!    "contains")))
%! assert (all (eq (...
%!    overlap (infsup (-inf, 2.0), infsup (1.0, 2.0)), ...
%!    "finishedBy")))
%! assert (all (eq (...
%!    overlap (infsup (0.0, 2.0), infsup (1.0, 2.0)), ...
%!    "finishedBy")))
%! assert (all (eq (...
%!    overlap (infsup (0.0, 2.0), infsup (2.0, 2.0)), ...
%!    "finishedBy")))

%!test "minimal_overlap_dec_test";
%! assert (all (eq (...
%!    overlap (infsupdec (empty, "trv"), infsupdec (empty, "trv")), ...
%!    "bothEmpty")))
%! assert (all (eq (...
%!    overlap (infsupdec (empty, "trv"), infsupdec (1.0, 2.0, "com")), ...
%!    "firstEmpty")))
%! assert (all (eq (...
%!    overlap (infsupdec (1.0, 2.0, "def"), infsupdec (empty, "trv")), ...
%!    "secondEmpty")))
%! assert (all (eq (...
%!    overlap (infsupdec (2.0, 2.0, "def"), infsupdec (3.0, 4.0, "def")), ...
%!    "before")))
%! assert (all (eq (...
%!    overlap (infsupdec (1.0, 2.0, "dac"), infsupdec (3.0, 4.0, "com")), ...
%!    "before")))
%! assert (all (eq (...
%!    overlap (infsupdec (1.0, 2.0, "com"), infsupdec (3.0, 3.0, "trv")), ...
%!    "before")))
%! assert (all (eq (...
%!    overlap (infsupdec (2.0, 2.0, "trv"), infsupdec (3.0, 3.0, "def")), ...
%!    "before")))
%! assert (all (eq (...
%!    overlap (infsupdec (1.0, 2.0, "def"), infsupdec (2.0, 3.0, "def")), ...
%!    "meets")))
%! assert (all (eq (...
%!    overlap (infsupdec (1.0, 2.0, "dac"), infsupdec (1.5, 2.5, "def")), ...
%!    "overlaps")))
%! assert (all (eq (...
%!    overlap (infsupdec (1.0, 2.0, "def"), infsupdec (1.0, 3.0, "com")), ...
%!    "starts")))
%! assert (all (eq (...
%!    overlap (infsupdec (1.0, 1.0, "trv"), infsupdec (1.0, 3.0, "def")), ...
%!    "starts")))
%! assert (all (eq (...
%!    overlap (infsupdec (1.0, 2.0, "def"), infsupdec (0.0, 3.0, "dac")), ...
%!    "containedBy")))
%! assert (all (eq (...
%!    overlap (infsupdec (2.0, 2.0, "trv"), infsupdec (0.0, 3.0, "def")), ...
%!    "containedBy")))
%! assert (all (eq (...
%!    overlap (infsupdec (1.0, 2.0, "trv"), infsupdec (0.0, 2.0, "com")), ...
%!    "finishes")))
%! assert (all (eq (...
%!    overlap (infsupdec (2.0, 2.0, "def"), infsupdec (0.0, 2.0, "dac")), ...
%!    "finishes")))
%! assert (all (eq (...
%!    overlap (infsupdec (1.0, 2.0, "def"), infsupdec (1.0, 2.0, "def")), ...
%!    "equals")))
%! assert (all (eq (...
%!    overlap (infsupdec (1.0, 1.0, "dac"), infsupdec (1.0, 1.0, "dac")), ...
%!    "equals")))
%! assert (all (eq (...
%!    overlap (infsupdec (3.0, 4.0, "trv"), infsupdec (2.0, 2.0, "trv")), ...
%!    "after")))
%! assert (all (eq (...
%!    overlap (infsupdec (3.0, 4.0, "def"), infsupdec (1.0, 2.0, "def")), ...
%!    "after")))
%! assert (all (eq (...
%!    overlap (infsupdec (3.0, 3.0, "com"), infsupdec (1.0, 2.0, "dac")), ...
%!    "after")))
%! assert (all (eq (...
%!    overlap (infsupdec (3.0, 3.0, "def"), infsupdec (2.0, 2.0, "trv")), ...
%!    "after")))
%! assert (all (eq (...
%!    overlap (infsupdec (2.0, 3.0, "def"), infsupdec (1.0, 2.0, "trv")), ...
%!    "metBy")))
%! assert (all (eq (...
%!    overlap (infsupdec (1.5, 2.5, "com"), infsupdec (1.0, 2.0, "com")), ...
%!    "overlappedBy")))
%! assert (all (eq (...
%!    overlap (infsupdec (1.0, 3.0, "dac"), infsupdec (1.0, 2.0, "def")), ...
%!    "startedBy")))
%! assert (all (eq (...
%!    overlap (infsupdec (1.0, 3.0, "com"), infsupdec (1.0, 1.0, "dac")), ...
%!    "startedBy")))
%! assert (all (eq (...
%!    overlap (infsupdec (0.0, 3.0, "com"), infsupdec (1.0, 2.0, "dac")), ...
%!    "contains")))
%! assert (all (eq (...
%!    overlap (infsupdec (0.0, 3.0, "com"), infsupdec (2.0, 2.0, "def")), ...
%!    "contains")))
%! assert (all (eq (...
%!    overlap (infsupdec (0.0, 2.0, "def"), infsupdec (1.0, 2.0, "trv")), ...
%!    "finishedBy")))
%! assert (all (eq (...
%!    overlap (infsupdec (0.0, 2.0, "dac"), infsupdec (2.0, 2.0, "def")), ...
%!    "finishedBy")))
