##
## Copyright 2015 Oliver Heimlich
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
## 
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
## 
## You should have received a copy of the GNU General Public License
## along with this program; if not, see <http://www.gnu.org/licenses/>.
##
%! ## Test library imports
%!function s = to_string (x)
%!    if (isnumeric (x))
%!        s = num2str (x);
%!    elseif (isa (x, 'infsup'))
%!        s = intervaltotext (x);
%!    else
%!        # x probably is a char.
%!        s = x;
%!    endif
%!endfunction
%
%!function n = decval (dec)
%! n = find (strcmp (dec, {"ill", "trv", "def", "dac", "com"}));
%!endfunction

%!test "minimal.absRevBin_test";
%! assert (all (eq (...
%!    absrev (infsup (), infsup (-inf, inf)), ...
%!    infsup ())))
%! assert (all (eq (...
%!    absrev (infsup (0.0, 1.0), infsup ()), ...
%!    infsup ())))
%! assert (all (eq (...
%!    absrev (infsup (0.0, 1.0), infsup (7.0, 9.0)), ...
%!    infsup ())))
%! assert (all (eq (...
%!    absrev (infsup (), infsup (0.0, 1.0)), ...
%!    infsup ())))
%! assert (all (eq (...
%!    absrev (infsup (-2.0, -1.0), infsup (-inf, inf)), ...
%!    infsup ())))
%! assert (all (eq (...
%!    absrev (infsup (1.0, 1.0), infsup (-inf, inf)), ...
%!    infsup (-1.0, 1.0))))
%! assert (all (eq (...
%!    absrev (infsup (0.0, 0.0), infsup (-inf, inf)), ...
%!    infsup (0.0, 0.0))))
%! assert (all (eq (...
%!    absrev (infsup (-1.0, -1.0), infsup (-inf, inf)), ...
%!    infsup ())))
%! assert (all (eq (...
%!    absrev (infsup (1.797693134862315708e+308, 1.797693134862315708e+308), infsup (-inf, inf)), ...
%!    infsup (-1.797693134862315708e+308, 1.797693134862315708e+308))))
%! assert (all (eq (...
%!    absrev (infsup (2.225073858507201383e-308, 2.225073858507201383e-308), infsup (-inf, inf)), ...
%!    infsup (-2.225073858507201383e-308, 2.225073858507201383e-308))))
%! assert (all (eq (...
%!    absrev (infsup (-2.225073858507201383e-308, -2.225073858507201383e-308), infsup (-inf, inf)), ...
%!    infsup ())))
%! assert (all (eq (...
%!    absrev (infsup (-1.797693134862315708e+308, -1.797693134862315708e+308), infsup (-inf, inf)), ...
%!    infsup ())))
%! assert (all (eq (...
%!    absrev (infsup (1.0, 2.0), infsup (-inf, inf)), ...
%!    infsup (-2.0, 2.0))))
%! assert (all (eq (...
%!    absrev (infsup (1.0, 2.0), infsup (0.0, 2.0)), ...
%!    infsup (1.0, 2.0))))
%! assert (all (eq (...
%!    absrev (infsup (0.0, 1.0), infsup (-0.5, 2.0)), ...
%!    infsup (-0.5, 1.0))))
%! assert (all (eq (...
%!    absrev (infsup (-1.0, 1.0), infsup (-inf, inf)), ...
%!    infsup (-1.0, 1.0))))
%! assert (all (eq (...
%!    absrev (infsup (-1.0, 0.0), infsup (-inf, inf)), ...
%!    infsup (0.0, 0.0))))
%! assert (all (eq (...
%!    absrev (infsup (0.0, inf), infsup (-inf, inf)), ...
%!    infsup (-inf, inf))))
%! assert (all (eq (...
%!    absrev (infsup (-inf, inf), infsup (-inf, inf)), ...
%!    infsup (-inf, inf))))
%! assert (all (eq (...
%!    absrev (infsup (-inf, 0.0), infsup (-inf, inf)), ...
%!    infsup (0.0, 0.0))))
%! assert (all (eq (...
%!    absrev (infsup (1.0, inf), infsup (-inf, 0.0)), ...
%!    infsup (-inf, -1.0))))
%! assert (all (eq (...
%!    absrev (infsup (-1.0, inf), infsup (-inf, inf)), ...
%!    infsup (-inf, inf))))
%! assert (all (eq (...
%!    absrev (infsup (-inf, -1.0), infsup (-inf, inf)), ...
%!    infsup ())))
%! assert (all (eq (...
%!    absrev (infsup (-inf, 1.0), infsup (-inf, inf)), ...
%!    infsup (-1.0, 1.0))))
