##
## Copyright 2014
## 
## Marco Nehmeier (nehmeier@informatik.uni-wuerzburg.de)
## Maximilian Kiesner (maximilian.kiesner@stud-mail.uni-wuerzburg.de)
## 
## Department of Computer Science
## University of Wuerzburg, Germany
## 
## Licensed under the Apache License, Version 2.0 (the "License");
## you may not use this file except in compliance with the License.
## You may obtain a copy of the License at
## 
##     http://www.apache.org/licenses/LICENSE-2.0
## 
## Unless required by applicable law or agreed to in writing, software
## distributed under the License is distributed on an "AS IS" BASIS,
## WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
## See the License for the specific language governing permissions and
## limitations under the License.
##
%!test "minimal.pos_test";
%! assert (eq (...
%!         +infsup (1.0, 2.0), ...
%!         infsup (1.0, 2.0)))
%! assert (eq (...
%!         +infsup (), ...
%!         infsup ()))
%! assert (eq (...
%!         +infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         +infsup (1.0, inf), ...
%!         infsup (1.0, inf)))
%! assert (eq (...
%!         +infsup ((-inf), -1.0), ...
%!         infsup ((-inf), -1.0)))

%!test "minimal.neg_test";
%! assert (eq (...
%!         -infsup (1.0, 2.0), ...
%!         infsup (-2.0, -1.0)))
%! assert (eq (...
%!         -infsup (), ...
%!         infsup ()))
%! assert (eq (...
%!         -infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         -infsup (1.0, inf), ...
%!         infsup ((-inf), -1.0)))
%! assert (eq (...
%!         -infsup ((-inf), 1.0), ...
%!         infsup (-1.0, inf)))

%!test "minimal.add_test";
%! assert (eq (...
%!         infsup () + infsup (), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup (-1.0, 1.0) + infsup (), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup () + infsup (-1.0, 1.0), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup () + infsup (-inf, inf), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup (-inf, inf) + infsup (), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup (-inf, inf) + infsup ((-inf), 1.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) + infsup (-1.0, 1.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) + infsup (-1.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) + infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 1.0) + infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-1.0, 1.0) + infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-1.0, inf) + infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 2.0) + infsup ((-inf), 4.0), ...
%!         infsup ((-inf), 6.0)))
%! assert (eq (...
%!         infsup ((-inf), 2.0) + infsup (3.0, 4.0), ...
%!         infsup ((-inf), 6.0)))
%! assert (eq (...
%!         infsup ((-inf), 2.0) + infsup (3.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (1.0, 2.0) + infsup ((-inf), 4.0), ...
%!         infsup ((-inf), 6.0)))
%! assert (eq (...
%!         infsup (1.0, 2.0) + infsup (3.0, 4.0), ...
%!         infsup (4.0, 6.0)))
%! assert (eq (...
%!         infsup (1.0, 2.0) + infsup (3.0, inf), ...
%!         infsup (4.0, inf)))
%! assert (eq (...
%!         infsup (1.0, inf) + infsup ((-inf), 4.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (1.0, inf) + infsup (3.0, 4.0), ...
%!         infsup (4.0, inf)))
%! assert (eq (...
%!         infsup (1.0, inf) + infsup (3.0, inf), ...
%!         infsup (4.0, inf)))

%!test "minimal.sub_test";
%! assert (eq (...
%!         infsup () - infsup (), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup (-1.0, 1.0) - infsup (), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup () - infsup (-1.0, 1.0), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup () - infsup (-inf, inf), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup (-inf, inf) - infsup (), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup (-inf, inf) - infsup ((-inf), 1.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) - infsup (-1.0, 1.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) - infsup (-1.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) - infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 1.0) - infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-1.0, 1.0) - infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-1.0, inf) - infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 2.0) - infsup ((-inf), 4.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 2.0) - infsup (3.0, 4.0), ...
%!         infsup ((-inf), -1.0)))
%! assert (eq (...
%!         infsup ((-inf), 2.0) - infsup (3.0, inf), ...
%!         infsup ((-inf), -1.0)))
%! assert (eq (...
%!         infsup (1.0, 2.0) - infsup ((-inf), 4.0), ...
%!         infsup (-3.0, inf)))
%! assert (eq (...
%!         infsup (1.0, 2.0) - infsup (3.0, 4.0), ...
%!         infsup (-3.0, -1.0)))
%! assert (eq (...
%!         infsup (1.0, 2.0) - infsup (3.0, inf), ...
%!         infsup ((-inf), -1.0)))
%! assert (eq (...
%!         infsup (1.0, inf) - infsup ((-inf), 4.0), ...
%!         infsup (-3.0, inf)))
%! assert (eq (...
%!         infsup (1.0, inf) - infsup (3.0, 4.0), ...
%!         infsup (-3.0, inf)))
%! assert (eq (...
%!         infsup (1.0, inf) - infsup (3.0, inf), ...
%!         infsup (-inf, inf)))

%!test "minimal.mul_test";
%! assert (eq (...
%!         infsup () .* infsup (), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup (-1.0, 1.0) .* infsup (), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup () .* infsup (-1.0, 1.0), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup () .* infsup (-inf, inf), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup (-inf, inf) .* infsup (), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup (-inf, inf) .* infsup (-5.0, -1.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) .* infsup (-5.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) .* infsup (1.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) .* infsup ((-inf), -1.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) .* infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) .* infsup (-5.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) .* infsup (1.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) .* infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (1.0, inf) .* infsup (-5.0, -1.0), ...
%!         infsup ((-inf), -1.0)))
%! assert (eq (...
%!         infsup (1.0, inf) .* infsup (-5.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (1.0, inf) .* infsup (1.0, 3.0), ...
%!         infsup (1.0, inf)))
%! assert (eq (...
%!         infsup (1.0, inf) .* infsup ((-inf), -1.0), ...
%!         infsup ((-inf), -1.0)))
%! assert (eq (...
%!         infsup (1.0, inf) .* infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (1.0, inf) .* infsup (-5.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (1.0, inf) .* infsup (1.0, inf), ...
%!         infsup (1.0, inf)))
%! assert (eq (...
%!         infsup (1.0, inf) .* infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-1.0, inf) .* infsup (-5.0, -1.0), ...
%!         infsup ((-inf), 5.0)))
%! assert (eq (...
%!         infsup (-1.0, inf) .* infsup (-5.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-1.0, inf) .* infsup (1.0, 3.0), ...
%!         infsup (-3.0, inf)))
%! assert (eq (...
%!         infsup (-1.0, inf) .* infsup ((-inf), -1.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-1.0, inf) .* infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-1.0, inf) .* infsup (-5.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-1.0, inf) .* infsup (1.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-1.0, inf) .* infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 3.0) .* infsup (-5.0, -1.0), ...
%!         infsup (-15.0, inf)))
%! assert (eq (...
%!         infsup ((-inf), 3.0) .* infsup (-5.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 3.0) .* infsup (1.0, 3.0), ...
%!         infsup ((-inf), 9.0)))
%! assert (eq (...
%!         infsup ((-inf), 3.0) .* infsup ((-inf), -1.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 3.0) .* infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 3.0) .* infsup (-5.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 3.0) .* infsup (1.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 3.0) .* infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), -3.0) .* infsup (-5.0, -1.0), ...
%!         infsup (3.0, inf)))
%! assert (eq (...
%!         infsup ((-inf), -3.0) .* infsup (-5.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), -3.0) .* infsup (1.0, 3.0), ...
%!         infsup ((-inf), -3.0)))
%! assert (eq (...
%!         infsup ((-inf), -3.0) .* infsup ((-inf), -1.0), ...
%!         infsup (3.0, inf)))
%! assert (eq (...
%!         infsup ((-inf), -3.0) .* infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), -3.0) .* infsup (-5.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), -3.0) .* infsup (1.0, inf), ...
%!         infsup ((-inf), -3.0)))
%! assert (eq (...
%!         infsup ((-inf), -3.0) .* infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (1.0, 5.0) .* infsup (-5.0, -1.0), ...
%!         infsup (-25.0, -1.0)))
%! assert (eq (...
%!         infsup (1.0, 5.0) .* infsup (-5.0, 3.0), ...
%!         infsup (-25.0, 15.0)))
%! assert (eq (...
%!         infsup (1.0, 5.0) .* infsup (1.0, 3.0), ...
%!         infsup (1.0, 15.0)))
%! assert (eq (...
%!         infsup (1.0, 5.0) .* infsup ((-inf), -1.0), ...
%!         infsup ((-inf), -1.0)))
%! assert (eq (...
%!         infsup (1.0, 5.0) .* infsup ((-inf), 3.0), ...
%!         infsup ((-inf), 15.0)))
%! assert (eq (...
%!         infsup (1.0, 5.0) .* infsup (-5.0, inf), ...
%!         infsup (-25.0, inf)))
%! assert (eq (...
%!         infsup (1.0, 5.0) .* infsup (1.0, inf), ...
%!         infsup (1.0, inf)))
%! assert (eq (...
%!         infsup (1.0, 5.0) .* infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-1.0, 5.0) .* infsup (-5.0, -1.0), ...
%!         infsup (-25.0, 5.0)))
%! assert (eq (...
%!         infsup (-1.0, 5.0) .* infsup (-5.0, 3.0), ...
%!         infsup (-25.0, 15.0)))
%! assert (eq (...
%!         infsup (-10.0, 2.0) .* infsup (-5.0, 3.0), ...
%!         infsup (-30.0, 50.0)))
%! assert (eq (...
%!         infsup (-1.0, 5.0) .* infsup (-1.0, 10.0), ...
%!         infsup (-10.0, 50.0)))
%! assert (eq (...
%!         infsup (-2.0, 2.0) .* infsup (-5.0, 3.0), ...
%!         infsup (-10.0, 10.0)))
%! assert (eq (...
%!         infsup (-1.0, 5.0) .* infsup (1.0, 3.0), ...
%!         infsup (-3.0, 15.0)))
%! assert (eq (...
%!         infsup (-1.0, 5.0) .* infsup ((-inf), -1.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-1.0, 5.0) .* infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-1.0, 5.0) .* infsup (-5.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-1.0, 5.0) .* infsup (1.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-1.0, 5.0) .* infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-10.0, -5.0) .* infsup (-5.0, -1.0), ...
%!         infsup (5.0, 50.0)))
%! assert (eq (...
%!         infsup (-10.0, -5.0) .* infsup (-5.0, 3.0), ...
%!         infsup (-30.0, 50.0)))
%! assert (eq (...
%!         infsup (-10.0, -5.0) .* infsup (1.0, 3.0), ...
%!         infsup (-30.0, -5.0)))
%! assert (eq (...
%!         infsup (-10.0, -5.0) .* infsup ((-inf), -1.0), ...
%!         infsup (5.0, inf)))
%! assert (eq (...
%!         infsup (-10.0, -5.0) .* infsup ((-inf), 3.0), ...
%!         infsup (-30.0, inf)))
%! assert (eq (...
%!         infsup (-10.0, -5.0) .* infsup (-5.0, inf), ...
%!         infsup ((-inf), 50.0)))
%! assert (eq (...
%!         infsup (-10.0, -5.0) .* infsup (1.0, inf), ...
%!         infsup ((-inf), -5.0)))
%! assert (eq (...
%!         infsup (-10.0, -5.0) .* infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ("0X1.999999999999AP-4", "0X1.FFFFFFFFFFFFP+0") .* infsup ("-0X1.FFFFFFFFFFFFP+0", inf), ...
%!         infsup ("-0X1.FFFFFFFFFFFE1P+1", inf)))
%! assert (eq (...
%!         infsup ("-0X1.999999999999AP-4", "0X1.FFFFFFFFFFFFP+0") .* infsup ("-0X1.FFFFFFFFFFFFP+0", "-0X1.999999999999AP-4"), ...
%!         infsup ("-0X1.FFFFFFFFFFFE1P+1", "0X1.999999999998EP-3")))
%! assert (eq (...
%!         infsup ("-0X1.999999999999AP-4", "0X1.999999999999AP-4") .* infsup ("-0X1.FFFFFFFFFFFFP+0", "0X1.999999999999AP-4"), ...
%!         infsup ("-0X1.999999999998EP-3", "0X1.999999999998EP-3")))
%! assert (eq (...
%!         infsup ("-0X1.FFFFFFFFFFFFP+0", "-0X1.999999999999AP-4") .* infsup ("0X1.999999999999AP-4", "0X1.FFFFFFFFFFFFP+0"), ...
%!         infsup ("-0X1.FFFFFFFFFFFE1P+1", "-0X1.47AE147AE147BP-7")))

%!test "minimal.div_test";
%! assert (eq (...
%!         infsup () ./ infsup (), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup (-1.0, 1.0) ./ infsup (), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup () ./ infsup (-1.0, 1.0), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup () ./ infsup (0.1, 1.0), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup () ./ infsup (-1.0, -0.1), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup () ./ infsup (-inf, inf), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup (-inf, inf) ./ infsup (), ...
%!         infsup ()))
%! assert (eq (...
%!         infsup (-inf, inf) ./ infsup (-5.0, -3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) ./ infsup (3.0, 5.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) ./ infsup ((-inf), -3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) ./ infsup (3.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) ./ infsup (-3.0, 0.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) ./ infsup (-3.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) ./ infsup (0.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) ./ infsup ((-inf), 0.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) ./ infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) ./ infsup (-3.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) ./ infsup (0.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-inf, inf) ./ infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-30.0, -15.0) ./ infsup (-5.0, -3.0), ...
%!         infsup (3.0, 10.0)))
%! assert (eq (...
%!         infsup (-30.0, -15.0) ./ infsup (3.0, 5.0), ...
%!         infsup (-10.0, -3.0)))
%! assert (eq (...
%!         infsup (-30.0, -15.0) ./ infsup ((-inf), -3.0), ...
%!         infsup (0.0, 10.0)))
%! assert (eq (...
%!         infsup (-30.0, -15.0) ./ infsup (3.0, inf), ...
%!         infsup (-10.0, 0.0)))
%! assert (eq (...
%!         infsup (-30.0, -15.0) ./ infsup (-3.0, 0.0), ...
%!         infsup (5.0, inf)))
%! assert (eq (...
%!         infsup (-30.0, -15.0) ./ infsup (-3.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-30.0, -15.0) ./ infsup (0.0, 3.0), ...
%!         infsup ((-inf), -5.0)))
%! assert (eq (...
%!         infsup (-30.0, -15.0) ./ infsup ((-inf), 0.0), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup (-30.0, -15.0) ./ infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-30.0, -15.0) ./ infsup (-3.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-30.0, -15.0) ./ infsup (0.0, inf), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup (-30.0, -15.0) ./ infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-30.0, 15.0) ./ infsup (-5.0, -3.0), ...
%!         infsup (-5.0, 10.0)))
%! assert (eq (...
%!         infsup (-30.0, 15.0) ./ infsup (3.0, 5.0), ...
%!         infsup (-10.0, 5.0)))
%! assert (eq (...
%!         infsup (-30.0, 15.0) ./ infsup ((-inf), -3.0), ...
%!         infsup (-5.0, 10.0)))
%! assert (eq (...
%!         infsup (-30.0, 15.0) ./ infsup (3.0, inf), ...
%!         infsup (-10.0, 5.0)))
%! assert (eq (...
%!         infsup (-30.0, 15.0) ./ infsup (-3.0, 0.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-30.0, 15.0) ./ infsup (-3.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-30.0, 15.0) ./ infsup (0.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-30.0, 15.0) ./ infsup ((-inf), 0.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-30.0, 15.0) ./ infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-30.0, 15.0) ./ infsup (-3.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-30.0, 15.0) ./ infsup (0.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-30.0, 15.0) ./ infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (15.0, 30.0) ./ infsup (-5.0, -3.0), ...
%!         infsup (-10.0, -3.0)))
%! assert (eq (...
%!         infsup (15.0, 30.0) ./ infsup (3.0, 5.0), ...
%!         infsup (3.0, 10.0)))
%! assert (eq (...
%!         infsup (15.0, 30.0) ./ infsup ((-inf), -3.0), ...
%!         infsup (-10.0, 0.0)))
%! assert (eq (...
%!         infsup (15.0, 30.0) ./ infsup (3.0, inf), ...
%!         infsup (0.0, 10.0)))
%! assert (eq (...
%!         infsup (15.0, 30.0) ./ infsup (-3.0, 0.0), ...
%!         infsup ((-inf), -5.0)))
%! assert (eq (...
%!         infsup (15.0, 30.0) ./ infsup (-3.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (15.0, 30.0) ./ infsup (0.0, 3.0), ...
%!         infsup (5.0, inf)))
%! assert (eq (...
%!         infsup (15.0, 30.0) ./ infsup ((-inf), 0.0), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup (15.0, 30.0) ./ infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (15.0, 30.0) ./ infsup (-3.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (15.0, 30.0) ./ infsup (0.0, inf), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup (15.0, 30.0) ./ infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), -15.0) ./ infsup (-5.0, -3.0), ...
%!         infsup (3.0, inf)))
%! assert (eq (...
%!         infsup ((-inf), -15.0) ./ infsup (3.0, 5.0), ...
%!         infsup ((-inf), -3.0)))
%! assert (eq (...
%!         infsup ((-inf), -15.0) ./ infsup ((-inf), -3.0), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup ((-inf), -15.0) ./ infsup (3.0, inf), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup ((-inf), -15.0) ./ infsup (-3.0, 0.0), ...
%!         infsup (5.0, inf)))
%! assert (eq (...
%!         infsup ((-inf), -15.0) ./ infsup (-3.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), -15.0) ./ infsup (0.0, 3.0), ...
%!         infsup ((-inf), -5.0)))
%! assert (eq (...
%!         infsup ((-inf), -15.0) ./ infsup ((-inf), 0.0), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup ((-inf), -15.0) ./ infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), -15.0) ./ infsup (-3.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), -15.0) ./ infsup (0.0, inf), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup ((-inf), -15.0) ./ infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 15.0) ./ infsup (-5.0, -3.0), ...
%!         infsup (-5.0, inf)))
%! assert (eq (...
%!         infsup ((-inf), 15.0) ./ infsup (3.0, 5.0), ...
%!         infsup ((-inf), 5.0)))
%! assert (eq (...
%!         infsup ((-inf), 15.0) ./ infsup ((-inf), -3.0), ...
%!         infsup (-5.0, inf)))
%! assert (eq (...
%!         infsup ((-inf), 15.0) ./ infsup (3.0, inf), ...
%!         infsup ((-inf), 5.0)))
%! assert (eq (...
%!         infsup ((-inf), 15.0) ./ infsup (-3.0, 0.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 15.0) ./ infsup (-3.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 15.0) ./ infsup (0.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 15.0) ./ infsup ((-inf), 0.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 15.0) ./ infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 15.0) ./ infsup (-3.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 15.0) ./ infsup (0.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 15.0) ./ infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-15.0, inf) ./ infsup (-5.0, -3.0), ...
%!         infsup ((-inf), 5.0)))
%! assert (eq (...
%!         infsup (-15.0, inf) ./ infsup (3.0, 5.0), ...
%!         infsup (-5.0, inf)))
%! assert (eq (...
%!         infsup (-15.0, inf) ./ infsup ((-inf), -3.0), ...
%!         infsup ((-inf), 5.0)))
%! assert (eq (...
%!         infsup (-15.0, inf) ./ infsup (3.0, inf), ...
%!         infsup (-5.0, inf)))
%! assert (eq (...
%!         infsup (-15.0, inf) ./ infsup (-3.0, 0.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-15.0, inf) ./ infsup (-3.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-15.0, inf) ./ infsup (0.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-15.0, inf) ./ infsup ((-inf), 0.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-15.0, inf) ./ infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-15.0, inf) ./ infsup (-3.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-15.0, inf) ./ infsup (0.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-15.0, inf) ./ infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (15.0, inf) ./ infsup (-5.0, -3.0), ...
%!         infsup ((-inf), -3.0)))
%! assert (eq (...
%!         infsup (15.0, inf) ./ infsup (3.0, 5.0), ...
%!         infsup (3.0, inf)))
%! assert (eq (...
%!         infsup (15.0, inf) ./ infsup ((-inf), -3.0), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup (15.0, inf) ./ infsup (3.0, inf), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup (15.0, inf) ./ infsup (-3.0, 0.0), ...
%!         infsup ((-inf), -5.0)))
%! assert (eq (...
%!         infsup (15.0, inf) ./ infsup (-3.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (15.0, inf) ./ infsup (0.0, 3.0), ...
%!         infsup (5.0, inf)))
%! assert (eq (...
%!         infsup (15.0, inf) ./ infsup ((-inf), 0.0), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup (15.0, inf) ./ infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (15.0, inf) ./ infsup (-3.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (15.0, inf) ./ infsup (0.0, inf), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup (15.0, inf) ./ infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-30.0, 0.0) ./ infsup (-5.0, -3.0), ...
%!         infsup (0.0, 10.0)))
%! assert (eq (...
%!         infsup (-30.0, 0.0) ./ infsup (3.0, 5.0), ...
%!         infsup (-10.0, 0.0)))
%! assert (eq (...
%!         infsup (-30.0, 0.0) ./ infsup ((-inf), -3.0), ...
%!         infsup (0.0, 10.0)))
%! assert (eq (...
%!         infsup (-30.0, 0.0) ./ infsup (3.0, inf), ...
%!         infsup (-10.0, 0.0)))
%! assert (eq (...
%!         infsup (-30.0, 0.0) ./ infsup (-3.0, 0.0), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup (-30.0, 0.0) ./ infsup (-3.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-30.0, 0.0) ./ infsup (0.0, 3.0), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup (-30.0, 0.0) ./ infsup ((-inf), 0.0), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup (-30.0, 0.0) ./ infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-30.0, 0.0) ./ infsup (-3.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-30.0, 0.0) ./ infsup (0.0, inf), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup (-30.0, 0.0) ./ infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (0.0, 30.0) ./ infsup (-5.0, -3.0), ...
%!         infsup (-10.0, 0.0)))
%! assert (eq (...
%!         infsup (0.0, 30.0) ./ infsup (3.0, 5.0), ...
%!         infsup (0.0, 10.0)))
%! assert (eq (...
%!         infsup (0.0, 30.0) ./ infsup ((-inf), -3.0), ...
%!         infsup (-10.0, 0.0)))
%! assert (eq (...
%!         infsup (0.0, 30.0) ./ infsup (3.0, inf), ...
%!         infsup (0.0, 10.0)))
%! assert (eq (...
%!         infsup (0.0, 30.0) ./ infsup (-3.0, 0.0), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup (0.0, 30.0) ./ infsup (-3.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (0.0, 30.0) ./ infsup (0.0, 3.0), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup (0.0, 30.0) ./ infsup ((-inf), 0.0), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup (0.0, 30.0) ./ infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (0.0, 30.0) ./ infsup (-3.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (0.0, 30.0) ./ infsup (0.0, inf), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup (0.0, 30.0) ./ infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 0.0) ./ infsup (-5.0, -3.0), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup ((-inf), 0.0) ./ infsup (3.0, 5.0), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup ((-inf), 0.0) ./ infsup ((-inf), -3.0), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup ((-inf), 0.0) ./ infsup (3.0, inf), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup ((-inf), 0.0) ./ infsup (-3.0, 0.0), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup ((-inf), 0.0) ./ infsup (-3.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 0.0) ./ infsup (0.0, 3.0), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup ((-inf), 0.0) ./ infsup ((-inf), 0.0), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup ((-inf), 0.0) ./ infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 0.0) ./ infsup (-3.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup ((-inf), 0.0) ./ infsup (0.0, inf), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup ((-inf), 0.0) ./ infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (0.0, inf) ./ infsup (-5.0, -3.0), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup (0.0, inf) ./ infsup (3.0, 5.0), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup (0.0, inf) ./ infsup ((-inf), -3.0), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup (0.0, inf) ./ infsup (3.0, inf), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup (0.0, inf) ./ infsup (-3.0, 0.0), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup (0.0, inf) ./ infsup (-3.0, 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (0.0, inf) ./ infsup (0.0, 3.0), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup (0.0, inf) ./ infsup ((-inf), 0.0), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         infsup (0.0, inf) ./ infsup ((-inf), 3.0), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (0.0, inf) ./ infsup (-3.0, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (0.0, inf) ./ infsup (0.0, inf), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         infsup (0.0, inf) ./ infsup (-inf, inf), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         infsup (-2.0, -1.0) ./ infsup (-10.0, -3.0), ...
%!         infsup ("0X1.9999999999999P-4", "0X1.5555555555556P-1")))
%! assert (eq (...
%!         infsup (-2.0, -1.0) ./ infsup (0.0, 10.0), ...
%!         infsup ((-inf), "-0X1.9999999999999P-4")))
%! assert (eq (...
%!         infsup (-1.0, 2.0) ./ infsup (10.0, inf), ...
%!         infsup ("-0X1.999999999999AP-4", "0X1.999999999999AP-3")))
%! assert (eq (...
%!         infsup (1.0, 3.0) ./ infsup ((-inf), -10.0), ...
%!         infsup ("-0X1.3333333333334P-2", 0.0)))
%! assert (eq (...
%!         infsup ((-inf), -1.0) ./ infsup (1.0, 3.0), ...
%!         infsup ((-inf), "-0X1.5555555555555P-2")))

%!test "minimal.recip_test";
%! assert (eq (...
%!         inv (infsup (-50.0, -10.0)), ...
%!         infsup ("-0X1.999999999999AP-4", "-0X1.47AE147AE147AP-6")))
%! assert (eq (...
%!         inv (infsup (10.0, 50.0)), ...
%!         infsup ("0X1.47AE147AE147AP-6", "0X1.999999999999AP-4")))
%! assert (eq (...
%!         inv (infsup ((-inf), -10.0)), ...
%!         infsup ("-0X1.999999999999AP-4", 0.0)))
%! assert (eq (...
%!         inv (infsup (10.0, inf)), ...
%!         infsup (0.0, "0X1.999999999999AP-4")))
%! assert (eq (...
%!         inv (infsup (-10.0, 0.0)), ...
%!         infsup ((-inf), "-0X1.9999999999999P-4")))
%! assert (eq (...
%!         inv (infsup (-10.0, 10.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         inv (infsup (0.0, 10.0)), ...
%!         infsup ("0X1.9999999999999P-4", inf)))
%! assert (eq (...
%!         inv (infsup ((-inf), 0.0)), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         inv (infsup ((-inf), 10.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         inv (infsup (-10.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         inv (infsup (0.0, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         inv (infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))

%!test "minimal.sqr_test";
%! assert (eq (...
%!         sqr (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         sqr (infsup (-inf, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         sqr (infsup (-1.0, 1.0)), ...
%!         infsup (0.0, 1.0)))
%! assert (eq (...
%!         sqr (infsup (-5.0, 3.0)), ...
%!         infsup (0.0, 25.0)))
%! assert (eq (...
%!         sqr (infsup ("-0X1.FFFFFFFFFFFFP+0", "0X1.999999999999AP-4")), ...
%!         infsup (0.0, "0X1.FFFFFFFFFFFE1P+1")))

%!test "minimal.sqrt_test";
%! assert (eq (...
%!         sqrt (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         sqrt (infsup (-inf, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         sqrt (infsup (-1.0, 1.0)), ...
%!         infsup (0.0, 1.0)))
%! assert (eq (...
%!         sqrt (infsup (-5.0, 25.0)), ...
%!         infsup (0.0, 5.0)))
%! assert (eq (...
%!         sqrt (infsup (-5.0, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         sqrt (infsup ("-0X1.FFFFFFFFFFFFP+0", "0X1.999999999999AP-4")), ...
%!         infsup (0.0, "0X1.43D136248491P-2")))
%! assert (eq (...
%!         sqrt (infsup ("0X1.999999999999AP-4", "0X1.FFFFFFFFFFFFP+0")), ...
%!         infsup ("0X1.43D136248490FP-2", "0X1.6A09E667F3BC7P+0")))

%!test "minimal.fma_test";
%! assert (eq (...
%!         fma (infsup (), infsup (), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, 1.0), infsup (), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (), infsup (-1.0, 1.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (), infsup (-inf, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-5.0, -1.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-5.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (1.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup ((-inf), -1.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup ((-inf), 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-5.0, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (1.0, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-inf, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-5.0, -1.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-5.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (1.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup ((-inf), -1.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup ((-inf), 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-5.0, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (1.0, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-inf, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-5.0, -1.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-5.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (1.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup ((-inf), -1.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup ((-inf), 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-5.0, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (1.0, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-inf, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-5.0, -1.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-5.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (1.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup ((-inf), -1.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup ((-inf), 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-5.0, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (1.0, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-inf, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-5.0, -1.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-5.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (1.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup ((-inf), -1.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup ((-inf), 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-5.0, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (1.0, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-inf, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-5.0, -1.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-5.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (1.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup ((-inf), -1.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup ((-inf), 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-5.0, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (1.0, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-inf, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-5.0, -1.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-5.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-10.0, 2.0), infsup (-5.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-1.0, 10.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-2.0, 2.0), infsup (-5.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (1.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup ((-inf), -1.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup ((-inf), 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-5.0, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (1.0, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-inf, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-5.0, -1.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-5.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (1.0, 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup ((-inf), -1.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup ((-inf), 3.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-5.0, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (1.0, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-inf, inf), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (), infsup (), infsup ((-inf), 2.0)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, 1.0), infsup (), infsup ((-inf), 2.0)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (), infsup (-1.0, 1.0), infsup ((-inf), 2.0)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (), infsup (-inf, inf), infsup ((-inf), 2.0)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (), infsup ((-inf), 2.0)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-5.0, -1.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-5.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (1.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup ((-inf), -1.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup ((-inf), 3.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-5.0, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (1.0, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-inf, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-5.0, -1.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 1.0)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-5.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (1.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup ((-inf), -1.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 1.0)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup ((-inf), 3.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-5.0, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (1.0, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-inf, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-5.0, -1.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 7.0)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-5.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (1.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup ((-inf), -1.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup ((-inf), 3.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-5.0, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (1.0, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-inf, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-5.0, -1.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-5.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (1.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 11.0)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup ((-inf), -1.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup ((-inf), 3.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-5.0, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (1.0, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-inf, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-5.0, -1.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-5.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (1.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), -1.0)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup ((-inf), -1.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup ((-inf), 3.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-5.0, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (1.0, inf), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), -1.0)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-inf, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-5.0, -1.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 1.0)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-5.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 17.0)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (1.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 17.0)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup ((-inf), -1.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 1.0)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup ((-inf), 3.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 17.0)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-5.0, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (1.0, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-inf, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-5.0, -1.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 7.0)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-5.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 17.0)))
%! assert (eq (...
%!         fma (infsup (-10.0, 2.0), infsup (-5.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 52.0)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-1.0, 10.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 52.0)))
%! assert (eq (...
%!         fma (infsup (-2.0, 2.0), infsup (-5.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 12.0)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (1.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 17.0)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup ((-inf), -1.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup ((-inf), 3.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-5.0, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (1.0, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-inf, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-5.0, -1.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 52.0)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-5.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 52.0)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (1.0, 3.0), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), -3.0)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup ((-inf), -1.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup ((-inf), 3.0), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-5.0, inf), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), 52.0)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (1.0, inf), infsup ((-inf), 2.0)), ...
%!         infsup ((-inf), -3.0)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-inf, inf), infsup ((-inf), 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (), infsup (), infsup (-2.0, 2.0)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, 1.0), infsup (), infsup (-2.0, 2.0)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (), infsup (-1.0, 1.0), infsup (-2.0, 2.0)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (), infsup (-inf, inf), infsup (-2.0, 2.0)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (), infsup (-2.0, 2.0)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-5.0, -1.0), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-5.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (1.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup ((-inf), -1.0), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup ((-inf), 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-5.0, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (1.0, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-inf, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-5.0, -1.0), infsup (-2.0, 2.0)), ...
%!         infsup ((-inf), 1.0)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-5.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (1.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-1.0, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup ((-inf), -1.0), infsup (-2.0, 2.0)), ...
%!         infsup ((-inf), 1.0)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup ((-inf), 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-5.0, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (1.0, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-1.0, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-inf, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-5.0, -1.0), infsup (-2.0, 2.0)), ...
%!         infsup ((-inf), 7.0)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-5.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (1.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-5.0, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup ((-inf), -1.0), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup ((-inf), 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-5.0, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (1.0, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-inf, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-5.0, -1.0), infsup (-2.0, 2.0)), ...
%!         infsup (-17.0, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-5.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (1.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup ((-inf), 11.0)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup ((-inf), -1.0), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup ((-inf), 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-5.0, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (1.0, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-inf, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-5.0, -1.0), infsup (-2.0, 2.0)), ...
%!         infsup (1.0, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-5.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (1.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup ((-inf), -1.0)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup ((-inf), -1.0), infsup (-2.0, 2.0)), ...
%!         infsup (1.0, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup ((-inf), 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-5.0, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (1.0, inf), infsup (-2.0, 2.0)), ...
%!         infsup ((-inf), -1.0)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-inf, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-5.0, -1.0), infsup (-2.0, 2.0)), ...
%!         infsup (-27.0, 1.0)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-5.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-27.0, 17.0)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (1.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-1.0, 17.0)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup ((-inf), -1.0), infsup (-2.0, 2.0)), ...
%!         infsup ((-inf), 1.0)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup ((-inf), 3.0), infsup (-2.0, 2.0)), ...
%!         infsup ((-inf), 17.0)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-5.0, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-27.0, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (1.0, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-1.0, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-inf, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-5.0, -1.0), infsup (-2.0, 2.0)), ...
%!         infsup (-27.0, 7.0)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-5.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-27.0, 17.0)))
%! assert (eq (...
%!         fma (infsup (-10.0, 2.0), infsup (-5.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-32.0, 52.0)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-1.0, 10.0), infsup (-2.0, 2.0)), ...
%!         infsup (-12.0, 52.0)))
%! assert (eq (...
%!         fma (infsup (-2.0, 2.0), infsup (-5.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-12.0, 12.0)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (1.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-5.0, 17.0)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup ((-inf), -1.0), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup ((-inf), 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-5.0, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (1.0, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-inf, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-5.0, -1.0), infsup (-2.0, 2.0)), ...
%!         infsup (3.0, 52.0)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-5.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-32.0, 52.0)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (1.0, 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-32.0, -3.0)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup ((-inf), -1.0), infsup (-2.0, 2.0)), ...
%!         infsup (3.0, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup ((-inf), 3.0), infsup (-2.0, 2.0)), ...
%!         infsup (-32.0, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-5.0, inf), infsup (-2.0, 2.0)), ...
%!         infsup ((-inf), 52.0)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (1.0, inf), infsup (-2.0, 2.0)), ...
%!         infsup ((-inf), -3.0)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-inf, inf), infsup (-2.0, 2.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (), infsup (), infsup (-2.0, inf)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, 1.0), infsup (), infsup (-2.0, inf)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (), infsup (-1.0, 1.0), infsup (-2.0, inf)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (), infsup (-inf, inf), infsup (-2.0, inf)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (), infsup (-2.0, inf)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-5.0, -1.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-5.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (1.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup ((-inf), -1.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup ((-inf), 3.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-5.0, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (1.0, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-inf, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-5.0, -1.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-5.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (1.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-1.0, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup ((-inf), -1.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup ((-inf), 3.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-5.0, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (1.0, inf), infsup (-2.0, inf)), ...
%!         infsup (-1.0, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-inf, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-5.0, -1.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-5.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (1.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-5.0, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup ((-inf), -1.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup ((-inf), 3.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-5.0, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (1.0, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-inf, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-5.0, -1.0), infsup (-2.0, inf)), ...
%!         infsup (-17.0, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-5.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (1.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup ((-inf), -1.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup ((-inf), 3.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-5.0, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (1.0, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-inf, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-5.0, -1.0), infsup (-2.0, inf)), ...
%!         infsup (1.0, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-5.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (1.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup ((-inf), -1.0), infsup (-2.0, inf)), ...
%!         infsup (1.0, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup ((-inf), 3.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-5.0, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (1.0, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-inf, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-5.0, -1.0), infsup (-2.0, inf)), ...
%!         infsup (-27.0, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-5.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-27.0, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (1.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-1.0, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup ((-inf), -1.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup ((-inf), 3.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-5.0, inf), infsup (-2.0, inf)), ...
%!         infsup (-27.0, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (1.0, inf), infsup (-2.0, inf)), ...
%!         infsup (-1.0, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-inf, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-5.0, -1.0), infsup (-2.0, inf)), ...
%!         infsup (-27.0, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-5.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-27.0, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, 2.0), infsup (-5.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-32.0, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-1.0, 10.0), infsup (-2.0, inf)), ...
%!         infsup (-12.0, inf)))
%! assert (eq (...
%!         fma (infsup (-2.0, 2.0), infsup (-5.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-12.0, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (1.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-5.0, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup ((-inf), -1.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup ((-inf), 3.0), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-5.0, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (1.0, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-inf, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-5.0, -1.0), infsup (-2.0, inf)), ...
%!         infsup (3.0, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-5.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-32.0, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (1.0, 3.0), infsup (-2.0, inf)), ...
%!         infsup (-32.0, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup ((-inf), -1.0), infsup (-2.0, inf)), ...
%!         infsup (3.0, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup ((-inf), 3.0), infsup (-2.0, inf)), ...
%!         infsup (-32.0, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-5.0, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (1.0, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-inf, inf), infsup (-2.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (), infsup (), infsup (-inf, inf)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-1.0, 1.0), infsup (), infsup (-inf, inf)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (), infsup (-1.0, 1.0), infsup (-inf, inf)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (), infsup (-inf, inf), infsup (-inf, inf)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (), infsup (-inf, inf)), ...
%!         infsup ()))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-5.0, -1.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-5.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (1.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup ((-inf), -1.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup ((-inf), 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-5.0, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (1.0, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-inf, inf), infsup (-inf, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-5.0, -1.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-5.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (1.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup ((-inf), -1.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup ((-inf), 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-5.0, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (1.0, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, inf), infsup (-inf, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-5.0, -1.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-5.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (1.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup ((-inf), -1.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup ((-inf), 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-5.0, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (1.0, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, inf), infsup (-inf, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-5.0, -1.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-5.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (1.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup ((-inf), -1.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup ((-inf), 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-5.0, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (1.0, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), 3.0), infsup (-inf, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-5.0, -1.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-5.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (1.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup ((-inf), -1.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup ((-inf), 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-5.0, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (1.0, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup ((-inf), -3.0), infsup (-inf, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-5.0, -1.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-5.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (1.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup ((-inf), -1.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup ((-inf), 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-5.0, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (1.0, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (1.0, 5.0), infsup (-inf, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-5.0, -1.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-5.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, 2.0), infsup (-5.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-1.0, 10.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-2.0, 2.0), infsup (-5.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (1.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup ((-inf), -1.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup ((-inf), 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-5.0, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (1.0, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-1.0, 5.0), infsup (-inf, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-5.0, -1.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-5.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (1.0, 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup ((-inf), -1.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup ((-inf), 3.0), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-5.0, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (1.0, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (-10.0, -5.0), infsup (-inf, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fma (infsup (0.1, 0.5), infsup (-5.0, 3.0), infsup (-0.1, 0.1)), ...
%!         infsup ("-0X1.4CCCCCCCCCCCDP+1", "0X1.999999999999AP+0")))
%! assert (eq (...
%!         fma (infsup (-0.5, 0.2), infsup (-5.0, 3.0), infsup (-0.1, 0.1)), ...
%!         infsup ("-0X1.999999999999AP+0", "0X1.4CCCCCCCCCCCDP+1")))
%! assert (eq (...
%!         fma (infsup (-0.5, -0.1), infsup (2.0, 3.0), infsup (-0.1, 0.1)), ...
%!         infsup ("-0X1.999999999999AP+0", "-0X1.999999999999AP-4")))
%! assert (eq (...
%!         fma (infsup (-0.5, -0.1), infsup ((-inf), 3.0), infsup (-0.1, 0.1)), ...
%!         infsup ("-0X1.999999999999AP+0", inf)))

%!xtest "minimal.pown_test";
%! assert (eq (...
%!         pown (infsup (), 0), ...
%!         infsup ()))
%! assert (eq (...
%!         pown (infsup (), 2), ...
%!         infsup ()))
%! assert (eq (...
%!         pown (infsup (-inf, inf), 2), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup (0.0, inf), 2), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup ((-inf), 0.0), 2), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup (-324.3, 2.5), 2), ...
%!         infsup (0.0, "0X1.9AD27D70A3D72P+16")))
%! assert (eq (...
%!         pown (infsup (0.01, 2.33), 2), ...
%!         infsup ("0X1.A36E2EB1C432CP-14", "0X1.5B7318FC50482P+2")))
%! assert (eq (...
%!         pown (infsup (-1.9, -0.33), 2), ...
%!         infsup ("0X1.BE0DED288CE7P-4", "0X1.CE147AE147AE1P+1")))
%! assert (eq (...
%!         pown (infsup (), 8), ...
%!         infsup ()))
%! assert (eq (...
%!         pown (infsup (-inf, inf), 8), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup (0.0, inf), 8), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup ((-inf), 0.0), 8), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup (-324.3, 2.5), 8), ...
%!         infsup (0.0, "0X1.A87587109655P+66")))
%! assert (eq (...
%!         pown (infsup (0.01, 2.33), 8), ...
%!         infsup ("0X1.CD2B297D889BDP-54", "0X1.B253D9F33CE4DP+9")))
%! assert (eq (...
%!         pown (infsup (-1.9, -0.33), 8), ...
%!         infsup ("0X1.26F1FCDD502A3P-13", "0X1.53ABD7BFC4FC6P+7")))
%! assert (eq (...
%!         pown (infsup (), 1), ...
%!         infsup ()))
%! assert (eq (...
%!         pown (infsup (-inf, inf), 1), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         pown (infsup (0.0, inf), 1), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup ((-inf), 0.0), 1), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         pown (infsup (-324.3, 2.5), 1), ...
%!         infsup (-324.3, 2.5)))
%! assert (eq (...
%!         pown (infsup (0.01, 2.33), 1), ...
%!         infsup (0.01, 2.33)))
%! assert (eq (...
%!         pown (infsup (-1.9, -0.33), 1), ...
%!         infsup (-1.9, -0.33)))
%! assert (eq (...
%!         pown (infsup (), 3), ...
%!         infsup ()))
%! assert (eq (...
%!         pown (infsup (-inf, inf), 3), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         pown (infsup (0.0, inf), 3), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup ((-inf), 0.0), 3), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         pown (infsup (-324.3, 2.5), 3), ...
%!         infsup ("-0X1.0436D2F418938P+25", "0X1.F4P+3")))
%! assert (eq (...
%!         pown (infsup (0.01, 2.33), 3), ...
%!         infsup ("0X1.0C6F7A0B5ED8DP-20", "0X1.94C75E6362A6P+3")))
%! assert (eq (...
%!         pown (infsup (-1.9, -0.33), 3), ...
%!         infsup ("-0X1.B6F9DB22D0E55P+2", "-0X1.266559F6EC5B1P-5")))
%! assert (eq (...
%!         pown (infsup (), 7), ...
%!         infsup ()))
%! assert (eq (...
%!         pown (infsup (-inf, inf), 7), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         pown (infsup (0.0, inf), 7), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup ((-inf), 0.0), 7), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         pown (infsup (-324.3, 2.5), 7), ...
%!         infsup ("-0X1.4F109959E6D7FP+58", "0X1.312DP+9")))
%! assert (eq (...
%!         pown (infsup (0.01, 2.33), 7), ...
%!         infsup ("0X1.6849B86A12B9BP-47", "0X1.74D0373C76313P+8")))
%! assert (eq (...
%!         pown (infsup (-1.9, -0.33), 7), ...
%!         infsup ("-0X1.658C775099757P+6", "-0X1.BEE30301BF47AP-12")))
%! assert (eq (...
%!         pown (infsup (), -2), ...
%!         infsup ()))
%! assert (eq (...
%!         pown (infsup (-inf, inf), -2), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup (0.0, inf), -2), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup ((-inf), 0.0), -2), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup (-324.3, 2.5), -2), ...
%!         infsup ("0X1.3F0C482C977C9P-17", inf)))
%! assert (eq (...
%!         pown (infsup (0.01, 2.33), -2), ...
%!         infsup ("0X1.793D85EF38E47P-3", "0X1.388P+13")))
%! assert (eq (...
%!         pown (infsup (-1.9, -0.33), -2), ...
%!         infsup ("0X1.1BA81104F6C8P-2", "0X1.25D8FA1F801E1P+3")))
%! assert (eq (...
%!         pown (infsup (), -8), ...
%!         infsup ()))
%! assert (eq (...
%!         pown (infsup (-inf, inf), -8), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup (0.0, inf), -8), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup ((-inf), 0.0), -8), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup (-324.3, 2.5), -8), ...
%!         infsup ("0X1.34CC3764D1E0CP-67", inf)))
%! assert (eq (...
%!         pown (infsup (0.01, 2.33), -8), ...
%!         infsup ("0X1.2DC80DB11AB7CP-10", "0X1.1C37937E08P+53")))
%! assert (eq (...
%!         pown (infsup (-1.9, -0.33), -8), ...
%!         infsup ("0X1.81E104E61630DP-8", "0X1.BC64F21560E34P+12")))
%! assert (eq (...
%!         pown (infsup (), -1), ...
%!         infsup ()))
%! assert (eq (...
%!         pown (infsup (-inf, inf), -1), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         pown (infsup (0.0, inf), -1), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup ((-inf), 0.0), -1), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         pown (infsup (-324.3, 2.5), -1), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         pown (infsup (0.01, 2.33), -1), ...
%!         infsup ("0X1.B77C278DBBE13P-2", "0X1.9P+6")))
%! assert (eq (...
%!         pown (infsup (-1.9, -0.33), -1), ...
%!         infsup ("-0X1.83E0F83E0F83EP+1", "-0X1.0D79435E50D79P-1")))
%! assert (eq (...
%!         pown (infsup (), -3), ...
%!         infsup ()))
%! assert (eq (...
%!         pown (infsup (-inf, inf), -3), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         pown (infsup (0.0, inf), -3), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup ((-inf), 0.0), -3), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         pown (infsup (-324.3, 2.5), -3), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         pown (infsup (0.01, 2.33), -3), ...
%!         infsup ("0X1.43CFBA61AACABP-4", "0X1.E848P+19")))
%! assert (eq (...
%!         pown (infsup (-1.9, -0.33), -3), ...
%!         infsup ("-0X1.BD393CE9E8E7CP+4", "-0X1.2A95F6F7C066CP-3")))
%! assert (eq (...
%!         pown (infsup (), -7), ...
%!         infsup ()))
%! assert (eq (...
%!         pown (infsup (-inf, inf), -7), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         pown (infsup (0.0, inf), -7), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pown (infsup ((-inf), 0.0), -7), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         pown (infsup (-324.3, 2.5), -7), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         pown (infsup (0.01, 2.33), -7), ...
%!         infsup ("0X1.5F934D64162A9P-9", "0X1.6BCC41E9P+46")))
%! assert (eq (...
%!         pown (infsup (-1.9, -0.33), -7), ...
%!         infsup ("-0X1.254CDD3711DDBP+11", "-0X1.6E95C4A761E19P-7")))

%!test "minimal.exp_test";
%! assert (eq (...
%!         exp (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         exp (infsup ((-inf), 0.0)), ...
%!         infsup (0.0, 1.0)))
%! assert (eq (...
%!         exp (infsup (0.0, inf)), ...
%!         infsup (1.0, inf)))
%! assert (eq (...
%!         exp (infsup (-inf, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         exp (infsup ((-inf), "0X1.62E42FEFA39FP+9")), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         exp (infsup (0.0, "0X1.62E42FEFA39EP+9")), ...
%!         infsup (1.0, "0X1.FFFFFFFFFC32BP+1023")))
%! assert (eq (...
%!         exp (infsup ("-0X1.6232BDD7ABCD3P+8", "0X1.62E42FEFA39EP+9")), ...
%!         infsup ("0X1.FFFFFFFFFFE7BP-512", "0X1.FFFFFFFFFC32BP+1023")))
%! assert (eq (...
%!         exp (infsup ("-0X1.6232BDD7ABCD3P+8", 0.0)), ...
%!         infsup ("0X1.FFFFFFFFFFE7BP-512", 1.0)))
%! assert (eq (...
%!         exp (infsup ("-0X1.6232BDD7ABCD3P+8", 1.0)), ...
%!         infsup ("0X1.FFFFFFFFFFE7BP-512", "0X1.5BF0A8B14576AP+1")))
%! assert (eq (...
%!         exp (infsup (1.0, 5.0)), ...
%!         infsup ("0X1.5BF0A8B145769P+1", "0X1.28D389970339P+7")))
%! assert (eq (...
%!         exp (infsup ("-0X1.A934F0979A372P+1", "0X1.CEAECFEA8085AP+0")), ...
%!         infsup ("0X1.2797F0A337A5FP-5", "0X1.86091CC9095C5P+2")))
%! assert (eq (...
%!         exp (infsup ("0X1.87F42B972949CP-1", "0X1.8B55484710029P+6")), ...
%!         infsup ("0X1.1337E9E45812AP+1", "0X1.805A5C88021B6P+142")))
%! assert (eq (...
%!         exp (infsup ("0X1.78025C8B3FD39P+3", "0X1.9FD8EEF3FA79BP+4")), ...
%!         infsup ("0X1.EF461A783114CP+16", "0X1.691D36C6B008CP+37")))

%!xtest "minimal.exp2_test";
%! assert (eq (...
%!         pow2 (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         pow2 (infsup ((-inf), 0.0)), ...
%!         infsup (0.0, 1.0)))
%! assert (eq (...
%!         pow2 (infsup (0.0, inf)), ...
%!         infsup (1.0, inf)))
%! assert (eq (...
%!         pow2 (infsup (-inf, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pow2 (infsup ((-inf), 1024.0)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pow2 (infsup (0.0, 1023.0)), ...
%!         infsup (1.0, "0X1P+1023")))
%! assert (eq (...
%!         pow2 (infsup (-1022.0, 1023.0)), ...
%!         infsup ("0X1P-1022", "0X1P+1023")))
%! assert (eq (...
%!         pow2 (infsup (-1022.0, 0.0)), ...
%!         infsup ("0X1P-1022", 1.0)))
%! assert (eq (...
%!         pow2 (infsup (-1022.0, 1.0)), ...
%!         infsup ("0X1P-1022", 2.0)))
%! assert (eq (...
%!         pow2 (infsup (1.0, 5.0)), ...
%!         infsup (2.0, 32.0)))
%! assert (eq (...
%!         pow2 (infsup ("-0X1.A934F0979A372P+1", "0X1.CEAECFEA8085AP+0")), ...
%!         infsup ("0X1.9999999999998P-4", "0X1.C000000000001P+1")))
%! assert (eq (...
%!         pow2 (infsup ("0X1.87F42B972949CP-1", "0X1.8B55484710029P+6")), ...
%!         infsup ("0X1.B333333333332P+0", "0X1.C81FD88228B4FP+98")))
%! assert (eq (...
%!         pow2 (infsup ("0X1.78025C8B3FD39P+3", "0X1.9FD8EEF3FA79BP+4")), ...
%!         infsup ("0X1.AEA0000721857P+11", "0X1.FCA0555555559P+25")))

%!xtest "minimal.exp10_test";
%! assert (eq (...
%!         pow10 (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         pow10 (infsup ((-inf), 0.0)), ...
%!         infsup (0.0, 1.0)))
%! assert (eq (...
%!         pow10 (infsup (0.0, inf)), ...
%!         infsup (1.0, inf)))
%! assert (eq (...
%!         pow10 (infsup (-inf, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pow10 (infsup ((-inf), "0X1.34413509F79FFP+8")), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         pow10 (infsup (0.0, "0X1.34413509F79FEP+8")), ...
%!         infsup (1.0, "0X1.FFFFFFFFFFBA1P+1023")))
%! assert (eq (...
%!         pow10 (infsup ("-0X1.22P+7", "0X1.34413509F79FEP+8")), ...
%!         infsup ("0X1.3FAAC3E3FA1F3P-482", "0X1.FFFFFFFFFFBA1P+1023")))
%! assert (eq (...
%!         pow10 (infsup ("-0X1.22P+7", 0.0)), ...
%!         infsup ("0X1.3FAAC3E3FA1F3P-482", 1.0)))
%! assert (eq (...
%!         pow10 (infsup ("-0X1.22P+7", 1.0)), ...
%!         infsup ("0X1.3FAAC3E3FA1F3P-482", 10.0)))
%! assert (eq (...
%!         pow10 (infsup (1.0, 5.0)), ...
%!         infsup (10.0, 100000.0)))
%! assert (eq (...
%!         pow10 (infsup ("-0X1.A934F0979A372P+1", "0X1.CEAECFEA8085AP+0")), ...
%!         infsup ("0X1.F3A8254311F9AP-12", "0X1.00B18AD5B7D56P+6")))
%! assert (eq (...
%!         pow10 (infsup ("0X1.87F42B972949CP-1", "0X1.8B55484710029P+6")), ...
%!         infsup ("0X1.75014B7296807P+2", "0X1.3EEC1D47DFB2BP+328")))
%! assert (eq (...
%!         pow10 (infsup ("0X1.78025C8B3FD39P+3", "0X1.9FD8EEF3FA79BP+4")), ...
%!         infsup ("0X1.0608D2279A811P+39", "0X1.43AF5D4271CB8P+86")))

%!test "minimal.log_test";
%! assert (eq (...
%!         log (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         log (infsup ((-inf), 0.0)), ...
%!         infsup ()))
%! assert (eq (...
%!         log (infsup (0.0, 1.0)), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         log (infsup (1.0, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         log (infsup (0.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         log (infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         log (infsup ("0X1.5BF0A8B145769P+1", 32.0)), ...
%!         infsup ("0X1.FFFFFFFFFFFFFP-1", "0X1.BB9D3BEB8C86CP+1")))
%! assert (eq (...
%!         log (infsup ("0X1.999999999999AP-4", "0X1.CP+1")), ...
%!         infsup ("-0X1.26BB1BBB55516P+1", "0X1.40B512EB53D6P+0")))
%! assert (eq (...
%!         log (infsup ("0X1.B333333333333P+0", "0X1.C81FD88228B2FP+98")), ...
%!         infsup ("0X1.0FAE81914A99P-1", "0X1.120627F6AE7F1P+6")))
%! assert (eq (...
%!         log (infsup ("0X1.AEA0000721861P+11", "0X1.FCA055555554CP+25")), ...
%!         infsup ("0X1.04A1363DB1E63P+3", "0X1.203E52C0256B5P+4")))

%!test "minimal.log2_test";
%! assert (eq (...
%!         log2 (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         log2 (infsup ((-inf), 0.0)), ...
%!         infsup ()))
%! assert (eq (...
%!         log2 (infsup (0.0, 1.0)), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         log2 (infsup (1.0, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         log2 (infsup (0.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         log2 (infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         log2 (infsup (2.0, 32.0)), ...
%!         infsup (1.0, 5.0)))
%! assert (eq (...
%!         log2 (infsup ("0X1.999999999999AP-4", "0X1.CP+1")), ...
%!         infsup ("-0X1.A934F0979A372P+1", "0X1.CEAECFEA8085AP+0")))
%! assert (eq (...
%!         log2 (infsup ("0X1.B333333333333P+0", "0X1.C81FD88228B2FP+98")), ...
%!         infsup ("0X1.87F42B972949CP-1", "0X1.8B55484710029P+6")))
%! assert (eq (...
%!         log2 (infsup ("0X1.AEA0000721861P+11", "0X1.FCA055555554CP+25")), ...
%!         infsup ("0X1.78025C8B3FD39P+3", "0X1.9FD8EEF3FA79BP+4")))

%!test "minimal.log10_test";
%! assert (eq (...
%!         log10 (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         log10 (infsup ((-inf), 0.0)), ...
%!         infsup ()))
%! assert (eq (...
%!         log10 (infsup (0.0, 1.0)), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         log10 (infsup (1.0, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         log10 (infsup (0.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         log10 (infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         log10 (infsup (10.0, 100000.0)), ...
%!         infsup (1.0, 5.0)))
%! assert (eq (...
%!         log10 (infsup ("0X1.999999999999AP-4", "0X1.CP+1")), ...
%!         infsup ("-0X1P+0", "0X1.1690163290F4P-1")))
%! assert (eq (...
%!         log10 (infsup ("0X1.999999999999AP-4", "0X1.999999999999AP-4")), ...
%!         infsup ("-0X1P+0", "-0X1.FFFFFFFFFFFFFP-1")))
%! assert (eq (...
%!         log10 (infsup ("0X1.B333333333333P+0", "0X1.C81FD88228B2FP+98")), ...
%!         infsup ("0X1.D7F59AA5BECB9P-3", "0X1.DC074D84E5AABP+4")))
%! assert (eq (...
%!         log10 (infsup ("0X1.AEA0000721861P+11", "0X1.FCA055555554CP+25")), ...
%!         infsup ("0X1.C4C29DD829191P+1", "0X1.F4BAEBBA4FA4P+2")))

%!test "minimal.sin_test";
%! assert (eq (...
%!         sin (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         sin (infsup (0.0, inf)), ...
%!         infsup (-1.0, 1.0)))
%! assert (eq (...
%!         sin (infsup ((-inf), 0.0)), ...
%!         infsup (-1.0, 1.0)))
%! assert (eq (...
%!         sin (infsup (-inf, inf)), ...
%!         infsup (-1.0, 1.0)))
%! assert (eq (...
%!         sin (infsup ("0X1.921FB54442D18P+0", "0X1.921FB54442D19P+0")), ...
%!         infsup ("0X1.FFFFFFFFFFFFFP-1", "0X1P+0")))
%! assert (eq (...
%!         sin (infsup (0.0, "0X1.921FB54442D18P+0")), ...
%!         infsup (0.0, "0X1P+0")))
%! assert (eq (...
%!         sin (infsup (0.0, "0X1.921FB54442D19P+0")), ...
%!         infsup (0.0, "0X1P+0")))
%! assert (eq (...
%!         sin (infsup ("0X1.921FB54442D18P+1", "0X1.921FB54442D19P+1")), ...
%!         infsup ("-0X1.72CECE675D1FDP-52", "0X1.1A62633145C07P-53")))
%! assert (eq (...
%!         sin (infsup (0.0, "0X1.921FB54442D18P+1")), ...
%!         infsup (0.0, 1.0)))
%! assert (eq (...
%!         sin (infsup (0.0, "0X1.921FB54442D19P+1")), ...
%!         infsup ("-0X1.72CECE675D1FDP-52", 1.0)))
%! assert (eq (...
%!         sin (infsup ("0X1.921FB54442D18P+0", "0X1.921FB54442D18P+1")), ...
%!         infsup ("0X1.1A62633145C06P-53", "0X1P+0")))
%! assert (eq (...
%!         sin (infsup ("0X1.921FB54442D18P+0", "0X1.921FB54442D19P+1")), ...
%!         infsup ("-0X1.72CECE675D1FDP-52", "0X1P+0")))
%! assert (eq (...
%!         sin (infsup ("0X1.921FB54442D19P+0", "0X1.921FB54442D18P+1")), ...
%!         infsup ("0X1.1A62633145C06P-53", "0X1P+0")))
%! assert (eq (...
%!         sin (infsup ("0X1.921FB54442D19P+0", "0X1.921FB54442D19P+1")), ...
%!         infsup ("-0X1.72CECE675D1FDP-52", "0X1P+0")))
%! assert (eq (...
%!         sin (infsup ("-0X1.921FB54442D19P+0", "-0X1.921FB54442D18P+0")), ...
%!         infsup ("-0X1P+0", "-0X1.FFFFFFFFFFFFFP-1")))
%! assert (eq (...
%!         sin (infsup ("-0X1.921FB54442D18P+0", 0.0)), ...
%!         infsup ("-0X1P+0", 0.0)))
%! assert (eq (...
%!         sin (infsup ("-0X1.921FB54442D19P+0", 0.0)), ...
%!         infsup ("-0X1P+0", 0.0)))
%! assert (eq (...
%!         sin (infsup ("-0X1.921FB54442D19P+1", "-0X1.921FB54442D18P+1")), ...
%!         infsup ("-0X1.1A62633145C07P-53", "0X1.72CECE675D1FDP-52")))
%! assert (eq (...
%!         sin (infsup ("-0X1.921FB54442D18P+1", 0.0)), ...
%!         infsup (-1.0, 0.0)))
%! assert (eq (...
%!         sin (infsup ("-0X1.921FB54442D19P+1", 0.0)), ...
%!         infsup (-1.0, "0X1.72CECE675D1FDP-52")))
%! assert (eq (...
%!         sin (infsup ("-0X1.921FB54442D18P+1", "-0X1.921FB54442D18P+0")), ...
%!         infsup ("-0X1P+0", "-0X1.1A62633145C06P-53")))
%! assert (eq (...
%!         sin (infsup ("-0X1.921FB54442D19P+1", "-0X1.921FB54442D18P+0")), ...
%!         infsup ("-0X1P+0", "0X1.72CECE675D1FDP-52")))
%! assert (eq (...
%!         sin (infsup ("-0X1.921FB54442D18P+1", "-0X1.921FB54442D19P+0")), ...
%!         infsup ("-0X1P+0", "-0X1.1A62633145C06P-53")))
%! assert (eq (...
%!         sin (infsup ("-0X1.921FB54442D19P+1", "-0X1.921FB54442D19P+0")), ...
%!         infsup ("-0X1P+0", "0X1.72CECE675D1FDP-52")))
%! assert (eq (...
%!         sin (infsup ("-0X1.921FB54442D18P+0", "0X1.921FB54442D18P+0")), ...
%!         infsup ("-0X1P+0", "0X1P+0")))
%! assert (eq (...
%!         sin (infsup ("-0X1.921FB54442D18P+0", "0X1.921FB54442D19P+0")), ...
%!         infsup ("-0X1P+0", "0X1P+0")))
%! assert (eq (...
%!         sin (infsup ("-0X1.921FB54442D19P+0", "0X1.921FB54442D18P+0")), ...
%!         infsup ("-0X1P+0", "0X1P+0")))
%! assert (eq (...
%!         sin (infsup ("-0X1.921FB54442D19P+0", "0X1.921FB54442D19P+0")), ...
%!         infsup ("-0X1P+0", "0X1P+0")))
%! assert (eq (...
%!         sin (infsup (-0.7, 0.1)), ...
%!         infsup ("-0X1.49D6E694619B9P-1", "0X1.98EAECB8BCB2DP-4")))
%! assert (eq (...
%!         sin (infsup (1.0, 2.0)), ...
%!         infsup ("0X1.AED548F090CEEP-1", 1.0)))
%! assert (eq (...
%!         sin (infsup (-3.2, -2.9)), ...
%!         infsup ("-0X1.E9FB8D64830E3P-3", "0X1.DE33739E82D33P-5")))
%! assert (eq (...
%!         sin (infsup (2.0, 3.0)), ...
%!         infsup ("0X1.210386DB6D55BP-3", "0X1.D18F6EAD1B446P-1")))

%!test "minimal.cos_test";
%! assert (eq (...
%!         cos (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         cos (infsup (0.0, inf)), ...
%!         infsup (-1.0, 1.0)))
%! assert (eq (...
%!         cos (infsup ((-inf), 0.0)), ...
%!         infsup (-1.0, 1.0)))
%! assert (eq (...
%!         cos (infsup (-inf, inf)), ...
%!         infsup (-1.0, 1.0)))
%! assert (eq (...
%!         cos (infsup ("0X1.921FB54442D18P+0", "0X1.921FB54442D19P+0")), ...
%!         infsup ("-0X1.72CECE675D1FDP-53", "0X1.1A62633145C07P-54")))
%! assert (eq (...
%!         cos (infsup (0.0, "0X1.921FB54442D18P+0")), ...
%!         infsup ("0X1.1A62633145C06P-54", 1.0)))
%! assert (eq (...
%!         cos (infsup (0.0, "0X1.921FB54442D19P+0")), ...
%!         infsup ("-0X1.72CECE675D1FDP-53", 1.0)))
%! assert (eq (...
%!         cos (infsup ("0X1.921FB54442D18P+1", "0X1.921FB54442D19P+1")), ...
%!         infsup ("-0X1P+0", "-0X1.FFFFFFFFFFFFFP-1")))
%! assert (eq (...
%!         cos (infsup (0.0, "0X1.921FB54442D18P+1")), ...
%!         infsup (-1.0, 1.0)))
%! assert (eq (...
%!         cos (infsup (0.0, "0X1.921FB54442D19P+1")), ...
%!         infsup (-1.0, 1.0)))
%! assert (eq (...
%!         cos (infsup ("0X1.921FB54442D18P+0", "0X1.921FB54442D18P+1")), ...
%!         infsup (-1.0, "0X1.1A62633145C07P-54")))
%! assert (eq (...
%!         cos (infsup ("0X1.921FB54442D18P+0", "0X1.921FB54442D19P+1")), ...
%!         infsup (-1.0, "0X1.1A62633145C07P-54")))
%! assert (eq (...
%!         cos (infsup ("0X1.921FB54442D19P+0", "0X1.921FB54442D18P+1")), ...
%!         infsup (-1.0, "-0X1.72CECE675D1FCP-53")))
%! assert (eq (...
%!         cos (infsup ("0X1.921FB54442D19P+0", "0X1.921FB54442D19P+1")), ...
%!         infsup (-1.0, "-0X1.72CECE675D1FCP-53")))
%! assert (eq (...
%!         cos (infsup ("-0X1.921FB54442D19P+0", "-0X1.921FB54442D18P+0")), ...
%!         infsup ("-0X1.72CECE675D1FDP-53", "0X1.1A62633145C07P-54")))
%! assert (eq (...
%!         cos (infsup ("-0X1.921FB54442D18P+0", 0.0)), ...
%!         infsup ("0X1.1A62633145C06P-54", 1.0)))
%! assert (eq (...
%!         cos (infsup ("-0X1.921FB54442D19P+0", 0.0)), ...
%!         infsup ("-0X1.72CECE675D1FDP-53", 1.0)))
%! assert (eq (...
%!         cos (infsup ("-0X1.921FB54442D19P+1", "-0X1.921FB54442D18P+1")), ...
%!         infsup ("-0X1P+0", "-0X1.FFFFFFFFFFFFFP-1")))
%! assert (eq (...
%!         cos (infsup ("-0X1.921FB54442D18P+1", 0.0)), ...
%!         infsup (-1.0, 1.0)))
%! assert (eq (...
%!         cos (infsup ("-0X1.921FB54442D19P+1", 0.0)), ...
%!         infsup (-1.0, 1.0)))
%! assert (eq (...
%!         cos (infsup ("-0X1.921FB54442D18P+1", "-0X1.921FB54442D18P+0")), ...
%!         infsup (-1.0, "0X1.1A62633145C07P-54")))
%! assert (eq (...
%!         cos (infsup ("-0X1.921FB54442D19P+1", "-0X1.921FB54442D18P+0")), ...
%!         infsup (-1.0, "0X1.1A62633145C07P-54")))
%! assert (eq (...
%!         cos (infsup ("-0X1.921FB54442D18P+1", "-0X1.921FB54442D19P+0")), ...
%!         infsup (-1.0, "-0X1.72CECE675D1FCP-53")))
%! assert (eq (...
%!         cos (infsup ("-0X1.921FB54442D19P+1", "-0X1.921FB54442D19P+0")), ...
%!         infsup (-1.0, "-0X1.72CECE675D1FCP-53")))
%! assert (eq (...
%!         cos (infsup ("-0X1.921FB54442D18P+0", "0X1.921FB54442D18P+0")), ...
%!         infsup ("0X1.1A62633145C06P-54", 1.0)))
%! assert (eq (...
%!         cos (infsup ("-0X1.921FB54442D18P+0", "0X1.921FB54442D19P+0")), ...
%!         infsup ("-0X1.72CECE675D1FDP-53", 1.0)))
%! assert (eq (...
%!         cos (infsup ("-0X1.921FB54442D19P+0", "0X1.921FB54442D18P+0")), ...
%!         infsup ("-0X1.72CECE675D1FDP-53", 1.0)))
%! assert (eq (...
%!         cos (infsup ("-0X1.921FB54442D19P+0", "0X1.921FB54442D19P+0")), ...
%!         infsup ("-0X1.72CECE675D1FDP-53", 1.0)))
%! assert (eq (...
%!         cos (infsup (-0.7, 0.1)), ...
%!         infsup ("0X1.87996529F9D92P-1", 1.0)))
%! assert (eq (...
%!         cos (infsup (1.0, 2.0)), ...
%!         infsup ("-0X1.AA22657537205P-2", "0X1.14A280FB5068CP-1")))
%! assert (eq (...
%!         cos (infsup (-3.2, -2.9)), ...
%!         infsup (-1.0, "-0X1.F1216DBA340C8P-1")))
%! assert (eq (...
%!         cos (infsup (2.0, 3.0)), ...
%!         infsup ("-0X1.FAE04BE85E5D3P-1", "-0X1.AA22657537204P-2")))

%!test "minimal.tan_test";
%! assert (eq (...
%!         tan (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         tan (infsup (0.0, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         tan (infsup ((-inf), 0.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         tan (infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         tan (infsup ("0X1.921FB54442D18P+0", "0X1.921FB54442D19P+0")), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         tan (infsup (0.0, "0X1.921FB54442D18P+0")), ...
%!         infsup (0.0, "0X1.D02967C31CDB5P+53")))
%! assert (eq (...
%!         tan (infsup (0.0, "0X1.921FB54442D19P+0")), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         tan (infsup (0.0, "0X1.921FB54442D18P+1")), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         tan (infsup (0.0, "0X1.921FB54442D19P+1")), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         tan (infsup ("0X1P-51", "0X1.921FB54442D18P+1")), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         tan (infsup ("0X1P-51", "0X1.921FB54442D19P+1")), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         tan (infsup ("0X1P-52", "0X1.921FB54442D18P+1")), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         tan (infsup ("0X1P-52", "0X1.921FB54442D19P+1")), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         tan (infsup ("-0X1.921FB54442D18P+0", "0X1.921FB54442D18P+0")), ...
%!         infsup ("-0X1.D02967C31CDB5P+53", "0X1.D02967C31CDB5P+53")))
%! assert (eq (...
%!         tan (infsup ("-0X1.921FB54442D18P+0", "0X1.921FB54442D19P+0")), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         tan (infsup ("-0X1.921FB54442D19P+0", "0X1.921FB54442D18P+0")), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         tan (infsup ("-0X1.921FB54442D19P+0", "0X1.921FB54442D19P+0")), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         tan (infsup ("-0X1.555475A31A4BEP-2", "0X1.999999999999AP-4")), ...
%!         infsup ("-0X1.628F4FD931FEFP-2", "0X1.9AF8877430B81P-4")))
%! assert (eq (...
%!         tan (infsup ("0X1.4E18E147AE148P+12", "0X1.4E2028F5C28F6P+12")), ...
%!         infsup ("-0X1.D6D67B035B6B4P+2", "-0X1.7E42B0760E3F3P+0")))
%! assert (eq (...
%!         tan (infsup ("0X1.4E18E147AE148P+12", "0X1.546028F5C28F6P+12")), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         tan (infsup ("0X1.FAE147AE147AEP-1", "0X1.028F5C28F5C29P+0")), ...
%!         infsup ("0X1.860FADCC59064P+0", "0X1.979AD0628469DP+0")))

%!test "minimal.asin_test";
%! assert (eq (...
%!         asin (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         asin (infsup (0.0, inf)), ...
%!         infsup (0.0, "0X1.921FB54442D19P+0")))
%! assert (eq (...
%!         asin (infsup ((-inf), 0.0)), ...
%!         infsup ("-0X1.921FB54442D19P+0", 0.0)))
%! assert (eq (...
%!         asin (infsup (-inf, inf)), ...
%!         infsup ("-0X1.921FB54442D19P+0", "0X1.921FB54442D19P+0")))
%! assert (eq (...
%!         asin (infsup (-1.0, 1.0)), ...
%!         infsup ("-0X1.921FB54442D19P+0", "0X1.921FB54442D19P+0")))
%! assert (eq (...
%!         asin (infsup ((-inf), -1.0)), ...
%!         infsup ("-0X1.921FB54442D19P+0", "-0X1.921FB54442D18P+0")))
%! assert (eq (...
%!         asin (infsup (1.0, inf)), ...
%!         infsup ("0X1.921FB54442D18P+0", "0X1.921FB54442D19P+0")))
%! assert (eq (...
%!         asin (infsup ((-inf), "-0X1.0000000000001P+0")), ...
%!         infsup ()))
%! assert (eq (...
%!         asin (infsup ("0X1.0000000000001P+0", inf)), ...
%!         infsup ()))
%! assert (eq (...
%!         asin (infsup ("-0X1.999999999999AP-4", "0X1.999999999999AP-4")), ...
%!         infsup ("-0X1.9A49276037885P-4", "0X1.9A49276037885P-4")))
%! assert (eq (...
%!         asin (infsup ("-0X1.51EB851EB851FP-2", "0X1.FFFFFFFFFFFFFP-1")), ...
%!         infsup ("-0X1.585FF6E341C3FP-2", "0X1.921FB50442D19P+0")))
%! assert (eq (...
%!         asin (infsup ("-0X1.FFFFFFFFFFFFFP-1", "0X1.FFFFFFFFFFFFFP-1")), ...
%!         infsup ("-0X1.921FB50442D19P+0", "0X1.921FB50442D19P+0")))

%!test "minimal.acos_test";
%! assert (eq (...
%!         acos (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         acos (infsup (0.0, inf)), ...
%!         infsup (0.0, "0X1.921FB54442D19P+0")))
%! assert (eq (...
%!         acos (infsup ((-inf), 0.0)), ...
%!         infsup ("0X1.921FB54442D18P+0", "0X1.921FB54442D19P+1")))
%! assert (eq (...
%!         acos (infsup (-inf, inf)), ...
%!         infsup (0.0, "0X1.921FB54442D19P+1")))
%! assert (eq (...
%!         acos (infsup (-1.0, 1.0)), ...
%!         infsup (0.0, "0X1.921FB54442D19P+1")))
%! assert (eq (...
%!         acos (infsup ((-inf), -1.0)), ...
%!         infsup ("0X1.921FB54442D18P+1", "0X1.921FB54442D19P+1")))
%! assert (eq (...
%!         acos (infsup ((-inf), "-0X1.0000000000001P+0")), ...
%!         infsup ()))
%! assert (eq (...
%!         acos (infsup ("0X1.0000000000001P+0", inf)), ...
%!         infsup ()))
%! assert (eq (...
%!         acos (infsup ("-0X1.999999999999AP-4", "0X1.999999999999AP-4")), ...
%!         infsup ("0X1.787B22CE3F59P+0", "0X1.ABC447BA464A1P+0")))
%! assert (eq (...
%!         acos (infsup ("-0X1.51EB851EB851FP-2", "0X1.FFFFFFFFFFFFFP-1")), ...
%!         infsup ("0X1P-26", "0X1.E837B2FD13428P+0")))
%! assert (eq (...
%!         acos (infsup ("-0X1.FFFFFFFFFFFFFP-1", "0X1.FFFFFFFFFFFFFP-1")), ...
%!         infsup ("0X1P-26", "0X1.921FB52442D19P+1")))

%!test "minimal.atan_test";
%! assert (eq (...
%!         atan (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         atan (infsup (0.0, inf)), ...
%!         infsup (0.0, "0X1.921FB54442D19P+0")))
%! assert (eq (...
%!         atan (infsup ((-inf), 0.0)), ...
%!         infsup ("-0X1.921FB54442D19P+0", 0.0)))
%! assert (eq (...
%!         atan (infsup (-inf, inf)), ...
%!         infsup ("-0X1.921FB54442D19P+0", "0X1.921FB54442D19P+0")))
%! assert (eq (...
%!         atan (infsup (1.0, "0X1.4C2463567C5ACP+25")), ...
%!         infsup ("0X1.921FB54442D18P-1", "0X1.921FB4E19ABD7P+0")))
%! assert (eq (...
%!         atan (infsup ("-0X1.FD219490EAAC1P+38", "-0X1.1AF1C9D74F06DP+9")), ...
%!         infsup ("-0X1.921FB54440CEBP+0", "-0X1.91ABE5C1E4C6DP+0")))

%!test "minimal.sinh_test";
%! assert (eq (...
%!         sinh (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         sinh (infsup (0.0, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         sinh (infsup ((-inf), 0.0)), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         sinh (infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         sinh (infsup (1.0, "0X1.2C903022DD7AAP+8")), ...
%!         infsup ("0X1.2CD9FC44EB982P+0", "0X1.89BCA168970C6P+432")))
%! assert (eq (...
%!         sinh (infsup ("-0X1.FD219490EAAC1P+38", "-0X1.1AF1C9D74F06DP+9")), ...
%!         infsup ((-inf), "-0X1.53045B4F849DEP+815")))
%! assert (eq (...
%!         sinh (infsup ("-0X1.199999999999AP+0", "0X1.2666666666666P+1")), ...
%!         infsup ("-0X1.55ECFE1B2B215P+0", "0X1.3BF72EA61AF1BP+2")))

%!test "minimal.cosh_test";
%! assert (eq (...
%!         cosh (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         cosh (infsup (0.0, inf)), ...
%!         infsup (1.0, inf)))
%! assert (eq (...
%!         cosh (infsup ((-inf), 0.0)), ...
%!         infsup (1.0, inf)))
%! assert (eq (...
%!         cosh (infsup (-inf, inf)), ...
%!         infsup (1.0, inf)))
%! assert (eq (...
%!         cosh (infsup (1.0, "0X1.2C903022DD7AAP+8")), ...
%!         infsup ("0X1.8B07551D9F55P+0", "0X1.89BCA168970C6P+432")))
%! assert (eq (...
%!         cosh (infsup ("-0X1.FD219490EAAC1P+38", "-0X1.1AF1C9D74F06DP+9")), ...
%!         infsup ("0X1.53045B4F849DEP+815", inf)))
%! assert (eq (...
%!         cosh (infsup ("-0X1.199999999999AP+0", "0X1.2666666666666P+1")), ...
%!         infsup (1.0, "0X1.4261D2B7D6181P+2")))

%!test "minimal.tanh_test";
%! assert (eq (...
%!         tanh (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         tanh (infsup (0.0, inf)), ...
%!         infsup (0.0, 1.0)))
%! assert (eq (...
%!         tanh (infsup ((-inf), 0.0)), ...
%!         infsup (-1.0, 0.0)))
%! assert (eq (...
%!         tanh (infsup (-inf, inf)), ...
%!         infsup (-1.0, 1.0)))
%! assert (eq (...
%!         tanh (infsup (1.0, "0X1.2C903022DD7AAP+8")), ...
%!         infsup ("0X1.85EFAB514F394P-1", "0X1P+0")))
%! assert (eq (...
%!         tanh (infsup ("-0X1.FD219490EAAC1P+38", "-0X1.1AF1C9D74F06DP+9")), ...
%!         infsup ("-0X1P+0", "-0X1.FFFFFFFFFFFFFP-1")))
%! assert (eq (...
%!         tanh (infsup ("-0X1.199999999999AP+0", "0X1.2666666666666P+1")), ...
%!         infsup ("-0X1.99DB01FDE2406P-1", "0X1.F5CF31E1C8103P-1")))

%!test "minimal.asinh_test";
%! assert (eq (...
%!         asinh (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         asinh (infsup (0.0, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         asinh (infsup ((-inf), 0.0)), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         asinh (infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         asinh (infsup (1.0, "0X1.2C903022DD7AAP+8")), ...
%!         infsup ("0X1.C34366179D426P-1", "0X1.9986127438A87P+2")))
%! assert (eq (...
%!         asinh (infsup ("-0X1.FD219490EAAC1P+38", "-0X1.1AF1C9D74F06DP+9")), ...
%!         infsup ("-0X1.BB86380A6CC45P+4", "-0X1.C204D8EB20827P+2")))
%! assert (eq (...
%!         asinh (infsup ("-0X1.199999999999AP+0", "0X1.2666666666666P+1")), ...
%!         infsup ("-0X1.E693DF6EDF1E7P-1", "0X1.91FDC64DE0E51P+0")))

%!test "minimal.acosh_test";
%! assert (eq (...
%!         acosh (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         acosh (infsup (0.0, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         acosh (infsup (1.0, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         acosh (infsup ((-inf), "0X1.FFFFFFFFFFFFFP-1")), ...
%!         infsup ()))
%! assert (eq (...
%!         acosh (infsup (-inf, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         acosh (infsup (1.0, "0X1.2C903022DD7AAP+8")), ...
%!         infsup (0.0, "0X1.9985FB3D532AFP+2")))
%! assert (eq (...
%!         acosh (infsup ("0X1.199999999999AP+0", "0X1.2666666666666P+1")), ...
%!         infsup ("0X1.C636C1A882F2CP-2", "0X1.799C88E79140DP+0")))
%! assert (eq (...
%!         acosh (infsup ("0X1.14D4E82B2B26FP+15", "0X1.72DBE91C837B5P+29")), ...
%!         infsup ("0X1.656510B4BAEC3P+3", "0X1.52A415EE8455AP+4")))

%!test "minimal.atanh_test";
%! assert (eq (...
%!         atanh (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         atanh (infsup (0.0, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         atanh (infsup (1.0, inf)), ...
%!         infsup ()))
%! assert (eq (...
%!         atanh (infsup ((-inf), 0.0)), ...
%!         infsup ((-inf), 0.0)))
%! assert (eq (...
%!         atanh (infsup ((-inf), -1.0)), ...
%!         infsup ()))
%! assert (eq (...
%!         atanh (infsup (-1.0, 1.0)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         atanh (infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         atanh (infsup ("0X1.4C0420F6F08CCP-2", "0X1.FFFFFFFFFFFFFP-1")), ...
%!         infsup ("0X1.5871DD2DF9102P-2", "0X1.2B708872320E2P+4")))
%! assert (eq (...
%!         atanh (infsup ("-0X1.FFB88E9EB6307P-1", "0X1.999999999999AP-4")), ...
%!         infsup ("-0X1.06A3A97D7979CP+2", "0X1.9AF93CD234413P-4")))

%!test "minimal.sign_test";
%! assert (eq (...
%!         sign (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         sign (infsup (-1.0, 2.0)), ...
%!         infsup (-1.0, 1.0)))
%! assert (eq (...
%!         sign (infsup (-1.0, 0.0)), ...
%!         infsup (-1.0, 0.0)))
%! assert (eq (...
%!         sign (infsup (0.0, 2.0)), ...
%!         infsup (0.0, 1.0)))
%! assert (eq (...
%!         sign (infsup (-inf, inf)), ...
%!         infsup (-1.0, 1.0)))

%!test "minimal.ceil_test";
%! assert (eq (...
%!         ceil (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         ceil (infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         ceil (infsup (-1.1, 2.0)), ...
%!         infsup (-1.0, 2.0)))
%! assert (eq (...
%!         ceil (infsup (-1.1, -0.4)), ...
%!         infsup (-1.0, 0.0)))
%! assert (eq (...
%!         ceil (infsup (-1.9, 2.2)), ...
%!         infsup (-1.0, 3.0)))
%! assert (eq (...
%!         ceil (infsup (-1.0, 2.2)), ...
%!         infsup (-1.0, 3.0)))
%! assert (eq (...
%!         ceil (infsup (-1.5, inf)), ...
%!         infsup (-1.0, inf)))
%! assert (eq (...
%!         ceil (infsup ((-inf), 2.2)), ...
%!         infsup ((-inf), 3.0)))

%!test "minimal.floor_test";
%! assert (eq (...
%!         floor (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         floor (infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         floor (infsup (1.1, 2.0)), ...
%!         infsup (1.0, 2.0)))
%! assert (eq (...
%!         floor (infsup (-1.1, 2.0)), ...
%!         infsup (-2.0, 2.0)))
%! assert (eq (...
%!         floor (infsup (-1.1, -0.4)), ...
%!         infsup (-2.0, -1.0)))
%! assert (eq (...
%!         floor (infsup (-1.9, 2.2)), ...
%!         infsup (-2.0, 2.0)))
%! assert (eq (...
%!         floor (infsup (-1.0, 2.2)), ...
%!         infsup (-1.0, 2.0)))
%! assert (eq (...
%!         floor (infsup (-1.5, inf)), ...
%!         infsup (-2.0, inf)))
%! assert (eq (...
%!         floor (infsup ((-inf), 2.2)), ...
%!         infsup ((-inf), 2.0)))

%!test "minimal.trunc_test";
%! assert (eq (...
%!         fix (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         fix (infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         fix (infsup (1.1, 2.1)), ...
%!         infsup (1.0, 2.0)))
%! assert (eq (...
%!         fix (infsup (-1.1, 2.0)), ...
%!         infsup (-1.0, 2.0)))
%! assert (eq (...
%!         fix (infsup (-1.1, -0.4)), ...
%!         infsup (-1.0, 0.0)))
%! assert (eq (...
%!         fix (infsup (-1.9, 2.2)), ...
%!         infsup (-1.0, 2.0)))
%! assert (eq (...
%!         fix (infsup (-1.0, 2.2)), ...
%!         infsup (-1.0, 2.0)))
%! assert (eq (...
%!         fix (infsup (-1.5, inf)), ...
%!         infsup (-1.0, inf)))
%! assert (eq (...
%!         fix (infsup ((-inf), 2.2)), ...
%!         infsup ((-inf), 2.0)))

%!test "minimal.round_ties_to_even_test";
%! assert (eq (...
%!         roundb (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         roundb (infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         roundb (infsup (1.1, 2.1)), ...
%!         infsup (1.0, 2.0)))
%! assert (eq (...
%!         roundb (infsup (-1.1, 2.0)), ...
%!         infsup (-1.0, 2.0)))
%! assert (eq (...
%!         roundb (infsup (-1.1, -0.4)), ...
%!         infsup (-1.0, 0.0)))
%! assert (eq (...
%!         roundb (infsup (-1.9, 2.2)), ...
%!         infsup (-2.0, 2.0)))
%! assert (eq (...
%!         roundb (infsup (-1.0, 2.2)), ...
%!         infsup (-1.0, 2.0)))
%! assert (eq (...
%!         roundb (infsup (-1.5, 2.0)), ...
%!         infsup (-2.0, 2.0)))
%! assert (eq (...
%!         roundb (infsup (-1.1, -0.5)), ...
%!         infsup (-1.0, 0.0)))
%! assert (eq (...
%!         roundb (infsup (-1.9, 2.5)), ...
%!         infsup (-2.0, 2.0)))
%! assert (eq (...
%!         roundb (infsup (-1.5, 2.5)), ...
%!         infsup (-2.0, 2.0)))
%! assert (eq (...
%!         roundb (infsup (-1.5, inf)), ...
%!         infsup (-2.0, inf)))
%! assert (eq (...
%!         roundb (infsup ((-inf), 2.2)), ...
%!         infsup ((-inf), 2.0)))

%!test "minimal.round_ties_to_away_test";
%! assert (eq (...
%!         round (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         round (infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         round (infsup (1.1, 2.1)), ...
%!         infsup (1.0, 2.0)))
%! assert (eq (...
%!         round (infsup (-1.1, 2.0)), ...
%!         infsup (-1.0, 2.0)))
%! assert (eq (...
%!         round (infsup (-1.1, -0.4)), ...
%!         infsup (-1.0, 0.0)))
%! assert (eq (...
%!         round (infsup (-1.9, 2.2)), ...
%!         infsup (-2.0, 2.0)))
%! assert (eq (...
%!         round (infsup (-1.0, 2.2)), ...
%!         infsup (-1.0, 2.0)))
%! assert (eq (...
%!         round (infsup (0.5, 2.1)), ...
%!         infsup (1.0, 2.0)))
%! assert (eq (...
%!         round (infsup (-2.5, 2.0)), ...
%!         infsup (-3.0, 2.0)))
%! assert (eq (...
%!         round (infsup (-1.9, 2.5)), ...
%!         infsup (-2.0, 3.0)))
%! assert (eq (...
%!         round (infsup (-1.5, 2.5)), ...
%!         infsup (-2.0, 3.0)))
%! assert (eq (...
%!         round (infsup (-1.5, inf)), ...
%!         infsup (-2.0, inf)))
%! assert (eq (...
%!         round (infsup ((-inf), 2.2)), ...
%!         infsup ((-inf), 2.0)))

%!test "minimal.abs_test";
%! assert (eq (...
%!         abs (infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         abs (infsup (-inf, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         abs (infsup (1.1, 2.1)), ...
%!         infsup (1.1, 2.1)))
%! assert (eq (...
%!         abs (infsup (-1.1, 2.0)), ...
%!         infsup (0.0, 2.0)))
%! assert (eq (...
%!         abs (infsup (-1.1, -0.4)), ...
%!         infsup (0.4, 1.1)))
%! assert (eq (...
%!         abs (infsup (-1.9, 0.2)), ...
%!         infsup (0.0, 1.9)))
%! assert (eq (...
%!         abs (infsup (-1.5, inf)), ...
%!         infsup (0.0, inf)))
%! assert (eq (...
%!         abs (infsup ((-inf), -2.2)), ...
%!         infsup (2.2, inf)))

%!test "minimal.min_test";
%! assert (eq (...
%!         min (infsup (), infsup (1.0, 2.0)), ...
%!         infsup ()))
%! assert (eq (...
%!         min (infsup (1.0, 2.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         min (infsup (), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         min (infsup (-inf, inf), infsup (1.0, 2.0)), ...
%!         infsup ((-inf), 2.0)))
%! assert (eq (...
%!         min (infsup (1.0, 2.0), infsup (-inf, inf)), ...
%!         infsup ((-inf), 2.0)))
%! assert (eq (...
%!         min (infsup (-inf, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         min (infsup (), infsup (-inf, inf)), ...
%!         infsup ()))
%! assert (eq (...
%!         min (infsup (1.0, 5.0), infsup (2.0, 4.0)), ...
%!         infsup (1.0, 4.0)))
%! assert (eq (...
%!         min (infsup (1.0, 5.0), infsup (2.0, 8.0)), ...
%!         infsup (1.0, 5.0)))
%! assert (eq (...
%!         min (infsup (1.0, 5.0), infsup (-inf, inf)), ...
%!         infsup ((-inf), 5.0)))
%! assert (eq (...
%!         min (infsup (-7.0, -5.0), infsup (2.0, 4.0)), ...
%!         infsup (-7.0, -5.0)))

%!test "minimal.max_test";
%! assert (eq (...
%!         max (infsup (), infsup (1.0, 2.0)), ...
%!         infsup ()))
%! assert (eq (...
%!         max (infsup (1.0, 2.0), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         max (infsup (), infsup ()), ...
%!         infsup ()))
%! assert (eq (...
%!         max (infsup (-inf, inf), infsup (1.0, 2.0)), ...
%!         infsup (1.0, inf)))
%! assert (eq (...
%!         max (infsup (1.0, 2.0), infsup (-inf, inf)), ...
%!         infsup (1.0, inf)))
%! assert (eq (...
%!         max (infsup (-inf, inf), infsup (-inf, inf)), ...
%!         infsup (-inf, inf)))
%! assert (eq (...
%!         max (infsup (), infsup (-inf, inf)), ...
%!         infsup ()))
%! assert (eq (...
%!         max (infsup (1.0, 5.0), infsup (2.0, 4.0)), ...
%!         infsup (2.0, 5.0)))
%! assert (eq (...
%!         max (infsup (1.0, 5.0), infsup (2.0, 8.0)), ...
%!         infsup (2.0, 8.0)))
%! assert (eq (...
%!         max (infsup (-1.0, 5.0), infsup (-inf, inf)), ...
%!         infsup (-1.0, inf)))
%! assert (eq (...
%!         max (infsup (-7.0, -5.0), infsup (2.0, 4.0)), ...
%!         infsup (2.0, 4.0)))
# Test library imports
%!function s = to_string (x)
%!    if (isnumeric (x))
%!        s = num2str (x);
%!    elseif (isa (x, 'infsup'))
%!        s = intervaltotext (x);
%!    else
%!        # x probably is a char.
%!        s = x;
%!    endif
%!endfunction

