Introduction
------------

Thank you for considering contributing to this project. Any contribution
is extremely welcome and appreciated.

These guidelines are designed to help all contributors understand how to
work and interact within this project.

Basics
------

* Bug reports and merge requests via GitHub are very welcome.
* Contributions include testing, writing more tests, documentation,
  submitting bug reports, and proposing new features and tests.
* Issues and changes should be small and focused on a particular topic.
* Contributors are expected to abide by the [code of conduct](CODE_OF_CONDUCT.md).
* Do not use MATLAB to develop this project! That could be a violation of your MATLAB license.
  * Only use Octave and reference to the [publicly-available MATLAB documentation](https://www.mathworks.com/help/matlab/) to develop this project.

Community
---------

All project interaction takes place on GitHub. The project community is
essentially the original author (Andrew Janke) at the moment. However, this project exists within the greater GNU Octave community. It is the author's hope
that at some point in the future, this project's components will be merged into GNU
Octave and cease to be developed in an independent project.

The GitHub home for this project is https://github.com/apjanke/octave-chrono.

Advanced
--------

* Use standard [GNU Octave code style](https://wiki.octave.org/Octave_style_guide) in all code.
  * This is important because I'd like to see this code integrated into core Octave some day.

While all contributions are welcome, the _most_ welcome type of contribution is unit tests!
Especially challenging ones that break my code.

