function GetOciTopLevelCommand_adm() {
    return 'adm'
}

function GetOciSubcommands_adm() {
    $ociSubcommands = @{
        'adm' = 'knowledge-base remediation-recipe remediation-run remediation-run-stage vulnerability-audit work-request work-request-error work-request-log-entry'
        'adm knowledge-base' = 'change-compartment create delete get list update'
        'adm remediation-recipe' = 'activate change-compartment create deactivate delete get list update'
        'adm remediation-run' = 'cancel change-compartment create delete get list list-application-dependency-recommendations update'
        'adm remediation-run-stage' = 'get-stage list-stages'
        'adm vulnerability-audit' = 'change-compartment create create-vulnerability-audit-external-resource-vulnerability-audit-source create-vulnerability-audit-oci-resource-vulnerability-audit-source create-vulnerability-audit-unknown-source-vulnerability-audit-source delete get list list-application-dependency-vulnerabilities update'
        'adm work-request' = 'cancel get list'
        'adm work-request-error' = 'list'
        'adm work-request-log-entry' = 'list-work-request-logs'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_adm() {
    $ociCommandsToLongParams = @{
        'adm knowledge-base change-compartment' = 'compartment-id from-json help if-match knowledge-base-id max-wait-seconds wait-for-state wait-interval-seconds'
        'adm knowledge-base create' = 'compartment-id defined-tags display-name freeform-tags from-json help max-wait-seconds wait-for-state wait-interval-seconds'
        'adm knowledge-base delete' = 'force from-json help if-match knowledge-base-id max-wait-seconds wait-for-state wait-interval-seconds'
        'adm knowledge-base get' = 'from-json help knowledge-base-id'
        'adm knowledge-base list' = 'all compartment-id display-name from-json help id lifecycle-state limit page page-size sort-by sort-order'
        'adm knowledge-base update' = 'defined-tags display-name force freeform-tags from-json help if-match knowledge-base-id max-wait-seconds wait-for-state wait-interval-seconds'
        'adm remediation-recipe activate' = 'from-json help if-match max-wait-seconds remediation-recipe-id wait-for-state wait-interval-seconds'
        'adm remediation-recipe change-compartment' = 'compartment-id from-json help if-match max-wait-seconds remediation-recipe-id wait-for-state wait-interval-seconds'
        'adm remediation-recipe create' = 'compartment-id defined-tags detect-configuration display-name freeform-tags from-json help is-run-triggered-on-kb-change knowledge-base-id max-wait-seconds network-configuration scm-configuration verify-configuration wait-for-state wait-interval-seconds'
        'adm remediation-recipe deactivate' = 'from-json help if-match max-wait-seconds remediation-recipe-id wait-for-state wait-interval-seconds'
        'adm remediation-recipe delete' = 'force from-json help if-match max-wait-seconds remediation-recipe-id wait-for-state wait-interval-seconds'
        'adm remediation-recipe get' = 'from-json help remediation-recipe-id'
        'adm remediation-recipe list' = 'all compartment-id display-name from-json help id lifecycle-state limit page page-size sort-by sort-order'
        'adm remediation-recipe update' = 'defined-tags detect-configuration display-name force freeform-tags from-json help if-match is-run-triggered-on-kb-change knowledge-base-id max-wait-seconds network-configuration remediation-recipe-id scm-configuration verify-configuration wait-for-state wait-interval-seconds'
        'adm remediation-run cancel' = 'from-json help if-match max-wait-seconds remediation-run-id wait-for-state wait-interval-seconds'
        'adm remediation-run change-compartment' = 'compartment-id from-json help if-match remediation-run-id'
        'adm remediation-run create' = 'defined-tags display-name freeform-tags from-json help max-wait-seconds remediation-recipe-id wait-for-state wait-interval-seconds'
        'adm remediation-run delete' = 'force from-json help if-match max-wait-seconds remediation-run-id wait-for-state wait-interval-seconds'
        'adm remediation-run get' = 'from-json help remediation-run-id'
        'adm remediation-run list' = 'all compartment-id display-name from-json help id lifecycle-state limit page page-size remediation-recipe-id sort-by sort-order'
        'adm remediation-run list-application-dependency-recommendations' = 'all from-json gav help limit page page-size purl remediation-run-id sort-by sort-order'
        'adm remediation-run update' = 'defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds remediation-run-id wait-for-state wait-interval-seconds'
        'adm remediation-run-stage get-stage' = 'from-json help remediation-run-id stage-type'
        'adm remediation-run-stage list-stages' = 'all from-json help limit page page-size remediation-run-id sort-by sort-order status type'
        'adm vulnerability-audit change-compartment' = 'compartment-id from-json help if-match vulnerability-audit-id'
        'adm vulnerability-audit create' = 'application-dependencies build-type compartment-id configuration defined-tags display-name freeform-tags from-json help if-match knowledge-base-id max-wait-seconds source usage-data wait-for-state wait-interval-seconds'
        'adm vulnerability-audit create-vulnerability-audit-external-resource-vulnerability-audit-source' = 'application-dependencies build-type compartment-id configuration defined-tags display-name freeform-tags from-json help if-match knowledge-base-id max-wait-seconds source-description usage-data wait-for-state wait-interval-seconds'
        'adm vulnerability-audit create-vulnerability-audit-oci-resource-vulnerability-audit-source' = 'application-dependencies build-type compartment-id configuration defined-tags display-name freeform-tags from-json help if-match knowledge-base-id max-wait-seconds source-oci-resource-id usage-data wait-for-state wait-interval-seconds'
        'adm vulnerability-audit create-vulnerability-audit-unknown-source-vulnerability-audit-source' = 'application-dependencies build-type compartment-id configuration defined-tags display-name freeform-tags from-json help if-match knowledge-base-id max-wait-seconds usage-data wait-for-state wait-interval-seconds'
        'adm vulnerability-audit delete' = 'force from-json help if-match max-wait-seconds vulnerability-audit-id wait-for-state wait-interval-seconds'
        'adm vulnerability-audit get' = 'from-json help vulnerability-audit-id'
        'adm vulnerability-audit list' = 'all compartment-id display-name from-json help id is-success knowledge-base-id lifecycle-state limit max-observed-severity-greater-than-or-equal-to page page-size sort-by sort-order time-created-greater-than-or-equal-to time-created-less-than-or-equal-to'
        'adm vulnerability-audit list-application-dependency-vulnerabilities' = 'all cvss-v2-greater-than-or-equal cvss-v3-greater-than-or-equal depth from-json gav help limit page page-size purl root-node-id severity-greater-than-or-equal sort-by sort-order vulnerability-audit-id vulnerability-id'
        'adm vulnerability-audit update' = 'defined-tags display-name force freeform-tags from-json help if-match max-wait-seconds vulnerability-audit-id wait-for-state wait-interval-seconds'
        'adm work-request cancel' = 'force from-json help if-match work-request-id'
        'adm work-request get' = 'from-json help work-request-id'
        'adm work-request list' = 'all compartment-id from-json help limit page page-size resource-id sort-by sort-order status work-request-id'
        'adm work-request-error list' = 'all from-json help limit page page-size sort-by sort-order work-request-id'
        'adm work-request-log-entry list-work-request-logs' = 'all from-json help limit page page-size sort-by sort-order work-request-id'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_adm() {
    $ociCommandsToShortParams = @{
        'adm knowledge-base change-compartment' = '? c h'
        'adm knowledge-base create' = '? c h'
        'adm knowledge-base delete' = '? h'
        'adm knowledge-base get' = '? h'
        'adm knowledge-base list' = '? c h'
        'adm knowledge-base update' = '? h'
        'adm remediation-recipe activate' = '? h'
        'adm remediation-recipe change-compartment' = '? c h'
        'adm remediation-recipe create' = '? c h'
        'adm remediation-recipe deactivate' = '? h'
        'adm remediation-recipe delete' = '? h'
        'adm remediation-recipe get' = '? h'
        'adm remediation-recipe list' = '? c h'
        'adm remediation-recipe update' = '? h'
        'adm remediation-run cancel' = '? h'
        'adm remediation-run change-compartment' = '? c h'
        'adm remediation-run create' = '? h'
        'adm remediation-run delete' = '? h'
        'adm remediation-run get' = '? h'
        'adm remediation-run list' = '? c h'
        'adm remediation-run list-application-dependency-recommendations' = '? h'
        'adm remediation-run update' = '? h'
        'adm remediation-run-stage get-stage' = '? h'
        'adm remediation-run-stage list-stages' = '? h'
        'adm vulnerability-audit change-compartment' = '? c h'
        'adm vulnerability-audit create' = '? c h'
        'adm vulnerability-audit create-vulnerability-audit-external-resource-vulnerability-audit-source' = '? c h'
        'adm vulnerability-audit create-vulnerability-audit-oci-resource-vulnerability-audit-source' = '? c h'
        'adm vulnerability-audit create-vulnerability-audit-unknown-source-vulnerability-audit-source' = '? c h'
        'adm vulnerability-audit delete' = '? h'
        'adm vulnerability-audit get' = '? h'
        'adm vulnerability-audit list' = '? c h'
        'adm vulnerability-audit list-application-dependency-vulnerabilities' = '? h'
        'adm vulnerability-audit update' = '? h'
        'adm work-request cancel' = '? h'
        'adm work-request get' = '? h'
        'adm work-request list' = '? c h'
        'adm work-request-error list' = '? h'
        'adm work-request-log-entry list-work-request-logs' = '? h'
    }
    return $ociCommandsToShortParams
}