# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190501

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias
from services.apigateway.src.oci_cli_apigateway.generated import api_gateway_service_cli


@click.command(cli_util.override('gateway.gateway_root_group.command_name', 'gateway'), cls=CommandGroupWithAlias, help=cli_util.override('gateway.gateway_root_group.help', """API for the API Gateway service. Use this API to manage gateways, deployments, and related items.
For more information, see
[Overview of API Gateway]."""), short_help=cli_util.override('gateway.gateway_root_group.short_help', """API Gateway API"""))
@cli_util.help_option_group
def gateway_root_group():
    pass


@click.command(cli_util.override('gateway.gateway_summary_group.command_name', 'gateway-summary'), cls=CommandGroupWithAlias, help="""A summary of the gateway.""")
@cli_util.help_option_group
def gateway_summary_group():
    pass


@click.command(cli_util.override('gateway.gateway_group.command_name', 'gateway'), cls=CommandGroupWithAlias, help="""A gateway is a virtual network appliance in a regional subnet. A gateway routes inbound traffic to back-end services including public, private, and partner HTTP APIs, as well as Oracle Functions. Avoid entering confidential information. For more information, see [API Gateway Concepts].""")
@cli_util.help_option_group
def gateway_group():
    pass


api_gateway_service_cli.api_gateway_service_group.add_command(gateway_root_group)
gateway_root_group.add_command(gateway_summary_group)
gateway_root_group.add_command(gateway_group)


@gateway_group.command(name=cli_util.override('gateway.change_gateway_compartment.command_name', 'change-compartment'), help=u"""Changes the gateway compartment. \n[Command Reference](changeGatewayCompartment)""")
@cli_util.option('--gateway-id', required=True, help=u"""The ocid of the gateway.""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment in which the resource is created.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_gateway_compartment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, gateway_id, compartment_id, if_match):

    if isinstance(gateway_id, six.string_types) and len(gateway_id.strip()) == 0:
        raise click.UsageError('Parameter --gateway-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('apigateway', 'gateway', ctx)
    result = client.change_gateway_compartment(
        gateway_id=gateway_id,
        change_gateway_compartment_details=_details,
        **kwargs
    )
    if wait_for_state:

        client = cli_util.build_client('apigateway', 'work_requests', ctx)

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@gateway_group.command(name=cli_util.override('gateway.create_gateway.command_name', 'create'), help=u"""Creates a new gateway. \n[Command Reference](createGateway)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment in which the resource is created.""")
@cli_util.option('--endpoint-type', required=True, help=u"""Gateway endpoint type. `PUBLIC` will have a public ip address assigned to it, while `PRIVATE` will only be accessible on a private IP address on the subnet.

Example: `PUBLIC` or `PRIVATE`""")
@cli_util.option('--subnet-id', required=True, help=u"""The [OCID] of the subnet in which related resources are created.""")
@cli_util.option('--display-name', help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--network-security-group-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""An array of Network Security Groups OCIDs associated with this API Gateway.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--certificate-id', help=u"""The [OCID] of the resource.""")
@cli_util.option('--response-cache-details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--ca-bundles', type=custom_types.CLI_COMPLEX_TYPE, help=u"""An array of CA bundles that should be used on the Gateway for TLS validation.

This option is a JSON list with items of type CaBundle.  For documentation on CaBundle please see our API reference: https://docs.cloud.oracle.com/api/#/en/gateway/20190501/datatypes/CaBundle.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'network-security-group-ids': {'module': 'apigateway', 'class': 'list[string]'}, 'response-cache-details': {'module': 'apigateway', 'class': 'ResponseCacheDetails'}, 'freeform-tags': {'module': 'apigateway', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apigateway', 'class': 'dict(str, dict(str, object))'}, 'ca-bundles': {'module': 'apigateway', 'class': 'list[CaBundle]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'network-security-group-ids': {'module': 'apigateway', 'class': 'list[string]'}, 'response-cache-details': {'module': 'apigateway', 'class': 'ResponseCacheDetails'}, 'freeform-tags': {'module': 'apigateway', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apigateway', 'class': 'dict(str, dict(str, object))'}, 'ca-bundles': {'module': 'apigateway', 'class': 'list[CaBundle]'}}, output_type={'module': 'apigateway', 'class': 'Gateway'})
@cli_util.wrap_exceptions
def create_gateway(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, endpoint_type, subnet_id, display_name, network_security_group_ids, certificate_id, response_cache_details, freeform_tags, defined_tags, ca_bundles):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['endpointType'] = endpoint_type
    _details['subnetId'] = subnet_id

    if display_name is not None:
        _details['displayName'] = display_name

    if network_security_group_ids is not None:
        _details['networkSecurityGroupIds'] = cli_util.parse_json_parameter("network_security_group_ids", network_security_group_ids)

    if certificate_id is not None:
        _details['certificateId'] = certificate_id

    if response_cache_details is not None:
        _details['responseCacheDetails'] = cli_util.parse_json_parameter("response_cache_details", response_cache_details)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if ca_bundles is not None:
        _details['caBundles'] = cli_util.parse_json_parameter("ca_bundles", ca_bundles)

    client = cli_util.build_client('apigateway', 'gateway', ctx)
    result = client.create_gateway(
        create_gateway_details=_details,
        **kwargs
    )
    if wait_for_state:

        client = cli_util.build_client('apigateway', 'work_requests', ctx)

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@gateway_group.command(name=cli_util.override('gateway.create_gateway_external_resp_cache.command_name', 'create-gateway-external-resp-cache'), help=u"""Creates a new gateway. \n[Command Reference](createGateway)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment in which the resource is created.""")
@cli_util.option('--endpoint-type', required=True, help=u"""Gateway endpoint type. `PUBLIC` will have a public ip address assigned to it, while `PRIVATE` will only be accessible on a private IP address on the subnet.

Example: `PUBLIC` or `PRIVATE`""")
@cli_util.option('--subnet-id', required=True, help=u"""The [OCID] of the subnet in which related resources are created.""")
@cli_util.option('--response-cache-details-servers', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""The set of cache store members to connect to. At present only a single server is supported.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--response-cache-details-authentication-secret-id', required=True, help=u"""The [OCID] of the Oracle Vault Service secret resource.""")
@cli_util.option('--response-cache-details-authentication-secret-version-number', required=True, type=click.INT, help=u"""The version number of the authentication secret to use.""")
@cli_util.option('--display-name', help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--network-security-group-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""An array of Network Security Groups OCIDs associated with this API Gateway.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--certificate-id', help=u"""The [OCID] of the resource.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--ca-bundles', type=custom_types.CLI_COMPLEX_TYPE, help=u"""An array of CA bundles that should be used on the Gateway for TLS validation.

This option is a JSON list with items of type CaBundle.  For documentation on CaBundle please see our API reference: https://docs.cloud.oracle.com/api/#/en/gateway/20190501/datatypes/CaBundle.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--response-cache-details-is-ssl-enabled', type=click.BOOL, help=u"""Defines if the connection should be over SSL.""")
@cli_util.option('--response-cache-details-is-ssl-verify-disabled', type=click.BOOL, help=u"""Defines whether or not to uphold SSL verification.""")
@cli_util.option('--response-cache-details-connect-timeout-in-ms', type=click.INT, help=u"""Defines the timeout for establishing a connection with the Response Cache.""")
@cli_util.option('--response-cache-details-read-timeout-in-ms', type=click.INT, help=u"""Defines the timeout for reading data from the Response Cache.""")
@cli_util.option('--response-cache-details-send-timeout-in-ms', type=click.INT, help=u"""Defines the timeout for transmitting data to the Response Cache.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'network-security-group-ids': {'module': 'apigateway', 'class': 'list[string]'}, 'freeform-tags': {'module': 'apigateway', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apigateway', 'class': 'dict(str, dict(str, object))'}, 'ca-bundles': {'module': 'apigateway', 'class': 'list[CaBundle]'}, 'response-cache-details-servers': {'module': 'apigateway', 'class': 'list[ResponseCacheRespServer]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'network-security-group-ids': {'module': 'apigateway', 'class': 'list[string]'}, 'freeform-tags': {'module': 'apigateway', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apigateway', 'class': 'dict(str, dict(str, object))'}, 'ca-bundles': {'module': 'apigateway', 'class': 'list[CaBundle]'}, 'response-cache-details-servers': {'module': 'apigateway', 'class': 'list[ResponseCacheRespServer]'}}, output_type={'module': 'apigateway', 'class': 'Gateway'})
@cli_util.wrap_exceptions
def create_gateway_external_resp_cache(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, endpoint_type, subnet_id, response_cache_details_servers, response_cache_details_authentication_secret_id, response_cache_details_authentication_secret_version_number, display_name, network_security_group_ids, certificate_id, freeform_tags, defined_tags, ca_bundles, response_cache_details_is_ssl_enabled, response_cache_details_is_ssl_verify_disabled, response_cache_details_connect_timeout_in_ms, response_cache_details_read_timeout_in_ms, response_cache_details_send_timeout_in_ms):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['responseCacheDetails'] = {}
    _details['compartmentId'] = compartment_id
    _details['endpointType'] = endpoint_type
    _details['subnetId'] = subnet_id
    _details['responseCacheDetails']['servers'] = cli_util.parse_json_parameter("response_cache_details_servers", response_cache_details_servers)
    _details['responseCacheDetails']['authenticationSecretId'] = response_cache_details_authentication_secret_id
    _details['responseCacheDetails']['authenticationSecretVersionNumber'] = response_cache_details_authentication_secret_version_number

    if display_name is not None:
        _details['displayName'] = display_name

    if network_security_group_ids is not None:
        _details['networkSecurityGroupIds'] = cli_util.parse_json_parameter("network_security_group_ids", network_security_group_ids)

    if certificate_id is not None:
        _details['certificateId'] = certificate_id

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if ca_bundles is not None:
        _details['caBundles'] = cli_util.parse_json_parameter("ca_bundles", ca_bundles)

    if response_cache_details_is_ssl_enabled is not None:
        _details['responseCacheDetails']['isSslEnabled'] = response_cache_details_is_ssl_enabled

    if response_cache_details_is_ssl_verify_disabled is not None:
        _details['responseCacheDetails']['isSslVerifyDisabled'] = response_cache_details_is_ssl_verify_disabled

    if response_cache_details_connect_timeout_in_ms is not None:
        _details['responseCacheDetails']['connectTimeoutInMs'] = response_cache_details_connect_timeout_in_ms

    if response_cache_details_read_timeout_in_ms is not None:
        _details['responseCacheDetails']['readTimeoutInMs'] = response_cache_details_read_timeout_in_ms

    if response_cache_details_send_timeout_in_ms is not None:
        _details['responseCacheDetails']['sendTimeoutInMs'] = response_cache_details_send_timeout_in_ms

    _details['responseCacheDetails']['type'] = 'EXTERNAL_RESP_CACHE'

    client = cli_util.build_client('apigateway', 'gateway', ctx)
    result = client.create_gateway(
        create_gateway_details=_details,
        **kwargs
    )
    if wait_for_state:

        client = cli_util.build_client('apigateway', 'work_requests', ctx)

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@gateway_group.command(name=cli_util.override('gateway.create_gateway_no_cache.command_name', 'create-gateway-no-cache'), help=u"""Creates a new gateway. \n[Command Reference](createGateway)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment in which the resource is created.""")
@cli_util.option('--endpoint-type', required=True, help=u"""Gateway endpoint type. `PUBLIC` will have a public ip address assigned to it, while `PRIVATE` will only be accessible on a private IP address on the subnet.

Example: `PUBLIC` or `PRIVATE`""")
@cli_util.option('--subnet-id', required=True, help=u"""The [OCID] of the subnet in which related resources are created.""")
@cli_util.option('--display-name', help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--network-security-group-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""An array of Network Security Groups OCIDs associated with this API Gateway.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--certificate-id', help=u"""The [OCID] of the resource.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--ca-bundles', type=custom_types.CLI_COMPLEX_TYPE, help=u"""An array of CA bundles that should be used on the Gateway for TLS validation.

This option is a JSON list with items of type CaBundle.  For documentation on CaBundle please see our API reference: https://docs.cloud.oracle.com/api/#/en/gateway/20190501/datatypes/CaBundle.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'network-security-group-ids': {'module': 'apigateway', 'class': 'list[string]'}, 'freeform-tags': {'module': 'apigateway', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apigateway', 'class': 'dict(str, dict(str, object))'}, 'ca-bundles': {'module': 'apigateway', 'class': 'list[CaBundle]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'network-security-group-ids': {'module': 'apigateway', 'class': 'list[string]'}, 'freeform-tags': {'module': 'apigateway', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apigateway', 'class': 'dict(str, dict(str, object))'}, 'ca-bundles': {'module': 'apigateway', 'class': 'list[CaBundle]'}}, output_type={'module': 'apigateway', 'class': 'Gateway'})
@cli_util.wrap_exceptions
def create_gateway_no_cache(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, endpoint_type, subnet_id, display_name, network_security_group_ids, certificate_id, freeform_tags, defined_tags, ca_bundles):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['responseCacheDetails'] = {}
    _details['compartmentId'] = compartment_id
    _details['endpointType'] = endpoint_type
    _details['subnetId'] = subnet_id

    if display_name is not None:
        _details['displayName'] = display_name

    if network_security_group_ids is not None:
        _details['networkSecurityGroupIds'] = cli_util.parse_json_parameter("network_security_group_ids", network_security_group_ids)

    if certificate_id is not None:
        _details['certificateId'] = certificate_id

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if ca_bundles is not None:
        _details['caBundles'] = cli_util.parse_json_parameter("ca_bundles", ca_bundles)

    _details['responseCacheDetails']['type'] = 'NONE'

    client = cli_util.build_client('apigateway', 'gateway', ctx)
    result = client.create_gateway(
        create_gateway_details=_details,
        **kwargs
    )
    if wait_for_state:

        client = cli_util.build_client('apigateway', 'work_requests', ctx)

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@gateway_group.command(name=cli_util.override('gateway.delete_gateway.command_name', 'delete'), help=u"""Deletes the gateway with the given identifier. \n[Command Reference](deleteGateway)""")
@cli_util.option('--gateway-id', required=True, help=u"""The ocid of the gateway.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_gateway(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, gateway_id, if_match):

    if isinstance(gateway_id, six.string_types) and len(gateway_id.strip()) == 0:
        raise click.UsageError('Parameter --gateway-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('apigateway', 'gateway', ctx)
    result = client.delete_gateway(
        gateway_id=gateway_id,
        **kwargs
    )
    if wait_for_state:

        client = cli_util.build_client('apigateway', 'work_requests', ctx)

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@gateway_group.command(name=cli_util.override('gateway.get_gateway.command_name', 'get'), help=u"""Gets a gateway by identifier. \n[Command Reference](getGateway)""")
@cli_util.option('--gateway-id', required=True, help=u"""The ocid of the gateway.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'apigateway', 'class': 'Gateway'})
@cli_util.wrap_exceptions
def get_gateway(ctx, from_json, gateway_id):

    if isinstance(gateway_id, six.string_types) and len(gateway_id.strip()) == 0:
        raise click.UsageError('Parameter --gateway-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('apigateway', 'gateway', ctx)
    result = client.get_gateway(
        gateway_id=gateway_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@gateway_summary_group.command(name=cli_util.override('gateway.list_gateways.command_name', 'list-gateways'), help=u"""Returns a list of gateways. \n[Command Reference](listGateways)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ocid of the compartment in which to list resources.""")
@cli_util.option('--certificate-id', help=u"""Filter gateways by the certificate ocid.""")
@cli_util.option('--display-name', help=u"""A user-friendly name. Does not have to be unique, and it's changeable.

Example: `My new resource`""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]), help=u"""A filter to return only resources that match the given lifecycle state.

Example: `SUCCEEDED`""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'asc' or 'desc'. The default order depends on the sortBy value.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. You can provide one sort order (`sortOrder`). Default order for `timeCreated` is descending. Default order for `displayName` is ascending. The `displayName` sort order is case sensitive.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'apigateway', 'class': 'GatewayCollection'})
@cli_util.wrap_exceptions
def list_gateways(ctx, from_json, all_pages, page_size, compartment_id, certificate_id, display_name, lifecycle_state, limit, page, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if certificate_id is not None:
        kwargs['certificate_id'] = certificate_id
    if display_name is not None:
        kwargs['display_name'] = display_name
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('apigateway', 'gateway', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_gateways,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_gateways,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_gateways(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@gateway_group.command(name=cli_util.override('gateway.update_gateway.command_name', 'update'), help=u"""Updates the gateway with the given identifier. \n[Command Reference](updateGateway)""")
@cli_util.option('--gateway-id', required=True, help=u"""The ocid of the gateway.""")
@cli_util.option('--display-name', help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--network-security-group-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""An array of Network Security Groups OCIDs associated with this API Gateway.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--certificate-id', help=u"""The [OCID] of the resource.""")
@cli_util.option('--response-cache-details', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--ca-bundles', type=custom_types.CLI_COMPLEX_TYPE, help=u"""An array of CA bundles that should be used on the Gateway for TLS validation.

This option is a JSON list with items of type CaBundle.  For documentation on CaBundle please see our API reference: https://docs.cloud.oracle.com/api/#/en/gateway/20190501/datatypes/CaBundle.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'network-security-group-ids': {'module': 'apigateway', 'class': 'list[string]'}, 'response-cache-details': {'module': 'apigateway', 'class': 'ResponseCacheDetails'}, 'freeform-tags': {'module': 'apigateway', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apigateway', 'class': 'dict(str, dict(str, object))'}, 'ca-bundles': {'module': 'apigateway', 'class': 'list[CaBundle]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'network-security-group-ids': {'module': 'apigateway', 'class': 'list[string]'}, 'response-cache-details': {'module': 'apigateway', 'class': 'ResponseCacheDetails'}, 'freeform-tags': {'module': 'apigateway', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apigateway', 'class': 'dict(str, dict(str, object))'}, 'ca-bundles': {'module': 'apigateway', 'class': 'list[CaBundle]'}})
@cli_util.wrap_exceptions
def update_gateway(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, gateway_id, display_name, network_security_group_ids, certificate_id, response_cache_details, freeform_tags, defined_tags, ca_bundles, if_match):

    if isinstance(gateway_id, six.string_types) and len(gateway_id.strip()) == 0:
        raise click.UsageError('Parameter --gateway-id cannot be whitespace or empty string')
    if not force:
        if network_security_group_ids or response_cache_details or freeform_tags or defined_tags or ca_bundles:
            if not click.confirm("WARNING: Updates to network-security-group-ids and response-cache-details and freeform-tags and defined-tags and ca-bundles will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if network_security_group_ids is not None:
        _details['networkSecurityGroupIds'] = cli_util.parse_json_parameter("network_security_group_ids", network_security_group_ids)

    if certificate_id is not None:
        _details['certificateId'] = certificate_id

    if response_cache_details is not None:
        _details['responseCacheDetails'] = cli_util.parse_json_parameter("response_cache_details", response_cache_details)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if ca_bundles is not None:
        _details['caBundles'] = cli_util.parse_json_parameter("ca_bundles", ca_bundles)

    client = cli_util.build_client('apigateway', 'gateway', ctx)
    result = client.update_gateway(
        gateway_id=gateway_id,
        update_gateway_details=_details,
        **kwargs
    )
    if wait_for_state:

        client = cli_util.build_client('apigateway', 'work_requests', ctx)

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@gateway_group.command(name=cli_util.override('gateway.update_gateway_external_resp_cache.command_name', 'update-gateway-external-resp-cache'), help=u"""Updates the gateway with the given identifier. \n[Command Reference](updateGateway)""")
@cli_util.option('--gateway-id', required=True, help=u"""The ocid of the gateway.""")
@cli_util.option('--response-cache-details-servers', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""The set of cache store members to connect to. At present only a single server is supported.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--response-cache-details-authentication-secret-id', required=True, help=u"""The [OCID] of the Oracle Vault Service secret resource.""")
@cli_util.option('--response-cache-details-authentication-secret-version-number', required=True, type=click.INT, help=u"""The version number of the authentication secret to use.""")
@cli_util.option('--display-name', help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--network-security-group-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""An array of Network Security Groups OCIDs associated with this API Gateway.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--certificate-id', help=u"""The [OCID] of the resource.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--ca-bundles', type=custom_types.CLI_COMPLEX_TYPE, help=u"""An array of CA bundles that should be used on the Gateway for TLS validation.

This option is a JSON list with items of type CaBundle.  For documentation on CaBundle please see our API reference: https://docs.cloud.oracle.com/api/#/en/gateway/20190501/datatypes/CaBundle.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--response-cache-details-is-ssl-enabled', type=click.BOOL, help=u"""Defines if the connection should be over SSL.""")
@cli_util.option('--response-cache-details-is-ssl-verify-disabled', type=click.BOOL, help=u"""Defines whether or not to uphold SSL verification.""")
@cli_util.option('--response-cache-details-connect-timeout-in-ms', type=click.INT, help=u"""Defines the timeout for establishing a connection with the Response Cache.""")
@cli_util.option('--response-cache-details-read-timeout-in-ms', type=click.INT, help=u"""Defines the timeout for reading data from the Response Cache.""")
@cli_util.option('--response-cache-details-send-timeout-in-ms', type=click.INT, help=u"""Defines the timeout for transmitting data to the Response Cache.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'network-security-group-ids': {'module': 'apigateway', 'class': 'list[string]'}, 'freeform-tags': {'module': 'apigateway', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apigateway', 'class': 'dict(str, dict(str, object))'}, 'ca-bundles': {'module': 'apigateway', 'class': 'list[CaBundle]'}, 'response-cache-details-servers': {'module': 'apigateway', 'class': 'list[ResponseCacheRespServer]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'network-security-group-ids': {'module': 'apigateway', 'class': 'list[string]'}, 'freeform-tags': {'module': 'apigateway', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apigateway', 'class': 'dict(str, dict(str, object))'}, 'ca-bundles': {'module': 'apigateway', 'class': 'list[CaBundle]'}, 'response-cache-details-servers': {'module': 'apigateway', 'class': 'list[ResponseCacheRespServer]'}})
@cli_util.wrap_exceptions
def update_gateway_external_resp_cache(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, gateway_id, response_cache_details_servers, response_cache_details_authentication_secret_id, response_cache_details_authentication_secret_version_number, display_name, network_security_group_ids, certificate_id, freeform_tags, defined_tags, ca_bundles, if_match, response_cache_details_is_ssl_enabled, response_cache_details_is_ssl_verify_disabled, response_cache_details_connect_timeout_in_ms, response_cache_details_read_timeout_in_ms, response_cache_details_send_timeout_in_ms):

    if isinstance(gateway_id, six.string_types) and len(gateway_id.strip()) == 0:
        raise click.UsageError('Parameter --gateway-id cannot be whitespace or empty string')
    if not force:
        if network_security_group_ids or freeform_tags or defined_tags or ca_bundles:
            if not click.confirm("WARNING: Updates to network-security-group-ids and freeform-tags and defined-tags and ca-bundles will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['responseCacheDetails'] = {}
    _details['responseCacheDetails']['servers'] = cli_util.parse_json_parameter("response_cache_details_servers", response_cache_details_servers)
    _details['responseCacheDetails']['authenticationSecretId'] = response_cache_details_authentication_secret_id
    _details['responseCacheDetails']['authenticationSecretVersionNumber'] = response_cache_details_authentication_secret_version_number

    if display_name is not None:
        _details['displayName'] = display_name

    if network_security_group_ids is not None:
        _details['networkSecurityGroupIds'] = cli_util.parse_json_parameter("network_security_group_ids", network_security_group_ids)

    if certificate_id is not None:
        _details['certificateId'] = certificate_id

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if ca_bundles is not None:
        _details['caBundles'] = cli_util.parse_json_parameter("ca_bundles", ca_bundles)

    if response_cache_details_is_ssl_enabled is not None:
        _details['responseCacheDetails']['isSslEnabled'] = response_cache_details_is_ssl_enabled

    if response_cache_details_is_ssl_verify_disabled is not None:
        _details['responseCacheDetails']['isSslVerifyDisabled'] = response_cache_details_is_ssl_verify_disabled

    if response_cache_details_connect_timeout_in_ms is not None:
        _details['responseCacheDetails']['connectTimeoutInMs'] = response_cache_details_connect_timeout_in_ms

    if response_cache_details_read_timeout_in_ms is not None:
        _details['responseCacheDetails']['readTimeoutInMs'] = response_cache_details_read_timeout_in_ms

    if response_cache_details_send_timeout_in_ms is not None:
        _details['responseCacheDetails']['sendTimeoutInMs'] = response_cache_details_send_timeout_in_ms

    _details['responseCacheDetails']['type'] = 'EXTERNAL_RESP_CACHE'

    client = cli_util.build_client('apigateway', 'gateway', ctx)
    result = client.update_gateway(
        gateway_id=gateway_id,
        update_gateway_details=_details,
        **kwargs
    )
    if wait_for_state:

        client = cli_util.build_client('apigateway', 'work_requests', ctx)

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@gateway_group.command(name=cli_util.override('gateway.update_gateway_no_cache.command_name', 'update-gateway-no-cache'), help=u"""Updates the gateway with the given identifier. \n[Command Reference](updateGateway)""")
@cli_util.option('--gateway-id', required=True, help=u"""The ocid of the gateway.""")
@cli_util.option('--display-name', help=u"""A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.

Example: `My new resource`""")
@cli_util.option('--network-security-group-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""An array of Network Security Groups OCIDs associated with this API Gateway.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--certificate-id', help=u"""The [OCID] of the resource.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags].

Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags].

Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--ca-bundles', type=custom_types.CLI_COMPLEX_TYPE, help=u"""An array of CA bundles that should be used on the Gateway for TLS validation.

This option is a JSON list with items of type CaBundle.  For documentation on CaBundle please see our API reference: https://docs.cloud.oracle.com/api/#/en/gateway/20190501/datatypes/CaBundle.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'network-security-group-ids': {'module': 'apigateway', 'class': 'list[string]'}, 'freeform-tags': {'module': 'apigateway', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apigateway', 'class': 'dict(str, dict(str, object))'}, 'ca-bundles': {'module': 'apigateway', 'class': 'list[CaBundle]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'network-security-group-ids': {'module': 'apigateway', 'class': 'list[string]'}, 'freeform-tags': {'module': 'apigateway', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'apigateway', 'class': 'dict(str, dict(str, object))'}, 'ca-bundles': {'module': 'apigateway', 'class': 'list[CaBundle]'}})
@cli_util.wrap_exceptions
def update_gateway_no_cache(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, gateway_id, display_name, network_security_group_ids, certificate_id, freeform_tags, defined_tags, ca_bundles, if_match):

    if isinstance(gateway_id, six.string_types) and len(gateway_id.strip()) == 0:
        raise click.UsageError('Parameter --gateway-id cannot be whitespace or empty string')
    if not force:
        if network_security_group_ids or freeform_tags or defined_tags or ca_bundles:
            if not click.confirm("WARNING: Updates to network-security-group-ids and freeform-tags and defined-tags and ca-bundles will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['responseCacheDetails'] = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if network_security_group_ids is not None:
        _details['networkSecurityGroupIds'] = cli_util.parse_json_parameter("network_security_group_ids", network_security_group_ids)

    if certificate_id is not None:
        _details['certificateId'] = certificate_id

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    if ca_bundles is not None:
        _details['caBundles'] = cli_util.parse_json_parameter("ca_bundles", ca_bundles)

    _details['responseCacheDetails']['type'] = 'NONE'

    client = cli_util.build_client('apigateway', 'gateway', ctx)
    result = client.update_gateway(
        gateway_id=gateway_id,
        update_gateway_details=_details,
        **kwargs
    )
    if wait_for_state:

        client = cli_util.build_client('apigateway', 'work_requests', ctx)

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds
                if 'opc-work-request-id' not in result.headers:
                    click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state')
                    cli_util.render_response(result, ctx)
                    return

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)
