function GetOciTopLevelCommand_oda() {
    return 'oda'
}

function GetOciSubcommands_oda() {
    $ociSubcommands = @{
        'oda' = 'instance management oda-instance-attachment oda-instance-attachment-collection odapackage work-request work-request-error work-request-log-entry'
        'oda instance' = 'change-compartment create delete get list start stop update'
        'oda management' = 'authentication-provider bot channel digital-assistant digital-assistant-parameter oda-private-endpoint oda-private-endpoint-attachment oda-private-endpoint-scan-proxy skill skill-parameter translator'
        'oda management authentication-provider' = 'create delete get list update'
        'oda management bot' = 'import'
        'oda management channel' = 'create create-channel-create-android-channel-details create-channel-create-app-event-channel-details create-channel-create-application-channel-details create-channel-create-cortana-channel-details create-channel-create-facebook-channel-details create-channel-create-ios-channel-details create-channel-create-ms-teams-channel-details create-channel-create-oss-channel-details create-channel-create-osvc-channel-details create-channel-create-service-cloud-channel-details create-channel-create-slack-channel-details create-channel-create-twilio-channel-details create-channel-create-web-channel-details create-channel-create-webhook-channel-details delete get list rotate-channel-keys start stop update update-channel-update-android-channel-details update-channel-update-app-event-channel-details update-channel-update-application-channel-details update-channel-update-cortana-channel-details update-channel-update-facebook-channel-details update-channel-update-ios-channel-details update-channel-update-ms-teams-channel-details update-channel-update-oss-channel-details update-channel-update-osvc-channel-details update-channel-update-service-cloud-channel-details update-channel-update-slack-channel-details update-channel-update-twilio-channel-details update-channel-update-web-channel-details update-channel-update-webhook-channel-details'
        'oda management digital-assistant' = 'create create-digital-assistant-clone-digital-assistant-details create-digital-assistant-create-digital-assistant-version-details create-digital-assistant-create-new-digital-assistant-details create-digital-assistant-extend-digital-assistant-details delete get list publish update'
        'oda management digital-assistant-parameter' = 'configure get list update'
        'oda management oda-private-endpoint' = 'change-compartment create delete get list update'
        'oda management oda-private-endpoint-attachment' = 'create delete get list'
        'oda management oda-private-endpoint-scan-proxy' = 'create delete get list'
        'oda management skill' = 'create create-skill-clone-skill-details create-skill-create-new-skill-details create-skill-create-skill-version-details create-skill-extend-skill-details delete export export-digital-assistant get list publish update'
        'oda management skill-parameter' = 'create delete get list update'
        'oda management translator' = 'create delete get list update'
        'oda oda-instance-attachment' = 'create delete get update'
        'oda oda-instance-attachment-collection' = 'list-oda-instance-attachments'
        'oda odapackage' = 'imported-package package'
        'oda odapackage imported-package' = 'create delete get list update'
        'oda odapackage package' = 'get list'
        'oda work-request' = 'get list'
        'oda work-request-error' = 'list'
        'oda work-request-log-entry' = 'list'
    }
    return $ociSubcommands
}

function GetOciCommandsToLongParams_oda() {
    $ociCommandsToLongParams = @{
        'oda instance change-compartment' = 'compartment-id from-json help if-match max-wait-seconds oda-instance-id wait-for-state wait-interval-seconds'
        'oda instance create' = 'compartment-id defined-tags description display-name freeform-tags from-json help identity-domain is-role-based-access max-wait-seconds shape-name wait-for-state wait-interval-seconds'
        'oda instance delete' = 'force from-json help if-match max-wait-seconds oda-instance-id retention-time wait-for-state wait-interval-seconds'
        'oda instance get' = 'from-json help oda-instance-id'
        'oda instance list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'oda instance start' = 'from-json help if-match max-wait-seconds oda-instance-id wait-for-state wait-interval-seconds'
        'oda instance stop' = 'from-json help if-match max-wait-seconds oda-instance-id wait-for-state wait-interval-seconds'
        'oda instance update' = 'defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds oda-instance-id wait-for-state wait-interval-seconds'
        'oda management authentication-provider create' = 'authorization-endpoint-url client-id client-secret defined-tags freeform-tags from-json grant-type help identity-provider is-visible max-wait-seconds name oda-instance-id redirect-url refresh-token-retention-period-in-days revoke-token-endpoint-url scopes short-authorization-code-request-url subject-claim token-endpoint-url wait-for-state wait-interval-seconds'
        'oda management authentication-provider delete' = 'authentication-provider-id force from-json help if-match oda-instance-id'
        'oda management authentication-provider get' = 'authentication-provider-id from-json help if-none-match oda-instance-id'
        'oda management authentication-provider list' = 'all from-json help id identity-provider lifecycle-state limit name oda-instance-id page page-size sort-by sort-order'
        'oda management authentication-provider update' = 'authentication-provider-id authorization-endpoint-url client-id client-secret defined-tags force freeform-tags from-json help if-match max-wait-seconds oda-instance-id redirect-url refresh-token-retention-period-in-days revoke-token-endpoint-url scopes short-authorization-code-request-url subject-claim token-endpoint-url wait-for-state wait-interval-seconds'
        'oda management bot import' = 'from-json help max-wait-seconds oda-instance-id source wait-for-state wait-interval-seconds'
        'oda management channel create' = 'defined-tags description freeform-tags from-json help name oda-instance-id session-expiry-duration-in-milliseconds type'
        'oda management channel create-channel-create-android-channel-details' = 'bot-id defined-tags description freeform-tags from-json help is-client-authentication-enabled max-token-expiration-time-in-minutes name oda-instance-id session-expiry-duration-in-milliseconds'
        'oda management channel create-channel-create-app-event-channel-details' = 'defined-tags description event-sink-bot-ids freeform-tags from-json help name oda-instance-id outbound-url session-expiry-duration-in-milliseconds'
        'oda management channel create-channel-create-application-channel-details' = 'defined-tags description freeform-tags from-json help is-authenticated-user-id name oda-instance-id outbound-url session-expiry-duration-in-milliseconds'
        'oda management channel create-channel-create-cortana-channel-details' = 'bot-id defined-tags description freeform-tags from-json help msa-app-id msa-app-password name oda-instance-id session-expiry-duration-in-milliseconds'
        'oda management channel create-channel-create-facebook-channel-details' = 'app-secret bot-id defined-tags description freeform-tags from-json help name oda-instance-id page-access-token session-expiry-duration-in-milliseconds'
        'oda management channel create-channel-create-ios-channel-details' = 'bot-id defined-tags description freeform-tags from-json help is-client-authentication-enabled max-token-expiration-time-in-minutes name oda-instance-id session-expiry-duration-in-milliseconds'
        'oda management channel create-channel-create-ms-teams-channel-details' = 'bot-id defined-tags description freeform-tags from-json help msa-app-id msa-app-password name oda-instance-id session-expiry-duration-in-milliseconds'
        'oda management channel create-channel-create-oss-channel-details' = 'auth-token bootstrap-servers defined-tags description event-sink-bot-ids freeform-tags from-json help inbound-message-topic name oda-instance-id outbound-message-topic sasl-mechanism security-protocol session-expiry-duration-in-milliseconds stream-pool-id tenancy-name user-name'
        'oda management channel create-channel-create-osvc-channel-details' = 'authentication-provider-name bot-id channel-service defined-tags description freeform-tags from-json help host name oda-instance-id password port session-expiry-duration-in-milliseconds total-session-count user-name'
        'oda management channel create-channel-create-service-cloud-channel-details' = 'client-type defined-tags description domain-name freeform-tags from-json help host-name-prefix name oda-instance-id password session-expiry-duration-in-milliseconds user-name'
        'oda management channel create-channel-create-slack-channel-details' = 'auth-error-url auth-success-url bot-id client-id client-secret defined-tags description freeform-tags from-json help name oda-instance-id session-expiry-duration-in-milliseconds signing-secret'
        'oda management channel create-channel-create-twilio-channel-details' = 'account-sid auth-token bot-id defined-tags description freeform-tags from-json help is-mms-enabled name oda-instance-id original-connectors-url phone-number session-expiry-duration-in-milliseconds'
        'oda management channel create-channel-create-web-channel-details' = 'allowed-domains bot-id defined-tags description freeform-tags from-json help is-client-authentication-enabled max-token-expiration-time-in-minutes name oda-instance-id session-expiry-duration-in-milliseconds'
        'oda management channel create-channel-create-webhook-channel-details' = 'bot-id defined-tags description freeform-tags from-json help name oda-instance-id outbound-url payload-version session-expiry-duration-in-milliseconds'
        'oda management channel delete' = 'channel-id force from-json help if-match oda-instance-id'
        'oda management channel get' = 'channel-id from-json help if-none-match oda-instance-id'
        'oda management channel list' = 'all category from-json help id lifecycle-state limit name oda-instance-id page page-size sort-by sort-order type'
        'oda management channel rotate-channel-keys' = 'channel-id from-json help if-match oda-instance-id'
        'oda management channel start' = 'channel-id from-json help if-match max-wait-seconds oda-instance-id wait-for-state wait-interval-seconds'
        'oda management channel stop' = 'channel-id from-json help if-match max-wait-seconds oda-instance-id wait-for-state wait-interval-seconds'
        'oda management channel update' = 'channel-id defined-tags description force freeform-tags from-json help if-match max-wait-seconds name oda-instance-id session-expiry-duration-in-milliseconds type wait-for-state wait-interval-seconds'
        'oda management channel update-channel-update-android-channel-details' = 'bot-id channel-id defined-tags description force freeform-tags from-json help if-match is-client-authentication-enabled max-token-expiration-time-in-minutes max-wait-seconds name oda-instance-id session-expiry-duration-in-milliseconds wait-for-state wait-interval-seconds'
        'oda management channel update-channel-update-app-event-channel-details' = 'channel-id defined-tags description event-sink-bot-ids force freeform-tags from-json help if-match max-wait-seconds name oda-instance-id outbound-url session-expiry-duration-in-milliseconds wait-for-state wait-interval-seconds'
        'oda management channel update-channel-update-application-channel-details' = 'channel-id defined-tags description force freeform-tags from-json help if-match is-authenticated-user-id max-wait-seconds name oda-instance-id outbound-url session-expiry-duration-in-milliseconds wait-for-state wait-interval-seconds'
        'oda management channel update-channel-update-cortana-channel-details' = 'bot-id channel-id defined-tags description force freeform-tags from-json help if-match max-wait-seconds msa-app-id msa-app-password name oda-instance-id session-expiry-duration-in-milliseconds wait-for-state wait-interval-seconds'
        'oda management channel update-channel-update-facebook-channel-details' = 'app-secret bot-id channel-id defined-tags description force freeform-tags from-json help if-match max-wait-seconds name oda-instance-id page-access-token session-expiry-duration-in-milliseconds wait-for-state wait-interval-seconds'
        'oda management channel update-channel-update-ios-channel-details' = 'bot-id channel-id defined-tags description force freeform-tags from-json help if-match is-client-authentication-enabled max-token-expiration-time-in-minutes max-wait-seconds name oda-instance-id session-expiry-duration-in-milliseconds wait-for-state wait-interval-seconds'
        'oda management channel update-channel-update-ms-teams-channel-details' = 'bot-id channel-id defined-tags description force freeform-tags from-json help if-match max-wait-seconds msa-app-id msa-app-password name oda-instance-id session-expiry-duration-in-milliseconds wait-for-state wait-interval-seconds'
        'oda management channel update-channel-update-oss-channel-details' = 'auth-token bootstrap-servers channel-id defined-tags description event-sink-bot-ids force freeform-tags from-json help if-match inbound-message-topic max-wait-seconds name oda-instance-id outbound-message-topic sasl-mechanism security-protocol session-expiry-duration-in-milliseconds stream-pool-id tenancy-name user-name wait-for-state wait-interval-seconds'
        'oda management channel update-channel-update-osvc-channel-details' = 'authentication-provider-name bot-id channel-id channel-service defined-tags description force freeform-tags from-json help host if-match max-wait-seconds name oda-instance-id password port session-expiry-duration-in-milliseconds total-session-count user-name wait-for-state wait-interval-seconds'
        'oda management channel update-channel-update-service-cloud-channel-details' = 'channel-id client-type defined-tags description domain-name force freeform-tags from-json help host-name-prefix if-match max-wait-seconds name oda-instance-id password session-expiry-duration-in-milliseconds user-name wait-for-state wait-interval-seconds'
        'oda management channel update-channel-update-slack-channel-details' = 'auth-error-url auth-success-url bot-id channel-id client-id client-secret defined-tags description force freeform-tags from-json help if-match max-wait-seconds name oda-instance-id session-expiry-duration-in-milliseconds signing-secret wait-for-state wait-interval-seconds'
        'oda management channel update-channel-update-twilio-channel-details' = 'account-sid auth-token bot-id channel-id defined-tags description force freeform-tags from-json help if-match is-mms-enabled max-wait-seconds name oda-instance-id original-connectors-url phone-number session-expiry-duration-in-milliseconds wait-for-state wait-interval-seconds'
        'oda management channel update-channel-update-web-channel-details' = 'allowed-domains bot-id channel-id defined-tags description force freeform-tags from-json help if-match is-client-authentication-enabled max-token-expiration-time-in-minutes max-wait-seconds name oda-instance-id session-expiry-duration-in-milliseconds wait-for-state wait-interval-seconds'
        'oda management channel update-channel-update-webhook-channel-details' = 'bot-id channel-id defined-tags description force freeform-tags from-json help if-match max-wait-seconds name oda-instance-id outbound-url payload-version session-expiry-duration-in-milliseconds wait-for-state wait-interval-seconds'
        'oda management digital-assistant create' = 'category defined-tags description freeform-tags from-json help kind max-wait-seconds multilingual-mode oda-instance-id platform-version primary-language-tag wait-for-state wait-interval-seconds'
        'oda management digital-assistant create-digital-assistant-clone-digital-assistant-details' = 'category defined-tags description display-name freeform-tags from-json help id max-wait-seconds multilingual-mode name oda-instance-id platform-version primary-language-tag version-parameterconflict wait-for-state wait-interval-seconds'
        'oda management digital-assistant create-digital-assistant-create-digital-assistant-version-details' = 'category defined-tags description freeform-tags from-json help id max-wait-seconds multilingual-mode oda-instance-id platform-version primary-language-tag version-parameterconflict wait-for-state wait-interval-seconds'
        'oda management digital-assistant create-digital-assistant-create-new-digital-assistant-details' = 'category defined-tags description display-name freeform-tags from-json help max-wait-seconds multilingual-mode name native-language-tags oda-instance-id platform-version primary-language-tag version-parameterconflict wait-for-state wait-interval-seconds'
        'oda management digital-assistant create-digital-assistant-extend-digital-assistant-details' = 'category defined-tags description display-name freeform-tags from-json help id max-wait-seconds multilingual-mode name oda-instance-id platform-version primary-language-tag version-parameterconflict wait-for-state wait-interval-seconds'
        'oda management digital-assistant delete' = 'digital-assistant-id force from-json help if-match oda-instance-id'
        'oda management digital-assistant get' = 'digital-assistant-id from-json help if-none-match oda-instance-id'
        'oda management digital-assistant list' = 'all category from-json help id lifecycle-details lifecycle-state limit name namespace oda-instance-id page page-size platform-version sort-by sort-order version-parameterconflict'
        'oda management digital-assistant publish' = 'digital-assistant-id from-json help if-match max-wait-seconds oda-instance-id wait-for-state wait-interval-seconds'
        'oda management digital-assistant update' = 'category defined-tags description digital-assistant-id force freeform-tags from-json help if-match max-wait-seconds oda-instance-id wait-for-state wait-interval-seconds'
        'oda management digital-assistant-parameter configure' = 'from-json help oda-instance-id parameters'
        'oda management digital-assistant-parameter get' = 'digital-assistant-id from-json help if-none-match oda-instance-id parameter-name'
        'oda management digital-assistant-parameter list' = 'all digital-assistant-id from-json help lifecycle-state limit name oda-instance-id page page-size sort-by sort-order'
        'oda management digital-assistant-parameter update' = 'digital-assistant-id from-json help if-match max-wait-seconds oda-instance-id parameter-name value wait-for-state wait-interval-seconds'
        'oda management oda-private-endpoint change-compartment' = 'compartment-id from-json help if-match max-wait-seconds oda-private-endpoint-id wait-for-state wait-interval-seconds'
        'oda management oda-private-endpoint create' = 'compartment-id defined-tags description display-name freeform-tags from-json help max-wait-seconds nsg-ids subnet-id wait-for-state wait-interval-seconds'
        'oda management oda-private-endpoint delete' = 'force from-json help if-match max-wait-seconds oda-private-endpoint-id wait-for-state wait-interval-seconds'
        'oda management oda-private-endpoint get' = 'from-json help oda-private-endpoint-id'
        'oda management oda-private-endpoint list' = 'all compartment-id display-name from-json help lifecycle-state limit page page-size sort-by sort-order'
        'oda management oda-private-endpoint update' = 'defined-tags description display-name force freeform-tags from-json help if-match max-wait-seconds nsg-ids oda-private-endpoint-id wait-for-state wait-interval-seconds'
        'oda management oda-private-endpoint-attachment create' = 'from-json help max-wait-seconds oda-instance-id oda-private-endpoint-id wait-for-state wait-interval-seconds'
        'oda management oda-private-endpoint-attachment delete' = 'force from-json help if-match max-wait-seconds oda-private-endpoint-attachment-id wait-for-state wait-interval-seconds'
        'oda management oda-private-endpoint-attachment get' = 'from-json help oda-private-endpoint-attachment-id'
        'oda management oda-private-endpoint-attachment list' = 'all compartment-id from-json help lifecycle-state limit oda-private-endpoint-id page page-size sort-by sort-order'
        'oda management oda-private-endpoint-scan-proxy create' = 'from-json help max-wait-seconds oda-private-endpoint-id protocol scan-listener-infos scan-listener-type wait-for-state wait-interval-seconds'
        'oda management oda-private-endpoint-scan-proxy delete' = 'force from-json help if-match max-wait-seconds oda-private-endpoint-id oda-private-endpoint-scan-proxy-id wait-for-state wait-interval-seconds'
        'oda management oda-private-endpoint-scan-proxy get' = 'from-json help oda-private-endpoint-id oda-private-endpoint-scan-proxy-id'
        'oda management oda-private-endpoint-scan-proxy list' = 'all from-json help lifecycle-state limit oda-private-endpoint-id page page-size sort-by sort-order'
        'oda management skill create' = 'category defined-tags description freeform-tags from-json help kind max-wait-seconds multilingual-mode oda-instance-id platform-version primary-language-tag wait-for-state wait-interval-seconds'
        'oda management skill create-skill-clone-skill-details' = 'category defined-tags description display-name freeform-tags from-json help id max-wait-seconds multilingual-mode name oda-instance-id platform-version primary-language-tag version-parameterconflict wait-for-state wait-interval-seconds'
        'oda management skill create-skill-create-new-skill-details' = 'category defined-tags description display-name freeform-tags from-json help max-wait-seconds multilingual-mode name native-language-tags oda-instance-id platform-version primary-language-tag version-parameterconflict wait-for-state wait-interval-seconds'
        'oda management skill create-skill-create-skill-version-details' = 'category defined-tags description freeform-tags from-json help id max-wait-seconds multilingual-mode oda-instance-id platform-version primary-language-tag version-parameterconflict wait-for-state wait-interval-seconds'
        'oda management skill create-skill-extend-skill-details' = 'category defined-tags description display-name freeform-tags from-json help id max-wait-seconds multilingual-mode name oda-instance-id platform-version primary-language-tag version-parameterconflict wait-for-state wait-interval-seconds'
        'oda management skill delete' = 'force from-json help if-match oda-instance-id skill-id'
        'oda management skill export' = 'from-json help max-wait-seconds oda-instance-id skill-id target wait-for-state wait-interval-seconds'
        'oda management skill export-digital-assistant' = 'digital-assistant-id from-json help max-wait-seconds oda-instance-id target wait-for-state wait-interval-seconds'
        'oda management skill get' = 'from-json help if-none-match oda-instance-id skill-id'
        'oda management skill list' = 'all category from-json help id lifecycle-details lifecycle-state limit name namespace oda-instance-id page page-size platform-version sort-by sort-order version-parameterconflict'
        'oda management skill publish' = 'from-json help if-match max-wait-seconds oda-instance-id skill-id wait-for-state wait-interval-seconds'
        'oda management skill update' = 'category defined-tags description force freeform-tags from-json help if-match max-wait-seconds oda-instance-id skill-id wait-for-state wait-interval-seconds'
        'oda management skill-parameter create' = 'description display-name from-json help max-wait-seconds name oda-instance-id skill-id type value wait-for-state wait-interval-seconds'
        'oda management skill-parameter delete' = 'force from-json help if-match oda-instance-id parameter-name skill-id'
        'oda management skill-parameter get' = 'from-json help if-none-match oda-instance-id parameter-name skill-id'
        'oda management skill-parameter list' = 'all from-json help lifecycle-state limit name oda-instance-id page page-size skill-id sort-by sort-order'
        'oda management skill-parameter update' = 'description display-name from-json help if-match max-wait-seconds oda-instance-id parameter-name skill-id value wait-for-state wait-interval-seconds'
        'oda management translator create' = 'auth-token base-url defined-tags freeform-tags from-json help max-wait-seconds oda-instance-id properties type wait-for-state wait-interval-seconds'
        'oda management translator delete' = 'force from-json help if-match oda-instance-id translator-id'
        'oda management translator get' = 'from-json help if-none-match oda-instance-id translator-id'
        'oda management translator list' = 'all from-json help id lifecycle-state limit name oda-instance-id page page-size sort-by sort-order type'
        'oda management translator update' = 'auth-token base-url defined-tags force freeform-tags from-json help if-match max-wait-seconds oda-instance-id properties translator-id wait-for-state wait-interval-seconds'
        'oda oda-instance-attachment create' = 'attach-to-id attachment-metadata attachment-type defined-tags freeform-tags from-json help max-wait-seconds oda-instance-id owner restricted-operations wait-for-state wait-interval-seconds'
        'oda oda-instance-attachment delete' = 'attachment-id force from-json help if-match max-wait-seconds oda-instance-id wait-for-state wait-interval-seconds'
        'oda oda-instance-attachment get' = 'attachment-id from-json help include-owner-metadata oda-instance-id'
        'oda oda-instance-attachment update' = 'attachment-id attachment-metadata defined-tags force freeform-tags from-json help if-match max-wait-seconds oda-instance-id owner restricted-operations wait-for-state wait-interval-seconds'
        'oda oda-instance-attachment-collection list-oda-instance-attachments' = 'all from-json help include-owner-metadata lifecycle-state limit oda-instance-id page page-size sort-by sort-order'
        'oda odapackage imported-package create' = 'current-package-id defined-tags freeform-tags from-json help max-wait-seconds oda-instance-id parameter-values wait-for-state wait-interval-seconds'
        'oda odapackage imported-package delete' = 'force from-json help if-match max-wait-seconds oda-instance-id package-id wait-for-state wait-interval-seconds'
        'oda odapackage imported-package get' = 'from-json help oda-instance-id package-id'
        'oda odapackage imported-package list' = 'all from-json help limit name oda-instance-id page page-size sort-by sort-order'
        'oda odapackage imported-package update' = 'current-package-id defined-tags force freeform-tags from-json help if-match is-replace-skills max-wait-seconds oda-instance-id package-id parameter-values wait-for-state wait-interval-seconds'
        'oda odapackage package get' = 'from-json help oda-instance-id package-id'
        'oda odapackage package list' = 'all compartment-id display-name from-json help is-latest-version-only limit name oda-instance-id page page-size resource-type sort-by sort-order'
        'oda work-request get' = 'from-json help work-request-id'
        'oda work-request list' = 'all compartment-id from-json help limit oda-instance-id page page-size resource-id sort-by sort-order'
        'oda work-request-error list' = 'all from-json help limit page page-size sort-by sort-order work-request-id'
        'oda work-request-log-entry list' = 'all from-json help limit page page-size sort-by sort-order work-request-id'
    }
    return $ociCommandsToLongParams
}

function GetOciCommandsToShortParams_oda() {
    $ociCommandsToShortParams = @{
        'oda instance change-compartment' = '? c h'
        'oda instance create' = '? c h'
        'oda instance delete' = '? h'
        'oda instance get' = '? h'
        'oda instance list' = '? c h'
        'oda instance start' = '? h'
        'oda instance stop' = '? h'
        'oda instance update' = '? h'
        'oda management authentication-provider create' = '? h'
        'oda management authentication-provider delete' = '? h'
        'oda management authentication-provider get' = '? h'
        'oda management authentication-provider list' = '? h'
        'oda management authentication-provider update' = '? h'
        'oda management bot import' = '? h'
        'oda management channel create' = '? h'
        'oda management channel create-channel-create-android-channel-details' = '? h'
        'oda management channel create-channel-create-app-event-channel-details' = '? h'
        'oda management channel create-channel-create-application-channel-details' = '? h'
        'oda management channel create-channel-create-cortana-channel-details' = '? h'
        'oda management channel create-channel-create-facebook-channel-details' = '? h'
        'oda management channel create-channel-create-ios-channel-details' = '? h'
        'oda management channel create-channel-create-ms-teams-channel-details' = '? h'
        'oda management channel create-channel-create-oss-channel-details' = '? h'
        'oda management channel create-channel-create-osvc-channel-details' = '? h'
        'oda management channel create-channel-create-service-cloud-channel-details' = '? h'
        'oda management channel create-channel-create-slack-channel-details' = '? h'
        'oda management channel create-channel-create-twilio-channel-details' = '? h'
        'oda management channel create-channel-create-web-channel-details' = '? h'
        'oda management channel create-channel-create-webhook-channel-details' = '? h'
        'oda management channel delete' = '? h'
        'oda management channel get' = '? h'
        'oda management channel list' = '? h'
        'oda management channel rotate-channel-keys' = '? h'
        'oda management channel start' = '? h'
        'oda management channel stop' = '? h'
        'oda management channel update' = '? h'
        'oda management channel update-channel-update-android-channel-details' = '? h'
        'oda management channel update-channel-update-app-event-channel-details' = '? h'
        'oda management channel update-channel-update-application-channel-details' = '? h'
        'oda management channel update-channel-update-cortana-channel-details' = '? h'
        'oda management channel update-channel-update-facebook-channel-details' = '? h'
        'oda management channel update-channel-update-ios-channel-details' = '? h'
        'oda management channel update-channel-update-ms-teams-channel-details' = '? h'
        'oda management channel update-channel-update-oss-channel-details' = '? h'
        'oda management channel update-channel-update-osvc-channel-details' = '? h'
        'oda management channel update-channel-update-service-cloud-channel-details' = '? h'
        'oda management channel update-channel-update-slack-channel-details' = '? h'
        'oda management channel update-channel-update-twilio-channel-details' = '? h'
        'oda management channel update-channel-update-web-channel-details' = '? h'
        'oda management channel update-channel-update-webhook-channel-details' = '? h'
        'oda management digital-assistant create' = '? h'
        'oda management digital-assistant create-digital-assistant-clone-digital-assistant-details' = '? h'
        'oda management digital-assistant create-digital-assistant-create-digital-assistant-version-details' = '? h'
        'oda management digital-assistant create-digital-assistant-create-new-digital-assistant-details' = '? h'
        'oda management digital-assistant create-digital-assistant-extend-digital-assistant-details' = '? h'
        'oda management digital-assistant delete' = '? h'
        'oda management digital-assistant get' = '? h'
        'oda management digital-assistant list' = '? h'
        'oda management digital-assistant publish' = '? h'
        'oda management digital-assistant update' = '? h'
        'oda management digital-assistant-parameter configure' = '? h'
        'oda management digital-assistant-parameter get' = '? h'
        'oda management digital-assistant-parameter list' = '? h'
        'oda management digital-assistant-parameter update' = '? h'
        'oda management oda-private-endpoint change-compartment' = '? c h'
        'oda management oda-private-endpoint create' = '? c h'
        'oda management oda-private-endpoint delete' = '? h'
        'oda management oda-private-endpoint get' = '? h'
        'oda management oda-private-endpoint list' = '? c h'
        'oda management oda-private-endpoint update' = '? h'
        'oda management oda-private-endpoint-attachment create' = '? h'
        'oda management oda-private-endpoint-attachment delete' = '? h'
        'oda management oda-private-endpoint-attachment get' = '? h'
        'oda management oda-private-endpoint-attachment list' = '? c h'
        'oda management oda-private-endpoint-scan-proxy create' = '? h'
        'oda management oda-private-endpoint-scan-proxy delete' = '? h'
        'oda management oda-private-endpoint-scan-proxy get' = '? h'
        'oda management oda-private-endpoint-scan-proxy list' = '? h'
        'oda management skill create' = '? h'
        'oda management skill create-skill-clone-skill-details' = '? h'
        'oda management skill create-skill-create-new-skill-details' = '? h'
        'oda management skill create-skill-create-skill-version-details' = '? h'
        'oda management skill create-skill-extend-skill-details' = '? h'
        'oda management skill delete' = '? h'
        'oda management skill export' = '? h'
        'oda management skill export-digital-assistant' = '? h'
        'oda management skill get' = '? h'
        'oda management skill list' = '? h'
        'oda management skill publish' = '? h'
        'oda management skill update' = '? h'
        'oda management skill-parameter create' = '? h'
        'oda management skill-parameter delete' = '? h'
        'oda management skill-parameter get' = '? h'
        'oda management skill-parameter list' = '? h'
        'oda management skill-parameter update' = '? h'
        'oda management translator create' = '? h'
        'oda management translator delete' = '? h'
        'oda management translator get' = '? h'
        'oda management translator list' = '? h'
        'oda management translator update' = '? h'
        'oda oda-instance-attachment create' = '? h'
        'oda oda-instance-attachment delete' = '? h'
        'oda oda-instance-attachment get' = '? h'
        'oda oda-instance-attachment update' = '? h'
        'oda oda-instance-attachment-collection list-oda-instance-attachments' = '? h'
        'oda odapackage imported-package create' = '? h'
        'oda odapackage imported-package delete' = '? h'
        'oda odapackage imported-package get' = '? h'
        'oda odapackage imported-package list' = '? h'
        'oda odapackage imported-package update' = '? h'
        'oda odapackage package get' = '? h'
        'oda odapackage package list' = '? c h'
        'oda work-request get' = '? h'
        'oda work-request list' = '? c h'
        'oda work-request-error list' = '? h'
        'oda work-request-log-entry list' = '? h'
    }
    return $ociCommandsToShortParams
}