# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501

from __future__ import print_function
import click
import oci  # noqa: F401
import six  # noqa: F401
import sys  # noqa: F401
from oci_cli.cli_root import cli
from oci_cli import cli_constants  # noqa: F401
from oci_cli import cli_util
from oci_cli import json_skeleton_utils
from oci_cli import custom_types  # noqa: F401
from oci_cli.aliasing import CommandGroupWithAlias


@cli.command(cli_util.override('network_firewall.network_firewall_root_group.command_name', 'network-firewall'), cls=CommandGroupWithAlias, help=cli_util.override('network_firewall.network_firewall_root_group.help', """Use the Network Firewall API to create network firewalls and configure policies that regulates network traffic in and across VCNs."""), short_help=cli_util.override('network_firewall.network_firewall_root_group.short_help', """Network Firewall API"""))
@cli_util.help_option_group
def network_firewall_root_group():
    pass


@click.command(cli_util.override('network_firewall.network_firewall_group.command_name', 'network-firewall'), cls=CommandGroupWithAlias, help="""A network firewall is a security resource that exists in a subnet of your choice and controls incoming and outgoing network traffic based on a set of security rules. Each firewall is associated with a policy. Traffic is routed to and from the firewall from resources such as internet gateways and dynamic routing gateways (DRGs). For more information, see [Overview of Network Firewall]""")
@cli_util.help_option_group
def network_firewall_group():
    pass


@click.command(cli_util.override('network_firewall.network_firewall_policy_group.command_name', 'network-firewall-policy'), cls=CommandGroupWithAlias, help="""Description of NetworkFirewall Policy.""")
@cli_util.help_option_group
def network_firewall_policy_group():
    pass


@click.command(cli_util.override('network_firewall.url_list_group.command_name', 'url-list'), cls=CommandGroupWithAlias, help="""URL pattern lists of the policy. The value of an entry is a list of URL patterns. The associated key/name is the identifier by which the URL pattern list is referenced.""")
@cli_util.help_option_group
def url_list_group():
    pass


@click.command(cli_util.override('network_firewall.work_request_log_entry_group.command_name', 'work-request-log-entry'), cls=CommandGroupWithAlias, help="""A log message from the execution of a work request.""")
@cli_util.help_option_group
def work_request_log_entry_group():
    pass


@click.command(cli_util.override('network_firewall.work_request_group.command_name', 'work-request'), cls=CommandGroupWithAlias, help="""A description of workrequest status""")
@cli_util.help_option_group
def work_request_group():
    pass


@click.command(cli_util.override('network_firewall.application_group_group.command_name', 'application-group'), cls=CommandGroupWithAlias, help="""A group of applications.""")
@cli_util.help_option_group
def application_group_group():
    pass


@click.command(cli_util.override('network_firewall.decryption_rule_group.command_name', 'decryption-rule'), cls=CommandGroupWithAlias, help="""Decryption Rule used in the firewall policy rules. A Decryption Rule is used to define which traffic should be decrypted by the firewall, and how it should do so.""")
@cli_util.help_option_group
def decryption_rule_group():
    pass


@click.command(cli_util.override('network_firewall.address_list_group.command_name', 'address-list'), cls=CommandGroupWithAlias, help="""List of addresses with a reference name. The value of an entry is a list of IP addresses or prefixes in CIDR notation or FQDNs. The associated key is the identifier by which the IP address list is referenced.""")
@cli_util.help_option_group
def address_list_group():
    pass


@click.command(cli_util.override('network_firewall.application_group.command_name', 'application'), cls=CommandGroupWithAlias, help="""A protocol identifier (such as TCP, UDP, or ICMP) and protocol-specific parameters (such as a port range).""")
@cli_util.help_option_group
def application_group():
    pass


@click.command(cli_util.override('network_firewall.decryption_profile_group.command_name', 'decryption-profile'), cls=CommandGroupWithAlias, help="""Decryption Profile used on the firewall policy rules.""")
@cli_util.help_option_group
def decryption_profile_group():
    pass


@click.command(cli_util.override('network_firewall.mapped_secret_group.command_name', 'mapped-secret'), cls=CommandGroupWithAlias, help="""Mapped secret used on the firewall policy rules.""")
@cli_util.help_option_group
def mapped_secret_group():
    pass


@click.command(cli_util.override('network_firewall.service_group.command_name', 'service'), cls=CommandGroupWithAlias, help="""A Service which can be used to identify the running service. It uses port & protocol information.""")
@cli_util.help_option_group
def service_group():
    pass


@click.command(cli_util.override('network_firewall.work_request_error_group.command_name', 'work-request-error'), cls=CommandGroupWithAlias, help="""An error encountered while executing a work request.""")
@cli_util.help_option_group
def work_request_error_group():
    pass


@click.command(cli_util.override('network_firewall.service_list_group.command_name', 'service-list'), cls=CommandGroupWithAlias, help="""A group of services.""")
@cli_util.help_option_group
def service_list_group():
    pass


@click.command(cli_util.override('network_firewall.security_rule_group.command_name', 'security-rule'), cls=CommandGroupWithAlias, help="""Security Rule used in the firewall policy rules. Security Rules determine whether to block or allow a session based on traffic attributes, such as  the source and destination IP address, protocol/port, and the HTTP(S) target URL.""")
@cli_util.help_option_group
def security_rule_group():
    pass


network_firewall_root_group.add_command(network_firewall_group)
network_firewall_root_group.add_command(network_firewall_policy_group)
network_firewall_root_group.add_command(url_list_group)
network_firewall_root_group.add_command(work_request_log_entry_group)
network_firewall_root_group.add_command(work_request_group)
network_firewall_root_group.add_command(application_group_group)
network_firewall_root_group.add_command(decryption_rule_group)
network_firewall_root_group.add_command(address_list_group)
network_firewall_root_group.add_command(application_group)
network_firewall_root_group.add_command(decryption_profile_group)
network_firewall_root_group.add_command(mapped_secret_group)
network_firewall_root_group.add_command(service_group)
network_firewall_root_group.add_command(work_request_error_group)
network_firewall_root_group.add_command(service_list_group)
network_firewall_root_group.add_command(security_rule_group)


@network_firewall_policy_group.command(name=cli_util.override('network_firewall.apply_network_firewall_policy.command_name', 'apply'), help=u"""Applies the candidate version of the NetworkFirewallPolicy resource. When provided, If-Match is checked against ETag values of the resource. \n[Command Reference](applyNetworkFirewallPolicy)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--firewalls', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Ordered priority list of firewall OCIDs on which the update needs to be applied in given order. If the list is a subset of the firewalls attached, then given firewalls would be deployed first with the change, followed by remaining firewalls.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'firewalls': {'module': 'network_firewall', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'firewalls': {'module': 'network_firewall', 'class': 'list[string]'}}, output_type={'module': 'network_firewall', 'class': 'NetworkFirewallPolicy'})
@cli_util.wrap_exceptions
def apply_network_firewall_policy(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_policy_id, firewalls, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if firewalls is not None:
        _details['firewalls'] = cli_util.parse_json_parameter("firewalls", firewalls)

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.apply_network_firewall_policy(
        network_firewall_policy_id=network_firewall_policy_id,
        apply_network_firewall_policy_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@address_list_group.command(name=cli_util.override('network_firewall.bulk_upload_address_lists.command_name', 'bulk-upload'), help=u"""Creates a new Address Lists at bulk for the Network Firewall Policy. \n[Command Reference](bulkUploadAddressLists)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--bulk-upload-address-lists-details', required=True, help=u"""Request Details to create the Address Lists for the Network Firewall Policy Resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def bulk_upload_address_lists(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_policy_id, bulk_upload_address_lists_details, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    # do not automatically retry operations with binary inputs
    kwargs['retry_strategy'] = oci.retry.NoneRetryStrategy()

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.bulk_upload_address_lists(
        network_firewall_policy_id=network_firewall_policy_id,
        bulk_upload_address_lists_details=bulk_upload_address_lists_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@application_group_group.command(name=cli_util.override('network_firewall.bulk_upload_application_groups.command_name', 'bulk-upload'), help=u"""Creates a new Application Group at bulk for the Network Firewall Policy. \n[Command Reference](bulkUploadApplicationGroups)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--bulk-upload-application-groups-details', required=True, help=u"""Request Details to create the Application Group for the Network Firewall Policy Resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def bulk_upload_application_groups(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_policy_id, bulk_upload_application_groups_details, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    # do not automatically retry operations with binary inputs
    kwargs['retry_strategy'] = oci.retry.NoneRetryStrategy()

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.bulk_upload_application_groups(
        network_firewall_policy_id=network_firewall_policy_id,
        bulk_upload_application_groups_details=bulk_upload_application_groups_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@application_group.command(name=cli_util.override('network_firewall.bulk_upload_applications.command_name', 'bulk-upload'), help=u"""Creates new Applications at bulk for the Network Firewall Policy. \n[Command Reference](bulkUploadApplications)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--bulk-upload-applications-details', required=True, help=u"""Request Details to create the Applications for the Network Firewall Policy Resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def bulk_upload_applications(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_policy_id, bulk_upload_applications_details, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    # do not automatically retry operations with binary inputs
    kwargs['retry_strategy'] = oci.retry.NoneRetryStrategy()

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.bulk_upload_applications(
        network_firewall_policy_id=network_firewall_policy_id,
        bulk_upload_applications_details=bulk_upload_applications_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@decryption_profile_group.command(name=cli_util.override('network_firewall.bulk_upload_decryption_profiles.command_name', 'bulk-upload'), help=u"""Creates new Decryption Profiles at bulk for the Network Firewall Policy. \n[Command Reference](bulkUploadDecryptionProfiles)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--bulk-upload-decryption-profiles-details', required=True, help=u"""Request Details to create the Decryption Profile for the Network Firewall Policy Resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def bulk_upload_decryption_profiles(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_policy_id, bulk_upload_decryption_profiles_details, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    # do not automatically retry operations with binary inputs
    kwargs['retry_strategy'] = oci.retry.NoneRetryStrategy()

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.bulk_upload_decryption_profiles(
        network_firewall_policy_id=network_firewall_policy_id,
        bulk_upload_decryption_profiles_details=bulk_upload_decryption_profiles_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@decryption_rule_group.command(name=cli_util.override('network_firewall.bulk_upload_decryption_rules.command_name', 'bulk-upload'), help=u"""Creates Decryption Rules at bulk for the Network Firewall Policy. \n[Command Reference](bulkUploadDecryptionRules)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--bulk-upload-decryption-rules-details', required=True, help=u"""Request Details to create the Decryption Rule for the Network Firewall Policy Resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def bulk_upload_decryption_rules(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_policy_id, bulk_upload_decryption_rules_details, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    # do not automatically retry operations with binary inputs
    kwargs['retry_strategy'] = oci.retry.NoneRetryStrategy()

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.bulk_upload_decryption_rules(
        network_firewall_policy_id=network_firewall_policy_id,
        bulk_upload_decryption_rules_details=bulk_upload_decryption_rules_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@mapped_secret_group.command(name=cli_util.override('network_firewall.bulk_upload_mapped_secrets.command_name', 'bulk-upload'), help=u"""Creates new Mapped Secrets at bulk for the Network Firewall Policy. \n[Command Reference](bulkUploadMappedSecrets)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--bulk-upload-mapped-secrets-details', required=True, help=u"""Request Details to create the Mapped Secret for the Network Firewall Policy Resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def bulk_upload_mapped_secrets(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_policy_id, bulk_upload_mapped_secrets_details, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    # do not automatically retry operations with binary inputs
    kwargs['retry_strategy'] = oci.retry.NoneRetryStrategy()

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.bulk_upload_mapped_secrets(
        network_firewall_policy_id=network_firewall_policy_id,
        bulk_upload_mapped_secrets_details=bulk_upload_mapped_secrets_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@security_rule_group.command(name=cli_util.override('network_firewall.bulk_upload_security_rules.command_name', 'bulk-upload'), help=u"""Creates a new Security Rule at bulk for the Network Firewall Policy. \n[Command Reference](bulkUploadSecurityRules)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--bulk-upload-security-rules-details', required=True, help=u"""Request Details to create the Security Rule for the Network Firewall Policy Resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def bulk_upload_security_rules(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_policy_id, bulk_upload_security_rules_details, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    # do not automatically retry operations with binary inputs
    kwargs['retry_strategy'] = oci.retry.NoneRetryStrategy()

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.bulk_upload_security_rules(
        network_firewall_policy_id=network_firewall_policy_id,
        bulk_upload_security_rules_details=bulk_upload_security_rules_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@service_list_group.command(name=cli_util.override('network_firewall.bulk_upload_service_lists.command_name', 'bulk-upload'), help=u"""Creates a new Service List at bulk for the Network Firewall Policy. \n[Command Reference](bulkUploadServiceLists)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--bulk-upload-service-lists-details', required=True, help=u"""Request Details to create the Service List for the Network Firewall Policy Resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def bulk_upload_service_lists(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_policy_id, bulk_upload_service_lists_details, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    # do not automatically retry operations with binary inputs
    kwargs['retry_strategy'] = oci.retry.NoneRetryStrategy()

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.bulk_upload_service_lists(
        network_firewall_policy_id=network_firewall_policy_id,
        bulk_upload_service_lists_details=bulk_upload_service_lists_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@service_group.command(name=cli_util.override('network_firewall.bulk_upload_services.command_name', 'bulk-upload'), help=u"""Creates new Services at bulk for the Network Firewall Policy. \n[Command Reference](bulkUploadServices)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--bulk-upload-services-details', required=True, help=u"""Request Details to create the Services for the Network Firewall Policy Resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def bulk_upload_services(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_policy_id, bulk_upload_services_details, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    # do not automatically retry operations with binary inputs
    kwargs['retry_strategy'] = oci.retry.NoneRetryStrategy()

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.bulk_upload_services(
        network_firewall_policy_id=network_firewall_policy_id,
        bulk_upload_services_details=bulk_upload_services_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@url_list_group.command(name=cli_util.override('network_firewall.bulk_upload_url_lists.command_name', 'bulk-upload'), help=u"""Creates a new Url Lists at bulk for the Network Firewall Policy. \n[Command Reference](bulkUploadUrlLists)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--bulk-upload-url-lists-details', required=True, help=u"""Request Details to create the Url Lists for the Network Firewall Policy Resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def bulk_upload_url_lists(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_policy_id, bulk_upload_url_lists_details, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    # do not automatically retry operations with binary inputs
    kwargs['retry_strategy'] = oci.retry.NoneRetryStrategy()

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.bulk_upload_url_lists(
        network_firewall_policy_id=network_firewall_policy_id,
        bulk_upload_url_lists_details=bulk_upload_url_lists_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@work_request_group.command(name=cli_util.override('network_firewall.cancel_work_request.command_name', 'cancel'), help=u"""Cancel work request with the given ID. \n[Command Reference](cancelWorkRequest)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def cancel_work_request(ctx, from_json, work_request_id, if_match):

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.cancel_work_request(
        work_request_id=work_request_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@network_firewall_group.command(name=cli_util.override('network_firewall.change_network_firewall_compartment.command_name', 'change-compartment'), help=u"""Moves a NetworkFirewall resource from one compartment identifier to another. When provided, If-Match is checked against ETag values of the resource. \n[Command Reference](changeNetworkFirewallCompartment)""")
@cli_util.option('--network-firewall-id', required=True, help=u"""The [OCID] of the Network Firewall resource.""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment into which the Network Firewalll resource should be moved.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_network_firewall_compartment(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_id, compartment_id, if_match):

    if isinstance(network_firewall_id, six.string_types) and len(network_firewall_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.change_network_firewall_compartment(
        network_firewall_id=network_firewall_id,
        change_network_firewall_compartment_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@network_firewall_policy_group.command(name=cli_util.override('network_firewall.change_network_firewall_policy_compartment.command_name', 'change-compartment'), help=u"""Moves a NetworkFirewallPolicy resource from one compartment identifier to another. When provided, If-Match is checked against ETag values of the resource. \n[Command Reference](changeNetworkFirewallPolicyCompartment)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment into which the resource should be moved.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def change_network_firewall_policy_compartment(ctx, from_json, network_firewall_policy_id, compartment_id, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.change_network_firewall_policy_compartment(
        network_firewall_policy_id=network_firewall_policy_id,
        change_network_firewall_policy_compartment_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@network_firewall_policy_group.command(name=cli_util.override('network_firewall.clone_network_firewall_policy.command_name', 'clone'), help=u"""Moves a NetworkFirewallPolicy resource from one compartment identifier to another. When provided, If-Match is checked against ETag values of the resource. \n[Command Reference](cloneNetworkFirewallPolicy)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--display-name', help=u"""A user-friendly optional name for the cloned firewall policy. Avoid entering confidential information.""")
@cli_util.option('--compartment-id', help=u"""The [OCID] of the compartment containing the NetworkFirewall Policy.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags]. Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags]. Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'network_firewall', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'network_firewall', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'network_firewall', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'network_firewall', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'network_firewall', 'class': 'NetworkFirewallPolicy'})
@cli_util.wrap_exceptions
def clone_network_firewall_policy(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_policy_id, display_name, compartment_id, freeform_tags, defined_tags, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if compartment_id is not None:
        _details['compartmentId'] = compartment_id

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.clone_network_firewall_policy(
        network_firewall_policy_id=network_firewall_policy_id,
        clone_network_firewall_policy_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@address_list_group.command(name=cli_util.override('network_firewall.create_address_list.command_name', 'create'), help=u"""Creates a new Address List for the Network Firewall Policy. \n[Command Reference](createAddressList)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--name', required=True, help=u"""Unique name to identify the group of addresses to be used in the policy rules.""")
@cli_util.option('--type', required=True, type=custom_types.CliCaseInsensitiveChoice(["FQDN", "IP"]), help=u"""Type of address List. The accepted values are - * FQDN * IP""")
@cli_util.option('--addresses', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of addresses.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'addresses': {'module': 'network_firewall', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'addresses': {'module': 'network_firewall', 'class': 'list[string]'}}, output_type={'module': 'network_firewall', 'class': 'AddressList'})
@cli_util.wrap_exceptions
def create_address_list(ctx, from_json, network_firewall_policy_id, name, type, addresses):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['name'] = name
    _details['type'] = type
    _details['addresses'] = cli_util.parse_json_parameter("addresses", addresses)

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_address_list(
        network_firewall_policy_id=network_firewall_policy_id,
        create_address_list_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@application_group.command(name=cli_util.override('network_firewall.create_application.command_name', 'create'), help=u"""Creates a new Application for the Network Firewall Policy. \n[Command Reference](createApplication)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--name', required=True, help=u"""Name of the application""")
@cli_util.option('--type', type=custom_types.CliCaseInsensitiveChoice(["ICMP", "ICMP_V6"]), help=u"""Describes the type of Application.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'Application'})
@cli_util.wrap_exceptions
def create_application(ctx, from_json, network_firewall_policy_id, name, type):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['name'] = name

    if type is not None:
        _details['type'] = type

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_application(
        network_firewall_policy_id=network_firewall_policy_id,
        create_application_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@application_group.command(name=cli_util.override('network_firewall.create_application_create_icmp_application_details.command_name', 'create-application-create-icmp-application-details'), help=u"""Creates a new Application for the Network Firewall Policy. \n[Command Reference](createApplication)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--name', required=True, help=u"""Name of the application""")
@cli_util.option('--icmp-type', required=True, type=click.INT, help=u"""The value of the ICMP message Type field as defined by [RFC 792].""")
@cli_util.option('--icmp-code', type=click.INT, help=u"""The value of the ICMP message Code (subtype) field as defined by [RFC 792].""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'Application'})
@cli_util.wrap_exceptions
def create_application_create_icmp_application_details(ctx, from_json, network_firewall_policy_id, name, icmp_type, icmp_code):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['name'] = name
    _details['icmpType'] = icmp_type

    if icmp_code is not None:
        _details['icmpCode'] = icmp_code

    _details['type'] = 'ICMP'

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_application(
        network_firewall_policy_id=network_firewall_policy_id,
        create_application_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@application_group.command(name=cli_util.override('network_firewall.create_application_create_icmp6_application_details.command_name', 'create-application-create-icmp6-application-details'), help=u"""Creates a new Application for the Network Firewall Policy. \n[Command Reference](createApplication)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--name', required=True, help=u"""Name of the application""")
@cli_util.option('--icmp-type', required=True, type=click.INT, help=u"""The value of the ICMP6 message Type field as defined by [RFC 4443].""")
@cli_util.option('--icmp-code', type=click.INT, help=u"""The value of the ICMP6 message Code (subtype) field as defined by [RFC 4443].""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'Application'})
@cli_util.wrap_exceptions
def create_application_create_icmp6_application_details(ctx, from_json, network_firewall_policy_id, name, icmp_type, icmp_code):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['name'] = name
    _details['icmpType'] = icmp_type

    if icmp_code is not None:
        _details['icmpCode'] = icmp_code

    _details['type'] = 'ICMP_V6'

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_application(
        network_firewall_policy_id=network_firewall_policy_id,
        create_application_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@application_group_group.command(name=cli_util.override('network_firewall.create_application_group.command_name', 'create'), help=u"""Creates a new ApplicationGroup for the Network Firewall Policy. \n[Command Reference](createApplicationGroup)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--name', required=True, help=u"""Name of the application Group.""")
@cli_util.option('--apps', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""Collection of application names.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'apps': {'module': 'network_firewall', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'apps': {'module': 'network_firewall', 'class': 'list[string]'}}, output_type={'module': 'network_firewall', 'class': 'ApplicationGroup'})
@cli_util.wrap_exceptions
def create_application_group(ctx, from_json, network_firewall_policy_id, name, apps):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['name'] = name
    _details['apps'] = cli_util.parse_json_parameter("apps", apps)

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_application_group(
        network_firewall_policy_id=network_firewall_policy_id,
        create_application_group_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@decryption_profile_group.command(name=cli_util.override('network_firewall.create_decryption_profile.command_name', 'create'), help=u"""Creates a new Decryption Profile for the Network Firewall Policy. \n[Command Reference](createDecryptionProfile)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--type', required=True, type=custom_types.CliCaseInsensitiveChoice(["SSL_INBOUND_INSPECTION", "SSL_FORWARD_PROXY"]), help=u"""Describes the type of Decryption Profile SslForwardProxy or SslInboundInspection.""")
@cli_util.option('--name', required=True, help=u"""Name of the decryption profile.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'DecryptionProfile'})
@cli_util.wrap_exceptions
def create_decryption_profile(ctx, from_json, network_firewall_policy_id, type, name):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['type'] = type
    _details['name'] = name

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_decryption_profile(
        network_firewall_policy_id=network_firewall_policy_id,
        create_decryption_profile_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@decryption_profile_group.command(name=cli_util.override('network_firewall.create_decryption_profile_create_ssl_inbound_inspection_profile_details.command_name', 'create-decryption-profile-create-ssl-inbound-inspection-profile-details'), help=u"""Creates a new Decryption Profile for the Network Firewall Policy. \n[Command Reference](createDecryptionProfile)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--name', required=True, help=u"""Name of the decryption profile.""")
@cli_util.option('--is-unsupported-version-blocked', type=click.BOOL, help=u"""Whether to block sessions if SSL version is not supported.""")
@cli_util.option('--is-unsupported-cipher-blocked', type=click.BOOL, help=u"""Whether to block sessions if SSL cipher suite is not supported.""")
@cli_util.option('--is-out-of-capacity-blocked', type=click.BOOL, help=u"""Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'DecryptionProfile'})
@cli_util.wrap_exceptions
def create_decryption_profile_create_ssl_inbound_inspection_profile_details(ctx, from_json, network_firewall_policy_id, name, is_unsupported_version_blocked, is_unsupported_cipher_blocked, is_out_of_capacity_blocked):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['name'] = name

    if is_unsupported_version_blocked is not None:
        _details['isUnsupportedVersionBlocked'] = is_unsupported_version_blocked

    if is_unsupported_cipher_blocked is not None:
        _details['isUnsupportedCipherBlocked'] = is_unsupported_cipher_blocked

    if is_out_of_capacity_blocked is not None:
        _details['isOutOfCapacityBlocked'] = is_out_of_capacity_blocked

    _details['type'] = 'SSL_INBOUND_INSPECTION'

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_decryption_profile(
        network_firewall_policy_id=network_firewall_policy_id,
        create_decryption_profile_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@decryption_profile_group.command(name=cli_util.override('network_firewall.create_decryption_profile_create_ssl_forward_proxy_profile_details.command_name', 'create-decryption-profile-create-ssl-forward-proxy-profile-details'), help=u"""Creates a new Decryption Profile for the Network Firewall Policy. \n[Command Reference](createDecryptionProfile)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--name', required=True, help=u"""Name of the decryption profile.""")
@cli_util.option('--is-expired-certificate-blocked', type=click.BOOL, help=u"""Whether to block sessions if server's certificate is expired.""")
@cli_util.option('--is-untrusted-issuer-blocked', type=click.BOOL, help=u"""Whether to block sessions if server's certificate is issued by an untrusted certificate authority (CA).""")
@cli_util.option('--is-revocation-status-timeout-blocked', type=click.BOOL, help=u"""Whether to block sessions if the revocation status check for server's certificate does not succeed within the maximum allowed time (defaulting to 5 seconds).""")
@cli_util.option('--is-unsupported-version-blocked', type=click.BOOL, help=u"""Whether to block sessions if SSL version is not supported.""")
@cli_util.option('--is-unsupported-cipher-blocked', type=click.BOOL, help=u"""Whether to block sessions if SSL cipher suite is not supported.""")
@cli_util.option('--is-unknown-revocation-status-blocked', type=click.BOOL, help=u"""Whether to block sessions if the revocation status check for server's certificate results in \"unknown\".""")
@cli_util.option('--are-certificate-extensions-restricted', type=click.BOOL, help=u"""Whether to block sessions if the server's certificate uses extensions other than key usage and/or extended key usage.""")
@cli_util.option('--is-auto-include-alt-name', type=click.BOOL, help=u"""Whether to automatically append SAN to impersonating certificate if server certificate is missing SAN.""")
@cli_util.option('--is-out-of-capacity-blocked', type=click.BOOL, help=u"""Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'DecryptionProfile'})
@cli_util.wrap_exceptions
def create_decryption_profile_create_ssl_forward_proxy_profile_details(ctx, from_json, network_firewall_policy_id, name, is_expired_certificate_blocked, is_untrusted_issuer_blocked, is_revocation_status_timeout_blocked, is_unsupported_version_blocked, is_unsupported_cipher_blocked, is_unknown_revocation_status_blocked, are_certificate_extensions_restricted, is_auto_include_alt_name, is_out_of_capacity_blocked):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['name'] = name

    if is_expired_certificate_blocked is not None:
        _details['isExpiredCertificateBlocked'] = is_expired_certificate_blocked

    if is_untrusted_issuer_blocked is not None:
        _details['isUntrustedIssuerBlocked'] = is_untrusted_issuer_blocked

    if is_revocation_status_timeout_blocked is not None:
        _details['isRevocationStatusTimeoutBlocked'] = is_revocation_status_timeout_blocked

    if is_unsupported_version_blocked is not None:
        _details['isUnsupportedVersionBlocked'] = is_unsupported_version_blocked

    if is_unsupported_cipher_blocked is not None:
        _details['isUnsupportedCipherBlocked'] = is_unsupported_cipher_blocked

    if is_unknown_revocation_status_blocked is not None:
        _details['isUnknownRevocationStatusBlocked'] = is_unknown_revocation_status_blocked

    if are_certificate_extensions_restricted is not None:
        _details['areCertificateExtensionsRestricted'] = are_certificate_extensions_restricted

    if is_auto_include_alt_name is not None:
        _details['isAutoIncludeAltName'] = is_auto_include_alt_name

    if is_out_of_capacity_blocked is not None:
        _details['isOutOfCapacityBlocked'] = is_out_of_capacity_blocked

    _details['type'] = 'SSL_FORWARD_PROXY'

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_decryption_profile(
        network_firewall_policy_id=network_firewall_policy_id,
        create_decryption_profile_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@decryption_rule_group.command(name=cli_util.override('network_firewall.create_decryption_rule.command_name', 'create'), help=u"""Creates a new Decryption Rule for the Network Firewall Policy. \n[Command Reference](createDecryptionRule)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--name', required=True, help=u"""Name for the decryption rule, must be unique within the policy.""")
@cli_util.option('--condition', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--action', required=True, type=custom_types.CliCaseInsensitiveChoice(["NO_DECRYPT", "DECRYPT"]), help=u"""Action:

* NO_DECRYPT - Matching traffic is not decrypted. * DECRYPT - Matching traffic is decrypted with the specified `secret` according to the specified `decryptionProfile`.""")
@cli_util.option('--decryption-profile', help=u"""The name of the decryption profile to use.""")
@cli_util.option('--secret', help=u"""The name of a mapped secret. Its `type` must match that of the specified decryption profile.""")
@cli_util.option('--position', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'condition': {'module': 'network_firewall', 'class': 'DecryptionRuleMatchCriteria'}, 'position': {'module': 'network_firewall', 'class': 'RulePosition'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'condition': {'module': 'network_firewall', 'class': 'DecryptionRuleMatchCriteria'}, 'position': {'module': 'network_firewall', 'class': 'RulePosition'}}, output_type={'module': 'network_firewall', 'class': 'DecryptionRule'})
@cli_util.wrap_exceptions
def create_decryption_rule(ctx, from_json, network_firewall_policy_id, name, condition, action, decryption_profile, secret, position):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['name'] = name
    _details['condition'] = cli_util.parse_json_parameter("condition", condition)
    _details['action'] = action

    if decryption_profile is not None:
        _details['decryptionProfile'] = decryption_profile

    if secret is not None:
        _details['secret'] = secret

    if position is not None:
        _details['position'] = cli_util.parse_json_parameter("position", position)

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_decryption_rule(
        network_firewall_policy_id=network_firewall_policy_id,
        create_decryption_rule_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@mapped_secret_group.command(name=cli_util.override('network_firewall.create_mapped_secret.command_name', 'create'), help=u"""Creates a new Mapped Secret for the Network Firewall Policy. \n[Command Reference](createMappedSecret)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--name', required=True, help=u"""Unique name to identify the group of urls to be used in the policy rules.""")
@cli_util.option('--source', required=True, help=u"""Source of the secrets, where the secrets are stored.""")
@cli_util.option('--type', required=True, type=custom_types.CliCaseInsensitiveChoice(["SSL_INBOUND_INSPECTION", "SSL_FORWARD_PROXY"]), help=u"""Type of the secrets mapped based on the policy.

* `SSL_INBOUND_INSPECTION`: For Inbound inspection of SSL traffic. * `SSL_FORWARD_PROXY`: For forward proxy certificates for SSL inspection.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'MappedSecret'})
@cli_util.wrap_exceptions
def create_mapped_secret(ctx, from_json, network_firewall_policy_id, name, source, type):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['name'] = name
    _details['source'] = source
    _details['type'] = type

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_mapped_secret(
        network_firewall_policy_id=network_firewall_policy_id,
        create_mapped_secret_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@mapped_secret_group.command(name=cli_util.override('network_firewall.create_mapped_secret_create_vault_mapped_secret_details.command_name', 'create-mapped-secret-create-vault-mapped-secret-details'), help=u"""Creates a new Mapped Secret for the Network Firewall Policy. \n[Command Reference](createMappedSecret)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--name', required=True, help=u"""Unique name to identify the group of urls to be used in the policy rules.""")
@cli_util.option('--type', required=True, type=custom_types.CliCaseInsensitiveChoice(["SSL_INBOUND_INSPECTION", "SSL_FORWARD_PROXY"]), help=u"""Type of the secrets mapped based on the policy.

* `SSL_INBOUND_INSPECTION`: For Inbound inspection of SSL traffic. * `SSL_FORWARD_PROXY`: For forward proxy certificates for SSL inspection.""")
@cli_util.option('--vault-secret-id', required=True, help=u"""OCID for the Vault Secret to be used.""")
@cli_util.option('--version-number', required=True, type=click.INT, help=u"""Version number of the secret to be used.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'MappedSecret'})
@cli_util.wrap_exceptions
def create_mapped_secret_create_vault_mapped_secret_details(ctx, from_json, network_firewall_policy_id, name, type, vault_secret_id, version_number):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['name'] = name
    _details['type'] = type
    _details['vaultSecretId'] = vault_secret_id
    _details['versionNumber'] = version_number

    _details['source'] = 'OCI_VAULT'

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_mapped_secret(
        network_firewall_policy_id=network_firewall_policy_id,
        create_mapped_secret_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@network_firewall_group.command(name=cli_util.override('network_firewall.create_network_firewall.command_name', 'create'), help=u"""Creates a new NetworkFirewall. \n[Command Reference](createNetworkFirewall)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment containing the Network Firewall.""")
@cli_util.option('--subnet-id', required=True, help=u"""The [OCID] of the subnet associated with the Network Firewall.""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""The [OCID] of the Network Firewall Policy.""")
@cli_util.option('--display-name', help=u"""A user-friendly name for the Network Firewall. Does not have to be unique, and it's changeable. Avoid entering confidential information.""")
@cli_util.option('--availability-domain', help=u"""Availability Domain where Network Firewall instance is created. To get a list of availability domains for a tenancy, use [ListAvailabilityDomains] operation. Example: `kIdk:PHX-AD-1`""")
@cli_util.option('--ipv4-address', help=u"""IPv4 address for the Network Firewall.""")
@cli_util.option('--ipv6-address', help=u"""IPv6 address for the Network Firewall.""")
@cli_util.option('--network-security-group-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""An array of network security groups [OCID] associated with the Network Firewall.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags]. Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags]. Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'network-security-group-ids': {'module': 'network_firewall', 'class': 'list[string]'}, 'freeform-tags': {'module': 'network_firewall', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'network_firewall', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'network-security-group-ids': {'module': 'network_firewall', 'class': 'list[string]'}, 'freeform-tags': {'module': 'network_firewall', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'network_firewall', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'network_firewall', 'class': 'NetworkFirewall'})
@cli_util.wrap_exceptions
def create_network_firewall(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, subnet_id, network_firewall_policy_id, display_name, availability_domain, ipv4_address, ipv6_address, network_security_group_ids, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id
    _details['subnetId'] = subnet_id
    _details['networkFirewallPolicyId'] = network_firewall_policy_id

    if display_name is not None:
        _details['displayName'] = display_name

    if availability_domain is not None:
        _details['availabilityDomain'] = availability_domain

    if ipv4_address is not None:
        _details['ipv4Address'] = ipv4_address

    if ipv6_address is not None:
        _details['ipv6Address'] = ipv6_address

    if network_security_group_ids is not None:
        _details['networkSecurityGroupIds'] = cli_util.parse_json_parameter("network_security_group_ids", network_security_group_ids)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_network_firewall(
        create_network_firewall_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@network_firewall_policy_group.command(name=cli_util.override('network_firewall.create_network_firewall_policy.command_name', 'create'), help=u"""Creates a new Network Firewall Policy. \n[Command Reference](createNetworkFirewallPolicy)""")
@cli_util.option('--compartment-id', required=True, help=u"""The [OCID] of the compartment containing the NetworkFirewall Policy.""")
@cli_util.option('--display-name', help=u"""A user-friendly optional name for the firewall policy. Avoid entering confidential information.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags]. Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags]. Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'network_firewall', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'network_firewall', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'network_firewall', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'network_firewall', 'class': 'dict(str, dict(str, object))'}}, output_type={'module': 'network_firewall', 'class': 'NetworkFirewallPolicy'})
@cli_util.wrap_exceptions
def create_network_firewall_policy(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, compartment_id, display_name, freeform_tags, defined_tags):

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['compartmentId'] = compartment_id

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_network_firewall_policy(
        create_network_firewall_policy_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@security_rule_group.command(name=cli_util.override('network_firewall.create_security_rule.command_name', 'create'), help=u"""Creates a new Security Rule for the Network Firewall Policy. \n[Command Reference](createSecurityRule)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--name', required=True, help=u"""Name for the Security rule, must be unique within the policy.""")
@cli_util.option('--condition', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--action', required=True, type=custom_types.CliCaseInsensitiveChoice(["ALLOW", "DROP", "REJECT", "INSPECT"]), help=u"""Types of Action on the Traffic flow.

  * ALLOW - Allows the traffic.   * DROP - Silently drops the traffic, e.g. without sending a TCP reset.   * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.   * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.""")
@cli_util.option('--inspection', type=custom_types.CliCaseInsensitiveChoice(["INTRUSION_DETECTION", "INTRUSION_PREVENTION"]), help=u"""Type of inspection to affect the Traffic flow. This is only applicable if action is INSPECT.

  * INTRUSION_DETECTION - Intrusion Detection.   * INTRUSION_PREVENTION - Intrusion Detection and Prevention. Traffic classified as potentially malicious will be rejected as described in `type`.""")
@cli_util.option('--position', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'condition': {'module': 'network_firewall', 'class': 'SecurityRuleMatchCriteria'}, 'position': {'module': 'network_firewall', 'class': 'RulePosition'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'condition': {'module': 'network_firewall', 'class': 'SecurityRuleMatchCriteria'}, 'position': {'module': 'network_firewall', 'class': 'RulePosition'}}, output_type={'module': 'network_firewall', 'class': 'SecurityRule'})
@cli_util.wrap_exceptions
def create_security_rule(ctx, from_json, network_firewall_policy_id, name, condition, action, inspection, position):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['name'] = name
    _details['condition'] = cli_util.parse_json_parameter("condition", condition)
    _details['action'] = action

    if inspection is not None:
        _details['inspection'] = inspection

    if position is not None:
        _details['position'] = cli_util.parse_json_parameter("position", position)

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_security_rule(
        network_firewall_policy_id=network_firewall_policy_id,
        create_security_rule_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@service_group.command(name=cli_util.override('network_firewall.create_service.command_name', 'create'), help=u"""Creates a new Service for the Network Firewall Policy. \n[Command Reference](createService)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--name', required=True, help=u"""Name of the service""")
@cli_util.option('--type', type=custom_types.CliCaseInsensitiveChoice(["TCP_SERVICE", "UDP_SERVICE"]), help=u"""Describes the type of Service.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'Service'})
@cli_util.wrap_exceptions
def create_service(ctx, from_json, network_firewall_policy_id, name, type):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['name'] = name

    if type is not None:
        _details['type'] = type

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_service(
        network_firewall_policy_id=network_firewall_policy_id,
        create_service_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@service_group.command(name=cli_util.override('network_firewall.create_service_create_udp_service_details.command_name', 'create-service-create-udp-service-details'), help=u"""Creates a new Service for the Network Firewall Policy. \n[Command Reference](createService)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--name', required=True, help=u"""Name of the service""")
@cli_util.option('--port-ranges', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of port-ranges to be used.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'port-ranges': {'module': 'network_firewall', 'class': 'list[PortRange]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'port-ranges': {'module': 'network_firewall', 'class': 'list[PortRange]'}}, output_type={'module': 'network_firewall', 'class': 'Service'})
@cli_util.wrap_exceptions
def create_service_create_udp_service_details(ctx, from_json, network_firewall_policy_id, name, port_ranges):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['name'] = name
    _details['portRanges'] = cli_util.parse_json_parameter("port_ranges", port_ranges)

    _details['type'] = 'UDP_SERVICE'

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_service(
        network_firewall_policy_id=network_firewall_policy_id,
        create_service_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@service_group.command(name=cli_util.override('network_firewall.create_service_create_tcp_service_details.command_name', 'create-service-create-tcp-service-details'), help=u"""Creates a new Service for the Network Firewall Policy. \n[Command Reference](createService)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--name', required=True, help=u"""Name of the service""")
@cli_util.option('--port-ranges', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of port-ranges used.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'port-ranges': {'module': 'network_firewall', 'class': 'list[PortRange]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'port-ranges': {'module': 'network_firewall', 'class': 'list[PortRange]'}}, output_type={'module': 'network_firewall', 'class': 'Service'})
@cli_util.wrap_exceptions
def create_service_create_tcp_service_details(ctx, from_json, network_firewall_policy_id, name, port_ranges):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['name'] = name
    _details['portRanges'] = cli_util.parse_json_parameter("port_ranges", port_ranges)

    _details['type'] = 'TCP_SERVICE'

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_service(
        network_firewall_policy_id=network_firewall_policy_id,
        create_service_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@service_list_group.command(name=cli_util.override('network_firewall.create_service_list.command_name', 'create'), help=u"""Creates a new ServiceList for the Network Firewall Policy. \n[Command Reference](createServiceList)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--name', required=True, help=u"""Name of the service Group.""")
@cli_util.option('--services', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""Collection of service names.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'services': {'module': 'network_firewall', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'services': {'module': 'network_firewall', 'class': 'list[string]'}}, output_type={'module': 'network_firewall', 'class': 'ServiceList'})
@cli_util.wrap_exceptions
def create_service_list(ctx, from_json, network_firewall_policy_id, name, services):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['name'] = name
    _details['services'] = cli_util.parse_json_parameter("services", services)

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_service_list(
        network_firewall_policy_id=network_firewall_policy_id,
        create_service_list_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@url_list_group.command(name=cli_util.override('network_firewall.create_url_list.command_name', 'create'), help=u"""Creates a new Url List for the Network Firewall Policy. \n[Command Reference](createUrlList)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--name', required=True, help=u"""Unique name to identify the group of urls to be used in the policy rules.""")
@cli_util.option('--urls', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of urls.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@json_skeleton_utils.get_cli_json_input_option({'urls': {'module': 'network_firewall', 'class': 'list[UrlPattern]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'urls': {'module': 'network_firewall', 'class': 'list[UrlPattern]'}}, output_type={'module': 'network_firewall', 'class': 'UrlList'})
@cli_util.wrap_exceptions
def create_url_list(ctx, from_json, network_firewall_policy_id, name, urls):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['name'] = name
    _details['urls'] = cli_util.parse_json_parameter("urls", urls)

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.create_url_list(
        network_firewall_policy_id=network_firewall_policy_id,
        create_url_list_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@address_list_group.command(name=cli_util.override('network_firewall.delete_address_list.command_name', 'delete'), help=u"""Deletes a Address List resource with the given identifier. \n[Command Reference](deleteAddressList)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--address-list-name', required=True, help=u"""Unique identifier for address lists.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_address_list(ctx, from_json, network_firewall_policy_id, address_list_name, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(address_list_name, six.string_types) and len(address_list_name.strip()) == 0:
        raise click.UsageError('Parameter --address-list-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.delete_address_list(
        network_firewall_policy_id=network_firewall_policy_id,
        address_list_name=address_list_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@application_group.command(name=cli_util.override('network_firewall.delete_application.command_name', 'delete'), help=u"""Deletes a Application resource with the given identifier. \n[Command Reference](deleteApplication)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--application-name', required=True, help=u"""Unique identifier for Applications.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_application(ctx, from_json, network_firewall_policy_id, application_name, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(application_name, six.string_types) and len(application_name.strip()) == 0:
        raise click.UsageError('Parameter --application-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.delete_application(
        network_firewall_policy_id=network_firewall_policy_id,
        application_name=application_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@application_group_group.command(name=cli_util.override('network_firewall.delete_application_group.command_name', 'delete'), help=u"""Deletes a ApplicationGroup resource with the given identifier. \n[Command Reference](deleteApplicationGroup)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--application-group-name', required=True, help=u"""Unique name identifier for Application Lists in the scope of Network Firewall Policy.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_application_group(ctx, from_json, network_firewall_policy_id, application_group_name, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(application_group_name, six.string_types) and len(application_group_name.strip()) == 0:
        raise click.UsageError('Parameter --application-group-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.delete_application_group(
        network_firewall_policy_id=network_firewall_policy_id,
        application_group_name=application_group_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@decryption_profile_group.command(name=cli_util.override('network_firewall.delete_decryption_profile.command_name', 'delete'), help=u"""Deletes a Decryption Profile resource with the given identifier. \n[Command Reference](deleteDecryptionProfile)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--decryption-profile-name', required=True, help=u"""Unique identifier for Decryption Profiles.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_decryption_profile(ctx, from_json, network_firewall_policy_id, decryption_profile_name, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(decryption_profile_name, six.string_types) and len(decryption_profile_name.strip()) == 0:
        raise click.UsageError('Parameter --decryption-profile-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.delete_decryption_profile(
        network_firewall_policy_id=network_firewall_policy_id,
        decryption_profile_name=decryption_profile_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@decryption_rule_group.command(name=cli_util.override('network_firewall.delete_decryption_rule.command_name', 'delete'), help=u"""Deletes a Decryption Rule resource with the given identifier. \n[Command Reference](deleteDecryptionRule)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--decryption-rule-name', required=True, help=u"""Unique identifier for Decryption Rules in the network firewall policy.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_decryption_rule(ctx, from_json, network_firewall_policy_id, decryption_rule_name, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(decryption_rule_name, six.string_types) and len(decryption_rule_name.strip()) == 0:
        raise click.UsageError('Parameter --decryption-rule-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.delete_decryption_rule(
        network_firewall_policy_id=network_firewall_policy_id,
        decryption_rule_name=decryption_rule_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@mapped_secret_group.command(name=cli_util.override('network_firewall.delete_mapped_secret.command_name', 'delete'), help=u"""Deletes a Mapped Secret resource with the given identifier. \n[Command Reference](deleteMappedSecret)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--mapped-secret-name', required=True, help=u"""Unique identifier for Mapped Secrets.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_mapped_secret(ctx, from_json, network_firewall_policy_id, mapped_secret_name, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(mapped_secret_name, six.string_types) and len(mapped_secret_name.strip()) == 0:
        raise click.UsageError('Parameter --mapped-secret-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.delete_mapped_secret(
        network_firewall_policy_id=network_firewall_policy_id,
        mapped_secret_name=mapped_secret_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@network_firewall_group.command(name=cli_util.override('network_firewall.delete_network_firewall.command_name', 'delete'), help=u"""Deletes a NetworkFirewall resource by identifier \n[Command Reference](deleteNetworkFirewall)""")
@cli_util.option('--network-firewall-id', required=True, help=u"""The [OCID] of the Network Firewall resource.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_network_firewall(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_id, if_match):

    if isinstance(network_firewall_id, six.string_types) and len(network_firewall_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.delete_network_firewall(
        network_firewall_id=network_firewall_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@network_firewall_policy_group.command(name=cli_util.override('network_firewall.delete_network_firewall_policy.command_name', 'delete'), help=u"""Deletes a NetworkFirewallPolicy resource with the given identifier. \n[Command Reference](deleteNetworkFirewallPolicy)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_network_firewall_policy(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_policy_id, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.delete_network_firewall_policy(
        network_firewall_policy_id=network_firewall_policy_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Please retrieve the work request to find its current state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@security_rule_group.command(name=cli_util.override('network_firewall.delete_security_rule.command_name', 'delete'), help=u"""Deletes a Security Rule resource with the given identifier. \n[Command Reference](deleteSecurityRule)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--security-rule-name', required=True, help=u"""Unique identifier for Security Rules in the network firewall policy.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_security_rule(ctx, from_json, network_firewall_policy_id, security_rule_name, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(security_rule_name, six.string_types) and len(security_rule_name.strip()) == 0:
        raise click.UsageError('Parameter --security-rule-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.delete_security_rule(
        network_firewall_policy_id=network_firewall_policy_id,
        security_rule_name=security_rule_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@service_group.command(name=cli_util.override('network_firewall.delete_service.command_name', 'delete'), help=u"""Deletes a Service resource with the given identifier. \n[Command Reference](deleteService)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--service-name', required=True, help=u"""Unique identifier for Services.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_service(ctx, from_json, network_firewall_policy_id, service_name, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(service_name, six.string_types) and len(service_name.strip()) == 0:
        raise click.UsageError('Parameter --service-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.delete_service(
        network_firewall_policy_id=network_firewall_policy_id,
        service_name=service_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@service_list_group.command(name=cli_util.override('network_firewall.delete_service_list.command_name', 'delete'), help=u"""Deletes a ServiceList resource with the given identifier. \n[Command Reference](deleteServiceList)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--service-list-name', required=True, help=u"""Unique name identifier for Service Lists in the scope of Network Firewall Policy.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_service_list(ctx, from_json, network_firewall_policy_id, service_list_name, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(service_list_name, six.string_types) and len(service_list_name.strip()) == 0:
        raise click.UsageError('Parameter --service-list-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.delete_service_list(
        network_firewall_policy_id=network_firewall_policy_id,
        service_list_name=service_list_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@url_list_group.command(name=cli_util.override('network_firewall.delete_url_list.command_name', 'delete'), help=u"""Deletes a Url List resource with the given identifier. \n[Command Reference](deleteUrlList)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--url-list-name', required=True, help=u"""Unique name identifier for url lists in the scope of Network Firewall Policy.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.confirm_delete_option
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def delete_url_list(ctx, from_json, network_firewall_policy_id, url_list_name, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(url_list_name, six.string_types) and len(url_list_name.strip()) == 0:
        raise click.UsageError('Parameter --url-list-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.delete_url_list(
        network_firewall_policy_id=network_firewall_policy_id,
        url_list_name=url_list_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@address_list_group.command(name=cli_util.override('network_firewall.get_address_list.command_name', 'get'), help=u"""Get Address List by the given name in the context of network firewall policy. \n[Command Reference](getAddressList)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--address-list-name', required=True, help=u"""Unique identifier for address lists.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'AddressList'})
@cli_util.wrap_exceptions
def get_address_list(ctx, from_json, network_firewall_policy_id, address_list_name):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(address_list_name, six.string_types) and len(address_list_name.strip()) == 0:
        raise click.UsageError('Parameter --address-list-name cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.get_address_list(
        network_firewall_policy_id=network_firewall_policy_id,
        address_list_name=address_list_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@application_group.command(name=cli_util.override('network_firewall.get_application.command_name', 'get'), help=u"""Get Application by the given name in the context of network firewall policy. \n[Command Reference](getApplication)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--application-name', required=True, help=u"""Unique identifier for Applications.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'Application'})
@cli_util.wrap_exceptions
def get_application(ctx, from_json, network_firewall_policy_id, application_name, limit, page):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(application_name, six.string_types) and len(application_name.strip()) == 0:
        raise click.UsageError('Parameter --application-name cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.get_application(
        network_firewall_policy_id=network_firewall_policy_id,
        application_name=application_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@application_group_group.command(name=cli_util.override('network_firewall.get_application_group.command_name', 'get'), help=u"""Get ApplicationGroup by the given name in the context of network firewall policy. \n[Command Reference](getApplicationGroup)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--application-group-name', required=True, help=u"""Unique name identifier for Application Lists in the scope of Network Firewall Policy.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'ApplicationGroup'})
@cli_util.wrap_exceptions
def get_application_group(ctx, from_json, network_firewall_policy_id, application_group_name):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(application_group_name, six.string_types) and len(application_group_name.strip()) == 0:
        raise click.UsageError('Parameter --application-group-name cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.get_application_group(
        network_firewall_policy_id=network_firewall_policy_id,
        application_group_name=application_group_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@decryption_profile_group.command(name=cli_util.override('network_firewall.get_decryption_profile.command_name', 'get'), help=u"""Get Decryption Profile by the given name in the context of network firewall policy. \n[Command Reference](getDecryptionProfile)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--decryption-profile-name', required=True, help=u"""Unique identifier for Decryption Profiles.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'DecryptionProfile'})
@cli_util.wrap_exceptions
def get_decryption_profile(ctx, from_json, network_firewall_policy_id, decryption_profile_name):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(decryption_profile_name, six.string_types) and len(decryption_profile_name.strip()) == 0:
        raise click.UsageError('Parameter --decryption-profile-name cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.get_decryption_profile(
        network_firewall_policy_id=network_firewall_policy_id,
        decryption_profile_name=decryption_profile_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@decryption_rule_group.command(name=cli_util.override('network_firewall.get_decryption_rule.command_name', 'get'), help=u"""Get Decryption Rule by the given name in the context of network firewall policy. \n[Command Reference](getDecryptionRule)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--decryption-rule-name', required=True, help=u"""Unique identifier for Decryption Rules in the network firewall policy.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'DecryptionRule'})
@cli_util.wrap_exceptions
def get_decryption_rule(ctx, from_json, network_firewall_policy_id, decryption_rule_name, limit, page):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(decryption_rule_name, six.string_types) and len(decryption_rule_name.strip()) == 0:
        raise click.UsageError('Parameter --decryption-rule-name cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.get_decryption_rule(
        network_firewall_policy_id=network_firewall_policy_id,
        decryption_rule_name=decryption_rule_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@mapped_secret_group.command(name=cli_util.override('network_firewall.get_mapped_secret.command_name', 'get'), help=u"""Get Mapped Secret by the given name in the context of network firewall policy. \n[Command Reference](getMappedSecret)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--mapped-secret-name', required=True, help=u"""Unique identifier for Mapped Secrets.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'MappedSecret'})
@cli_util.wrap_exceptions
def get_mapped_secret(ctx, from_json, network_firewall_policy_id, mapped_secret_name, limit, page):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(mapped_secret_name, six.string_types) and len(mapped_secret_name.strip()) == 0:
        raise click.UsageError('Parameter --mapped-secret-name cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.get_mapped_secret(
        network_firewall_policy_id=network_firewall_policy_id,
        mapped_secret_name=mapped_secret_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@network_firewall_group.command(name=cli_util.override('network_firewall.get_network_firewall.command_name', 'get'), help=u"""Gets a NetworkFirewall by identifier \n[Command Reference](getNetworkFirewall)""")
@cli_util.option('--network-firewall-id', required=True, help=u"""The [OCID] of the Network Firewall resource.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'NetworkFirewall'})
@cli_util.wrap_exceptions
def get_network_firewall(ctx, from_json, network_firewall_id):

    if isinstance(network_firewall_id, six.string_types) and len(network_firewall_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.get_network_firewall(
        network_firewall_id=network_firewall_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@network_firewall_policy_group.command(name=cli_util.override('network_firewall.get_network_firewall_policy.command_name', 'get'), help=u"""Gets a NetworkFirewallPolicy given the network firewall policy identifier. \n[Command Reference](getNetworkFirewallPolicy)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'NetworkFirewallPolicy'})
@cli_util.wrap_exceptions
def get_network_firewall_policy(ctx, from_json, network_firewall_policy_id):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.get_network_firewall_policy(
        network_firewall_policy_id=network_firewall_policy_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@security_rule_group.command(name=cli_util.override('network_firewall.get_security_rule.command_name', 'get'), help=u"""Get Security Rule by the given name in the context of network firewall policy. \n[Command Reference](getSecurityRule)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--security-rule-name', required=True, help=u"""Unique identifier for Security Rules in the network firewall policy.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'SecurityRule'})
@cli_util.wrap_exceptions
def get_security_rule(ctx, from_json, network_firewall_policy_id, security_rule_name):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(security_rule_name, six.string_types) and len(security_rule_name.strip()) == 0:
        raise click.UsageError('Parameter --security-rule-name cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.get_security_rule(
        network_firewall_policy_id=network_firewall_policy_id,
        security_rule_name=security_rule_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@service_group.command(name=cli_util.override('network_firewall.get_service.command_name', 'get'), help=u"""Get Service by the given name in the context of network firewall policy. \n[Command Reference](getService)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--service-name', required=True, help=u"""Unique identifier for Services.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'Service'})
@cli_util.wrap_exceptions
def get_service(ctx, from_json, network_firewall_policy_id, service_name, limit, page):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(service_name, six.string_types) and len(service_name.strip()) == 0:
        raise click.UsageError('Parameter --service-name cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.get_service(
        network_firewall_policy_id=network_firewall_policy_id,
        service_name=service_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@service_list_group.command(name=cli_util.override('network_firewall.get_service_list.command_name', 'get'), help=u"""Get ServiceList by the given name in the context of network firewall policy. \n[Command Reference](getServiceList)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--service-list-name', required=True, help=u"""Unique name identifier for Service Lists in the scope of Network Firewall Policy.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'ServiceList'})
@cli_util.wrap_exceptions
def get_service_list(ctx, from_json, network_firewall_policy_id, service_list_name):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(service_list_name, six.string_types) and len(service_list_name.strip()) == 0:
        raise click.UsageError('Parameter --service-list-name cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.get_service_list(
        network_firewall_policy_id=network_firewall_policy_id,
        service_list_name=service_list_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@url_list_group.command(name=cli_util.override('network_firewall.get_url_list.command_name', 'get'), help=u"""Get Url List by the given name in the context of network firewall policy. \n[Command Reference](getUrlList)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--url-list-name', required=True, help=u"""Unique name identifier for url lists in the scope of Network Firewall Policy.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'UrlList'})
@cli_util.wrap_exceptions
def get_url_list(ctx, from_json, network_firewall_policy_id, url_list_name):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(url_list_name, six.string_types) and len(url_list_name.strip()) == 0:
        raise click.UsageError('Parameter --url-list-name cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.get_url_list(
        network_firewall_policy_id=network_firewall_policy_id,
        url_list_name=url_list_name,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@work_request_group.command(name=cli_util.override('network_firewall.get_work_request.command_name', 'get'), help=u"""Gets the status of the work request with the given ID. \n[Command Reference](getWorkRequest)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'WorkRequest'})
@cli_util.wrap_exceptions
def get_work_request(ctx, from_json, work_request_id):

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.get_work_request(
        work_request_id=work_request_id,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@address_list_group.command(name=cli_util.override('network_firewall.list_address_lists.command_name', 'list'), help=u"""Returns a list of Network Firewall Policies. \n[Command Reference](listAddressLists)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'AddressListSummaryCollection'})
@cli_util.wrap_exceptions
def list_address_lists(ctx, from_json, all_pages, page_size, network_firewall_policy_id, limit, page, sort_order, sort_by, display_name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if display_name is not None:
        kwargs['display_name'] = display_name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_address_lists,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_address_lists,
            limit,
            page_size,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    else:
        result = client.list_address_lists(
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@application_group_group.command(name=cli_util.override('network_firewall.list_application_groups.command_name', 'list'), help=u"""Returns a list of ApplicationGroups for the policy. \n[Command Reference](listApplicationGroups)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'ApplicationGroupSummaryCollection'})
@cli_util.wrap_exceptions
def list_application_groups(ctx, from_json, all_pages, page_size, network_firewall_policy_id, limit, page, sort_order, sort_by, display_name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if display_name is not None:
        kwargs['display_name'] = display_name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_application_groups,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_application_groups,
            limit,
            page_size,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    else:
        result = client.list_application_groups(
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@application_group.command(name=cli_util.override('network_firewall.list_applications.command_name', 'list'), help=u"""Returns a list of Applications for the policy. \n[Command Reference](listApplications)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'ApplicationSummaryCollection'})
@cli_util.wrap_exceptions
def list_applications(ctx, from_json, all_pages, page_size, network_firewall_policy_id, limit, page, sort_order, sort_by, display_name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if display_name is not None:
        kwargs['display_name'] = display_name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_applications,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_applications,
            limit,
            page_size,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    else:
        result = client.list_applications(
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@decryption_profile_group.command(name=cli_util.override('network_firewall.list_decryption_profiles.command_name', 'list'), help=u"""Returns a list of Decryption Profile for the Network Firewall Policy. \n[Command Reference](listDecryptionProfiles)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'DecryptionProfileSummaryCollection'})
@cli_util.wrap_exceptions
def list_decryption_profiles(ctx, from_json, all_pages, page_size, network_firewall_policy_id, limit, page, sort_order, sort_by, display_name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if display_name is not None:
        kwargs['display_name'] = display_name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_decryption_profiles,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_decryption_profiles,
            limit,
            page_size,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    else:
        result = client.list_decryption_profiles(
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@decryption_rule_group.command(name=cli_util.override('network_firewall.list_decryption_rules.command_name', 'list'), help=u"""Returns a list of Decryption Rule for the Network Firewall Policy. \n[Command Reference](listDecryptionRules)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--decryption-rule-priority-order', type=click.INT, help=u"""Unique priority order for Decryption Rules in the network firewall policy.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'DecryptionRuleSummaryCollection'})
@cli_util.wrap_exceptions
def list_decryption_rules(ctx, from_json, all_pages, page_size, network_firewall_policy_id, limit, page, sort_order, sort_by, display_name, decryption_rule_priority_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if display_name is not None:
        kwargs['display_name'] = display_name
    if decryption_rule_priority_order is not None:
        kwargs['decryption_rule_priority_order'] = decryption_rule_priority_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_decryption_rules,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_decryption_rules,
            limit,
            page_size,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    else:
        result = client.list_decryption_rules(
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@mapped_secret_group.command(name=cli_util.override('network_firewall.list_mapped_secrets.command_name', 'list'), help=u"""Returns a list of Mapped Secret for the Network Firewall Policy. \n[Command Reference](listMappedSecrets)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'MappedSecretSummaryCollection'})
@cli_util.wrap_exceptions
def list_mapped_secrets(ctx, from_json, all_pages, page_size, network_firewall_policy_id, limit, page, sort_order, sort_by, display_name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if display_name is not None:
        kwargs['display_name'] = display_name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_mapped_secrets,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_mapped_secrets,
            limit,
            page_size,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    else:
        result = client.list_mapped_secrets(
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@network_firewall_policy_group.command(name=cli_util.override('network_firewall.list_network_firewall_policies.command_name', 'list'), help=u"""Returns a list of Network Firewall Policies. \n[Command Reference](listNetworkFirewallPolicies)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--id', help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION", "ATTACHING", "DETACHING"]), help=u"""A filter to return only resources with a lifecycleState matching the given value.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'NetworkFirewallPolicySummaryCollection'})
@cli_util.wrap_exceptions
def list_network_firewall_policies(ctx, from_json, all_pages, page_size, compartment_id, display_name, id, limit, page, lifecycle_state, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if display_name is not None:
        kwargs['display_name'] = display_name
    if id is not None:
        kwargs['id'] = id
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_network_firewall_policies,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_network_firewall_policies,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_network_firewall_policies(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@network_firewall_group.command(name=cli_util.override('network_firewall.list_network_firewalls.command_name', 'list'), help=u"""Returns a list of NetworkFirewalls. \n[Command Reference](listNetworkFirewalls)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--network-firewall-policy-id', help=u"""A filter to return only resources that match the entire networkFirewallPolicyId given.""")
@cli_util.option('--id', help=u"""The [OCID] of the Network Firewall resource.""")
@cli_util.option('--availability-domain', help=u"""A filter to return only resources that are present within the specified availability domain. To get a list of availability domains for a tenancy, use [ListAvailabilityDomains] operation. Example: `kIdk:PHX-AD-1`""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@cli_util.option('--lifecycle-state', type=custom_types.CliCaseInsensitiveChoice(["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION", "ATTACHING", "DETACHING"]), help=u"""A filter to return only resources with a lifecycleState matching the given value.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'NetworkFirewallCollection'})
@cli_util.wrap_exceptions
def list_network_firewalls(ctx, from_json, all_pages, page_size, compartment_id, display_name, network_firewall_policy_id, id, availability_domain, limit, page, lifecycle_state, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')
    if sort_by and not availability_domain and not all_pages:
        raise click.UsageError('You must provide an --availability-domain when doing a --sort-by, unless you specify the --all parameter')

    kwargs = {}
    if display_name is not None:
        kwargs['display_name'] = display_name
    if network_firewall_policy_id is not None:
        kwargs['network_firewall_policy_id'] = network_firewall_policy_id
    if id is not None:
        kwargs['id'] = id
    if availability_domain is not None:
        kwargs['availability_domain'] = availability_domain
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if lifecycle_state is not None:
        kwargs['lifecycle_state'] = lifecycle_state
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_network_firewalls,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_network_firewalls,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_network_firewalls(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@security_rule_group.command(name=cli_util.override('network_firewall.list_security_rules.command_name', 'list'), help=u"""Returns a list of Security Rule for the Network Firewall Policy. \n[Command Reference](listSecurityRules)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--security-rule-priority-order', type=click.INT, help=u"""Unique priority order for Security Rules in the network firewall policy.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'SecurityRuleSummaryCollection'})
@cli_util.wrap_exceptions
def list_security_rules(ctx, from_json, all_pages, page_size, network_firewall_policy_id, limit, page, sort_order, sort_by, display_name, security_rule_priority_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if display_name is not None:
        kwargs['display_name'] = display_name
    if security_rule_priority_order is not None:
        kwargs['security_rule_priority_order'] = security_rule_priority_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_security_rules,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_security_rules,
            limit,
            page_size,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    else:
        result = client.list_security_rules(
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@service_list_group.command(name=cli_util.override('network_firewall.list_service_lists.command_name', 'list'), help=u"""Returns a list of ServiceLists for the policy. \n[Command Reference](listServiceLists)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'ServiceListSummaryCollection'})
@cli_util.wrap_exceptions
def list_service_lists(ctx, from_json, all_pages, page_size, network_firewall_policy_id, limit, page, sort_order, sort_by, display_name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if display_name is not None:
        kwargs['display_name'] = display_name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_service_lists,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_service_lists,
            limit,
            page_size,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    else:
        result = client.list_service_lists(
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@service_group.command(name=cli_util.override('network_firewall.list_services.command_name', 'list'), help=u"""Returns a list of Services for the policy. \n[Command Reference](listServices)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'ServiceSummaryCollection'})
@cli_util.wrap_exceptions
def list_services(ctx, from_json, all_pages, page_size, network_firewall_policy_id, limit, page, sort_order, sort_by, display_name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if display_name is not None:
        kwargs['display_name'] = display_name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_services,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_services,
            limit,
            page_size,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    else:
        result = client.list_services(
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@url_list_group.command(name=cli_util.override('network_firewall.list_url_lists.command_name', 'list'), help=u"""Returns a list of URL lists for the Network Firewall Policy. \n[Command Reference](listUrlLists)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeCreated", "displayName"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.""")
@cli_util.option('--display-name', help=u"""A filter to return only resources that match the entire display name given.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'UrlListSummaryCollection'})
@cli_util.wrap_exceptions
def list_url_lists(ctx, from_json, all_pages, page_size, network_firewall_policy_id, limit, page, sort_order, sort_by, display_name):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if limit is not None:
        kwargs['limit'] = limit
    if page is not None:
        kwargs['page'] = page
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if display_name is not None:
        kwargs['display_name'] = display_name
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_url_lists,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_url_lists,
            limit,
            page_size,
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    else:
        result = client.list_url_lists(
            network_firewall_policy_id=network_firewall_policy_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_error_group.command(name=cli_util.override('network_firewall.list_work_request_errors.command_name', 'list'), help=u"""Return a (paginated) list of errors for a given work request. \n[Command Reference](listWorkRequestErrors)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeAccepted"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeAccepted is descending.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'WorkRequestErrorCollection'})
@cli_util.wrap_exceptions
def list_work_request_errors(ctx, from_json, all_pages, page_size, work_request_id, page, limit, sort_by, sort_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_request_errors,
            work_request_id=work_request_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_request_errors,
            limit,
            page_size,
            work_request_id=work_request_id,
            **kwargs
        )
    else:
        result = client.list_work_request_errors(
            work_request_id=work_request_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_log_entry_group.command(name=cli_util.override('network_firewall.list_work_request_logs.command_name', 'list-work-request-logs'), help=u"""Return a (paginated) list of logs for a given work request. \n[Command Reference](listWorkRequestLogs)""")
@cli_util.option('--work-request-id', required=True, help=u"""The ID of the asynchronous request.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeAccepted"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeAccepted is descending.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'WorkRequestLogEntryCollection'})
@cli_util.wrap_exceptions
def list_work_request_logs(ctx, from_json, all_pages, page_size, work_request_id, page, limit, sort_by, sort_order):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    if isinstance(work_request_id, six.string_types) and len(work_request_id.strip()) == 0:
        raise click.UsageError('Parameter --work-request-id cannot be whitespace or empty string')

    kwargs = {}
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_request_logs,
            work_request_id=work_request_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_request_logs,
            limit,
            page_size,
            work_request_id=work_request_id,
            **kwargs
        )
    else:
        result = client.list_work_request_logs(
            work_request_id=work_request_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@work_request_group.command(name=cli_util.override('network_firewall.list_work_requests.command_name', 'list'), help=u"""Lists the work requests in a compartment. \n[Command Reference](listWorkRequests)""")
@cli_util.option('--compartment-id', required=True, help=u"""The ID of the compartment in which to list resources.""")
@cli_util.option('--work-request-id', help=u"""The ID of the asynchronous work request.""")
@cli_util.option('--status', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), help=u"""A filter to return only resources their lifecycleState matches the given OperationStatus.""")
@cli_util.option('--resource-id', help=u"""The ID of the resource affected by the work request.""")
@cli_util.option('--page', help=u"""A token representing the position at which to start retrieving results. This must come from the `opc-next-page` or `opc-prev-page` header field of a previous response.""")
@cli_util.option('--limit', type=click.INT, help=u"""The maximum number of items to return.""")
@cli_util.option('--sort-order', type=custom_types.CliCaseInsensitiveChoice(["ASC", "DESC"]), help=u"""The sort order to use, either 'ASC' or 'DESC'.""")
@cli_util.option('--sort-by', type=custom_types.CliCaseInsensitiveChoice(["timeAccepted"]), help=u"""The field to sort by. Only one sort order may be provided. Default order for timeAccepted is descending.""")
@cli_util.option('--all', 'all_pages', is_flag=True, help="""Fetches all pages of results. If you provide this option, then you cannot provide the --limit option.""")
@cli_util.option('--page-size', type=click.INT, help="""When fetching results, the number of results to fetch per call. Only valid when used with --all or --limit, and ignored otherwise.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'WorkRequestSummaryCollection'})
@cli_util.wrap_exceptions
def list_work_requests(ctx, from_json, all_pages, page_size, compartment_id, work_request_id, status, resource_id, page, limit, sort_order, sort_by):

    if all_pages and limit:
        raise click.UsageError('If you provide the --all option you cannot provide the --limit option')

    kwargs = {}
    if work_request_id is not None:
        kwargs['work_request_id'] = work_request_id
    if status is not None:
        kwargs['status'] = status
    if resource_id is not None:
        kwargs['resource_id'] = resource_id
    if page is not None:
        kwargs['page'] = page
    if limit is not None:
        kwargs['limit'] = limit
    if sort_order is not None:
        kwargs['sort_order'] = sort_order
    if sort_by is not None:
        kwargs['sort_by'] = sort_by
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    if all_pages:
        if page_size:
            kwargs['limit'] = page_size

        result = cli_util.list_call_get_all_results(
            client.list_work_requests,
            compartment_id=compartment_id,
            **kwargs
        )
    elif limit is not None:
        result = cli_util.list_call_get_up_to_limit(
            client.list_work_requests,
            limit,
            page_size,
            compartment_id=compartment_id,
            **kwargs
        )
    else:
        result = client.list_work_requests(
            compartment_id=compartment_id,
            **kwargs
        )
    cli_util.render_response(result, ctx)


@network_firewall_policy_group.command(name=cli_util.override('network_firewall.migrate_network_firewall_policy.command_name', 'migrate'), help=u"""Moves a NetworkFirewallPolicy resource from one version to latest version. When provided, If-Match is checked against ETag values of the resource. \n[Command Reference](migrateNetworkFirewallPolicy)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={})
@cli_util.wrap_exceptions
def migrate_network_firewall_policy(ctx, from_json, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_policy_id, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])
    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.migrate_network_firewall_policy(
        network_firewall_policy_id=network_firewall_policy_id,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@address_list_group.command(name=cli_util.override('network_firewall.update_address_list.command_name', 'update'), help=u"""Updates the Address list with the given name in the network firewall policy. \n[Command Reference](updateAddressList)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--address-list-name', required=True, help=u"""Unique identifier for address lists.""")
@cli_util.option('--type', required=True, type=custom_types.CliCaseInsensitiveChoice(["FQDN", "IP"]), help=u"""Type of address List. The accepted values are - * FQDN * IP""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'AddressList'})
@cli_util.wrap_exceptions
def update_address_list(ctx, from_json, network_firewall_policy_id, address_list_name, type, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(address_list_name, six.string_types) and len(address_list_name.strip()) == 0:
        raise click.UsageError('Parameter --address-list-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['type'] = type

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_address_list(
        network_firewall_policy_id=network_firewall_policy_id,
        address_list_name=address_list_name,
        update_address_list_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@address_list_group.command(name=cli_util.override('network_firewall.update_address_list_update_fqdn_address_list_details.command_name', 'update-address-list-update-fqdn-address-list-details'), help=u"""Updates the Address list with the given name in the network firewall policy. \n[Command Reference](updateAddressList)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--address-list-name', required=True, help=u"""Unique identifier for address lists.""")
@cli_util.option('--addresses', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of FQDN addresses.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@json_skeleton_utils.get_cli_json_input_option({'addresses': {'module': 'network_firewall', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'addresses': {'module': 'network_firewall', 'class': 'list[string]'}}, output_type={'module': 'network_firewall', 'class': 'AddressList'})
@cli_util.wrap_exceptions
def update_address_list_update_fqdn_address_list_details(ctx, from_json, force, network_firewall_policy_id, address_list_name, addresses, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(address_list_name, six.string_types) and len(address_list_name.strip()) == 0:
        raise click.UsageError('Parameter --address-list-name cannot be whitespace or empty string')
    if not force:
        if addresses:
            if not click.confirm("WARNING: Updates to addresses will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['addresses'] = cli_util.parse_json_parameter("addresses", addresses)

    _details['type'] = 'FQDN'

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_address_list(
        network_firewall_policy_id=network_firewall_policy_id,
        address_list_name=address_list_name,
        update_address_list_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@address_list_group.command(name=cli_util.override('network_firewall.update_address_list_update_ip_address_list_details.command_name', 'update-address-list-update-ip-address-list-details'), help=u"""Updates the Address list with the given name in the network firewall policy. \n[Command Reference](updateAddressList)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--address-list-name', required=True, help=u"""Unique identifier for address lists.""")
@cli_util.option('--addresses', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of IP addresses which could be IPv4 or IPv6 addresses or CIDR blocks.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@json_skeleton_utils.get_cli_json_input_option({'addresses': {'module': 'network_firewall', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'addresses': {'module': 'network_firewall', 'class': 'list[string]'}}, output_type={'module': 'network_firewall', 'class': 'AddressList'})
@cli_util.wrap_exceptions
def update_address_list_update_ip_address_list_details(ctx, from_json, force, network_firewall_policy_id, address_list_name, addresses, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(address_list_name, six.string_types) and len(address_list_name.strip()) == 0:
        raise click.UsageError('Parameter --address-list-name cannot be whitespace or empty string')
    if not force:
        if addresses:
            if not click.confirm("WARNING: Updates to addresses will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['addresses'] = cli_util.parse_json_parameter("addresses", addresses)

    _details['type'] = 'IP'

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_address_list(
        network_firewall_policy_id=network_firewall_policy_id,
        address_list_name=address_list_name,
        update_address_list_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@application_group.command(name=cli_util.override('network_firewall.update_application.command_name', 'update'), help=u"""Updates the Application with the given name in the network firewall policy. \n[Command Reference](updateApplication)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--application-name', required=True, help=u"""Unique identifier for Applications.""")
@cli_util.option('--type', required=True, type=custom_types.CliCaseInsensitiveChoice(["ICMP", "ICMP_V6"]), help=u"""Describes the type of Application.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'Application'})
@cli_util.wrap_exceptions
def update_application(ctx, from_json, network_firewall_policy_id, application_name, type, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(application_name, six.string_types) and len(application_name.strip()) == 0:
        raise click.UsageError('Parameter --application-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['type'] = type

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_application(
        network_firewall_policy_id=network_firewall_policy_id,
        application_name=application_name,
        update_application_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@application_group.command(name=cli_util.override('network_firewall.update_application_update_icmp6_application_details.command_name', 'update-application-update-icmp6-application-details'), help=u"""Updates the Application with the given name in the network firewall policy. \n[Command Reference](updateApplication)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--application-name', required=True, help=u"""Unique identifier for Applications.""")
@cli_util.option('--icmp-type', required=True, type=click.INT, help=u"""The value of the ICMP6 message Type field as defined by [RFC 4443].""")
@cli_util.option('--icmp-code', type=click.INT, help=u"""The value of the ICMP6 message Code (subtype) field as defined by [RFC 4443].""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'Application'})
@cli_util.wrap_exceptions
def update_application_update_icmp6_application_details(ctx, from_json, network_firewall_policy_id, application_name, icmp_type, icmp_code, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(application_name, six.string_types) and len(application_name.strip()) == 0:
        raise click.UsageError('Parameter --application-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['icmpType'] = icmp_type

    if icmp_code is not None:
        _details['icmpCode'] = icmp_code

    _details['type'] = 'ICMP_V6'

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_application(
        network_firewall_policy_id=network_firewall_policy_id,
        application_name=application_name,
        update_application_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@application_group.command(name=cli_util.override('network_firewall.update_application_update_icmp_application_details.command_name', 'update-application-update-icmp-application-details'), help=u"""Updates the Application with the given name in the network firewall policy. \n[Command Reference](updateApplication)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--application-name', required=True, help=u"""Unique identifier for Applications.""")
@cli_util.option('--icmp-type', required=True, type=click.INT, help=u"""The value of the ICMP message Type field as defined by [RFC 792].""")
@cli_util.option('--icmp-code', type=click.INT, help=u"""The value of the ICMP message Code (subtype) field as defined by [RFC 792].""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'Application'})
@cli_util.wrap_exceptions
def update_application_update_icmp_application_details(ctx, from_json, network_firewall_policy_id, application_name, icmp_type, icmp_code, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(application_name, six.string_types) and len(application_name.strip()) == 0:
        raise click.UsageError('Parameter --application-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['icmpType'] = icmp_type

    if icmp_code is not None:
        _details['icmpCode'] = icmp_code

    _details['type'] = 'ICMP'

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_application(
        network_firewall_policy_id=network_firewall_policy_id,
        application_name=application_name,
        update_application_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@application_group_group.command(name=cli_util.override('network_firewall.update_application_group.command_name', 'update'), help=u"""Updates the ApplicationGroup with the given name in the network firewall policy. \n[Command Reference](updateApplicationGroup)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--application-group-name', required=True, help=u"""Unique name identifier for Application Lists in the scope of Network Firewall Policy.""")
@cli_util.option('--apps', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""Collection of application names.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@json_skeleton_utils.get_cli_json_input_option({'apps': {'module': 'network_firewall', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'apps': {'module': 'network_firewall', 'class': 'list[string]'}}, output_type={'module': 'network_firewall', 'class': 'ApplicationGroup'})
@cli_util.wrap_exceptions
def update_application_group(ctx, from_json, force, network_firewall_policy_id, application_group_name, apps, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(application_group_name, six.string_types) and len(application_group_name.strip()) == 0:
        raise click.UsageError('Parameter --application-group-name cannot be whitespace or empty string')
    if not force:
        if apps:
            if not click.confirm("WARNING: Updates to apps will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['apps'] = cli_util.parse_json_parameter("apps", apps)

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_application_group(
        network_firewall_policy_id=network_firewall_policy_id,
        application_group_name=application_group_name,
        update_application_group_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@decryption_profile_group.command(name=cli_util.override('network_firewall.update_decryption_profile.command_name', 'update'), help=u"""Updates the Decryption Profile with the given name in the network firewall policy. \n[Command Reference](updateDecryptionProfile)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--decryption-profile-name', required=True, help=u"""Unique identifier for Decryption Profiles.""")
@cli_util.option('--type', required=True, type=custom_types.CliCaseInsensitiveChoice(["SSL_INBOUND_INSPECTION", "SSL_FORWARD_PROXY"]), help=u"""Describes the type of Decryption Profile SslForwardProxy or SslInboundInspection.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'DecryptionProfile'})
@cli_util.wrap_exceptions
def update_decryption_profile(ctx, from_json, network_firewall_policy_id, decryption_profile_name, type, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(decryption_profile_name, six.string_types) and len(decryption_profile_name.strip()) == 0:
        raise click.UsageError('Parameter --decryption-profile-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['type'] = type

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_decryption_profile(
        network_firewall_policy_id=network_firewall_policy_id,
        decryption_profile_name=decryption_profile_name,
        update_decryption_profile_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@decryption_profile_group.command(name=cli_util.override('network_firewall.update_decryption_profile_update_ssl_inbound_inspection_profile_details.command_name', 'update-decryption-profile-update-ssl-inbound-inspection-profile-details'), help=u"""Updates the Decryption Profile with the given name in the network firewall policy. \n[Command Reference](updateDecryptionProfile)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--decryption-profile-name', required=True, help=u"""Unique identifier for Decryption Profiles.""")
@cli_util.option('--is-unsupported-version-blocked', type=click.BOOL, help=u"""Whether to block sessions if SSL version is not supported.""")
@cli_util.option('--is-unsupported-cipher-blocked', type=click.BOOL, help=u"""Whether to block sessions if SSL cipher suite is not supported.""")
@cli_util.option('--is-out-of-capacity-blocked', type=click.BOOL, help=u"""Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'DecryptionProfile'})
@cli_util.wrap_exceptions
def update_decryption_profile_update_ssl_inbound_inspection_profile_details(ctx, from_json, network_firewall_policy_id, decryption_profile_name, is_unsupported_version_blocked, is_unsupported_cipher_blocked, is_out_of_capacity_blocked, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(decryption_profile_name, six.string_types) and len(decryption_profile_name.strip()) == 0:
        raise click.UsageError('Parameter --decryption-profile-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if is_unsupported_version_blocked is not None:
        _details['isUnsupportedVersionBlocked'] = is_unsupported_version_blocked

    if is_unsupported_cipher_blocked is not None:
        _details['isUnsupportedCipherBlocked'] = is_unsupported_cipher_blocked

    if is_out_of_capacity_blocked is not None:
        _details['isOutOfCapacityBlocked'] = is_out_of_capacity_blocked

    _details['type'] = 'SSL_INBOUND_INSPECTION'

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_decryption_profile(
        network_firewall_policy_id=network_firewall_policy_id,
        decryption_profile_name=decryption_profile_name,
        update_decryption_profile_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@decryption_profile_group.command(name=cli_util.override('network_firewall.update_decryption_profile_update_ssl_forward_proxy_profile_details.command_name', 'update-decryption-profile-update-ssl-forward-proxy-profile-details'), help=u"""Updates the Decryption Profile with the given name in the network firewall policy. \n[Command Reference](updateDecryptionProfile)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--decryption-profile-name', required=True, help=u"""Unique identifier for Decryption Profiles.""")
@cli_util.option('--is-expired-certificate-blocked', type=click.BOOL, help=u"""Whether to block sessions if server's certificate is expired.""")
@cli_util.option('--is-untrusted-issuer-blocked', type=click.BOOL, help=u"""Whether to block sessions if server's certificate is issued by an untrusted certificate authority (CA).""")
@cli_util.option('--is-revocation-status-timeout-blocked', type=click.BOOL, help=u"""Whether to block sessions if the revocation status check for server's certificate does not succeed within the maximum allowed time (defaulting to 5 seconds).""")
@cli_util.option('--is-unsupported-version-blocked', type=click.BOOL, help=u"""Whether to block sessions if SSL version is not supported.""")
@cli_util.option('--is-unsupported-cipher-blocked', type=click.BOOL, help=u"""Whether to block sessions if SSL cipher suite is not supported.""")
@cli_util.option('--is-unknown-revocation-status-blocked', type=click.BOOL, help=u"""Whether to block sessions if the revocation status check for server's certificate results in \"unknown\".""")
@cli_util.option('--are-certificate-extensions-restricted', type=click.BOOL, help=u"""Whether to block sessions if the server's certificate uses extensions other than key usage and/or extended key usage.""")
@cli_util.option('--is-auto-include-alt-name', type=click.BOOL, help=u"""Whether to automatically append SAN to impersonating certificate if server certificate is missing SAN.""")
@cli_util.option('--is-out-of-capacity-blocked', type=click.BOOL, help=u"""Whether to block sessions if the firewall is temporarily unable to decrypt their traffic.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'DecryptionProfile'})
@cli_util.wrap_exceptions
def update_decryption_profile_update_ssl_forward_proxy_profile_details(ctx, from_json, network_firewall_policy_id, decryption_profile_name, is_expired_certificate_blocked, is_untrusted_issuer_blocked, is_revocation_status_timeout_blocked, is_unsupported_version_blocked, is_unsupported_cipher_blocked, is_unknown_revocation_status_blocked, are_certificate_extensions_restricted, is_auto_include_alt_name, is_out_of_capacity_blocked, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(decryption_profile_name, six.string_types) and len(decryption_profile_name.strip()) == 0:
        raise click.UsageError('Parameter --decryption-profile-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if is_expired_certificate_blocked is not None:
        _details['isExpiredCertificateBlocked'] = is_expired_certificate_blocked

    if is_untrusted_issuer_blocked is not None:
        _details['isUntrustedIssuerBlocked'] = is_untrusted_issuer_blocked

    if is_revocation_status_timeout_blocked is not None:
        _details['isRevocationStatusTimeoutBlocked'] = is_revocation_status_timeout_blocked

    if is_unsupported_version_blocked is not None:
        _details['isUnsupportedVersionBlocked'] = is_unsupported_version_blocked

    if is_unsupported_cipher_blocked is not None:
        _details['isUnsupportedCipherBlocked'] = is_unsupported_cipher_blocked

    if is_unknown_revocation_status_blocked is not None:
        _details['isUnknownRevocationStatusBlocked'] = is_unknown_revocation_status_blocked

    if are_certificate_extensions_restricted is not None:
        _details['areCertificateExtensionsRestricted'] = are_certificate_extensions_restricted

    if is_auto_include_alt_name is not None:
        _details['isAutoIncludeAltName'] = is_auto_include_alt_name

    if is_out_of_capacity_blocked is not None:
        _details['isOutOfCapacityBlocked'] = is_out_of_capacity_blocked

    _details['type'] = 'SSL_FORWARD_PROXY'

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_decryption_profile(
        network_firewall_policy_id=network_firewall_policy_id,
        decryption_profile_name=decryption_profile_name,
        update_decryption_profile_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@decryption_rule_group.command(name=cli_util.override('network_firewall.update_decryption_rule.command_name', 'update'), help=u"""Updates the Decryption Rule with the given name in the network firewall policy. \n[Command Reference](updateDecryptionRule)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--decryption-rule-name', required=True, help=u"""Unique identifier for Decryption Rules in the network firewall policy.""")
@cli_util.option('--condition', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--action', required=True, type=custom_types.CliCaseInsensitiveChoice(["NO_DECRYPT", "DECRYPT"]), help=u"""Action:

* NO_DECRYPT - Matching traffic is not decrypted. * DECRYPT - Matching traffic is decrypted with the specified `secret` according to the specified `decryptionProfile`.""")
@cli_util.option('--decryption-profile', help=u"""The name of the decryption profile to use.""")
@cli_util.option('--secret', help=u"""The name of a mapped secret. Its `type` must match that of the specified decryption profile.""")
@cli_util.option('--position', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@json_skeleton_utils.get_cli_json_input_option({'condition': {'module': 'network_firewall', 'class': 'DecryptionRuleMatchCriteria'}, 'position': {'module': 'network_firewall', 'class': 'RulePosition'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'condition': {'module': 'network_firewall', 'class': 'DecryptionRuleMatchCriteria'}, 'position': {'module': 'network_firewall', 'class': 'RulePosition'}}, output_type={'module': 'network_firewall', 'class': 'DecryptionRule'})
@cli_util.wrap_exceptions
def update_decryption_rule(ctx, from_json, force, network_firewall_policy_id, decryption_rule_name, condition, action, decryption_profile, secret, position, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(decryption_rule_name, six.string_types) and len(decryption_rule_name.strip()) == 0:
        raise click.UsageError('Parameter --decryption-rule-name cannot be whitespace or empty string')
    if not force:
        if condition or position:
            if not click.confirm("WARNING: Updates to condition and position will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['condition'] = cli_util.parse_json_parameter("condition", condition)
    _details['action'] = action

    if decryption_profile is not None:
        _details['decryptionProfile'] = decryption_profile

    if secret is not None:
        _details['secret'] = secret

    if position is not None:
        _details['position'] = cli_util.parse_json_parameter("position", position)

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_decryption_rule(
        network_firewall_policy_id=network_firewall_policy_id,
        decryption_rule_name=decryption_rule_name,
        update_decryption_rule_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@mapped_secret_group.command(name=cli_util.override('network_firewall.update_mapped_secret.command_name', 'update'), help=u"""Updates the Mapped Secret with the given name in the network firewall policy. \n[Command Reference](updateMappedSecret)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--mapped-secret-name', required=True, help=u"""Unique identifier for Mapped Secrets.""")
@cli_util.option('--source', required=True, help=u"""Source of the secrets, where the secrets are stored.""")
@cli_util.option('--type', required=True, type=custom_types.CliCaseInsensitiveChoice(["SSL_INBOUND_INSPECTION", "SSL_FORWARD_PROXY"]), help=u"""Type of the secrets mapped based on the policy.

 * `SSL_INBOUND_INSPECTION`: For Inbound inspection of SSL traffic.  * `SSL_FORWARD_PROXY`: For forward proxy certificates for SSL inspection.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'MappedSecret'})
@cli_util.wrap_exceptions
def update_mapped_secret(ctx, from_json, network_firewall_policy_id, mapped_secret_name, source, type, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(mapped_secret_name, six.string_types) and len(mapped_secret_name.strip()) == 0:
        raise click.UsageError('Parameter --mapped-secret-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['source'] = source
    _details['type'] = type

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_mapped_secret(
        network_firewall_policy_id=network_firewall_policy_id,
        mapped_secret_name=mapped_secret_name,
        update_mapped_secret_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@mapped_secret_group.command(name=cli_util.override('network_firewall.update_mapped_secret_update_vault_mapped_secret_details.command_name', 'update-mapped-secret-update-vault-mapped-secret-details'), help=u"""Updates the Mapped Secret with the given name in the network firewall policy. \n[Command Reference](updateMappedSecret)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--mapped-secret-name', required=True, help=u"""Unique identifier for Mapped Secrets.""")
@cli_util.option('--type', required=True, type=custom_types.CliCaseInsensitiveChoice(["SSL_INBOUND_INSPECTION", "SSL_FORWARD_PROXY"]), help=u"""Type of the secrets mapped based on the policy.

 * `SSL_INBOUND_INSPECTION`: For Inbound inspection of SSL traffic.  * `SSL_FORWARD_PROXY`: For forward proxy certificates for SSL inspection.""")
@cli_util.option('--vault-secret-id', required=True, help=u"""OCID for the Vault Secret to be used.""")
@cli_util.option('--version-number', required=True, type=click.INT, help=u"""Version number of the secret to be used.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'MappedSecret'})
@cli_util.wrap_exceptions
def update_mapped_secret_update_vault_mapped_secret_details(ctx, from_json, network_firewall_policy_id, mapped_secret_name, type, vault_secret_id, version_number, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(mapped_secret_name, six.string_types) and len(mapped_secret_name.strip()) == 0:
        raise click.UsageError('Parameter --mapped-secret-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['type'] = type
    _details['vaultSecretId'] = vault_secret_id
    _details['versionNumber'] = version_number

    _details['source'] = 'OCI_VAULT'

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_mapped_secret(
        network_firewall_policy_id=network_firewall_policy_id,
        mapped_secret_name=mapped_secret_name,
        update_mapped_secret_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@network_firewall_group.command(name=cli_util.override('network_firewall.update_network_firewall.command_name', 'update'), help=u"""Updates the NetworkFirewall \n[Command Reference](updateNetworkFirewall)""")
@cli_util.option('--network-firewall-id', required=True, help=u"""The [OCID] of the Network Firewall resource.""")
@cli_util.option('--display-name', help=u"""A user-friendly name for the Network Firewall. Does not have to be unique, and it's changeable. Avoid entering confidential information.""")
@cli_util.option('--network-firewall-policy-id', help=u"""The [OCID] of the Network Firewall Policy.""")
@cli_util.option('--network-security-group-ids', type=custom_types.CLI_COMPLEX_TYPE, help=u"""An array of network security groups [OCID] associated with the Network Firewall.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags]. Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags]. Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'network-security-group-ids': {'module': 'network_firewall', 'class': 'list[string]'}, 'freeform-tags': {'module': 'network_firewall', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'network_firewall', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'network-security-group-ids': {'module': 'network_firewall', 'class': 'list[string]'}, 'freeform-tags': {'module': 'network_firewall', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'network_firewall', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def update_network_firewall(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_id, display_name, network_firewall_policy_id, network_security_group_ids, freeform_tags, defined_tags, if_match):

    if isinstance(network_firewall_id, six.string_types) and len(network_firewall_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-id cannot be whitespace or empty string')
    if not force:
        if network_security_group_ids or freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to network-security-group-ids and freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if network_firewall_policy_id is not None:
        _details['networkFirewallPolicyId'] = network_firewall_policy_id

    if network_security_group_ids is not None:
        _details['networkSecurityGroupIds'] = cli_util.parse_json_parameter("network_security_group_ids", network_security_group_ids)

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_network_firewall(
        network_firewall_id=network_firewall_id,
        update_network_firewall_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@network_firewall_policy_group.command(name=cli_util.override('network_firewall.update_network_firewall_policy.command_name', 'update'), help=u"""Updates the NetworkFirewallPolicy \n[Command Reference](updateNetworkFirewallPolicy)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--display-name', help=u"""A user-friendly name for the firewall. Does not have to be unique, and it's changeable. Avoid entering confidential information.""")
@cli_util.option('--freeform-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags]. Example: `{\"Department\": \"Finance\"}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--defined-tags', type=custom_types.CLI_COMPLEX_TYPE, help=u"""Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags]. Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@cli_util.option('--wait-for-state', type=custom_types.CliCaseInsensitiveChoice(["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "NEEDS_ATTENTION", "CANCELING", "CANCELED"]), multiple=True, help="""This operation asynchronously creates, modifies or deletes a resource and uses a work request to track the progress of the operation. Specify this option to perform the action and then wait until the work request reaches a certain state. Multiple states can be specified, returning on the first state. For example, --wait-for-state SUCCEEDED --wait-for-state FAILED would return on whichever lifecycle state is reached first. If timeout is reached, a return code of 2 is returned. For any other error, a return code of 1 is returned.""")
@cli_util.option('--max-wait-seconds', type=click.INT, help="""The maximum time to wait for the work request to reach the state defined by --wait-for-state. Defaults to 1200 seconds.""")
@cli_util.option('--wait-interval-seconds', type=click.INT, help="""Check every --wait-interval-seconds to see whether the work request has reached the state defined by --wait-for-state. Defaults to 30 seconds.""")
@json_skeleton_utils.get_cli_json_input_option({'freeform-tags': {'module': 'network_firewall', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'network_firewall', 'class': 'dict(str, dict(str, object))'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'freeform-tags': {'module': 'network_firewall', 'class': 'dict(str, string)'}, 'defined-tags': {'module': 'network_firewall', 'class': 'dict(str, dict(str, object))'}})
@cli_util.wrap_exceptions
def update_network_firewall_policy(ctx, from_json, force, wait_for_state, max_wait_seconds, wait_interval_seconds, network_firewall_policy_id, display_name, freeform_tags, defined_tags, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')
    if not force:
        if freeform_tags or defined_tags:
            if not click.confirm("WARNING: Updates to freeform-tags and defined-tags will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}

    if display_name is not None:
        _details['displayName'] = display_name

    if freeform_tags is not None:
        _details['freeformTags'] = cli_util.parse_json_parameter("freeform_tags", freeform_tags)

    if defined_tags is not None:
        _details['definedTags'] = cli_util.parse_json_parameter("defined_tags", defined_tags)

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_network_firewall_policy(
        network_firewall_policy_id=network_firewall_policy_id,
        update_network_firewall_policy_details=_details,
        **kwargs
    )
    if wait_for_state:

        if hasattr(client, 'get_work_request') and callable(getattr(client, 'get_work_request')):
            try:
                wait_period_kwargs = {}
                if max_wait_seconds is not None:
                    wait_period_kwargs['max_wait_seconds'] = max_wait_seconds
                if wait_interval_seconds is not None:
                    wait_period_kwargs['max_interval_seconds'] = wait_interval_seconds

                click.echo('Action completed. Waiting until the work request has entered state: {}'.format(wait_for_state), file=sys.stderr)
                result = oci.wait_until(client, client.get_work_request(result.headers['opc-work-request-id']), 'status', wait_for_state, **wait_period_kwargs)
            except oci.exceptions.MaximumWaitTimeExceeded as e:
                # If we fail, we should show an error, but we should still provide the information to the customer
                click.echo('Failed to wait until the work request entered the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                sys.exit(2)
            except Exception:
                click.echo('Encountered error while waiting for work request to enter the specified state. Outputting last known resource state', file=sys.stderr)
                cli_util.render_response(result, ctx)
                raise
        else:
            click.echo('Unable to wait for the work request to enter the specified state', file=sys.stderr)
    cli_util.render_response(result, ctx)


@security_rule_group.command(name=cli_util.override('network_firewall.update_security_rule.command_name', 'update'), help=u"""Updates the Security Rule with the given name in the network firewall policy. \n[Command Reference](updateSecurityRule)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--security-rule-name', required=True, help=u"""Unique identifier for Security Rules in the network firewall policy.""")
@cli_util.option('--condition', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--action', required=True, type=custom_types.CliCaseInsensitiveChoice(["ALLOW", "DROP", "REJECT", "INSPECT"]), help=u"""Types of Action on the Traffic flow.

  * ALLOW - Allows the traffic.   * DROP - Silently drops the traffic, e.g. without sending a TCP reset.   * REJECT - Rejects the traffic, sending a TCP reset to client and/or server as applicable.   * INSPECT - Inspects traffic for vulnerability as specified in `inspection`, which may result in rejection.""")
@cli_util.option('--inspection', type=custom_types.CliCaseInsensitiveChoice(["INTRUSION_DETECTION", "INTRUSION_PREVENTION"]), help=u"""Type of inspection to affect the Traffic flow. This is only applicable if action is INSPECT.

  * INTRUSION_DETECTION - Intrusion Detection.   * INTRUSION_PREVENTION - Intrusion Detection and Prevention. Traffic classified as potentially malicious will be rejected as described in `type`.""")
@cli_util.option('--position', type=custom_types.CLI_COMPLEX_TYPE, help=u"""""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@json_skeleton_utils.get_cli_json_input_option({'condition': {'module': 'network_firewall', 'class': 'SecurityRuleMatchCriteria'}, 'position': {'module': 'network_firewall', 'class': 'RulePosition'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'condition': {'module': 'network_firewall', 'class': 'SecurityRuleMatchCriteria'}, 'position': {'module': 'network_firewall', 'class': 'RulePosition'}}, output_type={'module': 'network_firewall', 'class': 'SecurityRule'})
@cli_util.wrap_exceptions
def update_security_rule(ctx, from_json, force, network_firewall_policy_id, security_rule_name, condition, action, inspection, position, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(security_rule_name, six.string_types) and len(security_rule_name.strip()) == 0:
        raise click.UsageError('Parameter --security-rule-name cannot be whitespace or empty string')
    if not force:
        if condition or position:
            if not click.confirm("WARNING: Updates to condition and position will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['condition'] = cli_util.parse_json_parameter("condition", condition)
    _details['action'] = action

    if inspection is not None:
        _details['inspection'] = inspection

    if position is not None:
        _details['position'] = cli_util.parse_json_parameter("position", position)

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_security_rule(
        network_firewall_policy_id=network_firewall_policy_id,
        security_rule_name=security_rule_name,
        update_security_rule_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@service_group.command(name=cli_util.override('network_firewall.update_service.command_name', 'update'), help=u"""Updates the Service with the given name in the network firewall policy. \n[Command Reference](updateService)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--service-name', required=True, help=u"""Unique identifier for Services.""")
@cli_util.option('--type', required=True, type=custom_types.CliCaseInsensitiveChoice(["TCP_SERVICE", "UDP_SERVICE"]), help=u"""Describes the type of Service.""")
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@json_skeleton_utils.get_cli_json_input_option({})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={}, output_type={'module': 'network_firewall', 'class': 'Service'})
@cli_util.wrap_exceptions
def update_service(ctx, from_json, network_firewall_policy_id, service_name, type, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(service_name, six.string_types) and len(service_name.strip()) == 0:
        raise click.UsageError('Parameter --service-name cannot be whitespace or empty string')

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['type'] = type

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_service(
        network_firewall_policy_id=network_firewall_policy_id,
        service_name=service_name,
        update_service_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@service_group.command(name=cli_util.override('network_firewall.update_service_update_tcp_service_details.command_name', 'update-service-update-tcp-service-details'), help=u"""Updates the Service with the given name in the network firewall policy. \n[Command Reference](updateService)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--service-name', required=True, help=u"""Unique identifier for Services.""")
@cli_util.option('--port-ranges', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of port-ranges to be used.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@json_skeleton_utils.get_cli_json_input_option({'port-ranges': {'module': 'network_firewall', 'class': 'list[PortRange]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'port-ranges': {'module': 'network_firewall', 'class': 'list[PortRange]'}}, output_type={'module': 'network_firewall', 'class': 'Service'})
@cli_util.wrap_exceptions
def update_service_update_tcp_service_details(ctx, from_json, force, network_firewall_policy_id, service_name, port_ranges, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(service_name, six.string_types) and len(service_name.strip()) == 0:
        raise click.UsageError('Parameter --service-name cannot be whitespace or empty string')
    if not force:
        if port_ranges:
            if not click.confirm("WARNING: Updates to port-ranges will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['portRanges'] = cli_util.parse_json_parameter("port_ranges", port_ranges)

    _details['type'] = 'TCP_SERVICE'

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_service(
        network_firewall_policy_id=network_firewall_policy_id,
        service_name=service_name,
        update_service_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@service_group.command(name=cli_util.override('network_firewall.update_service_update_udp_service_details.command_name', 'update-service-update-udp-service-details'), help=u"""Updates the Service with the given name in the network firewall policy. \n[Command Reference](updateService)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--service-name', required=True, help=u"""Unique identifier for Services.""")
@cli_util.option('--port-ranges', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of port-ranges to be used.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@json_skeleton_utils.get_cli_json_input_option({'port-ranges': {'module': 'network_firewall', 'class': 'list[PortRange]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'port-ranges': {'module': 'network_firewall', 'class': 'list[PortRange]'}}, output_type={'module': 'network_firewall', 'class': 'Service'})
@cli_util.wrap_exceptions
def update_service_update_udp_service_details(ctx, from_json, force, network_firewall_policy_id, service_name, port_ranges, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(service_name, six.string_types) and len(service_name.strip()) == 0:
        raise click.UsageError('Parameter --service-name cannot be whitespace or empty string')
    if not force:
        if port_ranges:
            if not click.confirm("WARNING: Updates to port-ranges will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['portRanges'] = cli_util.parse_json_parameter("port_ranges", port_ranges)

    _details['type'] = 'UDP_SERVICE'

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_service(
        network_firewall_policy_id=network_firewall_policy_id,
        service_name=service_name,
        update_service_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@service_list_group.command(name=cli_util.override('network_firewall.update_service_list.command_name', 'update'), help=u"""Updates the ServiceList with the given name in the network firewall policy. \n[Command Reference](updateServiceList)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--service-list-name', required=True, help=u"""Unique name identifier for Service Lists in the scope of Network Firewall Policy.""")
@cli_util.option('--services', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""Collection of service names.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@json_skeleton_utils.get_cli_json_input_option({'services': {'module': 'network_firewall', 'class': 'list[string]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'services': {'module': 'network_firewall', 'class': 'list[string]'}}, output_type={'module': 'network_firewall', 'class': 'ServiceList'})
@cli_util.wrap_exceptions
def update_service_list(ctx, from_json, force, network_firewall_policy_id, service_list_name, services, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(service_list_name, six.string_types) and len(service_list_name.strip()) == 0:
        raise click.UsageError('Parameter --service-list-name cannot be whitespace or empty string')
    if not force:
        if services:
            if not click.confirm("WARNING: Updates to services will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['services'] = cli_util.parse_json_parameter("services", services)

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_service_list(
        network_firewall_policy_id=network_firewall_policy_id,
        service_list_name=service_list_name,
        update_service_list_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)


@url_list_group.command(name=cli_util.override('network_firewall.update_url_list.command_name', 'update'), help=u"""Updates the Url list with the given name in the network firewall policy. \n[Command Reference](updateUrlList)""")
@cli_util.option('--network-firewall-policy-id', required=True, help=u"""Unique Network Firewall Policy identifier""")
@cli_util.option('--url-list-name', required=True, help=u"""Unique name identifier for url lists in the scope of Network Firewall Policy.""")
@cli_util.option('--urls', required=True, type=custom_types.CLI_COMPLEX_TYPE, help=u"""List of urls.""" + custom_types.cli_complex_type.COMPLEX_TYPE_HELP)
@cli_util.option('--if-match', help=u"""For optimistic concurrency control. In the PUT or DELETE call for a resource, set the `if-match` parameter to the value of the etag from a previous GET or POST response for that resource. The resource will be updated or deleted only if the etag you provide matches the resource's current etag value.""")
@cli_util.option('--force', help="""Perform update without prompting for confirmation.""", is_flag=True)
@json_skeleton_utils.get_cli_json_input_option({'urls': {'module': 'network_firewall', 'class': 'list[UrlPattern]'}})
@cli_util.help_option
@click.pass_context
@json_skeleton_utils.json_skeleton_generation_handler(input_params_to_complex_types={'urls': {'module': 'network_firewall', 'class': 'list[UrlPattern]'}}, output_type={'module': 'network_firewall', 'class': 'UrlList'})
@cli_util.wrap_exceptions
def update_url_list(ctx, from_json, force, network_firewall_policy_id, url_list_name, urls, if_match):

    if isinstance(network_firewall_policy_id, six.string_types) and len(network_firewall_policy_id.strip()) == 0:
        raise click.UsageError('Parameter --network-firewall-policy-id cannot be whitespace or empty string')

    if isinstance(url_list_name, six.string_types) and len(url_list_name.strip()) == 0:
        raise click.UsageError('Parameter --url-list-name cannot be whitespace or empty string')
    if not force:
        if urls:
            if not click.confirm("WARNING: Updates to urls will replace any existing values. Are you sure you want to continue?"):
                ctx.abort()

    kwargs = {}
    if if_match is not None:
        kwargs['if_match'] = if_match
    kwargs['opc_request_id'] = cli_util.use_or_generate_request_id(ctx.obj['request_id'])

    _details = {}
    _details['urls'] = cli_util.parse_json_parameter("urls", urls)

    client = cli_util.build_client('network_firewall', 'network_firewall', ctx)
    result = client.update_url_list(
        network_firewall_policy_id=network_firewall_policy_id,
        url_list_name=url_list_name,
        update_url_list_details=_details,
        **kwargs
    )
    cli_util.render_response(result, ctx)
