#pragma once

//openssl genpkey -algorithm DH -pkeyopt group:ffdhe3072 -text

typedef struct {
  Spec_FFDHE_ffdhe_alg alg;
  uint8_t *sk1;
  uint8_t *pk1;
  uint8_t *sk2;
  uint8_t *pk2;
  uint8_t *ss;
} ffdhe_test_vector;


static uint8_t test2048_sk1[256] = {
  0x52, 0xb0, 0x3e, 0xaf, 0x37, 0xb5, 0xf2, 0x08, 0x83, 0x7d, 0x1d, 0x90, 0x45, 0xe6, 0x0e, 0xed,
  0xe5, 0x2a, 0x9a, 0x75, 0x8b, 0x86, 0x38, 0x30, 0xdb, 0x57, 0x62, 0xe3, 0xfe, 0x69, 0xa8, 0x65,
  0x95, 0xd6, 0x99, 0x73, 0xff, 0x3e, 0x9f, 0x32, 0x54, 0xea, 0xe0, 0x1a, 0x73, 0xfb, 0x62, 0xa2,
  0x29, 0x24, 0xec, 0x18, 0xd0, 0xd1, 0xe9, 0x54, 0xd1, 0xd9, 0x66, 0xf1, 0x88, 0x07, 0xc8, 0x4e,
  0x84, 0x99, 0x94, 0xcb, 0xcb, 0x7f, 0x15, 0x20, 0xbc, 0xe4, 0x54, 0x4d, 0x94, 0x86, 0xc4, 0x94,
  0xf4, 0xfc, 0x51, 0xb3, 0xb7, 0x11, 0x86, 0x67, 0xa5, 0x59, 0x09, 0xf8, 0x2c, 0x4c, 0x17, 0xf3,
  0xe5, 0xc5, 0x30, 0x8d, 0x34, 0x39, 0x16, 0xe8, 0xba, 0x9f, 0x3a, 0xac, 0xb7, 0xbe, 0xed, 0x7e,
  0x77, 0x50, 0xab, 0xcc, 0xef, 0xee, 0x61, 0xb3, 0xb8, 0xb6, 0xd2, 0x55, 0xb6, 0xfa, 0xca, 0x16,
  0x08, 0x83, 0x21, 0xd2, 0x1c, 0x58, 0x8a, 0x8c, 0x2f, 0xa8, 0xde, 0x16, 0x68, 0x19, 0xb3, 0x32,
  0x84, 0xbb, 0x8a, 0x91, 0x7a, 0x1b, 0x29, 0xc8, 0xc9, 0x8b, 0xc7, 0xd3, 0x74, 0xe3, 0xef, 0xb6,
  0xa2, 0x63, 0x82, 0x4f, 0xba, 0x6c, 0x88, 0x5f, 0xb9, 0x1f, 0xb0, 0xd5, 0xee, 0xf1, 0x2a, 0x67,
  0x4e, 0xa8, 0x93, 0xae, 0x6a, 0x23, 0xe1, 0x57, 0x5f, 0xb9, 0x3b, 0x9f, 0xea, 0x48, 0x29, 0x35,
  0x23, 0x45, 0x92, 0x1a, 0x5b, 0x6d, 0x50, 0xb8, 0x25, 0x46, 0x58, 0xc8, 0x36, 0x3d, 0x9e, 0x4b,
  0xf5, 0x06, 0xfc, 0x51, 0x96, 0xd7, 0xbe, 0xb0, 0xa6, 0xe5, 0x77, 0x34, 0x85, 0x83, 0x8d, 0x27,
  0xff, 0xf5, 0x1f, 0x98, 0x1a, 0x8a, 0xe7, 0xc4, 0xfb, 0x23, 0x8e, 0x17, 0x1b, 0x3d, 0xe0, 0x1c,
  0x09, 0x49, 0x40, 0x09, 0xf6, 0xea, 0x78, 0x84, 0x3a, 0xdb, 0xb7, 0x6b, 0xe0, 0x80, 0x79, 0x48
};

static uint8_t test2048_pk1[256] = {
  0x42, 0x30, 0xa8, 0x5b, 0xbc, 0xcd, 0x6e, 0x38, 0x0c, 0xed, 0x97, 0x66, 0x4c, 0xee, 0x55, 0xe7,
  0x96, 0x24, 0x6b, 0xda, 0xe6, 0xa9, 0xed, 0x90, 0x03, 0x3c, 0x1c, 0xb2, 0xf7, 0xc7, 0x55, 0x92,
  0xad, 0x9a, 0x54, 0x1b, 0x2a, 0xd1, 0xd5, 0xc0, 0xd6, 0xb8, 0x6a, 0xc1, 0xfb, 0xb4, 0xcc, 0xe5,
  0x9f, 0xc0, 0xab, 0x51, 0x80, 0x2d, 0xac, 0x64, 0x8b, 0xe3, 0x3f, 0xd1, 0x61, 0xfb, 0x9f, 0x7f,
  0xcf, 0xe3, 0x3e, 0x24, 0x72, 0xac, 0x0a, 0x39, 0xe5, 0xfc, 0x4e, 0xbe, 0x98, 0x22, 0x39, 0x6e,
  0x47, 0x72, 0x31, 0xc8, 0xdd, 0x8d, 0x48, 0x41, 0xd8, 0xe0, 0xa0, 0xcc, 0xa9, 0x28, 0xa2, 0x9e,
  0x2a, 0xa9, 0x80, 0x00, 0xa3, 0xe3, 0xe5, 0xae, 0xa7, 0xc6, 0xb7, 0x24, 0x65, 0xbb, 0x1a, 0x25,
  0x44, 0xdc, 0xcb, 0x1a, 0xc1, 0x7c, 0xc4, 0x67, 0x51, 0xf1, 0x5c, 0x5f, 0xcd, 0x80, 0xe2, 0xd1,
  0x3f, 0x00, 0xa9, 0xa0, 0x0b, 0xcc, 0xe0, 0x0f, 0x19, 0xfa, 0x5e, 0xbf, 0x97, 0xbc, 0xdf, 0xb7,
  0x15, 0x21, 0x5a, 0xb9, 0x3a, 0xa4, 0x12, 0x96, 0x78, 0x76, 0xc3, 0xa9, 0x97, 0x9f, 0x54, 0x49,
  0xf0, 0x21, 0x0a, 0xa6, 0xd6, 0x8e, 0x3d, 0xed, 0x70, 0x75, 0xa9, 0xf3, 0xc3, 0xb8, 0x70, 0xf6,
  0xd5, 0x9a, 0x37, 0x92, 0xda, 0x45, 0xde, 0x95, 0xfd, 0x2c, 0xd6, 0x88, 0x8b, 0x8d, 0x60, 0x4f,
  0x52, 0x68, 0xd1, 0xb9, 0x03, 0xb6, 0x9a, 0x6f, 0xb3, 0x03, 0x3a, 0xe0, 0x30, 0x5f, 0x62, 0xde,
  0x65, 0xeb, 0x81, 0x0b, 0x26, 0xa8, 0xd0, 0xc9, 0x61, 0x3d, 0x1c, 0xb5, 0x0f, 0xdb, 0xdc, 0x63,
  0x9b, 0x13, 0x91, 0x12, 0x5c, 0x04, 0xc8, 0xd1, 0x65, 0x4a, 0x93, 0xd6, 0xad, 0x8e, 0x2a, 0xc7,
  0x21, 0xea, 0x23, 0x46, 0x2a, 0x7d, 0x00, 0x67, 0xc5, 0xf2, 0xc9, 0xd5, 0x0e, 0xfd, 0x33, 0x23
};

static uint8_t test2048_sk2[256] = {
  0x6e, 0x22, 0x9c, 0x40, 0x3d, 0x66, 0xc6, 0x84, 0xb9, 0xeb, 0xee, 0xf3, 0x25, 0x48, 0x5d, 0x72,
  0x8a, 0xef, 0xe5, 0x48, 0x7e, 0x9e, 0xb6, 0x40, 0xaa, 0x5d, 0xd7, 0x2b, 0x62, 0x3e, 0xae, 0x87,
  0x46, 0x0f, 0xf1, 0xb5, 0xa4, 0xda, 0xcc, 0x2b, 0x1d, 0x5d, 0x2f, 0xe4, 0x23, 0x35, 0x74, 0x55,
  0x4a, 0x7d, 0x93, 0x26, 0x71, 0x23, 0x6b, 0x75, 0x12, 0xcd, 0x14, 0x71, 0xea, 0x4b, 0x0d, 0x9f,
  0x61, 0xba, 0xe3, 0x3e, 0xcc, 0x57, 0x57, 0xe1, 0xff, 0x41, 0x04, 0x3b, 0x7f, 0xfa, 0x31, 0x07,
  0x09, 0x68, 0x6d, 0x47, 0x03, 0xda, 0x5c, 0x83, 0x75, 0x68, 0x4e, 0xcd, 0x98, 0x56, 0x38, 0x8d,
  0x2e, 0xad, 0x57, 0x25, 0xbc, 0x6b, 0x92, 0x7e, 0xac, 0xba, 0xb8, 0x0e, 0xa4, 0xaf, 0xcb, 0xdc,
  0x96, 0x12, 0x8b, 0x32, 0xaf, 0xd6, 0x7a, 0xe7, 0x58, 0xfd, 0x85, 0xae, 0x43, 0x42, 0x31, 0xc6,
  0x37, 0x54, 0x9b, 0xe1, 0x24, 0x94, 0x5e, 0xb9, 0x2d, 0xc1, 0xfe, 0x54, 0x28, 0xaa, 0x13, 0x85,
  0xf8, 0x38, 0x96, 0x91, 0xfc, 0xb5, 0xfe, 0x66, 0x8e, 0xe8, 0x5c, 0xd9, 0xe9, 0xf2, 0x1e, 0xb4,
  0x1d, 0xcc, 0x4f, 0xbd, 0x8a, 0x13, 0xaa, 0x91, 0x1b, 0xba, 0x2d, 0x5d, 0x19, 0xc4, 0x4e, 0x3c,
  0x6f, 0x51, 0x27, 0x2e, 0xd1, 0xbc, 0xe1, 0x88, 0x5e, 0x98, 0x23, 0x5b, 0x83, 0x6a, 0x0c, 0xce,
  0xe7, 0xbe, 0xb4, 0xd6, 0xc5, 0x7e, 0x3b, 0xe5, 0xfe, 0x77, 0xde, 0xab, 0xf1, 0xde, 0x88, 0x31,
  0x74, 0x64, 0xd8, 0xb0, 0xff, 0x44, 0xbf, 0x1b, 0x96, 0x83, 0xd5, 0xf2, 0x90, 0xab, 0x78, 0x55,
  0xec, 0x42, 0xc7, 0x74, 0xdf, 0x6d, 0x99, 0xd9, 0xf9, 0xe3, 0x02, 0x86, 0x84, 0x8c, 0x90, 0x3f,
  0xba, 0xad, 0x30, 0x4a, 0x4a, 0x1a, 0xae, 0xda, 0x45, 0xac, 0xb6, 0x71, 0xac, 0xe3, 0x38, 0x1e
};

static uint8_t test2048_pk2[256] = {
  0x51, 0xd7, 0x79, 0x06, 0x48, 0x98, 0x20, 0x0d, 0x58, 0xdc, 0x95, 0xd6, 0x31, 0x50, 0xc1, 0xdb,
  0xde, 0xc2, 0xe4, 0xb7, 0x93, 0xcf, 0xe7, 0xda, 0xb0, 0xcf, 0xf1, 0x15, 0xe5, 0x6a, 0xc3, 0xa7,
  0x73, 0x1d, 0x26, 0xa9, 0x32, 0x5f, 0x8c, 0x95, 0xe9, 0x31, 0x76, 0xfb, 0xe1, 0x28, 0x93, 0x4a,
  0xad, 0xc4, 0x6f, 0xf3, 0x59, 0x0b, 0x95, 0xb9, 0x56, 0xb7, 0x78, 0xd3, 0x18, 0x12, 0x17, 0x9a,
  0xf3, 0x0e, 0xc1, 0x8b, 0xec, 0x13, 0x92, 0x7c, 0xba, 0xd9, 0xf5, 0xa6, 0xbc, 0x22, 0x35, 0x13,
  0xfe, 0xaf, 0x33, 0x5d, 0x47, 0xfc, 0x5b, 0x29, 0x50, 0x91, 0x29, 0x5b, 0xc3, 0xd6, 0xb8, 0xaa,
  0xb3, 0x00, 0x67, 0x87, 0xd0, 0x5b, 0x66, 0x16, 0x0f, 0x68, 0x5c, 0xa6, 0x64, 0x83, 0x21, 0xcb,
  0x26, 0x87, 0xbc, 0x6f, 0x5b, 0x93, 0x6d, 0x90, 0xe3, 0x12, 0xd7, 0x89, 0xe5, 0xb3, 0x25, 0xc7,
  0xf7, 0x7e, 0x4a, 0x0c, 0x1e, 0xda, 0x6d, 0x26, 0x40, 0xa8, 0xa1, 0xdd, 0x90, 0xb2, 0x57, 0xa0,
  0xfe, 0x98, 0x4c, 0x47, 0xf0, 0xb2, 0x8d, 0xfc, 0xad, 0x00, 0xe5, 0x39, 0xb6, 0xdb, 0x95, 0xad,
  0xdb, 0xf2, 0x81, 0x28, 0x88, 0x38, 0x10, 0xbf, 0x8b, 0x42, 0x5e, 0xd9, 0x8e, 0x37, 0xb6, 0x9e,
  0x5a, 0xc6, 0x5d, 0x7a, 0x80, 0x16, 0x3e, 0x16, 0x4b, 0xa3, 0x77, 0x88, 0xfd, 0xf6, 0x65, 0x0b,
  0xcf, 0xe7, 0x83, 0x63, 0xa7, 0x0c, 0x99, 0x53, 0xd2, 0x14, 0x7d, 0x35, 0x58, 0x18, 0x2d, 0xf0,
  0x5a, 0x50, 0xac, 0x90, 0x68, 0x8a, 0x42, 0x47, 0x25, 0x89, 0x9b, 0x18, 0x79, 0x32, 0x45, 0x78,
  0x48, 0xc5, 0xef, 0x92, 0x04, 0xcf, 0x83, 0x37, 0x37, 0x17, 0x18, 0x4f, 0xfd, 0x7b, 0xd6, 0x02,
  0x81, 0x40, 0xe7, 0x8e, 0x8d, 0x17, 0x41, 0xfd, 0xc5, 0x0f, 0xaa, 0xee, 0x96, 0x06, 0x87, 0x3e
};

static uint8_t test2048_ss[256] = {
  0x41, 0xce, 0xe2, 0xf0, 0x29, 0x6b, 0x77, 0xf6, 0x49, 0xcd, 0xae, 0xbc, 0xc9, 0x0d, 0x76, 0xf0,
  0xdb, 0x18, 0xc2, 0x76, 0x01, 0xcb, 0xd6, 0x91, 0xc8, 0x60, 0xca, 0xcd, 0xc3, 0xb1, 0x14, 0x9b,
  0x55, 0xff, 0x4e, 0xf2, 0x43, 0x05, 0x81, 0x72, 0x6b, 0x47, 0xe3, 0xa5, 0xe4, 0xf1, 0x68, 0xb9,
  0xd1, 0x7e, 0x3a, 0xf4, 0x14, 0xcf, 0x97, 0x2d, 0xc9, 0x8e, 0x0f, 0x0f, 0x8d, 0xf4, 0x7e, 0x6a,
  0xe2, 0x80, 0x57, 0x52, 0x9a, 0x6e, 0x26, 0x04, 0x8c, 0xd9, 0x2f, 0x7e, 0xf1, 0x0b, 0xd0, 0x32,
  0x57, 0x73, 0xcd, 0xa7, 0x92, 0x11, 0x47, 0x80, 0x4a, 0x52, 0xa2, 0xde, 0x8e, 0x1c, 0xd0, 0x82,
  0xa6, 0x98, 0x8c, 0xd3, 0x2c, 0xd9, 0x11, 0x1e, 0xe9, 0x55, 0x2e, 0xb6, 0x21, 0xf1, 0x99, 0x45,
  0xa7, 0xf3, 0x26, 0x77, 0x11, 0xe5, 0xdd, 0x20, 0xca, 0x43, 0xd6, 0xf1, 0x23, 0x78, 0xb5, 0x56,
  0x86, 0x8b, 0x2d, 0x88, 0x60, 0xc5, 0x9e, 0xc7, 0x31, 0xd2, 0x9d, 0xdd, 0x1d, 0xa7, 0xea, 0x2a,
  0x59, 0x3c, 0x44, 0x03, 0xf1, 0xe0, 0x9b, 0x8c, 0x22, 0x35, 0x98, 0x30, 0x26, 0xba, 0x74, 0x83,
  0x88, 0x5b, 0x03, 0xfe, 0xec, 0x1e, 0x40, 0x31, 0xdb, 0xa9, 0x10, 0xd5, 0x1c, 0xb2, 0x03, 0xd3,
  0x14, 0x6f, 0x11, 0x2e, 0xa0, 0x09, 0xa9, 0xd2, 0x17, 0xf2, 0x6c, 0x84, 0xaf, 0x2f, 0xb8, 0x0d,
  0x7b, 0xd2, 0x35, 0x79, 0x29, 0xbc, 0x46, 0xed, 0x2a, 0x25, 0x6d, 0x62, 0x4e, 0xc8, 0x13, 0x91,
  0x3c, 0x06, 0x9e, 0x6c, 0x97, 0x9d, 0x88, 0x5c, 0x5a, 0xfd, 0x3a, 0xab, 0xb7, 0x92, 0x45, 0xe8,
  0xb9, 0x9b, 0x0c, 0x33, 0x25, 0x82, 0x86, 0xf1, 0x9f, 0x18, 0xdb, 0x61, 0x6a, 0x6f, 0xa3, 0xe8,
  0xba, 0x45, 0xab, 0xe5, 0x34, 0x72, 0x2e, 0x00, 0xad, 0x09, 0xae, 0x21, 0x17, 0x19, 0x06, 0x43
};

static uint8_t test3072_sk1[384] = {
  0x3b, 0x20, 0x95, 0x69, 0x62, 0xa0, 0x5d, 0xc2, 0xe3, 0x59, 0x26, 0x5d, 0x47, 0x89, 0x03, 0xfb,
  0xf5, 0x62, 0xd0, 0xbf, 0xda, 0x09, 0x9e, 0x9a, 0x8f, 0x17, 0xc9, 0xe5, 0xf2, 0x00, 0xfe, 0xcc,
  0x01, 0xab, 0x7a, 0x18, 0xeb, 0x91, 0xb5, 0x00, 0x58, 0x54, 0xe9, 0x69, 0xe7, 0xe4, 0xb3, 0x03,
  0x2f, 0xcb, 0x16, 0x10, 0x64, 0x03, 0x09, 0x94, 0xc7, 0xa6, 0x45, 0x9f, 0x55, 0x08, 0xdd, 0xce,
  0x44, 0xd1, 0x7f, 0x87, 0xe0, 0xd2, 0xd2, 0x81, 0xea, 0xc7, 0x31, 0x0e, 0xe2, 0xe4, 0x38, 0x71,
  0xda, 0x38, 0x18, 0x2f, 0x7a, 0xc9, 0xce, 0xe8, 0x97, 0x4e, 0x09, 0xf8, 0x0d, 0x58, 0x00, 0xbb,
  0x58, 0x46, 0x20, 0xb3, 0x30, 0x49, 0x20, 0x6b, 0x4f, 0x25, 0x59, 0xdf, 0x26, 0x4a, 0x61, 0x83,
  0xb8, 0x37, 0x18, 0x06, 0xb8, 0x5d, 0x77, 0xe3, 0x06, 0x56, 0x70, 0x09, 0x47, 0x67, 0x33, 0xdf,
  0x78, 0xf1, 0x65, 0x1f, 0x39, 0x0f, 0xb1, 0x21, 0x86, 0xb5, 0xdb, 0x72, 0x12, 0x5c, 0x09, 0x31,
  0x81, 0x34, 0x80, 0xe9, 0x25, 0x8c, 0xc8, 0x8c, 0xb4, 0x4a, 0x76, 0xfc, 0x90, 0x47, 0xeb, 0xae,
  0x55, 0x6c, 0x86, 0x6d, 0x2e, 0x9c, 0x44, 0x99, 0xc0, 0xbc, 0x0c, 0x67, 0x38, 0xc3, 0xc8, 0x96,
  0x11, 0xf1, 0x73, 0x3a, 0xe2, 0x03, 0x72, 0x01, 0x20, 0xdd, 0x4b, 0xe8, 0xf5, 0xca, 0xdd, 0x96,
  0x2c, 0xea, 0xeb, 0x85, 0x3e, 0x58, 0x45, 0x7e, 0x28, 0x38, 0x3f, 0x78, 0x24, 0x61, 0xcb, 0xc6,
  0x0b, 0xc7, 0x75, 0x62, 0x1e, 0x4b, 0xdf, 0xb4, 0x7a, 0x70, 0xb8, 0xd8, 0x67, 0xad, 0xa5, 0xea,
  0x31, 0x65, 0x3c, 0xb7, 0x9d, 0x76, 0x75, 0x85, 0x9b, 0x96, 0x21, 0x20, 0x51, 0x5c, 0x6d, 0xea,
  0x1e, 0x31, 0x30, 0xa4, 0x75, 0xf7, 0xec, 0x6b, 0x7b, 0xfc, 0xb8, 0xa5, 0x4f, 0x24, 0xda, 0x0d,
  0x45, 0x77, 0xe2, 0x91, 0xe8, 0xbc, 0xa7, 0xab, 0x04, 0x53, 0xce, 0xd0, 0x0b, 0x33, 0x55, 0x14,
  0x37, 0x19, 0x56, 0x07, 0x47, 0xf5, 0x6b, 0xd7, 0xb3, 0xf0, 0xb8, 0xe5, 0x96, 0xae, 0xe8, 0x64,
  0xeb, 0x00, 0x7e, 0x47, 0x63, 0x83, 0xb6, 0x22, 0xb2, 0x92, 0x6b, 0xc0, 0xb7, 0x4d, 0xf3, 0x19,
  0x14, 0x07, 0x86, 0x34, 0x79, 0xd5, 0x1a, 0x17, 0xa0, 0x3f, 0x10, 0x37, 0xd8, 0xc4, 0x1b, 0x31,
  0x76, 0xe4, 0xf1, 0x8d, 0x82, 0xea, 0x10, 0xae, 0xb9, 0x38, 0x0a, 0xe0, 0xa6, 0x08, 0xfa, 0xa3,
  0x63, 0x06, 0xa4, 0xe7, 0x19, 0xd9, 0xec, 0x7a, 0xd2, 0xdc, 0x77, 0x86, 0x22, 0x34, 0x6f, 0xf2,
  0xae, 0x6b, 0xfc, 0x4c, 0xd0, 0x9a, 0x7c, 0xfa, 0x27, 0x29, 0x3f, 0xb6, 0x7a, 0x89, 0x67, 0x73,
  0xf8, 0xc9, 0x72, 0xf4, 0xd7, 0x7b, 0x52, 0x9e, 0xd1, 0xe6, 0x10, 0xb9, 0xd8, 0xad, 0x1a, 0xf3
};

static uint8_t test3072_pk1[384] = {
  0xe1, 0xc4, 0xf7, 0x3b, 0x11, 0xda, 0x27, 0x92, 0xbd, 0x4b, 0x5d, 0x3b, 0xef, 0x66, 0xd6, 0x50,
  0xc6, 0x12, 0x4d, 0xb0, 0xf3, 0x8d, 0x32, 0x85, 0xaa, 0xec, 0x59, 0xbb, 0x97, 0x8f, 0xf6, 0x55,
  0x74, 0x77, 0x1c, 0xeb, 0xc2, 0x0a, 0x2b, 0xf4, 0x62, 0x57, 0x84, 0x98, 0x7d, 0xb0, 0xc6, 0xd9,
  0x3b, 0xc0, 0x6f, 0xb2, 0xfd, 0xbd, 0x39, 0x43, 0x1a, 0x5d, 0x6f, 0xaf, 0x0d, 0x43, 0x41, 0x5c,
  0x7c, 0x93, 0x2f, 0xff, 0xea, 0x03, 0x92, 0xa3, 0xf0, 0x4a, 0x18, 0x6c, 0xa3, 0x0d, 0x4f, 0x47,
  0x4a, 0x4d, 0x29, 0xfb, 0x42, 0xb2, 0xd3, 0xe0, 0x47, 0x0b, 0x9a, 0xf1, 0xf2, 0x0d, 0x10, 0xb5,
  0xba, 0x7e, 0x27, 0x1b, 0xa2, 0xdd, 0x33, 0xd5, 0xc9, 0x38, 0xa7, 0x90, 0x45, 0xf9, 0xa2, 0xc3,
  0x70, 0xf0, 0x65, 0xe1, 0x56, 0xc8, 0xed, 0x39, 0x29, 0x93, 0x06, 0x07, 0x92, 0xa1, 0x3e, 0x8e,
  0x74, 0x40, 0x57, 0xa7, 0xd0, 0x13, 0x4f, 0xbc, 0x7a, 0xfc, 0xf2, 0xbc, 0xc0, 0xdc, 0x9a, 0x04,
  0xa1, 0x89, 0xfe, 0x39, 0x94, 0xf6, 0x2e, 0x74, 0x37, 0x26, 0xde, 0xb9, 0x92, 0x7a, 0x61, 0xb9,
  0xc1, 0xdb, 0x4b, 0x21, 0x4f, 0xe3, 0x3c, 0xbb, 0x3b, 0x3c, 0x97, 0xcc, 0x71, 0x07, 0xea, 0x81,
  0xd1, 0xe1, 0x37, 0x27, 0x96, 0xed, 0x0b, 0xbd, 0xbd, 0xf9, 0x68, 0x86, 0x93, 0x87, 0xb0, 0xe5,
  0x01, 0xdd, 0xe0, 0x18, 0xb9, 0x28, 0x90, 0xd1, 0x74, 0x94, 0x06, 0xa8, 0x81, 0x34, 0x0e, 0x10,
  0xbc, 0x11, 0xcc, 0xbb, 0xe1, 0x68, 0x5a, 0x6c, 0x54, 0x91, 0x7c, 0xed, 0x3b, 0x58, 0x70, 0x02,
  0x6e, 0x3c, 0xb1, 0x79, 0x35, 0x8d, 0x3d, 0x95, 0x51, 0xa0, 0xb3, 0x22, 0xeb, 0x21, 0x6a, 0x70,
  0x98, 0xfc, 0x77, 0xf2, 0x99, 0xb0, 0xf7, 0x5d, 0xa3, 0x68, 0xb7, 0xa2, 0x3c, 0x04, 0x5d, 0x8f,
  0x13, 0x8e, 0x1d, 0x9f, 0x71, 0x5c, 0x1f, 0xe4, 0x22, 0x33, 0x0f, 0x64, 0xac, 0xbc, 0x83, 0x1e,
  0x3a, 0xf1, 0x48, 0x9f, 0xd5, 0x8a, 0xf2, 0xd9, 0x1e, 0xcc, 0x4c, 0x44, 0x62, 0xed, 0x40, 0xc8,
  0x05, 0x89, 0x63, 0x5d, 0xe1, 0xa5, 0x94, 0xbe, 0x14, 0xcd, 0x10, 0x38, 0x91, 0xfc, 0xa9, 0x4e,
  0xb1, 0xec, 0x23, 0x12, 0xf1, 0x87, 0x26, 0xf0, 0x4b, 0x0e, 0xfc, 0xe9, 0x7f, 0x99, 0xc2, 0xaf,
  0x22, 0xdc, 0x4a, 0x4d, 0x91, 0x2d, 0xd8, 0x93, 0x3f, 0x9b, 0x3d, 0x6b, 0xd4, 0x51, 0xbf, 0x3e,
  0x3c, 0x4a, 0x71, 0xca, 0xc1, 0xa6, 0x9e, 0x30, 0xdb, 0x6d, 0x4a, 0x44, 0x81, 0x8f, 0x2a, 0x19,
  0x25, 0x36, 0xca, 0x7a, 0xbb, 0x52, 0xb1, 0x38, 0xe1, 0x6d, 0xb5, 0x84, 0x40, 0x0f, 0x49, 0x67,
  0x8e, 0xff, 0xc5, 0xcb, 0xb2, 0xd6, 0xec, 0x66, 0x58, 0x57, 0xf3, 0xaf, 0xba, 0x0b, 0xf3, 0x09
};

static uint8_t test3072_sk2[384] = {
  0x0c, 0x0e, 0xb2, 0x60, 0xb9, 0x5a, 0xd9, 0x86, 0xf8, 0x95, 0xcd, 0x63, 0x72, 0x4a, 0x0f, 0x90,
  0x50, 0x6c, 0x4e, 0xe9, 0x49, 0xf4, 0x4e, 0x5c, 0x7c, 0xa8, 0x70, 0x6d, 0x2f, 0x84, 0xea, 0xa1,
  0x7a, 0x6b, 0xb6, 0x17, 0xef, 0xfb, 0xb5, 0xaf, 0x32, 0x0b, 0x53, 0x7b, 0x2d, 0x19, 0x48, 0xad,
  0xdd, 0x09, 0x76, 0x85, 0xa1, 0x25, 0x44, 0x94, 0x87, 0xf9, 0x87, 0xa7, 0x20, 0x2d, 0x2e, 0xa9,
  0xbc, 0x8c, 0xc5, 0x55, 0x9c, 0xc6, 0x43, 0xa7, 0x13, 0x1c, 0xc3, 0x78, 0x7a, 0x98, 0xce, 0x76,
  0xb3, 0x27, 0xc9, 0xdf, 0x03, 0x78, 0xa5, 0xaa, 0x85, 0x4b, 0x99, 0x29, 0x69, 0xc8, 0xe3, 0x2b,
  0x80, 0x80, 0xaa, 0x14, 0xc8, 0x5d, 0x39, 0x56, 0xb3, 0xc2, 0xeb, 0xb1, 0x2c, 0x4f, 0x5b, 0xd8,
  0xab, 0xb2, 0x96, 0xf1, 0xfc, 0x4b, 0x9c, 0xdc, 0x7f, 0x17, 0x05, 0x5f, 0x1f, 0x3c, 0xda, 0x79,
  0x2d, 0xe6, 0x76, 0x58, 0x6a, 0x98, 0x0f, 0x97, 0x9e, 0xcc, 0x5a, 0xda, 0x65, 0x9a, 0xc2, 0x2f,
  0x83, 0x27, 0xd3, 0x0c, 0x3c, 0xf2, 0x30, 0xfb, 0x02, 0xe5, 0xa5, 0x5c, 0x59, 0x37, 0x9f, 0xb6,
  0xcc, 0x22, 0xbe, 0xbf, 0x6f, 0x4c, 0x5b, 0x5d, 0x70, 0xe0, 0xeb, 0x3a, 0xca, 0x47, 0x00, 0x4b,
  0x4d, 0xf9, 0x67, 0xfb, 0x7f, 0x5e, 0x4e, 0x7c, 0x85, 0x11, 0xb3, 0xb8, 0xd5, 0x78, 0x92, 0x48,
  0x93, 0xa8, 0x2f, 0x0d, 0xca, 0x86, 0x18, 0xa2, 0x63, 0xee, 0x58, 0xac, 0xb2, 0xfc, 0xf8, 0xc6,
  0x7f, 0x0d, 0x23, 0x91, 0x0b, 0x93, 0x76, 0x10, 0xcd, 0x83, 0x99, 0x8e, 0xf9, 0x0c, 0xcd, 0x9e,
  0xc8, 0x4b, 0x87, 0xeb, 0x27, 0xf5, 0x5b, 0x19, 0x48, 0xe9, 0xe5, 0xc3, 0x47, 0x5b, 0x11, 0x2c,
  0xc4, 0x81, 0x11, 0x61, 0xe9, 0xd4, 0x2a, 0x0e, 0xae, 0x27, 0x8b, 0x39, 0xbb, 0x28, 0xda, 0xc3,
  0xd7, 0xed, 0x3c, 0xc7, 0xb8, 0x9a, 0xba, 0x7f, 0xd8, 0xd2, 0xca, 0x08, 0xca, 0xb2, 0xf5, 0x89,
  0x5e, 0xa7, 0x22, 0x69, 0x98, 0xdd, 0x61, 0xe4, 0x28, 0x55, 0x23, 0xfb, 0xf9, 0xbf, 0x5c, 0xd8,
  0xb8, 0x8a, 0xe2, 0xab, 0xba, 0x8b, 0xba, 0x0c, 0x08, 0x1a, 0x63, 0xce, 0x00, 0xff, 0x5c, 0x4b,
  0xd3, 0xe6, 0x8f, 0x31, 0xf8, 0x60, 0x64, 0xec, 0xf3, 0x8b, 0x76, 0x7c, 0xb5, 0x7c, 0xc3, 0x04,
  0xa6, 0x8b, 0xd6, 0x0b, 0xb8, 0x3c, 0x5a, 0x37, 0xb3, 0xb0, 0xeb, 0xe7, 0x83, 0x92, 0xfc, 0x66,
  0x71, 0x62, 0x44, 0x0d, 0xc5, 0x5e, 0x6d, 0xe9, 0x9e, 0x36, 0x2f, 0x83, 0xa7, 0xaa, 0xe8, 0x7d,
  0xe0, 0xbc, 0xf8, 0xfd, 0xb3, 0xfa, 0x1f, 0xfc, 0x25, 0xce, 0x7e, 0x04, 0x06, 0x06, 0x20, 0x48,
  0xeb, 0xe8, 0x13, 0x09, 0x1f, 0x7a, 0xe5, 0xda, 0x85, 0x20, 0x97, 0x79, 0xc1, 0x48, 0x6c, 0xbd
};

static uint8_t test3072_pk2[384] = {
  0x01, 0xf4, 0x29, 0x6b, 0x08, 0xd5, 0xb5, 0x15, 0x05, 0xed, 0xa0, 0x94, 0xb3, 0x1f, 0x09, 0x68,
  0xdd, 0x6b, 0x09, 0x0c, 0x47, 0xa3, 0x07, 0xbd, 0x27, 0x32, 0x2f, 0xa4, 0xd1, 0x91, 0xca, 0x99,
  0x0a, 0x5e, 0xa1, 0xb2, 0xcf, 0x1e, 0x16, 0xd2, 0xcf, 0x8f, 0x89, 0x2a, 0x93, 0x08, 0x93, 0x38,
  0xe7, 0xaf, 0x95, 0x4e, 0x2f, 0xe1, 0xbc, 0x17, 0xb4, 0xb0, 0x43, 0x52, 0x2a, 0x8f, 0x5c, 0xc5,
  0xa9, 0x15, 0x49, 0xf4, 0x8b, 0xaf, 0xa6, 0x69, 0x8e, 0xe0, 0x71, 0x61, 0x63, 0xc5, 0xa0, 0x65,
  0x7b, 0x36, 0x1d, 0x7f, 0xf1, 0x57, 0x53, 0x89, 0xa1, 0xcd, 0x53, 0xb5, 0x41, 0xa4, 0x31, 0x80,
  0x9a, 0xf3, 0x2b, 0xb9, 0xad, 0xf1, 0xbf, 0x48, 0x93, 0xfc, 0x6e, 0x9a, 0xf3, 0x0b, 0x35, 0x17,
  0x6a, 0x06, 0xc9, 0xa5, 0xaa, 0x05, 0xe8, 0x01, 0x7d, 0x87, 0x9e, 0xaa, 0x6e, 0xb9, 0x50, 0xe1,
  0xcb, 0x40, 0x38, 0x62, 0x96, 0x45, 0x2f, 0x7a, 0xb1, 0xab, 0x26, 0xa8, 0x7d, 0xf1, 0x6a, 0x12,
  0x8b, 0x82, 0x07, 0x1e, 0x93, 0x28, 0xce, 0xd3, 0x77, 0x48, 0xa4, 0xb9, 0x34, 0x63, 0x93, 0x67,
  0xda, 0x92, 0x6e, 0xae, 0x30, 0x55, 0xbc, 0xc7, 0xa6, 0x98, 0xa7, 0x9d, 0x46, 0xf0, 0x75, 0x8c,
  0x8b, 0x6b, 0x08, 0x9d, 0xd0, 0x00, 0x17, 0x62, 0x7c, 0xef, 0x28, 0x34, 0xf4, 0x4e, 0xcf, 0xc6,
  0x27, 0x91, 0x3f, 0xff, 0xd8, 0xdf, 0x40, 0x83, 0xba, 0x8d, 0xd8, 0x00, 0x38, 0xc5, 0x18, 0x54,
  0x70, 0xa0, 0x49, 0x62, 0xf6, 0xf6, 0x75, 0x49, 0xfb, 0x31, 0x9a, 0x7a, 0xab, 0x32, 0xc5, 0x1c,
  0x7f, 0x9c, 0x4a, 0xbc, 0xc3, 0x8d, 0x5c, 0x9e, 0x7e, 0xc9, 0xa0, 0x99, 0xa8, 0x61, 0xe2, 0x65,
  0x08, 0xae, 0x30, 0x76, 0xcc, 0x5d, 0x52, 0x18, 0x3a, 0x8b, 0x1a, 0x27, 0x5e, 0x50, 0x09, 0xbb,
  0x0b, 0xfb, 0x15, 0xd5, 0x45, 0x8c, 0x27, 0xcb, 0xe4, 0x8e, 0x6d, 0x90, 0x3a, 0x5d, 0x72, 0x6f,
  0x94, 0xe6, 0xcc, 0xb4, 0xfd, 0xb0, 0xf1, 0xad, 0xc2, 0x65, 0x3a, 0xfe, 0xa6, 0xb0, 0xcf, 0xce,
  0xd9, 0x88, 0x82, 0xb9, 0xb9, 0xea, 0x3c, 0xc3, 0x8d, 0x08, 0xbc, 0xbf, 0x49, 0x77, 0xb0, 0x75,
  0xbf, 0x0c, 0x46, 0xd4, 0x11, 0xcf, 0xaf, 0x31, 0x3b, 0x1a, 0xb3, 0x80, 0x89, 0x45, 0xc6, 0xc6,
  0x6f, 0x63, 0xd3, 0xf1, 0x7d, 0x8e, 0x59, 0x13, 0xc4, 0xda, 0x1a, 0xb5, 0x6d, 0x8e, 0x99, 0x88,
  0x30, 0xf9, 0x3f, 0xae, 0x26, 0x68, 0xd2, 0x5c, 0x95, 0x9a, 0x37, 0xbd, 0x6d, 0x07, 0xd8, 0x9a,
  0x90, 0x66, 0x25, 0x7f, 0x8d, 0x5a, 0x70, 0x1a, 0x25, 0xc7, 0xa2, 0xa1, 0x98, 0x06, 0x31, 0x77,
  0xcc, 0x44, 0xb6, 0xc2, 0x43, 0x4e, 0xec, 0xf7, 0xf6, 0x06, 0xaa, 0xcf, 0x79, 0x70, 0x63, 0x1a
};

static uint8_t test3072_ss[384] = {
  0x71, 0x20, 0xbc, 0x1c, 0x66, 0xf2, 0xa4, 0xc8, 0x4c, 0xa4, 0x2e, 0xde, 0x34, 0x10, 0x39, 0x91,
  0x2a, 0x00, 0x4b, 0x4a, 0x91, 0x4c, 0x52, 0xf4, 0x55, 0xfe, 0x67, 0x80, 0xbd, 0xd9, 0xa3, 0xf7,
  0xfe, 0x3f, 0xbf, 0x99, 0x4e, 0x54, 0x22, 0x05, 0x94, 0xcf, 0x09, 0xa7, 0x41, 0x59, 0x02, 0x99,
  0x99, 0xc1, 0x24, 0x8a, 0xcb, 0xfd, 0xe5, 0x74, 0x8a, 0xac, 0x41, 0x7f, 0x80, 0x60, 0xa6, 0x8a,
  0xb5, 0xd1, 0x71, 0xe9, 0x83, 0x13, 0x14, 0xb1, 0x7e, 0xe1, 0xf7, 0xb3, 0xe9, 0x4e, 0xad, 0x11,
  0x4d, 0xf7, 0x57, 0xac, 0x74, 0x7a, 0xc3, 0x12, 0xc8, 0xbf, 0xc7, 0xd8, 0x91, 0x59, 0xa0, 0xc6,
  0x27, 0xa6, 0x00, 0x1b, 0x9b, 0xb4, 0xe5, 0x41, 0xe9, 0x4b, 0x62, 0x1c, 0x76, 0xfd, 0x44, 0x46,
  0x51, 0xd8, 0x2d, 0xc4, 0x0b, 0xc3, 0x7d, 0x79, 0xcc, 0x04, 0x89, 0x27, 0x31, 0x54, 0x67, 0x8d,
  0x58, 0x81, 0xea, 0x6b, 0xf1, 0x30, 0xbc, 0xea, 0x19, 0xa2, 0xd8, 0xc8, 0x19, 0x17, 0xc7, 0xe3,
  0xbe, 0xcc, 0x29, 0xbf, 0x09, 0xa0, 0x08, 0x77, 0xe4, 0x3e, 0x42, 0x03, 0x4c, 0x40, 0xb9, 0xeb,
  0x83, 0x54, 0x91, 0x4d, 0xd3, 0xad, 0xdf, 0x7f, 0xa0, 0x4a, 0x9e, 0xb9, 0xa3, 0x41, 0x0f, 0x65,
  0x83, 0x95, 0x87, 0x20, 0x79, 0x69, 0x4b, 0xe2, 0x0e, 0xef, 0x5c, 0x90, 0x3c, 0x1d, 0xb1, 0xb8,
  0xc8, 0x08, 0xa9, 0xa2, 0xca, 0x1e, 0x11, 0xe7, 0xde, 0x8a, 0x5f, 0x6d, 0x6a, 0x6c, 0x4b, 0x60,
  0xf4, 0x90, 0xb3, 0xcf, 0x33, 0xb8, 0xb9, 0xd1, 0x5f, 0xda, 0x5c, 0xf0, 0x9a, 0x27, 0xdf, 0x04,
  0x96, 0x29, 0x35, 0xcf, 0x2e, 0x6f, 0x13, 0x1e, 0xa7, 0x2e, 0xb6, 0x88, 0x26, 0x87, 0xcb, 0xb4,
  0xec, 0x3b, 0xe6, 0x77, 0xd7, 0x1b, 0xbd, 0xa1, 0x63, 0xeb, 0x71, 0x7b, 0xe5, 0xfd, 0x69, 0x93,
  0x3c, 0x62, 0x70, 0x8b, 0x1b, 0xab, 0xed, 0x9a, 0x7d, 0xbf, 0x75, 0x99, 0xcc, 0x0e, 0xf1, 0xb5,
  0x58, 0x1a, 0xc3, 0x8b, 0x7f, 0xaf, 0x6b, 0xca, 0x10, 0x79, 0x4c, 0x27, 0x53, 0xeb, 0x6d, 0x6f,
  0xa3, 0xf7, 0x8f, 0xa5, 0x32, 0x55, 0x80, 0x31, 0x44, 0x6a, 0xce, 0xa1, 0x9d, 0x8e, 0x00, 0x1e,
  0x2a, 0xe9, 0x6f, 0x8d, 0x84, 0x25, 0x2e, 0xd0, 0xaf, 0x78, 0xbb, 0x2f, 0xb3, 0xdd, 0x70, 0xbf,
  0xf7, 0xf0, 0x13, 0x19, 0xf1, 0x4b, 0xa9, 0xc5, 0xa9, 0x4c, 0x36, 0x77, 0xc6, 0xd5, 0x74, 0xca,
  0x0c, 0xba, 0x61, 0xa4, 0xcf, 0xcc, 0x86, 0xbd, 0xf3, 0x13, 0xe2, 0x2b, 0x4a, 0x59, 0x8a, 0xd2,
  0xa5, 0xd3, 0x76, 0x7a, 0xff, 0x3b, 0xdb, 0x10, 0xff, 0x00, 0x90, 0x29, 0xaa, 0x36, 0xc3, 0x1e,
  0xa4, 0xf7, 0x2b, 0xcc, 0xfb, 0xeb, 0x84, 0x2d, 0xe5, 0xf6, 0xaf, 0xc2, 0x66, 0x0c, 0xbc, 0x5a
};


static uint8_t test4096_sk1[512] = {
  0x35, 0xd8, 0x81, 0xc4, 0xcb, 0xe1, 0xaf, 0x8a, 0x7c, 0x84, 0x1c, 0x7b, 0xc5, 0xeb, 0x9d, 0x88,
  0x4b, 0xb8, 0x31, 0x69, 0xe1, 0x62, 0x5a, 0x3b, 0xef, 0xf0, 0x90, 0x86, 0x42, 0x18, 0x0d, 0x55,
  0x9f, 0x93, 0x03, 0xf2, 0x8c, 0xb5, 0x8b, 0x08, 0x8b, 0xb6, 0x6e, 0x03, 0x68, 0xc8, 0xc7, 0xe9,
  0x96, 0xdd, 0x72, 0x75, 0x10, 0x6d, 0x0e, 0xc4, 0x79, 0x4f, 0x35, 0xb8, 0x8e, 0x7b, 0xd0, 0x36,
  0x90, 0xfa, 0x98, 0x74, 0xd7, 0x5c, 0xc6, 0xef, 0x93, 0x2a, 0x6f, 0x99, 0x66, 0x15, 0xf0, 0xde,
  0x97, 0x15, 0xd4, 0x4b, 0xd2, 0xca, 0x59, 0xb2, 0x96, 0xc2, 0x01, 0x39, 0x51, 0x36, 0xa4, 0x44,
  0xba, 0xcd, 0x79, 0x42, 0x9b, 0x1c, 0x56, 0x3c, 0x78, 0x04, 0x8d, 0x6e, 0xfa, 0xbc, 0x79, 0xb6,
  0x35, 0xb9, 0x8d, 0x43, 0xda, 0xc4, 0x84, 0x2e, 0x5c, 0x93, 0xde, 0xe8, 0xb5, 0xa6, 0xa0, 0x48,
  0xd7, 0x1e, 0x01, 0x84, 0x95, 0xc1, 0x84, 0x9e, 0x43, 0xd6, 0x9f, 0xc0, 0xfe, 0x2c, 0x58, 0xce,
  0xca, 0x50, 0x70, 0x9c, 0xad, 0x3d, 0x95, 0x8a, 0x23, 0xa4, 0x95, 0xce, 0x09, 0xc1, 0xe9, 0xe0,
  0x96, 0xb4, 0xa0, 0x1d, 0x62, 0xdd, 0x64, 0xa7, 0x5b, 0x3e, 0xb3, 0xf6, 0x6e, 0xe9, 0xe2, 0xa2,
  0x0e, 0xef, 0xef, 0xbd, 0x39, 0x21, 0x0e, 0xf3, 0x37, 0xba, 0x9e, 0x23, 0x7c, 0x94, 0x46, 0xdf,
  0x7b, 0xef, 0x8e, 0xf5, 0xfa, 0xcb, 0xf8, 0xb0, 0xa0, 0xdc, 0x07, 0x7e, 0xd3, 0x3c, 0x7d, 0xab,
  0x09, 0x5e, 0x72, 0xd5, 0xe7, 0xf3, 0xfe, 0x34, 0x5a, 0xe7, 0x5e, 0x12, 0xa4, 0x08, 0x4c, 0xe7,
  0x80, 0xdd, 0xe6, 0xec, 0xdc, 0x51, 0x52, 0xb2, 0xf0, 0xeb, 0x80, 0xa2, 0x1c, 0x33, 0xb3, 0xd6,
  0x60, 0x22, 0x45, 0xe2, 0x1b, 0xd3, 0x4f, 0x0e, 0x92, 0x54, 0x60, 0xb0, 0x89, 0xb1, 0xa9, 0xf3,
  0x55, 0x83, 0x3e, 0xa8, 0x6a, 0x2c, 0xe9, 0x00, 0xb5, 0xa6, 0x94, 0x80, 0x36, 0x0f, 0x5b, 0xc9,
  0x30, 0x41, 0xff, 0xfd, 0xcc, 0x12, 0xe6, 0x67, 0x47, 0x20, 0x7d, 0xed, 0xfe, 0xbe, 0x37, 0x03,
  0x4b, 0x69, 0x3b, 0xd9, 0x6d, 0xd0, 0xe4, 0x8e, 0x61, 0xfd, 0xb1, 0x3e, 0xae, 0x66, 0x0d, 0x9e,
  0x21, 0x62, 0xb8, 0xd6, 0xea, 0xc6, 0x86, 0xd1, 0x05, 0x94, 0x60, 0xd0, 0x9f, 0xf8, 0x1e, 0x17,
  0xd5, 0x6f, 0x8c, 0xc9, 0xc5, 0x92, 0xcd, 0x56, 0x87, 0xbc, 0x9e, 0xe9, 0xda, 0x96, 0x2f, 0x7f,
  0xf5, 0x91, 0x57, 0xf2, 0x2d, 0x56, 0x6b, 0x5d, 0x6c, 0x10, 0x91, 0x4e, 0xd2, 0x71, 0x08, 0x85,
  0x90, 0x2b, 0x0f, 0x5b, 0x39, 0xad, 0xd5, 0xcd, 0xab, 0x36, 0x98, 0x60, 0xf8, 0xdc, 0xcb, 0xd8,
  0xab, 0xa3, 0xa6, 0xca, 0x33, 0xcf, 0x9e, 0x6c, 0x49, 0x73, 0x51, 0x19, 0xbe, 0xcb, 0x27, 0xb0,
  0x72, 0xaa, 0x7a, 0x9c, 0x9b, 0xe7, 0x98, 0x0b, 0x65, 0xf9, 0x0d, 0x9c, 0xa6, 0xa5, 0x42, 0x5d,
  0x79, 0xe2, 0x7b, 0x7f, 0x42, 0x11, 0xfc, 0xdb, 0x9f, 0x89, 0xf8, 0x88, 0x34, 0x97, 0x3e, 0x40,
  0xf7, 0x63, 0x36, 0x18, 0xd0, 0x9b, 0x8b, 0x43, 0x43, 0x79, 0x83, 0x0f, 0x96, 0xe7, 0x5b, 0xf5,
  0x1c, 0x92, 0x03, 0x29, 0x6d, 0xeb, 0x38, 0xb2, 0xa0, 0x56, 0x29, 0xf4, 0x59, 0xcf, 0xb4, 0x1e,
  0xaf, 0xfc, 0xac, 0x2d, 0x0c, 0x0b, 0xbe, 0x03, 0x99, 0xfc, 0x6b, 0xa8, 0x65, 0x96, 0x96, 0x27,
  0xcc, 0xdb, 0xb5, 0x41, 0x9a, 0x1c, 0x3e, 0x18, 0xca, 0xbb, 0x29, 0x76, 0xab, 0x57, 0x11, 0x3f,
  0x5a, 0x92, 0xc9, 0x8e, 0x03, 0x35, 0x1a, 0xe9, 0x78, 0x8f, 0xd2, 0x0e, 0x4e, 0x7d, 0xc8, 0x32,
  0xc5, 0xa8, 0x13, 0xe3, 0x1b, 0x76, 0x1d, 0xea, 0xd7, 0xb7, 0x73, 0x3d, 0xa9, 0x47, 0x6f, 0xad
};

static uint8_t test4096_pk1[512] = {
  0x76, 0x35, 0x79, 0x94, 0x15, 0x2e, 0xc3, 0x26, 0x78, 0x48, 0x89, 0x50, 0xbb, 0xf7, 0x7f, 0x90,
  0x50, 0x75, 0xcd, 0xbd, 0x4f, 0xf2, 0xab, 0xcb, 0xc4, 0x84, 0x7d, 0xd1, 0x28, 0x4d, 0xa5, 0x1c,
  0x86, 0xe0, 0xdc, 0x15, 0x0a, 0x2f, 0xeb, 0x26, 0x6b, 0x4d, 0xe5, 0x7e, 0x7c, 0xf2, 0x6e, 0x39,
  0x10, 0xb7, 0x1e, 0xcf, 0xc7, 0xfb, 0xb7, 0xeb, 0x50, 0x8b, 0xd4, 0x6d, 0x5b, 0x90, 0x94, 0x66,
  0xed, 0x61, 0x11, 0x01, 0xf2, 0xd4, 0xc5, 0xa5, 0x2c, 0xe0, 0xc9, 0xab, 0xd0, 0x63, 0x2a, 0x07,
  0x09, 0x5b, 0x6a, 0xc3, 0x2e, 0xfe, 0x22, 0xc0, 0xb7, 0x34, 0x74, 0xef, 0x5d, 0x1e, 0xca, 0x0b,
  0xe1, 0x22, 0x5b, 0xcb, 0x85, 0x61, 0x9f, 0xd5, 0x2e, 0x3d, 0xec, 0x64, 0x62, 0x74, 0x1b, 0xc6,
  0xb8, 0x15, 0x86, 0x58, 0x59, 0xca, 0x9d, 0x9a, 0xc5, 0x9a, 0xd8, 0x76, 0x9b, 0xd5, 0xbc, 0xe0,
  0x39, 0x73, 0x15, 0x8d, 0x6d, 0x95, 0x27, 0x85, 0xcf, 0xc2, 0xb6, 0x1c, 0xa3, 0xbb, 0xfa, 0xdf,
  0x2a, 0xbc, 0x0d, 0x79, 0x86, 0x22, 0x26, 0xbc, 0x18, 0x13, 0xda, 0xd6, 0x71, 0xda, 0x7b, 0x7f,
  0xd0, 0x43, 0xf7, 0xab, 0xa6, 0x21, 0xeb, 0xcf, 0x56, 0xc1, 0x17, 0xfa, 0xdc, 0x7f, 0xd8, 0xbf,
  0x04, 0xf4, 0xec, 0x5e, 0x09, 0x78, 0x7f, 0x7e, 0x1f, 0xe0, 0x99, 0x89, 0x5d, 0xc7, 0x2b, 0x7b,
  0xfe, 0x59, 0x86, 0xc6, 0xc6, 0xba, 0xb9, 0x16, 0xbc, 0x1d, 0xa1, 0x5f, 0x28, 0xd6, 0x07, 0x1c,
  0xbf, 0x23, 0xc0, 0xa4, 0x32, 0xeb, 0x0b, 0x9f, 0xc4, 0x30, 0x55, 0xc9, 0x1e, 0xa7, 0x89, 0x52,
  0x18, 0x83, 0x8d, 0xa3, 0x15, 0x7e, 0x2a, 0x4c, 0x2c, 0xd9, 0xc8, 0x2b, 0x4d, 0xfe, 0xd1, 0xb4,
  0xd6, 0x93, 0x68, 0x0a, 0xc7, 0x7f, 0xa9, 0x43, 0x64, 0x11, 0xcc, 0x6f, 0x1d, 0xc4, 0x47, 0xb9,
  0x70, 0xa1, 0x0b, 0x5a, 0x6c, 0xef, 0xbe, 0x86, 0x13, 0x12, 0xea, 0xfc, 0xea, 0x84, 0x9d, 0xb8,
  0x7a, 0xf3, 0x60, 0xe2, 0xd9, 0x30, 0x27, 0x17, 0x3c, 0xb9, 0x29, 0x5c, 0x4d, 0x04, 0x2b, 0xc3,
  0xdb, 0x03, 0x50, 0xb2, 0xe4, 0x9a, 0x68, 0xe4, 0x19, 0x67, 0x99, 0x79, 0xd5, 0x0f, 0x28, 0x61,
  0xf2, 0xd3, 0xe9, 0xdb, 0x61, 0xeb, 0x1a, 0xe1, 0x00, 0x8b, 0x20, 0xa7, 0x1c, 0x30, 0xd8, 0xeb,
  0xc3, 0x7e, 0x32, 0x5f, 0xcb, 0xd4, 0x28, 0x73, 0xf9, 0xd8, 0xe4, 0x11, 0x1f, 0xc1, 0x74, 0x9c,
  0x90, 0xdc, 0xd3, 0x28, 0xff, 0x52, 0xa4, 0x86, 0xcd, 0xa7, 0xa6, 0x30, 0xc3, 0x7e, 0xa4, 0x26,
  0x29, 0xab, 0xc1, 0x1c, 0xd6, 0xf2, 0x8c, 0xf5, 0x73, 0x19, 0x60, 0x56, 0xa8, 0x6d, 0x02, 0x00,
  0x4c, 0x8d, 0xfa, 0xb4, 0x40, 0x84, 0x14, 0x43, 0xa5, 0x1c, 0xe9, 0x29, 0x26, 0x82, 0x29, 0x3b,
  0x4f, 0xac, 0x08, 0x50, 0x4b, 0x95, 0x57, 0x0d, 0x04, 0x91, 0x94, 0x19, 0x16, 0x5c, 0xb5, 0xd3,
  0x29, 0x31, 0xaa, 0x0f, 0x9b, 0x57, 0x87, 0xa3, 0x10, 0x25, 0x0d, 0x9c, 0xd9, 0x81, 0xbf, 0x31,
  0xb6, 0x77, 0x1c, 0x10, 0xab, 0xd2, 0xee, 0x4f, 0x30, 0xa9, 0xef, 0x58, 0x8c, 0x47, 0x7f, 0xa3,
  0xef, 0xd6, 0xc4, 0xda, 0x54, 0x57, 0x6e, 0xb9, 0x86, 0xd3, 0x15, 0x98, 0x32, 0x4d, 0xc4, 0x87,
  0x0b, 0x3c, 0xf8, 0x2f, 0xac, 0xc5, 0x62, 0x05, 0xe8, 0x5f, 0x60, 0x89, 0x46, 0x41, 0x0b, 0x41,
  0x14, 0x9d, 0x4c, 0x10, 0x38, 0x45, 0x69, 0x75, 0x66, 0xfc, 0x3b, 0x63, 0x58, 0xe2, 0x9a, 0x41,
  0xe3, 0xa2, 0xf9, 0x94, 0x13, 0x77, 0xbe, 0xd3, 0x86, 0xc0, 0xbc, 0x11, 0x15, 0x26, 0x84, 0x27,
  0x98, 0x77, 0x99, 0xf0, 0xc5, 0x91, 0x36, 0x5c, 0xea, 0xa5, 0xaa, 0x86, 0xe0, 0x70, 0x1f, 0x6e
};

static uint8_t test4096_sk2[512] = {
  0x49, 0x3a, 0xf7, 0xc4, 0x14, 0x9f, 0x09, 0xbd, 0x5c, 0xd8, 0xd2, 0x4b, 0x73, 0x55, 0xe9, 0xea,
  0x46, 0xd7, 0x96, 0xd1, 0xe0, 0xcb, 0x61, 0xd2, 0x59, 0x4d, 0xf4, 0xd1, 0xea, 0x5e, 0xed, 0xb0,
  0x29, 0x54, 0x10, 0x28, 0xce, 0x14, 0x5e, 0x7c, 0x7f, 0x8d, 0x27, 0xa7, 0x2d, 0xbb, 0x0f, 0xfb,
  0x6f, 0x11, 0xf7, 0x6e, 0x32, 0x34, 0xdd, 0xcf, 0x5d, 0x31, 0x0c, 0x53, 0x46, 0x72, 0x16, 0x9e,
  0x46, 0x55, 0x98, 0xd8, 0x14, 0x41, 0x71, 0xda, 0x5c, 0xdf, 0xd4, 0xfc, 0x08, 0xd7, 0x29, 0x2f,
  0xc0, 0x56, 0x6c, 0x1e, 0x6c, 0x02, 0x7a, 0xb8, 0xf0, 0x48, 0x04, 0xcd, 0xad, 0x35, 0x1d, 0xe0,
  0x8c, 0x6e, 0x97, 0xc1, 0xed, 0xb0, 0xb3, 0xbe, 0xc2, 0x19, 0x2b, 0x08, 0x68, 0x17, 0xe8, 0x7c,
  0xa1, 0x1f, 0xd2, 0xe3, 0x93, 0x10, 0x3b, 0x49, 0x8e, 0x90, 0x38, 0x37, 0xa1, 0x09, 0x69, 0xc9,
  0x60, 0xc4, 0xac, 0x71, 0xc6, 0x01, 0x13, 0xc8, 0xd0, 0xd4, 0xd3, 0xa8, 0x02, 0xe0, 0x7e, 0x1a,
  0xcd, 0x76, 0x39, 0xd5, 0x30, 0x55, 0x79, 0x4e, 0x96, 0x3f, 0x4a, 0xd1, 0x85, 0xc3, 0x42, 0x23,
  0xed, 0x9f, 0x07, 0x14, 0x63, 0x37, 0xb7, 0x0b, 0xc4, 0x5b, 0x17, 0x43, 0xe4, 0x82, 0x99, 0xe2,
  0xee, 0xb9, 0x11, 0x28, 0xc3, 0x12, 0x83, 0x94, 0x68, 0x46, 0xce, 0x96, 0x82, 0x5e, 0x53, 0x6c,
  0xae, 0x97, 0x83, 0x20, 0xb9, 0x91, 0xfe, 0xd2, 0xa6, 0x46, 0xef, 0x9f, 0xa1, 0x24, 0xb5, 0xe2,
  0x10, 0x17, 0x28, 0x5f, 0x64, 0xd9, 0x99, 0x3f, 0x58, 0xdf, 0xaf, 0x5a, 0xa8, 0xea, 0xdb, 0x95,
  0x3e, 0x5f, 0x47, 0x6a, 0xce, 0xd2, 0xa6, 0xa8, 0x90, 0x15, 0xb7, 0x67, 0xb6, 0x83, 0x7e, 0xe4,
  0xaf, 0x4f, 0x02, 0x35, 0xfb, 0x4e, 0xb7, 0x23, 0x46, 0x02, 0x4f, 0x72, 0xd9, 0x99, 0xb1, 0xf5,
  0x68, 0x4a, 0xcc, 0x4d, 0xa6, 0x0b, 0x57, 0x71, 0xc3, 0x2f, 0x35, 0xf6, 0x76, 0x3e, 0x3d, 0x55,
  0xcd, 0x6d, 0xaa, 0xfb, 0x38, 0x88, 0xd5, 0x1a, 0x25, 0xc9, 0xd3, 0x89, 0x8a, 0x91, 0xd5, 0xa6,
  0xe2, 0x5a, 0xe8, 0x9b, 0x65, 0x3b, 0x77, 0x27, 0xd7, 0x49, 0x48, 0x1e, 0x11, 0x69, 0x26, 0xe0,
  0xbe, 0x47, 0xf9, 0xe9, 0x66, 0xb5, 0xa7, 0x5a, 0x87, 0x8b, 0xe8, 0xb6, 0xe3, 0x2f, 0xb4, 0xef,
  0xe8, 0x32, 0x97, 0x89, 0xc6, 0x2d, 0x58, 0xe8, 0xa0, 0xd7, 0x4e, 0x35, 0xda, 0x0c, 0xed, 0xac,
  0x93, 0x70, 0x0f, 0xd4, 0xb8, 0xb9, 0x43, 0xb1, 0x15, 0xf9, 0xfd, 0x85, 0x7e, 0x03, 0x3c, 0x35,
  0xf1, 0x50, 0xc0, 0x7b, 0xd6, 0x15, 0xb4, 0x0d, 0x3d, 0xf0, 0x38, 0x1e, 0x80, 0x5a, 0x15, 0xde,
  0x0f, 0x5e, 0xbd, 0x3c, 0x7d, 0xfd, 0xda, 0xca, 0xcf, 0xc6, 0x92, 0x8a, 0xdd, 0x0c, 0xaa, 0xc5,
  0x7a, 0xe7, 0x90, 0xdb, 0x5b, 0x96, 0xfa, 0x1c, 0x60, 0xd9, 0x1a, 0x14, 0xed, 0x77, 0xff, 0xbe,
  0xb6, 0x28, 0x5b, 0x94, 0x97, 0x53, 0x0e, 0x74, 0x5b, 0x2a, 0x18, 0xe5, 0xd8, 0xf6, 0xa4, 0x10,
  0x69, 0x9f, 0x08, 0x55, 0x8b, 0xe5, 0x76, 0x33, 0x8a, 0xb7, 0x04, 0xba, 0x0c, 0xa6, 0xe3, 0xa7,
  0x8c, 0xe6, 0x88, 0x4a, 0xb0, 0x4c, 0x5a, 0x11, 0xa0, 0x12, 0x66, 0x59, 0x18, 0x1b, 0x8d, 0x41,
  0xbe, 0x74, 0xb3, 0x07, 0x6e, 0x77, 0xd5, 0xb4, 0x25, 0x04, 0x3b, 0x9c, 0x41, 0xd4, 0x6c, 0x72,
  0xad, 0xde, 0x6f, 0x48, 0xf7, 0x69, 0x8b, 0x5f, 0x5d, 0x97, 0x39, 0xe6, 0x82, 0xfc, 0x13, 0x0f,
  0xde, 0x13, 0xff, 0x70, 0x71, 0x7e, 0x6e, 0x2d, 0xe8, 0xb4, 0xd1, 0x1f, 0xa0, 0xd7, 0x98, 0x26,
  0x62, 0x82, 0x43, 0xea, 0xc5, 0x8a, 0x05, 0x85, 0x89, 0x6f, 0x74, 0x8a, 0xce, 0x24, 0x5a, 0x34
};

static uint8_t test4096_pk2[512] = {
  0x1e, 0x2b, 0xdc, 0xb3, 0xf2, 0x54, 0xf0, 0xc0, 0x7e, 0x3a, 0xa8, 0xce, 0x95, 0x40, 0x36, 0x1e,
  0x89, 0x2f, 0x15, 0xf1, 0x99, 0x4a, 0x10, 0x83, 0xd1, 0x5e, 0x42, 0x29, 0x64, 0x96, 0xc7, 0x5e,
  0x10, 0x21, 0x3c, 0xce, 0xcb, 0xd3, 0x99, 0xa8, 0x60, 0xa9, 0x8e, 0x0d, 0x5b, 0xc1, 0xb0, 0x9c,
  0x75, 0xf3, 0x1b, 0x2a, 0xe0, 0x17, 0xa6, 0x54, 0xe1, 0x38, 0xe1, 0x6c, 0x8e, 0x13, 0xea, 0x19,
  0x37, 0xa1, 0xbf, 0x83, 0xf3, 0x69, 0xbd, 0x5d, 0x26, 0xbe, 0x11, 0xc7, 0xd5, 0x80, 0xa4, 0x92,
  0x5b, 0xfe, 0x2e, 0x95, 0xd3, 0xde, 0x5d, 0xa2, 0xe0, 0x0f, 0x20, 0x10, 0xaa, 0xf6, 0x37, 0x4c,
  0x9a, 0x28, 0x67, 0x64, 0x50, 0x3a, 0x64, 0x3c, 0x08, 0x3d, 0x8d, 0xb4, 0xa1, 0xc0, 0x33, 0x26,
  0x05, 0x62, 0x9d, 0x46, 0xb7, 0x10, 0x44, 0x38, 0x31, 0xf6, 0x57, 0xe4, 0xba, 0x20, 0xb2, 0x11,
  0x3c, 0x2f, 0x6b, 0x4c, 0x26, 0x83, 0x8e, 0xb9, 0x1f, 0x89, 0x4b, 0x17, 0x52, 0x31, 0x56, 0xa0,
  0x8d, 0x87, 0xa3, 0xa9, 0x0b, 0xdc, 0x16, 0xbe, 0x3f, 0x20, 0xfe, 0xc7, 0x6d, 0xc5, 0xfa, 0x9c,
  0x4a, 0xde, 0x10, 0x99, 0x84, 0xda, 0xde, 0xab, 0xe0, 0x3c, 0x09, 0xdd, 0x80, 0xfb, 0xc7, 0xf2,
  0x74, 0xd3, 0xd5, 0x7e, 0x00, 0x62, 0xb0, 0xf8, 0x55, 0x36, 0x74, 0xa0, 0x9d, 0xdd, 0x80, 0xf3,
  0x68, 0x90, 0xbd, 0xf8, 0xc8, 0x72, 0x95, 0xbd, 0xd0, 0x46, 0xba, 0x56, 0x0c, 0x63, 0xac, 0x49,
  0xfc, 0x74, 0x0f, 0xde, 0xe3, 0xce, 0xee, 0x17, 0x90, 0x9a, 0xa0, 0xb1, 0x23, 0x98, 0xe1, 0x5f,
  0xed, 0xa5, 0x99, 0xdc, 0x79, 0x49, 0x9b, 0x16, 0x97, 0xe9, 0x56, 0xe1, 0x7e, 0x42, 0x41, 0xe8,
  0x64, 0x97, 0x92, 0x8d, 0x55, 0x54, 0xcf, 0xf1, 0x99, 0xb4, 0xe6, 0x10, 0xf1, 0xa4, 0x2d, 0xc1,
  0xca, 0xe2, 0x31, 0x00, 0x29, 0x5d, 0xae, 0x0b, 0x75, 0x5f, 0x8f, 0x9e, 0xf6, 0x67, 0x8a, 0x5d,
  0x51, 0x2d, 0xbf, 0x1c, 0x4b, 0xd9, 0x23, 0x0f, 0xb7, 0x32, 0xcb, 0xa7, 0x23, 0x11, 0x04, 0x6c,
  0x6c, 0x59, 0x36, 0x62, 0xea, 0xd1, 0xea, 0x8c, 0x65, 0xf6, 0x18, 0x7d, 0x0d, 0x07, 0x8f, 0xd3,
  0xfc, 0xd5, 0x84, 0x6b, 0x2e, 0xb3, 0x7d, 0xdf, 0x90, 0x5e, 0x36, 0xa1, 0x68, 0x3a, 0x0f, 0x13,
  0x1a, 0xfb, 0x4d, 0xf7, 0x07, 0x1f, 0x99, 0xa0, 0xb5, 0x5b, 0x51, 0xd4, 0xb5, 0xb6, 0xe5, 0x16,
  0xf6, 0xfb, 0x51, 0x0c, 0xae, 0x24, 0xc1, 0xa8, 0x6b, 0x2a, 0x87, 0x8f, 0x61, 0x63, 0xcd, 0xe0,
  0x14, 0xed, 0xd6, 0x13, 0x27, 0xde, 0x31, 0x83, 0x9d, 0x89, 0xcd, 0xbb, 0x2b, 0x6b, 0x76, 0x39,
  0xb7, 0x2e, 0xc8, 0x89, 0xd3, 0xde, 0x67, 0xef, 0x92, 0x9f, 0x2a, 0x3e, 0x25, 0x8c, 0xb5, 0xfa,
  0x49, 0x58, 0x3e, 0x3a, 0x69, 0x15, 0x2b, 0x99, 0xb4, 0x51, 0x03, 0xc4, 0xf1, 0x5c, 0x3e, 0x2a,
  0x07, 0x6d, 0x01, 0xb1, 0xdb, 0x9c, 0xb9, 0xb7, 0x8b, 0x09, 0x10, 0xaa, 0x2e, 0x35, 0x53, 0xcb,
  0x28, 0x49, 0x84, 0x2b, 0x18, 0x34, 0xed, 0x23, 0xf2, 0xe1, 0xf1, 0x6e, 0xec, 0x5e, 0x8e, 0xea,
  0xa6, 0x3e, 0x90, 0x23, 0x4d, 0xa7, 0x73, 0xda, 0x8d, 0x98, 0x55, 0x13, 0x05, 0x19, 0xb9, 0x06,
  0x03, 0xc2, 0x69, 0xa1, 0x8d, 0xe4, 0xc4, 0x52, 0x9b, 0x10, 0xdf, 0x80, 0xba, 0x4f, 0xec, 0x41,
  0x1e, 0x4b, 0x8f, 0xf8, 0xa0, 0xef, 0xbd, 0xe6, 0xe5, 0xc2, 0x51, 0xfa, 0x22, 0xc3, 0xba, 0x89,
  0x39, 0x4c, 0xd5, 0x42, 0x1b, 0x85, 0x0c, 0x5a, 0xa2, 0x8d, 0x4e, 0xc6, 0xc7, 0x8d, 0x00, 0x75,
  0xb4, 0xab, 0x94, 0xff, 0xce, 0xb9, 0x51, 0x78, 0x0d, 0x8a, 0xfb, 0x47, 0x14, 0x6d, 0x0a, 0x2c
};

static uint8_t test4096_ss[512] = {
  0x07, 0x7a, 0x18, 0x76, 0x77, 0x0d, 0xcb, 0x5a, 0xf8, 0x79, 0x27, 0x1a, 0x3c, 0x6e, 0x86, 0xd6,
  0x00, 0xc0, 0x92, 0x67, 0xa5, 0x20, 0xf2, 0xe4, 0xc5, 0xc2, 0xaf, 0x06, 0x72, 0xe2, 0x1a, 0xf7,
  0xf0, 0xaa, 0x66, 0xd5, 0x2e, 0x99, 0x76, 0xda, 0x94, 0xec, 0x86, 0x44, 0x83, 0x07, 0x01, 0xe3,
  0xfb, 0x71, 0xda, 0x1f, 0x4b, 0x6d, 0x8f, 0x4d, 0x41, 0xbc, 0x27, 0x5a, 0xa2, 0x6f, 0xd8, 0x7c,
  0x14, 0x3b, 0xb0, 0x6a, 0x64, 0x0f, 0x6a, 0x58, 0xe6, 0x79, 0x2e, 0xd1, 0xfc, 0x8c, 0x9c, 0x38,
  0x73, 0x5f, 0x8a, 0xdd, 0xc3, 0xa2, 0x20, 0x9e, 0x91, 0x2d, 0x08, 0x13, 0x44, 0x2f, 0xe5, 0x7d,
  0x96, 0x96, 0xa0, 0xf4, 0xe3, 0x7f, 0xee, 0x0b, 0x5c, 0xda, 0x49, 0x95, 0x03, 0x0a, 0x18, 0x6a,
  0x6f, 0x4f, 0xe7, 0x8e, 0x8c, 0xf4, 0xc2, 0xab, 0x76, 0x81, 0x84, 0xcd, 0x74, 0x80, 0xf3, 0x24,
  0xda, 0xfa, 0x67, 0x39, 0x7e, 0xaa, 0xef, 0x92, 0x9d, 0xa2, 0x19, 0x8d, 0x28, 0xb7, 0xf3, 0xdc,
  0xe9, 0xca, 0x6b, 0x33, 0x77, 0xe4, 0x7a, 0x6a, 0x46, 0xc5, 0x81, 0xe2, 0xb5, 0xc0, 0x66, 0x48,
  0x2a, 0xad, 0x02, 0xca, 0x53, 0x48, 0x7a, 0x6f, 0xcb, 0xb2, 0x51, 0x5c, 0x4a, 0x3e, 0x01, 0xfc,
  0xc0, 0x4f, 0x52, 0xc2, 0x40, 0x19, 0xfe, 0x0a, 0xe2, 0xe2, 0x96, 0x1a, 0xa4, 0xe1, 0xae, 0xd8,
  0xf7, 0x70, 0x6a, 0x7e, 0x69, 0xe4, 0x95, 0x96, 0xf1, 0x37, 0xe4, 0xc5, 0x2b, 0x48, 0x3b, 0x31,
  0x15, 0xd1, 0x78, 0x0d, 0x95, 0xeb, 0x00, 0x00, 0xbf, 0xcb, 0xf9, 0xcd, 0xe1, 0x0b, 0x2c, 0xec,
  0xab, 0x03, 0xb7, 0xf8, 0x66, 0xe4, 0xf4, 0x90, 0xe6, 0xc2, 0x51, 0xaa, 0x68, 0xbf, 0x2f, 0xd0,
  0x65, 0xee, 0x56, 0x35, 0x8f, 0x16, 0x7f, 0xdd, 0x1f, 0x3c, 0xec, 0x21, 0x90, 0xed, 0x57, 0x61,
  0x98, 0x70, 0x56, 0xf0, 0x88, 0x9d, 0x27, 0x04, 0x07, 0xa3, 0x2e, 0xfb, 0x24, 0x53, 0xe8, 0x05,
  0xe4, 0x27, 0x32, 0x0a, 0x97, 0x7e, 0xf2, 0x32, 0xc8, 0xc0, 0x04, 0x09, 0xa6, 0xb8, 0x54, 0x76,
  0x45, 0xc3, 0x50, 0x80, 0xb9, 0xeb, 0x0d, 0xa6, 0xf3, 0x26, 0x88, 0x28, 0x0b, 0xa3, 0xb3, 0x23,
  0x24, 0xd1, 0xd6, 0x6f, 0xc9, 0x55, 0xec, 0x2b, 0x79, 0x9c, 0xd8, 0xcf, 0x02, 0xf2, 0xf7, 0xe9,
  0x96, 0x55, 0xc5, 0x6d, 0x9a, 0x02, 0x6f, 0xa8, 0xbe, 0x7b, 0xa9, 0x1a, 0x31, 0xca, 0x86, 0xed,
  0x8f, 0xf4, 0x3e, 0x71, 0x54, 0x18, 0x2c, 0x50, 0x54, 0xd2, 0xb4, 0x82, 0x5f, 0xff, 0x79, 0xe3,
  0xc4, 0xa8, 0x1e, 0x93, 0x89, 0x11, 0x25, 0x0b, 0xa6, 0x12, 0xff, 0x5d, 0x38, 0xb5, 0xb0, 0x21,
  0x28, 0x82, 0xfe, 0x03, 0x09, 0x41, 0x61, 0xe6, 0x51, 0x6c, 0x7c, 0x8f, 0x8d, 0xbc, 0x3b, 0x04,
  0x42, 0x1c, 0x73, 0x17, 0x51, 0xae, 0xff, 0x5f, 0x33, 0x93, 0x6c, 0x96, 0xf1, 0x20, 0xbd, 0xeb,
  0x5c, 0xa9, 0x7c, 0x6e, 0x3c, 0xde, 0xb9, 0x6e, 0x49, 0x31, 0xa8, 0x46, 0x4b, 0x08, 0xe1, 0xf4,
  0xf4, 0x77, 0xea, 0x11, 0xa2, 0xae, 0x91, 0x1d, 0x7f, 0x86, 0xbb, 0x89, 0xdf, 0x7b, 0xdb, 0x77,
  0xc3, 0x0c, 0x7e, 0xa4, 0xb1, 0x8c, 0x2d, 0x75, 0x9d, 0xdc, 0x74, 0x38, 0x89, 0x06, 0xed, 0xa5,
  0xae, 0x79, 0x64, 0xce, 0xfc, 0xd3, 0x94, 0x7b, 0x64, 0x61, 0xcc, 0x05, 0xea, 0x9f, 0xb5, 0xf9,
  0x8f, 0xde, 0xe4, 0x05, 0x8c, 0x9c, 0x95, 0xe4, 0x81, 0x29, 0x91, 0xd1, 0xe5, 0xdc, 0xdc, 0xc9,
  0xf3, 0x84, 0x0c, 0x74, 0x9d, 0x1b, 0x24, 0x70, 0xcf, 0x42, 0x90, 0xe4, 0x25, 0xe5, 0x4f, 0x2a,
  0x1e, 0x14, 0xe2, 0xc3, 0xa8, 0xc7, 0x52, 0x7a, 0x04, 0x11, 0x75, 0x4a, 0x67, 0xde, 0x74, 0xb9
};


static uint8_t test6144_sk1[768] = {
  0x71, 0xa8, 0xd8, 0x32, 0xa7, 0x68, 0x7c, 0xe4, 0xdf, 0x66, 0xb7, 0xe0, 0x5a, 0xeb, 0xa3, 0x75,
  0xe6, 0x02, 0x94, 0x1b, 0x5f, 0x70, 0x5b, 0xe3, 0x12, 0x7d, 0xc1, 0x03, 0x20, 0x4d, 0x47, 0x52,
  0xfe, 0xac, 0x56, 0xfb, 0x41, 0xd8, 0x88, 0x8e, 0xc9, 0x4c, 0x50, 0x22, 0x8e, 0xbf, 0x56, 0x8f,
  0xf4, 0x9f, 0x44, 0x3d, 0x54, 0x6f, 0xe8, 0x92, 0x56, 0xc5, 0xfb, 0x87, 0x96, 0xf2, 0xee, 0x04,
  0x69, 0x87, 0x8e, 0x7b, 0x2d, 0x81, 0x92, 0x04, 0x67, 0xcb, 0xd6, 0x8b, 0xf6, 0xf9, 0x82, 0x32,
  0x26, 0xa5, 0x4b, 0x6f, 0x37, 0x23, 0x36, 0xd7, 0x7f, 0x78, 0x55, 0xd5, 0x6c, 0xd9, 0xf2, 0x5e,
  0x14, 0xcd, 0xfa, 0xc1, 0xa8, 0x3b, 0x6e, 0x5b, 0x72, 0xf0, 0xfd, 0x1f, 0x13, 0x04, 0xce, 0xf8,
  0xda, 0x78, 0xd9, 0xc5, 0x9d, 0xf2, 0xc7, 0x01, 0xc4, 0x46, 0xac, 0x66, 0x92, 0x7d, 0x21, 0x98,
  0xaf, 0xea, 0x3c, 0x43, 0x8c, 0x1f, 0x8a, 0x5b, 0xeb, 0x3b, 0xb4, 0x85, 0x77, 0x33, 0x76, 0xed,
  0x34, 0x8f, 0xc2, 0x67, 0xa8, 0x03, 0x08, 0x2c, 0xb7, 0x04, 0xde, 0x14, 0xb9, 0x30, 0xf2, 0x56,
  0x85, 0xf7, 0xfe, 0x93, 0xc2, 0x39, 0x19, 0x21, 0x25, 0x95, 0x72, 0x08, 0x2b, 0x4f, 0xf4, 0x62,
  0x0b, 0x59, 0xe9, 0x74, 0xd7, 0xb5, 0x50, 0x1a, 0x60, 0xe7, 0x25, 0x09, 0x3d, 0x38, 0x47, 0x19,
  0xcd, 0x2d, 0x29, 0xfb, 0xe0, 0x62, 0xf5, 0x85, 0x32, 0xc5, 0x31, 0x95, 0xe6, 0xed, 0x7a, 0xa2,
  0xd5, 0x69, 0x5f, 0x23, 0x0d, 0xe2, 0xf3, 0x38, 0x79, 0x04, 0xad, 0xde, 0x98, 0xac, 0xe1, 0x11,
  0x33, 0xe9, 0x21, 0x45, 0xae, 0x6d, 0x72, 0xa4, 0x45, 0x48, 0x97, 0xe1, 0x17, 0xa8, 0x1a, 0xb5,
  0xaa, 0x70, 0x64, 0x98, 0xb0, 0x87, 0x18, 0x3e, 0xd0, 0x16, 0x6a, 0x7c, 0xd5, 0x00, 0x33, 0x2e,
  0xc9, 0x2a, 0x3e, 0xa0, 0x24, 0x38, 0x7c, 0x7b, 0x1d, 0x73, 0x02, 0xb4, 0x35, 0x1a, 0x8e, 0x7a,
  0x81, 0x33, 0x79, 0xb4, 0x9c, 0xfa, 0xae, 0x68, 0x9f, 0xfc, 0x17, 0x11, 0x39, 0x4e, 0xb3, 0x01,
  0x4e, 0xb1, 0xbf, 0x10, 0x1b, 0x53, 0x4b, 0x24, 0x18, 0xef, 0xbb, 0x92, 0xd3, 0x4a, 0xf8, 0xc7,
  0x53, 0x78, 0xe0, 0xc3, 0x21, 0xcf, 0xf7, 0xa7, 0x5d, 0xbc, 0xda, 0xf8, 0xf1, 0xcb, 0x43, 0x1c,
  0x21, 0x08, 0xc5, 0x27, 0x60, 0xaa, 0x7d, 0x53, 0xa8, 0xa1, 0x51, 0x1f, 0x1a, 0xa3, 0x46, 0x1f,
  0x70, 0xb9, 0x38, 0x0a, 0xf7, 0x39, 0x4e, 0x18, 0x85, 0x70, 0x5a, 0x5d, 0x02, 0xb6, 0x53, 0xaa,
  0x7d, 0x74, 0x1e, 0x1f, 0x5f, 0xc3, 0xa2, 0x38, 0x6e, 0x46, 0xe5, 0x2d, 0xdd, 0x1d, 0xca, 0xe9,
  0xc4, 0xa0, 0x62, 0x3e, 0x37, 0xe4, 0xbe, 0xba, 0x28, 0x66, 0x4b, 0xa6, 0x48, 0x23, 0x77, 0x7e,
  0xf6, 0xdf, 0x2a, 0x16, 0xc0, 0xa0, 0x5a, 0x94, 0x1c, 0x59, 0x27, 0x91, 0x1a, 0x2a, 0x55, 0x1c,
  0x66, 0xd2, 0x04, 0x20, 0xe3, 0xd7, 0x54, 0x17, 0x72, 0xbd, 0x02, 0x7a, 0xb8, 0xb0, 0x46, 0x56,
  0x1c, 0xa2, 0xb2, 0x19, 0x42, 0xd7, 0x32, 0xde, 0x27, 0x3d, 0xd7, 0xcb, 0xde, 0x59, 0xb7, 0x74,
  0x01, 0xb0, 0xe8, 0xbe, 0xe0, 0xec, 0x31, 0x76, 0x13, 0x43, 0xbd, 0x78, 0x34, 0x11, 0xf2, 0xc3,
  0x6a, 0xf4, 0xe7, 0x38, 0x9b, 0x89, 0x4a, 0x9f, 0x50, 0xba, 0x41, 0x0a, 0x98, 0x6a, 0x6f, 0xdf,
  0x65, 0xf6, 0x59, 0x14, 0x4f, 0x4f, 0x4d, 0xae, 0x36, 0x0c, 0xc7, 0x9d, 0x90, 0x12, 0x53, 0xe2,
  0xea, 0x9f, 0xee, 0xe4, 0x0f, 0xcb, 0x2e, 0x49, 0x3b, 0xde, 0x92, 0x90, 0x0a, 0x60, 0x0e, 0xb5,
  0x5a, 0x7a, 0x22, 0x1b, 0x05, 0xec, 0x4f, 0xe1, 0x8e, 0x2a, 0x4b, 0xc9, 0x70, 0xc6, 0x2a, 0xac,
  0x23, 0x6c, 0x5e, 0x6a, 0x00, 0xf1, 0x52, 0xe4, 0x80, 0x4e, 0x45, 0xfb, 0xe3, 0xde, 0x19, 0xf4,
  0xce, 0x2d, 0x24, 0xe6, 0xf1, 0xc2, 0x35, 0xcd, 0xe6, 0xde, 0x2f, 0x59, 0xab, 0xd7, 0x06, 0xf2,
  0xb8, 0x68, 0xab, 0x2e, 0x91, 0x69, 0xdc, 0x73, 0x3a, 0xca, 0xfc, 0x42, 0xf3, 0xef, 0xff, 0x30,
  0xd1, 0x2f, 0x1b, 0x3e, 0x43, 0xb0, 0xa9, 0xe9, 0xb9, 0x6c, 0x11, 0x0d, 0xf9, 0x78, 0x18, 0x25,
  0x36, 0xae, 0xc6, 0x79, 0x87, 0x31, 0xdd, 0xa0, 0x1e, 0xc6, 0x0b, 0x42, 0x88, 0x62, 0xcf, 0x3b,
  0xa4, 0xeb, 0x6f, 0xd7, 0xbd, 0x98, 0x60, 0xa6, 0xe8, 0xb5, 0x5d, 0x64, 0xdf, 0x09, 0x68, 0xce,
  0x8e, 0x8a, 0xea, 0x99, 0x26, 0xfd, 0xda, 0xdb, 0xbe, 0xdf, 0x51, 0x18, 0x28, 0x20, 0xe9, 0x12,
  0x1d, 0x6b, 0x69, 0x7d, 0xeb, 0xdc, 0x19, 0x5f, 0x70, 0xc9, 0xe1, 0xf8, 0x5f, 0x5a, 0xe5, 0x8d,
  0xb8, 0x59, 0xdb, 0xbe, 0x0a, 0x4a, 0x02, 0xa1, 0x98, 0x06, 0x9d, 0x3d, 0x7a, 0x82, 0xe2, 0x01,
  0x77, 0x1a, 0x28, 0x59, 0x44, 0x34, 0x95, 0x5c, 0x62, 0xeb, 0x6f, 0x74, 0x40, 0x83, 0x43, 0xa2,
  0x66, 0x36, 0x9d, 0xfe, 0x03, 0x66, 0x68, 0xcc, 0xe6, 0xee, 0x14, 0x27, 0xc3, 0x22, 0x17, 0x3b,
  0x6f, 0x76, 0x6a, 0xef, 0x22, 0x2f, 0xfb, 0x2d, 0x2a, 0xb8, 0x20, 0xd4, 0x20, 0x54, 0xf4, 0xae,
  0x25, 0x37, 0x93, 0x1c, 0xaa, 0x7c, 0xc3, 0x8b, 0x5b, 0x86, 0x07, 0xac, 0x34, 0x42, 0x7d, 0x2c,
  0xf9, 0x81, 0xad, 0x4b, 0xb6, 0x11, 0x6d, 0x68, 0x8b, 0x9c, 0x69, 0xb7, 0x4b, 0x0a, 0x76, 0xcd,
  0x06, 0xd4, 0x3a, 0xc3, 0x15, 0x32, 0xe3, 0x05, 0xa2, 0xeb, 0xd6, 0x21, 0x36, 0xc6, 0xaf, 0x6b,
  0x7d, 0xd6, 0x4e, 0x74, 0x3e, 0x4b, 0xb6, 0x46, 0x09, 0xeb, 0x1e, 0x9a, 0x9f, 0x0b, 0x6f, 0x6b
};

static uint8_t test6144_pk1[768] = {
  0x33, 0x1b, 0xcb, 0xfc, 0x0e, 0x68, 0x8b, 0xdd, 0x50, 0x01, 0x29, 0x43, 0x5a, 0xaf, 0xac, 0x69,
  0x7b, 0x80, 0x61, 0x9e, 0xf8, 0x8c, 0x23, 0x79, 0x94, 0x03, 0x35, 0x29, 0x8b, 0xc9, 0x48, 0x33,
  0x22, 0x19, 0x52, 0x39, 0x06, 0xff, 0xfd, 0x5c, 0x8d, 0x2c, 0xf9, 0x62, 0x75, 0x98, 0x29, 0x47,
  0x34, 0x36, 0x0c, 0x5e, 0x7c, 0xa2, 0x54, 0x38, 0x4c, 0xa9, 0xc3, 0xf0, 0xf6, 0x5d, 0xec, 0xc6,
  0x3d, 0xf9, 0x0f, 0x5a, 0xe3, 0xab, 0x46, 0xe4, 0x2e, 0xc4, 0x58, 0x59, 0x4e, 0x32, 0xaf, 0xbb,
  0x45, 0xc2, 0xb3, 0x62, 0xef, 0x73, 0x7a, 0xea, 0x47, 0x3b, 0x28, 0xff, 0x49, 0x90, 0x43, 0x42,
  0x43, 0x33, 0x42, 0x5b, 0x78, 0x5b, 0x9f, 0x9f, 0xde, 0x20, 0xc9, 0x4f, 0x97, 0x12, 0xa2, 0xfb,
  0xdd, 0xf5, 0x3a, 0x9b, 0xd8, 0xd1, 0x9b, 0xc2, 0x8b, 0x35, 0x34, 0x61, 0x2c, 0x42, 0x04, 0x27,
  0xf3, 0xcb, 0x98, 0x58, 0xdf, 0x68, 0x7e, 0x1f, 0xac, 0xf5, 0x08, 0xef, 0xfc, 0xa2, 0xe9, 0xd9,
  0x3f, 0x3b, 0x25, 0x6f, 0xa8, 0x1e, 0x1a, 0x95, 0x64, 0xb3, 0xdc, 0x16, 0x0a, 0x83, 0x1f, 0xe3,
  0x81, 0x2d, 0xdb, 0xde, 0xe6, 0xa2, 0x38, 0x0a, 0xdb, 0x45, 0x51, 0x41, 0x68, 0xec, 0x74, 0xb2,
  0x31, 0x0f, 0x03, 0x5f, 0xc5, 0x90, 0x04, 0xaf, 0xfc, 0x83, 0x4d, 0xdc, 0xcd, 0x6f, 0xb1, 0x0b,
  0xcd, 0x1b, 0x59, 0x69, 0xfd, 0x8a, 0x36, 0x1d, 0x53, 0x08, 0xb6, 0xc0, 0x04, 0xfe, 0xe6, 0x66,
  0x57, 0x01, 0xf8, 0xab, 0x11, 0xbc, 0x1f, 0xcd, 0x38, 0xa5, 0x22, 0x0f, 0xa3, 0x35, 0x95, 0xd7,
  0xf5, 0x62, 0xc5, 0x44, 0x0e, 0xef, 0xa9, 0xc1, 0xbe, 0x79, 0x55, 0xd4, 0x36, 0xf5, 0x6b, 0xe7,
  0x00, 0x07, 0xfa, 0xd3, 0xc7, 0x6b, 0x83, 0xd3, 0x3f, 0x1f, 0x38, 0x65, 0x9b, 0xa4, 0x79, 0x97,
  0x78, 0x6f, 0x75, 0xab, 0xf8, 0x76, 0x3d, 0x02, 0x0b, 0xea, 0xc0, 0xfb, 0x84, 0xcf, 0xcd, 0x25,
  0x62, 0xf6, 0x92, 0x53, 0xbb, 0x21, 0x11, 0x16, 0x64, 0xdc, 0x91, 0xe6, 0x3e, 0x84, 0x75, 0xb7,
  0x5d, 0x63, 0xc4, 0xa1, 0x46, 0xd3, 0x08, 0x94, 0x8c, 0xe7, 0x56, 0xbb, 0x22, 0xb4, 0x1d, 0x00,
  0xf1, 0xa3, 0xe6, 0x67, 0x48, 0x3c, 0x0a, 0x12, 0x45, 0xd3, 0x65, 0x33, 0x31, 0x6c, 0xa7, 0xf2,
  0xa6, 0x18, 0xba, 0x4f, 0xd9, 0xd4, 0xf7, 0xae, 0x7e, 0xb7, 0xc4, 0x4c, 0x4b, 0x6a, 0x66, 0xc5,
  0x01, 0x12, 0x81, 0xad, 0xc0, 0x51, 0xac, 0x8b, 0x95, 0x07, 0xc7, 0x54, 0x3f, 0x8c, 0x8e, 0xc9,
  0x34, 0x40, 0x71, 0x90, 0xb1, 0x48, 0x9d, 0xae, 0x1e, 0xad, 0x34, 0x2e, 0x51, 0xcd, 0xa7, 0x45,
  0xea, 0xbe, 0x6c, 0x24, 0x70, 0x1e, 0x58, 0x02, 0x58, 0x77, 0x2c, 0x96, 0xa3, 0xf5, 0x10, 0x51,
  0x0b, 0x3a, 0x65, 0x2e, 0x98, 0xa6, 0x37, 0xef, 0xee, 0x09, 0xef, 0x67, 0x2a, 0x47, 0xd6, 0x05,
  0x84, 0x6a, 0x29, 0xdf, 0x6b, 0xe9, 0x65, 0x01, 0x2c, 0x75, 0xb0, 0x8f, 0x85, 0xad, 0x33, 0xb2,
  0x3d, 0xfd, 0x7a, 0xd7, 0x38, 0xd3, 0x75, 0x43, 0x09, 0x56, 0xac, 0x6b, 0xe7, 0xb2, 0xee, 0x3c,
  0xb2, 0xa4, 0x54, 0xd5, 0x67, 0x99, 0x0c, 0x61, 0x6c, 0x60, 0x4b, 0xe7, 0xca, 0x5c, 0x25, 0x07,
  0xce, 0x11, 0x0d, 0xa1, 0x06, 0x40, 0x3c, 0xd9, 0xa0, 0x65, 0xfe, 0xba, 0x29, 0x27, 0xe5, 0x1f,
  0x3f, 0x9b, 0x85, 0x20, 0x4d, 0xf1, 0x49, 0x2b, 0xc9, 0x49, 0x3b, 0xe2, 0xd4, 0x02, 0x36, 0xb7,
  0x10, 0x49, 0x9b, 0x97, 0x46, 0x3d, 0x76, 0x5a, 0x67, 0x28, 0x0f, 0x8b, 0xc2, 0x86, 0xe7, 0x4d,
  0xd2, 0x80, 0x4f, 0x95, 0x93, 0xe4, 0x09, 0x4b, 0x7f, 0xeb, 0x81, 0x00, 0x38, 0x27, 0xb0, 0x55,
  0xd3, 0x97, 0x8c, 0xdb, 0x59, 0x33, 0xce, 0xab, 0x4b, 0x14, 0xfe, 0x40, 0xef, 0x16, 0xcb, 0xc2,
  0xb0, 0x26, 0x5a, 0x0c, 0x85, 0x68, 0x67, 0x63, 0x12, 0x34, 0xa8, 0x3d, 0xa5, 0xa0, 0x7b, 0xd8,
  0xbe, 0x1d, 0x2b, 0xe2, 0x0d, 0x02, 0xe5, 0xf8, 0x3c, 0xc3, 0x0a, 0xa7, 0x18, 0x50, 0x0a, 0xe1,
  0x0c, 0xde, 0x8d, 0x2f, 0x67, 0x6a, 0x7e, 0x21, 0x3c, 0x87, 0x91, 0x40, 0x04, 0xb8, 0x4a, 0x12,
  0x4b, 0x93, 0xf4, 0x7b, 0x91, 0x52, 0x05, 0x63, 0xb3, 0xf6, 0xe0, 0x1f, 0x90, 0xe7, 0x5b, 0x75,
  0x77, 0x98, 0xc2, 0x0c, 0xc9, 0xc7, 0x8b, 0x77, 0xec, 0x7f, 0xa4, 0xcd, 0x99, 0xfd, 0xbe, 0x29,
  0x4d, 0xea, 0xb8, 0x47, 0x3d, 0x84, 0xff, 0x98, 0x53, 0x68, 0x91, 0x24, 0x97, 0x8d, 0xf0, 0x5b,
  0xfe, 0x02, 0x91, 0xc6, 0x28, 0x2b, 0x5f, 0x2d, 0xc2, 0xca, 0x8a, 0xed, 0x85, 0x23, 0xe4, 0xc6,
  0x84, 0x0b, 0x4e, 0xae, 0xdd, 0xba, 0x82, 0xef, 0xa9, 0xb1, 0x65, 0x08, 0xfc, 0x4a, 0xd7, 0x91,
  0x8f, 0xb2, 0x97, 0x57, 0x16, 0x8a, 0x32, 0x1f, 0x9d, 0xa6, 0x74, 0x80, 0x1d, 0xb4, 0xbf, 0xc8,
  0xa5, 0x6b, 0xf6, 0xf4, 0xc6, 0x07, 0xab, 0x8f, 0xf7, 0x46, 0xf5, 0x5e, 0x4b, 0xb7, 0xf2, 0x5e,
  0x89, 0x21, 0x44, 0xe9, 0xe6, 0x6c, 0xc8, 0x71, 0x5e, 0x24, 0xfd, 0xc4, 0x91, 0x56, 0x19, 0xfe,
  0xbf, 0x8b, 0x58, 0x8d, 0x5b, 0x33, 0x86, 0xb0, 0x22, 0x49, 0xe8, 0x5e, 0x7a, 0xff, 0x5e, 0xa1,
  0xa5, 0x50, 0x0a, 0xa6, 0xfc, 0x4d, 0x9d, 0x48, 0xc3, 0xfe, 0xff, 0x75, 0x00, 0xcf, 0xc3, 0x71,
  0xd2, 0x6a, 0x75, 0x69, 0xf4, 0xc0, 0xdd, 0x22, 0x5c, 0xee, 0x81, 0x9f, 0x46, 0x44, 0xbb, 0xd7,
  0xec, 0xf9, 0x28, 0xdc, 0x1c, 0xe1, 0x9b, 0x1b, 0xe0, 0xc6, 0x66, 0x9a, 0x70, 0xdd, 0xb5, 0xe6
};

static uint8_t test6144_sk2[768] = {
  0x4a, 0x1f, 0xb7, 0x95, 0x5e, 0xad, 0xa0, 0x47, 0x73, 0x2c, 0x54, 0x63, 0xd3, 0xa4, 0x8e, 0xa6,
  0xaa, 0x08, 0x6f, 0x79, 0x8c, 0x6c, 0x21, 0xdd, 0x7c, 0xaa, 0x4c, 0x08, 0x6e, 0x7f, 0xf3, 0x21,
  0x73, 0xed, 0x4d, 0x83, 0xe1, 0x4d, 0x12, 0x61, 0xf3, 0x1a, 0x21, 0x40, 0x0b, 0x80, 0x81, 0xba,
  0x2e, 0x1c, 0xa4, 0xa3, 0x4b, 0x27, 0x12, 0x94, 0x8f, 0xf5, 0xa9, 0x9d, 0x0a, 0x9c, 0x98, 0x85,
  0xb6, 0x8d, 0x7f, 0x48, 0x58, 0x85, 0xb9, 0xff, 0x1f, 0x86, 0x1e, 0x08, 0xce, 0x98, 0xaa, 0x9b,
  0x98, 0xc9, 0xd9, 0x46, 0x65, 0xd0, 0x59, 0xa3, 0x04, 0x91, 0x5f, 0x7f, 0x4d, 0xc2, 0x76, 0xaa,
  0x54, 0x4f, 0x01, 0x41, 0x75, 0x2c, 0x27, 0xc2, 0x6b, 0x92, 0x2d, 0x75, 0x85, 0x21, 0x84, 0x77,
  0xe5, 0x59, 0x2f, 0x8e, 0xee, 0x33, 0x72, 0x5e, 0x90, 0xaf, 0xa2, 0x34, 0x2c, 0x8b, 0x8b, 0x3e,
  0x7b, 0xab, 0x7d, 0xf8, 0xb0, 0x33, 0x06, 0xaf, 0x79, 0x36, 0x85, 0xa7, 0x5d, 0x28, 0xcc, 0xeb,
  0x0b, 0x0c, 0xbe, 0xaf, 0x26, 0xa8, 0xd0, 0xa5, 0x98, 0x20, 0x51, 0xaf, 0x71, 0x78, 0xd4, 0x64,
  0x53, 0xc8, 0xaa, 0x63, 0x77, 0x92, 0x20, 0x84, 0xf2, 0x1d, 0x62, 0x91, 0x4d, 0x6b, 0xc6, 0x01,
  0x33, 0x66, 0xa7, 0xb1, 0x03, 0x39, 0xf8, 0x0b, 0x2c, 0x5b, 0xca, 0x8a, 0x49, 0x81, 0xb1, 0xb5,
  0x3f, 0x7f, 0x6e, 0x43, 0x48, 0xe3, 0x60, 0x18, 0xd2, 0x06, 0x28, 0x70, 0x0f, 0x3b, 0x3a, 0x27,
  0x2e, 0xf6, 0x1f, 0xc6, 0x17, 0x91, 0x2b, 0x9c, 0xba, 0xe0, 0x7d, 0x6c, 0x23, 0x56, 0x53, 0x4d,
  0x0b, 0xad, 0x6e, 0x05, 0x0a, 0xce, 0x87, 0x0e, 0x27, 0x72, 0x5c, 0x53, 0x04, 0xda, 0xaf, 0xf7,
  0xd7, 0xa0, 0x9b, 0x68, 0x27, 0x03, 0xa3, 0x82, 0x70, 0x30, 0xda, 0x0c, 0xa3, 0x04, 0xd6, 0xf0,
  0xc9, 0x83, 0x95, 0xc1, 0xa7, 0x67, 0x08, 0x5e, 0x30, 0xa9, 0x4c, 0x30, 0xcc, 0x6f, 0xfb, 0x7b,
  0x7f, 0x1f, 0x10, 0x34, 0x09, 0x30, 0xc1, 0x12, 0x23, 0xb4, 0xf9, 0x35, 0xcf, 0x51, 0xcb, 0x4f,
  0x85, 0x0a, 0x8a, 0x0a, 0x79, 0x52, 0x24, 0xe6, 0x85, 0xb7, 0x12, 0x0d, 0x60, 0xda, 0xde, 0x87,
  0x7f, 0xb0, 0x46, 0x40, 0x81, 0x52, 0x44, 0x84, 0x45, 0xff, 0x0d, 0x0a, 0xf9, 0xf0, 0x36, 0xe9,
  0x84, 0x31, 0x5a, 0xa0, 0xf3, 0x84, 0xee, 0xfd, 0x5b, 0x5e, 0x6e, 0x98, 0xcc, 0xf3, 0x7b, 0x98,
  0x91, 0x9e, 0x0c, 0xd2, 0xa4, 0x63, 0xc8, 0xd0, 0x99, 0x91, 0x29, 0x19, 0x78, 0x99, 0x3b, 0x5c,
  0xe1, 0xad, 0x0c, 0xac, 0xef, 0x75, 0xe3, 0x31, 0x18, 0x4d, 0xb0, 0x68, 0x58, 0xeb, 0xd2, 0x73,
  0x6c, 0x94, 0xc4, 0xa4, 0x51, 0x8f, 0x80, 0xf4, 0xa7, 0x11, 0x79, 0xe5, 0x6f, 0x71, 0xb2, 0x39,
  0x76, 0xf3, 0x24, 0x08, 0x37, 0x5b, 0x1a, 0x73, 0x49, 0x4d, 0xd8, 0x72, 0x9e, 0x8b, 0xbf, 0x03,
  0x5e, 0x41, 0x71, 0xcc, 0xea, 0xbf, 0x2d, 0x44, 0xb2, 0xba, 0x0e, 0x8b, 0x53, 0x6d, 0xf5, 0xc9,
  0x92, 0xa6, 0x96, 0x94, 0x5b, 0x06, 0x42, 0x2e, 0x57, 0xf7, 0xf4, 0x14, 0x61, 0xd8, 0x18, 0x45,
  0x13, 0x70, 0x8e, 0xad, 0xd5, 0x85, 0xa5, 0x06, 0x9e, 0xc3, 0x81, 0x65, 0x4a, 0xeb, 0xf6, 0xf5,
  0x3e, 0x69, 0xca, 0x74, 0x5f, 0x08, 0xa0, 0x25, 0x23, 0x69, 0xff, 0x01, 0xcf, 0xd4, 0xd3, 0x53,
  0xbb, 0x5d, 0xe4, 0x7c, 0xfd, 0xf3, 0x4a, 0x17, 0xe9, 0xf2, 0x97, 0x5f, 0x0e, 0x68, 0x60, 0x69,
  0x4c, 0x8b, 0x45, 0x6f, 0x74, 0xc3, 0xe2, 0xfe, 0x7f, 0xa5, 0x18, 0x4e, 0x33, 0xbd, 0xe5, 0xa4,
  0x8d, 0xee, 0xf2, 0xf2, 0xab, 0x4e, 0x7d, 0x5a, 0xc5, 0xf6, 0x63, 0x54, 0x8a, 0x60, 0xa6, 0x89,
  0xa4, 0xb5, 0x9f, 0x4b, 0x7b, 0x90, 0xcc, 0x0c, 0x8c, 0x1e, 0x09, 0xa2, 0xc2, 0x8d, 0x72, 0xc8,
  0x91, 0x19, 0x44, 0x7b, 0x54, 0xe7, 0x89, 0x87, 0x4e, 0x33, 0x6e, 0xa6, 0xd1, 0xd7, 0x6c, 0x42,
  0x56, 0x46, 0x8f, 0xbc, 0x30, 0x74, 0x5d, 0xd8, 0x29, 0xb1, 0xb7, 0xc5, 0x68, 0x6b, 0x2e, 0x8d,
  0x34, 0x1d, 0x46, 0xff, 0x3d, 0x63, 0x2e, 0x4f, 0x77, 0x1b, 0xaa, 0x06, 0x21, 0x06, 0x21, 0x05,
  0x61, 0x46, 0xa8, 0x7b, 0xbc, 0x90, 0x4a, 0x40, 0x83, 0xb2, 0x0c, 0x43, 0x15, 0x7b, 0x72, 0xfc,
  0x0b, 0xa9, 0x0a, 0x9a, 0xf1, 0xd7, 0x3f, 0xf9, 0x5c, 0x6d, 0xee, 0x42, 0x0a, 0xdc, 0xe8, 0xb6,
  0x90, 0xc7, 0xcb, 0x64, 0x34, 0x47, 0xcc, 0x3d, 0x54, 0x27, 0x57, 0x7a, 0x84, 0x60, 0x6e, 0xd2,
  0x2a, 0xb1, 0x21, 0xc8, 0xd0, 0xaa, 0x78, 0x55, 0x27, 0x9a, 0x1b, 0xeb, 0xd4, 0xfe, 0xe3, 0x3a,
  0x1a, 0x12, 0x69, 0x7d, 0x78, 0xac, 0x2a, 0x90, 0xd4, 0x0a, 0x20, 0x0b, 0x04, 0x9b, 0xe3, 0x20,
  0xbf, 0xad, 0x49, 0x35, 0x62, 0x98, 0x3b, 0x2a, 0xe5, 0x69, 0xf4, 0xcf, 0x48, 0xa3, 0x57, 0x02,
  0x2a, 0x71, 0x96, 0xf4, 0x1b, 0x05, 0x64, 0x3c, 0x99, 0x80, 0x2c, 0xac, 0xe5, 0xf2, 0x21, 0xb7,
  0x15, 0x03, 0xaa, 0x3d, 0x8c, 0x9e, 0x96, 0x44, 0x77, 0x65, 0xf9, 0x49, 0x5e, 0x52, 0xb1, 0x35,
  0xdc, 0x76, 0xd5, 0x9c, 0xf2, 0xf4, 0xfd, 0x29, 0xfc, 0xb6, 0xe0, 0x83, 0x8e, 0x13, 0x90, 0x36,
  0x12, 0x56, 0x8f, 0xa5, 0x69, 0xa0, 0x2a, 0x2a, 0xc0, 0xc5, 0x50, 0x1e, 0xee, 0xae, 0xfe, 0x13,
  0x74, 0x5d, 0xc9, 0x44, 0x86, 0x51, 0xf9, 0x59, 0x6a, 0x92, 0x7a, 0x5d, 0x2e, 0xeb, 0x53, 0xd8,
  0xb1, 0xe0, 0x96, 0xde, 0xe9, 0x5f, 0xa5, 0x07, 0x89, 0xd2, 0x44, 0x51, 0x64, 0xf4, 0x2c, 0x5d
};

static uint8_t test6144_pk2[768] = {
  0xe7, 0xf9, 0xd6, 0x56, 0xbc, 0xf7, 0xb6, 0xdf, 0x18, 0xee, 0xc1, 0x27, 0x2c, 0x8d, 0xa9, 0xe3,
  0x40, 0x25, 0x17, 0x38, 0xc5, 0xff, 0x14, 0xb3, 0x5a, 0x29, 0xd0, 0x50, 0xb5, 0x47, 0x07, 0x0e,
  0x54, 0x59, 0xb9, 0xe3, 0x3a, 0xe2, 0xaf, 0x86, 0xfe, 0x37, 0x6a, 0xb7, 0x4e, 0xa4, 0xf5, 0x8a,
  0x10, 0x11, 0x60, 0x4e, 0xf2, 0xcf, 0xc6, 0x71, 0x01, 0x41, 0x40, 0x30, 0xfa, 0xaa, 0x76, 0x7b,
  0x54, 0x80, 0xce, 0xd7, 0xba, 0x2d, 0x19, 0x0b, 0x85, 0x85, 0x03, 0x7e, 0x0b, 0x1b, 0xda, 0xf3,
  0xfb, 0x91, 0x93, 0x50, 0x62, 0x5f, 0x6b, 0x26, 0xc3, 0x44, 0xfc, 0x51, 0x92, 0x7c, 0xaa, 0x39,
  0xa5, 0xc8, 0x03, 0x31, 0xad, 0x23, 0xc1, 0x36, 0xcf, 0x65, 0x52, 0x53, 0xca, 0xa7, 0xdc, 0x11,
  0x73, 0xb0, 0x77, 0xca, 0x60, 0x1f, 0xcf, 0xb7, 0x31, 0xae, 0xe3, 0x43, 0xdc, 0x5e, 0x2a, 0x92,
  0xe2, 0x30, 0xc5, 0x98, 0xf4, 0x3e, 0x3b, 0x93, 0xa7, 0xfe, 0x95, 0xbd, 0x1a, 0x60, 0x4d, 0x8e,
  0x68, 0x10, 0x61, 0x3b, 0xa0, 0x1e, 0xf0, 0x7a, 0x5a, 0xb2, 0x63, 0x20, 0xe8, 0x79, 0x1d, 0x7f,
  0x5f, 0x09, 0xc8, 0xa2, 0xa7, 0x42, 0x7b, 0xc6, 0xa8, 0x34, 0x22, 0x3e, 0x1e, 0x29, 0x16, 0xff,
  0xb1, 0xc2, 0x81, 0x07, 0xef, 0x9a, 0x7d, 0x6b, 0xbd, 0x9b, 0xa9, 0x46, 0x54, 0x43, 0xb1, 0x9c,
  0xd1, 0xef, 0xd1, 0xbe, 0x50, 0xb3, 0xab, 0x75, 0xc2, 0x50, 0xb5, 0x7a, 0xc9, 0xc3, 0x44, 0xec,
  0x49, 0x1f, 0x58, 0x84, 0xdb, 0xba, 0x60, 0xf4, 0x77, 0x18, 0xe7, 0xd0, 0x15, 0xe5, 0x1c, 0x70,
  0x82, 0xd7, 0xd5, 0x1a, 0x62, 0x85, 0xd9, 0xd3, 0x3f, 0xaa, 0x47, 0xaa, 0x9a, 0x70, 0x58, 0x70,
  0x2e, 0x69, 0xa0, 0x01, 0xbc, 0x1f, 0x66, 0xec, 0x77, 0x56, 0x40, 0x4f, 0x3d, 0xc6, 0xd0, 0xc4,
  0xbd, 0x48, 0x02, 0x7d, 0x3a, 0x8b, 0xf0, 0x1b, 0xad, 0x6b, 0x8a, 0x8a, 0x22, 0xaa, 0x3f, 0x5d,
  0x41, 0xe2, 0x96, 0x3d, 0x26, 0x6f, 0x97, 0xa7, 0x38, 0x11, 0x4e, 0xdf, 0xcf, 0x75, 0x42, 0x84,
  0xc6, 0x82, 0x01, 0xd4, 0xa1, 0xa3, 0xd3, 0xc9, 0x1d, 0xc2, 0x80, 0xcb, 0xf8, 0xbc, 0xb0, 0x3f,
  0x77, 0xff, 0xa9, 0x86, 0xe4, 0xba, 0x5f, 0x5c, 0x8d, 0x3d, 0xd8, 0xcf, 0x99, 0xbe, 0x73, 0x44,
  0x45, 0x5c, 0x43, 0x21, 0x0a, 0x3b, 0x32, 0xd4, 0xa7, 0x6a, 0x9e, 0xab, 0x4b, 0x3f, 0x93, 0x69,
  0xd2, 0xf6, 0xd9, 0xa1, 0x59, 0x4d, 0x23, 0x79, 0xc8, 0x6e, 0xae, 0xbb, 0x5f, 0x1a, 0x8d, 0x82,
  0x9b, 0xd7, 0x94, 0xc4, 0x52, 0xa9, 0x5b, 0xc5, 0xfb, 0x84, 0x92, 0xe4, 0x47, 0x00, 0x56, 0xb9,
  0xe5, 0x98, 0xc3, 0xf8, 0x96, 0xb6, 0x08, 0x34, 0x83, 0x42, 0x6c, 0xef, 0x90, 0x09, 0x87, 0xa3,
  0x1a, 0xa0, 0x65, 0xb1, 0x8c, 0x36, 0x60, 0xa5, 0x3b, 0x47, 0x70, 0x70, 0x05, 0xe3, 0x31, 0x9b,
  0x68, 0x6b, 0xd7, 0x63, 0xc2, 0x08, 0x5a, 0x71, 0xa1, 0x4c, 0x08, 0xfe, 0xd9, 0x4b, 0x2b, 0xf1,
  0x58, 0x23, 0xb8, 0x4d, 0xbb, 0x23, 0x9e, 0x71, 0x41, 0x8b, 0x6a, 0x04, 0x2e, 0x23, 0xdc, 0xb5,
  0xa2, 0x9e, 0xdb, 0x96, 0x74, 0x3d, 0xbc, 0xec, 0x2e, 0x10, 0xb9, 0x45, 0x56, 0x2b, 0x20, 0x64,
  0x69, 0x48, 0xe9, 0xa4, 0xc4, 0x3c, 0xda, 0x93, 0x12, 0xd7, 0x78, 0x18, 0xc1, 0xf8, 0xd4, 0xf8,
  0x8c, 0xa4, 0xc2, 0xa9, 0xe5, 0x26, 0x47, 0x18, 0xc4, 0x34, 0xc7, 0xee, 0x83, 0x61, 0x31, 0xf4,
  0xc4, 0x45, 0x59, 0xa6, 0x82, 0x0c, 0x77, 0x5d, 0xec, 0x4e, 0x05, 0x2b, 0x67, 0x0f, 0xf5, 0x45,
  0xc1, 0x90, 0xae, 0x14, 0x4e, 0x2f, 0xd0, 0xb8, 0x24, 0xcc, 0xa0, 0x3c, 0xa0, 0x4c, 0x49, 0xb3,
  0xa1, 0x01, 0x0f, 0xc3, 0xf9, 0xbe, 0xec, 0x7f, 0xb1, 0x5e, 0xaa, 0x95, 0x65, 0x45, 0x3e, 0x78,
  0xb9, 0xba, 0x79, 0xfb, 0x7d, 0xe0, 0xf7, 0xf0, 0x12, 0x84, 0x1b, 0xdf, 0xb9, 0x4f, 0x10, 0x83,
  0x32, 0x9d, 0x79, 0xca, 0x49, 0xf0, 0xeb, 0xb7, 0x68, 0x4a, 0x25, 0x11, 0xdc, 0x33, 0x61, 0xec,
  0x2a, 0x72, 0x62, 0x76, 0x62, 0xc5, 0xbc, 0x56, 0xa7, 0x9e, 0xe2, 0xa5, 0xcc, 0x63, 0x8d, 0xd1,
  0xf8, 0x51, 0x8a, 0x2c, 0xc9, 0xb6, 0x07, 0xaa, 0x71, 0x24, 0x51, 0x54, 0x9f, 0xdf, 0x42, 0x2b,
  0x8a, 0xe6, 0x98, 0xc8, 0xde, 0xdd, 0xb1, 0x21, 0x93, 0xd2, 0x42, 0x7b, 0xcd, 0x53, 0x55, 0x8d,
  0x7d, 0x6a, 0x4c, 0x8c, 0x9f, 0x5c, 0xd1, 0x64, 0x19, 0x70, 0x11, 0x4b, 0x72, 0x1e, 0xca, 0xb7,
  0xdc, 0x47, 0xed, 0xc8, 0x33, 0xe0, 0x73, 0x49, 0x28, 0xe3, 0xf4, 0xcc, 0x1e, 0xde, 0x9d, 0xec,
  0x08, 0x49, 0xef, 0xd9, 0xae, 0x7a, 0x61, 0xb2, 0x74, 0x0e, 0xec, 0x76, 0xb1, 0x6c, 0x17, 0x67,
  0x1d, 0x34, 0x66, 0x6d, 0xb7, 0x1e, 0x7e, 0x3b, 0xf0, 0xd1, 0xe2, 0x05, 0x7c, 0xe1, 0x50, 0x9f,
  0xea, 0x32, 0xdf, 0x5a, 0xba, 0xc7, 0x46, 0xf5, 0x56, 0xe1, 0xc0, 0x39, 0x77, 0x57, 0x3d, 0xa9,
  0xce, 0xa0, 0x91, 0xcf, 0xe6, 0xe6, 0x15, 0xc8, 0xe6, 0x8e, 0x4a, 0xa8, 0x1f, 0x37, 0x89, 0x2c,
  0x7c, 0xd3, 0xb9, 0xc6, 0xc9, 0xb5, 0x59, 0xee, 0x69, 0x10, 0x0e, 0x43, 0xfe, 0xda, 0x90, 0x9f,
  0x0c, 0x51, 0x33, 0x47, 0x56, 0xc4, 0xa0, 0x8c, 0x2f, 0x48, 0xdf, 0x23, 0xa4, 0x9e, 0x77, 0x49,
  0xa3, 0x8d, 0x16, 0x99, 0xcb, 0x07, 0x2f, 0x2e, 0x2e, 0x9e, 0x53, 0x9a, 0xa3, 0x05, 0x0b, 0x81,
  0xf3, 0x48, 0x02, 0x6e, 0x4c, 0xec, 0xf1, 0xe6, 0x9a, 0xc2, 0x52, 0x72, 0x2e, 0x47, 0x28, 0x8f
};

static uint8_t test6144_ss[768] = {
  0x87, 0xf9, 0xad, 0xfa, 0xcc, 0x5a, 0xc1, 0x08, 0x44, 0xbe, 0xba, 0x58, 0x19, 0x11, 0xb0, 0x0d,
  0xf5, 0x8c, 0x1e, 0x2d, 0xb9, 0x1a, 0x76, 0x18, 0xa6, 0xf3, 0x9c, 0xaf, 0xaf, 0x9d, 0x01, 0x62,
  0xa4, 0xe1, 0x42, 0xfd, 0xcd, 0x8d, 0x1d, 0x28, 0xe8, 0x75, 0xd1, 0xcb, 0xea, 0x67, 0x42, 0x5e,
  0xb5, 0xbe, 0xe1, 0x48, 0x9b, 0xfa, 0x69, 0xe3, 0x48, 0x77, 0x62, 0x1a, 0x48, 0xa6, 0x3c, 0xf3,
  0x03, 0x98, 0xfd, 0x98, 0xb4, 0x47, 0x94, 0xd6, 0x40, 0xf5, 0xf5, 0x59, 0xcc, 0x87, 0x7d, 0xb8,
  0x36, 0x3d, 0xa9, 0x1f, 0xa2, 0x69, 0x8b, 0x25, 0x55, 0xa5, 0x14, 0x1c, 0x56, 0x16, 0x43, 0xf4,
  0x52, 0x81, 0xb5, 0x72, 0xfb, 0xe4, 0xe3, 0xb1, 0x34, 0x5b, 0xe1, 0x68, 0xa2, 0xfe, 0x43, 0xb2,
  0xbf, 0x55, 0xab, 0x2a, 0x4a, 0x75, 0xd6, 0xe8, 0x0d, 0x56, 0x3a, 0xb6, 0x49, 0xa2, 0xce, 0x36,
  0x53, 0x6b, 0x4f, 0x27, 0xeb, 0x2e, 0xc6, 0x09, 0x90, 0x9a, 0xd2, 0x96, 0x0b, 0xb2, 0xc8, 0xd8,
  0xf2, 0xfc, 0x8b, 0x41, 0x5e, 0x83, 0xd0, 0x1d, 0x09, 0xf8, 0x4f, 0xb8, 0x49, 0x8c, 0x31, 0xcb,
  0xfe, 0x22, 0xae, 0x31, 0x36, 0x2d, 0xc4, 0x11, 0xb2, 0x03, 0x6f, 0x53, 0x96, 0x68, 0x61, 0x5e,
  0xa7, 0xb7, 0xb2, 0x57, 0x2f, 0x20, 0x00, 0x4e, 0x7c, 0x71, 0xfc, 0xea, 0xd9, 0x3e, 0xd6, 0x4b,
  0x72, 0x8d, 0xfc, 0x51, 0x1e, 0xd8, 0xf8, 0x09, 0x90, 0x35, 0xb8, 0xbc, 0x7d, 0xe4, 0xd6, 0xc4,
  0x83, 0x2f, 0x18, 0x82, 0xc4, 0xec, 0xea, 0x45, 0x75, 0x5c, 0xbf, 0x9c, 0x0a, 0x87, 0xe4, 0x09,
  0x47, 0x87, 0x10, 0xd8, 0x8c, 0x0e, 0x3f, 0xa5, 0x95, 0xc2, 0x89, 0x2f, 0xa9, 0x95, 0x20, 0x91,
  0x7e, 0x00, 0x3c, 0x5f, 0xce, 0xc4, 0x27, 0x8c, 0xd0, 0xde, 0x3c, 0xe8, 0xca, 0x33, 0x72, 0x95,
  0x5a, 0x52, 0x92, 0x2b, 0x7b, 0xcc, 0xa4, 0xc7, 0x27, 0x96, 0xc5, 0xed, 0x33, 0xa0, 0x09, 0x99,
  0x6e, 0x91, 0x28, 0xee, 0x53, 0x56, 0x11, 0xfc, 0xf4, 0x6b, 0xcc, 0x30, 0x6e, 0x1d, 0xb7, 0x3f,
  0x57, 0x00, 0x9c, 0xe1, 0x15, 0x1c, 0xb8, 0x96, 0xd7, 0xff, 0x5d, 0x46, 0x7e, 0x81, 0x17, 0x86,
  0x31, 0x8c, 0xd5, 0xd8, 0xf9, 0x20, 0x12, 0x5e, 0x74, 0x0f, 0xd8, 0x9f, 0x28, 0xe4, 0x9e, 0xe8,
  0xc3, 0xd8, 0x40, 0x34, 0xd8, 0x61, 0x7e, 0x19, 0xc5, 0x5d, 0x0d, 0x88, 0x69, 0xd9, 0x7b, 0x7e,
  0xe1, 0xea, 0x52, 0x74, 0x67, 0xc9, 0xfc, 0xa3, 0x57, 0xfb, 0x7f, 0xde, 0xe2, 0xb0, 0x71, 0xb4,
  0x15, 0x62, 0xb0, 0xa4, 0x90, 0x70, 0x30, 0x85, 0xc9, 0x33, 0xea, 0x88, 0x5d, 0x45, 0x6d, 0xe6,
  0x6e, 0xa2, 0x39, 0x77, 0x84, 0x2a, 0x32, 0xf0, 0xe1, 0x10, 0xe3, 0xee, 0x3c, 0x80, 0x83, 0x63,
  0xce, 0xb9, 0xdf, 0x07, 0x86, 0xd1, 0x40, 0xdd, 0x99, 0x32, 0xbe, 0x6e, 0xa4, 0xeb, 0xf7, 0xf9,
  0x52, 0x33, 0x01, 0xe4, 0xc2, 0x9f, 0x7d, 0x36, 0xc7, 0x32, 0x70, 0xb4, 0xfc, 0x92, 0x1e, 0xc3,
  0x82, 0x47, 0xc2, 0x47, 0x1e, 0x82, 0x7e, 0xb9, 0x25, 0x9d, 0xee, 0x68, 0xbb, 0x2a, 0x2c, 0xc4,
  0xd0, 0xa5, 0x29, 0x3e, 0x90, 0x4d, 0x92, 0x7e, 0x4c, 0xe2, 0x2e, 0xe6, 0xde, 0xbc, 0xb5, 0x70,
  0x12, 0x99, 0x03, 0xc4, 0x7e, 0x01, 0x72, 0x74, 0x9f, 0xf3, 0x35, 0xe4, 0x71, 0x6b, 0x04, 0xb4,
  0xa3, 0xf6, 0xeb, 0x29, 0x74, 0x07, 0xe2, 0x34, 0xab, 0x7a, 0x50, 0x78, 0x20, 0x49, 0xbb, 0x70,
  0x60, 0x5c, 0x5e, 0xba, 0x3a, 0x57, 0x1f, 0xff, 0xf5, 0x31, 0x9e, 0x61, 0x27, 0x29, 0xfa, 0x56,
  0xd1, 0x0e, 0xb9, 0x77, 0x5c, 0x44, 0x9d, 0x2b, 0xdd, 0xa5, 0x0f, 0xef, 0x26, 0x8a, 0xeb, 0xb9,
  0x03, 0x50, 0x99, 0x41, 0x42, 0xa2, 0x5c, 0x49, 0x72, 0xfe, 0x9f, 0xdc, 0xd1, 0x77, 0x71, 0x19,
  0x5b, 0x8e, 0xf6, 0xb9, 0x78, 0xd9, 0xb5, 0xaf, 0xba, 0x91, 0x50, 0xc5, 0xc9, 0x1f, 0x27, 0xd9,
  0x8a, 0x7f, 0x50, 0x16, 0x5e, 0x81, 0xcc, 0x3e, 0xf6, 0x90, 0x1d, 0x6a, 0x78, 0xb9, 0xcd, 0xe7,
  0x44, 0xdf, 0xd9, 0x37, 0x69, 0x78, 0x98, 0x91, 0xe8, 0x16, 0x02, 0xef, 0x73, 0x6e, 0xd5, 0x96,
  0x72, 0x45, 0xf9, 0xa4, 0xce, 0xff, 0x34, 0x12, 0xb3, 0x75, 0x06, 0xcb, 0x1e, 0xe2, 0x2c, 0xb6,
  0x12, 0xbc, 0xbf, 0xbb, 0x2a, 0xad, 0x60, 0xcb, 0x15, 0x2c, 0x97, 0xf2, 0x83, 0x69, 0xc6, 0x7c,
  0x4c, 0xe3, 0x2f, 0x48, 0x63, 0x40, 0x9a, 0xd5, 0x8b, 0xa3, 0x5e, 0x10, 0xae, 0x2b, 0x42, 0x54,
  0x38, 0xb4, 0x75, 0x30, 0xe7, 0x1d, 0x89, 0x9f, 0x74, 0x84, 0x58, 0xbf, 0x95, 0x7f, 0xd3, 0x7b,
  0xb8, 0xc7, 0x22, 0xa3, 0x39, 0xea, 0xa6, 0xb3, 0xab, 0x22, 0x71, 0xcc, 0xc9, 0xfc, 0xe6, 0x07,
  0x5d, 0xf0, 0x73, 0x7c, 0x18, 0x7a, 0x97, 0x2d, 0x5a, 0x3d, 0xf7, 0xcf, 0x86, 0x84, 0x02, 0x66,
  0xfb, 0xb7, 0x74, 0xa7, 0x4e, 0x8e, 0x27, 0x0d, 0xf0, 0x4e, 0x90, 0x09, 0xfb, 0x8d, 0x0d, 0x4c,
  0x3a, 0xd5, 0x56, 0x40, 0xfb, 0x21, 0xb1, 0x6e, 0x78, 0x11, 0x5b, 0x94, 0xf9, 0x9e, 0xcf, 0xae,
  0x35, 0x34, 0xa2, 0xe9, 0xe4, 0x39, 0xd6, 0x71, 0x0c, 0x19, 0x83, 0x65, 0x53, 0x17, 0x5f, 0xfc,
  0x81, 0xf8, 0x9d, 0xeb, 0xe3, 0x57, 0xf4, 0x07, 0xf4, 0xcc, 0x1f, 0x0f, 0x50, 0xb7, 0x9e, 0x3e,
  0x42, 0x00, 0xc7, 0xb6, 0x7f, 0x68, 0xd9, 0x2c, 0x23, 0x4e, 0xe6, 0xe1, 0xb3, 0x9e, 0xfe, 0xe0,
  0x7e, 0xda, 0x55, 0x89, 0xbe, 0x17, 0x0d, 0x24, 0x96, 0xfa, 0xe8, 0x6e, 0x2b, 0xb3, 0xb6, 0x03
};

static uint8_t test8192_sk1[1024] = {
  0x73, 0x9d, 0xeb, 0xbf, 0xef, 0x02, 0x57, 0x6e, 0xfb, 0xd4, 0x35, 0x14, 0xb3, 0xe2, 0xf6, 0x79,
  0xc8, 0xeb, 0x0f, 0x05, 0xd8, 0x5f, 0x0f, 0x4a, 0x68, 0xdd, 0xbf, 0xf5, 0xc7, 0xcb, 0xac, 0x16,
  0x6c, 0xbf, 0x9f, 0x6f, 0x50, 0x37, 0xcb, 0x53, 0xb5, 0x5b, 0xc0, 0xb5, 0x9b, 0x49, 0xd0, 0xbe,
  0xca, 0xbe, 0x23, 0xca, 0x13, 0xde, 0x73, 0xda, 0x1e, 0x96, 0x83, 0xb5, 0xf8, 0x6c, 0x18, 0x9c,
  0x48, 0xd5, 0xe4, 0x86, 0x47, 0x20, 0xb5, 0x06, 0xed, 0x14, 0x38, 0x09, 0xd5, 0x65, 0xd7, 0x38,
  0x0f, 0x3e, 0x61, 0x1a, 0x0e, 0xc8, 0xa7, 0x5b, 0xaf, 0x11, 0xdb, 0x0b, 0xc2, 0x2b, 0xfe, 0xcd,
  0xc1, 0x1b, 0x66, 0xb0, 0xf2, 0x68, 0x9f, 0x4a, 0xae, 0xea, 0xa1, 0xfe, 0x9c, 0xcb, 0x55, 0xa9,
  0xa2, 0x71, 0xe3, 0xb1, 0x5f, 0xd3, 0x75, 0x0d, 0x20, 0x00, 0x64, 0x53, 0xf5, 0x82, 0x1c, 0x40,
  0x55, 0x24, 0x7f, 0x1d, 0x80, 0xd6, 0x2f, 0x21, 0xed, 0x61, 0x5f, 0x4f, 0x1d, 0xa2, 0xb0, 0xfa,
  0xbb, 0x70, 0x9a, 0x2f, 0xb5, 0x41, 0xb0, 0xc2, 0x8d, 0x84, 0xe5, 0x3a, 0x62, 0x0d, 0xb3, 0x62,
  0x66, 0xa7, 0x0d, 0xd1, 0xbe, 0x36, 0x28, 0x35, 0x03, 0x2f, 0x56, 0x57, 0x8f, 0x21, 0xea, 0x2a,
  0xc6, 0x0e, 0xa2, 0xea, 0x4f, 0xe4, 0xc2, 0xb2, 0x34, 0xeb, 0x91, 0x81, 0x45, 0xc0, 0x56, 0x46,
  0xc8, 0x88, 0x8f, 0x32, 0x75, 0xb0, 0x4d, 0x17, 0x3f, 0xf1, 0x05, 0x97, 0x9b, 0xa0, 0xa0, 0x8a,
  0x75, 0xd2, 0xe4, 0xaf, 0xac, 0x01, 0x51, 0x65, 0x09, 0x7e, 0xa0, 0x95, 0x2d, 0x5b, 0x67, 0xcc,
  0xf2, 0x4f, 0x0e, 0xe4, 0xc5, 0x31, 0x24, 0xca, 0x10, 0xbe, 0x17, 0xa5, 0xc7, 0x2a, 0x55, 0x25,
  0x06, 0x28, 0xac, 0x09, 0xf2, 0x20, 0x95, 0xbb, 0x55, 0xff, 0x43, 0x3e, 0x5e, 0xf2, 0x53, 0x87,
  0x9b, 0x34, 0x9c, 0x95, 0x1d, 0x16, 0x7d, 0xa5, 0x58, 0x5b, 0xf8, 0xec, 0x0d, 0xcf, 0xbb, 0x6c,
  0x88, 0x19, 0xe7, 0xb2, 0xd5, 0xc6, 0x27, 0x4e, 0xb2, 0xac, 0x73, 0x5f, 0x6e, 0xc1, 0x67, 0xe0,
  0x76, 0x7f, 0x43, 0x93, 0x6a, 0xeb, 0xce, 0xb1, 0xf9, 0x31, 0x1c, 0xf0, 0xc3, 0x0b, 0xf0, 0xa7,
  0x80, 0xf3, 0xf8, 0xea, 0x5d, 0x3f, 0xce, 0x40, 0x62, 0xae, 0xde, 0xf8, 0x71, 0xb2, 0xf6, 0x3e,
  0xa2, 0xab, 0x67, 0xd8, 0x01, 0x72, 0x18, 0xfb, 0xa1, 0xc8, 0x6a, 0x83, 0xab, 0xb2, 0xdc, 0x8c,
  0xe5, 0xb8, 0xe4, 0x66, 0x92, 0x00, 0x0c, 0x66, 0x4f, 0xb0, 0x3d, 0xdc, 0xdb, 0x89, 0xb0, 0x16,
  0xa3, 0x05, 0x70, 0x23, 0x03, 0x3b, 0x36, 0x97, 0x30, 0xdf, 0x28, 0x28, 0x7b, 0x85, 0x83, 0x89,
  0x67, 0x2b, 0x9e, 0x48, 0x42, 0x15, 0x11, 0x1c, 0xf6, 0x47, 0x5d, 0xe8, 0xbe, 0xf6, 0x76, 0x50,
  0x26, 0x55, 0x24, 0x37, 0x52, 0x56, 0x48, 0xf6, 0xd7, 0x87, 0x4b, 0xd8, 0xd0, 0xe1, 0x61, 0xcf,
  0xfc, 0xef, 0xad, 0x40, 0xf8, 0x8c, 0xe7, 0xc1, 0x89, 0xfa, 0x4e, 0x57, 0x64, 0x75, 0xe4, 0x4b,
  0x19, 0xea, 0xfe, 0x22, 0x58, 0x42, 0x80, 0xb2, 0xc7, 0xcb, 0x44, 0x27, 0xbf, 0x28, 0x18, 0xfb,
  0x25, 0x68, 0x6f, 0x07, 0xfa, 0xa7, 0x23, 0xf1, 0xe8, 0x71, 0x59, 0x6e, 0xef, 0xff, 0xbf, 0x1b,
  0x53, 0x7c, 0x2c, 0x4a, 0xe5, 0xd4, 0x18, 0x7d, 0x11, 0x5f, 0x7b, 0xf4, 0x9f, 0x7b, 0xf8, 0x2a,
  0x3e, 0x5e, 0x12, 0xa8, 0x38, 0x97, 0x7d, 0x28, 0x58, 0x81, 0xe1, 0xd9, 0x7c, 0x52, 0xfc, 0xd9,
  0x1e, 0xb0, 0xf6, 0xc5, 0x42, 0xad, 0xf5, 0xf9, 0xda, 0x6d, 0xfd, 0xb1, 0x33, 0x46, 0x08, 0xd7,
  0x46, 0x58, 0x8d, 0xe1, 0x6b, 0x51, 0x06, 0x45, 0x38, 0x7e, 0x4b, 0x30, 0x52, 0xf6, 0x9a, 0x06,
  0xe8, 0x3a, 0x93, 0x8e, 0xda, 0xad, 0x95, 0x01, 0x90, 0x7b, 0xbe, 0xae, 0x7e, 0x67, 0xec, 0xb3,
  0xa5, 0x2d, 0x11, 0x22, 0x86, 0x50, 0xf7, 0x0e, 0xe6, 0x76, 0x20, 0x62, 0x68, 0x73, 0x24, 0x19,
  0xca, 0xa6, 0xef, 0x24, 0xa9, 0xab, 0x56, 0x64, 0xa2, 0xb1, 0x6c, 0xcc, 0x2e, 0xae, 0x54, 0xce,
  0x74, 0xf6, 0x93, 0xee, 0xe9, 0xef, 0x3c, 0xa8, 0xd0, 0x90, 0xa0, 0xca, 0x7d, 0x01, 0xe3, 0x84,
  0x64, 0xa0, 0x73, 0xce, 0xbb, 0x6e, 0x4b, 0xa8, 0x6a, 0x2e, 0x91, 0x12, 0x6d, 0xff, 0x95, 0xd9,
  0xe0, 0x6e, 0x80, 0xb9, 0x27, 0x0c, 0x98, 0xe9, 0xf3, 0x2c, 0x45, 0xc8, 0xf5, 0xd8, 0x95, 0xba,
  0xee, 0x1f, 0x23, 0xcc, 0x66, 0xf7, 0xeb, 0x6f, 0x96, 0xf8, 0x23, 0x7b, 0x3a, 0xac, 0xa1, 0x6e,
  0xfd, 0x24, 0x9d, 0x83, 0x5d, 0x2d, 0x04, 0x28, 0x84, 0x42, 0x2d, 0x72, 0xbe, 0xfb, 0x95, 0x0e,
  0x7e, 0x1d, 0x66, 0xb2, 0xac, 0xd8, 0x1c, 0x04, 0x14, 0xd9, 0xcd, 0x42, 0x4e, 0xca, 0xd6, 0xdf,
  0x86, 0x1d, 0x47, 0x13, 0x3b, 0x43, 0xbb, 0x53, 0x8c, 0x43, 0xcf, 0x79, 0xf7, 0xad, 0xcd, 0xe6,
  0x2d, 0xc4, 0x3d, 0x2c, 0x39, 0x73, 0xf5, 0xec, 0x97, 0xf4, 0x2c, 0x55, 0xfa, 0xb7, 0xfb, 0x45,
  0x3b, 0xfc, 0x0e, 0x41, 0x87, 0x45, 0x4f, 0xdd, 0x8c, 0xe2, 0xbc, 0x24, 0xf1, 0x0a, 0x7b, 0xa4,
  0x3e, 0x3d, 0x34, 0xc3, 0xbd, 0xd2, 0x77, 0x68, 0x6a, 0xe3, 0xac, 0xef, 0x0a, 0xa8, 0xd2, 0x0d,
  0x27, 0xd1, 0xa2, 0xd5, 0xa6, 0x31, 0xc6, 0x37, 0x99, 0x73, 0x22, 0x49, 0xb4, 0x1f, 0xcf, 0x1c,
  0x3f, 0x91, 0xbe, 0x67, 0x19, 0x96, 0x7f, 0xe1, 0xb7, 0x35, 0x66, 0x1f, 0x02, 0x85, 0xab, 0x85,
  0xdd, 0x5a, 0x11, 0x48, 0x66, 0x3e, 0xe2, 0x33, 0xfa, 0xfa, 0xdc, 0xf4, 0x3c, 0xc8, 0xf9, 0xaa,
  0x52, 0xd8, 0xd9, 0xc1, 0x5a, 0xce, 0xab, 0xb2, 0x34, 0x99, 0x65, 0x05, 0xcf, 0x21, 0x41, 0x51,
  0x7c, 0x28, 0x44, 0x69, 0xd0, 0x15, 0x0e, 0x45, 0x8a, 0xde, 0x5b, 0xb0, 0xd8, 0xac, 0xde, 0x07,
  0xca, 0xd8, 0x2e, 0x17, 0xc1, 0xa6, 0x38, 0x52, 0x94, 0xf4, 0xa5, 0xdc, 0xe9, 0x8f, 0x30, 0xcc,
  0x80, 0x4d, 0x09, 0x2c, 0x3f, 0x0f, 0xd5, 0xc3, 0x99, 0x15, 0x61, 0xa4, 0x29, 0xf1, 0x72, 0x9a,
  0xa9, 0xd0, 0xe7, 0x4e, 0x22, 0x0a, 0x24, 0x6a, 0x31, 0x5f, 0xd8, 0xa9, 0xc3, 0xad, 0x26, 0xae,
  0x08, 0xd0, 0x87, 0xa5, 0x7f, 0xac, 0xc0, 0x7c, 0x08, 0xd5, 0xaf, 0x7b, 0x1d, 0x6d, 0xfa, 0xe0,
  0xae, 0x2b, 0x0b, 0x5b, 0x7d, 0x07, 0x9d, 0xc9, 0x23, 0xb4, 0xbc, 0x13, 0xa3, 0xee, 0x4f, 0x7b,
  0x58, 0xae, 0x21, 0x10, 0x0d, 0x9c, 0x2f, 0xf0, 0x2b, 0x5c, 0x25, 0x9c, 0xd3, 0xb3, 0xcd, 0x4a,
  0x56, 0x21, 0x12, 0x9f, 0x8a, 0x44, 0x02, 0xf0, 0x93, 0x7c, 0x7d, 0xa8, 0x14, 0xd9, 0x11, 0x20,
  0xd3, 0xe5, 0x96, 0xa0, 0xb5, 0x03, 0xa1, 0x2b, 0x84, 0xe8, 0xa4, 0xc2, 0x8b, 0x0e, 0xc7, 0x93,
  0x6b, 0xce, 0x8f, 0x85, 0x29, 0x14, 0xb1, 0x4a, 0xf6, 0xbb, 0x2d, 0x5b, 0x14, 0x67, 0x6f, 0x28,
  0x48, 0xb2, 0x48, 0xd1, 0x5b, 0x08, 0xd7, 0x31, 0xe8, 0xcd, 0xb4, 0xcc, 0x45, 0x45, 0x9c, 0x70,
  0x41, 0x4b, 0x81, 0x57, 0x2b, 0x07, 0x00, 0x16, 0x53, 0xb9, 0xc5, 0xc7, 0xcd, 0x9f, 0x31, 0xc7,
  0xb3, 0x78, 0xc1, 0x96, 0x6c, 0x41, 0xd0, 0xf9, 0xdc, 0x68, 0xbf, 0x58, 0x4c, 0xc2, 0x30, 0x9a,
  0x5e, 0x96, 0xd8, 0x83, 0x57, 0x7e, 0x9d, 0xbf, 0xe9, 0xe0, 0x14, 0xa4, 0xe7, 0x09, 0x81, 0x4e,
  0x55, 0x5b, 0x3e, 0x62, 0x82, 0x87, 0x13, 0x5f, 0x79, 0xd1, 0x3a, 0x98, 0x3f, 0x9e, 0x02, 0x6a
};

static uint8_t test8192_pk1[1024] = {
  0x0d, 0xa1, 0xc7, 0x7b, 0x86, 0x93, 0xa3, 0xa5, 0xb5, 0x00, 0x0a, 0x52, 0xd4, 0x87, 0xd4, 0xd3,
  0xd9, 0x30, 0xc7, 0xe5, 0x70, 0xb3, 0x14, 0xaa, 0xfa, 0xf2, 0xce, 0xda, 0x92, 0xc0, 0x2a, 0xfe,
  0xd1, 0xfc, 0x5b, 0xda, 0xb9, 0x9b, 0xbe, 0x0a, 0xba, 0x4e, 0x78, 0xc1, 0x2e, 0x2f, 0x45, 0x82,
  0x2c, 0xa1, 0x7b, 0x05, 0x8b, 0xcf, 0x5d, 0xbc, 0x14, 0xe6, 0x11, 0x7e, 0x18, 0x48, 0x21, 0x62,
  0x36, 0x30, 0x5a, 0x5d, 0xc4, 0x34, 0x53, 0x5d, 0x97, 0xd7, 0xd9, 0x55, 0x65, 0xb3, 0xe7, 0xde,
  0xe9, 0x9d, 0x1e, 0x16, 0x57, 0x11, 0xae, 0x54, 0x81, 0x57, 0x9a, 0x7e, 0x10, 0x75, 0x7c, 0xd9,
  0x60, 0xa1, 0x2c, 0xfc, 0x57, 0x5c, 0xf1, 0xca, 0xfa, 0xd8, 0x8f, 0xfd, 0x3e, 0xed, 0x8e, 0x2f,
  0xa1, 0x6c, 0x81, 0x2b, 0x9f, 0xf4, 0xdb, 0x55, 0x5a, 0x66, 0x8b, 0xde, 0xc1, 0x18, 0xe2, 0x8f,
  0xcf, 0x75, 0xd9, 0xd5, 0xb4, 0x4c, 0x0b, 0x9e, 0xfd, 0x1c, 0x66, 0xa3, 0x10, 0x64, 0xf1, 0x53,
  0xfd, 0x86, 0xf7, 0x9d, 0x15, 0xc4, 0x51, 0xaf, 0x60, 0x49, 0x03, 0x1e, 0x54, 0x03, 0x9f, 0x48,
  0x9e, 0x0f, 0x84, 0x6c, 0x22, 0xe2, 0x4f, 0xff, 0x7f, 0xec, 0x3c, 0xc7, 0x06, 0x8c, 0x1b, 0xc5,
  0xbf, 0x62, 0x9c, 0xcd, 0xf6, 0xb0, 0x38, 0x9f, 0x8c, 0x61, 0x58, 0xe6, 0x9a, 0x24, 0x69, 0xa5,
  0x51, 0xa4, 0x23, 0xb0, 0xe3, 0xc8, 0xc1, 0x01, 0x9b, 0x4e, 0xec, 0xb6, 0xa3, 0xc7, 0x24, 0xba,
  0x8d, 0x89, 0x1b, 0xf4, 0xfa, 0xe8, 0x16, 0x64, 0x27, 0x85, 0xdd, 0x51, 0xbe, 0x57, 0xf0, 0x95,
  0xed, 0x67, 0x83, 0x09, 0x6e, 0x41, 0x76, 0xdd, 0x9b, 0x99, 0x21, 0xc2, 0x17, 0x43, 0xc1, 0x75,
  0xa2, 0xcd, 0x7d, 0x35, 0x43, 0xac, 0xff, 0x55, 0xff, 0x12, 0xbf, 0xaa, 0x83, 0x44, 0x33, 0x91,
  0x4c, 0x97, 0x83, 0x63, 0x6b, 0x17, 0xa0, 0x5a, 0x2c, 0x7a, 0x26, 0x6b, 0x4b, 0xb0, 0x5f, 0x3b,
  0x90, 0x4b, 0x77, 0xa8, 0xe0, 0xfd, 0xa4, 0x1a, 0x1a, 0x5b, 0x57, 0xf0, 0x19, 0x29, 0xf1, 0x8e,
  0xec, 0x78, 0x34, 0x25, 0x7a, 0xe1, 0xf5, 0x64, 0x07, 0x2e, 0xd9, 0xf2, 0xba, 0xda, 0x1b, 0xd8,
  0x60, 0x18, 0x80, 0xa6, 0x93, 0x23, 0xd3, 0x75, 0x2f, 0xc5, 0xc0, 0x75, 0x52, 0x14, 0x75, 0x47,
  0x83, 0xf6, 0x7e, 0xbb, 0xbf, 0x86, 0x4e, 0x4a, 0xff, 0x73, 0x7c, 0x6e, 0xda, 0x3c, 0x0e, 0xdc,
  0x07, 0x2d, 0x8c, 0x73, 0x28, 0x44, 0x2c, 0x15, 0x18, 0x72, 0x3a, 0x4d, 0x4b, 0xc0, 0x00, 0xd1,
  0x2e, 0x84, 0x09, 0x83, 0x23, 0xe1, 0x2c, 0xa5, 0x22, 0xf3, 0xfe, 0x23, 0x51, 0x74, 0xb7, 0x90,
  0xf3, 0x9d, 0x7f, 0x67, 0xe2, 0xf6, 0x01, 0xba, 0xaa, 0xd3, 0x1b, 0xa7, 0x3d, 0x7a, 0xce, 0x97,
  0x02, 0xc5, 0x50, 0xa0, 0xb2, 0xe5, 0xfe, 0x6e, 0xbe, 0xdc, 0x0e, 0x5d, 0x75, 0x88, 0xb5, 0xe5,
  0xa4, 0x04, 0xa6, 0xc8, 0x83, 0x4a, 0x1e, 0xc7, 0x5f, 0x7d, 0xe6, 0xf1, 0x53, 0x3e, 0x0a, 0x66,
  0x7b, 0x76, 0x42, 0xef, 0x39, 0xb2, 0x5a, 0xf6, 0xf0, 0xde, 0xc7, 0xca, 0x47, 0xc5, 0x8e, 0xdf,
  0xab, 0x58, 0xd4, 0x00, 0x23, 0xb6, 0x16, 0xfd, 0x8f, 0xa7, 0x2d, 0x5f, 0x56, 0x81, 0x97, 0x4c,
  0xdf, 0x3b, 0xc3, 0x91, 0x54, 0x6e, 0xa2, 0x62, 0xcb, 0x54, 0x80, 0x02, 0xd5, 0x4e, 0xdf, 0x00,
  0x1d, 0x1c, 0xe5, 0xa9, 0xc1, 0xe9, 0x22, 0xa1, 0xe0, 0x10, 0x53, 0xdc, 0xbb, 0xf2, 0xe0, 0xd7,
  0x1b, 0xd1, 0xb0, 0x0b, 0x4c, 0x9e, 0x30, 0x77, 0x9a, 0x8e, 0xee, 0xa0, 0xf2, 0x19, 0x6d, 0x28,
  0x6b, 0x96, 0xe5, 0xe2, 0x1a, 0xa3, 0x24, 0x32, 0xbb, 0x16, 0x0b, 0xac, 0xc5, 0x2d, 0x44, 0xca,
  0x16, 0x45, 0xcd, 0x68, 0x8e, 0x1f, 0xff, 0x69, 0x7d, 0x23, 0x26, 0x6e, 0xa8, 0xaf, 0x9d, 0xe1,
  0x6d, 0x6a, 0xcc, 0xf5, 0xa2, 0xb5, 0x94, 0x0b, 0x9b, 0x3f, 0x47, 0x0d, 0x01, 0x9a, 0x87, 0x08,
  0xbe, 0x13, 0x1c, 0x8d, 0xe3, 0x6c, 0xd5, 0x41, 0x10, 0x60, 0x85, 0xf5, 0xa5, 0x5c, 0xc1, 0x7e,
  0x4b, 0xc0, 0xb2, 0x9b, 0xfd, 0x53, 0x08, 0x36, 0x25, 0xd5, 0xb9, 0xcc, 0x47, 0xcb, 0x6e, 0xa0,
  0xdd, 0xde, 0x55, 0xe0, 0xb2, 0xc7, 0x28, 0xb3, 0x7c, 0x28, 0x1a, 0xe2, 0xae, 0x5a, 0xa0, 0x3a,
  0x15, 0xf1, 0x25, 0xd0, 0x5a, 0xdd, 0xba, 0x05, 0x9b, 0x52, 0x6f, 0x3b, 0x83, 0xda, 0x7d, 0x0e,
  0x26, 0x6c, 0x1f, 0x21, 0xb6, 0x5c, 0xee, 0xe5, 0xde, 0x38, 0x3e, 0xf1, 0x49, 0xf9, 0xf7, 0x06,
  0x6c, 0xc6, 0x15, 0x87, 0x92, 0xcb, 0xd1, 0x70, 0xc5, 0xe8, 0xce, 0x41, 0x2b, 0x06, 0x57, 0x6a,
  0x30, 0xd6, 0xcd, 0x58, 0x92, 0xeb, 0x04, 0xba, 0xdb, 0x90, 0x4a, 0x04, 0x54, 0x3a, 0x15, 0xe7,
  0x50, 0x7e, 0xe1, 0x48, 0x79, 0xad, 0x6c, 0xff, 0x63, 0xe9, 0xa0, 0x09, 0x3e, 0xbf, 0xa2, 0xca,
  0xa8, 0x56, 0x63, 0x6b, 0x21, 0xdf, 0x91, 0xc0, 0xf3, 0x35, 0x1b, 0x0a, 0xaf, 0x17, 0x8b, 0x06,
  0x16, 0x53, 0x32, 0xc4, 0x85, 0x14, 0xfd, 0x8c, 0x02, 0x2c, 0xf2, 0xdb, 0xe8, 0xc5, 0x29, 0x04,
  0xbd, 0x60, 0x6b, 0x10, 0xf3, 0xad, 0x22, 0xcb, 0x5d, 0xf3, 0x04, 0xcf, 0x4d, 0x54, 0xac, 0xba,
  0x64, 0x3a, 0x24, 0x2e, 0x61, 0x80, 0x98, 0xfa, 0xf3, 0xb7, 0x3f, 0x35, 0xbc, 0x59, 0xcd, 0x77,
  0x5c, 0x11, 0x7c, 0x10, 0x09, 0x36, 0x73, 0xe5, 0x7f, 0x08, 0xb7, 0xda, 0x78, 0xae, 0xb4, 0xa4,
  0xcf, 0x02, 0xe6, 0x30, 0x3e, 0x58, 0x95, 0x89, 0xd1, 0x7d, 0x9b, 0x34, 0x71, 0x65, 0x5f, 0x6d,
  0x6e, 0x37, 0x7c, 0x04, 0xaa, 0xd9, 0x42, 0xab, 0x9e, 0x55, 0xbe, 0x75, 0x0c, 0x3c, 0x89, 0xa0,
  0x0f, 0x54, 0xf5, 0x66, 0xff, 0xc2, 0x5d, 0xf6, 0xb6, 0xf8, 0xfc, 0xde, 0xea, 0xc9, 0x29, 0x6d,
  0xf8, 0xaa, 0x72, 0x32, 0x82, 0xe8, 0x87, 0x36, 0x5a, 0x2c, 0x00, 0x92, 0xba, 0x22, 0x90, 0x62,
  0x11, 0x67, 0xdc, 0x83, 0x23, 0x67, 0xe4, 0x25, 0x8d, 0xe3, 0xc6, 0xdd, 0xd2, 0xec, 0x3c, 0xe5,
  0x20, 0xed, 0x57, 0x3b, 0x63, 0x20, 0xed, 0x0b, 0x6c, 0xdc, 0x55, 0x04, 0xeb, 0xcd, 0xbc, 0xa2,
  0xe0, 0xb0, 0xfc, 0xa2, 0xb2, 0x46, 0x47, 0xc4, 0xee, 0xda, 0xfa, 0xaf, 0x65, 0xe9, 0x3c, 0x78,
  0xdb, 0xf4, 0x52, 0x67, 0xdf, 0x3a, 0x88, 0xc8, 0x34, 0xae, 0xe4, 0x29, 0x52, 0xad, 0xba, 0xab,
  0x89, 0xff, 0x9d, 0x1c, 0x70, 0xb6, 0x75, 0xdd, 0x3c, 0x8b, 0x01, 0xb0, 0x2b, 0x3f, 0x8f, 0xe8,
  0x80, 0xad, 0xaf, 0x8a, 0xcf, 0xe7, 0x0e, 0x6f, 0x1d, 0x0c, 0x6f, 0x3f, 0x65, 0xe9, 0x9a, 0xdf,
  0x26, 0xd1, 0xc4, 0xfa, 0xd8, 0x36, 0xdd, 0x7d, 0x0b, 0x40, 0x54, 0x3e, 0xcc, 0x3d, 0x06, 0x74,
  0x31, 0x0a, 0xc6, 0xd8, 0x04, 0x48, 0xe0, 0x23, 0x75, 0xdb, 0xd1, 0x00, 0x87, 0x7d, 0x3e, 0x24,
  0xd7, 0x3e, 0xf7, 0xe6, 0xc7, 0x9b, 0x50, 0x18, 0x5e, 0xc9, 0x43, 0xde, 0xd4, 0xb3, 0xa5, 0x21,
  0xc9, 0x74, 0x4b, 0x12, 0xaf, 0xd0, 0x5a, 0x6c, 0x80, 0xeb, 0x87, 0x87, 0x81, 0x82, 0x89, 0x9f,
  0x5d, 0x9a, 0xa5, 0x69, 0x65, 0x34, 0x9c, 0xb2, 0x0e, 0x42, 0x9b, 0x7d, 0xe4, 0x94, 0x36, 0x50,
  0xac, 0xa4, 0x2b, 0x07, 0x00, 0xbb, 0x46, 0x07, 0x88, 0xf6, 0xee, 0x0a, 0xf1, 0xdd, 0xea, 0x21,
  0x87, 0x29, 0x8d, 0xa4, 0xf3, 0xfa, 0xc6, 0x60, 0x4f, 0xe8, 0x8e, 0x8e, 0x10, 0xfe, 0xcd, 0x77
};

static uint8_t test8192_sk2[1024] = {
  0x0e, 0xd1, 0xa5, 0x3f, 0xd3, 0xfe, 0xe1, 0xb2, 0x25, 0x08, 0xfc, 0x9d, 0xba, 0xe7, 0xf4, 0xab,
  0x05, 0x22, 0x4b, 0x5e, 0xd2, 0xe0, 0x2f, 0x82, 0xff, 0x23, 0x0d, 0x4d, 0xfb, 0xa9, 0x34, 0x12,
  0x7a, 0xe3, 0x66, 0x0b, 0x1b, 0x0c, 0x71, 0xb9, 0x12, 0xe9, 0xeb, 0xdf, 0x35, 0x14, 0x96, 0x77,
  0x40, 0xc8, 0x6b, 0xf1, 0xd8, 0xa8, 0xcc, 0xdf, 0x68, 0xf1, 0xe0, 0xb8, 0xc8, 0x60, 0xab, 0xd2,
  0xa6, 0xca, 0x29, 0xd1, 0x14, 0x2a, 0xb2, 0x3a, 0xfb, 0x2b, 0x55, 0x51, 0x91, 0x17, 0xf4, 0xcf,
  0x95, 0x99, 0x4d, 0x40, 0xc8, 0x6e, 0xb9, 0x25, 0x2e, 0x61, 0x8f, 0x7d, 0x89, 0x4c, 0xd6, 0x83,
  0xf0, 0x25, 0x9a, 0x10, 0x3e, 0x01, 0x8f, 0x77, 0x12, 0xac, 0x07, 0xec, 0xda, 0xbb, 0x99, 0xc5,
  0x91, 0xc5, 0x29, 0xae, 0x8c, 0x27, 0xc1, 0x53, 0x8f, 0xaa, 0x25, 0x70, 0xa0, 0x13, 0x27, 0xaa,
  0xdc, 0xca, 0xd7, 0x1b, 0xef, 0x27, 0x22, 0xc7, 0xe9, 0x3c, 0x09, 0x64, 0xd5, 0x08, 0x7b, 0xe1,
  0x6a, 0xa6, 0x5e, 0x54, 0x2d, 0x92, 0xa0, 0x00, 0x16, 0xc4, 0x12, 0x0f, 0xd1, 0xce, 0x62, 0x9a,
  0x57, 0xb9, 0xf5, 0xcd, 0x0a, 0xed, 0x1a, 0x75, 0x7c, 0xf0, 0x4f, 0x22, 0xe0, 0x19, 0xce, 0x53,
  0x20, 0x39, 0x80, 0x69, 0x1d, 0xf4, 0xbd, 0x78, 0xf3, 0x3f, 0x01, 0xe1, 0x66, 0x65, 0x2b, 0x16,
  0xcb, 0x5e, 0xc1, 0x2c, 0x0d, 0x06, 0xe6, 0x02, 0x98, 0x33, 0xeb, 0x31, 0xbd, 0xc6, 0x7a, 0x39,
  0x0d, 0x48, 0x7d, 0x0d, 0x87, 0x3e, 0xdf, 0x92, 0xd4, 0x24, 0x16, 0x9f, 0x01, 0x22, 0xfa, 0x63,
  0xbe, 0x32, 0x31, 0xf5, 0x63, 0x40, 0x03, 0x51, 0xee, 0x72, 0xa9, 0x33, 0x7a, 0x08, 0x21, 0x76,
  0x5e, 0x78, 0x7d, 0x13, 0xc4, 0xf2, 0x3c, 0x8f, 0xf9, 0xe2, 0xcf, 0xbb, 0xdf, 0xf1, 0xb0, 0xc1,
  0x42, 0x42, 0x1e, 0xa8, 0xc8, 0x68, 0x3a, 0x00, 0xdf, 0xde, 0xa3, 0x8b, 0x26, 0x5b, 0xb1, 0xfe,
  0xd2, 0x22, 0x16, 0xcc, 0xfe, 0x1b, 0x8c, 0x1a, 0x10, 0x7a, 0xaa, 0xa9, 0x3a, 0x1b, 0xaf, 0xc6,
  0xde, 0xc4, 0xda, 0xe2, 0xdf, 0x3d, 0xab, 0xe5, 0x59, 0x06, 0x6e, 0xdb, 0xe6, 0x7d, 0x7f, 0x99,
  0xa5, 0x33, 0xbc, 0x90, 0x18, 0x28, 0xf1, 0xb3, 0x58, 0x41, 0x99, 0xa1, 0xef, 0x95, 0x6a, 0x3a,
  0x1e, 0xd4, 0xe1, 0x71, 0xd8, 0x70, 0x95, 0x83, 0x2f, 0xf8, 0x1e, 0x46, 0x79, 0x3f, 0xf0, 0x4b,
  0x63, 0xf4, 0x1e, 0xb9, 0x48, 0x07, 0x9c, 0xc7, 0x80, 0x25, 0xaf, 0x0a, 0x13, 0x8e, 0x00, 0x2d,
  0xee, 0x72, 0xea, 0x30, 0x2d, 0xcc, 0x9a, 0x94, 0x05, 0xbc, 0x39, 0x54, 0x6f, 0xd2, 0xcb, 0x29,
  0xb2, 0xde, 0x0d, 0x98, 0x96, 0x60, 0x99, 0x11, 0xce, 0xd3, 0x8b, 0xbc, 0xc5, 0x43, 0x7d, 0xa7,
  0xc8, 0xc1, 0xc0, 0x84, 0xd8, 0x20, 0xad, 0x40, 0xb6, 0xa3, 0xfe, 0xda, 0x65, 0x86, 0x92, 0xdb,
  0x6b, 0x6f, 0xdd, 0x58, 0xb0, 0xd3, 0x42, 0x69, 0xa6, 0x3e, 0x04, 0xa9, 0x30, 0x6e, 0x20, 0x22,
  0x3e, 0x33, 0xe4, 0x02, 0x41, 0xd6, 0x18, 0x20, 0xea, 0x9b, 0x60, 0x26, 0x5f, 0x3f, 0x72, 0x06,
  0xda, 0x94, 0xe5, 0xb6, 0xf3, 0xb6, 0x42, 0x9d, 0xa8, 0x39, 0x0b, 0xfa, 0x4a, 0x9f, 0xd1, 0x72,
  0x51, 0xd1, 0xf9, 0x3a, 0x43, 0x8d, 0x68, 0xbc, 0x6a, 0x58, 0x42, 0xaf, 0x7f, 0x68, 0x5c, 0xe0,
  0x73, 0x29, 0x12, 0x17, 0xec, 0x5d, 0x6a, 0xe3, 0x3f, 0x4c, 0xf0, 0x13, 0xc4, 0x93, 0xb7, 0x95,
  0x46, 0x5e, 0x8d, 0x19, 0x54, 0x6a, 0x89, 0x4b, 0xc3, 0x51, 0x38, 0x11, 0xcb, 0x31, 0x14, 0x7a,
  0x83, 0x01, 0x67, 0xc8, 0xf9, 0x3a, 0xc2, 0x13, 0x7f, 0x25, 0xa9, 0x19, 0xfd, 0x3e, 0xc4, 0x80,
  0x71, 0xda, 0x80, 0xd5, 0xa6, 0xf0, 0x6e, 0x9f, 0x59, 0x3b, 0x76, 0xb3, 0x03, 0x49, 0xc6, 0xc9,
  0xf8, 0x0c, 0x17, 0x86, 0xd3, 0x32, 0x7b, 0xc2, 0xf6, 0x68, 0x43, 0x7e, 0x2f, 0xa5, 0x96, 0x9a,
  0x3c, 0xbe, 0x7a, 0xc4, 0x41, 0x4f, 0xb2, 0x59, 0x82, 0x28, 0x50, 0x97, 0xf3, 0x78, 0xa4, 0x59,
  0x37, 0x8e, 0x3c, 0xe6, 0x96, 0xe0, 0x3f, 0xe1, 0xed, 0x54, 0xfd, 0xda, 0x2d, 0x15, 0x01, 0x4f,
  0x18, 0x2e, 0xe8, 0xf8, 0xa2, 0xcd, 0x66, 0x17, 0x14, 0x48, 0x3b, 0x97, 0xb5, 0x75, 0x57, 0xaa,
  0x78, 0xe2, 0xae, 0x9d, 0x08, 0xb4, 0x24, 0x7f, 0x7f, 0x91, 0xc3, 0xca, 0x63, 0xd4, 0x2e, 0x70,
  0xa2, 0x07, 0x34, 0xae, 0x20, 0xdb, 0xb7, 0x0d, 0xe3, 0xdc, 0x73, 0xa3, 0xfc, 0x07, 0xdf, 0xef,
  0x1a, 0x36, 0x6f, 0xeb, 0x5e, 0x2b, 0x10, 0x59, 0xbb, 0x69, 0xd3, 0x93, 0x94, 0xa1, 0x65, 0x41,
  0x09, 0x39, 0xd5, 0x02, 0xb5, 0x64, 0x7f, 0x0b, 0x00, 0x5b, 0x45, 0x64, 0x46, 0x93, 0x7d, 0x72,
  0xca, 0x0f, 0x31, 0x11, 0x53, 0x7d, 0x48, 0x9a, 0x39, 0x94, 0x4b, 0x7e, 0x73, 0xb1, 0x08, 0x34,
  0xa7, 0x5e, 0xf2, 0x92, 0x97, 0x72, 0xea, 0x01, 0xb7, 0xc9, 0xd7, 0xc4, 0x29, 0xfe, 0xa4, 0xd3,
  0xae, 0xc6, 0xb6, 0x31, 0x59, 0x60, 0xbc, 0x91, 0x46, 0xe9, 0x25, 0x0c, 0x80, 0x6b, 0x81, 0xa7,
  0x5d, 0x6f, 0x30, 0xc9, 0x8a, 0x6d, 0x64, 0x8f, 0xa3, 0xae, 0xfc, 0xda, 0x39, 0xbb, 0xe4, 0xff,
  0x0b, 0x2f, 0xfc, 0xb1, 0x5c, 0x17, 0x90, 0x9c, 0x59, 0x4d, 0x43, 0x47, 0x81, 0x17, 0xab, 0x2d,
  0xa6, 0x6b, 0xb7, 0x5f, 0x00, 0x48, 0xbf, 0xbf, 0x74, 0xea, 0x20, 0x9f, 0x6c, 0x9d, 0xd1, 0xef,
  0xdf, 0x59, 0x2d, 0x81, 0xf2, 0x83, 0x89, 0x72, 0x1d, 0xab, 0x82, 0x7c, 0x06, 0xe0, 0x53, 0x97,
  0x4a, 0x90, 0x16, 0x98, 0x9f, 0xde, 0x9e, 0x48, 0x07, 0x10, 0x9b, 0x3d, 0xf9, 0x69, 0x97, 0x56,
  0x68, 0xe0, 0x22, 0x66, 0x55, 0x80, 0x4a, 0x59, 0x18, 0x3f, 0x3d, 0xf6, 0xd8, 0xe6, 0xb6, 0x8b,
  0x14, 0x5d, 0x21, 0x30, 0xc2, 0xb3, 0x47, 0x2b, 0xb3, 0x28, 0x23, 0xa1, 0xc6, 0x86, 0xe4, 0x7e,
  0x3d, 0x10, 0x2a, 0xab, 0x2d, 0xec, 0xe9, 0xef, 0xd6, 0xab, 0x98, 0x2d, 0xa4, 0x98, 0x49, 0x3a,
  0xfe, 0xb1, 0x48, 0x2f, 0x96, 0x75, 0x10, 0xb6, 0x75, 0x08, 0xe4, 0x65, 0xb2, 0x48, 0x2a, 0x8f,
  0x35, 0x47, 0x05, 0x46, 0x52, 0xf9, 0x1b, 0xd0, 0x5a, 0x20, 0x26, 0x82, 0x42, 0x17, 0xa4, 0x69,
  0x9a, 0x92, 0x07, 0x12, 0x5d, 0x51, 0x76, 0x5f, 0x75, 0x56, 0x76, 0xce, 0xf6, 0x6c, 0xaf, 0xa7,
  0xdd, 0x18, 0x71, 0x0c, 0x61, 0xae, 0x17, 0xb4, 0xd6, 0xd0, 0xa2, 0xd4, 0x9f, 0xcd, 0xec, 0xb7,
  0x05, 0x3a, 0xa7, 0x50, 0x92, 0xcf, 0x93, 0xbc, 0x44, 0x96, 0x49, 0xa9, 0x36, 0x42, 0x0f, 0xe6,
  0x03, 0x09, 0x92, 0xc9, 0x8b, 0xd6, 0xae, 0xa4, 0x72, 0x3a, 0x0d, 0xf9, 0x82, 0xd2, 0xe5, 0x6e,
  0xc7, 0xf7, 0x1c, 0xd2, 0x4c, 0x09, 0xd1, 0x4f, 0xc7, 0xb0, 0xbe, 0x0a, 0xb1, 0x74, 0xa6, 0xbb,
  0x70, 0x7a, 0x90, 0x73, 0x6b, 0x95, 0x53, 0xe4, 0x47, 0x09, 0x09, 0xdf, 0xcc, 0x1a, 0xe4, 0x11,
  0xd2, 0x02, 0x10, 0xc7, 0x53, 0x1e, 0x26, 0x53, 0xfa, 0x3a, 0x85, 0x43, 0x7d, 0xe7, 0x99, 0x17,
  0xbd, 0x1b, 0xe6, 0x3e, 0xa7, 0x75, 0xc5, 0xda, 0xb3, 0x11, 0x8c, 0x7e, 0x04, 0x66, 0x75, 0x54,
  0x7b, 0xfb, 0x62, 0x18, 0xc4, 0x8f, 0xf0, 0xce, 0xb5, 0xa6, 0x53, 0x32, 0x6b, 0xc2, 0x92, 0x98,
  0x7c, 0x26, 0x19, 0x61, 0x68, 0xca, 0x03, 0x5b, 0xb0, 0x7f, 0xc6, 0xea, 0x15, 0x80, 0xf0, 0x82
};

static uint8_t test8192_pk2[1024] = {
  0x18, 0x77, 0x50, 0x23, 0x5d, 0x4d, 0x83, 0xdf, 0x2e, 0x4a, 0x0f, 0xda, 0xb4, 0xdb, 0x70, 0x7d,
  0x98, 0x78, 0x8e, 0x5b, 0x81, 0x75, 0x13, 0xa5, 0x2e, 0x49, 0x7f, 0xd4, 0xe8, 0x0d, 0x57, 0xed,
  0x3f, 0xc4, 0xcc, 0x67, 0xc9, 0x23, 0x52, 0xc0, 0xd0, 0xbf, 0x9a, 0x6a, 0x5f, 0xb4, 0x65, 0x67,
  0x2e, 0xbb, 0x62, 0xbd, 0xd5, 0xea, 0xf6, 0x66, 0x20, 0xcf, 0xd7, 0x38, 0x90, 0x29, 0x71, 0x49,
  0xfa, 0x29, 0x96, 0x78, 0xd6, 0x9d, 0x45, 0x5e, 0x1b, 0xf6, 0x0d, 0xcc, 0x49, 0x0f, 0x10, 0xa0,
  0x06, 0xa3, 0x10, 0x1b, 0xde, 0xe7, 0x7a, 0x71, 0x50, 0xe0, 0x52, 0x53, 0x31, 0x96, 0x55, 0x53,
  0xd0, 0x42, 0xf9, 0x0e, 0x03, 0xab, 0xb0, 0x70, 0x0c, 0x1f, 0x93, 0x99, 0x6e, 0x0d, 0xc9, 0x9a,
  0xce, 0xb2, 0x52, 0xa6, 0x75, 0xab, 0xa3, 0xaa, 0x97, 0x9c, 0x8e, 0x73, 0x03, 0xbf, 0x56, 0x1c,
  0xd1, 0x9d, 0x8b, 0x37, 0x07, 0x01, 0x97, 0xa9, 0x83, 0xad, 0x47, 0xf5, 0x21, 0x7d, 0x37, 0xca,
  0x6f, 0x45, 0x1a, 0x87, 0xb4, 0xcd, 0x3f, 0xe3, 0x6d, 0x52, 0x38, 0x23, 0x6c, 0xbb, 0xe8, 0xb9,
  0xec, 0x2a, 0x2b, 0x10, 0x8a, 0x0d, 0x3c, 0x8e, 0x5f, 0xda, 0x3f, 0x83, 0xd7, 0xfc, 0x48, 0x4f,
  0x5c, 0x50, 0xe5, 0xa8, 0x43, 0xea, 0x60, 0x81, 0x6b, 0x04, 0xd6, 0xff, 0xce, 0xec, 0x61, 0xfd,
  0xa4, 0xf3, 0x6a, 0x8c, 0x4a, 0x39, 0x91, 0x79, 0x7a, 0xa2, 0xad, 0x59, 0x56, 0x49, 0xac, 0xc8,
  0x66, 0x8f, 0x79, 0xe1, 0xa2, 0x40, 0x00, 0x43, 0xb3, 0x2d, 0x56, 0x18, 0x42, 0x00, 0xd0, 0x2a,
  0x67, 0xdd, 0x2a, 0xf1, 0xc0, 0x52, 0x75, 0xfb, 0x9a, 0x4b, 0x92, 0x22, 0xf3, 0x72, 0x67, 0xf6,
  0xdf, 0xed, 0x48, 0x4b, 0x2a, 0xf6, 0xd6, 0xa5, 0x05, 0xed, 0xa6, 0xd0, 0xd7, 0x1d, 0x0f, 0xde,
  0x0b, 0x2b, 0xdd, 0xa9, 0xea, 0x91, 0x92, 0x6c, 0xc9, 0x9c, 0x45, 0x06, 0xcb, 0x20, 0xc5, 0xdb,
  0x42, 0x58, 0x3d, 0x0c, 0xf8, 0x72, 0xbb, 0x98, 0xd8, 0x78, 0x1a, 0xa8, 0xb7, 0x50, 0xd5, 0xaf,
  0x84, 0x61, 0x25, 0x13, 0x5a, 0x12, 0x0b, 0xb7, 0xfa, 0x48, 0xa0, 0x41, 0x7a, 0x98, 0x04, 0x88,
  0xcc, 0xe8, 0xd6, 0x00, 0xa4, 0xf9, 0x87, 0x90, 0x81, 0xc2, 0x44, 0xe6, 0x64, 0x5a, 0xd0, 0xab,
  0xec, 0xc2, 0xbc, 0x43, 0xf4, 0xe0, 0x90, 0xf0, 0x65, 0x83, 0xf6, 0x86, 0x7a, 0x09, 0xd4, 0x98,
  0x5c, 0x10, 0x20, 0x1c, 0x31, 0x3c, 0x0a, 0x5f, 0x64, 0xca, 0x83, 0x97, 0x84, 0xc8, 0x76, 0x2c,
  0x7b, 0xf4, 0x55, 0x3d, 0x55, 0x7c, 0x90, 0x33, 0xd7, 0x9d, 0xcb, 0xe8, 0x80, 0x8a, 0x16, 0xda,
  0xe1, 0x43, 0xb4, 0x50, 0xc0, 0xbb, 0xb3, 0x1a, 0x76, 0x0b, 0x31, 0x90, 0x96, 0x3b, 0x52, 0x54,
  0x40, 0x02, 0x9a, 0x26, 0x2b, 0x99, 0x09, 0x9e, 0xba, 0x83, 0x1b, 0x0e, 0x4a, 0xa2, 0x39, 0x69,
  0x6f, 0xae, 0x3b, 0x07, 0x32, 0x17, 0x84, 0x44, 0x45, 0xf8, 0x5f, 0x17, 0x3d, 0x61, 0x7e, 0xad,
  0x2e, 0xf4, 0xbf, 0x99, 0xea, 0xd6, 0x12, 0x95, 0xf6, 0x78, 0x55, 0xfa, 0xa3, 0x3c, 0x54, 0x1e,
  0xea, 0xe9, 0xc2, 0xac, 0x0c, 0xd7, 0x7a, 0x31, 0x32, 0x0c, 0x24, 0x17, 0x5a, 0xd1, 0xb0, 0x13,
  0xec, 0x32, 0x20, 0x4d, 0xfe, 0x24, 0xdb, 0xe5, 0x53, 0xdf, 0x3b, 0xcb, 0x00, 0x55, 0x7f, 0xcd,
  0xd4, 0xb3, 0x92, 0x6f, 0xc6, 0xdb, 0x7b, 0x56, 0xce, 0x7f, 0xfb, 0x65, 0xd8, 0x42, 0xa1, 0x5a,
  0x6c, 0xf4, 0x01, 0x54, 0x57, 0xe0, 0x25, 0x53, 0x18, 0xb9, 0x24, 0x17, 0x56, 0x2e, 0xc5, 0xa7,
  0xea, 0x86, 0x7c, 0x5a, 0x40, 0x21, 0x9f, 0xc4, 0xa1, 0x76, 0xbd, 0x4a, 0xd8, 0x05, 0x36, 0x73,
  0x95, 0xa4, 0xf2, 0xb5, 0x93, 0x42, 0x73, 0xaf, 0x6a, 0x2b, 0x85, 0xc3, 0xe9, 0xf0, 0x10, 0x0a,
  0x8b, 0xdb, 0x62, 0xca, 0x2d, 0x6b, 0xb8, 0xe7, 0x86, 0x48, 0xfc, 0xe6, 0x16, 0x55, 0x9c, 0xc6,
  0xc0, 0x16, 0xc3, 0x23, 0x15, 0xde, 0x9e, 0x23, 0x47, 0x6f, 0xe7, 0x70, 0xc0, 0x11, 0xaa, 0x24,
  0xb8, 0x59, 0xc5, 0x52, 0xeb, 0x01, 0x3a, 0x0c, 0x15, 0x78, 0x95, 0xde, 0x56, 0xa1, 0xd8, 0xb6,
  0x45, 0x9f, 0xc4, 0x85, 0x52, 0x74, 0xb0, 0x10, 0x3b, 0xc0, 0x57, 0x18, 0x03, 0x45, 0x72, 0x41,
  0x73, 0xb0, 0xf7, 0xe5, 0x86, 0xff, 0x06, 0x43, 0xb3, 0x73, 0xd6, 0x00, 0xf2, 0x0c, 0x3e, 0x76,
  0x2b, 0x3b, 0xee, 0xb6, 0x12, 0x75, 0xfb, 0xb8, 0x4e, 0xa2, 0x28, 0x62, 0x88, 0x40, 0x81, 0xab,
  0x75, 0xd2, 0xa9, 0xc4, 0xc1, 0x8d, 0x72, 0x39, 0x37, 0x33, 0x8c, 0x12, 0x45, 0xa6, 0xb4, 0x5e,
  0x04, 0x49, 0x96, 0x86, 0x78, 0xe9, 0xd9, 0x8a, 0x04, 0x7c, 0xa6, 0x76, 0xcc, 0x2e, 0x5c, 0x9c,
  0x5a, 0x7f, 0x19, 0x40, 0x26, 0x5e, 0xc7, 0xd3, 0xd0, 0xb6, 0xcf, 0xe9, 0x9c, 0xdb, 0xff, 0xe8,
  0x1c, 0x16, 0x7a, 0x53, 0x80, 0xce, 0x94, 0x84, 0x3a, 0x21, 0xad, 0x0a, 0x6f, 0x46, 0x0e, 0xec,
  0xd1, 0xfd, 0xc0, 0x55, 0x6f, 0xb6, 0xf7, 0xaf, 0x13, 0xb4, 0xa1, 0x60, 0x21, 0x0e, 0x82, 0x13,
  0x8a, 0x8a, 0x46, 0x1a, 0xb2, 0xcb, 0xbb, 0x7e, 0xb2, 0x2f, 0xaf, 0x2c, 0xea, 0x44, 0x4b, 0xe9,
  0x38, 0x5f, 0x1d, 0x94, 0xdb, 0x32, 0xfa, 0x05, 0x82, 0xa4, 0xed, 0x90, 0x34, 0x44, 0xe7, 0xfb,
  0x44, 0xcc, 0xad, 0x36, 0x07, 0x61, 0x8b, 0xaf, 0x74, 0x28, 0x4c, 0x37, 0x6f, 0xdd, 0xaa, 0x21,
  0x37, 0x86, 0xe4, 0x25, 0x81, 0x94, 0x03, 0x7d, 0x77, 0xd8, 0x72, 0x6e, 0x3f, 0xb7, 0xdc, 0xe1,
  0xaf, 0x32, 0xf1, 0xde, 0x3f, 0x17, 0x8b, 0x52, 0xd6, 0x02, 0xad, 0xfb, 0x63, 0x4b, 0x55, 0x8a,
  0x43, 0xb6, 0xce, 0x05, 0xad, 0xa9, 0x3d, 0x81, 0xeb, 0xca, 0xc0, 0xa6, 0x3d, 0xe8, 0x53, 0x3c,
  0x49, 0xe4, 0x6f, 0x28, 0x78, 0x11, 0x7a, 0x15, 0x1d, 0x93, 0x45, 0xed, 0xa9, 0xfe, 0xd3, 0x20,
  0x08, 0x7d, 0xa5, 0xa6, 0xf6, 0x3d, 0xf8, 0x3b, 0xd0, 0x90, 0x64, 0xe4, 0x3a, 0x90, 0x4f, 0x3e,
  0x7c, 0xa6, 0x59, 0x52, 0x7e, 0xac, 0x9a, 0xe9, 0xa2, 0x27, 0xa2, 0xcd, 0x17, 0x05, 0xc9, 0xa0,
  0xa3, 0xb7, 0x15, 0x86, 0x87, 0x3a, 0xed, 0x6a, 0xc3, 0xf3, 0x90, 0xa9, 0xf8, 0x39, 0x0e, 0x4f,
  0x31, 0x37, 0x66, 0x39, 0xbd, 0xde, 0x5e, 0xf3, 0x2e, 0x92, 0xb4, 0x20, 0x8e, 0xdf, 0x60, 0x67,
  0xfa, 0x02, 0x0d, 0xe0, 0xbb, 0x13, 0xd0, 0x1c, 0x61, 0x09, 0xab, 0x38, 0xb4, 0x18, 0x82, 0x4a,
  0x09, 0x91, 0xf1, 0xe5, 0x58, 0x83, 0xff, 0x69, 0x41, 0xe0, 0x22, 0x8c, 0x0f, 0x43, 0x29, 0xc4,
  0x12, 0x4d, 0x4e, 0x4b, 0x2e, 0x6e, 0x12, 0x81, 0x52, 0xcb, 0xa2, 0xea, 0xd3, 0x8c, 0xa1, 0x9d,
  0x6d, 0x92, 0x2d, 0x90, 0x8f, 0xca, 0x0d, 0x61, 0xb8, 0xd0, 0xf6, 0x34, 0x3e, 0x99, 0xd3, 0x6c,
  0x06, 0xad, 0xd7, 0x9c, 0x24, 0x03, 0x12, 0x95, 0x0b, 0x6c, 0xfa, 0x2b, 0xbd, 0x46, 0x8c, 0xd9,
  0x1e, 0xf8, 0xc6, 0xf8, 0x9e, 0xee, 0x68, 0x26, 0x1f, 0x46, 0xec, 0x67, 0x07, 0x56, 0xb7, 0xd1,
  0x98, 0xc6, 0x6a, 0xe7, 0x03, 0xff, 0x89, 0xc8, 0x9b, 0x84, 0x37, 0x2e, 0xe2, 0x4b, 0x7a, 0x4c,
  0x21, 0x96, 0x85, 0xbb, 0x57, 0xe9, 0xe0, 0x11, 0x81, 0x62, 0x5a, 0x96, 0x7a, 0x26, 0x7a, 0x8e,
  0xd6, 0xc2, 0x96, 0x69, 0x72, 0x99, 0x82, 0x5f, 0x10, 0x07, 0xd5, 0xf5, 0x28, 0xab, 0xfe, 0x50
};

static uint8_t test8192_ss[1024] = {
  0x6b, 0x9f, 0x76, 0xa8, 0x7b, 0xba, 0xcc, 0x08, 0xf8, 0x3d, 0x52, 0xe0, 0xac, 0x9d, 0xf0, 0x02,
  0xfb, 0xcb, 0x6a, 0xcb, 0x77, 0x9b, 0xbd, 0xcf, 0x31, 0x80, 0xba, 0x81, 0x89, 0xfc, 0xab, 0x7d,
  0x2f, 0xd1, 0x3a, 0xb5, 0x19, 0xa2, 0x61, 0x9e, 0x71, 0x9f, 0xd8, 0xf8, 0xbc, 0x2c, 0xb8, 0x68,
  0xeb, 0xed, 0x5d, 0x25, 0x90, 0x37, 0x10, 0x5f, 0x6a, 0x36, 0x34, 0x4b, 0xf5, 0x4c, 0xb7, 0x3e,
  0xb6, 0x44, 0xcf, 0xde, 0xa0, 0x45, 0x25, 0x4c, 0xd9, 0x3f, 0xf8, 0x81, 0x10, 0xa7, 0xd8, 0x7d,
  0x83, 0x7c, 0x3b, 0x52, 0x4c, 0xb6, 0xf4, 0x2e, 0x27, 0x7f, 0x7d, 0x5e, 0x66, 0xa6, 0xf5, 0xc9,
  0x0c, 0xcb, 0xf6, 0xe0, 0xdd, 0x8d, 0xcb, 0xe6, 0x59, 0x0a, 0x0a, 0xdf, 0x12, 0xe5, 0x2b, 0xb8,
  0xa6, 0x51, 0xed, 0xf6, 0x6d, 0x2c, 0xd3, 0x27, 0xf3, 0xb1, 0x67, 0xe5, 0xec, 0x09, 0x64, 0xc0,
  0x3b, 0x61, 0x00, 0x41, 0xe5, 0xf8, 0x01, 0x70, 0x1d, 0xba, 0x52, 0x84, 0x97, 0x93, 0x13, 0xcf,
  0x46, 0x1d, 0xef, 0x64, 0x13, 0x3c, 0x01, 0x70, 0x59, 0x85, 0x83, 0xce, 0x15, 0xd1, 0x1a, 0xdf,
  0x64, 0xa8, 0xc7, 0x1b, 0xe8, 0x15, 0x1f, 0xb1, 0x70, 0x3b, 0xcd, 0xf3, 0x0b, 0xf4, 0x19, 0xba,
  0x7f, 0xf4, 0x2f, 0x6b, 0xc8, 0x7f, 0xfb, 0xe0, 0x0a, 0x1f, 0x35, 0x89, 0x44, 0x85, 0xe8, 0xea,
  0x6c, 0x0f, 0x4f, 0xf7, 0xb2, 0x50, 0x80, 0x9e, 0x77, 0x5d, 0x1c, 0x21, 0xb2, 0x27, 0x72, 0x10,
  0xde, 0x03, 0xf7, 0xf3, 0x02, 0x73, 0x07, 0x35, 0xca, 0x12, 0xa2, 0xe2, 0x00, 0x30, 0x01, 0x58,
  0x43, 0xf3, 0x00, 0xef, 0x8f, 0x8b, 0x22, 0xdb, 0xe0, 0x61, 0x10, 0xb6, 0xa3, 0x4f, 0x0f, 0x02,
  0xdc, 0x54, 0x43, 0x88, 0x06, 0xaa, 0x1f, 0x40, 0xb9, 0xce, 0x4a, 0xc2, 0x60, 0xae, 0x91, 0xe9,
  0xef, 0x87, 0xc6, 0xbf, 0xa8, 0xf2, 0x9b, 0xea, 0x15, 0x06, 0xb0, 0xba, 0x83, 0x42, 0xf4, 0xba,
  0x00, 0x31, 0x23, 0x91, 0x43, 0x94, 0x64, 0x81, 0x65, 0x0a, 0xe6, 0x75, 0xe3, 0xf4, 0x6e, 0x58,
  0x01, 0xdc, 0x06, 0x6f, 0x79, 0x38, 0x4a, 0x4b, 0x4e, 0x6b, 0x34, 0xb6, 0x10, 0x02, 0x7e, 0x2f,
  0x8d, 0x76, 0x02, 0x6f, 0xeb, 0x3b, 0x42, 0x4c, 0x0b, 0x54, 0xf9, 0xbe, 0xba, 0x78, 0x8a, 0x8a,
  0xcd, 0x7c, 0x67, 0x91, 0x82, 0xbf, 0x2a, 0x08, 0x58, 0xf3, 0xb3, 0xe2, 0x19, 0x71, 0x45, 0xa4,
  0xcb, 0x19, 0x43, 0x38, 0x52, 0x6b, 0xc8, 0x3f, 0x19, 0x54, 0x5b, 0x92, 0x1d, 0x36, 0x8a, 0xa0,
  0x37, 0xfe, 0x79, 0xa8, 0x61, 0xcd, 0x82, 0xd1, 0xfb, 0x00, 0x32, 0xdf, 0x3b, 0x43, 0xf1, 0xff,
  0xdc, 0x6f, 0x0e, 0x07, 0x16, 0x85, 0x62, 0xd5, 0x39, 0xab, 0x13, 0x01, 0xe6, 0x46, 0xbf, 0x90,
  0x63, 0x7c, 0x28, 0x3d, 0x26, 0x59, 0x80, 0x3e, 0x7a, 0xa5, 0xd4, 0x4d, 0x2e, 0xce, 0xff, 0x0c,
  0x94, 0x12, 0x48, 0x8a, 0x8f, 0xd8, 0xce, 0xd9, 0xd0, 0x01, 0xa7, 0x34, 0x97, 0x1a, 0x09, 0xaf,
  0x27, 0x1e, 0xea, 0xf3, 0x48, 0x51, 0x50, 0x42, 0xcf, 0x30, 0xcf, 0x37, 0xdc, 0x13, 0x78, 0xde,
  0x07, 0xc2, 0x4b, 0x20, 0x24, 0x43, 0xf3, 0x56, 0xd4, 0xf0, 0x14, 0xdf, 0x99, 0x83, 0xd7, 0x2c,
  0x6b, 0xa1, 0x3c, 0x37, 0xaa, 0x73, 0x3c, 0xb7, 0xdd, 0xa9, 0xa3, 0x22, 0xfe, 0xda, 0xb8, 0x09,
  0x2e, 0xad, 0x0c, 0x41, 0xef, 0xcc, 0x92, 0x7c, 0x09, 0x7c, 0x88, 0x68, 0x2b, 0xd3, 0x15, 0x03,
  0xc5, 0xc2, 0xcc, 0xc3, 0xa3, 0xae, 0xaa, 0xe4, 0xed, 0x1c, 0xae, 0x3f, 0x11, 0x4b, 0x44, 0x56,
  0xdc, 0x47, 0x6a, 0x91, 0xfc, 0x85, 0x8b, 0xc0, 0xa9, 0x24, 0xe5, 0xf6, 0xa8, 0x3a, 0xeb, 0xbd,
  0xd9, 0x9e, 0xeb, 0xda, 0xb5, 0xe5, 0xe9, 0x60, 0x94, 0xdd, 0x15, 0x0d, 0xff, 0x41, 0x53, 0xc9,
  0x05, 0xae, 0x28, 0xbb, 0x4d, 0x33, 0x02, 0x5a, 0xcd, 0xc1, 0xf6, 0x65, 0x4c, 0xdd, 0x52, 0x92,
  0xb1, 0xf4, 0xbb, 0x81, 0x71, 0x7f, 0x28, 0x8d, 0x4a, 0xae, 0xdc, 0x0f, 0xb9, 0xfe, 0x1e, 0x62,
  0x41, 0x2e, 0x46, 0xfb, 0x9f, 0x18, 0x8e, 0xb3, 0xd2, 0xa5, 0x8e, 0x3e, 0xe5, 0xa0, 0x2e, 0x7a,
  0x13, 0x17, 0x05, 0x77, 0x74, 0xba, 0x48, 0xce, 0xb3, 0xbb, 0x05, 0x14, 0x42, 0x7f, 0x74, 0x8a,
  0x68, 0xcf, 0x15, 0xb8, 0xa8, 0xc2, 0x1c, 0x24, 0xe4, 0x6b, 0x86, 0x3e, 0x29, 0x6b, 0xf0, 0xab,
  0xae, 0xf2, 0x53, 0xad, 0x6f, 0xbd, 0xa2, 0x34, 0x5d, 0xf3, 0xe0, 0xd2, 0x24, 0xdc, 0x34, 0xff,
  0xc4, 0x41, 0x07, 0x9d, 0x1f, 0xe8, 0x09, 0x96, 0x2d, 0x63, 0xf0, 0xeb, 0xcb, 0x8d, 0xc7, 0xee,
  0x0c, 0xbf, 0x94, 0xa2, 0xe4, 0x76, 0x2c, 0x90, 0x61, 0x59, 0x2d, 0x0a, 0xca, 0x85, 0xe2, 0x6c,
  0x4c, 0x43, 0x5b, 0x6f, 0x8d, 0xca, 0xbd, 0x3d, 0xab, 0x60, 0x49, 0x93, 0x08, 0x8e, 0xfb, 0xa5,
  0x86, 0x60, 0x51, 0x2a, 0xad, 0x10, 0xa4, 0x19, 0x8c, 0x05, 0xcf, 0x37, 0xc1, 0x5d, 0x2a, 0x43,
  0xdc, 0x26, 0x6f, 0x8f, 0xb0, 0x80, 0x27, 0xda, 0x48, 0x13, 0x87, 0x37, 0x35, 0xda, 0x7f, 0x8f,
  0x9c, 0x8e, 0x04, 0x25, 0x4e, 0xaf, 0xd8, 0x5f, 0x21, 0xeb, 0xb3, 0xdf, 0x03, 0x1d, 0x43, 0x27,
  0xf6, 0x7b, 0xdc, 0xee, 0x81, 0xdb, 0xd3, 0x96, 0xcb, 0x8d, 0xb7, 0xa6, 0x28, 0xd9, 0x9c, 0x88,
  0x81, 0xe9, 0x9c, 0x81, 0xd3, 0xa9, 0xe1, 0x63, 0xd0, 0x56, 0x02, 0xe8, 0x6f, 0xa5, 0x0c, 0xc8,
  0xe3, 0x3d, 0xdc, 0x64, 0x85, 0xd2, 0x2a, 0x56, 0x6d, 0x09, 0x5c, 0x35, 0xce, 0x31, 0x22, 0x49,
  0x65, 0x26, 0x8a, 0x08, 0x9e, 0x94, 0x5a, 0x01, 0x17, 0x34, 0x31, 0x77, 0x3c, 0xd5, 0x51, 0x41,
  0x81, 0x30, 0x04, 0xdb, 0x47, 0xf6, 0x24, 0x55, 0xa5, 0x42, 0x4b, 0x7b, 0x4f, 0x58, 0xb4, 0xd7,
  0x48, 0x88, 0xee, 0xe3, 0x63, 0x4c, 0x38, 0xfa, 0x38, 0xec, 0x91, 0x83, 0x7f, 0x25, 0xe3, 0x71,
  0x13, 0xda, 0xcf, 0xe2, 0x0c, 0x7c, 0x0f, 0x99, 0xa6, 0xe8, 0x22, 0x29, 0x1a, 0x63, 0xf6, 0xd8,
  0x97, 0x76, 0x16, 0x26, 0x77, 0xbb, 0xa0, 0xe5, 0x75, 0xfe, 0x1e, 0x08, 0x96, 0x5c, 0x20, 0x40,
  0x73, 0x43, 0xf3, 0xbc, 0xd2, 0xf3, 0xe5, 0x1b, 0xcc, 0x00, 0xf7, 0x78, 0x8b, 0x05, 0xf5, 0xbd,
  0x53, 0x64, 0x4a, 0xcc, 0x16, 0xb4, 0x48, 0xab, 0x88, 0x49, 0xca, 0xf3, 0xaa, 0x40, 0x75, 0x9d,
  0x85, 0x0b, 0xb2, 0x63, 0x4b, 0xbd, 0x1f, 0x5b, 0xc6, 0x16, 0xaf, 0x0e, 0xb2, 0x9d, 0x04, 0xc4,
  0x5d, 0x97, 0x01, 0x17, 0x06, 0x47, 0xdf, 0xd7, 0xba, 0x62, 0x4c, 0x06, 0x54, 0x6f, 0x36, 0x94,
  0x08, 0x43, 0x61, 0x2c, 0xc1, 0x1d, 0xba, 0x31, 0xaf, 0x24, 0xdf, 0xa6, 0x08, 0x94, 0x00, 0x65,
  0x77, 0x1f, 0x8b, 0x63, 0x14, 0x9c, 0xbd, 0x72, 0x45, 0xde, 0x44, 0x33, 0xd5, 0xf2, 0x21, 0x73,
  0xf3, 0xc2, 0x9f, 0x50, 0x4c, 0x08, 0xbc, 0x54, 0x5c, 0x94, 0x35, 0x37, 0x09, 0xb3, 0xfc, 0x69,
  0x3c, 0x01, 0xe7, 0xfd, 0x58, 0x14, 0x4c, 0x7c, 0xfb, 0xac, 0xa2, 0x26, 0xb4, 0xce, 0x08, 0xc5,
  0x3b, 0xa2, 0xdb, 0x92, 0x4a, 0x80, 0x7d, 0xe3, 0x6c, 0xea, 0x2c, 0x88, 0xe7, 0x31, 0xe2, 0x1d,
  0x3c, 0x83, 0x1e, 0x15, 0x7b, 0x7e, 0x10, 0x95, 0x55, 0x42, 0x89, 0x5f, 0xbb, 0x16, 0x9a, 0xbf,
  0xbc, 0x5a, 0xf6, 0x9e, 0x90, 0xef, 0xb4, 0xe1, 0x8c, 0x3b, 0xed, 0x62, 0x53, 0xf7, 0xf1, 0x0c
};


static ffdhe_test_vector vectors[] = {
  {
    .alg = Spec_FFDHE_FFDHE2048,
    .sk1 = test2048_sk1,
    .pk1 = test2048_pk1,
    .sk2 = test2048_sk2,
    .pk2 = test2048_pk2,
    .ss  = test2048_ss
  },
  {
    .alg = Spec_FFDHE_FFDHE3072,
    .sk1 = test3072_sk1,
    .pk1 = test3072_pk1,
    .sk2 = test3072_sk2,
    .pk2 = test3072_pk2,
    .ss  = test3072_ss
  },
  {
    .alg = Spec_FFDHE_FFDHE4096,
    .sk1 = test4096_sk1,
    .pk1 = test4096_pk1,
    .sk2 = test4096_sk2,
    .pk2 = test4096_pk2,
    .ss  = test4096_ss
  },
  {
    .alg = Spec_FFDHE_FFDHE6144,
    .sk1 = test6144_sk1,
    .pk1 = test6144_pk1,
    .sk2 = test6144_sk2,
    .pk2 = test6144_pk2,
    .ss  = test6144_ss
  },
  {
    .alg = Spec_FFDHE_FFDHE8192,
    .sk1 = test8192_sk1,
    .pk1 = test8192_pk1,
    .sk2 = test8192_sk2,
    .pk2 = test8192_pk2,
    .ss  = test8192_ss
  }
};
