/* MIT License
 *
 * Copyright (c) 2016-2020 INRIA, CMU and Microsoft Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */


#ifndef __Hacl_Hash_H
#define __Hacl_Hash_H

#if defined(__cplusplus)
extern "C" {
#endif

#include "libintvector.h"
#include "kremlin/internal/types.h"
#include "kremlin/lowstar_endianness.h"
#include <string.h>
#include "kremlin/internal/target.h"


#include "Hacl_Kremlib.h"
#include "Hacl_Blake2s_32.h"
#include "Lib_Memzero0.h"
#include "Hacl_Blake2b_32.h"
#include "Hacl_Impl_Blake2_Constants.h"
#include "Hacl_Spec.h"

void Hacl_Hash_Core_Blake2_finish_blake2s_32(u32 *s, u64 ev, u8 *dst);

void Hacl_Hash_Core_Blake2_finish_blake2b_32(u64 *s, uint128_t ev, u8 *dst);

u64 Hacl_Hash_Blake2_update_multi_blake2s_32(u32 *s, u64 ev, u8 *blocks, u32 n_blocks);

uint128_t
Hacl_Hash_Blake2_update_multi_blake2b_32(u64 *s, uint128_t ev, u8 *blocks, u32 n_blocks);

typedef struct K___u32_u32_u32__u8___u8__s
{
  u32 fst;
  u32 snd;
  u32 thd;
  u8 *f3;
  u8 *f4;
}
K___u32_u32_u32__u8___u8_;

typedef struct K___u32_u32_u32_s
{
  u32 fst;
  u32 snd;
  u32 thd;
}
K___u32_u32_u32;

u64
Hacl_Hash_Blake2_update_last_blake2s_32(u32 *s, u64 ev, u64 prev_len, u8 *input, u32 input_len);

uint128_t
Hacl_Hash_Blake2_update_last_blake2b_32(
  u64 *s,
  uint128_t ev,
  uint128_t prev_len,
  u8 *input,
  u32 input_len
);

void Hacl_Hash_Blake2_hash_blake2s_32(u8 *input, u32 input_len, u8 *dst);

void Hacl_Hash_Blake2_hash_blake2b_32(u8 *input, u32 input_len, u8 *dst);

void Hacl_Hash_MD5_legacy_update_multi(u32 *s, u8 *blocks, u32 n_blocks);

void Hacl_Hash_MD5_legacy_update_last(u32 *s, u64 prev_len, u8 *input, u32 input_len);

void Hacl_Hash_MD5_legacy_hash(u8 *input, u32 input_len, u8 *dst);

void Hacl_Hash_Core_MD5_legacy_init(u32 *s);

void Hacl_Hash_Core_MD5_legacy_update(u32 *abcd, u8 *x);

void Hacl_Hash_Core_MD5_legacy_pad(u64 len, u8 *dst);

void Hacl_Hash_Core_MD5_legacy_finish(u32 *s, u8 *dst);

void Hacl_Hash_SHA1_legacy_update_multi(u32 *s, u8 *blocks, u32 n_blocks);

void Hacl_Hash_SHA1_legacy_update_last(u32 *s, u64 prev_len, u8 *input, u32 input_len);

void Hacl_Hash_SHA1_legacy_hash(u8 *input, u32 input_len, u8 *dst);

void Hacl_Hash_Core_SHA1_legacy_init(u32 *s);

void Hacl_Hash_Core_SHA1_legacy_update(u32 *h, u8 *l);

void Hacl_Hash_Core_SHA1_legacy_pad(u64 len, u8 *dst);

void Hacl_Hash_Core_SHA1_legacy_finish(u32 *s, u8 *dst);

void Hacl_Hash_SHA2_update_multi_224(u32 *s, u8 *blocks, u32 n_blocks);

void Hacl_Hash_SHA2_update_multi_256(u32 *s, u8 *blocks, u32 n_blocks);

void Hacl_Hash_SHA2_update_multi_384(u64 *s, u8 *blocks, u32 n_blocks);

void Hacl_Hash_SHA2_update_multi_512(u64 *s, u8 *blocks, u32 n_blocks);

void Hacl_Hash_SHA2_update_last_224(u32 *s, u64 prev_len, u8 *input, u32 input_len);

void Hacl_Hash_SHA2_update_last_256(u32 *s, u64 prev_len, u8 *input, u32 input_len);

void Hacl_Hash_SHA2_update_last_384(u64 *s, uint128_t prev_len, u8 *input, u32 input_len);

void Hacl_Hash_SHA2_update_last_512(u64 *s, uint128_t prev_len, u8 *input, u32 input_len);

void Hacl_Hash_SHA2_hash_224(u8 *input, u32 input_len, u8 *dst);

void Hacl_Hash_SHA2_hash_256(u8 *input, u32 input_len, u8 *dst);

void Hacl_Hash_SHA2_hash_384(u8 *input, u32 input_len, u8 *dst);

void Hacl_Hash_SHA2_hash_512(u8 *input, u32 input_len, u8 *dst);

void Hacl_Hash_Core_SHA2_init_224(u32 *s);

void Hacl_Hash_Core_SHA2_init_256(u32 *s);

void Hacl_Hash_Core_SHA2_init_384(u64 *s);

void Hacl_Hash_Core_SHA2_init_512(u64 *s);

void Hacl_Hash_Core_SHA2_update_224(u32 *hash, u8 *block);

void Hacl_Hash_Core_SHA2_update_256(u32 *hash, u8 *block);

void Hacl_Hash_Core_SHA2_update_384(u64 *hash, u8 *block);

void Hacl_Hash_Core_SHA2_update_512(u64 *hash, u8 *block);

void Hacl_Hash_Core_SHA2_pad_224(u64 len, u8 *dst);

void Hacl_Hash_Core_SHA2_pad_256(u64 len, u8 *dst);

void Hacl_Hash_Core_SHA2_pad_384(uint128_t len, u8 *dst);

void Hacl_Hash_Core_SHA2_pad_512(uint128_t len, u8 *dst);

void Hacl_Hash_Core_SHA2_finish_224(u32 *s, u8 *dst);

void Hacl_Hash_Core_SHA2_finish_256(u32 *s, u8 *dst);

void Hacl_Hash_Core_SHA2_finish_384(u64 *s, u8 *dst);

void Hacl_Hash_Core_SHA2_finish_512(u64 *s, u8 *dst);

u32 Hacl_Hash_Definitions_word_len(Spec_Hash_Definitions_hash_alg a);

u32 Hacl_Hash_Definitions_block_len(Spec_Hash_Definitions_hash_alg a);

u32 Hacl_Hash_Definitions_hash_word_len(Spec_Hash_Definitions_hash_alg a);

u32 Hacl_Hash_Definitions_hash_len(Spec_Hash_Definitions_hash_alg a);

#if defined(__cplusplus)
}
#endif

#define __Hacl_Hash_H_DEFINED
#endif
