module Test.Vectors.Poly1305

module B = LowStar.Buffer

#set-options "--max_fuel 0 --max_ifuel 0"

let input0: (b: B.buffer UInt8.t { B.length b = 34 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x43uy; 0x72uy; 0x79uy; 0x70uy; 0x74uy; 0x6fuy; 0x67uy; 0x72uy; 0x61uy; 0x70uy; 0x68uy; 0x69uy; 0x63uy; 0x20uy; 0x46uy; 0x6fuy; 0x72uy; 0x75uy; 0x6duy; 0x20uy; 0x52uy; 0x65uy; 0x73uy; 0x65uy; 0x61uy; 0x72uy; 0x63uy; 0x68uy; 0x20uy; 0x47uy; 0x72uy; 0x6fuy; 0x75uy; 0x70uy; ] in
  assert_norm (List.Tot.length l = 34);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input0_len: (x:UInt32.t { UInt32.v x = B.length input0 }) =
  34ul

let key0: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x85uy; 0xd6uy; 0xbeuy; 0x78uy; 0x57uy; 0x55uy; 0x6duy; 0x33uy; 0x7fuy; 0x44uy; 0x52uy; 0xfeuy; 0x42uy; 0xd5uy; 0x06uy; 0xa8uy; 0x01uy; 0x03uy; 0x80uy; 0x8auy; 0xfbuy; 0x0duy; 0xb2uy; 0xfduy; 0x4auy; 0xbfuy; 0xf6uy; 0xafuy; 0x41uy; 0x49uy; 0xf5uy; 0x1buy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key0_len: (x:UInt32.t { UInt32.v x = B.length key0 }) =
  32ul

let tag0: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xa8uy; 0x06uy; 0x1duy; 0xc1uy; 0x30uy; 0x51uy; 0x36uy; 0xc6uy; 0xc2uy; 0x2buy; 0x8buy; 0xafuy; 0x0cuy; 0x01uy; 0x27uy; 0xa9uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag0_len: (x:UInt32.t { UInt32.v x = B.length tag0 }) =
  16ul

let input1: (b: B.buffer UInt8.t { B.length b = 2 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xf3uy; 0xf6uy; ] in
  assert_norm (List.Tot.length l = 2);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input1_len: (x:UInt32.t { UInt32.v x = B.length input1 }) =
  2ul

let key1: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x85uy; 0x1fuy; 0xc4uy; 0x0cuy; 0x34uy; 0x67uy; 0xacuy; 0x0buy; 0xe0uy; 0x5cuy; 0xc2uy; 0x04uy; 0x04uy; 0xf3uy; 0xf7uy; 0x00uy; 0x58uy; 0x0buy; 0x3buy; 0x0fuy; 0x94uy; 0x47uy; 0xbbuy; 0x1euy; 0x69uy; 0xd0uy; 0x95uy; 0xb5uy; 0x92uy; 0x8buy; 0x6duy; 0xbcuy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key1_len: (x:UInt32.t { UInt32.v x = B.length key1 }) =
  32ul

let tag1: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xf4uy; 0xc6uy; 0x33uy; 0xc3uy; 0x04uy; 0x4fuy; 0xc1uy; 0x45uy; 0xf8uy; 0x4fuy; 0x33uy; 0x5cuy; 0xb8uy; 0x19uy; 0x53uy; 0xdeuy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag1_len: (x:UInt32.t { UInt32.v x = B.length tag1 }) =
  16ul

let input2: (b: B.buffer UInt8.t { B.length b = 0 /\ B.recallable b }) =
  [@inline_let] let l = [ ] in
  assert_norm (List.Tot.length l = 0);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input2_len: (x:UInt32.t { UInt32.v x = B.length input2 }) =
  0ul

let key2: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xa0uy; 0xf3uy; 0x08uy; 0x00uy; 0x00uy; 0xf4uy; 0x64uy; 0x00uy; 0xd0uy; 0xc7uy; 0xe9uy; 0x07uy; 0x6cuy; 0x83uy; 0x44uy; 0x03uy; 0xdduy; 0x3fuy; 0xabuy; 0x22uy; 0x51uy; 0xf1uy; 0x1auy; 0xc7uy; 0x59uy; 0xf0uy; 0x88uy; 0x71uy; 0x29uy; 0xccuy; 0x2euy; 0xe7uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key2_len: (x:UInt32.t { UInt32.v x = B.length key2 }) =
  32ul

let tag2: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xdduy; 0x3fuy; 0xabuy; 0x22uy; 0x51uy; 0xf1uy; 0x1auy; 0xc7uy; 0x59uy; 0xf0uy; 0x88uy; 0x71uy; 0x29uy; 0xccuy; 0x2euy; 0xe7uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag2_len: (x:UInt32.t { UInt32.v x = B.length tag2 }) =
  16ul

let input3: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x66uy; 0x3cuy; 0xeauy; 0x19uy; 0x0fuy; 0xfbuy; 0x83uy; 0xd8uy; 0x95uy; 0x93uy; 0xf3uy; 0xf4uy; 0x76uy; 0xb6uy; 0xbcuy; 0x24uy; 0xd7uy; 0xe6uy; 0x79uy; 0x10uy; 0x7euy; 0xa2uy; 0x6auy; 0xdbuy; 0x8cuy; 0xafuy; 0x66uy; 0x52uy; 0xd0uy; 0x65uy; 0x61uy; 0x36uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input3_len: (x:UInt32.t { UInt32.v x = B.length input3 }) =
  32ul

let key3: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x48uy; 0x44uy; 0x3duy; 0x0buy; 0xb0uy; 0xd2uy; 0x11uy; 0x09uy; 0xc8uy; 0x9auy; 0x10uy; 0x0buy; 0x5cuy; 0xe2uy; 0xc2uy; 0x08uy; 0x83uy; 0x14uy; 0x9cuy; 0x69uy; 0xb5uy; 0x61uy; 0xdduy; 0x88uy; 0x29uy; 0x8auy; 0x17uy; 0x98uy; 0xb1uy; 0x07uy; 0x16uy; 0xefuy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key3_len: (x:UInt32.t { UInt32.v x = B.length key3 }) =
  32ul

let tag3: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x0euy; 0xe1uy; 0xc1uy; 0x6buy; 0xb7uy; 0x3fuy; 0x0fuy; 0x4fuy; 0xd1uy; 0x98uy; 0x81uy; 0x75uy; 0x3cuy; 0x01uy; 0xcduy; 0xbeuy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag3_len: (x:UInt32.t { UInt32.v x = B.length tag3 }) =
  16ul

let input4: (b: B.buffer UInt8.t { B.length b = 63 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xabuy; 0x08uy; 0x12uy; 0x72uy; 0x4auy; 0x7fuy; 0x1euy; 0x34uy; 0x27uy; 0x42uy; 0xcbuy; 0xeduy; 0x37uy; 0x4duy; 0x94uy; 0xd1uy; 0x36uy; 0xc6uy; 0xb8uy; 0x79uy; 0x5duy; 0x45uy; 0xb3uy; 0x81uy; 0x98uy; 0x30uy; 0xf2uy; 0xc0uy; 0x44uy; 0x91uy; 0xfauy; 0xf0uy; 0x99uy; 0x0cuy; 0x62uy; 0xe4uy; 0x8buy; 0x80uy; 0x18uy; 0xb2uy; 0xc3uy; 0xe4uy; 0xa0uy; 0xfauy; 0x31uy; 0x34uy; 0xcbuy; 0x67uy; 0xfauy; 0x83uy; 0xe1uy; 0x58uy; 0xc9uy; 0x94uy; 0xd9uy; 0x61uy; 0xc4uy; 0xcbuy; 0x21uy; 0x09uy; 0x5cuy; 0x1buy; 0xf9uy; ] in
  assert_norm (List.Tot.length l = 63);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input4_len: (x:UInt32.t { UInt32.v x = B.length input4 }) =
  63ul

let key4: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x12uy; 0x97uy; 0x6auy; 0x08uy; 0xc4uy; 0x42uy; 0x6duy; 0x0cuy; 0xe8uy; 0xa8uy; 0x24uy; 0x07uy; 0xc4uy; 0xf4uy; 0x82uy; 0x07uy; 0x80uy; 0xf8uy; 0xc2uy; 0x0auy; 0xa7uy; 0x12uy; 0x02uy; 0xd1uy; 0xe2uy; 0x91uy; 0x79uy; 0xcbuy; 0xcbuy; 0x55uy; 0x5auy; 0x57uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key4_len: (x:UInt32.t { UInt32.v x = B.length key4 }) =
  32ul

let tag4: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x51uy; 0x54uy; 0xaduy; 0x0duy; 0x2cuy; 0xb2uy; 0x6euy; 0x01uy; 0x27uy; 0x4fuy; 0xc5uy; 0x11uy; 0x48uy; 0x49uy; 0x1fuy; 0x1buy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag4_len: (x:UInt32.t { UInt32.v x = B.length tag4 }) =
  16ul

let input5: (b: B.buffer UInt8.t { B.length b = 64 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xabuy; 0x08uy; 0x12uy; 0x72uy; 0x4auy; 0x7fuy; 0x1euy; 0x34uy; 0x27uy; 0x42uy; 0xcbuy; 0xeduy; 0x37uy; 0x4duy; 0x94uy; 0xd1uy; 0x36uy; 0xc6uy; 0xb8uy; 0x79uy; 0x5duy; 0x45uy; 0xb3uy; 0x81uy; 0x98uy; 0x30uy; 0xf2uy; 0xc0uy; 0x44uy; 0x91uy; 0xfauy; 0xf0uy; 0x99uy; 0x0cuy; 0x62uy; 0xe4uy; 0x8buy; 0x80uy; 0x18uy; 0xb2uy; 0xc3uy; 0xe4uy; 0xa0uy; 0xfauy; 0x31uy; 0x34uy; 0xcbuy; 0x67uy; 0xfauy; 0x83uy; 0xe1uy; 0x58uy; 0xc9uy; 0x94uy; 0xd9uy; 0x61uy; 0xc4uy; 0xcbuy; 0x21uy; 0x09uy; 0x5cuy; 0x1buy; 0xf9uy; 0xafuy; ] in
  assert_norm (List.Tot.length l = 64);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input5_len: (x:UInt32.t { UInt32.v x = B.length input5 }) =
  64ul

let key5: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x12uy; 0x97uy; 0x6auy; 0x08uy; 0xc4uy; 0x42uy; 0x6duy; 0x0cuy; 0xe8uy; 0xa8uy; 0x24uy; 0x07uy; 0xc4uy; 0xf4uy; 0x82uy; 0x07uy; 0x80uy; 0xf8uy; 0xc2uy; 0x0auy; 0xa7uy; 0x12uy; 0x02uy; 0xd1uy; 0xe2uy; 0x91uy; 0x79uy; 0xcbuy; 0xcbuy; 0x55uy; 0x5auy; 0x57uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key5_len: (x:UInt32.t { UInt32.v x = B.length key5 }) =
  32ul

let tag5: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x81uy; 0x20uy; 0x59uy; 0xa5uy; 0xdauy; 0x19uy; 0x86uy; 0x37uy; 0xcauy; 0xc7uy; 0xc4uy; 0xa6uy; 0x31uy; 0xbeuy; 0xe4uy; 0x66uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag5_len: (x:UInt32.t { UInt32.v x = B.length tag5 }) =
  16ul

let input6: (b: B.buffer UInt8.t { B.length b = 48 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xabuy; 0x08uy; 0x12uy; 0x72uy; 0x4auy; 0x7fuy; 0x1euy; 0x34uy; 0x27uy; 0x42uy; 0xcbuy; 0xeduy; 0x37uy; 0x4duy; 0x94uy; 0xd1uy; 0x36uy; 0xc6uy; 0xb8uy; 0x79uy; 0x5duy; 0x45uy; 0xb3uy; 0x81uy; 0x98uy; 0x30uy; 0xf2uy; 0xc0uy; 0x44uy; 0x91uy; 0xfauy; 0xf0uy; 0x99uy; 0x0cuy; 0x62uy; 0xe4uy; 0x8buy; 0x80uy; 0x18uy; 0xb2uy; 0xc3uy; 0xe4uy; 0xa0uy; 0xfauy; 0x31uy; 0x34uy; 0xcbuy; 0x67uy; ] in
  assert_norm (List.Tot.length l = 48);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input6_len: (x:UInt32.t { UInt32.v x = B.length input6 }) =
  48ul

let key6: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x12uy; 0x97uy; 0x6auy; 0x08uy; 0xc4uy; 0x42uy; 0x6duy; 0x0cuy; 0xe8uy; 0xa8uy; 0x24uy; 0x07uy; 0xc4uy; 0xf4uy; 0x82uy; 0x07uy; 0x80uy; 0xf8uy; 0xc2uy; 0x0auy; 0xa7uy; 0x12uy; 0x02uy; 0xd1uy; 0xe2uy; 0x91uy; 0x79uy; 0xcbuy; 0xcbuy; 0x55uy; 0x5auy; 0x57uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key6_len: (x:UInt32.t { UInt32.v x = B.length key6 }) =
  32ul

let tag6: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x5buy; 0x88uy; 0xd7uy; 0xf6uy; 0x22uy; 0x8buy; 0x11uy; 0xe2uy; 0xe2uy; 0x85uy; 0x79uy; 0xa5uy; 0xc0uy; 0xc1uy; 0xf7uy; 0x61uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag6_len: (x:UInt32.t { UInt32.v x = B.length tag6 }) =
  16ul

let input7: (b: B.buffer UInt8.t { B.length b = 96 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xabuy; 0x08uy; 0x12uy; 0x72uy; 0x4auy; 0x7fuy; 0x1euy; 0x34uy; 0x27uy; 0x42uy; 0xcbuy; 0xeduy; 0x37uy; 0x4duy; 0x94uy; 0xd1uy; 0x36uy; 0xc6uy; 0xb8uy; 0x79uy; 0x5duy; 0x45uy; 0xb3uy; 0x81uy; 0x98uy; 0x30uy; 0xf2uy; 0xc0uy; 0x44uy; 0x91uy; 0xfauy; 0xf0uy; 0x99uy; 0x0cuy; 0x62uy; 0xe4uy; 0x8buy; 0x80uy; 0x18uy; 0xb2uy; 0xc3uy; 0xe4uy; 0xa0uy; 0xfauy; 0x31uy; 0x34uy; 0xcbuy; 0x67uy; 0xfauy; 0x83uy; 0xe1uy; 0x58uy; 0xc9uy; 0x94uy; 0xd9uy; 0x61uy; 0xc4uy; 0xcbuy; 0x21uy; 0x09uy; 0x5cuy; 0x1buy; 0xf9uy; 0xafuy; 0x66uy; 0x3cuy; 0xeauy; 0x19uy; 0x0fuy; 0xfbuy; 0x83uy; 0xd8uy; 0x95uy; 0x93uy; 0xf3uy; 0xf4uy; 0x76uy; 0xb6uy; 0xbcuy; 0x24uy; 0xd7uy; 0xe6uy; 0x79uy; 0x10uy; 0x7euy; 0xa2uy; 0x6auy; 0xdbuy; 0x8cuy; 0xafuy; 0x66uy; 0x52uy; 0xd0uy; 0x65uy; 0x61uy; 0x36uy; ] in
  assert_norm (List.Tot.length l = 96);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input7_len: (x:UInt32.t { UInt32.v x = B.length input7 }) =
  96ul

let key7: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x12uy; 0x97uy; 0x6auy; 0x08uy; 0xc4uy; 0x42uy; 0x6duy; 0x0cuy; 0xe8uy; 0xa8uy; 0x24uy; 0x07uy; 0xc4uy; 0xf4uy; 0x82uy; 0x07uy; 0x80uy; 0xf8uy; 0xc2uy; 0x0auy; 0xa7uy; 0x12uy; 0x02uy; 0xd1uy; 0xe2uy; 0x91uy; 0x79uy; 0xcbuy; 0xcbuy; 0x55uy; 0x5auy; 0x57uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key7_len: (x:UInt32.t { UInt32.v x = B.length key7 }) =
  32ul

let tag7: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xbbuy; 0xb6uy; 0x13uy; 0xb2uy; 0xb6uy; 0xd7uy; 0x53uy; 0xbauy; 0x07uy; 0x39uy; 0x5buy; 0x91uy; 0x6auy; 0xaeuy; 0xceuy; 0x15uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag7_len: (x:UInt32.t { UInt32.v x = B.length tag7 }) =
  16ul

let input8: (b: B.buffer UInt8.t { B.length b = 112 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xabuy; 0x08uy; 0x12uy; 0x72uy; 0x4auy; 0x7fuy; 0x1euy; 0x34uy; 0x27uy; 0x42uy; 0xcbuy; 0xeduy; 0x37uy; 0x4duy; 0x94uy; 0xd1uy; 0x36uy; 0xc6uy; 0xb8uy; 0x79uy; 0x5duy; 0x45uy; 0xb3uy; 0x81uy; 0x98uy; 0x30uy; 0xf2uy; 0xc0uy; 0x44uy; 0x91uy; 0xfauy; 0xf0uy; 0x99uy; 0x0cuy; 0x62uy; 0xe4uy; 0x8buy; 0x80uy; 0x18uy; 0xb2uy; 0xc3uy; 0xe4uy; 0xa0uy; 0xfauy; 0x31uy; 0x34uy; 0xcbuy; 0x67uy; 0xfauy; 0x83uy; 0xe1uy; 0x58uy; 0xc9uy; 0x94uy; 0xd9uy; 0x61uy; 0xc4uy; 0xcbuy; 0x21uy; 0x09uy; 0x5cuy; 0x1buy; 0xf9uy; 0xafuy; 0x48uy; 0x44uy; 0x3duy; 0x0buy; 0xb0uy; 0xd2uy; 0x11uy; 0x09uy; 0xc8uy; 0x9auy; 0x10uy; 0x0buy; 0x5cuy; 0xe2uy; 0xc2uy; 0x08uy; 0x83uy; 0x14uy; 0x9cuy; 0x69uy; 0xb5uy; 0x61uy; 0xdduy; 0x88uy; 0x29uy; 0x8auy; 0x17uy; 0x98uy; 0xb1uy; 0x07uy; 0x16uy; 0xefuy; 0x66uy; 0x3cuy; 0xeauy; 0x19uy; 0x0fuy; 0xfbuy; 0x83uy; 0xd8uy; 0x95uy; 0x93uy; 0xf3uy; 0xf4uy; 0x76uy; 0xb6uy; 0xbcuy; 0x24uy; ] in
  assert_norm (List.Tot.length l = 112);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input8_len: (x:UInt32.t { UInt32.v x = B.length input8 }) =
  112ul

let key8: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x12uy; 0x97uy; 0x6auy; 0x08uy; 0xc4uy; 0x42uy; 0x6duy; 0x0cuy; 0xe8uy; 0xa8uy; 0x24uy; 0x07uy; 0xc4uy; 0xf4uy; 0x82uy; 0x07uy; 0x80uy; 0xf8uy; 0xc2uy; 0x0auy; 0xa7uy; 0x12uy; 0x02uy; 0xd1uy; 0xe2uy; 0x91uy; 0x79uy; 0xcbuy; 0xcbuy; 0x55uy; 0x5auy; 0x57uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key8_len: (x:UInt32.t { UInt32.v x = B.length key8 }) =
  32ul

let tag8: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xc7uy; 0x94uy; 0xd7uy; 0x05uy; 0x7duy; 0x17uy; 0x78uy; 0xc4uy; 0xbbuy; 0xeeuy; 0x0auy; 0x39uy; 0xb3uy; 0xd9uy; 0x73uy; 0x42uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag8_len: (x:UInt32.t { UInt32.v x = B.length tag8 }) =
  16ul

let input9: (b: B.buffer UInt8.t { B.length b = 128 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xabuy; 0x08uy; 0x12uy; 0x72uy; 0x4auy; 0x7fuy; 0x1euy; 0x34uy; 0x27uy; 0x42uy; 0xcbuy; 0xeduy; 0x37uy; 0x4duy; 0x94uy; 0xd1uy; 0x36uy; 0xc6uy; 0xb8uy; 0x79uy; 0x5duy; 0x45uy; 0xb3uy; 0x81uy; 0x98uy; 0x30uy; 0xf2uy; 0xc0uy; 0x44uy; 0x91uy; 0xfauy; 0xf0uy; 0x99uy; 0x0cuy; 0x62uy; 0xe4uy; 0x8buy; 0x80uy; 0x18uy; 0xb2uy; 0xc3uy; 0xe4uy; 0xa0uy; 0xfauy; 0x31uy; 0x34uy; 0xcbuy; 0x67uy; 0xfauy; 0x83uy; 0xe1uy; 0x58uy; 0xc9uy; 0x94uy; 0xd9uy; 0x61uy; 0xc4uy; 0xcbuy; 0x21uy; 0x09uy; 0x5cuy; 0x1buy; 0xf9uy; 0xafuy; 0x48uy; 0x44uy; 0x3duy; 0x0buy; 0xb0uy; 0xd2uy; 0x11uy; 0x09uy; 0xc8uy; 0x9auy; 0x10uy; 0x0buy; 0x5cuy; 0xe2uy; 0xc2uy; 0x08uy; 0x83uy; 0x14uy; 0x9cuy; 0x69uy; 0xb5uy; 0x61uy; 0xdduy; 0x88uy; 0x29uy; 0x8auy; 0x17uy; 0x98uy; 0xb1uy; 0x07uy; 0x16uy; 0xefuy; 0x66uy; 0x3cuy; 0xeauy; 0x19uy; 0x0fuy; 0xfbuy; 0x83uy; 0xd8uy; 0x95uy; 0x93uy; 0xf3uy; 0xf4uy; 0x76uy; 0xb6uy; 0xbcuy; 0x24uy; 0xd7uy; 0xe6uy; 0x79uy; 0x10uy; 0x7euy; 0xa2uy; 0x6auy; 0xdbuy; 0x8cuy; 0xafuy; 0x66uy; 0x52uy; 0xd0uy; 0x65uy; 0x61uy; 0x36uy; ] in
  assert_norm (List.Tot.length l = 128);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input9_len: (x:UInt32.t { UInt32.v x = B.length input9 }) =
  128ul

let key9: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x12uy; 0x97uy; 0x6auy; 0x08uy; 0xc4uy; 0x42uy; 0x6duy; 0x0cuy; 0xe8uy; 0xa8uy; 0x24uy; 0x07uy; 0xc4uy; 0xf4uy; 0x82uy; 0x07uy; 0x80uy; 0xf8uy; 0xc2uy; 0x0auy; 0xa7uy; 0x12uy; 0x02uy; 0xd1uy; 0xe2uy; 0x91uy; 0x79uy; 0xcbuy; 0xcbuy; 0x55uy; 0x5auy; 0x57uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key9_len: (x:UInt32.t { UInt32.v x = B.length key9 }) =
  32ul

let tag9: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xffuy; 0xbcuy; 0xb9uy; 0xb3uy; 0x71uy; 0x42uy; 0x31uy; 0x52uy; 0xd7uy; 0xfcuy; 0xa5uy; 0xaduy; 0x04uy; 0x2fuy; 0xbauy; 0xa9uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag9_len: (x:UInt32.t { UInt32.v x = B.length tag9 }) =
  16ul

let input10: (b: B.buffer UInt8.t { B.length b = 144 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xabuy; 0x08uy; 0x12uy; 0x72uy; 0x4auy; 0x7fuy; 0x1euy; 0x34uy; 0x27uy; 0x42uy; 0xcbuy; 0xeduy; 0x37uy; 0x4duy; 0x94uy; 0xd1uy; 0x36uy; 0xc6uy; 0xb8uy; 0x79uy; 0x5duy; 0x45uy; 0xb3uy; 0x81uy; 0x98uy; 0x30uy; 0xf2uy; 0xc0uy; 0x44uy; 0x91uy; 0xfauy; 0xf0uy; 0x99uy; 0x0cuy; 0x62uy; 0xe4uy; 0x8buy; 0x80uy; 0x18uy; 0xb2uy; 0xc3uy; 0xe4uy; 0xa0uy; 0xfauy; 0x31uy; 0x34uy; 0xcbuy; 0x67uy; 0xfauy; 0x83uy; 0xe1uy; 0x58uy; 0xc9uy; 0x94uy; 0xd9uy; 0x61uy; 0xc4uy; 0xcbuy; 0x21uy; 0x09uy; 0x5cuy; 0x1buy; 0xf9uy; 0xafuy; 0x48uy; 0x44uy; 0x3duy; 0x0buy; 0xb0uy; 0xd2uy; 0x11uy; 0x09uy; 0xc8uy; 0x9auy; 0x10uy; 0x0buy; 0x5cuy; 0xe2uy; 0xc2uy; 0x08uy; 0x83uy; 0x14uy; 0x9cuy; 0x69uy; 0xb5uy; 0x61uy; 0xdduy; 0x88uy; 0x29uy; 0x8auy; 0x17uy; 0x98uy; 0xb1uy; 0x07uy; 0x16uy; 0xefuy; 0x66uy; 0x3cuy; 0xeauy; 0x19uy; 0x0fuy; 0xfbuy; 0x83uy; 0xd8uy; 0x95uy; 0x93uy; 0xf3uy; 0xf4uy; 0x76uy; 0xb6uy; 0xbcuy; 0x24uy; 0xd7uy; 0xe6uy; 0x79uy; 0x10uy; 0x7euy; 0xa2uy; 0x6auy; 0xdbuy; 0x8cuy; 0xafuy; 0x66uy; 0x52uy; 0xd0uy; 0x65uy; 0x61uy; 0x36uy; 0x81uy; 0x20uy; 0x59uy; 0xa5uy; 0xdauy; 0x19uy; 0x86uy; 0x37uy; 0xcauy; 0xc7uy; 0xc4uy; 0xa6uy; 0x31uy; 0xbeuy; 0xe4uy; 0x66uy; ] in
  assert_norm (List.Tot.length l = 144);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input10_len: (x:UInt32.t { UInt32.v x = B.length input10 }) =
  144ul

let key10: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x12uy; 0x97uy; 0x6auy; 0x08uy; 0xc4uy; 0x42uy; 0x6duy; 0x0cuy; 0xe8uy; 0xa8uy; 0x24uy; 0x07uy; 0xc4uy; 0xf4uy; 0x82uy; 0x07uy; 0x80uy; 0xf8uy; 0xc2uy; 0x0auy; 0xa7uy; 0x12uy; 0x02uy; 0xd1uy; 0xe2uy; 0x91uy; 0x79uy; 0xcbuy; 0xcbuy; 0x55uy; 0x5auy; 0x57uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key10_len: (x:UInt32.t { UInt32.v x = B.length key10 }) =
  32ul

let tag10: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x06uy; 0x9euy; 0xd6uy; 0xb8uy; 0xefuy; 0x0fuy; 0x20uy; 0x7buy; 0x3euy; 0x24uy; 0x3buy; 0xb1uy; 0x01uy; 0x9fuy; 0xe6uy; 0x32uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag10_len: (x:UInt32.t { UInt32.v x = B.length tag10 }) =
  16ul

let input11: (b: B.buffer UInt8.t { B.length b = 160 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xabuy; 0x08uy; 0x12uy; 0x72uy; 0x4auy; 0x7fuy; 0x1euy; 0x34uy; 0x27uy; 0x42uy; 0xcbuy; 0xeduy; 0x37uy; 0x4duy; 0x94uy; 0xd1uy; 0x36uy; 0xc6uy; 0xb8uy; 0x79uy; 0x5duy; 0x45uy; 0xb3uy; 0x81uy; 0x98uy; 0x30uy; 0xf2uy; 0xc0uy; 0x44uy; 0x91uy; 0xfauy; 0xf0uy; 0x99uy; 0x0cuy; 0x62uy; 0xe4uy; 0x8buy; 0x80uy; 0x18uy; 0xb2uy; 0xc3uy; 0xe4uy; 0xa0uy; 0xfauy; 0x31uy; 0x34uy; 0xcbuy; 0x67uy; 0xfauy; 0x83uy; 0xe1uy; 0x58uy; 0xc9uy; 0x94uy; 0xd9uy; 0x61uy; 0xc4uy; 0xcbuy; 0x21uy; 0x09uy; 0x5cuy; 0x1buy; 0xf9uy; 0xafuy; 0x48uy; 0x44uy; 0x3duy; 0x0buy; 0xb0uy; 0xd2uy; 0x11uy; 0x09uy; 0xc8uy; 0x9auy; 0x10uy; 0x0buy; 0x5cuy; 0xe2uy; 0xc2uy; 0x08uy; 0x83uy; 0x14uy; 0x9cuy; 0x69uy; 0xb5uy; 0x61uy; 0xdduy; 0x88uy; 0x29uy; 0x8auy; 0x17uy; 0x98uy; 0xb1uy; 0x07uy; 0x16uy; 0xefuy; 0x66uy; 0x3cuy; 0xeauy; 0x19uy; 0x0fuy; 0xfbuy; 0x83uy; 0xd8uy; 0x95uy; 0x93uy; 0xf3uy; 0xf4uy; 0x76uy; 0xb6uy; 0xbcuy; 0x24uy; 0xd7uy; 0xe6uy; 0x79uy; 0x10uy; 0x7euy; 0xa2uy; 0x6auy; 0xdbuy; 0x8cuy; 0xafuy; 0x66uy; 0x52uy; 0xd0uy; 0x65uy; 0x61uy; 0x36uy; 0x81uy; 0x20uy; 0x59uy; 0xa5uy; 0xdauy; 0x19uy; 0x86uy; 0x37uy; 0xcauy; 0xc7uy; 0xc4uy; 0xa6uy; 0x31uy; 0xbeuy; 0xe4uy; 0x66uy; 0x5buy; 0x88uy; 0xd7uy; 0xf6uy; 0x22uy; 0x8buy; 0x11uy; 0xe2uy; 0xe2uy; 0x85uy; 0x79uy; 0xa5uy; 0xc0uy; 0xc1uy; 0xf7uy; 0x61uy; ] in
  assert_norm (List.Tot.length l = 160);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input11_len: (x:UInt32.t { UInt32.v x = B.length input11 }) =
  160ul

let key11: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x12uy; 0x97uy; 0x6auy; 0x08uy; 0xc4uy; 0x42uy; 0x6duy; 0x0cuy; 0xe8uy; 0xa8uy; 0x24uy; 0x07uy; 0xc4uy; 0xf4uy; 0x82uy; 0x07uy; 0x80uy; 0xf8uy; 0xc2uy; 0x0auy; 0xa7uy; 0x12uy; 0x02uy; 0xd1uy; 0xe2uy; 0x91uy; 0x79uy; 0xcbuy; 0xcbuy; 0x55uy; 0x5auy; 0x57uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key11_len: (x:UInt32.t { UInt32.v x = B.length key11 }) =
  32ul

let tag11: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xccuy; 0xa3uy; 0x39uy; 0xd9uy; 0xa4uy; 0x5fuy; 0xa2uy; 0x36uy; 0x8cuy; 0x2cuy; 0x68uy; 0xb3uy; 0xa4uy; 0x17uy; 0x91uy; 0x33uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag11_len: (x:UInt32.t { UInt32.v x = B.length tag11 }) =
  16ul

let input12: (b: B.buffer UInt8.t { B.length b = 288 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xabuy; 0x08uy; 0x12uy; 0x72uy; 0x4auy; 0x7fuy; 0x1euy; 0x34uy; 0x27uy; 0x42uy; 0xcbuy; 0xeduy; 0x37uy; 0x4duy; 0x94uy; 0xd1uy; 0x36uy; 0xc6uy; 0xb8uy; 0x79uy; 0x5duy; 0x45uy; 0xb3uy; 0x81uy; 0x98uy; 0x30uy; 0xf2uy; 0xc0uy; 0x44uy; 0x91uy; 0xfauy; 0xf0uy; 0x99uy; 0x0cuy; 0x62uy; 0xe4uy; 0x8buy; 0x80uy; 0x18uy; 0xb2uy; 0xc3uy; 0xe4uy; 0xa0uy; 0xfauy; 0x31uy; 0x34uy; 0xcbuy; 0x67uy; 0xfauy; 0x83uy; 0xe1uy; 0x58uy; 0xc9uy; 0x94uy; 0xd9uy; 0x61uy; 0xc4uy; 0xcbuy; 0x21uy; 0x09uy; 0x5cuy; 0x1buy; 0xf9uy; 0xafuy; 0x48uy; 0x44uy; 0x3duy; 0x0buy; 0xb0uy; 0xd2uy; 0x11uy; 0x09uy; 0xc8uy; 0x9auy; 0x10uy; 0x0buy; 0x5cuy; 0xe2uy; 0xc2uy; 0x08uy; 0x83uy; 0x14uy; 0x9cuy; 0x69uy; 0xb5uy; 0x61uy; 0xdduy; 0x88uy; 0x29uy; 0x8auy; 0x17uy; 0x98uy; 0xb1uy; 0x07uy; 0x16uy; 0xefuy; 0x66uy; 0x3cuy; 0xeauy; 0x19uy; 0x0fuy; 0xfbuy; 0x83uy; 0xd8uy; 0x95uy; 0x93uy; 0xf3uy; 0xf4uy; 0x76uy; 0xb6uy; 0xbcuy; 0x24uy; 0xd7uy; 0xe6uy; 0x79uy; 0x10uy; 0x7euy; 0xa2uy; 0x6auy; 0xdbuy; 0x8cuy; 0xafuy; 0x66uy; 0x52uy; 0xd0uy; 0x65uy; 0x61uy; 0x36uy; 0x81uy; 0x20uy; 0x59uy; 0xa5uy; 0xdauy; 0x19uy; 0x86uy; 0x37uy; 0xcauy; 0xc7uy; 0xc4uy; 0xa6uy; 0x31uy; 0xbeuy; 0xe4uy; 0x66uy; 0x5buy; 0x88uy; 0xd7uy; 0xf6uy; 0x22uy; 0x8buy; 0x11uy; 0xe2uy; 0xe2uy; 0x85uy; 0x79uy; 0xa5uy; 0xc0uy; 0xc1uy; 0xf7uy; 0x61uy; 0xabuy; 0x08uy; 0x12uy; 0x72uy; 0x4auy; 0x7fuy; 0x1euy; 0x34uy; 0x27uy; 0x42uy; 0xcbuy; 0xeduy; 0x37uy; 0x4duy; 0x94uy; 0xd1uy; 0x36uy; 0xc6uy; 0xb8uy; 0x79uy; 0x5duy; 0x45uy; 0xb3uy; 0x81uy; 0x98uy; 0x30uy; 0xf2uy; 0xc0uy; 0x44uy; 0x91uy; 0xfauy; 0xf0uy; 0x99uy; 0x0cuy; 0x62uy; 0xe4uy; 0x8buy; 0x80uy; 0x18uy; 0xb2uy; 0xc3uy; 0xe4uy; 0xa0uy; 0xfauy; 0x31uy; 0x34uy; 0xcbuy; 0x67uy; 0xfauy; 0x83uy; 0xe1uy; 0x58uy; 0xc9uy; 0x94uy; 0xd9uy; 0x61uy; 0xc4uy; 0xcbuy; 0x21uy; 0x09uy; 0x5cuy; 0x1buy; 0xf9uy; 0xafuy; 0x48uy; 0x44uy; 0x3duy; 0x0buy; 0xb0uy; 0xd2uy; 0x11uy; 0x09uy; 0xc8uy; 0x9auy; 0x10uy; 0x0buy; 0x5cuy; 0xe2uy; 0xc2uy; 0x08uy; 0x83uy; 0x14uy; 0x9cuy; 0x69uy; 0xb5uy; 0x61uy; 0xdduy; 0x88uy; 0x29uy; 0x8auy; 0x17uy; 0x98uy; 0xb1uy; 0x07uy; 0x16uy; 0xefuy; 0x66uy; 0x3cuy; 0xeauy; 0x19uy; 0x0fuy; 0xfbuy; 0x83uy; 0xd8uy; 0x95uy; 0x93uy; 0xf3uy; 0xf4uy; 0x76uy; 0xb6uy; 0xbcuy; 0x24uy; 0xd7uy; 0xe6uy; 0x79uy; 0x10uy; 0x7euy; 0xa2uy; 0x6auy; 0xdbuy; 0x8cuy; 0xafuy; 0x66uy; 0x52uy; 0xd0uy; 0x65uy; 0x61uy; 0x36uy; ] in
  assert_norm (List.Tot.length l = 288);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input12_len: (x:UInt32.t { UInt32.v x = B.length input12 }) =
  288ul

let key12: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x12uy; 0x97uy; 0x6auy; 0x08uy; 0xc4uy; 0x42uy; 0x6duy; 0x0cuy; 0xe8uy; 0xa8uy; 0x24uy; 0x07uy; 0xc4uy; 0xf4uy; 0x82uy; 0x07uy; 0x80uy; 0xf8uy; 0xc2uy; 0x0auy; 0xa7uy; 0x12uy; 0x02uy; 0xd1uy; 0xe2uy; 0x91uy; 0x79uy; 0xcbuy; 0xcbuy; 0x55uy; 0x5auy; 0x57uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key12_len: (x:UInt32.t { UInt32.v x = B.length key12 }) =
  32ul

let tag12: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x53uy; 0xf6uy; 0xe8uy; 0x28uy; 0xa2uy; 0xf0uy; 0xfeuy; 0x0euy; 0xe8uy; 0x15uy; 0xbfuy; 0x0buy; 0xd5uy; 0x84uy; 0x1auy; 0x34uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag12_len: (x:UInt32.t { UInt32.v x = B.length tag12 }) =
  16ul

let input13: (b: B.buffer UInt8.t { B.length b = 320 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xabuy; 0x08uy; 0x12uy; 0x72uy; 0x4auy; 0x7fuy; 0x1euy; 0x34uy; 0x27uy; 0x42uy; 0xcbuy; 0xeduy; 0x37uy; 0x4duy; 0x94uy; 0xd1uy; 0x36uy; 0xc6uy; 0xb8uy; 0x79uy; 0x5duy; 0x45uy; 0xb3uy; 0x81uy; 0x98uy; 0x30uy; 0xf2uy; 0xc0uy; 0x44uy; 0x91uy; 0xfauy; 0xf0uy; 0x99uy; 0x0cuy; 0x62uy; 0xe4uy; 0x8buy; 0x80uy; 0x18uy; 0xb2uy; 0xc3uy; 0xe4uy; 0xa0uy; 0xfauy; 0x31uy; 0x34uy; 0xcbuy; 0x67uy; 0xfauy; 0x83uy; 0xe1uy; 0x58uy; 0xc9uy; 0x94uy; 0xd9uy; 0x61uy; 0xc4uy; 0xcbuy; 0x21uy; 0x09uy; 0x5cuy; 0x1buy; 0xf9uy; 0xafuy; 0x48uy; 0x44uy; 0x3duy; 0x0buy; 0xb0uy; 0xd2uy; 0x11uy; 0x09uy; 0xc8uy; 0x9auy; 0x10uy; 0x0buy; 0x5cuy; 0xe2uy; 0xc2uy; 0x08uy; 0x83uy; 0x14uy; 0x9cuy; 0x69uy; 0xb5uy; 0x61uy; 0xdduy; 0x88uy; 0x29uy; 0x8auy; 0x17uy; 0x98uy; 0xb1uy; 0x07uy; 0x16uy; 0xefuy; 0x66uy; 0x3cuy; 0xeauy; 0x19uy; 0x0fuy; 0xfbuy; 0x83uy; 0xd8uy; 0x95uy; 0x93uy; 0xf3uy; 0xf4uy; 0x76uy; 0xb6uy; 0xbcuy; 0x24uy; 0xd7uy; 0xe6uy; 0x79uy; 0x10uy; 0x7euy; 0xa2uy; 0x6auy; 0xdbuy; 0x8cuy; 0xafuy; 0x66uy; 0x52uy; 0xd0uy; 0x65uy; 0x61uy; 0x36uy; 0x81uy; 0x20uy; 0x59uy; 0xa5uy; 0xdauy; 0x19uy; 0x86uy; 0x37uy; 0xcauy; 0xc7uy; 0xc4uy; 0xa6uy; 0x31uy; 0xbeuy; 0xe4uy; 0x66uy; 0x5buy; 0x88uy; 0xd7uy; 0xf6uy; 0x22uy; 0x8buy; 0x11uy; 0xe2uy; 0xe2uy; 0x85uy; 0x79uy; 0xa5uy; 0xc0uy; 0xc1uy; 0xf7uy; 0x61uy; 0xabuy; 0x08uy; 0x12uy; 0x72uy; 0x4auy; 0x7fuy; 0x1euy; 0x34uy; 0x27uy; 0x42uy; 0xcbuy; 0xeduy; 0x37uy; 0x4duy; 0x94uy; 0xd1uy; 0x36uy; 0xc6uy; 0xb8uy; 0x79uy; 0x5duy; 0x45uy; 0xb3uy; 0x81uy; 0x98uy; 0x30uy; 0xf2uy; 0xc0uy; 0x44uy; 0x91uy; 0xfauy; 0xf0uy; 0x99uy; 0x0cuy; 0x62uy; 0xe4uy; 0x8buy; 0x80uy; 0x18uy; 0xb2uy; 0xc3uy; 0xe4uy; 0xa0uy; 0xfauy; 0x31uy; 0x34uy; 0xcbuy; 0x67uy; 0xfauy; 0x83uy; 0xe1uy; 0x58uy; 0xc9uy; 0x94uy; 0xd9uy; 0x61uy; 0xc4uy; 0xcbuy; 0x21uy; 0x09uy; 0x5cuy; 0x1buy; 0xf9uy; 0xafuy; 0x48uy; 0x44uy; 0x3duy; 0x0buy; 0xb0uy; 0xd2uy; 0x11uy; 0x09uy; 0xc8uy; 0x9auy; 0x10uy; 0x0buy; 0x5cuy; 0xe2uy; 0xc2uy; 0x08uy; 0x83uy; 0x14uy; 0x9cuy; 0x69uy; 0xb5uy; 0x61uy; 0xdduy; 0x88uy; 0x29uy; 0x8auy; 0x17uy; 0x98uy; 0xb1uy; 0x07uy; 0x16uy; 0xefuy; 0x66uy; 0x3cuy; 0xeauy; 0x19uy; 0x0fuy; 0xfbuy; 0x83uy; 0xd8uy; 0x95uy; 0x93uy; 0xf3uy; 0xf4uy; 0x76uy; 0xb6uy; 0xbcuy; 0x24uy; 0xd7uy; 0xe6uy; 0x79uy; 0x10uy; 0x7euy; 0xa2uy; 0x6auy; 0xdbuy; 0x8cuy; 0xafuy; 0x66uy; 0x52uy; 0xd0uy; 0x65uy; 0x61uy; 0x36uy; 0x81uy; 0x20uy; 0x59uy; 0xa5uy; 0xdauy; 0x19uy; 0x86uy; 0x37uy; 0xcauy; 0xc7uy; 0xc4uy; 0xa6uy; 0x31uy; 0xbeuy; 0xe4uy; 0x66uy; 0x5buy; 0x88uy; 0xd7uy; 0xf6uy; 0x22uy; 0x8buy; 0x11uy; 0xe2uy; 0xe2uy; 0x85uy; 0x79uy; 0xa5uy; 0xc0uy; 0xc1uy; 0xf7uy; 0x61uy; ] in
  assert_norm (List.Tot.length l = 320);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input13_len: (x:UInt32.t { UInt32.v x = B.length input13 }) =
  320ul

let key13: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x12uy; 0x97uy; 0x6auy; 0x08uy; 0xc4uy; 0x42uy; 0x6duy; 0x0cuy; 0xe8uy; 0xa8uy; 0x24uy; 0x07uy; 0xc4uy; 0xf4uy; 0x82uy; 0x07uy; 0x80uy; 0xf8uy; 0xc2uy; 0x0auy; 0xa7uy; 0x12uy; 0x02uy; 0xd1uy; 0xe2uy; 0x91uy; 0x79uy; 0xcbuy; 0xcbuy; 0x55uy; 0x5auy; 0x57uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key13_len: (x:UInt32.t { UInt32.v x = B.length key13 }) =
  32ul

let tag13: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xb8uy; 0x46uy; 0xd4uy; 0x4euy; 0x9buy; 0xbduy; 0x53uy; 0xceuy; 0xdfuy; 0xfbuy; 0xfbuy; 0xb6uy; 0xb7uy; 0xfauy; 0x49uy; 0x33uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag13_len: (x:UInt32.t { UInt32.v x = B.length tag13 }) =
  16ul

let input14: (b: B.buffer UInt8.t { B.length b = 256 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; ] in
  assert_norm (List.Tot.length l = 256);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input14_len: (x:UInt32.t { UInt32.v x = B.length input14 }) =
  256ul

let key14: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xaduy; 0x62uy; 0x81uy; 0x07uy; 0xe8uy; 0x35uy; 0x1duy; 0x0fuy; 0x2cuy; 0x23uy; 0x1auy; 0x05uy; 0xdcuy; 0x4auy; 0x41uy; 0x06uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key14_len: (x:UInt32.t { UInt32.v x = B.length key14 }) =
  32ul

let tag14: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x07uy; 0x14uy; 0x5auy; 0x4cuy; 0x02uy; 0xfeuy; 0x5fuy; 0xa3uy; 0x20uy; 0x36uy; 0xdeuy; 0x68uy; 0xfauy; 0xbeuy; 0x90uy; 0x66uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag14_len: (x:UInt32.t { UInt32.v x = B.length tag14 }) =
  16ul

let input15: (b: B.buffer UInt8.t { B.length b = 252 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x84uy; 0x23uy; 0x64uy; 0xe1uy; 0x56uy; 0x33uy; 0x6cuy; 0x09uy; 0x98uy; 0xb9uy; 0x33uy; 0xa6uy; 0x23uy; 0x77uy; 0x26uy; 0x18uy; 0x0duy; 0x9euy; 0x3fuy; 0xdcuy; 0xbduy; 0xe4uy; 0xcduy; 0x5duy; 0x17uy; 0x08uy; 0x0fuy; 0xc3uy; 0xbeuy; 0xb4uy; 0x96uy; 0x14uy; 0xd7uy; 0x12uy; 0x2cuy; 0x03uy; 0x74uy; 0x63uy; 0xffuy; 0x10uy; 0x4duy; 0x73uy; 0xf1uy; 0x9cuy; 0x12uy; 0x70uy; 0x46uy; 0x28uy; 0xd4uy; 0x17uy; 0xc4uy; 0xc5uy; 0x4auy; 0x3fuy; 0xe3uy; 0x0duy; 0x3cuy; 0x3duy; 0x77uy; 0x14uy; 0x38uy; 0x2duy; 0x43uy; 0xb0uy; 0x38uy; 0x2auy; 0x50uy; 0xa5uy; 0xdeuy; 0xe5uy; 0x4buy; 0xe8uy; 0x44uy; 0xb0uy; 0x76uy; 0xe8uy; 0xdfuy; 0x88uy; 0x20uy; 0x1auy; 0x1cuy; 0xd4uy; 0x3buy; 0x90uy; 0xebuy; 0x21uy; 0x64uy; 0x3fuy; 0xa9uy; 0x6fuy; 0x39uy; 0xb5uy; 0x18uy; 0xaauy; 0x83uy; 0x40uy; 0xc9uy; 0x42uy; 0xffuy; 0x3cuy; 0x31uy; 0xbauy; 0xf7uy; 0xc9uy; 0xbduy; 0xbfuy; 0x0fuy; 0x31uy; 0xaeuy; 0x3fuy; 0xa0uy; 0x96uy; 0xbfuy; 0x8cuy; 0x63uy; 0x03uy; 0x06uy; 0x09uy; 0x82uy; 0x9fuy; 0xe7uy; 0x2euy; 0x17uy; 0x98uy; 0x24uy; 0x89uy; 0x0buy; 0xc8uy; 0xe0uy; 0x8cuy; 0x31uy; 0x5cuy; 0x1cuy; 0xceuy; 0x2auy; 0x83uy; 0x14uy; 0x4duy; 0xbbuy; 0xffuy; 0x09uy; 0xf7uy; 0x4euy; 0x3euy; 0xfcuy; 0x77uy; 0x0buy; 0x54uy; 0xd0uy; 0x98uy; 0x4auy; 0x8fuy; 0x19uy; 0xb1uy; 0x47uy; 0x19uy; 0xe6uy; 0x36uy; 0x35uy; 0x64uy; 0x1duy; 0x6buy; 0x1euy; 0xeduy; 0xf6uy; 0x3euy; 0xfbuy; 0xf0uy; 0x80uy; 0xe1uy; 0x78uy; 0x3duy; 0x32uy; 0x44uy; 0x54uy; 0x12uy; 0x11uy; 0x4cuy; 0x20uy; 0xdeuy; 0x0buy; 0x83uy; 0x7auy; 0x0duy; 0xfauy; 0x33uy; 0xd6uy; 0xb8uy; 0x28uy; 0x25uy; 0xffuy; 0xf4uy; 0x4cuy; 0x9auy; 0x70uy; 0xeauy; 0x54uy; 0xceuy; 0x47uy; 0xf0uy; 0x7duy; 0xf6uy; 0x98uy; 0xe6uy; 0xb0uy; 0x33uy; 0x23uy; 0xb5uy; 0x30uy; 0x79uy; 0x36uy; 0x4auy; 0x5fuy; 0xc3uy; 0xe9uy; 0xdduy; 0x03uy; 0x43uy; 0x92uy; 0xbduy; 0xdeuy; 0x86uy; 0xdcuy; 0xcduy; 0xdauy; 0x94uy; 0x32uy; 0x1cuy; 0x5euy; 0x44uy; 0x06uy; 0x04uy; 0x89uy; 0x33uy; 0x6cuy; 0xb6uy; 0x5buy; 0xf3uy; 0x98uy; 0x9cuy; 0x36uy; 0xf7uy; 0x28uy; 0x2cuy; 0x2fuy; 0x5duy; 0x2buy; 0x88uy; 0x2cuy; 0x17uy; 0x1euy; 0x74uy; ] in
  assert_norm (List.Tot.length l = 252);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input15_len: (x:UInt32.t { UInt32.v x = B.length input15 }) =
  252ul

let key15: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x95uy; 0xd5uy; 0xc0uy; 0x05uy; 0x50uy; 0x3euy; 0x51uy; 0x0duy; 0x8cuy; 0xd0uy; 0xaauy; 0x07uy; 0x2cuy; 0x4auy; 0x4duy; 0x06uy; 0x6euy; 0xabuy; 0xc5uy; 0x2duy; 0x11uy; 0x65uy; 0x3duy; 0xf4uy; 0x7fuy; 0xbfuy; 0x63uy; 0xabuy; 0x19uy; 0x8buy; 0xccuy; 0x26uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key15_len: (x:UInt32.t { UInt32.v x = B.length key15 }) =
  32ul

let tag15: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xf2uy; 0x48uy; 0x31uy; 0x2euy; 0x57uy; 0x8duy; 0x9duy; 0x58uy; 0xf8uy; 0xb7uy; 0xbbuy; 0x4duy; 0x19uy; 0x10uy; 0x54uy; 0x31uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag15_len: (x:UInt32.t { UInt32.v x = B.length tag15 }) =
  16ul

let input16: (b: B.buffer UInt8.t { B.length b = 208 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x24uy; 0x8auy; 0xc3uy; 0x10uy; 0x85uy; 0xb6uy; 0xc2uy; 0xaduy; 0xaauy; 0xa3uy; 0x82uy; 0x59uy; 0xa0uy; 0xd7uy; 0x19uy; 0x2cuy; 0x5cuy; 0x35uy; 0xd1uy; 0xbbuy; 0x4euy; 0xf3uy; 0x9auy; 0xd9uy; 0x4cuy; 0x38uy; 0xd1uy; 0xc8uy; 0x24uy; 0x79uy; 0xe2uy; 0xdduy; 0x21uy; 0x59uy; 0xa0uy; 0x77uy; 0x02uy; 0x4buy; 0x05uy; 0x89uy; 0xbcuy; 0x8auy; 0x20uy; 0x10uy; 0x1buy; 0x50uy; 0x6fuy; 0x0auy; 0x1auy; 0xd0uy; 0xbbuy; 0xabuy; 0x76uy; 0xe8uy; 0x3auy; 0x83uy; 0xf1uy; 0xb9uy; 0x4buy; 0xe6uy; 0xbeuy; 0xaeuy; 0x74uy; 0xe8uy; 0x74uy; 0xcauy; 0xb6uy; 0x92uy; 0xc5uy; 0x96uy; 0x3auy; 0x75uy; 0x43uy; 0x6buy; 0x77uy; 0x61uy; 0x21uy; 0xecuy; 0x9fuy; 0x62uy; 0x39uy; 0x9auy; 0x3euy; 0x66uy; 0xb2uy; 0xd2uy; 0x27uy; 0x07uy; 0xdauy; 0xe8uy; 0x19uy; 0x33uy; 0xb6uy; 0x27uy; 0x7fuy; 0x3cuy; 0x85uy; 0x16uy; 0xbcuy; 0xbeuy; 0x26uy; 0xdbuy; 0xbduy; 0x86uy; 0xf3uy; 0x73uy; 0x10uy; 0x3duy; 0x7cuy; 0xf4uy; 0xcauy; 0xd1uy; 0x88uy; 0x8cuy; 0x95uy; 0x21uy; 0x18uy; 0xfbuy; 0xfbuy; 0xd0uy; 0xd7uy; 0xb4uy; 0xbeuy; 0xdcuy; 0x4auy; 0xe4uy; 0x93uy; 0x6auy; 0xffuy; 0x91uy; 0x15uy; 0x7euy; 0x7auy; 0xa4uy; 0x7cuy; 0x54uy; 0x44uy; 0x2euy; 0xa7uy; 0x8duy; 0x6auy; 0xc2uy; 0x51uy; 0xd3uy; 0x24uy; 0xa0uy; 0xfbuy; 0xe4uy; 0x9duy; 0x89uy; 0xccuy; 0x35uy; 0x21uy; 0xb6uy; 0x6duy; 0x16uy; 0xe9uy; 0xc6uy; 0x6auy; 0x37uy; 0x09uy; 0x89uy; 0x4euy; 0x4euy; 0xb0uy; 0xa4uy; 0xeeuy; 0xdcuy; 0x4auy; 0xe1uy; 0x94uy; 0x68uy; 0xe6uy; 0x6buy; 0x81uy; 0xf2uy; 0x71uy; 0x35uy; 0x1buy; 0x1duy; 0x92uy; 0x1euy; 0xa5uy; 0x51uy; 0x04uy; 0x7auy; 0xbcuy; 0xc6uy; 0xb8uy; 0x7auy; 0x90uy; 0x1fuy; 0xdeuy; 0x7duy; 0xb7uy; 0x9fuy; 0xa1uy; 0x81uy; 0x8cuy; 0x11uy; 0x33uy; 0x6duy; 0xbcuy; 0x07uy; 0x24uy; 0x4auy; 0x40uy; 0xebuy; ] in
  assert_norm (List.Tot.length l = 208);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input16_len: (x:UInt32.t { UInt32.v x = B.length input16 }) =
  208ul

let key16: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0x01uy; 0x02uy; 0x03uy; 0x04uy; 0x05uy; 0x06uy; 0x07uy; 0x08uy; 0x09uy; 0x0auy; 0x0buy; 0x0cuy; 0x0duy; 0x0euy; 0x0fuy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key16_len: (x:UInt32.t { UInt32.v x = B.length key16 }) =
  32ul

let tag16: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xbcuy; 0x93uy; 0x9buy; 0xc5uy; 0x28uy; 0x14uy; 0x80uy; 0xfauy; 0x99uy; 0xc6uy; 0xd6uy; 0x8cuy; 0x25uy; 0x8euy; 0xc4uy; 0x2fuy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag16_len: (x:UInt32.t { UInt32.v x = B.length tag16 }) =
  16ul

let input17: (b: B.buffer UInt8.t { B.length b = 0 /\ B.recallable b }) =
  [@inline_let] let l = [ ] in
  assert_norm (List.Tot.length l = 0);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input17_len: (x:UInt32.t { UInt32.v x = B.length input17 }) =
  0ul

let key17: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xc8uy; 0xafuy; 0xaauy; 0xc3uy; 0x31uy; 0xeeuy; 0x37uy; 0x2cuy; 0xd6uy; 0x08uy; 0x2duy; 0xe1uy; 0x34uy; 0x94uy; 0x3buy; 0x17uy; 0x47uy; 0x10uy; 0x13uy; 0x0euy; 0x9fuy; 0x6fuy; 0xeauy; 0x8duy; 0x72uy; 0x29uy; 0x38uy; 0x50uy; 0xa6uy; 0x67uy; 0xd8uy; 0x6cuy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key17_len: (x:UInt32.t { UInt32.v x = B.length key17 }) =
  32ul

let tag17: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x47uy; 0x10uy; 0x13uy; 0x0euy; 0x9fuy; 0x6fuy; 0xeauy; 0x8duy; 0x72uy; 0x29uy; 0x38uy; 0x50uy; 0xa6uy; 0x67uy; 0xd8uy; 0x6cuy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag17_len: (x:UInt32.t { UInt32.v x = B.length tag17 }) =
  16ul

let input18: (b: B.buffer UInt8.t { B.length b = 12 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x48uy; 0x65uy; 0x6cuy; 0x6cuy; 0x6fuy; 0x20uy; 0x77uy; 0x6fuy; 0x72uy; 0x6cuy; 0x64uy; 0x21uy; ] in
  assert_norm (List.Tot.length l = 12);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input18_len: (x:UInt32.t { UInt32.v x = B.length input18 }) =
  12ul

let key18: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x74uy; 0x68uy; 0x69uy; 0x73uy; 0x20uy; 0x69uy; 0x73uy; 0x20uy; 0x33uy; 0x32uy; 0x2duy; 0x62uy; 0x79uy; 0x74uy; 0x65uy; 0x20uy; 0x6buy; 0x65uy; 0x79uy; 0x20uy; 0x66uy; 0x6fuy; 0x72uy; 0x20uy; 0x50uy; 0x6fuy; 0x6cuy; 0x79uy; 0x31uy; 0x33uy; 0x30uy; 0x35uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key18_len: (x:UInt32.t { UInt32.v x = B.length key18 }) =
  32ul

let tag18: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xa6uy; 0xf7uy; 0x45uy; 0x00uy; 0x8fuy; 0x81uy; 0xc9uy; 0x16uy; 0xa2uy; 0x0duy; 0xccuy; 0x74uy; 0xeeuy; 0xf2uy; 0xb2uy; 0xf0uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag18_len: (x:UInt32.t { UInt32.v x = B.length tag18 }) =
  16ul

let input19: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input19_len: (x:UInt32.t { UInt32.v x = B.length input19 }) =
  32ul

let key19: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x74uy; 0x68uy; 0x69uy; 0x73uy; 0x20uy; 0x69uy; 0x73uy; 0x20uy; 0x33uy; 0x32uy; 0x2duy; 0x62uy; 0x79uy; 0x74uy; 0x65uy; 0x20uy; 0x6buy; 0x65uy; 0x79uy; 0x20uy; 0x66uy; 0x6fuy; 0x72uy; 0x20uy; 0x50uy; 0x6fuy; 0x6cuy; 0x79uy; 0x31uy; 0x33uy; 0x30uy; 0x35uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key19_len: (x:UInt32.t { UInt32.v x = B.length key19 }) =
  32ul

let tag19: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x49uy; 0xecuy; 0x78uy; 0x09uy; 0x0euy; 0x48uy; 0x1euy; 0xc6uy; 0xc2uy; 0x6buy; 0x33uy; 0xb9uy; 0x1cuy; 0xccuy; 0x03uy; 0x07uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag19_len: (x:UInt32.t { UInt32.v x = B.length tag19 }) =
  16ul

let input20: (b: B.buffer UInt8.t { B.length b = 128 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x89uy; 0xdauy; 0xb8uy; 0x0buy; 0x77uy; 0x17uy; 0xc1uy; 0xdbuy; 0x5duy; 0xb4uy; 0x37uy; 0x86uy; 0x0auy; 0x3fuy; 0x70uy; 0x21uy; 0x8euy; 0x93uy; 0xe1uy; 0xb8uy; 0xf4uy; 0x61uy; 0xfbuy; 0x67uy; 0x7fuy; 0x16uy; 0xf3uy; 0x5fuy; 0x6fuy; 0x87uy; 0xe2uy; 0xa9uy; 0x1cuy; 0x99uy; 0xbcuy; 0x3auy; 0x47uy; 0xacuy; 0xe4uy; 0x76uy; 0x40uy; 0xccuy; 0x95uy; 0xc3uy; 0x45uy; 0xbeuy; 0x5euy; 0xccuy; 0xa5uy; 0xa3uy; 0x52uy; 0x3cuy; 0x35uy; 0xccuy; 0x01uy; 0x89uy; 0x3auy; 0xf0uy; 0xb6uy; 0x4auy; 0x62uy; 0x03uy; 0x34uy; 0x27uy; 0x03uy; 0x72uy; 0xecuy; 0x12uy; 0x48uy; 0x2duy; 0x1buy; 0x1euy; 0x36uy; 0x35uy; 0x61uy; 0x69uy; 0x8auy; 0x57uy; 0x8buy; 0x35uy; 0x98uy; 0x03uy; 0x49uy; 0x5buy; 0xb4uy; 0xe2uy; 0xefuy; 0x19uy; 0x30uy; 0xb1uy; 0x7auy; 0x51uy; 0x90uy; 0xb5uy; 0x80uy; 0xf1uy; 0x41uy; 0x30uy; 0x0duy; 0xf3uy; 0x0auy; 0xdbuy; 0xecuy; 0xa2uy; 0x8fuy; 0x64uy; 0x27uy; 0xa8uy; 0xbcuy; 0x1auy; 0x99uy; 0x9fuy; 0xd5uy; 0x1cuy; 0x55uy; 0x4auy; 0x01uy; 0x7duy; 0x09uy; 0x5duy; 0x8cuy; 0x3euy; 0x31uy; 0x27uy; 0xdauy; 0xf9uy; 0xf5uy; 0x95uy; ] in
  assert_norm (List.Tot.length l = 128);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input20_len: (x:UInt32.t { UInt32.v x = B.length input20 }) =
  128ul

let key20: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x2duy; 0x77uy; 0x3buy; 0xe3uy; 0x7auy; 0xdbuy; 0x1euy; 0x4duy; 0x68uy; 0x3buy; 0xf0uy; 0x07uy; 0x5euy; 0x79uy; 0xc4uy; 0xeeuy; 0x03uy; 0x79uy; 0x18uy; 0x53uy; 0x5auy; 0x7fuy; 0x99uy; 0xccuy; 0xb7uy; 0x04uy; 0x0fuy; 0xb5uy; 0xf5uy; 0xf4uy; 0x3auy; 0xeauy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key20_len: (x:UInt32.t { UInt32.v x = B.length key20 }) =
  32ul

let tag20: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xc8uy; 0x5duy; 0x15uy; 0xeduy; 0x44uy; 0xc3uy; 0x78uy; 0xd6uy; 0xb0uy; 0x0euy; 0x23uy; 0x06uy; 0x4cuy; 0x7buy; 0xcduy; 0x51uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag20_len: (x:UInt32.t { UInt32.v x = B.length tag20 }) =
  16ul

let input21: (b: B.buffer UInt8.t { B.length b = 528 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x0buy; 0x17uy; 0x03uy; 0x03uy; 0x02uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x06uy; 0xdbuy; 0x1fuy; 0x1fuy; 0x36uy; 0x8duy; 0x69uy; 0x6auy; 0x81uy; 0x0auy; 0x34uy; 0x9cuy; 0x0cuy; 0x71uy; 0x4cuy; 0x9auy; 0x5euy; 0x78uy; 0x50uy; 0xc2uy; 0x40uy; 0x7duy; 0x72uy; 0x1auy; 0xcduy; 0xeduy; 0x95uy; 0xe0uy; 0x18uy; 0xd7uy; 0xa8uy; 0x52uy; 0x66uy; 0xa6uy; 0xe1uy; 0x28uy; 0x9cuy; 0xdbuy; 0x4auy; 0xebuy; 0x18uy; 0xdauy; 0x5auy; 0xc8uy; 0xa2uy; 0xb0uy; 0x02uy; 0x6duy; 0x24uy; 0xa5uy; 0x9auy; 0xd4uy; 0x85uy; 0x22uy; 0x7fuy; 0x3euy; 0xaeuy; 0xdbuy; 0xb2uy; 0xe7uy; 0xe3uy; 0x5euy; 0x1cuy; 0x66uy; 0xcduy; 0x60uy; 0xf9uy; 0xabuy; 0xf7uy; 0x16uy; 0xdcuy; 0xc9uy; 0xacuy; 0x42uy; 0x68uy; 0x2duy; 0xd7uy; 0xdauy; 0xb2uy; 0x87uy; 0xa7uy; 0x02uy; 0x4cuy; 0x4euy; 0xefuy; 0xc3uy; 0x21uy; 0xccuy; 0x05uy; 0x74uy; 0xe1uy; 0x67uy; 0x93uy; 0xe3uy; 0x7cuy; 0xecuy; 0x03uy; 0xc5uy; 0xbduy; 0xa4uy; 0x2buy; 0x54uy; 0xc1uy; 0x14uy; 0xa8uy; 0x0buy; 0x57uy; 0xafuy; 0x26uy; 0x41uy; 0x6cuy; 0x7buy; 0xe7uy; 0x42uy; 0x00uy; 0x5euy; 0x20uy; 0x85uy; 0x5cuy; 0x73uy; 0xe2uy; 0x1duy; 0xc8uy; 0xe2uy; 0xeduy; 0xc9uy; 0xd4uy; 0x35uy; 0xcbuy; 0x6fuy; 0x60uy; 0x59uy; 0x28uy; 0x00uy; 0x11uy; 0xc2uy; 0x70uy; 0xb7uy; 0x15uy; 0x70uy; 0x05uy; 0x1cuy; 0x1cuy; 0x9buy; 0x30uy; 0x52uy; 0x12uy; 0x66uy; 0x20uy; 0xbcuy; 0x1euy; 0x27uy; 0x30uy; 0xfauy; 0x06uy; 0x6cuy; 0x7auy; 0x50uy; 0x9duy; 0x53uy; 0xc6uy; 0x0euy; 0x5auy; 0xe1uy; 0xb4uy; 0x0auy; 0xa6uy; 0xe3uy; 0x9euy; 0x49uy; 0x66uy; 0x92uy; 0x28uy; 0xc9uy; 0x0euy; 0xecuy; 0xb4uy; 0xa5uy; 0x0duy; 0xb3uy; 0x2auy; 0x50uy; 0xbcuy; 0x49uy; 0xe9uy; 0x0buy; 0x4fuy; 0x4buy; 0x35uy; 0x9auy; 0x1duy; 0xfduy; 0x11uy; 0x74uy; 0x9cuy; 0xd3uy; 0x86uy; 0x7fuy; 0xcfuy; 0x2fuy; 0xb7uy; 0xbbuy; 0x6cuy; 0xd4uy; 0x73uy; 0x8fuy; 0x6auy; 0x4auy; 0xd6uy; 0xf7uy; 0xcauy; 0x50uy; 0x58uy; 0xf7uy; 0x61uy; 0x88uy; 0x45uy; 0xafuy; 0x9fuy; 0x02uy; 0x0fuy; 0x6cuy; 0x3buy; 0x96uy; 0x7buy; 0x8fuy; 0x4cuy; 0xd4uy; 0xa9uy; 0x1euy; 0x28uy; 0x13uy; 0xb5uy; 0x07uy; 0xaeuy; 0x66uy; 0xf2uy; 0xd3uy; 0x5cuy; 0x18uy; 0x28uy; 0x4fuy; 0x72uy; 0x92uy; 0x18uy; 0x60uy; 0x62uy; 0xe1uy; 0x0fuy; 0xd5uy; 0x51uy; 0x0duy; 0x18uy; 0x77uy; 0x53uy; 0x51uy; 0xefuy; 0x33uy; 0x4euy; 0x76uy; 0x34uy; 0xabuy; 0x47uy; 0x43uy; 0xf5uy; 0xb6uy; 0x8fuy; 0x49uy; 0xaduy; 0xcauy; 0xb3uy; 0x84uy; 0xd3uy; 0xfduy; 0x75uy; 0xf7uy; 0x39uy; 0x0fuy; 0x40uy; 0x06uy; 0xefuy; 0x2auy; 0x29uy; 0x5cuy; 0x8cuy; 0x7auy; 0x07uy; 0x6auy; 0xd5uy; 0x45uy; 0x46uy; 0xcduy; 0x25uy; 0xd2uy; 0x10uy; 0x7fuy; 0xbeuy; 0x14uy; 0x36uy; 0xc8uy; 0x40uy; 0x92uy; 0x4auy; 0xaeuy; 0xbeuy; 0x5buy; 0x37uy; 0x08uy; 0x93uy; 0xcduy; 0x63uy; 0xd1uy; 0x32uy; 0x5buy; 0x86uy; 0x16uy; 0xfcuy; 0x48uy; 0x10uy; 0x88uy; 0x6buy; 0xc1uy; 0x52uy; 0xc5uy; 0x32uy; 0x21uy; 0xb6uy; 0xdfuy; 0x37uy; 0x31uy; 0x19uy; 0x39uy; 0x32uy; 0x55uy; 0xeeuy; 0x72uy; 0xbcuy; 0xaauy; 0x88uy; 0x01uy; 0x74uy; 0xf1uy; 0x71uy; 0x7fuy; 0x91uy; 0x84uy; 0xfauy; 0x91uy; 0x64uy; 0x6fuy; 0x17uy; 0xa2uy; 0x4auy; 0xc5uy; 0x5duy; 0x16uy; 0xbfuy; 0xdduy; 0xcauy; 0x95uy; 0x81uy; 0xa9uy; 0x2euy; 0xdauy; 0x47uy; 0x92uy; 0x01uy; 0xf0uy; 0xeduy; 0xbfuy; 0x63uy; 0x36uy; 0x00uy; 0xd6uy; 0x06uy; 0x6duy; 0x1auy; 0xb3uy; 0x6duy; 0x5duy; 0x24uy; 0x15uy; 0xd7uy; 0x13uy; 0x51uy; 0xbbuy; 0xcduy; 0x60uy; 0x8auy; 0x25uy; 0x10uy; 0x8duy; 0x25uy; 0x64uy; 0x19uy; 0x92uy; 0xc1uy; 0xf2uy; 0x6cuy; 0x53uy; 0x1cuy; 0xf9uy; 0xf9uy; 0x02uy; 0x03uy; 0xbcuy; 0x4cuy; 0xc1uy; 0x9fuy; 0x59uy; 0x27uy; 0xd8uy; 0x34uy; 0xb0uy; 0xa4uy; 0x71uy; 0x16uy; 0xd3uy; 0x88uy; 0x4buy; 0xbbuy; 0x16uy; 0x4buy; 0x8euy; 0xc8uy; 0x83uy; 0xd1uy; 0xacuy; 0x83uy; 0x2euy; 0x56uy; 0xb3uy; 0x91uy; 0x8auy; 0x98uy; 0x60uy; 0x1auy; 0x08uy; 0xd1uy; 0x71uy; 0x88uy; 0x15uy; 0x41uy; 0xd5uy; 0x94uy; 0xdbuy; 0x39uy; 0x9cuy; 0x6auy; 0xe6uy; 0x15uy; 0x12uy; 0x21uy; 0x74uy; 0x5auy; 0xecuy; 0x81uy; 0x4cuy; 0x45uy; 0xb0uy; 0xb0uy; 0x5buy; 0x56uy; 0x54uy; 0x36uy; 0xfduy; 0x6fuy; 0x13uy; 0x7auy; 0xa1uy; 0x0auy; 0x0cuy; 0x0buy; 0x64uy; 0x37uy; 0x61uy; 0xdbuy; 0xd6uy; 0xf9uy; 0xa9uy; 0xdcuy; 0xb9uy; 0x9buy; 0x1auy; 0x6euy; 0x69uy; 0x08uy; 0x54uy; 0xceuy; 0x07uy; 0x69uy; 0xcduy; 0xe3uy; 0x97uy; 0x61uy; 0xd8uy; 0x2fuy; 0xcduy; 0xecuy; 0x15uy; 0xf0uy; 0xd9uy; 0x2duy; 0x7duy; 0x8euy; 0x94uy; 0xaduy; 0xe8uy; 0xebuy; 0x83uy; 0xfbuy; 0xe0uy; ] in
  assert_norm (List.Tot.length l = 528);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input21_len: (x:UInt32.t { UInt32.v x = B.length input21 }) =
  528ul

let key21: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x99uy; 0xe5uy; 0x82uy; 0x2duy; 0xd4uy; 0x17uy; 0x3cuy; 0x99uy; 0x5euy; 0x3duy; 0xaeuy; 0x0duy; 0xdeuy; 0xfbuy; 0x97uy; 0x74uy; 0x3fuy; 0xdeuy; 0x3buy; 0x08uy; 0x01uy; 0x34uy; 0xb3uy; 0x9fuy; 0x76uy; 0xe9uy; 0xbfuy; 0x8duy; 0x0euy; 0x88uy; 0xd5uy; 0x46uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key21_len: (x:UInt32.t { UInt32.v x = B.length key21 }) =
  32ul

let tag21: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x26uy; 0x37uy; 0x40uy; 0x8fuy; 0xe1uy; 0x30uy; 0x86uy; 0xeauy; 0x73uy; 0xf9uy; 0x71uy; 0xe3uy; 0x42uy; 0x5euy; 0x28uy; 0x20uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag21_len: (x:UInt32.t { UInt32.v x = B.length tag21 }) =
  16ul

let input22: (b: B.buffer UInt8.t { B.length b = 257 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0x80uy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xceuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xc5uy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xe3uy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xacuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xe6uy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0x00uy; 0x00uy; 0x00uy; 0xafuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xffuy; 0xffuy; 0xffuy; 0xf5uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0xffuy; 0xffuy; 0xffuy; 0xe7uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x71uy; 0x92uy; 0x05uy; 0xa8uy; 0x52uy; 0x1duy; 0xfcuy; ] in
  assert_norm (List.Tot.length l = 257);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input22_len: (x:UInt32.t { UInt32.v x = B.length input22 }) =
  257ul

let key22: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x7fuy; 0x1buy; 0x02uy; 0x64uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; 0xccuy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key22_len: (x:UInt32.t { UInt32.v x = B.length key22 }) =
  32ul

let tag22: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x85uy; 0x59uy; 0xb8uy; 0x76uy; 0xecuy; 0xeeuy; 0xd6uy; 0x6euy; 0xb3uy; 0x77uy; 0x98uy; 0xc0uy; 0x45uy; 0x7buy; 0xafuy; 0xf9uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag22_len: (x:UInt32.t { UInt32.v x = B.length tag22 }) =
  16ul

let input23: (b: B.buffer UInt8.t { B.length b = 39 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x80uy; 0x02uy; 0x64uy; ] in
  assert_norm (List.Tot.length l = 39);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input23_len: (x:UInt32.t { UInt32.v x = B.length input23 }) =
  39ul

let key23: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xe0uy; 0x00uy; 0x16uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; 0xaauy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key23_len: (x:UInt32.t { UInt32.v x = B.length key23 }) =
  32ul

let tag23: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0xbduy; 0x12uy; 0x58uy; 0x97uy; 0x8euy; 0x20uy; 0x54uy; 0x44uy; 0xc9uy; 0xaauy; 0xaauy; 0x82uy; 0x00uy; 0x6fuy; 0xeduy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag23_len: (x:UInt32.t { UInt32.v x = B.length tag23 }) =
  16ul

let input24: (b: B.buffer UInt8.t { B.length b = 2 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x02uy; 0xfcuy; ] in
  assert_norm (List.Tot.length l = 2);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input24_len: (x:UInt32.t { UInt32.v x = B.length input24 }) =
  2ul

let key24: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key24_len: (x:UInt32.t { UInt32.v x = B.length key24 }) =
  32ul

let tag24: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x06uy; 0x12uy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; 0x0cuy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag24_len: (x:UInt32.t { UInt32.v x = B.length tag24 }) =
  16ul

let input25: (b: B.buffer UInt8.t { B.length b = 415 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7auy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x5cuy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x6euy; 0x7buy; 0x00uy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7auy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x5cuy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x7buy; 0x6euy; 0x7buy; 0x00uy; 0x13uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0xb3uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0xf2uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x20uy; 0x00uy; 0xefuy; 0xffuy; 0x00uy; 0x09uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x10uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x09uy; 0x00uy; 0x00uy; 0x00uy; 0x64uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x13uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0xb3uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0xf2uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x20uy; 0x00uy; 0xefuy; 0xffuy; 0x00uy; 0x09uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x7auy; 0x00uy; 0x00uy; 0x10uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x09uy; 0x00uy; 0x00uy; 0x00uy; 0x64uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0xfcuy; ] in
  assert_norm (List.Tot.length l = 415);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input25_len: (x:UInt32.t { UInt32.v x = B.length input25 }) =
  415ul

let key25: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0xffuy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x1euy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x7buy; 0x7buy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key25_len: (x:UInt32.t { UInt32.v x = B.length key25 }) =
  32ul

let tag25: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x33uy; 0x20uy; 0x5buy; 0xbfuy; 0x9euy; 0x9fuy; 0x8fuy; 0x72uy; 0x12uy; 0xabuy; 0x9euy; 0x2auy; 0xb9uy; 0xb7uy; 0xe4uy; 0xa5uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag25_len: (x:UInt32.t { UInt32.v x = B.length tag25 }) =
  16ul

let input26: (b: B.buffer UInt8.t { B.length b = 118 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0xffuy; 0xffuy; 0xffuy; 0xe9uy; 0xe9uy; 0xacuy; 0xacuy; 0xacuy; 0xacuy; 0xacuy; 0xacuy; 0xacuy; 0xacuy; 0xacuy; 0xacuy; 0xacuy; 0x00uy; 0x00uy; 0xacuy; 0xacuy; 0xecuy; 0x01uy; 0x00uy; 0xacuy; 0xacuy; 0xacuy; 0x2cuy; 0xacuy; 0xa2uy; 0xacuy; 0xacuy; 0xacuy; 0xacuy; 0xacuy; 0xacuy; 0xacuy; 0xacuy; 0xacuy; 0xacuy; 0xacuy; 0x64uy; 0xf2uy; ] in
  assert_norm (List.Tot.length l = 118);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input26_len: (x:UInt32.t { UInt32.v x = B.length input26 }) =
  118ul

let key26: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0x00uy; 0x00uy; 0x7fuy; 0x00uy; 0x00uy; 0x00uy; 0x7fuy; 0x01uy; 0x00uy; 0x00uy; 0x20uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0xcfuy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; 0x77uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key26_len: (x:UInt32.t { UInt32.v x = B.length key26 }) =
  32ul

let tag26: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x02uy; 0xeeuy; 0x7cuy; 0x8cuy; 0x54uy; 0x6duy; 0xdeuy; 0xb1uy; 0xa4uy; 0x67uy; 0xe4uy; 0xc3uy; 0x98uy; 0x11uy; 0x58uy; 0xb9uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag26_len: (x:UInt32.t { UInt32.v x = B.length tag26 }) =
  16ul

let input27: (b: B.buffer UInt8.t { B.length b = 131 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x8euy; 0x99uy; 0x3buy; 0x9fuy; 0x48uy; 0x68uy; 0x12uy; 0x73uy; 0xc2uy; 0x96uy; 0x50uy; 0xbauy; 0x32uy; 0xfcuy; 0x76uy; 0xceuy; 0x48uy; 0x33uy; 0x2euy; 0xa7uy; 0x16uy; 0x4duy; 0x96uy; 0xa4uy; 0x47uy; 0x6fuy; 0xb8uy; 0xc5uy; 0x31uy; 0xa1uy; 0x18uy; 0x6auy; 0xc0uy; 0xdfuy; 0xc1uy; 0x7cuy; 0x98uy; 0xdcuy; 0xe8uy; 0x7buy; 0x4duy; 0xa7uy; 0xf0uy; 0x11uy; 0xecuy; 0x48uy; 0xc9uy; 0x72uy; 0x71uy; 0xd2uy; 0xc2uy; 0x0fuy; 0x9buy; 0x92uy; 0x8fuy; 0xe2uy; 0x27uy; 0x0duy; 0x6fuy; 0xb8uy; 0x63uy; 0xd5uy; 0x17uy; 0x38uy; 0xb4uy; 0x8euy; 0xeeuy; 0xe3uy; 0x14uy; 0xa7uy; 0xccuy; 0x8auy; 0xb9uy; 0x32uy; 0x16uy; 0x45uy; 0x48uy; 0xe5uy; 0x26uy; 0xaeuy; 0x90uy; 0x22uy; 0x43uy; 0x68uy; 0x51uy; 0x7auy; 0xcfuy; 0xeauy; 0xbduy; 0x6buy; 0xb3uy; 0x73uy; 0x2buy; 0xc0uy; 0xe9uy; 0xdauy; 0x99uy; 0x83uy; 0x2buy; 0x61uy; 0xcauy; 0x01uy; 0xb6uy; 0xdeuy; 0x56uy; 0x24uy; 0x4auy; 0x9euy; 0x88uy; 0xd5uy; 0xf9uy; 0xb3uy; 0x79uy; 0x73uy; 0xf6uy; 0x22uy; 0xa4uy; 0x3duy; 0x14uy; 0xa6uy; 0x59uy; 0x9buy; 0x1fuy; 0x65uy; 0x4cuy; 0xb4uy; 0x5auy; 0x74uy; 0xe3uy; 0x55uy; 0xa5uy; ] in
  assert_norm (List.Tot.length l = 131);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input27_len: (x:UInt32.t { UInt32.v x = B.length input27 }) =
  131ul

let key27: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xeeuy; 0xa6uy; 0xa7uy; 0x25uy; 0x1cuy; 0x1euy; 0x72uy; 0x91uy; 0x6duy; 0x11uy; 0xc2uy; 0xcbuy; 0x21uy; 0x4duy; 0x3cuy; 0x25uy; 0x25uy; 0x39uy; 0x12uy; 0x1duy; 0x8euy; 0x23uy; 0x4euy; 0x65uy; 0x2duy; 0x65uy; 0x1fuy; 0xa4uy; 0xc8uy; 0xcfuy; 0xf8uy; 0x80uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key27_len: (x:UInt32.t { UInt32.v x = B.length key27 }) =
  32ul

let tag27: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xf3uy; 0xffuy; 0xc7uy; 0x70uy; 0x3fuy; 0x94uy; 0x00uy; 0xe5uy; 0x2auy; 0x7duy; 0xfbuy; 0x4buy; 0x3duy; 0x33uy; 0x05uy; 0xd9uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag27_len: (x:UInt32.t { UInt32.v x = B.length tag27 }) =
  16ul

let input28: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input28_len: (x:UInt32.t { UInt32.v x = B.length input28 }) =
  16ul

let key28: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x02uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key28_len: (x:UInt32.t { UInt32.v x = B.length key28 }) =
  32ul

let tag28: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x03uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag28_len: (x:UInt32.t { UInt32.v x = B.length tag28 }) =
  16ul

let input29: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x02uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input29_len: (x:UInt32.t { UInt32.v x = B.length input29 }) =
  16ul

let key29: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x02uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key29_len: (x:UInt32.t { UInt32.v x = B.length key29 }) =
  32ul

let tag29: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x03uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag29_len: (x:UInt32.t { UInt32.v x = B.length tag29 }) =
  16ul

let input30: (b: B.buffer UInt8.t { B.length b = 48 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xf0uy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0x11uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 48);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input30_len: (x:UInt32.t { UInt32.v x = B.length input30 }) =
  48ul

let key30: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x01uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key30_len: (x:UInt32.t { UInt32.v x = B.length key30 }) =
  32ul

let tag30: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x05uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag30_len: (x:UInt32.t { UInt32.v x = B.length tag30 }) =
  16ul

let input31: (b: B.buffer UInt8.t { B.length b = 48 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xfbuy; 0xfeuy; 0xfeuy; 0xfeuy; 0xfeuy; 0xfeuy; 0xfeuy; 0xfeuy; 0xfeuy; 0xfeuy; 0xfeuy; 0xfeuy; 0xfeuy; 0xfeuy; 0xfeuy; 0xfeuy; 0x01uy; 0x01uy; 0x01uy; 0x01uy; 0x01uy; 0x01uy; 0x01uy; 0x01uy; 0x01uy; 0x01uy; 0x01uy; 0x01uy; 0x01uy; 0x01uy; 0x01uy; 0x01uy; ] in
  assert_norm (List.Tot.length l = 48);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input31_len: (x:UInt32.t { UInt32.v x = B.length input31 }) =
  48ul

let key31: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x01uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key31_len: (x:UInt32.t { UInt32.v x = B.length key31 }) =
  32ul

let tag31: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag31_len: (x:UInt32.t { UInt32.v x = B.length tag31 }) =
  16ul

let input32: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xfduy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input32_len: (x:UInt32.t { UInt32.v x = B.length input32 }) =
  16ul

let key32: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x02uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key32_len: (x:UInt32.t { UInt32.v x = B.length key32 }) =
  32ul

let tag32: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xfauy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; 0xffuy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag32_len: (x:UInt32.t { UInt32.v x = B.length tag32 }) =
  16ul

let input33: (b: B.buffer UInt8.t { B.length b = 64 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xe3uy; 0x35uy; 0x94uy; 0xd7uy; 0x50uy; 0x5euy; 0x43uy; 0xb9uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x33uy; 0x94uy; 0xd7uy; 0x50uy; 0x5euy; 0x43uy; 0x79uy; 0xcduy; 0x01uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x01uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 64);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input33_len: (x:UInt32.t { UInt32.v x = B.length input33 }) =
  64ul

let key33: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x01uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x04uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key33_len: (x:UInt32.t { UInt32.v x = B.length key33 }) =
  32ul

let tag33: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x14uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x55uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag33_len: (x:UInt32.t { UInt32.v x = B.length tag33 }) =
  16ul

let input34: (b: B.buffer UInt8.t { B.length b = 48 /\ B.recallable b }) =
  [@inline_let] let l = [ 0xe3uy; 0x35uy; 0x94uy; 0xd7uy; 0x50uy; 0x5euy; 0x43uy; 0xb9uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x33uy; 0x94uy; 0xd7uy; 0x50uy; 0x5euy; 0x43uy; 0x79uy; 0xcduy; 0x01uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 48);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let input34_len: (x:UInt32.t { UInt32.v x = B.length input34 }) =
  48ul

let key34: (b: B.buffer UInt8.t { B.length b = 32 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x01uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x04uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 32);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let key34_len: (x:UInt32.t { UInt32.v x = B.length key34 }) =
  32ul

let tag34: (b: B.buffer UInt8.t { B.length b = 16 /\ B.recallable b }) =
  [@inline_let] let l = [ 0x13uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; 0x00uy; ] in
  assert_norm (List.Tot.length l = 16);
  B.gcmalloc_of_list HyperStack.root l

inline_for_extraction let tag34_len: (x:UInt32.t { UInt32.v x = B.length tag34 }) =
  16ul

noeq
type vector = | Vector:
  tag: B.buffer UInt8.t { B.recallable tag } ->
  tag_len: UInt32.t { B.length tag = UInt32.v tag_len } ->
  key: B.buffer UInt8.t { B.recallable key } ->
  key_len: UInt32.t { B.length key = UInt32.v key_len } ->
  input: B.buffer UInt8.t { B.recallable input } ->
  input_len: UInt32.t { B.length input = UInt32.v input_len } ->
  vector

let vectors: (b: B.buffer vector { B.length b = 35 /\ B.recallable b }) =
  [@inline_let] let l = [ 
    Vector tag0 tag0_len key0 key0_len input0 input0_len ;
    Vector tag1 tag1_len key1 key1_len input1 input1_len ;
    Vector tag2 tag2_len key2 key2_len input2 input2_len ;
    Vector tag3 tag3_len key3 key3_len input3 input3_len ;
    Vector tag4 tag4_len key4 key4_len input4 input4_len ;
    Vector tag5 tag5_len key5 key5_len input5 input5_len ;
    Vector tag6 tag6_len key6 key6_len input6 input6_len ;
    Vector tag7 tag7_len key7 key7_len input7 input7_len ;
    Vector tag8 tag8_len key8 key8_len input8 input8_len ;
    Vector tag9 tag9_len key9 key9_len input9 input9_len ;
    Vector tag10 tag10_len key10 key10_len input10 input10_len ;
    Vector tag11 tag11_len key11 key11_len input11 input11_len ;
    Vector tag12 tag12_len key12 key12_len input12 input12_len ;
    Vector tag13 tag13_len key13 key13_len input13 input13_len ;
    Vector tag14 tag14_len key14 key14_len input14 input14_len ;
    Vector tag15 tag15_len key15 key15_len input15 input15_len ;
    Vector tag16 tag16_len key16 key16_len input16 input16_len ;
    Vector tag17 tag17_len key17 key17_len input17 input17_len ;
    Vector tag18 tag18_len key18 key18_len input18 input18_len ;
    Vector tag19 tag19_len key19 key19_len input19 input19_len ;
    Vector tag20 tag20_len key20 key20_len input20 input20_len ;
    Vector tag21 tag21_len key21 key21_len input21 input21_len ;
    Vector tag22 tag22_len key22 key22_len input22 input22_len ;
    Vector tag23 tag23_len key23 key23_len input23 input23_len ;
    Vector tag24 tag24_len key24 key24_len input24 input24_len ;
    Vector tag25 tag25_len key25 key25_len input25 input25_len ;
    Vector tag26 tag26_len key26 key26_len input26 input26_len ;
    Vector tag27 tag27_len key27 key27_len input27 input27_len ;
    Vector tag28 tag28_len key28 key28_len input28 input28_len ;
    Vector tag29 tag29_len key29 key29_len input29 input29_len ;
    Vector tag30 tag30_len key30 key30_len input30 input30_len ;
    Vector tag31 tag31_len key31 key31_len input31 input31_len ;
    Vector tag32 tag32_len key32 key32_len input32 input32_len ;
    Vector tag33 tag33_len key33 key33_len input33 input33_len ;
    Vector tag34 tag34_len key34 key34_len input34 input34_len ;
  ] in
  assert_norm (List.Tot.length l = 35);
  B.gcmalloc_of_list HyperStack.root l

let vectors_len: (x:UInt32.t { UInt32.v x = B.length vectors }) =
  35ul
