type t

exception Error of int

external get_error_message : int -> string = "ocaml_faad_get_error_message"

let () =
  Callback.register_exception "ocaml_faad_exn_error" (Error 0)

external create : unit -> t = "ocaml_faad_open"

external close : t -> unit = "ocaml_faad_close"

external init : t -> string -> int -> int -> int * int = "ocaml_faad_init"

external decode : t -> string -> int -> int -> int * (float array array) = "ocaml_faad_decode"

let find_frame buf =
  let i = ref 0 in
  let found = ref false in
    while !i < String.length buf - 1 && not !found do
      if buf.[!i] = '\255' then
        if int_of_char buf.[!i+1] land 0xf6 = 0xf0 then
          found := true
        else
          incr i
      else
        incr i
    done;
    if !found then !i else raise Not_found
