Invalid package versions should be reported by Dune. We should also give a hint for common
invalid versions such as foo.1.2.3, which can result from a users false assumption from
opam.

  $ cat > dune-project <<EOF
  > (lang dune 3.12)
  > (package
  >  (name invalid)
  >  (allow_empty)
  >  (depends foo.1.2.3))
  > EOF

Building doesn't raise any error about the invalid version.

  $ dune build

Even generating .opam files doesn't raise any error about the version.

  $ cat >> dune-project <<EOF
  > (generate_opam_files true)
  > EOF

  $ dune build invalid.opam

We can take this further and add some really invalid characters into the name:

  $ cat > dune-project <<EOF
  > (lang dune 3.12)
  > (package
  >  (name invalid)
  >  (allow_empty)
  >  (depends f{oo."1.2.3"))
  > (generate_opam_files true)
  > EOF

  $ dune build invalid.opam

  $ cat invalid.opam
  # This file is generated by dune, edit dune-project instead
  opam-version: "2.0"
  depends: [
    "dune" {>= "3.12"}
    "f{oo."
    "1.2.3"
    "odoc" {with-doc}
  ]
  build: [
    ["dune" "subst"] {dev}
    [
      "dune"
      "build"
      "-p"
      name
      "-j"
      jobs
      "@install"
      "@runtest" {with-test}
      "@doc" {with-doc}
    ]
  ]

