(*
 * data.mli
 * 
 * This file is part of the Oxford Oberon-2 compiler
 * Copyright (c) 2006 J. M. Spivey
 * All rights reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: data.mli 1484 2009-12-22 17:27:31Z mike $
 *)

(* dynvalue -- type of runtime values *)
type dynvalue

val type_of : dynvalue -> Dict.otype

val void_value : dynvalue

(* def_value -- get value of a definition *)
val def_value : int32 -> Dict.def -> dynvalue

val null_pointer : dynvalue -> bool

val deref : dynvalue -> dynvalue

val subscript : dynvalue -> int -> dynvalue

val select : dynvalue -> Dict.def -> dynvalue

(*

val get_addr : dynvalue -> int32

val fetch_value : Dict.otype -> int32 -> dynvalue

val deref_type : Dict.otype -> dynvalue -> Dict.otype

val index : Dict.otype -> int32 -> int -> Dict.otype * dynvalue

*)

(* fDynVal -- format a dynamic value *)   
val fDynVal : dynvalue -> Print.arg

(* fLongVal -- format a dynamic value, printing its fields if a record *)
val fLongVal : dynvalue -> Print.arg

(* fType -- format a type *)
val fType : Dict.otype -> Print.arg

val fFrame : Binary.regs -> Print.arg
