TEMPLATE = """## Makefile.am generated by the makefiler script
##
# FileName	[ Makefile ]
#
# PackageName	[ NuSMV ]
#
# Synopsis	[ Package-wide Makefile ]
#
# Description	[ Makefile template for the NuSMV executable ]
#
# Author	[ Roberto Cavada ]
#
# Copyright	[Copyright (C) 2004 by ITC-irst ]
#
# NuSMV version 2 is free software; you can redistribute it and/or 
# modify it under the terms of the GNU Lesser General Public 
# License as published by the Free Software Foundation; either 
# version 2 of the License, or (at your option) any later version.
#
# NuSMV version 2 is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public 
# License along with this library; if not, write to the Free Software 
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.
#
# For more information on NuSMV see <http://nusmv.fbk.eu>
# or email to <nusmv-users@fbk.eu>.
# Please report bugs to <nusmv-users@fbk.eu>.
#
# To contact the NuSMV development board, email to <nusmv@fbk.eu>.]
#
# Revision	[$Id: makefiler.py,v 1.1.2.3.4.2 2005-11-04 08:37:57 nusmv Exp $]

AUTOMAKE_OPTIONS = subdir-objects

CUDD_NAME = $(cuddname)
CUDD_DIR = ../$(CUDD_NAME)

INCLUDES = -I. -I.. -I$(top_srcdir)/src -I$(top_srcdir)/$(CUDD_DIR)/include

PKG_SOURCES = %(pkg_sources)s

%(pkg_name)sdir = $(includedir)/nusmv/%(pkg_name)s
nobase_%(pkg_name)s_HEADERS = 

# -------------------------------------------------------

noinst_LTLIBRARIES = lib%(pkg_name)s.la
lib%(pkg_name)s_la_SOURCES = $(PKG_SOURCES)

"""

PKGS = """
be cmd dag enc ltl mc opt prop sat set 
simulate trans bmc compile dd fsm node parser rbc sim 
sm utils
"""

src_path = ".."
# ----------------------------------------------------------------------


def order_filenames(files, prefix_path):
    from os.path import splitext

    h = filter(lambda x: splitext(x)[1] == ".h", files)
    c = filter(lambda x: splitext(x)[1] == ".c", files)

    index = len(prefix_path+"/")
    h = map(lambda x: x[index:], h)
    c = map(lambda x: x[index:], c)
    h.sort; c.sort()
    return h+c


def pritty_splitter(str, length=50, tabs=-1):
    ls = str.split()
    res = ""
    le = 0
    if tabs >= 0: tab = " " * tabs
    else: tab = "\t"
    
    for l in ls:
        res += l + " "
        le += len(l) + 1
        if le >= length and l != ls[-1]:
            res += "\\\n" + tab
            le = 0
            pass
        pass
    
    return res
    


def main():
    import os.path    
    from extractors.file_searcher import FileSearcher
    
    for pkg_name in PKGS.split():

        fs = FileSearcher("*.[hc]")
        path = os.path.join(src_path, pkg_name)

        assert os.path.isdir(path)
        
        fs.search(path)
        files = fs.get_matches()
        files = order_filenames(files, path)
        pkg_sources = pritty_splitter(" ".join(files))

        template = TEMPLATE % { 'pkg_name' : pkg_name,
                                'pkg_sources' : pkg_sources}

        filename = os.path.join(path, "Makefile.am")
        f = open(filename, "w")
        f.write(template)
        f.close()

        print "Written " + filename    
        pass

    return 0

if __name__ == "__main__":
    main()
    pass

