class NSM_Console
  NSMVERSION = "0.7"
  $PROMPT = "nsm> "
  $CPROMPT = "\033[32mnsm\033[0m> "

  # Save our default standard out
  $DEF_STDOUT = STDOUT.dup
  
  def initialize(args)
    ## Print the lobster
    print_banner()
    puts "NSM Console version #{NSMVERSION}"
    print "\n"

    ## Set {$PCAP_FILE} if passed in as an argument
    CommandManager.execute("file",args[0]) if args.length > 0

    ## Load modules
    load_modules($moduledir)
    load_categories($moduledir)

    ## Initialize logging
    logfilename = "logs/nsm-log."
    logfilename.concat(Time.now.year.to_s)
    logfilename.concat(Time.now.month.to_s)
    logfilename.concat(Time.now.day.to_s)
    logfilename.concat(".log")
    
    start_logging(logfilename)

    puts $color ? "Default ${#{$MAGENTA}OUTPUT_DIR#{$RESET}} is '#{$outputdir}'" : "Default ${OUTPUT_DIR} is '#{$outputdir}'"
    puts $color ? "Default ${#{$MAGENTA}MODULE_DIR#{$RESET}} is '#{$moduledir}'" : "Default ${MODULE_DIR} is '#{$moduledir}'"

    cmd = ""

    print "\n"
    
    ## Read ~/.nsmcrc
    rcfile = ENV['HOME']
    rcfile += "/.nsmcrc"
    if File.exist?(rcfile)
      print "Reading ~/.nsmcrc..."
      old_stdout = STDOUT.dup
      STDOUT.reopen( PLATFORM =~ /mswin/ ? "NUL" : "/dev/null" )
      read_dotnsmcrc(rcfile)
      STDOUT.reopen(old_stdout)
      print "done.\n\n"
    end
  end

  def start_logging(logfilename)
    puts "Logging to #{logfilename}\n\n"
    Logger.new(logfilename)
    ## Write initial entry
    Logger.write("-" * 80)
    Logger.write("\n")
    Logger.write("Log for nsm-console begun at #{Time.now.year}\
                 -#{Time.now.month}-#{Time.now.day} #{Time.now.hour}\
                 :#{Time.now.min}:#{Time.now.sec}\n")
    Logger.write("-" * 80)
    Logger.write("\n")
  end

  def start_shell
    ## Command loop until quit
    loop {

      ## New method uses readline so we can use tab-completion
      begin
        # I put this line in because after piping the prompt wouldn't show up
        if STDOUT != $DEF_STDOUT
          print "\n"
        end

        p = $color ? $CPROMPT : $PROMPT
        cmd = readline("#{p}", TRUE)
      rescue Interrupt
        puts "Caught ^C, use 'quit' or 'q' to exit"
      rescue
        STDERR.puts "Error encountered: #{$!}"
      end

      # Check for our pipes, split our cmd into regular cmd and pipeout if
      # we find one
      unless cmd.nil?
        if cmd =~ /((\||<|>)+)/
          token = $1
          n = cmd.split(token)
          cmd = n[0].dup.strip
          pipeout = n[1].dup.strip
          #puts "Cmd: #{cmd} will be #{token}'d into #{pipeout}"

          if token == "|"
            ## Regular File.open will *NOT* open pipes, Kernel.open will
            fd = Kernel.open("#{token} #{pipeout}","w")
            STDOUT.reopen(fd)
          elsif token == ">"
            STDOUT.reopen("#{pipeout}", "w")
          elsif token == ">>"
            STDOUT.reopen("#{pipeout}", "a")
          else
            STDERR.puts "Err...haven't implemented '<' yet."
            next
          end
        end
      end

      ## Split the command into function and arguments
      unless cmd.nil?
        cmd.gsub!(/(\w)\s([\s\S]*)/) { $1 }
        cmd.chomp!
        args = $2
        args.strip! unless args.nil?
        
        ## Check our aliases and substitute if any match
        a = NSM_Alias.get_alias(cmd)
        unless a.nil?
          cmd = String.new(a)
          cmd.gsub!(/(\w)\s([\s\S]*)/) { $1 }
          cmd.chomp!
          ## We concatinate our old args with the args from the alias
          unless args.nil?
            newargs = $2 + " " + args
            newargs.strip!
            args = String.new(newargs)
          else
            args = String.new($2.to_s.strip)
          end
        end

        begin
          Logger.write("[nsmcmd] #{cmd} #{args}\n")
          History.write("#{cmd} #{args}")
          CommandManager.execute(cmd,args) unless cmd.length < 1
        rescue Interrupt
          puts "Caught ^C, use 'quit' or 'q' to exit"
        rescue LocalJumpError
          ## Ignore LocalJumpErrors, it just means we returned
        rescue NoMethodError
          puts "Command '#{cmd}' unrecognized. Try 'help' for a list of commands."
        rescue
          STDERR.puts "Error encountered: #{$!}"
        end
      end

      # restore STDOUT
      STDOUT.reopen($DEF_STDOUT)

    }
  end

  def run
    puts "=-" * 35
    puts "Welcome to #{$WHITE}NSM Console#{$RESET}, type '#{$WHITE}help#{$RESET}' to see available commands"
    puts "=-" * 35
    puts "Note: All modules are DISABLED by default, use '#{$WHITE}list#{$RESET}' to list available"
    puts "modules and '#{$WHITE}toggle <module>#{$RESET}' to disable/enable a module.\n\n"

    start_shell()
  end
end
