#
# discover-snmpd.tm
#
# $Id: discover-snmpd.tm,v 1.17 2003/06/21 16:40:16 rader Exp $
#

#==============================================================================

sub print_load_conf {
  $t = "$target-snmpd-load5";
  print <<__EOT__;
#------------------------------------------------------------------

System[$t]:             ${comm_str}\@${host}
RRD[$t]:                ${root}${prefix}/load5/${t}.rrd
GraphWebPage[$t]:       ${root}${prefix}/load5/${t}.cgi
Variable[$t][load5int]: ucd-snmpd.laLoadInt5 GAUGE
__EOT__

if ( $runscript ) {
print <<__EOT__;
RunScript[$t]:          $runscript
__EOT__
}

print <<__EOT__;

PageTitle[$t]:  ${target}'s System Load Graphs
PageTop[$t]:    ${target}'s System Load Graphs <P>
PageBottom[$t]: ${target}'s System Load Graphs

__EOT__

}
#==============================================================================

sub print_mem_conf {
  local($instance) = @_;

  $t = "$target-snmpd-mem";

  print <<__EOT__;
#------------------------------------------------------------------

System[$t]:               ${comm_str}\@${host}
RRD[$t]:                  ${root}${prefix}/mem/${t}.rrd
GraphWebPage[$t]:         ${root}${prefix}/mem/${t}.cgi
Variable[$t][free_mem]:   ucd-snmpd.memAvailReal.0 GAUGE
Variable[$t][buff_mem]:    ucd-snmpd.memBuffer.0 GAUGE
Variable[$t][cache_mem]:  ucd-snmpd.memCached.0 GAUGE
Variable[$t][total_mem]:  ucd-snmpd.memTotalReal.0 GAUGE
__EOT__

if ( $runscript ) {
print <<__EOT__;
RunScript[$t]:            $runscript
__EOT__
}

print <<__EOT__;

PageTitle[$t]:   ${target}'s Real Memory Utilization Graphs
PageTop[$t]:     ${target}'s Real Memory Utilization Graphs <P>
PageBottom[$t]:  ${target}'s Real Memory Utilization Graphs

__EOT__

}

#==============================================================================

sub print_swap_conf {
  local($instance) = @_;

  $t = "$target-snmpd-swap";

  print <<__EOT__;
#------------------------------------------------------------------

System[$t]:               ${comm_str}\@${host}
RRD[$t]:                  ${root}${prefix}/swap/${t}.rrd
GraphWebPage[$t]:         ${root}${prefix}/swap/${t}.cgi
Variable[$t][free_swp]:   ucd-snmpd.memAvailSwap.0 GAUGE
Variable[$t][total_swp]:  ucd-snmpd.memTotalSwap.0 GAUGE
__EOT__

if ( $runscript ) {
print <<__EOT__;
RunScript[$t]:            $runscript
__EOT__
}

  print <<__EOT__;

PageTitle[$t]:   ${target}'s Virtual Memory Utilization Graphs
PageTop[$t]:     ${target}'s Virtual Memory Utilization Graphs <P>
PageBottom[$t]:  ${target}'s Virtual Memory Utilization Graphs

__EOT__

}

#==============================================================================

sub print_df_conf {
  local($t) = @_;

  $dev = "$filesystem_details{$instance}{'diskDevice'}";
  $filesystem = "$filesystem_details{$instance}{'diskPath'}";
  $fs = $filesystem;
  $fs =~ s/^\/$/slash/;
  $fs =~ s/^\///g;
  $fs =~ s/\//-/g;
  $t = "$target-snmpd-df-$fs";

  print <<__EOT__;
#------------------------------------------------------------------

System[$t]:           ${comm_str}\@${host}
RRD[$t]:              ${root}${prefix}/df/${t}.rrd
GraphWebPage[$t]:     ${root}${prefix}/df/${t}.cgi
Variable[$t][used]:   ucd-snmpd.diskUsed.$instance GAUGE
Variable[$t][total]:  ucd-snmpd.diskTotal.$instance GAUGE
__EOT__

if ( $t =~ /dos$/ ) {
  print <<__EOT__;
CalcDef[$t][total_m]: total,1024,*,32,*
CalcDef[$t][used_m]:  used,1024,*,32,*
__EOT__
}
if ( $runscript ) {
print <<__EOT__;
RunScript[$t]:        $runscript
__EOT__
}

  print <<__EOT__;
Label[$t][used_m]:    "$filesystem used  "
Label[$t][usable_m]:  "$filesystem usable"
Label[$t][total_m]:   "$filesystem total "

PageTitle[$t]:   ${target}'s Disk Utilization Graphs for $filesystem
PageTop[$t]:     ${target}'s Disk Utilization Graphs for $filesystem <P>
PageBottom[$t]:  ${target}'s Disk Utilization Graphs for $filesystem

__EOT__
}

#==============================================================================

return 1;

