/*
 *  $Id: write_stats.c,v 1.18 2006/01/30 12:09:25 rader Exp $
 */

#include <stdio.h>
#include <signal.h>
#ifdef __FreeBSD__
#include <limits.h> 
#else
#include <values.h>
#endif
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <errno.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include "pingd.h"

extern int polling_interval;
extern int packet_size;
extern struct ping_list_entry *ping_list[];
extern int ping_list_size;
extern int interpacket_delay;

char pingstats_file[MAX_PATH_LENGTH];

/*------------------------------------------------------------------*/

write_stats_file()
{
  FILE *fp;
  time_t now = time(&now);
  struct tm *now_tm;
  char now_str[27];
  int i, j;
  int data_point_count, loss_data_point_count, loss_count;
  int min, max, loss;

  sprintf(pingstats_file, "%s/%s", PREFIX, PINGD_STATS_FILE);
  debug("  write_stats_file() to %s\n", pingstats_file);
  if ((fp = fopen(pingstats_file, "w+")) == NULL) {
    fprintf(stderr,"fopen %s ",pingstats_file);
    perror("failed");
    exit(1);
  }
  now_tm = (struct tm *)localtime(&now);
  strncpy(now_str,asctime(now_tm),25);
  now_str[24] = '\0';
  fprintf(fp, "\n");
  fprintf(fp, " pingd statistics from %s (%d)\n", now_str, now);
  fprintf(fp, "\n");
  fprintf(fp, " packet size is %d bytes\n", packet_size);
  fprintf(fp, " interpacket delay for all nodes is %d msecs\n", interpacket_delay);
  fprintf(fp, " number of data points for each node is %d pings\n", NUM_DATA_POINTS);
  fprintf(fp, " packet polling interval for each node is %d seconds\n", polling_interval);
  fprintf(fp, " complete polling interval for each node is %d seconds\n\n",
    NUM_DATA_POINTS * polling_interval);
fprintf(fp,"address          name                    min    ave    max    loss\n");
fprintf(fp,"---------------  --------------------   -----  -----  -----  -----------------\n");

  for ( i = 0; i < ping_list_size; i++ ) {
    data_point_count = loss_data_point_count = loss_count = 0;
#ifdef __FreeBSD__
    min = INT_MAX;
#else 
    min = MAXINT;
#endif
    max = NO_MAX_SET;
    for ( j = 0; j < NUM_DATA_POINTS; j++ ) {
      if ( ping_list[i]->n_latency_data[j] == NO_VALUE_SET ) {
        continue;
      }
      if ( ping_list[i]->n_latency_data[j] == NOT_RESPONDING ) {
        loss_count++;
        loss_data_point_count++;
        continue;
      }
      if ( ping_list[i]->n_latency_data[j] > max ) {
        max = ping_list[i]->n_latency_data[j];
      } 
      if ( ping_list[i]->n_latency_data[j] >= 0 && 
           ping_list[i]->n_latency_data[j] < min ) {
        min = ping_list[i]->n_latency_data[j];
      }
      data_point_count++;
      loss_data_point_count++;
    }
    if ( loss_data_point_count == 0 ) {
      /* no data points means 100% packet loss... */
      loss = 100; 
    } else {
      loss = (loss_count * 100) / loss_data_point_count;
    }

    debug("  node %d: data_points=%d min=%d ave=%d max=%d loss=%d%% (%d of %d)\n",
      i, data_point_count, min, ping_list[i]->n_latency_ave, max, 
      loss, loss_count, loss_data_point_count);
    fprintf(fp,"%-15s  %-20s  ", ping_list[i]->n_addr, ping_list[i]->n_name);
    dataprintf(fp,min);
    dataprintf(fp,ping_list[i]->n_latency_ave);
    dataprintf(fp,max);
    fprintf(fp," %4d%%  (%d of %d)\n", 
      loss, loss_count, loss_data_point_count);
  }
  fprintf(fp, "\n");
  (void)fclose(fp);
}

/*------------------------------------------------------------------*/

dataprintf(fp, arg)
FILE *fp;
int arg;
{
  switch (arg) {
    case NOT_RESPONDING: {
      fprintf(fp,"  NaN  ");
      break;
    }
    case NO_VALUE_SET: {
      fprintf(fp,"  NaN  ");
      break;
    }
#ifdef __FreeBSD__
    case INT_MAX: {
#else
    case MAXINT: {
#endif
      fprintf(fp,"  NaN  ");
      break;
    }
    case NO_MAX_SET: {
      fprintf(fp,"  NaN  ");
      break;
    }
    default: {
      fprintf(fp," %4d  ",arg);
    }
  }
}

