/* 
 *  $Id: packet.c,v 1.9 2001/05/03 01:07:29 rader Exp $
 */

#include <stdio.h>
#include <sys/file.h>
#include <sys/param.h>
#include <sys/socket.h>
#ifndef __SOLARIS__
#include <sys/socketvar.h>
#endif
#include <sys/time.h>
#include <sys/types.h>
#include <netdb.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <arpa/inet.h>
#include "pingd.h"

extern int packet_size;

int icmp_ident;
char *ping_packet;

/*------------------------------------------------------------------*/

malloc_ping_packet()
{
  debug("mallocing %d bytes for packet\n", packet_size);
  if ((ping_packet = (u_char *)malloc((unsigned) packet_size)) == NULL) {
    fprintf(stderr,"fatal error: malloc failed while creating ping packet\n");
    exit(1);
  }
  memset(ping_packet, 0, packet_size);
}

/*------------------------------------------------------------------*/

set_icmp_identifer()
{
  icmp_ident = getpid() & 0xffff;
  debug("setting icmp identifer to %d\n", icmp_ident);
}

/*------------------------------------------------------------------*/

static unsigned int calc_checksum(addr,len)
u_short *addr;
int len;
{
  register int nleft = len;
  register u_short *w = addr;
  register u_short answer;
  register int sum = 0;
  extern time_t time();

  while( nleft > 1 )  {
    sum += *w++;
    nleft -= 2;
  }
  if( nleft == 1 )
    sum += *(u_char *)w;
  sum = (sum >> 16) + (sum & 0xffff);
  sum += (sum >> 16);
  answer = ~sum;
  return (answer);
}

/*------------------------------------------------------------------*/

create_icmp_header(address,header,sock,seq)
char *address;
struct icmp *header;
struct sockaddr *sock;
int seq;
{
  struct sockaddr_in *to;

  debug("  creating icmp header for %s\n", address);
  if ((address == NULL) || (header == NULL) || (sock == NULL))
    return(-1);
  to = (struct sockaddr_in *)sock;
  memset((char *)to, 0, sizeof(struct sockaddr));
#ifndef __OSF1__
  if ((to->sin_addr.s_addr = inet_addr(address)) == -1L)
#else
  if ((to->sin_addr.s_addr = inet_addr(address)) == (in_addr_t)-1)
#endif
    return(-1);
  to->sin_family = AF_INET;
  to->sin_port = htons(0);
  header->icmp_type = ICMP_ECHO;
  header->icmp_code = 0;
  header->icmp_seq = seq;
  header->icmp_id = icmp_ident;
  header->icmp_cksum = calc_checksum((u_short *)header, sizeof(struct icmp));
  return(0);
}
