# vi: filetype=perl6:
sub comment($comment) {
    say("# $comment");
}
sub constant($name, $value) {
    say("$name = $value");
}

sub stage_path($stage) {
    '$(JS_STAGE' ~ $stage ~ ')/';
}

sub make_parents($path) {
    my $parts := nqp::split("/",$path);
    nqp::pop($parts);
    '$(MKPATH) ' ~ nqp::join('/',$parts);
}

sub rule($target, $source, *@actions) {
    my $rule := "$target: $source\n";
    for @actions -> $action {
        if $rule ne '' {
            $rule := $rule ~ "\t$action\n";
        }
    }
    say($rule);
    $target;
}

sub nqp($prefix, $file, $stage, :$source=$prefix ~ '/' ~ $file ~ '.nqp', :$deps=[]) {
    my $path := stage_path($stage);
    my $mbc := $path ~ $file ~ '.moarvm';

    my $installed_pbc := 'gen/moar/stage2/' ~ $file ~ '.moarvm';

    nqp::unshift($deps, $source);

    rule($mbc, nqp::join(' ', $deps),
        make_parents($mbc),
        "\$(JS_NQP) --module-path=\$(JS_STAGE1) --target=mbc --output=$mbc $source",
        # HACK - workaround for not being able to supply multiple directories to --module-path
        make_parents($installed_pbc),
        "\$(CP) $mbc $installed_pbc"
    );
}

sub deps($target, *@deps) {
    say("$target : {nqp::join(' ',@deps)}");
}

# TODO is the version regenerated as often as it should
sub combine(:$sources, :$stage, :$file, :$gen-version = 0) {

    my $target := stage_path($stage) ~ $file;
    my $version := stage_path($stage) ~ 'nqp-config.nqp';

    rule($target, $sources,
        make_parents($target),
        $gen-version ?? "\$(PERL) tools/build/gen-version.pl > $version" !! '',
        "\$(PERL) tools/build/gen-cat.pl js $sources {$gen-version ?? $version !! ''} > $target"
    ); 
}

my $nqp-js-on-js := 'nqp-js-on-js';

sub cross-compile(:$stage, :$source, :$target, :$setting='NQPCORE', :$no-regex-lib=1, :$deps = []) {
    my $path := stage_path($stage);
    my $moarvm := $path ~ $target ~ '.moarvm';
    # todo dependency on compiler
    
    nqp::unshift($deps, $source);
    nqp::unshift($deps, '$(JS_STAGE1_COMPILER)');

    my $replaced-target := subst($target, /\//, '-');
    my $js := "$nqp-js-on-js/$replaced-target.js";


    rule($moarvm, nqp::join(' ', $deps), 
        make_parents($moarvm),
        make_parents($js),
	"\$(JS_NQP) --module-path gen/js/stage1 src/vm/js/bin/cross-compile.nqp --setting=$setting --target=mbc --output $moarvm {$no-regex-lib ?? "--no-regex-lib" !! ""} $source > $js"
        );
}





comment("This is the JS Makefile - autogenerated by gen-js-makefile.nqp");

constant('JS_BUILD_DIR','gen/js');
constant('JS_STAGE1','$(JS_BUILD_DIR)/stage1');
constant('JS_STAGE2','$(JS_BUILD_DIR)/stage2');
constant('JS_NQP','./$(M_RUNNER)$(BAT)');


say('js-runner-default: js-all');

my $QASTCompiler-combined := combine(:stage(1), :sources('src/vm/js/Utils.nqp src/vm/js/SerializeOnce.nqp src/vm/js/const_map.nqp src/vm/js/LoopInfo.nqp src/vm/js/ReturnInfo.nqp src/vm/js/BlockBarrier.nqp src/vm/js/DWIMYNameMangling.nqp src/vm/js/Chunk.nqp src/vm/js/Operations.nqp src/vm/js/RegexCompiler.nqp src/vm/js/Compiler.nqp'), :file('QASTCompiler.nqp'));


my $stage1-qast-compiler-moar := nqp('src/vm/js','QAST/Compiler',1, :source($QASTCompiler-combined));
my $stage1-hll-backend-moar := nqp('src/vm/js','HLL/Backend',1,:deps([$stage1-qast-compiler-moar]));

constant('JS_STAGE1_COMPILER',"$stage1-qast-compiler-moar $stage1-hll-backend-moar");


my $nqp-mo-combined := combine(:stage(2), :sources('$(NQP_MO_SOURCES)'), :file('$(NQP_MO_COMBINED)'));

my $nqp-mo-moarvm := cross-compile(:stage(2), :source($nqp-mo-combined), :target('nqpmo'), :setting('NULL'), :no-regex-lib(1));


my $nqpcore-combined := combine(:stage(2), :sources('$(CORE_SETTING_SOURCES)'), :file('$(CORE_SETTING_COMBINED).nqp'));

my $nqpcore-moarvm := cross-compile(:stage(2), :source($nqpcore-combined), :deps([$nqp-mo-moarvm]), :setting('NULL'), :target('NQPCORE.setting'));


my $QASTNode-combined := combine(:stage(2), :sources('$(QASTNODE_SOURCES)'), :file('$(QASTNODE_COMBINED)'));
my $QASTNode-moarvm := cross-compile(:stage(2), :source($QASTNode-combined), :target('QASTNode'), :setting('NQPCORE'), :no-regex-lib(1), :deps([$nqpcore-moarvm]));

my $QRegex-combined := combine(:stage(2), :sources('$(QREGEX_SOURCES)'), :file('$(QREGEX_COMBINED)'));
my $QRegex-moarvm := cross-compile(:stage(2), :source($QRegex-combined), :target('QRegex'), :setting('NQPCORE'), :no-regex-lib(1), :deps([$nqpcore-moarvm, $QASTNode-moarvm]));

my $sprintf-moarvm := cross-compile(:stage(2), :source('src/HLL/sprintf.nqp'), :target('sprintf'), :setting('NQPCORE'), :deps([$nqpcore-moarvm, $QRegex-moarvm]), :no-regex-lib(0)); 

deps('js-stage1-compiler', '$(JS_STAGE1_COMPILER)');

say('js-test: js-all gen/js/qregex.t
	perl src/vm/js/bin/run_tests.pl');

say('js-test-bootstrapped: js-bootstrap gen/js/qregex.t
	perl src/vm/js/bin/run_tests_bootstrapped.pl');

say('gen/js/qregex.t: tools/build/process-qregex-tests
	$(JS_NQP) tools/build/process-qregex-tests > gen/js/qregex.t');

say("\n\njs-clean:
	\$(RM_RF) gen/js/stage1 gen/js/stage2
");

my $ModuleLoader := "$nqp-js-on-js/ModuleLoader.js";

deps("js-all", 'm-all', 'js-stage1-compiler', $nqpcore-moarvm, $nqpcore-combined, $QASTNode-moarvm, $QRegex-moarvm, $sprintf-moarvm, $ModuleLoader);

# Enforce the google coding standards
say("js-lint:
	gjslint --strict --max_line_length=200 --nojsdoc src/vm/js/nqp-runtime/*.js");

say('js-install: js-all
	@echo "*** The JavaScript backend can\'t be installed yet, sorry! ***"');

constant('JS_NQP_SOURCES', '$(COMMON_NQP_SOURCES)');



my $nqp-combined := combine(:stage(2), :sources('$(JS_NQP_SOURCES)'), :file('$(NQP_COMBINED)'), :gen-version(1));

constant('JS_HLL_SOURCES', 'src/vm/js/HLL/Backend.nqp $(COMMON_HLL_SOURCES)');

my $hll-combined := combine(:stage(2), :sources('$(JS_HLL_SOURCES)'), :file('$(HLL_COMBINED)'));



my $QAST-Compiler-moarvm := cross-compile(:stage(2), :source($QASTCompiler-combined), :target('QAST/Compiler'), :setting('NQPCORE'), :no-regex-lib(1), :deps([$nqpcore-moarvm, $QASTNode-moarvm]));


my $QAST-moarvm := cross-compile(:stage(2), :source('src/vm/js/QAST.nqp'), :target('QAST'), :setting('NQPCORE'), :no-regex-lib(1), :deps([$nqpcore-moarvm, $QAST-Compiler-moarvm]));


my $hll-moar := cross-compile(:stage(2), :source($hll-combined), :target('NQPHLL'), :setting('NQPCORE'), :no-regex-lib(1), :deps([$nqpcore-moarvm, $QAST-Compiler-moarvm, $QRegex-moarvm]));

my $p6qregex-combined := combine(:stage(2), :sources('$(P6QREGEX_SOURCES)'), :file('$(P6QREGEX_COMBINED)'));

my $p5qregex-combined := combine(:stage(2), :sources('$(P5QREGEX_SOURCES)'), :file('$(P5QREGEX_COMBINED)'));



my $NQPP5QRegex-moarvm := cross-compile(:stage(2), :source($p5qregex-combined), :target('NQPP5QRegex'), :setting('NQPCORE'), :no-regex-lib(1), :deps([$nqpcore-moarvm, $QAST-moarvm, $hll-moar, $QRegex-moarvm]));

my $NQPP6QRegex-moarvm := cross-compile(:stage(2), :source($p6qregex-combined), :target('NQPP6QRegex'), :setting('NQPCORE'), :no-regex-lib(1), :deps([$nqpcore-moarvm, $QAST-moarvm, $hll-moar, $QRegex-moarvm]));

my $nqp-bootstrapped := "$nqp-js-on-js/nqp-bootstrapped.js";


say("$nqp-js-on-js/ModuleLoader.js: $nqpcore-moarvm src/vm/js/ModuleLoader.nqp \$(JS_STAGE1_COMPILER)
	./nqp-js --setting=NULL --no-regex-lib --target=js --output $ModuleLoader src/vm/js/ModuleLoader.nqp
");

say("$nqp-bootstrapped: $QAST-moarvm $NQPP5QRegex-moarvm $NQPP6QRegex-moarvm $nqp-combined $QRegex-moarvm
	./nqp-js --target=js --shebang $nqp-combined > $nqp-bootstrapped
");


deps("js-bootstrap", "js-all", $nqp-bootstrapped);

