const React = require('react');

const ms = require('ms');

const {
  Box,
  Color
} = require('ink');

const importJSX = require('import-jsx');

const Test = importJSX('./test.js');

const chalk = require('chalk');

const s = n => new Array(n + 1).join(' ');

const bannerWords = '  🌈 SUMMARY RESULTS 🌈  ';
const banner = '\n' + chalk.bgHex('#fff')(s(bannerWords.length)) + '\n' + chalk.bgHex('#fff')(chalk.hex('#333')(chalk.bold(bannerWords))) + '\n' + chalk.bgHex('#fff')(s(bannerWords.length)) + '\n';

module.exports = ({
  results,
  tests
}) => /*#__PURE__*/React.createElement(Box, {
  flexDirection: "column"
}, banner, /*#__PURE__*/React.createElement(Box, {
  flexDirection: "column"
}, tests.filter(t => t.results && !t.results.ok || t.options.skip || t.options.todo || t.counts.total !== t.counts.pass).sort((a, b) => a.name.localeCompare(b.name, 'en')).map((test, i) => /*#__PURE__*/React.createElement(Test, {
  test: test,
  key: '' + i
}))));
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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