/*
 * Copyright (c) 2004 - 2009 Marcus Glocker <marcus@nazgul.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <sys/types.h>

#include <err.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>

#ifdef __linux__
#include <crypt.h>
#endif

/* prototypes */

void usage(void);

/* data */

static const char base64[64] =
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

void
usage(void)
{
	extern char	*__progname;

	fprintf(stderr, "usage: %s <passwordfile> <user> <password>\n",
	    __progname);
}

int
main(int argc, char *argv[])
{
	FILE		*file;
	char		*password;
	char		salt[2];
	unsigned char	random[2], a, b;
	time_t		tnow;

	/* we need a password */
	if (argc < 4 || argc > 4) {
		usage();
		exit(1);
	}

	/* open password file */
	if ((file = fopen(argv[1], "a")) == NULL)
		err(1, "fopen");

	/* generate random seed with time */
	time(&tnow);
	srand(tnow);

	/* generate first 8-bit random number and shift it to 6-bits */
	random[0] = rand();
	a = (random[0] >> 2);

	/* generate second 8-bit random number and shift it to 6-bits */
	random[1] = rand();
	b = (random[1] >> 2);

	/* assemble the 12-bit salt with base64 encoding */
	salt[0] = base64[a];
	salt[1] = base64[b];

	/* generate DES encrypted password */
	password = crypt(argv[3], salt);

	/* here we are */
	printf("User added.\n");
	fprintf(file, "%s:%s\n", argv[2], password);

	/* close password file */
	fclose(file);

	return (0);
}
