
# Node.js 8 ChangeLog

<!--lint disable prohibited-strings-->

<table>
<tr>
<th>LTS 'Carbon'</th>
<th title="Previously called 'Stable'">Current</th>
</tr>
<tr>
<td valign="top">
<a href="#8.16.2">8.16.2</a><br/>
<a href="#8.16.1">8.16.1</a><br/>
<a href="#8.16.0">8.16.0</a><br/>
<a href="#8.15.1">8.15.1</a><br/>
<a href="#8.15.0">8.15.0</a><br/>
<a href="#8.14.1">8.14.1</a><br/>
<a href="#8.14.0">8.14.0</a><br/>
<a href="#8.13.0">8.13.0</a><br/>
<a href="#8.12.0">8.12.0</a><br/>
<a href="#8.11.4">8.11.4</a><br/>
<a href="#8.11.3">8.11.3</a><br/>
<a href="#8.11.2">8.11.2</a><br/>
<a href="#8.11.1">8.11.1</a><br/>
<a href="#8.11.0">8.11.0</a><br/>
<a href="#8.10.0">8.10.0</a><br/>
<a href="#8.9.4">8.9.4</a><br/>
<a href="#8.9.3">8.9.3</a><br/>
<a href="#8.9.2">8.9.2</a><br/>
<a href="#8.9.1">8.9.1</a><br/>
<a href="#8.9.0">8.9.0</a><br/>
</td>
<td valign="top">
<a href="#8.8.1">8.8.1</a><br/>
<a href="#8.8.0">8.8.0</a><br/>
<a href="#8.7.0">8.7.0</a><br/>
<a href="#8.6.0">8.6.0</a><br/>
<a href="#8.5.0">8.5.0</a><br/>
<a href="#8.4.0">8.4.0</a><br/>
<a href="#8.3.0">8.3.0</a><br/>
<a href="#8.2.1">8.2.1</a><br/>
<a href="#8.2.0">8.2.0</a><br/>
<a href="#8.1.4">8.1.4</a><br/>
<a href="#8.1.3">8.1.3</a><br/>
<a href="#8.1.2">8.1.2</a><br/>
<a href="#8.1.1">8.1.1</a><br/>
<a href="#8.1.0">8.1.0</a><br/>
<a href="#8.0.0">8.0.0</a><br/>
</td>
</tr>
</table>

* Other Versions
  * [7.x](CHANGELOG_V7.md)
  * [6.x](CHANGELOG_V6.md)
  * [5.x](CHANGELOG_V5.md)
  * [4.x](CHANGELOG_V4.md)
  * [0.12.x](CHANGELOG_V012.md)
  * [0.10.x](CHANGELOG_V010.md)
  * [io.js](CHANGELOG_IOJS.md)
  * [Archive](CHANGELOG_ARCHIVE.md)

*Note*: Node.js v8 is covered by the
[Node.js Long Term Support Plan](https://github.com/nodejs/LTS) and
will be supported actively until April 2019 and maintained until December 2019.

<a id="8.16.2"></a>
## 2019-10-09, Version 8.16.2 'Carbon' (LTS), @BethGriggs

Node.js 8 is due to go End-of-Life on 31st December 2019.

### Notable changes

* **deps**: upgrade openssl sources to 1.0.2s (Sam Roberts) [#28230](https://github.com/nodejs/node/pull/28230)

### Commits

* [[`cc9d005628`](https://github.com/nodejs/node/commit/cc9d005628)] - **crypto**: update root certificates (Sam Roberts) [#28808](https://github.com/nodejs/node/pull/28808)
* [[`347fcd35e3`](https://github.com/nodejs/node/commit/347fcd35e3)] - **crypto**: update root certificates (Sam Roberts) [#27374](https://github.com/nodejs/node/pull/27374)
* [[`b2a6b3254d`](https://github.com/nodejs/node/commit/b2a6b3254d)] - **crypto**: update root certificates (Sam Roberts) [#25113](https://github.com/nodejs/node/pull/25113)
* [[`5682e50325`](https://github.com/nodejs/node/commit/5682e50325)] - **deps**: add -no\_rand\_screen to openssl s\_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`9663ae3546`](https://github.com/nodejs/node/commit/9663ae3546)] - **deps**: fix asm build error of openssl in x86\_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`87eee99466`](https://github.com/nodejs/node/commit/87eee99466)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`da99d3f972`](https://github.com/nodejs/node/commit/da99d3f972)] - **deps**: copy all openssl header files to include dir (Sam Roberts) [#28230](https://github.com/nodejs/node/pull/28230)
* [[`dc9d645ac4`](https://github.com/nodejs/node/commit/dc9d645ac4)] - **deps**: upgrade openssl sources to 1.0.2s (Sam Roberts) [#28230](https://github.com/nodejs/node/pull/28230)
* [[`37e24b19a0`](https://github.com/nodejs/node/commit/37e24b19a0)] - **deps**: V8: backport d520ebb (Michaël Zasso) [#27358](https://github.com/nodejs/node/pull/27358)
* [[`1a5dc6a3e7`](https://github.com/nodejs/node/commit/1a5dc6a3e7)] - **http**: check for existance in resetHeadersTimeoutOnReqEnd (Matteo Collina) [#26402](https://github.com/nodejs/node/pull/26402)
* [[`e45b6a3b98`](https://github.com/nodejs/node/commit/e45b6a3b98)] - **http2**: do not start reading after write if new write is on wire (Anna Henningsen) [#29399](https://github.com/nodejs/node/pull/29399)
* [[`559a8e342b`](https://github.com/nodejs/node/commit/559a8e342b)] - **http2**: do not crash on stream listener removal w/ destroyed session (Anna Henningsen) [#29459](https://github.com/nodejs/node/pull/29459)
* [[`dd285968c4`](https://github.com/nodejs/node/commit/dd285968c4)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`3ee076f03d`](https://github.com/nodejs/node/commit/3ee076f03d)] - **stream**: ensure writable.destroy() emits error once (Luigi Pinca) [#26057](https://github.com/nodejs/node/pull/26057)
* [[`a7e5fe1f06`](https://github.com/nodejs/node/commit/a7e5fe1f06)] - **test**: unskip tests that now pass on AIX (Sam Roberts) [#29054](https://github.com/nodejs/node/pull/29054)
* [[`65e9b0f5a2`](https://github.com/nodejs/node/commit/65e9b0f5a2)] - **test**: specialize OOM check for AIX (Sam Roberts) [#28857](https://github.com/nodejs/node/pull/28857)
* [[`7aca9cb09b`](https://github.com/nodejs/node/commit/7aca9cb09b)] - **test**: fix pty test hangs on aix (Ben Noordhuis) [#28600](https://github.com/nodejs/node/pull/28600)
* [[`588b761fca`](https://github.com/nodejs/node/commit/588b761fca)] - **test**: skip stringbytes-external-exceed-max on AIX (Sam Roberts) [#28516](https://github.com/nodejs/node/pull/28516)
* [[`930647d0fe`](https://github.com/nodejs/node/commit/930647d0fe)] - **test**: skip tests related to CI failures on AIX (Sam Roberts) [#28469](https://github.com/nodejs/node/pull/28469)
* [[`92a2f8bbe3`](https://github.com/nodejs/node/commit/92a2f8bbe3)] - **test,win**: cleanup exec-timeout processes (João Reis) [#28723](https://github.com/nodejs/node/pull/28723)
* [[`d57f79726d`](https://github.com/nodejs/node/commit/d57f79726d)] - **tls**: partially backport pull request #26415 (Ben Noordhuis) [#26415](https://github.com/nodejs/node/pull/26415)
* [[`c582fef5cc`](https://github.com/nodejs/node/commit/c582fef5cc)] - **tools**: update certdata.txt (Sam Roberts) [#28808](https://github.com/nodejs/node/pull/28808)
* [[`4fbadf6a9e`](https://github.com/nodejs/node/commit/4fbadf6a9e)] - **tools**: update certdata.txt (Sam Roberts) [#27374](https://github.com/nodejs/node/pull/27374)
* [[`529b2ad25f`](https://github.com/nodejs/node/commit/529b2ad25f)] - **tools**: update certdata.txt (Sam Roberts) [#25113](https://github.com/nodejs/node/pull/25113)

<a id="8.16.1"></a>
## 2019-08-15, Version 8.16.1 'Carbon' (LTS), @BethGriggs

### Notable changes

This is a security release.

Node.js, as well as many other implementations of HTTP/2, have been found
vulnerable to Denial of Service attacks.
See https://github.com/Netflix/security-bulletins/blob/master/advisories/third-party/2019-002.md
for more information.

Vulnerabilities fixed:

* **CVE-2019-9511 “Data Dribble”**: The attacker requests a large amount of data from a specified resource over multiple streams. They manipulate window size and stream priority to force the server to queue the data in 1-byte chunks. Depending on how efficiently this data is queued, this can consume excess CPU, memory, or both, potentially leading to a denial of service.
* **CVE-2019-9512 “Ping Flood”**: The attacker sends continual pings to an HTTP/2 peer, causing the peer to build an internal queue of responses. Depending on how efficiently this data is queued, this can consume excess CPU, memory, or both, potentially leading to a denial of service.
* **CVE-2019-9513 “Resource Loop”**: The attacker creates multiple request streams and continually shuffles the priority of the streams in a way that causes substantial churn to the priority tree. This can consume excess CPU, potentially leading to a denial of service.
* **CVE-2019-9514 “Reset Flood”**: The attacker opens a number of streams and sends an invalid request over each stream that should solicit a stream of RST_STREAM frames from the peer. Depending on how the peer queues the RST_STREAM frames, this can consume excess memory, CPU, or both, potentially leading to a denial of service.
* **CVE-2019-9515 “Settings Flood”**: The attacker sends a stream of SETTINGS frames to the peer. Since the RFC requires that the peer reply with one acknowledgement per SETTINGS frame, an empty SETTINGS frame is almost equivalent in behavior to a ping. Depending on how efficiently this data is queued, this can consume excess CPU, memory, or both, potentially leading to a denial of service.
* **CVE-2019-9516 “0-Length Headers Leak”**: The attacker sends a stream of headers with a 0-length header name and 0-length header value, optionally Huffman encoded into 1-byte or greater headers. Some implementations allocate memory for these headers and keep the allocation alive until the session dies. This can consume excess memory, potentially leading to a denial of service.
* **CVE-2019-9517 “Internal Data Buffering”**: The attacker opens the HTTP/2 window so the peer can send without constraint; however, they leave the TCP window closed so the peer cannot actually write (many of) the bytes on the wire. The attacker then sends a stream of requests for a large response object. Depending on how the servers queue the responses, this can consume excess memory, CPU, or both, potentially leading to a denial of service.
* **CVE-2019-9518 “Empty Frames Flood”**: The attacker sends a stream of frames with an empty payload and without the end-of-stream flag. These frames can be DATA, HEADERS, CONTINUATION and/or PUSH_PROMISE. The peer spends time processing each frame disproportionate to attack bandwidth. This can consume excess CPU, potentially leading to a denial of service. (Discovered by Piotr Sikora of Google)

### Commits

* [[`6d427378c0`](https://github.com/nodejs/node/commit/6d427378c0)] - **deps**: update nghttp2 to 1.39.2 (Anna Henningsen) [#29122](https://github.com/nodejs/node/pull/29122)
* [[`33d4d916d5`](https://github.com/nodejs/node/commit/33d4d916d5)] - **deps**: update nghttp2 to 1.39.1 (gengjiawen) [#28448](https://github.com/nodejs/node/pull/28448)
* [[`17fad97113`](https://github.com/nodejs/node/commit/17fad97113)] - **deps**: update nghttp2 to 1.38.0 (gengjiawen) [#27295](https://github.com/nodejs/node/pull/27295)
* [[`0b44733695`](https://github.com/nodejs/node/commit/0b44733695)] - **deps**: update nghttp2 to 1.37.0 (gengjiawen) [#26990](https://github.com/nodejs/node/pull/26990)
* [[`5afc77b044`](https://github.com/nodejs/node/commit/5afc77b044)] - **deps**: update nghttp2 to 1.34.0 (James M Snell) [#23284](https://github.com/nodejs/node/pull/23284)
* [[`073108c855`](https://github.com/nodejs/node/commit/073108c855)] - **http2**: allow security revert for Ping/Settings Flood (Anna Henningsen) [#29122](https://github.com/nodejs/node/pull/29122)
* [[`6d687f7af8`](https://github.com/nodejs/node/commit/6d687f7af8)] - **http2**: pause input processing if sending output (Anna Henningsen) [#29122](https://github.com/nodejs/node/pull/29122)
* [[`854dba649e`](https://github.com/nodejs/node/commit/854dba649e)] - **http2**: stop reading from socket if writes are in progress (Anna Henningsen) [#29122](https://github.com/nodejs/node/pull/29122)
* [[`a3191689dd`](https://github.com/nodejs/node/commit/a3191689dd)] - **http2**: consider 0-length non-end DATA frames an error (Anna Henningsen) [#29122](https://github.com/nodejs/node/pull/29122)
* [[`156f2f35df`](https://github.com/nodejs/node/commit/156f2f35df)] - **http2**: shrink default `vector::reserve()` allocations (Anna Henningsen) [#29122](https://github.com/nodejs/node/pull/29122)
* [[`10f05b65c4`](https://github.com/nodejs/node/commit/10f05b65c4)] - **http2**: handle 0-length headers better (Anna Henningsen) [#29122](https://github.com/nodejs/node/pull/29122)
* [[`ac28a628a5`](https://github.com/nodejs/node/commit/ac28a628a5)] - **http2**: limit number of invalid incoming frames (Anna Henningsen) [#29122](https://github.com/nodejs/node/pull/29122)
* [[`11b4e2c0db`](https://github.com/nodejs/node/commit/11b4e2c0db)] - **http2**: limit number of rejected stream openings (Anna Henningsen) [#29122](https://github.com/nodejs/node/pull/29122)
* [[`7de642b6f9`](https://github.com/nodejs/node/commit/7de642b6f9)] - **http2**: do not create ArrayBuffers when no DATA received (Anna Henningsen) [#29122](https://github.com/nodejs/node/pull/29122)
* [[`dd60d3561a`](https://github.com/nodejs/node/commit/dd60d3561a)] - **http2**: only call into JS when necessary for session events (Anna Henningsen) [#29122](https://github.com/nodejs/node/pull/29122)
* [[`00f6846b73`](https://github.com/nodejs/node/commit/00f6846b73)] - **http2**: improve JS-side debug logging (Anna Henningsen) [#29122](https://github.com/nodejs/node/pull/29122)
* [[`b095e35f1f`](https://github.com/nodejs/node/commit/b095e35f1f)] - **http2**: improve http2 code a bit (James M Snell) [#23984](https://github.com/nodejs/node/pull/23984)
* [[`cc282239c1`](https://github.com/nodejs/node/commit/cc282239c1)] - **test**: apply test-http2-max-session-memory-leak from v12.x (Anna Henningsen) [#29122](https://github.com/nodejs/node/pull/29122)

<a id="8.16.0"></a>
## 2019-04-16, Version 8.16.0 'Carbon' (LTS), @MylesBorins

### Notable Changes

* **n-api**:
  - add API for asynchronous functions (Gabriel Schulhof) [#17887](https://github.com/nodejs/node/pull/17887)
  - mark thread-safe function as stable (Gabriel Schulhof) [#25556](https://github.com/nodejs/node/pull/25556)

### Commits

* [[`705935d620`](https://github.com/nodejs/node/commit/705935d620)] - **assert**: fix backport regression (Ruben Bridgewater) [#27202](https://github.com/nodejs/node/pull/27202)
* [[`c07ba9681f`](https://github.com/nodejs/node/commit/c07ba9681f)] - **build**: skip cctest on Windows shared lib build (Yihong Wang) [#21228](https://github.com/nodejs/node/pull/21228)
* [[`63522886ea`](https://github.com/nodejs/node/commit/63522886ea)] - **build**: add loader path to rpath for cctest (Sam Ruby) [#23168](https://github.com/nodejs/node/pull/23168)
* [[`e9369073d9`](https://github.com/nodejs/node/commit/e9369073d9)] - **build**: set `-blibpath:` for AIX (Richard Lau) [#25447](https://github.com/nodejs/node/pull/25447)
* [[`97cc0fc51d`](https://github.com/nodejs/node/commit/97cc0fc51d)] - **deps**: V8: cherry-pick 3cc6919 (Farazmand) [#25874](https://github.com/nodejs/node/pull/25874)
* [[`a1aff28fba`](https://github.com/nodejs/node/commit/a1aff28fba)] - **deps**: cherry-pick 525b396 from V8 upstream (Peter Marshall) [#25041](https://github.com/nodejs/node/pull/25041)
* [[`6b7cccc88a`](https://github.com/nodejs/node/commit/6b7cccc88a)] - **doc**: fix optional parameters in n-api.md (Lars-Magnus Skog) [#22998](https://github.com/nodejs/node/pull/22998)
* [[`b17819db3d`](https://github.com/nodejs/node/commit/b17819db3d)] - **doc**: update the http.request.setTimeout docs to be accurate (James Bunton) [#25123](https://github.com/nodejs/node/pull/25123)
* [[`ac9b8f7645`](https://github.com/nodejs/node/commit/ac9b8f7645)] - **http**: fix error check in `Execute()` (Brian White) [#24738](https://github.com/nodejs/node/pull/24738)
* [[`1d862610f8`](https://github.com/nodejs/node/commit/1d862610f8)] - **http**: attach reused parser to correct domain (Julien Gilli) [#25459](https://github.com/nodejs/node/pull/25459)
* [[`d3de1ed653`](https://github.com/nodejs/node/commit/d3de1ed653)] - **n-api**: improve performance creating strings (Anthony Tuininga) [#26439](https://github.com/nodejs/node/pull/26439)
* [[`2b2ad96ef2`](https://github.com/nodejs/node/commit/2b2ad96ef2)] - **n-api**: finalize during second-pass callback (Gabriel Schulhof) [#25992](https://github.com/nodejs/node/pull/25992)
* [[`d6ffabc37f`](https://github.com/nodejs/node/commit/d6ffabc37f)] - **(SEMVER-MINOR)** **n-api**: mark thread-safe function as stable (Gabriel Schulhof) [#25556](https://github.com/nodejs/node/pull/25556)
* [[`44609d1274`](https://github.com/nodejs/node/commit/44609d1274)] - **n-api**: restrict exports by version (Kyle Farnung) [#19962](https://github.com/nodejs/node/pull/19962)
* [[`fe4328252a`](https://github.com/nodejs/node/commit/fe4328252a)] - **n-api**: add missing handle scopes (Daniel Bevenius) [#24011](https://github.com/nodejs/node/pull/24011)
* [[`902b07959f`](https://github.com/nodejs/node/commit/902b07959f)] - **n-api**: clean up thread-safe function (Gabriel Schulhof) [#22259](https://github.com/nodejs/node/pull/22259)
* [[`09b88aabb3`](https://github.com/nodejs/node/commit/09b88aabb3)] - **n-api**: remove idle\_running from TsFn (Lars-Magnus Skog) [#22520](https://github.com/nodejs/node/pull/22520)
* [[`367505940a`](https://github.com/nodejs/node/commit/367505940a)] - **n-api**: guard against cond null dereference (Gabriel Schulhof) [#21871](https://github.com/nodejs/node/pull/21871)
* [[`c5a11dc58e`](https://github.com/nodejs/node/commit/c5a11dc58e)] - **n-api**: fix compiler warning (cjihrig) [#21597](https://github.com/nodejs/node/pull/21597)
* [[`759a0180b5`](https://github.com/nodejs/node/commit/759a0180b5)] - **(SEMVER-MINOR)** **n-api**: add API for asynchronous functions (Gabriel Schulhof) [#17887](https://github.com/nodejs/node/pull/17887)
* [[`ea5628e77a`](https://github.com/nodejs/node/commit/ea5628e77a)] - **process**: allow reading from stdout/stderr sockets (Anna Henningsen) [#23053](https://github.com/nodejs/node/pull/23053)
* [[`67b6e0d19c`](https://github.com/nodejs/node/commit/67b6e0d19c)] - **src**: fix may be uninitialized warning in n-api (Michael Dawson) [#21898](https://github.com/nodejs/node/pull/21898)
* [[`eaf474cc5d`](https://github.com/nodejs/node/commit/eaf474cc5d)] - **test**: shared lib build doesn't handle SIGPIPE (Yihong Wang) [#19211](https://github.com/nodejs/node/pull/19211)
* [[`3128cb7da6`](https://github.com/nodejs/node/commit/3128cb7da6)] - **test**: avoid running fsync on directory on AIX (John Barboza) [#21298](https://github.com/nodejs/node/pull/21298)
* [[`b4c5435a46`](https://github.com/nodejs/node/commit/b4c5435a46)] - **test**: add process.stdin.end() TTY regression test (Matteo Collina) [#23051](https://github.com/nodejs/node/pull/23051)
* [[`c56f3edb10`](https://github.com/nodejs/node/commit/c56f3edb10)] - **test**: add stdin writable regression test (Anna Henningsen) [#23053](https://github.com/nodejs/node/pull/23053)
* [[`f6ff8c51bc`](https://github.com/nodejs/node/commit/f6ff8c51bc)] - **test**: fix module loading error for AIX 7.1 (Richard Lau) [#25418](https://github.com/nodejs/node/pull/25418)
* [[`d4b6643ac3`](https://github.com/nodejs/node/commit/d4b6643ac3)] - **test**: mark test-cli-node-options flaky on arm (Rich Trott) [#25032](https://github.com/nodejs/node/pull/25032)
* [[`60db455961`](https://github.com/nodejs/node/commit/60db455961)] - **test**: mark test\_threadsafe\_function/test as flaky (Gireesh Punathil) [#24714](https://github.com/nodejs/node/pull/24714)
* [[`fbafe8d311`](https://github.com/nodejs/node/commit/fbafe8d311)] - **test**: fix test-repl-envvars (Anna Henningsen) [#25226](https://github.com/nodejs/node/pull/25226)
* [[`7573b55a15`](https://github.com/nodejs/node/commit/7573b55a15)] - **tls**: fix legacy SecurePair clienthello race window (Ben Noordhuis) [#26452](https://github.com/nodejs/node/pull/26452)
* [[`91620b8bd6`](https://github.com/nodejs/node/commit/91620b8bd6)] - **tls**: fix legacy SecurePair session resumption (Ben Noordhuis) [#26452](https://github.com/nodejs/node/pull/26452)
* [[`1a9582b7a6`](https://github.com/nodejs/node/commit/1a9582b7a6)] - **tools**: allow input for TTY tests (Anna Henningsen) [#23053](https://github.com/nodejs/node/pull/23053)

<a id="8.15.1"></a>
## 2019-02-28, Version 8.15.1 'Carbon' (LTS), @rvagg

This is a security release. All Node.js users should consult the security release summary at:

  https://nodejs.org/en/blog/vulnerability/february-2019-security-releases/

for details on patched vulnerabilities.

Fixes for the following CVEs are included in this release:

  * Node.js: Slowloris HTTP Denial of Service with keep-alive (CVE-2019-5737)
  * OpenSSL: 0-byte record padding oracle (CVE-2019-1559)

### Notable Changes

* **deps**: OpenSSL has been upgraded to 1.0.2r which contains a fix for [CVE-2019-1559](https://www.openssl.org/news/secadv/20190226.txt). Under certain circumstances, a TLS server can be forced to respond differently to a client if a zero-byte record is received with an invalid _padding_ compared to a zero-byte record with an invalid _MAC_. This can be used as the basis of a padding oracle attack to decrypt data.
* **http**: Further prevention of "Slowloris" attacks on HTTP and HTTPS connections by consistently applying the receive timeout set by `server.headersTimeout` to connections in keep-alive mode. Reported by Marco Pracucci ([Voxnest](https://voxnest.com)). (CVE-2019-5737 / Matteo Collina)

### Commits

* [[`61980dcbf9`](https://github.com/nodejs/node/commit/61980dcbf9)] - **deps**: add -no\_rand\_screen to openssl s\_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`bf287faf21`](https://github.com/nodejs/node/commit/bf287faf21)] - **deps**: fix asm build error of openssl in x86\_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`22ec5feff0`](https://github.com/nodejs/node/commit/22ec5feff0)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`2cc5e7f534`](https://github.com/nodejs/node/commit/2cc5e7f534)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu)
* [[`d71517fd43`](https://github.com/nodejs/node/commit/d71517fd43)] - **deps**: upgrade openssl sources to 1.0.2r (Shigeki Ohtsu)
* [[`76d52c508a`](https://github.com/nodejs/node/commit/76d52c508a)] - **http**: prevent slowloris with keepalive connections (Matteo Collina) [nodejs-private/node-private#162](https://github.com/nodejs-private/node-private/pull/162)
* [[`6969fad7d6`](https://github.com/nodejs/node/commit/6969fad7d6)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)

<a id="8.15.0"></a>
## 2018-12-26, Version 8.15.0 'Carbon' (LTS), @MylesBorins

The 8.14.0 security release introduced some unexpected breakages on the 8.x release line.
This is a special release to fix a regression in the HTTP binary upgrade response body and add
a missing CLI flag to adjust the max header size of the http parser.

### Notable Changes

* **cli**:
  - add --max-http-header-size flag (cjihrig) [#24811](https://github.com/nodejs/node/pull/24811)
* **http**:
  - add maxHeaderSize property (cjihrig) [#24860](https://github.com/nodejs/node/pull/24860)

### Commits

* [[`693e362175`](https://github.com/nodejs/node/commit/693e362175)] - **(SEMVER-MINOR)** **cli**: add --max-http-header-size flag (cjihrig) [#24811](https://github.com/nodejs/node/pull/24811)
* [[`4fb5a1be2f`](https://github.com/nodejs/node/commit/4fb5a1be2f)] - **(SEMVER-MINOR)** **deps**: cherry-pick http\_parser\_set\_max\_header\_size (cjihrig) [#24811](https://github.com/nodejs/node/pull/24811)
* [[`446f8b54e5`](https://github.com/nodejs/node/commit/446f8b54e5)] - **(SEMVER-MINOR)** **http**: add maxHeaderSize property (cjihrig) [#24860](https://github.com/nodejs/node/pull/24860)
* [[`215ecfe4de`](https://github.com/nodejs/node/commit/215ecfe4de)] - **http**: fix regression of binary upgrade response body (Matteo Collina) [#25037](https://github.com/nodejs/node/pull/25037)
* [[`e1fbc26c6a`](https://github.com/nodejs/node/commit/e1fbc26c6a)] - **test**: move test-benchmark-path to sequential (Rich Trott) [#21393](https://github.com/nodejs/node/pull/21393)
* [[`aef71c05a2`](https://github.com/nodejs/node/commit/aef71c05a2)] - **test**: mark test-http2-settings-flood as flaky on Windows (Rich Trott) [#25048](https://github.com/nodejs/node/pull/25048)


<a id="8.14.1"></a>
## 2018-12-18, Version 8.14.1 'Carbon' (LTS), @MylesBorins prepared by @BethGriggs

### Notable changes

* **assert**:
  - revert breaking change (Ruben Bridgewater) [#24786](https://github.com/nodejs/node/pull/24786)
* **http2**:
  - fix sequence of error/close events (Gerhard Stoebich) [#24789](https://github.com/nodejs/node/pull/24789)

### Commits

* [[`62fb5dbec5`](https://github.com/nodejs/node/commit/62fb5dbec5)] - **assert**: revert breaking change (Ruben Bridgewater) [#24786](https://github.com/nodejs/node/pull/24786)
* [[`a8402fe1c8`](https://github.com/nodejs/node/commit/a8402fe1c8)] - **build**: only check REPLACEME & DEP...X for releases (Rod Vagg) [#24575](https://github.com/nodejs/node/pull/24575)
* [[`26743369d3`](https://github.com/nodejs/node/commit/26743369d3)] - **build**: improve Travis CI settings (Timothy Gu) [#21459](https://github.com/nodejs/node/pull/21459)
* [[`1da04c208d`](https://github.com/nodejs/node/commit/1da04c208d)] - **build**: install markdown linter for travis (Richard Lau) [#21215](https://github.com/nodejs/node/pull/21215)
* [[`7612024939`](https://github.com/nodejs/node/commit/7612024939)] - **build**: initial .travis.yml implementation (Anna Henningsen) [#21059](https://github.com/nodejs/node/pull/21059)
* [[`f70e79a7b2`](https://github.com/nodejs/node/commit/f70e79a7b2)] - **build**: allow for overwriting of use\_openssl\_def (Shelley Vohr) [#23763](https://github.com/nodejs/node/pull/23763)
* [[`15d1f67c60`](https://github.com/nodejs/node/commit/15d1f67c60)] - **build,doc**: remove outdated `lint-md-build` (Michaël Zasso) [#22991](https://github.com/nodejs/node/pull/22991)
* [[`85a6daeaef`](https://github.com/nodejs/node/commit/85a6daeaef)] - **build,meta**: switch to gcc-4.9 on travis (Refael Ackermann) [#23778](https://github.com/nodejs/node/pull/23778)
* [[`313ef6fa73`](https://github.com/nodejs/node/commit/313ef6fa73)] - **build,tools**: tweak the travis config (Refael Ackermann) [#22417](https://github.com/nodejs/node/pull/22417)
* [[`22b41495ea`](https://github.com/nodejs/node/commit/22b41495ea)] - **child_process**: handle undefined/null for fork() args (Shobhit Chittora) [#22416](https://github.com/nodejs/node/pull/22416)
* [[`499605618b`](https://github.com/nodejs/node/commit/499605618b)] - **crypto**: add SET\_INTEGER\_CONSANT macro (Daniel Bevenius) [#23687](https://github.com/nodejs/node/pull/23687)
* [[`34d91296df`](https://github.com/nodejs/node/commit/34d91296df)] - **deps**: icu: apply workaround patch (Steven R. Loomis) [#23764](https://github.com/nodejs/node/pull/23764)
* [[`50347297a1`](https://github.com/nodejs/node/commit/50347297a1)] - **deps**: cherry-pick d2e0166 from V8 upstream (Vasili Skurydzin) [#23958](https://github.com/nodejs/node/pull/23958)
* [[`9bedae5266`](https://github.com/nodejs/node/commit/9bedae5266)] - **deps**: cherry-pick 6bc4bfe from V8 upstream (Vasili Skurydzin) [#23958](https://github.com/nodejs/node/pull/23958)
* [[`4f3c9e6aab`](https://github.com/nodejs/node/commit/4f3c9e6aab)] - **deps,v8**: fix gyp build on Aix platform (Vasili Skurydzin) [#23958](https://github.com/nodejs/node/pull/23958)
* [[`74c1074d53`](https://github.com/nodejs/node/commit/74c1074d53)] - **doc**: add description for inspector-only console methods. (Benjamin Zaslavsky) [#17004](https://github.com/nodejs/node/pull/17004)
* [[`692223182c`](https://github.com/nodejs/node/commit/692223182c)] - **doc**: fix api documentation of http.createServer (Ari Autio) [#24869](https://github.com/nodejs/node/pull/24869)
* [[`6d8c65e574`](https://github.com/nodejs/node/commit/6d8c65e574)] - **doc**: update to adding listens on SIGUSR1 (willhayslett) [#19709](https://github.com/nodejs/node/pull/19709)
* [[`33b7c50036`](https://github.com/nodejs/node/commit/33b7c50036)] - **doc**: remove "if provided" for optional arguments (Rich Trott) [#19690](https://github.com/nodejs/node/pull/19690)
* [[`216e7da8c5`](https://github.com/nodejs/node/commit/216e7da8c5)] - **doc**: do not identify string as "JavaScript string" (Rich Trott) [#19689](https://github.com/nodejs/node/pull/19689)
* [[`17e84217c7`](https://github.com/nodejs/node/commit/17e84217c7)] - **doc**: fix grammar error in process.md (Kenji Okamoto) [#19641](https://github.com/nodejs/node/pull/19641)
* [[`06daf5276f`](https://github.com/nodejs/node/commit/06daf5276f)] - **doc**: remove use of "random port" re dgram send (Thomas Hunter II) [#19620](https://github.com/nodejs/node/pull/19620)
* [[`bf95392e86`](https://github.com/nodejs/node/commit/bf95392e86)] - **doc**: improve assert legacy text (Rich Trott) [#19622](https://github.com/nodejs/node/pull/19622)
* [[`e48cc3c403`](https://github.com/nodejs/node/commit/e48cc3c403)] - **doc**: remove confusing note about child process stdio (Anna Henningsen) [#19552](https://github.com/nodejs/node/pull/19552)
* [[`9d249bf6d5`](https://github.com/nodejs/node/commit/9d249bf6d5)] - **doc**: add BethGriggs to collaborators (Beth Griggs) [#19610](https://github.com/nodejs/node/pull/19610)
* [[`c3ecf05b01`](https://github.com/nodejs/node/commit/c3ecf05b01)] - **doc**: document `make docopen` (Ayush Gupta) [#19321](https://github.com/nodejs/node/pull/19321)
* [[`8338700d05`](https://github.com/nodejs/node/commit/8338700d05)] - **doc**: add directory structure in writing-tests.md (juggernaut451) [#18802](https://github.com/nodejs/node/pull/18802)
* [[`63d8632611`](https://github.com/nodejs/node/commit/63d8632611)] - **doc**: add types for some `process` properties (Vse Mozhet Byt) [#19571](https://github.com/nodejs/node/pull/19571)
* [[`b2fc3b556c`](https://github.com/nodejs/node/commit/b2fc3b556c)] - **doc**: fix n-api example string (Steven R. Loomis) [#19205](https://github.com/nodejs/node/pull/19205)
* [[`d79e7d6e89`](https://github.com/nodejs/node/commit/d79e7d6e89)] - **doc**: minor improvements to buffer.md (Rich Trott) [#19547](https://github.com/nodejs/node/pull/19547)
* [[`06491482f8`](https://github.com/nodejs/node/commit/06491482f8)] - **doc**: update child\_process.md (Ari Leo Frankel) [#19075](https://github.com/nodejs/node/pull/19075)
* [[`4db289ca17`](https://github.com/nodejs/node/commit/4db289ca17)] - **doc**: move StackOverflow to unofficial section (josephleon) [#19416](https://github.com/nodejs/node/pull/19416)
* [[`f5683a9a6d`](https://github.com/nodejs/node/commit/f5683a9a6d)] - **doc**: correct async\_hooks resource names (Gerhard Stoebich) [#24684](https://github.com/nodejs/node/pull/24684)
* [[`ffe1f8033c`](https://github.com/nodejs/node/commit/ffe1f8033c)] - **doc**: sort bottom-of-file markdown links (Sam Roberts) [#24682](https://github.com/nodejs/node/pull/24682)
* [[`78d9a5e6e4`](https://github.com/nodejs/node/commit/78d9a5e6e4)] - **doc**: address bits of proof reading work (Jagannath Bhat) [#23978](https://github.com/nodejs/node/pull/23978)
* [[`d1eebb2e43`](https://github.com/nodejs/node/commit/d1eebb2e43)] - **doc**: revise COLLABORATOR\_GUIDE.md (Rich Trott) [#23990](https://github.com/nodejs/node/pull/23990)
* [[`003eb0c8e1`](https://github.com/nodejs/node/commit/003eb0c8e1)] - **doc**: simplify CODE\_OF\_CONDUCT.md (Rich Trott) [#23989](https://github.com/nodejs/node/pull/23989)
* [[`c1723c8bca`](https://github.com/nodejs/node/commit/c1723c8bca)] - **doc**: add branding to style guide (Rich Trott) [#23967](https://github.com/nodejs/node/pull/23967)
* [[`8bb67a1fb9`](https://github.com/nodejs/node/commit/8bb67a1fb9)] - **doc**: use Node.js instead of Node (Rich Trott) [#23967](https://github.com/nodejs/node/pull/23967)
* [[`73e0bb1f52`](https://github.com/nodejs/node/commit/73e0bb1f52)] - **doc**: fix typographical issues (Denis McDonald) [#23970](https://github.com/nodejs/node/pull/23970)
* [[`6d76f852a9`](https://github.com/nodejs/node/commit/6d76f852a9)] - **doc**: add documentation for http.IncomingMessage$complete (James M Snell) [#23914](https://github.com/nodejs/node/pull/23914)
* [[`3025f351db`](https://github.com/nodejs/node/commit/3025f351db)] - **doc**: remove mailing list (Rich Trott) [#23932](https://github.com/nodejs/node/pull/23932)
* [[`2459e150bb`](https://github.com/nodejs/node/commit/2459e150bb)] - **doc**: add note about ABI compatibility (Myles Borins) [#22237](https://github.com/nodejs/node/pull/22237)
* [[`27b35833bd`](https://github.com/nodejs/node/commit/27b35833bd)] - **doc**: make example more clarified in cluster.md (ZYSzys) [#23931](https://github.com/nodejs/node/pull/23931)
* [[`0d4de59967`](https://github.com/nodejs/node/commit/0d4de59967)] - **doc**: simplify valid security issue descriptions (Rich Trott) [#23881](https://github.com/nodejs/node/pull/23881)
* [[`9afdc09f98`](https://github.com/nodejs/node/commit/9afdc09f98)] - **doc**: simplify path.basename() on POSIX and Windows (ZYSzys) [#23864](https://github.com/nodejs/node/pull/23864)
* [[`3f2a01688d`](https://github.com/nodejs/node/commit/3f2a01688d)] - **doc**: add review suggestions to require() (erickwendel) [#23605](https://github.com/nodejs/node/pull/23605)
* [[`f037942fe7`](https://github.com/nodejs/node/commit/f037942fe7)] - **doc**: move @phillipj to emeriti (Phillip Johnsen) [#23790](https://github.com/nodejs/node/pull/23790)
* [[`e5f75cf82e`](https://github.com/nodejs/node/commit/e5f75cf82e)] - **doc**: add note about removeListener order (James M Snell) [#23762](https://github.com/nodejs/node/pull/23762)
* [[`0ff88a3510`](https://github.com/nodejs/node/commit/0ff88a3510)] - **doc**: document ACL limitation for fs.access on Windows (James M Snell) [#23772](https://github.com/nodejs/node/pull/23772)
* [[`32ae851710`](https://github.com/nodejs/node/commit/32ae851710)] - **doc**: document that addMembership must be called once in a cluster (James M Snell) [#23746](https://github.com/nodejs/node/pull/23746)
* [[`e2d2ce6706`](https://github.com/nodejs/node/commit/e2d2ce6706)] - **doc**: remove reference to sslv3 in tls.md (James M Snell) [#23745](https://github.com/nodejs/node/pull/23745)
* [[`4c24a82a65`](https://github.com/nodejs/node/commit/4c24a82a65)] - **http2**: fix sequence of error/close events (Gerhard Stoebich) [#24789](https://github.com/nodejs/node/pull/24789)
* [[`8afbd5ce41`](https://github.com/nodejs/node/commit/8afbd5ce41)] - **lib**: fix a typo in lib/timers "read through" (wangzengdi) [#19666](https://github.com/nodejs/node/pull/19666)
* [[`fa12532000`](https://github.com/nodejs/node/commit/fa12532000)] - **lib**: remove useless cwd in posix.resolve (ZYSzys) [#23902](https://github.com/nodejs/node/pull/23902)
* [[`e8dbd09414`](https://github.com/nodejs/node/commit/e8dbd09414)] - **src**: use "constants" string instead of creating new one (Ouyang Yadong) [#23894](https://github.com/nodejs/node/pull/23894)
* [[`394cb42962`](https://github.com/nodejs/node/commit/394cb42962)] - **test**: verify order of error in h2 server stream (Myles Borins) [#24685](https://github.com/nodejs/node/pull/24685)
* [[`5e09a3d4ed`](https://github.com/nodejs/node/commit/5e09a3d4ed)] - **test**: test process.setuid for bad argument types (Divyanshu Singh) [#19703](https://github.com/nodejs/node/pull/19703)
* [[`970164f3a8`](https://github.com/nodejs/node/commit/970164f3a8)] - **test**: improve assert message (fatahn) [#19629](https://github.com/nodejs/node/pull/19629)
* [[`086570e4e1`](https://github.com/nodejs/node/commit/086570e4e1)] - **test**: remove third argument from call to assert.strictEqual() (Forrest Wolf) [#19659](https://github.com/nodejs/node/pull/19659)
* [[`a7b3274af4`](https://github.com/nodejs/node/commit/a7b3274af4)] - **test**: fix flaky test-cluster-send-handle-twice (Rich Trott) [#19700](https://github.com/nodejs/node/pull/19700)
* [[`1bda58289a`](https://github.com/nodejs/node/commit/1bda58289a)] - **test**: rename regression tests more expressively (Ujjwal Sharma) [#19668](https://github.com/nodejs/node/pull/19668)
* [[`bd9cc92e8d`](https://github.com/nodejs/node/commit/bd9cc92e8d)] - **test**: remove 3rd argument from assert.strictEqual (Arian Santrach) [#19707](https://github.com/nodejs/node/pull/19707)
* [[`3ca10faf00`](https://github.com/nodejs/node/commit/3ca10faf00)] - **test**: use createReadStream instead of ReadStream (Daniel Bevenius) [#19636](https://github.com/nodejs/node/pull/19636)
* [[`8a546e822d`](https://github.com/nodejs/node/commit/8a546e822d)] - **test**: removed default message from assert.strictEqual (jaspal-yupana) [#19660](https://github.com/nodejs/node/pull/19660)
* [[`a62df1b379`](https://github.com/nodejs/node/commit/a62df1b379)] - **test**: refactor test-net-dns-error (Luigi Pinca) [#19640](https://github.com/nodejs/node/pull/19640)
* [[`8a0ecf4360`](https://github.com/nodejs/node/commit/8a0ecf4360)] - **test**: refactor test-http-expect-continue (Rich Trott) [#19625](https://github.com/nodejs/node/pull/19625)
* [[`0cbe813e90`](https://github.com/nodejs/node/commit/0cbe813e90)] - **test**: update link according to NIST bibliography (Tobias Nießen) [#19593](https://github.com/nodejs/node/pull/19593)
* [[`ea1fda6228`](https://github.com/nodejs/node/commit/ea1fda6228)] - **test**: remove third param from assert.strictEqual (davis.okoth@kemsa.co.ke) [#19536](https://github.com/nodejs/node/pull/19536)
* [[`18c4e5e886`](https://github.com/nodejs/node/commit/18c4e5e886)] - **test**: remove message from assert.strictEqual() (willhayslett) [#19525](https://github.com/nodejs/node/pull/19525)
* [[`146c488bf5`](https://github.com/nodejs/node/commit/146c488bf5)] - **test**: refactor parallel/test-tls-ca-concat.js (juggernaut451) [#19092](https://github.com/nodejs/node/pull/19092)
* [[`8fa5bd3761`](https://github.com/nodejs/node/commit/8fa5bd3761)] - **test**: rename regression tests file names (Ujjwal Sharma) [#19332](https://github.com/nodejs/node/pull/19332)
* [[`d34ade8755`](https://github.com/nodejs/node/commit/d34ade8755)] - **test**: fix strictEqual arguments order (Esteban Sotillo) [#23956](https://github.com/nodejs/node/pull/23956)
* [[`6ae07a9248`](https://github.com/nodejs/node/commit/6ae07a9248)] - **test**: add property for RangeError in test-buffer-copy (mritunjaygoutam12) [#23968](https://github.com/nodejs/node/pull/23968)
* [[`b1e6de80c1`](https://github.com/nodejs/node/commit/b1e6de80c1)] - **test**: fix regression when compiled with FIPS (Adam Majer) [#23871](https://github.com/nodejs/node/pull/23871)
* [[`d0368b8245`](https://github.com/nodejs/node/commit/d0368b8245)] - **test**: fix strictEqual() argument order (Loic) [#23829](https://github.com/nodejs/node/pull/23829)
* [[`3a864d716e`](https://github.com/nodejs/node/commit/3a864d716e)] - **test**: fix strictEqual() arguments order (Nolan Rigo) [#23800](https://github.com/nodejs/node/pull/23800)
* [[`e7a573a9e2`](https://github.com/nodejs/node/commit/e7a573a9e2)] - **test**: fix test-require-symlink on Windows (Bartosz Sosnowski) [#23691](https://github.com/nodejs/node/pull/23691)
* [[`ac91346776`](https://github.com/nodejs/node/commit/ac91346776)] - **test**: fix strictEqual() argument order (Romain Lanz) [#23768](https://github.com/nodejs/node/pull/23768)
* [[`0f98c4926a`](https://github.com/nodejs/node/commit/0f98c4926a)] - **test**: fix strictEqual() arguments order (Thomas GENTILHOMME) [#23771](https://github.com/nodejs/node/pull/23771)
* [[`73d19b1516`](https://github.com/nodejs/node/commit/73d19b1516)] - **test**: ensure openssl version prints correctly (Sam Roberts) [#23678](https://github.com/nodejs/node/pull/23678)
* [[`544e64d68d`](https://github.com/nodejs/node/commit/544e64d68d)] - **test**: fix assertion arguments order (Elian Gutierrez) [#23787](https://github.com/nodejs/node/pull/23787)
* [[`e84c01d1f3`](https://github.com/nodejs/node/commit/e84c01d1f3)] - **tools**: update alternative docs versions (Richard Lau) [#23980](https://github.com/nodejs/node/pull/23980)
* [[`02209c5fa7`](https://github.com/nodejs/node/commit/02209c5fa7)] - **tools**: clarify commit message linting (Rich Trott) [#23742](https://github.com/nodejs/node/pull/23742)
* [[`22043ccb84`](https://github.com/nodejs/node/commit/22043ccb84)] - **tools**: do not lint commit message if var undefined (Rich Trott) [#23725](https://github.com/nodejs/node/pull/23725)
* [[`2a8a28c436`](https://github.com/nodejs/node/commit/2a8a28c436)] - **tools**: make Travis commit linting more robust (Rich Trott) [#23397](https://github.com/nodejs/node/pull/23397)
* [[`c15d236545`](https://github.com/nodejs/node/commit/c15d236545)] - **tools**: apply linting to first commit in PRs (Rich Trott) [#22452](https://github.com/nodejs/node/pull/22452)

<a id="8.14.0"></a>
## 2018-11-27, Version 8.14.0 'Carbon' (LTS), @rvagg

This is a security release. All Node.js users should consult the security release summary at:

  https://nodejs.org/en/blog/vulnerability/november-2018-security-releases/

for details on patched vulnerabilities.

Fixes for the following CVEs are included in this release:

  * Node.js: Denial of Service with large HTTP headers (CVE-2018-12121)
  * Node.js: Slowloris HTTP Denial of Service (CVE-2018-12122 / Node.js)
  * Node.js: Hostname spoofing in URL parser for javascript protocol (CVE-2018-12123)
  * Node.js: HTTP request splitting (CVE-2018-12116)
  * OpenSSL: Timing vulnerability in DSA signature generation (CVE-2018-0734)
  * OpenSSL: Microarchitecture timing vulnerability in ECC scalar multiplication (CVE-2018-5407)

### Notable Changes

* **deps**: Upgrade to OpenSSL 1.0.2q, fixing CVE-2018-0734 and CVE-2018-5407
* **http**:
    * Headers received by HTTP servers must not exceed 8192 bytes in total to prevent possible Denial of Service attacks. Reported by Trevor Norris. (CVE-2018-12121 / Matteo Collina)
    * A timeout of 40 seconds now applies to servers receiving HTTP headers. This value can be adjusted with `server.headersTimeout`. Where headers are not completely received within this period, the socket is destroyed on the next received chunk. In conjunction with `server.setTimeout()`, this aids in protecting against excessive resource retention and possible Denial of Service. Reported by Jan Maybach ([liebdich.com](https://liebdich.com)). (CVE-2018-12122 / Matteo Collina)
    * Two-byte characters are now strictly disallowed for the `path` option in HTTP client requests. Paths containing characters outside of the range `\u0021` - `\u00ff` will now be rejected with a `TypeError`. This behavior can be reverted if necessary by supplying the `--security-revert=CVE-2018-12116` command line argument (this is not recommended). Reported as security concern for Node.js 6 and 8 by [Arkadiy Tetelman](https://twitter.com/arkadiyt) ([Lob](https://lob.com)), fixed by backporting a change by Benno Fünfstück applied to Node.js 10 and later. (CVE-2018-12116 / Matteo Collina)
* **url**: Fix a bug that would allow a hostname being spoofed when parsing URLs with `url.parse()` with the `'javascript:'` protocol. Reported by [Martin Bajanik](https://twitter.com/_bayotop) ([Kentico](https://kenticocloud.com/)). (CVE-2018-12123 / Matteo Collina)

### Commits

* [[`add20f373c`](https://github.com/nodejs/node/commit/add20f373c)] - **deps**: add -no\_rand\_screen to openssl s\_client (Shigeki Ohtsu) [nodejs/node#1836](https://github.com/nodejs/node/pull/1836)
* [[`c4e382cce3`](https://github.com/nodejs/node/commit/c4e382cce3)] - **deps**: fix asm build error of openssl in x86\_win32 (Shigeki Ohtsu) [nodejs/node#1389](https://github.com/nodejs/node/pull/1389)
* [[`f1d1f12519`](https://github.com/nodejs/node/commit/f1d1f12519)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [nodejs/node#1389](https://github.com/nodejs/node/pull/1389)
* [[`69037ad5c4`](https://github.com/nodejs/node/commit/69037ad5c4)] - **deps**: copy all openssl header files to include dir (Sam Roberts) [#24530](https://github.com/nodejs/node/pull/24530)
* [[`f5b34336bb`](https://github.com/nodejs/node/commit/f5b34336bb)] - **deps**: upgrade openssl sources to 1.0.2q (Sam Roberts) [#24530](https://github.com/nodejs/node/pull/24530)
* [[`93dba83fb0`](https://github.com/nodejs/node/commit/93dba83fb0)] - **deps,http**: http\_parser set max header size to 8KB (Matteo Collina) [nodejs-private/node-private#143](https://github.com/nodejs-private/node-private/pull/143)
* [[`576038fb61`](https://github.com/nodejs/node/commit/576038fb61)] - **(SEMVER-MINOR)** **http**: add --security-revert for CVE-2018-12116 (Matteo Collina) [nodejs-private/node-private#146](https://github.com/nodejs-private/node-private/pull/146)
* [[`513e9747a2`](https://github.com/nodejs/node/commit/513e9747a2)] - **(SEMVER-MINOR)** **http**: disallow two-byte characters in URL path (Benno Fünfstück) [nodejs-private/node-private#146](https://github.com/nodejs-private/node-private/pull/146)
* [[`696f063c5e`](https://github.com/nodejs/node/commit/696f063c5e)] - **(SEMVER-MINOR)** **http,https**: protect against slow headers attack (Matteo Collina) [nodejs-private/node-private#151](https://github.com/nodejs-private/node-private/pull/151)
* [[`7f362a11ee`](https://github.com/nodejs/node/commit/7f362a11ee)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [nodejs/node#1389](https://github.com/nodejs/node/pull/1389)
* [[`53a6e4eb20`](https://github.com/nodejs/node/commit/53a6e4eb20)] - **url**: avoid hostname spoofing w/ javascript protocol (Matteo Collina) [nodejs-private/node-private#145](https://github.com/nodejs-private/node-private/pull/145)

<a id="8.13.0"></a>
## 2018-11-20, Version 8.13.0 'Carbon' (LTS), @MylesBorins prepared by @BethGriggs

### Notable changes

* **assert**:
  - backport some assert commits (Ruben Bridgewater) [#23223](https://github.com/nodejs/node/pull/23223)
* **deps**:
  - upgrade to libuv 1.23.2 (cjihrig) [#23336](https://github.com/nodejs/node/pull/23336)
  - V8: cherry-pick 64-bit hash seed commits (Yang Guo) [#23274](https://github.com/nodejs/node/pull/23274)
* **http**:
  - added aborted property to request (Robert Nagy) [#20094](https://github.com/nodejs/node/pull/20094)
* **http2**:
  - graduate from experimental (James M Snell) [#22466](https://github.com/nodejs/node/pull/22466)

### Commits

* [[`0d241ba385`](https://github.com/nodejs/node/commit/0d241ba385)] - **assert**: ensure .rejects() disallows sync throws (Teddy Katz) [#19650](https://github.com/nodejs/node/pull/19650)
* [[`3babc5bb53`](https://github.com/nodejs/node/commit/3babc5bb53)] - **(SEMVER-MINOR)** **assert**: add rejects() and doesNotReject() (feugy) [#18023](https://github.com/nodejs/node/pull/18023)
* [[`18071db274`](https://github.com/nodejs/node/commit/18071db274)] - **assert**: fix throws trace (Ruben Bridgewater) [#18595](https://github.com/nodejs/node/pull/18595)
* [[`562787efb2`](https://github.com/nodejs/node/commit/562787efb2)] - **assert**: fix strict regression (Ruben Bridgewater) [#17903](https://github.com/nodejs/node/pull/17903)
* [[`f2af930ebb`](https://github.com/nodejs/node/commit/f2af930ebb)] - **(SEMVER-MINOR)** **assert**: .throws accept objects (Ruben Bridgewater) [#17584](https://github.com/nodejs/node/pull/17584)
* [[`147aeedc8d`](https://github.com/nodejs/node/commit/147aeedc8d)] - **(SEMVER-MINOR)** **assert**: improve assert.throws (Ruben Bridgewater) [#17585](https://github.com/nodejs/node/pull/17585)
* [[`c9d84b6d4f`](https://github.com/nodejs/node/commit/c9d84b6d4f)] - **assert**: fix throws and doesNotThrow stack frames (Ruben Bridgewater) [#17703](https://github.com/nodejs/node/pull/17703)
* [[`a42d0726ac`](https://github.com/nodejs/node/commit/a42d0726ac)] - **assert**: use object argument in innerFail (Ruben Bridgewater) [#17582](https://github.com/nodejs/node/pull/17582)
* [[`84948cf14f`](https://github.com/nodejs/node/commit/84948cf14f)] - **assert**: fix .throws operator (Ruben Bridgewater) [#17575](https://github.com/nodejs/node/pull/17575)
* [[`c6d94f8fa5`](https://github.com/nodejs/node/commit/c6d94f8fa5)] - **(SEMVER-MINOR)** **assert**: add strict functionality export (Ruben Bridgewater) [#17002](https://github.com/nodejs/node/pull/17002)
* [[`26d145a77f`](https://github.com/nodejs/node/commit/26d145a77f)] - **async_hooks**: add missing async\_hooks destroys in AsyncReset (Bastian Krol) [#23272](https://github.com/nodejs/node/pull/23272)
* [[`104fbc64ed`](https://github.com/nodejs/node/commit/104fbc64ed)] - **build**: update arm64 minimum supported platform (Gibson Fahnestock) [#19164](https://github.com/nodejs/node/pull/19164)
* [[`afcf059898`](https://github.com/nodejs/node/commit/afcf059898)] - **build**: do not cd on vcbuild help (Vse Mozhet Byt) [#19291](https://github.com/nodejs/node/pull/19291)
* [[`ca8d4e3450`](https://github.com/nodejs/node/commit/ca8d4e3450)] - **build**: define NOMINMAX on windows (Ben Noordhuis) [#22731](https://github.com/nodejs/node/pull/22731)
* [[`5245d6ac97`](https://github.com/nodejs/node/commit/5245d6ac97)] - **deps**: V8: partially revert d868eb7 (Ali Ijaz Sheikh) [#24499](https://github.com/nodejs/node/pull/24499)
* [[`62dd1d7bd4`](https://github.com/nodejs/node/commit/62dd1d7bd4)] - **deps**: upgrade to libuv 1.23.2 (cjihrig) [#23336](https://github.com/nodejs/node/pull/23336)
* [[`b38190ebb0`](https://github.com/nodejs/node/commit/b38190ebb0)] - **deps**: upgrade to libuv 1.23.1 (cjihrig) [#22997](https://github.com/nodejs/node/pull/22997)
* [[`d9d541c415`](https://github.com/nodejs/node/commit/d9d541c415)] - **deps**: upgrade to libuv 1.23.0 (cjihrig) [#22365](https://github.com/nodejs/node/pull/22365)
* [[`e3d08af7c1`](https://github.com/nodejs/node/commit/e3d08af7c1)] - **deps**: upgrade to libuv 1.22.0 (cjihrig) [#21731](https://github.com/nodejs/node/pull/21731)
* [[`11cb09b25a`](https://github.com/nodejs/node/commit/11cb09b25a)] - **deps**: upgrade to libuv 1.21.0 (cjihrig) [#21466](https://github.com/nodejs/node/pull/21466)
* [[`c54f4bc8e8`](https://github.com/nodejs/node/commit/c54f4bc8e8)] - **deps**: upgrade to libuv 1.20.3 (cjihrig) [#20585](https://github.com/nodejs/node/pull/20585)
* [[`2307653abf`](https://github.com/nodejs/node/commit/2307653abf)] - **deps**: upgrade to libuv 1.20.2 (cjihrig) [#20129](https://github.com/nodejs/node/pull/20129)
* [[`a1b94d35e7`](https://github.com/nodejs/node/commit/a1b94d35e7)] - **deps**: upgrade libuv to 1.20.0 (cjihrig) [#19758](https://github.com/nodejs/node/pull/19758)
* [[`ce65d84537`](https://github.com/nodejs/node/commit/ce65d84537)] - **deps**: backport a8f6869 from upstream V8 (Ben Newman) [#22714](https://github.com/nodejs/node/pull/22714)
* [[`7ab253f62e`](https://github.com/nodejs/node/commit/7ab253f62e)] - **deps**: V8: cherry-pick 64-bit hash seed commits (Yang Guo) [#23274](https://github.com/nodejs/node/pull/23274)
* [[`60f7bfa4d7`](https://github.com/nodejs/node/commit/60f7bfa4d7)] - **deps**: update to nghttp2 1.33.0 (Anna Henningsen) [#22649](https://github.com/nodejs/node/pull/22649)
* [[`48f31bdf20`](https://github.com/nodejs/node/commit/48f31bdf20)] - **deps**: V8: backport 20 CPU profiler commits from upstream (Peter Marshall) [#21558](https://github.com/nodejs/node/pull/21558)
* [[`9e2077afee`](https://github.com/nodejs/node/commit/9e2077afee)] - **deps**: backport 9a23bdd from upstream V8 (Daniel Beckert) [#22418](https://github.com/nodejs/node/pull/22418)
* [[`610297e2ab`](https://github.com/nodejs/node/commit/610297e2ab)] - **doc**: improve best practices in onboarding-extras (Rich Trott) [#19315](https://github.com/nodejs/node/pull/19315)
* [[`9446bb68ea`](https://github.com/nodejs/node/commit/9446bb68ea)] - **doc**: fix minor issues in async\_hooks.md (Rich Trott) [#19313](https://github.com/nodejs/node/pull/19313)
* [[`5b9af6ea73`](https://github.com/nodejs/node/commit/5b9af6ea73)] - **doc**: update username and email (Yuta Hiroto) [#19338](https://github.com/nodejs/node/pull/19338)
* [[`bae7c608e2`](https://github.com/nodejs/node/commit/bae7c608e2)] - **doc**: document http2 timeouts (Sagi Tsofan) [#22798](https://github.com/nodejs/node/pull/22798)
* [[`d0be932375`](https://github.com/nodejs/node/commit/d0be932375)] - **doc**: simplify http2 wording and formatting (Rich Trott) [#22541](https://github.com/nodejs/node/pull/22541)
* [[`3fe9293efc`](https://github.com/nodejs/node/commit/3fe9293efc)] - **doc**: make createPushResponse() more detailled (MaleDong) [#22366](https://github.com/nodejs/node/pull/22366)
* [[`3980ca1840`](https://github.com/nodejs/node/commit/3980ca1840)] - **doc**: clarify http2 docs around class exports (James M Snell) [#22247](https://github.com/nodejs/node/pull/22247)
* [[`32bfd7ebfb`](https://github.com/nodejs/node/commit/32bfd7ebfb)] - **doc**: add missing `require` to example in http2.md (Kevin Simper) [#21858](https://github.com/nodejs/node/pull/21858)
* [[`2116ace0ad`](https://github.com/nodejs/node/commit/2116ace0ad)] - **doc**: fix http2stream.pushStream error doc (Сковорода Никита Андреевич) [#21487](https://github.com/nodejs/node/pull/21487)
* [[`4228141012`](https://github.com/nodejs/node/commit/4228141012)] - **doc**: Improve doc for Http2 headers object (Gerhard Stoebich) [#21296](https://github.com/nodejs/node/pull/21296)
* [[`11a63ddf48`](https://github.com/nodejs/node/commit/11a63ddf48)] - **doc**: fix typo in http2.md (Keita Akutsu) [#20843](https://github.com/nodejs/node/pull/20843)
* [[`4f0035485f`](https://github.com/nodejs/node/commit/4f0035485f)] - **doc**: add parameters for Http2Stream:error event (Ujjwal Sharma) [#20610](https://github.com/nodejs/node/pull/20610)
* [[`77acef4af2`](https://github.com/nodejs/node/commit/77acef4af2)] - **doc**: add params for ClientHttp2Session:altsvc (Ujjwal Sharma) [#20598](https://github.com/nodejs/node/pull/20598)
* [[`448922d0de`](https://github.com/nodejs/node/commit/448922d0de)] - **doc**: add parameters for Http2Session:stream event (Ujjwal Sharma) [#20547](https://github.com/nodejs/node/pull/20547)
* [[`41e89316e6`](https://github.com/nodejs/node/commit/41e89316e6)] - **doc**: add parameters for settings events (Ujjwal Sharma) [#20371](https://github.com/nodejs/node/pull/20371)
* [[`1a6a054899`](https://github.com/nodejs/node/commit/1a6a054899)] - **doc**: improve parameters for Http2Session:goaway event (Ujjwal Sharma)
* [[`98ed30f3f5`](https://github.com/nodejs/node/commit/98ed30f3f5)] - **doc**: improve docs for Http2Session:frameError (Ujjwal Sharma) [#20236](https://github.com/nodejs/node/pull/20236)
* [[`b32cf8fa40`](https://github.com/nodejs/node/commit/b32cf8fa40)] - **doc**: add parameters for Http2Session:error event (Ujjwal Sharma) [#20206](https://github.com/nodejs/node/pull/20206)
* [[`c0d1423bd3`](https://github.com/nodejs/node/commit/c0d1423bd3)] - **doc**: close event does not take arguments (Indranil Dasgupta) [#20031](https://github.com/nodejs/node/pull/20031)
* [[`459690aca4`](https://github.com/nodejs/node/commit/459690aca4)] - **doc**: improve style guide text (Rich Trott) [#19269](https://github.com/nodejs/node/pull/19269)
* [[`eaabbf4ff0`](https://github.com/nodejs/node/commit/eaabbf4ff0)] - **doc**: make caveat in stream.md more concise (Rich Trott) [#19251](https://github.com/nodejs/node/pull/19251)
* [[`0340dd8c8d`](https://github.com/nodejs/node/commit/0340dd8c8d)] - **doc**: add and unify return statements in crypto.md (Vse Mozhet Byt) [#19853](https://github.com/nodejs/node/pull/19853)
* [[`b0d6067d87`](https://github.com/nodejs/node/commit/b0d6067d87)] - **doc**: fix 8.12.0 changelog (Myles Borins) [#22803](https://github.com/nodejs/node/pull/22803)
* [[`af5cebb326`](https://github.com/nodejs/node/commit/af5cebb326)] - **doc,http2**: add parameters for Http2Session:connect event (Ujjwal Sharma) [#20193](https://github.com/nodejs/node/pull/20193)
* [[`57618aae0a`](https://github.com/nodejs/node/commit/57618aae0a)] - **errors**: fix undefined HTTP2 and tls errors (Shailesh Shekhawat) [#21564](https://github.com/nodejs/node/pull/21564)
* [[`e3bddeec18`](https://github.com/nodejs/node/commit/e3bddeec18)] - **http**: fix undefined error in parser event (Anatoli Papirovski) [#20029](https://github.com/nodejs/node/pull/20029)
* [[`1edd7f6393`](https://github.com/nodejs/node/commit/1edd7f6393)] - **(SEMVER-MINOR)** **http**: added aborted property to request (Robert Nagy) [#20094](https://github.com/nodejs/node/pull/20094)
* [[`7f34c277ac`](https://github.com/nodejs/node/commit/7f34c277ac)] - **http2**: simplify timeout tracking (Anna Henningsen) [#19206](https://github.com/nodejs/node/pull/19206)
* [[`18a2b3dc8e`](https://github.com/nodejs/node/commit/18a2b3dc8e)] - **(SEMVER-MINOR)** **http2**: graduate from experimental (James M Snell) [#22466](https://github.com/nodejs/node/pull/22466)
* [[`10576d6e77`](https://github.com/nodejs/node/commit/10576d6e77)] - **(SEMVER-MINOR)** **http2**: add ping event (James M Snell) [#23009](https://github.com/nodejs/node/pull/23009)
* [[`ca933ce577`](https://github.com/nodejs/node/commit/ca933ce577)] - **http2**: do not falsely emit 'aborted' on push (Anatoli Papirovski) [#22878](https://github.com/nodejs/node/pull/22878)
* [[`49f44f3b44`](https://github.com/nodejs/node/commit/49f44f3b44)] - **(SEMVER-MINOR)** **http2**: add origin frame support (James M Snell) [#22956](https://github.com/nodejs/node/pull/22956)
* [[`9f7934159e`](https://github.com/nodejs/node/commit/9f7934159e)] - **http2**: check if stream is not destroyed before sending trailers (Matteo Collina) [#22896](https://github.com/nodejs/node/pull/22896)
* [[`2de17ead89`](https://github.com/nodejs/node/commit/2de17ead89)] - **(SEMVER-MINOR)** **http2**: add http2stream.endAfterHeaders property (James M Snell) [#22843](https://github.com/nodejs/node/pull/22843)
* [[`805bf40bfd`](https://github.com/nodejs/node/commit/805bf40bfd)] - **http2**: don't expose the original socket through the socket proxy (Szymon Marczak) [#22650](https://github.com/nodejs/node/pull/22650)
* [[`6a396ff911`](https://github.com/nodejs/node/commit/6a396ff911)] - **http2**: throw better error when accessing unbound socket proxy (James M Snell) [#22486](https://github.com/nodejs/node/pull/22486)
* [[`348cde07fd`](https://github.com/nodejs/node/commit/348cde07fd)] - **http2**: emit timeout on compat request and response (James M Snell) [#22252](https://github.com/nodejs/node/pull/22252)
* [[`cc561cc5a7`](https://github.com/nodejs/node/commit/cc561cc5a7)] - **http2**: explicitly disallow nested push streams (James M Snell) [#22245](https://github.com/nodejs/node/pull/22245)
* [[`5c3edd3479`](https://github.com/nodejs/node/commit/5c3edd3479)] - **http2**: avoid race condition in OnHeaderCallback (James M Snell) [#22256](https://github.com/nodejs/node/pull/22256)
* [[`f2f66b4cfb`](https://github.com/nodejs/node/commit/f2f66b4cfb)] - **http2**: remove `streamError` from docs (James M Snell) [#22246](https://github.com/nodejs/node/pull/22246)
* [[`d602c7a2ed`](https://github.com/nodejs/node/commit/d602c7a2ed)] - **http2**: release request()'s "connect" event listener after it runs (James Ide) [#21916](https://github.com/nodejs/node/pull/21916)
* [[`745e1e6192`](https://github.com/nodejs/node/commit/745e1e6192)] - **http2**: remove unused nghttp2 error list (Anna Henningsen) [#21827](https://github.com/nodejs/node/pull/21827)
* [[`e5175e6596`](https://github.com/nodejs/node/commit/e5175e6596)] - **http2**: remove `waitTrailers` listener after closing a stream (RidgeA) [#21764](https://github.com/nodejs/node/pull/21764)
* [[`071a022dbc`](https://github.com/nodejs/node/commit/071a022dbc)] - **http2**: order declarations in core.js (Rich Trott) [#21689](https://github.com/nodejs/node/pull/21689)
* [[`1cdf93ecdc`](https://github.com/nodejs/node/commit/1cdf93ecdc)] - **http2**: pass incoming set-cookie header as array (Gerhard Stoebich) [#21360](https://github.com/nodejs/node/pull/21360)
* [[`20b72fc94d`](https://github.com/nodejs/node/commit/20b72fc94d)] - **http2**: track memory allocated by nghttp2 (Anna Henningsen) [#21374](https://github.com/nodejs/node/pull/21374)
* [[`e9e4f434b3`](https://github.com/nodejs/node/commit/e9e4f434b3)] - **http2**: fix memory leak when headers are not emitted (Anna Henningsen) [#21373](https://github.com/nodejs/node/pull/21373)
* [[`0f3e65099d`](https://github.com/nodejs/node/commit/0f3e65099d)] - **http2**: fix memory leak for uncommon headers (Anna Henningsen) [#21336](https://github.com/nodejs/node/pull/21336)
* [[`0a8d0861f2`](https://github.com/nodejs/node/commit/0a8d0861f2)] - **http2**: safer Http2Session destructor (Anatoli Papirovski) [#21194](https://github.com/nodejs/node/pull/21194)
* [[`3c8c53f4f4`](https://github.com/nodejs/node/commit/3c8c53f4f4)] - **http2**: fix premature destroy (Anatoli Papirovski) [#21051](https://github.com/nodejs/node/pull/21051)
* [[`b22266cc97`](https://github.com/nodejs/node/commit/b22266cc97)] - **http2**: force through RST\_STREAM in destroy (Anatoli Papirovski) [#21016](https://github.com/nodejs/node/pull/21016)
* [[`91be1dc2a5`](https://github.com/nodejs/node/commit/91be1dc2a5)] - **http2**: delay closing stream (Anatoli Papirovski) [#20997](https://github.com/nodejs/node/pull/20997)
* [[`0a6672fbcf`](https://github.com/nodejs/node/commit/0a6672fbcf)] - **http2**: fix several serious bugs (Anatoli Papirovski) [#20772](https://github.com/nodejs/node/pull/20772)
* [[`b0c92cadfa`](https://github.com/nodejs/node/commit/b0c92cadfa)] - **http2**: fix end without read (Anatoli Papirovski) [#20621](https://github.com/nodejs/node/pull/20621)
* [[`d1b78252b1`](https://github.com/nodejs/node/commit/d1b78252b1)] - **http2**: avoid bind and properly clean up in compat (Robert Nagy) [#20374](https://github.com/nodejs/node/pull/20374)
* [[`395ce845da`](https://github.com/nodejs/node/commit/395ce845da)] - **http2**: rename http2\_state class to Http2State (Daniel Bevenius) [#20423](https://github.com/nodejs/node/pull/20423)
* [[`74192ddb66`](https://github.com/nodejs/node/commit/74192ddb66)] - **http2**: reduce require calls in http2/core (Daniel Bevenius) [#20422](https://github.com/nodejs/node/pull/20422)
* [[`28a6e59bd3`](https://github.com/nodejs/node/commit/28a6e59bd3)] - **http2**: fix ping callback (Ruben Bridgewater) [#20311](https://github.com/nodejs/node/pull/20311)
* [[`41dca9e851`](https://github.com/nodejs/node/commit/41dca9e851)] - **http2**: fix responses to long payload reqs (Anatoli Papirovski) [#20084](https://github.com/nodejs/node/pull/20084)
* [[`fa5a3809a3`](https://github.com/nodejs/node/commit/fa5a3809a3)] - **http2**: refactor how trailers are done (James M Snell) [#19959](https://github.com/nodejs/node/pull/19959)
* [[`5862d0372c`](https://github.com/nodejs/node/commit/5862d0372c)] - **http2**: fix ping duration calculation (James M Snell) [#19956](https://github.com/nodejs/node/pull/19956)
* [[`2ae98ce7cb`](https://github.com/nodejs/node/commit/2ae98ce7cb)] - **lib**: define printErr() in script string (cjihrig) [#19285](https://github.com/nodejs/node/pull/19285)
* [[`b0e3ce9c4b`](https://github.com/nodejs/node/commit/b0e3ce9c4b)] - **net,http2**: refactor \_write and \_writev (Ujjwal Sharma) [#20643](https://github.com/nodejs/node/pull/20643)
* [[`0187e3bef8`](https://github.com/nodejs/node/commit/0187e3bef8)] - **process**: avoid using the same fd for ipc and stdio (cjihrig) [#21466](https://github.com/nodejs/node/pull/21466)
* [[`5b2f6508f9`](https://github.com/nodejs/node/commit/5b2f6508f9)] - **src**: make AsyncWrap constructors delegate (Daniel Bevenius) [#19366](https://github.com/nodejs/node/pull/19366)
* [[`9e8f4e5047`](https://github.com/nodejs/node/commit/9e8f4e5047)] - **src**: remove unused uv.h include from async\_wrap.cc (Daniel Bevenius) [#19342](https://github.com/nodejs/node/pull/19342)
* [[`042434f9af`](https://github.com/nodejs/node/commit/042434f9af)] - **src**: fix indenting of wrap-\>EmitTraceEventBefore (Daniel Bevenius) [#19340](https://github.com/nodejs/node/pull/19340)
* [[`3ad10e5789`](https://github.com/nodejs/node/commit/3ad10e5789)] - **src**: add extractPromiseWrap function (Daniel Bevenius) [#19340](https://github.com/nodejs/node/pull/19340)
* [[`b67bf38f31`](https://github.com/nodejs/node/commit/b67bf38f31)] - **src**: fix fs.write() externalized string handling (Ben Noordhuis) [#18216](https://github.com/nodejs/node/pull/18216)
* [[`0157e3ebca`](https://github.com/nodejs/node/commit/0157e3ebca)] - **src,deps**: add ABI safe use of CheckMemoryPressure (Ali Ijaz Sheikh) [#24499](https://github.com/nodejs/node/pull/24499)
* [[`dbc7d9baae`](https://github.com/nodejs/node/commit/dbc7d9baae)] - **test**: read() on dir on AIX does not return EISDIR (Ben Noordhuis) [#23330](https://github.com/nodejs/node/pull/23330)
* [[`3cd4462370`](https://github.com/nodejs/node/commit/3cd4462370)] - **test**: ensure failed assertions cause build to fail (Teddy Katz) [#19650](https://github.com/nodejs/node/pull/19650)
* [[`9f15bc40b8`](https://github.com/nodejs/node/commit/9f15bc40b8)] - **test**: skip failing tests for osx mojave (jn99) [#23550](https://github.com/nodejs/node/pull/23550)
* [[`aba1ff202c`](https://github.com/nodejs/node/commit/aba1ff202c)] - **test**: refactor test-fs-readfile-tostring-fail (Rich Trott) [#19404](https://github.com/nodejs/node/pull/19404)
* [[`38ed6c2b25`](https://github.com/nodejs/node/commit/38ed6c2b25)] - **test**: fix flaky test-http2-ping-flood (Rich Trott) [#19395](https://github.com/nodejs/node/pull/19395)
* [[`b407060556`](https://github.com/nodejs/node/commit/b407060556)] - **test**: fix flaky test-http2-settings-flood (Rich Trott) [#19349](https://github.com/nodejs/node/pull/19349)
* [[`069fd79424`](https://github.com/nodejs/node/commit/069fd79424)] - **test**: improve debugging information for http2 test (Rich Trott) [#23058](https://github.com/nodejs/node/pull/23058)
* [[`c0f8e49c32`](https://github.com/nodejs/node/commit/c0f8e49c32)] - **test**: remove setImmediate from timeout test (Rich Trott) [#23058](https://github.com/nodejs/node/pull/23058)
* [[`b66cba0766`](https://github.com/nodejs/node/commit/b66cba0766)] - **test**: add test-http2-large-file sequential test (James M Snell) [#22254](https://github.com/nodejs/node/pull/22254)
* [[`7ea08eedac`](https://github.com/nodejs/node/commit/7ea08eedac)] - **test**: improve reliability in http2-session-timeout (Rich Trott) [#22026](https://github.com/nodejs/node/pull/22026)
* [[`dcf04dc7df`](https://github.com/nodejs/node/commit/dcf04dc7df)] - **test**: refactor test-http2-compat-serverresponse-finished.js (Anto Aravinth) [#21929](https://github.com/nodejs/node/pull/21929)
* [[`322f39d490`](https://github.com/nodejs/node/commit/322f39d490)] - **test**: minor adjustments to test-http2-respond-file (Anna Henningsen) [#21098](https://github.com/nodejs/node/pull/21098)
* [[`5d29e2c631`](https://github.com/nodejs/node/commit/5d29e2c631)] - **test**: fix flaky http2-session-unref (Anatoli Papirovski) [#20772](https://github.com/nodejs/node/pull/20772)
* [[`e5f8b08305`](https://github.com/nodejs/node/commit/e5f8b08305)] - **test**: improve reliability of http2-session-timeout (Rich Trott) [#20692](https://github.com/nodejs/node/pull/20692)
* [[`c30a8f468d`](https://github.com/nodejs/node/commit/c30a8f468d)] - **test**: fix flaky http2-flow-control test (Anatoli Papirovski) [#20556](https://github.com/nodejs/node/pull/20556)
* [[`aa341d1d3d`](https://github.com/nodejs/node/commit/aa341d1d3d)] - **test**: verify arguments length in common.expectsError (Ruben Bridgewater) [#20311](https://github.com/nodejs/node/pull/20311)
* [[`c7ba556264`](https://github.com/nodejs/node/commit/c7ba556264)] - **test**: removed assert.strictEqual message (kailash k yogeshwar) [#20223](https://github.com/nodejs/node/pull/20223)
* [[`5abe246a44`](https://github.com/nodejs/node/commit/5abe246a44)] - **test**: add strictEqual method to assert (Christine E. Taylor) [#20189](https://github.com/nodejs/node/pull/20189)
* [[`887417eb37`](https://github.com/nodejs/node/commit/887417eb37)] - **test**: remove message from strictEqual assertions (Bryan Azofeifa) [#20174](https://github.com/nodejs/node/pull/20174)
* [[`fe3836a871`](https://github.com/nodejs/node/commit/fe3836a871)] - **test**: delete test/parallel/test-regress-GH-4948 (Ujjwal Sharma)
* [[`4bcdc1b83c`](https://github.com/nodejs/node/commit/4bcdc1b83c)] - **test**: fix assertion argument order (Rich Trott) [#19264](https://github.com/nodejs/node/pull/19264)
* [[`534bc82578`](https://github.com/nodejs/node/commit/534bc82578)] - **test**: name test files appropriately (Ujjwal Sharma) [#19212](https://github.com/nodejs/node/pull/19212)
* [[`d58867a6a7`](https://github.com/nodejs/node/commit/d58867a6a7)] - **test**: call gc() explicitly to avoid OOM (Refael Ackermann) [#22301](https://github.com/nodejs/node/pull/22301)
* [[`8209ccb313`](https://github.com/nodejs/node/commit/8209ccb313)] - **test**: prepare test-assert for strictEqual linting (Rich Trott) [#22849](https://github.com/nodejs/node/pull/22849)
* [[`52b21caff2`](https://github.com/nodejs/node/commit/52b21caff2)] - **test**: remove string literal from assertion (Rich Trott) [#22849](https://github.com/nodejs/node/pull/22849)
* [[`976d55f9e3`](https://github.com/nodejs/node/commit/976d55f9e3)] - **test**: remove string literal from assertion (Rich Trott) [#22849](https://github.com/nodejs/node/pull/22849)
* [[`702d67f4c4`](https://github.com/nodejs/node/commit/702d67f4c4)] - **test**: refactor flag check (Rich Trott) [#22849](https://github.com/nodejs/node/pull/22849)
* [[`e9416d4f67`](https://github.com/nodejs/node/commit/e9416d4f67)] - **test**: simplify assertion in http2 tests (Rich Trott) [#22849](https://github.com/nodejs/node/pull/22849)
* [[`f2158f30fb`](https://github.com/nodejs/node/commit/f2158f30fb)] - **test**: improve assertion in test-inspector.js (Rich Trott) [#22849](https://github.com/nodejs/node/pull/22849)
* [[`f5985c734c`](https://github.com/nodejs/node/commit/f5985c734c)] - **tls,http2**: handle writes after SSL destroy more gracefully (Anna Henningsen) [#18987](https://github.com/nodejs/node/pull/18987)

<a id="8.12.0"></a>
## 2018-09-11, Version 8.12.0 'Carbon' (LTS), @MylesBorins

### Notable Changes

* **async_hooks**:
  - rename PromiseWrap.parentId (Ali Ijaz Sheikh) [#18633](https://github.com/nodejs/node/pull/18633)
  - remove runtime deprecation (Ali Ijaz Sheikh) [#19517](https://github.com/nodejs/node/pull/19517)
  - deprecate unsafe emit{Before,After} (Ali Ijaz Sheikh) [#18513](https://github.com/nodejs/node/pull/18513)
* **cluster**:
  - add cwd to cluster.settings (cjihrig) [#18399](https://github.com/nodejs/node/pull/18399)
  - support windowsHide option for workers (Todd Wong) [#17412](https://github.com/nodejs/node/pull/17412)
* **crypto**:
  - allow passing null as IV unless required (Tobias Nießen) [#18644](https://github.com/nodejs/node/pull/18644)
* **deps**:
  - upgrade npm to 6.4.1 (Kat Marchán) [#22591](https://github.com/nodejs/node/pull/22591)
  - upgrade libuv to 1.19.2 (cjihrig) [#18918](https://github.com/nodejs/node/pull/18918)
  - Upgrade node-inspect to 1.11.5 (Jan Krems) [#21055](https://github.com/nodejs/node/pull/21055)
* **fs,net**:
  - support as and as+ flags in stringToFlags() (Sarat Addepalli) [#18801](https://github.com/nodejs/node/pull/18801)
  - emit 'ready' for fs streams and sockets (Sameer Srivastava) [#19408](https://github.com/nodejs/node/pull/19408)
* **http, http2**:
  - add options to http.createServer() (Peter Marton) [#15752](https://github.com/nodejs/node/pull/15752)-
  - add 103 Early Hints status code (Yosuke Furukawa) [#16644](https://github.com/nodejs/node/pull/16644)
  - add http fallback options to .createServer (Peter Marton) [#15752](https://github.com/nodejs/node/pull/15752)
* **n-api**:
  - take n-api out of experimental (Michael Dawson) [#19262](https://github.com/nodejs/node/pull/19262)
* **perf_hooks**:
  - add warning when too many entries in the timeline (James M Snell) [#18087](https://github.com/nodejs/node/pull/18087)
* **src**:
  - add public API for managing NodePlatform (Cheng Zhao) [#16981](https://github.com/nodejs/node/pull/16981)
  - allow --perf-(basic-)?prof in NODE\_OPTIONS (Leko) [#17600](https://github.com/nodejs/node/pull/17600)
  - node internals' postmortem metadata (Matheus Marchini) [#14901](https://github.com/nodejs/node/pull/14901)
* **tls**:
  - expose Finished messages in TLSSocket (Anton Salikhmetov) [#19102](https://github.com/nodejs/node/pull/19102)
* **trace_events**:
  - add file pattern cli option (Andreas Madsen) [#18480](https://github.com/nodejs/node/pull/18480)
* **util**:
  - implement util.getSystemErrorName() (Joyee Cheung) [#18186](https://github.com/nodejs/node/pull/18186)

### Commits

* [[`b7f9334454`](https://github.com/nodejs/node/commit/b7f9334454)] - **(SEMVER-MINOR)** **async_hooks**: rename PromiseWrap.parentId (Ali Ijaz Sheikh) [#18633](https://github.com/nodejs/node/pull/18633)
* [[`373f4d6225`](https://github.com/nodejs/node/commit/373f4d6225)] - **(SEMVER-MINOR)** **async_hooks**: remove runtime deprecation (Ali Ijaz Sheikh) [#19517](https://github.com/nodejs/node/pull/19517)
* [[`daacff8584`](https://github.com/nodejs/node/commit/daacff8584)] - **(SEMVER-MINOR)** **async_hooks**: deprecate unsafe emit{Before,After} (Ali Ijaz Sheikh) [#18513](https://github.com/nodejs/node/pull/18513)
* [[`8f5e9916d1`](https://github.com/nodejs/node/commit/8f5e9916d1)] - **async_wrap**: fix memory leak in AsyncResource (Michael Dawson) [#20668](https://github.com/nodejs/node/pull/20668)
* [[`0a3ebb030e`](https://github.com/nodejs/node/commit/0a3ebb030e)] - **benchmark**: add JSStreamWrap benchmark (Anna Henningsen) [#17983](https://github.com/nodejs/node/pull/17983)
* [[`4009e3f245`](https://github.com/nodejs/node/commit/4009e3f245)] - **buffer**: fix typo in lib/buffer.js (Ujjwal Sharma) [#19126](https://github.com/nodejs/node/pull/19126)
* [[`20d805e4bc`](https://github.com/nodejs/node/commit/20d805e4bc)] - **build**: disable openssl build warnings on macos (Ben Noordhuis) [#19046](https://github.com/nodejs/node/pull/19046)
* [[`abcc9119d2`](https://github.com/nodejs/node/commit/abcc9119d2)] - **build**: fix rm commands in tarball rule (Ben Noordhuis) [#18332](https://github.com/nodejs/node/pull/18332)
* [[`0bef96094e`](https://github.com/nodejs/node/commit/0bef96094e)] - **build**: include the libuv and zlib into node (Yihong Wang) [#18383](https://github.com/nodejs/node/pull/18383)
* [[`2ec7dd4edc`](https://github.com/nodejs/node/commit/2ec7dd4edc)] - **build**: fix configure script for double-digits (Misty De Meo) [#21183](https://github.com/nodejs/node/pull/21183)
* [[`020057ade7`](https://github.com/nodejs/node/commit/020057ade7)] - **build**: make lint-ci work properly on Linux make (Rod Vagg) [#19746](https://github.com/nodejs/node/pull/19746)
* [[`18fd620606`](https://github.com/nodejs/node/commit/18fd620606)] - **build**: add node\_lib\_target\_name to cctest deps (Daniel Bevenius) [#18576](https://github.com/nodejs/node/pull/18576)
* [[`9bd5fc2b34`](https://github.com/nodejs/node/commit/9bd5fc2b34)] - **build**: make gyp user defined variables lowercase (Daniel Bevenius) [#16238](https://github.com/nodejs/node/pull/16238)
* [[`1d90700514`](https://github.com/nodejs/node/commit/1d90700514)] - **child_process**: fix stdio sockets creation (Santiago Gimeno) [#18701](https://github.com/nodejs/node/pull/18701)
* [[`dc000a55d3`](https://github.com/nodejs/node/commit/dc000a55d3)] - **(SEMVER-MINOR)** **cluster**: add cwd to cluster.settings (cjihrig) [#18399](https://github.com/nodejs/node/pull/18399)
* [[`76805f0043`](https://github.com/nodejs/node/commit/76805f0043)] - **(SEMVER-MINOR)** **cluster**: support windowsHide option for workers (Todd Wong) [#17412](https://github.com/nodejs/node/pull/17412)
* [[`4d5cb4c8b5`](https://github.com/nodejs/node/commit/4d5cb4c8b5)] - **crypto**: use bool over int consistently (Tobias Nießen) [#19238](https://github.com/nodejs/node/pull/19238)
* [[`5a3dc37bc8`](https://github.com/nodejs/node/commit/5a3dc37bc8)] - **crypto**: Use math.h definitions of isnan and isinf (Jeroen Roovers) [#19196](https://github.com/nodejs/node/pull/19196)
* [[`fc34f5cae2`](https://github.com/nodejs/node/commit/fc34f5cae2)] - **(SEMVER-MINOR)** **crypto**: allow passing null as IV unless required (Tobias Nießen) [#18644](https://github.com/nodejs/node/pull/18644)
* [[`4f3bf0449c`](https://github.com/nodejs/node/commit/4f3bf0449c)] - **crypto**: use non-deprecated v8::Object::Set (Daniel Bevenius) [#17482](https://github.com/nodejs/node/pull/17482)
* [[`c491ac424b`](https://github.com/nodejs/node/commit/c491ac424b)] - **crypto**: remove BIO\_set\_shutdown (Daniel Bevenius) [#17542](https://github.com/nodejs/node/pull/17542)
* [[`f82d58db4c`](https://github.com/nodejs/node/commit/f82d58db4c)] - **(SEMVER-MINOR)** **deps**: upgrade npm to 6.4.1 (Kat Marchán) [#22591](https://github.com/nodejs/node/pull/22591)
* [[`5294919d05`](https://github.com/nodejs/node/commit/5294919d05)] - **deps**: V8: cherry-pick 9040405 from upstream (Junliang Yan) [#22375](https://github.com/nodejs/node/pull/22375)
* [[`ae63db8624`](https://github.com/nodejs/node/commit/ae63db8624)] - **deps**: backport 804a693 from upstream V8 (Matheus Marchini) [#21855](https://github.com/nodejs/node/pull/21855)
* [[`bf2daab673`](https://github.com/nodejs/node/commit/bf2daab673)] - **deps**: Upgrade node-inspect to 1.11.5 (Jan Krems) [#21055](https://github.com/nodejs/node/pull/21055)
* [[`d9ab189f55`](https://github.com/nodejs/node/commit/d9ab189f55)] - **deps**: cherry-pick b767cde1e7 from upstream V8 (Ben Noordhuis) [#19710](https://github.com/nodejs/node/pull/19710)
* [[`812b97c826`](https://github.com/nodejs/node/commit/812b97c826)] - **deps**: fix typo in openssl upgrading doc (Daniel Bevenius) [#19789](https://github.com/nodejs/node/pull/19789)
* [[`60733a7a78`](https://github.com/nodejs/node/commit/60733a7a78)] - **deps**: upgrade libuv to 1.19.2 (cjihrig) [#18918](https://github.com/nodejs/node/pull/18918)
* [[`31883368c7`](https://github.com/nodejs/node/commit/31883368c7)] - **deps**: cherry-pick 0c35b72 from upstream V8 (Gus Caplan) [#18038](https://github.com/nodejs/node/pull/18038)
* [[`74ca456af0`](https://github.com/nodejs/node/commit/74ca456af0)] - **(SEMVER-MINOR)** **deps**: upgrade npm to 6.2.0 (Kat Marchán) [#21592](https://github.com/nodejs/node/pull/21592)
* [[`ffb72f810e`](https://github.com/nodejs/node/commit/ffb72f810e)] - **deps**: cherry-pick 09b53ee from upstream V8 (Anna Henningsen) [#21767](https://github.com/nodejs/node/pull/21767)
* [[`8e0f28b8f0`](https://github.com/nodejs/node/commit/8e0f28b8f0)] - **deps**: V8: backport 49712d8a from upstream (Ali Ijaz Sheikh) [#21334](https://github.com/nodejs/node/pull/21334)
* [[`efe28b8581`](https://github.com/nodejs/node/commit/efe28b8581)] - **deps**: V8: fix bug in InternalPerformPromiseThen (Ali Ijaz Sheikh) [#21426](https://github.com/nodejs/node/pull/21426)
* [[`9aeffab452`](https://github.com/nodejs/node/commit/9aeffab452)] - **deps**: V8: cherry-pick 8361fa58 from upstream (Ali Ijaz Sheikh) [#21294](https://github.com/nodejs/node/pull/21294)
* [[`f987a512d4`](https://github.com/nodejs/node/commit/f987a512d4)] - **deps**: V8: backport b49206d from upstream (Ali Ijaz Sheikh) [#20727](https://github.com/nodejs/node/pull/20727)
* [[`185aca054e`](https://github.com/nodejs/node/commit/185aca054e)] - **deps**: float fix on node-gyp in npm tree (Myles Borins) [#21448](https://github.com/nodejs/node/pull/21448)
* [[`677236494b`](https://github.com/nodejs/node/commit/677236494b)] - **(SEMVER-MINOR)** **deps**: upgrade npm to 6.1.0 (Rebecca Turner) [#20190](https://github.com/nodejs/node/pull/20190)
* [[`e6cd7e57b3`](https://github.com/nodejs/node/commit/e6cd7e57b3)] - **deps**: V8: cherry-pick 5ebd6fcd from upstream (Ali Ijaz Sheikh) [#21269](https://github.com/nodejs/node/pull/21269)
* [[`d868eb784c`](https://github.com/nodejs/node/commit/d868eb784c)] - **deps**: V8: cherry-pick 502c6ae6 from upstream (Ali Ijaz Sheikh) [#21269](https://github.com/nodejs/node/pull/21269)
* [[`656ceea393`](https://github.com/nodejs/node/commit/656ceea393)] - **deps**: cherry-pick dbfe4a49d8 from upstream V8 (Jan Krems) [#16889](https://github.com/nodejs/node/pull/16889)
* [[`a02319368c`](https://github.com/nodejs/node/commit/a02319368c)] - **doc**: fix/add link to Android info (Vse Mozhet Byt) [#19004](https://github.com/nodejs/node/pull/19004)
* [[`cae60ca57a`](https://github.com/nodejs/node/commit/cae60ca57a)] - **doc**: add warning to assert.doesNotThrow() (Ruben Bridgewater) [#18699](https://github.com/nodejs/node/pull/18699)
* [[`7ed297d528`](https://github.com/nodejs/node/commit/7ed297d528)] - **doc**: remove warning against readable/readable.read (Rich Trott) [#19193](https://github.com/nodejs/node/pull/19193)
* [[`94d27e21ef`](https://github.com/nodejs/node/commit/94d27e21ef)] - **doc**: add inspector usage example (Ali Ijaz Sheikh) [#19172](https://github.com/nodejs/node/pull/19172)
* [[`1116d3274d`](https://github.com/nodejs/node/commit/1116d3274d)] - **doc**: make suggestion more direct in stream.md (Rich Trott) [#19124](https://github.com/nodejs/node/pull/19124)
* [[`369e1efca9`](https://github.com/nodejs/node/commit/369e1efca9)] - **doc**: remove subsystem from pull request template (Rich Trott) [#19125](https://github.com/nodejs/node/pull/19125)
* [[`d14137590e`](https://github.com/nodejs/node/commit/d14137590e)] - **doc**: remove tentativeness in pull-requests.md (Rich Trott) [#19123](https://github.com/nodejs/node/pull/19123)
* [[`e2190ad755`](https://github.com/nodejs/node/commit/e2190ad755)] - **doc**: add simple example to rename function (punteek) [#18812](https://github.com/nodejs/node/pull/18812)
* [[`d9895c4ba7`](https://github.com/nodejs/node/commit/d9895c4ba7)] - **doc**: add URL.format() example (Zeke Sikelianos) [#18888](https://github.com/nodejs/node/pull/18888)
* [[`c2978ac045`](https://github.com/nodejs/node/commit/c2978ac045)] - **doc**: update list of re-exported symbols (Richard Lau) [#19013](https://github.com/nodejs/node/pull/19013)
* [[`7f6e0b3510`](https://github.com/nodejs/node/commit/7f6e0b3510)] - **doc**: Readable unpipe on Writable error event (George Sapkin) [#18080](https://github.com/nodejs/node/pull/18080)
* [[`ce66b02f97`](https://github.com/nodejs/node/commit/ce66b02f97)] - **doc**: add RegExp Unicode Property Escapes to intl (Vse Mozhet Byt) [#19052](https://github.com/nodejs/node/pull/19052)
* [[`68e78e8e9e`](https://github.com/nodejs/node/commit/68e78e8e9e)] - **doc**: make the background section concise and improve its formality (Wilson) [#18928](https://github.com/nodejs/node/pull/18928)
* [[`dbc5bedd3e`](https://github.com/nodejs/node/commit/dbc5bedd3e)] - **doc**: add process.debugPort to doc/api/process.md (flickz) [#18716](https://github.com/nodejs/node/pull/18716)
* [[`dc6dadd585`](https://github.com/nodejs/node/commit/dc6dadd585)] - **doc**: `readable.push(undefined)` in non-object mode (陈刚) [#18283](https://github.com/nodejs/node/pull/18283)
* [[`4a795dd084`](https://github.com/nodejs/node/commit/4a795dd084)] - **doc**: improve buf.lastIndexOf() text (Rich Trott) [#19904](https://github.com/nodejs/node/pull/19904)
* [[`24a105f63f`](https://github.com/nodejs/node/commit/24a105f63f)] - **doc**: remove eu-strip from tarball (jvelezpo) [#20304](https://github.com/nodejs/node/pull/20304)
* [[`14a5dd4769`](https://github.com/nodejs/node/commit/14a5dd4769)] - **doc**: add tools/doc/README link in doc/STYLE\_GUIDE (Vse Mozhet Byt) [#20071](https://github.com/nodejs/node/pull/20071)
* [[`f391181b27`](https://github.com/nodejs/node/commit/f391181b27)] - **doc**: update tools/doc/README.md (Vse Mozhet Byt) [#20047](https://github.com/nodejs/node/pull/20047)
* [[`ab559b88f6`](https://github.com/nodejs/node/commit/ab559b88f6)] - **doc**: add trivikr to collaborators (Trivikram) [#19384](https://github.com/nodejs/node/pull/19384)
* [[`98fe68fbb0`](https://github.com/nodejs/node/commit/98fe68fbb0)] - **doc**: add pronouns to readme (Teddy Katz) [#22036](https://github.com/nodejs/node/pull/22036)
* [[`274b2d2a89`](https://github.com/nodejs/node/commit/274b2d2a89)] - **doc**: remove confusing "cats" from style guide (Rich Trott) [#19246](https://github.com/nodejs/node/pull/19246)
* [[`20ee726c9c`](https://github.com/nodejs/node/commit/20ee726c9c)] - **doc**: remove superfluous adverb from style guide (Rich Trott) [#19246](https://github.com/nodejs/node/pull/19246)
* [[`b9b422abe2`](https://github.com/nodejs/node/commit/b9b422abe2)] - **doc**: add watson to collaborators (Thomas Watson) [#19234](https://github.com/nodejs/node/pull/19234)
* [[`eae80e43ae`](https://github.com/nodejs/node/commit/eae80e43ae)] - **doc**: add MoonBall to collaborators (Chen Gang) [#19109](https://github.com/nodejs/node/pull/19109)
* [[`f876887cae`](https://github.com/nodejs/node/commit/f876887cae)] - **doc**: update description of 'clientError' event (Luigi Pinca) [#18885](https://github.com/nodejs/node/pull/18885)
* [[`07e2bd4b73`](https://github.com/nodejs/node/commit/07e2bd4b73)] - **doc**: remove CII badge in README (Roman Reiss) [#18908](https://github.com/nodejs/node/pull/18908)
* [[`8fad7affd9`](https://github.com/nodejs/node/commit/8fad7affd9)] - **doc**: fix nits in tools/doc/README.md (Vse Mozhet Byt) [#18874](https://github.com/nodejs/node/pull/18874)
* [[`a1902caf09`](https://github.com/nodejs/node/commit/a1902caf09)] - **doc**: improved documentation for fs.unlink() (dustinnewman98) [#18843](https://github.com/nodejs/node/pull/18843)
* [[`8c5ad68add`](https://github.com/nodejs/node/commit/8c5ad68add)] - **doc**: fix broken link in pull-requests.md (Justin Lee) [#18873](https://github.com/nodejs/node/pull/18873)
* [[`399ba4b8d8`](https://github.com/nodejs/node/commit/399ba4b8d8)] - **doc**: mark accessing IPC channel fd as undefined (Bartosz Sosnowski) [#17545](https://github.com/nodejs/node/pull/17545)
* [[`2cbeea0926`](https://github.com/nodejs/node/commit/2cbeea0926)] - **doc**: add Yihong Wang to collaborators (Yihong Wang) [#18824](https://github.com/nodejs/node/pull/18824)
* [[`f57c53c811`](https://github.com/nodejs/node/commit/f57c53c811)] - **doc**: add missing metadata for fs.open (Tobias Nießen) [#19585](https://github.com/nodejs/node/pull/19585)
* [[`ebd73ad27a`](https://github.com/nodejs/node/commit/ebd73ad27a)] - **doc**: activate `no-multiple-empty-lines` rule (Ruben Bridgewater) [#18747](https://github.com/nodejs/node/pull/18747)
* [[`adca631f8a`](https://github.com/nodejs/node/commit/adca631f8a)] - **doc**: note that linting is required in releases.md (Gibson Fahnestock) [#18776](https://github.com/nodejs/node/pull/18776)
* [[`a5ee6eeea7`](https://github.com/nodejs/node/commit/a5ee6eeea7)] - **doc**: remove extra space in README.md (Matheus Marchini) [#18822](https://github.com/nodejs/node/pull/18822)
* [[`9c52231a05`](https://github.com/nodejs/node/commit/9c52231a05)] - **doc**: update crypo Certficate class. (Antoine AMARA) [#18721](https://github.com/nodejs/node/pull/18721)
* [[`a26454ea32`](https://github.com/nodejs/node/commit/a26454ea32)] - **doc**: add error check to fs example (Evan Lucas) [#18681](https://github.com/nodejs/node/pull/18681)
* [[`531cb6238d`](https://github.com/nodejs/node/commit/531cb6238d)] - **doc**: add missing metadata for settings.windowsHide (Tobias Nießen) [#19578](https://github.com/nodejs/node/pull/19578)
* [[`bb85fd6f5b`](https://github.com/nodejs/node/commit/bb85fd6f5b)] - **doc**: add missing metadata for cluster.settings.cwd (Tobias Nießen) [#19569](https://github.com/nodejs/node/pull/19569)
* [[`4709734cfc`](https://github.com/nodejs/node/commit/4709734cfc)] - **doc**: cleanup n-api.md doc (Michael Dawson) [#20430](https://github.com/nodejs/node/pull/20430)
* [[`e1a7244fbd`](https://github.com/nodejs/node/commit/e1a7244fbd)] - **doc**: Uint8Array support in Buffer functions (SheetJS) [#19949](https://github.com/nodejs/node/pull/19949)
* [[`3ad5e30e05`](https://github.com/nodejs/node/commit/3ad5e30e05)] - **doc**: remove ES6/ECMAScript 2015 from buffer.md (Rich Trott) [#19685](https://github.com/nodejs/node/pull/19685)
* [[`41bb1107cf`](https://github.com/nodejs/node/commit/41bb1107cf)] - **doc**: Uint8Array support in Buffer functions (SheetJS) [#19949](https://github.com/nodejs/node/pull/19949)
* [[`cf0577eef2`](https://github.com/nodejs/node/commit/cf0577eef2)] - **doc**: remove ES6/ECMAScript 2015 from buffer.md (Rich Trott) [#19685](https://github.com/nodejs/node/pull/19685)
* [[`fceeee616b`](https://github.com/nodejs/node/commit/fceeee616b)] - **doc**: Update tools/icu/README.md (Steven R. Loomis) [#16939](https://github.com/nodejs/node/pull/16939)
* [[`52f5829cdb`](https://github.com/nodejs/node/commit/52f5829cdb)] - **doc**: fix typo in http2.md (Vse Mozhet Byt) [#18872](https://github.com/nodejs/node/pull/18872)
* [[`50316e2021`](https://github.com/nodejs/node/commit/50316e2021)] - **doc,tools**: formalize, unify, codify default values (Vse Mozhet Byt) [#19737](https://github.com/nodejs/node/pull/19737)
* [[`98f5b17ee1`](https://github.com/nodejs/node/commit/98f5b17ee1)] - **errors**: make message non-enumerable (Ruben Bridgewater) [#19719](https://github.com/nodejs/node/pull/19719)
* [[`9dc1f509f1`](https://github.com/nodejs/node/commit/9dc1f509f1)] - **errors**: move error creation helpers to errors.js (Joyee Cheung) [#18546](https://github.com/nodejs/node/pull/18546)
* [[`9696bf920f`](https://github.com/nodejs/node/commit/9696bf920f)] - **errors**: lazy load util in internal/errors.js (Joyee Cheung) [#18358](https://github.com/nodejs/node/pull/18358)
* [[`e25d5d077d`](https://github.com/nodejs/node/commit/e25d5d077d)] - **(SEMVER-MINOR)** **fs**: support as and as+ flags in stringToFlags() (Sarat Addepalli) [#18801](https://github.com/nodejs/node/pull/18801)
* [[`35a1bd97ba`](https://github.com/nodejs/node/commit/35a1bd97ba)] - **(SEMVER-MINOR)** **fs,net**: emit 'ready' for fs streams and sockets (Sameer Srivastava) [#19408](https://github.com/nodejs/node/pull/19408)
* [[`68a810cd85`](https://github.com/nodejs/node/commit/68a810cd85)] - **http**: prevent aborted event when already completed (Andrew Johnston) [#18999](https://github.com/nodejs/node/pull/18999)
* [[`c4fa1f72a2`](https://github.com/nodejs/node/commit/c4fa1f72a2)] - **http**: prevent aborted event when already completed (Andrew Johnston) [#18999](https://github.com/nodejs/node/pull/18999)
* [[`1fc00f0821`](https://github.com/nodejs/node/commit/1fc00f0821)] - **http**: do not rely on the 'agentRemove' event (Luigi Pinca) [#20786](https://github.com/nodejs/node/pull/20786)
* [[`e094275799`](https://github.com/nodejs/node/commit/e094275799)] - **http**: simplify parser lifetime tracking (Anna Henningsen) [#18135](https://github.com/nodejs/node/pull/18135)
* [[`01dc646382`](https://github.com/nodejs/node/commit/01dc646382)] - **(SEMVER-MINOR)** **http**: add options to http.createServer() (Peter Marton) [#15752](https://github.com/nodejs/node/pull/15752)
* [[`7c43099d1e`](https://github.com/nodejs/node/commit/7c43099d1e)] - **(SEMVER-MINOR)** **http, http2**: add 103 Early Hints status code (Yosuke Furukawa) [#16644](https://github.com/nodejs/node/pull/16644)
* [[`87818dc8bc`](https://github.com/nodejs/node/commit/87818dc8bc)] - **http2**: destroy the socket properly and add tests (Mathias Buus) [#19852](https://github.com/nodejs/node/pull/19852)
* [[`de51a83e58`](https://github.com/nodejs/node/commit/de51a83e58)] - **http2**: remove unused using declarations node\_http2 (Daniel Bevenius) [#20420](https://github.com/nodejs/node/pull/20420)
* [[`a29cd25b41`](https://github.com/nodejs/node/commit/a29cd25b41)] - **http2**: refer to stream errors by name (Anna Henningsen) [#18966](https://github.com/nodejs/node/pull/18966)
* [[`06329a8eaf`](https://github.com/nodejs/node/commit/06329a8eaf)] - **http2**: remove duplicate words in comments (Tobias Nießen) [#17939](https://github.com/nodejs/node/pull/17939)
* [[`955080f7ee`](https://github.com/nodejs/node/commit/955080f7ee)] - **http2**: pass session to DEBUG\_HTTP2SESSION2 (Daniel Bevenius) [#20815](https://github.com/nodejs/node/pull/20815)
* [[`b1b0486049`](https://github.com/nodejs/node/commit/b1b0486049)] - **http2**: add req and res options to server creation (Peter Marton) [#15560](https://github.com/nodejs/node/pull/15560)
* [[`3f78847e0e`](https://github.com/nodejs/node/commit/3f78847e0e)] - **(SEMVER-MINOR)** **http2**: add http fallback options to .createServer (Peter Marton) [#15752](https://github.com/nodejs/node/pull/15752)
* [[`cf833e4901`](https://github.com/nodejs/node/commit/cf833e4901)] - **lib**: change hook -\> hooks in code comment (Daniel Bevenius) [#19053](https://github.com/nodejs/node/pull/19053)
* [[`29b5d3999e`](https://github.com/nodejs/node/commit/29b5d3999e)] - **lib**: re-fix v8\_prof\_processor (Anna Henningsen) [#19059](https://github.com/nodejs/node/pull/19059)
* [[`2702fd779e`](https://github.com/nodejs/node/commit/2702fd779e)] - **lib**: replace `eval` with `vm.runInThisContext` (Myles Borins) [#18623](https://github.com/nodejs/node/pull/18623)
* [[`7e23946c87`](https://github.com/nodejs/node/commit/7e23946c87)] - **lib**: provide proper deprecation code (Ruben Bridgewater) [#18694](https://github.com/nodejs/node/pull/18694)
* [[`7c6e391419`](https://github.com/nodejs/node/commit/7c6e391419)] - **lib, src**: use process.config instead of regex (Jon Moss) [#17814](https://github.com/nodejs/node/pull/17814)
* [[`0f83f251fe`](https://github.com/nodejs/node/commit/0f83f251fe)] - **module**: enable dynamic import flag for esmodules (Myles Borins) [#18387](https://github.com/nodejs/node/pull/18387)
* [[`d7192c4e6a`](https://github.com/nodejs/node/commit/d7192c4e6a)] - **module**: Set dynamic import callback (Jan Krems) [#15713](https://github.com/nodejs/node/pull/15713)
* [[`35a8ff7e55`](https://github.com/nodejs/node/commit/35a8ff7e55)] - **n-api**: create functions directly (Gabriel Schulhof) [#21688](https://github.com/nodejs/node/pull/21688)
* [[`7033bbaa01`](https://github.com/nodejs/node/commit/7033bbaa01)] - **n-api**: throw when entry point is null (Gabriel Schulhof) [#20779](https://github.com/nodejs/node/pull/20779)
* [[`4911c4e9fa`](https://github.com/nodejs/node/commit/4911c4e9fa)] - **n-api**: improve runtime perf of n-api func call (Kenny Yuan) [#21072](https://github.com/nodejs/node/pull/21072)
* [[`0b2f52706d`](https://github.com/nodejs/node/commit/0b2f52706d)] - **(SEMVER-MINOR)** **n-api**: take n-api out of experimental (Michael Dawson) [#19262](https://github.com/nodejs/node/pull/19262)
* [[`4a267f0e3c`](https://github.com/nodejs/node/commit/4a267f0e3c)] - **net**: simplify net.Socket#end() (Anna Henningsen) [#18708](https://github.com/nodejs/node/pull/18708)
* [[`3d38bab64e`](https://github.com/nodejs/node/commit/3d38bab64e)] - **net**: use `\_final` instead of `on('finish')` (Anna Henningsen) [#18608](https://github.com/nodejs/node/pull/18608)
* [[`1a1288d03c`](https://github.com/nodejs/node/commit/1a1288d03c)] - **perf_hooks**: fix timing (Timothy Gu) [#18993](https://github.com/nodejs/node/pull/18993)
* [[`b4192b007b`](https://github.com/nodejs/node/commit/b4192b007b)] - **(SEMVER-MINOR)** **perf_hooks**: add warning when too many entries in the timeline (James M Snell) [#18087](https://github.com/nodejs/node/pull/18087)
* [[`68d33c692e`](https://github.com/nodejs/node/commit/68d33c692e)] - **perf_hooks**: fix scheduling regression (Anatoli Papirovski) [#18051](https://github.com/nodejs/node/pull/18051)
* [[`711098e88c`](https://github.com/nodejs/node/commit/711098e88c)] - **(SEMVER-MINOR)** **process**: Send signal name to signal handlers (Robert Rossmann) [#15606](https://github.com/nodejs/node/pull/15606)
* [[`2ec981b078`](https://github.com/nodejs/node/commit/2ec981b078)] - **process**: use more direct sync I/O for stdio (Anna Henningsen) [#18019](https://github.com/nodejs/node/pull/18019)
* [[`a6fca750be`](https://github.com/nodejs/node/commit/a6fca750be)] - **repl**: better handling of recoverable errors (Prince J Wesley) [#18915](https://github.com/nodejs/node/pull/18915)
* [[`66343c546c`](https://github.com/nodejs/node/commit/66343c546c)] - **(SEMVER-MINOR)** **src**: add environment cleanup hooks (Anna Henningsen) [#19377](https://github.com/nodejs/node/pull/19377)
* [[`f33f3238f9`](https://github.com/nodejs/node/commit/f33f3238f9)] - **src**: #include \<stdio.h\>" to iculslocs (Steven R. Loomis) [#19150](https://github.com/nodejs/node/pull/19150)
* [[`02ea033e05`](https://github.com/nodejs/node/commit/02ea033e05)] - **src**: fix error message in async\_hooks constructor (Daniel Bevenius) [#19000](https://github.com/nodejs/node/pull/19000)
* [[`d478bc7375`](https://github.com/nodejs/node/commit/d478bc7375)] - **src**: fix bootstrap\_node on bsd (sylkat) [#22663](https://github.com/nodejs/node/pull/22663)
* [[`cbe92390c1`](https://github.com/nodejs/node/commit/cbe92390c1)] - **src**: use `DoTryWrite()` for not-all-Buffer writev()s too (Anna Henningsen) [#18019](https://github.com/nodejs/node/pull/18019)
* [[`69efa9f6b3`](https://github.com/nodejs/node/commit/69efa9f6b3)] - **src**: remove node namespace qualifiers (Daniel Bevenius) [#18962](https://github.com/nodejs/node/pull/18962)
* [[`8af6b75e10`](https://github.com/nodejs/node/commit/8af6b75e10)] - **(SEMVER-MINOR)** **src**: add public API for managing NodePlatform (Cheng Zhao) [#16981](https://github.com/nodejs/node/pull/16981)
* [[`e194c3782b`](https://github.com/nodejs/node/commit/e194c3782b)] - **src**: fix deprecation warning in node\_perf.cc (Daniel Bevenius) [#18877](https://github.com/nodejs/node/pull/18877)
* [[`161869ece0`](https://github.com/nodejs/node/commit/161869ece0)] - **(SEMVER-MINOR)** **src**: allow --perf-(basic-)?prof in NODE\_OPTIONS (Leko) [#17600](https://github.com/nodejs/node/pull/17600)
* [[`eaf99d9393`](https://github.com/nodejs/node/commit/eaf99d9393)] - **src**: add node\_encoding.cc (James M Snell) [#21112](https://github.com/nodejs/node/pull/21112)
* [[`0321afed4c`](https://github.com/nodejs/node/commit/0321afed4c)] - **src**: add node\_process.cc (James M Snell) [#21105](https://github.com/nodejs/node/pull/21105)
* [[`54ea1ccf2d`](https://github.com/nodejs/node/commit/54ea1ccf2d)] - **src**: refactor bootstrap to use bootstrap object (James M Snell) [#20917](https://github.com/nodejs/node/pull/20917)
* [[`6f545d1902`](https://github.com/nodejs/node/commit/6f545d1902)] - **src**: fix compiler warning in process.ppid (cjihrig) [#16958](https://github.com/nodejs/node/pull/16958)
* [[`9125e2b6fa`](https://github.com/nodejs/node/commit/9125e2b6fa)] - **src**: add convenience ctor for async trigger id scope (Anna Henningsen) [#19204](https://github.com/nodejs/node/pull/19204)
* [[`2ee4bb7826`](https://github.com/nodejs/node/commit/2ee4bb7826)] - **src**: move `Environment` ctor/dtor into env.cc (Anna Henningsen) [#19202](https://github.com/nodejs/node/pull/19202)
* [[`342dbff852`](https://github.com/nodejs/node/commit/342dbff852)] - **src**: make `AsyncResource` destructor virtual (Anna Henningsen) [#20633](https://github.com/nodejs/node/pull/20633)
* [[`b916620bf5`](https://github.com/nodejs/node/commit/b916620bf5)] - **src**: fix typo in util.h comment (Anna Henningsen) [#20656](https://github.com/nodejs/node/pull/20656)
* [[`8076a793ed`](https://github.com/nodejs/node/commit/8076a793ed)] - **src**: fix nullptr dereference for signal during startup (Anna Henningsen) [#20637](https://github.com/nodejs/node/pull/20637)
* [[`1cb9772a40`](https://github.com/nodejs/node/commit/1cb9772a40)] - **src**: remove unused freelist.h header (Anna Henningsen) [#20544](https://github.com/nodejs/node/pull/20544)
* [[`e17f05a817`](https://github.com/nodejs/node/commit/e17f05a817)] - **src**: create per-isolate strings after platform setup (Ulan Degenbaev) [#20175](https://github.com/nodejs/node/pull/20175)
* [[`d38ccbb07f`](https://github.com/nodejs/node/commit/d38ccbb07f)] - **src**: use `unordered\_map` for perf marks (Anna Henningsen) [#19558](https://github.com/nodejs/node/pull/19558)
* [[`553e34ef9c`](https://github.com/nodejs/node/commit/553e34ef9c)] - **src**: simplify http2 perf tracking code (Anna Henningsen) [#19470](https://github.com/nodejs/node/pull/19470)
* [[`67182912d7`](https://github.com/nodejs/node/commit/67182912d7)] - **src**: add "icu::" prefix before ICU symbols (Steven R. Loomis)
* [[`2cf263519a`](https://github.com/nodejs/node/commit/2cf263519a)] - **src**: use unique\_ptr for scheduled delayed tasks (Franziska Hinkelmann) [#17083](https://github.com/nodejs/node/pull/17083)
* [[`2148b1921e`](https://github.com/nodejs/node/commit/2148b1921e)] - **src**: use unique\_ptr in platform implementation (Franziska Hinkelmann) [#16970](https://github.com/nodejs/node/pull/16970)
* [[`e9327541e1`](https://github.com/nodejs/node/commit/e9327541e1)] - **src**: cancel pending delayed platform tasks on exit (Anna Henningsen) [#16700](https://github.com/nodejs/node/pull/16700)
* [[`bf8068e6f9`](https://github.com/nodejs/node/commit/bf8068e6f9)] - **src**: prepare v8 platform for multi-isolate support (Anna Henningsen) [#16700](https://github.com/nodejs/node/pull/16700)
* [[`59f13304e1`](https://github.com/nodejs/node/commit/59f13304e1)] - **src**: refactor callback #defines into C++ templates (Anna Henningsen) [#18133](https://github.com/nodejs/node/pull/18133)
* [[`a8d2ab50fc`](https://github.com/nodejs/node/commit/a8d2ab50fc)] - **src**: rename `On\*` -\> `Emit\*` for stream callbacks (Anna Henningsen) [#17701](https://github.com/nodejs/node/pull/17701)
* [[`15c4717e0a`](https://github.com/nodejs/node/commit/15c4717e0a)] - **src**: harden JSStream callbacks (Anna Henningsen) [#18028](https://github.com/nodejs/node/pull/18028)
* [[`5ea1492b74`](https://github.com/nodejs/node/commit/5ea1492b74)] - **src**: fix code coverage cleanup (Michael Dawson) [#18081](https://github.com/nodejs/node/pull/18081)
* [[`0d2a720c70`](https://github.com/nodejs/node/commit/0d2a720c70)] - **src**: update make for new code coverage locations (Michael Dawson) [#17987](https://github.com/nodejs/node/pull/17987)
* [[`2c6f482ba2`](https://github.com/nodejs/node/commit/2c6f482ba2)] - **src**: remove duplicate words in comments (Tobias Nießen) [#17939](https://github.com/nodejs/node/pull/17939)
* [[`7fa97d4f09`](https://github.com/nodejs/node/commit/7fa97d4f09)] - **src**: make FSEventWrap/StatWatcher::Start more robust (Timothy Gu) [#17432](https://github.com/nodejs/node/pull/17432)
* [[`c39b0020b5`](https://github.com/nodejs/node/commit/c39b0020b5)] - **src**: expose uv.errmap to binding (Joyee Cheung) [#17338](https://github.com/nodejs/node/pull/17338)
* [[`75b456d0b8`](https://github.com/nodejs/node/commit/75b456d0b8)] - **src**: do not redefine private for GenDebugSymbols (Joyee Cheung) [#18653](https://github.com/nodejs/node/pull/18653)
* [[`7cf26e5813`](https://github.com/nodejs/node/commit/7cf26e5813)] - **src**: remove superfluous check in backtrace\_posix.cc (Anna Henningsen) [#16950](https://github.com/nodejs/node/pull/16950)
* [[`0564454b75`](https://github.com/nodejs/node/commit/0564454b75)] - **(SEMVER-MINOR)** **src, test**: node internals' postmortem metadata (Matheus Marchini) [#14901](https://github.com/nodejs/node/pull/14901)
* [[`c92d66a749`](https://github.com/nodejs/node/commit/c92d66a749)] - **stream**: delete redundant code (陈刚) [#18145](https://github.com/nodejs/node/pull/18145)
* [[`af27768df4`](https://github.com/nodejs/node/commit/af27768df4)] - **stream**: delete redundant code (陈刚) [#18145](https://github.com/nodejs/node/pull/18145)
* [[`9c781f041d`](https://github.com/nodejs/node/commit/9c781f041d)] - **test**: fix test-abort-backtrace in shared lib build (Yihong Wang) [#19213](https://github.com/nodejs/node/pull/19213)
* [[`a0fd0b69eb`](https://github.com/nodejs/node/commit/a0fd0b69eb)] - **test**: Remove unnecessary asserion messages in test-crypto-hash.js (Piotr Grzesik) [#18984](https://github.com/nodejs/node/pull/18984)
* [[`e6131c2687`](https://github.com/nodejs/node/commit/e6131c2687)] - **test**: do not check text for engine-generated error (Rich Trott) [#19215](https://github.com/nodejs/node/pull/19215)
* [[`8adb0b37bd`](https://github.com/nodejs/node/commit/8adb0b37bd)] - **test**: address unreliable test-performance (Rich Trott) [#19228](https://github.com/nodejs/node/pull/19228)
* [[`e1e6a0965e`](https://github.com/nodejs/node/commit/e1e6a0965e)] - **test**: refactor http-https-default-ports (Ken Lin) [#19130](https://github.com/nodejs/node/pull/19130)
* [[`d3a10c70f1`](https://github.com/nodejs/node/commit/d3a10c70f1)] - **test**: skip postmortem metadata test when nm fails (Joyee Cheung) [#19107](https://github.com/nodejs/node/pull/19107)
* [[`f64100a7df`](https://github.com/nodejs/node/commit/f64100a7df)] - **test**: add more information to assert.strictEqual (Ujjwal Sharma) [#19162](https://github.com/nodejs/node/pull/19162)
* [[`21be1279dd`](https://github.com/nodejs/node/commit/21be1279dd)] - **test**: move require http2 to after crypto check (Daniel Bevenius) [#19111](https://github.com/nodejs/node/pull/19111)
* [[`61dd5b73b5`](https://github.com/nodejs/node/commit/61dd5b73b5)] - **test**: specify 'dir' for directory symlinks (Kyle Farnung) [#19049](https://github.com/nodejs/node/pull/19049)
* [[`85aa639440`](https://github.com/nodejs/node/commit/85aa639440)] - **test**: refactor test after review (Andrew Johnston) [#18999](https://github.com/nodejs/node/pull/18999)
* [[`01e2eba0c7`](https://github.com/nodejs/node/commit/01e2eba0c7)] - **test**: move test-timers-throw-reschedule to sequential (Myles Borins) [#22379](https://github.com/nodejs/node/pull/22379)
* [[`812c950691`](https://github.com/nodejs/node/commit/812c950691)] - **test**: rename test-regress-GH-877.js (Ujjwal Sharma) [#19161](https://github.com/nodejs/node/pull/19161)
* [[`67bdb35e0f`](https://github.com/nodejs/node/commit/67bdb35e0f)] - **test**: rename test-regress-GH-784.js (Ujjwal Sharma) [#19161](https://github.com/nodejs/node/pull/19161)
* [[`37936304e8`](https://github.com/nodejs/node/commit/37936304e8)] - **test**: address nits and rename the corresponding fixture (Ujjwal Sharma) [#19161](https://github.com/nodejs/node/pull/19161)
* [[`d76a96c6ad`](https://github.com/nodejs/node/commit/d76a96c6ad)] - **test**: rename tests to remove "regress" keyword (Ujjwal Sharma) [#19161](https://github.com/nodejs/node/pull/19161)
* [[`b70dd35ba4`](https://github.com/nodejs/node/commit/b70dd35ba4)] - **test**: rename test-regress-GH-4027 (Ujjwal Sharma) [#19161](https://github.com/nodejs/node/pull/19161)
* [[`6092060227`](https://github.com/nodejs/node/commit/6092060227)] - **test**: rename test-regress-GH-4015 (Ujjwal Sharma) [#19161](https://github.com/nodejs/node/pull/19161)
* [[`6417564b29`](https://github.com/nodejs/node/commit/6417564b29)] - **test**: rename test-regress-GH-1697 (Ujjwal Sharma) [#19161](https://github.com/nodejs/node/pull/19161)
* [[`20a4ec88a0`](https://github.com/nodejs/node/commit/20a4ec88a0)] - **test**: rename test-regress-GH-1726 (Ujjwal Sharma) [#19161](https://github.com/nodejs/node/pull/19161)
* [[`d7b657fceb`](https://github.com/nodejs/node/commit/d7b657fceb)] - **test**: refactor test-async-wrap-getasyncid (Santiago Gimeno) [#18727](https://github.com/nodejs/node/pull/18727)
* [[`905c350147`](https://github.com/nodejs/node/commit/905c350147)] - **test**: remove assert message and add block scope (wuweiweiwu) [#19054](https://github.com/nodejs/node/pull/19054)
* [[`7d0f02e48d`](https://github.com/nodejs/node/commit/7d0f02e48d)] - **test**: fix flaky inspector-stop-profile-after-done (Rich Trott) [#18126](https://github.com/nodejs/node/pull/18126)
* [[`4b4383918f`](https://github.com/nodejs/node/commit/4b4383918f)] - **test**: http2 compat response.write() error checks (Trivikram) [#18859](https://github.com/nodejs/node/pull/18859)
* [[`78e79c7f7d`](https://github.com/nodejs/node/commit/78e79c7f7d)] - **test**: fix deprecation warning in binding.cc (Daniel Bevenius) [#18877](https://github.com/nodejs/node/pull/18877)
* [[`2f6866e1d9`](https://github.com/nodejs/node/commit/2f6866e1d9)] - **test**: check symbols in shared lib (Yihong Wang) [#18806](https://github.com/nodejs/node/pull/18806)
* [[`a8ae04d528`](https://github.com/nodejs/node/commit/a8ae04d528)] - **test**: http2 client ping errors (Trivikram) [#18849](https://github.com/nodejs/node/pull/18849)
* [[`901f5799f3`](https://github.com/nodejs/node/commit/901f5799f3)] - **test**: http2 client settings invalid callback (Trivikram) [#18850](https://github.com/nodejs/node/pull/18850)
* [[`cd44b82f52`](https://github.com/nodejs/node/commit/cd44b82f52)] - **test**: http2 client operations after destroy (Trivikram) [#18845](https://github.com/nodejs/node/pull/18845)
* [[`ffa7b50eef`](https://github.com/nodejs/node/commit/ffa7b50eef)] - **test**: refactor parallel/test-tls-pause (juggernaut451) [#18714](https://github.com/nodejs/node/pull/18714)
* [[`83e704d396`](https://github.com/nodejs/node/commit/83e704d396)] - **test**: stdio pipe behavior tests (Bartosz Sosnowski) [#18614](https://github.com/nodejs/node/pull/18614)
* [[`488e1bbe81`](https://github.com/nodejs/node/commit/488e1bbe81)] - **test**: refactor parallel/test-tls-0-dns-altname (juggernaut451) [#18803](https://github.com/nodejs/node/pull/18803)
* [[`35e691cb40`](https://github.com/nodejs/node/commit/35e691cb40)] - **test**: refactor parallel/test-tls-addca (juggernaut451) [#18798](https://github.com/nodejs/node/pull/18798)
* [[`f534bd889a`](https://github.com/nodejs/node/commit/f534bd889a)] - **test**: make tls test more rigorous (Ben Noordhuis) [#18792](https://github.com/nodejs/node/pull/18792)
* [[`ecf3616f51`](https://github.com/nodejs/node/commit/ecf3616f51)] - **test**: reduce benchmark test run time (juggernaut451) [#18787](https://github.com/nodejs/node/pull/18787)
* [[`29009aec96`](https://github.com/nodejs/node/commit/29009aec96)] - **test**: try to connect after server was closed (Leko) [#18257](https://github.com/nodejs/node/pull/18257)
* [[`d0083cbccd`](https://github.com/nodejs/node/commit/d0083cbccd)] - **test**: wrap countdown callback in common.mustCall (Bamieh) [#18506](https://github.com/nodejs/node/pull/18506)
* [[`0977f042e6`](https://github.com/nodejs/node/commit/0977f042e6)] - **test**: add lib path env when node\_shared=true (Yihong Wang) [#18626](https://github.com/nodejs/node/pull/18626)
* [[`11695907e1`](https://github.com/nodejs/node/commit/11695907e1)] - **test**: add multiline repl input regression test (cjihrig) [#18718](https://github.com/nodejs/node/pull/18718)
* [[`0b6ab530c1`](https://github.com/nodejs/node/commit/0b6ab530c1)] - **test**: add crypto check to test-benchmark-tls (Daniel Bevenius) [#18724](https://github.com/nodejs/node/pull/18724)
* [[`6bc307ff32`](https://github.com/nodejs/node/commit/6bc307ff32)] - **test**: add useful info to error msg and refactor (Chin Huang) [#18541](https://github.com/nodejs/node/pull/18541)
* [[`1654b12037`](https://github.com/nodejs/node/commit/1654b12037)] - **test**: fix missing param in benchmark-timers (Anatoli Papirovski) [#18734](https://github.com/nodejs/node/pull/18734)
* [[`bbc7443724`](https://github.com/nodejs/node/commit/bbc7443724)] - **test**: fix and improve error message (Kevin Caulfield) [#18449](https://github.com/nodejs/node/pull/18449)
* [[`4eca50a2a0`](https://github.com/nodejs/node/commit/4eca50a2a0)] - **test**: fix flaky repl-timeout-throw (Santiago Gimeno) [#18692](https://github.com/nodejs/node/pull/18692)
* [[`3cdae1541b`](https://github.com/nodejs/node/commit/3cdae1541b)] - **test**: remove NodeTestFixture from Env constructor (Daniel Bevenius) [#18558](https://github.com/nodejs/node/pull/18558)
* [[`25ce5c3852`](https://github.com/nodejs/node/commit/25ce5c3852)] - **test**: introduce SetUpTestCase/TearDownTestCase (Daniel Bevenius) [#18558](https://github.com/nodejs/node/pull/18558)
* [[`e98efcfa6a`](https://github.com/nodejs/node/commit/e98efcfa6a)] - **test**: replace assert.equal with assert.strictEqual (Sho Miyamoto) [#18119](https://github.com/nodejs/node/pull/18119)
* [[`9a9ea0d756`](https://github.com/nodejs/node/commit/9a9ea0d756)] - **test**: bypass dns for IPv6 net tests (Refael Ackermann) [#16976](https://github.com/nodejs/node/pull/16976)
* [[`d0588f151d`](https://github.com/nodejs/node/commit/d0588f151d)] - **test**: fix flaky http-client-timeout-agent (Santiago Gimeno) [#19856](https://github.com/nodejs/node/pull/19856)
* [[`1e25f00353`](https://github.com/nodejs/node/commit/1e25f00353)] - **test**: move http-client-timeout-agent to sequential (Rich Trott) [#19809](https://github.com/nodejs/node/pull/19809)
* [[`0517cd8504`](https://github.com/nodejs/node/commit/0517cd8504)] - **test**: fix test-cluster-send-handle-large-payload (Rich Trott) [#19311](https://github.com/nodejs/node/pull/19311)
* [[`8053474679`](https://github.com/nodejs/node/commit/8053474679)] - **test**: add http2/tls destroy regression test (Anna Henningsen) [#21598](https://github.com/nodejs/node/pull/21598)
* [[`ed0d939dbc`](https://github.com/nodejs/node/commit/ed0d939dbc)] - **test**: remove --harmony-sharedarraybuffer usage (Ben Smith) [#16343](https://github.com/nodejs/node/pull/16343)
* [[`0f45ecb68c`](https://github.com/nodejs/node/commit/0f45ecb68c)] - **test**: add http \_dump regression test (Anna Henningsen) [#21595](https://github.com/nodejs/node/pull/21595)
* [[`6d3cbcbb13`](https://github.com/nodejs/node/commit/6d3cbcbb13)] - **test**: make test-error-reporting engine agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`b1110b22b4`](https://github.com/nodejs/node/commit/b1110b22b4)] - **test**: fix test when NODE\_OPTIONS env var is set to --trace-warnings (Ashok) [#20027](https://github.com/nodejs/node/pull/20027)
* [[`f0f44f69a6`](https://github.com/nodejs/node/commit/f0f44f69a6)] - **test**: check TTY mode reset on exit (Anna Henningsen) [#21027](https://github.com/nodejs/node/pull/21027)
* [[`71ee19e064`](https://github.com/nodejs/node/commit/71ee19e064)] - **test**: plug AliasedBuffer cctest memory leak (Anna Henningsen) [#20665](https://github.com/nodejs/node/pull/20665)
* [[`3c6464a4f4`](https://github.com/nodejs/node/commit/3c6464a4f4)] - **test**: add regression test for large write (Anna Henningsen) [#19551](https://github.com/nodejs/node/pull/19551)
* [[`21cdb73d67`](https://github.com/nodejs/node/commit/21cdb73d67)] - **test**: allow running with `NODE\_PENDING\_DEPRECATION` (Anna Henningsen) [#18991](https://github.com/nodejs/node/pull/18991)
* [[`ad862a0114`](https://github.com/nodejs/node/commit/ad862a0114)] - **test**: properly tag anonymous namespaces (Michael Dawson) [#18583](https://github.com/nodejs/node/pull/18583)
* [[`1942440696`](https://github.com/nodejs/node/commit/1942440696)] - **test**: refactor test-repl (Anna Henningsen) [#17926](https://github.com/nodejs/node/pull/17926)
* [[`7d263ff708`](https://github.com/nodejs/node/commit/7d263ff708)] - **test**: fix unreliable async-hooks/test-signalwrap (Rich Trott) [#17827](https://github.com/nodejs/node/pull/17827)
* [[`fa6f808c71`](https://github.com/nodejs/node/commit/fa6f808c71)] - **test**: add test for postmortem metadata validation (cjihrig) [#17685](https://github.com/nodejs/node/pull/17685)
* [[`88c4adfdde`](https://github.com/nodejs/node/commit/88c4adfdde)] - **test**: remove test case 0 from tls-cnnic-whitelist (Daniel Bevenius) [#19767](https://github.com/nodejs/node/pull/19767)
* [[`64b4ea47ed`](https://github.com/nodejs/node/commit/64b4ea47ed)] - **test**: set clientOpts.port property (Daniel Bevenius) [#19767](https://github.com/nodejs/node/pull/19767)
* [[`b7564c48dd`](https://github.com/nodejs/node/commit/b7564c48dd)] - **test**: fix cctest -Wunused-variable warning (Ben Noordhuis) [#18530](https://github.com/nodejs/node/pull/18530)
* [[`d55e4adc3d`](https://github.com/nodejs/node/commit/d55e4adc3d)] - **test,benchmark,doc**: enable dot-notation rule (Ruben Bridgewater) [#18749](https://github.com/nodejs/node/pull/18749)
* [[`1f49de4b24`](https://github.com/nodejs/node/commit/1f49de4b24)] - **(SEMVER-MINOR)** **tls**: expose Finished messages in TLSSocket (Anton Salikhmetov) [#19102](https://github.com/nodejs/node/pull/19102)
* [[`1cf17df769`](https://github.com/nodejs/node/commit/1cf17df769)] - **tls**: accept array of protocols in TLSSocket (Mark S. Everitt) [#16655](https://github.com/nodejs/node/pull/16655)
* [[`8292bc3892`](https://github.com/nodejs/node/commit/8292bc3892)] - **tls**: use correct class name in deprecation message (Anna Henningsen) [#17561](https://github.com/nodejs/node/pull/17561)
* [[`c56aafd645`](https://github.com/nodejs/node/commit/c56aafd645)] - **tools**: add log output to crashes (Ruben Bridgewater) [#20295](https://github.com/nodejs/node/pull/20295)
* [[`422b6e8b9f`](https://github.com/nodejs/node/commit/422b6e8b9f)] - **tools**: show stdout/stderr for timed out tests (Rich Trott) [#20260](https://github.com/nodejs/node/pull/20260)
* [[`f8c5042454`](https://github.com/nodejs/node/commit/f8c5042454)] - **tools**: include exit code in TAP log (Refael Ackermann) [#19855](https://github.com/nodejs/node/pull/19855)
* [[`11e53cd323`](https://github.com/nodejs/node/commit/11e53cd323)] - **tools**: include exit code in test failures (Rich Trott) [#19855](https://github.com/nodejs/node/pull/19855)
* [[`246c2d18cb`](https://github.com/nodejs/node/commit/246c2d18cb)] - **tools**: fix TypeError from `test.py --time` (Richard Lau) [#20368](https://github.com/nodejs/node/pull/20368)
* [[`1241b90a13`](https://github.com/nodejs/node/commit/1241b90a13)] - **tools**: simplify HTML generation (Vse Mozhet Byt) [#20307](https://github.com/nodejs/node/pull/20307)
* [[`ac05c2b226`](https://github.com/nodejs/node/commit/ac05c2b226)] - **tools**: modernize and optimize doc/addon-verify.js (Vse Mozhet Byt) [#20188](https://github.com/nodejs/node/pull/20188)
* [[`fc41817f97`](https://github.com/nodejs/node/commit/fc41817f97)] - **tools**: don’t emit illegal utf-8 from icutrim/iculslocs (Steven R. Loomis) [#19756](https://github.com/nodejs/node/pull/19756)
* [[`cf2a7e9ce6`](https://github.com/nodejs/node/commit/cf2a7e9ce6)] - **tools**: apply editorconfig rules to tools also (Tobias Nießen) [#19521](https://github.com/nodejs/node/pull/19521)
* [[`36ffc3b69b`](https://github.com/nodejs/node/commit/36ffc3b69b)] - **tools**: remove src dir from JS editorconfig rule (Tobias Nießen) [#19521](https://github.com/nodejs/node/pull/19521)
* [[`ff4c30e9bb`](https://github.com/nodejs/node/commit/ff4c30e9bb)] - **tools**: dry utility function in tools/doc/json.js (Vse Mozhet Byt) [#19692](https://github.com/nodejs/node/pull/19692)
* [[`59b99e88fb`](https://github.com/nodejs/node/commit/59b99e88fb)] - **tools**: fix comment nits in tools/doc/\*.js files (Vse Mozhet Byt) [#19696](https://github.com/nodejs/node/pull/19696)
* [[`eb5f08546e`](https://github.com/nodejs/node/commit/eb5f08546e)] - **tools**: fix nits in tools/doc/type-parser.js (Vse Mozhet Byt) [#19612](https://github.com/nodejs/node/pull/19612)
* [[`4a1b064cdc`](https://github.com/nodejs/node/commit/4a1b064cdc)] - **tools**: simplify tools/doc/preprocess.js (Vse Mozhet Byt) [#19539](https://github.com/nodejs/node/pull/19539)
* [[`fe4e511ae8`](https://github.com/nodejs/node/commit/fe4e511ae8)] - **tools**: fix nits in tools/doc/common.js (Vse Mozhet Byt) [#19599](https://github.com/nodejs/node/pull/19599)
* [[`11b8d4793f`](https://github.com/nodejs/node/commit/11b8d4793f)] - **tools**: shorten metadata parsing (Tobias Nießen) [#19512](https://github.com/nodejs/node/pull/19512)
* [[`aa3be00b08`](https://github.com/nodejs/node/commit/aa3be00b08)] - **tools**: make metadata parsing less permissive (Tobias Nießen) [#19512](https://github.com/nodejs/node/pull/19512)
* [[`2fb47a5cbf`](https://github.com/nodejs/node/commit/2fb47a5cbf)] - **tools**: fix nits in tools/doc/preprocess.js (Vse Mozhet Byt) [#19473](https://github.com/nodejs/node/pull/19473)
* [[`e1c28b6f46`](https://github.com/nodejs/node/commit/e1c28b6f46)] - **tools**: fix logic nit in tools/doc/generate.js (Vse Mozhet Byt) [#19475](https://github.com/nodejs/node/pull/19475)
* [[`7d4d96b63d`](https://github.com/nodejs/node/commit/7d4d96b63d)] - **tools**: bump remark-cli to 4.0 (Refael Ackermann) [#17028](https://github.com/nodejs/node/pull/17028)
* [[`814021182e`](https://github.com/nodejs/node/commit/814021182e)] - **tools**: fix custom eslint rule errors (Ruben Bridgewater) [#18853](https://github.com/nodejs/node/pull/18853)
* [[`ce62e142b3`](https://github.com/nodejs/node/commit/ce62e142b3)] - **tools**: ignore VS compiler output in deps/v8 (Michaël Zasso) [#18952](https://github.com/nodejs/node/pull/18952)
* [[`817f43637b`](https://github.com/nodejs/node/commit/817f43637b)] - **tools**: custom eslint autofix for inspector-check.js (Shobhit Chittora) [#16646](https://github.com/nodejs/node/pull/16646)
* [[`c32b087161`](https://github.com/nodejs/node/commit/c32b087161)] - **tools**: auto fix custom crypto-check eslint rule (Shobhit Chittora) [#16647](https://github.com/nodejs/node/pull/16647)
* [[`7f1a9421c0`](https://github.com/nodejs/node/commit/7f1a9421c0)] - **tools**: fix eslint isRequired (Ruben Bridgewater) [#18729](https://github.com/nodejs/node/pull/18729)
* [[`bf09b7a155`](https://github.com/nodejs/node/commit/bf09b7a155)] - **tools**: treat SIGABRT as crash (Anna Henningsen) [#19990](https://github.com/nodejs/node/pull/19990)
* [[`79919a3a9a`](https://github.com/nodejs/node/commit/79919a3a9a)] - **tools**: ensure doc-only doesn't update package-lock (Myles Borins) [#21015](https://github.com/nodejs/node/pull/21015)
* [[`c5eb1f83d0`](https://github.com/nodejs/node/commit/c5eb1f83d0)] - **tools**: update tooling to work with new macOS CLI … (Rich Trott) [#21173](https://github.com/nodejs/node/pull/21173)
* [[`5362e2fbb3`](https://github.com/nodejs/node/commit/5362e2fbb3)] - **tools**: fix test-npm-package (Michaël Zasso) [#19293](https://github.com/nodejs/node/pull/19293)
* [[`ab967b725e`](https://github.com/nodejs/node/commit/ab967b725e)] - **tools**: fix icu readme lint error (Anatoli Papirovski) [#18445](https://github.com/nodejs/node/pull/18445)
* [[`f2506d46b5`](https://github.com/nodejs/node/commit/f2506d46b5)] - **tools**: don't lint-md as part of main lint target (Refael Ackermann) [#17587](https://github.com/nodejs/node/pull/17587)
* [[`3857e108ca`](https://github.com/nodejs/node/commit/3857e108ca)] - **tools**: speed up lint-md-build (Refael Ackermann) [#16945](https://github.com/nodejs/node/pull/16945)
* [[`c4716dc711`](https://github.com/nodejs/node/commit/c4716dc711)] - **tools, test**: fix prof polyfill readline (killagu) [#18641](https://github.com/nodejs/node/pull/18641)
* [[`4df93dc8ac`](https://github.com/nodejs/node/commit/4df93dc8ac)] - **tools,bootstrap**: preprocess gypi files to json (Gus Caplan) [#19140](https://github.com/nodejs/node/pull/19140)
* [[`7a35e18177`](https://github.com/nodejs/node/commit/7a35e18177)] - **tools,gyp**: fix regex for version matching (Rich Trott) [#21216](https://github.com/nodejs/node/pull/21216)
* [[`e602726c68`](https://github.com/nodejs/node/commit/e602726c68)] - **(SEMVER-MINOR)** **trace_events**: add file pattern cli option (Andreas Madsen) [#18480](https://github.com/nodejs/node/pull/18480)
* [[`9fdba04e5e`](https://github.com/nodejs/node/commit/9fdba04e5e)] - **tty**: fix console printing on Windows (Anna Henningsen) [#18214](https://github.com/nodejs/node/pull/18214)
* [[`40a36b3af8`](https://github.com/nodejs/node/commit/40a36b3af8)] - **url**: added url fragment lookup table (Hakan Kimeiga) [#17627](https://github.com/nodejs/node/pull/17627)
* [[`654ce4ba17`](https://github.com/nodejs/node/commit/654ce4ba17)] - **url**: added space to class string of iterator objects (Haejin Jo) [#17558](https://github.com/nodejs/node/pull/17558)
* [[`66520afdb8`](https://github.com/nodejs/node/commit/66520afdb8)] - **util**: skip type checks in internal getSystemErrorName (Joyee Cheung) [#18546](https://github.com/nodejs/node/pull/18546)
* [[`58b5a610d8`](https://github.com/nodejs/node/commit/58b5a610d8)] - **(SEMVER-MINOR)** **util**: implement util.getSystemErrorName() (Joyee Cheung) [#18186](https://github.com/nodejs/node/pull/18186)
* [[`ec1828c2b6`](https://github.com/nodejs/node/commit/ec1828c2b6)] - **(SEMVER-MAJOR)** **v8**: add new to the throw statement (Ruben Bridgewater) [#13857](https://github.com/nodejs/node/pull/13857)
* [[`8a5c100793`](https://github.com/nodejs/node/commit/8a5c100793)] - **win, tools**: add nasm to boxstarter script (Bartosz Sosnowski) [#19950](https://github.com/nodejs/node/pull/19950)

<a id="8.11.4"></a>
## 2018-08-15, Version 8.11.4 'Carbon' (LTS), @rvagg

This is a security release. All Node.js users should consult the security release summary at:

  https://nodejs.org/en/blog/vulnerability/august-2018-security-releases/

for details on patched vulnerabilities.

Fixes for the following CVEs are included in this release:

  * CVE-2018-0732 (OpenSSL)
  * CVE-2018-12115 (Node.js)

### Notable Changes

* **buffer**: Fix out-of-bounds (OOB) write in `Buffer.write()` for UCS-2 encoding (CVE-2018-12115)
* **deps**: Upgrade to OpenSSL 1.0.2p, fixing:
  * Client DoS due to large DH parameter (CVE-2018-0732)
  * ECDSA key extraction via local side-channel (CVE not assigned)

### Commits

* [[`fc14d812b7`](https://github.com/nodejs/node/commit/fc14d812b7)] - **buffer**: avoid overrun on UCS-2 string write (Rod Vagg) [nodejs-private/node-private#138](https://github.com/nodejs-private/node-private/pull/138)
* [[`8f59838ae7`](https://github.com/nodejs/node/commit/8f59838ae7)] - **deps**: add -no\_rand\_screen to openssl s\_client (Shigeki Ohtsu) [#1836](https://github.com/nodejs/node/pull/1836)
* [[`97607f8622`](https://github.com/nodejs/node/commit/97607f8622)] - **deps**: fix asm build error of openssl in x86\_win32 (Shigeki Ohtsu) [#1389](https://github.com/nodejs/node/pull/1389)
* [[`46e4917d98`](https://github.com/nodejs/node/commit/46e4917d98)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [#1389](https://github.com/nodejs/node/pull/1389)
* [[`1b93677a81`](https://github.com/nodejs/node/commit/1b93677a81)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#22320](https://github.com/nodejs/node/pull/22320)
* [[`ebf399473b`](https://github.com/nodejs/node/commit/ebf399473b)] - **deps**: upgrade openssl sources to 1.0.2p (Shigeki Ohtsu) [#22320](https://github.com/nodejs/node/pull/22320)
* [[`131c5ed438`](https://github.com/nodejs/node/commit/131c5ed438)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [#1389](https://github.com/nodejs/node/pull/1389)
* [[`3139897ff5`](https://github.com/nodejs/node/commit/3139897ff5)] - **test**: fix error messages for OpenSSL-1.0.2p (Shigeki Ohtsu) [#22320](https://github.com/nodejs/node/pull/22320)
* [[`0c047c4d9a`](https://github.com/nodejs/node/commit/0c047c4d9a)] - **test**: update certificates and private keys (Fedor Indutny) [#22184](https://github.com/nodejs/node/pull/22184)
* [[`7c6d0f604b`](https://github.com/nodejs/node/commit/7c6d0f604b)] - **test**: update keys/Makefile to clean and build all (Daniel Bevenius) [#19975](https://github.com/nodejs/node/pull/19975)

<a id="8.11.3"></a>
## 2018-06-12, Version 8.11.3 'Carbon' (LTS), @evanlucas

### Notable Changes

* **buffer** (CVE-2018-7167): Fixes Denial of Service vulnerability where calling Buffer.fill() could hang
* **http2**
  * (CVE-2018-7161): Fixes Denial of Service vulnerability by updating the http2 implementation to not crash under certain circumstances during cleanup
  * (CVE-2018-1000168): Fixes Denial of Service vulnerability by upgrading nghttp2 to 1.32.0

### Commits

* [[`e1ff7c3cbc`](https://github.com/nodejs/node/commit/e1ff7c3cbc)] - **deps**: update to nghttp2 1.32.0 (James M Snell) [nodejs-private/node-private#125](https://github.com/nodejs-private/node-private/pull/125)
* [[`c5a2748d8f`](https://github.com/nodejs/node/commit/c5a2748d8f)] - **doc**: buffer.fill() can zero-fill on invalid input (Сковорода Никита Андреевич) [nodejs-private/node-private#119](https://github.com/nodejs-private/node-private/pull/119)
* [[`354f2d97ff`](https://github.com/nodejs/node/commit/354f2d97ff)] - **http2**: fixup http2stream cleanup and other nits (James M Snell) [nodejs-private/node-private#123](https://github.com/nodejs-private/node-private/pull/123)
* [[`25c5111ca4`](https://github.com/nodejs/node/commit/25c5111ca4)] - **src**: avoid hanging on Buffer#fill 0-length input (Сковорода Никита Андреевич) [nodejs-private/node-private#119](https://github.com/nodejs-private/node-private/pull/119)
* [[`10c5adf19b`](https://github.com/nodejs/node/commit/10c5adf19b)] - **test**: add `Realloc()` shrink after reading stream data test (Anna Henningsen) [nodejs-private/node-private#132](https://github.com/nodejs-private/node-private/pull/132)
* [[`bc91220ca2`](https://github.com/nodejs/node/commit/bc91220ca2)] - **test**: add tls write error regression test (Shigeki Ohtsu) [nodejs-private/node-private#131](https://github.com/nodejs-private/node-private/pull/131)
* [[`acd11b01c4`](https://github.com/nodejs/node/commit/acd11b01c4)] - **test**: add regression test for nghttp2 CVE-2018-1000168 (James M Snell) [nodejs-private/node-private#125](https://github.com/nodejs-private/node-private/pull/125)

<a id="8.11.2"></a>
## 2018-05-15, Version 8.11.2 'Carbon' (LTS), @MylesBorins

### Notable Changes

* **deps**:
  - update node-inspect to 1.11.3 (Jan Krems) [#18354](https://github.com/nodejs/node/pull/18354)
  - update nghttp2 to 1.29.0 (James M Snell) [#17908](https://github.com/nodejs/node/pull/17908)
* **http2**:
  - Sync with current release stream
* **n-api**:
  - Sync with current release stream

### Commits

* [[`ce3866bdcc`](https://github.com/nodejs/node/commit/ce3866bdcc)] - **async_hooks**: clean up comments (Ali Ijaz Sheikh) [#18467](https://github.com/nodejs/node/pull/18467)
* [[`86e3c89ea4`](https://github.com/nodejs/node/commit/86e3c89ea4)] - **benchmark**: improve compare output (Ruben Bridgewater) [#18597](https://github.com/nodejs/node/pull/18597)
* [[`18be476116`](https://github.com/nodejs/node/commit/18be476116)] - **benchmark**: fix punycode test for --without-intl (Timothy Gu) [#16251](https://github.com/nodejs/node/pull/16251)
* [[`88d3028e22`](https://github.com/nodejs/node/commit/88d3028e22)] - **build**: no longer have v8-debug.h as dependency. (Yang Guo) [#18677](https://github.com/nodejs/node/pull/18677)
* [[`7b6d93c145`](https://github.com/nodejs/node/commit/7b6d93c145)] - **build**: add doc linting when runnning `make lint` (Camilo Gonzalez) [#18472](https://github.com/nodejs/node/pull/18472)
* [[`9bce14172a`](https://github.com/nodejs/node/commit/9bce14172a)] - **build**: do not suppress output in make doc-only (Joyee Cheung) [#18507](https://github.com/nodejs/node/pull/18507)
* [[`333d7dda84`](https://github.com/nodejs/node/commit/333d7dda84)] - **build**: make lint-js independent of local node (Joyee Cheung) [#18272](https://github.com/nodejs/node/pull/18272)
* [[`d537f45aaa`](https://github.com/nodejs/node/commit/d537f45aaa)] - **build**: make lint-md independent of local node (Joyee Cheung) [#18272](https://github.com/nodejs/node/pull/18272)
* [[`658dd409fd`](https://github.com/nodejs/node/commit/658dd409fd)] - **build**: refine static and shared lib build (Yihong Wang) [#17604](https://github.com/nodejs/node/pull/17604)
* [[`659b2a1821`](https://github.com/nodejs/node/commit/659b2a1821)] - **build**: allow x86\_64 as a dest\_cpu alias for x64 (Rod Vagg) [#18052](https://github.com/nodejs/node/pull/18052)
* [[`424703a556`](https://github.com/nodejs/node/commit/424703a556)] - **build**: add cflags for OpenBSD, remove stray comma. (Aaron Bieber) [#18448](https://github.com/nodejs/node/pull/18448)
* [[`ab4809f195`](https://github.com/nodejs/node/commit/ab4809f195)] - **build,win**: restore vcbuild TAG functionality (Rod Vagg) [#18031](https://github.com/nodejs/node/pull/18031)
* [[`bf4d0743be`](https://github.com/nodejs/node/commit/bf4d0743be)] - **cluster**: fix inspector port assignment (Santiago Gimeno) [#18696](https://github.com/nodejs/node/pull/18696)
* [[`16bf5fed69`](https://github.com/nodejs/node/commit/16bf5fed69)] - **crypto**: reuse variable instead of reevaluation (Tobias Nießen) [#17735](https://github.com/nodejs/node/pull/17735)
* [[`9acc7f3fbb`](https://github.com/nodejs/node/commit/9acc7f3fbb)] - **deps**: update nghttp2 to 1.29.0 (James M Snell) [#17908](https://github.com/nodejs/node/pull/17908)
* [[`ab005592be`](https://github.com/nodejs/node/commit/ab005592be)] - **deps**: V8: backport 76c3ac5 from upstream (Ali Ijaz Sheikh) [#18298](https://github.com/nodejs/node/pull/18298)
* [[`f12db24947`](https://github.com/nodejs/node/commit/f12db24947)] - **deps**: cherry-pick a803fad from upstream V8 (Michaël Zasso) [#19824](https://github.com/nodejs/node/pull/19824)
* [[`09f5e252bf`](https://github.com/nodejs/node/commit/09f5e252bf)] - **deps**: cherry-pick 7abdadc from upstream V8 (Michaël Zasso) [#19824](https://github.com/nodejs/node/pull/19824)
* [[`c97237bc10`](https://github.com/nodejs/node/commit/c97237bc10)] - **deps**: cherry-pick a4bddba from upstream V8 (Michaël Zasso) [#19824](https://github.com/nodejs/node/pull/19824)
* [[`d02b72e799`](https://github.com/nodejs/node/commit/d02b72e799)] - **deps**: V8: backport 596d55a from upstream (Myles Borins) [#19477](https://github.com/nodejs/node/pull/19477)
* [[`79a7a17312`](https://github.com/nodejs/node/commit/79a7a17312)] - **deps**: update node-inspect to 1.11.3 (Jan Krems) [#18354](https://github.com/nodejs/node/pull/18354)
* [[`5394bc5c42`](https://github.com/nodejs/node/commit/5394bc5c42)] - **deps,src**: align ssize\_t ABI between Node & nghttp2 (Anna Henningsen) [#18565](https://github.com/nodejs/node/pull/18565)
* [[`165d214a54`](https://github.com/nodejs/node/commit/165d214a54)] - **doc**: add Http2Session.connecting property (Pieter Mees) [#19842](https://github.com/nodejs/node/pull/19842)
* [[`1ff3544a4b`](https://github.com/nodejs/node/commit/1ff3544a4b)] - **doc**: guard against md list parsing edge case (Vse Mozhet Byt) [#19647](https://github.com/nodejs/node/pull/19647)
* [[`f59eab0165`](https://github.com/nodejs/node/commit/f59eab0165)] - **doc**: rename HTTP2 to HTTP/2 (Timothy Gu) [#19603](https://github.com/nodejs/node/pull/19603)
* [[`da185cec8f`](https://github.com/nodejs/node/commit/da185cec8f)] - **doc**: add note about browsers and HTTP/2 (Steven) [#19476](https://github.com/nodejs/node/pull/19476)
* [[`30070c7568`](https://github.com/nodejs/node/commit/30070c7568)] - **doc**: warn against concurrent http2stream.respondWithFD (Anna Henningsen) [#18762](https://github.com/nodejs/node/pull/18762)
* [[`39267e8bb0`](https://github.com/nodejs/node/commit/39267e8bb0)] - **doc**: fix typo in http2.md (Vse Mozhet Byt) [#18602](https://github.com/nodejs/node/pull/18602)
* [[`2da965c5b8`](https://github.com/nodejs/node/commit/2da965c5b8)] - **doc**: remove removed apis from http2 docs (Kelvin Jin) [#18439](https://github.com/nodejs/node/pull/18439)
* [[`9a4a8c127e`](https://github.com/nodejs/node/commit/9a4a8c127e)] - **doc**: unify type linkification (Vse Mozhet Byt) [#18407](https://github.com/nodejs/node/pull/18407)
* [[`15023c7d28`](https://github.com/nodejs/node/commit/15023c7d28)] - **doc**: fix documentation of http2Stream.pushstream() (Peter Dalgaard-Jensen) [#18258](https://github.com/nodejs/node/pull/18258)
* [[`fac76f9a6b`](https://github.com/nodejs/node/commit/fac76f9a6b)] - **doc**: fix typo in http2stream.close param default (Moritz Peters) [#18166](https://github.com/nodejs/node/pull/18166)
* [[`88babd5a23`](https://github.com/nodejs/node/commit/88babd5a23)] - **doc**: fix s/rstStream/close in example (James M Snell) [#18088](https://github.com/nodejs/node/pull/18088)
* [[`d9d0d0e98e`](https://github.com/nodejs/node/commit/d9d0d0e98e)] - **doc**: update pushStream docs to use err first (James M Snell) [#18088](https://github.com/nodejs/node/pull/18088)
* [[`940457394a`](https://github.com/nodejs/node/commit/940457394a)] - **doc**: compact eslint directives in common/README (Vse Mozhet Byt) [#17971](https://github.com/nodejs/node/pull/17971)
* [[`e9de5a976b`](https://github.com/nodejs/node/commit/e9de5a976b)] - **doc**: re-alphabetise sections in common/README.md (Vse Mozhet Byt) [#17971](https://github.com/nodejs/node/pull/17971)
* [[`c924adf33d`](https://github.com/nodejs/node/commit/c924adf33d)] - **doc**: fix code nits in common/README (Vse Mozhet Byt) [#17971](https://github.com/nodejs/node/pull/17971)
* [[`0205b3f0c1`](https://github.com/nodejs/node/commit/0205b3f0c1)] - **doc**: correct spelling (sreepurnajasti) [#17911](https://github.com/nodejs/node/pull/17911)
* [[`591f78bb0a`](https://github.com/nodejs/node/commit/591f78bb0a)] - **doc**: grammar fixes in http2.md (Rich Trott) [#17972](https://github.com/nodejs/node/pull/17972)
* [[`35ee8943da`](https://github.com/nodejs/node/commit/35ee8943da)] - **doc**: add docs for common/http2.js utility (James M Snell) [#17942](https://github.com/nodejs/node/pull/17942)
* [[`f0ba2c6ceb`](https://github.com/nodejs/node/commit/f0ba2c6ceb)] - **doc**: Add a missing comma (jiangq) [#19555](https://github.com/nodejs/node/pull/19555)
* [[`7c6fa183cb`](https://github.com/nodejs/node/commit/7c6fa183cb)] - **doc**: fix typos on n-api (Kyle Robinson Young) [#19385](https://github.com/nodejs/node/pull/19385)
* [[`1abb168838`](https://github.com/nodejs/node/commit/1abb168838)] - **doc**: fix n-api asynchronous threading docs (Eric Bickle) [#19073](https://github.com/nodejs/node/pull/19073)
* [[`87d0fd8212`](https://github.com/nodejs/node/commit/87d0fd8212)] - **doc**: mark NAPI\_AUTO\_LENGTH as code (Tobias Nießen) [#18697](https://github.com/nodejs/node/pull/18697)
* [[`58688d97dc`](https://github.com/nodejs/node/commit/58688d97dc)] - **doc**: fix exporting a function example (Aonghus O Nia) [#18661](https://github.com/nodejs/node/pull/18661)
* [[`4d43607474`](https://github.com/nodejs/node/commit/4d43607474)] - **doc**: fix typo in n-api.md (Vse Mozhet Byt) [#18590](https://github.com/nodejs/node/pull/18590)
* [[`9729278007`](https://github.com/nodejs/node/commit/9729278007)] - **doc**: small typo in n-api.md (iskore) [#18555](https://github.com/nodejs/node/pull/18555)
* [[`7ed1dfef28`](https://github.com/nodejs/node/commit/7ed1dfef28)] - **doc**: remove usage of you in n-api doc (Michael Dawson) [#18528](https://github.com/nodejs/node/pull/18528)
* [[`84e0a03727`](https://github.com/nodejs/node/commit/84e0a03727)] - **doc**: remove uannecessary Require (Michael Dawson) [#18184](https://github.com/nodejs/node/pull/18184)
* [[`51513fdf9e`](https://github.com/nodejs/node/commit/51513fdf9e)] - **doc**: napi: make header style consistent (Ali Ijaz Sheikh) [#18122](https://github.com/nodejs/node/pull/18122)
* [[`02ae3295d5`](https://github.com/nodejs/node/commit/02ae3295d5)] - **doc**: napi: fix unbalanced emphasis (Ali Ijaz Sheikh) [#18122](https://github.com/nodejs/node/pull/18122)
* [[`79ecc2c586`](https://github.com/nodejs/node/commit/79ecc2c586)] - **doc**: updates examples to use NULL (Michael Dawson) [#18008](https://github.com/nodejs/node/pull/18008)
* [[`b2213798a3`](https://github.com/nodejs/node/commit/b2213798a3)] - **doc**: fix MDN links to avoid redirections (Vse Mozhet Byt) [#18631](https://github.com/nodejs/node/pull/18631)
* [[`f4ddaaec0e`](https://github.com/nodejs/node/commit/f4ddaaec0e)] - **doc**: move Fedor to TSC Emeritus (Myles Borins) [#18752](https://github.com/nodejs/node/pull/18752)
* [[`b8f2acd2e8`](https://github.com/nodejs/node/commit/b8f2acd2e8)] - **doc**: add mmarchini to collaborators (Matheus Marchini) [#18740](https://github.com/nodejs/node/pull/18740)
* [[`16f9631475`](https://github.com/nodejs/node/commit/16f9631475)] - **doc**: add history for url.parse (Steven) [#18685](https://github.com/nodejs/node/pull/18685)
* [[`d30c3533ff`](https://github.com/nodejs/node/commit/d30c3533ff)] - **doc**: fix links to Style Guide and CPP Style Guide (Justin Lee) [#18683](https://github.com/nodejs/node/pull/18683)
* [[`176ed1e9b1`](https://github.com/nodejs/node/commit/176ed1e9b1)] - **doc**: add devsnek to collaborators (Gus Caplan) [#18679](https://github.com/nodejs/node/pull/18679)
* [[`25db460f03`](https://github.com/nodejs/node/commit/25db460f03)] - **doc**: expand on promises and async\_hooks (Ali Ijaz Sheikh) [#18540](https://github.com/nodejs/node/pull/18540)
* [[`73adadd56a`](https://github.com/nodejs/node/commit/73adadd56a)] - **doc**: add section for strategic initiatives (Michael Dawson) [#17104](https://github.com/nodejs/node/pull/17104)
* [[`8ca6d34801`](https://github.com/nodejs/node/commit/8ca6d34801)] - **doc**: add introduce about cli options (Weijia Wang) [#18475](https://github.com/nodejs/node/pull/18475)
* [[`1ea1970c37`](https://github.com/nodejs/node/commit/1ea1970c37)] - **doc**: modify the return value of request.write() (陈刚) [#18526](https://github.com/nodejs/node/pull/18526)
* [[`50bdf0ed78`](https://github.com/nodejs/node/commit/50bdf0ed78)] - **doc**: be more explicit in the sypnosis (Tim O. Peters) [#17977](https://github.com/nodejs/node/pull/17977)
* [[`f8ad381e61`](https://github.com/nodejs/node/commit/f8ad381e61)] - **doc**: add missing meta for createCipheriv (Tobias Nießen) [#18651](https://github.com/nodejs/node/pull/18651)
* [[`0071560eb4`](https://github.com/nodejs/node/commit/0071560eb4)] - **doc**: fix description of createDecipheriv (Tobias Nießen) [#18651](https://github.com/nodejs/node/pull/18651)
* [[`c89781583b`](https://github.com/nodejs/node/commit/c89781583b)] - **doc**: fix various nits (Vse Mozhet Byt) [#19743](https://github.com/nodejs/node/pull/19743)
* [[`1091dfc801`](https://github.com/nodejs/node/commit/1091dfc801)] - **doc**: linkify missing types (Vse Mozhet Byt) [#18444](https://github.com/nodejs/node/pull/18444)
* [[`1107a494e4`](https://github.com/nodejs/node/commit/1107a494e4)] - **doc**: shell option for the execFile and execFileSync functions (jvelezpo) [#18237](https://github.com/nodejs/node/pull/18237)
* [[`36ea472393`](https://github.com/nodejs/node/commit/36ea472393)] - **doc**: improve http.request documentation (Guangcong Luo) [#18289](https://github.com/nodejs/node/pull/18289)
* [[`e5d5137963`](https://github.com/nodejs/node/commit/e5d5137963)] - **doc**: streamline README intro (Rich Trott) [#18483](https://github.com/nodejs/node/pull/18483)
* [[`eec9334a2e`](https://github.com/nodejs/node/commit/eec9334a2e)] - **doc**: move Brian White to TSC Emeriti list (Rich Trott) [#18482](https://github.com/nodejs/node/pull/18482)
* [[`ac41aacb05`](https://github.com/nodejs/node/commit/ac41aacb05)] - **doc**: improve stream documentation (陈刚) [#18375](https://github.com/nodejs/node/pull/18375)
* [[`7feeb1574e`](https://github.com/nodejs/node/commit/7feeb1574e)] - **doc**: add Gibson Fahnestock to TSC (Rich Trott) [#18481](https://github.com/nodejs/node/pull/18481)
* [[`142ad8d450`](https://github.com/nodejs/node/commit/142ad8d450)] - **doc**: reorder section on updating PR branch (Ali Ijaz Sheikh) [#18355](https://github.com/nodejs/node/pull/18355)
* [[`39ea4f12c5`](https://github.com/nodejs/node/commit/39ea4f12c5)] - **doc**: fix manpage warnings (Roman Reiss)
* [[`5209f9e1e2`](https://github.com/nodejs/node/commit/5209f9e1e2)] - **doc**: warn about GCM authenticity (Tobias Nießen) [#18376](https://github.com/nodejs/node/pull/18376)
* [[`e84e9db6fe`](https://github.com/nodejs/node/commit/e84e9db6fe)] - **doc**: capitalize non-primitive types (Vse Mozhet Byt) [#18111](https://github.com/nodejs/node/pull/18111)
* [[`84fa6eb173`](https://github.com/nodejs/node/commit/84fa6eb173)] - **doc, http2**: add sections for server.close() (Chris Miller) [#19802](https://github.com/nodejs/node/pull/19802)
* [[`cbc8561949`](https://github.com/nodejs/node/commit/cbc8561949)] - **errors**: remove ERR\_OUTOFMEMORY (Tobias Nießen) [#17877](https://github.com/nodejs/node/pull/17877)
* [[`2995506bbf`](https://github.com/nodejs/node/commit/2995506bbf)] - **fs**: fix stack overflow in fs.readdirSync (Joyee Cheung) [#18647](https://github.com/nodejs/node/pull/18647)
* [[`a653f23dfc`](https://github.com/nodejs/node/commit/a653f23dfc)] - **fs**: fix `createReadStream(…, {end: n})` for non-seekable fds (Anna Henningsen) [#19329](https://github.com/nodejs/node/pull/19329)
* [[`6bfdba125f`](https://github.com/nodejs/node/commit/6bfdba125f)] - **http**: remove default 'drain' listener on upgrade (Luigi Pinca) [#18866](https://github.com/nodejs/node/pull/18866)
* [[`29c395d975`](https://github.com/nodejs/node/commit/29c395d975)] - **http**: allow \_httpMessage to be GC'ed (Luigi Pinca) [#18865](https://github.com/nodejs/node/pull/18865)
* [[`d2a884edf9`](https://github.com/nodejs/node/commit/d2a884edf9)] - **http**: fix parsing of binary upgrade response body (Ben Noordhuis) [#17806](https://github.com/nodejs/node/pull/17806)
* [[`1d88266543`](https://github.com/nodejs/node/commit/1d88266543)] - **http**: free the parser before emitting 'upgrade' (Luigi Pinca) [#18209](https://github.com/nodejs/node/pull/18209)
* [[`1455b1dec2`](https://github.com/nodejs/node/commit/1455b1dec2)] - **http2**: emit session connect on next tick (Pieter Mees) [#19842](https://github.com/nodejs/node/pull/19842)
* [[`6d6e2e2454`](https://github.com/nodejs/node/commit/6d6e2e2454)] - **http2**: callback valid check before closing request (Trivikram) [#19061](https://github.com/nodejs/node/pull/19061)
* [[`eddf3a6c70`](https://github.com/nodejs/node/commit/eddf3a6c70)] - **http2**: destroy() stream, upon errnoException (Sarat Addepalli) [#19389](https://github.com/nodejs/node/pull/19389)
* [[`e4c10e1201`](https://github.com/nodejs/node/commit/e4c10e1201)] - **http2**: remove some unnecessary next ticks (James M Snell) [#19451](https://github.com/nodejs/node/pull/19451)
* [[`c976cb5be5`](https://github.com/nodejs/node/commit/c976cb5be5)] - **http2**: no stream destroy while its data is on the wire (Anna Henningsen) [#19002](https://github.com/nodejs/node/pull/19002)
* [[`bfd7d6d0de`](https://github.com/nodejs/node/commit/bfd7d6d0de)] - **http2**: fix flaky test-http2-https-fallback (Matteo Collina) [#19093](https://github.com/nodejs/node/pull/19093)
* [[`b75897f982`](https://github.com/nodejs/node/commit/b75897f982)] - **http2**: fix endless loop when writing empty string (Anna Henningsen) [#18924](https://github.com/nodejs/node/pull/18924)
* [[`7e4a9c9fe2`](https://github.com/nodejs/node/commit/7e4a9c9fe2)] - **http2**: use original error for cancelling pending streams (Anna Henningsen) [#18988](https://github.com/nodejs/node/pull/18988)
* [[`2a04f57444`](https://github.com/nodejs/node/commit/2a04f57444)] - **http2**: send error text in case of ALPN mismatch (Anna Henningsen) [#18986](https://github.com/nodejs/node/pull/18986)
* [[`f366373ad8`](https://github.com/nodejs/node/commit/f366373ad8)] - **http2**: fix condition where data is lost (Matteo Collina) [#18895](https://github.com/nodejs/node/pull/18895)
* [[`20fb59fdc4`](https://github.com/nodejs/node/commit/20fb59fdc4)] - **http2**: use `\_final` instead of `on('finish')` (Anna Henningsen) [#18609](https://github.com/nodejs/node/pull/18609)
* [[`ac64b4f6a7`](https://github.com/nodejs/node/commit/ac64b4f6a7)] - **http2**: add checks for server close callback (James M Snell) [#18182](https://github.com/nodejs/node/pull/18182)
* [[`8b0a1b32de`](https://github.com/nodejs/node/commit/8b0a1b32de)] - **http2**: refactor read mechanism (Anna Henningsen) [#18030](https://github.com/nodejs/node/pull/18030)
* [[`a4d910c644`](https://github.com/nodejs/node/commit/a4d910c644)] - **http2**: remember sent headers (James M Snell) [#18045](https://github.com/nodejs/node/pull/18045)
* [[`3cd205431b`](https://github.com/nodejs/node/commit/3cd205431b)] - **http2**: use aliased buffer for perf stats, add stats (James M Snell) [#18020](https://github.com/nodejs/node/pull/18020)
* [[`46d1b331e0`](https://github.com/nodejs/node/commit/46d1b331e0)] - **http2**: verify flood error and unsolicited frames (James M Snell) [#17969](https://github.com/nodejs/node/pull/17969)
* [[`a85518ed22`](https://github.com/nodejs/node/commit/a85518ed22)] - **http2**: verify that a dependency cycle may exist (James M Snell) [#17968](https://github.com/nodejs/node/pull/17968)
* [[`9c85ada4e3`](https://github.com/nodejs/node/commit/9c85ada4e3)] - **http2**: implement maxSessionMemory (James M Snell) [#17967](https://github.com/nodejs/node/pull/17967)
* [[`9a6ea7eb02`](https://github.com/nodejs/node/commit/9a6ea7eb02)] - **http2**: properly handle already closed stream error (James M Snell) [#17942](https://github.com/nodejs/node/pull/17942)
* [[`0078a97793`](https://github.com/nodejs/node/commit/0078a97793)] - **http2**: add aligned padding strategy (James M Snell) [#17938](https://github.com/nodejs/node/pull/17938)
* [[`1c313e09d6`](https://github.com/nodejs/node/commit/1c313e09d6)] - **http2**: add initial support for originSet (James M Snell) [#17935](https://github.com/nodejs/node/pull/17935)
* [[`1a24feccb5`](https://github.com/nodejs/node/commit/1a24feccb5)] - **http2**: add altsvc support (James M Snell) [#17917](https://github.com/nodejs/node/pull/17917)
* [[`c915bc54d4`](https://github.com/nodejs/node/commit/c915bc54d4)] - **http2**: strictly limit number on concurrent streams (James M Snell) [#16766](https://github.com/nodejs/node/pull/16766)
* [[`dcc7f4d84c`](https://github.com/nodejs/node/commit/dcc7f4d84c)] - **http2**: perf\_hooks integration (James M Snell) [#17906](https://github.com/nodejs/node/pull/17906)
* [[`72b42de33a`](https://github.com/nodejs/node/commit/72b42de33a)] - **http2**: implement ref() and unref() on client sessions (Kelvin Jin) [#17620](https://github.com/nodejs/node/pull/17620)
* [[`55f6bdb698`](https://github.com/nodejs/node/commit/55f6bdb698)] - **http2**: keep session objects alive during Http2Scope (Anna Henningsen) [#17863](https://github.com/nodejs/node/pull/17863)
* [[`c61a54ec3d`](https://github.com/nodejs/node/commit/c61a54ec3d)] - **http2**: fix compiling with `--debug-http2` (Anna Henningsen) [#17863](https://github.com/nodejs/node/pull/17863)
* [[`04632214c1`](https://github.com/nodejs/node/commit/04632214c1)] - **http2**: convert Http2Settings to an AsyncWrap (James M Snell) [#17763](https://github.com/nodejs/node/pull/17763)
* [[`ea98fd573e`](https://github.com/nodejs/node/commit/ea98fd573e)] - **http2**: refactor outgoing write mechanism (Anna Henningsen) [#17718](https://github.com/nodejs/node/pull/17718)
* [[`05b823d4ad`](https://github.com/nodejs/node/commit/05b823d4ad)] - **http2**: remove redundant write indirection (Anna Henningsen) [#17718](https://github.com/nodejs/node/pull/17718)
* [[`fc40b7de46`](https://github.com/nodejs/node/commit/fc40b7de46)] - **http2**: cleanup Http2Stream/Http2Session destroy (James M Snell) [#17406](https://github.com/nodejs/node/pull/17406)
* [[`1d65f2b879`](https://github.com/nodejs/node/commit/1d65f2b879)] - **http2**: be sure to destroy the Http2Stream (James M Snell) [#17406](https://github.com/nodejs/node/pull/17406)
* [[`8431b4297c`](https://github.com/nodejs/node/commit/8431b4297c)] - **http2**: only schedule write when necessary (Anna Henningsen) [#17183](https://github.com/nodejs/node/pull/17183)
* [[`38cfb707bd`](https://github.com/nodejs/node/commit/38cfb707bd)] - **http2**: don't call into JS from GC (Anna Henningsen) [#17183](https://github.com/nodejs/node/pull/17183)
* [[`a1539e5731`](https://github.com/nodejs/node/commit/a1539e5731)] - **http2**: simplify onSelectPadding (Anna Henningsen) [#17717](https://github.com/nodejs/node/pull/17717)
* [[`9a4bac2081`](https://github.com/nodejs/node/commit/9a4bac2081)] - **http2,perf_hooks**: perf state using AliasedBuffer (Kyle Farnung) [#18300](https://github.com/nodejs/node/pull/18300)
* [[`9129bc4fde`](https://github.com/nodejs/node/commit/9129bc4fde)] - **lib**: set process.execPath on OpenBSD (Aaron Bieber) [#18543](https://github.com/nodejs/node/pull/18543)
* [[`2019b023a7`](https://github.com/nodejs/node/commit/2019b023a7)] - **lib**: refactor ES module loader for readability (Anna Henningsen) [#16579](https://github.com/nodejs/node/pull/16579)
* [[`3df0570c90`](https://github.com/nodejs/node/commit/3df0570c90)] - **lib**: fix spelling in comments (Tobias Nießen) [#18018](https://github.com/nodejs/node/pull/18018)
* [[`20844d1716`](https://github.com/nodejs/node/commit/20844d1716)] - **lib**: remove debugger dead code (Qingyan Li) [#18426](https://github.com/nodejs/node/pull/18426)
* [[`07a6770614`](https://github.com/nodejs/node/commit/07a6770614)] - **n-api**: add more `int64\_t` tests (Kyle Farnung) [#19402](https://github.com/nodejs/node/pull/19402)
* [[`8b3ef4660a`](https://github.com/nodejs/node/commit/8b3ef4660a)] - **n-api**: back up env before finalize (Gabriel Schulhof) [#19718](https://github.com/nodejs/node/pull/19718)
* [[`92f699e021`](https://github.com/nodejs/node/commit/92f699e021)] - **n-api**: ensure in-module exceptions are propagated (Gabriel Schulhof) [#19537](https://github.com/nodejs/node/pull/19537)
* [[`367113f5d7`](https://github.com/nodejs/node/commit/367113f5d7)] - **n-api**: bump version of n-api supported (Michael Dawson) [#19497](https://github.com/nodejs/node/pull/19497)
* [[`24b8bb6708`](https://github.com/nodejs/node/commit/24b8bb6708)] - **n-api**: re-write test\_make\_callback (Gabriel Schulhof) [#19448](https://github.com/nodejs/node/pull/19448)
* [[`3a6b7e610d`](https://github.com/nodejs/node/commit/3a6b7e610d)] - **n-api**: add napi\_fatal\_exception (Mathias Buus) [#19337](https://github.com/nodejs/node/pull/19337)
* [[`9949d55ae9`](https://github.com/nodejs/node/commit/9949d55ae9)] - **n-api**: separate out async\_hooks test (Gabriel Schulhof) [#19392](https://github.com/nodejs/node/pull/19392)
* [[`f29d8e0e8d`](https://github.com/nodejs/node/commit/f29d8e0e8d)] - **n-api**: add missing exception checking (Michael Dawson) [#19362](https://github.com/nodejs/node/pull/19362)
* [[`faf94b1c49`](https://github.com/nodejs/node/commit/faf94b1c49)] - **n-api**: resolve promise in test (Gabriel Schulhof) [#19245](https://github.com/nodejs/node/pull/19245)
* [[`df63adf7aa`](https://github.com/nodejs/node/commit/df63adf7aa)] - **n-api**: update documentation (Gabriel Schulhof) [#19078](https://github.com/nodejs/node/pull/19078)
* [[`b26410e86f`](https://github.com/nodejs/node/commit/b26410e86f)] - **n-api**: update reference test (Gabriel Schulhof) [#19086](https://github.com/nodejs/node/pull/19086)
* [[`cb3f90a1a9`](https://github.com/nodejs/node/commit/cb3f90a1a9)] - **n-api**: fix object test (Gabriel Schulhof) [#19039](https://github.com/nodejs/node/pull/19039)
* [[`9244e1d234`](https://github.com/nodejs/node/commit/9244e1d234)] - **n-api**: remove extra reference from test (Gabriel Schulhof) [#18542](https://github.com/nodejs/node/pull/18542)
* [[`927fc0b19f`](https://github.com/nodejs/node/commit/927fc0b19f)] - **n-api**: add methods to open/close callback scope (Michael Dawson) [#18089](https://github.com/nodejs/node/pull/18089)
* [[`969a520990`](https://github.com/nodejs/node/commit/969a520990)] - **n-api**: wrap control flow macro in do/while (Ben Noordhuis) [#18532](https://github.com/nodejs/node/pull/18532)
* [[`d89f5937eb`](https://github.com/nodejs/node/commit/d89f5937eb)] - **n-api**: implement wrapping using private properties (Gabriel Schulhof) [#18311](https://github.com/nodejs/node/pull/18311)
* [[`af655f586c`](https://github.com/nodejs/node/commit/af655f586c)] - **n-api**: change assert ok check to notStrictEqual. (Aaron Kau) [#18414](https://github.com/nodejs/node/pull/18414)
* [[`ca10fda064`](https://github.com/nodejs/node/commit/ca10fda064)] - **n-api**: throw RangeError napi\_create\_typedarray() (Jinho Bang) [#18037](https://github.com/nodejs/node/pull/18037)
* [[`853b4d593c`](https://github.com/nodejs/node/commit/853b4d593c)] - **n-api**: expose n-api version in process.versions (Michael Dawson) [#18067](https://github.com/nodejs/node/pull/18067)
* [[`48be8a4793`](https://github.com/nodejs/node/commit/48be8a4793)] - **n-api**: throw RangeError in napi\_create\_dataview() with invalid range (Jinho Bang) [#17869](https://github.com/nodejs/node/pull/17869)
* [[`a744535f99`](https://github.com/nodejs/node/commit/a744535f99)] - **n-api**: fix memory leak in napi\_async\_destroy() (alnyan) [#17714](https://github.com/nodejs/node/pull/17714)
* [[`584fadc605`](https://github.com/nodejs/node/commit/584fadc605)] - **n-api,test**: add int64 bounds tests (Kyle Farnung) [#19309](https://github.com/nodejs/node/pull/19309)
* [[`4c1181dc02`](https://github.com/nodejs/node/commit/4c1181dc02)] - **n-api,test**: add a new.target test to addons-napi (Taylor Woll) [#19236](https://github.com/nodejs/node/pull/19236)
* [[`3225601ffc`](https://github.com/nodejs/node/commit/3225601ffc)] - **net**: remove Socket.prototoype.read (Anna Henningsen) [#18568](https://github.com/nodejs/node/pull/18568)
* [[`35aaee1059`](https://github.com/nodejs/node/commit/35aaee1059)] - **net**: remove redundant code from \_writeGeneric() (Luigi Pinca) [#18429](https://github.com/nodejs/node/pull/18429)
* [[`54442efcd2`](https://github.com/nodejs/node/commit/54442efcd2)] - **perf_hooks**: refactor internals (James M Snell) [#17822](https://github.com/nodejs/node/pull/17822)
* [[`6bdfb1f8f0`](https://github.com/nodejs/node/commit/6bdfb1f8f0)] - **perf_hooks,http2**: add performance.clear() (James M Snell) [#18046](https://github.com/nodejs/node/pull/18046)
* [[`1faae90b74`](https://github.com/nodejs/node/commit/1faae90b74)] - **readline**: use Date.now() and move test to parallel (Anatoli Papirovski) [#18563](https://github.com/nodejs/node/pull/18563)
* [[`965b56a34e`](https://github.com/nodejs/node/commit/965b56a34e)] - **readline**: update references to archived repository (Tobias Nießen) [#17924](https://github.com/nodejs/node/pull/17924)
* [[`801a49935b`](https://github.com/nodejs/node/commit/801a49935b)] - **src**: add nullptr check for session in DEBUG macro (Daniel Bevenius) [#18815](https://github.com/nodejs/node/pull/18815)
* [[`4e807d648e`](https://github.com/nodejs/node/commit/4e807d648e)] - **src**: introduce internal buffer slice constructor (Anna Henningsen) [#18030](https://github.com/nodejs/node/pull/18030)
* [[`0b828e5125`](https://github.com/nodejs/node/commit/0b828e5125)] - **src**: remove declarations for missing functions (Anna Henningsen) [#18134](https://github.com/nodejs/node/pull/18134)
* [[`3766e04f31`](https://github.com/nodejs/node/commit/3766e04f31)] - **src**: silence http2 -Wunused-result warnings (cjihrig) [#17954](https://github.com/nodejs/node/pull/17954)
* [[`2b7732788a`](https://github.com/nodejs/node/commit/2b7732788a)] - **src**: add optional keep-alive object to SetImmediate (Anna Henningsen) [#17183](https://github.com/nodejs/node/pull/17183)
* [[`f3e082c4ea`](https://github.com/nodejs/node/commit/f3e082c4ea)] - **src**: replace SetAccessor w/ SetAccessorProperty (Jure Triglav) [#17665](https://github.com/nodejs/node/pull/17665)
* [[`45e28a8628`](https://github.com/nodejs/node/commit/45e28a8628)] - **src**: minor refactoring to StreamBase writes (Anna Henningsen) [#17564](https://github.com/nodejs/node/pull/17564)
* [[`42b4f3ce0b`](https://github.com/nodejs/node/commit/42b4f3ce0b)] - **src**: fix abort when taking a heap snapshot (Ben Noordhuis) [#18898](https://github.com/nodejs/node/pull/18898)
* [[`b48ca0a140`](https://github.com/nodejs/node/commit/b48ca0a140)] - **src**: fix crypto.pbkdf2 callback error argument (BufoViridis) [#18458](https://github.com/nodejs/node/pull/18458)
* [[`973488b77b`](https://github.com/nodejs/node/commit/973488b77b)] - **src**: replace var for let / const. (alejandro estrada) [#18649](https://github.com/nodejs/node/pull/18649)
* [[`9ac91b14de`](https://github.com/nodejs/node/commit/9ac91b14de)] - **src**: fix util abort (Ruben Bridgewater) [#19224](https://github.com/nodejs/node/pull/19224)
* [[`c0f40be23b`](https://github.com/nodejs/node/commit/c0f40be23b)] - **src**: free memory before re-setting URLHost value (Ivan Filenko) [#18357](https://github.com/nodejs/node/pull/18357)
* [[`5e4f9b37ba`](https://github.com/nodejs/node/commit/5e4f9b37ba)] - **src,doc,test**: Fix common misspellings (Roman Reiss) [#18151](https://github.com/nodejs/node/pull/18151)
* [[`10231a9e44`](https://github.com/nodejs/node/commit/10231a9e44)] - **stream**: cleanup() when unpiping all streams. (陈刚) [#18266](https://github.com/nodejs/node/pull/18266)
* [[`bf523822ba`](https://github.com/nodejs/node/commit/bf523822ba)] - **stream**: simplify `src.\_readableState` to `state` (陈刚) [#18264](https://github.com/nodejs/node/pull/18264)
* [[`37e594ed4a`](https://github.com/nodejs/node/commit/37e594ed4a)] - **stream**: remove unreachable code (Luigi Pinca) [#18239](https://github.com/nodejs/node/pull/18239)
* [[`f96b0bf494`](https://github.com/nodejs/node/commit/f96b0bf494)] - **string_decoder**: reset decoder on end (Justin Ridgewell) [#18494](https://github.com/nodejs/node/pull/18494)
* [[`4dbdb8ae4e`](https://github.com/nodejs/node/commit/4dbdb8ae4e)] - **test**: http2 errors on req.close() (Trivikram) [#18854](https://github.com/nodejs/node/pull/18854)
* [[`83d8ad351c`](https://github.com/nodejs/node/commit/83d8ad351c)] - **test**: http2 stream.respond() error checks (Trivikram) [#18861](https://github.com/nodejs/node/pull/18861)
* [[`b0664426f5`](https://github.com/nodejs/node/commit/b0664426f5)] - **test**: check endless loop while writing empty string (XadillaX) [#18924](https://github.com/nodejs/node/pull/18924)
* [[`7eba62e028`](https://github.com/nodejs/node/commit/7eba62e028)] - **test**: make test-tls-external-accessor agnostic (Rich Trott) [#16272](https://github.com/nodejs/node/pull/16272)
* [[`9e68947ff4`](https://github.com/nodejs/node/commit/9e68947ff4)] - **test**: add hasCrypto when using binding('crypto') (Daniel Bevenius) [#17867](https://github.com/nodejs/node/pull/17867)
* [[`6129ff4b99`](https://github.com/nodejs/node/commit/6129ff4b99)] - **test**: remove unnecessary timer (cjihrig) [#18719](https://github.com/nodejs/node/pull/18719)
* [[`2838f9b150`](https://github.com/nodejs/node/commit/2838f9b150)] - **test**: convert new tests to use error types (Jack Horton) [#18581](https://github.com/nodejs/node/pull/18581)
* [[`5c0983e5a2`](https://github.com/nodejs/node/commit/5c0983e5a2)] - **test**: improve error message output (Bhavani Shankar) [#18498](https://github.com/nodejs/node/pull/18498)
* [[`bebcdfe382`](https://github.com/nodejs/node/commit/bebcdfe382)] - **test**: show pending exception error in napi tests (Ben Wilcox) [#18413](https://github.com/nodejs/node/pull/18413)
* [[`5b1b74c5a5`](https://github.com/nodejs/node/commit/5b1b74c5a5)] - **test**: refactor addons-napi/test\_exception/test.js (Rich Trott) [#18340](https://github.com/nodejs/node/pull/18340)
* [[`8cfa87832d`](https://github.com/nodejs/node/commit/8cfa87832d)] - **test**: fixed typos in napi test (furstenheim) [#18148](https://github.com/nodejs/node/pull/18148)
* [[`ad8c079af7`](https://github.com/nodejs/node/commit/ad8c079af7)] - **test**: remove ambiguous error messages from test\_error (Nicholas Drane) [#17812](https://github.com/nodejs/node/pull/17812)
* [[`2e100c82be`](https://github.com/nodejs/node/commit/2e100c82be)] - **test**: remove literals that obscure assert messages (Rich Trott) [#17642](https://github.com/nodejs/node/pull/17642)
* [[`077e1870ae`](https://github.com/nodejs/node/commit/077e1870ae)] - **test**: add unhandled rejection guard (babygoat) [#17275](https://github.com/nodejs/node/pull/17275)
* [[`9236332cc3`](https://github.com/nodejs/node/commit/9236332cc3)] - **test**: update a few tests to work on OpenBSD (Aaron Bieber) [#18543](https://github.com/nodejs/node/pull/18543)
* [[`cbd698a521`](https://github.com/nodejs/node/commit/cbd698a521)] - **test**: refactor test-http-abort-before-end (cjihrig) [#18508](https://github.com/nodejs/node/pull/18508)
* [[`ab8edc9d48`](https://github.com/nodejs/node/commit/ab8edc9d48)] - **test**: fix flaky timers-block-eventloop test (Anatoli Papirovski) [#18567](https://github.com/nodejs/node/pull/18567)
* [[`53b702fdba`](https://github.com/nodejs/node/commit/53b702fdba)] - **test**: remove common.PORT from parallel tests (Rich Trott) [#17410](https://github.com/nodejs/node/pull/17410)
* [[`da162278de`](https://github.com/nodejs/node/commit/da162278de)] - **test**: mock the lookup function in parallel tests (Joyee Cheung) [#17296](https://github.com/nodejs/node/pull/17296)
* [[`34af49401b`](https://github.com/nodejs/node/commit/34af49401b)] - **test**: add common.dns.errorLookupMock (Joyee Cheung) [#17296](https://github.com/nodejs/node/pull/17296)
* [[`bff7258535`](https://github.com/nodejs/node/commit/bff7258535)] - **test**: do not check TXT content in test-dns-any (Joyee Cheung) [#18547](https://github.com/nodejs/node/pull/18547)
* [[`daeb6de8ec`](https://github.com/nodejs/node/commit/daeb6de8ec)] - **test**: use internet.addresses in internet tests (Joyee Cheung) [#16390](https://github.com/nodejs/node/pull/16390)
* [[`7813a0de0a`](https://github.com/nodejs/node/commit/7813a0de0a)] - **test**: introduce test/common/internet.addresses (Joyee Cheung) [#16390](https://github.com/nodejs/node/pull/16390)
* [[`745600a0b3`](https://github.com/nodejs/node/commit/745600a0b3)] - **test**: remove orphaned entries from status (Kyle Farnung) [#18092](https://github.com/nodejs/node/pull/18092)
* [[`e42ab10957`](https://github.com/nodejs/node/commit/e42ab10957)] - **test**: add assertions for TextEncoder/Decoder (Sho Miyamoto) [#18132](https://github.com/nodejs/node/pull/18132)
* [[`a1b0d5da07`](https://github.com/nodejs/node/commit/a1b0d5da07)] - **test**: move tmpdir to submodule of common (Rich Trott) [#17856](https://github.com/nodejs/node/pull/17856)
* [[`5155d8e7c3`](https://github.com/nodejs/node/commit/5155d8e7c3)] - **test**: update references to archived repository (Tobias Nießen) [#17924](https://github.com/nodejs/node/pull/17924)
* [[`1043b6fd7c`](https://github.com/nodejs/node/commit/1043b6fd7c)] - **test**: fix spelling in test case comments (Tobias Nießen) [#18018](https://github.com/nodejs/node/pull/18018)
* [[`fdb4dbc04b`](https://github.com/nodejs/node/commit/fdb4dbc04b)] - **test**: remove destructor from node\_test\_fixture (Daniel Bevenius) [#18524](https://github.com/nodejs/node/pull/18524)
* [[`e55e08c80e`](https://github.com/nodejs/node/commit/e55e08c80e)] - **test**: verify the shell option works properly on execFile (jvelezpo) [#18384](https://github.com/nodejs/node/pull/18384)
* [[`0cf9d0483f`](https://github.com/nodejs/node/commit/0cf9d0483f)] - **test**: add test for tls benchmarks (Anatoli Papirovski) [#18489](https://github.com/nodejs/node/pull/18489)
* [[`d630874250`](https://github.com/nodejs/node/commit/d630874250)] - **test**: speed up parallel/test-tls-session-cache (Anna Henningsen) [#18424](https://github.com/nodejs/node/pull/18424)
* [[`a1fb263880`](https://github.com/nodejs/node/commit/a1fb263880)] - **test**: fix flaky test-http-dns-error (Bryan English) [#16534](https://github.com/nodejs/node/pull/16534)
* [[`6f3fb46541`](https://github.com/nodejs/node/commit/6f3fb46541)] - **test**: use correct size in test-stream-buffer-list (Luigi Pinca) [#18239](https://github.com/nodejs/node/pull/18239)
* [[`a52f15efae`](https://github.com/nodejs/node/commit/a52f15efae)] - **timers**: fix a bug in error handling (Anatoli Papirovski) [#20497](https://github.com/nodejs/node/pull/20497)
* [[`e15f57745d`](https://github.com/nodejs/node/commit/e15f57745d)] - **timers**: allow Immediates to be unrefed (Anatoli Papirovski) [#18139](https://github.com/nodejs/node/pull/18139)
* [[`95c1e2d606`](https://github.com/nodejs/node/commit/95c1e2d606)] - **tls**: set servername on client side too (James M Snell) [#17935](https://github.com/nodejs/node/pull/17935)
* [[`d4bccccf23`](https://github.com/nodejs/node/commit/d4bccccf23)] - **tools**: add fixer for prefer-assert-iferror.js (Shobhit Chittora) [#16648](https://github.com/nodejs/node/pull/16648)
* [[`016a28ac08`](https://github.com/nodejs/node/commit/016a28ac08)] - **tools**: non-Ascii linter for /lib only (Sarat Addepalli) [#18043](https://github.com/nodejs/node/pull/18043)
* [[`a0a45fc3b6`](https://github.com/nodejs/node/commit/a0a45fc3b6)] - **tools**: add .mjs linting for Windows (Vse Mozhet Byt) [#18569](https://github.com/nodejs/node/pull/18569)
* [[`e0d2842b29`](https://github.com/nodejs/node/commit/e0d2842b29)] - **tools**: add check for using process.binding crypto (Daniel Bevenius) [#17867](https://github.com/nodejs/node/pull/17867)
* [[`a8b5a96d15`](https://github.com/nodejs/node/commit/a8b5a96d15)] - **tools**: auto fix custom eslint rule (Shobhit Chittora) [#16652](https://github.com/nodejs/node/pull/16652)
* [[`5d03c8219a`](https://github.com/nodejs/node/commit/5d03c8219a)] - **url**: simplify loop in parser (Tobias Nießen) [#18468](https://github.com/nodejs/node/pull/18468)
* [[`e0e0ef7bab`](https://github.com/nodejs/node/commit/e0e0ef7bab)] - **util**: escaping object keys in util.inspect() (buji) [#16986](https://github.com/nodejs/node/pull/16986)
* [[`8ac69c457b`](https://github.com/nodejs/node/commit/8ac69c457b)] - **v8**: add missing ',' in OpenBSD's 'sources' section. (Aaron Bieber) [#18448](https://github.com/nodejs/node/pull/18448)
* [[`c61754fad9`](https://github.com/nodejs/node/commit/c61754fad9)] - **win, build**: fix intl-none option (Birunthan Mohanathas) [#18292](https://github.com/nodejs/node/pull/18292)

<a id="8.11.1"></a>
## 2018-03-29, Version 8.11.1 'Carbon' (LTS), @MylesBorins

### Notable Changes

No additional commits.

Due to incorrect staging of the upgrade to the GCC 4.9.X compiler, the latest releases for PPC little
endian were built using GCC 4.9.X instead of GCC 4.8.X. This caused an ABI breakage on PPCLE based
environments. This has been fixed in our infrastructure and we are doing this release to ensure that
the hosted binaries are adhering to our platform support contract.

Note that Node.js versions 10.X and later will be built with version 4.9.X or later of the GCC compiler,
and it is possible that Node.js version 8.X may be built on the 4.9.X compiler at a later
time as the stated [minimum compiler requirement](https://github.com/nodejs/node/blob/v8.x/BUILDING.md)
for Node.js version 8.X is 4.9.4.

<a id="8.11.0"></a>
## 2018-03-28, Version 8.11.0 'Carbon' (LTS), @MylesBorins

This is a security release. All Node.js users should consult the security release summary at https://nodejs.org/en/blog/vulnerability/march-2018-security-releases/ for details on patched vulnerabilities.

Fixes for the following CVEs are included in this release:

* CVE-2018-7158
* CVE-2018-7159
* CVE-2018-7160

### Notable Changes

* **Upgrade to OpenSSL 1.0.2o**: Does not contain any security fixes that are known to impact Node.js.
* **Fix for inspector DNS rebinding vulnerability (CVE-2018-7160)**: A malicious website could use a DNS rebinding attack to trick a web browser to bypass same-origin-policy checks and allow HTTP connections to localhost or to hosts on the local network, potentially to an open inspector port as a debugger, therefore gaining full code execution access. The inspector now only allows connections that have a browser `Host` value of `localhost` or `localhost6`.
* **Fix for `'path'` module regular expression denial of service (CVE-2018-7158)**: A regular expression used for parsing POSIX paths could be used to cause a denial of service if an attacker were able to have a specially crafted path string passed through one of the impacted `'path'` module functions.
* **Reject spaces in HTTP `Content-Length` header values (CVE-2018-7159)**: The Node.js HTTP parser allowed for spaces inside `Content-Length` header values. Such values now lead to rejected connections in the same way as non-numeric values.
* **Update root certificates**: 5 additional root certificates have been added to the Node.js binary and 30 have been removed.

### Commits

* [[`dc290562e9`](https://github.com/nodejs/node/commit/dc290562e9)] - **crypto**: update root certificates (Ben Noordhuis) [#19322](https://github.com/nodejs/node/pull/19322)
* [[`df92da3f3c`](https://github.com/nodejs/node/commit/df92da3f3c)] - **deps**: add -no\_rand\_screen to openssl s\_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`259156ea40`](https://github.com/nodejs/node/commit/259156ea40)] - **deps**: fix asm build error of openssl in x86\_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`d559d0eb25`](https://github.com/nodejs/node/commit/d559d0eb25)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`cf8e8bcad2`](https://github.com/nodejs/node/commit/cf8e8bcad2)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#19638](https://github.com/nodejs/node/pull/19638)
* [[`987138e488`](https://github.com/nodejs/node/commit/987138e488)] - **deps**: upgrade openssl sources to 1.0.2o (Shigeki Ohtsu) [#19638](https://github.com/nodejs/node/pull/19638)
* [[`1b7f6d9072`](https://github.com/nodejs/node/commit/1b7f6d9072)] - **deps**: reject interior blanks in Content-Length (Ben Noordhuis) [nodejs-private/http-parser-private#1](https://github.com/nodejs-private/http-parser-private/pull/1)
* [[`86c9ec6c5c`](https://github.com/nodejs/node/commit/86c9ec6c5c)] - **deps**: upgrade http-parser to v2.8.0 (Ben Noordhuis) [nodejs-private/http-parser-private#1](https://github.com/nodejs-private/http-parser-private/pull/1)
* [[`de0c84889b`](https://github.com/nodejs/node/commit/de0c84889b)] - **inspector**: minor adjustments (Eugene Ostroukhov)
* [[`b7690655ef`](https://github.com/nodejs/node/commit/b7690655ef)] - **inspector**: check Host header (Ali Ijaz Sheikh)
* [[`0641f2dbf9`](https://github.com/nodejs/node/commit/0641f2dbf9)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`6ee4228c1d`](https://github.com/nodejs/node/commit/6ee4228c1d)] - **src**: drop CNNIC+StartCom certificate whitelisting (Ben Noordhuis) [#19322](https://github.com/nodejs/node/pull/19322)
* [[`633e23a618`](https://github.com/nodejs/node/commit/633e23a618)] - **tools**: update certdata.txt (Ben Noordhuis) [#19322](https://github.com/nodejs/node/pull/19322)

<a id="8.10.0"></a>
## 2018-03-06, Version 8.10.0 'Carbon' (LTS), @gibfahn

### Notable Changes

* **deps**:
  * update V8 to 6.2.414.46 (Michaël Zasso) [#16413](https://github.com/nodejs/node/pull/16413)
  * revert ABI breaking changes in V8 6.2 (Anna Henningsen) [#16413](https://github.com/nodejs/node/pull/16413)
  * upgrade libuv to 1.19.1 (cjihrig) [#18260](https://github.com/nodejs/node/pull/18260)
  * re land npm 5.6.0 (Myles Borins) [#18625](https://github.com/nodejs/node/pull/18625)
  * ICU 60 bump (Steven R. Loomis) [#16876](https://github.com/nodejs/node/pull/16876)
* **crypto**:
  * Support both OpenSSL 1.1.0 and 1.0.2 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
  * warn on invalid authentication tag length (Tobias Nießen) [#17566](https://github.com/nodejs/node/pull/17566)
* **async_hooks**:
  * update defaultTriggerAsyncIdScope for perf (Anatoli Papirovski) [#18004](https://github.com/nodejs/node/pull/18004)
  * use typed array stack as fast path (Anna Henningsen) [#17780](https://github.com/nodejs/node/pull/17780)
  * use scope for defaultTriggerAsyncId (Andreas Madsen) [#17273](https://github.com/nodejs/node/pull/17273)
  * separate missing from default context (Andreas Madsen) [#17273](https://github.com/nodejs/node/pull/17273)
  * rename initTriggerId (Andreas Madsen) [#17273](https://github.com/nodejs/node/pull/17273)
  * deprecate undocumented API (Andreas Madsen) [#16972](https://github.com/nodejs/node/pull/16972)
  * add destroy event for gced AsyncResources (Sebastian Mayr) [#16998](https://github.com/nodejs/node/pull/16998)
  * add trace events to async_hooks (Andreas Madsen) [#15538](https://github.com/nodejs/node/pull/15538)
  * set HTTPParser trigger to socket (Andreas Madsen) [#18003](https://github.com/nodejs/node/pull/18003)
  * add provider types for net server (Andreas Madsen) [#17157](https://github.com/nodejs/node/pull/17157)
* **n-api**:
  * add helper for addons to get the event loop (Anna Henningsen) [#17109](https://github.com/nodejs/node/pull/17109)
* **cli**:
  * add --stack-trace-limit to NODE_OPTIONS (Anna Henningsen) [#16495](https://github.com/nodejs/node/pull/16495)
* **console**:
  * add support for console.debug (Benjamin Zaslavsky) [#17033](https://github.com/nodejs/node/pull/17033)
* **module**:
  * add builtinModules (Jon Moss) [#16386](https://github.com/nodejs/node/pull/16386)
  * replace default paths in require.resolve() (cjihrig) [#17113](https://github.com/nodejs/node/pull/17113)
* **src**:
  * add helper for addons to get the event loop (Anna Henningsen) [#17109](https://github.com/nodejs/node/pull/17109)
  * add process.ppid (cjihrig) [#16839](https://github.com/nodejs/node/pull/16839)
* **http**:
  * support generic `Duplex` streams (Anna Henningsen) [#16267](https://github.com/nodejs/node/pull/16267)
  * add rawPacket in err of `clientError` event (XadillaX) [#17672](https://github.com/nodejs/node/pull/17672)
  * better support for IPv6 addresses (Mattias Holmlund) [#14772](https://github.com/nodejs/node/pull/14772)
* **net**:
  * remove ADDRCONFIG DNS hint on Windows (Bartosz Sosnowski) [#17662](https://github.com/nodejs/node/pull/17662)
* **process**:
  * fix reading zero-length env vars on win32 (Anna Henningsen) [#18463](https://github.com/nodejs/node/pull/18463)
* **tls**:
  * unconsume stream on destroy (Anna Henningsen) [#17478](https://github.com/nodejs/node/pull/17478)
* **process**:
  * improve unhandled rejection message (Madara Uchiha) [#17158](https://github.com/nodejs/node/pull/17158)
* **stream**:
  * remove usage of *State.highWaterMark (Calvin Metcalf) [#12860](https://github.com/nodejs/node/pull/12860)
* **trace_events**:
  * add executionAsyncId to init events (Andreas Madsen) [#17196](https://github.com/nodejs/node/pull/17196)

### Commits

* [[`5dab90b8bb`](https://github.com/nodejs/node/commit/5dab90b8bb)] - **async_hooks**: update defaultTriggerAsyncIdScope for perf (Anatoli Papirovski) [#18004](https://github.com/nodejs/node/pull/18004)
* [[`086af68c19`](https://github.com/nodejs/node/commit/086af68c19)] - **async_hooks**: use typed array stack as fast path (Anna Henningsen) [#17780](https://github.com/nodejs/node/pull/17780)
* [[`0f7c8984af`](https://github.com/nodejs/node/commit/0f7c8984af)] - **async_hooks**: use CHECK instead of throwing error (Jon Moss) [#17832](https://github.com/nodejs/node/pull/17832)
* [[`5a199a905b`](https://github.com/nodejs/node/commit/5a199a905b)] - **async_hooks**: use scope for defaultTriggerAsyncId (Andreas Madsen) [#17273](https://github.com/nodejs/node/pull/17273)
* [[`03873db4d0`](https://github.com/nodejs/node/commit/03873db4d0)] - **async_hooks**: separate missing from default context (Andreas Madsen) [#17273](https://github.com/nodejs/node/pull/17273)
* [[`cce92ccfa8`](https://github.com/nodejs/node/commit/cce92ccfa8)] - **async_hooks**: rename initTriggerId (Andreas Madsen) [#17273](https://github.com/nodejs/node/pull/17273)
* [[`025b9f208f`](https://github.com/nodejs/node/commit/025b9f208f)] - **(SEMVER-MINOR)** **async_hooks**: deprecate undocumented API (Andreas Madsen) [#16972](https://github.com/nodejs/node/pull/16972)
* [[`36dbd1181a`](https://github.com/nodejs/node/commit/36dbd1181a)] - **(SEMVER-MINOR)** **async_hooks**: add destroy event for gced AsyncResources (Sebastian Mayr) [#16998](https://github.com/nodejs/node/pull/16998)
* [[`331b175af2`](https://github.com/nodejs/node/commit/331b175af2)] - **(SEMVER-MINOR)** **async_hooks**: add trace events to async_hooks (Andreas Madsen) [#15538](https://github.com/nodejs/node/pull/15538)
* [[`91d4eb5ff8`](https://github.com/nodejs/node/commit/91d4eb5ff8)] - **(SEMVER-MINOR)** **async_hooks,http**: set HTTPParser trigger to socket (Andreas Madsen) [#18003](https://github.com/nodejs/node/pull/18003)
* [[`0211175bc7`](https://github.com/nodejs/node/commit/0211175bc7)] - **async_hooks,test**: only use IPv6 in http test (Andreas Madsen) [#18143](https://github.com/nodejs/node/pull/18143)
* [[`6d55a4c941`](https://github.com/nodejs/node/commit/6d55a4c941)] - **(SEMVER-MINOR)** **async_wrap**: add provider types for net server (Andreas Madsen) [#17157](https://github.com/nodejs/node/pull/17157)
* [[`8143a95c1f`](https://github.com/nodejs/node/commit/8143a95c1f)] - **benchmark**: implement duration in http test double (Joyee Cheung) [#18380](https://github.com/nodejs/node/pull/18380)
* [[`f779a8b5a4`](https://github.com/nodejs/node/commit/f779a8b5a4)] - **benchmark**: make compare.R easier to understand (Andreas Madsen) [#18373](https://github.com/nodejs/node/pull/18373)
* [[`deb70417cd`](https://github.com/nodejs/node/commit/deb70417cd)] - **benchmark**: remove redundant + (sreepurnajasti) [#17803](https://github.com/nodejs/node/pull/17803)
* [[`452d2c561a`](https://github.com/nodejs/node/commit/452d2c561a)] - **benchmark**: fix timeout in write-stream-throughput (Anatoli Papirovski) [#17958](https://github.com/nodejs/node/pull/17958)
* [[`1e3ea5023b`](https://github.com/nodejs/node/commit/1e3ea5023b)] - **benchmark**: make temp file path configurable (Rich Trott) [#17811](https://github.com/nodejs/node/pull/17811)
* [[`91135b9bd2`](https://github.com/nodejs/node/commit/91135b9bd2)] - **build**: fix Makefile wrt finding node executable (Yang Guo) [#18040](https://github.com/nodejs/node/pull/18040)
* [[`f07bb16255`](https://github.com/nodejs/node/commit/f07bb16255)] - **build**: fix cctest target with --enable-static (Qingyan Li) [#17992](https://github.com/nodejs/node/pull/17992)
* [[`e61344a9e9`](https://github.com/nodejs/node/commit/e61344a9e9)] - **build**: remove cctest extension (Yihong Wang) [#16680](https://github.com/nodejs/node/pull/16680)
* [[`fd845d80eb`](https://github.com/nodejs/node/commit/fd845d80eb)] - **build,win**: update lint-cpp on Windows (Kyle Farnung) [#18012](https://github.com/nodejs/node/pull/18012)
* [[`44ab4f09a2`](https://github.com/nodejs/node/commit/44ab4f09a2)] - **build,win,msi**: support WiX with VS2017 (João Reis) [#17101](https://github.com/nodejs/node/pull/17101)
* [[`ec7996ca15`](https://github.com/nodejs/node/commit/ec7996ca15)] - **(SEMVER-MINOR)** **cli**: add --stack-trace-limit to NODE_OPTIONS (Anna Henningsen) [#16495](https://github.com/nodejs/node/pull/16495)
* [[`087cdaf871`](https://github.com/nodejs/node/commit/087cdaf871)] - **cluster**: resolve relative unix socket paths (laino) [#16749](https://github.com/nodejs/node/pull/16749)
* [[`162ff56439`](https://github.com/nodejs/node/commit/162ff56439)] - **(SEMVER-MINOR)** **console**: add support for console.debug (Benjamin Zaslavsky) [#17033](https://github.com/nodejs/node/pull/17033)
* [[`8cc0ea78d7`](https://github.com/nodejs/node/commit/8cc0ea78d7)] - **crypto**: do not reach into OpenSSL internals for ThrowCryptoError (David Benjamin) [#16701](https://github.com/nodejs/node/pull/16701)
* [[`072902a258`](https://github.com/nodejs/node/commit/072902a258)] - **crypto**: remove leftover initialization (Myles Borins) [#18622](https://github.com/nodejs/node/pull/18622)
* [[`b0526ba7f1`](https://github.com/nodejs/node/commit/b0526ba7f1)] - **(SEMVER-MINOR)** **crypto**: clear some SSL_METHOD deprecation warnings (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`78738266d6`](https://github.com/nodejs/node/commit/78738266d6)] - **(SEMVER-MINOR)** **crypto**: make ALPN the same for OpenSSL 1.0.2 & 1.1.0 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`f1d458be58`](https://github.com/nodejs/node/commit/f1d458be58)] - **(SEMVER-MINOR)** **crypto**: remove deprecated ECDH calls w/ OpenSSL 1.1 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`f9a597a1d3`](https://github.com/nodejs/node/commit/f9a597a1d3)] - **(SEMVER-MINOR)** **crypto**: emulate OpenSSL 1.0 ticket scheme in 1.1 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`eb377f38f6`](https://github.com/nodejs/node/commit/eb377f38f6)] - **(SEMVER-MINOR)** **crypto**: hard-code tlsSocket.getCipher().version (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`2efb16b7d7`](https://github.com/nodejs/node/commit/2efb16b7d7)] - **(SEMVER-MINOR)** **crypto**: add compat logic for "DSS1" and "dss1" (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`5e9e4e5bf9`](https://github.com/nodejs/node/commit/5e9e4e5bf9)] - **(SEMVER-MINOR)** **crypto**: Make Hmac 1.1.0-compatible (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`2419b8613a`](https://github.com/nodejs/node/commit/2419b8613a)] - **(SEMVER-MINOR)** **crypto**: make SignBase compatible with OpenSSL 1.1.0 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`0ef35a137f`](https://github.com/nodejs/node/commit/0ef35a137f)] - **(SEMVER-MINOR)** **crypto**: make Hash 1.1.0-compatible (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`e0cbc39668`](https://github.com/nodejs/node/commit/e0cbc39668)] - **(SEMVER-MINOR)** **crypto**: make CipherBase 1.1.0-compatible (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`e21079851f`](https://github.com/nodejs/node/commit/e21079851f)] - **(SEMVER-MINOR)** **crypto**: remove locking callbacks for OpenSSL 1.1.0 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`c2106e4037`](https://github.com/nodejs/node/commit/c2106e4037)] - **(SEMVER-MINOR)** **crypto**: use RSA and DH accessors (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`f518238c2e`](https://github.com/nodejs/node/commit/f518238c2e)] - **(SEMVER-MINOR)** **crypto**: test DH keys work without a public half (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`f00d758067`](https://github.com/nodejs/node/commit/f00d758067)] - **(SEMVER-MINOR)** **crypto**: account for new 1.1.0 SSL APIs (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`335bbff96d`](https://github.com/nodejs/node/commit/335bbff96d)] - **(SEMVER-MINOR)** **crypto**: remove unnecessary SSLerr calls (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`0f909a87a6`](https://github.com/nodejs/node/commit/0f909a87a6)] - **(SEMVER-MINOR)** **crypto**: estimate kExternalSize (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`ec349b4640`](https://github.com/nodejs/node/commit/ec349b4640)] - **(SEMVER-MINOR)** **crypto**: make node_crypto_bio compat w/ OpenSSL 1.1 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`e28e80d5b8`](https://github.com/nodejs/node/commit/e28e80d5b8)] - **(SEMVER-MINOR)** **crypto**: use X509_STORE_CTX_new (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`1279893a46`](https://github.com/nodejs/node/commit/1279893a46)] - **crypto**: add ocsp_request ClientHelloParser::Reset (Daniel Bevenius) [#17753](https://github.com/nodejs/node/pull/17753)
* [[`964850a24c`](https://github.com/nodejs/node/commit/964850a24c)] - **crypto**: warn on invalid authentication tag length (Tobias Nießen) [#17566](https://github.com/nodejs/node/pull/17566)
* [[`2f3d91dc58`](https://github.com/nodejs/node/commit/2f3d91dc58)] - **crypto**: remove unused header in clienthello.h (Daniel Bevenius) [#17752](https://github.com/nodejs/node/pull/17752)
* [[`1331a2a504`](https://github.com/nodejs/node/commit/1331a2a504)] - **(SEMVER-MINOR)** **deps**: upgrade libuv to 1.19.1 (cjihrig) [#18260](https://github.com/nodejs/node/pull/18260)
* [[`cae489657b`](https://github.com/nodejs/node/commit/cae489657b)] - **(SEMVER-MINOR)** **deps**: upgrade libuv to 1.18.0 (cjihrig) [#17282](https://github.com/nodejs/node/pull/17282)
* [[`1e316826ff`](https://github.com/nodejs/node/commit/1e316826ff)] - **(SEMVER-MINOR)** **deps**: revert ABI breaking changes in V8 6.1 (Anna Henningsen) [#15393](https://github.com/nodejs/node/pull/15393)
* [[`758b730139`](https://github.com/nodejs/node/commit/758b730139)] - **(SEMVER-MINOR)** **deps**: revert ABI breaking changes in V8 6.2 (Anna Henningsen) [#16413](https://github.com/nodejs/node/pull/16413)
* [[`2b84fa9514`](https://github.com/nodejs/node/commit/2b84fa9514)] - **deps**: cherry-pick c3458a8 from upstream V8 (Michaël Zasso) [#18060](https://github.com/nodejs/node/pull/18060)
* [[`aae68d3ef0`](https://github.com/nodejs/node/commit/aae68d3ef0)] - **deps**: V8: cherry-pick ac0fe8ec from upstream (Ali Ijaz Sheikh) [#17695](https://github.com/nodejs/node/pull/17695)
* [[`51ad36a901`](https://github.com/nodejs/node/commit/51ad36a901)] - **deps**: V8: backport 14ac02c from upstream (Ali Ijaz Sheikh) [#17512](https://github.com/nodejs/node/pull/17512)
* [[`0a064c4b68`](https://github.com/nodejs/node/commit/0a064c4b68)] - **deps**: backport 3c8195d from V8 upstream (Myles Borins) [#17383](https://github.com/nodejs/node/pull/17383)
* [[`0ee645510d`](https://github.com/nodejs/node/commit/0ee645510d)] - **deps**: cherry-pick 1420e44db0 from upstream V8 (Timothy Gu) [#17344](https://github.com/nodejs/node/pull/17344)
* [[`be734c513c`](https://github.com/nodejs/node/commit/be734c513c)] - **deps**: cherry-pick cc55747 from V8 upstream (Franziska Hinkelmann) [#16890](https://github.com/nodejs/node/pull/16890)
* [[`0e30ca942e`](https://github.com/nodejs/node/commit/0e30ca942e)] - **deps**: cherry-pick b8331cc030 from upstream V8 (Daniel Bevenius) [#16900](https://github.com/nodejs/node/pull/16900)
* [[`711f344c2e`](https://github.com/nodejs/node/commit/711f344c2e)] - **deps**: V8: backport b1cd96e from upstream (Ali Ijaz Sheikh) [#16308](https://github.com/nodejs/node/pull/16308)
* [[`ae8c838339`](https://github.com/nodejs/node/commit/ae8c838339)] - **deps**: cherry-pick e0d64dc from upstream V8 (Michaël Zasso) [#16490](https://github.com/nodejs/node/pull/16490)
* [[`5d80b0edd9`](https://github.com/nodejs/node/commit/5d80b0edd9)] - **deps**: cherry-pick 676c413 from upstream V8 (Michaël Zasso) [#16490](https://github.com/nodejs/node/pull/16490)
* [[`16a980b4c4`](https://github.com/nodejs/node/commit/16a980b4c4)] - **deps**: cherry-pick 2c75616 from upstream V8 (Michaël Zasso) [#16490](https://github.com/nodejs/node/pull/16490)
* [[`0b690a9ce3`](https://github.com/nodejs/node/commit/0b690a9ce3)] - **deps**: cherry-pick 37a3a15c3 from V8 upstream (Franziska Hinkelmann) [#16294](https://github.com/nodejs/node/pull/16294)
* [[`b71a33c2bf`](https://github.com/nodejs/node/commit/b71a33c2bf)] - **(SEMVER-MAJOR)** **deps**: backport 0f1dfae from V8 upstream (Tobias Tebbi) [#15362](https://github.com/nodejs/node/pull/15362)
* [[`ebee8edca2`](https://github.com/nodejs/node/commit/ebee8edca2)] - **deps**: v8: fix potential segfault in profiler (Ali Ijaz Sheikh) [#15498](https://github.com/nodejs/node/pull/15498)
* [[`a7fc12772d`](https://github.com/nodejs/node/commit/a7fc12772d)] - **deps**: cherry-pick 9b21865822243 from V8 upstream (Anna Henningsen) [#15391](https://github.com/nodejs/node/pull/15391)
* [[`bede7a3cfa`](https://github.com/nodejs/node/commit/bede7a3cfa)] - **(SEMVER-MINOR)** **deps**: update V8 to 6.2.414.46 (Michaël Zasso) [#16413](https://github.com/nodejs/node/pull/16413)
* [[`96f85e4d8b`](https://github.com/nodejs/node/commit/96f85e4d8b)] - **deps**: re land npm 5.6.0 (Myles Borins) [#18625](https://github.com/nodejs/node/pull/18625)
* [[`3a648b7e62`](https://github.com/nodejs/node/commit/3a648b7e62)] - **deps**: cherry-pick c3458a8 from upstream V8 (Michaël Zasso) [#18059](https://github.com/nodejs/node/pull/18059)
* [[`ce245810fa`](https://github.com/nodejs/node/commit/ce245810fa)] - **(SEMVER-MINOR)** **deps**: ICU 60 bump (Steven R. Loomis) [#16876](https://github.com/nodejs/node/pull/16876)
* [[`09c1f21746`](https://github.com/nodejs/node/commit/09c1f21746)] - **(SEMVER-MINOR)** **deps**: upgrade libuv to 1.16.1 (cjihrig) [#16835](https://github.com/nodejs/node/pull/16835)
* [[`35887306f1`](https://github.com/nodejs/node/commit/35887306f1)] - **dns**: fix crash while setting server during query (XadillaX) [#14891](https://github.com/nodejs/node/pull/14891)
* [[`0776a43123`](https://github.com/nodejs/node/commit/0776a43123)] - **doc**: add vdeturckheim as collaborator (vdeturckheim) [#18432](https://github.com/nodejs/node/pull/18432)
* [[`504054c8d5`](https://github.com/nodejs/node/commit/504054c8d5)] - **doc**: fix e.g., to e.g. in docs (sreepurnajasti) [#18369](https://github.com/nodejs/node/pull/18369)
* [[`5f381e843a`](https://github.com/nodejs/node/commit/5f381e843a)] - **doc**: fix return value for require.resolve.paths() (Peter Dalgaard-Jensen) [#18350](https://github.com/nodejs/node/pull/18350)
* [[`37531a4103`](https://github.com/nodejs/node/commit/37531a4103)] - **doc**: add missing word in modules.md (Robert Adamian) [#18343](https://github.com/nodejs/node/pull/18343)
* [[`477e7d1788`](https://github.com/nodejs/node/commit/477e7d1788)] - **doc**: add doc for performance.clearGC() (Antony Tran) [#18331](https://github.com/nodejs/node/pull/18331)
* [[`15c847e915`](https://github.com/nodejs/node/commit/15c847e915)] - **doc**: split CONTRIBUTING.md (Joyee Cheung) [#18271](https://github.com/nodejs/node/pull/18271)
* [[`850e5bab1f`](https://github.com/nodejs/node/commit/850e5bab1f)] - **doc**: fix typos in async_hooks (Matthew Turner) [#18314](https://github.com/nodejs/node/pull/18314)
* [[`af88c0fc26`](https://github.com/nodejs/node/commit/af88c0fc26)] - **doc**: add missing URL argument types in fs.md (Vse Mozhet Byt) [#18309](https://github.com/nodejs/node/pull/18309)
* [[`454a3d9870`](https://github.com/nodejs/node/commit/454a3d9870)] - **doc**: remove confusing signature in fs.md (Vse Mozhet Byt) [#18310](https://github.com/nodejs/node/pull/18310)
* [[`67b7ad3b67`](https://github.com/nodejs/node/commit/67b7ad3b67)] - **doc**: use PBKDF2 in text (Tobias Nießen) [#18279](https://github.com/nodejs/node/pull/18279)
* [[`78eb81447f`](https://github.com/nodejs/node/commit/78eb81447f)] - **doc**: fix typo in async_hooks.md (Matthew Turner) [#18286](https://github.com/nodejs/node/pull/18286)
* [[`d554b8a669`](https://github.com/nodejs/node/commit/d554b8a669)] - **doc**: Add example of null to assert.ifError (Leko) [#18236](https://github.com/nodejs/node/pull/18236)
* [[`bda8355530`](https://github.com/nodejs/node/commit/bda8355530)] - **doc**: improve process.platform (Mars Wong) [#18057](https://github.com/nodejs/node/pull/18057)
* [[`4c89666bdc`](https://github.com/nodejs/node/commit/4c89666bdc)] - **doc**: cjs format is now commonjs (Gus Caplan) [#18165](https://github.com/nodejs/node/pull/18165)
* [[`a4e8a929ca`](https://github.com/nodejs/node/commit/a4e8a929ca)] - **doc**: V8 branch used in 8.x not active anymore (Franziska Hinkelmann) [#18155](https://github.com/nodejs/node/pull/18155)
* [[`83915234ad`](https://github.com/nodejs/node/commit/83915234ad)] - **doc**: add change info for async_hooks.executionAsyncId() (Stephen Belanger) [#17813](https://github.com/nodejs/node/pull/17813)
* [[`896aa77eac`](https://github.com/nodejs/node/commit/896aa77eac)] - **doc**: add builtin module in building.md (Suixinlei) [#17705](https://github.com/nodejs/node/pull/17705)
* [[`5f1803be6c`](https://github.com/nodejs/node/commit/5f1803be6c)] - **doc**: warn users about non-ASCII paths on build (Matheus Marchini) [#16735](https://github.com/nodejs/node/pull/16735)
* [[`b52afa2844`](https://github.com/nodejs/node/commit/b52afa2844)] - **doc**: simplify sentences that use "considered" (Rich Trott) [#18095](https://github.com/nodejs/node/pull/18095)
* [[`299482cb74`](https://github.com/nodejs/node/commit/299482cb74)] - **doc**: update sample output for process.versions (Michael Dawson) [#18167](https://github.com/nodejs/node/pull/18167)
* [[`f7b48a3d08`](https://github.com/nodejs/node/commit/f7b48a3d08)] - **doc**: fix typo in TextEncoding section (Yosuke Furukawa) [#18201](https://github.com/nodejs/node/pull/18201)
* [[`afc528920b`](https://github.com/nodejs/node/commit/afc528920b)] - **doc**: suggest not to throw JS errors from C++ (Joyee Cheung) [#18149](https://github.com/nodejs/node/pull/18149)
* [[`5607f587b2`](https://github.com/nodejs/node/commit/5607f587b2)] - **doc**: add documentation for deprecation properties (Jon Moss) [#16539](https://github.com/nodejs/node/pull/16539)
* [[`98579decd7`](https://github.com/nodejs/node/commit/98579decd7)] - **doc**: prefer make test-only when verifying the build (Joyee Cheung) [#18061](https://github.com/nodejs/node/pull/18061)
* [[`f7e6fe29d3`](https://github.com/nodejs/node/commit/f7e6fe29d3)] - **doc**: add Leko to collaborators (Leko) [#18117](https://github.com/nodejs/node/pull/18117)
* [[`835573abd1`](https://github.com/nodejs/node/commit/835573abd1)] - **doc**: decapitalize primitive types (Vse Mozhet Byt) [#18110](https://github.com/nodejs/node/pull/18110)
* [[`08a2d7f299`](https://github.com/nodejs/node/commit/08a2d7f299)] - **doc**: be less tentative about undefined behavior (Rich Trott) [#18091](https://github.com/nodejs/node/pull/18091)
* [[`074add3ab3`](https://github.com/nodejs/node/commit/074add3ab3)] - **doc**: add descriptions of state properties (James M Snell) [#18044](https://github.com/nodejs/node/pull/18044)
* [[`3f801b37bc`](https://github.com/nodejs/node/commit/3f801b37bc)] - **doc**: examples for fast-tracking regression fixes (Refael Ackermann) [#17379](https://github.com/nodejs/node/pull/17379)
* [[`22ddc43d07`](https://github.com/nodejs/node/commit/22ddc43d07)] - **doc**: multiple updates to child_process.md (Rich Trott) [#17990](https://github.com/nodejs/node/pull/17990)
* [[`e49dd53a2c`](https://github.com/nodejs/node/commit/e49dd53a2c)] - **doc**: remove x86 from os.arch() options (Gibson Fahnestock) [#17899](https://github.com/nodejs/node/pull/17899)
* [[`b3ff0ed652`](https://github.com/nodejs/node/commit/b3ff0ed652)] - **doc**: fix incorrect argument type in fs.readSync (Mykola Bilochub) [#18022](https://github.com/nodejs/node/pull/18022)
* [[`50780c1748`](https://github.com/nodejs/node/commit/50780c1748)] - **doc**: move matthewloring to emeriti (Rich Trott) [#17998](https://github.com/nodejs/node/pull/17998)
* [[`e734e0a284`](https://github.com/nodejs/node/commit/e734e0a284)] - **doc**: move joshgav to TSC emeriti list (Rich Trott) [#17953](https://github.com/nodejs/node/pull/17953)
* [[`135bc61fff`](https://github.com/nodejs/node/commit/135bc61fff)] - **doc**: improve security section of README.md (Rich Trott) [#17929](https://github.com/nodejs/node/pull/17929)
* [[`532e85a749`](https://github.com/nodejs/node/commit/532e85a749)] - **doc**: edit for concision (Rich Trott) [#17891](https://github.com/nodejs/node/pull/17891)
* [[`d5c8a348ba`](https://github.com/nodejs/node/commit/d5c8a348ba)] - **doc**: improve PR-review paragraph in CONTRIBUTING.md (Rich Trott) [#17931](https://github.com/nodejs/node/pull/17931)
* [[`5e83150894`](https://github.com/nodejs/node/commit/5e83150894)] - **doc**: fix typos in CONTRIBUTING.md (Rich Trott) [#17930](https://github.com/nodejs/node/pull/17930)
* [[`fe36cd9227`](https://github.com/nodejs/node/commit/fe36cd9227)] - **doc**: copy-edit COLLABORATOR_GUIDE.md (Rich Trott) [#17922](https://github.com/nodejs/node/pull/17922)
* [[`4b8c579e7a`](https://github.com/nodejs/node/commit/4b8c579e7a)] - **doc**: improve alt text (Rich Trott) [#17922](https://github.com/nodejs/node/pull/17922)
* [[`ea0766ad08`](https://github.com/nodejs/node/commit/ea0766ad08)] - **doc**: fix spelling of contributors (Rich Trott) [#17922](https://github.com/nodejs/node/pull/17922)
* [[`68235da055`](https://github.com/nodejs/node/commit/68235da055)] - **doc**: add references to PR communication articles (Salame William) [#17902](https://github.com/nodejs/node/pull/17902)
* [[`90c5bd4857`](https://github.com/nodejs/node/commit/90c5bd4857)] - **doc**: replace wrong U+00A0 by common spaces (Vse Mozhet Byt) [#17940](https://github.com/nodejs/node/pull/17940)
* [[`6e841a3776`](https://github.com/nodejs/node/commit/6e841a3776)] - **doc**: remove duplicate words in API docs (Tobias Nießen) [#17937](https://github.com/nodejs/node/pull/17937)
* [[`f393eb1e81`](https://github.com/nodejs/node/commit/f393eb1e81)] - **doc**: fix duplicate words & spellings in docs (sreepurnajasti) [#17923](https://github.com/nodejs/node/pull/17923)
* [[`de85204208`](https://github.com/nodejs/node/commit/de85204208)] - **doc**: doc imitating the old behavior of http.Server.keepAliveTimeout (Tyson Andre) [#17660](https://github.com/nodejs/node/pull/17660)
* [[`1c2783b111`](https://github.com/nodejs/node/commit/1c2783b111)] - **doc**: fs doc improvements (James M Snell) [#17831](https://github.com/nodejs/node/pull/17831)
* [[`3ae37b22bb`](https://github.com/nodejs/node/commit/3ae37b22bb)] - **doc**: fix typo (Tobias Nießen) [#17900](https://github.com/nodejs/node/pull/17900)
* [[`7eb0215a97`](https://github.com/nodejs/node/commit/7eb0215a97)] - **doc**: use my legal name in README (Timothy Gu) [#17894](https://github.com/nodejs/node/pull/17894)
* [[`807612771f`](https://github.com/nodejs/node/commit/807612771f)] - **doc**: use dashes instead of asterisks (Ruben Bridgewater) [#17722](https://github.com/nodejs/node/pull/17722)
* [[`f154e767e9`](https://github.com/nodejs/node/commit/f154e767e9)] - **doc**: update AUTHORS list (Ruben Bridgewater) [#17805](https://github.com/nodejs/node/pull/17805)
* [[`9cf8df3283`](https://github.com/nodejs/node/commit/9cf8df3283)] - **doc**: add starkwang to collaborators (Weijia Wang) [#17847](https://github.com/nodejs/node/pull/17847)
* [[`4b6c182077`](https://github.com/nodejs/node/commit/4b6c182077)] - **doc**: improve fs api descriptions (Evan Lucas) [#17679](https://github.com/nodejs/node/pull/17679)
* [[`b121d51a06`](https://github.com/nodejs/node/commit/b121d51a06)] - **doc**: instructions on how to make membership public (Michael Dawson) [#17688](https://github.com/nodejs/node/pull/17688)
* [[`51f2dfcac6`](https://github.com/nodejs/node/commit/51f2dfcac6)] - **doc**: removed extra explanation in api/buffer.md (Waleed Ashraf) [#17796](https://github.com/nodejs/node/pull/17796)
* [[`673fdc60c6`](https://github.com/nodejs/node/commit/673fdc60c6)] - **doc**: use american spelling as per style guide (sreepurnajasti) [#17818](https://github.com/nodejs/node/pull/17818)
* [[`81cc0e73e3`](https://github.com/nodejs/node/commit/81cc0e73e3)] - **doc**: require CI status indicator in PRs (Nikolai Vavilov) [#17151](https://github.com/nodejs/node/pull/17151)
* [[`ceb7790d18`](https://github.com/nodejs/node/commit/ceb7790d18)] - **doc**: mark DEP0002 as end of life (Jon Moss) [#17815](https://github.com/nodejs/node/pull/17815)
* [[`ff03d2f9c6`](https://github.com/nodejs/node/commit/ff03d2f9c6)] - **doc**: remove duplicate the from onboarding.md (sreepurnajasti) [#17733](https://github.com/nodejs/node/pull/17733)
* [[`78c8c61dd7`](https://github.com/nodejs/node/commit/78c8c61dd7)] - **doc**: fix typo in README.md (Weijia Wang) [#17729](https://github.com/nodejs/node/pull/17729)
* [[`5b672af203`](https://github.com/nodejs/node/commit/5b672af203)] - **doc**: fix typo in child_process.md (Rich Trott) [#17727](https://github.com/nodejs/node/pull/17727)
* [[`762c1ecb81`](https://github.com/nodejs/node/commit/762c1ecb81)] - **doc**: edit CONTRIBUTING.md preamble (Rich Trott) [#17700](https://github.com/nodejs/node/pull/17700)
* [[`d1b224d493`](https://github.com/nodejs/node/commit/d1b224d493)] - **doc**: improve release guide (Evan Lucas) [#17677](https://github.com/nodejs/node/pull/17677)
* [[`98c83c68be`](https://github.com/nodejs/node/commit/98c83c68be)] - **doc**: not all example code can be run without 1:1 (Jeremiah Senkpiel) [#17702](https://github.com/nodejs/node/pull/17702)
* [[`87d504da2e`](https://github.com/nodejs/node/commit/87d504da2e)] - **doc**: adjust TTY wording & add inter-doc links (Jeremiah Senkpiel) [#17702](https://github.com/nodejs/node/pull/17702)
* [[`0ceed2c569`](https://github.com/nodejs/node/commit/0ceed2c569)] - **doc**: fix fs.existsSync description (Jeremiah Senkpiel) [#17702](https://github.com/nodejs/node/pull/17702)
* [[`02af31a7fc`](https://github.com/nodejs/node/commit/02af31a7fc)] - **doc**: improve documentation.md (Jeremiah Senkpiel) [#17702](https://github.com/nodejs/node/pull/17702)
* [[`2f35920c97`](https://github.com/nodejs/node/commit/2f35920c97)] - **doc**: add countdown module to writing tests guide (Bamieh) [#17201](https://github.com/nodejs/node/pull/17201)
* [[`7601bb0ba0`](https://github.com/nodejs/node/commit/7601bb0ba0)] - **doc**: change "Node.js style cb" to "error-first cb" (Ram Goli) [#17638](https://github.com/nodejs/node/pull/17638)
* [[`70daf95a11`](https://github.com/nodejs/node/commit/70daf95a11)] - **doc**: add C++ style comments to the style guide (Matheus Marchini) [#17617](https://github.com/nodejs/node/pull/17617)
* [[`8f9ea23a6d`](https://github.com/nodejs/node/commit/8f9ea23a6d)] - **doc**: include Daniel Bevenius as a TSC member (Rich Trott) [#17652](https://github.com/nodejs/node/pull/17652)
* [[`ca71b00bd4`](https://github.com/nodejs/node/commit/ca71b00bd4)] - **doc**: correct pbkdf2 salt length recommendation (Will Clark) [#17524](https://github.com/nodejs/node/pull/17524)
* [[`24e7753400`](https://github.com/nodejs/node/commit/24e7753400)] - **doc**: clearify promisify behavior for bad arguments (Ram Goli) [#17593](https://github.com/nodejs/node/pull/17593)
* [[`5422767039`](https://github.com/nodejs/node/commit/5422767039)] - **doc,test**: mention Duplex support for TLS (Anna Henningsen) [#17599](https://github.com/nodejs/node/pull/17599)
* [[`577933a7c6`](https://github.com/nodejs/node/commit/577933a7c6)] - **fs**: cleanup fd lchown and lchownSync (James M Snell) [#18329](https://github.com/nodejs/node/pull/18329)
* [[`b343cb60e1`](https://github.com/nodejs/node/commit/b343cb60e1)] - **fs**: fix options.end of fs.ReadStream() (陈刚) [#18121](https://github.com/nodejs/node/pull/18121)
* [[`a7f9e12aee`](https://github.com/nodejs/node/commit/a7f9e12aee)] - **gitignore**: ignore *.VC.db files (Tobias Nießen) [#17898](https://github.com/nodejs/node/pull/17898)
* [[`56401a45dc`](https://github.com/nodejs/node/commit/56401a45dc)] - **(SEMVER-MINOR)** **http**: add rawPacket in err of `clientError` event (XadillaX) [#17672](https://github.com/nodejs/node/pull/17672)
* [[`bc982f650f`](https://github.com/nodejs/node/commit/bc982f650f)] - **http**: remove duplicate export (Evan Lucas) [#17982](https://github.com/nodejs/node/pull/17982)
* [[`8da41434cf`](https://github.com/nodejs/node/commit/8da41434cf)] - **http**: remove adapter frame from onParserExecute (Ben Noordhuis) [#17693](https://github.com/nodejs/node/pull/17693)
* [[`949ace9524`](https://github.com/nodejs/node/commit/949ace9524)] - **(SEMVER-MINOR)** **http**: support generic `Duplex` streams (Anna Henningsen) [#16267](https://github.com/nodejs/node/pull/16267)
* [[`0fd051888a`](https://github.com/nodejs/node/commit/0fd051888a)] - **http, stream**: writeHWM -\> writableHighWaterMark (Matteo Collina) [#17050](https://github.com/nodejs/node/pull/17050)
* [[`6aa0adc26f`](https://github.com/nodejs/node/commit/6aa0adc26f)] - **http, tls**: better support for IPv6 addresses (Mattias Holmlund) [#14772](https://github.com/nodejs/node/pull/14772)
* [[`dea44b9697`](https://github.com/nodejs/node/commit/dea44b9697)] - **http2,perf_hooks**: perf state using AliasedBuffer (Kyle Farnung) [#18300](https://github.com/nodejs/node/pull/18300)
* [[`1cfc67c003`](https://github.com/nodejs/node/commit/1cfc67c003)] - **lib**: fix typo in trace_events_async_hooks.js (Gilles De Mey) [#18280](https://github.com/nodejs/node/pull/18280)
* [[`92defcc996`](https://github.com/nodejs/node/commit/92defcc996)] - **lib**: enable dot-notation eslint rule (Anatoli Papirovski) [#18007](https://github.com/nodejs/node/pull/18007)
* [[`c5093fceb5`](https://github.com/nodejs/node/commit/c5093fceb5)] - **(SEMVER-MINOR)** **module**: add builtinModules (Jon Moss) [#16386](https://github.com/nodejs/node/pull/16386)
* [[`aaca447333`](https://github.com/nodejs/node/commit/aaca447333)] - **module**: replace default paths in require.resolve() (cjihrig) [#17113](https://github.com/nodejs/node/pull/17113)
* [[`3d2d051ed0`](https://github.com/nodejs/node/commit/3d2d051ed0)] - **(SEMVER-MINOR)** **n-api**: add helper for addons to get the event loop (Anna Henningsen) [#17109](https://github.com/nodejs/node/pull/17109)
* [[`80468cc5dd`](https://github.com/nodejs/node/commit/80468cc5dd)] - **net**: remove ADDRCONFIG DNS hint on Windows (Bartosz Sosnowski) [#17662](https://github.com/nodejs/node/pull/17662)
* [[`fea710e36a`](https://github.com/nodejs/node/commit/fea710e36a)] - **path**: fix path.normalize for relative paths (Weijia Wang) [#17974](https://github.com/nodejs/node/pull/17974)
* [[`f99aba1f80`](https://github.com/nodejs/node/commit/f99aba1f80)] - **process**: fix reading zero-length env vars on win32 (Anna Henningsen) [#18463](https://github.com/nodejs/node/pull/18463)
* [[`3705e0e01c`](https://github.com/nodejs/node/commit/3705e0e01c)] - **process**: improve unhandled rejection message (Madara Uchiha) [#17158](https://github.com/nodejs/node/pull/17158)
* [[`bb5cafef55`](https://github.com/nodejs/node/commit/bb5cafef55)] - **repl**: fix coloring of `process.versions` (Ben Noordhuis) [#17861](https://github.com/nodejs/node/pull/17861)
* [[`d47cb9ab63`](https://github.com/nodejs/node/commit/d47cb9ab63)] - **src**: use uv_os_getpid() to get process id (cjihrig) [#17415](https://github.com/nodejs/node/pull/17415)
* [[`8a000e8f81`](https://github.com/nodejs/node/commit/8a000e8f81)] - **(SEMVER-MINOR)** **src**: add openssl-system-ca-path configure option (Daniel Bevenius) [#16790](https://github.com/nodejs/node/pull/16790)
* [[`fed8d30702`](https://github.com/nodejs/node/commit/fed8d30702)] - **(SEMVER-MINOR)** ***Revert*** "**src**: update NODE_MODULE_VERSION to 59" (Myles Borins) [#16413](https://github.com/nodejs/node/pull/16413)
* [[`aa4f58a9a5`](https://github.com/nodejs/node/commit/aa4f58a9a5)] - **(SEMVER-MAJOR)** **src**: fix rename of entry frame in v8abbr.h (geek) [#15362](https://github.com/nodejs/node/pull/15362)
* [[`805084b59d`](https://github.com/nodejs/node/commit/805084b59d)] - **(SEMVER-MAJOR)** **src**: update ustack offset identifiers (geek) [#15362](https://github.com/nodejs/node/pull/15362)
* [[`d3aa9eeb1d`](https://github.com/nodejs/node/commit/d3aa9eeb1d)] - **(SEMVER-MINOR)** **src**: update NODE_MODULE_VERSION to 59 (Michaël Zasso) [#16413](https://github.com/nodejs/node/pull/16413)
* [[`35a51d4a78`](https://github.com/nodejs/node/commit/35a51d4a78)] - **src**: remove nonexistent method from header file (Anna Henningsen) [#17748](https://github.com/nodejs/node/pull/17748)
* [[`0e204433f6`](https://github.com/nodejs/node/commit/0e204433f6)] - **src**: fix inspector nullptr deref on abrupt exit (Ben Noordhuis) [#17577](https://github.com/nodejs/node/pull/17577)
* [[`068d52d667`](https://github.com/nodejs/node/commit/068d52d667)] - **src**: use correct OOB check for IPv6 parsing (Anna Henningsen) [#17470](https://github.com/nodejs/node/pull/17470)
* [[`c2028fab23`](https://github.com/nodejs/node/commit/c2028fab23)] - **src**: make url host a proper C++ class (Anna Henningsen) [#17470](https://github.com/nodejs/node/pull/17470)
* [[`6c9bdc1652`](https://github.com/nodejs/node/commit/6c9bdc1652)] - **src**: move url internals into anonymous namespace (Anna Henningsen) [#17470](https://github.com/nodejs/node/pull/17470)
* [[`2c70965e82`](https://github.com/nodejs/node/commit/2c70965e82)] - **src**: minor cleanups to node_url.cc (Anna Henningsen) [#17470](https://github.com/nodejs/node/pull/17470)
* [[`089f18e3a1`](https://github.com/nodejs/node/commit/089f18e3a1)] - **src**: remove unused async hooks methods (Anna Henningsen) [#17757](https://github.com/nodejs/node/pull/17757)
* [[`e67448813f`](https://github.com/nodejs/node/commit/e67448813f)] - **src**: remove async_hooks destroy timer handle (Anna Henningsen) [#17117](https://github.com/nodejs/node/pull/17117)
* [[`bd47272bc9`](https://github.com/nodejs/node/commit/bd47272bc9)] - **src**: introduce internal C++ SetImmediate() mechanism (Anna Henningsen) [#17117](https://github.com/nodejs/node/pull/17117)
* [[`f276cd954e`](https://github.com/nodejs/node/commit/f276cd954e)] - **src**: rename async-wrap -\> async_wrap (Daniel Bevenius) [#17022](https://github.com/nodejs/node/pull/17022)
* [[`aa63e021d2`](https://github.com/nodejs/node/commit/aa63e021d2)] - **src**: use NODE_BUILTIN_MODULE_CONTEXT_AWARE() macro (Ben Noordhuis) [#17071](https://github.com/nodejs/node/pull/17071)
* [[`ace2c2fade`](https://github.com/nodejs/node/commit/ace2c2fade)] - **src**: use unique pointer for tracing_agent (Franziska Hinkelmann) [#17012](https://github.com/nodejs/node/pull/17012)
* [[`e71beba14f`](https://github.com/nodejs/node/commit/e71beba14f)] - **src**: explicitly register built-in modules (Yihong Wang) [#16565](https://github.com/nodejs/node/pull/16565)
* [[`fdd84c403e`](https://github.com/nodejs/node/commit/fdd84c403e)] - **(SEMVER-MINOR)** **src**: add helper for addons to get the event loop (Anna Henningsen) [#17109](https://github.com/nodejs/node/pull/17109)
* [[`22d4fef247`](https://github.com/nodejs/node/commit/22d4fef247)] - **(SEMVER-MINOR)** **src**: add process.ppid (cjihrig) [#16839](https://github.com/nodejs/node/pull/16839)
* [[`f52c2b9bce`](https://github.com/nodejs/node/commit/f52c2b9bce)] - **src**: use nullptr instead of NULL (Daniel Bevenius) [#17373](https://github.com/nodejs/node/pull/17373)
* [[`fdf9601a91`](https://github.com/nodejs/node/commit/fdf9601a91)] - **(SEMVER-MINOR)** **stream**: remove usage of *State.highWaterMark (Calvin Metcalf) [#12860](https://github.com/nodejs/node/pull/12860)
* [[`d629be2b8f`](https://github.com/nodejs/node/commit/d629be2b8f)] - **test**: change assert message to default (ryanmahan) [#18259](https://github.com/nodejs/node/pull/18259)
* [[`0e6cb3f16b`](https://github.com/nodejs/node/commit/0e6cb3f16b)] - **test**: use countdown timer (Mandeep Singh) [#17326](https://github.com/nodejs/node/pull/17326)
* [[`74d86ccd12`](https://github.com/nodejs/node/commit/74d86ccd12)] - **test**: make async-wrap-getasyncid parallelizable (Joyee Cheung) [#18245](https://github.com/nodejs/node/pull/18245)
* [[`9e79951855`](https://github.com/nodejs/node/commit/9e79951855)] - **test**: refactor test-http-parser (Jon Moss) [#18219](https://github.com/nodejs/node/pull/18219)
* [[`9c75a0fa47`](https://github.com/nodejs/node/commit/9c75a0fa47)] - **test**: remove trivial buffer imports (sreepurnajasti) [#18034](https://github.com/nodejs/node/pull/18034)
* [[`9f52d93c6c`](https://github.com/nodejs/node/commit/9f52d93c6c)] - **test**: use shorthand properties (Tobias Nießen) [#18105](https://github.com/nodejs/node/pull/18105)
* [[`5d66c20c7a`](https://github.com/nodejs/node/commit/5d66c20c7a)] - **test**: simplify loadDHParam in TLS test (Tobias Nießen) [#18103](https://github.com/nodejs/node/pull/18103)
* [[`58fbcabb5c`](https://github.com/nodejs/node/commit/58fbcabb5c)] - **test**: fix flaky cluster unix socket test (Ben Noordhuis) [#18263](https://github.com/nodejs/node/pull/18263)
* [[`15e07b8d22`](https://github.com/nodejs/node/commit/15e07b8d22)] - **test**: improve to use template string (sreepurnajasti) [#18097](https://github.com/nodejs/node/pull/18097)
* [[`80973ec6c3`](https://github.com/nodejs/node/commit/80973ec6c3)] - **test**: add common.crashOnUnhandledRejection to addons/callback-scope (Sho Miyamoto) [#18076](https://github.com/nodejs/node/pull/18076)
* [[`66a19cf3d6`](https://github.com/nodejs/node/commit/66a19cf3d6)] - **test**: use smaller input file for test-zlib.js (Rich Trott) [#17988](https://github.com/nodejs/node/pull/17988)
* [[`180a38ebb9`](https://github.com/nodejs/node/commit/180a38ebb9)] - **test**: move common.fires() to inspector-helper (Rich Trott) [#17401](https://github.com/nodejs/node/pull/17401)
* [[`474d7763d9`](https://github.com/nodejs/node/commit/474d7763d9)] - **test**: add common.skipIfEslintMissing (Myles Borins) [#18807](https://github.com/nodejs/node/pull/18807)
* [[`92a93c02c4`](https://github.com/nodejs/node/commit/92a93c02c4)] - **(SEMVER-MAJOR)** **test**: fix message test after V8 upgrade (Michaël Zasso) [#15362](https://github.com/nodejs/node/pull/15362)
* [[`92ec6f69c3`](https://github.com/nodejs/node/commit/92ec6f69c3)] - **(SEMVER-MINOR)** **test**: fix test-https-agent-session-eviction for 1.1 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`f883458270`](https://github.com/nodejs/node/commit/f883458270)] - **(SEMVER-MINOR)** **test**: configure certs in tests (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`20cc0cfe5f`](https://github.com/nodejs/node/commit/20cc0cfe5f)] - **(SEMVER-MINOR)** **test**: revise test-tls-econnreset for OpenSSL 1.1.0 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`a6a41d89e6`](https://github.com/nodejs/node/commit/a6a41d89e6)] - **(SEMVER-MINOR)** **test**: test with a larger RSA key (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`4b90576e5e`](https://github.com/nodejs/node/commit/4b90576e5e)] - **(SEMVER-MINOR)** **test**: remove sha from test expectations (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`de37b993e8`](https://github.com/nodejs/node/commit/de37b993e8)] - **(SEMVER-MINOR)** **test**: update test expectations for OpenSSL 1.1.0 (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)
* [[`51999d0965`](https://github.com/nodejs/node/commit/51999d0965)] - **test**: fix test-tls-server-verify.js on Windows CI (Rich Trott) [#18382](https://github.com/nodejs/node/pull/18382)
* [[`4746bbf1ce`](https://github.com/nodejs/node/commit/4746bbf1ce)] - **test**: mark test-inspector-stop-profile-after-done flaky (Myles Borins) [#18491](https://github.com/nodejs/node/pull/18491)
* [[`edcf9acf4e`](https://github.com/nodejs/node/commit/edcf9acf4e)] - **test**: fix flaky test-http-pipeline-flood (Anatoli Papirovski) [#17955](https://github.com/nodejs/node/pull/17955)
* [[`6597b2fd96`](https://github.com/nodejs/node/commit/6597b2fd96)] - **test**: rename regression tests (Tobias Nießen) [#17948](https://github.com/nodejs/node/pull/17948)
* [[`1474a47b80`](https://github.com/nodejs/node/commit/1474a47b80)] - **test**: fix flaky test-http-highwatermark (Anatoli Papirovski) [#17949](https://github.com/nodejs/node/pull/17949)
* [[`9fcf4d0de4`](https://github.com/nodejs/node/commit/9fcf4d0de4)] - **test**: fix flaky test-pipe-unref (Anatoli Papirovski) [#17950](https://github.com/nodejs/node/pull/17950)
* [[`5eadfc870f`](https://github.com/nodejs/node/commit/5eadfc870f)] - **test**: fix flaky http-writable-true-after-close (Anatoli Papirovski) [#17952](https://github.com/nodejs/node/pull/17952)
* [[`2e4fa26878`](https://github.com/nodejs/node/commit/2e4fa26878)] - **test**: improve readability of some crypto tests (Tobias Nießen) [#17904](https://github.com/nodejs/node/pull/17904)
* [[`8b3c23392c`](https://github.com/nodejs/node/commit/8b3c23392c)] - **test**: fix crypto test case to use correct encoding (Tobias Nießen) [#17956](https://github.com/nodejs/node/pull/17956)
* [[`8e38ad95a4`](https://github.com/nodejs/node/commit/8e38ad95a4)] - **test**: simplify test-buffer-slice.js (Weijia Wang) [#17962](https://github.com/nodejs/node/pull/17962)
* [[`d472704912`](https://github.com/nodejs/node/commit/d472704912)] - **test**: fix flaky test-resolve-async (Anatoli Papirovski) [#17957](https://github.com/nodejs/node/pull/17957)
* [[`f273c2945b`](https://github.com/nodejs/node/commit/f273c2945b)] - **test**: use countdown in test file (sreepurnajasti) [#17874](https://github.com/nodejs/node/pull/17874)
* [[`38f56cb436`](https://github.com/nodejs/node/commit/38f56cb436)] - **test**: improve to use template string (sreepurnajasti) [#17895](https://github.com/nodejs/node/pull/17895)
* [[`b69c710dec`](https://github.com/nodejs/node/commit/b69c710dec)] - **test**: fix flaky test-benchmark-fs (Rich Trott) [#17885](https://github.com/nodejs/node/pull/17885)
* [[`aff27a1b9d`](https://github.com/nodejs/node/commit/aff27a1b9d)] - **test**: make test-tls-invoke-queued use public API (Anna Henningsen) [#17864](https://github.com/nodejs/node/pull/17864)
* [[`05101e69ca`](https://github.com/nodejs/node/commit/05101e69ca)] - **test**: refactor test-tls-securepair-fiftharg (Anna Henningsen) [#17836](https://github.com/nodejs/node/pull/17836)
* [[`5485ad104d`](https://github.com/nodejs/node/commit/5485ad104d)] - **test**: reduce scope of variable in common module (Rich Trott) [#17830](https://github.com/nodejs/node/pull/17830)
* [[`d7f74dd53d`](https://github.com/nodejs/node/commit/d7f74dd53d)] - **test**: remove undefined function (Rich Trott) [#17845](https://github.com/nodejs/node/pull/17845)
* [[`e233f51976`](https://github.com/nodejs/node/commit/e233f51976)] - **test**: fix flaky test-benchmark-fs (Rich Trott) [#17853](https://github.com/nodejs/node/pull/17853)
* [[`59aa505825`](https://github.com/nodejs/node/commit/59aa505825)] - **test**: use common module API in test-child-process-exec-stdout-stderr-data-string (sreepurnajasti) [#17751](https://github.com/nodejs/node/pull/17751)
* [[`822e93e1d4`](https://github.com/nodejs/node/commit/822e93e1d4)] - **test**: refactor test-repl-definecommand (Rich Trott) [#17795](https://github.com/nodejs/node/pull/17795)
* [[`8c5fe7be4a`](https://github.com/nodejs/node/commit/8c5fe7be4a)] - **test**: improve flaky test-listen-fd-ebadf.js (Rich Trott) [#17797](https://github.com/nodejs/node/pull/17797)
* [[`96abea06c5`](https://github.com/nodejs/node/commit/96abea06c5)] - **test**: use valid authentication tag length (Tobias Nießen) [#17566](https://github.com/nodejs/node/pull/17566)
* [[`a5ada418c4`](https://github.com/nodejs/node/commit/a5ada418c4)] - **test**: do not open fixture files for writing (Rich Trott) [#17808](https://github.com/nodejs/node/pull/17808)
* [[`95cbf081e7`](https://github.com/nodejs/node/commit/95cbf081e7)] - **test**: do not open fixture files for writing (Rich Trott) [#17810](https://github.com/nodejs/node/pull/17810)
* [[`d3d0aaf116`](https://github.com/nodejs/node/commit/d3d0aaf116)] - **test**: fix typo in test-inspector-cluster-port-clash.js (Rich Trott) [#17782](https://github.com/nodejs/node/pull/17782)
* [[`e495981586`](https://github.com/nodejs/node/commit/e495981586)] - **test**: change callback function to arrow function (rt33) [#17734](https://github.com/nodejs/node/pull/17734)
* [[`9d4add2cd9`](https://github.com/nodejs/node/commit/9d4add2cd9)] - **test**: Use countdown in test file (sreepurnajasti) [#17646](https://github.com/nodejs/node/pull/17646)
* [[`6ed5773eb8`](https://github.com/nodejs/node/commit/6ed5773eb8)] - **test**: update test-http-content-length to use countdown (Bamieh) [#17201](https://github.com/nodejs/node/pull/17201)
* [[`21ec917152`](https://github.com/nodejs/node/commit/21ec917152)] - **test**: coverage for emitExperimentalWarning (Mithun Sasidharan) [#17635](https://github.com/nodejs/node/pull/17635)
* [[`535e76b84b`](https://github.com/nodejs/node/commit/535e76b84b)] - **test**: check socketOnDrain where needPause is false (Leko) [#17654](https://github.com/nodejs/node/pull/17654)
* [[`d4f355a679`](https://github.com/nodejs/node/commit/d4f355a679)] - **test**: change callback function to arrow function (routerman) [#17697](https://github.com/nodejs/node/pull/17697)
* [[`b8b0ed35b4`](https://github.com/nodejs/node/commit/b8b0ed35b4)] - **test**: change callback function to arrow function (you12724) [#17698](https://github.com/nodejs/node/pull/17698)
* [[`c81b8519a9`](https://github.com/nodejs/node/commit/c81b8519a9)] - **test**: change callback function to arrow function (Shinya Kanamaru) [#17699](https://github.com/nodejs/node/pull/17699)
* [[`d1c854f76d`](https://github.com/nodejs/node/commit/d1c854f76d)] - **test**: fix flaky test-benchmark-misc (Rich Trott) [#17686](https://github.com/nodejs/node/pull/17686)
* [[`98cc1fef94`](https://github.com/nodejs/node/commit/98cc1fef94)] - **test**: improve coverage for util.promisify (Mithun Sasidharan) [#17591](https://github.com/nodejs/node/pull/17591)
* [[`fcc5b99152`](https://github.com/nodejs/node/commit/fcc5b99152)] - **test**: fix flaky test-child-process-pass-fd (Rich Trott) [#17598](https://github.com/nodejs/node/pull/17598)
* [[`aada57b893`](https://github.com/nodejs/node/commit/aada57b893)] - **test**: add test description to fs.readFile tests (Jamie Davis) [#17610](https://github.com/nodejs/node/pull/17610)
* [[`337d93abe5`](https://github.com/nodejs/node/commit/337d93abe5)] - **test**: simplify common.expectsError (Ruben Bridgewater) [#17616](https://github.com/nodejs/node/pull/17616)
* [[`439112a91b`](https://github.com/nodejs/node/commit/439112a91b)] - **test**: fix test-cli-node-options on Windows (Anna Henningsen) [#16709](https://github.com/nodejs/node/pull/16709)
* [[`b5bc3f8eb8`](https://github.com/nodejs/node/commit/b5bc3f8eb8)] - **timers**: cross JS/C++ border less frequently (Anna Henningsen) [#17064](https://github.com/nodejs/node/pull/17064)
* [[`d2138b205c`](https://github.com/nodejs/node/commit/d2138b205c)] - **tls**: comment about old-style errors (xortiz) [#17759](https://github.com/nodejs/node/pull/17759)
* [[`30c607600b`](https://github.com/nodejs/node/commit/30c607600b)] - **tls**: unconsume stream on destroy (Anna Henningsen) [#17478](https://github.com/nodejs/node/pull/17478)
* [[`8250a5a8ba`](https://github.com/nodejs/node/commit/8250a5a8ba)] - **tools**: do not override V8's gitignore (Yang Guo) [#18010](https://github.com/nodejs/node/pull/18010)
* [[`990d22e073`](https://github.com/nodejs/node/commit/990d22e073)] - **tools**: fix AttributeError: \_\_exit\_\_ on Python 2.6 (Dmitriy Kasyanov) [#17663](https://github.com/nodejs/node/pull/17663)
* [[`f88afb42f3`](https://github.com/nodejs/node/commit/f88afb42f3)] - **tools**: autofixer for lowercase-name-for-primitive (Shobhit Chittora) [#17715](https://github.com/nodejs/node/pull/17715)
* [[`90fe1692e2`](https://github.com/nodejs/node/commit/90fe1692e2)] - **tools**: fix man pages linking regex (Diego Rodríguez Baquero) [#17724](https://github.com/nodejs/node/pull/17724)
* [[`0e37054c96`](https://github.com/nodejs/node/commit/0e37054c96)] - **tools**: add number-isnan rule (Jon Moss) [#17556](https://github.com/nodejs/node/pull/17556)
* [[`59def2a9f1`](https://github.com/nodejs/node/commit/59def2a9f1)] - **tools**: simplify lowercase-name-for-primitive rule (cjihrig) [#17653](https://github.com/nodejs/node/pull/17653)
* [[`dc480f84f9`](https://github.com/nodejs/node/commit/dc480f84f9)] - **tools**: add lowercase-name-for-primitive eslint rule (Weijia Wang) [#17568](https://github.com/nodejs/node/pull/17568)
* [[`47322e67c4`](https://github.com/nodejs/node/commit/47322e67c4)] - **tools**: add cpplint rule for NULL usage (Daniel Bevenius) [#17373](https://github.com/nodejs/node/pull/17373)
* [[`1d3d1ddce7`](https://github.com/nodejs/node/commit/1d3d1ddce7)] - **trace_events**: stop tracing agent in process.exit() (Andreas Madsen) [#18005](https://github.com/nodejs/node/pull/18005)
* [[`ae4428e967`](https://github.com/nodejs/node/commit/ae4428e967)] - **(SEMVER-MINOR)** **trace_events**: add executionAsyncId to init events (Andreas Madsen) [#17196](https://github.com/nodejs/node/pull/17196)
* [[`2a2c881df3`](https://github.com/nodejs/node/commit/2a2c881df3)] - **(SEMVER-MINOR)** **v8**: make building addons with VS2013 work again (Ben Noordhuis) [#16413](https://github.com/nodejs/node/pull/16413)
* [[`6df169c409`](https://github.com/nodejs/node/commit/6df169c409)] - **win, build**: fix without-intl option (Bartosz Sosnowski) [#17614](https://github.com/nodejs/node/pull/17614)

<a id="8.9.4"></a>
## 2018-01-02, Version 8.9.4 'Carbon' (LTS), @gibfahn

### Notable Changes

* **deps**:
  * upgrade npm to 5.6.0 (Kat Marchán) [#17535](https://github.com/nodejs/node/pull/17535)
* **build**:
  * configure can now be run from any directory (Gibson Fahnestock) [#17321](https://github.com/nodejs/node/pull/17321)

### Commits

* [[`62ad4cca07`](https://github.com/nodejs/node/commit/62ad4cca07)] - **tools/doc**: add tools/remark-\* to eslintignore (Ivan Wei) [#17240](https://github.com/nodejs/node/pull/17240)
* [[`ce91a38970`](https://github.com/nodejs/node/commit/ce91a38970)] - **benchmark**: fix http/simple.js benchmark (Anatoli Papirovski) [#17583](https://github.com/nodejs/node/pull/17583)
* [[`3fe7f9f102`](https://github.com/nodejs/node/commit/3fe7f9f102)] - **benchmark**: set maxHeaderListPairs in h2 headers.js (Anatoli Papirovski) [#17194](https://github.com/nodejs/node/pull/17194)
* [[`4597bd753a`](https://github.com/nodejs/node/commit/4597bd753a)] - **benchmark**: use unique filenames in fs benchmarks (Rich Trott) [#16776](https://github.com/nodejs/node/pull/16776)
* [[`92723701cd`](https://github.com/nodejs/node/commit/92723701cd)] - **benchmark,path**: remove unused variables (薛定谔的猫) [#15789](https://github.com/nodejs/node/pull/15789)
* [[`58a667c884`](https://github.com/nodejs/node/commit/58a667c884)] - **build**: add a `make help` option for common targets (Gibson Fahnestock) [#17323](https://github.com/nodejs/node/pull/17323)
* [[`5b04621c40`](https://github.com/nodejs/node/commit/5b04621c40)] - **build**: allow running configure from any directory (Gibson Fahnestock) [#17321](https://github.com/nodejs/node/pull/17321)
* [[`6ed330610a`](https://github.com/nodejs/node/commit/6ed330610a)] - **build**: define HAVE_OPENSSL macro for cctest (Matheus Marchini) [#17461](https://github.com/nodejs/node/pull/17461)
* [[`2e6f96e15d`](https://github.com/nodejs/node/commit/2e6f96e15d)] - **build**: add serial commas to messages in configure script (Rich Trott) [#17464](https://github.com/nodejs/node/pull/17464)
* [[`1802f3f8fc`](https://github.com/nodejs/node/commit/1802f3f8fc)] - **build**: fix test-v8 target (Michaël Zasso) [#17269](https://github.com/nodejs/node/pull/17269)
* [[`337d2b9972`](https://github.com/nodejs/node/commit/337d2b9972)] - **build**: add make lint-js-fix (Joyee Cheung) [#17283](https://github.com/nodejs/node/pull/17283)
* [[`134bbd8f30`](https://github.com/nodejs/node/commit/134bbd8f30)] - **build**: fix bsd build with gcc (Matheus Marchini) [#16737](https://github.com/nodejs/node/pull/16737)
* [[`bacbdc968d`](https://github.com/nodejs/node/commit/bacbdc968d)] - **build**: remove empty VCLibrarianTool entry (Daniel Bevenius) [#17191](https://github.com/nodejs/node/pull/17191)
* [[`2c891412b2`](https://github.com/nodejs/node/commit/2c891412b2)] - **build**: Allow linking against an external copy of nghttp2. (Ed Schouten) [#16788](https://github.com/nodejs/node/pull/16788)
* [[`1941d0a405`](https://github.com/nodejs/node/commit/1941d0a405)] - **build**: do not build doc in source tarball (Joyee Cheung) [#17100](https://github.com/nodejs/node/pull/17100)
* [[`792eee9803`](https://github.com/nodejs/node/commit/792eee9803)] - **build**: minor corrections to configure descriptions (Daniel Bevenius) [#17094](https://github.com/nodejs/node/pull/17094)
* [[`3036b36b76`](https://github.com/nodejs/node/commit/3036b36b76)] - **build**: enforce order of dependency when building addons (Joyee Cheung) [#17048](https://github.com/nodejs/node/pull/17048)
* [[`2f708c172f`](https://github.com/nodejs/node/commit/2f708c172f)] - **build**: fix cctest target --with-dtrace (Daniel Bevenius) [#17039](https://github.com/nodejs/node/pull/17039)
* [[`9532e982dc`](https://github.com/nodejs/node/commit/9532e982dc)] - **build**: prevent echoing of recipes for test target (Daniel Bevenius) [#17010](https://github.com/nodejs/node/pull/17010)
* [[`73eab91c8e`](https://github.com/nodejs/node/commit/73eab91c8e)] - **build**: fix cctest compilation (Daniel Bevenius) [#16887](https://github.com/nodejs/node/pull/16887)
* [[`811892edf0`](https://github.com/nodejs/node/commit/811892edf0)] - **build,win**: vcbuild refactoring call configure (Refael Ackermann) [#17299](https://github.com/nodejs/node/pull/17299)
* [[`54f6b294a1`](https://github.com/nodejs/node/commit/54f6b294a1)] - **crypto**: use SetNull instead of Set (Daniel Bevenius) [#17521](https://github.com/nodejs/node/pull/17521)
* [[`000be870e0`](https://github.com/nodejs/node/commit/000be870e0)] - **crypto**: make createXYZ inlineable (Matteo Collina) [#16067](https://github.com/nodejs/node/pull/16067)
* [[`13e853fb68`](https://github.com/nodejs/node/commit/13e853fb68)] - **deps**: upgrade npm to 5.6.0 (Kat Marchán) [#17535](https://github.com/nodejs/node/pull/17535)
* [[`c57cd9bf8b`](https://github.com/nodejs/node/commit/c57cd9bf8b)] - **deps**: V8: cherry-pick cfc3404f from upstream (Ali Ijaz Sheikh) [#17354](https://github.com/nodejs/node/pull/17354)
* [[`f34ee5c954`](https://github.com/nodejs/node/commit/f34ee5c954)] - **deps**: V8: backport 14ac02c from upstream (Ali Ijaz Sheikh) [#17512](https://github.com/nodejs/node/pull/17512)
* [[`5076cf3de7`](https://github.com/nodejs/node/commit/5076cf3de7)] - **doc**: use "JavaScript" instead of "Javascript" (Rich Trott) [#17163](https://github.com/nodejs/node/pull/17163)
* [[`81afb5c4c7`](https://github.com/nodejs/node/commit/81afb5c4c7)] - **doc**: prepare for v8/V8 linting in doc text (Rich Trott) [#17163](https://github.com/nodejs/node/pull/17163)
* [[`772ad878be`](https://github.com/nodejs/node/commit/772ad878be)] - **doc**: add capitalization styling to STYLE_GUIDE (Rich Trott) [#17163](https://github.com/nodejs/node/pull/17163)
* [[`9a06d988fd`](https://github.com/nodejs/node/commit/9a06d988fd)] - **doc**: make error descriptions more concise (Rich Trott) [#16954](https://github.com/nodejs/node/pull/16954)
* [[`d85a63546c`](https://github.com/nodejs/node/commit/d85a63546c)] - **doc**: fix modules.md export example (Anatoli Papirovski) [#17579](https://github.com/nodejs/node/pull/17579)
* [[`08220a309e`](https://github.com/nodejs/node/commit/08220a309e)] - **doc**: add link to debugger in process.md (Delapouite) [#17522](https://github.com/nodejs/node/pull/17522)
* [[`26e0fa8979`](https://github.com/nodejs/node/commit/26e0fa8979)] - **doc**: simplify and clarify FIPS text in BUILDING.md (Rich Trott) [#17538](https://github.com/nodejs/node/pull/17538)
* [[`f36ba1adca`](https://github.com/nodejs/node/commit/f36ba1adca)] - **doc**: esm loader example with module.builtinModules (Guy Bedford) [#17385](https://github.com/nodejs/node/pull/17385)
* [[`545c526b4e`](https://github.com/nodejs/node/commit/545c526b4e)] - **doc**: 'constructor' implies use of new keyword (Cameron Moorehead) [#17364](https://github.com/nodejs/node/pull/17364)
* [[`e53691c208`](https://github.com/nodejs/node/commit/e53691c208)] - **doc**: add "Hello world" example for N-API (Franziska Hinkelmann) [#17425](https://github.com/nodejs/node/pull/17425)
* [[`ce4a49ee7a`](https://github.com/nodejs/node/commit/ce4a49ee7a)] - **doc**: immprove inode text in fs.md (Rich Trott) [#17519](https://github.com/nodejs/node/pull/17519)
* [[`e7c1578768`](https://github.com/nodejs/node/commit/e7c1578768)] - **doc**: improve text for Console constructor (Rich Trott) [#17519](https://github.com/nodejs/node/pull/17519)
* [[`820d97b0ed`](https://github.com/nodejs/node/commit/820d97b0ed)] - **doc**: improve readability of README.md (Rich Trott) [#17519](https://github.com/nodejs/node/pull/17519)
* [[`29cda14049`](https://github.com/nodejs/node/commit/29cda14049)] - **doc**: improve readability of COLLABORATOR_GUIDE.md (Rich Trott) [#17519](https://github.com/nodejs/node/pull/17519)
* [[`9390ad1a65`](https://github.com/nodejs/node/commit/9390ad1a65)] - **doc**: add info on post-publishing ARM6 builds (Michael Dawson) [#17455](https://github.com/nodejs/node/pull/17455)
* [[`418ee1c13a`](https://github.com/nodejs/node/commit/418ee1c13a)] - **doc**: mention node-test-pull-request-lite job (Jon Moss) [#17513](https://github.com/nodejs/node/pull/17513)
* [[`2c327c6c68`](https://github.com/nodejs/node/commit/2c327c6c68)] - **doc**: fix typo in repl.md (Rich Trott) [#17502](https://github.com/nodejs/node/pull/17502)
* [[`07735b9fc2`](https://github.com/nodejs/node/commit/07735b9fc2)] - **doc**: fix common typo involving one-time listeners (Rich Trott) [#17502](https://github.com/nodejs/node/pull/17502)
* [[`25d7b8a4af`](https://github.com/nodejs/node/commit/25d7b8a4af)] - **doc**: fix typo in dns.md (Rich Trott) [#17502](https://github.com/nodejs/node/pull/17502)
* [[`4d826f09c1`](https://github.com/nodejs/node/commit/4d826f09c1)] - **doc**: remove unused link reference (Anatoli Papirovski) [#17510](https://github.com/nodejs/node/pull/17510)
* [[`8767acb401`](https://github.com/nodejs/node/commit/8767acb401)] - **doc**: remove IPC channel implementation details (Bartosz Sosnowski) [#17460](https://github.com/nodejs/node/pull/17460)
* [[`b49dfeed7b`](https://github.com/nodejs/node/commit/b49dfeed7b)] - **doc**: update AUTHORS list (Michaël Zasso) [#17452](https://github.com/nodejs/node/pull/17452)
* [[`9519616564`](https://github.com/nodejs/node/commit/9519616564)] - **doc**: use serial comma in tls.md (Rich Trott) [#17464](https://github.com/nodejs/node/pull/17464)
* [[`4667de8aac`](https://github.com/nodejs/node/commit/4667de8aac)] - **doc**: add serial comma in CPP_STYLE_GUIDE.md (Rich Trott) [#17464](https://github.com/nodejs/node/pull/17464)
* [[`bc9a490f54`](https://github.com/nodejs/node/commit/bc9a490f54)] - **doc**: edit module introduction (Rich Trott) [#17463](https://github.com/nodejs/node/pull/17463)
* [[`9b7168f3cb`](https://github.com/nodejs/node/commit/9b7168f3cb)] - **doc**: standardize preposition usage in fs.md (Rich Trott) [#17463](https://github.com/nodejs/node/pull/17463)
* [[`cfaba6b0ba`](https://github.com/nodejs/node/commit/cfaba6b0ba)] - **doc**: improve punctuation in fs.open() text (Rich Trott) [#17463](https://github.com/nodejs/node/pull/17463)
* [[`0d7dca5858`](https://github.com/nodejs/node/commit/0d7dca5858)] - **doc**: use colon consistently in assert.md (Rich Trott) [#17463](https://github.com/nodejs/node/pull/17463)
* [[`cb262d284e`](https://github.com/nodejs/node/commit/cb262d284e)] - **doc**: update example in module registration (Franziska Hinkelmann) [#17424](https://github.com/nodejs/node/pull/17424)
* [[`43215c6c3c`](https://github.com/nodejs/node/commit/43215c6c3c)] - **doc**: introduce categories to Cpp style guide (Franziska Hinkelmann) [#17095](https://github.com/nodejs/node/pull/17095)
* [[`afd001b29b`](https://github.com/nodejs/node/commit/afd001b29b)] - **doc**: add missing serial commas (Rich Trott) [#17384](https://github.com/nodejs/node/pull/17384)
* [[`aa45aa4a90`](https://github.com/nodejs/node/commit/aa45aa4a90)] - **doc**: be concise about serial commas (Rich Trott) [#17384](https://github.com/nodejs/node/pull/17384)
* [[`a3d218dafb`](https://github.com/nodejs/node/commit/a3d218dafb)] - **doc**: document tls.checkServerIdentity (Hannes Magnusson) [#17203](https://github.com/nodejs/node/pull/17203)
* [[`e786fde2a5`](https://github.com/nodejs/node/commit/e786fde2a5)] - **doc**: improve checkServerIdentity docs (Hannes Magnusson) [#17203](https://github.com/nodejs/node/pull/17203)
* [[`b18cd4e8b1`](https://github.com/nodejs/node/commit/b18cd4e8b1)] - **doc**: add guide to maintaining npm (Myles Borins) [#16541](https://github.com/nodejs/node/pull/16541)
* [[`3690d73901`](https://github.com/nodejs/node/commit/3690d73901)] - **doc**: fix doc example for cctest (Matheus Marchini) [#17355](https://github.com/nodejs/node/pull/17355)
* [[`0605f01b05`](https://github.com/nodejs/node/commit/0605f01b05)] - **doc**: clarify fast-track of reversions (Refael Ackermann) [#17332](https://github.com/nodejs/node/pull/17332)
* [[`2ceecce725`](https://github.com/nodejs/node/commit/2ceecce725)] - **doc**: fix typo in stream.md (Matthew Leon) [#17357](https://github.com/nodejs/node/pull/17357)
* [[`5d1b76c1bd`](https://github.com/nodejs/node/commit/5d1b76c1bd)] - **doc**: non-partitioned async crypto operations (Jamie Davis) [#17250](https://github.com/nodejs/node/pull/17250)
* [[`04732f1bdf`](https://github.com/nodejs/node/commit/04732f1bdf)] - **doc**: move Code of Conduct to admin repo (Myles Borins) [#17301](https://github.com/nodejs/node/pull/17301)
* [[`f1b4c4b2ee`](https://github.com/nodejs/node/commit/f1b4c4b2ee)] - **doc**: fix typo occuring -\> occurring (Leko) [#17350](https://github.com/nodejs/node/pull/17350)
* [[`3043d1573c`](https://github.com/nodejs/node/commit/3043d1573c)] - **doc**: Add link for ECMAScript 2015 (smatsu-hl) [#17317](https://github.com/nodejs/node/pull/17317)
* [[`3efa621878`](https://github.com/nodejs/node/commit/3efa621878)] - **doc**: caution against removing pseudoheaders (James M Snell) [#17329](https://github.com/nodejs/node/pull/17329)
* [[`7b7ab9cfb3`](https://github.com/nodejs/node/commit/7b7ab9cfb3)] - **doc**: replace string with template string (Leko) [#17316](https://github.com/nodejs/node/pull/17316)
* [[`1289cbd09d`](https://github.com/nodejs/node/commit/1289cbd09d)] - **doc**: replace function with arrow function in vm.md (narirou) [#17307](https://github.com/nodejs/node/pull/17307)
* [[`891e469490`](https://github.com/nodejs/node/commit/891e469490)] - **doc**: replace function with arrow function (Leko) [#17304](https://github.com/nodejs/node/pull/17304)
* [[`ceab92804d`](https://github.com/nodejs/node/commit/ceab92804d)] - **doc**: fix typo in api doc of url.format(urlObject) (pkovacs) [#17295](https://github.com/nodejs/node/pull/17295)
* [[`cd3defe124`](https://github.com/nodejs/node/commit/cd3defe124)] - **doc**: add ES Modules entry to who-to-cc (Rich Trott) [#17205](https://github.com/nodejs/node/pull/17205)
* [[`64b7398daf`](https://github.com/nodejs/node/commit/64b7398daf)] - **doc**: add maclover7 to collaborators (Jon Moss) [#17289](https://github.com/nodejs/node/pull/17289)
* [[`092aa6079a`](https://github.com/nodejs/node/commit/092aa6079a)] - **doc**: update http URLs to https in README.md (Ronald Eddy Jr) [#17264](https://github.com/nodejs/node/pull/17264)
* [[`342a291bd0`](https://github.com/nodejs/node/commit/342a291bd0)] - **doc**: update http URLs to https in doc/api (Ronald Eddy Jr) [#17263](https://github.com/nodejs/node/pull/17263)
* [[`c1db3a2507`](https://github.com/nodejs/node/commit/c1db3a2507)] - **doc**: update http URLs to https in GOVERNANCE.md (Ronald Eddy Jr) [#17262](https://github.com/nodejs/node/pull/17262)
* [[`5fe370cc99`](https://github.com/nodejs/node/commit/5fe370cc99)] - **doc**: update http URLs to https in CONTRIBUTING.md (Ronald Eddy Jr) [#17261](https://github.com/nodejs/node/pull/17261)
* [[`36f5f13bb2`](https://github.com/nodejs/node/commit/36f5f13bb2)] - **doc**: add SharedArrayBuffer to Buffer documentation (Thomas den Hollander) [#15489](https://github.com/nodejs/node/pull/15489)
* [[`1b689fb2a1`](https://github.com/nodejs/node/commit/1b689fb2a1)] - **doc**: document resolve hook formats (Lucas Azzola) [#16375](https://github.com/nodejs/node/pull/16375)
* [[`ec1a35c6b6`](https://github.com/nodejs/node/commit/ec1a35c6b6)] - **doc**: fs.readFile is async but not partitioned (Jamie Davis) [#17154](https://github.com/nodejs/node/pull/17154)
* [[`eb041a0cec`](https://github.com/nodejs/node/commit/eb041a0cec)] - **doc**: use better terminology for build machines (Anna Henningsen) [#17142](https://github.com/nodejs/node/pull/17142)
* [[`fef966f4c0`](https://github.com/nodejs/node/commit/fef966f4c0)] - **doc**: update mgol in AUTHORS.txt, add to .mailmap (Michał Gołębiowski-Owczarek) [#17239](https://github.com/nodejs/node/pull/17239)
* [[`38a78f4010`](https://github.com/nodejs/node/commit/38a78f4010)] - **doc**: update release table in V8 guide (Ali Ijaz Sheikh) [#17136](https://github.com/nodejs/node/pull/17136)
* [[`641fae08e6`](https://github.com/nodejs/node/commit/641fae08e6)] - **doc**: add guybedford to collaborators (Guy Bedford) [#17197](https://github.com/nodejs/node/pull/17197)
* [[`c67bab338e`](https://github.com/nodejs/node/commit/c67bab338e)] - **doc**: update AUTHORS list (Michaël Zasso) [#16571](https://github.com/nodejs/node/pull/16571)
* [[`017a75bcdf`](https://github.com/nodejs/node/commit/017a75bcdf)] - **doc**: normalize ToC indentation with heading levels in README (Rich Trott) [#17106](https://github.com/nodejs/node/pull/17106)
* [[`214959320f`](https://github.com/nodejs/node/commit/214959320f)] - **doc**: add Contributing to Node.js to the README ToC (Rich Trott) [#17106](https://github.com/nodejs/node/pull/17106)
* [[`738261499f`](https://github.com/nodejs/node/commit/738261499f)] - **doc**: merge Working Groups with Contributing to Node.js in README (Rich Trott) [#17106](https://github.com/nodejs/node/pull/17106)
* [[`b9d51b8e9c`](https://github.com/nodejs/node/commit/b9d51b8e9c)] - **doc**: remove IRC node-dev link from README (Rich Trott) [#17106](https://github.com/nodejs/node/pull/17106)
* [[`d6e02867c8`](https://github.com/nodejs/node/commit/d6e02867c8)] - **doc**: add missing introduced_in comments (Luigi Pinca) [#16741](https://github.com/nodejs/node/pull/16741)
* [[`7ecaa1b849`](https://github.com/nodejs/node/commit/7ecaa1b849)] - **doc**: change v8 to V8 (Rich Trott) [#17089](https://github.com/nodejs/node/pull/17089)
* [[`58d986f2ad`](https://github.com/nodejs/node/commit/58d986f2ad)] - **doc**: avoid mentioning 'uncaughtException' (Luigi Pinca) [#16905](https://github.com/nodejs/node/pull/16905)
* [[`7ee9d69888`](https://github.com/nodejs/node/commit/7ee9d69888)] - **doc**: add note about using cluster without networking (pimlie) [#17031](https://github.com/nodejs/node/pull/17031)
* [[`9e28f6f546`](https://github.com/nodejs/node/commit/9e28f6f546)] - **doc**: explicitly document highWaterMark option (Sebastian Silbermann) [#17049](https://github.com/nodejs/node/pull/17049)
* [[`21a017fb9b`](https://github.com/nodejs/node/commit/21a017fb9b)] - **doc**: fix a link in dgram.md (Vse Mozhet Byt) [#17107](https://github.com/nodejs/node/pull/17107)
* [[`3b524cf510`](https://github.com/nodejs/node/commit/3b524cf510)] - **doc**: reorganize collaborator guide (Joyee Cheung) [#17056](https://github.com/nodejs/node/pull/17056)
* [[`2145b3734d`](https://github.com/nodejs/node/commit/2145b3734d)] - **doc**: delete unused definition in README.md (Vse Mozhet Byt) [#17108](https://github.com/nodejs/node/pull/17108)
* [[`f67c0bfac0`](https://github.com/nodejs/node/commit/f67c0bfac0)] - **doc**: add Support section in README (Rich Trott) [#16533](https://github.com/nodejs/node/pull/16533)
* [[`010a3309a6`](https://github.com/nodejs/node/commit/010a3309a6)] - **doc**: document common pattern for instanceof checks (Michael Dawson) [#16699](https://github.com/nodejs/node/pull/16699)
* [[`706aab9d91`](https://github.com/nodejs/node/commit/706aab9d91)] - **doc**: mention smart pointers in Cpp style guide (Franziska Hinkelmann) [#17055](https://github.com/nodejs/node/pull/17055)
* [[`6b99323ceb`](https://github.com/nodejs/node/commit/6b99323ceb)] - **doc**: add Table of Contents to Cpp style guide (Franziska Hinkelmann) [#17052](https://github.com/nodejs/node/pull/17052)
* [[`996108cb14`](https://github.com/nodejs/node/commit/996108cb14)] - **doc**: add hashseed to collaborators (Yang Guo) [#16863](https://github.com/nodejs/node/pull/16863)
* [[`8622353c68`](https://github.com/nodejs/node/commit/8622353c68)] - **doc**: make stream.Readable consistent (Sakthipriyan Vairamani (thefourtheye)) [#16786](https://github.com/nodejs/node/pull/16786)
* [[`58cd649146`](https://github.com/nodejs/node/commit/58cd649146)] - **doc**: correct effects to affects (gowpen) [#16794](https://github.com/nodejs/node/pull/16794)
* [[`24178ac002`](https://github.com/nodejs/node/commit/24178ac002)] - **doc**: correct EventEmitter reference (gowpen) [#16791](https://github.com/nodejs/node/pull/16791)
* [[`b8561c2261`](https://github.com/nodejs/node/commit/b8561c2261)] - **doc**: fix a typo in n-api documentation (Vipin Menon) [#16879](https://github.com/nodejs/node/pull/16879)
* [[`4ede5eceb7`](https://github.com/nodejs/node/commit/4ede5eceb7)] - **doc**: fix typos in N-API (Swathi Kalahastri) [#16911](https://github.com/nodejs/node/pull/16911)
* [[`f1de0da7b9`](https://github.com/nodejs/node/commit/f1de0da7b9)] - **doc,test**: remove unnecessary await with return instances (Rich Trott) [#17265](https://github.com/nodejs/node/pull/17265)
* [[`97d9be555a`](https://github.com/nodejs/node/commit/97d9be555a)] - **doc,win**: clarify WSL support (João Reis) [#17008](https://github.com/nodejs/node/pull/17008)
* [[`20b40d154f`](https://github.com/nodejs/node/commit/20b40d154f)] - **errors,tools**: ASCIIbetical instead of alphabetical (Refael Ackermann) [#15578](https://github.com/nodejs/node/pull/15578)
* [[`b413e0920e`](https://github.com/nodejs/node/commit/b413e0920e)] - **fs**: use arrow functions instead of `.bind` and `self` (Weijia Wang) [#17137](https://github.com/nodejs/node/pull/17137)
* [[`63a35133f9`](https://github.com/nodejs/node/commit/63a35133f9)] - **http**: do not assign intermediate variable (Jon Moss) [#17335](https://github.com/nodejs/node/pull/17335)
* [[`673e2637f8`](https://github.com/nodejs/node/commit/673e2637f8)] - **http2**: use more descriptive names (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`9fd0b32c38`](https://github.com/nodejs/node/commit/9fd0b32c38)] - **http2**: remove unnecessary event handlers (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`31cdbd636a`](https://github.com/nodejs/node/commit/31cdbd636a)] - **http2**: reduce code duplication in settings (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`bdcbe81ad0`](https://github.com/nodejs/node/commit/bdcbe81ad0)] - **http2**: general cleanups (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`4b43e52f1a`](https://github.com/nodejs/node/commit/4b43e52f1a)] - **inspector**: no async tracking for promises (Anna Henningsen) [#17118](https://github.com/nodejs/node/pull/17118)
* [[`bf123f3dc2`](https://github.com/nodejs/node/commit/bf123f3dc2)] - **inspector**: include node_platform.h header (Alexey Kuzmin) [#16677](https://github.com/nodejs/node/pull/16677)
* [[`e6a568b49d`](https://github.com/nodejs/node/commit/e6a568b49d)] - **internal**: add emitExperimentalWarning function (Cody Deckard) [#16497](https://github.com/nodejs/node/pull/16497)
* [[`5d06a4f907`](https://github.com/nodejs/node/commit/5d06a4f907)] - **lib**: replace string concatenation with template (Vijayalakshmi Kannan) [#16923](https://github.com/nodejs/node/pull/16923)
* [[`c3fdef7469`](https://github.com/nodejs/node/commit/c3fdef7469)] - **module**: fix for #17130 shared loader cjs dep (Guy Bedford) [#17131](https://github.com/nodejs/node/pull/17131)
* [[`371e3f1f0b`](https://github.com/nodejs/node/commit/371e3f1f0b)] - **module**: be lazy when creating CJS facades (Bradley Farias) [#17153](https://github.com/nodejs/node/pull/17153)
* [[`b0da03bdf1`](https://github.com/nodejs/node/commit/b0da03bdf1)] - **n-api**: use nullptr instead of NULL in node_api.cc (Daniel Bevenius) [#17276](https://github.com/nodejs/node/pull/17276)
* [[`2e1e166139`](https://github.com/nodejs/node/commit/2e1e166139)] - **path**: remove obsolete comment (Rich Trott) [#17023](https://github.com/nodejs/node/pull/17023)
* [[`6deae6e4c0`](https://github.com/nodejs/node/commit/6deae6e4c0)] - **repl**: remove internal frames from runtime errors (Lance Ball) [#15351](https://github.com/nodejs/node/pull/15351)
* [[`3f2d3b388b`](https://github.com/nodejs/node/commit/3f2d3b388b)] - **src**: remove unused include node_crypto_clienthello (Daniel Bevenius) [#17546](https://github.com/nodejs/node/pull/17546)
* [[`28a81ce102`](https://github.com/nodejs/node/commit/28a81ce102)] - **src**: fix missing handlescope bug in inspector (Ben Noordhuis) [#17539](https://github.com/nodejs/node/pull/17539)
* [[`c78559eb83`](https://github.com/nodejs/node/commit/c78559eb83)] - **src**: node_http2_state.h should not be executable (Jon Moss) [#17408](https://github.com/nodejs/node/pull/17408)
* [[`3c8bdd9652`](https://github.com/nodejs/node/commit/3c8bdd9652)] - **src**: fix typo in NODE_OPTIONS whitelist (Evan Lucas) [#17369](https://github.com/nodejs/node/pull/17369)
* [[`c602c4c7cd`](https://github.com/nodejs/node/commit/c602c4c7cd)] - **src**: make base64.h self-contained (Daniel Bevenius) [#17177](https://github.com/nodejs/node/pull/17177)
* [[`0802128d68`](https://github.com/nodejs/node/commit/0802128d68)] - **src**: add napi_handle_scope_mismatch to msg list (neta) [#17161](https://github.com/nodejs/node/pull/17161)
* [[`76f63b50db`](https://github.com/nodejs/node/commit/76f63b50db)] - **src**: fix compiler warning (cjihrig) [#17195](https://github.com/nodejs/node/pull/17195)
* [[`f26b5761f7`](https://github.com/nodejs/node/commit/f26b5761f7)] - **src**: remove unprofessional slang in assertions (Alexey Orlenko) [#17166](https://github.com/nodejs/node/pull/17166)
* [[`0b07dda767`](https://github.com/nodejs/node/commit/0b07dda767)] - **src**: inspector context name = program title + pid (Ben Noordhuis) [#17087](https://github.com/nodejs/node/pull/17087)
* [[`c5920737a1`](https://github.com/nodejs/node/commit/c5920737a1)] - **src**: abstract getpid() operation (Ben Noordhuis) [#17087](https://github.com/nodejs/node/pull/17087)
* [[`f12efd5990`](https://github.com/nodejs/node/commit/f12efd5990)] - **src**: use unique_ptr for http2_state (Franziska Hinkelmann) [#17078](https://github.com/nodejs/node/pull/17078)
* [[`e46f06c53d`](https://github.com/nodejs/node/commit/e46f06c53d)] - **src**: use std::unique_ptr in base-object-inl.h (Franziska Hinkelmann) [#17079](https://github.com/nodejs/node/pull/17079)
* [[`c9da446533`](https://github.com/nodejs/node/commit/c9da446533)] - **src**: fix size of CounterSet (Witthawat Piwawatthanapanit) [#16984](https://github.com/nodejs/node/pull/16984)
* [[`05422689d7`](https://github.com/nodejs/node/commit/05422689d7)] - **src**: use smart pointer instead of new and delete (Franziska Hinkelmann) [#17020](https://github.com/nodejs/node/pull/17020)
* [[`54706f0531`](https://github.com/nodejs/node/commit/54706f0531)] - **src**: perf_hooks: fix wrong sized delete (Ali Ijaz Sheikh) [#16898](https://github.com/nodejs/node/pull/16898)
* [[`7db8f01ef7`](https://github.com/nodejs/node/commit/7db8f01ef7)] - **src**: implement backtrace-on-abort for windows (Anna Henningsen) [#16951](https://github.com/nodejs/node/pull/16951)
* [[`13a46fcec7`](https://github.com/nodejs/node/commit/13a46fcec7)] - **src**: remove unnecessary call to SetHiddenPrototype (Toon Verwaest) [#16554](https://github.com/nodejs/node/pull/16554)
* [[`9ec35c583f`](https://github.com/nodejs/node/commit/9ec35c583f)] - **src**: clean up uv_fs_t's in module_wrap.cc (cjihrig) [#16722](https://github.com/nodejs/node/pull/16722)
* [[`81970f87ed`](https://github.com/nodejs/node/commit/81970f87ed)] - **src**: fix UB in InternalModuleReadFile() (Ben Noordhuis) [#16871](https://github.com/nodejs/node/pull/16871)
* [[`b1802ede3b`](https://github.com/nodejs/node/commit/b1802ede3b)] - **src**: turn inspector raw pointer into unique_ptr (Franziska Hinkelmann) [#16974](https://github.com/nodejs/node/pull/16974)
* [[`af579907de`](https://github.com/nodejs/node/commit/af579907de)] - **src**: fix bad sizeof expression (Ben Noordhuis) [#17014](https://github.com/nodejs/node/pull/17014)
* [[`cae8772617`](https://github.com/nodejs/node/commit/cae8772617)] - **stream**: use arrow fns for 'this' in readable (Vipin Menon) [#16927](https://github.com/nodejs/node/pull/16927)
* [[`9830b10133`](https://github.com/nodejs/node/commit/9830b10133)] - **test**: remove hidden use of common.PORT in parallel tests (Rich Trott) [#17466](https://github.com/nodejs/node/pull/17466)
* [[`3bf3dc465f`](https://github.com/nodejs/node/commit/3bf3dc465f)] - **test**: remove fixturesDir from common module (Rich Trott) [#17400](https://github.com/nodejs/node/pull/17400)
* [[`0cd4503b76`](https://github.com/nodejs/node/commit/0cd4503b76)] - **test**: remove common.fixturesDir from tests (Rich Trott) [#17400](https://github.com/nodejs/node/pull/17400)
* [[`c02ac841e9`](https://github.com/nodejs/node/commit/c02ac841e9)] - **test**: refactor test-child-process-pass-fd (Rich Trott) [#17596](https://github.com/nodejs/node/pull/17596)
* [[`8eef736f8d`](https://github.com/nodejs/node/commit/8eef736f8d)] - **test**: refactor test-http-default-port (Anna Henningsen) [#17562](https://github.com/nodejs/node/pull/17562)
* [[`bb96831d83`](https://github.com/nodejs/node/commit/bb96831d83)] - **test**: refactored to remove unnecessary variables (Mithun Sasidharan) [#17553](https://github.com/nodejs/node/pull/17553)
* [[`bbb503f90b`](https://github.com/nodejs/node/commit/bbb503f90b)] - **test**: use Countdown in http-agent test (Federico Kauffman) [#17537](https://github.com/nodejs/node/pull/17537)
* [[`831f021e2d`](https://github.com/nodejs/node/commit/831f021e2d)] - **test**: update http test to use common.mustCall (Collins Abitekaniza) [#17528](https://github.com/nodejs/node/pull/17528)
* [[`d5b5278f33`](https://github.com/nodejs/node/commit/d5b5278f33)] - **test**: improve assert messages in repl-reset-event (Adri Van Houdt) [#16836](https://github.com/nodejs/node/pull/16836)
* [[`19aa3b1185`](https://github.com/nodejs/node/commit/19aa3b1185)] - **test**: update test-http-should-keep-alive to use countdown (TomerOmri) [#17505](https://github.com/nodejs/node/pull/17505)
* [[`24305daabe`](https://github.com/nodejs/node/commit/24305daabe)] - **test**: fix flaky test-benchmark-es (Rich Trott) [#17516](https://github.com/nodejs/node/pull/17516)
* [[`e00a4f3b66`](https://github.com/nodejs/node/commit/e00a4f3b66)] - **test**: use Countdown in http test (idandagan1) [#17506](https://github.com/nodejs/node/pull/17506)
* [[`e4edb038db`](https://github.com/nodejs/node/commit/e4edb038db)] - **test**: use Number.isNaN instead of global isNaN (Mithun Sasidharan) [#17515](https://github.com/nodejs/node/pull/17515)
* [[`90ee2b5657`](https://github.com/nodejs/node/commit/90ee2b5657)] - **test**: use Countdown in http-response-statuscode (Mandeep Singh) [#17327](https://github.com/nodejs/node/pull/17327)
* [[`925db27d94`](https://github.com/nodejs/node/commit/925db27d94)] - **test**: use Countdown in test-http-set-cookies (Shilo Mangam) [#17504](https://github.com/nodejs/node/pull/17504)
* [[`56c2f0f434`](https://github.com/nodejs/node/commit/56c2f0f434)] - **test**: Use common.mustCall in http test (sreepurnajasti) [#17487](https://github.com/nodejs/node/pull/17487)
* [[`65b0db4267`](https://github.com/nodejs/node/commit/65b0db4267)] - **test**: update http test to use Countdown (Francisco Gerardo Neri Andriano) [#17477](https://github.com/nodejs/node/pull/17477)
* [[`a81f732fe9`](https://github.com/nodejs/node/commit/a81f732fe9)] - **test**: replace fs.accessSync with fs.existsSync (Leko) [#17446](https://github.com/nodejs/node/pull/17446)
* [[`e442dfbe76`](https://github.com/nodejs/node/commit/e442dfbe76)] - **test**: fix flaky test-benchmark-querystring (Rich Trott) [#17517](https://github.com/nodejs/node/pull/17517)
* [[`f8856ea4f4`](https://github.com/nodejs/node/commit/f8856ea4f4)] - **test**: add common.crashOnUnhandledRejection() (IHsuan) [#17247](https://github.com/nodejs/node/pull/17247)
* [[`4af3a744a3`](https://github.com/nodejs/node/commit/4af3a744a3)] - **test**: refactor code to use common.mustCall (Mithun Sasidharan) [#17437](https://github.com/nodejs/node/pull/17437)
* [[`977eb5aa06`](https://github.com/nodejs/node/commit/977eb5aa06)] - **test**: add more settings to test-benchmark-dgram (Rich Trott) [#17462](https://github.com/nodejs/node/pull/17462)
* [[`6c6635dd2e`](https://github.com/nodejs/node/commit/6c6635dd2e)] - **test**: add dgram benchmark test (jopann) [#17462](https://github.com/nodejs/node/pull/17462)
* [[`d0738fe6e3`](https://github.com/nodejs/node/commit/d0738fe6e3)] - **test**: fix flaky test-benchmark-events (Rich Trott) [#17472](https://github.com/nodejs/node/pull/17472)
* [[`6b18b35b30`](https://github.com/nodejs/node/commit/6b18b35b30)] - **test**: update test-http-request-dont-override-options to use common.mustCall (Mithun Sasidharan) [#17438](https://github.com/nodejs/node/pull/17438)
* [[`e01cd821f5`](https://github.com/nodejs/node/commit/e01cd821f5)] - **test**: replace assert.throws with common.expectsError (Leko) [#17445](https://github.com/nodejs/node/pull/17445)
* [[`daa0cab9c2`](https://github.com/nodejs/node/commit/daa0cab9c2)] - **test**: use common.mustCall in test-http-malformed-request (Mithun Sasidharan) [#17439](https://github.com/nodejs/node/pull/17439)
* [[`26a5d9a66c`](https://github.com/nodejs/node/commit/26a5d9a66c)] - **test**: forbid `common.mustCall*()` in process exit handlers (Rich Trott) [#17453](https://github.com/nodejs/node/pull/17453)
* [[`fddba1840c`](https://github.com/nodejs/node/commit/fddba1840c)] - **test**: use Countdown in http test (Mithun Sasidharan) [#17436](https://github.com/nodejs/node/pull/17436)
* [[`4231923557`](https://github.com/nodejs/node/commit/4231923557)] - **test**: update test-http-response-multiheaders to use countdown (hmammedzadeh) [#17419](https://github.com/nodejs/node/pull/17419)
* [[`45b65857f4`](https://github.com/nodejs/node/commit/45b65857f4)] - **test**: update test-http-timeout to use countdown (Mithun Sasidharan) [#17341](https://github.com/nodejs/node/pull/17341)
* [[`2ab0534322`](https://github.com/nodejs/node/commit/2ab0534322)] - **test**: make common.mustNotCall show file:linenumber (Lance Ball) [#17257](https://github.com/nodejs/node/pull/17257)
* [[`6723619a07`](https://github.com/nodejs/node/commit/6723619a07)] - **test**: update test-http-upgrade-client to use countdown (Mithun Sasidharan) [#17339](https://github.com/nodejs/node/pull/17339)
* [[`8e73a06bbf`](https://github.com/nodejs/node/commit/8e73a06bbf)] - **test**: update test-http-status-reason-invalid-chars to use countdown (Mithun Sasidharan) [#17342](https://github.com/nodejs/node/pull/17342)
* [[`d00df5d6d7`](https://github.com/nodejs/node/commit/d00df5d6d7)] - **test**: refactored test-http-allow-req-after-204-res to countdown (Mithun Sasidharan) [#17211](https://github.com/nodejs/node/pull/17211)
* [[`323ffacfd0`](https://github.com/nodejs/node/commit/323ffacfd0)] - **test**: update test/parallel/test-http-pipe-fs.js to use countdown (ChungNgoops) [#17346](https://github.com/nodejs/node/pull/17346)
* [[`279d844fda`](https://github.com/nodejs/node/commit/279d844fda)] - **test**: refactored test-http-response-splitting to use countdown (Mithun Sasidharan) [#17348](https://github.com/nodejs/node/pull/17348)
* [[`97a264e194`](https://github.com/nodejs/node/commit/97a264e194)] - **test**: make CreateParams stack-allocated (Daniel Bevenius) [#17366](https://github.com/nodejs/node/pull/17366)
* [[`a71f214282`](https://github.com/nodejs/node/commit/a71f214282)] - **test**: use v8 Default Allocator in cctest fixture (Daniel Bevenius) [#17366](https://github.com/nodejs/node/pull/17366)
* [[`f5cd808212`](https://github.com/nodejs/node/commit/f5cd808212)] - **test**: replace function with arrow function (Leko) [#17345](https://github.com/nodejs/node/pull/17345)
* [[`683daea419`](https://github.com/nodejs/node/commit/683daea419)] - **test**: fix flaky async-hooks/test-graph.signal (Rich Trott) [#17509](https://github.com/nodejs/node/pull/17509)
* [[`0498649c25`](https://github.com/nodejs/node/commit/0498649c25)] - **test**: remove common.tmpDirName (Rich Trott) [#17266](https://github.com/nodejs/node/pull/17266)
* [[`ef7261006e`](https://github.com/nodejs/node/commit/ef7261006e)] - **test**: replace function with ES6 arrow function (Junichi Kajiwara) [#17306](https://github.com/nodejs/node/pull/17306)
* [[`ecb1f17c1e`](https://github.com/nodejs/node/commit/ecb1f17c1e)] - **test**: add es6 module global leakage tests (WhoMeNope) [#16341](https://github.com/nodejs/node/pull/16341)
* [[`86d00b2af8`](https://github.com/nodejs/node/commit/86d00b2af8)] - **test**: Enable specifying flaky tests on fips (Nikhil Komawar) [#16329](https://github.com/nodejs/node/pull/16329)
* [[`d5795d016b`](https://github.com/nodejs/node/commit/d5795d016b)] - **test**: refactored http test to use countdown (Mithun Sasidharan) [#17241](https://github.com/nodejs/node/pull/17241)
* [[`74d5e6bcb1`](https://github.com/nodejs/node/commit/74d5e6bcb1)] - **test**: Update test-http-parser-free to use countdown timer (Mandeep Singh) [#17322](https://github.com/nodejs/node/pull/17322)
* [[`6137afad8c`](https://github.com/nodejs/node/commit/6137afad8c)] - **test**: Update test-http-client-agent to use countdown timer (Mandeep Singh) [#17325](https://github.com/nodejs/node/pull/17325)
* [[`341f0c5be7`](https://github.com/nodejs/node/commit/341f0c5be7)] - **test**: fix flaky parallel/test-http2-client-upload (Anna Henningsen) [#17361](https://github.com/nodejs/node/pull/17361)
* [[`c1efba8737`](https://github.com/nodejs/node/commit/c1efba8737)] - **test**: fix isNAN-\>Number.isNAN (yuza yuko) [#17309](https://github.com/nodejs/node/pull/17309)
* [[`7f4aafc46d`](https://github.com/nodejs/node/commit/7f4aafc46d)] - **test**: make use of Number.isNaN to test-readfloat.js (Hiromu Yoshiwara) [#17310](https://github.com/nodejs/node/pull/17310)
* [[`8b64df06d2`](https://github.com/nodejs/node/commit/8b64df06d2)] - **test**: replace function with arrow function (spring_raining) [#17312](https://github.com/nodejs/node/pull/17312)
* [[`6ed8c28315`](https://github.com/nodejs/node/commit/6ed8c28315)] - **test**: replace function with arrow function (Hiroaki KARASAWA) [#17308](https://github.com/nodejs/node/pull/17308)
* [[`8874473cff`](https://github.com/nodejs/node/commit/8874473cff)] - **test**: replace function with arrow function (kou-hin) [#17305](https://github.com/nodejs/node/pull/17305)
* [[`eccb5cb34f`](https://github.com/nodejs/node/commit/eccb5cb34f)] - **test**: use arrow function (koooge) [#17318](https://github.com/nodejs/node/pull/17318)
* [[`fa397148b3`](https://github.com/nodejs/node/commit/fa397148b3)] - **test**: use Number.isNaN() (MURAKAMI Masahiko) [#17319](https://github.com/nodejs/node/pull/17319)
* [[`0aca036e91`](https://github.com/nodejs/node/commit/0aca036e91)] - **test**: add test of stream Transform (Yoshiya Hinosawa) [#17303](https://github.com/nodejs/node/pull/17303)
* [[`39107d7a79`](https://github.com/nodejs/node/commit/39107d7a79)] - **test**: use common.crashOnUnhandledRejection (yozian) [#17242](https://github.com/nodejs/node/pull/17242)
* [[`2d697a8068`](https://github.com/nodejs/node/commit/2d697a8068)] - **test**: use common.crashOnUnhandledRejection (Kcin1993) [#17235](https://github.com/nodejs/node/pull/17235)
* [[`0fb5d27496`](https://github.com/nodejs/node/commit/0fb5d27496)] - **test**: add common.crashOnUnhandledRejection() (Andy Chen) [#17234](https://github.com/nodejs/node/pull/17234)
* [[`e07c200d24`](https://github.com/nodejs/node/commit/e07c200d24)] - **test**: use common.crashOnUnhandledRejection (zhengyuanjie) [#17215](https://github.com/nodejs/node/pull/17215)
* [[`3255686722`](https://github.com/nodejs/node/commit/3255686722)] - **test**: use common.crashOnUnhandledRejection (Jason Chung) [#17233](https://github.com/nodejs/node/pull/17233)
* [[`bea920068f`](https://github.com/nodejs/node/commit/bea920068f)] - **test**: use common.crashOnUnhandledRejection() (sorarize@gmail.com) [#17232](https://github.com/nodejs/node/pull/17232)
* [[`ef6d68c2f9`](https://github.com/nodejs/node/commit/ef6d68c2f9)] - **test**: use common.crashOnUnhandledRejection (Kurt Hsu) [#17229](https://github.com/nodejs/node/pull/17229)
* [[`2b5bc37bca`](https://github.com/nodejs/node/commit/2b5bc37bca)] - **test**: add common.crashOnHandleRejection (jackyen) [#17225](https://github.com/nodejs/node/pull/17225)
* [[`0daf33e5e7`](https://github.com/nodejs/node/commit/0daf33e5e7)] - **test**: add crashonUnhandledRejection (danielLin) [#17237](https://github.com/nodejs/node/pull/17237)
* [[`f4e6d06e29`](https://github.com/nodejs/node/commit/f4e6d06e29)] - **test**: keep coverage reports after coverage-clean (Anatoli Papirovski) [#15470](https://github.com/nodejs/node/pull/15470)
* [[`b4726fabb6`](https://github.com/nodejs/node/commit/b4726fabb6)] - **test**: add test on unhandled rejection (Larry Lu) [#17228](https://github.com/nodejs/node/pull/17228)
* [[`040fe7025a`](https://github.com/nodejs/node/commit/040fe7025a)] - **test**: use common.crashOnUnhandledRejection (aryung chen) [#17221](https://github.com/nodejs/node/pull/17221)
* [[`22d352540e`](https://github.com/nodejs/node/commit/22d352540e)] - **test**: use common.crashOnUnhandledRejection (Zack Yang) [#17217](https://github.com/nodejs/node/pull/17217)
* [[`1474460d2e`](https://github.com/nodejs/node/commit/1474460d2e)] - **test**: add common.crashOnUnhandledRejection() (Scya597) [#17212](https://github.com/nodejs/node/pull/17212)
* [[`7900f8ae63`](https://github.com/nodejs/node/commit/7900f8ae63)] - **test**: remove unlink function which is needless (buji) [#17119](https://github.com/nodejs/node/pull/17119)
* [[`179a4f4fa4`](https://github.com/nodejs/node/commit/179a4f4fa4)] - **test**: dont need to remove nonexistent directory (buji) [#17119](https://github.com/nodejs/node/pull/17119)
* [[`12940b1bed`](https://github.com/nodejs/node/commit/12940b1bed)] - **test**: use common.crashOnUnhandledRejection() (Ivan Wei) [#17227](https://github.com/nodejs/node/pull/17227)
* [[`f56e0ca30d`](https://github.com/nodejs/node/commit/f56e0ca30d)] - **test**: add common.crashOnUnhandledRejection() (Kyle Yu) [#17236](https://github.com/nodejs/node/pull/17236)
* [[`92d4d1e523`](https://github.com/nodejs/node/commit/92d4d1e523)] - **test**: use crashOnUnhandledRejection (YuLun Shih) [#17220](https://github.com/nodejs/node/pull/17220)
* [[`90630ae091`](https://github.com/nodejs/node/commit/90630ae091)] - **test**: fix linting error (James M Snell) [#17251](https://github.com/nodejs/node/pull/17251)
* [[`0e4a681e98`](https://github.com/nodejs/node/commit/0e4a681e98)] - **test**: use common.crashOnUnhandledRejection (jimliu7434) [#17231](https://github.com/nodejs/node/pull/17231)
* [[`8a0a2658cc`](https://github.com/nodejs/node/commit/8a0a2658cc)] - **test**: use crashOnUnhandledRejection (Roth Peng) [#17226](https://github.com/nodejs/node/pull/17226)
* [[`5dd620babd`](https://github.com/nodejs/node/commit/5dd620babd)] - **test**: use common.crashOnUnhandledRejection (esbb48) [#17218](https://github.com/nodejs/node/pull/17218)
* [[`74e6f0d08f`](https://github.com/nodejs/node/commit/74e6f0d08f)] - **test**: use arrow function instead of bind (Lance Ball) [#17202](https://github.com/nodejs/node/pull/17202)
* [[`b1b98210a6`](https://github.com/nodejs/node/commit/b1b98210a6)] - **test**: use crashOnUnhandledRejection (Chiahao Lin) [#17219](https://github.com/nodejs/node/pull/17219)
* [[`f608f708c4`](https://github.com/nodejs/node/commit/f608f708c4)] - **test**: use common.crashOnUnhandledRejection (Whien) [#17214](https://github.com/nodejs/node/pull/17214)
* [[`bd8d7d7258`](https://github.com/nodejs/node/commit/bd8d7d7258)] - **test**: clean up inappropriate language (Gus Caplan) [#17170](https://github.com/nodejs/node/pull/17170)
* [[`27ee7117dd`](https://github.com/nodejs/node/commit/27ee7117dd)] - **test**: wrap callback in common.mustCall (suman-mitra) [#17173](https://github.com/nodejs/node/pull/17173)
* [[`7b9623a819`](https://github.com/nodejs/node/commit/7b9623a819)] - **test**: remove unused parameter in test-next-tick-error-spin.js (Francois KY) [#17185](https://github.com/nodejs/node/pull/17185)
* [[`1f20891445`](https://github.com/nodejs/node/commit/1f20891445)] - **test**: remove unused parameter (Fran Herrero) [#17193](https://github.com/nodejs/node/pull/17193)
* [[`cebedd6845`](https://github.com/nodejs/node/commit/cebedd6845)] - **test**: remove unused variable (Pierre-Loic Doulcet) [#17186](https://github.com/nodejs/node/pull/17186)
* [[`9c6b845d43`](https://github.com/nodejs/node/commit/9c6b845d43)] - **test**: remove unused variable (Guillaume Flandre) [#17187](https://github.com/nodejs/node/pull/17187)
* [[`71d554e8cb`](https://github.com/nodejs/node/commit/71d554e8cb)] - **test**: remove unused parameter (François Descamps) [#17184](https://github.com/nodejs/node/pull/17184)
* [[`431ed2be5d`](https://github.com/nodejs/node/commit/431ed2be5d)] - **test**: remove unused parameter (Xavier Balloy) [#17188](https://github.com/nodejs/node/pull/17188)
* [[`3d1e129dbc`](https://github.com/nodejs/node/commit/3d1e129dbc)] - **test**: make debugging of inspector-port-zero easier (Gibson Fahnestock) [#16685](https://github.com/nodejs/node/pull/16685)
* [[`c86f185b49`](https://github.com/nodejs/node/commit/c86f185b49)] - **test**: replace assert.throws w/ common.expectsError (sgreylyn) [#17091](https://github.com/nodejs/node/pull/17091)
* [[`ca0b5fa68b`](https://github.com/nodejs/node/commit/ca0b5fa68b)] - **test**: reduce benchmark cases in test-benchmark-buffer (Rich Trott) [#17111](https://github.com/nodejs/node/pull/17111)
* [[`2f276c894e`](https://github.com/nodejs/node/commit/2f276c894e)] - **test**: fs.write() if 3rd argument is a callback, not offset (Patrick Heneise) [#17045](https://github.com/nodejs/node/pull/17045)
* [[`ec28fe68ad`](https://github.com/nodejs/node/commit/ec28fe68ad)] - **test**: utilize common.mustCall() on child exit (sreepurnajasti) [#16996](https://github.com/nodejs/node/pull/16996)
* [[`e3d0e0360e`](https://github.com/nodejs/node/commit/e3d0e0360e)] - **test**: use arrow functions instead of bind (Tobias Nießen) [#17070](https://github.com/nodejs/node/pull/17070)
* [[`f44ad16298`](https://github.com/nodejs/node/commit/f44ad16298)] - **test**: move timing-sensitive test to sequential (Rich Trott) [#16775](https://github.com/nodejs/node/pull/16775)
* [[`af4d74e6d0`](https://github.com/nodejs/node/commit/af4d74e6d0)] - **test**: make REPL test pass in coverage mode (Anna Henningsen) [#17082](https://github.com/nodejs/node/pull/17082)
* [[`b1bcd4fe11`](https://github.com/nodejs/node/commit/b1bcd4fe11)] - **test**: --enable-static linked executable (Daniel Bevenius) [#14986](https://github.com/nodejs/node/pull/14986)
* [[`621390fe65`](https://github.com/nodejs/node/commit/621390fe65)] - **test**: add basic WebAssembly test (Steve Kinney) [#16760](https://github.com/nodejs/node/pull/16760)
* [[`8528a5d5f0`](https://github.com/nodejs/node/commit/8528a5d5f0)] - **test**: flag known flake (Refael Ackermann) [#16941](https://github.com/nodejs/node/pull/16941)
* [[`3da14495c7`](https://github.com/nodejs/node/commit/3da14495c7)] - **test**: refactor exitedAfterDisconnect test (Rich Trott) [#16729](https://github.com/nodejs/node/pull/16729)
* [[`5a1a56722b`](https://github.com/nodejs/node/commit/5a1a56722b)] - **test**: add tests for eslint rules (Teddy Katz) [#16138](https://github.com/nodejs/node/pull/16138)
* [[`927a28126b`](https://github.com/nodejs/node/commit/927a28126b)] - **test**: fixup test-http2-create-client-secure-session (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`eb8344b3a9`](https://github.com/nodejs/node/commit/eb8344b3a9)] - **test**: use default assertion messages (John Byrne) [#16808](https://github.com/nodejs/node/pull/16808)
* [[`d2b32ce074`](https://github.com/nodejs/node/commit/d2b32ce074)] - **test**: add detailed message for assertion failure (Attila Gonda) [#16812](https://github.com/nodejs/node/pull/16812)
* [[`55bf57dc9a`](https://github.com/nodejs/node/commit/55bf57dc9a)] - **test**: improve assert messages in napi exception test (Paul Blanche) [#16820](https://github.com/nodejs/node/pull/16820)
* [[`25ff7bf1cd`](https://github.com/nodejs/node/commit/25ff7bf1cd)] - **test**: improve error emssage reporting in testNapiRun.js (Paul Ashfield) [#16821](https://github.com/nodejs/node/pull/16821)
* [[`2d63b65aed`](https://github.com/nodejs/node/commit/2d63b65aed)] - **test**: refactor addons-napi/test_promise/test.js (ka3e) [#16814](https://github.com/nodejs/node/pull/16814)
* [[`ad331f20bd`](https://github.com/nodejs/node/commit/ad331f20bd)] - **test**: add coverage to tty module (cjihrig) [#16959](https://github.com/nodejs/node/pull/16959)
* [[`9bade7a095`](https://github.com/nodejs/node/commit/9bade7a095)] - **test,doc**: do not indicate that non-functions "return" values (Rich Trott) [#17267](https://github.com/nodejs/node/pull/17267)
* [[`7e571ae204`](https://github.com/nodejs/node/commit/7e571ae204)] - **test,doc**: document where common modules go (Gibson Fahnestock) [#16089](https://github.com/nodejs/node/pull/16089)
* [[`eb3db343c3`](https://github.com/nodejs/node/commit/eb3db343c3)] - **tools**: fix gitignore for tools/doc/ (Richard Littauer) [#17224](https://github.com/nodejs/node/pull/17224)
* [[`0e47f4151e`](https://github.com/nodejs/node/commit/0e47f4151e)] - **tools**: simplify no-let-in-for-declaration rule (cjihrig) [#17572](https://github.com/nodejs/node/pull/17572)
* [[`dd1105ddba`](https://github.com/nodejs/node/commit/dd1105ddba)] - **tools**: simplify buffer-constructor rule (cjihrig) [#17572](https://github.com/nodejs/node/pull/17572)
* [[`20044a239d`](https://github.com/nodejs/node/commit/20044a239d)] - **tools**: simplify prefer-assert-methods rule (cjihrig) [#17572](https://github.com/nodejs/node/pull/17572)
* [[`9ece12f542`](https://github.com/nodejs/node/commit/9ece12f542)] - **tools**: simplify prefer-common-mustnotcall rule (cjihrig) [#17572](https://github.com/nodejs/node/pull/17572)
* [[`3e4ca90077`](https://github.com/nodejs/node/commit/3e4ca90077)] - **tools**: replace space with \b in regex (Diego Rodríguez Baquero) [#17479](https://github.com/nodejs/node/pull/17479)
* [[`36c977e551`](https://github.com/nodejs/node/commit/36c977e551)] - **tools**: enable no-return-await lint rule (Rich Trott) [#17265](https://github.com/nodejs/node/pull/17265)
* [[`aa546e7365`](https://github.com/nodejs/node/commit/aa546e7365)] - **tools**: add Boxstarter script (Bartosz Sosnowski) [#17046](https://github.com/nodejs/node/pull/17046)
* [[`3fb2183464`](https://github.com/nodejs/node/commit/3fb2183464)] - **tools**: update to ESLint 4.12.0 (cjihrig) [#16948](https://github.com/nodejs/node/pull/16948)
* [[`b6be2d7181`](https://github.com/nodejs/node/commit/b6be2d7181)] - **tools**: add lint fixer for `require-buffer` (Bamieh) [#17144](https://github.com/nodejs/node/pull/17144)
* [[`baf95b68e5`](https://github.com/nodejs/node/commit/baf95b68e5)] - **tools**: make doc tool a bit more readable (Tobias Nießen) [#17125](https://github.com/nodejs/node/pull/17125)
* [[`9a76a6cfcf`](https://github.com/nodejs/node/commit/9a76a6cfcf)] - **tools**: remove useless function declaration (Tobias Nießen) [#17125](https://github.com/nodejs/node/pull/17125)
* [[`df39389175`](https://github.com/nodejs/node/commit/df39389175)] - **tools**: avoid using process.cwd in tools/lint-js (Tobias Nießen) [#17121](https://github.com/nodejs/node/pull/17121)
* [[`5e5cb1bd54`](https://github.com/nodejs/node/commit/5e5cb1bd54)] - **tools**: use built-in padStart instead of padString (Tobias Nießen) [#17120](https://github.com/nodejs/node/pull/17120)
* [[`7658eec62e`](https://github.com/nodejs/node/commit/7658eec62e)] - **tools**: allow running test.py without configuring (Gibson Fahnestock) [#16621](https://github.com/nodejs/node/pull/16621)
* [[`d7eaa3ffb4`](https://github.com/nodejs/node/commit/d7eaa3ffb4)] - **tools**: fail tests if malformed status file (Rich Trott) [#16703](https://github.com/nodejs/node/pull/16703)
* [[`8319b68873`](https://github.com/nodejs/node/commit/8319b68873)] - **tools**: try installing js-yaml only once (Joyee Cheung) [#16661](https://github.com/nodejs/node/pull/16661)
* [[`a91fb54693`](https://github.com/nodejs/node/commit/a91fb54693)] - **tools**: add fixer for no-let-in-for-declaration (Weijia Wang) [#16642](https://github.com/nodejs/node/pull/16642)
* [[`ba73a67d45`](https://github.com/nodejs/node/commit/ba73a67d45)] - **tools**: update to ESLint 4.10.0 (cjihrig) [#16738](https://github.com/nodejs/node/pull/16738)
* [[`38b0da7fab`](https://github.com/nodejs/node/commit/38b0da7fab)] - **tools,test**: use Execute instead of check_output (Refael Ackermann) [#17381](https://github.com/nodejs/node/pull/17381)
* [[`6fa51d6198`](https://github.com/nodejs/node/commit/6fa51d6198)] - **tty**: fix 'resize' event regression (Ben Noordhuis) [#16225](https://github.com/nodejs/node/pull/16225)
* [[`5ee05f2187`](https://github.com/nodejs/node/commit/5ee05f2187)] - **tty**: refactor exports (cjihrig) [#16959](https://github.com/nodejs/node/pull/16959)
* [[`3236944761`](https://github.com/nodejs/node/commit/3236944761)] - **util**: fix negative 0 check in inspect (Gus Caplan) [#17507](https://github.com/nodejs/node/pull/17507)
* [[`943258e093`](https://github.com/nodejs/node/commit/943258e093)] - **util**: remove check for global.process (Gus Caplan) [#17435](https://github.com/nodejs/node/pull/17435)

<a id="8.9.3"></a>
## 2017-12-08, Version 8.9.3 'Carbon' (LTS), @MylesBorins

This is a security release. All Node.js users should consult the security release summary at https://nodejs.org/en/blog/vulnerability/december-2017-security-releases/ for details on patched vulnerabilities.

Fixes for the following CVEs are included in this release:

* CVE-2017-15896
* CVE-2017-15897
* CVE-2017-3738 (from the openssl project)

### Notable Changes

* **buffer**:
  * buffer allocated with an invalid content will now be zero filled (Anna Henningsen) [#17428](https://github.com/nodejs/node/pull/17428)
* **deps**:
  * openssl updated to 1.0.2n (Shigeki Ohtsu) [#17526](https://github.com/nodejs/node/pull/17526)

### Commits

* [[`b05ef978d3`](https://github.com/nodejs/node/commit/b05ef978d3)] - **buffer**: zero-fill buffer allocated with invalid content (Anna Henningsen) [#17428](https://github.com/nodejs/node/pull/17428)
* [[`18652b6860`](https://github.com/nodejs/node/commit/18652b6860)] - **deps**: update openssl asm and asm_obsolete files (Shigeki Ohtsu) [#17526](https://github.com/nodejs/node/pull/17526)
* [[`e6c308e237`](https://github.com/nodejs/node/commit/e6c308e237)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`a85f94bd59`](https://github.com/nodejs/node/commit/a85f94bd59)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`b5552c854c`](https://github.com/nodejs/node/commit/b5552c854c)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`afad1f23a2`](https://github.com/nodejs/node/commit/afad1f23a2)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#17526](https://github.com/nodejs/node/pull/17526)
* [[`9fdd3bddf5`](https://github.com/nodejs/node/commit/9fdd3bddf5)] - **deps**: upgrade openssl sources to 1.0.2n (Shigeki Ohtsu) [#17526](https://github.com/nodejs/node/pull/17526)
* [[`db09f245bf`](https://github.com/nodejs/node/commit/db09f245bf)] - **doc**: warn against filling buffer with invalid data (Anna Henningsen) [#17428](https://github.com/nodejs/node/pull/17428)
* [[`42f09ed461`](https://github.com/nodejs/node/commit/42f09ed461)] - **http2**: use correct connect event for TLS Socket (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`aba3544b50`](https://github.com/nodejs/node/commit/aba3544b50)] - **http2**: use 'close' event instead of 'streamClosed' (James M Snell) [#17328](https://github.com/nodejs/node/pull/17328)
* [[`bd035d75bd`](https://github.com/nodejs/node/commit/bd035d75bd)] - **http2**: general cleanups in core.js (James M Snell) [#17209](https://github.com/nodejs/node/pull/17209)
* [[`a5e3ba2cb3`](https://github.com/nodejs/node/commit/a5e3ba2cb3)] - **http2**: major update to internals (James M Snell) [#17105](https://github.com/nodejs/node/pull/17105)
* [[`d7f37cebed`](https://github.com/nodejs/node/commit/d7f37cebed)] - **http2**: simplify subsequent rstStream calls (Anatoli Papirovski) [#16753](https://github.com/nodejs/node/pull/16753)
* [[`22ee960775`](https://github.com/nodejs/node/commit/22ee960775)] - **http2**: refactor multiple internals (James M Snell) [#16676](https://github.com/nodejs/node/pull/16676)
* [[`319beaf45b`](https://github.com/nodejs/node/commit/319beaf45b)] - **http2**: allocate on every chunk send (James M Snell) [#16669](https://github.com/nodejs/node/pull/16669)
* [[`7d68488524`](https://github.com/nodejs/node/commit/7d68488524)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`8e8fac29de`](https://github.com/nodejs/node/commit/8e8fac29de)] - **src**: fix -Winconsistent-missing-override warning (Ben Noordhuis) [#16726](https://github.com/nodejs/node/pull/16726)
* [[`26b43c87ee`](https://github.com/nodejs/node/commit/26b43c87ee)] - **src**: add method to compute storage in WriteWrap (Anna Henningsen) [#16727](https://github.com/nodejs/node/pull/16727)
* [[`99d775ca07`](https://github.com/nodejs/node/commit/99d775ca07)] - **test**: fix flaky test-http2-create-client-connect (David Benjamin) [#16130](https://github.com/nodejs/node/pull/16130)

<a id="8.9.2"></a>
## 2017-12-05, Version 8.9.2 'Carbon' (LTS), @gibfahn

### Notable Changes

- **console**:
  - avoid adding infinite error listeners (Matteo Collina) [#16770](https://github.com/nodejs/node/pull/16770)
- **http2**:
  - improve errors thrown in header validation (Joyee Cheung) [#16718](https://github.com/nodejs/node/pull/16718)

### Commits

* [[`1bf6250b99`](https://github.com/nodejs/node/commit/1bf6250b99)] - doc : mention constant-time in crypto doc (Mithun Sasidharan) [#16604](https://github.com/nodejs/node/pull/16604)
* [[`585f8698af`](https://github.com/nodejs/node/commit/585f8698af)] - **build**: include src\tracing when linting on win (Daniel Bevenius) [#16720](https://github.com/nodejs/node/pull/16720)
* [[`d9a18beaa6`](https://github.com/nodejs/node/commit/d9a18beaa6)] - **build**: suppress lint-md output (Gibson Fahnestock) [#16551](https://github.com/nodejs/node/pull/16551)
* [[`4e848d4afb`](https://github.com/nodejs/node/commit/4e848d4afb)] - **build**: add missing comma in sources list (Daniel Bevenius) [#16613](https://github.com/nodejs/node/pull/16613)
* [[`9df1e8f10e`](https://github.com/nodejs/node/commit/9df1e8f10e)] - **console**: avoid adding infinite error listeners (Matteo Collina) [#16770](https://github.com/nodejs/node/pull/16770)
* [[`7ba037592d`](https://github.com/nodejs/node/commit/7ba037592d)] - **deps**: cherry-pick cc55747 from V8 upstream (Franziska Hinkelmann) [#16890](https://github.com/nodejs/node/pull/16890)
* [[`c3c9a8d4bf`](https://github.com/nodejs/node/commit/c3c9a8d4bf)] - **doc**: recommend node-core-utils for metadata (Rich Trott) [#16978](https://github.com/nodejs/node/pull/16978)
* [[`891ddad93c`](https://github.com/nodejs/node/commit/891ddad93c)] - **doc**: fix typo in http2 doc (Gus Caplan) [#16993](https://github.com/nodejs/node/pull/16993)
* [[`ccd36467f8`](https://github.com/nodejs/node/commit/ccd36467f8)] - **doc**: reorganize COLLABORATOR_GUIDE.md (Rich Trott) [#15710](https://github.com/nodejs/node/pull/15710)
* [[`8f0793ff93`](https://github.com/nodejs/node/commit/8f0793ff93)] - **doc**: clarify the prerequisites for building with VS2017 (Nikolai Vavilov) [#16903](https://github.com/nodejs/node/pull/16903)
* [[`6e7a444a91`](https://github.com/nodejs/node/commit/6e7a444a91)] - **doc**: outline commit message for breaking changes (Maton Anthony) [#16846](https://github.com/nodejs/node/pull/16846)
* [[`6eb550da34`](https://github.com/nodejs/node/commit/6eb550da34)] - **doc**: remove duplicate 'the' from http2 API doc (Vipin Menon) [#16924](https://github.com/nodejs/node/pull/16924)
* [[`0b8a400cad`](https://github.com/nodejs/node/commit/0b8a400cad)] - **doc**: correct the spelling of omitting in dgram.md (Vidya Subramanyam) [#16910](https://github.com/nodejs/node/pull/16910)
* [[`adb8f08c36`](https://github.com/nodejs/node/commit/adb8f08c36)] - **doc**: fix a typo in the documentation (Mamatha J V) [#16909](https://github.com/nodejs/node/pull/16909)
* [[`d721c0bb5e`](https://github.com/nodejs/node/commit/d721c0bb5e)] - **doc**: improve documentation for the vm module (Franziska Hinkelmann) [#16867](https://github.com/nodejs/node/pull/16867)
* [[`360f40354e`](https://github.com/nodejs/node/commit/360f40354e)] - **doc**: fix typo in assert.md (Andres Kalle) [#16866](https://github.com/nodejs/node/pull/16866)
* [[`c4634bf506`](https://github.com/nodejs/node/commit/c4634bf506)] - **doc**: update subprocess.killed (cjihrig) [#16748](https://github.com/nodejs/node/pull/16748)
* [[`eafc0a1314`](https://github.com/nodejs/node/commit/eafc0a1314)] - **doc**: fix a link in dgram.md (Vse Mozhet Byt) [#16854](https://github.com/nodejs/node/pull/16854)
* [[`fab55980be`](https://github.com/nodejs/node/commit/fab55980be)] - **doc**: add isTTY property documentation (SonaySevik) [#16828](https://github.com/nodejs/node/pull/16828)
* [[`f2a9c024ed`](https://github.com/nodejs/node/commit/f2a9c024ed)] - **doc**: fix json generator warnings (Luigi Pinca) [#16742](https://github.com/nodejs/node/pull/16742)
* [[`3319b2092f`](https://github.com/nodejs/node/commit/3319b2092f)] - **doc**: update license to include node-inspect (Myles Borins) [#16659](https://github.com/nodejs/node/pull/16659)
* [[`7618567b4f`](https://github.com/nodejs/node/commit/7618567b4f)] - **doc**: add docs for Zlib#close() (Luigi Pinca) [#16592](https://github.com/nodejs/node/pull/16592)
* [[`2cc05e0657`](https://github.com/nodejs/node/commit/2cc05e0657)] - **doc**: add nodejs/gyp team for GYP related issues (Gibson Fahnestock) [#16638](https://github.com/nodejs/node/pull/16638)
* [[`542f3b9cc0`](https://github.com/nodejs/node/commit/542f3b9cc0)] - **doc**: add details about rss on process.memoryUsage (Anthony Nandaa) [#16566](https://github.com/nodejs/node/pull/16566)
* [[`13866b8b1b`](https://github.com/nodejs/node/commit/13866b8b1b)] - **doc**: add windowsVerbatimArguments docs (Andrew Stucki) [#16299](https://github.com/nodejs/node/pull/16299)
* [[`d2e4a87321`](https://github.com/nodejs/node/commit/d2e4a87321)] - **doc**: howto decode buffers extending from Writable (dicearr) [#16403](https://github.com/nodejs/node/pull/16403)
* [[`a2fd9a3cf2`](https://github.com/nodejs/node/commit/a2fd9a3cf2)] - **doc**: add *-inl.h include rule to C++ style guide (Joyee Cheung) [#16548](https://github.com/nodejs/node/pull/16548)
* [[`9b8e2a68d8`](https://github.com/nodejs/node/commit/9b8e2a68d8)] - **http**: use arrow fns for lexical `this` in Agent (Bryan English) [#16475](https://github.com/nodejs/node/pull/16475)
* [[`29efb02f12`](https://github.com/nodejs/node/commit/29efb02f12)] - **http2**: multiple smaller code cleanups (James M Snell) [#16764](https://github.com/nodejs/node/pull/16764)
* [[`658301664f`](https://github.com/nodejs/node/commit/658301664f)] - **http2**: improve errors thrown in header validation (Joyee Cheung) [#16718](https://github.com/nodejs/node/pull/16718)
* [[`8cf8a327c8`](https://github.com/nodejs/node/commit/8cf8a327c8)] - **http2**: refactor settings handling (James M Snell) [#16668](https://github.com/nodejs/node/pull/16668)
* [[`4faf2ec783`](https://github.com/nodejs/node/commit/4faf2ec783)] - **lib**: replace string concatenation with template (Suryanarayana Murthy N) [#16933](https://github.com/nodejs/node/pull/16933)
* [[`14f8cee401`](https://github.com/nodejs/node/commit/14f8cee401)] - **lib**: guard inspector console using process var (Daniel Bevenius) [#15008](https://github.com/nodejs/node/pull/15008)
* [[`2ad051d62c`](https://github.com/nodejs/node/commit/2ad051d62c)] - **lib**: change concatenated string to template (Pawan Jangid) [#16930](https://github.com/nodejs/node/pull/16930)
* [[`28f036045b`](https://github.com/nodejs/node/commit/28f036045b)] - **lib**: change concatenated string to template (Nayana Das K) [#16925](https://github.com/nodejs/node/pull/16925)
* [[`134c2f31f2`](https://github.com/nodejs/node/commit/134c2f31f2)] - **lib**: replace string concatenation with template (subrahmanya chari p) [#16917](https://github.com/nodejs/node/pull/16917)
* [[`dc14c25ee9`](https://github.com/nodejs/node/commit/dc14c25ee9)] - **loader**: test search module (Cyril Lakech) [#16795](https://github.com/nodejs/node/pull/16795)
* [[`d27ec13cd3`](https://github.com/nodejs/node/commit/d27ec13cd3)] - **repl**: avoid crashing from null and undefined errors (cPhost) [#16574](https://github.com/nodejs/node/pull/16574)
* [[`40880897fe`](https://github.com/nodejs/node/commit/40880897fe)] - **src**: use unrefed async for GC tracking (Anna Henningsen) [#16758](https://github.com/nodejs/node/pull/16758)
* [[`f7411b5df7`](https://github.com/nodejs/node/commit/f7411b5df7)] - **src**: make StreamBase prototype accessors robust (Joyee Cheung) [#16860](https://github.com/nodejs/node/pull/16860)
* [[`8d31294b3b`](https://github.com/nodejs/node/commit/8d31294b3b)] - **src**: CHECK() for argument overflow in Spawn() (cjihrig) [#16761](https://github.com/nodejs/node/pull/16761)
* [[`57b377ef93`](https://github.com/nodejs/node/commit/57b377ef93)] - **src**: improve module loader readability (Anna Henningsen) [#16536](https://github.com/nodejs/node/pull/16536)
* [[`82076ed91f`](https://github.com/nodejs/node/commit/82076ed91f)] - **src**: pass context to Get() operations for cares_wrap (Evan Lucas) [#16641](https://github.com/nodejs/node/pull/16641)
* [[`79e1d7719d`](https://github.com/nodejs/node/commit/79e1d7719d)] - **src**: remove unused includes in string_bytes.h (Daniel Bevenius) [#16606](https://github.com/nodejs/node/pull/16606)
* [[`cecd1e3def`](https://github.com/nodejs/node/commit/cecd1e3def)] - **src**: fix etw provider include on Windows (Joyee Cheung) [#16639](https://github.com/nodejs/node/pull/16639)
* [[`255fffbbc8`](https://github.com/nodejs/node/commit/255fffbbc8)] - **src**: do not include x.h if x-inl.h is included (Joyee Cheung) [#16548](https://github.com/nodejs/node/pull/16548)
* [[`efdd7c8cae`](https://github.com/nodejs/node/commit/efdd7c8cae)] - **test**: reuse existing PassThrough implementation (Tobias Nießen) [#16936](https://github.com/nodejs/node/pull/16936)
* [[`375bec00a4`](https://github.com/nodejs/node/commit/375bec00a4)] - **test**: use fixtures module for path resolve (sercan yersen) [#16842](https://github.com/nodejs/node/pull/16842)
* [[`6ab706d7f0`](https://github.com/nodejs/node/commit/6ab706d7f0)] - **test**: refactor comments in test-child-process-spawnsync-maxbuf (ChrBergert) [#16829](https://github.com/nodejs/node/pull/16829)
* [[`315fba8bfd`](https://github.com/nodejs/node/commit/315fba8bfd)] - **test**: used fixturesDir from fixtures modules (Klemen Kogovsek) [#16813](https://github.com/nodejs/node/pull/16813)
* [[`5c8fb6a976`](https://github.com/nodejs/node/commit/5c8fb6a976)] - **test**: refactor fs.write() test (Patrick Heneise) [#16827](https://github.com/nodejs/node/pull/16827)
* [[`4f587e5a30`](https://github.com/nodejs/node/commit/4f587e5a30)] - **test**: add a test description (Grant Gasparyan) [#16833](https://github.com/nodejs/node/pull/16833)
* [[`af8b17a314`](https://github.com/nodejs/node/commit/af8b17a314)] - **test**: use common/fixtures module in hash-seed test (Javier Blanco) [#16823](https://github.com/nodejs/node/pull/16823)
* [[`3a3792b0a0`](https://github.com/nodejs/node/commit/3a3792b0a0)] - **test**: improve template value for test message (Stephan Smith) [#16826](https://github.com/nodejs/node/pull/16826)
* [[`c3e6491a51`](https://github.com/nodejs/node/commit/c3e6491a51)] - **test**: unmark flaky test (Anna Henningsen) [#16758](https://github.com/nodejs/node/pull/16758)
* [[`bf9eb04abe`](https://github.com/nodejs/node/commit/bf9eb04abe)] - **test**: change concatenated string to template (Deepthi Sebastian) [#16929](https://github.com/nodejs/node/pull/16929)
* [[`7168a7e044`](https://github.com/nodejs/node/commit/7168a7e044)] - **test**: change concatenated string to template (Anawesha Khuntia) [#16912](https://github.com/nodejs/node/pull/16912)
* [[`febd1bf519`](https://github.com/nodejs/node/commit/febd1bf519)] - **test**: change string concatenation to template (Suryanarayana Murthy N) [#16919](https://github.com/nodejs/node/pull/16919)
* [[`7164d9a6b8`](https://github.com/nodejs/node/commit/7164d9a6b8)] - **test**: use template string for concatenation (Vipin Menon) [#16918](https://github.com/nodejs/node/pull/16918)
* [[`ae7106cc75`](https://github.com/nodejs/node/commit/ae7106cc75)] - **test**: replace string concatenation with template (Kabir Islam) [#16916](https://github.com/nodejs/node/pull/16916)
* [[`81a6c4f785`](https://github.com/nodejs/node/commit/81a6c4f785)] - **test**: enable mustCall() during child exit (Vipin Menon) [#16915](https://github.com/nodejs/node/pull/16915)
* [[`41f905bb00`](https://github.com/nodejs/node/commit/41f905bb00)] - **test**: replace string concatenation with template (Sabari Lakshmi Krishnamoorthy) [#16914](https://github.com/nodejs/node/pull/16914)
* [[`be920aa372`](https://github.com/nodejs/node/commit/be920aa372)] - **test**: replace string concatenation with template (Tanvi Kini) [#16913](https://github.com/nodejs/node/pull/16913)
* [[`26d529e60f`](https://github.com/nodejs/node/commit/26d529e60f)] - **test**: cover vm.runInNewContext() (cjihrig) [#16906](https://github.com/nodejs/node/pull/16906)
* [[`6c57399c6b`](https://github.com/nodejs/node/commit/6c57399c6b)] - **test**: improve assertion messages (Neil Vass) [#16885](https://github.com/nodejs/node/pull/16885)
* [[`1522562ffd`](https://github.com/nodejs/node/commit/1522562ffd)] - **test**: pass process.env to child processes (Rod Vagg) [#16405](https://github.com/nodejs/node/pull/16405)
* [[`0bc16cd9b6`](https://github.com/nodejs/node/commit/0bc16cd9b6)] - **test**: improve assert messages in stream test (Katie Stockton Roberts) [#16884](https://github.com/nodejs/node/pull/16884)
* [[`7c9aee3348`](https://github.com/nodejs/node/commit/7c9aee3348)] - **test**: improve assertion in test-require-dot (Adam Wegrzynek) [#16805](https://github.com/nodejs/node/pull/16805)
* [[`1b1bd261dc`](https://github.com/nodejs/node/commit/1b1bd261dc)] - **test**: add values to error message (Adam Jeffery) [#16831](https://github.com/nodejs/node/pull/16831)
* [[`e66a7ae6e3`](https://github.com/nodejs/node/commit/e66a7ae6e3)] - **test**: replace common.fixtiresDir with fixtures.readKey() (woj) [#16817](https://github.com/nodejs/node/pull/16817)
* [[`c1309d6b80`](https://github.com/nodejs/node/commit/c1309d6b80)] - **test**: use tmpDir in test-fs-utimes (Rich Trott) [#16774](https://github.com/nodejs/node/pull/16774)
* [[`2f1f7e1de0`](https://github.com/nodejs/node/commit/2f1f7e1de0)] - **test**: remove message argument in cluster setup test (mbornath) [#16838](https://github.com/nodejs/node/pull/16838)
* [[`d64fe485c5`](https://github.com/nodejs/node/commit/d64fe485c5)] - **test**: check session timeout in http2 (Anatoli Papirovski) [#16754](https://github.com/nodejs/node/pull/16754)
* [[`4fcb03c0ae`](https://github.com/nodejs/node/commit/4fcb03c0ae)] - **test**: move test-http-keepalive-maxsockets to sequential (Rich Trott) [#16777](https://github.com/nodejs/node/pull/16777)
* [[`71c11d67f4`](https://github.com/nodejs/node/commit/71c11d67f4)] - **test**: improve assert messages in test-global (Mark McNelis) [#16843](https://github.com/nodejs/node/pull/16843)
* [[`ca278802ff`](https://github.com/nodejs/node/commit/ca278802ff)] - **test**: use default assertion message (jonask) [#16819](https://github.com/nodejs/node/pull/16819)
* [[`ec4c3f5777`](https://github.com/nodejs/node/commit/ec4c3f5777)] - **test**: improve message in test-fs-readfile-pipe-large (fjau) [#16840](https://github.com/nodejs/node/pull/16840)
* [[`562d8fca15`](https://github.com/nodejs/node/commit/562d8fca15)] - **test**: remove custom message from assertion (Nicolas Morel) [#16824](https://github.com/nodejs/node/pull/16824)
* [[`0ebded4376`](https://github.com/nodejs/node/commit/0ebded4376)] - **test**: show incorrect value on test failure (Sean Karson) [#16818](https://github.com/nodejs/node/pull/16818)
* [[`2bbc76eb1f`](https://github.com/nodejs/node/commit/2bbc76eb1f)] - **test**: include file mode in assert message (Sascha Tandel) [#16815](https://github.com/nodejs/node/pull/16815)
* [[`33f2fff52b`](https://github.com/nodejs/node/commit/33f2fff52b)] - **test**: refactor tls test to use fixtres.readSync (Brian O'Connell) [#16816](https://github.com/nodejs/node/pull/16816)
* [[`b307582d10`](https://github.com/nodejs/node/commit/b307582d10)] - **test**: use fixtures module in test-repl (Maring, Damian Lion) [#16809](https://github.com/nodejs/node/pull/16809)
* [[`5719beaf83`](https://github.com/nodejs/node/commit/5719beaf83)] - **test**: update test to use fixtures.readKey (Dara Hayes) [#16811](https://github.com/nodejs/node/pull/16811)
* [[`b166b6b1b3`](https://github.com/nodejs/node/commit/b166b6b1b3)] - **test**: fix typos in read-buffer tests (Jimi van der Woning) [#16834](https://github.com/nodejs/node/pull/16834)
* [[`c4176eb722`](https://github.com/nodejs/node/commit/c4176eb722)] - **test**: replace fixturesDir with usage of fixtures module (Octavian Ionescu) [#16810](https://github.com/nodejs/node/pull/16810)
* [[`af13678889`](https://github.com/nodejs/node/commit/af13678889)] - **test**: clarified assert message for test-require-json.js (Matthias Reis) [#16807](https://github.com/nodejs/node/pull/16807)
* [[`0fa659cdcd`](https://github.com/nodejs/node/commit/0fa659cdcd)] - **test**: replace common.fixturesDir with fixtures module (Dumitru Glavan) [#16803](https://github.com/nodejs/node/pull/16803)
* [[`1e6845d024`](https://github.com/nodejs/node/commit/1e6845d024)] - **test**: replace common.fixturesDir with fixtures.readSync() (Adri Van Houdt) [#16802](https://github.com/nodejs/node/pull/16802)
* [[`7b1491711d`](https://github.com/nodejs/node/commit/7b1491711d)] - **test**: replace `common.fixturesDir` usage (Sascha Tandel) [#16800](https://github.com/nodejs/node/pull/16800)
* [[`480f14a55e`](https://github.com/nodejs/node/commit/480f14a55e)] - **test**: update test to use fixtures (Adam Wegrzynek) [#16799](https://github.com/nodejs/node/pull/16799)
* [[`c52ac92661`](https://github.com/nodejs/node/commit/c52ac92661)] - **test**: fix malformed parallel.status line (Rich Trott) [#16702](https://github.com/nodejs/node/pull/16702)
* [[`a41cc020fd`](https://github.com/nodejs/node/commit/a41cc020fd)] - **test**: fix flaky test-http2-server-rst-stream.js (Anatoli Papirovski) [#16690](https://github.com/nodejs/node/pull/16690)
* [[`1e8a421159`](https://github.com/nodejs/node/commit/1e8a421159)] - **test**: pause child until parent is ready (jBarz) [#15774](https://github.com/nodejs/node/pull/15774)
* [[`b3032d29c9`](https://github.com/nodejs/node/commit/b3032d29c9)] - **test**: increase coverage for ModuleMap (Rob Paton) [#16045](https://github.com/nodejs/node/pull/16045)
* [[`2f66faf6cf`](https://github.com/nodejs/node/commit/2f66faf6cf)] - **test**: use fixtures module in test-https-pfx (Ken Takagi) [#15895](https://github.com/nodejs/node/pull/15895)
* [[`981a1ef0c2`](https://github.com/nodejs/node/commit/981a1ef0c2)] - **test**: use ES6 classes instead of util.inherits (Tobias Nießen) [#16938](https://github.com/nodejs/node/pull/16938)
* [[`47b1c3b43c`](https://github.com/nodejs/node/commit/47b1c3b43c)] - **test**: add test for WrapStream readStop (Ashish Kaila) [#16356](https://github.com/nodejs/node/pull/16356)
* [[`72c34cf706`](https://github.com/nodejs/node/commit/72c34cf706)] - **test,net**: remove scatological terminology (Rich Trott) [#16599](https://github.com/nodejs/node/pull/16599)
* [[`2b903bff05`](https://github.com/nodejs/node/commit/2b903bff05)] - **tools**: enforce no unused trailing arguments tools directory (Rich Trott) [#16953](https://github.com/nodejs/node/pull/16953)
* [[`57937e5746`](https://github.com/nodejs/node/commit/57937e5746)] - **tools**: remove unused trailing function arguments (Rich Trott) [#16953](https://github.com/nodejs/node/pull/16953)
* [[`85fd7bb8f7`](https://github.com/nodejs/node/commit/85fd7bb8f7)] - **tools**: fix inspector-check reporting (Daniel Bevenius) [#16902](https://github.com/nodejs/node/pull/16902)
* [[`8538354139`](https://github.com/nodejs/node/commit/8538354139)] - **tools**: add direct anchors for error codes (Joyee Cheung) [#16779](https://github.com/nodejs/node/pull/16779)
* [[`79006dab87`](https://github.com/nodejs/node/commit/79006dab87)] - **tools**: don't lint files that have not changed (Joyee Cheung) [#16581](https://github.com/nodejs/node/pull/16581)
* [[`cb08f5d6fe`](https://github.com/nodejs/node/commit/cb08f5d6fe)] - **tools**: remove unneeded parentheses in doc/html.js (Vse Mozhet Byt) [#16845](https://github.com/nodejs/node/pull/16845)
* [[`60c918ac7a`](https://github.com/nodejs/node/commit/60c918ac7a)] - **tools**: replace string concatenation with template literals (Kevin Yu) [#16804](https://github.com/nodejs/node/pull/16804)
* [[`aaf7e83d62`](https://github.com/nodejs/node/commit/aaf7e83d62)] - **tools**: replace string concatenation with template literals (Giovanni Lela) [#16806](https://github.com/nodejs/node/pull/16806)
* [[`40fa970914`](https://github.com/nodejs/node/commit/40fa970914)] - **tools**: replace string concetation with templates (Patrick Heneise) [#16801](https://github.com/nodejs/node/pull/16801)
* [[`0d4f62c85f`](https://github.com/nodejs/node/commit/0d4f62c85f)] - **tools,build**: allow build without `remark-cli` (Refael Ackermann) [#16893](https://github.com/nodejs/node/pull/16893)

<a id="8.9.1"></a>
## 2017-11-07, Version 8.9.1 'Carbon' (LTS), @gibfahn

### Notable Changes

- **openssl**:
  - upgrade openssl sources to 1.0.2m (Shigeki Ohtsu) [#16691](https://github.com/nodejs/node/pull/16691)
- ***Revert*** "**https**:
  - refactor to use http internals" (Myles Borins) [#16660](https://github.com/nodejs/node/pull/16660)

### Commits

* [[`6a7e5ceaa9`](https://github.com/nodejs/node/commit/6a7e5ceaa9)] - **deps**: V8: cherry-pick 32141e9 from upstream (Ali Ijaz Sheikh) [#16704](https://github.com/nodejs/node/pull/16704)
* [[`a815e1b6a2`](https://github.com/nodejs/node/commit/a815e1b6a2)] - **deps**: cherry-pick e7f4e9e from upstream libuv (Bartosz Sosnowski) [#16724](https://github.com/nodejs/node/pull/16724)
* [[`7f86e8190c`](https://github.com/nodejs/node/commit/7f86e8190c)] - **deps**: update openssl asm and asm_obsolete files (Shigeki Ohtsu) [#16691](https://github.com/nodejs/node/pull/16691)
* [[`1af2244020`](https://github.com/nodejs/node/commit/1af2244020)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`9d98dcc395`](https://github.com/nodejs/node/commit/9d98dcc395)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`99319efc45`](https://github.com/nodejs/node/commit/99319efc45)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`151a8da4b7`](https://github.com/nodejs/node/commit/151a8da4b7)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#16691](https://github.com/nodejs/node/pull/16691)
* [[`d68e53452c`](https://github.com/nodejs/node/commit/d68e53452c)] - **deps**: upgrade openssl sources to 1.0.2m (Shigeki Ohtsu) [#16691](https://github.com/nodejs/node/pull/16691)
* [[`a3be5bc560`](https://github.com/nodejs/node/commit/a3be5bc560)] - **doc**: add 9.x to version picker and mark 8.x as LTS (Chris Young) [#16672](https://github.com/nodejs/node/pull/16672)
* [[`08b75c1591`](https://github.com/nodejs/node/commit/08b75c1591)] - ***Revert*** "**https**: refactor to use http internals" (Myles Borins) [#16660](https://github.com/nodejs/node/pull/16660)
* [[`d334a95834`](https://github.com/nodejs/node/commit/d334a95834)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`bf26b96fd6`](https://github.com/nodejs/node/commit/bf26b96fd6)] - **src**: add 'dynamic' process.release.lts property (Rod Vagg) [#16656](https://github.com/nodejs/node/pull/16656)
* [[`dfac6cc0bb`](https://github.com/nodejs/node/commit/dfac6cc0bb)] - **test**: update process-release for Node 8 Carbon (Jeremiah Senkpiel) [#16656](https://github.com/nodejs/node/pull/16656)

<a id="8.9.0"></a>
## 2017-10-31, Version 8.9.0 'Carbon' (LTS), @gibfahn

This release marks the transition of Node.js v8 into Long Term Support (LTS) with the codename 'Carbon'. The v8 release line now moves in to "Active LTS" and will remain so until April 2019. After that time it will move in to "Maintenance" until end of life in December 2019.

### Notable Changes

* **doc**:
  - add Gibson Fahnestock to Release team (Gibson Fahnestock) [#16620](https://github.com/nodejs/node/pull/16620)
* **deps**:
  - update npm to 5.5.1 (Myles Borins) [#16509](https://github.com/nodejs/node/pull/16509)
* **http2**:
  - The exposed http2 socket is no longer manipulatable (Anatoli Papirovski) [#16330](https://github.com/nodejs/node/pull/16330)
* **module**:
  - support custom paths to require.resolve() (cjihrig) [#16397](https://github.com/nodejs/node/pull/16397)
* **util**:
  - util.TextEncoder and util.TextDecoder are no longer experimental. There will no longer be a warning when they are used  (James M Snell) [#15743](https://github.com/nodejs/node/pull/15743)

### Commits

* [[`d576e17691`](https://github.com/nodejs/node/commit/d576e17691)] - **build**: make test-doc and lint addon docs (Joyee Cheung) [#16377](https://github.com/nodejs/node/pull/16377)
* [[`63e33ac327`](https://github.com/nodejs/node/commit/63e33ac327)] - **build**: make doc target quiet (Daniel Bevenius) [#16516](https://github.com/nodejs/node/pull/16516)
* [[`528edb2ea8`](https://github.com/nodejs/node/commit/528edb2ea8)] - **build**: ignore empty folders in test-addons-napi (Anna Henningsen) [#16380](https://github.com/nodejs/node/pull/16380)
* [[`c8a3b2d171`](https://github.com/nodejs/node/commit/c8a3b2d171)] - **build**: run linter before running tests (Joyee Cheung) [#16284](https://github.com/nodejs/node/pull/16284)
* [[`a763fcd7a7`](https://github.com/nodejs/node/commit/a763fcd7a7)] - **build**: improve `make clean` (Refael Ackermann) [#16372](https://github.com/nodejs/node/pull/16372)
* [[`0a1f7fefc6`](https://github.com/nodejs/node/commit/0a1f7fefc6)] - **build**: skip bin override on windows (Hitesh Kanwathirtha) [#16460](https://github.com/nodejs/node/pull/16460)
* [[`3b64fa451e`](https://github.com/nodejs/node/commit/3b64fa451e)] - **build**: fix npm install with --shared (Ben Noordhuis) [#16438](https://github.com/nodejs/node/pull/16438)
* [[`9185cfef9c`](https://github.com/nodejs/node/commit/9185cfef9c)] - **build**: add lint-md-build (Daijiro Wachi) [#12756](https://github.com/nodejs/node/pull/12756)
* [[`22ec800b20`](https://github.com/nodejs/node/commit/22ec800b20)] - **build**: do not include deleted directory (Jon Moss) [#16384](https://github.com/nodejs/node/pull/16384)
* [[`b5c6d596ca`](https://github.com/nodejs/node/commit/b5c6d596ca)] - **build,win**: set /MP separately in Debug and Release (Nikolai Vavilov) [#16415](https://github.com/nodejs/node/pull/16415)
* [[`9bea207e83`](https://github.com/nodejs/node/commit/9bea207e83)] - **child_process**: fix memory leak in .fork() (Ben Noordhuis) [#15679](https://github.com/nodejs/node/pull/15679)
* [[`bf2564df0d`](https://github.com/nodejs/node/commit/bf2564df0d)] - **deps**: V8: backport b1cd96e from upstream (Ali Ijaz Sheikh) [#16308](https://github.com/nodejs/node/pull/16308)
* [[`ad692074a4`](https://github.com/nodejs/node/commit/ad692074a4)] - **deps**: cherry-pick e0d64dc from upstream V8 (Michaël Zasso) [#16490](https://github.com/nodejs/node/pull/16490)
* [[`7bdb8db440`](https://github.com/nodejs/node/commit/7bdb8db440)] - **deps**: cherry-pick 676c413 from upstream V8 (Michaël Zasso) [#16490](https://github.com/nodejs/node/pull/16490)
* [[`5787f5331f`](https://github.com/nodejs/node/commit/5787f5331f)] - **deps**: cherry-pick 2c75616 from upstream V8 (Michaël Zasso) [#16490](https://github.com/nodejs/node/pull/16490)
* [[`0d7e4d2bdc`](https://github.com/nodejs/node/commit/0d7e4d2bdc)] - **deps**: update npm to 5.5.1 (Myles Borins) [#16509](https://github.com/nodejs/node/pull/16509)
* [[`4d9c1bedbd`](https://github.com/nodejs/node/commit/4d9c1bedbd)] - **doc**: add Gibson Fahnestock to Release team (Gibson Fahnestock) [#16620](https://github.com/nodejs/node/pull/16620)
* [[`d6619b9ad4`](https://github.com/nodejs/node/commit/d6619b9ad4)] - **doc**: document missing error codes (George Bezerra) [#15160](https://github.com/nodejs/node/pull/15160)
* [[`fdc072bd9c`](https://github.com/nodejs/node/commit/fdc072bd9c)] - **doc**: fix inconsistent server.listen documentation (Martin Michaelis) [#16020](https://github.com/nodejs/node/pull/16020)
* [[`a6b3cd8166`](https://github.com/nodejs/node/commit/a6b3cd8166)] - **doc**: more accurate zlib windowBits information (Anna Henningsen) [#16511](https://github.com/nodejs/node/pull/16511)
* [[`e5c2059f88`](https://github.com/nodejs/node/commit/e5c2059f88)] - **doc**: make default values and periods consistent (Matej Krajčovič) [#16563](https://github.com/nodejs/node/pull/16563)
* [[`b93275e1a3`](https://github.com/nodejs/node/commit/b93275e1a3)] - **doc**: slightly relax 50 character rule (James M Snell) [#16523](https://github.com/nodejs/node/pull/16523)
* [[`1b08ae853e`](https://github.com/nodejs/node/commit/1b08ae853e)] - **doc**: http2.connect accepts net & tls options (Anatoli Papirovski) [#16576](https://github.com/nodejs/node/pull/16576)
* [[`04602109e8`](https://github.com/nodejs/node/commit/04602109e8)] - **doc**: add note to releases.md (Jon Moss) [#16507](https://github.com/nodejs/node/pull/16507)
* [[`03b233ed40`](https://github.com/nodejs/node/commit/03b233ed40)] - **doc**: fix CHANGELOG_V8 indentation (Jon Moss) [#16507](https://github.com/nodejs/node/pull/16507)
* [[`a7540d59e8`](https://github.com/nodejs/node/commit/a7540d59e8)] - **doc**: remove http2 pushStream weight option (Sebastiaan Deckers) [#16451](https://github.com/nodejs/node/pull/16451)
* [[`4ba06d07cc`](https://github.com/nodejs/node/commit/4ba06d07cc)] - **doc**: add dot in documentations (erwinwahyura) [#16542](https://github.com/nodejs/node/pull/16542)
* [[`83902e6e02`](https://github.com/nodejs/node/commit/83902e6e02)] - **doc**: add multiple build guide to benchmarking doc (Peter Marton) [#16142](https://github.com/nodejs/node/pull/16142)
* [[`04fac61fdd`](https://github.com/nodejs/node/commit/04fac61fdd)] - **doc**: improve http2 documentation (Jacob Hoffman-Andrews) [#16366](https://github.com/nodejs/node/pull/16366)
* [[`fe5d4535c9`](https://github.com/nodejs/node/commit/fe5d4535c9)] - **doc, win**: remove note about resize (Bartosz Sosnowski) [#16320](https://github.com/nodejs/node/pull/16320)
* [[`54ebf91394`](https://github.com/nodejs/node/commit/54ebf91394)] - **http2**: make sessions garbage-collectible (Anna Henningsen) [#16461](https://github.com/nodejs/node/pull/16461)
* [[`bfc1ad07a3`](https://github.com/nodejs/node/commit/bfc1ad07a3)] - **http2**: remove unused assignment (Anna Henningsen) [#16461](https://github.com/nodejs/node/pull/16461)
* [[`56dd734a6a`](https://github.com/nodejs/node/commit/56dd734a6a)] - **http2**: track async state for sending (Anna Henningsen) [#16461](https://github.com/nodejs/node/pull/16461)
* [[`5390d7e374`](https://github.com/nodejs/node/commit/5390d7e374)] - **http2**: move uv_prepare handle to `Http2Session` (Anna Henningsen) [#16461](https://github.com/nodejs/node/pull/16461)
* [[`95a61cbb1e`](https://github.com/nodejs/node/commit/95a61cbb1e)] - **http2**: fix stream reading resumption (Anatoli Papirovski) [#16580](https://github.com/nodejs/node/pull/16580)
* [[`98b9705cb8`](https://github.com/nodejs/node/commit/98b9705cb8)] - **http2**: simplify mapToHeaders, stricter validation (Anatoli Papirovski) [#16575](https://github.com/nodejs/node/pull/16575)
* [[`e592c320ce`](https://github.com/nodejs/node/commit/e592c320ce)] - **http2**: fix several timeout related issues (Anatoli Papirovski) [#16525](https://github.com/nodejs/node/pull/16525)
* [[`24fd8ff32a`](https://github.com/nodejs/node/commit/24fd8ff32a)] - **http2**: adjust stream buffer size (Anatoli Papirovski) [#16445](https://github.com/nodejs/node/pull/16445)
* [[`2c2b6586e7`](https://github.com/nodejs/node/commit/2c2b6586e7)] - **http2**: fix mapToHeaders() with single string value (Jinwoo Lee) [#16458](https://github.com/nodejs/node/pull/16458)
* [[`e6e99eb447`](https://github.com/nodejs/node/commit/e6e99eb447)] - **http2**: do not allow socket manipulation (Anatoli Papirovski) [#16330](https://github.com/nodejs/node/pull/16330)
* [[`3638694d8b`](https://github.com/nodejs/node/commit/3638694d8b)] - **http2**: fix errors in debug statements (Anatoli Papirovski) [#16373](https://github.com/nodejs/node/pull/16373)
* [[`754df71a79`](https://github.com/nodejs/node/commit/754df71a79)] - **https**: refactor to use http internals (Bryan English) [#16395](https://github.com/nodejs/node/pull/16395)
* [[`2ea25ad3e2`](https://github.com/nodejs/node/commit/2ea25ad3e2)] - **inspector**: track async stacks when necessary (Ali Ijaz Sheikh) [#16308](https://github.com/nodejs/node/pull/16308)
* [[`ab0d7a64aa`](https://github.com/nodejs/node/commit/ab0d7a64aa)] - **lib**: refactor wrap_js_stream for ES6/readability (Anna Henningsen) [#16158](https://github.com/nodejs/node/pull/16158)
* [[`87fd5b798f`](https://github.com/nodejs/node/commit/87fd5b798f)] - **lib**: move _stream_wrap into internals (Anna Henningsen) [#16158](https://github.com/nodejs/node/pull/16158)
* [[`96e82509b0`](https://github.com/nodejs/node/commit/96e82509b0)] - **lib**: use destructuring for some constants (Weijia Wang) [#16063](https://github.com/nodejs/node/pull/16063)
* [[`6be494251b`](https://github.com/nodejs/node/commit/6be494251b)] - **lib**: move duplicate spliceOne into internal/util (Weijia Wang) [#16221](https://github.com/nodejs/node/pull/16221)
* [[`8c0c456c73`](https://github.com/nodejs/node/commit/8c0c456c73)] - **lib**: setup IPC channel before console (Nikolai Vavilov) [#16562](https://github.com/nodejs/node/pull/16562)
* [[`3a230b42f3`](https://github.com/nodejs/node/commit/3a230b42f3)] - **lib**: internal/errors should not be executable (Jon Moss) [#16369](https://github.com/nodejs/node/pull/16369)
* [[`415fb56735`](https://github.com/nodejs/node/commit/415fb56735)] - **module**: fix extension lookups for top-level main (Guy Bedford) [#16526](https://github.com/nodejs/node/pull/16526)
* [[`e68307737c`](https://github.com/nodejs/node/commit/e68307737c)] - **module**: fix hook module CJS dependency loading (guybedford) [#16381](https://github.com/nodejs/node/pull/16381)
* [[`ac02a0be28`](https://github.com/nodejs/node/commit/ac02a0be28)] - **(SEMVER-MINOR)** **module**: support custom paths to require.resolve() (cjihrig) [#16397](https://github.com/nodejs/node/pull/16397)
* [[`e578268ef9`](https://github.com/nodejs/node/commit/e578268ef9)] - **src**: add `InternalCallbackScope` util constructor (Anna Henningsen) [#16461](https://github.com/nodejs/node/pull/16461)
* [[`6ac7eefe41`](https://github.com/nodejs/node/commit/6ac7eefe41)] - **src**: move handle properties to prototype (Ben Noordhuis) [#16482](https://github.com/nodejs/node/pull/16482)
* [[`3a54bb5c2c`](https://github.com/nodejs/node/commit/3a54bb5c2c)] - **src**: remove superfluous HandleScope (Ben Noordhuis) [#16482](https://github.com/nodejs/node/pull/16482)
* [[`77c02aab5b`](https://github.com/nodejs/node/commit/77c02aab5b)] - **src**: use uv_stream_t, not uv_stream_s (Ben Noordhuis) [#16512](https://github.com/nodejs/node/pull/16512)
* [[`a194d831fe`](https://github.com/nodejs/node/commit/a194d831fe)] - **src**: use maybe versions of methods (Tom Boutell) [#16005](https://github.com/nodejs/node/pull/16005)
* [[`ec5168813b`](https://github.com/nodejs/node/commit/ec5168813b)] - **src**: use V8 function to get Module Namespace (Bradley Farias) [#16261](https://github.com/nodejs/node/pull/16261)
* [[`0a5a2c43b1`](https://github.com/nodejs/node/commit/0a5a2c43b1)] - **src**: fix vm module for strict mode (Franziska Hinkelmann) [#16487](https://github.com/nodejs/node/pull/16487)
* [[`ee40368c87`](https://github.com/nodejs/node/commit/ee40368c87)] - **src**: make header file self-contained (Joyee Cheung) [#16518](https://github.com/nodejs/node/pull/16518)
* [[`465540cc98`](https://github.com/nodejs/node/commit/465540cc98)] - **src**: destroy inspector agent before context (Ali Ijaz Sheikh) [#16472](https://github.com/nodejs/node/pull/16472)
* [[`9bca6200ad`](https://github.com/nodejs/node/commit/9bca6200ad)] - **src**: remove empty comment in node_http2.h (Daniel Bevenius) [#16400](https://github.com/nodejs/node/pull/16400)
* [[`f0576c5ee0`](https://github.com/nodejs/node/commit/f0576c5ee0)] - **src**: remove unused include in tty_wrap.h (Daniel Bevenius) [#16379](https://github.com/nodejs/node/pull/16379)
* [[`f00ba6b142`](https://github.com/nodejs/node/commit/f00ba6b142)] - **src**: fix http2 debug build errors (Daniel Bevenius) [#16432](https://github.com/nodejs/node/pull/16432)
* [[`889f42a924`](https://github.com/nodejs/node/commit/889f42a924)] - **test**: remove empty comments in http2 tests (Gibson Fahnestock) [#16631](https://github.com/nodejs/node/pull/16631)
* [[`a62845565e`](https://github.com/nodejs/node/commit/a62845565e)] - **test**: add block scoping to test-assert-deep (Rich Trott) [#16532](https://github.com/nodejs/node/pull/16532)
* [[`0510f42efc`](https://github.com/nodejs/node/commit/0510f42efc)] - **test**: update test-timers-block-eventloop.js (zhangzifa) [#16314](https://github.com/nodejs/node/pull/16314)
* [[`bac2aff23d`](https://github.com/nodejs/node/commit/bac2aff23d)] - **test**: include actual value in assertion message (Matthew Cantelon) [#15935](https://github.com/nodejs/node/pull/15935)
* [[`d185bfdcef`](https://github.com/nodejs/node/commit/d185bfdcef)] - **test**: replace fixturesDir in test-tls-connect (Casie Lynch) [#15849](https://github.com/nodejs/node/pull/15849)
* [[`ce07cbeacb`](https://github.com/nodejs/node/commit/ce07cbeacb)] - **test**: use fixtures module (Iryna Yaremtso) [#15901](https://github.com/nodejs/node/pull/15901)
* [[`2e1b45db07`](https://github.com/nodejs/node/commit/2e1b45db07)] - **test**: add details in assertions in test-vm-context (Vladimir Ilic) [#16116](https://github.com/nodejs/node/pull/16116)
* [[`4f47e2df44`](https://github.com/nodejs/node/commit/4f47e2df44)] - **test**: increase fs.exists coverage (Nigel Kibodeaux) [#15963](https://github.com/nodejs/node/pull/15963)
* [[`01058c412e`](https://github.com/nodejs/node/commit/01058c412e)] - **test**: use fixtures module in test-fs-realpath.js (Raphael Rheault) [#15904](https://github.com/nodejs/node/pull/15904)
* [[`fe9cca2e0f`](https://github.com/nodejs/node/commit/fe9cca2e0f)] - **test**: use fixtures module (Scott J Beck) [#15843](https://github.com/nodejs/node/pull/15843)
* [[`b4af92280b`](https://github.com/nodejs/node/commit/b4af92280b)] - **test**: imporove assert messages (Hadis-Fard) [#16021](https://github.com/nodejs/node/pull/16021)
* [[`604ab12447`](https://github.com/nodejs/node/commit/604ab12447)] - **test**: show values instead of assertion message (Cheyenne Arrowsmith) [#15979](https://github.com/nodejs/node/pull/15979)
* [[`aea09da6f9`](https://github.com/nodejs/node/commit/aea09da6f9)] - **test**: include values in assertion messages (nhoel) [#15996](https://github.com/nodejs/node/pull/15996)
* [[`ea32d0ec4e`](https://github.com/nodejs/node/commit/ea32d0ec4e)] - **test**: use process.features.debug in common module (Rich Trott) [#16537](https://github.com/nodejs/node/pull/16537)
* [[`a0fcd4d219`](https://github.com/nodejs/node/commit/a0fcd4d219)] - **test**: use common.buildType in repl-domain-abort (Rich Trott) [#16538](https://github.com/nodejs/node/pull/16538)
* [[`525700b3d5`](https://github.com/nodejs/node/commit/525700b3d5)] - **test**: skip test-process-config if no config.gypi (Gibson Fahnestock) [#16436](https://github.com/nodejs/node/pull/16436)
* [[`aaacddbcbf`](https://github.com/nodejs/node/commit/aaacddbcbf)] - **test**: use fixtures module in tls-handshake-error (Mark Walker) [#15939](https://github.com/nodejs/node/pull/15939)
* [[`977fe22290`](https://github.com/nodejs/node/commit/977fe22290)] - **test**: add failing vm tests to known_issues (Michaël Zasso) [#16410](https://github.com/nodejs/node/pull/16410)
* [[`02ac8bae91`](https://github.com/nodejs/node/commit/02ac8bae91)] - **test**: change tmp directories prefix (Refael Ackermann) [#16372](https://github.com/nodejs/node/pull/16372)
* [[`568d614dc3`](https://github.com/nodejs/node/commit/568d614dc3)] - **test**: allow tests to pass without internet (Daniel Bevenius) [#16255](https://github.com/nodejs/node/pull/16255)
* [[`3d8a7e97fe`](https://github.com/nodejs/node/commit/3d8a7e97fe)] - **tools**: modernize license2rtf (Tobias Nießen) [#16220](https://github.com/nodejs/node/pull/16220)
* [[`d5891b5330`](https://github.com/nodejs/node/commit/d5891b5330)] - **tools**: replace loop with padStart (Tobias Nießen) [#16220](https://github.com/nodejs/node/pull/16220)
* [[`b1e2a38d90`](https://github.com/nodejs/node/commit/b1e2a38d90)] - **tools**: fix cpplint.py when path contains non-ascii (sharkfisher) [#16047](https://github.com/nodejs/node/pull/16047)
* [[`e80d878b3f`](https://github.com/nodejs/node/commit/e80d878b3f)] - **tools**: no trailing slash in ignore patterns (Refael Ackermann) [#16372](https://github.com/nodejs/node/pull/16372)
* [[`31f54e5fb9`](https://github.com/nodejs/node/commit/31f54e5fb9)] - **tools**: add make lint-md-clean (Daijiro Wachi) [#12756](https://github.com/nodejs/node/pull/12756)
* [[`ea415a663e`](https://github.com/nodejs/node/commit/ea415a663e)] - **tools**: add lint-md command in Makefile (Daijiro Wachi) [#12756](https://github.com/nodejs/node/pull/12756)
* [[`3522e765be`](https://github.com/nodejs/node/commit/3522e765be)] - **tools**: use remark-preset-lint-node in .remarkrc (Daijiro Wachi) [#12756](https://github.com/nodejs/node/pull/12756)
* [[`8d62116cf0`](https://github.com/nodejs/node/commit/8d62116cf0)] - **tools**: introduce remark-preset-lint-node (Daijiro Wachi) [#12756](https://github.com/nodejs/node/pull/12756)
* [[`3d499b3712`](https://github.com/nodejs/node/commit/3d499b3712)] - **tools**: introduce remark-cli@3.0.1 (Daijiro Wachi) [#12756](https://github.com/nodejs/node/pull/12756)
* [[`55ba1d4115`](https://github.com/nodejs/node/commit/55ba1d4115)] - **util**: expand test coverage for util.deprecate (Ashish Kaila) [#16305](https://github.com/nodejs/node/pull/16305)
* [[`8fd75fb9b5`](https://github.com/nodejs/node/commit/8fd75fb9b5)] - **(SEMVER-MINOR)** **util**: graduate TextEncoder/TextDecoder, tests (James M Snell) [#15743](https://github.com/nodejs/node/pull/15743)

<a id="8.8.1"></a>
## 2017-10-25, Version 8.8.1 (Current), @cjihrig

### Notable Changes

* **net**:
  - Fix timeout with null handle issue. This is a regression in Node 8.8.0 [#16489](https://github.com/nodejs/node/pull/16489)

### Commits

* [[`db8c92fb42`](https://github.com/nodejs/node/commit/db8c92fb42)] - **doc**: fix spelling in v8.8.0 changelog (Myles Borins) [#16477](https://github.com/nodejs/node/pull/16477)
* [[`c8396b8370`](https://github.com/nodejs/node/commit/c8396b8370)] - **doc**: remove loader hooks from unsupported features (Teppei Sato) [#16465](https://github.com/nodejs/node/pull/16465)
* [[`2b0bb57055`](https://github.com/nodejs/node/commit/2b0bb57055)] - **doc**: fix wrong URL (Jon Moss) [#16470](https://github.com/nodejs/node/pull/16470)
* [[`9ffc32974e`](https://github.com/nodejs/node/commit/9ffc32974e)] - **doc**: fix typo in changelog for 8.8.0 (Alec Perkins) [#16462](https://github.com/nodejs/node/pull/16462)
* [[`7facaa5031`](https://github.com/nodejs/node/commit/7facaa5031)] - **doc**: fix missing newline character (Daijiro Wachi) [#16447](https://github.com/nodejs/node/pull/16447)
* [[`16eb7d3a5f`](https://github.com/nodejs/node/commit/16eb7d3a5f)] - **doc**: fix doc styles (Daijiro Wachi) [#16385](https://github.com/nodejs/node/pull/16385)
* [[`99fdc1d04f`](https://github.com/nodejs/node/commit/99fdc1d04f)] - **doc**: add recommendations for first timers (Refael Ackermann) [#16350](https://github.com/nodejs/node/pull/16350)
* [[`6fbef7f350`](https://github.com/nodejs/node/commit/6fbef7f350)] - **doc**: fix typo in zlib.md (Luigi Pinca) [#16480](https://github.com/nodejs/node/pull/16480)
* [[`655e017e40`](https://github.com/nodejs/node/commit/655e017e40)] - **net**: fix timeout with null handle (Anatoli Papirovski) [#16489](https://github.com/nodejs/node/pull/16489)
* [[`7fad10cc7e`](https://github.com/nodejs/node/commit/7fad10cc7e)] - **test**: make test-v8-serdes work without stdin (Anna Henningsen)
* [[`12dc06e3e1`](https://github.com/nodejs/node/commit/12dc06e3e1)] - **test**: call toLowerCase on the resolved module (Daniel Bevenius) [#16486](https://github.com/nodejs/node/pull/16486)
* [[`10894c3835`](https://github.com/nodejs/node/commit/10894c3835)] - **test**: allow for different nsswitch.conf settings (Daniel Bevenius) [#16378](https://github.com/nodejs/node/pull/16378)
* [[`2a53165aa0`](https://github.com/nodejs/node/commit/2a53165aa0)] - **test**: add missing assertion (cjihrig) [#15519](https://github.com/nodejs/node/pull/15519)

<a id="8.8.0"></a>
## 2017-10-24, Version 8.8.0 (Current), @MylesBorins

### Notable Changes

* **crypto**:
  - expose ECDH class [#8188](https://github.com/nodejs/node/pull/8188)
* **http2**:
  - http2 is now exposed by default without the need for a flag [#15685](https://github.com/nodejs/node/pull/15685)
  - a new environment variable NODE\_NO\_HTTP2 has been added to allow userland http2 to be required [#15685](https://github.com/nodejs/node/pull/15685)
  - support has been added for generic `Duplex` streams [#16269](https://github.com/nodejs/node/pull/16269)
* **module**:
  - resolve and instantiate loader pipeline hooks have been added to the ESM lifecycle [#15445](https://github.com/nodejs/node/pull/15445)
* **zlib**:
  - CVE-2017-14919 - In zlib v1.2.9, a change was made that causes an error to be raised when a raw deflate stream is initialized with windowBits set to 8. On some versions this crashes Node and you cannot recover from it, while on some versions it throws an exception. Node.js will now gracefully set windowBits to 9 replicating the legacy behavior to avoid a DOS vector. [nodejs-private/node-private#95](https://github.com/nodejs-private/node-private/pull/95)

### Commits

* [[`c62f2e21c0`](https://github.com/nodejs/node/commit/c62f2e21c0)] - **assert**: fix actual and expected order (Steve Jenkins) [#15866](https://github.com/nodejs/node/pull/15866)
* [[`c9715bb9c2`](https://github.com/nodejs/node/commit/c9715bb9c2)] - **async_hooks**: skip runtime checks when disabled (Andreas Madsen) [#15454](https://github.com/nodejs/node/pull/15454)
* [[`11b775beb6`](https://github.com/nodejs/node/commit/11b775beb6)] - **async_hooks**: replace concat w template literals (Rob Adelmann) [#15968](https://github.com/nodejs/node/pull/15968)
* [[`5d34f2f5a7`](https://github.com/nodejs/node/commit/5d34f2f5a7)] - **benchmark**: improve http2 benchmark configs (James M Snell) [#16239](https://github.com/nodejs/node/pull/16239)
* [[`b1a68f52e2`](https://github.com/nodejs/node/commit/b1a68f52e2)] - **benchmark**: add util/type-check (Timothy Gu) [#15663](https://github.com/nodejs/node/pull/15663)
* [[`6f64a4456f`](https://github.com/nodejs/node/commit/6f64a4456f)] - **benchmark**: remove writing to benchmark directory (Rich Trott) [#16144](https://github.com/nodejs/node/pull/16144)
* [[`dc48e9cdaf`](https://github.com/nodejs/node/commit/dc48e9cdaf)] - **benchmark**: remove misc/v8-bench.js (Joyee Cheung) [#16126](https://github.com/nodejs/node/pull/16126)
* [[`a16d314214`](https://github.com/nodejs/node/commit/a16d314214)] - **build**: use bin override if no `python` in PATH (Bradley T. Hughes) [#16241](https://github.com/nodejs/node/pull/16241)
* [[`6ce04d94f9`](https://github.com/nodejs/node/commit/6ce04d94f9)] - **build**: revert "call setlocal in vcbuild.bat" (Refael Ackermann) [#16270](https://github.com/nodejs/node/pull/16270)
* [[`dfaa05722b`](https://github.com/nodejs/node/commit/dfaa05722b)] - **build**: use doc-only instead of doc (Rich Trott) [#16309](https://github.com/nodejs/node/pull/16309)
* [[`2cfcc45ae1`](https://github.com/nodejs/node/commit/2cfcc45ae1)] - **build**: add c++ coverage support on macOS (Evan Lucas) [#16163](https://github.com/nodejs/node/pull/16163)
* [[`e32b10f469`](https://github.com/nodejs/node/commit/e32b10f469)] - **build**: set disable_glibcxx_debug flag (Anna Henningsen) [#16159](https://github.com/nodejs/node/pull/16159)
* [[`ea0fec25fe`](https://github.com/nodejs/node/commit/ea0fec25fe)] - **build**: lint benchmark addon (Ben Noordhuis) [#16160](https://github.com/nodejs/node/pull/16160)
* [[`c032b5ffe7`](https://github.com/nodejs/node/commit/c032b5ffe7)] - **build**: use local node-gyp for benchmark addon (Ben Noordhuis) [#16160](https://github.com/nodejs/node/pull/16160)
* [[`ce2eeb9a0b`](https://github.com/nodejs/node/commit/ce2eeb9a0b)] - **build**: restore mistakenly dropped suites (Refael Ackermann) [#16132](https://github.com/nodejs/node/pull/16132)
* [[`37ab447942`](https://github.com/nodejs/node/commit/37ab447942)] - **build**: correct minor typo in lttng help message (Daniel Bevenius) [#16101](https://github.com/nodejs/node/pull/16101)
* [[`f5c0d74eda`](https://github.com/nodejs/node/commit/f5c0d74eda)] - **build**: ignore empty folders in test-addons (Gregor) [#16031](https://github.com/nodejs/node/pull/16031)
* [[`152ca1e49b`](https://github.com/nodejs/node/commit/152ca1e49b)] - **build, windows**: use /bigobj for debug builds (Nikolai Vavilov) [#16289](https://github.com/nodejs/node/pull/16289)
* [[`3951c15212`](https://github.com/nodejs/node/commit/3951c15212)] - **build,win**: use /MP for debug builds (Nikolai Vavilov) [#16333](https://github.com/nodejs/node/pull/16333)
* [[`c9ec12d3e6`](https://github.com/nodejs/node/commit/c9ec12d3e6)] - **build,win**: enable lint option to run "standalone" (Daniel Bevenius) [#16176](https://github.com/nodejs/node/pull/16176)
* [[`6e2a6b2c7e`](https://github.com/nodejs/node/commit/6e2a6b2c7e)] - **build,win**: include addons-napi in linter (Daniel Bevenius) [#16181](https://github.com/nodejs/node/pull/16181)
* [[`81d01bccd1`](https://github.com/nodejs/node/commit/81d01bccd1)] - **child_process**: add windowsHide option (cjihrig) [#15380](https://github.com/nodejs/node/pull/15380)
* [[`a5c3143539`](https://github.com/nodejs/node/commit/a5c3143539)] - **(SEMVER-MINOR)** **crypto**: expose ECDH class (Bryan English) [#8188](https://github.com/nodejs/node/pull/8188)
* [[`ff25ca70b2`](https://github.com/nodejs/node/commit/ff25ca70b2)] - **doc**: replace undocumented encoding aliases (Vse Mozhet Byt) [#16368](https://github.com/nodejs/node/pull/16368)
* [[`8f08d6653d`](https://github.com/nodejs/node/commit/8f08d6653d)] - **doc**: async_hooks grammar nits (Jon Moss) [#16361](https://github.com/nodejs/node/pull/16361)
* [[`b96d76f3a7`](https://github.com/nodejs/node/commit/b96d76f3a7)] - **doc**: link to async_hooks destroy callback properly (Jon Moss) [#16351](https://github.com/nodejs/node/pull/16351)
* [[`71e6c6ea9c`](https://github.com/nodejs/node/commit/71e6c6ea9c)] - **doc**: fix some links (Vse Mozhet Byt) [#16202](https://github.com/nodejs/node/pull/16202)
* [[`fbd3c80316`](https://github.com/nodejs/node/commit/fbd3c80316)] - **doc**: replace methods used in the example code (Damian) [#16416](https://github.com/nodejs/node/pull/16416)
* [[`73915d3ff8`](https://github.com/nodejs/node/commit/73915d3ff8)] - **doc**: fix http2 example with rstWithCancel (c0b) [#16365](https://github.com/nodejs/node/pull/16365)
* [[`ce159f4e10`](https://github.com/nodejs/node/commit/ce159f4e10)] - **doc**: improve {readable,writable}._destroy() docs (Luigi Pinca) [#16313](https://github.com/nodejs/node/pull/16313)
* [[`d57f358225`](https://github.com/nodejs/node/commit/d57f358225)] - **doc**: remove duplicate options (aayush.a) [#16339](https://github.com/nodejs/node/pull/16339)
* [[`77e76141ee`](https://github.com/nodejs/node/commit/77e76141ee)] - **doc**: fix comment in assert.md (umatoma) [#16335](https://github.com/nodejs/node/pull/16335)
* [[`d0fc7ab4d2`](https://github.com/nodejs/node/commit/d0fc7ab4d2)] - **doc**: add space after period (Diego Rodríguez Baquero) [#16334](https://github.com/nodejs/node/pull/16334)
* [[`6c809e0125`](https://github.com/nodejs/node/commit/6c809e0125)] - **doc**: minor correction to note on process section (Daniel Bevenius) [#16311](https://github.com/nodejs/node/pull/16311)
* [[`49a41d9739`](https://github.com/nodejs/node/commit/49a41d9739)] - **doc**: fix links in http2.md (Vse Mozhet Byt) [#16307](https://github.com/nodejs/node/pull/16307)
* [[`8b4f1229ac`](https://github.com/nodejs/node/commit/8b4f1229ac)] - **doc**: document opening hidden files on Windows (Bartosz Sosnowski) [#15409](https://github.com/nodejs/node/pull/15409)
* [[`0585148c34`](https://github.com/nodejs/node/commit/0585148c34)] - **doc**: add return value to util.promisify (Supamic) [#16040](https://github.com/nodejs/node/pull/16040)
* [[`497bfff7b2`](https://github.com/nodejs/node/commit/497bfff7b2)] - **doc**: clarify using crlfDelay with fs streams (Vse Mozhet Byt) [#16259](https://github.com/nodejs/node/pull/16259)
* [[`7bf9878568`](https://github.com/nodejs/node/commit/7bf9878568)] - **doc**: add apapirovski to collaborators (Anatoli Papirovski) [#16302](https://github.com/nodejs/node/pull/16302)
* [[`97b8271aa4`](https://github.com/nodejs/node/commit/97b8271aa4)] - **doc**: add @nodejs/build to onboarding-extras.md (Lance Ball) [#16298](https://github.com/nodejs/node/pull/16298)
* [[`d92b45ec55`](https://github.com/nodejs/node/commit/d92b45ec55)] - **doc**: update test/inspector reference (Jon Moss) [#16277](https://github.com/nodejs/node/pull/16277)
* [[`e34509e8ed`](https://github.com/nodejs/node/commit/e34509e8ed)] - **doc**: public keys don't accept passphrases (Ben Noordhuis) [#16087](https://github.com/nodejs/node/pull/16087)
* [[`720ea94894`](https://github.com/nodejs/node/commit/720ea94894)] - **doc**: clarify os.cpus() returns logical CPU cores (Luke Childs) [#16282](https://github.com/nodejs/node/pull/16282)
* [[`8a8e5c775b`](https://github.com/nodejs/node/commit/8a8e5c775b)] - **doc**: add return values in crypto documentation (Jeremy Huang) [#16229](https://github.com/nodejs/node/pull/16229)
* [[`9eccb8479b`](https://github.com/nodejs/node/commit/9eccb8479b)] - **doc**: reduce keylen in pbkdf2 examples (Lukas) [#16203](https://github.com/nodejs/node/pull/16203)
* [[`0776c80606`](https://github.com/nodejs/node/commit/0776c80606)] - **doc**: support multidimensional arrays in type link (Vse Mozhet Byt) [#16207](https://github.com/nodejs/node/pull/16207)
* [[`3e7945ad3a`](https://github.com/nodejs/node/commit/3e7945ad3a)] - **doc**: update to use NAPI_AUTO_LENGTH (Michael Dawson) [#16187](https://github.com/nodejs/node/pull/16187)
* [[`7218bba916`](https://github.com/nodejs/node/commit/7218bba916)] - **doc**: move Shigeki to TSC Emeritus (Rich Trott) [#16195](https://github.com/nodejs/node/pull/16195)
* [[`c23bf96dbe`](https://github.com/nodejs/node/commit/c23bf96dbe)] - **doc**: fix paragraph line-height issue (silverwind) [#16200](https://github.com/nodejs/node/pull/16200)
* [[`d75a403add`](https://github.com/nodejs/node/commit/d75a403add)] - **doc**: Update a typo in module.js' comments (Orta) [#16205](https://github.com/nodejs/node/pull/16205)
* [[`4ecc2880a4`](https://github.com/nodejs/node/commit/4ecc2880a4)] - **doc**: add missing comma (Jon Moss) [#16204](https://github.com/nodejs/node/pull/16204)
* [[`57b7f401ee`](https://github.com/nodejs/node/commit/57b7f401ee)] - **doc**: added note to fs.watchFile on previousStat (NiveditN) [#16099](https://github.com/nodejs/node/pull/16099)
* [[`0bb1415b2d`](https://github.com/nodejs/node/commit/0bb1415b2d)] - **doc**: add UV_THREADPOOL_SIZE link definition (Jon Moss) [#16193](https://github.com/nodejs/node/pull/16193)
* [[`3266e1fe81`](https://github.com/nodejs/node/commit/3266e1fe81)] - **doc**: add basic C++ style guide (Anna Henningsen) [#16090](https://github.com/nodejs/node/pull/16090)
* [[`c9be3a29de`](https://github.com/nodejs/node/commit/c9be3a29de)] - **doc**: fix dgram.md typos (Alessandro Vergani) [#16183](https://github.com/nodejs/node/pull/16183)
* [[`55fa067a6d`](https://github.com/nodejs/node/commit/55fa067a6d)] - **doc**: clarify usage of util.promisify.custom (Shiya Luo) [#16134](https://github.com/nodejs/node/pull/16134)
* [[`4ed78e267a`](https://github.com/nodejs/node/commit/4ed78e267a)] - **doc**: ensure collaborators validate commits (Bradley Farias) [#16162](https://github.com/nodejs/node/pull/16162)
* [[`04b6ae6648`](https://github.com/nodejs/node/commit/04b6ae6648)] - **doc**: move 8 collaborators to emeriti (Rich Trott) [#16173](https://github.com/nodejs/node/pull/16173)
* [[`d09e489ec9`](https://github.com/nodejs/node/commit/d09e489ec9)] - **doc**: include V8 commit URL in V8 backport guide (Gibson Fahnestock) [#16054](https://github.com/nodejs/node/pull/16054)
* [[`80539d83d2`](https://github.com/nodejs/node/commit/80539d83d2)] - **doc**: add parentheses to refreshTmpDir() (Rich Trott) [#16168](https://github.com/nodejs/node/pull/16168)
* [[`a45ac4f77d`](https://github.com/nodejs/node/commit/a45ac4f77d)] - **doc**: fix changelog anchor to v8.7.0 (Lewis Zhang) [#16165](https://github.com/nodejs/node/pull/16165)
* [[`2b4f3bb39e`](https://github.com/nodejs/node/commit/2b4f3bb39e)] - **doc**: add pronoun for fhinkel (F. Hinkelmann) [#16069](https://github.com/nodejs/node/pull/16069)
* [[`4fdb9f5024`](https://github.com/nodejs/node/commit/4fdb9f5024)] - **doc**: document windows shell support (Tim Ermilov) [#16104](https://github.com/nodejs/node/pull/16104)
* [[`6670b35f23`](https://github.com/nodejs/node/commit/6670b35f23)] - **doc**: remove undefined reference variable (Adarsh Honawad) [#16106](https://github.com/nodejs/node/pull/16106)
* [[`0d23412e12`](https://github.com/nodejs/node/commit/0d23412e12)] - **doc**: exempt test/doc only changes from 48-hr rule (Anna Henningsen) [#16135](https://github.com/nodejs/node/pull/16135)
* [[`e375b8cbae`](https://github.com/nodejs/node/commit/e375b8cbae)] - **doc**: rename good first contrib label (Jeremiah Senkpiel) [#16150](https://github.com/nodejs/node/pull/16150)
* [[`3b7abe1e0d`](https://github.com/nodejs/node/commit/3b7abe1e0d)] - **doc**: fix the description of 'close' event (James M. Greene) [#15800](https://github.com/nodejs/node/pull/15800)
* [[`698f358956`](https://github.com/nodejs/node/commit/698f358956)] - **doc**: document the `test/common/dns` module (Cameron Burwell) [#15772](https://github.com/nodejs/node/pull/15772)
* [[`cfa1ef51b4`](https://github.com/nodejs/node/commit/cfa1ef51b4)] - **doc**: remove bold typography from STYLE_GUIDE.md (Rich Trott) [#16085](https://github.com/nodejs/node/pull/16085)
* [[`c2f0700769`](https://github.com/nodejs/node/commit/c2f0700769)] - **doc**: add history for readline `crlfDelay` option (Vse Mozhet Byt) [#16075](https://github.com/nodejs/node/pull/16075)
* [[`8a151bedfb`](https://github.com/nodejs/node/commit/8a151bedfb)] - **doc**: responsive docs, rewrite font sizes (silverwind) [#15660](https://github.com/nodejs/node/pull/15660)
* [[`939a580406`](https://github.com/nodejs/node/commit/939a580406)] - **errors**: make `code` and `name` properties settable (John-David Dalton) [#15694](https://github.com/nodejs/node/pull/15694)
* [[`0bd2fd5627`](https://github.com/nodejs/node/commit/0bd2fd5627)] - **errors**: make properties mutable (Rich Trott) [#15694](https://github.com/nodejs/node/pull/15694)
* [[`62f802aee0`](https://github.com/nodejs/node/commit/62f802aee0)] - **fs**: account for buffer alloc failure in readFile (Anna Henningsen) [#16219](https://github.com/nodejs/node/pull/16219)
* [[`f501062363`](https://github.com/nodejs/node/commit/f501062363)] - **fs**: remove no-longer-relevant comment (Bryan English) [#16285](https://github.com/nodejs/node/pull/16285)
* [[`ce73ee5f36`](https://github.com/nodejs/node/commit/ce73ee5f36)] - **http**: do not blindly destroy UNIX domain sockets (Luigi Pinca) [#15650](https://github.com/nodejs/node/pull/15650)
* [[`0d50c7061c`](https://github.com/nodejs/node/commit/0d50c7061c)] - **http2**: multiple style and performance updates (James M Snell) [#16239](https://github.com/nodejs/node/pull/16239)
* [[`9aa5d494e6`](https://github.com/nodejs/node/commit/9aa5d494e6)] - **http2**: allow port 80 in http2.connect (Anatoli Papirovski) [#16337](https://github.com/nodejs/node/pull/16337)
* [[`63036a8d6d`](https://github.com/nodejs/node/commit/63036a8d6d)] - **(SEMVER-MINOR)** **http2**: support generic `Duplex` streams (Anna Henningsen) [#16269](https://github.com/nodejs/node/pull/16269)
* [[`bc1ad81b4c`](https://github.com/nodejs/node/commit/bc1ad81b4c)] - **http2**: small fixes to http2 core (Anatoli Papirovski) [#16327](https://github.com/nodejs/node/pull/16327)
* [[`bcb83f70ec`](https://github.com/nodejs/node/commit/bcb83f70ec)] - **http2**: remove unnecessary asserts in core (Anatoli Papirovski) [#16327](https://github.com/nodejs/node/pull/16327)
* [[`098cd90560`](https://github.com/nodejs/node/commit/098cd90560)] - **http2**: cleanup access via Symbols in core (Anatoli Papirovski) [#16327](https://github.com/nodejs/node/pull/16327)
* [[`bf7c2a3b65`](https://github.com/nodejs/node/commit/bf7c2a3b65)] - **http2**: slightly simplify stream destroy (Anatoli Papirovski) [#16327](https://github.com/nodejs/node/pull/16327)
* [[`25ef372235`](https://github.com/nodejs/node/commit/25ef372235)] - **http2**: simplify te header validation, add test (Trivikram Kamat) [#16246](https://github.com/nodejs/node/pull/16246)
* [[`e01daec4e1`](https://github.com/nodejs/node/commit/e01daec4e1)] - **(SEMVER-MINOR)** **http2**: remove --expose-http2 flag from tests, etc (James M Snell) [#15685](https://github.com/nodejs/node/pull/15685)
* [[`57ab6e2a10`](https://github.com/nodejs/node/commit/57ab6e2a10)] - **(SEMVER-MINOR)** **http2**: expose http2 by default, add NODE_NO_HTTP2 (James M Snell) [#15685](https://github.com/nodejs/node/pull/15685)
* [[`b0b224c823`](https://github.com/nodejs/node/commit/b0b224c823)] - **http2**: replace fixturesDir with common.fixtures (ekulnivek) [#15839](https://github.com/nodejs/node/pull/15839)
* [[`1956ae7fc1`](https://github.com/nodejs/node/commit/1956ae7fc1)] - **inspector**: Move JS API code to separate file (Eugene Ostroukhov) [#16056](https://github.com/nodejs/node/pull/16056)
* [[`b431a4969b`](https://github.com/nodejs/node/commit/b431a4969b)] - **inspector**: reimplement JS binding (Timothy Gu) [#15643](https://github.com/nodejs/node/pull/15643)
* [[`ec93a53933`](https://github.com/nodejs/node/commit/ec93a53933)] - **lib**: fix extraneous space in module.js (Anatoli Papirovski) [#16199](https://github.com/nodejs/node/pull/16199)
* [[`67aed7972d`](https://github.com/nodejs/node/commit/67aed7972d)] - **lib**: faster type checks for some types (Timothy Gu) [#15663](https://github.com/nodejs/node/pull/15663)
* [[`303c6c287f`](https://github.com/nodejs/node/commit/303c6c287f)] - **meta**: update comments for module version (Myles Borins) [#16303](https://github.com/nodejs/node/pull/16303)
* [[`fd54d8a438`](https://github.com/nodejs/node/commit/fd54d8a438)] - **meta**: add note about email sync to CONTRIBUTING.md (Vse Mozhet Byt) [#16340](https://github.com/nodejs/node/pull/16340)
* [[`598787d854`](https://github.com/nodejs/node/commit/598787d854)] - **module**: fix main resolution and not found updates (Guy Bedford) [#16147](https://github.com/nodejs/node/pull/16147)
* [[`25c980332f`](https://github.com/nodejs/node/commit/25c980332f)] - **module**: add inspector to builtinLibs (Timothy Gu) [#15643](https://github.com/nodejs/node/pull/15643)
* [[`a4bc6ff546`](https://github.com/nodejs/node/commit/a4bc6ff546)] - **module**: minor performance improvement (243083df) [#16125](https://github.com/nodejs/node/pull/16125)
* [[`86082a4a74`](https://github.com/nodejs/node/commit/86082a4a74)] - **module**: allow loading files with % in the name (Guy Bedford) [#16128](https://github.com/nodejs/node/pull/16128)
* [[`7337a40491`](https://github.com/nodejs/node/commit/7337a40491)] - **module**: resolve and instantiate loader pipeline hooks (guybedford) [#15445](https://github.com/nodejs/node/pull/15445)
* [[`43c92cd850`](https://github.com/nodejs/node/commit/43c92cd850)] - **n-api**: unexpose symbols and remove EXTERNAL_NAPI (Gabriel Schulhof) [#16234](https://github.com/nodejs/node/pull/16234)
* [[`0a52479805`](https://github.com/nodejs/node/commit/0a52479805)] - **n-api**: check against invalid handle scope usage (Anna Henningsen) [#16201](https://github.com/nodejs/node/pull/16201)
* [[`06aa09661d`](https://github.com/nodejs/node/commit/06aa09661d)] - **n-api**: reimplement instanceof using V8 API (Yang Guo) [#16143](https://github.com/nodejs/node/pull/16143)
* [[`170d9abe03`](https://github.com/nodejs/node/commit/170d9abe03)] - **n-api**: use module name macro (Michael Dawson) [#16185](https://github.com/nodejs/node/pull/16185)
* [[`5c8cd0ef3e`](https://github.com/nodejs/node/commit/5c8cd0ef3e)] - **n-api**: make changes for source compatibility (Gabriel Schulhof) [#16102](https://github.com/nodejs/node/pull/16102)
* [[`8e7ca5db8d`](https://github.com/nodejs/node/commit/8e7ca5db8d)] - **n-api,test**: use module name macro (Gabriel Schulhof) [#16146](https://github.com/nodejs/node/pull/16146)
* [[`f6a725ea09`](https://github.com/nodejs/node/commit/f6a725ea09)] - **net**: fix timeouts during long writes (Anatoli Papirovski) [#15791](https://github.com/nodejs/node/pull/15791)
* [[`5f486cd5b6`](https://github.com/nodejs/node/commit/5f486cd5b6)] - **net**: change assert to conform to other files (James Hodgskiss) [#15861](https://github.com/nodejs/node/pull/15861)
* [[`1168e01455`](https://github.com/nodejs/node/commit/1168e01455)] - **repl**: remove unused err argument (Jon Moss) [#16152](https://github.com/nodejs/node/pull/16152)
* [[`78a6ef46a9`](https://github.com/nodejs/node/commit/78a6ef46a9)] - **src**: combine loops in CopyJsStringArray() (cjihrig) [#16247](https://github.com/nodejs/node/pull/16247)
* [[`5dbefe12e6`](https://github.com/nodejs/node/commit/5dbefe12e6)] - **src**: increase usage of context in spawn_sync.cc (cjihrig) [#16247](https://github.com/nodejs/node/pull/16247)
* [[`91dc6c7c40`](https://github.com/nodejs/node/commit/91dc6c7c40)] - **src**: increase usage of context in process_wrap.cc (cjihrig) [#16247](https://github.com/nodejs/node/pull/16247)
* [[`d356022087`](https://github.com/nodejs/node/commit/d356022087)] - **(SEMVER-MINOR)** **src**: turn JS stream into a full duplex (Anna Henningsen) [#16269](https://github.com/nodejs/node/pull/16269)
* [[`2788cb7524`](https://github.com/nodejs/node/commit/2788cb7524)] - **(SEMVER-MINOR)** **src**: allow top-level calls into JSStream (Anna Henningsen) [#16269](https://github.com/nodejs/node/pull/16269)
* [[`26bd574b32`](https://github.com/nodejs/node/commit/26bd574b32)] - **src**: operator\[\] checks bounds in debug mode (gitHubTracey) [#16002](https://github.com/nodejs/node/pull/16002)
* [[`0ddb00d3c2`](https://github.com/nodejs/node/commit/0ddb00d3c2)] - **src**: check uv_prepare_stop return value (Anna Henningsen) [#16268](https://github.com/nodejs/node/pull/16268)
* [[`0b04869860`](https://github.com/nodejs/node/commit/0b04869860)] - **src**: do not add .domain to promises in VM contexts (Timothy Gu) [#15695](https://github.com/nodejs/node/pull/15695)
* [[`659dd8ae4f`](https://github.com/nodejs/node/commit/659dd8ae4f)] - **src**: remove unused includes from node_wrap.h (Daniel Bevenius) [#16179](https://github.com/nodejs/node/pull/16179)
* [[`e8f59f755b`](https://github.com/nodejs/node/commit/e8f59f755b)] - **src**: rename StreamWrap to LibuvStreamWrap (Anna Henningsen) [#16157](https://github.com/nodejs/node/pull/16157)
* [[`7307e1d2cd`](https://github.com/nodejs/node/commit/7307e1d2cd)] - **src**: add internalBindings for binding isolation (Bradley Farias) [#15759](https://github.com/nodejs/node/pull/15759)
* [[`c8db0230c9`](https://github.com/nodejs/node/commit/c8db0230c9)] - **src**: use more appropriate context-entered check (Anna Henningsen) [#15691](https://github.com/nodejs/node/pull/15691)
* [[`419876aabb`](https://github.com/nodejs/node/commit/419876aabb)] - **src**: fixup node_platform blocking task drain (Anna Henningsen) [#15639](https://github.com/nodejs/node/pull/15639)
* [[`33d5262c23`](https://github.com/nodejs/node/commit/33d5262c23)] - **src**: prepare platform for upstream V8 changes (Anna Henningsen) [#15428](https://github.com/nodejs/node/pull/15428)
* [[`824be6dc1d`](https://github.com/nodejs/node/commit/824be6dc1d)] - **src**: node_dtrace line continuations clean up (Daniel Bevenius) [#15777](https://github.com/nodejs/node/pull/15777)
* [[`09660c8511`](https://github.com/nodejs/node/commit/09660c8511)] - **src**: rename perfctr_macros.py-\>noperfctr_macros.py (Daniel Bevenius) [#16100](https://github.com/nodejs/node/pull/16100)
* [[`2c469e8e29`](https://github.com/nodejs/node/commit/2c469e8e29)] - **test**: fix flaky test-make-doc (Rich Trott) [#16301](https://github.com/nodejs/node/pull/16301)
* [[`6d1602244a`](https://github.com/nodejs/node/commit/6d1602244a)] - **test**: http2 add timeout no callback test case (Trivikram Kamat) [#16082](https://github.com/nodejs/node/pull/16082)
* [[`c07d757508`](https://github.com/nodejs/node/commit/c07d757508)] - **test**: http2 session operations after destroy (Trivikram Kamat) [#15758](https://github.com/nodejs/node/pull/15758)
* [[`65c5d0e27a`](https://github.com/nodejs/node/commit/65c5d0e27a)] - **test**: consolidate http2 tests in one file (Trivikram Kamat) [#15624](https://github.com/nodejs/node/pull/15624)
* [[`6ad5b90730`](https://github.com/nodejs/node/commit/6ad5b90730)] - **test**: add tests for ERR_HTTP2_FRAME_ERROR (Ruxandra Fediuc) [#16107](https://github.com/nodejs/node/pull/16107)
* [[`d1080f858d`](https://github.com/nodejs/node/commit/d1080f858d)] - **test**: improve coverage for 'internal/errors' (Ruxandra Fediuc) [#16055](https://github.com/nodejs/node/pull/16055)
* [[`80b0dcfd2b`](https://github.com/nodejs/node/commit/80b0dcfd2b)] - **(SEMVER-MINOR)** **test**: add `makeDuplexPair()` helper (Anna Henningsen) [#16269](https://github.com/nodejs/node/pull/16269)
* [[`7e1a187df1`](https://github.com/nodejs/node/commit/7e1a187df1)] - **test**: handle blank shells in test-os.js (Gibson Fahnestock) [#16287](https://github.com/nodejs/node/pull/16287)
* [[`3c41f3f0e3`](https://github.com/nodejs/node/commit/3c41f3f0e3)] - **test**: increase enoughTestMem to 1.75 Gb (Rich Trott) [#16374](https://github.com/nodejs/node/pull/16374)
* [[`0d5ee95e36`](https://github.com/nodejs/node/commit/0d5ee95e36)] - **test**: use fixtures.readKey in https-timeout-server (Nicolas 'Pixel' Noble) [#15871](https://github.com/nodejs/node/pull/15871)
* [[`d7b4ad89fb`](https://github.com/nodejs/node/commit/d7b4ad89fb)] - **test**: improve message for assert.strictEqual() (Jayson D. Henkel) [#16013](https://github.com/nodejs/node/pull/16013)
* [[`b1c7889ad7`](https://github.com/nodejs/node/commit/b1c7889ad7)] - **test**: fix common.PIPE path bug (Rich Trott) [#16364](https://github.com/nodejs/node/pull/16364)
* [[`fad763789d`](https://github.com/nodejs/node/commit/fad763789d)] - **test**: use fixtures.readKey instead of fixturesDir (Paul Marion Camantigue) [#15976](https://github.com/nodejs/node/pull/15976)
* [[`f9321bb2f6`](https://github.com/nodejs/node/commit/f9321bb2f6)] - **test**: replace fixturesDir with fixtures module (tpurcell) [#16262](https://github.com/nodejs/node/pull/16262)
* [[`87804a6c0e`](https://github.com/nodejs/node/commit/87804a6c0e)] - **test**: replace fixturesDir with fixtures module (André Føyn Berge) [#15947](https://github.com/nodejs/node/pull/15947)
* [[`dae022e17e`](https://github.com/nodejs/node/commit/dae022e17e)] - **test**: replace fixturesDir with fixtures module (elisa lee) [#16095](https://github.com/nodejs/node/pull/16095)
* [[`0a0fa2bc42`](https://github.com/nodejs/node/commit/0a0fa2bc42)] - **test**: skip test due to file size limit (jBarz) [#16273](https://github.com/nodejs/node/pull/16273)
* [[`6b1f75d26f`](https://github.com/nodejs/node/commit/6b1f75d26f)] - **test**: update test-npm to use test-npm-package.js (Gibson Fahnestock) [#11540](https://github.com/nodejs/node/pull/11540)
* [[`e11c8fbc9f`](https://github.com/nodejs/node/commit/e11c8fbc9f)] - **test**: remove error msg in test-vm-symbols.js (Daniel Abrão) [#15873](https://github.com/nodejs/node/pull/15873)
* [[`dacef99bfc`](https://github.com/nodejs/node/commit/dacef99bfc)] - **test**: remove error messages in test-buffer-alloc (Braden Whitten) [#15867](https://github.com/nodejs/node/pull/15867)
* [[`bbc93edee9`](https://github.com/nodejs/node/commit/bbc93edee9)] - **test**: update assert error messages (Omar Gonzalez) [#16035](https://github.com/nodejs/node/pull/16035)
* [[`2e2c09e5de`](https://github.com/nodejs/node/commit/2e2c09e5de)] - **test**: more AsyncWrap constructor validation tests (Braden Whitten) [#16025](https://github.com/nodejs/node/pull/16025)
* [[`6f5edf4894`](https://github.com/nodejs/node/commit/6f5edf4894)] - **test**: remove error message (Jack Wang) [#15983](https://github.com/nodejs/node/pull/15983)
* [[`0ef63352b3`](https://github.com/nodejs/node/commit/0ef63352b3)] - **test**: expand error message (Stefania Sharp) [#15991](https://github.com/nodejs/node/pull/15991)
* [[`489168d87f`](https://github.com/nodejs/node/commit/489168d87f)] - **test**: use fixtures module (Kanika Shah) [#15959](https://github.com/nodejs/node/pull/15959)
* [[`d472922e35`](https://github.com/nodejs/node/commit/d472922e35)] - **test**: remove literal messages (Oscar Funes) [#15938](https://github.com/nodejs/node/pull/15938)
* [[`7634652e71`](https://github.com/nodejs/node/commit/7634652e71)] - **test**: fix stderr reference (Oscar Funes) [#15938](https://github.com/nodejs/node/pull/15938)
* [[`2b46049e16`](https://github.com/nodejs/node/commit/2b46049e16)] - **test**: fix typo (Oscar Funes) [#15938](https://github.com/nodejs/node/pull/15938)
* [[`acba6d0cb0`](https://github.com/nodejs/node/commit/acba6d0cb0)] - **test**: improve coverage of ModuleMap.js (Jean-Philippe Blais) [#15924](https://github.com/nodejs/node/pull/15924)
* [[`fe84f3ca26`](https://github.com/nodejs/node/commit/fe84f3ca26)] - **test**: replace concatenation with literals (Jean-Philippe Blais) [#15924](https://github.com/nodejs/node/pull/15924)
* [[`a87b202530`](https://github.com/nodejs/node/commit/a87b202530)] - **test**: use fixtures module in test-https-truncate (Gene Wu) [#15875](https://github.com/nodejs/node/pull/15875)
* [[`48ae4e0e5f`](https://github.com/nodejs/node/commit/48ae4e0e5f)] - **test**: use fixtures module (Alvaro Cruz) [#15874](https://github.com/nodejs/node/pull/15874)
* [[`b4fa45d641`](https://github.com/nodejs/node/commit/b4fa45d641)] - **test**: use fixtures module (Lance Barlaan) [#15872](https://github.com/nodejs/node/pull/15872)
* [[`737c9cfff0`](https://github.com/nodejs/node/commit/737c9cfff0)] - **test**: replace fixturesDir with fixtures module (Thomas Karsten) [#15840](https://github.com/nodejs/node/pull/15840)
* [[`f4a5abac56`](https://github.com/nodejs/node/commit/f4a5abac56)] - **test**: use default message for assert.strictEqual (hwaisiu) [#15970](https://github.com/nodejs/node/pull/15970)
* [[`70dab19c18`](https://github.com/nodejs/node/commit/70dab19c18)] - **test**: fix flaky test-benchmark-buffer (Rich Trott) [#16296](https://github.com/nodejs/node/pull/16296)
* [[`c6b2fa904e`](https://github.com/nodejs/node/commit/c6b2fa904e)] - **test**: improve assert message in internet test (Nikki St Onge) [#15998](https://github.com/nodejs/node/pull/15998)
* [[`e5cf833453`](https://github.com/nodejs/node/commit/e5cf833453)] - **test**: http2 priority stream depends on itself (Trivikram Kamat) [#16224](https://github.com/nodejs/node/pull/16224)
* [[`50b49656cb`](https://github.com/nodejs/node/commit/50b49656cb)] - **test**: http2 client settings errors (Trivikram Kamat) [#16096](https://github.com/nodejs/node/pull/16096)
* [[`327be77749`](https://github.com/nodejs/node/commit/327be77749)] - **test**: http2 emitGoAway post shutdown pre destroy (Trivikram Kamat) [#16215](https://github.com/nodejs/node/pull/16215)
* [[`811118e112`](https://github.com/nodejs/node/commit/811118e112)] - **test**: http2-respond-file-errors to fixtures module (David8472) [#16004](https://github.com/nodejs/node/pull/16004)
* [[`2a5e7ec634`](https://github.com/nodejs/node/commit/2a5e7ec634)] - **test**: http2-respond-file-range to use fixtures (Michael Rueppel) [#15852](https://github.com/nodejs/node/pull/15852)
* [[`1c14ad96a5`](https://github.com/nodejs/node/commit/1c14ad96a5)] - **test**: http2 ERR_INVALID_ARG_TYPE tests (Trivikram Kamat) [#15766](https://github.com/nodejs/node/pull/15766)
* [[`63a2b55747`](https://github.com/nodejs/node/commit/63a2b55747)] - **test**: replace common.fixturesDir (Shawn McGinty) [#15834](https://github.com/nodejs/node/pull/15834)
* [[`e0e5c890da`](https://github.com/nodejs/node/commit/e0e5c890da)] - **test**: fix flaky test-crypto-classes.js (Bryan English) [#15662](https://github.com/nodejs/node/pull/15662)
* [[`8f778d2506`](https://github.com/nodejs/node/commit/8f778d2506)] - **(SEMVER-MINOR)** **test**: crypto createClass instanceof Class (Bryan English) [#8188](https://github.com/nodejs/node/pull/8188)
* [[`a601596718`](https://github.com/nodejs/node/commit/a601596718)] - **test**: refactor test-process-kill-null (Luigi Pinca) [#16236](https://github.com/nodejs/node/pull/16236)
* [[`fefcd82c18`](https://github.com/nodejs/node/commit/fefcd82c18)] - **test**: test make doc and verify toc (Joyee Cheung) [#16208](https://github.com/nodejs/node/pull/16208)
* [[`5829b8fbf9`](https://github.com/nodejs/node/commit/5829b8fbf9)] - **test**: add common.projectDir (Joyee Cheung) [#16208](https://github.com/nodejs/node/pull/16208)
* [[`1daf5179dc`](https://github.com/nodejs/node/commit/1daf5179dc)] - **test**: fix inspector tests (Rich Trott) [#16281](https://github.com/nodejs/node/pull/16281)
* [[`1fe5308753`](https://github.com/nodejs/node/commit/1fe5308753)] - **test**: move inspector tests to parallel/sequential (Jon Moss) [#16197](https://github.com/nodejs/node/pull/16197)
* [[`cef125bfca`](https://github.com/nodejs/node/commit/cef125bfca)] - **test**: add missing spaces in concatenations (Vse Mozhet Byt) [#16244](https://github.com/nodejs/node/pull/16244)
* [[`06bae4b34a`](https://github.com/nodejs/node/commit/06bae4b34a)] - **test**: replace fixturesDir with fixtures module (hschwalm) [#15989](https://github.com/nodejs/node/pull/15989)
* [[`fa8e4186fb`](https://github.com/nodejs/node/commit/fa8e4186fb)] - **test**: update output to include exit code & signal (Jenna Zeigen) [#15945](https://github.com/nodejs/node/pull/15945)
* [[`edb9e1119f`](https://github.com/nodejs/node/commit/edb9e1119f)] - **test**: change common.fixturesDir to fixtures.path (tejbirsingh) [#15860](https://github.com/nodejs/node/pull/15860)
* [[`cca51f4b0a`](https://github.com/nodejs/node/commit/cca51f4b0a)] - **test**: split up and refactor test-domain (Anna Henningsen) [#13614](https://github.com/nodejs/node/pull/13614)
* [[`191e39011b`](https://github.com/nodejs/node/commit/191e39011b)] - **test**: fixtures in repl persistent history test (Jenna Zeigen) [#15999](https://github.com/nodejs/node/pull/15999)
* [[`62c2c78929`](https://github.com/nodejs/node/commit/62c2c78929)] - **test**: replace fixturesDir with common.fixtures (Kasim Doctor) [#15810](https://github.com/nodejs/node/pull/15810)
* [[`8a172cb085`](https://github.com/nodejs/node/commit/8a172cb085)] - **test**: http2 client operations after destroy (Trivikram Kamat) [#16094](https://github.com/nodejs/node/pull/16094)
* [[`b49df0bf87`](https://github.com/nodejs/node/commit/b49df0bf87)] - **test**: replaced fs.readSync with fixtures.readSync (Lam Chan) [#15882](https://github.com/nodejs/node/pull/15882)
* [[`ae3836a58f`](https://github.com/nodejs/node/commit/ae3836a58f)] - **test**: http2 connectionListener reject client (Trivikram Kamat) [#16080](https://github.com/nodejs/node/pull/16080)
* [[`45ccf5cc35`](https://github.com/nodejs/node/commit/45ccf5cc35)] - **test**: improve coverage for process.umask (Evan Lucas) [#16188](https://github.com/nodejs/node/pull/16188)
* [[`f9c1bcb13c`](https://github.com/nodejs/node/commit/f9c1bcb13c)] - **test**: remove message from notStrictEqual (twk-b) [#16048](https://github.com/nodejs/node/pull/16048)
* [[`5629351c66`](https://github.com/nodejs/node/commit/5629351c66)] - **test**: use fixtures module (Ben Hallion) [#15808](https://github.com/nodejs/node/pull/15808)
* [[`3f9b0a985c`](https://github.com/nodejs/node/commit/3f9b0a985c)] - **test**: refactor test-cluster-setup-master (Jean-Baptiste Brossard) [#16065](https://github.com/nodejs/node/pull/16065)
* [[`8173b0c363`](https://github.com/nodejs/node/commit/8173b0c363)] - **test**: use relative path in pipePrefix (Randal Hanford) [#15988](https://github.com/nodejs/node/pull/15988)
* [[`fa836fc21b`](https://github.com/nodejs/node/commit/fa836fc21b)] - **test**: replace fixtureDir with fixtures methods (Vladimir Ilic) [#16114](https://github.com/nodejs/node/pull/16114)
* [[`9e8df31e8d`](https://github.com/nodejs/node/commit/9e8df31e8d)] - **test**: remove error messages in crypto-binary test (Kim Gentes) [#15981](https://github.com/nodejs/node/pull/15981)
* [[`438728a680`](https://github.com/nodejs/node/commit/438728a680)] - **test**: use fixtures module over fixturesDir (JamesNimlos) [#15847](https://github.com/nodejs/node/pull/15847)
* [[`3a77a2d0d2`](https://github.com/nodejs/node/commit/3a77a2d0d2)] - **test**: use common.fixtures module (Shaun Sweet) [#15992](https://github.com/nodejs/node/pull/15992)
* [[`6ebdd989f8`](https://github.com/nodejs/node/commit/6ebdd989f8)] - **test**: replace fixturesDir with fixtures.path (Bear Trickey) [#15994](https://github.com/nodejs/node/pull/15994)
* [[`dbbb36ecb2`](https://github.com/nodejs/node/commit/dbbb36ecb2)] - **test**: update fixturesDir import (Tyler Seabrook) [#15887](https://github.com/nodejs/node/pull/15887)
* [[`40d2da60d9`](https://github.com/nodejs/node/commit/40d2da60d9)] - **test**: replace fixturesDir with fixtures methods (Komivi Agbakpem) [#15967](https://github.com/nodejs/node/pull/15967)
* [[`816acc92a0`](https://github.com/nodejs/node/commit/816acc92a0)] - **test**: fix regression in test-require-resolver.js (Tobias Nießen) [#16192](https://github.com/nodejs/node/pull/16192)
* [[`8452af2469`](https://github.com/nodejs/node/commit/8452af2469)] - **test**: replace fixturesDir with the fixtures module (WeiPlanet) [#16027](https://github.com/nodejs/node/pull/16027)
* [[`f753aedb1e`](https://github.com/nodejs/node/commit/f753aedb1e)] - **test**: change crypto decipheriv assertion messages (Daniel Kostro) [#16007](https://github.com/nodejs/node/pull/16007)
* [[`ab87520b30`](https://github.com/nodejs/node/commit/ab87520b30)] - **test**: replaces fixturesDir with fixtures (Mike Fleming) [#15835](https://github.com/nodejs/node/pull/15835)
* [[`65eca5499f`](https://github.com/nodejs/node/commit/65eca5499f)] - **test**: remove test messages for assert.strictEqual (Ali Groening) [#15995](https://github.com/nodejs/node/pull/15995)
* [[`8dd217cf9e`](https://github.com/nodejs/node/commit/8dd217cf9e)] - **test**: move to common.fixtures (Justin Beckwith) [#15987](https://github.com/nodejs/node/pull/15987)
* [[`24a0761e0a`](https://github.com/nodejs/node/commit/24a0761e0a)] - **test**: remove redundant error messages (Christina Chan) [#16043](https://github.com/nodejs/node/pull/16043)
* [[`d818173044`](https://github.com/nodejs/node/commit/d818173044)] - **test**: remove error messages for readability (Fadi Asfour) [#16022](https://github.com/nodejs/node/pull/16022)
* [[`734a2d39b0`](https://github.com/nodejs/node/commit/734a2d39b0)] - **test**: added fixtures module (Michael Pal) [#15980](https://github.com/nodejs/node/pull/15980)
* [[`f1c30aa2c5`](https://github.com/nodejs/node/commit/f1c30aa2c5)] - **test**: use fixtures in test-tls-multi-key.js (Cheyenne Arrowsmith) [#15844](https://github.com/nodejs/node/pull/15844)
* [[`61b0af0fe4`](https://github.com/nodejs/node/commit/61b0af0fe4)] - **test**: switch to use common.fixtures.fixturesDir (Roger Jiang) [#15814](https://github.com/nodejs/node/pull/15814)
* [[`ae0a00c8d4`](https://github.com/nodejs/node/commit/ae0a00c8d4)] - **test**: use common.fixtures module (Chi-chi Wang) [#16012](https://github.com/nodejs/node/pull/16012)
* [[`e3ac7b14b7`](https://github.com/nodejs/node/commit/e3ac7b14b7)] - **test**: escape script filename on Windows (Bartosz Sosnowski) [#16124](https://github.com/nodejs/node/pull/16124)
* [[`f7c087040d`](https://github.com/nodejs/node/commit/f7c087040d)] - **test**: replace common.fixtureDir with fixtures (shaohui.liu2000@gmail.com) [#15816](https://github.com/nodejs/node/pull/15816)
* [[`81f16a988b`](https://github.com/nodejs/node/commit/81f16a988b)] - **test**: add env to failure message (shaohui.liu2000@gmail.com) [#15816](https://github.com/nodejs/node/pull/15816)
* [[`26ca2ae266`](https://github.com/nodejs/node/commit/26ca2ae266)] - **test**: improve assert message in test-dh-regr (Mabry Cervin) [#15912](https://github.com/nodejs/node/pull/15912)
* [[`6abb1f44f6`](https://github.com/nodejs/node/commit/6abb1f44f6)] - **test**: fixtures in test-net-pipe-connect-errors (Eric Freiberg) [#15922](https://github.com/nodejs/node/pull/15922)
* [[`969c87e456`](https://github.com/nodejs/node/commit/969c87e456)] - **test**: fixtures in test-process-redirect-warnings-env (Kat Rosario) [#15930](https://github.com/nodejs/node/pull/15930)
* [[`8e2064f093`](https://github.com/nodejs/node/commit/8e2064f093)] - **test**: fix ordering of strictEqual actual/expected (Chad Zezula) [#16008](https://github.com/nodejs/node/pull/16008)
* [[`b054a4e138`](https://github.com/nodejs/node/commit/b054a4e138)] - **test**: use fixtures.path instead of fixturesDir (Matthew Meyer) [#15984](https://github.com/nodejs/node/pull/15984)
* [[`68bfde9fb9`](https://github.com/nodejs/node/commit/68bfde9fb9)] - **test**: fix test-esm-addons (Rich Trott) [#16174](https://github.com/nodejs/node/pull/16174)
* [[`562d445999`](https://github.com/nodejs/node/commit/562d445999)] - **test**: use fixtures.readSync (szhang351)
* [[`1469eff8f6`](https://github.com/nodejs/node/commit/1469eff8f6)] - **test**: replaced fixturesDir with common.fixtures (Dolapo Toki) [#15836](https://github.com/nodejs/node/pull/15836)
* [[`b463259efb`](https://github.com/nodejs/node/commit/b463259efb)] - **test**: use fixtures.fixturesDir (Gene Wu) [#15822](https://github.com/nodejs/node/pull/15822)
* [[`1e0a55529f`](https://github.com/nodejs/node/commit/1e0a55529f)] - **test**: replaces fixturesDir with fixtures methods (Christian Murphy) [#15817](https://github.com/nodejs/node/pull/15817)
* [[`6f6b2cb7b7`](https://github.com/nodejs/node/commit/6f6b2cb7b7)] - **test**: replace fixturesDir with fixtures methods (Cristian Peñarrieta) [#15833](https://github.com/nodejs/node/pull/15833)
* [[`0418a4170b`](https://github.com/nodejs/node/commit/0418a4170b)] - **test**: update test-https-server-keep-alive-timeout (Tom Boutell) [#15805](https://github.com/nodejs/node/pull/15805)
* [[`1cfff97a2b`](https://github.com/nodejs/node/commit/1cfff97a2b)] - **test**: fixtures in test-process-redirect-warnings (Nicolas Chaulet) [#15917](https://github.com/nodejs/node/pull/15917)
* [[`ba2261a450`](https://github.com/nodejs/node/commit/ba2261a450)] - **test**: update test-crypto-from-binary (Raj Parekh) [#16011](https://github.com/nodejs/node/pull/16011)
* [[`abfb6b1262`](https://github.com/nodejs/node/commit/abfb6b1262)] - **test**: fixtures in test-http2-respond-file-fd-range (kysnm) [#15878](https://github.com/nodejs/node/pull/15878)
* [[`db92df9f67`](https://github.com/nodejs/node/commit/db92df9f67)] - **test**: use fixtures in test-https-set-timeout-server (Bob Clewell) [#15886](https://github.com/nodejs/node/pull/15886)
* [[`529e6851d9`](https://github.com/nodejs/node/commit/529e6851d9)] - **test**: make use of common/fixtures.fixturesDir (Jem Bezooyen) [#15815](https://github.com/nodejs/node/pull/15815)
* [[`7339620466`](https://github.com/nodejs/node/commit/7339620466)] - **test**: use common/fixtures in test-https-close (Alberto Lopez de Lara) [#15870](https://github.com/nodejs/node/pull/15870)
* [[`7a210cd467`](https://github.com/nodejs/node/commit/7a210cd467)] - **test**: use fixtures in test-process-warnings (Suresh Srinivas) [#15869](https://github.com/nodejs/node/pull/15869)
* [[`56cf077e0e`](https://github.com/nodejs/node/commit/56cf077e0e)] - **test**: use fixtures in tls-friendly-error-message (tobyfarley) [#15905](https://github.com/nodejs/node/pull/15905)
* [[`f1b4e7c001`](https://github.com/nodejs/node/commit/f1b4e7c001)] - **test**: add benchmark tests for es (Ethan Arrowood) [#16076](https://github.com/nodejs/node/pull/16076)
* [[`68b59eaaf0`](https://github.com/nodejs/node/commit/68b59eaaf0)] - **test**: use common/fixtures in tls-connect-no-host (Donovan Buck) [#15986](https://github.com/nodejs/node/pull/15986)
* [[`36fa169e01`](https://github.com/nodejs/node/commit/36fa169e01)] - **test**: use common/fixtures in test-https-agent (jpaulptr) [#15941](https://github.com/nodejs/node/pull/15941)
* [[`7a18e6441e`](https://github.com/nodejs/node/commit/7a18e6441e)] - **test**: use common fixtures module (Kat Rosario) [#15856](https://github.com/nodejs/node/pull/15856)
* [[`08fa0040a7`](https://github.com/nodejs/node/commit/08fa0040a7)] - **test**: fs.readFileSync -\> fixtures.readKey (Ethan Brown) [#16030](https://github.com/nodejs/node/pull/16030)
* [[`268ce8cad4`](https://github.com/nodejs/node/commit/268ce8cad4)] - **test**: reduce test-benchmark-http iterations (Rich Trott) [#16137](https://github.com/nodejs/node/pull/16137)
* [[`9808c59b4e`](https://github.com/nodejs/node/commit/9808c59b4e)] - **test**: reduce run time for misc benchmark tests (Rich Trott) [#16120](https://github.com/nodejs/node/pull/16120)
* [[`5f0686ab07`](https://github.com/nodejs/node/commit/5f0686ab07)] - **test**: improve assertion message in dgram test (Shakeel Mohamed) [#16121](https://github.com/nodejs/node/pull/16121)
* [[`5a1867067c`](https://github.com/nodejs/node/commit/5a1867067c)] - **test**: use of fixtures in test-pipe-head (Nicolas Chaulet) [#15868](https://github.com/nodejs/node/pull/15868)
* [[`48d862b0d5`](https://github.com/nodejs/node/commit/48d862b0d5)] - **test**: use fixtures in test-https-localaddress.js (Charles T Wall III) [#15811](https://github.com/nodejs/node/pull/15811)
* [[`ce88af1729`](https://github.com/nodejs/node/commit/ce88af1729)] - **test**: use common/fixtures in fs-symlink test (AlexeyM) [#15830](https://github.com/nodejs/node/pull/15830)
* [[`c89ef9d9aa`](https://github.com/nodejs/node/commit/c89ef9d9aa)] - **test**: replace common.fixtures with fixtures module (Jonathan Eskew) [#15877](https://github.com/nodejs/node/pull/15877)
* [[`181ee5d1ef`](https://github.com/nodejs/node/commit/181ee5d1ef)] - **test**: use fixtures.readKey() (Kasim Doctor) [#15862](https://github.com/nodejs/node/pull/15862)
* [[`859ce10c4d`](https://github.com/nodejs/node/commit/859ce10c4d)] - **test**: added a test comment (Edward Andrew Robinson) [#16003](https://github.com/nodejs/node/pull/16003)
* [[`78ffdb85d0`](https://github.com/nodejs/node/commit/78ffdb85d0)] - **test**: improve assert message (Tri Nguyen) [#15909](https://github.com/nodejs/node/pull/15909)
* [[`6f605b8b7e`](https://github.com/nodejs/node/commit/6f605b8b7e)] - **test**: replace fixturesDir with fixtures method (suraiyah) [#15894](https://github.com/nodejs/node/pull/15894)
* [[`e47366e66a`](https://github.com/nodejs/node/commit/e47366e66a)] - **test**: replace fixturesDir with fixtures module (Joel Dart) [#15848](https://github.com/nodejs/node/pull/15848)
* [[`1a884cd9e8`](https://github.com/nodejs/node/commit/1a884cd9e8)] - **test**: common.fixturesDir -\>  common.fixtures (Peter) [#16028](https://github.com/nodejs/node/pull/16028)
* [[`64a1c1f1d4`](https://github.com/nodejs/node/commit/64a1c1f1d4)] - **test**: normalize fixtures use (Ruxandra Fediuc) [#15855](https://github.com/nodejs/node/pull/15855)
* [[`d3bf46982f`](https://github.com/nodejs/node/commit/d3bf46982f)] - **test**: cleaned up assert messages (mrgorbo) [#16032](https://github.com/nodejs/node/pull/16032)
* [[`270dd22d4e`](https://github.com/nodejs/node/commit/270dd22d4e)] - **test**: replace common.fixturesDir w/common.fixtures (Jason Walton) [#15853](https://github.com/nodejs/node/pull/15853)
* [[`0e2db0e64e`](https://github.com/nodejs/node/commit/0e2db0e64e)] - **test**: fix lint error (Rich Trott) [#16145](https://github.com/nodejs/node/pull/16145)
* [[`ceca43ba39`](https://github.com/nodejs/node/commit/ceca43ba39)] - **test**: replace common.fixturesDir with commonfixtures (Feon Sua) [#15832](https://github.com/nodejs/node/pull/15832)
* [[`ae75af5292`](https://github.com/nodejs/node/commit/ae75af5292)] - **test**: replace fixturesDir to use fixtures module (Josh Lim) [#15831](https://github.com/nodejs/node/pull/15831)
* [[`d96b2a7077`](https://github.com/nodejs/node/commit/d96b2a7077)] - **test**: switch to use common.fixtures module for fixturesDir (r1cebank) [#15821](https://github.com/nodejs/node/pull/15821)
* [[`c2345391cd`](https://github.com/nodejs/node/commit/c2345391cd)] - **test**: replace common.fixturesDir with fixtures (Steven Scott) [#15845](https://github.com/nodejs/node/pull/15845)
* [[`d4b454dd3c`](https://github.com/nodejs/node/commit/d4b454dd3c)] - **test**: fixturesDir replaced to fixtures module (Pawel Golda) [#15809](https://github.com/nodejs/node/pull/15809)
* [[`d7ec89ce34`](https://github.com/nodejs/node/commit/d7ec89ce34)] - **test**: replace common.fixturesDir with fixtures (Stefania Sharp) [#16015](https://github.com/nodejs/node/pull/16015)
* [[`25335ec513`](https://github.com/nodejs/node/commit/25335ec513)] - **test**: replaces common.fixturesDir usage (Ruy Adorno) [#15818](https://github.com/nodejs/node/pull/15818)
* [[`a79b982155`](https://github.com/nodejs/node/commit/a79b982155)] - **test**: added fs benchmark test (Charlie Duong) [#16049](https://github.com/nodejs/node/pull/16049)
* [[`92b5cf1d49`](https://github.com/nodejs/node/commit/92b5cf1d49)] - **test**: use common.fixtures.path() (Tobias Kieslich) [#16112](https://github.com/nodejs/node/pull/16112)
* [[`b8f6d33f52`](https://github.com/nodejs/node/commit/b8f6d33f52)] - **test**: replace common.fixturesDir with fixtures (Shakeel Mohamed) [#15857](https://github.com/nodejs/node/pull/15857)
* [[`7788207a91`](https://github.com/nodejs/node/commit/7788207a91)] - **test**: use fixtures module in test (Nigel Kibodeaux) [#16117](https://github.com/nodejs/node/pull/16117)
* [[`37235a392c`](https://github.com/nodejs/node/commit/37235a392c)] - **test**: use template literals in test-string-decoder (Edward Andrew Robinson) [#15884](https://github.com/nodejs/node/pull/15884)
* [[`c7b0c9b2cd`](https://github.com/nodejs/node/commit/c7b0c9b2cd)] - **test**: switch to fixtures module (Christopher Sidebottom) [#15880](https://github.com/nodejs/node/pull/15880)
* [[`14b3f3af6a`](https://github.com/nodejs/node/commit/14b3f3af6a)] - **test**: rewrite assert message (Martin Michaelis) [#15879](https://github.com/nodejs/node/pull/15879)
* [[`d20f8d3d1f`](https://github.com/nodejs/node/commit/d20f8d3d1f)] - **test**: change fixturesDir to fixtures.path (Guilherme Akio Sakae) [#15863](https://github.com/nodejs/node/pull/15863)
* [[`228940d6ca`](https://github.com/nodejs/node/commit/228940d6ca)] - **test**: replace common.fixturesDir with fixtures (Chris Jimenez) [#15806](https://github.com/nodejs/node/pull/15806)
* [[`80b276c910`](https://github.com/nodejs/node/commit/80b276c910)] - **test**: replace fixturesDir with common.fixtures (Oliver Luebeck) [#15907](https://github.com/nodejs/node/pull/15907)
* [[`6dc3c116f0`](https://github.com/nodejs/node/commit/6dc3c116f0)] - **test**: allow short benchmarks for tests (Rich Trott) [#16097](https://github.com/nodejs/node/pull/16097)
* [[`cbbb229c81`](https://github.com/nodejs/node/commit/cbbb229c81)] - **test**: update http test client function signatures (Jakub Mrowiec - Alkagar) [#15807](https://github.com/nodejs/node/pull/15807)
* [[`0eb2826688`](https://github.com/nodejs/node/commit/0eb2826688)] - **test**: reduce run time for string_decoder benchmark (Rich Trott) [#16118](https://github.com/nodejs/node/pull/16118)
* [[`497bcebf82`](https://github.com/nodejs/node/commit/497bcebf82)] - **test**: increase test coverage of readline-interface (Daniel Kostro) [#16062](https://github.com/nodejs/node/pull/16062)
* [[`1be3f50d24`](https://github.com/nodejs/node/commit/1be3f50d24)] - **test**: improve crypto HMAC test assertions (Seth Holladay) [#16026](https://github.com/nodejs/node/pull/16026)
* [[`2c44072ea1`](https://github.com/nodejs/node/commit/2c44072ea1)] - **test**: add tests of querystring benchmark (Jonathan Eskew) [#16052](https://github.com/nodejs/node/pull/16052)
* [[`a8d1a56bec`](https://github.com/nodejs/node/commit/a8d1a56bec)] - **test**: make it easier to run tests for subsystems (Benjamin Coe) [#15450](https://github.com/nodejs/node/pull/15450)
* [[`3c98a2e67e`](https://github.com/nodejs/node/commit/3c98a2e67e)] - **timers**: fix eventloop block (zhangzifa) [#15072](https://github.com/nodejs/node/pull/15072)
* [[`eeef06a4bb`](https://github.com/nodejs/node/commit/eeef06a4bb)] - **tls**: properly track writeQueueSize during writes (Anatoli Papirovski) [#15791](https://github.com/nodejs/node/pull/15791)
* [[`509b3b81d6`](https://github.com/nodejs/node/commit/509b3b81d6)] - **tools**: enable additional eslint rules (Anatoli Papirovski) [#16243](https://github.com/nodejs/node/pull/16243)
* [[`37b50357c7`](https://github.com/nodejs/node/commit/37b50357c7)] - **tools**: update to ESLint 4.8.0 (Anatoli Papirovski) [#16199](https://github.com/nodejs/node/pull/16199)
* [[`118724f88e`](https://github.com/nodejs/node/commit/118724f88e)] - **tools**: rename unused variale in more pythonic way (Nikhil Komawar) [#16171](https://github.com/nodejs/node/pull/16171)
* [[`f89cc5d279`](https://github.com/nodejs/node/commit/f89cc5d279)] - **tools**: minor performance improvement (Anna Henningsen) [#16125](https://github.com/nodejs/node/pull/16125)
* [[`917ccc94b8`](https://github.com/nodejs/node/commit/917ccc94b8)] - **tools**: use template literal in error message (Tim Chon) [#15846](https://github.com/nodejs/node/pull/15846)
* [[`94a76162ef`](https://github.com/nodejs/node/commit/94a76162ef)] - **tools**: replace string concat (Kai Cataldo) [#15850](https://github.com/nodejs/node/pull/15850)
* [[`397ad0936d`](https://github.com/nodejs/node/commit/397ad0936d)] - **tools**: replace string concatenation with template (Nicola Del Gobbo) [#15827](https://github.com/nodejs/node/pull/15827)
* [[`e1cff102f4`](https://github.com/nodejs/node/commit/e1cff102f4)] - **tty,doc**: add type-check to isatty (Bryan English) [#15567](https://github.com/nodejs/node/pull/15567)
* [[`6ff397db89`](https://github.com/nodejs/node/commit/6ff397db89)] - **url**: using util._extend for improving profermace (Weijia Wang) [#16081](https://github.com/nodejs/node/pull/16081)
* [[`f5e56aac0c`](https://github.com/nodejs/node/commit/f5e56aac0c)] - **url**: fix port overflow checking (Rimas Misevičius) [#15794](https://github.com/nodejs/node/pull/15794)
* [[`c2b1435b55`](https://github.com/nodejs/node/commit/e82e2745af)] - **zlib**: gracefully set windowBits from 8 to 9 (Myles Borins) [nodejs-private/node-private#95](https://github.com/nodejs-private/node-private/pull/95)

<a id="8.7.0"></a>
## 2017-10-11, Version 8.7.0 (Current), @MylesBorins

### Notable Changes

* **deps**:
  * update npm to 5.4.2
    [#15600](https://github.com/nodejs/node/pull/15600)
  * upgrade libuv to 1.15.0
    [#15745](https://github.com/nodejs/node/pull/15745)
  * update V8 to 6.1.534.42
    [15393](https://github.com/nodejs/node/pull/15393)
* **dgram**:
  * support for setting dgram socket buffer size
    [#13623](https://github.com/nodejs/node/pull/13623)
* **fs**:
  * add support O_DSYNC file open constant
    [#15451](https://github.com/nodejs/node/pull/15451)
* **util**:
  * deprecate obj.inspect for custom inspection
    [#15631](https://github.com/nodejs/node/pull/15631)
* **tools, build**:
  * there is a fancy new macOS installer
    [#15179](https://github.com/nodejs/node/pull/15179)
* **Added new collaborators**
  * [bmeurer](https://github.com/bmeurer) - Benedikt Meurer
  * [kfarnung](https://github.com/kfarnung) - Kyle Farnung

### Commits

* [[`16bdbb9e76`](https://github.com/nodejs/node/commit/16bdbb9e76)] - **async_hooks**: fix reference in code comment (Brian White) [#15748](https://github.com/nodejs/node/pull/15748)
* [[`1bc0c1fb5f`](https://github.com/nodejs/node/commit/1bc0c1fb5f)] - **async_hooks**: consistent internal naming (Andreas Madsen) [#15569](https://github.com/nodejs/node/pull/15569)
* [[`9da8346c96`](https://github.com/nodejs/node/commit/9da8346c96)] - **async_wrap**: allow user to pass execution_async_id (Trevor Norris) [#14208](https://github.com/nodejs/node/pull/14208)
* [[`09b3faef40`](https://github.com/nodejs/node/commit/09b3faef40)] - **async_wrap**: add constructor for PromiseWrap (Trevor Norris) [#14208](https://github.com/nodejs/node/pull/14208)
* [[`67cef9b182`](https://github.com/nodejs/node/commit/67cef9b182)] - **build**: allow build with system python 3 (Emily Marigold Klassen) [#16058](https://github.com/nodejs/node/pull/16058)
* [[`3d2481e6cb`](https://github.com/nodejs/node/commit/3d2481e6cb)] - **build**: call setlocal in vcbuild.bat (Daniel Bevenius) [#15754](https://github.com/nodejs/node/pull/15754)
* [[`ed8c89a07d`](https://github.com/nodejs/node/commit/ed8c89a07d)] - **build**: fix shared installing target (Yorkie Liu) [#15148](https://github.com/nodejs/node/pull/15148)
* [[`7dd0ca40e2`](https://github.com/nodejs/node/commit/7dd0ca40e2)] - **build**: run es-module tests in CI (Benjamin Coe) [#15276](https://github.com/nodejs/node/pull/15276)
* [[`81515c7b62`](https://github.com/nodejs/node/commit/81515c7b62)] - **build**: add test-with-async-hooks (Trevor Norris) [#14208](https://github.com/nodejs/node/pull/14208)
* [[`1ed0c7706f`](https://github.com/nodejs/node/commit/1ed0c7706f)] - **crypto**: better crypto error messages (Greg Alexander) [#15518](https://github.com/nodejs/node/pull/15518)
* [[`be4e809af2`](https://github.com/nodejs/node/commit/be4e809af2)] - **crypto**: use X509V3_EXT_d2i (David Benjamin) [#15348](https://github.com/nodejs/node/pull/15348)
* [[`93d5ead37a`](https://github.com/nodejs/node/commit/93d5ead37a)] - **crypto**: use SSL_SESSION_get_id (David Benjamin) [#15348](https://github.com/nodejs/node/pull/15348)
* [[`9eeaab4ba5`](https://github.com/nodejs/node/commit/9eeaab4ba5)] - **crypto**: only try to set FIPS mode if different (Gibson Fahnestock) [#12210](https://github.com/nodejs/node/pull/12210)
* [[`77bdfc96ae`](https://github.com/nodejs/node/commit/77bdfc96ae)] - **deps**: upgrade libuv to 1.15.0 (cjihrig) [#15745](https://github.com/nodejs/node/pull/15745)
* [[`c17ff62376`](https://github.com/nodejs/node/commit/c17ff62376)] - **deps**: cherry-pick f4a2b7f3 from V8 upstream. (Erin Spiceland) [#16053](https://github.com/nodejs/node/pull/16053)
* [[`1c0ae10c26`](https://github.com/nodejs/node/commit/1c0ae10c26)] - **deps**: V8: cherry-pick 163d360 from upstream (Ali Ijaz Sheikh) [#15664](https://github.com/nodejs/node/pull/15664)
* [[`3f2ea53043`](https://github.com/nodejs/node/commit/3f2ea53043)] - **deps**: update npm to 5.4.2 (Michaël Zasso)
* [[`6a019183c6`](https://github.com/nodejs/node/commit/6a019183c6)] - **deps**: cherry-pick 0353a1e from upstream V8 (Michaël Zasso) [#15599](https://github.com/nodejs/node/pull/15599)
* [[`97c0880052`](https://github.com/nodejs/node/commit/97c0880052)] - **deps**: update V8 to 6.1.534.42 (Michaël Zasso) [#15521](https://github.com/nodejs/node/pull/15521)
* [[`b4ad15be5f`](https://github.com/nodejs/node/commit/b4ad15be5f)] - **deps**: cherry-pick 9b21865822243 from V8 upstream (Anna Henningsen) [#15391](https://github.com/nodejs/node/pull/15391)
* [[`e1828eb50d`](https://github.com/nodejs/node/commit/e1828eb50d)] - **deps**: cherry-pick b6158eb6befae from V8 upstream (Anna Henningsen) [#15391](https://github.com/nodejs/node/pull/15391)
* [[`aa1a3ea998`](https://github.com/nodejs/node/commit/aa1a3ea998)] - **(SEMVER-MINOR)** **deps**: revert ABI breaking changes in V8 6.1 (Anna Henningsen) [#15393](https://github.com/nodejs/node/pull/15393)
* [[`847174759d`](https://github.com/nodejs/node/commit/847174759d)] - **deps**: patch V8 to 6.1.534.38 (Myles Borins) [#15431](https://github.com/nodejs/node/pull/15431)
* [[`c0b5b09381`](https://github.com/nodejs/node/commit/c0b5b09381)] - **(SEMVER-MINOR)** **deps**: add postmortem metadata for V8 TurboFan (Michaël Zasso) [#14730](https://github.com/nodejs/node/pull/14730)
* [[`9934dfeb5e`](https://github.com/nodejs/node/commit/9934dfeb5e)] - **deps**: cherry-pick 1aead19 from upstream V8 (Ben Noordhuis) [#15184](https://github.com/nodejs/node/pull/15184)
* [[`273822f756`](https://github.com/nodejs/node/commit/273822f756)] - **deps**: cherry-pick e020aae394 from V8 upstream (Ben Noordhuis) [#14913](https://github.com/nodejs/node/pull/14913)
* [[`d85283b76b`](https://github.com/nodejs/node/commit/d85283b76b)] - **deps**: backport f9c4b7a from upstream V8 (Matt Loring) [#14001](https://github.com/nodejs/node/pull/14001)
* [[`19a5021ee3`](https://github.com/nodejs/node/commit/19a5021ee3)] - **deps**: backport bca8409 from upstream V8 (Matt Loring) [#14001](https://github.com/nodejs/node/pull/14001)
* [[`2601a515f9`](https://github.com/nodejs/node/commit/2601a515f9)] - **deps**: backport 6e9e2e5 from upstream V8 (Matt Loring) [#14001](https://github.com/nodejs/node/pull/14001)
* [[`ede9d2ed8e`](https://github.com/nodejs/node/commit/ede9d2ed8e)] - **(SEMVER-MINOR)** **deps**: cherry-pick f19b889 from upstream V8 (Michaël Zasso) [#14730](https://github.com/nodejs/node/pull/14730)
* [[`63ebad5a04`](https://github.com/nodejs/node/commit/63ebad5a04)] - **(SEMVER-MINOR)** **deps**: fix addons compilation with VS2013 (Bartosz Sosnowski) [#13263](https://github.com/nodejs/node/pull/13263)
* [[`21004dda00`](https://github.com/nodejs/node/commit/21004dda00)] - **deps**: limit regress/regress-crbug-514081 v8 test (Michael Dawson) [#6678](https://github.com/nodejs/node/pull/6678)
* [[`d67fb8188f`](https://github.com/nodejs/node/commit/d67fb8188f)] - **(SEMVER-MINOR)** **deps**: update V8 to 6.1.534.36 (Michaël Zasso) [#15393](https://github.com/nodejs/node/pull/15393)
* [[`827f843dfa`](https://github.com/nodejs/node/commit/827f843dfa)] - **dgram**: refactor SO_RCVBUF and SO_SNDBUF methods (cjihrig) [#15483](https://github.com/nodejs/node/pull/15483)
* [[`e3658143e5`](https://github.com/nodejs/node/commit/e3658143e5)] - **(SEMVER-MINOR)** **dgram**: support for setting socket buffer size (Damien O'Reilly) [#13623](https://github.com/nodejs/node/pull/13623)
* [[`bae46dc806`](https://github.com/nodejs/node/commit/bae46dc806)] - **doc**: add kfarnung to collaborators (Kyle Farnung) [#16108](https://github.com/nodejs/node/pull/16108)
* [[`d1266a3c57`](https://github.com/nodejs/node/commit/d1266a3c57)] - **doc**: mention collaboration summit in onboarding.md (Joyee Cheung) [#16079](https://github.com/nodejs/node/pull/16079)
* [[`140c98b327`](https://github.com/nodejs/node/commit/140c98b327)] - **doc**: document the benchmark CI (Joyee Cheung) [#16086](https://github.com/nodejs/node/pull/16086)
* [[`66a2c710f2`](https://github.com/nodejs/node/commit/66a2c710f2)] - **doc**: fix macosx-firewall suggestion BUILDING (suraiyah) [#15829](https://github.com/nodejs/node/pull/15829)
* [[`44719ed74d`](https://github.com/nodejs/node/commit/44719ed74d)] - **doc**: add clearer setup description (Emily Platzer) [#15962](https://github.com/nodejs/node/pull/15962)
* [[`9f6d535b87`](https://github.com/nodejs/node/commit/9f6d535b87)] - **doc**: update style guide for markdown extension (Rich Trott) [#15786](https://github.com/nodejs/node/pull/15786)
* [[`acd4924448`](https://github.com/nodejs/node/commit/acd4924448)] - **doc**: fix http2 API docs typos (Daniela Borges Matos de Carvalho) [#15778](https://github.com/nodejs/node/pull/15778)
* [[`74755415cc`](https://github.com/nodejs/node/commit/74755415cc)] - **doc**: fix: correctly use `public key` instead of `private key` (Pavel Pomerantsev) [#16038](https://github.com/nodejs/node/pull/16038)
* [[`0ae84c2434`](https://github.com/nodejs/node/commit/0ae84c2434)] - **doc**: fix incorrect vm.createContext usage (tshemsedinov) [#16059](https://github.com/nodejs/node/pull/16059)
* [[`344d6132ee`](https://github.com/nodejs/node/commit/344d6132ee)] - **doc**: fix YAML syntax in fs.md (Luigi Pinca) [#15769](https://github.com/nodejs/node/pull/15769)
* [[`df1d988270`](https://github.com/nodejs/node/commit/df1d988270)] - **doc**: explain common.restore* functions (Rich Trott) [#15720](https://github.com/nodejs/node/pull/15720)
* [[`dcad2df78b`](https://github.com/nodejs/node/commit/dcad2df78b)] - **doc**: fix typo in tls.md (kohta ito) [#15738](https://github.com/nodejs/node/pull/15738)
* [[`979e38b13c`](https://github.com/nodejs/node/commit/979e38b13c)] - **doc**: add 'git clean -xfd' to backport guide (Lance Ball) [#15715](https://github.com/nodejs/node/pull/15715)
* [[`978f78ef01`](https://github.com/nodejs/node/commit/978f78ef01)] - **doc**: alphabetize TSC Emeriti in README.md (Rich Trott) [#15722](https://github.com/nodejs/node/pull/15722)
* [[`54a43a6d38`](https://github.com/nodejs/node/commit/54a43a6d38)] - **doc**: change encoding to decoding (Sakthipriyan Vairamani (thefourtheye)) [#15706](https://github.com/nodejs/node/pull/15706)
* [[`cf579eae25`](https://github.com/nodejs/node/commit/cf579eae25)] - **doc**: fix dead link in doc/releases.md (Luigi Pinca) [#15733](https://github.com/nodejs/node/pull/15733)
* [[`fcea265421`](https://github.com/nodejs/node/commit/fcea265421)] - **doc**: fix v8.6 changelog entry (Ruben Bridgewater) [#15716](https://github.com/nodejs/node/pull/15716)
* [[`5630c8cd5d`](https://github.com/nodejs/node/commit/5630c8cd5d)] - **doc**: add missing TOC entry in CONTRIBUTING.md (Vse Mozhet Byt) [#15729](https://github.com/nodejs/node/pull/15729)
* [[`db0ba97bec`](https://github.com/nodejs/node/commit/db0ba97bec)] - **doc**: update fs.utimes{,Sync} changelog (Luigi Pinca) [#15680](https://github.com/nodejs/node/pull/15680)
* [[`cc902832e2`](https://github.com/nodejs/node/commit/cc902832e2)] - **doc**: edit COLLABORATORS_GUIDE.md for readability (Rich Trott) [#15629](https://github.com/nodejs/node/pull/15629)
* [[`f8e93e888e`](https://github.com/nodejs/node/commit/f8e93e888e)] - **doc**: fix links in some intra-repository docs (Vse Mozhet Byt) [#15675](https://github.com/nodejs/node/pull/15675)
* [[`9c247c56ab`](https://github.com/nodejs/node/commit/9c247c56ab)] - **doc**: standardize function param/object prop style (Gibson Fahnestock) [#13769](https://github.com/nodejs/node/pull/13769)
* [[`e5b5a03e00`](https://github.com/nodejs/node/commit/e5b5a03e00)] - **doc**: do not begin yaml value with backtick (Jon Moss) [#15447](https://github.com/nodejs/node/pull/15447)
* [[`f8805c4465`](https://github.com/nodejs/node/commit/f8805c4465)] - **doc**: fix link in the test/README.md (Rimas Misevičius) [#15642](https://github.com/nodejs/node/pull/15642)
* [[`1141e930a3`](https://github.com/nodejs/node/commit/1141e930a3)] - **doc**: update libuv license (Timothy Gu) [#15649](https://github.com/nodejs/node/pull/15649)
* [[`db70874c8f`](https://github.com/nodejs/node/commit/db70874c8f)] - **doc**: add bmeurer to collaborators (Benedikt Meurer) [#15677](https://github.com/nodejs/node/pull/15677)
* [[`ec56cbe572`](https://github.com/nodejs/node/commit/ec56cbe572)] - **doc**: improve fs.utimes (Refael Ackermann) [#14154](https://github.com/nodejs/node/pull/14154)
* [[`6565ddabd0`](https://github.com/nodejs/node/commit/6565ddabd0)] - **doc**: add callback function signatures in fs.md (Matej Krajčovič) [#13424](https://github.com/nodejs/node/pull/13424)
* [[`22b2d1a786`](https://github.com/nodejs/node/commit/22b2d1a786)] - **doc**: fix mistake in http2stream.respondWithFile. (Antoine AMARA) [#15501](https://github.com/nodejs/node/pull/15501)
* [[`d1d2ca5bef`](https://github.com/nodejs/node/commit/d1d2ca5bef)] - **doc**: retire bnoordhuis from the TSC (Ben Noordhuis) [#15626](https://github.com/nodejs/node/pull/15626)
* [[`e0a76347d4`](https://github.com/nodejs/node/commit/e0a76347d4)] - **doc**: update table of contents for common/README.md (Rich Trott) [#15595](https://github.com/nodejs/node/pull/15595)
* [[`6003afcc71`](https://github.com/nodejs/node/commit/6003afcc71)] - **doc,test**: minor improvements to O_DSYNC (Tobias Nießen) [#15547](https://github.com/nodejs/node/pull/15547)
* [[`a814a551f3`](https://github.com/nodejs/node/commit/a814a551f3)] - **(SEMVER-MINOR)** **fs**: add O_DSYNC (Jussi Räsänen) [#15451](https://github.com/nodejs/node/pull/15451)
* [[`9c1e48dca5`](https://github.com/nodejs/node/commit/9c1e48dca5)] - **http**: client keep-alive for UNIX domain sockets (Bryan English) [#13214](https://github.com/nodejs/node/pull/13214)
* [[`10622c6331`](https://github.com/nodejs/node/commit/10622c6331)] - **http2**: near full http1 compatibility, add tests (Anatoli Papirovski) [#15702](https://github.com/nodejs/node/pull/15702)
* [[`86dfcc609c`](https://github.com/nodejs/node/commit/86dfcc609c)] - **http2**: making sending to the socket more efficient (James M Snell) [#15693](https://github.com/nodejs/node/pull/15693)
* [[`68cd233a7b`](https://github.com/nodejs/node/commit/68cd233a7b)] - **http2**: eliminate dead code (James M Snell) [#15693](https://github.com/nodejs/node/pull/15693)
* [[`078ee27f13`](https://github.com/nodejs/node/commit/078ee27f13)] - **http2**: refactor method arguments to avoid bools (James M Snell) [#15693](https://github.com/nodejs/node/pull/15693)
* [[`86ee05d5ca`](https://github.com/nodejs/node/commit/86ee05d5ca)] - **http2**: simplify TypeName (James M Snell) [#15693](https://github.com/nodejs/node/pull/15693)
* [[`df271f4f00`](https://github.com/nodejs/node/commit/df271f4f00)] - **http2**: setting shuttingDown=true after validation (Trivikram Kamat) [#15676](https://github.com/nodejs/node/pull/15676)
* [[`a4a5bee933`](https://github.com/nodejs/node/commit/a4a5bee933)] - **http2**: adjust error emit in core, add tests (Anatoli Papirovski) [#15586](https://github.com/nodejs/node/pull/15586)
* [[`5f469a26f3`](https://github.com/nodejs/node/commit/5f469a26f3)] - **n-api**: add check for large strings (Michael Dawson) [#15611](https://github.com/nodejs/node/pull/15611)
* [[`de52eb8680`](https://github.com/nodejs/node/commit/de52eb8680)] - **perf_hooks**: remove docs for unimplemented API (Sam Roberts) [#15641](https://github.com/nodejs/node/pull/15641)
* [[`e4c461ba7d`](https://github.com/nodejs/node/commit/e4c461ba7d)] - **src**: replace manual memory mgmt with std::string (Ben Noordhuis) [#15782](https://github.com/nodejs/node/pull/15782)
* [[`6642f54184`](https://github.com/nodejs/node/commit/6642f54184)] - **src**: fix ^ in stack trace with vm's columnOffset (Timothy Gu) [#15771](https://github.com/nodejs/node/pull/15771)
* [[`824b8dfe9e`](https://github.com/nodejs/node/commit/824b8dfe9e)] - **src**: remove unused node_dtrace.h from node_win32 (Daniel Bevenius) [#15768](https://github.com/nodejs/node/pull/15768)
* [[`0004214ea7`](https://github.com/nodejs/node/commit/0004214ea7)] - **src**: trace_event macro line continuation cleanup (Daniel Bevenius) [#15750](https://github.com/nodejs/node/pull/15750)
* [[`15063844cb`](https://github.com/nodejs/node/commit/15063844cb)] - **src**: fix windows-only build breakage (Ben Noordhuis) [#15724](https://github.com/nodejs/node/pull/15724)
* [[`965efd7b47`](https://github.com/nodejs/node/commit/965efd7b47)] - **src**: remove unused includes in src/tracing (Daniel Bevenius) [#15682](https://github.com/nodejs/node/pull/15682)
* [[`64d0c7422d`](https://github.com/nodejs/node/commit/64d0c7422d)] - **src**: use UV_EINVAL instead of EINVAL in udp_wrap (Daniel Bevenius) [#15444](https://github.com/nodejs/node/pull/15444)
* [[`6551bb3ace`](https://github.com/nodejs/node/commit/6551bb3ace)] - **src**: fix compiler warning in udp_wrap.cc (Daniel Bevenius) [#15402](https://github.com/nodejs/node/pull/15402)
* [[`7e1003aad3`](https://github.com/nodejs/node/commit/7e1003aad3)] - **src**: remove unused using in node_trace_writer.h (Daniel Bevenius) [#15646](https://github.com/nodejs/node/pull/15646)
* [[`25fd85df36`](https://github.com/nodejs/node/commit/25fd85df36)] - **src**: add help for NODE_PENDING_DEPRECATION env (Thomas Corbière) [#15609](https://github.com/nodejs/node/pull/15609)
* [[`ca02576fb4`](https://github.com/nodejs/node/commit/ca02576fb4)] - **src**: fix typo in probe description (Evan Lucas) [#15397](https://github.com/nodejs/node/pull/15397)
* [[`69f8738a59`](https://github.com/nodejs/node/commit/69f8738a59)] - **src**: remove unused variable in node_url.cc (cjihrig) [#15592](https://github.com/nodejs/node/pull/15592)
* [[`9fcf5d7f25`](https://github.com/nodejs/node/commit/9fcf5d7f25)] - **src**: remove unused computation (cjihrig) [#15593](https://github.com/nodejs/node/pull/15593)
* [[`44ea5254f3`](https://github.com/nodejs/node/commit/44ea5254f3)] - **src**: clear async id stack if bootstrap throws (Trevor Norris) [#15553](https://github.com/nodejs/node/pull/15553)
* [[`67205391b3`](https://github.com/nodejs/node/commit/67205391b3)] - **src**: move node_trace_writer/buffer.h to agent.cc (Daniel Bevenius) [#15598](https://github.com/nodejs/node/pull/15598)
* [[`fd1a8924fd`](https://github.com/nodejs/node/commit/fd1a8924fd)] - **src**: constify PerformanceEntry data members (Ben Noordhuis) [#15458](https://github.com/nodejs/node/pull/15458)
* [[`e72761a27f`](https://github.com/nodejs/node/commit/e72761a27f)] - **src**: return references from getters, not copies (Ben Noordhuis) [#15458](https://github.com/nodejs/node/pull/15458)
* [[`aded597c10`](https://github.com/nodejs/node/commit/aded597c10)] - **src**: handle uv_async_init() failure (Ben Noordhuis) [#15458](https://github.com/nodejs/node/pull/15458)
* [[`d202c05f7e`](https://github.com/nodejs/node/commit/d202c05f7e)] - **src**: remove unused static variable (Ben Noordhuis) [#15458](https://github.com/nodejs/node/pull/15458)
* [[`902feeaad8`](https://github.com/nodejs/node/commit/902feeaad8)] - **src**: use InstantiateModule instead of deprecated (Daniel Bevenius) [#15423](https://github.com/nodejs/node/pull/15423)
* [[`e8da556eca`](https://github.com/nodejs/node/commit/e8da556eca)] - **src**: keep track of env properly in node_perf.cc (Anna Henningsen) [#15391](https://github.com/nodejs/node/pull/15391)
* [[`2e8652e164`](https://github.com/nodejs/node/commit/2e8652e164)] - **(SEMVER-MINOR)** **src**: fix SmartOS compilation (Michaël Zasso) [#14730](https://github.com/nodejs/node/pull/14730)
* [[`a43f681c20`](https://github.com/nodejs/node/commit/a43f681c20)] - **src,etw**: fix event 9 on 64 bit Windows (João Reis) [#15563](https://github.com/nodejs/node/pull/15563)
* [[`ae91ffe53c`](https://github.com/nodejs/node/commit/ae91ffe53c)] - **stream**: fix disparity between buffer and the count (jlvivero) [#15661](https://github.com/nodejs/node/pull/15661)
* [[`3d6390b32b`](https://github.com/nodejs/node/commit/3d6390b32b)] - **stream**: fix todo (Ruben Bridgewater) [#15667](https://github.com/nodejs/node/pull/15667)
* [[`6f42b680e3`](https://github.com/nodejs/node/commit/6f42b680e3)] - **test**: replace common.fixturesDir w/ fixtures.path (Druotic) [#15819](https://github.com/nodejs/node/pull/15819)
* [[`b1e6373dcc`](https://github.com/nodejs/node/commit/b1e6373dcc)] - **test**: replaces fixturesDir with fixtures (Alireza Alidousti) [#15838](https://github.com/nodejs/node/pull/15838)
* [[`50cae5c44f`](https://github.com/nodejs/node/commit/50cae5c44f)] - **test**: remove assert message (Joe Henry)
* [[`e48c8b3b6c`](https://github.com/nodejs/node/commit/e48c8b3b6c)] - **test**: replace fixtureDir with fixtures.path (matthewreed26) [#15943](https://github.com/nodejs/node/pull/15943)
* [[`572492a088`](https://github.com/nodejs/node/commit/572492a088)] - **test**: clarify assert messages in crypto tests (cpandrews8) [#16019](https://github.com/nodejs/node/pull/16019)
* [[`d962ee35de`](https://github.com/nodejs/node/commit/d962ee35de)] - **test**: use common.fixtures module for file path (Adil L) [#16017](https://github.com/nodejs/node/pull/16017)
* [[`8f367bb1a6`](https://github.com/nodejs/node/commit/8f367bb1a6)] - **test**: fix race condition in addon test (Kinnan Kwok) [#16037](https://github.com/nodejs/node/pull/16037)
* [[`5d63c1033d`](https://github.com/nodejs/node/commit/5d63c1033d)] - **test**: create benchmark test for misc and module (Charles T Wall III) [#16044](https://github.com/nodejs/node/pull/16044)
* [[`e9f6a624db`](https://github.com/nodejs/node/commit/e9f6a624db)] - **test**: include expected result in error messages (Chowdhurian) [#16039](https://github.com/nodejs/node/pull/16039)
* [[`f8496553df`](https://github.com/nodejs/node/commit/f8496553df)] - **test**: use fixtures module (Maurice Hayward) [#16034](https://github.com/nodejs/node/pull/16034)
* [[`e4f0483fb9`](https://github.com/nodejs/node/commit/e4f0483fb9)] - **test**: replace fixturesDir with fixtures module (tabulatedreams) [#16036](https://github.com/nodejs/node/pull/16036)
* [[`387b0b8b10`](https://github.com/nodejs/node/commit/387b0b8b10)] - **test**: replace concat with template literals (gitHubTracey) [#15885](https://github.com/nodejs/node/pull/15885)
* [[`6e25b081b6`](https://github.com/nodejs/node/commit/6e25b081b6)] - **test**: clarify assertion failure (ryshep111) [#15889](https://github.com/nodejs/node/pull/15889)
* [[`6a44442b5f`](https://github.com/nodejs/node/commit/6a44442b5f)] - **test**: use fixtures.readKey (Robin Lungwitz) [#15892](https://github.com/nodejs/node/pull/15892)
* [[`f7ab12685e`](https://github.com/nodejs/node/commit/f7ab12685e)] - **test**: replace fixturesDir with fixtures module (Ivan Etchart) [#15893](https://github.com/nodejs/node/pull/15893)
* [[`36a0d3f0b1`](https://github.com/nodejs/node/commit/36a0d3f0b1)] - **test**: cleanup test-buffer-sharedarraybuffer (Rafal Leszczynski) [#15896](https://github.com/nodejs/node/pull/15896)
* [[`bbbf58e951`](https://github.com/nodejs/node/commit/bbbf58e951)] - **test**: change fixturesDir to fixtures.path (Savio Lucena) [#15902](https://github.com/nodejs/node/pull/15902)
* [[`dba620b178`](https://github.com/nodejs/node/commit/dba620b178)] - **test**: changed fixtures require (creisle) [#15899](https://github.com/nodejs/node/pull/15899)
* [[`ccecaca056`](https://github.com/nodejs/node/commit/ccecaca056)] - **test**: replaced fixturesDir with fixtures module (Alex McKenzie) [#15908](https://github.com/nodejs/node/pull/15908)
* [[`547c284335`](https://github.com/nodejs/node/commit/547c284335)] - **test**: replace string concatenation with templates (Colin Leong) [#15903](https://github.com/nodejs/node/pull/15903)
* [[`a625d82c78`](https://github.com/nodejs/node/commit/a625d82c78)] - **test**: updated error message (Emily Platzer) [#15906](https://github.com/nodejs/node/pull/15906)
* [[`3b682aa857`](https://github.com/nodejs/node/commit/3b682aa857)] - **test**: assert.strictEqual using template literals (jmcgui05) [#15944](https://github.com/nodejs/node/pull/15944)
* [[`329d22fb32`](https://github.com/nodejs/node/commit/329d22fb32)] - **test**: use common.fixtures in tls test (Ben Michel) [#15965](https://github.com/nodejs/node/pull/15965)
* [[`9f9bd38aa0`](https://github.com/nodejs/node/commit/9f9bd38aa0)] - **test**: replace error msg w/ template literal (Sushil Tailor) [#15910](https://github.com/nodejs/node/pull/15910)
* [[`181d4bf5b3`](https://github.com/nodejs/node/commit/181d4bf5b3)] - **test**: add NODE_UNIQUE_ID value to err message (Daniele Lisi) [#15914](https://github.com/nodejs/node/pull/15914)
* [[`2d25a3b5f8`](https://github.com/nodejs/node/commit/2d25a3b5f8)] - **test**: replace string concatenation with template (Rob Paton) [#15915](https://github.com/nodejs/node/pull/15915)
* [[`802f99ba27`](https://github.com/nodejs/node/commit/802f99ba27)] - **test**: change concatenation to template literal (nodexpertsdev) [#15916](https://github.com/nodejs/node/pull/15916)
* [[`c5c51ebae4`](https://github.com/nodejs/node/commit/c5c51ebae4)] - **test**: improve asset msg in test (Gene Wu) [#15918](https://github.com/nodejs/node/pull/15918)
* [[`f201edc4be`](https://github.com/nodejs/node/commit/f201edc4be)] - **test**: replace fixturesDir with fixtures module (penDerGraft) [#15919](https://github.com/nodejs/node/pull/15919)
* [[`906f2b14ca`](https://github.com/nodejs/node/commit/906f2b14ca)] - **test**: remove message from asserts (Justin Lee) [#15920](https://github.com/nodejs/node/pull/15920)
* [[`a14b447bbb`](https://github.com/nodejs/node/commit/a14b447bbb)] - **test**: improve an error message (Pavel Pomerantsev) [#15921](https://github.com/nodejs/node/pull/15921)
* [[`27e0532eab`](https://github.com/nodejs/node/commit/27e0532eab)] - **test**: added string_decoder.js a parallel test (Uttam Pawar) [#15923](https://github.com/nodejs/node/pull/15923)
* [[`2ea339a346`](https://github.com/nodejs/node/commit/2ea339a346)] - **test**: use fixtures module instead of common (Joe Grace) [#15925](https://github.com/nodejs/node/pull/15925)
* [[`5bfc4f5e5a`](https://github.com/nodejs/node/commit/5bfc4f5e5a)] - **test**: replace fixtureDir with fixtures module (Charlie Duong) [#15823](https://github.com/nodejs/node/pull/15823)
* [[`7d8a808959`](https://github.com/nodejs/node/commit/7d8a808959)] - **test**: replaced fixturesDir with fixtures module (Alex McKenzie) [#15881](https://github.com/nodejs/node/pull/15881)
* [[`d3272c487a`](https://github.com/nodejs/node/commit/d3272c487a)] - **test**: use common.fixtures module (Christopher Choi) [#15891](https://github.com/nodejs/node/pull/15891)
* [[`e7c55bf77d`](https://github.com/nodejs/node/commit/e7c55bf77d)] - **test**: replaced literals in errors with templates (Paul Milham) [#15911](https://github.com/nodejs/node/pull/15911)
* [[`205927fe6b`](https://github.com/nodejs/node/commit/205927fe6b)] - **test**: display better error message for assertion (Russell Dempsey) [#15883](https://github.com/nodejs/node/pull/15883)
* [[`768060d5e7`](https://github.com/nodejs/node/commit/768060d5e7)] - **test**: changed buffer-zero output (heeeunkimmm) [#15926](https://github.com/nodejs/node/pull/15926)
* [[`0286da0992`](https://github.com/nodejs/node/commit/0286da0992)] - **test**: replaced fixturesDir with fixtures module (Alex McKenzie) [#15927](https://github.com/nodejs/node/pull/15927)
* [[`84dd5783c6`](https://github.com/nodejs/node/commit/84dd5783c6)] - **test**: remove literal error messages (Faisal Yaqoob) [#15928](https://github.com/nodejs/node/pull/15928)
* [[`633772a90c`](https://github.com/nodejs/node/commit/633772a90c)] - **test**: refactor test to use the fixtures module (Daniel Kostro) [#15934](https://github.com/nodejs/node/pull/15934)
* [[`dd23140015`](https://github.com/nodejs/node/commit/dd23140015)] - **test**: replace fixturesDir with fixtures module (Greg Matthews) [#15932](https://github.com/nodejs/node/pull/15932)
* [[`5b29e5a1f3`](https://github.com/nodejs/node/commit/5b29e5a1f3)] - **test**: modify test messages to template literals (Alice Tsui) [#15931](https://github.com/nodejs/node/pull/15931)
* [[`7df8e0b0db`](https://github.com/nodejs/node/commit/7df8e0b0db)] - **test**: replace common.fixturesDir with fixture (BradLarson) [#15940](https://github.com/nodejs/node/pull/15940)
* [[`26536e46ed`](https://github.com/nodejs/node/commit/26536e46ed)] - **test**: changes to use template literal (joanne-jjb) [#15937](https://github.com/nodejs/node/pull/15937)
* [[`e12dc40c2f`](https://github.com/nodejs/node/commit/e12dc40c2f)] - **test**: replace fixturesDir with fixtures (Mujtaba Al-Tameemi) [#15949](https://github.com/nodejs/node/pull/15949)
* [[`30631528e4`](https://github.com/nodejs/node/commit/30631528e4)] - **test**: remove common.fixturesDir (Luis Del Águila) [#15950](https://github.com/nodejs/node/pull/15950)
* [[`9059b09a34`](https://github.com/nodejs/node/commit/9059b09a34)] - **test**: remove template literal (Emily Ford) [#15953](https://github.com/nodejs/node/pull/15953)
* [[`ba9aa46b6d`](https://github.com/nodejs/node/commit/ba9aa46b6d)] - **test**: removed string from assert message arg (dpaulino) [#15954](https://github.com/nodejs/node/pull/15954)
* [[`3fd4f62f35`](https://github.com/nodejs/node/commit/3fd4f62f35)] - **test**: replace literal with template string (Brant Barger) [#15957](https://github.com/nodejs/node/pull/15957)
* [[`a224760639`](https://github.com/nodejs/node/commit/a224760639)] - **test**: upgrade from fixturesDir to fixtures.path (jacjam) [#15960](https://github.com/nodejs/node/pull/15960)
* [[`b564fe2231`](https://github.com/nodejs/node/commit/b564fe2231)] - **test**: use defaultHistoryPath instead of path.join (Chris Budy) [#15969](https://github.com/nodejs/node/pull/15969)
* [[`ece6cd1f9e`](https://github.com/nodejs/node/commit/ece6cd1f9e)] - **test**: replace fixturesDir with fixtures module (BinarySo1o) [#15961](https://github.com/nodejs/node/pull/15961)
* [[`d1bb608b45`](https://github.com/nodejs/node/commit/d1bb608b45)] - **test**: replaced fixturesDir with common.fixtures (jopann) [#15971](https://github.com/nodejs/node/pull/15971)
* [[`adceca44b2`](https://github.com/nodejs/node/commit/adceca44b2)] - **test**: improve assert messages (Eric Pemberton) [#15972](https://github.com/nodejs/node/pull/15972)
* [[`ab046beeeb`](https://github.com/nodejs/node/commit/ab046beeeb)] - **test**: replacing assert message with template (Barry Tam) [#15974](https://github.com/nodejs/node/pull/15974)
* [[`75ab6c00a9`](https://github.com/nodejs/node/commit/75ab6c00a9)] - **test**: use common.fixtures module in test-preload (Laura Cabrera) [#15975](https://github.com/nodejs/node/pull/15975)
* [[`530b62fc0d`](https://github.com/nodejs/node/commit/530b62fc0d)] - **test**: more informative test failure messages (Alec Ferguson) [#15977](https://github.com/nodejs/node/pull/15977)
* [[`4a9e3312fd`](https://github.com/nodejs/node/commit/4a9e3312fd)] - **test**: alter assert.strictEqual to default message (Luke Greenleaf) [#15978](https://github.com/nodejs/node/pull/15978)
* [[`e9d31bc6e4`](https://github.com/nodejs/node/commit/e9d31bc6e4)] - **test**: replaced common.fixturesDir with readKey (Sean Cox) [#15933](https://github.com/nodejs/node/pull/15933)
* [[`054f8f6683`](https://github.com/nodejs/node/commit/054f8f6683)] - **test**: replace fixturesDir in tls-env-bad-extra-ca (Annie Weng) [#15813](https://github.com/nodejs/node/pull/15813)
* [[`d410f74e23`](https://github.com/nodejs/node/commit/d410f74e23)] - **test**: use common.fixtures in checkServerIdentity (Emily Marigold Klassen) [#15951](https://github.com/nodejs/node/pull/15951)
* [[`145d1db923`](https://github.com/nodejs/node/commit/145d1db923)] - **test**: replaced common.fixturesDir with readKey (rhalldearn) [#15952](https://github.com/nodejs/node/pull/15952)
* [[`9592a486e0`](https://github.com/nodejs/node/commit/9592a486e0)] - **test**: use fixtures.path for cmd string building (John Miller) [#15982](https://github.com/nodejs/node/pull/15982)
* [[`4594315eae`](https://github.com/nodejs/node/commit/4594315eae)] - **test**: replace fixturesDir with fixtures.readKey (Thomas Schorn) [#15948](https://github.com/nodejs/node/pull/15948)
* [[`73231d95af`](https://github.com/nodejs/node/commit/73231d95af)] - **test**: replace common.fixturesDir with readKey (ashleyraymaceli) [#15946](https://github.com/nodejs/node/pull/15946)
* [[`73a41cf653`](https://github.com/nodejs/node/commit/73a41cf653)] - **test**: replace common.fixturesDir with fixtures. (Sam Skjonsberg) [#15802](https://github.com/nodejs/node/pull/15802)
* [[`de198a9dc0`](https://github.com/nodejs/node/commit/de198a9dc0)] - **test**: update test to use fixtures module (gbugaisky) [#15955](https://github.com/nodejs/node/pull/15955)
* [[`7ca02b0f0c`](https://github.com/nodejs/node/commit/7ca02b0f0c)] - **test**: replace fixturesDir with common.fixtures (rachelnicole) [#16051](https://github.com/nodejs/node/pull/16051)
* [[`1d7e1c0f18`](https://github.com/nodejs/node/commit/1d7e1c0f18)] - **test**: remove messages in assert.strictEqual (Saeed H) [#16014](https://github.com/nodejs/node/pull/16014)
* [[`8ea96488bc`](https://github.com/nodejs/node/commit/8ea96488bc)] - **test**: update fixturesDir to fixtures.readKey (bitandbang) [#16016](https://github.com/nodejs/node/pull/16016)
* [[`b766d27197`](https://github.com/nodejs/node/commit/b766d27197)] - **test**: replace fixturesDir with common.fixtures (Paul Berry) [#15973](https://github.com/nodejs/node/pull/15973)
* [[`c47ebe20dd`](https://github.com/nodejs/node/commit/c47ebe20dd)] - **test**: replace fixturesDir with common.fixtures (Pooya Paridel) [#15837](https://github.com/nodejs/node/pull/15837)
* [[`516fda6c64`](https://github.com/nodejs/node/commit/516fda6c64)] - **test**: update 'fixturesDir' refs in a test file (James M. Greene) [#15824](https://github.com/nodejs/node/pull/15824)
* [[`e1a1d2e13d`](https://github.com/nodejs/node/commit/e1a1d2e13d)] - **test**: replace common.fixturesDir in test-exception (Chowdhurian) [#15964](https://github.com/nodejs/node/pull/15964)
* [[`47169216d8`](https://github.com/nodejs/node/commit/47169216d8)] - **test**: use fixtures.readKey in https-agent test (Greg Byram) [#15913](https://github.com/nodejs/node/pull/15913)
* [[`f39c7926cf`](https://github.com/nodejs/node/commit/f39c7926cf)] - **test**: http2 client destroy tests in one file (Trivikram Kamat) [#15749](https://github.com/nodejs/node/pull/15749)
* [[`21a8a820a3`](https://github.com/nodejs/node/commit/21a8a820a3)] - **test**: add common.fixtures to https-req-split (Bruce Fletcher) [#15801](https://github.com/nodejs/node/pull/15801)
* [[`bd49ada52a`](https://github.com/nodejs/node/commit/bd49ada52a)] - **test**: http2 stored settings returned when present (Trivikram Kamat) [#15751](https://github.com/nodejs/node/pull/15751)
* [[`1e79a06ac6`](https://github.com/nodejs/node/commit/1e79a06ac6)] - **test**: fix flaky async-hooks/test-tlswrap (Rich Trott) [#15744](https://github.com/nodejs/node/pull/15744)
* [[`22ea3a8cd2`](https://github.com/nodejs/node/commit/22ea3a8cd2)] - **test**: remove `common.PORT` from test-tlswrap (Rich Trott) [#15742](https://github.com/nodejs/node/pull/15742)
* [[`3f1210992c`](https://github.com/nodejs/node/commit/3f1210992c)] - **test**: refactor test-internal-errors (Rich Trott) [#15721](https://github.com/nodejs/node/pull/15721)
* [[`995948a1f9`](https://github.com/nodejs/node/commit/995948a1f9)] - **test**: skip test if host is too slow (Rich Trott) [#15688](https://github.com/nodejs/node/pull/15688)
* [[`af304b21c7`](https://github.com/nodejs/node/commit/af304b21c7)] - **test**: mark test-bindings and test-debug-end flaky (João Reis) [#15747](https://github.com/nodejs/node/pull/15747)
* [[`1582260067`](https://github.com/nodejs/node/commit/1582260067)] - **test**: increase test coverage for os.js (kuroljov) [#14098](https://github.com/nodejs/node/pull/14098)
* [[`88f69d3ec3`](https://github.com/nodejs/node/commit/88f69d3ec3)] - **test**: check that this != new.target in addon (Ben Noordhuis) [#15681](https://github.com/nodejs/node/pull/15681)
* [[`7842f63069`](https://github.com/nodejs/node/commit/7842f63069)] - **test**: Http2Stream destroy server before shutdown (Trivikram Kamat) [#15597](https://github.com/nodejs/node/pull/15597)
* [[`41539381fe`](https://github.com/nodejs/node/commit/41539381fe)] - **test**: http2Stream redundant shutdown and single cb (Trivikram Kamat) [#15612](https://github.com/nodejs/node/pull/15612)
* [[`803d5bbf50`](https://github.com/nodejs/node/commit/803d5bbf50)] - **test**: update es-module.status prefix (Jack Horton) [#15690](https://github.com/nodejs/node/pull/15690)
* [[`bd7b216936`](https://github.com/nodejs/node/commit/bd7b216936)] - **test**: fix test-https-writable-true-after-close (Rich Trott) [#15705](https://github.com/nodejs/node/pull/15705)
* [[`0aea258f0e`](https://github.com/nodejs/node/commit/0aea258f0e)] - **test**: fix http-writable-true-after-close flakyness (Matteo Collina) [#15520](https://github.com/nodejs/node/pull/15520)
* [[`bbdd93f34f`](https://github.com/nodejs/node/commit/bbdd93f34f)] - **test**: skip test when checking async_hooks (Trevor Norris) [#14208](https://github.com/nodejs/node/pull/14208)
* [[`98fc665940`](https://github.com/nodejs/node/commit/98fc665940)] - **test**: print resource stack on error (Trevor Norris) [#14208](https://github.com/nodejs/node/pull/14208)
* [[`ab7448e0d5`](https://github.com/nodejs/node/commit/ab7448e0d5)] - **tools**: replace concatenation with string templates (Ethan Arrowood) [#15858](https://github.com/nodejs/node/pull/15858)
* [[`0e707f3f9e`](https://github.com/nodejs/node/commit/0e707f3f9e)] - **tools**: replace concat with template literals (Minya Liang) [#16046](https://github.com/nodejs/node/pull/16046)
* [[`ca5f4f0ed3`](https://github.com/nodejs/node/commit/ca5f4f0ed3)] - **tools**: use more template literals (Govee91) [#15942](https://github.com/nodejs/node/pull/15942)
* [[`94c6296d83`](https://github.com/nodejs/node/commit/94c6296d83)] - **tools**: use template literals (Sarah Meyer) [#15956](https://github.com/nodejs/node/pull/15956)
* [[`eebb2d775a`](https://github.com/nodejs/node/commit/eebb2d775a)] - **(SEMVER-MINOR)** **tools, build**: refactor macOS installer (JP Wesselink) [#15179](https://github.com/nodejs/node/pull/15179)
* [[`f68f572d7f`](https://github.com/nodejs/node/commit/f68f572d7f)] - **tty**: require readline at top of file (Bryan English) [#15647](https://github.com/nodejs/node/pull/15647)
* [[`d181147b2c`](https://github.com/nodejs/node/commit/d181147b2c)] - **url**: const-ify APIs, and pass URL by ref (Sam Roberts) [#15615](https://github.com/nodejs/node/pull/15615)
* [[`1cc4245bfb`](https://github.com/nodejs/node/commit/1cc4245bfb)] - **url**: fix remaining calculation (Rimas Misevičius) [#15637](https://github.com/nodejs/node/pull/15637)
* [[`34b4180d7d`](https://github.com/nodejs/node/commit/34b4180d7d)] - **url**: change variable name to be more descriptive (Yang-Kichang) [#15551](https://github.com/nodejs/node/pull/15551)
* [[`58c68c2fcb`](https://github.com/nodejs/node/commit/58c68c2fcb)] - **util**: use faster -0 check (Brian White) [#15726](https://github.com/nodejs/node/pull/15726)
* [[`d2e1545406`](https://github.com/nodejs/node/commit/d2e1545406)] - **(SEMVER-MINOR)** **util**: deprecate obj.inspect for custom inspection (Rich Trott) [#15631](https://github.com/nodejs/node/pull/15631)

<a id="8.6.0"></a>
## 2017-09-26, Version 8.6.0 (Current), @jasnell

### Notable Changes

* **crypto**
  * Support for multiple ECDH curves. [#15206](https://github.com/nodejs/node/pull/15206)
* **dgram**
  * Added `setMulticastInterface()` API. [#7855](https://github.com/nodejs/node/pull/7855)
  * Custom lookup functions are now supported. [#14560](https://github.com/nodejs/node/pull/14560)
* **n-api**
  * The command-line flag is no longer required to use N-API. [#14902](https://github.com/nodejs/node/pull/14902)
* **tls**
  * Docs-only deprecation of `parseCertString()`. [#14245](https://github.com/nodejs/node/pull/14245)
* **New Contributors**
  * Welcome Sebastiaan Deckers (@sebdeckers) as a new Collaborator! [#15354](https://github.com/nodejs/node/pull/15354)

### Commits

* [[`4f7d9392e7`](https://github.com/nodejs/node/commit/4f7d9392e7)] - **assert**: improve AssertionError in case of "Errors" (Ruben Bridgewater) [#15025](https://github.com/nodejs/node/pull/15025)
* [[`f6c65e6e19`](https://github.com/nodejs/node/commit/f6c65e6e19)] - **assert**: fix boxed primitives in deepStrictEqual (Ruben Bridgewater) [#15050](https://github.com/nodejs/node/pull/15050)
* [[`7fa175f6d3`](https://github.com/nodejs/node/commit/7fa175f6d3)] - **assert**: fix deepEqual inconsistencies (Ruben Bridgewater) [#14491](https://github.com/nodejs/node/pull/14491)
* [[`17d8dfec70`](https://github.com/nodejs/node/commit/17d8dfec70)] - **async_hooks**: support promise resolve hook (Anna Henningsen) [#15296](https://github.com/nodejs/node/pull/15296)
* [[`81723a9172`](https://github.com/nodejs/node/commit/81723a9172)] - **(SEMVER-MINOR)** **async_hooks,doc**: some async_hooks improvements (James M Snell) [#15103](https://github.com/nodejs/node/pull/15103)
* [[`535f8d5281`](https://github.com/nodejs/node/commit/535f8d5281)] - **benchmark**: var to const (Ruben Bridgewater) [#13757](https://github.com/nodejs/node/pull/13757)
* [[`0f8f37ed45`](https://github.com/nodejs/node/commit/0f8f37ed45)] - **benchmark**: improve and add more inspect benchmarks (Ruben Bridgewater) [#14881](https://github.com/nodejs/node/pull/14881)
* [[`3bf718c3fe`](https://github.com/nodejs/node/commit/3bf718c3fe)] - **benchmark**: enable assert benchmark with short len (Rich Trott) [#15174](https://github.com/nodejs/node/pull/15174)
* [[`d30a5836b6`](https://github.com/nodejs/node/commit/d30a5836b6)] - **benchmark**: provide default methods for assert (Rich Trott) [#15174](https://github.com/nodejs/node/pull/15174)
* [[`142d2ed057`](https://github.com/nodejs/node/commit/142d2ed057)] - **benchmark**: use smaller n value in some http tests (Peter Marshall) [#14002](https://github.com/nodejs/node/pull/14002)
* [[`5e4f87ae65`](https://github.com/nodejs/node/commit/5e4f87ae65)] - **buffer**: improve Buffer.from performance (Anatoli Papirovski) [#15178](https://github.com/nodejs/node/pull/15178)
* [[`8bbbda55e4`](https://github.com/nodejs/node/commit/8bbbda55e4)] - **build**: use generic names for linting tasks (Nikolai Vavilov) [#15272](https://github.com/nodejs/node/pull/15272)
* [[`9685b9ff2f`](https://github.com/nodejs/node/commit/9685b9ff2f)] - **build**: don't fail `make test` on source tarballs (Gibson Fahnestock) [#15441](https://github.com/nodejs/node/pull/15441)
* [[`354f32040d`](https://github.com/nodejs/node/commit/354f32040d)] - **build**: remove unused configuration variable (Ben Noordhuis) [#15266](https://github.com/nodejs/node/pull/15266)
* [[`5d217ad5d7`](https://github.com/nodejs/node/commit/5d217ad5d7)] - **build**: add support for link-module to vcbuild (Bartosz Sosnowski) [#15410](https://github.com/nodejs/node/pull/15410)
* [[`607832d3c3`](https://github.com/nodejs/node/commit/607832d3c3)] - **child_process**: set shell to false in fork() (Alex Gresnel) [#15352](https://github.com/nodejs/node/pull/15352)
* [[`c26e93b309`](https://github.com/nodejs/node/commit/c26e93b309)] - **crypto**: fix Node_SignFinal (David Benjamin) [#15024](https://github.com/nodejs/node/pull/15024)
* [[`bd07574718`](https://github.com/nodejs/node/commit/bd07574718)] - **(SEMVER-MINOR)** **crypto**: support multiple ECDH curves and auto (Roga Pria Sembada) [#15206](https://github.com/nodejs/node/pull/15206)
* [[`5e043a6c78`](https://github.com/nodejs/node/commit/5e043a6c78)] - **deps**: define BUILDING_NGHTTP2 during nghttp2 build (Ben Noordhuis) [#15487](https://github.com/nodejs/node/pull/15487)
* [[`2e75ac028a`](https://github.com/nodejs/node/commit/2e75ac028a)] - **deps**: v8: fix potential segfault in profiler (Ali Ijaz Sheikh) [#15498](https://github.com/nodejs/node/pull/15498)
* [[`2944ea6c6b`](https://github.com/nodejs/node/commit/2944ea6c6b)] - **(SEMVER-MINOR)** **dgram**: add custom lookup function in sockets (cjihrig) [#14560](https://github.com/nodejs/node/pull/14560)
* [[`b24ee68133`](https://github.com/nodejs/node/commit/b24ee68133)] - **(SEMVER-MINOR)** **dgram**: added setMulticastInterface() (Will Young) [#7855](https://github.com/nodejs/node/pull/7855)
* [[`f6b484461c`](https://github.com/nodejs/node/commit/f6b484461c)] - **doc**: ctc -\> tsc in onboarding extras (Bryan English) [#15621](https://github.com/nodejs/node/pull/15621)
* [[`f38666a967`](https://github.com/nodejs/node/commit/f38666a967)] - **doc**: ctc -\> tsc in collab guide (Bryan English) [#15590](https://github.com/nodejs/node/pull/15590)
* [[`02c62df75e`](https://github.com/nodejs/node/commit/02c62df75e)] - **doc**: remove invalid hash in link (Vse Mozhet Byt) [#15542](https://github.com/nodejs/node/pull/15542)
* [[`6cd64f36bc`](https://github.com/nodejs/node/commit/6cd64f36bc)] - **doc**: note caveats in process message serialization (Joyee Cheung) [#12963](https://github.com/nodejs/node/pull/12963)
* [[`1fbb86c64b`](https://github.com/nodejs/node/commit/1fbb86c64b)] - **doc**: fix 'aborted' event documentation (Luigi Pinca) [#15471](https://github.com/nodejs/node/pull/15471)
* [[`2326d655de`](https://github.com/nodejs/node/commit/2326d655de)] - **doc**: fix types and description for dns.resolveTxt (Tobias Nießen) [#15472](https://github.com/nodejs/node/pull/15472)
* [[`fcbee7b4bb`](https://github.com/nodejs/node/commit/fcbee7b4bb)] - **doc**: fix some links in http2.md (Vse Mozhet Byt) [#15481](https://github.com/nodejs/node/pull/15481)
* [[`9d6b0e6f6f`](https://github.com/nodejs/node/commit/9d6b0e6f6f)] - **doc**: fix external links with 404 status (Vse Mozhet Byt) [#15463](https://github.com/nodejs/node/pull/15463)
* [[`29fd88c3e5`](https://github.com/nodejs/node/commit/29fd88c3e5)] - **doc**: fix new nits in links (Vse Mozhet Byt) [#15449](https://github.com/nodejs/node/pull/15449)
* [[`4efc6fec6b`](https://github.com/nodejs/node/commit/4efc6fec6b)] - **doc**: fix some internal links (Vse Mozhet Byt) [#15293](https://github.com/nodejs/node/pull/15293)
* [[`5ea4b88a29`](https://github.com/nodejs/node/commit/5ea4b88a29)] - **doc**: adding sebdeckers to collaborators (Sebastiaan Deckers) [#15354](https://github.com/nodejs/node/pull/15354)
* [[`d5d498b6dc`](https://github.com/nodejs/node/commit/d5d498b6dc)] - **doc**: update AUTHORS list (Michaël Zasso) [#15181](https://github.com/nodejs/node/pull/15181)
* [[`950f7f5fe1`](https://github.com/nodejs/node/commit/950f7f5fe1)] - **doc**: update README with SHASUMS256.txt.sig info (Jon Moss) [#15107](https://github.com/nodejs/node/pull/15107)
* [[`38422d5963`](https://github.com/nodejs/node/commit/38422d5963)] - **doc**: fix nits in esm.md (Vse Mozhet Byt) [#15315](https://github.com/nodejs/node/pull/15315)
* [[`b0f5b2a38c`](https://github.com/nodejs/node/commit/b0f5b2a38c)] - **doc**: fix "added in" for Buffer.allocUnsafeSlow() (Tuan Anh Tran) [#15330](https://github.com/nodejs/node/pull/15330)
* [[`8112f496dc`](https://github.com/nodejs/node/commit/8112f496dc)] - **doc**: add missing heading for error (Jon Moss) [#15325](https://github.com/nodejs/node/pull/15325)
* [[`29707afd82`](https://github.com/nodejs/node/commit/29707afd82)] - **doc**: add missing doc for readable._destroy (Michaël Zasso) [#15316](https://github.com/nodejs/node/pull/15316)
* [[`9f4480ce90`](https://github.com/nodejs/node/commit/9f4480ce90)] - **doc**: use consistent terminology in process doc (Rich Trott) [#15321](https://github.com/nodejs/node/pull/15321)
* [[`a53a0d8b38`](https://github.com/nodejs/node/commit/a53a0d8b38)] - **doc**: fix emitKeypressEvents stream type (Oblosys) [#15399](https://github.com/nodejs/node/pull/15399)
* [[`b5c1a82560`](https://github.com/nodejs/node/commit/b5c1a82560)] - **doc**: fix http.ClientRequest method descriptions (Antoine AMARA) [#15163](https://github.com/nodejs/node/pull/15163)
* [[`f0e411d1b2`](https://github.com/nodejs/node/commit/f0e411d1b2)] - **doc**: prevent displaying empty version picker (Chris Young) [#15420](https://github.com/nodejs/node/pull/15420)
* [[`acb0d012b3`](https://github.com/nodejs/node/commit/acb0d012b3)] - **doc**: make mkdtemp example work on Windows (Bartosz Sosnowski) [#15408](https://github.com/nodejs/node/pull/15408)
* [[`bdfed1ad25`](https://github.com/nodejs/node/commit/bdfed1ad25)] - **doc**: fix entryTypes type and missing link (Mani Maghsoudlou) [#15406](https://github.com/nodejs/node/pull/15406)
* [[`7fa2bee5e7`](https://github.com/nodejs/node/commit/7fa2bee5e7)] - **doc**: add documentation for the 'timeout' event (Luigi Pinca) [#15443](https://github.com/nodejs/node/pull/15443)
* [[`b09eeb4a3d`](https://github.com/nodejs/node/commit/b09eeb4a3d)] - **(SEMVER-MINOR)** **doc, tls**: mark parseCertString() as deprecated (XadillaX) [#14245](https://github.com/nodejs/node/pull/14245)
* [[`e0f5e3a199`](https://github.com/nodejs/node/commit/e0f5e3a199)] - **docs**: clarify usage cli options -e,-p on windows (Łukasz Szewczak) [#15568](https://github.com/nodejs/node/pull/15568)
* [[`a792ea7709`](https://github.com/nodejs/node/commit/a792ea7709)] - **docs**: update 8.5.0 changelog (Myles Borins) [#15384](https://github.com/nodejs/node/pull/15384)
* [[`0a8258b3de`](https://github.com/nodejs/node/commit/0a8258b3de)] - **errors**: remove duplicate error definition (Jon Moss)
* [[`a14b252c5c`](https://github.com/nodejs/node/commit/a14b252c5c)] - **errors**: eliminate circular dependency on assert (James M Snell) [#15002](https://github.com/nodejs/node/pull/15002)
* [[`b58a2aae1b`](https://github.com/nodejs/node/commit/b58a2aae1b)] - **errors**: fix ERR_MODULE_RESOLUTION_LEGACY message (Tobias Nießen) [#15290](https://github.com/nodejs/node/pull/15290)
* [[`da3265ad82`](https://github.com/nodejs/node/commit/da3265ad82)] - **errors**: backport ERR_INVALID_PROTOCOL to v8.x (Myles Borins) [#15388](https://github.com/nodejs/node/pull/15388)
* [[`2e0313865b`](https://github.com/nodejs/node/commit/2e0313865b)] - **errors,tools**: alphabetize-errors lint rule (Jon Moss) [#15083](https://github.com/nodejs/node/pull/15083)
* [[`771c2ac7c2`](https://github.com/nodejs/node/commit/771c2ac7c2)] - **http**: revert #14024 writable is never set to false (Matteo Collina) [#15404](https://github.com/nodejs/node/pull/15404)
* [[`68ec157be0`](https://github.com/nodejs/node/commit/68ec157be0)] - **http2**: fix compat stream read handling, add tests (Anatoli Papirovski) [#15503](https://github.com/nodejs/node/pull/15503)
* [[`9fc8eddfdd`](https://github.com/nodejs/node/commit/9fc8eddfdd)] - **http2**: remove unused onTimeout, add timeout tests (Anatoli Papirovski) [#15539](https://github.com/nodejs/node/pull/15539)
* [[`1691827b8c`](https://github.com/nodejs/node/commit/1691827b8c)] - **http2**: small fixes to compatibility layer (Anatoli Papirovski) [#15473](https://github.com/nodejs/node/pull/15473)
* [[`66a5f99828`](https://github.com/nodejs/node/commit/66a5f99828)] - **http2**: improved coverage of Http2Stream destroy (Simon Brewster) [#15461](https://github.com/nodejs/node/pull/15461)
* [[`ba9012d4bc`](https://github.com/nodejs/node/commit/ba9012d4bc)] - **http2**: add tests for push stream error handling (Anatoli Papirovski) [#15281](https://github.com/nodejs/node/pull/15281)
* [[`b61220ed84`](https://github.com/nodejs/node/commit/b61220ed84)] - **http2**: fix subsequent end calls to not throw (Anatoli Papirovski) [#15414](https://github.com/nodejs/node/pull/15414)
* [[`2e421ff5c9`](https://github.com/nodejs/node/commit/2e421ff5c9)] - **http2**: correct behaviour for enablePush unpack (Anatoli Papirovski) [#15167](https://github.com/nodejs/node/pull/15167)
* [[`9490be353e`](https://github.com/nodejs/node/commit/9490be353e)] - **http2**: cleanup of h2 compat layer, add tests (Anatoli Papirovski) [#15254](https://github.com/nodejs/node/pull/15254)
* [[`aa0917cd0a`](https://github.com/nodejs/node/commit/aa0917cd0a)] - **http2**: improve http2 coverage (James M Snell) [#15210](https://github.com/nodejs/node/pull/15210)
* [[`a6879bfab6`](https://github.com/nodejs/node/commit/a6879bfab6)] - **http2**: custom promisify for http2.connect (James M Snell) [#15207](https://github.com/nodejs/node/pull/15207)
* [[`2ea2725ce0`](https://github.com/nodejs/node/commit/2ea2725ce0)] - **http2**: emit close event if request aborted (Anatoli Papirovski) [#15415](https://github.com/nodejs/node/pull/15415)
* [[`b9a9290e8d`](https://github.com/nodejs/node/commit/b9a9290e8d)] - **http2**: expand list of known headers (Anatoli Papirovski) [#15434](https://github.com/nodejs/node/pull/15434)
* [[`a32c8a566e`](https://github.com/nodejs/node/commit/a32c8a566e)] - **http2,async-wrap**: introduce AliasedBuffer class (Mike Kaufman) [#15077](https://github.com/nodejs/node/pull/15077)
* [[`25692a985c`](https://github.com/nodejs/node/commit/25692a985c)] - **inspector**: break in eval script (Eugene Ostroukhov) [#14581](https://github.com/nodejs/node/pull/14581)
* [[`cf1fe762dc`](https://github.com/nodejs/node/commit/cf1fe762dc)] - **lib**: improve lazy requires (Ruben Bridgewater) [#14167](https://github.com/nodejs/node/pull/14167)
* [[`8ce0e9a619`](https://github.com/nodejs/node/commit/8ce0e9a619)] - **lib**: refactor console startup (Ruben Bridgewater) [#15111](https://github.com/nodejs/node/pull/15111)
* [[`91e96d8f08`](https://github.com/nodejs/node/commit/91e96d8f08)] - **lib,src**: fix consistent spacing inside braces (James M Snell) [#14162](https://github.com/nodejs/node/pull/14162)
* [[`ede09f29d0`](https://github.com/nodejs/node/commit/ede09f29d0)] - **meta**: allow vague objections to be dismissed (James M Snell) [#15233](https://github.com/nodejs/node/pull/15233)
* [[`727d7b5078`](https://github.com/nodejs/node/commit/727d7b5078)] - **meta**: improve contributors guide (James M Snell) [#15123](https://github.com/nodejs/node/pull/15123)
* [[`c005713d05`](https://github.com/nodejs/node/commit/c005713d05)] - **module**: check file url passed to top-level import (guybedford) [#15389](https://github.com/nodejs/node/pull/15389)
* [[`939c8ed084`](https://github.com/nodejs/node/commit/939c8ed084)] - **module**: coverity fixes for ESM C++ (Bradley Farias) [#15275](https://github.com/nodejs/node/pull/15275)
* [[`a95ddc9484`](https://github.com/nodejs/node/commit/a95ddc9484)] - **n-api**: fix warning about size_t compare with int (Sampson Gao) [#15508](https://github.com/nodejs/node/pull/15508)
* [[`cd3a8e8832`](https://github.com/nodejs/node/commit/cd3a8e8832)] - **n-api**: remove n-api module loading flag (Gabriel Schulhof) [#14902](https://github.com/nodejs/node/pull/14902)
* [[`526e78f5cd`](https://github.com/nodejs/node/commit/526e78f5cd)] - **n-api**: add optional string length parameters (Sampson Gao) [#15343](https://github.com/nodejs/node/pull/15343)
* [[`87a3162f85`](https://github.com/nodejs/node/commit/87a3162f85)] - **n-api**: Context for custom async operations (Jason Ginchereau) [#15189](https://github.com/nodejs/node/pull/15189)
* [[`7b7c030adc`](https://github.com/nodejs/node/commit/7b7c030adc)] - **(SEMVER-MINOR)** **n-api**: change async resource name to napi_value (Jason Ginchereau) [#14697](https://github.com/nodejs/node/pull/14697)
* [[`d5b3002572`](https://github.com/nodejs/node/commit/d5b3002572)] - **n-api**: stop creating references to primitives (Gabriel Schulhof) [#15289](https://github.com/nodejs/node/pull/15289)
* [[`a47fe692b1`](https://github.com/nodejs/node/commit/a47fe692b1)] - **(SEMVER-MINOR)** **n-api**: use AsyncResource for Work tracking (Anna Henningsen) [#14697](https://github.com/nodejs/node/pull/14697)
* [[`8f12b9dce4`](https://github.com/nodejs/node/commit/8f12b9dce4)] - **n-api**: refactor napi_addon_register_func (Taylor Woll) [#15088](https://github.com/nodejs/node/pull/15088)
* [[`a2d340fb00`](https://github.com/nodejs/node/commit/a2d340fb00)] - **n-api**: napi_is_construct_call-\>napi_get_new_target (Sampson Gao) [#14698](https://github.com/nodejs/node/pull/14698)
* [[`fe9bb7e51e`](https://github.com/nodejs/node/commit/fe9bb7e51e)] - **net**: support passing null to listen() (cjihrig) [#14221](https://github.com/nodejs/node/pull/14221)
* [[`19d2d6611c`](https://github.com/nodejs/node/commit/19d2d6611c)] - **path**: fix normalize paths ending with two dots (Michaël Zasso) [nodejs-private/node-private#94](https://github.com/nodejs-private/node-private/pull/94)
* [[`8eeaba62bc`](https://github.com/nodejs/node/commit/8eeaba62bc)] - **readline**: name some anonymous functions (Flandre Scarlet) [#14297](https://github.com/nodejs/node/pull/14297)
* [[`4907ae7cb9`](https://github.com/nodejs/node/commit/4907ae7cb9)] - **src**: correct typo in trace_event header (Daniel Bevenius) [#15583](https://github.com/nodejs/node/pull/15583)
* [[`4f88c19cf3`](https://github.com/nodejs/node/commit/4f88c19cf3)] - **src**: add --pending-deprecation to NODE_OPTIONS (Thomas Corbière) [#15494](https://github.com/nodejs/node/pull/15494)
* [[`b87088c0b1`](https://github.com/nodejs/node/commit/b87088c0b1)] - **src**: remove unused constant from node_perf.h (Anna Henningsen) [#15548](https://github.com/nodejs/node/pull/15548)
* [[`90d14df56d`](https://github.com/nodejs/node/commit/90d14df56d)] - **src**: minor c++ refactors to module_wrap (Anna Henningsen) [#15515](https://github.com/nodejs/node/pull/15515)
* [[`24271a7aca`](https://github.com/nodejs/node/commit/24271a7aca)] - **src**: do not include internals from node_buffer.h (Anna Henningsen) [#15554](https://github.com/nodejs/node/pull/15554)
* [[`774e42b575`](https://github.com/nodejs/node/commit/774e42b575)] - **(SEMVER-MINOR)** **src**: refactor `#include` handling (Anna Henningsen) [#14697](https://github.com/nodejs/node/pull/14697)
* [[`29e38ab2a2`](https://github.com/nodejs/node/commit/29e38ab2a2)] - **src**: remove unused perf_hooks uv handles (James M Snell) [#15368](https://github.com/nodejs/node/pull/15368)
* [[`606da2ba43`](https://github.com/nodejs/node/commit/606da2ba43)] - **(SEMVER-MINOR)** **src**: make in_makecallback() getter const (Anna Henningsen) [#14697](https://github.com/nodejs/node/pull/14697)
* [[`98967c988f`](https://github.com/nodejs/node/commit/98967c988f)] - **(SEMVER-MINOR)** **src**: refactor async callback handling (Anna Henningsen) [#14697](https://github.com/nodejs/node/pull/14697)
* [[`f60a2aa982`](https://github.com/nodejs/node/commit/f60a2aa982)] - **(SEMVER-MINOR)** **src**: remove virtually unused ExecScope (Anna Henningsen) [#14697](https://github.com/nodejs/node/pull/14697)
* [[`6c520af6d5`](https://github.com/nodejs/node/commit/6c520af6d5)] - **(SEMVER-MINOR)** **src**: move DomainEnter,DomainExit to node.cc (Anna Henningsen) [#14697](https://github.com/nodejs/node/pull/14697)
* [[`8c480f9d8c`](https://github.com/nodejs/node/commit/8c480f9d8c)] - **src**: remove outdated todo from node_crypto.cc (Bartek Szczepański) [#15104](https://github.com/nodejs/node/pull/15104)
* [[`409576e015`](https://github.com/nodejs/node/commit/409576e015)] - **test**: expand http2 util test coverage for headers (Anatoli Papirovski) [#15493](https://github.com/nodejs/node/pull/15493)
* [[`0503c44835`](https://github.com/nodejs/node/commit/0503c44835)] - **test**: update test-fs-fsync to run from temp (atvoicu) [#15537](https://github.com/nodejs/node/pull/15537)
* [[`29f0ad6ccb`](https://github.com/nodejs/node/commit/29f0ad6ccb)] - **test**: fixing AliasedBuffer tests to enter Isolate (Mike Kaufman) [#15536](https://github.com/nodejs/node/pull/15536)
* [[`eccf503362`](https://github.com/nodejs/node/commit/eccf503362)] - **test**: improve readline test coverage for tty (Claudio Rodriguez) [#12064](https://github.com/nodejs/node/pull/12064)
* [[`58b9495c42`](https://github.com/nodejs/node/commit/58b9495c42)] - **test**: use reserved invalid hostname for tests (icarter09) [#14781](https://github.com/nodejs/node/pull/14781)
* [[`b1227147b9`](https://github.com/nodejs/node/commit/b1227147b9)] - **test**: clean up some assert deepEqual tests (Ruben Bridgewater) [#14491](https://github.com/nodejs/node/pull/14491)
* [[`93c08b0735`](https://github.com/nodejs/node/commit/93c08b0735)] - **test**: improve util inspect tests (Ruben Bridgewater) [#14881](https://github.com/nodejs/node/pull/14881)
* [[`59f183640b`](https://github.com/nodejs/node/commit/59f183640b)] - **test**: refactor test for readability (Refael Ackermann) [#13003](https://github.com/nodejs/node/pull/13003)
* [[`757c34276b`](https://github.com/nodejs/node/commit/757c34276b)] - **test**: fix actual and expected order (Ruben Bridgewater) [#14881](https://github.com/nodejs/node/pull/14881)
* [[`5125c08c50`](https://github.com/nodejs/node/commit/5125c08c50)] - **test**: remove obsolete debugger tests (Rich Trott) [#15139](https://github.com/nodejs/node/pull/15139)
* [[`7dfd570cad`](https://github.com/nodejs/node/commit/7dfd570cad)] - **test**: add test-benchmark-assert (Rich Trott) [#15174](https://github.com/nodejs/node/pull/15174)
* [[`a9066459ad`](https://github.com/nodejs/node/commit/a9066459ad)] - **test**: convert buffer benchmark to runBenchmark (Jon Moss) [#15349](https://github.com/nodejs/node/pull/15349)
* [[`45cdbcfee6`](https://github.com/nodejs/node/commit/45cdbcfee6)] - **test**: create shared runBenchmark function (Jon Moss) [#15004](https://github.com/nodejs/node/pull/15004)
* [[`ba96c8f23e`](https://github.com/nodejs/node/commit/ba96c8f23e)] - **test**: don't skip when common.mustCall() is pending (cjihrig) [#15421](https://github.com/nodejs/node/pull/15421)
* [[`50b6203a33`](https://github.com/nodejs/node/commit/50b6203a33)] - **(SEMVER-MINOR)** **test**: add regression test for 5691 (Anna Henningsen) [#14697](https://github.com/nodejs/node/pull/14697)
* [[`f0a741d178`](https://github.com/nodejs/node/commit/f0a741d178)] - **test**: kill subprocess only after last ACK (Refael Ackermann) [#15186](https://github.com/nodejs/node/pull/15186)
* [[`4d68064493`](https://github.com/nodejs/node/commit/4d68064493)] - **test**: move common.PORT tests to sequential (Jon Moss) [#15151](https://github.com/nodejs/node/pull/15151)
* [[`a92f3dfd8c`](https://github.com/nodejs/node/commit/a92f3dfd8c)] - **test**: make test-http-agent-maxsockets robust (Rich Trott) [#15192](https://github.com/nodejs/node/pull/15192)
* [[`edece30930`](https://github.com/nodejs/node/commit/edece30930)] - **test**: remove random timer in test-tls-fast-writing (Rich Trott) [#15138](https://github.com/nodejs/node/pull/15138)
* [[`b1a0bdcdaf`](https://github.com/nodejs/node/commit/b1a0bdcdaf)] - **test**: remove faulty test case (Ruben Bridgewater) [#15110](https://github.com/nodejs/node/pull/15110)
* [[`cd238e2c0e`](https://github.com/nodejs/node/commit/cd238e2c0e)] - **test**: check inspect array with empty string key (Rahul Mishra) [#15258](https://github.com/nodejs/node/pull/15258)
* [[`3ce501c8ff`](https://github.com/nodejs/node/commit/3ce501c8ff)] - **test**: improve process warning coverage (James M Snell) [#15212](https://github.com/nodejs/node/pull/15212)
* [[`a2c335b973`](https://github.com/nodejs/node/commit/a2c335b973)] - **test**: fix sequential/test-async-wrap-getasyncid (Anna Henningsen) [#15319](https://github.com/nodejs/node/pull/15319)
* [[`94e2b5c371`](https://github.com/nodejs/node/commit/94e2b5c371)] - **test**: refactor test-debug-prompt (Rich Trott) [#15141](https://github.com/nodejs/node/pull/15141)
* [[`5881033138`](https://github.com/nodejs/node/commit/5881033138)] - **test**: remove invalid test (Rich Trott) [#15320](https://github.com/nodejs/node/pull/15320)
* [[`a1abf62cc3`](https://github.com/nodejs/node/commit/a1abf62cc3)] - **test**: allow adding known-globals through ENV (Refael Ackermann) [#15187](https://github.com/nodejs/node/pull/15187)
* [[`427bf80194`](https://github.com/nodejs/node/commit/427bf80194)] - **test**: add test for fork() + shell (cjihrig) [#15352](https://github.com/nodejs/node/pull/15352)
* [[`4d26c68b6b`](https://github.com/nodejs/node/commit/4d26c68b6b)] - **test**: move test-benchmark-buffer to sequential (Rich Trott) [#15373](https://github.com/nodejs/node/pull/15373)
* [[`1fbdf47742`](https://github.com/nodejs/node/commit/1fbdf47742)] - **test**: fix flaky test-http2-session-timeout (Anatoli Papirovski) [#15338](https://github.com/nodejs/node/pull/15338)
* [[`f20fb4ce40`](https://github.com/nodejs/node/commit/f20fb4ce40)] - **test**: do not write fixture in test-require-symlink (Rich Trott) [#15067](https://github.com/nodejs/node/pull/15067)
* [[`389c8c33d7`](https://github.com/nodejs/node/commit/389c8c33d7)] - **test**: expand http2 frameError test case (Anatoli Papirovski) [#15298](https://github.com/nodejs/node/pull/15298)
* [[`d82ae0cb6e`](https://github.com/nodejs/node/commit/d82ae0cb6e)] - **test**: backward compatible api for tty (Gergely Nemeth) [#15235](https://github.com/nodejs/node/pull/15235)
* [[`e014983ec4`](https://github.com/nodejs/node/commit/e014983ec4)] - **test,process**: run 'abort' suite on Windows (Refael Ackermann) [#15056](https://github.com/nodejs/node/pull/15056)
* [[`6a94c1aa3b`](https://github.com/nodejs/node/commit/6a94c1aa3b)] - **timers**: clarify lib/timer.js comment (Daniel Bevenius) [#11018](https://github.com/nodejs/node/pull/11018)
* [[`ee157e5a7f`](https://github.com/nodejs/node/commit/ee157e5a7f)] - **tls**: prefer path over port in connect (Bryan English) [#14564](https://github.com/nodejs/node/pull/14564)
* [[`9049f09e0f`](https://github.com/nodejs/node/commit/9049f09e0f)] - **tools**: enforce consistent spacing inside braces (Sebastiaan Deckers) [#14162](https://github.com/nodejs/node/pull/14162)
* [[`6c221b83e3`](https://github.com/nodejs/node/commit/6c221b83e3)] - **url**: fix windows drive letter handling (Benjamin Coe) [#15490](https://github.com/nodejs/node/pull/15490)
* [[`fc1448f357`](https://github.com/nodejs/node/commit/fc1448f357)] - **util**: improve format performance (Ruben Bridgewater) [#15422](https://github.com/nodejs/node/pull/15422)
* [[`5b47f846b0`](https://github.com/nodejs/node/commit/5b47f846b0)] - **util**: fix out of bounds indices in util.inspect (Ruben Bridgewater) [#14881](https://github.com/nodejs/node/pull/14881)
* [[`9e8b1b3ec6`](https://github.com/nodejs/node/commit/9e8b1b3ec6)] - **util**: refactor inspect for performance and more (Ruben Bridgewater) [#14881](https://github.com/nodejs/node/pull/14881)
* [[`539445890b`](https://github.com/nodejs/node/commit/539445890b)] - **util**: add fast internal array join method (Ruben Bridgewater) [#14881](https://github.com/nodejs/node/pull/14881)
* [[`7d95dc385c`](https://github.com/nodejs/node/commit/7d95dc385c)] - **vm**: support parsing a script in a specific context (Timothy Gu) [#14888](https://github.com/nodejs/node/pull/14888)

<a id="8.5.0"></a>
## 2017-09-12, Version 8.5.0 (Current), @MylesBorins

### Notable Changes

* **build**
  * Snapshots are now re-enabled in V8
    [#14875](https://github.com/nodejs/node/pull/14875)
* **console**
  * Implement minimal `console.group()`.
    [#14910](https://github.com/nodejs/node/pull/14910)
* **deps**
  * upgrade libuv to 1.14.1
    [#14866](https://github.com/nodejs/node/pull/14866)
  * update nghttp2 to v1.25.0
    [#14955](https://github.com/nodejs/node/pull/14955)
* **dns**
  * Add `verbatim` option to dns.lookup(). When true, results from the DNS
    resolver are passed on as-is, without the reshuffling that Node.js
    otherwise does that puts IPv4 addresses before IPv6 addresses.
    [#14731](https://github.com/nodejs/node/pull/14731)
* **fs**
  * add fs.copyFile and fs.copyFileSync which allows for more efficient
    copying of files.
    [#15034](https://github.com/nodejs/node/pull/15034)
* **inspector**
  * Enable async stack traces [#13870](https://github.com/nodejs/node/pull/13870)
* **module**
  * Add support for ESM. This is currently behind the `--experimental-modules` flag
    and requires the .mjs extension.
    `node --experimental-modules index.mjs`
    [#14369](https://github.com/nodejs/node/pull/14369)
* **napi**
  * implement promise
    [#14365](https://github.com/nodejs/node/pull/14365)
* **os**
  * Add support for CIDR notation to the output of the networkInterfaces() method.
    [#14307](https://github.com/nodejs/node/pull/14307)
* **perf_hooks**
  * An initial implementation of the Performance Timing API for Node.js. This is the
    same Performance Timing API implemented by modern browsers with a number of Node.js
    specific properties. The User Timing mark() and measure() APIs are implemented.
    [#14680](https://github.com/nodejs/node/pull/14680)
* **tls**
  * multiple PFX in createSecureContext
    [#14793](https://github.com/nodejs/node/pull/14793)
* **Added new collaborators**
  * [BridgeAR](https://github.com/BridgeAR) – Ruben Bridgewater

### Commits

* [[`87c3e1d7de`](https://github.com/nodejs/node/commit/87c3e1d7de)] - fix --prof-process --preprocess flag (davidmarkclements) [#14966](https://github.com/nodejs/node/pull/14966)
* [[`bcf0e5d676`](https://github.com/nodejs/node/commit/bcf0e5d676)] - **assert**: handle errors properly with deep*Equal (Ruben Bridgewater) [#15001](https://github.com/nodejs/node/pull/15001)
* [[`7174dc2e8a`](https://github.com/nodejs/node/commit/7174dc2e8a)] - **assert**: handle sparse arrays in deepStrictEqual (Ruben Bridgewater) [#15027](https://github.com/nodejs/node/pull/15027)
* [[`b40105df3b`](https://github.com/nodejs/node/commit/b40105df3b)] - **async_hooks**: don't abort unnecessarily (Trevor Norris) [#14722](https://github.com/nodejs/node/pull/14722)
* [[`3e73ea8745`](https://github.com/nodejs/node/commit/3e73ea8745)] - **async_hooks**: improve comments and function names (Trevor Norris) [#14722](https://github.com/nodejs/node/pull/14722)
* [[`700d576962`](https://github.com/nodejs/node/commit/700d576962)] - **async_hooks**: emitAfter correctly on fatalException (Trevor Norris) [#14914](https://github.com/nodejs/node/pull/14914)
* [[`78a36e0dd1`](https://github.com/nodejs/node/commit/78a36e0dd1)] - **async_wrap**: unroll unnecessarily DRY code (Trevor Norris) [#14722](https://github.com/nodejs/node/pull/14722)
* [[`fadccbaa17`](https://github.com/nodejs/node/commit/fadccbaa17)] - **async_wrap**: return undefined if domain is disposed (Trevor Norris) [#14722](https://github.com/nodejs/node/pull/14722)
* [[`8d11220e0b`](https://github.com/nodejs/node/commit/8d11220e0b)] - **benchmark**: add default configs to buffer benchmark (Rich Trott) [#15175](https://github.com/nodejs/node/pull/15175)
* [[`7feb99455a`](https://github.com/nodejs/node/commit/7feb99455a)] - **benchmark**: fix issues in dns benchmark (Ian Perkins) [#14936](https://github.com/nodejs/node/pull/14936)
* [[`978889f8c0`](https://github.com/nodejs/node/commit/978889f8c0)] - **benchmark**: fix dgram/bind-params.js benchmark (Rich Trott) [#14948](https://github.com/nodejs/node/pull/14948)
* [[`7f1ea7c3af`](https://github.com/nodejs/node/commit/7f1ea7c3af)] - **benchmark**: removed unused arguments from callbacks (Abhishek Raj) [#14919](https://github.com/nodejs/node/pull/14919)
* [[`ca3ec90285`](https://github.com/nodejs/node/commit/ca3ec90285)] - **benchmark**: convert var to es6 const (Sebastian Murphy) [#12886](https://github.com/nodejs/node/pull/12886)
* [[`bda5585012`](https://github.com/nodejs/node/commit/bda5585012)] - **buffer**: fix MAX_LENGTH constant export (Anna Henningsen) [#14821](https://github.com/nodejs/node/pull/14821)
* [[`b9e1f60333`](https://github.com/nodejs/node/commit/b9e1f60333)] - **buffer**: increase coverage by removing dead code (Marcelo Gobelli) [#15100](https://github.com/nodejs/node/pull/15100)
* [[`5b8fa29649`](https://github.com/nodejs/node/commit/5b8fa29649)] - **build**: display HTTP2 configure --help options (Daniel Bevenius) [#15198](https://github.com/nodejs/node/pull/15198)
* [[`6de4e10c7a`](https://github.com/nodejs/node/commit/6de4e10c7a)] - **build**: add NetBSD support to opensslconf.h (Roy Marples) [#14313](https://github.com/nodejs/node/pull/14313)
* [[`ebb3c2ce6f`](https://github.com/nodejs/node/commit/ebb3c2ce6f)] - **build**: add npx to zip and 7z packages (Richard Lau) [#15033](https://github.com/nodejs/node/pull/15033)
* [[`b946693f4b`](https://github.com/nodejs/node/commit/b946693f4b)] - **build**: fix indentation in node.gyp (Alexey Orlenko) [#15051](https://github.com/nodejs/node/pull/15051)
* [[`c8be90cabf`](https://github.com/nodejs/node/commit/c8be90cabf)] - **build**: for --enable-static, run only cctest (Daniel Bevenius) [#14892](https://github.com/nodejs/node/pull/14892)
* [[`77dfa73cf2`](https://github.com/nodejs/node/commit/77dfa73cf2)] - **build**: better support for python3 systems (Ben Noordhuis) [#14737](https://github.com/nodejs/node/pull/14737)
* [[`8f3537f66a`](https://github.com/nodejs/node/commit/8f3537f66a)] - **build**: allow proper generation of html docs (Jon Moss) [#14932](https://github.com/nodejs/node/pull/14932)
* [[`838d3fef72`](https://github.com/nodejs/node/commit/838d3fef72)] - **build**: don't add libraries when --enable-static (Daniel Bevenius) [#14912](https://github.com/nodejs/node/pull/14912)
* [[`9d373981f4`](https://github.com/nodejs/node/commit/9d373981f4)] - **build**: remove duplicated code (Ruslan Bekenev) [#13482](https://github.com/nodejs/node/pull/13482)
* [[`e12a9c567c`](https://github.com/nodejs/node/commit/e12a9c567c)] - **build**: re-enable snapshots in v8.x (Myles Borins) [#14875](https://github.com/nodejs/node/pull/14875)
* [[`3a68b0bb98`](https://github.com/nodejs/node/commit/3a68b0bb98)] - **console**: improve console.group() (Rich Trott) [#14999](https://github.com/nodejs/node/pull/14999)
* [[`a46e59d52d`](https://github.com/nodejs/node/commit/a46e59d52d)] - **(SEMVER-MINOR)** **console**: implement minimal `console.group()` (Rich Trott) [#14910](https://github.com/nodejs/node/pull/14910)
* [[`78a71aa123`](https://github.com/nodejs/node/commit/78a71aa123)] - **crypto**: fix error of createCipher in wrap mode (Shigeki Ohtsu) [#15037](https://github.com/nodejs/node/pull/15037)
* [[`41bf40e209`](https://github.com/nodejs/node/commit/41bf40e209)] - **crypto**: warn if counter mode used in createCipher (Shigeki Ohtsu) [#13821](https://github.com/nodejs/node/pull/13821)
* [[`ba5a697bdb`](https://github.com/nodejs/node/commit/ba5a697bdb)] - **deps**: cherry-pick 5005faed5 from V8 upstream (Miguel Martins) [#15177](https://github.com/nodejs/node/pull/15177)
* [[`d18bb3d1dd`](https://github.com/nodejs/node/commit/d18bb3d1dd)] - **deps**: cherry-pick 1aead19 from upstream V8 (Ben Noordhuis) [#15184](https://github.com/nodejs/node/pull/15184)
* [[`acf9650730`](https://github.com/nodejs/node/commit/acf9650730)] - **deps**: upgrade libuv to 1.14.1 (cjihrig) [#14866](https://github.com/nodejs/node/pull/14866)
* [[`296729c41e`](https://github.com/nodejs/node/commit/296729c41e)] - **deps**: cherry-pick 0ef4a0c64b6 from c-ares upstream (Anna Henningsen) [#15023](https://github.com/nodejs/node/pull/15023)
* [[`3f7bdc5ab7`](https://github.com/nodejs/node/commit/3f7bdc5ab7)] - **deps**: cherry-pick e020aae394 from V8 upstream (Ben Noordhuis) [#14913](https://github.com/nodejs/node/pull/14913)
* [[`c46e7e1988`](https://github.com/nodejs/node/commit/c46e7e1988)] - **deps**: fixup nghttp2 version number (Anna Henningsen) [#14955](https://github.com/nodejs/node/pull/14955)
* [[`4eb907f26b`](https://github.com/nodejs/node/commit/4eb907f26b)] - **deps**: update nghttp2 to v1.25.0 (Anna Henningsen) [#14955](https://github.com/nodejs/node/pull/14955)
* [[`9f46bde440`](https://github.com/nodejs/node/commit/9f46bde440)] - **deps**: backport d727680 from V8 upstream (Matt Loring) [#14947](https://github.com/nodejs/node/pull/14947)
* [[`56bb199ef0`](https://github.com/nodejs/node/commit/56bb199ef0)] - **deps**: cherry-pick eb306f463e from nghttp2 upstream (Anna Henningsen) [#14808](https://github.com/nodejs/node/pull/14808)
* [[`55eed604a9`](https://github.com/nodejs/node/commit/55eed604a9)] - **deps**: backport f9c4b7a from upstream V8 (Matt Loring) [#14001](https://github.com/nodejs/node/pull/14001)
* [[`b7f7d67677`](https://github.com/nodejs/node/commit/b7f7d67677)] - **deps**: backport bca8409 from upstream V8 (Matt Loring) [#14001](https://github.com/nodejs/node/pull/14001)
* [[`a67e7f9b35`](https://github.com/nodejs/node/commit/a67e7f9b35)] - **deps**: backport 6e9e2e5 from upstream V8 (Matt Loring) [#14001](https://github.com/nodejs/node/pull/14001)
* [[`6e2f62262d`](https://github.com/nodejs/node/commit/6e2f62262d)] - **deps**: backport 3d8e87a from upstream V8 (Matt Loring) [#14001](https://github.com/nodejs/node/pull/14001)
* [[`6cb718b87a`](https://github.com/nodejs/node/commit/6cb718b87a)] - **deps**: backport 5152d97 from upstream V8 (Matt Loring) [#14001](https://github.com/nodejs/node/pull/14001)
* [[`c6e2b8adf7`](https://github.com/nodejs/node/commit/c6e2b8adf7)] - **deps**: backport c4852ea from upstream V8 (Matt Loring) [#14001](https://github.com/nodejs/node/pull/14001)
* [[`bfb97b71b6`](https://github.com/nodejs/node/commit/bfb97b71b6)] - **deps**: cherry-pick fa4ec9f from V8 upstream (Jaideep Bajwa) [#14608](https://github.com/nodejs/node/pull/14608)
* [[`1a2f749e16`](https://github.com/nodejs/node/commit/1a2f749e16)] - **deps**: fix inspector v8 test (Eugene Ostroukhov) [#14827](https://github.com/nodejs/node/pull/14827)
* [[`13577d4ada`](https://github.com/nodejs/node/commit/13577d4ada)] - **dns**: add `verbatim` option to dns.lookup() (Ben Noordhuis) [#14731](https://github.com/nodejs/node/pull/14731)
* [[`ffed33710c`](https://github.com/nodejs/node/commit/ffed33710c)] - **doc**: add ESM doc to _toc.md and all.md (Vse Mozhet Byt) [#15248](https://github.com/nodejs/node/pull/15248)
* [[`1b51287603`](https://github.com/nodejs/node/commit/1b51287603)] - **doc**: fix Error property markdown level (Sam Roberts) [#15247](https://github.com/nodejs/node/pull/15247)
* [[`af3b173e82`](https://github.com/nodejs/node/commit/af3b173e82)] - **doc**: add missing space in test/README.md (Vse Mozhet Byt) [#15278](https://github.com/nodejs/node/pull/15278)
* [[`c90c68e8a0`](https://github.com/nodejs/node/commit/c90c68e8a0)] - **doc**: document bytes to chars after setEncoding (Jessica Quynh Tran) [#13442](https://github.com/nodejs/node/pull/13442)
* [[`ea86cb59b9`](https://github.com/nodejs/node/commit/ea86cb59b9)] - **doc**: describe what security issues are (Sam Roberts) [#14485](https://github.com/nodejs/node/pull/14485)
* [[`ddbcc9e59d`](https://github.com/nodejs/node/commit/ddbcc9e59d)] - **doc**: add options argument to crypto docs (Adina Shanholtz) [#14846](https://github.com/nodejs/node/pull/14846)
* [[`da5e6d33d5`](https://github.com/nodejs/node/commit/da5e6d33d5)] - **doc**: instructions for generating coverage reports (Simon Brewster) [#15190](https://github.com/nodejs/node/pull/15190)
* [[`286111a2b0`](https://github.com/nodejs/node/commit/286111a2b0)] - **doc**: clarify async/asynchronous in deprecations.md (Rich Trott) [#15172](https://github.com/nodejs/node/pull/15172)
* [[`9542844feb`](https://github.com/nodejs/node/commit/9542844feb)] - **doc**: `readFileSync` instead of `fs.readFileSync` (Piotr Mionskowski) [#15137](https://github.com/nodejs/node/pull/15137)
* [[`959b270fe1`](https://github.com/nodejs/node/commit/959b270fe1)] - **doc**: /s/SHASUM256/SHASUMS256 (Jon Moss) [#15101](https://github.com/nodejs/node/pull/15101)
* [[`3697cd86c4`](https://github.com/nodejs/node/commit/3697cd86c4)] - **doc**: fix comment about http2.createSecureServer (creeperyang) [#15085](https://github.com/nodejs/node/pull/15085)
* [[`76780445b3`](https://github.com/nodejs/node/commit/76780445b3)] - **doc**: remove braces which shouldn't be there (Jan Schär) [#15094](https://github.com/nodejs/node/pull/15094)
* [[`2610ae326f`](https://github.com/nodejs/node/commit/2610ae326f)] - **doc**: clarify http.get data consumption requirement (AJ Jordan) [#15049](https://github.com/nodejs/node/pull/15049)
* [[`e7838d7077`](https://github.com/nodejs/node/commit/e7838d7077)] - **doc**: add 8.4.0 link to CHANGELOG.md (Ruslan Iusupov) [#15064](https://github.com/nodejs/node/pull/15064)
* [[`feeff48d5c`](https://github.com/nodejs/node/commit/feeff48d5c)] - **doc**: add links to alternative versions of doc (Chris Young) [#10958](https://github.com/nodejs/node/pull/10958)
* [[`a5242851b9`](https://github.com/nodejs/node/commit/a5242851b9)] - **doc**: update configure to require g++ 4.9.4 (Dave Olszewski) [#14204](https://github.com/nodejs/node/pull/14204)
* [[`87ff86b2d8`](https://github.com/nodejs/node/commit/87ff86b2d8)] - **doc**: building - note on Windows SDK 15063 (Refael Ackermann) [#14394](https://github.com/nodejs/node/pull/14394)
* [[`449549bc4f`](https://github.com/nodejs/node/commit/449549bc4f)] - **doc**: threadpool size, and APIs using the pool (Sam Roberts) [#14995](https://github.com/nodejs/node/pull/14995)
* [[`6bb8133638`](https://github.com/nodejs/node/commit/6bb8133638)] - **doc**: sort bottom-of-file dns markdown links (Sam Roberts) [#14992](https://github.com/nodejs/node/pull/14992)
* [[`a06d1295c5`](https://github.com/nodejs/node/commit/a06d1295c5)] - **doc**: crypto.randomBytes does not block when async (Sam Roberts) [#14993](https://github.com/nodejs/node/pull/14993)
* [[`83ba2aa46b`](https://github.com/nodejs/node/commit/83ba2aa46b)] - **doc**: environmental-\>environment & NodeJS-\>Node.js (Rod Vagg) [#14974](https://github.com/nodejs/node/pull/14974)
* [[`f1bc168ad5`](https://github.com/nodejs/node/commit/f1bc168ad5)] - **doc**: fix typo in Buffer.from(string, \[encoding\]) (Michał Wadas) [#15013](https://github.com/nodejs/node/pull/15013)
* [[`9b9e7b4044`](https://github.com/nodejs/node/commit/9b9e7b4044)] - **doc**: add note for Windows build path (Kyle Lamse) [#14354](https://github.com/nodejs/node/pull/14354)
* [[`57c7eae1df`](https://github.com/nodejs/node/commit/57c7eae1df)] - **doc**: rephrase text of child_process.execSync() (hafiz) [#14953](https://github.com/nodejs/node/pull/14953)
* [[`188713ca46`](https://github.com/nodejs/node/commit/188713ca46)] - **doc**: beautify net.md formats (sevenryze) [#14987](https://github.com/nodejs/node/pull/14987)
* [[`a8648e287c`](https://github.com/nodejs/node/commit/a8648e287c)] - **doc**: link to correct "OS Constants" heading in docs (James Kyle) [#14969](https://github.com/nodejs/node/pull/14969)
* [[`e187c98186`](https://github.com/nodejs/node/commit/e187c98186)] - **doc**: remove misterdjules from the CTC members list (Julien Gilli) [#1498](https://github.com/nodejs/node/pull/1498)
* [[`78b2bc77f2`](https://github.com/nodejs/node/commit/78b2bc77f2)] - **doc**: update http2.md example code (RefinedSoftwareLLC) [#14979](https://github.com/nodejs/node/pull/14979)
* [[`6179c2764a`](https://github.com/nodejs/node/commit/6179c2764a)] - **doc**: fix doc for napi_get_value_string_utf8 (Daniel Taveras) [#14529](https://github.com/nodejs/node/pull/14529)
* [[`daae6bc652`](https://github.com/nodejs/node/commit/daae6bc652)] - **doc**: fixed link definitions in http2.md footer (sharababy) [#14946](https://github.com/nodejs/node/pull/14946)
* [[`6c93d01fba`](https://github.com/nodejs/node/commit/6c93d01fba)] - **doc**: remove `you` and fixup note in stream.md (James M Snell) [#14938](https://github.com/nodejs/node/pull/14938)
* [[`96d95d4fed`](https://github.com/nodejs/node/commit/96d95d4fed)] - **doc**: minor fixes to http/2 docs (Anand Suresh) [#14877](https://github.com/nodejs/node/pull/14877)
* [[`bfa3cbe158`](https://github.com/nodejs/node/commit/bfa3cbe158)] - **doc**: remove redundant only from doc/api/stream.md (George Sapkin) [#14858](https://github.com/nodejs/node/pull/14858)
* [[`c5380c83c6`](https://github.com/nodejs/node/commit/c5380c83c6)] - **doc**: add missing word (Jon Moss) [#14924](https://github.com/nodejs/node/pull/14924)
* [[`abe014834e`](https://github.com/nodejs/node/commit/abe014834e)] - **doc**: fix http api document (陈刚) [#14625](https://github.com/nodejs/node/pull/14625)
* [[`050a2249c1`](https://github.com/nodejs/node/commit/050a2249c1)] - **doc**: explain what to do if git push is rejected (Rich Trott) [#14848](https://github.com/nodejs/node/pull/14848)
* [[`3d621393bd`](https://github.com/nodejs/node/commit/3d621393bd)] - **doc**: add BridgeAR to collaborators (Ruben Bridgewater) [#14862](https://github.com/nodejs/node/pull/14862)
* [[`c8f0e5ab82`](https://github.com/nodejs/node/commit/c8f0e5ab82)] - **doc**: fix typo in cli.md (hsmtkk) [#14855](https://github.com/nodejs/node/pull/14855)
* [[`0dc9d284a4`](https://github.com/nodejs/node/commit/0dc9d284a4)] - **doc**: added napi_get_value_string_latin1 (Kyle Farnung) [#14678](https://github.com/nodejs/node/pull/14678)
* [[`72cc2caf78`](https://github.com/nodejs/node/commit/72cc2caf78)] - **doc**: fix word wrapping for api stability boxes (Saad Quadri) [#14809](https://github.com/nodejs/node/pull/14809)
* [[`205d5f674a`](https://github.com/nodejs/node/commit/205d5f674a)] - **doc,fs**: rename defaultEncoding option to encoding (Aleh Zasypkin) [#14867](https://github.com/nodejs/node/pull/14867)
* [[`aaf55db95b`](https://github.com/nodejs/node/commit/aaf55db95b)] - **doc,lib,src,test**: strip executable bits off files (Anna Henningsen) [#15132](https://github.com/nodejs/node/pull/15132)
* [[`7f62378e76`](https://github.com/nodejs/node/commit/7f62378e76)] - **doc,stream**: remove wrong remark on readable.read (Jan Schär) [#15014](https://github.com/nodejs/node/pull/15014)
* [[`ea2b5760d5`](https://github.com/nodejs/node/commit/ea2b5760d5)] - **errors**: remove duplicated ERR_HTTP_INVALID_STATUS_CODE error (Jon Moss) [#15003](https://github.com/nodejs/node/pull/15003)
* [[`71f90c6f80`](https://github.com/nodejs/node/commit/71f90c6f80)] - **(SEMVER-MINOR)** **fs**: add fs.copyFile{Sync} (cjihrig) [#15034](https://github.com/nodejs/node/pull/15034)
* [[`3d9ad82729`](https://github.com/nodejs/node/commit/3d9ad82729)] - **gyp**: fix ninja build failure (GYP patch) (Daniel Bevenius) [#12484](https://github.com/nodejs/node/pull/12484)
* [[`12191f6ed8`](https://github.com/nodejs/node/commit/12191f6ed8)] - **gyp**: enable cctest to use objects (gyp part) (Daniel Bevenius) [#12450](https://github.com/nodejs/node/pull/12450)
* [[`538894978b`](https://github.com/nodejs/node/commit/538894978b)] - **gyp**: add compile_commands.json gyp generator (Ben Noordhuis) [#12450](https://github.com/nodejs/node/pull/12450)
* [[`7eb3679eea`](https://github.com/nodejs/node/commit/7eb3679eea)] - **gyp**: inherit parent for `*.host` (Johan Bergström) [#6173](https://github.com/nodejs/node/pull/6173)
* [[`5fb252a5a2`](https://github.com/nodejs/node/commit/5fb252a5a2)] - **gyp**: fix gyp to work on MacOSX without XCode (Shigeki Ohtsu) [iojs/io.js#1325](https://github.com/iojs/io.js/pull/1325)
* [[`0343eceda4`](https://github.com/nodejs/node/commit/0343eceda4)] - **http2**: fix refs to status 205, add tests (Anatoli Papirovski) [#15153](https://github.com/nodejs/node/pull/15153)
* [[`d8ff550528`](https://github.com/nodejs/node/commit/d8ff550528)] - **http2**: store headersSent after stream destroyed (Anatoli Papirovski) [#15232](https://github.com/nodejs/node/pull/15232)
* [[`4882f079f1`](https://github.com/nodejs/node/commit/4882f079f1)] - **http2**: set decodeStrings to false, test (Anatoli Papirovski) [#15140](https://github.com/nodejs/node/pull/15140)
* [[`93a4cf60ff`](https://github.com/nodejs/node/commit/93a4cf60ff)] - **http2**: use session not socket timeout, tests (Anatoli Papirovski) [#15188](https://github.com/nodejs/node/pull/15188)
* [[`764213cc7b`](https://github.com/nodejs/node/commit/764213cc7b)] - **http2**: add compat trailers, adjust multi-headers (Anatoli Papirovski) [#15193](https://github.com/nodejs/node/pull/15193)
* [[`cc82f541e5`](https://github.com/nodejs/node/commit/cc82f541e5)] - **http2**: fix closedCode NaN, increase test coverage (Anatoli Papirovski) [#15154](https://github.com/nodejs/node/pull/15154)
* [[`afa72dfdf3`](https://github.com/nodejs/node/commit/afa72dfdf3)] - **http2**: guard against destroyed session, timeouts (James M Snell) [#15106](https://github.com/nodejs/node/pull/15106)
* [[`f6c51888db`](https://github.com/nodejs/node/commit/f6c51888db)] - **http2**: correct emit error in onConnect, full tests (Anatoli Papirovski) [#15080](https://github.com/nodejs/node/pull/15080)
* [[`fd51cb8ca3`](https://github.com/nodejs/node/commit/fd51cb8ca3)] - **http2**: adjust error types, test coverage (Anatoli Papirovski) [#15109](https://github.com/nodejs/node/pull/15109)
* [[`f612a6dd5c`](https://github.com/nodejs/node/commit/f612a6dd5c)] - **http2**: handle 100-continue flow & writeContinue (Anatoli Papirovski) [#15039](https://github.com/nodejs/node/pull/15039)
* [[`989dfaf930`](https://github.com/nodejs/node/commit/989dfaf930)] - **http2**: refactor error handling (Matteo Collina) [#14991](https://github.com/nodejs/node/pull/14991)
* [[`d231ef645e`](https://github.com/nodejs/node/commit/d231ef645e)] - **http2**: ignore invalid headers explicitly (Anna Henningsen) [#14955](https://github.com/nodejs/node/pull/14955)
* [[`1b57c375aa`](https://github.com/nodejs/node/commit/1b57c375aa)] - **http2**: minor refactor of passing headers to JS (Anna Henningsen) [#14808](https://github.com/nodejs/node/pull/14808)
* [[`80fe40aabf`](https://github.com/nodejs/node/commit/80fe40aabf)] - **http2**: handful of http/2 src cleanups (James M Snell) [#14825](https://github.com/nodejs/node/pull/14825)
* [[`9589641c5c`](https://github.com/nodejs/node/commit/9589641c5c)] - **http2**: Expose Http2ServerRequest/Response (Pini Houri) [#14690](https://github.com/nodejs/node/pull/14690)
* [[`8c61b72f90`](https://github.com/nodejs/node/commit/8c61b72f90)] - **(SEMVER-MINOR)** **inspector**: enable async stack traces (Miroslav Bajtoš) [#13870](https://github.com/nodejs/node/pull/13870)
* [[`e2ae08b48d`](https://github.com/nodejs/node/commit/e2ae08b48d)] - **inspector**: rewrite inspector test helper (Eugene Ostroukhov) [#14797](https://github.com/nodejs/node/pull/14797)
* [[`105acf4af7`](https://github.com/nodejs/node/commit/105acf4af7)] - **inspector**: log exceptions in message handlers (Eugene Ostroukhov) [#14980](https://github.com/nodejs/node/pull/14980)
* [[`d5a376ab7a`](https://github.com/nodejs/node/commit/d5a376ab7a)] - **lib**: remove circular reference (Ruben Bridgewater) [#14885](https://github.com/nodejs/node/pull/14885)
* [[`605d625e62`](https://github.com/nodejs/node/commit/605d625e62)] - **lib**: simplify the readonly properties of icu (Jackson Tian) [#13221](https://github.com/nodejs/node/pull/13221)
* [[`ea0a882041`](https://github.com/nodejs/node/commit/ea0a882041)] - **lib**: remove the invalid command line options (Jackson Tian) [#13764](https://github.com/nodejs/node/pull/13764)
* [[`9129057e03`](https://github.com/nodejs/node/commit/9129057e03)] - **lib**: clean up usage of threw (Jackson Tian) [#10534](https://github.com/nodejs/node/pull/10534)
* [[`f34e0f97e7`](https://github.com/nodejs/node/commit/f34e0f97e7)] - **lib**: instantiate console methods eagerly (Ben Noordhuis) [#14791](https://github.com/nodejs/node/pull/14791)
* [[`01846a06c2`](https://github.com/nodejs/node/commit/01846a06c2)] - **meta**: merge TSC and CTC back into a single body (James M Snell) [#14973](https://github.com/nodejs/node/pull/14973)
* [[`859abe5169`](https://github.com/nodejs/node/commit/859abe5169)] - **meta**: considerations for new core modules (James M Snell) [#15022](https://github.com/nodejs/node/pull/15022)
* [[`cc72118e71`](https://github.com/nodejs/node/commit/cc72118e71)] - **meta**: improve definition of a collaborator (James M Snell) [#14981](https://github.com/nodejs/node/pull/14981)
* [[`865a3c3daf`](https://github.com/nodejs/node/commit/865a3c3daf)] - **(SEMVER-MINOR)** **module**: Allow runMain to be ESM (Bradley Farias) [#14369](https://github.com/nodejs/node/pull/14369)
* [[`4bf0d4e133`](https://github.com/nodejs/node/commit/4bf0d4e133)] - **n-api**: implement napi_run_script (Gabriel Schulhof) [#15216](https://github.com/nodejs/node/pull/15216)
* [[`3a18df0750`](https://github.com/nodejs/node/commit/3a18df0750)] - **n-api**: adds function to adjust external memory (Chris Young) [#14310](https://github.com/nodejs/node/pull/14310)
* [[`503370e2d3`](https://github.com/nodejs/node/commit/503370e2d3)] - **(SEMVER-MINOR)** **n-api**: implement promise (Gabriel Schulhof) [#14365](https://github.com/nodejs/node/pull/14365)
* [[`a6344d5a83`](https://github.com/nodejs/node/commit/a6344d5a83)] - **(SEMVER-MINOR)** **n-api**: add ability to remove a wrapping (Gabriel Schulhof) [#14658](https://github.com/nodejs/node/pull/14658)
* [[`67fde146e0`](https://github.com/nodejs/node/commit/67fde146e0)] - **net**: check EADDRINUSE after binding localPort (Joyee Cheung) [#15097](https://github.com/nodejs/node/pull/15097)
* [[`b4e8850576`](https://github.com/nodejs/node/commit/b4e8850576)] - **net**: move debug statement (Brian White) [#12616](https://github.com/nodejs/node/pull/12616)
* [[`136eea4bcb`](https://github.com/nodejs/node/commit/136eea4bcb)] - **(SEMVER-MINOR)** **os**: add CIDR support (Mudit Ameta) [#14307](https://github.com/nodejs/node/pull/14307)
* [[`29f9101a0f`](https://github.com/nodejs/node/commit/29f9101a0f)] - **path**: fix normalize on directories with two dots (Michaël Zasso) [#14107](https://github.com/nodejs/node/pull/14107)
* [[`e3f5c58423`](https://github.com/nodejs/node/commit/e3f5c58423)] - **perf_hooks**: fix presumed typo in node_perf.cc (Anna Henningsen) [#15019](https://github.com/nodejs/node/pull/15019)
* [[`69e3bc64cc`](https://github.com/nodejs/node/commit/69e3bc64cc)] - **perf_hooks**: mark as experimental (James M Snell) [#14997](https://github.com/nodejs/node/pull/14997)
* [[`f75faddb1f`](https://github.com/nodejs/node/commit/f75faddb1f)] - **(SEMVER-MINOR)** **perf_hooks**: implementation of the perf timing API (James M Snell) [#14680](https://github.com/nodejs/node/pull/14680)
* [[`4d2aa16d33`](https://github.com/nodejs/node/commit/4d2aa16d33)] - **process**: keep process prototype in inheritance chain (Jimmy Thomson) [#14715](https://github.com/nodejs/node/pull/14715)
* [[`ae85d5f024`](https://github.com/nodejs/node/commit/ae85d5f024)] - **promises**: more robust stringification (Timothy Gu) [#13784](https://github.com/nodejs/node/pull/13784)
* [[`eee2aa693b`](https://github.com/nodejs/node/commit/eee2aa693b)] - **repl**: force editorMode in .load (Lance Ball) [#14861](https://github.com/nodejs/node/pull/14861)
* [[`f81812b1ff`](https://github.com/nodejs/node/commit/f81812b1ff)] - **src**: turn key length exception into CHECK (Ben Noordhuis) [#15183](https://github.com/nodejs/node/pull/15183)
* [[`f113d7332f`](https://github.com/nodejs/node/commit/f113d7332f)] - **src**: fix compiler warnings in node_perf.cc (Daniel Bevenius) [#15112](https://github.com/nodejs/node/pull/15112)
* [[`a83d427091`](https://github.com/nodejs/node/commit/a83d427091)] - **src**: remove unused persistent properties from env (Anna Henningsen) [#15096](https://github.com/nodejs/node/pull/15096)
* [[`391855c252`](https://github.com/nodejs/node/commit/391855c252)] - **src**: fix build on certain platforms (Anna Henningsen) [#14996](https://github.com/nodejs/node/pull/14996)
* [[`8cee5d66bd`](https://github.com/nodejs/node/commit/8cee5d66bd)] - **src**: reduce code duplication (James M Snell) [#14937](https://github.com/nodejs/node/pull/14937)
* [[`5a05dfe0a7`](https://github.com/nodejs/node/commit/5a05dfe0a7)] - **src**: fixup strings, reduce duplication (James M Snell) [#14937](https://github.com/nodejs/node/pull/14937)
* [[`1c3cb49f00`](https://github.com/nodejs/node/commit/1c3cb49f00)] - **src**: miscellaneous cleanups for node_config (James M Snell) [#14868](https://github.com/nodejs/node/pull/14868)
* [[`7213be9f59`](https://github.com/nodejs/node/commit/7213be9f59)] - **src**: fix DEBUG_HTTP2 type arguments (Daniel Bevenius) [#15197](https://github.com/nodejs/node/pull/15197)
* [[`ffe572addd`](https://github.com/nodejs/node/commit/ffe572addd)] - **src**: replace assert() with CHECK() (Ben Noordhuis) [#14663](https://github.com/nodejs/node/pull/14663)
* [[`abc5cdc923`](https://github.com/nodejs/node/commit/abc5cdc923)] - **src**: remove unnecessary helper function (Brian White) [#14959](https://github.com/nodejs/node/pull/14959)
* [[`992d1dd956`](https://github.com/nodejs/node/commit/992d1dd956)] - **src**: detect nul bytes in InternalModuleReadFile() (Ben Noordhuis) [#14854](https://github.com/nodejs/node/pull/14854)
* [[`4570fa16c7`](https://github.com/nodejs/node/commit/4570fa16c7)] - **src**: remove extra copy from Copy() in node_url.cc (Anna Henningsen) [#14907](https://github.com/nodejs/node/pull/14907)
* [[`081c3e107d`](https://github.com/nodejs/node/commit/081c3e107d)] - **src**: minor cleanup for node_revert (James M Snell) [#14864](https://github.com/nodejs/node/pull/14864)
* [[`dcd7817fbc`](https://github.com/nodejs/node/commit/dcd7817fbc)] - **src**: use `unordered_set` instead of custom rb tree (Anna Henningsen) [#14826](https://github.com/nodejs/node/pull/14826)
* [[`fadcbab617`](https://github.com/nodejs/node/commit/fadcbab617)] - **src**: Node implementation of v8::Platform (Matt Loring) [#14001](https://github.com/nodejs/node/pull/14001)
* [[`c861462faa`](https://github.com/nodejs/node/commit/c861462faa)] - **stream**: fix Writable instanceof for subclasses (Anna Henningsen) [#14945](https://github.com/nodejs/node/pull/14945)
* [[`2adabe6777`](https://github.com/nodejs/node/commit/2adabe6777)] - **test**: fix single test runner regression (Timothy Gu) [#15329](https://github.com/nodejs/node/pull/15329)
* [[`e3d0ff901b`](https://github.com/nodejs/node/commit/e3d0ff901b)] - **test**: split test-cli-node-options (Refael Ackermann) [#14195](https://github.com/nodejs/node/pull/14195)
* [[`e87cb32db2`](https://github.com/nodejs/node/commit/e87cb32db2)] - **test**: remove envPlus, use Object.assign everywhere (Gibson Fahnestock) [#14845](https://github.com/nodejs/node/pull/14845)
* [[`dea959e841`](https://github.com/nodejs/node/commit/dea959e841)] - **test**: fix flaky test-readline-interface (Rich Trott) [#15066](https://github.com/nodejs/node/pull/15066)
* [[`ae91b1efc0`](https://github.com/nodejs/node/commit/ae91b1efc0)] - **test**: continue normalizing fixtures use (Miguel Angel Asencio Hurtado) [#14716](https://github.com/nodejs/node/pull/14716)
* [[`77bc72ad54`](https://github.com/nodejs/node/commit/77bc72ad54)] - **(SEMVER-MINOR)** **test**: fix inspector helper port sniffing (Timothy Gu) [#13870](https://github.com/nodejs/node/pull/13870)
* [[`7facfaab66`](https://github.com/nodejs/node/commit/7facfaab66)] - **test**: preserve env in test cases (Beth Griggs) [#14822](https://github.com/nodejs/node/pull/14822)
* [[`2310cfcea1`](https://github.com/nodejs/node/commit/2310cfcea1)] - **test**: exclude write-coverage from coverage report (Benjamin Coe) [#15194](https://github.com/nodejs/node/pull/15194)
* [[`6fa05e671c`](https://github.com/nodejs/node/commit/6fa05e671c)] - **test**: use no-save and no-package-lock flags (Simon Brewster) [#15196](https://github.com/nodejs/node/pull/15196)
* [[`ac71d99253`](https://github.com/nodejs/node/commit/ac71d99253)] - **test**: add http2 compat setTimeout tests (Anatoli Papirovski) [#15156](https://github.com/nodejs/node/pull/15156)
* [[`7106734773`](https://github.com/nodejs/node/commit/7106734773)] - **test**: add test-benchmark-buffer (Rich Trott) [#15175](https://github.com/nodejs/node/pull/15175)
* [[`0b9fde4d4a`](https://github.com/nodejs/node/commit/0b9fde4d4a)] - **test**: refactor test-fs-readfile-unlink (Rich Trott) [#15173](https://github.com/nodejs/node/pull/15173)
* [[`9f79bd8fba`](https://github.com/nodejs/node/commit/9f79bd8fba)] - **test**: http2 test coverage for NghttpError (James M Snell) [#15105](https://github.com/nodejs/node/pull/15105)
* [[`c0dba0f3f4`](https://github.com/nodejs/node/commit/c0dba0f3f4)] - **test**: http2 test coverage for assertValidPseudoHeader (James M Snell) [#15105](https://github.com/nodejs/node/pull/15105)
* [[`837c29c73b`](https://github.com/nodejs/node/commit/837c29c73b)] - **test**: http2 test coverage for updateOptionsBuffer (James M Snell) [#15105](https://github.com/nodejs/node/pull/15105)
* [[`e3e9e5039d`](https://github.com/nodejs/node/commit/e3e9e5039d)] - **test**: increase Http2ServerResponse test coverage (Anatoli Papirovski) [#15074](https://github.com/nodejs/node/pull/15074)
* [[`72aae0417c`](https://github.com/nodejs/node/commit/72aae0417c)] - **test**: split path tests into multiple files (Michaël Zasso) [#15093](https://github.com/nodejs/node/pull/15093)
* [[`d176a18547`](https://github.com/nodejs/node/commit/d176a18547)] - **test**: add a test for Expect & checkExpectation (Anatoli Papirovski) [#15040](https://github.com/nodejs/node/pull/15040)
* [[`cfbf5057d6`](https://github.com/nodejs/node/commit/cfbf5057d6)] - **test**: add http2 test for method CONNECT (Anatoli Papirovski) [#15052](https://github.com/nodejs/node/pull/15052)
* [[`5b13add028`](https://github.com/nodejs/node/commit/5b13add028)] - **test**: remove unused param in test-graph.pipe (Simon Brewster) [#15007](https://github.com/nodejs/node/pull/15007)
* [[`5cb6500de9`](https://github.com/nodejs/node/commit/5cb6500de9)] - **test**: increase coverage for http2 response headers (Anatoli Papirovski) [#15035](https://github.com/nodejs/node/pull/15035)
* [[`7050608593`](https://github.com/nodejs/node/commit/7050608593)] - **test**: fix hijackStdout behavior in console (XadillaX) [#14647](https://github.com/nodejs/node/pull/14647)
* [[`458b8ab5df`](https://github.com/nodejs/node/commit/458b8ab5df)] - **test**: add regression test for 14814 (Anna Henningsen) [#15023](https://github.com/nodejs/node/pull/15023)
* [[`f89ef77144`](https://github.com/nodejs/node/commit/f89ef77144)] - **test**: run abort tests (Rich Trott) [#14013](https://github.com/nodejs/node/pull/14013)
* [[`a91a3fe6c4`](https://github.com/nodejs/node/commit/a91a3fe6c4)] - **test**: improve test-abort-backtrace (Rich Trott) [#14013](https://github.com/nodejs/node/pull/14013)
* [[`b85a73407b`](https://github.com/nodejs/node/commit/b85a73407b)] - **test**: improve test-abort-uncaught-exception (Rich Trott) [#14013](https://github.com/nodejs/node/pull/14013)
* [[`f694ea6f2b`](https://github.com/nodejs/node/commit/f694ea6f2b)] - **test**: pipe some error output if npm fails (Jeremiah Senkpiel) [#12490](https://github.com/nodejs/node/pull/12490)
* [[`f1284d32a5`](https://github.com/nodejs/node/commit/f1284d32a5)] - **test**: simplify test-tls-client-default-ciphers (Jon Moss) [#14928](https://github.com/nodejs/node/pull/14928)
* [[`d4c2eba376`](https://github.com/nodejs/node/commit/d4c2eba376)] - **test**: remove unused function args (Mohd Maqbool Alam) [#14971](https://github.com/nodejs/node/pull/14971)
* [[`9c7f27b91b`](https://github.com/nodejs/node/commit/9c7f27b91b)] - **test**: extend async addon test (Anna Henningsen) [#14922](https://github.com/nodejs/node/pull/14922)
* [[`8c927dd71f`](https://github.com/nodejs/node/commit/8c927dd71f)] - **test**: fix async-hooks tests (Bartosz Sosnowski) [#14865](https://github.com/nodejs/node/pull/14865)
* [[`1849c519ca`](https://github.com/nodejs/node/commit/1849c519ca)] - **test**: add test-benchmark-process (Rich Trott) [#14951](https://github.com/nodejs/node/pull/14951)
* [[`b480b20e02`](https://github.com/nodejs/node/commit/b480b20e02)] - **test**: add test-benchmark-path (Rich Trott) [#14951](https://github.com/nodejs/node/pull/14951)
* [[`2e3e136519`](https://github.com/nodejs/node/commit/2e3e136519)] - **test**: add test-benchmark-os (Rich Trott) [#14951](https://github.com/nodejs/node/pull/14951)
* [[`7e541d6a97`](https://github.com/nodejs/node/commit/7e541d6a97)] - **test**: add test-benchmark-events (Rich Trott) [#14951](https://github.com/nodejs/node/pull/14951)
* [[`981ef464e2`](https://github.com/nodejs/node/commit/981ef464e2)] - **test**: add test-benchmark-domain (Rich Trott) [#14951](https://github.com/nodejs/node/pull/14951)
* [[`34d1a779b1`](https://github.com/nodejs/node/commit/34d1a779b1)] - **test**: add known issue for vm module (Franziska Hinkelmann) [#14661](https://github.com/nodejs/node/pull/14661)
* [[`ae27cb8ea3`](https://github.com/nodejs/node/commit/ae27cb8ea3)] - **test**: do not modify fixtures in test-fs-chmod (Rich Trott) [#14926](https://github.com/nodejs/node/pull/14926)
* [[`eb46609622`](https://github.com/nodejs/node/commit/eb46609622)] - **test**: improve assertion fail messages (Refael Ackermann) [#14949](https://github.com/nodejs/node/pull/14949)
* [[`36b8b46443`](https://github.com/nodejs/node/commit/36b8b46443)] - **test**: remove unused parameters (Daniil Shakir) [#14968](https://github.com/nodejs/node/pull/14968)
* [[`6421a9cb9a`](https://github.com/nodejs/node/commit/6421a9cb9a)] - **test**: remove unused arguments from function (Ankit Parashar) [#14931](https://github.com/nodejs/node/pull/14931)
* [[`e244f8433e`](https://github.com/nodejs/node/commit/e244f8433e)] - **test**: update windows module load error message (cjihrig) [#14950](https://github.com/nodejs/node/pull/14950)
* [[`8f61bf2cda`](https://github.com/nodejs/node/commit/8f61bf2cda)] - **test**: increase coverage for http2.connect (Michael Albert) [#14832](https://github.com/nodejs/node/pull/14832)
* [[`c0312dc781`](https://github.com/nodejs/node/commit/c0312dc781)] - **test**: make timers-blocking-callback more reliable (Rich Trott) [#14831](https://github.com/nodejs/node/pull/14831)
* [[`762155578a`](https://github.com/nodejs/node/commit/762155578a)] - **test**: remove erroneous assert message from test (Beth Griggs) [#14918](https://github.com/nodejs/node/pull/14918)
* [[`1217b1a556`](https://github.com/nodejs/node/commit/1217b1a556)] - **test**: add test for cluster benchmarks (Rich Trott) [#14812](https://github.com/nodejs/node/pull/14812)
* [[`03fd38c1bb`](https://github.com/nodejs/node/commit/03fd38c1bb)] - **test**: Mark test-stop-profile-after-done flaky (Eugene Ostroukhov)
* [[`4f49ae52f8`](https://github.com/nodejs/node/commit/4f49ae52f8)] - **test**: check util.inspect circular Set and Map refs (Ruben Bridgewater) [#14790](https://github.com/nodejs/node/pull/14790)
* [[`4dd095c982`](https://github.com/nodejs/node/commit/4dd095c982)] - **test**: refactor async-hooks/test-httparser tests (Runite618) [#14818](https://github.com/nodejs/node/pull/14818)
* [[`27ec693a53`](https://github.com/nodejs/node/commit/27ec693a53)] - **test**: add missing console.error to exec-maxBuffer (Beth Griggs) [#14796](https://github.com/nodejs/node/pull/14796)
* [[`7f02c36c4f`](https://github.com/nodejs/node/commit/7f02c36c4f)] - **test**: fix test-cluster-send-handle-large-payload (Rich Trott) [#14780](https://github.com/nodejs/node/pull/14780)
* [[`4205648216`](https://github.com/nodejs/node/commit/4205648216)] - **test**: invoke callback with common.mustCall() (Griffith Tchenpan) [#8597](https://github.com/nodejs/node/pull/8597)
* [[`a3feb54c7f`](https://github.com/nodejs/node/commit/a3feb54c7f)] - **test**: make test-tls-alert-handling more strict (Rich Trott) [#14650](https://github.com/nodejs/node/pull/14650)
* [[`d4f2a52953`](https://github.com/nodejs/node/commit/d4f2a52953)] - **test**: check crypto before requiring tls module (Daniel Bevenius) [#14708](https://github.com/nodejs/node/pull/14708)
* [[`868b441f3e`](https://github.com/nodejs/node/commit/868b441f3e)] - **test**: begin normalizing fixtures use (James M Snell) [#14332](https://github.com/nodejs/node/pull/14332)
* [[`c76ec7130e`](https://github.com/nodejs/node/commit/c76ec7130e)] - **test**: improve multiple zlib tests (James M Snell) [#14455](https://github.com/nodejs/node/pull/14455)
* [[`8fb0895176`](https://github.com/nodejs/node/commit/8fb0895176)] - **test**: improve multiple vm tests (James M Snell) [#14458](https://github.com/nodejs/node/pull/14458)
* [[`4d6da3f770`](https://github.com/nodejs/node/commit/4d6da3f770)] - **test, win**: fix IPv6 detection on Windows (Bartosz Sosnowski) [#14865](https://github.com/nodejs/node/pull/14865)
* [[`02260eab98`](https://github.com/nodejs/node/commit/02260eab98)] - **test,doc**: make module name match gyp target name (Gabriel Schulhof) [#15209](https://github.com/nodejs/node/pull/15209)
* [[`dae86e4cf5`](https://github.com/nodejs/node/commit/dae86e4cf5)] - **timers**: fix outdated comment (Tim Costa) [#14314](https://github.com/nodejs/node/pull/14314)
* [[`d6ad9d72f7`](https://github.com/nodejs/node/commit/d6ad9d72f7)] - **(SEMVER-MINOR)** **tls**: multiple PFX in createSecureContext (Yury Popov) [#14793](https://github.com/nodejs/node/pull/14793)
* [[`97908ea4d0`](https://github.com/nodejs/node/commit/97908ea4d0)] - **tools**: bump vswhere helper to 2.0.0 (Refael Ackermann) [#14557](https://github.com/nodejs/node/pull/14557)
* [[`87e44d8651`](https://github.com/nodejs/node/commit/87e44d8651)] - **tools**: add eslint rule for inspector checking (Daniel Bevenius) [#13813](https://github.com/nodejs/node/pull/13813)
* [[`1d97ff4800`](https://github.com/nodejs/node/commit/1d97ff4800)] - **tools**: add eslint rule for hasCrypto checking (Daniel Bevenius) [#13813](https://github.com/nodejs/node/pull/13813)
* [[`bc250a1e38`](https://github.com/nodejs/node/commit/bc250a1e38)] - **tools**: fix linter error in html.js (Michaël Zasso) [#15063](https://github.com/nodejs/node/pull/15063)
* [[`5ee4e86efc`](https://github.com/nodejs/node/commit/5ee4e86efc)] - **tools**: add custom private key option (Ruslan Bekenev) [#14401](https://github.com/nodejs/node/pull/14401)
* [[`8f34b834b7`](https://github.com/nodejs/node/commit/8f34b834b7)] - **tools**: update GYP to 324dd166 (Refael Ackermann) [#14718](https://github.com/nodejs/node/pull/14718)
* [[`e4ea45412e`](https://github.com/nodejs/node/commit/e4ea45412e)] - **tools**: remove stray package-lock.json file (Rich Trott) [#14873](https://github.com/nodejs/node/pull/14873)
* [[`37c43ede43`](https://github.com/nodejs/node/commit/37c43ede43)] - **tools**: fix update-eslint.sh (Myles Borins) [#14850](https://github.com/nodejs/node/pull/14850)
* [[`b0f4539ce5`](https://github.com/nodejs/node/commit/b0f4539ce5)] - **tools**: delete an unused argument (phisixersai) [#14251](https://github.com/nodejs/node/pull/14251)
* [[`9da6c1056c`](https://github.com/nodejs/node/commit/9da6c1056c)] - **tools**: checkout for unassigned DEP00XX codes (James M Snell) [#14702](https://github.com/nodejs/node/pull/14702)
* [[`bd40cc6ef8`](https://github.com/nodejs/node/commit/bd40cc6ef8)] - **tracing**: Update to use new Platform tracing apis (Matt Loring) [#14001](https://github.com/nodejs/node/pull/14001)
* [[`a4fc43202e`](https://github.com/nodejs/node/commit/a4fc43202e)] - **url**: remove unused code from autoEscapeStr (Cyril Lakech) [#15086](https://github.com/nodejs/node/pull/15086)
* [[`2aec977fa2`](https://github.com/nodejs/node/commit/2aec977fa2)] - **util**: remove duplicate code in format (Anatoli Papirovski) [#15098](https://github.com/nodejs/node/pull/15098)
* [[`de10c0f515`](https://github.com/nodejs/node/commit/de10c0f515)] - **util**: fix inspect array w. negative maxArrayLength (Ruben Bridgewater) [#14880](https://github.com/nodejs/node/pull/14880)
* [[`c3c6cb1c13`](https://github.com/nodejs/node/commit/c3c6cb1c13)] - **util**: use proper circular reference checking (Anna Henningsen) [#14790](https://github.com/nodejs/node/pull/14790)

<a id="8.4.0"></a>
## 2017-08-15, Version 8.4.0 (Current), @addaleax

### Notable changes

* **HTTP2**
  * Experimental support for the built-in `http2` has been added via the
    `--expose-http2` flag.
    [#14239](https://github.com/nodejs/node/pull/14239)

* **Inspector**
  * `require()` is available in the inspector console now.
    [#8837](https://github.com/nodejs/node/pull/8837)
  * Multiple contexts, as created by the `vm` module, are supported now.
    [#14465](https://github.com/nodejs/node/pull/14465)

* **N-API**
  * New APIs for creating number values have been introduced.
    [#14573](https://github.com/nodejs/node/pull/14573)

* **Stream**
  * For `Duplex` streams, the high water mark option can now be set
    independently for the readable and the writable side.
    [#14636](https://github.com/nodejs/node/pull/14636)

* **Util**
  * `util.format` now supports the `%o` and `%O` specifiers for printing
    objects.
    [#14558](https://github.com/nodejs/node/pull/14558)

### Commits

* [[`a6539ece2c`](https://github.com/nodejs/node/commit/a6539ece2c)] - **assert**: optimize code path for deepEqual Maps (Ruben Bridgewater) [#14501](https://github.com/nodejs/node/pull/14501)
* [[`2716b626b0`](https://github.com/nodejs/node/commit/2716b626b0)] - **async_hooks**: CHECK that resource is not empty (Anna Henningsen) [#14694](https://github.com/nodejs/node/pull/14694)
* [[`b3c1c6ff7f`](https://github.com/nodejs/node/commit/b3c1c6ff7f)] - **benchmark**: fix and extend assert benchmarks (Ruben Bridgewater) [#14147](https://github.com/nodejs/node/pull/14147)
* [[`139b08863e`](https://github.com/nodejs/node/commit/139b08863e)] - **benchmark**: Correct constructor for freelist (Gareth Ellis) [#14627](https://github.com/nodejs/node/pull/14627)
* [[`574cc379b9`](https://github.com/nodejs/node/commit/574cc379b9)] - **benchmark**: remove unused parameters (nishijayaraj) [#14640](https://github.com/nodejs/node/pull/14640)
* [[`fef2aa7e27`](https://github.com/nodejs/node/commit/fef2aa7e27)] - **(SEMVER-MINOR)** **deps**: add nghttp2 dependency (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`2d806f4f71`](https://github.com/nodejs/node/commit/2d806f4f71)] - **deps**: cherry-pick f19b889 from V8 upstream (Alexey Kozyatinskiy) [#14465](https://github.com/nodejs/node/pull/14465)
* [[`dd521d0a28`](https://github.com/nodejs/node/commit/dd521d0a28)] - **deps,tools**: add missing nghttp2 license (Anna Henningsen) [#14806](https://github.com/nodejs/node/pull/14806)
* [[`621c03acfe`](https://github.com/nodejs/node/commit/621c03acfe)] - **doc**: delint (Refael Ackermann) [#14707](https://github.com/nodejs/node/pull/14707)
* [[`230cb55574`](https://github.com/nodejs/node/commit/230cb55574)] - **doc**: fix header level typo (Refael Ackermann) [#14707](https://github.com/nodejs/node/pull/14707)
* [[`af85b6e058`](https://github.com/nodejs/node/commit/af85b6e058)] - **doc**: fix http2 sample code for http2.md (Keita Akutsu) [#14667](https://github.com/nodejs/node/pull/14667)
* [[`1e7ddb200f`](https://github.com/nodejs/node/commit/1e7ddb200f)] - **doc**: explain browser support of http/2 without SSL (Gil Tayar) [#14670](https://github.com/nodejs/node/pull/14670)
* [[`be716d00cc`](https://github.com/nodejs/node/commit/be716d00cc)] - **(SEMVER-MINOR)** **doc**: include http2.md in all.md (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`9e51802f53`](https://github.com/nodejs/node/commit/9e51802f53)] - **doc**: add missing `changes:` metadata for util (Anna Henningsen) [#14810](https://github.com/nodejs/node/pull/14810)
* [[`4811fea553`](https://github.com/nodejs/node/commit/4811fea553)] - **doc**: add missing `changes:` metadata for streams (Anna Henningsen) [#14810](https://github.com/nodejs/node/pull/14810)
* [[`20fb69063a`](https://github.com/nodejs/node/commit/20fb69063a)] - **doc**: fix docs style in util.md (Daijiro Wachi) [#14711](https://github.com/nodejs/node/pull/14711)
* [[`0de63e6888`](https://github.com/nodejs/node/commit/0de63e6888)] - **doc**: fix docs style in intl.md (Daijiro Wachi) [#14711](https://github.com/nodejs/node/pull/14711)
* [[`ee2ae0f30b`](https://github.com/nodejs/node/commit/ee2ae0f30b)] - **doc**: expanded description of buffer.slice (Vishal Bisht) [#14720](https://github.com/nodejs/node/pull/14720)
* [[`9888bb1238`](https://github.com/nodejs/node/commit/9888bb1238)] - **doc**: improve fs.read() doc text (Rich Trott) [#14631](https://github.com/nodejs/node/pull/14631)
* [[`d604173a66`](https://github.com/nodejs/node/commit/d604173a66)] - **doc**: clarify the position argument for fs.read (dcharbonnier) [#14631](https://github.com/nodejs/node/pull/14631)
* [[`d3b072276b`](https://github.com/nodejs/node/commit/d3b072276b)] - **doc**: add docs for AssertionError (Mandeep Singh) [#14261](https://github.com/nodejs/node/pull/14261)
* [[`4e15a6b76a`](https://github.com/nodejs/node/commit/4e15a6b76a)] - **doc**: fix order of AtExit callbacks in addons.md (Daniel Bevenius) [#14048](https://github.com/nodejs/node/pull/14048)
* [[`e07dfffad0`](https://github.com/nodejs/node/commit/e07dfffad0)] - **doc**: remove undef NDEBUG from addons.md (Daniel Bevenius) [#14048](https://github.com/nodejs/node/pull/14048)
* [[`c5ee34e39b`](https://github.com/nodejs/node/commit/c5ee34e39b)] - **encoding**: rudimentary TextDecoder support w/o ICU (Timothy Gu) [#14489](https://github.com/nodejs/node/pull/14489)
* [[`e0001dc601`](https://github.com/nodejs/node/commit/e0001dc601)] - **(SEMVER-MINOR)** **http**: move utcDate to internal/http.js (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`1d40850338`](https://github.com/nodejs/node/commit/1d40850338)] - **http2**: fix \[kInspect\]() output for Http2Stream (Evan Lucas) [#14753](https://github.com/nodejs/node/pull/14753)
* [[`c5740f9111`](https://github.com/nodejs/node/commit/c5740f9111)] - **http2**: name padding buffer fields (Anna Henningsen) [#14744](https://github.com/nodejs/node/pull/14744)
* [[`8a0d101adf`](https://github.com/nodejs/node/commit/8a0d101adf)] - **http2**: use per-environment buffers (Anna Henningsen) [#14744](https://github.com/nodejs/node/pull/14744)
* [[`92c37fe5fd`](https://github.com/nodejs/node/commit/92c37fe5fd)] - **http2**: improve perf of passing headers to C++ (Anna Henningsen) [#14723](https://github.com/nodejs/node/pull/14723)
* [[`47bf705f75`](https://github.com/nodejs/node/commit/47bf705f75)] - **http2**: rename some nghttp2 stream flags (Kelvin Jin) [#14637](https://github.com/nodejs/node/pull/14637)
* [[`723d1af5e7`](https://github.com/nodejs/node/commit/723d1af5e7)] - **(SEMVER-MINOR)** **http2**: fix flakiness in timeout (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`6a30448bac`](https://github.com/nodejs/node/commit/6a30448bac)] - **(SEMVER-MINOR)** **http2**: fix linting after rebase (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`efd929e402`](https://github.com/nodejs/node/commit/efd929e402)] - **(SEMVER-MINOR)** **http2**: fix compilation error after V8 update (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`f46c50b3e2`](https://github.com/nodejs/node/commit/f46c50b3e2)] - **(SEMVER-MINOR)** **http2**: add some doc detail for invalid header chars (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`b43caf92c0`](https://github.com/nodejs/node/commit/b43caf92c0)] - **(SEMVER-MINOR)** **http2**: fix documentation errors (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`33b03b2ab2`](https://github.com/nodejs/node/commit/33b03b2ab2)] - **(SEMVER-MINOR)** **http2**: minor cleanup (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`174ab6fda0`](https://github.com/nodejs/node/commit/174ab6fda0)] - **(SEMVER-MINOR)** **http2**: use static allocated arrays (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`9a4be4adc4`](https://github.com/nodejs/node/commit/9a4be4adc4)] - **(SEMVER-MINOR)** **http2**: get trailers working with the compat api (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`3e5b07a8fb`](https://github.com/nodejs/node/commit/3e5b07a8fb)] - **(SEMVER-MINOR)** **http2**: refactor trailers API (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`26e1f8e01c`](https://github.com/nodejs/node/commit/26e1f8e01c)] - **(SEMVER-MINOR)** **http2**: address initial pr feedback (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`7824fa0b40`](https://github.com/nodejs/node/commit/7824fa0b40)] - **(SEMVER-MINOR)** **http2**: make writeHead behave like HTTP/1. (Matteo Collina) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`b778838337`](https://github.com/nodejs/node/commit/b778838337)] - **(SEMVER-MINOR)** **http2**: doc and fixes to the Compatibility API (Matteo Collina) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`8f3bbd9b68`](https://github.com/nodejs/node/commit/8f3bbd9b68)] - **(SEMVER-MINOR)** **http2**: add range support for respondWith{File|FD} (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`61696f1215`](https://github.com/nodejs/node/commit/61696f1215)] - **(SEMVER-MINOR)** **http2**: fix socketOnTimeout and a segfault (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`2620769e7f`](https://github.com/nodejs/node/commit/2620769e7f)] - **(SEMVER-MINOR)** **http2**: refinement and test for socketError (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`cd0f4c6652`](https://github.com/nodejs/node/commit/cd0f4c6652)] - **(SEMVER-MINOR)** **http2**: fix abort when client.destroy inside end event (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`e8cc193bcc`](https://github.com/nodejs/node/commit/e8cc193bcc)] - **(SEMVER-MINOR)** **http2**: fix documentation nits (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`a49146e446`](https://github.com/nodejs/node/commit/a49146e446)] - **(SEMVER-MINOR)** **http2**: remove redundant return in test (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`3eb61b00de`](https://github.com/nodejs/node/commit/3eb61b00de)] - **(SEMVER-MINOR)** **http2**: add tests and benchmarks (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`9623ee0f99`](https://github.com/nodejs/node/commit/9623ee0f99)] - **(SEMVER-MINOR)** **http2**: introducing HTTP/2 (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`029567a460`](https://github.com/nodejs/node/commit/029567a460)] - **inspector**: support extra contexts (Eugene Ostroukhov) [#14465](https://github.com/nodejs/node/pull/14465)
* [[`d89f9f82b0`](https://github.com/nodejs/node/commit/d89f9f82b0)] - **(SEMVER-MINOR)** **inspector**: allow require in Runtime.evaluate (Jan Krems) [#8837](https://github.com/nodejs/node/pull/8837)
* [[`ac1b81ad75`](https://github.com/nodejs/node/commit/ac1b81ad75)] - **lib**: move deprecationWarned var (Daniel Bevenius) [#14769](https://github.com/nodejs/node/pull/14769)
* [[`8433b1ad37`](https://github.com/nodejs/node/commit/8433b1ad37)] - **lib**: use Timer.now() in readline module (Rich Trott) [#14681](https://github.com/nodejs/node/pull/14681)
* [[`917ace283f`](https://github.com/nodejs/node/commit/917ace283f)] - **(SEMVER-MINOR)** **n-api**: add napi_get_node_version (Anna Henningsen) [#14696](https://github.com/nodejs/node/pull/14696)
* [[`5e2cce59ef`](https://github.com/nodejs/node/commit/5e2cce59ef)] - **(SEMVER-MINOR)** **n-api**: optimize number API performance (Jason Ginchereau) [#14573](https://github.com/nodejs/node/pull/14573)
* [[`c94f346b93`](https://github.com/nodejs/node/commit/c94f346b93)] - **net**: use rest parameters instead of arguments (Tobias Nießen) [#13472](https://github.com/nodejs/node/pull/13472)
* [[`1c00875747`](https://github.com/nodejs/node/commit/1c00875747)] - **repl**: include folder extensions in autocomplete (Teddy Katz) [#14727](https://github.com/nodejs/node/pull/14727)
* [[`59d1d56da6`](https://github.com/nodejs/node/commit/59d1d56da6)] - **src**: remove unused http2_socket_buffer from env (Anna Henningsen) [#14740](https://github.com/nodejs/node/pull/14740)
* [[`268a1ff3f1`](https://github.com/nodejs/node/commit/268a1ff3f1)] - **src**: mention that node options are space-separated (Gabriel Schulhof) [#14709](https://github.com/nodejs/node/pull/14709)
* [[`9237ef868e`](https://github.com/nodejs/node/commit/9237ef868e)] - **src**: avoid creating local data variable (Daniel Bevenius) [#14732](https://github.com/nodejs/node/pull/14732)
* [[`f83827d64b`](https://github.com/nodejs/node/commit/f83827d64b)] - **src**: use local isolate instead of args.GetIsolate (Daniel Bevenius) [#14768](https://github.com/nodejs/node/pull/14768)
* [[`d7d22ead2b`](https://github.com/nodejs/node/commit/d7d22ead2b)] - **src**: add comments for cares library init refcount (Anna Henningsen) [#14743](https://github.com/nodejs/node/pull/14743)
* [[`b87fae927d`](https://github.com/nodejs/node/commit/b87fae927d)] - **src**: remove duplicate loop (Anna Henningsen) [#14750](https://github.com/nodejs/node/pull/14750)
* [[`033773c17b`](https://github.com/nodejs/node/commit/033773c17b)] - **src**: add overlooked handle to cleanup (Anna Henningsen) [#14749](https://github.com/nodejs/node/pull/14749)
* [[`dd6444d401`](https://github.com/nodejs/node/commit/dd6444d401)] - **src,http2**: DRY header/trailer handling code up (Anna Henningsen) [#14688](https://github.com/nodejs/node/pull/14688)
* [[`ef8ac7b5ac`](https://github.com/nodejs/node/commit/ef8ac7b5ac)] - **(SEMVER-MINOR)** **stream**: support readable/writableHWM for Duplex (Guy Margalit) [#14636](https://github.com/nodejs/node/pull/14636)
* [[`6d9f94f93f`](https://github.com/nodejs/node/commit/6d9f94f93f)] - **test**: cover all HTTP methods that parser supports (Oky Antoro) [#14773](https://github.com/nodejs/node/pull/14773)
* [[`e4854fccfc`](https://github.com/nodejs/node/commit/e4854fccfc)] - **test**: use regular expressions in throw assertions (Vincent Xue) [#14318](https://github.com/nodejs/node/pull/14318)
* [[`66788fc4d0`](https://github.com/nodejs/node/commit/66788fc4d0)] - **test**: increase http2 coverage (Michael Albert) [#14701](https://github.com/nodejs/node/pull/14701)
* [[`dbb9c370d4`](https://github.com/nodejs/node/commit/dbb9c370d4)] - **test**: add crypto check to http2 tests (Daniel Bevenius) [#14657](https://github.com/nodejs/node/pull/14657)
* [[`97f622b99e`](https://github.com/nodejs/node/commit/97f622b99e)] - **(SEMVER-MINOR)** **test**: fix flaky test-http2-client-unescaped-path on osx (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`9d752d5282`](https://github.com/nodejs/node/commit/9d752d5282)] - **(SEMVER-MINOR)** **test**: fix flakiness in test-http2-client-upload (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`82c63a55ea`](https://github.com/nodejs/node/commit/82c63a55ea)] - **test**: add test-benchmark-arrays (Rich Trott) [#14728](https://github.com/nodejs/node/pull/14728)
* [[`0eab77c86f`](https://github.com/nodejs/node/commit/0eab77c86f)] - **test**: allow inspector to reopen with same port (Gibson Fahnestock) [#14320](https://github.com/nodejs/node/pull/14320)
* [[`9bbbf12827`](https://github.com/nodejs/node/commit/9bbbf12827)] - **test**: remove redundant `using` in cctest (XadillaX) [#14739](https://github.com/nodejs/node/pull/14739)
* [[`7eb9f6f6e4`](https://github.com/nodejs/node/commit/7eb9f6f6e4)] - **test**: make totalLen snake case (Daniel Bevenius) [#14765](https://github.com/nodejs/node/pull/14765)
* [[`977e22857a`](https://github.com/nodejs/node/commit/977e22857a)] - **test**: make test-tls-connect checks more strict (Rich Trott) [#14695](https://github.com/nodejs/node/pull/14695)
* [[`a781bb4508`](https://github.com/nodejs/node/commit/a781bb4508)] - ***Revert*** "**test**: disable MultipleEnvironmentsPerIsolate" (Anna Henningsen) [#14749](https://github.com/nodejs/node/pull/14749)
* [[`8ff2a5c338`](https://github.com/nodejs/node/commit/8ff2a5c338)] - ***Revert*** "**test**: add DISABLED_ prefix to commented out test" (Anna Henningsen) [#14749](https://github.com/nodejs/node/pull/14749)
* [[`0bc3124c80`](https://github.com/nodejs/node/commit/0bc3124c80)] - **test**: properly order freeing resources in cctest (Anna Henningsen) [#14749](https://github.com/nodejs/node/pull/14749)
* [[`3f1bb0a551`](https://github.com/nodejs/node/commit/3f1bb0a551)] - **test**: split out load-sensitive readline tests (Rich Trott) [#14681](https://github.com/nodejs/node/pull/14681)
* [[`5d99d7dff2`](https://github.com/nodejs/node/commit/5d99d7dff2)] - **test**: add block scoping to test-readline-interface (Rich Trott) [#14615](https://github.com/nodejs/node/pull/14615)
* [[`58742729da`](https://github.com/nodejs/node/commit/58742729da)] - **test**: set module loading error for aix (Prakash Palaniappan) [#14511](https://github.com/nodejs/node/pull/14511)
* [[`06ba2dae30`](https://github.com/nodejs/node/commit/06ba2dae30)] - **test**: fix conversion of microseconds in test (Nick Stanish) [#14706](https://github.com/nodejs/node/pull/14706)
* [[`30837b3b90`](https://github.com/nodejs/node/commit/30837b3b90)] - **test**: improve check in test-os (Rich Trott) [#14655](https://github.com/nodejs/node/pull/14655)
* [[`55aba6aee7`](https://github.com/nodejs/node/commit/55aba6aee7)] - **test**: replace indexOf with includes (Miguel Angel Asencio Hurtado) [#14630](https://github.com/nodejs/node/pull/14630)
* [[`935d34bd6b`](https://github.com/nodejs/node/commit/935d34bd6b)] - **test**: fix test-readline-interface (Azard) [#14677](https://github.com/nodejs/node/pull/14677)
* [[`2ee3320f2c`](https://github.com/nodejs/node/commit/2ee3320f2c)] - **test**: improve multiple timers tests (James M Snell) [#14616](https://github.com/nodejs/node/pull/14616)
* [[`71f2e76353`](https://github.com/nodejs/node/commit/71f2e76353)] - **test**: use ciphers supported by shared OpenSSL (Jérémy Lal) [#14566](https://github.com/nodejs/node/pull/14566)
* [[`f73f659186`](https://github.com/nodejs/node/commit/f73f659186)] - **test**: mitigate RegEx exceeding 80 chars (Aditya Anand) [#14607](https://github.com/nodejs/node/pull/14607)
* [[`96147c980c`](https://github.com/nodejs/node/commit/96147c980c)] - **test**: read proper inspector message size (Bartosz Sosnowski) [#14596](https://github.com/nodejs/node/pull/14596)
* [[`e84c9d7176`](https://github.com/nodejs/node/commit/e84c9d7176)] - **(SEMVER-MINOR)** **tls**: add tlsSocket.disableRenegotiation() (James M Snell) [#14239](https://github.com/nodejs/node/pull/14239)
* [[`a0e05e884e`](https://github.com/nodejs/node/commit/a0e05e884e)] - **tools**: fix tools/addon-verify.js (Daniel Bevenius) [#14048](https://github.com/nodejs/node/pull/14048)
* [[`116841056a`](https://github.com/nodejs/node/commit/116841056a)] - **util**: improve util.inspect performance (Ruben Bridgewater) [#14492](https://github.com/nodejs/node/pull/14492)
* [[`7203924fea`](https://github.com/nodejs/node/commit/7203924fea)] - **(SEMVER-MINOR)** **util**: implement %o and %O as formatting specifiers (Greg Alexander) [#14558](https://github.com/nodejs/node/pull/14558)

<a id="8.3.0"></a>
## 2017-08-09, Version 8.3.0 (Current), @addaleax

### Notable changes

#### V8 6.0

The V8 engine has been upgraded to version 6.0, which has a significantly
changed performance profile.
[#14574](https://github.com/nodejs/node/pull/14574)

More detailed information on performance differences can be found at
https://medium.com/the-node-js-collection/get-ready-a-new-v8-is-coming-node-js-performance-is-changing-46a63d6da4de

#### Other notable changes

* **DNS**
  * Independent DNS resolver instances are supported now, with support for
    cancelling the corresponding requests.
    [#14518](https://github.com/nodejs/node/pull/14518)

* **N-API**
  * Multiple N-API functions for error handling have been changed to support
    assigning error codes.
    [#13988](https://github.com/nodejs/node/pull/13988)

* **REPL**
  * Autocompletion support for `require()` has been improved.
    [#14409](https://github.com/nodejs/node/pull/14409)

* **Utilities**
  * The WHATWG Encoding Standard (`TextDecoder` and `TextEncoder`) has
    been implemented as an experimental feature.
    [#13644](https://github.com/nodejs/node/pull/13644)

* **Added new collaborators**
  * [XadillaX](https://github.com/XadillaX) – Khaidi Chu
  * [gabrielschulhof](https://github.com/gabrielschulhof) – Gabriel Schulhof

### Commits

* [[`e2356e72e7`](https://github.com/nodejs/node/commit/e2356e72e7)] - **assert**: improve deepEqual Set and Map worst case (Ruben Bridgewater) [#14258](https://github.com/nodejs/node/pull/14258)
* [[`9252b8c057`](https://github.com/nodejs/node/commit/9252b8c057)] - **assert**: refactor to reduce unecessary code paths (Ruben Bridgewater) [#13973](https://github.com/nodejs/node/pull/13973)
* [[`89586f6684`](https://github.com/nodejs/node/commit/89586f6684)] - **assert**: fix incorrect use of ERR_INVALID_ARG_TYPE (Tobias Nießen) [#14011](https://github.com/nodejs/node/pull/14011)
* [[`26785a23bb`](https://github.com/nodejs/node/commit/26785a23bb)] - **assert**: refactor the code (Ruben Bridgewater) [#13862](https://github.com/nodejs/node/pull/13862)
* [[`0cf1e22448`](https://github.com/nodejs/node/commit/0cf1e22448)] - **benchmark**: remove unused parameters (Matthew Alsup) [#14526](https://github.com/nodejs/node/pull/14526)
* [[`9b104b4ea8`](https://github.com/nodejs/node/commit/9b104b4ea8)] - **benchmark**: add assert map and set benchmarks (Ruben Bridgewater) [#14258](https://github.com/nodejs/node/pull/14258)
* [[`2c364ab291`](https://github.com/nodejs/node/commit/2c364ab291)] - **buffer**: remove a wrongly added attribute specifier (Jiajie Hu) [#14466](https://github.com/nodejs/node/pull/14466)
* [[`c0f0c38535`](https://github.com/nodejs/node/commit/c0f0c38535)] - **build**: enable C++ linting for src/*/* (jeyanthinath) [#14497](https://github.com/nodejs/node/pull/14497)
* [[`87e108059b`](https://github.com/nodejs/node/commit/87e108059b)] - **build**: fix build without icu (Jimmy Thomson) [#14533](https://github.com/nodejs/node/pull/14533)
* [[`0ebb4dff17`](https://github.com/nodejs/node/commit/0ebb4dff17)] - **build**: codesign tarball binary on macOS (Evan Lucas) [#14179](https://github.com/nodejs/node/pull/14179)
* [[`7f5bcbd2e9`](https://github.com/nodejs/node/commit/7f5bcbd2e9)] - **build,test**: run v8 tests on windows (Kunal Pathak) [#13992](https://github.com/nodejs/node/pull/13992)
* [[`5ab4471d72`](https://github.com/nodejs/node/commit/5ab4471d72)] - **build,tools**: do not force codesign prefix (Evan Lucas) [#14179](https://github.com/nodejs/node/pull/14179)
* [[`7b96944254`](https://github.com/nodejs/node/commit/7b96944254)] - **build,win**: fix python detection script (Jason Ginchereau) [#14546](https://github.com/nodejs/node/pull/14546)
* [[`1f16c43e80`](https://github.com/nodejs/node/commit/1f16c43e80)] - **child_process**: fix handle passing w large payloads (Anna Henningsen) [#14588](https://github.com/nodejs/node/pull/14588)
* [[`9c1199e88f`](https://github.com/nodejs/node/commit/9c1199e88f)] - **(SEMVER-MINOR)** **console**: add console.count() and console.clear() (James M Snell) [#12678](https://github.com/nodejs/node/pull/12678)
* [[`255b9bfa8a`](https://github.com/nodejs/node/commit/255b9bfa8a)] - **console,test**: make message test more accurate (Anna Henningsen) [#14580](https://github.com/nodejs/node/pull/14580)
* [[`51c1afafa6`](https://github.com/nodejs/node/commit/51c1afafa6)] - **crypto**: change segmentation faults to CHECKs (Tobias Nießen) [#14548](https://github.com/nodejs/node/pull/14548)
* [[`e2b306c831`](https://github.com/nodejs/node/commit/e2b306c831)] - **(SEMVER-MINOR)** **deps**: backport rehash strings after deserialization (Yang Guo) [#14004](https://github.com/nodejs/node/pull/14004)
* [[`2dbf95d5ee`](https://github.com/nodejs/node/commit/2dbf95d5ee)] - **(SEMVER-MINOR)** **deps**: backport c0f1ff2 from upstream V8 (Michaël Zasso) [#14004](https://github.com/nodejs/node/pull/14004)
* [[`efd297a5c9`](https://github.com/nodejs/node/commit/efd297a5c9)] - **(SEMVER-MINOR)** **deps**: fix addons compilation with VS2013 (Bartosz Sosnowski) [#14004](https://github.com/nodejs/node/pull/14004)
* [[`160e2f03d2`](https://github.com/nodejs/node/commit/160e2f03d2)] - **(SEMVER-MINOR)** **deps**: limit regress/regress-crbug-514081 v8 test (Michael Dawson) [#14004](https://github.com/nodejs/node/pull/14004)
* [[`44ad55d493`](https://github.com/nodejs/node/commit/44ad55d493)] - **(SEMVER-MINOR)** **deps**: update V8 to 6.0.286.52 (Myles Borins) [#14574](https://github.com/nodejs/node/pull/14574)
* [[`d9273ed5ed`](https://github.com/nodejs/node/commit/d9273ed5ed)] - **deps**: cherry-pick 18ea996 from c-ares upstream (Anna Henningsen) [#13883](https://github.com/nodejs/node/pull/13883)
* [[`32b30d519e`](https://github.com/nodejs/node/commit/32b30d519e)] - **(SEMVER-MINOR)** **dns**: name generated functions (Anna Henningsen) [#14518](https://github.com/nodejs/node/pull/14518)
* [[`0982810208`](https://github.com/nodejs/node/commit/0982810208)] - **(SEMVER-MINOR)** **dns**: add channel.cancel() (Anna Henningsen) [#14518](https://github.com/nodejs/node/pull/14518)
* [[`69e41dc5da`](https://github.com/nodejs/node/commit/69e41dc5da)] - **(SEMVER-MINOR)** **dns**: enable usage of independent cares resolvers (Anna Henningsen) [#14518](https://github.com/nodejs/node/pull/14518)
* [[`ad901ed272`](https://github.com/nodejs/node/commit/ad901ed272)] - **doc**: add gabrielschulhof to collaborators (Gabriel Schulhof) [#14692](https://github.com/nodejs/node/pull/14692)
* [[`dd586c6bd4`](https://github.com/nodejs/node/commit/dd586c6bd4)] - **doc**: erase unneeded eslint-plugin-markdown comment (Vse Mozhet Byt) [#14598](https://github.com/nodejs/node/pull/14598)
* [[`8c80e91a2e`](https://github.com/nodejs/node/commit/8c80e91a2e)] - **doc**: fix typo in writing-and-running-benchmarks.md (Yuta Hiroto) [#14600](https://github.com/nodejs/node/pull/14600)
* [[`91b7843aeb`](https://github.com/nodejs/node/commit/91b7843aeb)] - **doc**: add entry for subprocess.killed property (Rich Trott) [#14578](https://github.com/nodejs/node/pull/14578)
* [[`342f4cccb5`](https://github.com/nodejs/node/commit/342f4cccb5)] - **doc**: change `child` to `subprocess` (Rich Trott) [#14578](https://github.com/nodejs/node/pull/14578)
* [[`b6bd3cf00f`](https://github.com/nodejs/node/commit/b6bd3cf00f)] - **doc**: cross-link util.TextDecoder and intl.md (Vse Mozhet Byt) [#14486](https://github.com/nodejs/node/pull/14486)
* [[`fffd8f5335`](https://github.com/nodejs/node/commit/fffd8f5335)] - **doc**: document napi_finalize() signature (cjihrig) [#14230](https://github.com/nodejs/node/pull/14230)
* [[`92b0555965`](https://github.com/nodejs/node/commit/92b0555965)] - **doc**: various small revisions in url (Timothy Gu) [#14478](https://github.com/nodejs/node/pull/14478)
* [[`9dd9760951`](https://github.com/nodejs/node/commit/9dd9760951)] - **doc**: update url.origin IDNA behavior (Timothy Gu) [#14478](https://github.com/nodejs/node/pull/14478)
* [[`4e2493a20d`](https://github.com/nodejs/node/commit/4e2493a20d)] - **doc**: fix minor typos in net.md (Daiki Arai) [#14502](https://github.com/nodejs/node/pull/14502)
* [[`e9088f92d8`](https://github.com/nodejs/node/commit/e9088f92d8)] - **doc**: fix verify in crypto.md (Ruslan Iusupov) [#14469](https://github.com/nodejs/node/pull/14469)
* [[`8a9de1b3c5`](https://github.com/nodejs/node/commit/8a9de1b3c5)] - **doc**: fix typo in using-internal-errors.md (Anton Paras) [#14429](https://github.com/nodejs/node/pull/14429)
* [[`ab9bc81b0e`](https://github.com/nodejs/node/commit/ab9bc81b0e)] - **doc**: add docs for module.paths (atever) [#14435](https://github.com/nodejs/node/pull/14435)
* [[`bdcd496c98`](https://github.com/nodejs/node/commit/bdcd496c98)] - **doc**: update experimental status to reflect use (James M Snell) [#12723](https://github.com/nodejs/node/pull/12723)
* [[`6c6da38518`](https://github.com/nodejs/node/commit/6c6da38518)] - **doc**: fix some links (Vse Mozhet Byt) [#14400](https://github.com/nodejs/node/pull/14400)
* [[`83c8e5c517`](https://github.com/nodejs/node/commit/83c8e5c517)] - **doc**: describe labelling process for backports (Anna Henningsen) [#12431](https://github.com/nodejs/node/pull/12431)
* [[`592787ef4d`](https://github.com/nodejs/node/commit/592787ef4d)] - **doc**: error message are still major (Refael Ackermann) [#14375](https://github.com/nodejs/node/pull/14375)
* [[`f1b09c0a44`](https://github.com/nodejs/node/commit/f1b09c0a44)] - **doc**: fix typo in stream.md (Marc Hernández Cabot) [#14364](https://github.com/nodejs/node/pull/14364)
* [[`4be373bc4b`](https://github.com/nodejs/node/commit/4be373bc4b)] - **doc**: fixes default shell in child_process.md (Henry) [#14203](https://github.com/nodejs/node/pull/14203)
* [[`b12924d894`](https://github.com/nodejs/node/commit/b12924d894)] - **doc**: add XadillaX to collaborators (XadillaX) [#14388](https://github.com/nodejs/node/pull/14388)
* [[`dc0a26f254`](https://github.com/nodejs/node/commit/dc0a26f254)] - **doc**: replace dead link in v8 module (Devin Boyer) [#14372](https://github.com/nodejs/node/pull/14372)
* [[`d2121ab768`](https://github.com/nodejs/node/commit/d2121ab768)] - **doc**: fix minor typo in cluster.md (Lance Ball) [#14353](https://github.com/nodejs/node/pull/14353)
* [[`eb023ef7df`](https://github.com/nodejs/node/commit/eb023ef7df)] - **doc, lib, test**: do not re-require needlessly (Vse Mozhet Byt) [#14244](https://github.com/nodejs/node/pull/14244)
* [[`cfed48e81c`](https://github.com/nodejs/node/commit/cfed48e81c)] - **doc, url**: add changelog metadata for url.format (Timothy Gu) [#14543](https://github.com/nodejs/node/pull/14543)
* [[`78f0c2aa75`](https://github.com/nodejs/node/commit/78f0c2aa75)] - **doc,assert**: document stackStartFunction in fail (Ruben Bridgewater) [#13862](https://github.com/nodejs/node/pull/13862)
* [[`53ad91c3b1`](https://github.com/nodejs/node/commit/53ad91c3b1)] - **doc,stream**: \_transform happens one at a time (Matteo Collina) [#14321](https://github.com/nodejs/node/pull/14321)
* [[`f6a03439d8`](https://github.com/nodejs/node/commit/f6a03439d8)] - **docs**: add note about fs.rmdir() (Oleksandr Kushchak) [#14323](https://github.com/nodejs/node/pull/14323)
* [[`142ce5ce2c`](https://github.com/nodejs/node/commit/142ce5ce2c)] - **errors**: order internal errors list alphabetically (Anna Henningsen) [#14453](https://github.com/nodejs/node/pull/14453)
* [[`50447e837b`](https://github.com/nodejs/node/commit/50447e837b)] - **http**: reset stream to unconsumed in `unconsume()` (Anna Henningsen) [#14410](https://github.com/nodejs/node/pull/14410)
* [[`751e87338f`](https://github.com/nodejs/node/commit/751e87338f)] - **http**: check for handle before running asyncReset() (Trevor Norris) [#14419](https://github.com/nodejs/node/pull/14419)
* [[`deea68cbb2`](https://github.com/nodejs/node/commit/deea68cbb2)] - **inspector**: fix console with inspector disabled (Timothy Gu) [#14489](https://github.com/nodejs/node/pull/14489)
* [[`71cb1cdf69`](https://github.com/nodejs/node/commit/71cb1cdf69)] - **inspector**: implement V8Inspector timer (Eugene Ostroukhov) [#14346](https://github.com/nodejs/node/pull/14346)
* [[`4836f3b9b9`](https://github.com/nodejs/node/commit/4836f3b9b9)] - **inspector**: send messages after the Node is done (Eugene Ostroukhov) [#14463](https://github.com/nodejs/node/pull/14463)
* [[`9e5a08884a`](https://github.com/nodejs/node/commit/9e5a08884a)] - **lib**: adjust indentation for impending lint change (Rich Trott) [#14403](https://github.com/nodejs/node/pull/14403)
* [[`a7b3e06e9b`](https://github.com/nodejs/node/commit/a7b3e06e9b)] - **lib**: modify destructuring for indentation (Rich Trott) [#14417](https://github.com/nodejs/node/pull/14417)
* [[`28f0693796`](https://github.com/nodejs/node/commit/28f0693796)] - **lib**: include cached modules in module.children (Ben Noordhuis) [#14132](https://github.com/nodejs/node/pull/14132)
* [[`19a0e06317`](https://github.com/nodejs/node/commit/19a0e06317)] - **linkedlist**: correct grammar in comments (alexbostock) [#14546](https://github.com/nodejs/node/pull/14546)
* [[`60e0f2bb0d`](https://github.com/nodejs/node/commit/60e0f2bb0d)] - **(SEMVER-MINOR)** **n-api**: add support for DataView (Shivanth MP) [#14382](https://github.com/nodejs/node/pull/14382)
* [[`b849b3d223`](https://github.com/nodejs/node/commit/b849b3d223)] - **n-api**: re-use napi_env between modules (Gabriel Schulhof) [#14217](https://github.com/nodejs/node/pull/14217)
* [[`6078dea35d`](https://github.com/nodejs/node/commit/6078dea35d)] - **n-api**: directly create Local from Persistent (Kyle Farnung) [#14211](https://github.com/nodejs/node/pull/14211)
* [[`f2efdc880f`](https://github.com/nodejs/node/commit/f2efdc880f)] - **(SEMVER-MINOR)** **n-api**: add code parameter to error helpers (Michael Dawson) [#13988](https://github.com/nodejs/node/pull/13988)
* [[`fa134dd60c`](https://github.com/nodejs/node/commit/fa134dd60c)] - **n-api**: add fast paths for integer getters (Anna Henningsen) [#14393](https://github.com/nodejs/node/pull/14393)
* [[`58446912a6`](https://github.com/nodejs/node/commit/58446912a6)] - **net**: fix bytesWritten during writev (Brendan Ashworth) [#14236](https://github.com/nodejs/node/pull/14236)
* [[`b41ae9847e`](https://github.com/nodejs/node/commit/b41ae9847e)] - **path**: fix win32 volume-relative paths (Timothy Gu) [#14440](https://github.com/nodejs/node/pull/14440)
* [[`509039fcaf`](https://github.com/nodejs/node/commit/509039fcaf)] - **path**: remove unnecessary string copies (Tobias Nießen) [#14438](https://github.com/nodejs/node/pull/14438)
* [[`e813cfaead`](https://github.com/nodejs/node/commit/e813cfaead)] - **querystring**: avoid indexOf when parsing (Matteo Collina) [#14703](https://github.com/nodejs/node/pull/14703)
* [[`37e55bf559`](https://github.com/nodejs/node/commit/37e55bf559)] - **readline**: remove max limit of crlfDelay (Azard) [#13497](https://github.com/nodejs/node/pull/13497)
* [[`e54f75b831`](https://github.com/nodejs/node/commit/e54f75b831)] - **readline**: remove the caching variable (Lyall Sun) [#14275](https://github.com/nodejs/node/pull/14275)
* [[`1a5927fc27`](https://github.com/nodejs/node/commit/1a5927fc27)] - **repl**: do not consider `...` as a REPL command (Shivanth MP) [#14467](https://github.com/nodejs/node/pull/14467)
* [[`5a8862bfa3`](https://github.com/nodejs/node/commit/5a8862bfa3)] - **(SEMVER-MINOR)** **repl**: improve require() autocompletion (Alexey Orlenko) [#14409](https://github.com/nodejs/node/pull/14409)
* [[`34821f6400`](https://github.com/nodejs/node/commit/34821f6400)] - **repl**: don't terminate on null thrown (Benjamin Gruenbaum) [#14306](https://github.com/nodejs/node/pull/14306)
* [[`32ba8aea0b`](https://github.com/nodejs/node/commit/32ba8aea0b)] - **repl**: fix old history error handling (Ruben Bridgewater) [#13733](https://github.com/nodejs/node/pull/13733)
* [[`264e4345f8`](https://github.com/nodejs/node/commit/264e4345f8)] - **src**: reuse 'ondone' string in node_crypto.cc (Tobias Nießen) [#14587](https://github.com/nodejs/node/pull/14587)
* [[`6ae6469d4a`](https://github.com/nodejs/node/commit/6ae6469d4a)] - **src**: use existing strings over creating new ones (Anna Henningsen) [#14587](https://github.com/nodejs/node/pull/14587)
* [[`eb068a0526`](https://github.com/nodejs/node/commit/eb068a0526)] - **src**: remove unused Connection::ClearError() (Ben Noordhuis) [#14514](https://github.com/nodejs/node/pull/14514)
* [[`4b01d8cac3`](https://github.com/nodejs/node/commit/4b01d8cac3)] - **src**: replace assert with CHECK_LE in node_api.cc (Ben Noordhuis) [#14514](https://github.com/nodejs/node/pull/14514)
* [[`3c6b5e5fac`](https://github.com/nodejs/node/commit/3c6b5e5fac)] - **src**: properly manage timer in cares ChannelWrap (Anna Henningsen) [#14634](https://github.com/nodejs/node/pull/14634)
* [[`8c5cd1439e`](https://github.com/nodejs/node/commit/8c5cd1439e)] - **src**: avoid dereference without existence check (Timothy Gu) [#14591](https://github.com/nodejs/node/pull/14591)
* [[`8a3bc874fa`](https://github.com/nodejs/node/commit/8a3bc874fa)] - **src**: fix process.abort() interaction with V8 (Anna Henningsen) [#13985](https://github.com/nodejs/node/pull/13985)
* [[`997204a213`](https://github.com/nodejs/node/commit/997204a213)] - **(SEMVER-MINOR)** **src**: fix new V8 compiler warnings (Michaël Zasso) [#14004](https://github.com/nodejs/node/pull/14004)
* [[`fa3aa2e1f7`](https://github.com/nodejs/node/commit/fa3aa2e1f7)] - **src**: return MaybeLocal in AsyncWrap::MakeCallback (Tobias Nießen) [#14549](https://github.com/nodejs/node/pull/14549)
* [[`d90a5e0069`](https://github.com/nodejs/node/commit/d90a5e0069)] - **src**: replace deprecated ForceSet() method (Franziska Hinkelmann) [#14450](https://github.com/nodejs/node/pull/14450)
* [[`eb7faf6734`](https://github.com/nodejs/node/commit/eb7faf6734)] - **src**: replace ASSERT with CHECK (Ben Noordhuis) [#14474](https://github.com/nodejs/node/pull/14474)
* [[`106a23bd27`](https://github.com/nodejs/node/commit/106a23bd27)] - **(SEMVER-MINOR)** **src,dns**: refactor cares_wrap to avoid global state (Anna Henningsen) [#14518](https://github.com/nodejs/node/pull/14518)
* [[`3c46ef4717`](https://github.com/nodejs/node/commit/3c46ef4717)] - **test**: explain sloppy mode for test-global (Rich Trott) [#14604](https://github.com/nodejs/node/pull/14604)
* [[`28b9c7a477`](https://github.com/nodejs/node/commit/28b9c7a477)] - **test**: fix test-readline-position w/o ICU (Timothy Gu) [#14489](https://github.com/nodejs/node/pull/14489)
* [[`636ba8caef`](https://github.com/nodejs/node/commit/636ba8caef)] - **test**: support odd value for kStringMaxLength (Michaël Zasso) [#14476](https://github.com/nodejs/node/pull/14476)
* [[`5094f2c299`](https://github.com/nodejs/node/commit/5094f2c299)] - **test**: refactor test-domain-abort-on-uncaught (Rich Trott) [#14541](https://github.com/nodejs/node/pull/14541)
* [[`b1fef05446`](https://github.com/nodejs/node/commit/b1fef05446)] - **test**: improvements to various http tests (James M Snell) [#14315](https://github.com/nodejs/node/pull/14315)
* [[`ce9e3cfe10`](https://github.com/nodejs/node/commit/ce9e3cfe10)] - **test**: refactor test/sequential/test-fs-watch.js (Rich Trott) [#14534](https://github.com/nodejs/node/pull/14534)
* [[`9f50db2450`](https://github.com/nodejs/node/commit/9f50db2450)] - **test**: refactor test-vm-new-script-new-context (Rich Trott) [#14536](https://github.com/nodejs/node/pull/14536)
* [[`f40b9062fc`](https://github.com/nodejs/node/commit/f40b9062fc)] - **test**: add check on an addon that does not register (Ezequiel Garcia) [#13954](https://github.com/nodejs/node/pull/13954)
* [[`ddd97fe15c`](https://github.com/nodejs/node/commit/ddd97fe15c)] - **test**: fix error when foo in path to git clone (Matt Woicik) [#14506](https://github.com/nodejs/node/pull/14506)
* [[`8fea17484d`](https://github.com/nodejs/node/commit/8fea17484d)] - **test**: add DISABLED_ prefix to commented out test (Daniel Bevenius) [#14317](https://github.com/nodejs/node/pull/14317)
* [[`7b6a77403c`](https://github.com/nodejs/node/commit/7b6a77403c)] - **test**: remove disabled tests directory (Rich Trott) [#14505](https://github.com/nodejs/node/pull/14505)
* [[`15b9aa1359`](https://github.com/nodejs/node/commit/15b9aa1359)] - **test**: improve error logging for inspector test (Rich Trott) [#14508](https://github.com/nodejs/node/pull/14508)
* [[`451e643cf2`](https://github.com/nodejs/node/commit/451e643cf2)] - **test**: remove --no-crankshaft (Myles Borins) [#14531](https://github.com/nodejs/node/pull/14531)
* [[`7c51240b1a`](https://github.com/nodejs/node/commit/7c51240b1a)] - **test**: adjust indentation for stricter linting (Rich Trott) [#14431](https://github.com/nodejs/node/pull/14431)
* [[`c704c02290`](https://github.com/nodejs/node/commit/c704c02290)] - **test**: increase coverage for path.parse (Tobias Nießen) [#14438](https://github.com/nodejs/node/pull/14438)
* [[`23cd934d71`](https://github.com/nodejs/node/commit/23cd934d71)] - **test**: refactor test-httpparser.response.js (erdun) [#14290](https://github.com/nodejs/node/pull/14290)
* [[`91b6ba1973`](https://github.com/nodejs/node/commit/91b6ba1973)] - **test**: refactor test-benchmark-timers (Rich Trott) [#14464](https://github.com/nodejs/node/pull/14464)
* [[`c2853893cf`](https://github.com/nodejs/node/commit/c2853893cf)] - **test**: refactor test-http-parser.js (Rich Trott) [#14431](https://github.com/nodejs/node/pull/14431)
* [[`4ff562f41e`](https://github.com/nodejs/node/commit/4ff562f41e)] - **test**: make flaky crypto test more deterministic (Ben Noordhuis) [#14451](https://github.com/nodejs/node/pull/14451)
* [[`100e862dfa`](https://github.com/nodejs/node/commit/100e862dfa)] - **test**: rename crypto test (Ben Noordhuis) [#14451](https://github.com/nodejs/node/pull/14451)
* [[`f8c2302a66`](https://github.com/nodejs/node/commit/f8c2302a66)] - **test**: use common.mustCall() instead of exit handle (笑斌) [#14262](https://github.com/nodejs/node/pull/14262)
* [[`0ff19b0c4c`](https://github.com/nodejs/node/commit/0ff19b0c4c)] - **test**: changed error message validator (Pratik Jain) [#14443](https://github.com/nodejs/node/pull/14443)
* [[`14f6a5a367`](https://github.com/nodejs/node/commit/14f6a5a367)] - **test**: fix flaky test-force-repl (Rich Trott) [#14439](https://github.com/nodejs/node/pull/14439)
* [[`5057c7a953`](https://github.com/nodejs/node/commit/5057c7a953)] - **test**: replace concatenation with template literal (rockcoder23) [#14270](https://github.com/nodejs/node/pull/14270)
* [[`6420a73f3e`](https://github.com/nodejs/node/commit/6420a73f3e)] - **test**: replace concatenation with template literal (Ching Hsu) [#14284](https://github.com/nodejs/node/pull/14284)
* [[`cd0fffd86a`](https://github.com/nodejs/node/commit/cd0fffd86a)] - **test**: convert table in test doc to markdown table (vixony) [#14291](https://github.com/nodejs/node/pull/14291)
* [[`1c6135f431`](https://github.com/nodejs/node/commit/1c6135f431)] - **test**: fix flaky http(s)-set-server-timeout tests (Rich Trott) [#14380](https://github.com/nodejs/node/pull/14380)
* [[`de3d73c88c`](https://github.com/nodejs/node/commit/de3d73c88c)] - **test**: replace CRLF by LF in a fixture (Vse Mozhet Byt) [#14437](https://github.com/nodejs/node/pull/14437)
* [[`aeb8d66eec`](https://github.com/nodejs/node/commit/aeb8d66eec)] - **test**: fix test-async-wrap-getasyncid flakyness (Julien Gilli) [#14329](https://github.com/nodejs/node/pull/14329)
* [[`3c50c592a5`](https://github.com/nodejs/node/commit/3c50c592a5)] - **test**: replace concatenation with template literals (笑斌) [#14293](https://github.com/nodejs/node/pull/14293)
* [[`1813467d27`](https://github.com/nodejs/node/commit/1813467d27)] - **test**: upgrade tests to work with master’s `common` (Anna Henningsen) [#14459](https://github.com/nodejs/node/pull/14459)
* [[`d89bb1c6f3`](https://github.com/nodejs/node/commit/d89bb1c6f3)] - **test**: bump test/common to master (Anna Henningsen) [#14459](https://github.com/nodejs/node/pull/14459)
* [[`d7a1637897`](https://github.com/nodejs/node/commit/d7a1637897)] - **test**: change isAix to isAIX (章礼平) [#14263](https://github.com/nodejs/node/pull/14263)
* [[`552d2be625`](https://github.com/nodejs/node/commit/552d2be625)] - **test**: improve test-util-inspect (Peter Marshall) [#14003](https://github.com/nodejs/node/pull/14003)
* [[`0418a70d7c`](https://github.com/nodejs/node/commit/0418a70d7c)] - **test**: add non-internet resolveAny tests (Anna Henningsen) [#13883](https://github.com/nodejs/node/pull/13883)
* [[`265f159881`](https://github.com/nodejs/node/commit/265f159881)] - **test**: replace concatenation with template literals (Song, Bintao Garfield) [#14295](https://github.com/nodejs/node/pull/14295)
* [[`3414e42127`](https://github.com/nodejs/node/commit/3414e42127)] - **test**: replace concatenation with template literals (Zongmin Lei) [#14298](https://github.com/nodejs/node/pull/14298)
* [[`953736cdde`](https://github.com/nodejs/node/commit/953736cdde)] - **test**: move timing-dependent tests to sequential (Alexey Orlenko) [#14377](https://github.com/nodejs/node/pull/14377)
* [[`9b22acc29e`](https://github.com/nodejs/node/commit/9b22acc29e)] - **test**: fix flaky test-net-write-after-close (Rich Trott) [#14361](https://github.com/nodejs/node/pull/14361)
* [[`11ae8c33bd`](https://github.com/nodejs/node/commit/11ae8c33bd)] - **test**: delete obsolete test-sendfd.js (decareano) [#14334](https://github.com/nodejs/node/pull/14334)
* [[`99104e1b58`](https://github.com/nodejs/node/commit/99104e1b58)] - **test**: improve fs.exists coverage (jkzing) [#14301](https://github.com/nodejs/node/pull/14301)
* [[`e237720537`](https://github.com/nodejs/node/commit/e237720537)] - **test**: replace string concatenation with template (ziyun) [#14286](https://github.com/nodejs/node/pull/14286)
* [[`3c92b787d7`](https://github.com/nodejs/node/commit/3c92b787d7)] - **test**: use path.join in async-hooks/test-tlswrap.js (Vincent Xue) [#14319](https://github.com/nodejs/node/pull/14319)
* [[`0197ba00a5`](https://github.com/nodejs/node/commit/0197ba00a5)] - **test**: add comments for whatwg-url tests (Gautam Arora) [#14355](https://github.com/nodejs/node/pull/14355)
* [[`956a473107`](https://github.com/nodejs/node/commit/956a473107)] - **test**: move test-fs-largefile to pummel (Rich Trott) [#14338](https://github.com/nodejs/node/pull/14338)
* [[`c866c9078b`](https://github.com/nodejs/node/commit/c866c9078b)] - **test**: use path.join for long path concatenation (zzz) [#14280](https://github.com/nodejs/node/pull/14280)
* [[`94c7331277`](https://github.com/nodejs/node/commit/94c7331277)] - **test**: replace string concatenation with path.join (jkzing) [#14272](https://github.com/nodejs/node/pull/14272)
* [[`def98c6959`](https://github.com/nodejs/node/commit/def98c6959)] - **test**: replace string concatenation with template (Nathan Jiang) [#14342](https://github.com/nodejs/node/pull/14342)
* [[`3bc7d2a5ea`](https://github.com/nodejs/node/commit/3bc7d2a5ea)] - **test**: replace string concat in test-fs-watchfile.js (Helianthus21) [#14287](https://github.com/nodejs/node/pull/14287)
* [[`72febfd3b6`](https://github.com/nodejs/node/commit/72febfd3b6)] - **test**: replace concatenation with template literals (SkyAo) [#14296](https://github.com/nodejs/node/pull/14296)
* [[`b5d0a03a9e`](https://github.com/nodejs/node/commit/b5d0a03a9e)] - **test**: fix error handling test-http-full-response (Rich Trott) [#14252](https://github.com/nodejs/node/pull/14252)
* [[`e90af29604`](https://github.com/nodejs/node/commit/e90af29604)] - **tls**: fix empty issuer/subject/infoAccess parsing (Ben Noordhuis) [#14473](https://github.com/nodejs/node/pull/14473)
* [[`767644def5`](https://github.com/nodejs/node/commit/767644def5)] - **tools**: simplify no-unescaped-regexp-dot rule (Rich Trott) [#14561](https://github.com/nodejs/node/pull/14561)
* [[`9f319d5dfb`](https://github.com/nodejs/node/commit/9f319d5dfb)] - **tools**: replace assert-throw-arguments custom lint (Rich Trott) [#14547](https://github.com/nodejs/node/pull/14547)
* [[`fa8c5f4372`](https://github.com/nodejs/node/commit/fa8c5f4372)] - **tools**: remove legacy indentation linting (Rich Trott) [#14515](https://github.com/nodejs/node/pull/14515)
* [[`d11840c180`](https://github.com/nodejs/node/commit/d11840c180)] - **tools**: enable stricter linting in lib directory (Rich Trott) [#14403](https://github.com/nodejs/node/pull/14403)
* [[`5e952182e7`](https://github.com/nodejs/node/commit/5e952182e7)] - **tools**: update to ESLint 4.3.0 (Rich Trott) [#14417](https://github.com/nodejs/node/pull/14417)
* [[`ebb90900af`](https://github.com/nodejs/node/commit/ebb90900af)] - **tools**: skip workaround for newer llvm (nanaya) [#14077](https://github.com/nodejs/node/pull/14077)
* [[`c0ea5d8ce5`](https://github.com/nodejs/node/commit/c0ea5d8ce5)] - **tools**: always include llvm_version in config (nanaya) [#14077](https://github.com/nodejs/node/pull/14077)
* [[`32259421ca`](https://github.com/nodejs/node/commit/32259421ca)] - **url**: update sort() behavior with no params (Timothy Gu) [#14185](https://github.com/nodejs/node/pull/14185)
* [[`9a3fc10dd4`](https://github.com/nodejs/node/commit/9a3fc10dd4)] - **(SEMVER-MINOR)** **util**: implement WHATWG Encoding Standard API (James M Snell) [#13644](https://github.com/nodejs/node/pull/13644)
* [[`f593960d35`](https://github.com/nodejs/node/commit/f593960d35)] - **util**: refactor util module (James M Snell) [#13803](https://github.com/nodejs/node/pull/13803)
* [[`357873ddb0`](https://github.com/nodejs/node/commit/357873ddb0)] - **(SEMVER-MINOR)** **v8**: fix stack overflow in recursive method (Ben Noordhuis) [#14004](https://github.com/nodejs/node/pull/14004)
* [[`a8132943c5`](https://github.com/nodejs/node/commit/a8132943c5)] - **zlib**: fix crash when initializing failed (Anna Henningsen) [#14666](https://github.com/nodejs/node/pull/14666)
* [[`e529914e70`](https://github.com/nodejs/node/commit/e529914e70)] - **zlib**: fix interaction of flushing and needDrain (Anna Henningsen) [#14527](https://github.com/nodejs/node/pull/14527)

<a id="8.2.1"></a>
## 2017-07-20, Version 8.2.1 (Current), @fishrock123

### Notable changes

* **http**: Writes no longer abort if the Socket is missing.
* **process, async_hooks**: Avoid problems when `triggerAsyncId` is `undefined`.
* **zlib**: Streams no longer attempt to process data when destroyed.

### Commits

* [[`8d426bbeec`](https://github.com/nodejs/node/commit/8d426bbeec)] - **http**: do not abort if socket is missing (Matteo Collina) [#14387](https://github.com/nodejs/node/pull/14387)
* [[`302c19b006`](https://github.com/nodejs/node/commit/302c19b006)] - **process**: triggerAsyncId can be undefined (Matteo Collina) [#14387](https://github.com/nodejs/node/pull/14387)
* [[`6fce1a314e`](https://github.com/nodejs/node/commit/6fce1a314e)] - **zlib**: check if the stream is destroyed before push (Matteo Collina) [#14330](https://github.com/nodejs/node/pull/14330)

<a id="8.2.0"></a>
## 2017-07-19, Version 8.2.0 (Current), @fishrock123

Big thanks to @addaleax who prepared the vast majority of this release.

### Notable changes

* **Async Hooks**
  * Multiple improvements to Promise support in `async_hooks` have been made.

* **Build**
  * The compiler version requirement to build Node with GCC has been raised to
    GCC 4.9.4.
    [[`820b011ed6`](https://github.com/nodejs/node/commit/820b011ed6)]
    [#13466](https://github.com/nodejs/node/pull/13466)

* **Cluster**
  * Users now have more fine-grained control over the inspector port used by
    individual cluster workers. Previously, cluster workers were restricted to
    incrementing from the master's debug port.
    [[`dfc46e262a`](https://github.com/nodejs/node/commit/dfc46e262a)]
    [#14140](https://github.com/nodejs/node/pull/14140)

* **DNS**
  * The server used for DNS queries can now use a custom port.
    [[`ebe7bb29aa`](https://github.com/nodejs/node/commit/ebe7bb29aa)]
    [#13723](https://github.com/nodejs/node/pull/13723)
  * Support for `dns.resolveAny()` has been added.
    [[`6e30e2558e`](https://github.com/nodejs/node/commit/6e30e2558e)]
    [#13137](https://github.com/nodejs/node/pull/13137)

* **npm**
  * The `npm` CLI has been updated to version 5.3.0. In particular, it now comes
    with the `npx` binary, which is also shipped with Node.
    [[`dc3f6b9ac1`](https://github.com/nodejs/node/commit/dc3f6b9ac1)]
    [#14235](https://github.com/nodejs/node/pull/14235)
  * `npm` Changelogs:
      - [v5.0.4](https://github.com/npm/npm/releases/tag/v5.0.4)
      - [v5.1.0](https://github.com/npm/npm/releases/tag/v5.1.0)
      - [v5.2.0](https://github.com/npm/npm/releases/tag/v5.2.0)
      - [v5.3.0](https://github.com/npm/npm/releases/tag/v5.3.0)

### Commits

* [[`53c52ac38e`](https://github.com/nodejs/node/commit/53c52ac38e)] - **N-API**: Reuse ObjectTemplate instances (Gabriel Schulhof) [#13999](https://github.com/nodejs/node/pull/13999)
* [[`86c06c01ec`](https://github.com/nodejs/node/commit/86c06c01ec)] - **async-hooks,net**: ensure asyncId=null if no handle (Matt Sergeant) [#13938](https://github.com/nodejs/node/pull/13938)
* [[`71ee15d340`](https://github.com/nodejs/node/commit/71ee15d340)] - **async_hooks**: make AsyncResource match emitInit (Andreas Madsen) [#14152](https://github.com/nodejs/node/pull/14152)
* [[`1aac2c09e7`](https://github.com/nodejs/node/commit/1aac2c09e7)] - **async_hooks**: rename internal emit functions (Andreas Madsen) [#14152](https://github.com/nodejs/node/pull/14152)
* [[`0c69ec12a9`](https://github.com/nodejs/node/commit/0c69ec12a9)] - **async_hooks**: fix nested hooks mutation (Andreas Madsen) [#14143](https://github.com/nodejs/node/pull/14143)
* [[`3211eff935`](https://github.com/nodejs/node/commit/3211eff935)] - **async_hooks**: move restoreTmpHooks call to init (Ruben Bridgewater) [#14054](https://github.com/nodejs/node/pull/14054)
* [[`76ba1b59bc`](https://github.com/nodejs/node/commit/76ba1b59bc)] - **async_hooks**: C++ Embedder API overhaul (Andreas Madsen) [#14040](https://github.com/nodejs/node/pull/14040)
* [[`544300ee48`](https://github.com/nodejs/node/commit/544300ee48)] - **async_hooks**: require parameter in emitBefore (Andreas Madsen) [#14050](https://github.com/nodejs/node/pull/14050)
* [[`9f66f1924f`](https://github.com/nodejs/node/commit/9f66f1924f)] - **async_hooks**: use common emitBefore and emitAfter (Andreas Madsen) [#14050](https://github.com/nodejs/node/pull/14050)
* [[`7b369d12cf`](https://github.com/nodejs/node/commit/7b369d12cf)] - **async_hooks**: fix default nextTick triggerAsyncId (Andreas Madsen) [#14026](https://github.com/nodejs/node/pull/14026)
* [[`2eabd92639`](https://github.com/nodejs/node/commit/2eabd92639)] - **async_hooks**: reduce duplication with factory (Ruben Bridgewater) [#13755](https://github.com/nodejs/node/pull/13755)
* [[`8f37f5dd01`](https://github.com/nodejs/node/commit/8f37f5dd01)] - **async_hooks**: proper id stacking for Promises (Anna Henningsen) [#13585](https://github.com/nodejs/node/pull/13585)
* [[`3bb4ec80ae`](https://github.com/nodejs/node/commit/3bb4ec80ae)] - **(SEMVER-MINOR)** **async_hooks**: rename currentId and triggerId (Andreas Madsen) [#13490](https://github.com/nodejs/node/pull/13490)
* [[`8b57b09c15`](https://github.com/nodejs/node/commit/8b57b09c15)] - ***Revert*** "**async_hooks**: only set up hooks if used" (Trevor Norris) [#13509](https://github.com/nodejs/node/pull/13509)
* [[`a44260326c`](https://github.com/nodejs/node/commit/a44260326c)] - **(SEMVER-MINOR)** **async_hooks**: use resource objects for Promises (Anna Henningsen) [#13452](https://github.com/nodejs/node/pull/13452)
* [[`2122e2fe89`](https://github.com/nodejs/node/commit/2122e2fe89)] - **async_wrap**: use kTotals to enable PromiseHook (Trevor Norris) [#13509](https://github.com/nodejs/node/pull/13509)
* [[`96279e83e7`](https://github.com/nodejs/node/commit/96279e83e7)] - **async_wrap**: expose enable/disablePromiseHook API (Anna Henningsen) [#13509](https://github.com/nodejs/node/pull/13509)
* [[`1c0f20fcf3`](https://github.com/nodejs/node/commit/1c0f20fcf3)] - **benchmark**: fix typo in inspect-proxy (Vse Mozhet Byt) [#14237](https://github.com/nodejs/node/pull/14237)
* [[`65a2e80596`](https://github.com/nodejs/node/commit/65a2e80596)] - **benchmark**: Improve event performance tests. (Benedikt Meurer) [#14052](https://github.com/nodejs/node/pull/14052)
* [[`3d0b66a7c2`](https://github.com/nodejs/node/commit/3d0b66a7c2)] - **benchmark,lib,test**: use braces for multiline block (Rich Trott) [#13995](https://github.com/nodejs/node/pull/13995)
* [[`bed13444b1`](https://github.com/nodejs/node/commit/bed13444b1)] - **buffer**: remove MAX_SAFE_INTEGER check on length (Rich Trott) [#14131](https://github.com/nodejs/node/pull/14131)
* [[`683f743e61`](https://github.com/nodejs/node/commit/683f743e61)] - **(SEMVER-MINOR)** **buffer**: support boxed strings and toPrimitive (James M Snell) [#13725](https://github.com/nodejs/node/pull/13725)
* [[`7794030700`](https://github.com/nodejs/node/commit/7794030700)] - **(SEMVER-MINOR)** **buffer**: add constants object (Anna Henningsen) [#13467](https://github.com/nodejs/node/pull/13467)
* [[`1444601a57`](https://github.com/nodejs/node/commit/1444601a57)] - **build**: prevent VsDevCmd.bat from changing cwd (Nikolai Vavilov) [#14303](https://github.com/nodejs/node/pull/14303)
* [[`6b052e7c42`](https://github.com/nodejs/node/commit/6b052e7c42)] - **(SEMVER-MINOR)** **build**: add npx to installers (Kat Marchán) [#14235](https://github.com/nodejs/node/pull/14235)
* [[`922f58f8ca`](https://github.com/nodejs/node/commit/922f58f8ca)] - **build**: run test-hash-seed at the end of test-v8 (Michaël Zasso) [#14219](https://github.com/nodejs/node/pull/14219)
* [[`b757105862`](https://github.com/nodejs/node/commit/b757105862)] - **build**: allow enabling the --trace-maps flag in V8 (Evan Lucas) [#14018](https://github.com/nodejs/node/pull/14018)
* [[`9ee271d92b`](https://github.com/nodejs/node/commit/9ee271d92b)] - **build**: split up cpplint to avoid long cmd lines (Kyle Farnung) [#14116](https://github.com/nodejs/node/pull/14116)
* [[`651af59e6b`](https://github.com/nodejs/node/commit/651af59e6b)] - **build**: add async-hooks testing to vcbuild.bat (Refael Ackermann) [#13381](https://github.com/nodejs/node/pull/13381)
* [[`c972364848`](https://github.com/nodejs/node/commit/c972364848)] - **build**: remove dependency on icu io library (Ben Noordhuis) [#13656](https://github.com/nodejs/node/pull/13656)
* [[`f2d7b803f1`](https://github.com/nodejs/node/commit/f2d7b803f1)] - **build**: clean up config_fips.gypi (Daniel Bevenius) [#13837](https://github.com/nodejs/node/pull/13837)
* [[`897405d62c`](https://github.com/nodejs/node/commit/897405d62c)] - **build,win**: skip `vcvarsall.bat` if env is set (Refael Ackermann) [#13806](https://github.com/nodejs/node/pull/13806)
* [[`dc0ae8be56`](https://github.com/nodejs/node/commit/dc0ae8be56)] - **build,win**: respect VS version for building addons (João Reis) [#13911](https://github.com/nodejs/node/pull/13911)
* [[`cd9ef939ba`](https://github.com/nodejs/node/commit/cd9ef939ba)] - **build,win**: use latest installed VS by default (João Reis) [#13911](https://github.com/nodejs/node/pull/13911)
* [[`79ead795b9`](https://github.com/nodejs/node/commit/79ead795b9)] - **build,windows**: restore DISTTYPEDIR (Refael Ackermann) [#13969](https://github.com/nodejs/node/pull/13969)
* [[`949f7be5a0`](https://github.com/nodejs/node/commit/949f7be5a0)] - **build,windows**: implement PEP514 python detection (Refael Ackermann) [#13900](https://github.com/nodejs/node/pull/13900)
* [[`096080b69c`](https://github.com/nodejs/node/commit/096080b69c)] - **child_process**: refactor normalizeSpawnArguments() (Rich Trott) [#14149](https://github.com/nodejs/node/pull/14149)
* [[`09eb58894e`](https://github.com/nodejs/node/commit/09eb58894e)] - **child_process**: fix handleless NODE_HANDLE handling (Santiago Gimeno) [#13235](https://github.com/nodejs/node/pull/13235)
* [[`16f2600ecf`](https://github.com/nodejs/node/commit/16f2600ecf)] - **child_process**: emit IPC messages on next tick (cjihrig) [#13856](https://github.com/nodejs/node/pull/13856)
* [[`dfc46e262a`](https://github.com/nodejs/node/commit/dfc46e262a)] - **(SEMVER-MINOR)** **cluster**: overriding inspector port (cornholio) [#14140](https://github.com/nodejs/node/pull/14140)
* [[`26f85e75f9`](https://github.com/nodejs/node/commit/26f85e75f9)] - **cluster**: remove obsolete todo (Ruben Bridgewater) [#13734](https://github.com/nodejs/node/pull/13734)
* [[`816f98f5d0`](https://github.com/nodejs/node/commit/816f98f5d0)] - **console**: use a plain object for the the error stack (Ruben Bridgewater) [#13743](https://github.com/nodejs/node/pull/13743)
* [[`932791063b`](https://github.com/nodejs/node/commit/932791063b)] - **(SEMVER-MINOR)** **deps**: hotfix to bump npx version (Kat Marchán) [#14235](https://github.com/nodejs/node/pull/14235)
* [[`dc3f6b9ac1`](https://github.com/nodejs/node/commit/dc3f6b9ac1)] - **(SEMVER-MINOR)** **deps**: upgrade npm to 5.3.0 (Kat Marchán) [#14235](https://github.com/nodejs/node/pull/14235)
* [[`fe6ca44f84`](https://github.com/nodejs/node/commit/fe6ca44f84)] - **deps**: upgrade libuv to 1.13.1 (cjihrig) [#14117](https://github.com/nodejs/node/pull/14117)
* [[`46cc80abf5`](https://github.com/nodejs/node/commit/46cc80abf5)] - **deps**: delete deps/icu-small/source/io (Ben Noordhuis) [#13656](https://github.com/nodejs/node/pull/13656)
* [[`6e30e2558e`](https://github.com/nodejs/node/commit/6e30e2558e)] - **(SEMVER-MINOR)** **dns**: add resolveAny support (XadillaX) [#13137](https://github.com/nodejs/node/pull/13137)
* [[`ebe7bb29aa`](https://github.com/nodejs/node/commit/ebe7bb29aa)] - **(SEMVER-MINOR)** **dns**: make `dns.setServers` support customized port (XadillaX) [#13723](https://github.com/nodejs/node/pull/13723)
* [[`7df10f529d`](https://github.com/nodejs/node/commit/7df10f529d)] - **doc**: fix inspectPort documentation in cluster.md (Anna Henningsen) [#14349](https://github.com/nodejs/node/pull/14349)
* [[`7a116d4a60`](https://github.com/nodejs/node/commit/7a116d4a60)] - **doc**: add guidance on testing new errors (Michael Dawson) [#14207](https://github.com/nodejs/node/pull/14207)
* [[`6f13d7da67`](https://github.com/nodejs/node/commit/6f13d7da67)] - **doc**: move LTS README link to increase prominence (Gibson Fahnestock) [#14259](https://github.com/nodejs/node/pull/14259)
* [[`c0703f0d4c`](https://github.com/nodejs/node/commit/c0703f0d4c)] - **(SEMVER-MINOR)** **doc**: fixes in cluster.md (cornholio) [#14140](https://github.com/nodejs/node/pull/14140)
* [[`e91a7a447d`](https://github.com/nodejs/node/commit/e91a7a447d)] - **doc**: update umask for clarity (James Sumners) [#14170](https://github.com/nodejs/node/pull/14170)
* [[`157ef23fc3`](https://github.com/nodejs/node/commit/157ef23fc3)] - **doc**: add notice about useGlobal option in repl docs (starkwang) [#13866](https://github.com/nodejs/node/pull/13866)
* [[`1b3cf97198`](https://github.com/nodejs/node/commit/1b3cf97198)] - **doc**: prefix of the stacktrace in errors.md (Roman Shoryn) [#14150](https://github.com/nodejs/node/pull/14150)
* [[`eb90ad61fb`](https://github.com/nodejs/node/commit/eb90ad61fb)] - **doc**: add missing space (Timothy Gu) [#14181](https://github.com/nodejs/node/pull/14181)
* [[`01b98a769f`](https://github.com/nodejs/node/commit/01b98a769f)] - **doc**: removed redundant mentions to error codes (jklepatch) [#13627](https://github.com/nodejs/node/pull/13627)
* [[`575dcdcf0e`](https://github.com/nodejs/node/commit/575dcdcf0e)] - **doc**: correct stream Duplex allowHalfOpen doc (Rich Trott) [#14127](https://github.com/nodejs/node/pull/14127)
* [[`cfa5e0c3b6`](https://github.com/nodejs/node/commit/cfa5e0c3b6)] - **doc**: note 'resize' event conditions on Windows (Dean Coakley) [#13576](https://github.com/nodejs/node/pull/13576)
* [[`217e1dc7b1`](https://github.com/nodejs/node/commit/217e1dc7b1)] - **doc**: fix mistake in http.md (Moogen Tian) [#14126](https://github.com/nodejs/node/pull/14126)
* [[`32ddb666b6`](https://github.com/nodejs/node/commit/32ddb666b6)] - **doc**: match debugger output & instructions to master behavior (Jan Krems) [#13885](https://github.com/nodejs/node/pull/13885)
* [[`9e6a4d6e27`](https://github.com/nodejs/node/commit/9e6a4d6e27)] - **doc**: add documentation on ICU (Timothy Gu) [#13916](https://github.com/nodejs/node/pull/13916)
* [[`23c67de3df`](https://github.com/nodejs/node/commit/23c67de3df)] - **doc**: fix padding mode of crypto.publicDecrypt (MoonBall) [#14036](https://github.com/nodejs/node/pull/14036)
* [[`99f0a6bdb5`](https://github.com/nodejs/node/commit/99f0a6bdb5)] - **doc**: add CTC members to Collaborators list (Rich Trott) [#13284](https://github.com/nodejs/node/pull/13284)
* [[`199e905249`](https://github.com/nodejs/node/commit/199e905249)] - **doc**: fix example in child_process.md (Ruslan Iusupov) [#13716](https://github.com/nodejs/node/pull/13716)
* [[`310040c89e`](https://github.com/nodejs/node/commit/310040c89e)] - **doc**: add default values to functions in fs.md (Matej Krajčovič) [#13767](https://github.com/nodejs/node/pull/13767)
* [[`26ed901730`](https://github.com/nodejs/node/commit/26ed901730)] - **doc**: fix some broken references (Alexander Gromnitsky) [#13811](https://github.com/nodejs/node/pull/13811)
* [[`e36561a828`](https://github.com/nodejs/node/commit/e36561a828)] - **doc**: move module-specific "globals" to modules.md (Tobias Nießen) [#13962](https://github.com/nodejs/node/pull/13962)
* [[`f1d92fb489`](https://github.com/nodejs/node/commit/f1d92fb489)] - **doc**: fix indentation issues in sample code (Rich Trott) [#13950](https://github.com/nodejs/node/pull/13950)
* [[`f53bfe4945`](https://github.com/nodejs/node/commit/f53bfe4945)] - **doc**: use stricter indentation checking for docs (Rich Trott) [#13950](https://github.com/nodejs/node/pull/13950)
* [[`adb0f4601d`](https://github.com/nodejs/node/commit/adb0f4601d)] - **doc**: note that fs.futimes only works on AIX \>7.1 (Gibson Fahnestock) [#13659](https://github.com/nodejs/node/pull/13659)
* [[`8fe77225ab`](https://github.com/nodejs/node/commit/8fe77225ab)] - **doc**: add @nodejs/documentation to CC table (Vse Mozhet Byt) [#13952](https://github.com/nodejs/node/pull/13952)
* [[`4c43ff271f`](https://github.com/nodejs/node/commit/4c43ff271f)] - **doc**: doc lifetime of n-api last error info (Michael Dawson) [#13939](https://github.com/nodejs/node/pull/13939)
* [[`7332e7ef5c`](https://github.com/nodejs/node/commit/7332e7ef5c)] - **doc**: add gireeshpunathil to collaborators (Gireesh Punathil) [#13967](https://github.com/nodejs/node/pull/13967)
* [[`9ff5212d5f`](https://github.com/nodejs/node/commit/9ff5212d5f)] - **doc**: fix mistake in path.relative (Tobias Nießen) [#13912](https://github.com/nodejs/node/pull/13912)
* [[`0fc7a5077f`](https://github.com/nodejs/node/commit/0fc7a5077f)] - **doc**: unify ERR_FALSY_VALUE_REJECTION description (Tobias Nießen) [#13869](https://github.com/nodejs/node/pull/13869)
* [[`502be7c085`](https://github.com/nodejs/node/commit/502be7c085)] - **doc**: fixed formatting issue in cli docs (Chris Young) [#13808](https://github.com/nodejs/node/pull/13808)
* [[`12b6765cd1`](https://github.com/nodejs/node/commit/12b6765cd1)] - **doc**: fix link in async_hooks.md (Azard) [#13930](https://github.com/nodejs/node/pull/13930)
* [[`04bca73bd7`](https://github.com/nodejs/node/commit/04bca73bd7)] - **doc**: add missing zlib link to stream API docs (Rob Wu) [#13838](https://github.com/nodejs/node/pull/13838)
* [[`f1b7e8d50d`](https://github.com/nodejs/node/commit/f1b7e8d50d)] - **doc**: fix nits in guides/using-internal-errors.md (Vse Mozhet Byt) [#13820](https://github.com/nodejs/node/pull/13820)
* [[`46756acb95`](https://github.com/nodejs/node/commit/46756acb95)] - **doc**: document res.connection and res.socket (Justin Beckwith) [#13617](https://github.com/nodejs/node/pull/13617)
* [[`70f3935130`](https://github.com/nodejs/node/commit/70f3935130)] - **doc**: fix api docs style (Daijiro Wachi) [#13700](https://github.com/nodejs/node/pull/13700)
* [[`820b011ed6`](https://github.com/nodejs/node/commit/820b011ed6)] - **doc**: update minimum g++ version to 4.9.4 (Ben Noordhuis) [#13466](https://github.com/nodejs/node/pull/13466)
* [[`d4a6ca6ed3`](https://github.com/nodejs/node/commit/d4a6ca6ed3)] - **doc, util, console**: clarify ambiguous docs (Natanael Log) [#14027](https://github.com/nodejs/node/pull/14027)
* [[`4f0eb6f024`](https://github.com/nodejs/node/commit/4f0eb6f024)] - **doc,test**: fs - reserved characters under win32 (XadillaX) [#13875](https://github.com/nodejs/node/pull/13875)
* [[`ad8b1588a2`](https://github.com/nodejs/node/commit/ad8b1588a2)] - **errors**: prevent stack recalculation (Ruben Bridgewater) [#13743](https://github.com/nodejs/node/pull/13743)
* [[`e8780ba7ae`](https://github.com/nodejs/node/commit/e8780ba7ae)] - **errors**: add missing ERR_ prefix on util.callbackify error (James M Snell) [#13750](https://github.com/nodejs/node/pull/13750)
* [[`2a02868934`](https://github.com/nodejs/node/commit/2a02868934)] - **fs**: two minor optimizations (Ruben Bridgewater) [#14055](https://github.com/nodejs/node/pull/14055)
* [[`4587f21716`](https://github.com/nodejs/node/commit/4587f21716)] - **gyp**: implement LD/LDXX for ninja and FIPS (Sam Roberts) [#14227](https://github.com/nodejs/node/pull/14227)
* [[`63aee3b4c8`](https://github.com/nodejs/node/commit/63aee3b4c8)] - **http**: OutgoingMessage change writable after end (Roee Kasher) [#14024](https://github.com/nodejs/node/pull/14024)
* [[`c652845a61`](https://github.com/nodejs/node/commit/c652845a61)] - **http**: guard against failed sockets creation (Refael Ackermann) [#13839](https://github.com/nodejs/node/pull/13839)
* [[`b22a04b2c6`](https://github.com/nodejs/node/commit/b22a04b2c6)] - **http**: always cork outgoing writes (Brian White) [#13522](https://github.com/nodejs/node/pull/13522)
* [[`74741fa52b`](https://github.com/nodejs/node/commit/74741fa52b)] - **(SEMVER-MINOR)** **https**: make opts optional & immutable when create (XadillaX) [#13599](https://github.com/nodejs/node/pull/13599)
* [[`a45792a383`](https://github.com/nodejs/node/commit/a45792a383)] - **inspector**: perform DNS lookup for host (Eugene Ostroukhov) [#13478](https://github.com/nodejs/node/pull/13478)
* [[`b0db2b9fc2`](https://github.com/nodejs/node/commit/b0db2b9fc2)] - **inspector, test**: Fix test bug detected by Coverity (Eugene Ostroukhov) [#13799](https://github.com/nodejs/node/pull/13799)
* [[`6361565915`](https://github.com/nodejs/node/commit/6361565915)] - **lib**: update indentation of ternaries (Rich Trott) [#14247](https://github.com/nodejs/node/pull/14247)
* [[`b12b8c2f7c`](https://github.com/nodejs/node/commit/b12b8c2f7c)] - **lib**: normalize indentation in parentheses (Rich Trott) [#14125](https://github.com/nodejs/node/pull/14125)
* [[`a0866b6b0c`](https://github.com/nodejs/node/commit/a0866b6b0c)] - **lib**: remove excess indentation (Rich Trott) [#14090](https://github.com/nodejs/node/pull/14090)
* [[`07642552cb`](https://github.com/nodejs/node/commit/07642552cb)] - **lib**: use consistent indentation for ternaries (Rich Trott) [#14078](https://github.com/nodejs/node/pull/14078)
* [[`4bb1a3a8ac`](https://github.com/nodejs/node/commit/4bb1a3a8ac)] - **lib**: fix typos (Ruben Bridgewater) [#14044](https://github.com/nodejs/node/pull/14044)
* [[`3bd18c51e0`](https://github.com/nodejs/node/commit/3bd18c51e0)] - **n-api**: add napi_fatal_error API (Kyle Farnung) [#13971](https://github.com/nodejs/node/pull/13971)
* [[`b1eb6d5485`](https://github.com/nodejs/node/commit/b1eb6d5485)] - **n-api**: wrap test macros in do/while (Kyle Farnung) [#14095](https://github.com/nodejs/node/pull/14095)
* [[`f2054f330a`](https://github.com/nodejs/node/commit/f2054f330a)] - **n-api**: Implement stricter wrapping (Gabriel Schulhof) [#13872](https://github.com/nodejs/node/pull/13872)
* [[`e25c5ef7da`](https://github.com/nodejs/node/commit/e25c5ef7da)] - **n-api**: fix warning in test_general (Daniel Bevenius) [#14104](https://github.com/nodejs/node/pull/14104)
* [[`2a86650562`](https://github.com/nodejs/node/commit/2a86650562)] - **n-api**: add napi_has_own_property() (cjihrig) [#14063](https://github.com/nodejs/node/pull/14063)
* [[`f3933049e5`](https://github.com/nodejs/node/commit/f3933049e5)] - **n-api**: fix -Wmaybe-uninitialized compiler warning (Ben Noordhuis) [#14053](https://github.com/nodejs/node/pull/14053)
* [[`de744ba232`](https://github.com/nodejs/node/commit/de744ba232)] - **n-api**: use Maybe version of Object::SetPrototype() (Ben Noordhuis) [#14053](https://github.com/nodejs/node/pull/14053)
* [[`820d97df5d`](https://github.com/nodejs/node/commit/820d97df5d)] - **n-api**: add napi_delete_property() (cjihrig) [#13934](https://github.com/nodejs/node/pull/13934)
* [[`6316c9a0f8`](https://github.com/nodejs/node/commit/6316c9a0f8)] - **n-api**: add napi_delete_element() (cjihrig) [#13949](https://github.com/nodejs/node/pull/13949)
* [[`4843d4da8c`](https://github.com/nodejs/node/commit/4843d4da8c)] - **n-api**: fix section title typo (Kyle Farnung) [#13972](https://github.com/nodejs/node/pull/13972)
* [[`a839aede3e`](https://github.com/nodejs/node/commit/a839aede3e)] - **(SEMVER-MINOR)** **net**: return this from getConnections() (Sam Roberts) [#13553](https://github.com/nodejs/node/pull/13553)
* [[`69f806cc55`](https://github.com/nodejs/node/commit/69f806cc55)] - **(SEMVER-MINOR)** **net**: return this from destroy() (Sam Roberts) [#13530](https://github.com/nodejs/node/pull/13530)
* [[`e30fc2c5ba`](https://github.com/nodejs/node/commit/e30fc2c5ba)] - **process**: improve nextTick() performance (Brian White) [#13446](https://github.com/nodejs/node/pull/13446)
* [[`c56a89013c`](https://github.com/nodejs/node/commit/c56a89013c)] - **querystring**: fix up lastPos usage (Timothy Gu) [#14151](https://github.com/nodejs/node/pull/14151)
* [[`b4b27b2edd`](https://github.com/nodejs/node/commit/b4b27b2edd)] - **readline**: properly handle 0-width characters (Timothy Gu) [#13918](https://github.com/nodejs/node/pull/13918)
* [[`3683f6b787`](https://github.com/nodejs/node/commit/3683f6b787)] - **repl**: fix crash with large buffer tab completion (XadillaX) [#13817](https://github.com/nodejs/node/pull/13817)
* [[`f237ad55ff`](https://github.com/nodejs/node/commit/f237ad55ff)] - **src**: fix memory leak in DH key setters (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`0bbdb78962`](https://github.com/nodejs/node/commit/0bbdb78962)] - **src**: reduce allocations in exportPublicKey() (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`e4b70199b3`](https://github.com/nodejs/node/commit/e4b70199b3)] - **src**: guard against double free in randomBytes() (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`ad0669bfe6`](https://github.com/nodejs/node/commit/ad0669bfe6)] - **src**: simplify PBKDF2Request (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`8f4b84ba42`](https://github.com/nodejs/node/commit/8f4b84ba42)] - **src**: remove PBKDF2Request::release() (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`b5802c7bf1`](https://github.com/nodejs/node/commit/b5802c7bf1)] - **src**: avoid heap allocation in crypto.pbkdf2() (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`1c3e090eba`](https://github.com/nodejs/node/commit/1c3e090eba)] - **src**: make array arg length compile-time checkable (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`41f79fb22f`](https://github.com/nodejs/node/commit/41f79fb22f)] - **src**: refactor PBKDF2Request (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`233740c594`](https://github.com/nodejs/node/commit/233740c594)] - **src**: remove extra heap allocations in DH functions (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`8e51d3151d`](https://github.com/nodejs/node/commit/8e51d3151d)] - **src**: avoid heap allocation in hmac.digest() (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`8be9bd139f`](https://github.com/nodejs/node/commit/8be9bd139f)] - **src**: remove extra heap allocation in GetSession() (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`8dd6866303`](https://github.com/nodejs/node/commit/8dd6866303)] - **src**: make CipherBase::kind_ const (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`0fcb8b1029`](https://github.com/nodejs/node/commit/0fcb8b1029)] - **src**: remove unused Local (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`db65422f0d`](https://github.com/nodejs/node/commit/db65422f0d)] - **src**: remove superfluous cipher_ data member (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`1af064bf7c`](https://github.com/nodejs/node/commit/1af064bf7c)] - **src**: don't heap allocate GCM cipher auth tag (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`174f8c8d91`](https://github.com/nodejs/node/commit/174f8c8d91)] - **src**: avoid heap allocation in sign.final() (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`efb7aef676`](https://github.com/nodejs/node/commit/efb7aef676)] - **src**: remove unneeded const_cast (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`2ee31aa261`](https://github.com/nodejs/node/commit/2ee31aa261)] - **src**: remove extra heap allocations in CipherBase (Ben Noordhuis) [#14122](https://github.com/nodejs/node/pull/14122)
* [[`50913b168d`](https://github.com/nodejs/node/commit/50913b168d)] - **(SEMVER-MINOR)** **src**: whitelist v8 options with `'_'` or `'-'` (Sam Roberts) [#14093](https://github.com/nodejs/node/pull/14093)
* [[`b799498e8a`](https://github.com/nodejs/node/commit/b799498e8a)] - **src**: document --abort-on-uncaught-exception (Sam Roberts) [#13931](https://github.com/nodejs/node/pull/13931)
* [[`21ee4b1b97`](https://github.com/nodejs/node/commit/21ee4b1b97)] - **src**: --abort-on-uncaught-exception in NODE_OPTIONS (Sam Roberts) [#13932](https://github.com/nodejs/node/pull/13932)
* [[`ef67f7c8ca`](https://github.com/nodejs/node/commit/ef67f7c8ca)] - **src**: move crypto_bio/clienthello to crypto ns (Daniel Bevenius) [#13957](https://github.com/nodejs/node/pull/13957)
* [[`dff506c5c5`](https://github.com/nodejs/node/commit/dff506c5c5)] - **src**: add missing new line to printed message (Timothy Gu) [#13940](https://github.com/nodejs/node/pull/13940)
* [[`98cb59e9f0`](https://github.com/nodejs/node/commit/98cb59e9f0)] - **src**: revise character width calculation (Timothy Gu) [#13918](https://github.com/nodejs/node/pull/13918)
* [[`5579bc8fb6`](https://github.com/nodejs/node/commit/5579bc8fb6)] - **src,fs**: calculate times as unsigned long (Refael Ackermann) [#13281](https://github.com/nodejs/node/pull/13281)
* [[`864abc567e`](https://github.com/nodejs/node/commit/864abc567e)] - **src,lib,test,doc**: correct misspellings (Roman Reiss) [#13719](https://github.com/nodejs/node/pull/13719)
* [[`6eb53e5611`](https://github.com/nodejs/node/commit/6eb53e5611)] - **stream**: avoid possible slow path w UInt8Array (Matteo Collina) [#13956](https://github.com/nodejs/node/pull/13956)
* [[`6512fd7614`](https://github.com/nodejs/node/commit/6512fd7614)] - **stream**: improve Transform performance (Brian White) [#13322](https://github.com/nodejs/node/pull/13322)
* [[`86e55eff27`](https://github.com/nodejs/node/commit/86e55eff27)] - **test**: add test for http outgoing internal headers (Gergely Nemeth) [#13980](https://github.com/nodejs/node/pull/13980)
* [[`0f52b41cbd`](https://github.com/nodejs/node/commit/0f52b41cbd)] - **test**: use regex error check in test-crypto-random (Zhang Weijie) [#14273](https://github.com/nodejs/node/pull/14273)
* [[`bf663a8550`](https://github.com/nodejs/node/commit/bf663a8550)] - **test**: check error with regex in test-signal-safety (shaman) [#14285](https://github.com/nodejs/node/pull/14285)
* [[`784102f2d1`](https://github.com/nodejs/node/commit/784102f2d1)] - **test**: use regex error checks in test-util-format (Superwoods) [#14299](https://github.com/nodejs/node/pull/14299)
* [[`f9b292c954`](https://github.com/nodejs/node/commit/f9b292c954)] - **test**: change style in test-cli-bad-options (boydfd) [#14274](https://github.com/nodejs/node/pull/14274)
* [[`9257e7ef70`](https://github.com/nodejs/node/commit/9257e7ef70)] - **test**: use template literals in test-writewrap (vercent deng) [#14292](https://github.com/nodejs/node/pull/14292)
* [[`f5e8342057`](https://github.com/nodejs/node/commit/f5e8342057)] - **test**: improve regexps for error checking (xinglong.wangwxl) [#14271](https://github.com/nodejs/node/pull/14271)
* [[`337a8652c7`](https://github.com/nodejs/node/commit/337a8652c7)] - **test**: replace string concatenation with template (weiyuanyue) [#14279](https://github.com/nodejs/node/pull/14279)
* [[`85c181ab78`](https://github.com/nodejs/node/commit/85c181ab78)] - **test**: use template literals as appropriate (blade254353074) [#14289](https://github.com/nodejs/node/pull/14289)
* [[`65bccd519e`](https://github.com/nodejs/node/commit/65bccd519e)] - **test**: use template literal for string concat (tobewhatwewant) [#14288](https://github.com/nodejs/node/pull/14288)
* [[`802783d34a`](https://github.com/nodejs/node/commit/802783d34a)] - **test**: simplify string concatenation (jiangplus) [#14278](https://github.com/nodejs/node/pull/14278)
* [[`76a4671729`](https://github.com/nodejs/node/commit/76a4671729)] - **test**: use regexp to confir error message (Bang Wu) [#14268](https://github.com/nodejs/node/pull/14268)
* [[`e37510a0c7`](https://github.com/nodejs/node/commit/e37510a0c7)] - **test**: use regluar expression in vm test (akira.xue) [#14266](https://github.com/nodejs/node/pull/14266)
* [[`a338b94214`](https://github.com/nodejs/node/commit/a338b94214)] - **test**: use regular expression to match error msg (Flandre) [#14265](https://github.com/nodejs/node/pull/14265)
* [[`c8087c05e8`](https://github.com/nodejs/node/commit/c8087c05e8)] - **test**: replace string concat with template literal (Song, Bintao Garfield) [#14269](https://github.com/nodejs/node/pull/14269)
* [[`c44d899ca1`](https://github.com/nodejs/node/commit/c44d899ca1)] - **test**: check complete error message (Fraser Xu) [#14264](https://github.com/nodejs/node/pull/14264)
* [[`bf9457276b`](https://github.com/nodejs/node/commit/bf9457276b)] - **test**: fix flaky test-net-can-reset-timeout (Rich Trott) [#14257](https://github.com/nodejs/node/pull/14257)
* [[`9efd328d5d`](https://github.com/nodejs/node/commit/9efd328d5d)] - **test**: disable MultipleEnvironmentsPerIsolate (Refael Ackermann) [#14246](https://github.com/nodejs/node/pull/14246)
* [[`724e7e1acf`](https://github.com/nodejs/node/commit/724e7e1acf)] - **test**: make common.PIPE process unique (Refael Ackermann) [#14168](https://github.com/nodejs/node/pull/14168)
* [[`d651a01641`](https://github.com/nodejs/node/commit/d651a01641)] - **(SEMVER-MINOR)** **test**: reduce offset in test-inspector-port-cluster (cornholio) [#14140](https://github.com/nodejs/node/pull/14140)
* [[`f5bea638df`](https://github.com/nodejs/node/commit/f5bea638df)] - **test**: http outgoing \_renderHeaders (Peter Czibik) [#13981](https://github.com/nodejs/node/pull/13981)
* [[`1671fe4506`](https://github.com/nodejs/node/commit/1671fe4506)] - **test**: decrease duration of test-cli-syntax (Evan Lucas) [#14187](https://github.com/nodejs/node/pull/14187)
* [[`3fcc7e6772`](https://github.com/nodejs/node/commit/3fcc7e6772)] - **test**: handle missing V8 tests in n-api test (cjihrig) [#14123](https://github.com/nodejs/node/pull/14123)
* [[`3bc713e45a`](https://github.com/nodejs/node/commit/3bc713e45a)] - **test**: reduce run time for test-benchmark-crypto (Rich Trott) [#14189](https://github.com/nodejs/node/pull/14189)
* [[`73257045a5`](https://github.com/nodejs/node/commit/73257045a5)] - **test**: reduce run time for test-benchmark-http (Rich Trott) [#14180](https://github.com/nodejs/node/pull/14180)
* [[`cd9eba9da8`](https://github.com/nodejs/node/commit/cd9eba9da8)] - **test**: reduce test-benchmark-net run duration (Rich Trott) [#14183](https://github.com/nodejs/node/pull/14183)
* [[`de842498fa`](https://github.com/nodejs/node/commit/de842498fa)] - **test**: fix flaky test-https-set-timeout-server (Rich Trott) [#14134](https://github.com/nodejs/node/pull/14134)
* [[`e879a56aec`](https://github.com/nodejs/node/commit/e879a56aec)] - **test**: remove common.noop (Rich Trott) [#12822](https://github.com/nodejs/node/pull/12822)
* [[`697ea62f39`](https://github.com/nodejs/node/commit/697ea62f39)] - **test**: add get/set effective uid/gid tests (Evan Lucas) [#14091](https://github.com/nodejs/node/pull/14091)
* [[`d0e4e2b5c5`](https://github.com/nodejs/node/commit/d0e4e2b5c5)] - **test**: fix cctest failure on Windows (Jimmy Thomson) [#14111](https://github.com/nodejs/node/pull/14111)
* [[`e080fb349e`](https://github.com/nodejs/node/commit/e080fb349e)] - **test**: ignore connection errors for hostname check (Refael Ackermann) [#14073](https://github.com/nodejs/node/pull/14073)
* [[`9cfa52a568`](https://github.com/nodejs/node/commit/9cfa52a568)] - **test**: check and fail inspector-cluster-port-clash (Daniel Bevenius) [#14074](https://github.com/nodejs/node/pull/14074)
* [[`2a91d59c49`](https://github.com/nodejs/node/commit/2a91d59c49)] - **test**: add coverage for napi_typeof (Michael Dawson) [#13990](https://github.com/nodejs/node/pull/13990)
* [[`e71b98f9f7`](https://github.com/nodejs/node/commit/e71b98f9f7)] - **test**: restore no-op function in test (Rich Trott) [#14065](https://github.com/nodejs/node/pull/14065)
* [[`d288cf10cc`](https://github.com/nodejs/node/commit/d288cf10cc)] - **test**: skip test-fs-readdir-ucs2 if no support (Rich Trott) [#14029](https://github.com/nodejs/node/pull/14029)
* [[`32a8f368ab`](https://github.com/nodejs/node/commit/32a8f368ab)] - **test**: simplify test skipping (Vse Mozhet Byt) [#14021](https://github.com/nodejs/node/pull/14021)
* [[`0cc12fc646`](https://github.com/nodejs/node/commit/0cc12fc646)] - **test**: fix require nits in some test-tls-* tests (Vse Mozhet Byt) [#14008](https://github.com/nodejs/node/pull/14008)
* [[`0707a6b2b5`](https://github.com/nodejs/node/commit/0707a6b2b5)] - **test**: refactor test-http-hostname-typechecking (Rich Trott) [#13993](https://github.com/nodejs/node/pull/13993)
* [[`534ae446c6`](https://github.com/nodejs/node/commit/534ae446c6)] - **test**: refactor test-http(s)-set-timeout-server (Alexey Orlenko) [#13935](https://github.com/nodejs/node/pull/13935)
* [[`81c644795d`](https://github.com/nodejs/node/commit/81c644795d)] - **test**: refactor test-http-invalidheaderfield (Rich Trott) [#13996](https://github.com/nodejs/node/pull/13996)
* [[`8edde98f16`](https://github.com/nodejs/node/commit/8edde98f16)] - **test**: change var to const in ./common (Ruben Bridgewater) [#13732](https://github.com/nodejs/node/pull/13732)
* [[`cfb6f94b30`](https://github.com/nodejs/node/commit/cfb6f94b30)] - **test**: mark test-npm-install flaky on arm (Refael Ackermann) [#14035](https://github.com/nodejs/node/pull/14035)
* [[`50ee4bd598`](https://github.com/nodejs/node/commit/50ee4bd598)] - **test**: replace indexOf with includes and startsWith (Nataly Shrits) [#13852](https://github.com/nodejs/node/pull/13852)
* [[`f1ef692454`](https://github.com/nodejs/node/commit/f1ef692454)] - **test**: refactor test-fs-options-immutable (Rich Trott) [#13977](https://github.com/nodejs/node/pull/13977)
* [[`bb198dcda9`](https://github.com/nodejs/node/commit/bb198dcda9)] - **test**: refactor test-crypto-pbkdf2 (Rich Trott) [#13975](https://github.com/nodejs/node/pull/13975)
* [[`4ba1d32609`](https://github.com/nodejs/node/commit/4ba1d32609)] - **test**: remove undef NDEBUG from at-exit addons test (Daniel Bevenius) [#13998](https://github.com/nodejs/node/pull/13998)
* [[`f400939206`](https://github.com/nodejs/node/commit/f400939206)] - **test**: verify napi_get_property() walks prototype (cjihrig) [#13961](https://github.com/nodejs/node/pull/13961)
* [[`100ccf9ad4`](https://github.com/nodejs/node/commit/100ccf9ad4)] - **test**: refactor test-fs-watchfile (Rich Trott) [#13721](https://github.com/nodejs/node/pull/13721)
* [[`f7383eb80e`](https://github.com/nodejs/node/commit/f7383eb80e)] - **test**: verify isNativeError accepts internal errors (cjihrig) [#13965](https://github.com/nodejs/node/pull/13965)
* [[`071ecb0dd2`](https://github.com/nodejs/node/commit/071ecb0dd2)] - **test**: refactor test-child-process-send-type-error (Rich Trott) [#13904](https://github.com/nodejs/node/pull/13904)
* [[`e5d32b8b13`](https://github.com/nodejs/node/commit/e5d32b8b13)] - **test**: mark test-fs-readdir-ucs2 flaky (João Reis) [#13989](https://github.com/nodejs/node/pull/13989)
* [[`fa9e647385`](https://github.com/nodejs/node/commit/fa9e647385)] - **test**: fix failure in test-icu-data-dir.js (Tobias Nießen) [#13987](https://github.com/nodejs/node/pull/13987)
* [[`b43547acc6`](https://github.com/nodejs/node/commit/b43547acc6)] - **test**: refactor test-cluster-basic (Rich Trott) [#13905](https://github.com/nodejs/node/pull/13905)
* [[`98ec8aaa30`](https://github.com/nodejs/node/commit/98ec8aaa30)] - **test**: refactor test-vm-sigint (Rich Trott) [#13902](https://github.com/nodejs/node/pull/13902)
* [[`949d1b1d4a`](https://github.com/nodejs/node/commit/949d1b1d4a)] - **test**: refactor test-tls-two-cas-one-string (Rich Trott) [#13896](https://github.com/nodejs/node/pull/13896)
* [[`c4018e8a48`](https://github.com/nodejs/node/commit/c4018e8a48)] - **test**: remove unneeded HandleScope usage (Ezequiel Garcia) [#13859](https://github.com/nodejs/node/pull/13859)
* [[`6120a0de6c`](https://github.com/nodejs/node/commit/6120a0de6c)] - **test**: skip fips tests using OpenSSL config file (Daniel Bevenius) [#13786](https://github.com/nodejs/node/pull/13786)
* [[`74aed0b6bd`](https://github.com/nodejs/node/commit/74aed0b6bd)] - **test**: refactor test-tls-invoked-queued (Rich Trott) [#13893](https://github.com/nodejs/node/pull/13893)
* [[`a767367123`](https://github.com/nodejs/node/commit/a767367123)] - **test**: refactor test-tls-env-extra-ca (Rich Trott) [#13886](https://github.com/nodejs/node/pull/13886)
* [[`265957334c`](https://github.com/nodejs/node/commit/265957334c)] - **test**: make http(s)-set-timeout-server more similar (Julien Klepatch) [#13822](https://github.com/nodejs/node/pull/13822)
* [[`587c905d11`](https://github.com/nodejs/node/commit/587c905d11)] - **test**: check uv_ip4_addr return value (Eugene Ostroukhov) [#13878](https://github.com/nodejs/node/pull/13878)
* [[`005e343339`](https://github.com/nodejs/node/commit/005e343339)] - **test**: remove `require('buffer')` from 4 test files (XadillaX) [#13844](https://github.com/nodejs/node/pull/13844)
* [[`df3c2929b9`](https://github.com/nodejs/node/commit/df3c2929b9)] - **test**: remove unnecessary require('buffer').Buffer (lena) [#13851](https://github.com/nodejs/node/pull/13851)
* [[`ec3761b1da`](https://github.com/nodejs/node/commit/ec3761b1da)] - **test**: remove `require('buffer')` from 4 test files (Zongmin Lei) [#13846](https://github.com/nodejs/node/pull/13846)
* [[`c3c6699bb3`](https://github.com/nodejs/node/commit/c3c6699bb3)] - **test**: remove require('buffer') from 4 buffer tests (OriLev) [#13855](https://github.com/nodejs/node/pull/13855)
* [[`4a6604193f`](https://github.com/nodejs/node/commit/4a6604193f)] - **test**: remove require('buffer') on 6 fs test files (sallen450) [#13845](https://github.com/nodejs/node/pull/13845)
* [[`76cdaec2b3`](https://github.com/nodejs/node/commit/76cdaec2b3)] - **test**: remove unnecessary Buffer import (Steven Winston) [#13860](https://github.com/nodejs/node/pull/13860)
* [[`b15378cc90`](https://github.com/nodejs/node/commit/b15378cc90)] - **test**: improve async-hooks/test-callback-error (Refael Ackermann) [#13559](https://github.com/nodejs/node/pull/13559)
* [[`7e3bab779a`](https://github.com/nodejs/node/commit/7e3bab779a)] - **test**: use string instead of RegExp in split() (Vse Mozhet Byt) [#13710](https://github.com/nodejs/node/pull/13710)
* [[`0e857a5ee4`](https://github.com/nodejs/node/commit/0e857a5ee4)] - **test**: remove needless RegExp flags (Vse Mozhet Byt) [#13690](https://github.com/nodejs/node/pull/13690)
* [[`022c6d080c`](https://github.com/nodejs/node/commit/022c6d080c)] - **test**: add crypto check to test-tls-wrap-econnreset (Daniel Bevenius) [#13691](https://github.com/nodejs/node/pull/13691)
* [[`bf22514ae4`](https://github.com/nodejs/node/commit/bf22514ae4)] - **test**: increase util.callbackify() coverage (cjihrig) [#13705](https://github.com/nodejs/node/pull/13705)
* [[`b717609e86`](https://github.com/nodejs/node/commit/b717609e86)] - **test,async_hooks**: match test-ttywrap.readstream (Trevor Norris) [#13991](https://github.com/nodejs/node/pull/13991)
* [[`1fc5c29f28`](https://github.com/nodejs/node/commit/1fc5c29f28)] - **test,async_hooks**: skip whether TTY is available (Trevor Norris) [#13991](https://github.com/nodejs/node/pull/13991)
* [[`3d9bc01734`](https://github.com/nodejs/node/commit/3d9bc01734)] - **test,async_hooks**: stabilize tests on Windows (Refael Ackermann) [#13381](https://github.com/nodejs/node/pull/13381)
* [[`b9e07f9fec`](https://github.com/nodejs/node/commit/b9e07f9fec)] - **test,fs**: delay unlink in test-regress-GH-4027.js (Jaime Bernardo) [#14010](https://github.com/nodejs/node/pull/14010)
* [[`e2d325403f`](https://github.com/nodejs/node/commit/e2d325403f)] - **(SEMVER-MINOR)** **tls**: add host and port info to ECONNRESET errors (José F. Romaniello) [#7476](https://github.com/nodejs/node/pull/7476)
* [[`55438024a6`](https://github.com/nodejs/node/commit/55438024a6)] - **tools**: update package.json `engine` field (AJ Jordan) [#14165](https://github.com/nodejs/node/pull/14165)
* [[`36c267cbe9`](https://github.com/nodejs/node/commit/36c267cbe9)] - **tools**: increase test timeouts (Rich Trott) [#14197](https://github.com/nodejs/node/pull/14197)
* [[`ef53149203`](https://github.com/nodejs/node/commit/ef53149203)] - **tools**: update ESLint to 4.2.0 (Rich Trott) [#14155](https://github.com/nodejs/node/pull/14155)
* [[`b97e140241`](https://github.com/nodejs/node/commit/b97e140241)] - **tools**: generate template literal for addon tests (Rich Trott) [#14094](https://github.com/nodejs/node/pull/14094)
* [[`e17fb82c06`](https://github.com/nodejs/node/commit/e17fb82c06)] - **tools**: fix error in eslintrc comment (Rich Trott) [#14108](https://github.com/nodejs/node/pull/14108)
* [[`f8d76dcc82`](https://github.com/nodejs/node/commit/f8d76dcc82)] - **tools**: remove align-multiline-assignment lint rule (Rich Trott) [#14079](https://github.com/nodejs/node/pull/14079)
* [[`7d7da98703`](https://github.com/nodejs/node/commit/7d7da98703)] - **tools**: eslint - use `error` and `off` (Refael Ackermann) [#14061](https://github.com/nodejs/node/pull/14061)
* [[`aa4a700ddb`](https://github.com/nodejs/node/commit/aa4a700ddb)] - **tools**: update: eslint-plugin-markdown@1.0.0-beta.7 (Vse Mozhet Byt) [#14047](https://github.com/nodejs/node/pull/14047)
* [[`e03774236a`](https://github.com/nodejs/node/commit/e03774236a)] - **tools**: use no-use-before-define ESLint rule (Vse Mozhet Byt) [#14032](https://github.com/nodejs/node/pull/14032)
* [[`d69527f426`](https://github.com/nodejs/node/commit/d69527f426)] - **tools**: change var to const in ./eslint-rules (Ruben Bridgewater) [#13732](https://github.com/nodejs/node/pull/13732)
* [[`d454add7ce`](https://github.com/nodejs/node/commit/d454add7ce)] - **tools**: change var to const in ./doc/html (Ruben Bridgewater) [#13732](https://github.com/nodejs/node/pull/13732)
* [[`7ed7b22e67`](https://github.com/nodejs/node/commit/7ed7b22e67)] - **tools**: change var to const in ./license2rtf (Ruben Bridgewater) [#13732](https://github.com/nodejs/node/pull/13732)
* [[`f3bff93e21`](https://github.com/nodejs/node/commit/f3bff93e21)] - **tools**: change var to const in ./doc/preprocess (Ruben Bridgewater) [#13732](https://github.com/nodejs/node/pull/13732)
* [[`148f49fcdc`](https://github.com/nodejs/node/commit/148f49fcdc)] - **tools**: change var to const in ./doc/json (Ruben Bridgewater) [#13732](https://github.com/nodejs/node/pull/13732)
* [[`b89c27d360`](https://github.com/nodejs/node/commit/b89c27d360)] - **tools**: change var to const in ./doc/addon-verify (Ruben Bridgewater) [#13732](https://github.com/nodejs/node/pull/13732)
* [[`17636f64db`](https://github.com/nodejs/node/commit/17636f64db)] - **tools**: update to ESLint 4.1.1 (Rich Trott) [#13946](https://github.com/nodejs/node/pull/13946)
* [[`42ef8f9161`](https://github.com/nodejs/node/commit/42ef8f9161)] - **tools**: remove comment in eslint rule (Daniel Bevenius) [#13945](https://github.com/nodejs/node/pull/13945)
* [[`84b1641182`](https://github.com/nodejs/node/commit/84b1641182)] - **tools**: disable legacy indentation linting in tools (Rich Trott) [#13895](https://github.com/nodejs/node/pull/13895)
* [[`c732bf613d`](https://github.com/nodejs/node/commit/c732bf613d)] - **tools**: add script to update ESLint (Rich Trott) [#13895](https://github.com/nodejs/node/pull/13895)
* [[`6a5c37655d`](https://github.com/nodejs/node/commit/6a5c37655d)] - **tools**: update to ESLint 4.1.0 (Rich Trott) [#13895](https://github.com/nodejs/node/pull/13895)
* [[`4ecff6cad7`](https://github.com/nodejs/node/commit/4ecff6cad7)] - **tools,benchmark**: use stricter indentation linting (Rich Trott) [#13895](https://github.com/nodejs/node/pull/13895)
* [[`d23c49f951`](https://github.com/nodejs/node/commit/d23c49f951)] - **url**: do not use HandleScope in ToObject (Bradley Farias) [#14096](https://github.com/nodejs/node/pull/14096)
* [[`cf6afe3331`](https://github.com/nodejs/node/commit/cf6afe3331)] - **url**: normalize port on scheme change (Timothy Gu) [#13997](https://github.com/nodejs/node/pull/13997)
* [[`783cf50a76`](https://github.com/nodejs/node/commit/783cf50a76)] - **util**: delete unused argument 'depth' (kadoufall) [#14267](https://github.com/nodejs/node/pull/14267)
* [[`a675c3d3b7`](https://github.com/nodejs/node/commit/a675c3d3b7)] - **util**: remove redundant declaration (Vse Mozhet Byt) [#14199](https://github.com/nodejs/node/pull/14199)
* [[`8cba959a93`](https://github.com/nodejs/node/commit/8cba959a93)] - **util**: add callbackify (Refael Ackermann) [#13750](https://github.com/nodejs/node/pull/13750)

<a id="8.1.4"></a>
## 2017-07-11, Version 8.1.4 (Current), @evanlucas

This is a security release. All Node.js users should consult the security release summary at https://nodejs.org/en/blog/vulnerability/july-2017-security-releases/ for details on patched vulnerabilities.

### Notable changes

* **build**:
  - Disable V8 snapshots - The hashseed embedded in the snapshot is currently the same for all runs of the binary. This opens node up to collision attacks which could result in a Denial of Service. We have temporarily disabled snapshots until a more robust solution is found (Ali Ijaz Sheikh)
* **deps**:
  - CVE-2017-1000381 - The c-ares function ares_parse_naptr_reply(), which is used for parsing NAPTR responses, could be triggered to read memory outside of the given input buffer if the passed in DNS response packet was crafted in a particular way. This patch checks that there is enough data for the required elements of an NAPTR record (2 int16, 3 bytes for string lengths) before processing a record. (David Drysdale)

### Commits

* [[`51d69d2bec`](https://github.com/nodejs/node/commit/51d69d2bec)] - **build**: disable V8 snapshots (Ali Ijaz Sheikh) [nodejs/node-private#84](https://github.com/nodejs/node-private/pull/84)
* [[`d70fac47af`](https://github.com/nodejs/node/commit/d70fac47af)] - **deps**: cherry-pick 9478908a49 from cares upstream (David Drysdale) [nodejs/node-private#88](https://github.com/nodejs/node-private/pull/88)
* [[`803d689873`](https://github.com/nodejs/node/commit/803d689873)] - **test**: verify hash seed uniqueness (Ali Ijaz Sheikh) [nodejs/node-private#84](https://github.com/nodejs/node-private/pull/84)

<a id="8.1.3"></a>
## 2017-06-29, Version 8.1.3 (Current), @addaleax

### Notable changes

* **Stream**
  Two regressions with the `stream` module have been fixed:
  * The `finish` event will now always be emitted after the `error` event
    if one is emitted:
    [[`0a9e96e86c`](https://github.com/nodejs/node/commit/0a9e96e86c)]
    [#13850](https://github.com/nodejs/node/pull/13850)
  * In object mode, readable streams can now use `undefined` again.
    [[`5840138e70`](https://github.com/nodejs/node/commit/5840138e70)]
    [#13760](https://github.com/nodejs/node/pull/13760)

### Commits

* [[`11f45623ac`](https://github.com/nodejs/node/commit/11f45623ac)] - **benchmark**: remove needless RegExp capturing (Vse Mozhet Byt) [#13718](https://github.com/nodejs/node/pull/13718)
* [[`2ce236e173`](https://github.com/nodejs/node/commit/2ce236e173)] - **build**: check for linter in bin rather than lib (Rich Trott) [#13645](https://github.com/nodejs/node/pull/13645)
* [[`18f073f0fe`](https://github.com/nodejs/node/commit/18f073f0fe)] - **build**: fail linter if linting not available (Gibson Fahnestock) [#13658](https://github.com/nodejs/node/pull/13658)
* [[`465bd48b14`](https://github.com/nodejs/node/commit/465bd48b14)] - **configure**: add mips64el to valid_arch (Aditya Anand) [#13620](https://github.com/nodejs/node/pull/13620)
* [[`1fe455f525`](https://github.com/nodejs/node/commit/1fe455f525)] - **dgram**: change parameter name in set(Multicast)TTL (Tobias Nießen) [#13747](https://github.com/nodejs/node/pull/13747)
* [[`a63e54a94c`](https://github.com/nodejs/node/commit/a63e54a94c)] - **doc**: update backporting guide (Refael Ackermann) [#13749](https://github.com/nodejs/node/pull/13749)
* [[`0bb53a7aa2`](https://github.com/nodejs/node/commit/0bb53a7aa2)] - **doc**: make socket IPC examples more robust (cjihrig) [#13196](https://github.com/nodejs/node/pull/13196)
* [[`57b7285400`](https://github.com/nodejs/node/commit/57b7285400)] - **doc**: mention rebasing of v?.x-staging post release (Anna Henningsen) [#13742](https://github.com/nodejs/node/pull/13742)
* [[`cb932835d5`](https://github.com/nodejs/node/commit/cb932835d5)] - **doc**: `path.relative` uses `cwd` (DuanPengfei) [#13714](https://github.com/nodejs/node/pull/13714)
* [[`61714acbe5`](https://github.com/nodejs/node/commit/61714acbe5)] - **doc**: add hasIntl to test/common/README.md (Daniel Bevenius) [#13699](https://github.com/nodejs/node/pull/13699)
* [[`2a95cfb4ef`](https://github.com/nodejs/node/commit/2a95cfb4ef)] - **doc**: fix typo in changelog (Teddy Katz) [#13713](https://github.com/nodejs/node/pull/13713)
* [[`31ae193b99`](https://github.com/nodejs/node/commit/31ae193b99)] - **doc**: small makeover for onboarding.md (Anna Henningsen) [#13413](https://github.com/nodejs/node/pull/13413)
* [[`c27ffadf8e`](https://github.com/nodejs/node/commit/c27ffadf8e)] - **doc**: fix a few n-api doc issues (Michael Dawson) [#13650](https://github.com/nodejs/node/pull/13650)
* [[`c142f1d316`](https://github.com/nodejs/node/commit/c142f1d316)] - **doc**: fix minor issues reported in #9538 (Tobias Nießen) [#13491](https://github.com/nodejs/node/pull/13491)
* [[`f28dd8e680`](https://github.com/nodejs/node/commit/f28dd8e680)] - **doc**: fixes a typo in the async_hooks documentation (Chris Young) [#13666](https://github.com/nodejs/node/pull/13666)
* [[`58e177cde1`](https://github.com/nodejs/node/commit/58e177cde1)] - **doc**: document and test that methods return this (Sam Roberts) [#13531](https://github.com/nodejs/node/pull/13531)
* [[`f5f2a0e968`](https://github.com/nodejs/node/commit/f5f2a0e968)] - **doc**: sort and update /cc list for inspector issues (Aditya Anand) [#13632](https://github.com/nodejs/node/pull/13632)
* [[`dc06a0a85a`](https://github.com/nodejs/node/commit/dc06a0a85a)] - **doc**: note that EoL platforms are not supported (Gibson Fahnestock) [#12672](https://github.com/nodejs/node/pull/12672)
* [[`9b74dded0d`](https://github.com/nodejs/node/commit/9b74dded0d)] - **doc**: update async_hooks providers list (Anna Henningsen) [#13561](https://github.com/nodejs/node/pull/13561)
* [[`cc922310e3`](https://github.com/nodejs/node/commit/cc922310e3)] - **doc**: fix out of date napi_callback doc (XadillaX) [#13570](https://github.com/nodejs/node/pull/13570)
* [[`8cb7d96569`](https://github.com/nodejs/node/commit/8cb7d96569)] - **fs**: don't conflate data and callback in appendFile (Nikolai Vavilov) [#11607](https://github.com/nodejs/node/pull/11607)
* [[`233545a81c`](https://github.com/nodejs/node/commit/233545a81c)] - **inspector,cluster**: fix inspect port assignment (cornholio) [#13619](https://github.com/nodejs/node/pull/13619)
* [[`cbe7c5c617`](https://github.com/nodejs/node/commit/cbe7c5c617)] - **lib**: correct typo in createSecureContext (Daniel Bevenius) [#13653](https://github.com/nodejs/node/pull/13653)
* [[`f49dd21b2f`](https://github.com/nodejs/node/commit/f49dd21b2f)] - **n-api**: avoid crash in napi_escape_scope() (Michael Dawson) [#13651](https://github.com/nodejs/node/pull/13651)
* [[`28166770bd`](https://github.com/nodejs/node/commit/28166770bd)] - **net**: fix abort on bad address input (Ruben Bridgewater) [#13726](https://github.com/nodejs/node/pull/13726)
* [[`e786926de9`](https://github.com/nodejs/node/commit/e786926de9)] - **readline,repl,url,util**: remove needless capturing (Vse Mozhet Byt) [#13718](https://github.com/nodejs/node/pull/13718)
* [[`3322191d2f`](https://github.com/nodejs/node/commit/3322191d2f)] - **src**: don't set --icu_case_mapping flag on startup (Ben Noordhuis) [#13698](https://github.com/nodejs/node/pull/13698)
* [[`a27a35b997`](https://github.com/nodejs/node/commit/a27a35b997)] - **src**: fix decoding base64 with whitespace (Nikolai Vavilov) [#13660](https://github.com/nodejs/node/pull/13660)
* [[`5b3e5fac38`](https://github.com/nodejs/node/commit/5b3e5fac38)] - **src**: remove void casts for clear_error_on_return (Daniel Bevenius) [#13669](https://github.com/nodejs/node/pull/13669)
* [[`0a9e96e86c`](https://github.com/nodejs/node/commit/0a9e96e86c)] - **stream**: finish must always follow error (Matteo Collina) [#13850](https://github.com/nodejs/node/pull/13850)
* [[`5840138e70`](https://github.com/nodejs/node/commit/5840138e70)] - **stream**: fix `undefined` in Readable object mode (Anna Henningsen) [#13760](https://github.com/nodejs/node/pull/13760)
* [[`f1d96f0b2a`](https://github.com/nodejs/node/commit/f1d96f0b2a)] - **test**: refactor test-http-set-timeout-server (Rich Trott) [#13802](https://github.com/nodejs/node/pull/13802)
* [[`b23f2461cb`](https://github.com/nodejs/node/commit/b23f2461cb)] - **test**: refactor test-stream2-writable (Rich Trott) [#13823](https://github.com/nodejs/node/pull/13823)
* [[`9ff9782f66`](https://github.com/nodejs/node/commit/9ff9782f66)] - **test**: remove common module from test it thwarts (Rich Trott) [#13748](https://github.com/nodejs/node/pull/13748)
* [[`1f32d9ef5b`](https://github.com/nodejs/node/commit/1f32d9ef5b)] - **test**: fix RegExp nits (Vse Mozhet Byt) [#13770](https://github.com/nodejs/node/pull/13770)
* [[`3306fd1d97`](https://github.com/nodejs/node/commit/3306fd1d97)] - **test**: accommodate AIX by watching file (Rich Trott) [#13766](https://github.com/nodejs/node/pull/13766)
* [[`c8b134bc6d`](https://github.com/nodejs/node/commit/c8b134bc6d)] - **test**: remove node-tap lookalike (cjihrig) [#13707](https://github.com/nodejs/node/pull/13707)
* [[`d4a05b2d9c`](https://github.com/nodejs/node/commit/d4a05b2d9c)] - **test**: make test-http(s)-set-timeout-server alike (jklepatch) [#13625](https://github.com/nodejs/node/pull/13625)
* [[`d0f39cc38a`](https://github.com/nodejs/node/commit/d0f39cc38a)] - **test**: delete outdated fixtures/stdio-filter.js (Vse Mozhet Byt) [#13712](https://github.com/nodejs/node/pull/13712)
* [[`b2a5399760`](https://github.com/nodejs/node/commit/b2a5399760)] - **test**: refactor test-fs-watch-stop-sync (Rich Trott) [#13689](https://github.com/nodejs/node/pull/13689)
* [[`10aee10c0c`](https://github.com/nodejs/node/commit/10aee10c0c)] - **test**: check zlib version for createDeflateRaw (Daniel Bevenius) [#13697](https://github.com/nodejs/node/pull/13697)
* [[`0d3b52e9de`](https://github.com/nodejs/node/commit/0d3b52e9de)] - **test**: add hasIntl to failing test (Daniel Bevenius) [#13699](https://github.com/nodejs/node/pull/13699)
* [[`70fb1bd038`](https://github.com/nodejs/node/commit/70fb1bd038)] - **test**: improve http test reliability (Brian White) [#13693](https://github.com/nodejs/node/pull/13693)
* [[`5e59c2d21d`](https://github.com/nodejs/node/commit/5e59c2d21d)] - **test**: increase coverage for internal/module.js (Tamás Hódi) [#13673](https://github.com/nodejs/node/pull/13673)
* [[`ba20627520`](https://github.com/nodejs/node/commit/ba20627520)] - **test**: refactor test-fs-read-stream (Rich Trott) [#13643](https://github.com/nodejs/node/pull/13643)
* [[`e203e392d7`](https://github.com/nodejs/node/commit/e203e392d7)] - **test**: refactor test-cluster-worker-isconnected.js (cjihrig) [#13685](https://github.com/nodejs/node/pull/13685)
* [[`80e6524ff0`](https://github.com/nodejs/node/commit/80e6524ff0)] - **test**: fix nits in test-fs-mkdir-rmdir.js (Vse Mozhet Byt) [#13680](https://github.com/nodejs/node/pull/13680)
* [[`406c09aacb`](https://github.com/nodejs/node/commit/406c09aacb)] - **test**: fix test-inspector-port-zero-cluster (Refael Ackermann) [#13373](https://github.com/nodejs/node/pull/13373)
* [[`af46cf621b`](https://github.com/nodejs/node/commit/af46cf621b)] - **test**: refactor test-fs-watch-stop-async (Rich Trott) [#13661](https://github.com/nodejs/node/pull/13661)
* [[`6920d5c9f9`](https://github.com/nodejs/node/commit/6920d5c9f9)] - **test**: change deprecated method to recommended (Rich Trott) [#13649](https://github.com/nodejs/node/pull/13649)
* [[`0d87b3102a`](https://github.com/nodejs/node/commit/0d87b3102a)] - **test**: refactor test-fs-read-stream-inherit (Rich Trott) [#13618](https://github.com/nodejs/node/pull/13618)
* [[`80fa13b93f`](https://github.com/nodejs/node/commit/80fa13b93f)] - **test**: use mustNotCall() in test-fs-watch (Rich Trott) [#13595](https://github.com/nodejs/node/pull/13595)
* [[`7874360ca2`](https://github.com/nodejs/node/commit/7874360ca2)] - **test**: add mustCall() to child-process test (Rich Trott) [#13605](https://github.com/nodejs/node/pull/13605)
* [[`5cb3fac396`](https://github.com/nodejs/node/commit/5cb3fac396)] - **test**: use mustNotCall in test-http-eof-on-connect (Rich Trott) [#13587](https://github.com/nodejs/node/pull/13587)
* [[`4afa7483b1`](https://github.com/nodejs/node/commit/4afa7483b1)] - **test**: increase bufsize in child process write test (Rich Trott) [#13626](https://github.com/nodejs/node/pull/13626)
* [[`0ef687e858`](https://github.com/nodejs/node/commit/0ef687e858)] - **tools**: fix error in custom ESLint rule (Rich Trott) [#13758](https://github.com/nodejs/node/pull/13758)
* [[`b171e728e5`](https://github.com/nodejs/node/commit/b171e728e5)] - **tools**: apply stricter indentation rules to tools (Rich Trott) [#13758](https://github.com/nodejs/node/pull/13758)
* [[`9c2abc3e29`](https://github.com/nodejs/node/commit/9c2abc3e29)] - **tools**: fix indentation in required-modules.js (Rich Trott) [#13758](https://github.com/nodejs/node/pull/13758)
* [[`ff568d4b63`](https://github.com/nodejs/node/commit/ff568d4b63)] - **tools**: update ESLint to v4.0.0 (Rich Trott) [#13645](https://github.com/nodejs/node/pull/13645)
* [[`c046a21321`](https://github.com/nodejs/node/commit/c046a21321)] - **util**: ignore invalid format specifiers (Michaël Zasso) [#13674](https://github.com/nodejs/node/pull/13674)
* [[`c68e472b76`](https://github.com/nodejs/node/commit/c68e472b76)] - **v8**: fix RegExp nits in v8_prof_polyfill.js (Vse Mozhet Byt) [#13709](https://github.com/nodejs/node/pull/13709)

<a id="8.1.2"></a>
## 2017-06-15, Version 8.1.2 (Current), @rvagg

### Notable changes

Release to fix broken `process.release` properties
Ref: https://github.com/nodejs/node/issues/13667

<a id="8.1.1"></a>
## 2017-06-13, Version 8.1.1 (Current), @addaleax

### Notable changes

* **Child processes**
  * `stdout` and `stderr` are now available on the error output of a
    failed call to the `util.promisify()`ed version of
    `child_process.exec`.
    [[`d66d4fc94c`](https://github.com/nodejs/node/commit/d66d4fc94c)]
    [#13388](https://github.com/nodejs/node/pull/13388)

* **HTTP**
  * A regression that broke certain scenarios in which HTTP is used together
    with the `cluster` module has been fixed.
    [[`fff8a56d6f`](https://github.com/nodejs/node/commit/fff8a56d6f)]
    [#13578](https://github.com/nodejs/node/pull/13578)

* **HTTPS**
  * The `rejectUnauthorized` option now works properly for unix sockets.
    [[`c4cbd99d37`](https://github.com/nodejs/node/commit/c4cbd99d37)]
    [#13505](https://github.com/nodejs/node/pull/13505)

* **Readline**
  * A change that broke `npm init` and other code which uses `readline`
    multiple times on the same input stream is reverted.
    [[`0df6c0b5f0`](https://github.com/nodejs/node/commit/0df6c0b5f0)]
    [#13560](https://github.com/nodejs/node/pull/13560)

### Commits

* [[`61c73085ba`](https://github.com/nodejs/node/commit/61c73085ba)] - **async_hooks**: minor refactor to callback invocation (Anna Henningsen) [#13419](https://github.com/nodejs/node/pull/13419)
* [[`bf61d97742`](https://github.com/nodejs/node/commit/bf61d97742)] - **async_hooks**: make sure `.{en|dis}able() === this` (Anna Henningsen) [#13418](https://github.com/nodejs/node/pull/13418)
* [[`32c87ac6f3`](https://github.com/nodejs/node/commit/32c87ac6f3)] - **benchmark**: fix some RegExp nits (Vse Mozhet Byt) [#13551](https://github.com/nodejs/node/pull/13551)
* [[`b967b4cbc5`](https://github.com/nodejs/node/commit/b967b4cbc5)] - **build**: merge test suite groups (Refael Ackermann) [#13378](https://github.com/nodejs/node/pull/13378)
* [[`00d2f7c818`](https://github.com/nodejs/node/commit/00d2f7c818)] - **build,windows**: check for VS version and arch (Refael Ackermann) [#13485](https://github.com/nodejs/node/pull/13485)
* [[`d66d4fc94c`](https://github.com/nodejs/node/commit/d66d4fc94c)] - **child_process**: promisify includes stdio in error (Gil Tayar) [#13388](https://github.com/nodejs/node/pull/13388)
* [[`0ca4bd1e18`](https://github.com/nodejs/node/commit/0ca4bd1e18)] - **child_process**: reduce nextTick() usage (Brian White) [#13459](https://github.com/nodejs/node/pull/13459)
* [[`d1fa59fbb7`](https://github.com/nodejs/node/commit/d1fa59fbb7)] - **child_process**: simplify send() result handling (Brian White) [#13459](https://github.com/nodejs/node/pull/13459)
* [[`d51b1c2e6f`](https://github.com/nodejs/node/commit/d51b1c2e6f)] - **cluster, dns, repl, tls, util**: fix RegExp nits (Vse Mozhet Byt) [#13536](https://github.com/nodejs/node/pull/13536)
* [[`68c0518e48`](https://github.com/nodejs/node/commit/68c0518e48)] - **doc**: fix links and typos in fs.md (Vse Mozhet Byt) [#13573](https://github.com/nodejs/node/pull/13573)
* [[`70432f2111`](https://github.com/nodejs/node/commit/70432f2111)] - **doc**: fix incorrect fs.utimes() link (Justin Beckwith) [#13608](https://github.com/nodejs/node/pull/13608)
* [[`26d76307d5`](https://github.com/nodejs/node/commit/26d76307d5)] - **doc**: fs constants for Node \< v6.3.0 in fs.md (Anshul Guleria) [#12690](https://github.com/nodejs/node/pull/12690)
* [[`52f5e3f804`](https://github.com/nodejs/node/commit/52f5e3f804)] - **doc**: use HTTPS URL for suggested upstream remote (Nikolai Vavilov) [#13602](https://github.com/nodejs/node/pull/13602)
* [[`2c1133d5fe`](https://github.com/nodejs/node/commit/2c1133d5fe)] - **doc**: add readline.emitKeypressEvents note (Samuel Reed) [#9447](https://github.com/nodejs/node/pull/9447)
* [[`53ec50d971`](https://github.com/nodejs/node/commit/53ec50d971)] - **doc**: fix napi_create_*_error signatures in n-api (Jamen Marzonie) [#13544](https://github.com/nodejs/node/pull/13544)
* [[`98d7f25181`](https://github.com/nodejs/node/commit/98d7f25181)] - **doc**: fix out of date sections in n-api doc (Michael Dawson) [#13508](https://github.com/nodejs/node/pull/13508)
* [[`85cac4ed53`](https://github.com/nodejs/node/commit/85cac4ed53)] - **doc**: update new CTC members (Refael Ackermann) [#13534](https://github.com/nodejs/node/pull/13534)
* [[`8c5407d321`](https://github.com/nodejs/node/commit/8c5407d321)] - **doc**: corrects reference to tlsClientError (Tarun) [#13533](https://github.com/nodejs/node/pull/13533)
* [[`3d12e1b455`](https://github.com/nodejs/node/commit/3d12e1b455)] - **doc**: emphasize Collaborators in GOVERNANCE.md (Rich Trott) [#13423](https://github.com/nodejs/node/pull/13423)
* [[`a9be8fff58`](https://github.com/nodejs/node/commit/a9be8fff58)] - **doc**: minimal documentation for Emeritus status (Rich Trott) [#13421](https://github.com/nodejs/node/pull/13421)
* [[`2778256680`](https://github.com/nodejs/node/commit/2778256680)] - **doc**: remove note highlighting in GOVERNANCE doc (Rich Trott) [#13420](https://github.com/nodejs/node/pull/13420)
* [[`2cb6f2b281`](https://github.com/nodejs/node/commit/2cb6f2b281)] - **http**: fix timeout reset after keep-alive timeout (Alexey Orlenko) [#13549](https://github.com/nodejs/node/pull/13549)
* [[`fff8a56d6f`](https://github.com/nodejs/node/commit/fff8a56d6f)] - **http**: handle cases where socket.server is null (Luigi Pinca) [#13578](https://github.com/nodejs/node/pull/13578)
* [[`c4cbd99d37`](https://github.com/nodejs/node/commit/c4cbd99d37)] - **https**: support rejectUnauthorized for unix sockets (cjihrig) [#13505](https://github.com/nodejs/node/pull/13505)
* [[`6a696d15ff`](https://github.com/nodejs/node/commit/6a696d15ff)] - **inspector**: fix crash on exception (Nikolai Vavilov) [#13455](https://github.com/nodejs/node/pull/13455)
* [[`50e1f931a9`](https://github.com/nodejs/node/commit/50e1f931a9)] - **profiler**: declare missing `printErr` (Fedor Indutny) [#13590](https://github.com/nodejs/node/pull/13590)
* [[`0df6c0b5f0`](https://github.com/nodejs/node/commit/0df6c0b5f0)] - ***Revert*** "**readline**: clean up event listener in onNewListener" (Anna Henningsen) [#13560](https://github.com/nodejs/node/pull/13560)
* [[`a5f415fe83`](https://github.com/nodejs/node/commit/a5f415fe83)] - **src**: merge `fn_name` in NODE_SET_PROTOTYPE_METHOD (XadillaX) [#13547](https://github.com/nodejs/node/pull/13547)
* [[`4a96ed4896`](https://github.com/nodejs/node/commit/4a96ed4896)] - **src**: check whether inspector is doing io (Sam Roberts) [#13504](https://github.com/nodejs/node/pull/13504)
* [[`f134c9d147`](https://github.com/nodejs/node/commit/f134c9d147)] - **src**: correct indentation for X509ToObject (Daniel Bevenius) [#13543](https://github.com/nodejs/node/pull/13543)
* [[`dd158b096f`](https://github.com/nodejs/node/commit/dd158b096f)] - **src**: make IsConstructCall checks consistent (Daniel Bevenius) [#13473](https://github.com/nodejs/node/pull/13473)
* [[`bf065344cf`](https://github.com/nodejs/node/commit/bf065344cf)] - **stream**: ensure that instanceof fast-path is hit. (Benedikt Meurer) [#13403](https://github.com/nodejs/node/pull/13403)
* [[`e713482147`](https://github.com/nodejs/node/commit/e713482147)] - **test**: fix typo in test-cli-node-options.js (Vse Mozhet Byt) [#13558](https://github.com/nodejs/node/pull/13558)
* [[`4c5457fae5`](https://github.com/nodejs/node/commit/4c5457fae5)] - **test**: fix flaky test-http-client-get-url (Sebastian Plesciuc) [#13516](https://github.com/nodejs/node/pull/13516)
* [[`812e0b0fbf`](https://github.com/nodejs/node/commit/812e0b0fbf)] - **test**: refactor async-hooks test-callback-error (Rich Trott) [#13554](https://github.com/nodejs/node/pull/13554)
* [[`2ea529b797`](https://github.com/nodejs/node/commit/2ea529b797)] - **test**: add regression test for 13557 (Anna Henningsen) [#13560](https://github.com/nodejs/node/pull/13560)
* [[`4d27930faf`](https://github.com/nodejs/node/commit/4d27930faf)] - **test**: fix flaky test-tls-socket-close (Rich Trott) [#13529](https://github.com/nodejs/node/pull/13529)
* [[`3da56ac9fb`](https://github.com/nodejs/node/commit/3da56ac9fb)] - **test**: harden test-dgram-bind-shared-ports (Refael Ackermann) [#13100](https://github.com/nodejs/node/pull/13100)
* [[`f686f73465`](https://github.com/nodejs/node/commit/f686f73465)] - **test**: add coverage for AsyncResource constructor (Gergely Nemeth) [#13327](https://github.com/nodejs/node/pull/13327)
* [[`12036a1d73`](https://github.com/nodejs/node/commit/12036a1d73)] - **test**: exercise once() with varying arguments (cjihrig) [#13524](https://github.com/nodejs/node/pull/13524)
* [[`1f88cbd620`](https://github.com/nodejs/node/commit/1f88cbd620)] - **test**: refactor test-http-server-keep-alive-timeout (realwakka) [#13448](https://github.com/nodejs/node/pull/13448)
* [[`bdbeb33dcb`](https://github.com/nodejs/node/commit/bdbeb33dcb)] - **test**: add hijackStdout and hijackStderr (XadillaX) [#13439](https://github.com/nodejs/node/pull/13439)
* [[`1c7f9171c0`](https://github.com/nodejs/node/commit/1c7f9171c0)] - **test**: add coverage for napi_property_descriptor (Michael Dawson) [#13510](https://github.com/nodejs/node/pull/13510)
* [[`c8db0475e0`](https://github.com/nodejs/node/commit/c8db0475e0)] - **test**: refactor test-fs-read-* (Rich Trott) [#13501](https://github.com/nodejs/node/pull/13501)
* [[`ad07c46b00`](https://github.com/nodejs/node/commit/ad07c46b00)] - **test**: refactor domain tests (Rich Trott) [#13480](https://github.com/nodejs/node/pull/13480)
* [[`fe5ea3feb0`](https://github.com/nodejs/node/commit/fe5ea3feb0)] - **test**: check callback not invoked on lookup error (Rich Trott) [#13456](https://github.com/nodejs/node/pull/13456)
* [[`216cb3f6e9`](https://github.com/nodejs/node/commit/216cb3f6e9)] - **test,benchmark**: stabilize child-process (Refael Ackermann) [#13457](https://github.com/nodejs/node/pull/13457)
* [[`a0f8faa3a4`](https://github.com/nodejs/node/commit/a0f8faa3a4)] - **v8**: fix debug builds on Windows (Bartosz Sosnowski) [#13634](https://github.com/nodejs/node/pull/13634)
* [[`38a1cfb5e6`](https://github.com/nodejs/node/commit/38a1cfb5e6)] - **v8**: add a js class for Serializer/Dserializer (Rajaram Gaunker) [#13541](https://github.com/nodejs/node/pull/13541)

<a id="8.1.0"></a>
## 2017-06-07, Version 8.1.0 (Current), @jasnell

### Notable Changes

* **Async Hooks**
  * When one `Promise` leads to the creation of a new `Promise`, the parent
    `Promise` will be identified as the trigger
    [[`135f4e6643`](https://github.com/nodejs/node/commit/135f4e6643)]
    [#13367](https://github.com/nodejs/node/pull/13367).
* **Dependencies**
  * libuv has been updated to 1.12.0
    [[`968596ec77`](https://github.com/nodejs/node/commit/968596ec77)]
    [#13306](https://github.com/nodejs/node/pull/13306).
  * npm has been updated to 5.0.3
    [[`ffa7debd7a`](https://github.com/nodejs/node/commit/ffa7debd7a)]
    [#13487](https://github.com/nodejs/node/pull/13487).
* **File system**
  * The `fs.exists()` function now works correctly with `util.promisify()`
    [[`6e0eccd7a1`](https://github.com/nodejs/node/commit/6e0eccd7a1)]
    [#13316](https://github.com/nodejs/node/pull/13316).
  * fs.Stats times are now also available as numbers
    [[`c756efb25a`](https://github.com/nodejs/node/commit/c756efb25a)]
    [#13173](https://github.com/nodejs/node/pull/13173).
* **Inspector**
  * It is now possible to bind to a random port using `--inspect=0`
    [[`cc6ec2fb27`](https://github.com/nodejs/node/commit/cc6ec2fb27)]
    [#5025](https://github.com/nodejs/node/pull/5025).
* **Zlib**
  * A regression in the Zlib module that made it impossible to properly
    subclasses `zlib.Deflate` and other Zlib classes has been fixed.
    [[`6aeb555cc4`](https://github.com/nodejs/node/commit/6aeb555cc4)]
    [#13374](https://github.com/nodejs/node/pull/13374).

### Commits

* [[`b8e90ddf53`](https://github.com/nodejs/node/commit/b8e90ddf53)] - **assert**: fix deepEqual similar sets and maps bug (Joseph Gentle) [#13426](https://github.com/nodejs/node/pull/13426)
* [[`47c9de9842`](https://github.com/nodejs/node/commit/47c9de9842)] - **assert**: fix deepEqual RangeError: Maximum call stack size exceeded (rmdm) [#13318](https://github.com/nodejs/node/pull/13318)
* [[`135f4e6643`](https://github.com/nodejs/node/commit/135f4e6643)] - **(SEMVER-MINOR)** **async_hooks**: use parent promise as triggerId (JiaLi.Passion) [#13367](https://github.com/nodejs/node/pull/13367)
* [[`9db02dcc85`](https://github.com/nodejs/node/commit/9db02dcc85)] - **async_hooks,http**: fix socket reuse with Agent (Anna Henningsen) [#13348](https://github.com/nodejs/node/pull/13348)
* [[`6917df2a80`](https://github.com/nodejs/node/commit/6917df2a80)] - **async_wrap**: run destroy in uv_timer_t (Trevor Norris) [#13369](https://github.com/nodejs/node/pull/13369)
* [[`65f22e481b`](https://github.com/nodejs/node/commit/65f22e481b)] - **build**: use existing variable to reduce complexity (Bryce Baril) [#2883](https://github.com/nodejs/node/pull/2883)
* [[`291669e7d8`](https://github.com/nodejs/node/commit/291669e7d8)] - **build**: streamline JS test suites in Makefile (Rich Trott) [#13340](https://github.com/nodejs/node/pull/13340)
* [[`dcadeb4fef`](https://github.com/nodejs/node/commit/dcadeb4fef)] - **build**: fix typo (Nikolai Vavilov) [#13396](https://github.com/nodejs/node/pull/13396)
* [[`50b5f8bac0`](https://github.com/nodejs/node/commit/50b5f8bac0)] - **crypto**: clear err stack after ECDH::BufferToPoint (Ryan Kelly) [#13275](https://github.com/nodejs/node/pull/13275)
* [[`968596ec77`](https://github.com/nodejs/node/commit/968596ec77)] - **deps**: upgrade libuv to 1.12.0 (cjihrig) [#13306](https://github.com/nodejs/node/pull/13306)
* [[`ffa7debd7a`](https://github.com/nodejs/node/commit/ffa7debd7a)] - **deps**: upgrade npm to 5.0.3 (Kat Marchán) [#13487](https://github.com/nodejs/node/pull/13487)
* [[`035a81b2e6`](https://github.com/nodejs/node/commit/035a81b2e6)] - **deps**: update openssl asm and asm_obsolete files (Daniel Bevenius) [#13233](https://github.com/nodejs/node/pull/13233)
* [[`6f57554650`](https://github.com/nodejs/node/commit/6f57554650)] - **deps**: update openssl config files (Daniel Bevenius) [#13233](https://github.com/nodejs/node/pull/13233)
* [[`1b8b82d076`](https://github.com/nodejs/node/commit/1b8b82d076)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`783294add1`](https://github.com/nodejs/node/commit/783294add1)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`db7419bead`](https://github.com/nodejs/node/commit/db7419bead)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`dd93fa677a`](https://github.com/nodejs/node/commit/dd93fa677a)] - **deps**: copy all openssl header files to include dir (Daniel Bevenius) [#13233](https://github.com/nodejs/node/pull/13233)
* [[`d9191f6e18`](https://github.com/nodejs/node/commit/d9191f6e18)] - **deps**: upgrade openssl sources to 1.0.2l (Daniel Bevenius) [#13233](https://github.com/nodejs/node/pull/13233)
* [[`d985ca7d4a`](https://github.com/nodejs/node/commit/d985ca7d4a)] - **deps**: float patch on npm to fix citgm (Myles Borins) [#13305](https://github.com/nodejs/node/pull/13305)
* [[`92de432780`](https://github.com/nodejs/node/commit/92de432780)] - **dns**: use faster IP address type check on results (Brian White) [#13261](https://github.com/nodejs/node/pull/13261)
* [[`007a033820`](https://github.com/nodejs/node/commit/007a033820)] - **dns**: improve callback performance (Brian White) [#13261](https://github.com/nodejs/node/pull/13261)
* [[`26e5b6411f`](https://github.com/nodejs/node/commit/26e5b6411f)] - **doc**: update linux supported versions (cjihrig) [#13306](https://github.com/nodejs/node/pull/13306)
* [[`a117bcc0a7`](https://github.com/nodejs/node/commit/a117bcc0a7)] - **doc**: Add URL argument with http/https request (Vladimir Trifonov) [#13405](https://github.com/nodejs/node/pull/13405)
* [[`e6e42c1f75`](https://github.com/nodejs/node/commit/e6e42c1f75)] - **doc**: fix typo "ndapi" in n-api.md (Jamen Marz) [#13484](https://github.com/nodejs/node/pull/13484)
* [[`e991cd79f3`](https://github.com/nodejs/node/commit/e991cd79f3)] - **doc**: add ref to option to enable n-api (Michael Dawson) [#13406](https://github.com/nodejs/node/pull/13406)
* [[`414da1b7a1`](https://github.com/nodejs/node/commit/414da1b7a1)] - **doc**: fix nits in code examples of async_hooks.md (Vse Mozhet Byt) [#13400](https://github.com/nodejs/node/pull/13400)
* [[`159294d7d5`](https://github.com/nodejs/node/commit/159294d7d5)] - **doc**: use prefer-rest-params eslint rule in docs (Vse Mozhet Byt) [#13389](https://github.com/nodejs/node/pull/13389)
* [[`641979b213`](https://github.com/nodejs/node/commit/641979b213)] - **doc**: resume a stream after pipe() and unpipe() (Matteo Collina) [#13329](https://github.com/nodejs/node/pull/13329)
* [[`6c56bbdf13`](https://github.com/nodejs/node/commit/6c56bbdf13)] - **doc**: add missing backticks to doc/api/tls.md (Paul Bininda) [#13394](https://github.com/nodejs/node/pull/13394)
* [[`837ecc01eb`](https://github.com/nodejs/node/commit/837ecc01eb)] - **doc**: update who to cc for async_hooks (Anna Henningsen) [#13332](https://github.com/nodejs/node/pull/13332)
* [[`52c0c47856`](https://github.com/nodejs/node/commit/52c0c47856)] - **doc**: suggest xcode-select --install (Gibson Fahnestock) [#13264](https://github.com/nodejs/node/pull/13264)
* [[`11e428dd99`](https://github.com/nodejs/node/commit/11e428dd99)] - **doc**: add require modules in url.md (Daijiro Wachi) [#13365](https://github.com/nodejs/node/pull/13365)
* [[`2d25e09b0f`](https://github.com/nodejs/node/commit/2d25e09b0f)] - **doc**: add object-curly-spacing to doc/.eslintrc (Vse Mozhet Byt) [#13354](https://github.com/nodejs/node/pull/13354)
* [[`6cd5312b22`](https://github.com/nodejs/node/commit/6cd5312b22)] - **doc**: unify spaces in object literals (Vse Mozhet Byt) [#13354](https://github.com/nodejs/node/pull/13354)
* [[`4e687605ee`](https://github.com/nodejs/node/commit/4e687605ee)] - **doc**: use destructuring in code examples (Vse Mozhet Byt) [#13349](https://github.com/nodejs/node/pull/13349)
* [[`1b192f936a`](https://github.com/nodejs/node/commit/1b192f936a)] - **doc**: fix code examples in zlib.md (Vse Mozhet Byt) [#13342](https://github.com/nodejs/node/pull/13342)
* [[`a872399ddb`](https://github.com/nodejs/node/commit/a872399ddb)] - **doc**: update who to cc for n-api (Michael Dawson) [#13335](https://github.com/nodejs/node/pull/13335)
* [[`90417e8ced`](https://github.com/nodejs/node/commit/90417e8ced)] - **doc**: add missing make command to UPGRADING.md (Daniel Bevenius) [#13233](https://github.com/nodejs/node/pull/13233)
* [[`3c55d1aea4`](https://github.com/nodejs/node/commit/3c55d1aea4)] - **doc**: refine spaces in example from vm.md (Vse Mozhet Byt) [#13334](https://github.com/nodejs/node/pull/13334)
* [[`1729574cd7`](https://github.com/nodejs/node/commit/1729574cd7)] - **doc**: fix link in CHANGELOG_V8 (James, please) [#13313](https://github.com/nodejs/node/pull/13313)
* [[`16605cc3e4`](https://github.com/nodejs/node/commit/16605cc3e4)] - **doc**: add async_hooks, n-api to _toc.md and all.md (Vse Mozhet Byt) [#13379](https://github.com/nodejs/node/pull/13379)
* [[`eb6e9a0c9a`](https://github.com/nodejs/node/commit/eb6e9a0c9a)] - **doc**: remove 'you' from writing-tests.md (Michael Dawson) [#13319](https://github.com/nodejs/node/pull/13319)
* [[`e4f37568e2`](https://github.com/nodejs/node/commit/e4f37568e2)] - **doc**: fix date for 8.0.0 changelog (Myles Borins) [#13360](https://github.com/nodejs/node/pull/13360)
* [[`41f0af524d`](https://github.com/nodejs/node/commit/41f0af524d)] - **doc**: async-hooks documentation (Thorsten Lorenz) [#13287](https://github.com/nodejs/node/pull/13287)
* [[`b8b0bfb1a7`](https://github.com/nodejs/node/commit/b8b0bfb1a7)] - **doc**: add tniessen to collaborators (Tobias Nießen) [#13371](https://github.com/nodejs/node/pull/13371)
* [[`561c14ba12`](https://github.com/nodejs/node/commit/561c14ba12)] - **doc**: modernize and fix code examples in util.md (Vse Mozhet Byt) [#13298](https://github.com/nodejs/node/pull/13298)
* [[`c2d7b41ac7`](https://github.com/nodejs/node/commit/c2d7b41ac7)] - **doc**: fix code examples in url.md (Vse Mozhet Byt) [#13288](https://github.com/nodejs/node/pull/13288)
* [[`243643e5e4`](https://github.com/nodejs/node/commit/243643e5e4)] - **doc**: fix typo in n-api.md (JongChan Choi) [#13323](https://github.com/nodejs/node/pull/13323)
* [[`bee1421501`](https://github.com/nodejs/node/commit/bee1421501)] - **doc**: fix doc styles (Daijiro Wachi) [#13270](https://github.com/nodejs/node/pull/13270)
* [[`44c8ea32df`](https://github.com/nodejs/node/commit/44c8ea32df)] - **doc,stream**: clarify 'data', pipe() and 'readable' (Matteo Collina) [#13432](https://github.com/nodejs/node/pull/13432)
* [[`8f2b82a2b4`](https://github.com/nodejs/node/commit/8f2b82a2b4)] - **errors,tty**: migrate to use internal/errors.js (Gautam Mittal) [#13240](https://github.com/nodejs/node/pull/13240)
* [[`a666238ffe`](https://github.com/nodejs/node/commit/a666238ffe)] - **events**: fix potential permanent deopt (Brian White) [#13384](https://github.com/nodejs/node/pull/13384)
* [[`c756efb25a`](https://github.com/nodejs/node/commit/c756efb25a)] - **(SEMVER-MINOR)** **fs**: expose Stats times as Numbers (Refael Ackermann) [#13173](https://github.com/nodejs/node/pull/13173)
* [[`5644dd76a5`](https://github.com/nodejs/node/commit/5644dd76a5)] - **fs**: replace a bind() with a top-level function (Matteo Collina) [#13474](https://github.com/nodejs/node/pull/13474)
* [[`6e0eccd7a1`](https://github.com/nodejs/node/commit/6e0eccd7a1)] - **(SEMVER-MINOR)** **fs**: promisify exists correctly (Dan Fabulich) [#13316](https://github.com/nodejs/node/pull/13316)
* [[`0caa09da60`](https://github.com/nodejs/node/commit/0caa09da60)] - **gitignore**: add libuv book and GitHub template (cjihrig) [#13306](https://github.com/nodejs/node/pull/13306)
* [[`8efaa554f2`](https://github.com/nodejs/node/commit/8efaa554f2)] - **(SEMVER-MINOR)** **http**: overridable keep-alive behavior of `Agent` (Fedor Indutny) [#13005](https://github.com/nodejs/node/pull/13005)
* [[`afe91ec957`](https://github.com/nodejs/node/commit/afe91ec957)] - **http**: assert parser.consume argument's type (Gireesh Punathil) [#12288](https://github.com/nodejs/node/pull/12288)
* [[`b3c9bff254`](https://github.com/nodejs/node/commit/b3c9bff254)] - **http**: describe parse err in debug output (Sam Roberts) [#13206](https://github.com/nodejs/node/pull/13206)
* [[`c7ebf6ea70`](https://github.com/nodejs/node/commit/c7ebf6ea70)] - **http**: suppress data event if req aborted (Yihong Wang) [#13260](https://github.com/nodejs/node/pull/13260)
* [[`9be8b6373e`](https://github.com/nodejs/node/commit/9be8b6373e)] - **(SEMVER-MINOR)** **inspector**: allow --inspect=host:port from js (Sam Roberts) [#13228](https://github.com/nodejs/node/pull/13228)
* [[`376ac5fc3e`](https://github.com/nodejs/node/commit/376ac5fc3e)] - **inspector**: Allows reentry when paused (Eugene Ostroukhov) [#13350](https://github.com/nodejs/node/pull/13350)
* [[`7f0aa3f4bd`](https://github.com/nodejs/node/commit/7f0aa3f4bd)] - **inspector**: refactor to rename and comment methods (Sam Roberts) [#13321](https://github.com/nodejs/node/pull/13321)
* [[`cc6ec2fb27`](https://github.com/nodejs/node/commit/cc6ec2fb27)] - **(SEMVER-MINOR)** **inspector**: bind to random port with --inspect=0 (Ben Noordhuis) [#5025](https://github.com/nodejs/node/pull/5025)
* [[`4b2c756bfc`](https://github.com/nodejs/node/commit/4b2c756bfc)] - **(SEMVER-MINOR)** **lib**: return this from net.Socket.end() (Sam Roberts) [#13481](https://github.com/nodejs/node/pull/13481)
* [[`b3fb909d06`](https://github.com/nodejs/node/commit/b3fb909d06)] - **lib**: "iff" changed to "if and only if" (Jacob Jones) [#13496](https://github.com/nodejs/node/pull/13496)
* [[`a95f080160`](https://github.com/nodejs/node/commit/a95f080160)] - **n-api**: enable napi_wrap() to work with any object (Jason Ginchereau) [#13250](https://github.com/nodejs/node/pull/13250)
* [[`41eaa4b6a6`](https://github.com/nodejs/node/commit/41eaa4b6a6)] - **net**: fix permanent deopt (Brian White) [#13384](https://github.com/nodejs/node/pull/13384)
* [[`b5409abf9a`](https://github.com/nodejs/node/commit/b5409abf9a)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`103de0e69a`](https://github.com/nodejs/node/commit/103de0e69a)] - **process**: fix permanent deopt (Brian White) [#13384](https://github.com/nodejs/node/pull/13384)
* [[`81ddeb98f6`](https://github.com/nodejs/node/commit/81ddeb98f6)] - **readline**: clean up event listener in onNewListener (Gibson Fahnestock) [#13266](https://github.com/nodejs/node/pull/13266)
* [[`791b5b5cbe`](https://github.com/nodejs/node/commit/791b5b5cbe)] - **src**: remove `'` print modifier (Refael Ackermann) [#13447](https://github.com/nodejs/node/pull/13447)
* [[`640101b780`](https://github.com/nodejs/node/commit/640101b780)] - **src**: remove process._inspectorEnbale (cjihrig) [#13460](https://github.com/nodejs/node/pull/13460)
* [[`8620aad573`](https://github.com/nodejs/node/commit/8620aad573)] - **src**: added newline in help message (Josh Ferge) [#13315](https://github.com/nodejs/node/pull/13315)
* [[`71a3d2c87e`](https://github.com/nodejs/node/commit/71a3d2c87e)] - **test**: refactor test-dgram-oob-buffer (Rich Trott) [#13443](https://github.com/nodejs/node/pull/13443)
* [[`54ae7d8931`](https://github.com/nodejs/node/commit/54ae7d8931)] - **test**: pass env vars through to test-benchmark-http (Gibson Fahnestock) [#13390](https://github.com/nodejs/node/pull/13390)
* [[`757ae521b5`](https://github.com/nodejs/node/commit/757ae521b5)] - **test**: validate full error messages (aniketshukla) [#13453](https://github.com/nodejs/node/pull/13453)
* [[`68e06e6945`](https://github.com/nodejs/node/commit/68e06e6945)] - **test**: increase coverage of async_hooks (David Cai) [#13336](https://github.com/nodejs/node/pull/13336)
* [[`7be1a1cd47`](https://github.com/nodejs/node/commit/7be1a1cd47)] - **test**: fix build warning in addons-napi/test_object (Jason Ginchereau) [#13412](https://github.com/nodejs/node/pull/13412)
* [[`fb73070068`](https://github.com/nodejs/node/commit/fb73070068)] - **test**: consolidate n-api test addons - part2 (Michael Dawson) [#13380](https://github.com/nodejs/node/pull/13380)
* [[`339d220eed`](https://github.com/nodejs/node/commit/339d220eed)] - **test**: rearrange inspector headers into convention (Sam Roberts) [#13428](https://github.com/nodejs/node/pull/13428)
* [[`8c7f9da489`](https://github.com/nodejs/node/commit/8c7f9da489)] - **test**: improve async hooks test error messages (Anna Henningsen) [#13243](https://github.com/nodejs/node/pull/13243)
* [[`818c935add`](https://github.com/nodejs/node/commit/818c935add)] - **test**: test async-hook triggerId properties (Dávid Szakállas) [#13328](https://github.com/nodejs/node/pull/13328)
* [[`29f19b6d39`](https://github.com/nodejs/node/commit/29f19b6d39)] - **test**: add documentation for common.mustNotCall() (Rich Trott) [#13359](https://github.com/nodejs/node/pull/13359)
* [[`c208f9d51f`](https://github.com/nodejs/node/commit/c208f9d51f)] - **test**: check destroy hooks are called before exit (Anna Henningsen) [#13369](https://github.com/nodejs/node/pull/13369)
* [[`406c2cd8e4`](https://github.com/nodejs/node/commit/406c2cd8e4)] - **test**: make test-fs-watchfile reliable (Rich Trott) [#13385](https://github.com/nodejs/node/pull/13385)
* [[`93e91a4f3f`](https://github.com/nodejs/node/commit/93e91a4f3f)] - **test**: check inspector support in test/inspector (Daniel Bevenius) [#13324](https://github.com/nodejs/node/pull/13324)
* [[`d1b39d92d6`](https://github.com/nodejs/node/commit/d1b39d92d6)] - **test**: add known_test request with Unicode in the URL (David D Lowe) [#13297](https://github.com/nodejs/node/pull/13297)
* [[`dccd1d2d31`](https://github.com/nodejs/node/commit/dccd1d2d31)] - **test**: improve dns internet test case (Brian White) [#13261](https://github.com/nodejs/node/pull/13261)
* [[`e20f3577d0`](https://github.com/nodejs/node/commit/e20f3577d0)] - **test**: improve test-https-server-keep-alive-timeout (Rich Trott) [#13312](https://github.com/nodejs/node/pull/13312)
* [[`2a29c07d9e`](https://github.com/nodejs/node/commit/2a29c07d9e)] - **test**: mark inspector-port-zero-cluster as flaky (Refael Ackermann)
* [[`b16dd98387`](https://github.com/nodejs/node/commit/b16dd98387)] - **test**: consolidate n-api test addons (Michael Dawson) [#13317](https://github.com/nodejs/node/pull/13317)
* [[`830049f784`](https://github.com/nodejs/node/commit/830049f784)] - **test**: refactor test-net-server-bind (Rich Trott) [#13273](https://github.com/nodejs/node/pull/13273)
* [[`9df8e2a3e9`](https://github.com/nodejs/node/commit/9df8e2a3e9)] - **test**: use mustCall() in test-readline-interface (Rich Trott) [#13259](https://github.com/nodejs/node/pull/13259)
* [[`25a05e5db1`](https://github.com/nodejs/node/commit/25a05e5db1)] - **test**: fix flaky test-fs-watchfile on macOS (Rich Trott) [#13252](https://github.com/nodejs/node/pull/13252)
* [[`ec357bf88f`](https://github.com/nodejs/node/commit/ec357bf88f)] - **test**: use mustNotCall() in test-stream2-objects (Rich Trott) [#13249](https://github.com/nodejs/node/pull/13249)
* [[`5369359d52`](https://github.com/nodejs/node/commit/5369359d52)] - **test**: Make N-API weak-ref GC tests asynchronous (Jason Ginchereau) [#13121](https://github.com/nodejs/node/pull/13121)
* [[`7cc6fd8403`](https://github.com/nodejs/node/commit/7cc6fd8403)] - **test**: improve n-api coverage for typed arrays (Michael Dawson) [#13244](https://github.com/nodejs/node/pull/13244)
* [[`a2d49545a7`](https://github.com/nodejs/node/commit/a2d49545a7)] - **test**: support candidate V8 versions (Michaël Zasso) [#13282](https://github.com/nodejs/node/pull/13282)
* [[`f0ad3bb695`](https://github.com/nodejs/node/commit/f0ad3bb695)] - **test**: hasCrypto https-server-keep-alive-timeout (Daniel Bevenius) [#13253](https://github.com/nodejs/node/pull/13253)
* [[`658560ee5b`](https://github.com/nodejs/node/commit/658560ee5b)] - **test,fs**: test fs.watch for `filename` (Refael Ackermann) [#13411](https://github.com/nodejs/node/pull/13411)
* [[`2e3b758006`](https://github.com/nodejs/node/commit/2e3b758006)] - **test,module**: make message check MUI dependent (Refael Ackermann) [#13393](https://github.com/nodejs/node/pull/13393)
* [[`01278bdd64`](https://github.com/nodejs/node/commit/01278bdd64)] - **tools**: fix order of ESLint rules (Michaël Zasso) [#13363](https://github.com/nodejs/node/pull/13363)
* [[`48cad9cde6`](https://github.com/nodejs/node/commit/48cad9cde6)] - **tools**: fix node args passing in test runner (Brian White) [#13384](https://github.com/nodejs/node/pull/13384)
* [[`bccda4f2b8`](https://github.com/nodejs/node/commit/bccda4f2b8)] - **tools**: be explicit about including key-id (Myles Borins) [#13309](https://github.com/nodejs/node/pull/13309)
* [[`61eb085c6a`](https://github.com/nodejs/node/commit/61eb085c6a)] - **tools, test**: update test-npm-package paths (Gibson Fahnestock) [#13441](https://github.com/nodejs/node/pull/13441)
* [[`ba817d3312`](https://github.com/nodejs/node/commit/ba817d3312)] - **url**: update IDNA handling (Timothy Gu) [#13362](https://github.com/nodejs/node/pull/13362)
* [[`d4d138c6e9`](https://github.com/nodejs/node/commit/d4d138c6e9)] - **url**: do not pass WHATWG host to http.request (Tobias Nießen) [#13409](https://github.com/nodejs/node/pull/13409)
* [[`315c3aaf43`](https://github.com/nodejs/node/commit/315c3aaf43)] - **url**: more precise URLSearchParams constructor (Timothy Gu) [#13026](https://github.com/nodejs/node/pull/13026)
* [[`1bcda5efda`](https://github.com/nodejs/node/commit/1bcda5efda)] - **util**: refactor format method.Performance improved. (Jesus Seijas) [#12407](https://github.com/nodejs/node/pull/12407)
* [[`f47ce01dfb`](https://github.com/nodejs/node/commit/f47ce01dfb)] - **win, doc**: document per-drive current working dir (Bartosz Sosnowski) [#13330](https://github.com/nodejs/node/pull/13330)
* [[`6aeb555cc4`](https://github.com/nodejs/node/commit/6aeb555cc4)] - **zlib**: revert back to Functions (James M Snell) [#13374](https://github.com/nodejs/node/pull/13374)
* [[`cc3174a937`](https://github.com/nodejs/node/commit/cc3174a937)] - **(SEMVER-MINOR)** **zlib**: expose amount of data read for engines (Alexander O'Mara) [#13088](https://github.com/nodejs/node/pull/13088)
* [[`bb77d6c1cc`](https://github.com/nodejs/node/commit/bb77d6c1cc)] - **(SEMVER-MINOR)** **zlib**: option for engine in convenience methods (Alexander O'Mara) [#13089](https://github.com/nodejs/node/pull/13089)


<a id="8.0.0"></a>
## 2017-05-30, Version 8.0.0 (Current), @jasnell

Node.js 8.0.0 is a major new release that includes a significant number of
`semver-major` and `semver-minor` changes. Notable changes are listed below.

The Node.js 8.x release branch is scheduled to become the *next* actively
maintained Long Term Support (LTS) release line in October, 2017 under the
LTS codename `'Carbon'`. Note that the
[LTS lifespan](https://github.com/nodejs/lts) for 8.x will end on December 31st,
2019.

### Notable Changes

* **Async Hooks**
  * The `async_hooks` module has landed in core
    [[`4a7233c178`](https://github.com/nodejs/node/commit/4a7233c178)]
    [#12892](https://github.com/nodejs/node/pull/12892).

* **Buffer**
  * Using the `--pending-deprecation` flag will cause Node.js to emit a
    deprecation warning when using `new Buffer(num)` or `Buffer(num)`.
    [[`d2d32ea5a2`](https://github.com/nodejs/node/commit/d2d32ea5a2)]
    [#11968](https://github.com/nodejs/node/pull/11968).
  * `new Buffer(num)` and `Buffer(num)` will zero-fill new `Buffer` instances
    [[`7eb1b4658e`](https://github.com/nodejs/node/commit/7eb1b4658e)]
    [#12141](https://github.com/nodejs/node/pull/12141).
  * Many `Buffer` methods now accept `Uint8Array` as input
    [[`beca3244e2`](https://github.com/nodejs/node/commit/beca3244e2)]
    [#10236](https://github.com/nodejs/node/pull/10236).

* **Child Process**
  * Argument and kill signal validations have been improved
    [[`97a77288ce`](https://github.com/nodejs/node/commit/97a77288ce)]
    [#12348](https://github.com/nodejs/node/pull/12348),
    [[`d75fdd96aa`](https://github.com/nodejs/node/commit/d75fdd96aa)]
    [#10423](https://github.com/nodejs/node/pull/10423).
  * Child Process methods accept `Uint8Array` as input
    [[`627ecee9ed`](https://github.com/nodejs/node/commit/627ecee9ed)]
    [#10653](https://github.com/nodejs/node/pull/10653).

* **Console**
  * Error events emitted when using `console` methods are now supressed.
    [[`f18e08d820`](https://github.com/nodejs/node/commit/f18e08d820)]
    [#9744](https://github.com/nodejs/node/pull/9744).

* **Dependencies**
  * The npm client has been updated to 5.0.0
    [[`3c3b36af0f`](https://github.com/nodejs/node/commit/3c3b36af0f)]
    [#12936](https://github.com/nodejs/node/pull/12936).
  * V8 has been updated to 5.8 with forward ABI stability to 6.0
    [[`60d1aac8d2`](https://github.com/nodejs/node/commit/60d1aac8d2)]
    [#12784](https://github.com/nodejs/node/pull/12784).

* **Domains**
  * Native `Promise` instances are now `Domain` aware
    [[`84dabe8373`](https://github.com/nodejs/node/commit/84dabe8373)]
    [#12489](https://github.com/nodejs/node/pull/12489).

* **Errors**
  * We have started assigning static error codes to errors generated by Node.js.
    This has been done through multiple commits and is still a work in
    progress.

* **File System**
  * The utility class `fs.SyncWriteStream` has been deprecated
    [[`7a55e34ef4`](https://github.com/nodejs/node/commit/7a55e34ef4)]
    [#10467](https://github.com/nodejs/node/pull/10467).
  * The deprecated `fs.read()` string interface has been removed
    [[`3c2a9361ff`](https://github.com/nodejs/node/commit/3c2a9361ff)]
    [#9683](https://github.com/nodejs/node/pull/9683).

* **HTTP**
  * Improved support for userland implemented Agents
    [[`90403dd1d0`](https://github.com/nodejs/node/commit/90403dd1d0)]
    [#11567](https://github.com/nodejs/node/pull/11567).
  * Outgoing Cookie headers are concatenated into a single string
    [[`d3480776c7`](https://github.com/nodejs/node/commit/d3480776c7)]
    [#11259](https://github.com/nodejs/node/pull/11259).
  * The `httpResponse.writeHeader()` method has been deprecated
    [[`fb71ba4921`](https://github.com/nodejs/node/commit/fb71ba4921)]
    [#11355](https://github.com/nodejs/node/pull/11355).
  * New methods for accessing HTTP headers have been added to `OutgoingMessage`
    [[`3e6f1032a4`](https://github.com/nodejs/node/commit/3e6f1032a4)]
    [#10805](https://github.com/nodejs/node/pull/10805).

* **Lib**
  * All deprecation messages have been assigned static identifiers
    [[`5de3cf099c`](https://github.com/nodejs/node/commit/5de3cf099c)]
    [#10116](https://github.com/nodejs/node/pull/10116).
  * The legacy `linkedlist` module has been removed
    [[`84a23391f6`](https://github.com/nodejs/node/commit/84a23391f6)]
    [#12113](https://github.com/nodejs/node/pull/12113).

* **N-API**
  * Experimental support for the new N-API API has been added
    [[`56e881d0b0`](https://github.com/nodejs/node/commit/56e881d0b0)]
    [#11975](https://github.com/nodejs/node/pull/11975).

* **Process**
  * Process warning output can be redirected to a file using the
    `--redirect-warnings` command-line argument
    [[`03e89b3ff2`](https://github.com/nodejs/node/commit/03e89b3ff2)]
    [#10116](https://github.com/nodejs/node/pull/10116).
  * Process warnings may now include additional detail
    [[`dd20e68b0f`](https://github.com/nodejs/node/commit/dd20e68b0f)]
    [#12725](https://github.com/nodejs/node/pull/12725).

* **REPL**
  * REPL magic mode has been deprecated
    [[`3f27f02da0`](https://github.com/nodejs/node/commit/3f27f02da0)]
    [#11599](https://github.com/nodejs/node/pull/11599).

* **Src**
  * `NODE_MODULE_VERSION` has been updated to 57
    [[`ec7cbaf266`](https://github.com/nodejs/node/commit/ec7cbaf266)]
    [#12995](https://github.com/nodejs/node/pull/12995).
  * Add `--pending-deprecation` command-line argument and
    `NODE_PENDING_DEPRECATION` environment variable
    [[`a16b570f8c`](https://github.com/nodejs/node/commit/a16b570f8c)]
    [#11968](https://github.com/nodejs/node/pull/11968).
  * The `--debug` command-line argument has been deprecated. Note that
    using `--debug` will enable the *new* Inspector-based debug protocol
    as the legacy Debugger protocol previously used by Node.js has been
    removed. [[`010f864426`](https://github.com/nodejs/node/commit/010f864426)]
    [#12949](https://github.com/nodejs/node/pull/12949).
  * Throw when the `-c` and `-e` command-line arguments are used at the same
    time [[`a5f91ab230`](https://github.com/nodejs/node/commit/a5f91ab230)]
    [#11689](https://github.com/nodejs/node/pull/11689).
  * Throw when the `--use-bundled-ca` and `--use-openssl-ca` command-line
    arguments are used at the same time.
    [[`8a7db9d4b5`](https://github.com/nodejs/node/commit/8a7db9d4b5)]
    [#12087](https://github.com/nodejs/node/pull/12087).

* **Stream**
  * `Stream` now supports `destroy()` and `_destroy()` APIs
    [[`b6e1d22fa6`](https://github.com/nodejs/node/commit/b6e1d22fa6)]
    [#12925](https://github.com/nodejs/node/pull/12925).
  * `Stream` now supports the `_final()` API
    [[`07c7f198db`](https://github.com/nodejs/node/commit/07c7f198db)]
    [#12828](https://github.com/nodejs/node/pull/12828).

* **TLS**
  * The `rejectUnauthorized` option now defaults to `true`
    [[`348cc80a3c`](https://github.com/nodejs/node/commit/348cc80a3c)]
    [#5923](https://github.com/nodejs/node/pull/5923).
  * The `tls.createSecurePair()` API now emits a runtime deprecation
    [[`a2ae08999b`](https://github.com/nodejs/node/commit/a2ae08999b)]
    [#11349](https://github.com/nodejs/node/pull/11349).
  * A runtime deprecation will now be emitted when `dhparam` is less than
    2048 bits [[`d523eb9c40`](https://github.com/nodejs/node/commit/d523eb9c40)]
    [#11447](https://github.com/nodejs/node/pull/11447).

* **URL**
  * The WHATWG URL implementation is now a fully-supported Node.js API
    [[`d080ead0f9`](https://github.com/nodejs/node/commit/d080ead0f9)]
    [#12710](https://github.com/nodejs/node/pull/12710).

* **Util**
  * `Symbol` keys are now displayed by default when using `util.inspect()`
    [[`5bfd13b81e`](https://github.com/nodejs/node/commit/5bfd13b81e)]
    [#9726](https://github.com/nodejs/node/pull/9726).
  * `toJSON` errors will be thrown when formatting `%j`
    [[`455e6f1dd8`](https://github.com/nodejs/node/commit/455e6f1dd8)]
    [#11708](https://github.com/nodejs/node/pull/11708).
  * Convert `inspect.styles` and `inspect.colors` to prototype-less objects
    [[`aab0d202f8`](https://github.com/nodejs/node/commit/aab0d202f8)]
    [#11624](https://github.com/nodejs/node/pull/11624).
  * The new `util.promisify()` API has been added
    [[`99da8e8e02`](https://github.com/nodejs/node/commit/99da8e8e02)]
    [#12442](https://github.com/nodejs/node/pull/12442).

* **Zlib**
  * Support `Uint8Array` in Zlib convenience methods
    [[`91383e47fd`](https://github.com/nodejs/node/commit/91383e47fd)]
    [#12001](https://github.com/nodejs/node/pull/12001).
  * Zlib errors now use `RangeError` and `TypeError` consistently
    [[`b514bd231e`](https://github.com/nodejs/node/commit/b514bd231e)]
    [#11391](https://github.com/nodejs/node/pull/11391).

### Commits

#### Semver-Major Commits

* [[`e48d58b8b2`](https://github.com/nodejs/node/commit/e48d58b8b2)] - **(SEMVER-MAJOR)** **assert**: fix AssertionError, assign error code (James M Snell) [#12651](https://github.com/nodejs/node/pull/12651)
* [[`758b8b6e5d`](https://github.com/nodejs/node/commit/758b8b6e5d)] - **(SEMVER-MAJOR)** **assert**: improve assert.fail() API (Rich Trott) [#12293](https://github.com/nodejs/node/pull/12293)
* [[`6481c93aef`](https://github.com/nodejs/node/commit/6481c93aef)] - **(SEMVER-MAJOR)** **assert**: add support for Map and Set in deepEqual (Joseph Gentle) [#12142](https://github.com/nodejs/node/pull/12142)
* [[`efec14a7d1`](https://github.com/nodejs/node/commit/efec14a7d1)] - **(SEMVER-MAJOR)** **assert**: enforce type check in deepStrictEqual (Joyee Cheung) [#10282](https://github.com/nodejs/node/pull/10282)
* [[`562cf5a81c`](https://github.com/nodejs/node/commit/562cf5a81c)] - **(SEMVER-MAJOR)** **assert**: fix premature deep strict comparison (Joyee Cheung) [#11128](https://github.com/nodejs/node/pull/11128)
* [[`0af41834f1`](https://github.com/nodejs/node/commit/0af41834f1)] - **(SEMVER-MAJOR)** **assert**: fix misformatted error message (Rich Trott) [#11254](https://github.com/nodejs/node/pull/11254)
* [[`190dc69c89`](https://github.com/nodejs/node/commit/190dc69c89)] - **(SEMVER-MAJOR)** **benchmark**: add parameter for module benchmark (Brian White) [#10789](https://github.com/nodejs/node/pull/10789)
* [[`b888bfe81d`](https://github.com/nodejs/node/commit/b888bfe81d)] - **(SEMVER-MAJOR)** **benchmark**: allow zero when parsing http req/s (Brian White) [#10558](https://github.com/nodejs/node/pull/10558)
* [[`f53a6fb48b`](https://github.com/nodejs/node/commit/f53a6fb48b)] - **(SEMVER-MAJOR)** **benchmark**: add http header setting scenarios (Brian White) [#10558](https://github.com/nodejs/node/pull/10558)
* [[`d2d32ea5a2`](https://github.com/nodejs/node/commit/d2d32ea5a2)] - **(SEMVER-MAJOR)** **buffer**: add pending deprecation warning (James M Snell) [#11968](https://github.com/nodejs/node/pull/11968)
* [[`7eb1b4658e`](https://github.com/nodejs/node/commit/7eb1b4658e)] - **(SEMVER-MAJOR)** **buffer**: zero fill Buffer(num) by default (James M Snell) [#12141](https://github.com/nodejs/node/pull/12141)
* [[`682573c11d`](https://github.com/nodejs/node/commit/682573c11d)] - **(SEMVER-MAJOR)** **buffer**: remove error for malformatted hex string (Rich Trott) [#12012](https://github.com/nodejs/node/pull/12012)
* [[`9a0829d728`](https://github.com/nodejs/node/commit/9a0829d728)] - **(SEMVER-MAJOR)** **buffer**: stricter argument checking in toString (Nikolai Vavilov) [#11120](https://github.com/nodejs/node/pull/11120)
* [[`beca3244e2`](https://github.com/nodejs/node/commit/beca3244e2)] - **(SEMVER-MAJOR)** **buffer**: allow Uint8Array input to methods (Anna Henningsen) [#10236](https://github.com/nodejs/node/pull/10236)
* [[`3d353c749c`](https://github.com/nodejs/node/commit/3d353c749c)] - **(SEMVER-MAJOR)** **buffer**: consistent error for length \> kMaxLength (Joyee Cheung) [#10152](https://github.com/nodejs/node/pull/10152)
* [[`bf5c309b5e`](https://github.com/nodejs/node/commit/bf5c309b5e)] - **(SEMVER-MAJOR)** **build**: fix V8 build on FreeBSD (Michaël Zasso) [#12784](https://github.com/nodejs/node/pull/12784)
* [[`a1028d5e3e`](https://github.com/nodejs/node/commit/a1028d5e3e)] - **(SEMVER-MAJOR)** **build**: remove cares headers from tarball (Gibson Fahnestock) [#10283](https://github.com/nodejs/node/pull/10283)
* [[`d08836003c`](https://github.com/nodejs/node/commit/d08836003c)] - **(SEMVER-MAJOR)** **build**: build an x64 build by default on Windows (Nikolai Vavilov) [#11537](https://github.com/nodejs/node/pull/11537)
* [[`92ed1ab450`](https://github.com/nodejs/node/commit/92ed1ab450)] - **(SEMVER-MAJOR)** **build**: change nosign flag to sign and flips logic (Joe Doyle) [#10156](https://github.com/nodejs/node/pull/10156)
* [[`97a77288ce`](https://github.com/nodejs/node/commit/97a77288ce)] - **(SEMVER-MAJOR)** **child_process**: improve ChildProcess validation (cjihrig) [#12348](https://github.com/nodejs/node/pull/12348)
* [[`a9111f9738`](https://github.com/nodejs/node/commit/a9111f9738)] - **(SEMVER-MAJOR)** **child_process**: minor cleanup of internals (cjihrig) [#12348](https://github.com/nodejs/node/pull/12348)
* [[`d75fdd96aa`](https://github.com/nodejs/node/commit/d75fdd96aa)] - **(SEMVER-MAJOR)** **child_process**: improve killSignal validations (Sakthipriyan Vairamani (thefourtheye)) [#10423](https://github.com/nodejs/node/pull/10423)
* [[`4cafa60c99`](https://github.com/nodejs/node/commit/4cafa60c99)] - **(SEMVER-MAJOR)** **child_process**: align fork/spawn stdio error msg (Sam Roberts) [#11044](https://github.com/nodejs/node/pull/11044)
* [[`3268863ebc`](https://github.com/nodejs/node/commit/3268863ebc)] - **(SEMVER-MAJOR)** **child_process**: add string shortcut for fork stdio (Javis Sullivan) [#10866](https://github.com/nodejs/node/pull/10866)
* [[`8f3ff98f0e`](https://github.com/nodejs/node/commit/8f3ff98f0e)] - **(SEMVER-MAJOR)** **child_process**: allow Infinity as maxBuffer value (cjihrig) [#10769](https://github.com/nodejs/node/pull/10769)
* [[`627ecee9ed`](https://github.com/nodejs/node/commit/627ecee9ed)] - **(SEMVER-MAJOR)** **child_process**: support Uint8Array input to methods (Anna Henningsen) [#10653](https://github.com/nodejs/node/pull/10653)
* [[`fc7b0dda85`](https://github.com/nodejs/node/commit/fc7b0dda85)] - **(SEMVER-MAJOR)** **child_process**: improve input validation (cjihrig) [#8312](https://github.com/nodejs/node/pull/8312)
* [[`49d1c366d8`](https://github.com/nodejs/node/commit/49d1c366d8)] - **(SEMVER-MAJOR)** **child_process**: remove extra newline in errors (cjihrig) [#9343](https://github.com/nodejs/node/pull/9343)
* [[`f18e08d820`](https://github.com/nodejs/node/commit/f18e08d820)] - **(SEMVER-MAJOR)** **console**: do not emit error events (Anna Henningsen) [#9744](https://github.com/nodejs/node/pull/9744)
* [[`a8f460f12d`](https://github.com/nodejs/node/commit/a8f460f12d)] - **(SEMVER-MAJOR)** **crypto**: support all ArrayBufferView types (Timothy Gu) [#12223](https://github.com/nodejs/node/pull/12223)
* [[`0db49fef41`](https://github.com/nodejs/node/commit/0db49fef41)] - **(SEMVER-MAJOR)** **crypto**: support Uint8Array prime in createDH (Anna Henningsen) [#11983](https://github.com/nodejs/node/pull/11983)
* [[`443691a5ae`](https://github.com/nodejs/node/commit/443691a5ae)] - **(SEMVER-MAJOR)** **crypto**: fix default encoding of LazyTransform (Lukas Möller) [#8611](https://github.com/nodejs/node/pull/8611)
* [[`9f74184e98`](https://github.com/nodejs/node/commit/9f74184e98)] - **(SEMVER-MAJOR)** **crypto**: upgrade pbkdf2 without digest to an error (James M Snell) [#11305](https://github.com/nodejs/node/pull/11305)
* [[`e90f38270c`](https://github.com/nodejs/node/commit/e90f38270c)] - **(SEMVER-MAJOR)** **crypto**: throw error in CipherBase::SetAutoPadding (Kirill Fomichev) [#9405](https://github.com/nodejs/node/pull/9405)
* [[`1ef401ce92`](https://github.com/nodejs/node/commit/1ef401ce92)] - **(SEMVER-7aa5a993b25eb333768503b5320224045df0d14a)** **crypto**: use check macros in CipherBase::SetAuthTag (Kirill Fomichev) [#9395](https://github.com/nodejs/node/pull/9395)
* [[`7599b0ef9d`](https://github.com/nodejs/node/commit/7599b0ef9d)] - **(SEMVER-MAJOR)** **debug**: activate inspector with _debugProcess (Eugene Ostroukhov) [#11431](https://github.com/nodejs/node/pull/11431)
* [[`549e81bfa1`](https://github.com/nodejs/node/commit/549e81bfa1)] - **(SEMVER-MAJOR)** **debugger**: remove obsolete _debug_agent.js (Rich Trott) [#12582](https://github.com/nodejs/node/pull/12582)
* [[`3c3b36af0f`](https://github.com/nodejs/node/commit/3c3b36af0f)] - **(SEMVER-MAJOR)** **deps**: upgrade npm beta to 5.0.0-beta.56 (Kat Marchán) [#12936](https://github.com/nodejs/node/pull/12936)
* [[`6690415696`](https://github.com/nodejs/node/commit/6690415696)] - **(SEMVER-MAJOR)** **deps**: cherry-pick a927f81c7 from V8 upstream (Anna Henningsen) [#11752](https://github.com/nodejs/node/pull/11752)
* [[`60d1aac8d2`](https://github.com/nodejs/node/commit/60d1aac8d2)] - **(SEMVER-MAJOR)** **deps**: update V8 to 5.8.283.38 (Michaël Zasso) [#12784](https://github.com/nodejs/node/pull/12784)
* [[`b7608ac707`](https://github.com/nodejs/node/commit/b7608ac707)] - **(SEMVER-MAJOR)** **deps**: cherry-pick node-inspect#43 (Ali Ijaz Sheikh) [#11441](https://github.com/nodejs/node/pull/11441)
* [[`9c9e2d7f4a`](https://github.com/nodejs/node/commit/9c9e2d7f4a)] - **(SEMVER-MAJOR)** **deps**: backport 3297130 from upstream V8 (Michaël Zasso) [#11752](https://github.com/nodejs/node/pull/11752)
* [[`07088e6fc1`](https://github.com/nodejs/node/commit/07088e6fc1)] - **(SEMVER-MAJOR)** **deps**: backport 39642fa from upstream V8 (Michaël Zasso) [#11752](https://github.com/nodejs/node/pull/11752)
* [[`8394b05e20`](https://github.com/nodejs/node/commit/8394b05e20)] - **(SEMVER-MAJOR)** **deps**: cherry-pick c5c570f from upstream V8 (Michaël Zasso) [#11752](https://github.com/nodejs/node/pull/11752)
* [[`fcc58bf0da`](https://github.com/nodejs/node/commit/fcc58bf0da)] - **(SEMVER-MAJOR)** **deps**: cherry-pick a927f81c7 from V8 upstream (Anna Henningsen) [#11752](https://github.com/nodejs/node/pull/11752)
* [[`83bf2975ec`](https://github.com/nodejs/node/commit/83bf2975ec)] - **(SEMVER-MAJOR)** **deps**: cherry-pick V8 ValueSerializer changes (Anna Henningsen) [#11752](https://github.com/nodejs/node/pull/11752)
* [[`c459d8ea5d`](https://github.com/nodejs/node/commit/c459d8ea5d)] - **(SEMVER-MAJOR)** **deps**: update V8 to 5.7.492.69 (Michaël Zasso) [#11752](https://github.com/nodejs/node/pull/11752)
* [[`7c0c7baff3`](https://github.com/nodejs/node/commit/7c0c7baff3)] - **(SEMVER-MAJOR)** **deps**: fix gyp configuration for v8-inspector (Michaël Zasso) [#10992](https://github.com/nodejs/node/pull/10992)
* [[`00a2aa0af5`](https://github.com/nodejs/node/commit/00a2aa0af5)] - **(SEMVER-MAJOR)** **deps**: fix gyp build configuration for Windows (Michaël Zasso) [#10992](https://github.com/nodejs/node/pull/10992)
* [[`b30ec59855`](https://github.com/nodejs/node/commit/b30ec59855)] - **(SEMVER-MAJOR)** **deps**: switch to v8_inspector in V8 (Ali Ijaz Sheikh) [#10992](https://github.com/nodejs/node/pull/10992)
* [[`7a77daf243`](https://github.com/nodejs/node/commit/7a77daf243)] - **(SEMVER-MAJOR)** **deps**: update V8 to 5.6.326.55 (Michaël Zasso) [#10992](https://github.com/nodejs/node/pull/10992)
* [[`c9e5178f3c`](https://github.com/nodejs/node/commit/c9e5178f3c)] - **(SEMVER-MAJOR)** **deps**: hide zlib internal symbols (Sam Roberts) [#11082](https://github.com/nodejs/node/pull/11082)
* [[`2739185b79`](https://github.com/nodejs/node/commit/2739185b79)] - **(SEMVER-MAJOR)** **deps**: update V8 to 5.5.372.40 (Michaël Zasso) [#9618](https://github.com/nodejs/node/pull/9618)
* [[`f2e3a670af`](https://github.com/nodejs/node/commit/f2e3a670af)] - **(SEMVER-MAJOR)** **dgram**: convert to using internal/errors (Michael Dawson) [#12926](https://github.com/nodejs/node/pull/12926)
* [[`2dc1053b0a`](https://github.com/nodejs/node/commit/2dc1053b0a)] - **(SEMVER-MAJOR)** **dgram**: support Uint8Array input to send() (Anna Henningsen) [#11985](https://github.com/nodejs/node/pull/11985)
* [[`32679c73c1`](https://github.com/nodejs/node/commit/32679c73c1)] - **(SEMVER-MAJOR)** **dgram**: improve signature of Socket.prototype.send (Christopher Hiller) [#10473](https://github.com/nodejs/node/pull/10473)
* [[`5587ff1ccd`](https://github.com/nodejs/node/commit/5587ff1ccd)] - **(SEMVER-MAJOR)** **dns**: handle implicit bind DNS errors (cjihrig) [#11036](https://github.com/nodejs/node/pull/11036)
* [[`eb535c5154`](https://github.com/nodejs/node/commit/eb535c5154)] - **(SEMVER-MAJOR)** **doc**: deprecate vm.runInDebugContext (Josh Gavant) [#12243](https://github.com/nodejs/node/pull/12243)
* [[`75c471a026`](https://github.com/nodejs/node/commit/75c471a026)] - **(SEMVER-MAJOR)** **doc**: drop PPC BE from supported platforms (Michael Dawson) [#12309](https://github.com/nodejs/node/pull/12309)
* [[`86996c5838`](https://github.com/nodejs/node/commit/86996c5838)] - **(SEMVER-MAJOR)** **doc**: deprecate private http properties (Brian White) [#10941](https://github.com/nodejs/node/pull/10941)
* [[`3d8379ae60`](https://github.com/nodejs/node/commit/3d8379ae60)] - **(SEMVER-MAJOR)** **doc**: improve assert.md regarding ECMAScript terms (Joyee Cheung) [#11128](https://github.com/nodejs/node/pull/11128)
* [[`d708700c68`](https://github.com/nodejs/node/commit/d708700c68)] - **(SEMVER-MAJOR)** **doc**: deprecate buffer's parent property (Sakthipriyan Vairamani (thefourtheye)) [#8332](https://github.com/nodejs/node/pull/8332)
* [[`03d440e3ce`](https://github.com/nodejs/node/commit/03d440e3ce)] - **(SEMVER-MAJOR)** **doc**: document buffer.buffer property (Sakthipriyan Vairamani (thefourtheye)) [#8332](https://github.com/nodejs/node/pull/8332)
* [[`f0b702555a`](https://github.com/nodejs/node/commit/f0b702555a)] - **(SEMVER-MAJOR)** **errors**: use lazy assert to avoid issues on startup (James M Snell) [#11300](https://github.com/nodejs/node/pull/11300)
* [[`251e5ed8ee`](https://github.com/nodejs/node/commit/251e5ed8ee)] - **(SEMVER-MAJOR)** **errors**: assign error code to bootstrap_node created error (James M Snell) [#11298](https://github.com/nodejs/node/pull/11298)
* [[`e75bc87d22`](https://github.com/nodejs/node/commit/e75bc87d22)] - **(SEMVER-MAJOR)** **errors**: port internal/process errors to internal/errors (James M Snell) [#11294](https://github.com/nodejs/node/pull/11294)
* [[`76327613af`](https://github.com/nodejs/node/commit/76327613af)] - **(SEMVER-MAJOR)** **errors, child_process**: migrate to using internal/errors (James M Snell) [#11300](https://github.com/nodejs/node/pull/11300)
* [[`1c834e78ff`](https://github.com/nodejs/node/commit/1c834e78ff)] - **(SEMVER-MAJOR)** **errors,test**: migrating error to internal/errors (larissayvette) [#11505](https://github.com/nodejs/node/pull/11505)
* [[`2141d37452`](https://github.com/nodejs/node/commit/2141d37452)] - **(SEMVER-MAJOR)** **events**: update and clarify error message (Chris Burkhart) [#10387](https://github.com/nodejs/node/pull/10387)
* [[`221b03ad20`](https://github.com/nodejs/node/commit/221b03ad20)] - **(SEMVER-MAJOR)** **events, doc**: check input in defaultMaxListeners (DavidCai) [#11938](https://github.com/nodejs/node/pull/11938)
* [[`eed87b1637`](https://github.com/nodejs/node/commit/eed87b1637)] - **(SEMVER-MAJOR)** **fs**: (+/-)Infinity and NaN invalid unixtimestamp (Luca Maraschi) [#11919](https://github.com/nodejs/node/pull/11919)
* [[`71097744b2`](https://github.com/nodejs/node/commit/71097744b2)] - **(SEMVER-MAJOR)** **fs**: more realpath*() optimizations (Brian White) [#11665](https://github.com/nodejs/node/pull/11665)
* [[`6a5ab5d550`](https://github.com/nodejs/node/commit/6a5ab5d550)] - **(SEMVER-MAJOR)** **fs**: include more fs.stat*() optimizations (Brian White) [#11665](https://github.com/nodejs/node/pull/11665)
* [[`1c3df96570`](https://github.com/nodejs/node/commit/1c3df96570)] - **(SEMVER-MAJOR)** **fs**: replace regexp with function (Brian White) [#10789](https://github.com/nodejs/node/pull/10789)
* [[`34c9fc2e4e`](https://github.com/nodejs/node/commit/34c9fc2e4e)] - **(SEMVER-MAJOR)** **fs**: avoid multiple conversions to string (Brian White) [#10789](https://github.com/nodejs/node/pull/10789)
* [[`21b2440176`](https://github.com/nodejs/node/commit/21b2440176)] - **(SEMVER-MAJOR)** **fs**: avoid recompilation of closure (Brian White) [#10789](https://github.com/nodejs/node/pull/10789)
* [[`7a55e34ef4`](https://github.com/nodejs/node/commit/7a55e34ef4)] - **(SEMVER-MAJOR)** **fs**: runtime deprecation for fs.SyncWriteStream (James M Snell) [#10467](https://github.com/nodejs/node/pull/10467)
* [[`b1fc7745f2`](https://github.com/nodejs/node/commit/b1fc7745f2)] - **(SEMVER-MAJOR)** **fs**: avoid emitting error EBADF for double close (Matteo Collina) [#11225](https://github.com/nodejs/node/pull/11225)
* [[`3c2a9361ff`](https://github.com/nodejs/node/commit/3c2a9361ff)] - **(SEMVER-MAJOR)** **fs**: remove fs.read's string interface (Nikolai Vavilov) [#9683](https://github.com/nodejs/node/pull/9683)
* [[`f3cf8e9808`](https://github.com/nodejs/node/commit/f3cf8e9808)] - **(SEMVER-MAJOR)** **fs**: do not pass Buffer when toString() fails (Brian White) [#9670](https://github.com/nodejs/node/pull/9670)
* [[`85a4e25775`](https://github.com/nodejs/node/commit/85a4e25775)] - **(SEMVER-MAJOR)** **http**: add type checking for hostname (James M Snell) [#12494](https://github.com/nodejs/node/pull/12494)
* [[`90403dd1d0`](https://github.com/nodejs/node/commit/90403dd1d0)] - **(SEMVER-MAJOR)** **http**: should support userland Agent (fengmk2) [#11567](https://github.com/nodejs/node/pull/11567)
* [[`d3480776c7`](https://github.com/nodejs/node/commit/d3480776c7)] - **(SEMVER-MAJOR)** **http**: concatenate outgoing Cookie headers (Brian White) [#11259](https://github.com/nodejs/node/pull/11259)
* [[`6b2cef65c9`](https://github.com/nodejs/node/commit/6b2cef65c9)] - **(SEMVER-MAJOR)** **http**: append Cookie header values with semicolon (Brian White) [#11259](https://github.com/nodejs/node/pull/11259)
* [[`8243ca0e0e`](https://github.com/nodejs/node/commit/8243ca0e0e)] - **(SEMVER-MAJOR)** **http**: reuse existing StorageObject (Brian White) [#10941](https://github.com/nodejs/node/pull/10941)
* [[`b377034359`](https://github.com/nodejs/node/commit/b377034359)] - **(SEMVER-MAJOR)** **http**: support old private properties and function (Brian White) [#10941](https://github.com/nodejs/node/pull/10941)
* [[`940b5303be`](https://github.com/nodejs/node/commit/940b5303be)] - **(SEMVER-MAJOR)** **http**: use Symbol for outgoing headers (Brian White) [#10941](https://github.com/nodejs/node/pull/10941)
* [[`fb71ba4921`](https://github.com/nodejs/node/commit/fb71ba4921)] - **(SEMVER-MAJOR)** **http**: docs-only deprecation of res.writeHeader() (James M Snell) [#11355](https://github.com/nodejs/node/pull/11355)
* [[`a4bb9fdb89`](https://github.com/nodejs/node/commit/a4bb9fdb89)] - **(SEMVER-MAJOR)** **http**: include provided status code in range error (cjihrig) [#11221](https://github.com/nodejs/node/pull/11221)
* [[`fc7025c9c0`](https://github.com/nodejs/node/commit/fc7025c9c0)] - **(SEMVER-MAJOR)** **http**: throw an error for unexpected agent values (brad-decker) [#10053](https://github.com/nodejs/node/pull/10053)
* [[`176cdc2823`](https://github.com/nodejs/node/commit/176cdc2823)] - **(SEMVER-MAJOR)** **http**: misc optimizations and style fixes (Brian White) [#10558](https://github.com/nodejs/node/pull/10558)
* [[`73d9445782`](https://github.com/nodejs/node/commit/73d9445782)] - **(SEMVER-MAJOR)** **http**: try to avoid lowercasing incoming headers (Brian White) [#10558](https://github.com/nodejs/node/pull/10558)
* [[`c77ed327d9`](https://github.com/nodejs/node/commit/c77ed327d9)] - **(SEMVER-MAJOR)** **http**: avoid using object for removed header status (Brian White) [#10558](https://github.com/nodejs/node/pull/10558)
* [[`c00e4adbb4`](https://github.com/nodejs/node/commit/c00e4adbb4)] - **(SEMVER-MAJOR)** **http**: optimize header storage and matching (Brian White) [#10558](https://github.com/nodejs/node/pull/10558)
* [[`ec8910bcea`](https://github.com/nodejs/node/commit/ec8910bcea)] - **(SEMVER-MAJOR)** **http**: check statusCode early (Brian White) [#10558](https://github.com/nodejs/node/pull/10558)
* [[`a73ab9de0d`](https://github.com/nodejs/node/commit/a73ab9de0d)] - **(SEMVER-MAJOR)** **http**: remove pointless use of arguments (cjihrig) [#10664](https://github.com/nodejs/node/pull/10664)
* [[`df3978421b`](https://github.com/nodejs/node/commit/df3978421b)] - **(SEMVER-MAJOR)** **http**: verify client method is a string (Luca Maraschi) [#10111](https://github.com/nodejs/node/pull/10111)
* [[`90476ac6ee`](https://github.com/nodejs/node/commit/90476ac6ee)] - **(SEMVER-MAJOR)** **lib**: remove _debugger.js (Ben Noordhuis) [#12495](https://github.com/nodejs/node/pull/12495)
* [[`3209a8ebf3`](https://github.com/nodejs/node/commit/3209a8ebf3)] - **(SEMVER-MAJOR)** **lib**: ensure --check flag works for piped-in code (Teddy Katz) [#11689](https://github.com/nodejs/node/pull/11689)
* [[`c67207731f`](https://github.com/nodejs/node/commit/c67207731f)] - **(SEMVER-MAJOR)** **lib**: simplify Module._resolveLookupPaths (Brian White) [#10789](https://github.com/nodejs/node/pull/10789)
* [[`28dc848e70`](https://github.com/nodejs/node/commit/28dc848e70)] - **(SEMVER-MAJOR)** **lib**: improve method of function calling (Brian White) [#10789](https://github.com/nodejs/node/pull/10789)
* [[`a851b868c0`](https://github.com/nodejs/node/commit/a851b868c0)] - **(SEMVER-MAJOR)** **lib**: remove sources of permanent deopts (Brian White) [#10789](https://github.com/nodejs/node/pull/10789)
* [[`62e96096fa`](https://github.com/nodejs/node/commit/62e96096fa)] - **(SEMVER-MAJOR)** **lib**: more consistent use of module.exports = {} model (James M Snell) [#11406](https://github.com/nodejs/node/pull/11406)
* [[`88c3f57cc3`](https://github.com/nodejs/node/commit/88c3f57cc3)] - **(SEMVER-MAJOR)** **lib**: refactor internal/socket_list (James M Snell) [#11406](https://github.com/nodejs/node/pull/11406)
* [[`f04387e9f2`](https://github.com/nodejs/node/commit/f04387e9f2)] - **(SEMVER-MAJOR)** **lib**: refactor internal/freelist (James M Snell) [#11406](https://github.com/nodejs/node/pull/11406)
* [[`d61a511728`](https://github.com/nodejs/node/commit/d61a511728)] - **(SEMVER-MAJOR)** **lib**: refactor internal/linkedlist (James M Snell) [#11406](https://github.com/nodejs/node/pull/11406)
* [[`2ba4eeadbb`](https://github.com/nodejs/node/commit/2ba4eeadbb)] - **(SEMVER-MAJOR)** **lib**: remove simd support from util.format() (Ben Noordhuis) [#11346](https://github.com/nodejs/node/pull/11346)
* [[`dfdd911e17`](https://github.com/nodejs/node/commit/dfdd911e17)] - **(SEMVER-MAJOR)** **lib**: deprecate node --debug at runtime (Josh Gavant) [#10970](https://github.com/nodejs/node/pull/10970)
* [[`5de3cf099c`](https://github.com/nodejs/node/commit/5de3cf099c)] - **(SEMVER-MAJOR)** **lib**: add static identifier codes for all deprecations (James M Snell) [#10116](https://github.com/nodejs/node/pull/10116)
* [[`4775942957`](https://github.com/nodejs/node/commit/4775942957)] - **(SEMVER-MAJOR)** **lib, test**: fix server.listen error message (Joyee Cheung) [#11693](https://github.com/nodejs/node/pull/11693)
* [[`caf9ae748b`](https://github.com/nodejs/node/commit/caf9ae748b)] - **(SEMVER-MAJOR)** **lib,src**: make constants not inherit from Object (Sakthipriyan Vairamani (thefourtheye)) [#10458](https://github.com/nodejs/node/pull/10458)
* [[`e0b076a949`](https://github.com/nodejs/node/commit/e0b076a949)] - **(SEMVER-MAJOR)** **lib,src,test**: update --debug/debug-brk comments (Ben Noordhuis) [#12495](https://github.com/nodejs/node/pull/12495)
* [[`b40dab553f`](https://github.com/nodejs/node/commit/b40dab553f)] - **(SEMVER-MAJOR)** **linkedlist**: remove unused methods (Brian White) [#11726](https://github.com/nodejs/node/pull/11726)
* [[`84a23391f6`](https://github.com/nodejs/node/commit/84a23391f6)] - **(SEMVER-MAJOR)** **linkedlist**: remove public module (Brian White) [#12113](https://github.com/nodejs/node/pull/12113)
* [[`e32425bfcd`](https://github.com/nodejs/node/commit/e32425bfcd)] - **(SEMVER-MAJOR)** **module**: avoid JSON.stringify() for cache key (Brian White) [#10789](https://github.com/nodejs/node/pull/10789)
* [[`403b89e72b`](https://github.com/nodejs/node/commit/403b89e72b)] - **(SEMVER-MAJOR)** **module**: avoid hasOwnProperty() (Brian White) [#10789](https://github.com/nodejs/node/pull/10789)
* [[`298a40e04e`](https://github.com/nodejs/node/commit/298a40e04e)] - **(SEMVER-MAJOR)** **module**: use "clean" objects (Brian White) [#10789](https://github.com/nodejs/node/pull/10789)
* [[`cf980b0311`](https://github.com/nodejs/node/commit/cf980b0311)] - **(SEMVER-MAJOR)** **net**: check and throw on error for getsockname (Daniel Bevenius) [#12871](https://github.com/nodejs/node/pull/12871)
* [[`473572ea25`](https://github.com/nodejs/node/commit/473572ea25)] - **(SEMVER-MAJOR)** **os**: refactor os structure, add Symbol.toPrimitive (James M Snell) [#12654](https://github.com/nodejs/node/pull/12654)
* [[`03e89b3ff2`](https://github.com/nodejs/node/commit/03e89b3ff2)] - **(SEMVER-MAJOR)** **process**: add --redirect-warnings command line argument (James M Snell) [#10116](https://github.com/nodejs/node/pull/10116)
* [[`5e1f32fd94`](https://github.com/nodejs/node/commit/5e1f32fd94)] - **(SEMVER-MAJOR)** **process**: add optional code to warnings + type checking (James M Snell) [#10116](https://github.com/nodejs/node/pull/10116)
* [[`a647d82f83`](https://github.com/nodejs/node/commit/a647d82f83)] - **(SEMVER-MAJOR)** **process**: improve process.hrtime (Joyee Cheung) [#10764](https://github.com/nodejs/node/pull/10764)
* [[`4e259b21a3`](https://github.com/nodejs/node/commit/4e259b21a3)] - **(SEMVER-MAJOR)** **querystring, url**: handle repeated sep in search (Daijiro Wachi) [#10967](https://github.com/nodejs/node/pull/10967)
* [[`39d9afe279`](https://github.com/nodejs/node/commit/39d9afe279)] - **(SEMVER-MAJOR)** **repl**: refactor `LineParser` implementation (Blake Embrey) [#6171](https://github.com/nodejs/node/pull/6171)
* [[`3f27f02da0`](https://github.com/nodejs/node/commit/3f27f02da0)] - **(SEMVER-MAJOR)** **repl**: docs-only deprecation of magic mode (Timothy Gu) [#11599](https://github.com/nodejs/node/pull/11599)
* [[`b77c89022b`](https://github.com/nodejs/node/commit/b77c89022b)] - **(SEMVER-MAJOR)** **repl**: remove magic mode semantics (Timothy Gu) [#11599](https://github.com/nodejs/node/pull/11599)
* [[`007386ee81`](https://github.com/nodejs/node/commit/007386ee81)] - **(SEMVER-MAJOR)** **repl**: remove workaround for function redefinition (Michaël Zasso) [#9618](https://github.com/nodejs/node/pull/9618)
* [[`5b63fabfd8`](https://github.com/nodejs/node/commit/5b63fabfd8)] - **(SEMVER-MAJOR)** **src**: update NODE_MODULE_VERSION to 55 (Michaël Zasso) [#12784](https://github.com/nodejs/node/pull/12784)
* [[`a16b570f8c`](https://github.com/nodejs/node/commit/a16b570f8c)] - **(SEMVER-MAJOR)** **src**: add --pending-deprecation and NODE_PENDING_DEPRECATION (James M Snell) [#11968](https://github.com/nodejs/node/pull/11968)
* [[`faa447b256`](https://github.com/nodejs/node/commit/faa447b256)] - **(SEMVER-MAJOR)** **src**: allow ArrayBufferView as instance of Buffer (Timothy Gu) [#12223](https://github.com/nodejs/node/pull/12223)
* [[`47f8f7462f`](https://github.com/nodejs/node/commit/47f8f7462f)] - **(SEMVER-MAJOR)** **src**: remove support for --debug (Jan Krems) [#12197](https://github.com/nodejs/node/pull/12197)
* [[`a5f91ab230`](https://github.com/nodejs/node/commit/a5f91ab230)] - **(SEMVER-MAJOR)** **src**: throw when -c and -e are used simultaneously (Teddy Katz) [#11689](https://github.com/nodejs/node/pull/11689)
* [[`8a7db9d4b5`](https://github.com/nodejs/node/commit/8a7db9d4b5)] - **(SEMVER-MAJOR)** **src**: add --use-bundled-ca --use-openssl-ca check (Daniel Bevenius) [#12087](https://github.com/nodejs/node/pull/12087)
* [[`ed12ea371c`](https://github.com/nodejs/node/commit/ed12ea371c)] - **(SEMVER-MAJOR)** **src**: update inspector code to match upstream API (Michaël Zasso) [#11752](https://github.com/nodejs/node/pull/11752)
* [[`89d8dc9afd`](https://github.com/nodejs/node/commit/89d8dc9afd)] - **(SEMVER-MAJOR)** **src**: update NODE_MODULE_VERSION to 54 (Michaël Zasso) [#11752](https://github.com/nodejs/node/pull/11752)
* [[`1125c8a814`](https://github.com/nodejs/node/commit/1125c8a814)] - **(SEMVER-MAJOR)** **src**: fix typos in node_lttng_provider.h (Benjamin Fleischer) [#11723](https://github.com/nodejs/node/pull/11723)
* [[`aae8f683b4`](https://github.com/nodejs/node/commit/aae8f683b4)] - **(SEMVER-MAJOR)** **src**: update NODE_MODULE_VERSION to 53 (Michaël Zasso) [#10992](https://github.com/nodejs/node/pull/10992)
* [[`91ab09fe2a`](https://github.com/nodejs/node/commit/91ab09fe2a)] - **(SEMVER-MAJOR)** **src**: update NODE_MODULE_VERSION to 52 (Michaël Zasso) [#9618](https://github.com/nodejs/node/pull/9618)
* [[`334be0feba`](https://github.com/nodejs/node/commit/334be0feba)] - **(SEMVER-MAJOR)** **src**: fix space for module version mismatch error (Yann Pringault) [#10606](https://github.com/nodejs/node/pull/10606)
* [[`45c9ca7fd4`](https://github.com/nodejs/node/commit/45c9ca7fd4)] - **(SEMVER-MAJOR)** **src**: remove redundant spawn/spawnSync type checks (cjihrig) [#8312](https://github.com/nodejs/node/pull/8312)
* [[`b374ee8c3d`](https://github.com/nodejs/node/commit/b374ee8c3d)] - **(SEMVER-MAJOR)** **src**: add handle check to spawn_sync (cjihrig) [#8312](https://github.com/nodejs/node/pull/8312)
* [[`3295a7feba`](https://github.com/nodejs/node/commit/3295a7feba)] - **(SEMVER-MAJOR)** **src**: allow getting Symbols on process.env (Anna Henningsen) [#9631](https://github.com/nodejs/node/pull/9631)
* [[`1aa595e5bd`](https://github.com/nodejs/node/commit/1aa595e5bd)] - **(SEMVER-MAJOR)** **src**: throw on process.env symbol usage (cjihrig) [#9446](https://github.com/nodejs/node/pull/9446)
* [[`a235ccd168`](https://github.com/nodejs/node/commit/a235ccd168)] - **(SEMVER-MAJOR)** **src,test**: debug is now an alias for inspect (Ali Ijaz Sheikh) [#11441](https://github.com/nodejs/node/pull/11441)
* [[`b6e1d22fa6`](https://github.com/nodejs/node/commit/b6e1d22fa6)] - **(SEMVER-MAJOR)** **stream**: add destroy and _destroy methods. (Matteo Collina) [#12925](https://github.com/nodejs/node/pull/12925)
* [[`f36c970cf3`](https://github.com/nodejs/node/commit/f36c970cf3)] - **(SEMVER-MAJOR)** **stream**: improve multiple callback error message (cjihrig) [#12520](https://github.com/nodejs/node/pull/12520)
* [[`202b07f414`](https://github.com/nodejs/node/commit/202b07f414)] - **(SEMVER-MAJOR)** **stream**: fix comment for sync flag of ReadableState (Wang Xinyong) [#11139](https://github.com/nodejs/node/pull/11139)
* [[`1004b9b4ad`](https://github.com/nodejs/node/commit/1004b9b4ad)] - **(SEMVER-MAJOR)** **stream**: remove unused `ranOut` from ReadableState (Wang Xinyong) [#11139](https://github.com/nodejs/node/pull/11139)
* [[`03b9f6fe26`](https://github.com/nodejs/node/commit/03b9f6fe26)] - **(SEMVER-MAJOR)** **stream**: avoid instanceof (Brian White) [#10558](https://github.com/nodejs/node/pull/10558)
* [[`a3539ae3be`](https://github.com/nodejs/node/commit/a3539ae3be)] - **(SEMVER-MAJOR)** **stream**: use plain objects for write/corked reqs (Brian White) [#10558](https://github.com/nodejs/node/pull/10558)
* [[`24ef1e6775`](https://github.com/nodejs/node/commit/24ef1e6775)] - **(SEMVER-MAJOR)** **string_decoder**: align UTF-8 handling with V8 (Brian White) [#9618](https://github.com/nodejs/node/pull/9618)
* [[`23fc082409`](https://github.com/nodejs/node/commit/23fc082409)] - **(SEMVER-MAJOR)** **test**: remove extra console output from test-os.js (James M Snell) [#12654](https://github.com/nodejs/node/pull/12654)
* [[`59c6230861`](https://github.com/nodejs/node/commit/59c6230861)] - **(SEMVER-MAJOR)** **test**: cleanup test-child-process-constructor.js (cjihrig) [#12348](https://github.com/nodejs/node/pull/12348)
* [[`06c29a66d4`](https://github.com/nodejs/node/commit/06c29a66d4)] - **(SEMVER-MAJOR)** **test**: remove common.fail() (Rich Trott) [#12293](https://github.com/nodejs/node/pull/12293)
* [[`0c539faac3`](https://github.com/nodejs/node/commit/0c539faac3)] - **(SEMVER-MAJOR)** **test**: add common.getArrayBufferViews(buf) (Timothy Gu) [#12223](https://github.com/nodejs/node/pull/12223)
* [[`c5d1851ac4`](https://github.com/nodejs/node/commit/c5d1851ac4)] - **(SEMVER-MAJOR)** **test**: drop v5.x-specific code path from simd test (Ben Noordhuis) [#11346](https://github.com/nodejs/node/pull/11346)
* [[`c2c6ae52ea`](https://github.com/nodejs/node/commit/c2c6ae52ea)] - **(SEMVER-MAJOR)** **test**: move test-vm-function-redefinition to parallel (Franziska Hinkelmann) [#9618](https://github.com/nodejs/node/pull/9618)
* [[`5b30c4f24d`](https://github.com/nodejs/node/commit/5b30c4f24d)] - **(SEMVER-MAJOR)** **test**: refactor test-child-process-spawnsync-maxbuf (cjihrig) [#10769](https://github.com/nodejs/node/pull/10769)
* [[`348cc80a3c`](https://github.com/nodejs/node/commit/348cc80a3c)] - **(SEMVER-MAJOR)** **tls**: make rejectUnauthorized default to true (ghaiklor) [#5923](https://github.com/nodejs/node/pull/5923)
* [[`a2ae08999b`](https://github.com/nodejs/node/commit/a2ae08999b)] - **(SEMVER-MAJOR)** **tls**: runtime deprecation for tls.createSecurePair() (James M Snell) [#11349](https://github.com/nodejs/node/pull/11349)
* [[`d523eb9c40`](https://github.com/nodejs/node/commit/d523eb9c40)] - **(SEMVER-MAJOR)** **tls**: use emitWarning() for dhparam \< 2048 bits (James M Snell) [#11447](https://github.com/nodejs/node/pull/11447)
* [[`e03a929648`](https://github.com/nodejs/node/commit/e03a929648)] - **(SEMVER-MAJOR)** **tools**: update test-npm.sh paths (Kat Marchán) [#12936](https://github.com/nodejs/node/pull/12936)
* [[`6f202ef857`](https://github.com/nodejs/node/commit/6f202ef857)] - **(SEMVER-MAJOR)** **tools**: remove assert.fail() lint rule (Rich Trott) [#12293](https://github.com/nodejs/node/pull/12293)
* [[`615789b723`](https://github.com/nodejs/node/commit/615789b723)] - **(SEMVER-MAJOR)** **tools**: enable ES2017 syntax support in ESLint (Michaël Zasso) [#11210](https://github.com/nodejs/node/pull/11210)
* [[`1b63fa1096`](https://github.com/nodejs/node/commit/1b63fa1096)] - **(SEMVER-MAJOR)** **tty**: remove NODE_TTY_UNSAFE_ASYNC (Jeremiah Senkpiel) [#12057](https://github.com/nodejs/node/pull/12057)
* [[`78182458e6`](https://github.com/nodejs/node/commit/78182458e6)] - **(SEMVER-MAJOR)** **url**: fix error message of url.format (DavidCai) [#11162](https://github.com/nodejs/node/pull/11162)
* [[`c65d55f087`](https://github.com/nodejs/node/commit/c65d55f087)] - **(SEMVER-MAJOR)** **url**: do not truncate long hostnames (Junshu Okamoto) [#9292](https://github.com/nodejs/node/pull/9292)
* [[`3cc3e099be`](https://github.com/nodejs/node/commit/3cc3e099be)] - **(SEMVER-MAJOR)** **util**: show External values explicitly in inspect (Anna Henningsen) [#12151](https://github.com/nodejs/node/pull/12151)
* [[`4a5a9445b5`](https://github.com/nodejs/node/commit/4a5a9445b5)] - **(SEMVER-MAJOR)** **util**: use `\[Array\]` for deeply nested arrays (Anna Henningsen) [#12046](https://github.com/nodejs/node/pull/12046)
* [[`5bfd13b81e`](https://github.com/nodejs/node/commit/5bfd13b81e)] - **(SEMVER-MAJOR)** **util**: display Symbol keys in inspect by default (Shahar Or) [#9726](https://github.com/nodejs/node/pull/9726)
* [[`455e6f1dd8`](https://github.com/nodejs/node/commit/455e6f1dd8)] - **(SEMVER-MAJOR)** **util**: throw toJSON errors when formatting %j (Timothy Gu) [#11708](https://github.com/nodejs/node/pull/11708)
* [[`ec2f098156`](https://github.com/nodejs/node/commit/ec2f098156)] - **(SEMVER-MAJOR)** **util**: change sparse arrays inspection format (Alexey Orlenko) [#11576](https://github.com/nodejs/node/pull/11576)
* [[`aab0d202f8`](https://github.com/nodejs/node/commit/aab0d202f8)] - **(SEMVER-MAJOR)** **util**: convert inspect.styles and inspect.colors to prototype-less objects (Nemanja Stojanovic) [#11624](https://github.com/nodejs/node/pull/11624)
* [[`4151ab398b`](https://github.com/nodejs/node/commit/4151ab398b)] - **(SEMVER-MAJOR)** **util**: add createClassWrapper to internal/util (James M Snell) [#11391](https://github.com/nodejs/node/pull/11391)
* [[`f65aa08b52`](https://github.com/nodejs/node/commit/f65aa08b52)] - **(SEMVER-MAJOR)** **util**: improve inspect for (Async|Generator)Function (Michaël Zasso) [#11210](https://github.com/nodejs/node/pull/11210)
* [[`efae43f0ee`](https://github.com/nodejs/node/commit/efae43f0ee)] - **(SEMVER-MAJOR)** **zlib**: fix node crashing on invalid options (Alexey Orlenko) [#13098](https://github.com/nodejs/node/pull/13098)
* [[`2ced07ccaf`](https://github.com/nodejs/node/commit/2ced07ccaf)] - **(SEMVER-MAJOR)** **zlib**: support all ArrayBufferView types (Timothy Gu) [#12223](https://github.com/nodejs/node/pull/12223)
* [[`91383e47fd`](https://github.com/nodejs/node/commit/91383e47fd)] - **(SEMVER-MAJOR)** **zlib**: support Uint8Array in convenience methods (Timothy Gu) [#12001](https://github.com/nodejs/node/pull/12001)
* [[`b514bd231e`](https://github.com/nodejs/node/commit/b514bd231e)] - **(SEMVER-MAJOR)** **zlib**: use RangeError/TypeError consistently (James M Snell) [#11391](https://github.com/nodejs/node/pull/11391)
* [[`8e69f7e385`](https://github.com/nodejs/node/commit/8e69f7e385)] - **(SEMVER-MAJOR)** **zlib**: refactor zlib module (James M Snell) [#11391](https://github.com/nodejs/node/pull/11391)
* [[`dd928b04fc`](https://github.com/nodejs/node/commit/dd928b04fc)] - **(SEMVER-MAJOR)** **zlib**: be strict about what strategies are accepted (Rich Trott) [#10934](https://github.com/nodejs/node/pull/10934)

#### Semver-minor Commits

* [[`7e3a3c962f`](https://github.com/nodejs/node/commit/7e3a3c962f)] - **(SEMVER-MINOR)** **async_hooks**: initial async_hooks implementation (Trevor Norris) [#12892](https://github.com/nodejs/node/pull/12892)
* [[`60a2fe7d47`](https://github.com/nodejs/node/commit/60a2fe7d47)] - **(SEMVER-MINOR)** **async_hooks**: implement C++ embedder API (Anna Henningsen) [#13142](https://github.com/nodejs/node/pull/13142)
* [[`f1ed19d98f`](https://github.com/nodejs/node/commit/f1ed19d98f)] - **(SEMVER-MINOR)** **async_wrap**: use more specific providers (Trevor Norris) [#12892](https://github.com/nodejs/node/pull/12892)
* [[`0432c6e91e`](https://github.com/nodejs/node/commit/0432c6e91e)] - **(SEMVER-MINOR)** **async_wrap**: use double, not int64_t, for async id (Trevor Norris) [#12892](https://github.com/nodejs/node/pull/12892)
* [[`fe2df3b842`](https://github.com/nodejs/node/commit/fe2df3b842)] - **(SEMVER-MINOR)** **async_wrap,src**: add GetAsyncId() method (Trevor Norris) [#12892](https://github.com/nodejs/node/pull/12892)
* [[`6d93508369`](https://github.com/nodejs/node/commit/6d93508369)] - **(SEMVER-MINOR)** **buffer**: expose FastBuffer on internal/buffer (Anna Henningsen) [#11048](https://github.com/nodejs/node/pull/11048)
* [[`fe5ca3ff27`](https://github.com/nodejs/node/commit/fe5ca3ff27)] - **(SEMVER-MINOR)** **child_process**: support promisified `exec(File)` (Anna Henningsen) [#12442](https://github.com/nodejs/node/pull/12442)
* [[`f146fe4ed4`](https://github.com/nodejs/node/commit/f146fe4ed4)] - **(SEMVER-MINOR)** **cmd**: support dash as stdin alias (Ebrahim Byagowi) [#13012](https://github.com/nodejs/node/pull/13012)
* [[`d9f3ec8e09`](https://github.com/nodejs/node/commit/d9f3ec8e09)] - **(SEMVER-MINOR)** **crypto**: use named FunctionTemplate (Trevor Norris) [#12892](https://github.com/nodejs/node/pull/12892)
* [[`0e710aada4`](https://github.com/nodejs/node/commit/0e710aada4)] - **(SEMVER-MINOR)** **crypto**: add sign/verify support for RSASSA-PSS (Tobias Nießen) [#11705](https://github.com/nodejs/node/pull/11705)
* [[`faf6654ff7`](https://github.com/nodejs/node/commit/faf6654ff7)] - **(SEMVER-MINOR)** **dns**: support promisified `lookup(Service)` (Anna Henningsen) [#12442](https://github.com/nodejs/node/pull/12442)
* [[`5077cde71f`](https://github.com/nodejs/node/commit/5077cde71f)] - **(SEMVER-MINOR)** **doc**: restructure url.md (James M Snell) [#12710](https://github.com/nodejs/node/pull/12710)
* [[`d080ead0f9`](https://github.com/nodejs/node/commit/d080ead0f9)] - **(SEMVER-MINOR)** **doc**: graduate WHATWG URL from Experimental (James M Snell) [#12710](https://github.com/nodejs/node/pull/12710)
* [[`c505b8109e`](https://github.com/nodejs/node/commit/c505b8109e)] - **(SEMVER-MINOR)** **doc**: document URLSearchParams constructor (Timothy Gu) [#11060](https://github.com/nodejs/node/pull/11060)
* [[`84dabe8373`](https://github.com/nodejs/node/commit/84dabe8373)] - **(SEMVER-MINOR)** **domain**: support promises (Anna Henningsen) [#12489](https://github.com/nodejs/node/pull/12489)
* [[`fbcb4f50b8`](https://github.com/nodejs/node/commit/fbcb4f50b8)] - **(SEMVER-MINOR)** **fs**: support util.promisify for fs.read/fs.write (Anna Henningsen) [#12442](https://github.com/nodejs/node/pull/12442)
* [[`a7f5c9cb7d`](https://github.com/nodejs/node/commit/a7f5c9cb7d)] - **(SEMVER-MINOR)** **http**: destroy sockets after keepAliveTimeout (Timur Shemsedinov) [#2534](https://github.com/nodejs/node/pull/2534)
* [[`3e6f1032a4`](https://github.com/nodejs/node/commit/3e6f1032a4)] - **(SEMVER-MINOR)** **http**: add new functions to OutgoingMessage (Brian White) [#10805](https://github.com/nodejs/node/pull/10805)
* [[`c7182b9d9c`](https://github.com/nodejs/node/commit/c7182b9d9c)] - **(SEMVER-MINOR)** **inspector**: JavaScript bindings for the inspector (Eugene Ostroukhov) [#12263](https://github.com/nodejs/node/pull/12263)
* [[`4a7233c178`](https://github.com/nodejs/node/commit/4a7233c178)] - **(SEMVER-MINOR)** **lib**: implement async_hooks API in core (Trevor Norris) [#12892](https://github.com/nodejs/node/pull/12892)
* [[`c68ebe8436`](https://github.com/nodejs/node/commit/c68ebe8436)] - **(SEMVER-MINOR)** **makefile**: add async-hooks to test and test-ci (Trevor Norris) [#12892](https://github.com/nodejs/node/pull/12892)
* [[`45139e59f3`](https://github.com/nodejs/node/commit/45139e59f3)] - **(SEMVER-MINOR)** **n-api**: add napi_get_version (Michael Dawson) [#13207](https://github.com/nodejs/node/pull/13207)
* [[`56e881d0b0`](https://github.com/nodejs/node/commit/56e881d0b0)] - **(SEMVER-MINOR)** **n-api**: add support for abi stable module API (Jason Ginchereau) [#11975](https://github.com/nodejs/node/pull/11975)
* [[`dd20e68b0f`](https://github.com/nodejs/node/commit/dd20e68b0f)] - **(SEMVER-MINOR)** **process**: add optional detail to process emitWarning (James M Snell) [#12725](https://github.com/nodejs/node/pull/12725)
* [[`c0bde73f1b`](https://github.com/nodejs/node/commit/c0bde73f1b)] - **(SEMVER-MINOR)** **src**: implement native changes for async_hooks (Trevor Norris) [#12892](https://github.com/nodejs/node/pull/12892)
* [[`e5a25cbc85`](https://github.com/nodejs/node/commit/e5a25cbc85)] - **(SEMVER-MINOR)** **src**: expose `node::AddPromiseHook` (Anna Henningsen) [#12489](https://github.com/nodejs/node/pull/12489)
* [[`ec53921d2e`](https://github.com/nodejs/node/commit/ec53921d2e)] - **(SEMVER-MINOR)** **src**: make AtExit callback's per Environment (Daniel Bevenius) [#9163](https://github.com/nodejs/node/pull/9163)
* [[`ba4847e879`](https://github.com/nodejs/node/commit/ba4847e879)] - **(SEMVER-MINOR)** **src**: Node Tracing Controller (misterpoe) [#9304](https://github.com/nodejs/node/pull/9304)
* [[`6ff3b03240`](https://github.com/nodejs/node/commit/6ff3b03240)] - **(SEMVER-MINOR)** **src, inspector**: add --inspect-brk option (Josh Gavant) [#8979](https://github.com/nodejs/node/pull/8979)
* [[`220186c4a8`](https://github.com/nodejs/node/commit/220186c4a8)] - **(SEMVER-MINOR)** **stream**: support Uint8Array input to methods (Anna Henningsen) [#11608](https://github.com/nodejs/node/pull/11608)
* [[`07c7f198db`](https://github.com/nodejs/node/commit/07c7f198db)] - **(SEMVER-MINOR)** **stream**: add final method (Calvin Metcalf) [#12828](https://github.com/nodejs/node/pull/12828)
* [[`11918c4aed`](https://github.com/nodejs/node/commit/11918c4aed)] - **(SEMVER-MINOR)** **stream**: fix highWaterMark integer overflow (Tobias Nießen) [#12593](https://github.com/nodejs/node/pull/12593)
* [[`c56d6046ec`](https://github.com/nodejs/node/commit/c56d6046ec)] - **(SEMVER-MINOR)** **test**: add AsyncResource addon test (Anna Henningsen) [#13142](https://github.com/nodejs/node/pull/13142)
* [[`e3e56f1d71`](https://github.com/nodejs/node/commit/e3e56f1d71)] - **(SEMVER-MINOR)** **test**: adding tests for initHooks API (Thorsten Lorenz) [#12892](https://github.com/nodejs/node/pull/12892)
* [[`732620cfe9`](https://github.com/nodejs/node/commit/732620cfe9)] - **(SEMVER-MINOR)** **test**: remove unneeded tests (Trevor Norris) [#12892](https://github.com/nodejs/node/pull/12892)
* [[`e965ed16c1`](https://github.com/nodejs/node/commit/e965ed16c1)] - **(SEMVER-MINOR)** **test**: add test for promisify customPromisifyArgs (Gil Tayar) [#12442](https://github.com/nodejs/node/pull/12442)
* [[`3ea2301e38`](https://github.com/nodejs/node/commit/3ea2301e38)] - **(SEMVER-MINOR)** **test**: add a bunch of tests from bluebird (Madara Uchiha) [#12442](https://github.com/nodejs/node/pull/12442)
* [[`dca08152cb`](https://github.com/nodejs/node/commit/dca08152cb)] - **(SEMVER-MINOR)** **test**: introduce `common.crashOnUnhandledRejection` (Anna Henningsen) [#12489](https://github.com/nodejs/node/pull/12489)
* [[`e7c51454b0`](https://github.com/nodejs/node/commit/e7c51454b0)] - **(SEMVER-MINOR)** **timers**: add promisify support (Anna Henningsen) [#12442](https://github.com/nodejs/node/pull/12442)
* [[`e600fbe576`](https://github.com/nodejs/node/commit/e600fbe576)] - **(SEMVER-MINOR)** **tls**: accept `lookup` option for `tls.connect()` (Fedor Indutny) [#12839](https://github.com/nodejs/node/pull/12839)
* [[`c3efe72669`](https://github.com/nodejs/node/commit/c3efe72669)] - **(SEMVER-MINOR)** **tls**: support Uint8Arrays for protocol list buffers (Anna Henningsen) [#11984](https://github.com/nodejs/node/pull/11984)
* [[`29f758731f`](https://github.com/nodejs/node/commit/29f758731f)] - **(SEMVER-MINOR)** **tools**: add MDN link for Iterable (Timothy Gu) [#11060](https://github.com/nodejs/node/pull/11060)
* [[`4b9d84df51`](https://github.com/nodejs/node/commit/4b9d84df51)] - **(SEMVER-MINOR)** **tty_wrap**: throw when uv_tty_init() returns error (Trevor Norris) [#12892](https://github.com/nodejs/node/pull/12892)
* [[`cc48f21c83`](https://github.com/nodejs/node/commit/cc48f21c83)] - **(SEMVER-MINOR)** **url**: extend URLSearchParams constructor (Timothy Gu) [#11060](https://github.com/nodejs/node/pull/11060)
* [[`99da8e8e02`](https://github.com/nodejs/node/commit/99da8e8e02)] - **(SEMVER-MINOR)** **util**: add util.promisify() (Anna Henningsen) [#12442](https://github.com/nodejs/node/pull/12442)
* [[`059f296050`](https://github.com/nodejs/node/commit/059f296050)] - **(SEMVER-MINOR)** **util**: add internal bindings for promise handling (Anna Henningsen) [#12442](https://github.com/nodejs/node/pull/12442)
* [[`1fde98bb4f`](https://github.com/nodejs/node/commit/1fde98bb4f)] - **(SEMVER-MINOR)** **v8**: expose new V8 serialization API (Anna Henningsen) [#11048](https://github.com/nodejs/node/pull/11048)
* [[`70beef97bd`](https://github.com/nodejs/node/commit/70beef97bd)] - **(SEMVER-MINOR)** **v8**: add cachedDataVersionTag (Andres Suarez) [#11515](https://github.com/nodejs/node/pull/11515)

#### Semver-patch commits

* [[`276720921b`](https://github.com/nodejs/node/commit/276720921b)] - **addons**: remove semicolons from after module definition (Gabriel Schulhof) [#12919](https://github.com/nodejs/node/pull/12919)
* [[`f6247a945c`](https://github.com/nodejs/node/commit/f6247a945c)] - **assert**: restore TypeError if no arguments (Rich Trott) [#12843](https://github.com/nodejs/node/pull/12843)
* [[`7e5f500c98`](https://github.com/nodejs/node/commit/7e5f500c98)] - **assert**: improve deepEqual perf for large input (Anna Henningsen) [#12849](https://github.com/nodejs/node/pull/12849)
* [[`3863c3ae66`](https://github.com/nodejs/node/commit/3863c3ae66)] - **async_hooks**: rename AsyncEvent to AsyncResource (Anna Henningsen) [#13192](https://github.com/nodejs/node/pull/13192)
* [[`e554bb449e`](https://github.com/nodejs/node/commit/e554bb449e)] - **async_hooks**: only set up hooks if used (Anna Henningsen) [#13177](https://github.com/nodejs/node/pull/13177)
* [[`6fb27af70a`](https://github.com/nodejs/node/commit/6fb27af70a)] - **async_hooks**: add constructor check to async-hooks (Shadowbeetle) [#13096](https://github.com/nodejs/node/pull/13096)
* [[`a6023ee0b5`](https://github.com/nodejs/node/commit/a6023ee0b5)] - **async_wrap**: fix Promises with later enabled hooks (Anna Henningsen) [#13242](https://github.com/nodejs/node/pull/13242)
* [[`6bfdeedce5`](https://github.com/nodejs/node/commit/6bfdeedce5)] - **async_wrap**: add `asyncReset` to `TLSWrap` (Refael Ackermann) [#13092](https://github.com/nodejs/node/pull/13092)
* [[`4a8ea63b3b`](https://github.com/nodejs/node/commit/4a8ea63b3b)] - **async_wrap,src**: wrap promises directly (Matt Loring) [#13242](https://github.com/nodejs/node/pull/13242)
* [[`6e4394fb0b`](https://github.com/nodejs/node/commit/6e4394fb0b)] - **async_wrap,src**: promise hook integration (Matt Loring) [#13000](https://github.com/nodejs/node/pull/13000)
* [[`72429b3981`](https://github.com/nodejs/node/commit/72429b3981)] - **benchmark**: allow no duration in benchmark tests (Rich Trott) [#13110](https://github.com/nodejs/node/pull/13110)
* [[`f2ba06db92`](https://github.com/nodejs/node/commit/f2ba06db92)] - **benchmark**: remove redundant timers benchmark (Rich Trott) [#13009](https://github.com/nodejs/node/pull/13009)
* [[`3fa5d80eda`](https://github.com/nodejs/node/commit/3fa5d80eda)] - **benchmark**: chunky http client should exit with 0 (Joyee Cheung) [#12916](https://github.com/nodejs/node/pull/12916)
* [[`a82e0e6f36`](https://github.com/nodejs/node/commit/a82e0e6f36)] - **benchmark**: check for time precision in common.js (Rich Trott) [#12934](https://github.com/nodejs/node/pull/12934)
* [[`65d6249979`](https://github.com/nodejs/node/commit/65d6249979)] - **benchmark**: update an obsolete path (Vse Mozhet Byt) [#12904](https://github.com/nodejs/node/pull/12904)
* [[`d8965d5b0e`](https://github.com/nodejs/node/commit/d8965d5b0e)] - **benchmark**: fix typo in _http-benchmarkers.js (Vse Mozhet Byt) [#12455](https://github.com/nodejs/node/pull/12455)
* [[`a3778cb9b1`](https://github.com/nodejs/node/commit/a3778cb9b1)] - **benchmark**: fix URL in _http-benchmarkers.js (Vse Mozhet Byt) [#12455](https://github.com/nodejs/node/pull/12455)
* [[`22aa3d4899`](https://github.com/nodejs/node/commit/22aa3d4899)] - **benchmark**: reduce string concatenations (Vse Mozhet Byt) [#12455](https://github.com/nodejs/node/pull/12455)
* [[`3e3414f45f`](https://github.com/nodejs/node/commit/3e3414f45f)] - **benchmark**: control HTTP benchmarks run time (Joyee Cheung) [#12121](https://github.com/nodejs/node/pull/12121)
* [[`a3e71a8901`](https://github.com/nodejs/node/commit/a3e71a8901)] - **benchmark**: add test double HTTP benchmarker (Joyee Cheung) [#12121](https://github.com/nodejs/node/pull/12121)
* [[`a6e69f8c08`](https://github.com/nodejs/node/commit/a6e69f8c08)] - **benchmark**: add more options to map-bench (Timothy Gu) [#11930](https://github.com/nodejs/node/pull/11930)
* [[`ae8a8691e6`](https://github.com/nodejs/node/commit/ae8a8691e6)] - **benchmark**: add final clean-up to module-loader.js (Vse Mozhet Byt) [#11924](https://github.com/nodejs/node/pull/11924)
* [[`6df23fa39f`](https://github.com/nodejs/node/commit/6df23fa39f)] - **benchmark**: fix punycode and get-ciphers benchmark (Bartosz Sosnowski) [#11720](https://github.com/nodejs/node/pull/11720)
* [[`75cdc895ec`](https://github.com/nodejs/node/commit/75cdc895ec)] - **benchmark**: cleanup after forced optimization drop (Bartosz Sosnowski) [#9615](https://github.com/nodejs/node/pull/9615)
* [[`ca86aa5323`](https://github.com/nodejs/node/commit/ca86aa5323)] - **benchmark**: remove forced optimization from util (Bartosz Sosnowski) [#9615](https://github.com/nodejs/node/pull/9615)
* [[`c5958d20fd`](https://github.com/nodejs/node/commit/c5958d20fd)] - **benchmark**: remove forced optimization from url (Bartosz Sosnowski) [#9615](https://github.com/nodejs/node/pull/9615)
* [[`ea61ce518b`](https://github.com/nodejs/node/commit/ea61ce518b)] - **benchmark**: remove forced optimization from tls (Bartosz Sosnowski) [#9615](https://github.com/nodejs/node/pull/9615)
* [[`541119c6ee`](https://github.com/nodejs/node/commit/541119c6ee)] - **benchmark**: remove streams forced optimization (Bartosz Sosnowski) [#9615](https://github.com/nodejs/node/pull/9615)
* [[`57b5ce1d8e`](https://github.com/nodejs/node/commit/57b5ce1d8e)] - **benchmark**: remove querystring forced optimization (Bartosz Sosnowski) [#9615](https://github.com/nodejs/node/pull/9615)
* [[`eba2c62bb1`](https://github.com/nodejs/node/commit/eba2c62bb1)] - **benchmark**: remove forced optimization from path (Bartosz Sosnowski) [#9615](https://github.com/nodejs/node/pull/9615)
* [[`7587a11adc`](https://github.com/nodejs/node/commit/7587a11adc)] - **benchmark**: remove forced optimization from misc (Bartosz Sosnowski) [#9615](https://github.com/nodejs/node/pull/9615)
* [[`ef8cc301fe`](https://github.com/nodejs/node/commit/ef8cc301fe)] - **benchmark**: remove forced optimization from es (Bartosz Sosnowski) [#9615](https://github.com/nodejs/node/pull/9615)
* [[`17c85ffd80`](https://github.com/nodejs/node/commit/17c85ffd80)] - **benchmark**: remove forced optimization from crypto (Bartosz Sosnowski) [#9615](https://github.com/nodejs/node/pull/9615)
* [[`05ac6e1b01`](https://github.com/nodejs/node/commit/05ac6e1b01)] - **benchmark**: remove forced optimization from buffer (Bartosz Sosnowski) [#9615](https://github.com/nodejs/node/pull/9615)
* [[`6123ed5b25`](https://github.com/nodejs/node/commit/6123ed5b25)] - **benchmark**: add USVString conversion benchmark (Timothy Gu) [#11436](https://github.com/nodejs/node/pull/11436)
* [[`28ddac2ec2`](https://github.com/nodejs/node/commit/28ddac2ec2)] - **buffer**: fix indexOf for empty searches (Anna Henningsen) [#13024](https://github.com/nodejs/node/pull/13024)
* [[`9d723e85fb`](https://github.com/nodejs/node/commit/9d723e85fb)] - **buffer**: remove pointless C++ utility methods (Anna Henningsen) [#12760](https://github.com/nodejs/node/pull/12760)
* [[`7cd0d4f644`](https://github.com/nodejs/node/commit/7cd0d4f644)] - **buffer**: fix backwards incompatibility (Brian White) [#12439](https://github.com/nodejs/node/pull/12439)
* [[`3ee4a1a281`](https://github.com/nodejs/node/commit/3ee4a1a281)] - **buffer**: optimize toString() (Brian White) [#12361](https://github.com/nodejs/node/pull/12361)
* [[`4a86803f60`](https://github.com/nodejs/node/commit/4a86803f60)] - **buffer**: optimize from() and byteLength() (Brian White) [#12361](https://github.com/nodejs/node/pull/12361)
* [[`00c86cc8e9`](https://github.com/nodejs/node/commit/00c86cc8e9)] - **buffer**: remove Uint8Array check (Nikolai Vavilov) [#11324](https://github.com/nodejs/node/pull/11324)
* [[`fb6cf2f861`](https://github.com/nodejs/node/commit/fb6cf2f861)] - **build**: xz tarball extreme compression (Peter Dave Hello) [#10626](https://github.com/nodejs/node/pull/10626)
* [[`4f4d5d24f4`](https://github.com/nodejs/node/commit/4f4d5d24f4)] - **build**: ignore more VC++ artifacts (Refael Ackermann) [#13208](https://github.com/nodejs/node/pull/13208)
* [[`735902f326`](https://github.com/nodejs/node/commit/735902f326)] - **build**: support dtrace on ARM (Bradley T. Hughes) [#12193](https://github.com/nodejs/node/pull/12193)
* [[`46bd32e7e8`](https://github.com/nodejs/node/commit/46bd32e7e8)] - **build**: fix openssl link error on windows (Daniel Bevenius) [#13078](https://github.com/nodejs/node/pull/13078)
* [[`77dfa2b1da`](https://github.com/nodejs/node/commit/77dfa2b1da)] - **build**: avoid /docs/api and /docs/doc/api upload (Rod Vagg) [#12957](https://github.com/nodejs/node/pull/12957)
* [[`6342988053`](https://github.com/nodejs/node/commit/6342988053)] - **build**: clean up napi build in test-addons-clean (Joyee Cheung) [#13034](https://github.com/nodejs/node/pull/13034)
* [[`ad7b98baa8`](https://github.com/nodejs/node/commit/ad7b98baa8)] - **build**: don't print directory for GNUMake (Daniel Bevenius) [#13042](https://github.com/nodejs/node/pull/13042)
* [[`80355271c3`](https://github.com/nodejs/node/commit/80355271c3)] - **build**: simplify `if` in setting of arg_paths (Refael Ackermann) [#12653](https://github.com/nodejs/node/pull/12653)
* [[`4aff0563aa`](https://github.com/nodejs/node/commit/4aff0563aa)] - **build**: reduce one level of spawning in node_gyp (Refael Ackermann) [#12653](https://github.com/nodejs/node/pull/12653)
* [[`9fd22bc4d4`](https://github.com/nodejs/node/commit/9fd22bc4d4)] - **build**: fix ninja build failure (GYP patch) (Daniel Bevenius) [#12484](https://github.com/nodejs/node/pull/12484)
* [[`bb88caec06`](https://github.com/nodejs/node/commit/bb88caec06)] - **build**: fix ninja build failure (Daniel Bevenius) [#12484](https://github.com/nodejs/node/pull/12484)
* [[`e488857402`](https://github.com/nodejs/node/commit/e488857402)] - **build**: add static option to vcbuild.bat (Tony Rice) [#12764](https://github.com/nodejs/node/pull/12764)
* [[`d727d5d2cf`](https://github.com/nodejs/node/commit/d727d5d2cf)] - **build**: enable cctest to use objects (gyp part) (Daniel Bevenius) [#12450](https://github.com/nodejs/node/pull/12450)
* [[`ea44b8b283`](https://github.com/nodejs/node/commit/ea44b8b283)] - **build**: disable -O3 for C++ coverage (Anna Henningsen) [#12406](https://github.com/nodejs/node/pull/12406)
* [[`baa2602539`](https://github.com/nodejs/node/commit/baa2602539)] - **build**: add test-gc-clean and test-gc PHONY rules (Joyee Cheung) [#12059](https://github.com/nodejs/node/pull/12059)
* [[`c694633328`](https://github.com/nodejs/node/commit/c694633328)] - **build**: sort phony rules (Joyee Cheung) [#12059](https://github.com/nodejs/node/pull/12059)
* [[`4dde87620a`](https://github.com/nodejs/node/commit/4dde87620a)] - **build**: don't test addons-napi twice (Gibson Fahnestock) [#12201](https://github.com/nodejs/node/pull/12201)
* [[`d19809a3c5`](https://github.com/nodejs/node/commit/d19809a3c5)] - **build**: avoid passing kill empty input in Makefile (Gibson Fahnestock) [#12158](https://github.com/nodejs/node/pull/12158)
* [[`c68da89694`](https://github.com/nodejs/node/commit/c68da89694)] - **build**: always use V8_ENABLE_CHECKS in debug mode (Anna Henningsen) [#12029](https://github.com/nodejs/node/pull/12029)
* [[`7cd6a7ddcb`](https://github.com/nodejs/node/commit/7cd6a7ddcb)] - **build**: notify about the redundancy of "nosign" (Nikolai Vavilov) [#11119](https://github.com/nodejs/node/pull/11119)
* [[`dd81d539e2`](https://github.com/nodejs/node/commit/dd81d539e2)] - **child_process**: fix deoptimizing use of arguments (Vse Mozhet Byt) [#11535](https://github.com/nodejs/node/pull/11535)
* [[`dc3bbb45a7`](https://github.com/nodejs/node/commit/dc3bbb45a7)] - **cluster**: remove debug arg handling (Rich Trott) [#12738](https://github.com/nodejs/node/pull/12738)
* [[`c969047d62`](https://github.com/nodejs/node/commit/c969047d62)] - **console**: fixup `console.dir()` error handling (Anna Henningsen) [#11443](https://github.com/nodejs/node/pull/11443)
* [[`9fa148909c`](https://github.com/nodejs/node/commit/9fa148909c)] - **crypto**: update root certificates (Ben Noordhuis) [#13279](https://github.com/nodejs/node/pull/13279)
* [[`945916195c`](https://github.com/nodejs/node/commit/945916195c)] - **crypto**: return CHECK_OK in VerifyCallback (Daniel Bevenius) [#13241](https://github.com/nodejs/node/pull/13241)
* [[`7b97f07340`](https://github.com/nodejs/node/commit/7b97f07340)] - **crypto**: remove root_cert_store from node_crypto.h (Daniel Bevenius) [#13194](https://github.com/nodejs/node/pull/13194)
* [[`f06f8365e4`](https://github.com/nodejs/node/commit/f06f8365e4)] - **crypto**: remove unnecessary template class (Daniel Bevenius) [#12993](https://github.com/nodejs/node/pull/12993)
* [[`6c2daf0ce9`](https://github.com/nodejs/node/commit/6c2daf0ce9)] - **crypto**: throw proper errors if out enc is UTF-16 (Anna Henningsen) [#12752](https://github.com/nodejs/node/pull/12752)
* [[`eaa0542eff`](https://github.com/nodejs/node/commit/eaa0542eff)] - **crypto**: remove unused C++ parameter in sign/verify (Tobias Nießen) [#12397](https://github.com/nodejs/node/pull/12397)
* [[`6083c4dc10`](https://github.com/nodejs/node/commit/6083c4dc10)] - **deps**: upgrade npm to 5.0.0 (Kat Marchán) [#13276](https://github.com/nodejs/node/pull/13276)
* [[`f204945495`](https://github.com/nodejs/node/commit/f204945495)] - **deps**: add example of comparing OpenSSL changes (Daniel Bevenius) [#13234](https://github.com/nodejs/node/pull/13234)
* [[`9302f512f8`](https://github.com/nodejs/node/commit/9302f512f8)] - **deps**: cherry-pick 6803eef from V8 upstream (Matt Loring) [#13175](https://github.com/nodejs/node/pull/13175)
* [[`2648c8de30`](https://github.com/nodejs/node/commit/2648c8de30)] - **deps**: backport 6d38f89d from upstream V8 (Ali Ijaz Sheikh) [#13162](https://github.com/nodejs/node/pull/13162)
* [[`6e1407c3b3`](https://github.com/nodejs/node/commit/6e1407c3b3)] - **deps**: backport 4fdf9fd4813 from upstream v8 (Jochen Eisinger) [#12875](https://github.com/nodejs/node/pull/12875)
* [[`385499ccf8`](https://github.com/nodejs/node/commit/385499ccf8)] - **deps**: backport 4acdb5eec2c from upstream v8 (jbroman) [#12875](https://github.com/nodejs/node/pull/12875)
* [[`69161b5f94`](https://github.com/nodejs/node/commit/69161b5f94)] - **deps**: backport 3700a01c82 from upstream v8 (jbroman) [#12875](https://github.com/nodejs/node/pull/12875)
* [[`9edd6d8ddb`](https://github.com/nodejs/node/commit/9edd6d8ddb)] - **deps**: backport 2cd2f5feff3 from upstream v8 (Jochen Eisinger) [#12875](https://github.com/nodejs/node/pull/12875)
* [[`19c0c07446`](https://github.com/nodejs/node/commit/19c0c07446)] - **deps**: backport de1461b7efd from upstream v8 (addaleax) [#12875](https://github.com/nodejs/node/pull/12875)
* [[`95c4b0d8f6`](https://github.com/nodejs/node/commit/95c4b0d8f6)] - **deps**: backport 78867ad8707a016 from v8 upstream (Michael Lippautz) [#12875](https://github.com/nodejs/node/pull/12875)
* [[`986e1d2c6f`](https://github.com/nodejs/node/commit/986e1d2c6f)] - **deps**: cherry-pick f5fad6d from upstream v8 (daniel.bevenius) [#12826](https://github.com/nodejs/node/pull/12826)
* [[`e896898dea`](https://github.com/nodejs/node/commit/e896898dea)] - **deps**: update openssl asm and asm_obsolete files (Shigeki Ohtsu) [#12913](https://github.com/nodejs/node/pull/12913)
* [[`f4390650e3`](https://github.com/nodejs/node/commit/f4390650e3)] - **deps**: cherry-pick 4ae5993 from upstream OpenSSL (Shigeki Ohtsu) [#12913](https://github.com/nodejs/node/pull/12913)
* [[`5d0a770c12`](https://github.com/nodejs/node/commit/5d0a770c12)] - **deps**: ICU 59.1 bump (Steven R. Loomis) [#12486](https://github.com/nodejs/node/pull/12486)
* [[`d74a545535`](https://github.com/nodejs/node/commit/d74a545535)] - **deps**: cherry-pick bfae9db from upstream v8 (Ben Noordhuis) [#12722](https://github.com/nodejs/node/pull/12722)
* [[`6ed791c665`](https://github.com/nodejs/node/commit/6ed791c665)] - **deps**: cherry-pick bfae9db from upstream v8 (Ben Noordhuis) [#12722](https://github.com/nodejs/node/pull/12722)
* [[`0084260448`](https://github.com/nodejs/node/commit/0084260448)] - **deps**: upgrade npm to 4.5.0 (Rebecca Turner) [#12480](https://github.com/nodejs/node/pull/12480)
* [[`021719738e`](https://github.com/nodejs/node/commit/021719738e)] - **deps**: update node-inspect to v1.11.2 (Jan Krems) [#12363](https://github.com/nodejs/node/pull/12363)
* [[`3471d6312d`](https://github.com/nodejs/node/commit/3471d6312d)] - **deps**: cherry-pick 0ba513f05 from V8 upstream (Franziska Hinkelmann) [#11712](https://github.com/nodejs/node/pull/11712)
* [[`dd8982dc74`](https://github.com/nodejs/node/commit/dd8982dc74)] - **deps**: cherry-pick 09de996 from V8 upstream (Franziska Hinkelmann) [#11905](https://github.com/nodejs/node/pull/11905)
* [[`a44aff4770`](https://github.com/nodejs/node/commit/a44aff4770)] - **deps**: cherry-pick 0ba513f05 from V8 upstream (Franziska Hinkelmann) [#11712](https://github.com/nodejs/node/pull/11712)
* [[`2b541471db`](https://github.com/nodejs/node/commit/2b541471db)] - **dns**: fix `resolve` failed starts without network (XadillaX) [#13076](https://github.com/nodejs/node/pull/13076)
* [[`5a948f6f64`](https://github.com/nodejs/node/commit/5a948f6f64)] - **dns**: fix crash using dns.setServers after resolve4 (XadillaX) [#13050](https://github.com/nodejs/node/pull/13050)
* [[`dd14ab608e`](https://github.com/nodejs/node/commit/dd14ab608e)] - **doc**: create list of CTC emeriti (Rich Trott) [#13232](https://github.com/nodejs/node/pull/13232)
* [[`40572c5def`](https://github.com/nodejs/node/commit/40572c5def)] - **doc**: remove Gitter badge from README (Rich Trott) [#13231](https://github.com/nodejs/node/pull/13231)
* [[`686dd36930`](https://github.com/nodejs/node/commit/686dd36930)] - **doc**: fix api docs style (Daijiro Wachi) [#13236](https://github.com/nodejs/node/pull/13236)
* [[`0be029ec97`](https://github.com/nodejs/node/commit/0be029ec97)] - **doc**: make spelling of behavior consistent (Michael Dawson) [#13245](https://github.com/nodejs/node/pull/13245)
* [[`c0a7c8e0d2`](https://github.com/nodejs/node/commit/c0a7c8e0d2)] - **doc**: fix code example in inspector.md (Vse Mozhet Byt) [#13182](https://github.com/nodejs/node/pull/13182)
* [[`cd2824cc93`](https://github.com/nodejs/node/commit/cd2824cc93)] - **doc**: make the style of notes consistent (Alexey Orlenko) [#13133](https://github.com/nodejs/node/pull/13133)
* [[`d4e9e0f7e4`](https://github.com/nodejs/node/commit/d4e9e0f7e4)] - **doc**: add jasongin & kunalspathak to collaborators (Jason Ginchereau) [#13200](https://github.com/nodejs/node/pull/13200)
* [[`db90b505e8`](https://github.com/nodejs/node/commit/db90b505e8)] - **doc**: don't use useless constructors in stream.md (Vse Mozhet Byt) [#13145](https://github.com/nodejs/node/pull/13145)
* [[`2c45e6fd68`](https://github.com/nodejs/node/commit/2c45e6fd68)] - **doc**: update code example for Windows in stream.md (Vse Mozhet Byt) [#13138](https://github.com/nodejs/node/pull/13138)
* [[`3c91145f31`](https://github.com/nodejs/node/commit/3c91145f31)] - **doc**: improve formatting of STYLE_GUIDE.md (Alexey Orlenko) [#13135](https://github.com/nodejs/node/pull/13135)
* [[`1d587ef982`](https://github.com/nodejs/node/commit/1d587ef982)] - **doc**: fix incorrect keyboard shortcut (Alexey Orlenko) [#13134](https://github.com/nodejs/node/pull/13134)
* [[`336d33b646`](https://github.com/nodejs/node/commit/336d33b646)] - **doc**: fix title/function name mismatch (Michael Dawson) [#13123](https://github.com/nodejs/node/pull/13123)
* [[`9f01b34bf9`](https://github.com/nodejs/node/commit/9f01b34bf9)] - **doc**: link to `common` docs in test writing guide (Anna Henningsen) [#13118](https://github.com/nodejs/node/pull/13118)
* [[`1aa68f9a8d`](https://github.com/nodejs/node/commit/1aa68f9a8d)] - **doc**: list macOS as supporting filename argument (Chris Young) [#13111](https://github.com/nodejs/node/pull/13111)
* [[`ef71824740`](https://github.com/nodejs/node/commit/ef71824740)] - **doc**: edit Error.captureStackTrace html comment (Artur Vieira) [#12962](https://github.com/nodejs/node/pull/12962)
* [[`bfade5aacd`](https://github.com/nodejs/node/commit/bfade5aacd)] - **doc**: remove unused/duplicated reference links (Daijiro Wachi) [#13066](https://github.com/nodejs/node/pull/13066)
* [[`4a7b7e8097`](https://github.com/nodejs/node/commit/4a7b7e8097)] - **doc**: add reference to node_api.h in docs (Michael Dawson) [#13084](https://github.com/nodejs/node/pull/13084)
* [[`3702ae732e`](https://github.com/nodejs/node/commit/3702ae732e)] - **doc**: add additional useful ci job to list (Michael Dawson) [#13086](https://github.com/nodejs/node/pull/13086)
* [[`847688018c`](https://github.com/nodejs/node/commit/847688018c)] - **doc**: don't suggest setEncoding for binary streams (Rick Bullotta) [#11363](https://github.com/nodejs/node/pull/11363)
* [[`eff9252181`](https://github.com/nodejs/node/commit/eff9252181)] - **doc**: update doc of publicEncrypt method (Faiz Halde) [#12947](https://github.com/nodejs/node/pull/12947)
* [[`ab34f9dec2`](https://github.com/nodejs/node/commit/ab34f9dec2)] - **doc**: update doc to remove usage of "you" (Michael Dawson) [#13067](https://github.com/nodejs/node/pull/13067)
* [[`5de722ab6d`](https://github.com/nodejs/node/commit/5de722ab6d)] - **doc**: fix links from ToC to subsection for 4.8.x (Frank Lanitz) [#13039](https://github.com/nodejs/node/pull/13039)
* [[`92f3b301ab`](https://github.com/nodejs/node/commit/92f3b301ab)] - **doc**: document method for reverting commits (Gibson Fahnestock) [#13015](https://github.com/nodejs/node/pull/13015)
* [[`1b28022de0`](https://github.com/nodejs/node/commit/1b28022de0)] - **doc**: clarify operation of napi_cancel_async_work (Michael Dawson) [#12974](https://github.com/nodejs/node/pull/12974)
* [[`1d5f5aa7e1`](https://github.com/nodejs/node/commit/1d5f5aa7e1)] - **doc**: update COLLABORATOR_GUIDE.md (morrme) [#12555](https://github.com/nodejs/node/pull/12555)
* [[`d7d16f7b8b`](https://github.com/nodejs/node/commit/d7d16f7b8b)] - **doc**: Change options at STEP 5 in CONTRIBUTING.md (kysnm) [#12830](https://github.com/nodejs/node/pull/12830)
* [[`c79deaab82`](https://github.com/nodejs/node/commit/c79deaab82)] - **doc**: update to add ref to supported platforms (Michael Dawson) [#12931](https://github.com/nodejs/node/pull/12931)
* [[`abfd4bf9df`](https://github.com/nodejs/node/commit/abfd4bf9df)] - **doc**: clarify node.js addons are c++ (Beth Griggs) [#12898](https://github.com/nodejs/node/pull/12898)
* [[`13487c437c`](https://github.com/nodejs/node/commit/13487c437c)] - **doc**: add docs for server.address() for pipe case (Flarna) [#12907](https://github.com/nodejs/node/pull/12907)
* [[`147048a0d3`](https://github.com/nodejs/node/commit/147048a0d3)] - **doc**: fix broken links in n-api doc (Michael Dawson) [#12889](https://github.com/nodejs/node/pull/12889)
* [[`e429f9a42a`](https://github.com/nodejs/node/commit/e429f9a42a)] - **doc**: fix typo in streams.md (Glenn Schlereth) [#12924](https://github.com/nodejs/node/pull/12924)
* [[`ea1b8a5cbc`](https://github.com/nodejs/node/commit/ea1b8a5cbc)] - **doc**: sort bottom-of-file markdown links (Sam Roberts) [#12726](https://github.com/nodejs/node/pull/12726)
* [[`cbd6fde9a3`](https://github.com/nodejs/node/commit/cbd6fde9a3)] - **doc**: improve path.posix.normalize docs (Steven Lehn) [#12700](https://github.com/nodejs/node/pull/12700)
* [[`a398516b4f`](https://github.com/nodejs/node/commit/a398516b4f)] - **doc**: remove test-npm from general build doc (Rich Trott) [#12840](https://github.com/nodejs/node/pull/12840)
* [[`4703824276`](https://github.com/nodejs/node/commit/4703824276)] - **doc**: fix commit guideline url (Thomas Watson) [#12862](https://github.com/nodejs/node/pull/12862)
* [[`2614d247fb`](https://github.com/nodejs/node/commit/2614d247fb)] - **doc**: update readFileSync in fs.md (Aditya Anand) [#12800](https://github.com/nodejs/node/pull/12800)
* [[`0258aed9d2`](https://github.com/nodejs/node/commit/0258aed9d2)] - **doc**: edit CONTRIBUTING.md for clarity etc. (Rich Trott) [#12796](https://github.com/nodejs/node/pull/12796)
* [[`c1b3b95939`](https://github.com/nodejs/node/commit/c1b3b95939)] - **doc**: add WHATWG file URLs in fs module (Olivier Martin) [#12670](https://github.com/nodejs/node/pull/12670)
* [[`2bf461e6f5`](https://github.com/nodejs/node/commit/2bf461e6f5)] - **doc**: document vm timeout option perf impact (Anna Henningsen) [#12751](https://github.com/nodejs/node/pull/12751)
* [[`d8f8096ec6`](https://github.com/nodejs/node/commit/d8f8096ec6)] - **doc**: update example in repl.md (Vse Mozhet Byt) [#12685](https://github.com/nodejs/node/pull/12685)
* [[`deb9622b11`](https://github.com/nodejs/node/commit/deb9622b11)] - **doc**: Add initial documentation for N-API (Michael Dawson) [#12549](https://github.com/nodejs/node/pull/12549)
* [[`71911be1de`](https://github.com/nodejs/node/commit/71911be1de)] - **doc**: clarify arch support for power platforms (Michael Dawson) [#12679](https://github.com/nodejs/node/pull/12679)
* [[`71f22c842b`](https://github.com/nodejs/node/commit/71f22c842b)] - **doc**: replace uses of `you` and other style nits (James M Snell) [#12673](https://github.com/nodejs/node/pull/12673)
* [[`35d2137715`](https://github.com/nodejs/node/commit/35d2137715)] - **doc**: modernize and fix code examples in repl.md (Vse Mozhet Byt) [#12634](https://github.com/nodejs/node/pull/12634)
* [[`6ee6aaefa1`](https://github.com/nodejs/node/commit/6ee6aaefa1)] - **doc**: add no-var, prefer-const in doc eslintrc (Vse Mozhet Byt) [#12563](https://github.com/nodejs/node/pull/12563)
* [[`b4fea2a3d6`](https://github.com/nodejs/node/commit/b4fea2a3d6)] - **doc**: add eslint-plugin-markdown (Vse Mozhet Byt) [#12563](https://github.com/nodejs/node/pull/12563)
* [[`e2c3e4727d`](https://github.com/nodejs/node/commit/e2c3e4727d)] - **doc**: conform to rules for eslint-plugin-markdown (Vse Mozhet Byt) [#12563](https://github.com/nodejs/node/pull/12563)
* [[`211813c99c`](https://github.com/nodejs/node/commit/211813c99c)] - **doc**: unify quotes in an assert.md code example (Vse Mozhet Byt) [#12505](https://github.com/nodejs/node/pull/12505)
* [[`b4f59a7460`](https://github.com/nodejs/node/commit/b4f59a7460)] - **doc**: upgrade Clang requirement to 3.4.2 (Michaël Zasso) [#12388](https://github.com/nodejs/node/pull/12388)
* [[`b837bd2792`](https://github.com/nodejs/node/commit/b837bd2792)] - **doc**: fix typo in CHANGELOG.md (Gautam krishna.R) [#12434](https://github.com/nodejs/node/pull/12434)
* [[`fe1be39b28`](https://github.com/nodejs/node/commit/fe1be39b28)] - **doc**: child_process example for special chars (Cody Deckard)
* [[`e72ea0da0b`](https://github.com/nodejs/node/commit/e72ea0da0b)] - **doc**: modernize and fix code examples in process.md (Vse Mozhet Byt) [#12381](https://github.com/nodejs/node/pull/12381)
* [[`c6e0ba31ec`](https://github.com/nodejs/node/commit/c6e0ba31ec)] - **doc**: update OS level support for AIX (Michael Dawson) [#12235](https://github.com/nodejs/node/pull/12235)
* [[`6ebc806a47`](https://github.com/nodejs/node/commit/6ebc806a47)] - **doc**: correct markdown file line lengths (JR McEntee) [#12106](https://github.com/nodejs/node/pull/12106)
* [[`7a5d07c7fb`](https://github.com/nodejs/node/commit/7a5d07c7fb)] - **doc**: change Mac OS X to macOS (JR McEntee) [#12106](https://github.com/nodejs/node/pull/12106)
* [[`c79b081367`](https://github.com/nodejs/node/commit/c79b081367)] - **doc**: fix typo in CHANGELOG_V6.md (Zero King) [#12206](https://github.com/nodejs/node/pull/12206)
* [[`ba0e3ac53d`](https://github.com/nodejs/node/commit/ba0e3ac53d)] - **doc**: minor improvements in BUILDING.md (Sakthipriyan Vairamani (thefourtheye)) [#11963](https://github.com/nodejs/node/pull/11963)
* [[`e40ac30e05`](https://github.com/nodejs/node/commit/e40ac30e05)] - **doc**: document extent of crypto Uint8Array support (Anna Henningsen) [#11982](https://github.com/nodejs/node/pull/11982)
* [[`ef4768754c`](https://github.com/nodejs/node/commit/ef4768754c)] - **doc**: add supported platforms list (Michael Dawson) [#11872](https://github.com/nodejs/node/pull/11872)
* [[`73e2d0bce6`](https://github.com/nodejs/node/commit/73e2d0bce6)] - **doc**: argument types for crypto methods (Amelia Clarke) [#11799](https://github.com/nodejs/node/pull/11799)
* [[`df97727272`](https://github.com/nodejs/node/commit/df97727272)] - **doc**: improve net.md on sockets and connections (Joyee Cheung) [#11700](https://github.com/nodejs/node/pull/11700)
* [[`3b05153cdc`](https://github.com/nodejs/node/commit/3b05153cdc)] - **doc**: various improvements to net.md (Joyee Cheung) [#11636](https://github.com/nodejs/node/pull/11636)
* [[`289e53265a`](https://github.com/nodejs/node/commit/289e53265a)] - **doc**: add missing entry in v6 changelog table (Luigi Pinca) [#11534](https://github.com/nodejs/node/pull/11534)
* [[`5da952472b`](https://github.com/nodejs/node/commit/5da952472b)] - **doc**: document pending semver-major API changes (Anna Henningsen) [#11489](https://github.com/nodejs/node/pull/11489)
* [[`52b253677a`](https://github.com/nodejs/node/commit/52b253677a)] - **doc**: fix sorting in API references (Vse Mozhet Byt) [#11331](https://github.com/nodejs/node/pull/11331)
* [[`ca8c30a35c`](https://github.com/nodejs/node/commit/ca8c30a35c)] - **doc**: update output examples in debugger.md (Vse Mozhet Byt) [#10944](https://github.com/nodejs/node/pull/10944)
* [[`c5a0dcedd3`](https://github.com/nodejs/node/commit/c5a0dcedd3)] - **doc**: fix math error in process.md (Diego Rodríguez Baquero) [#11158](https://github.com/nodejs/node/pull/11158)
* [[`93c4820458`](https://github.com/nodejs/node/commit/93c4820458)] - ***Revert*** "**doc**: correct vcbuild options for windows testing" (Gibson Fahnestock) [#10839](https://github.com/nodejs/node/pull/10839)
* [[`6d31bdb872`](https://github.com/nodejs/node/commit/6d31bdb872)] - **doc**: move Boron releases to LTS column (Anna Henningsen) [#10827](https://github.com/nodejs/node/pull/10827)
* [[`f3f2468bdc`](https://github.com/nodejs/node/commit/f3f2468bdc)] - **doc**: fix CHANGELOG.md table formatting (Сковорода Никита Андреевич) [#10743](https://github.com/nodejs/node/pull/10743)
* [[`65e7f62400`](https://github.com/nodejs/node/commit/65e7f62400)] - **doc**: fix heading type for v4.6.2 changelog (Myles Borins) [#9515](https://github.com/nodejs/node/pull/9515)
* [[`e1cabf6fbd`](https://github.com/nodejs/node/commit/e1cabf6fbd)] - **doc, test**: add note to response.getHeaders (Refael Ackermann) [#12887](https://github.com/nodejs/node/pull/12887)
* [[`42dca99cd7`](https://github.com/nodejs/node/commit/42dca99cd7)] - **doc, tools**: add doc linting to CI (Vse Mozhet Byt) [#12640](https://github.com/nodejs/node/pull/12640)
* [[`81b9b857aa`](https://github.com/nodejs/node/commit/81b9b857aa)] - **doc,build**: update configure help messages (Gibson Fahnestock) [#12978](https://github.com/nodejs/node/pull/12978)
* [[`50af2b95e0`](https://github.com/nodejs/node/commit/50af2b95e0)] - **errors**: AssertionError moved to internal/error (Faiz Halde) [#12906](https://github.com/nodejs/node/pull/12906)
* [[`7b4a72d797`](https://github.com/nodejs/node/commit/7b4a72d797)] - **errors**: add space between error name and code (James M Snell) [#12099](https://github.com/nodejs/node/pull/12099)
* [[`58066d16d5`](https://github.com/nodejs/node/commit/58066d16d5)] - **events**: remove unreachable code (cjihrig) [#12501](https://github.com/nodejs/node/pull/12501)
* [[`ea9eed5643`](https://github.com/nodejs/node/commit/ea9eed5643)] - **freelist**: simplify export (James M Snell) [#12644](https://github.com/nodejs/node/pull/12644)
* [[`d99b7bc8c9`](https://github.com/nodejs/node/commit/d99b7bc8c9)] - **fs**: fix realpath{Sync} on resolving pipes/sockets (Ebrahim Byagowi) [#13028](https://github.com/nodejs/node/pull/13028)
* [[`6f449db60f`](https://github.com/nodejs/node/commit/6f449db60f)] - **fs**: refactor deprecated functions for readability (Rich Trott) [#12910](https://github.com/nodejs/node/pull/12910)
* [[`08809f28ad`](https://github.com/nodejs/node/commit/08809f28ad)] - **fs**: simplify constant decls (James M Snell) [#12644](https://github.com/nodejs/node/pull/12644)
* [[`2264d9d4ba`](https://github.com/nodejs/node/commit/2264d9d4ba)] - **http**: improve outgoing string write performance (Brian White) [#13013](https://github.com/nodejs/node/pull/13013)
* [[`414f93ecb3`](https://github.com/nodejs/node/commit/414f93ecb3)] - **http**: fix IPv6 Host header check (Brian White) [#13122](https://github.com/nodejs/node/pull/13122)
* [[`55c95b1644`](https://github.com/nodejs/node/commit/55c95b1644)] - **http**: fix first body chunk fast case for UTF-16 (Anna Henningsen) [#12747](https://github.com/nodejs/node/pull/12747)
* [[`e283319969`](https://github.com/nodejs/node/commit/e283319969)] - **http**: fix permanent deoptimizations (Brian White) [#12456](https://github.com/nodejs/node/pull/12456)
* [[`e0a9ad1af2`](https://github.com/nodejs/node/commit/e0a9ad1af2)] - **http**: avoid retaining unneeded memory (Luigi Pinca) [#11926](https://github.com/nodejs/node/pull/11926)
* [[`74c1e02642`](https://github.com/nodejs/node/commit/74c1e02642)] - **http**: replace uses of self (James M Snell) [#11594](https://github.com/nodejs/node/pull/11594)
* [[`5425e0dcbe`](https://github.com/nodejs/node/commit/5425e0dcbe)] - **http**: use more efficient module.exports pattern (James M Snell) [#11594](https://github.com/nodejs/node/pull/11594)
* [[`69f3db4571`](https://github.com/nodejs/node/commit/69f3db4571)] - **http,https**: avoid instanceof for WHATWG URL (Brian White) [#12983](https://github.com/nodejs/node/pull/12983)
* [[`9ce2271e81`](https://github.com/nodejs/node/commit/9ce2271e81)] - **https**: support agent construction without new (cjihrig) [#12927](https://github.com/nodejs/node/pull/12927)
* [[`010f864426`](https://github.com/nodejs/node/commit/010f864426)] - **inspector**: --debug* deprecation and invalidation (Refael Ackermann) [#12949](https://github.com/nodejs/node/pull/12949)
* [[`bb77cce7a1`](https://github.com/nodejs/node/commit/bb77cce7a1)] - **inspector**: add missing virtual destructor (Eugene Ostroukhov) [#13198](https://github.com/nodejs/node/pull/13198)
* [[`39785c7780`](https://github.com/nodejs/node/commit/39785c7780)] - **inspector**: document bad usage for --inspect-port (Sam Roberts) [#12581](https://github.com/nodejs/node/pull/12581)
* [[`77d5e6f8da`](https://github.com/nodejs/node/commit/77d5e6f8da)] - **inspector**: fix process._debugEnd() for inspector (Eugene Ostroukhov) [#12777](https://github.com/nodejs/node/pull/12777)
* [[`7c3a23b9c1`](https://github.com/nodejs/node/commit/7c3a23b9c1)] - **inspector**: handle socket close before close frame (Eugene Ostroukhov) [#12937](https://github.com/nodejs/node/pull/12937)
* [[`15e160e626`](https://github.com/nodejs/node/commit/15e160e626)] - **inspector**: report when main context is destroyed (Eugene Ostroukhov) [#12814](https://github.com/nodejs/node/pull/12814)
* [[`3f48ab3042`](https://github.com/nodejs/node/commit/3f48ab3042)] - **inspector**: do not add 'inspector' property (Eugene Ostroukhov) [#12656](https://github.com/nodejs/node/pull/12656)
* [[`439b35aade`](https://github.com/nodejs/node/commit/439b35aade)] - **inspector**: remove AgentImpl (Eugene Ostroukhov) [#12576](https://github.com/nodejs/node/pull/12576)
* [[`42be835e05`](https://github.com/nodejs/node/commit/42be835e05)] - **inspector**: fix Coverity defects (Eugene Ostroukhov) [#12272](https://github.com/nodejs/node/pull/12272)
* [[`7954d2a4c7`](https://github.com/nodejs/node/commit/7954d2a4c7)] - **inspector**: use inspector API for "break on start" (Eugene Ostroukhov) [#12076](https://github.com/nodejs/node/pull/12076)
* [[`b170fb7c55`](https://github.com/nodejs/node/commit/b170fb7c55)] - **inspector**: proper WS URLs when bound to 0.0.0.0 (Eugene Ostroukhov) [#11755](https://github.com/nodejs/node/pull/11755)
* [[`54d331895c`](https://github.com/nodejs/node/commit/54d331895c)] - **lib**: add guard to originalConsole (Daniel Bevenius) [#12881](https://github.com/nodejs/node/pull/12881)
* [[`824fb49a70`](https://github.com/nodejs/node/commit/824fb49a70)] - **lib**: remove useless default caught (Jackson Tian) [#12884](https://github.com/nodejs/node/pull/12884)
* [[`9077b48271`](https://github.com/nodejs/node/commit/9077b48271)] - **lib**: refactor internal/util (James M Snell) [#11404](https://github.com/nodejs/node/pull/11404)
* [[`cfc8422a68`](https://github.com/nodejs/node/commit/cfc8422a68)] - **lib**: use Object.create(null) directly (Timothy Gu) [#11930](https://github.com/nodejs/node/pull/11930)
* [[`4eb194a2b1`](https://github.com/nodejs/node/commit/4eb194a2b1)] - **lib**: Use regex to compare error message (Kunal Pathak) [#11854](https://github.com/nodejs/node/pull/11854)
* [[`989713d343`](https://github.com/nodejs/node/commit/989713d343)] - **lib**: avoid using forEach (James M Snell) [#11582](https://github.com/nodejs/node/pull/11582)
* [[`4d090855c6`](https://github.com/nodejs/node/commit/4d090855c6)] - **lib**: avoid using forEach in LazyTransform (James M Snell) [#11582](https://github.com/nodejs/node/pull/11582)
* [[`3becb0206c`](https://github.com/nodejs/node/commit/3becb0206c)] - **lib,src**: improve writev() performance for Buffers (Brian White) [#13187](https://github.com/nodejs/node/pull/13187)
* [[`6bcf65d4a7`](https://github.com/nodejs/node/commit/6bcf65d4a7)] - **lib,test**: use regular expression literals (Rich Trott) [#12807](https://github.com/nodejs/node/pull/12807)
* [[`dd0624676c`](https://github.com/nodejs/node/commit/dd0624676c)] - **meta**: fix nits in README.md collaborators list (Vse Mozhet Byt) [#12866](https://github.com/nodejs/node/pull/12866)
* [[`98e54b0bd4`](https://github.com/nodejs/node/commit/98e54b0bd4)] - **meta**: restore original copyright header (James M Snell) [#10155](https://github.com/nodejs/node/pull/10155)
* [[`ed0716f0e9`](https://github.com/nodejs/node/commit/ed0716f0e9)] - **module**: refactor internal/module export style (James M Snell) [#12644](https://github.com/nodejs/node/pull/12644)
* [[`f97156623a`](https://github.com/nodejs/node/commit/f97156623a)] - **module**: standardize strip shebang behaviour (Sebastian Van Sande) [#12202](https://github.com/nodejs/node/pull/12202)
* [[`a63b245b0a`](https://github.com/nodejs/node/commit/a63b245b0a)] - **n-api**: Retain last code when getting error info (Jason Ginchereau) [#13087](https://github.com/nodejs/node/pull/13087)
* [[`008301167e`](https://github.com/nodejs/node/commit/008301167e)] - **n-api**: remove compiler warning (Anna Henningsen) [#13014](https://github.com/nodejs/node/pull/13014)
* [[`2e3fef7628`](https://github.com/nodejs/node/commit/2e3fef7628)] - **n-api**: Handle fatal exception in async callback (Jason Ginchereau) [#12838](https://github.com/nodejs/node/pull/12838)
* [[`2bbabb1f85`](https://github.com/nodejs/node/commit/2bbabb1f85)] - **n-api**: napi_get_cb_info should fill array (Jason Ginchereau) [#12863](https://github.com/nodejs/node/pull/12863)
* [[`cd32b77567`](https://github.com/nodejs/node/commit/cd32b77567)] - **n-api**: remove unnecessary try-catch bracket from certain APIs (Gabriel Schulhof) [#12705](https://github.com/nodejs/node/pull/12705)
* [[`972bfe1514`](https://github.com/nodejs/node/commit/972bfe1514)] - **n-api**: Sync with back-compat changes (Jason Ginchereau) [#12674](https://github.com/nodejs/node/pull/12674)
* [[`427125491f`](https://github.com/nodejs/node/commit/427125491f)] - **n-api**: Reference and external tests (Jason Ginchereau) [#12551](https://github.com/nodejs/node/pull/12551)
* [[`b7a341d7e5`](https://github.com/nodejs/node/commit/b7a341d7e5)] - **n-api**: Enable scope and ref APIs during exception (Jason Ginchereau) [#12524](https://github.com/nodejs/node/pull/12524)
* [[`ba7bac5c37`](https://github.com/nodejs/node/commit/ba7bac5c37)] - **n-api**: tighten null-checking and clean up last error (Gabriel Schulhof) [#12539](https://github.com/nodejs/node/pull/12539)
* [[`468275ac79`](https://github.com/nodejs/node/commit/468275ac79)] - **n-api**: remove napi_get_value_string_length() (Jason Ginchereau) [#12496](https://github.com/nodejs/node/pull/12496)
* [[`46f202690b`](https://github.com/nodejs/node/commit/46f202690b)] - **n-api**: fix coverity scan report (Michael Dawson) [#12365](https://github.com/nodejs/node/pull/12365)
* [[`ad5f987558`](https://github.com/nodejs/node/commit/ad5f987558)] - **n-api**: add string api for latin1 encoding (Sampson Gao) [#12368](https://github.com/nodejs/node/pull/12368)
* [[`affe0f2d2a`](https://github.com/nodejs/node/commit/affe0f2d2a)] - **n-api**: fix -Wmismatched-tags compiler warning (Ben Noordhuis) [#12333](https://github.com/nodejs/node/pull/12333)
* [[`9decfb1521`](https://github.com/nodejs/node/commit/9decfb1521)] - **n-api**: implement async helper methods (taylor.woll) [#12250](https://github.com/nodejs/node/pull/12250)
* [[`ca786c3734`](https://github.com/nodejs/node/commit/ca786c3734)] - **n-api**: change napi_callback to return napi_value (Taylor Woll) [#12248](https://github.com/nodejs/node/pull/12248)
* [[`8fbace163a`](https://github.com/nodejs/node/commit/8fbace163a)] - **n-api**: cache Symbol.hasInstance (Gabriel Schulhof) [#12246](https://github.com/nodejs/node/pull/12246)
* [[`84602845c6`](https://github.com/nodejs/node/commit/84602845c6)] - **n-api**: Update property attrs enum to match JS spec (Jason Ginchereau) [#12240](https://github.com/nodejs/node/pull/12240)
* [[`0a5bf4aee3`](https://github.com/nodejs/node/commit/0a5bf4aee3)] - **n-api**: create napi_env as a real structure (Gabriel Schulhof) [#12195](https://github.com/nodejs/node/pull/12195)
* [[`4a21e398d6`](https://github.com/nodejs/node/commit/4a21e398d6)] - **n-api**: break dep between v8 and napi attributes (Michael Dawson) [#12191](https://github.com/nodejs/node/pull/12191)
* [[`afd5966fa9`](https://github.com/nodejs/node/commit/afd5966fa9)] - **napi**: initialize and check status properly (Gabriel Schulhof) [#12283](https://github.com/nodejs/node/pull/12283)
* [[`491d59da84`](https://github.com/nodejs/node/commit/491d59da84)] - **napi**: supress invalid coverity leak message (Michael Dawson) [#12192](https://github.com/nodejs/node/pull/12192)
* [[`4fabcfc5a2`](https://github.com/nodejs/node/commit/4fabcfc5a2)] - ***Revert*** "**net**: remove unnecessary process.nextTick()" (Evan Lucas) [#12854](https://github.com/nodejs/node/pull/12854)
* [[`51664fc265`](https://github.com/nodejs/node/commit/51664fc265)] - **net**: add symbol to normalized connect() args (cjihrig) [#13069](https://github.com/nodejs/node/pull/13069)
* [[`212a7a609d`](https://github.com/nodejs/node/commit/212a7a609d)] - **net**: ensure net.connect calls Socket connect (Thomas Watson) [#12861](https://github.com/nodejs/node/pull/12861)
* [[`879d6663ea`](https://github.com/nodejs/node/commit/879d6663ea)] - **net**: remove an unused internal module `assertPort` (Daijiro Wachi) [#11812](https://github.com/nodejs/node/pull/11812)
* [[`896be833c8`](https://github.com/nodejs/node/commit/896be833c8)] - **node**: add missing option to --help output (Ruslan Bekenev) [#12763](https://github.com/nodejs/node/pull/12763)
* [[`579ff2a487`](https://github.com/nodejs/node/commit/579ff2a487)] - **process**: refactor internal/process.js export style (James M Snell) [#12644](https://github.com/nodejs/node/pull/12644)
* [[`776028c46b`](https://github.com/nodejs/node/commit/776028c46b)] - **querystring**: improve unescapeBuffer() performance (Jesus Seijas) [#12525](https://github.com/nodejs/node/pull/12525)
* [[`c98a8022b7`](https://github.com/nodejs/node/commit/c98a8022b7)] - **querystring**: move isHexTable to internal (Timothy Gu) [#11858](https://github.com/nodejs/node/pull/11858)
* [[`ff785fd517`](https://github.com/nodejs/node/commit/ff785fd517)] - **querystring**: fix empty pairs and optimize parse() (Brian White) [#11234](https://github.com/nodejs/node/pull/11234)
* [[`4c070d4897`](https://github.com/nodejs/node/commit/4c070d4897)] - **readline**: move escape codes into internal/readline (James M Snell) [#12755](https://github.com/nodejs/node/pull/12755)
* [[`4ac7a68ccd`](https://github.com/nodejs/node/commit/4ac7a68ccd)] - **readline**: multiple code cleanups (James M Snell) [#12755](https://github.com/nodejs/node/pull/12755)
* [[`392a8987c6`](https://github.com/nodejs/node/commit/392a8987c6)] - **readline**: use module.exports = {} on internal/readline (James M Snell) [#12755](https://github.com/nodejs/node/pull/12755)
* [[`9318f82937`](https://github.com/nodejs/node/commit/9318f82937)] - **readline**: use module.exports = {} (James M Snell) [#12755](https://github.com/nodejs/node/pull/12755)
* [[`c20e87a10e`](https://github.com/nodejs/node/commit/c20e87a10e)] - **repl**: fix /dev/null history file regression (Brian White) [#12762](https://github.com/nodejs/node/pull/12762)
* [[`b45abfda5f`](https://github.com/nodejs/node/commit/b45abfda5f)] - **repl**: fix permanent deoptimizations (Brian White) [#12456](https://github.com/nodejs/node/pull/12456)
* [[`c7b60165a6`](https://github.com/nodejs/node/commit/c7b60165a6)] - **repl**: Empty command should be sent to eval function (Jan Krems) [#11871](https://github.com/nodejs/node/pull/11871)
* [[`ac2e8820c4`](https://github.com/nodejs/node/commit/ac2e8820c4)] - **src**: reduce duplicate code in SafeGetenv() (cjihrig) [#13220](https://github.com/nodejs/node/pull/13220)
* [[`ec7cbaf266`](https://github.com/nodejs/node/commit/ec7cbaf266)] - **src**: update NODE_MODULE_VERSION to 57 (Michaël Zasso) [#12995](https://github.com/nodejs/node/pull/12995)
* [[`9d922c6c0e`](https://github.com/nodejs/node/commit/9d922c6c0e)] - **src**: fix InspectorStarted macro guard (Daniel Bevenius) [#13167](https://github.com/nodejs/node/pull/13167)
* [[`e7d098cea6`](https://github.com/nodejs/node/commit/e7d098cea6)] - **src**: ignore unused warning for inspector-agent.cc (Daniel Bevenius) [#13188](https://github.com/nodejs/node/pull/13188)
* [[`145ab052df`](https://github.com/nodejs/node/commit/145ab052df)] - **src**: add comment for TicketKeyCallback (Anna Henningsen) [#13193](https://github.com/nodejs/node/pull/13193)
* [[`b4f6ea06eb`](https://github.com/nodejs/node/commit/b4f6ea06eb)] - **src**: make StreamBase::GetAsyncWrap pure virtual (Anna Henningsen) [#13174](https://github.com/nodejs/node/pull/13174)
* [[`4fa2ee16bb`](https://github.com/nodejs/node/commit/4fa2ee16bb)] - **src**: add linux getauxval(AT_SECURE) in SafeGetenv (Daniel Bevenius) [#12548](https://github.com/nodejs/node/pull/12548)
* [[`287b11dc8c`](https://github.com/nodejs/node/commit/287b11dc8c)] - **src**: allow --tls-cipher-list in NODE_OPTIONS (Sam Roberts) [#13172](https://github.com/nodejs/node/pull/13172)
* [[`3ccef8e267`](https://github.com/nodejs/node/commit/3ccef8e267)] - **src**: correct endif comment SRC_NODE_API_H__ (Daniel Bevenius) [#13190](https://github.com/nodejs/node/pull/13190)
* [[`4cbdac3183`](https://github.com/nodejs/node/commit/4cbdac3183)] - **src**: redirect-warnings to file, not path (Sam Roberts) [#13120](https://github.com/nodejs/node/pull/13120)
* [[`85e2d56df1`](https://github.com/nodejs/node/commit/85e2d56df1)] - **src**: fix typo (Brian White) [#13085](https://github.com/nodejs/node/pull/13085)
* [[`1263b70e9e`](https://github.com/nodejs/node/commit/1263b70e9e)] - **src**: remove unused parameters (Brian White) [#13085](https://github.com/nodejs/node/pull/13085)
* [[`1acd4d2cc4`](https://github.com/nodejs/node/commit/1acd4d2cc4)] - **src**: assert that uv_async_init() succeeds (cjihrig) [#13116](https://github.com/nodejs/node/pull/13116)
* [[`f81281737c`](https://github.com/nodejs/node/commit/f81281737c)] - **src**: remove unnecessary forward declaration (Daniel Bevenius) [#13081](https://github.com/nodejs/node/pull/13081)
* [[`60132e83c3`](https://github.com/nodejs/node/commit/60132e83c3)] - **src**: check IsConstructCall in TLSWrap constructor (Daniel Bevenius) [#13097](https://github.com/nodejs/node/pull/13097)
* [[`57b9b9d7d6`](https://github.com/nodejs/node/commit/57b9b9d7d6)] - **src**: remove unnecessary return statement (Daniel Bevenius) [#13094](https://github.com/nodejs/node/pull/13094)
* [[`94eca79d5d`](https://github.com/nodejs/node/commit/94eca79d5d)] - **src**: remove unused node_buffer.h include (Daniel Bevenius) [#13095](https://github.com/nodejs/node/pull/13095)
* [[`46e773c5db`](https://github.com/nodejs/node/commit/46e773c5db)] - **src**: check if --icu-data-dir= points to valid dir (Ben Noordhuis)
* [[`29d89c9855`](https://github.com/nodejs/node/commit/29d89c9855)] - **src**: split CryptoPemCallback into two functions (Daniel Bevenius) [#12827](https://github.com/nodejs/node/pull/12827)
* [[`d6cd466a25`](https://github.com/nodejs/node/commit/d6cd466a25)] - **src**: whitelist new options for NODE_OPTIONS (Sam Roberts) [#13002](https://github.com/nodejs/node/pull/13002)
* [[`53dae83833`](https://github.com/nodejs/node/commit/53dae83833)] - **src**: fix --abort_on_uncaught_exception arg parsing (Sam Roberts) [#13004](https://github.com/nodejs/node/pull/13004)
* [[`fefab9026b`](https://github.com/nodejs/node/commit/fefab9026b)] - **src**: only call FatalException if not verbose (Daniel Bevenius) [#12826](https://github.com/nodejs/node/pull/12826)
* [[`32f01c8c11`](https://github.com/nodejs/node/commit/32f01c8c11)] - **src**: remove unused uv.h include in async-wrap.h (Daniel Bevenius) [#12973](https://github.com/nodejs/node/pull/12973)
* [[`60f0dc7d42`](https://github.com/nodejs/node/commit/60f0dc7d42)] - **src**: rename CONNECTION provider to SSLCONNECTION (Daniel Bevenius) [#12989](https://github.com/nodejs/node/pull/12989)
* [[`15410797f2`](https://github.com/nodejs/node/commit/15410797f2)] - **src**: add HAVE_OPENSSL guard to crypto providers (Daniel Bevenius) [#12967](https://github.com/nodejs/node/pull/12967)
* [[`9f8e030f1b`](https://github.com/nodejs/node/commit/9f8e030f1b)] - **src**: add/move hasCrypto checks for async tests (Daniel Bevenius) [#12968](https://github.com/nodejs/node/pull/12968)
* [[`b6001a2da5`](https://github.com/nodejs/node/commit/b6001a2da5)] - **src**: make SIGPROF message a real warning (cjihrig) [#12709](https://github.com/nodejs/node/pull/12709)
* [[`dd6e3f69a7`](https://github.com/nodejs/node/commit/dd6e3f69a7)] - **src**: fix comments re PER_ISOLATE macros (Josh Gavant) [#12899](https://github.com/nodejs/node/pull/12899)
* [[`6ade7f3601`](https://github.com/nodejs/node/commit/6ade7f3601)] - **src**: update --inspect hint text (Josh Gavant) [#11207](https://github.com/nodejs/node/pull/11207)
* [[`d0c968ea57`](https://github.com/nodejs/node/commit/d0c968ea57)] - **src**: make root_cert_vector function scoped (Daniel Bevenius) [#12788](https://github.com/nodejs/node/pull/12788)
* [[`ebcd8c6bb8`](https://github.com/nodejs/node/commit/ebcd8c6bb8)] - **src**: rename CryptoPemCallback -\> PasswordCallback (Daniel Bevenius) [#12787](https://github.com/nodejs/node/pull/12787)
* [[`d56a7e640f`](https://github.com/nodejs/node/commit/d56a7e640f)] - **src**: do proper StringBytes error handling (Anna Henningsen) [#12765](https://github.com/nodejs/node/pull/12765)
* [[`9990be2919`](https://github.com/nodejs/node/commit/9990be2919)] - **src**: turn buffer type-CHECK into exception (Anna Henningsen) [#12753](https://github.com/nodejs/node/pull/12753)
* [[`21653b6901`](https://github.com/nodejs/node/commit/21653b6901)] - **src**: add --napi-modules to whitelist (Michael Dawson) [#12733](https://github.com/nodejs/node/pull/12733)
* [[`0f58d3cbef`](https://github.com/nodejs/node/commit/0f58d3cbef)] - **src**: support domains with empty labels (Daijiro Wachi) [#12707](https://github.com/nodejs/node/pull/12707)
* [[`719247ff95`](https://github.com/nodejs/node/commit/719247ff95)] - **src**: remove debugger dead code (Michaël Zasso) [#12621](https://github.com/nodejs/node/pull/12621)
* [[`892ce06dbd`](https://github.com/nodejs/node/commit/892ce06dbd)] - **src**: fix incorrect macro comment (Daniel Bevenius) [#12688](https://github.com/nodejs/node/pull/12688)
* [[`5bb06e8596`](https://github.com/nodejs/node/commit/5bb06e8596)] - **src**: remove GTEST_DONT_DEFINE_ASSERT_EQ in util.h (Daniel Bevenius) [#12638](https://github.com/nodejs/node/pull/12638)
* [[`f2282bb812`](https://github.com/nodejs/node/commit/f2282bb812)] - **src**: allow CLI args in env with NODE_OPTIONS (Sam Roberts) [#12028](https://github.com/nodejs/node/pull/12028)
* [[`6a1275dfec`](https://github.com/nodejs/node/commit/6a1275dfec)] - **src**: add missing "http_parser.h" include (Anna Henningsen) [#12464](https://github.com/nodejs/node/pull/12464)
* [[`5ef6000afd`](https://github.com/nodejs/node/commit/5ef6000afd)] - **src**: don't call uv_run() after 'exit' event (Ben Noordhuis) [#12344](https://github.com/nodejs/node/pull/12344)
* [[`ade80eeb1a`](https://github.com/nodejs/node/commit/ade80eeb1a)] - **src**: clean up WHATWG WG parser (Timothy Gu) [#12251](https://github.com/nodejs/node/pull/12251)
* [[`b2803637e8`](https://github.com/nodejs/node/commit/b2803637e8)] - **src**: replace IsConstructCall functions with lambda (Daniel Bevenius) [#12384](https://github.com/nodejs/node/pull/12384)
* [[`9d522225e7`](https://github.com/nodejs/node/commit/9d522225e7)] - **src**: reduce number of exported symbols (Anna Henningsen) [#12366](https://github.com/nodejs/node/pull/12366)
* [[`a4125a3c49`](https://github.com/nodejs/node/commit/a4125a3c49)] - **src**: remove experimental warning for inspect (Josh Gavant) [#12352](https://github.com/nodejs/node/pull/12352)
* [[`8086cb68ae`](https://github.com/nodejs/node/commit/8086cb68ae)] - **src**: use option parser for expose_internals (Sam Roberts) [#12245](https://github.com/nodejs/node/pull/12245)
* [[`e505c079e0`](https://github.com/nodejs/node/commit/e505c079e0)] - **src**: supply missing comments for CLI options (Sam Roberts) [#12245](https://github.com/nodejs/node/pull/12245)
* [[`de168b4b4a`](https://github.com/nodejs/node/commit/de168b4b4a)] - **src**: guard bundled_ca/openssl_ca with HAVE_OPENSSL (Daniel Bevenius) [#12302](https://github.com/nodejs/node/pull/12302)
* [[`cecdf7c118`](https://github.com/nodejs/node/commit/cecdf7c118)] - **src**: use a std::vector for preload_modules (Sam Roberts) [#12241](https://github.com/nodejs/node/pull/12241)
* [[`65a6e05da5`](https://github.com/nodejs/node/commit/65a6e05da5)] - **src**: only block SIGUSR1 when HAVE_INSPECTOR (Daniel Bevenius) [#12266](https://github.com/nodejs/node/pull/12266)
* [[`ebeee853e6`](https://github.com/nodejs/node/commit/ebeee853e6)] - **src**: Update trace event macros to V8 5.7 version (Matt Loring) [#12127](https://github.com/nodejs/node/pull/12127)
* [[`7c0079f1be`](https://github.com/nodejs/node/commit/7c0079f1be)] - **src**: add .FromJust(), fix -Wunused-result warnings (Ben Noordhuis) [#12118](https://github.com/nodejs/node/pull/12118)
* [[`4ddd23f0ec`](https://github.com/nodejs/node/commit/4ddd23f0ec)] - **src**: WHATWG URL C++ parser cleanup (Timothy Gu) [#11917](https://github.com/nodejs/node/pull/11917)
* [[`d099f8e317`](https://github.com/nodejs/node/commit/d099f8e317)] - **src**: remove explicit UTF-8 validity check in url (Timothy Gu) [#11859](https://github.com/nodejs/node/pull/11859)
* [[`e2f151f5b2`](https://github.com/nodejs/node/commit/e2f151f5b2)] - **src**: make process.env work with symbols in/delete (Timothy Gu) [#11709](https://github.com/nodejs/node/pull/11709)
* [[`e1d8899c28`](https://github.com/nodejs/node/commit/e1d8899c28)] - **src**: add HAVE_OPENSSL directive to openssl_config (Daniel Bevenius) [#11618](https://github.com/nodejs/node/pull/11618)
* [[`a7f7724167`](https://github.com/nodejs/node/commit/a7f7724167)] - **src**: remove misleading flag in TwoByteValue (Timothy Gu) [#11436](https://github.com/nodejs/node/pull/11436)
* [[`046f66a554`](https://github.com/nodejs/node/commit/046f66a554)] - **src**: fix building --without-v8-plartform (Myk Melez) [#11088](https://github.com/nodejs/node/pull/11088)
* [[`d317184f97`](https://github.com/nodejs/node/commit/d317184f97)] - **src**: bump version to v8.0.0 for master (Rod Vagg) [#8956](https://github.com/nodejs/node/pull/8956)
* [[`f077e51c92`](https://github.com/nodejs/node/commit/f077e51c92)] - **src,fs**: calculate fs times without truncation (Daniel Pihlstrom) [#12607](https://github.com/nodejs/node/pull/12607)
* [[`b8b6c2c262`](https://github.com/nodejs/node/commit/b8b6c2c262)] - **stream**: emit finish when using writev and cork (Matteo Collina) [#13195](https://github.com/nodejs/node/pull/13195)
* [[`c15fe8b78e`](https://github.com/nodejs/node/commit/c15fe8b78e)] - **stream**: remove dup property (Calvin Metcalf) [#13216](https://github.com/nodejs/node/pull/13216)
* [[`87cef63ccb`](https://github.com/nodejs/node/commit/87cef63ccb)] - **stream**: fix destroy(err, cb) regression (Matteo Collina) [#13156](https://github.com/nodejs/node/pull/13156)
* [[`8914f7b4b7`](https://github.com/nodejs/node/commit/8914f7b4b7)] - **stream**: improve readable push performance (Brian White) [#13113](https://github.com/nodejs/node/pull/13113)
* [[`6993eb0897`](https://github.com/nodejs/node/commit/6993eb0897)] - **stream**: fix y.pipe(x)+y.pipe(x)+y.unpipe(x) (Anna Henningsen) [#12746](https://github.com/nodejs/node/pull/12746)
* [[`d6a6bcdc47`](https://github.com/nodejs/node/commit/d6a6bcdc47)] - **stream**: remove unnecessary parameter (Leo) [#12767](https://github.com/nodejs/node/pull/12767)
* [[`e2199e0fc2`](https://github.com/nodejs/node/commit/e2199e0fc2)] - **streams**: refactor BufferList into ES6 class (James M Snell) [#12644](https://github.com/nodejs/node/pull/12644)
* [[`ea6941f703`](https://github.com/nodejs/node/commit/ea6941f703)] - **test**: refactor test-fs-assert-encoding-error (Rich Trott) [#13226](https://github.com/nodejs/node/pull/13226)
* [[`8d193919fb`](https://github.com/nodejs/node/commit/8d193919fb)] - **test**: replace `indexOf` with `includes` (Aditya Anand) [#13215](https://github.com/nodejs/node/pull/13215)
* [[`2c5c2bda61`](https://github.com/nodejs/node/commit/2c5c2bda61)] - **test**: check noop invocation with mustNotCall() (Rich Trott) [#13205](https://github.com/nodejs/node/pull/13205)
* [[`d0dbd53eb0`](https://github.com/nodejs/node/commit/d0dbd53eb0)] - **test**: add coverage for socket write after close (cjihrig) [#13171](https://github.com/nodejs/node/pull/13171)
* [[`686e753b7e`](https://github.com/nodejs/node/commit/686e753b7e)] - **test**: use common.mustNotCall in test-crypto-random (Rich Trott) [#13183](https://github.com/nodejs/node/pull/13183)
* [[`4030aed8ce`](https://github.com/nodejs/node/commit/4030aed8ce)] - **test**: skip test-bindings if inspector is disabled (Daniel Bevenius) [#13186](https://github.com/nodejs/node/pull/13186)
* [[`a590709909`](https://github.com/nodejs/node/commit/a590709909)] - **test**: add coverage for napi_has_named_property (Michael Dawson) [#13178](https://github.com/nodejs/node/pull/13178)
* [[`72a319e417`](https://github.com/nodejs/node/commit/72a319e417)] - **test**: refactor event-emitter-remove-all-listeners (Rich Trott) [#13165](https://github.com/nodejs/node/pull/13165)
* [[`c4502728fb`](https://github.com/nodejs/node/commit/c4502728fb)] - **test**: refactor event-emitter-check-listener-leaks (Rich Trott) [#13164](https://github.com/nodejs/node/pull/13164)
* [[`597aff0846`](https://github.com/nodejs/node/commit/597aff0846)] - **test**: cover dgram handle send failures (cjihrig) [#13158](https://github.com/nodejs/node/pull/13158)
* [[`5ad4170cd9`](https://github.com/nodejs/node/commit/5ad4170cd9)] - **test**: cover util.format() format placeholders (cjihrig) [#13159](https://github.com/nodejs/node/pull/13159)
* [[`b781fa7b06`](https://github.com/nodejs/node/commit/b781fa7b06)] - **test**: add override to ServerDone function (Daniel Bevenius) [#13166](https://github.com/nodejs/node/pull/13166)
* [[`a985ed66c4`](https://github.com/nodejs/node/commit/a985ed66c4)] - **test**: refactor test-dns (Rich Trott) [#13163](https://github.com/nodejs/node/pull/13163)
* [[`7fe5303983`](https://github.com/nodejs/node/commit/7fe5303983)] - **test**: fix disabled test-fs-largefile (Rich Trott) [#13147](https://github.com/nodejs/node/pull/13147)
* [[`e012f5a412`](https://github.com/nodejs/node/commit/e012f5a412)] - **test**: move stream2 test from pummel to parallel (Rich Trott) [#13146](https://github.com/nodejs/node/pull/13146)
* [[`9100cac146`](https://github.com/nodejs/node/commit/9100cac146)] - **test**: simplify assert usage in test-stream2-basic (Rich Trott) [#13146](https://github.com/nodejs/node/pull/13146)
* [[`cd70a520d2`](https://github.com/nodejs/node/commit/cd70a520d2)] - **test**: check noop function invocations (Rich Trott) [#13146](https://github.com/nodejs/node/pull/13146)
* [[`110a3b2657`](https://github.com/nodejs/node/commit/110a3b2657)] - **test**: confirm callback is invoked in fs test (Rich Trott) [#13132](https://github.com/nodejs/node/pull/13132)
* [[`1da674e2c0`](https://github.com/nodejs/node/commit/1da674e2c0)] - **test**: check number of message events (Rich Trott) [#13125](https://github.com/nodejs/node/pull/13125)
* [[`4ccfd7cf15`](https://github.com/nodejs/node/commit/4ccfd7cf15)] - **test**: increase n-api constructor coverage (Michael Dawson) [#13124](https://github.com/nodejs/node/pull/13124)
* [[`6cfb876d54`](https://github.com/nodejs/node/commit/6cfb876d54)] - **test**: add regression test for immediate socket errors (Evan Lucas) [#12854](https://github.com/nodejs/node/pull/12854)
* [[`268a39ac2a`](https://github.com/nodejs/node/commit/268a39ac2a)] - **test**: add hasCrypto check to async-wrap-GH13045 (Daniel Bevenius) [#13141](https://github.com/nodejs/node/pull/13141)
* [[`e6c03c78f7`](https://github.com/nodejs/node/commit/e6c03c78f7)] - **test**: fix sequential test-net-connect-local-error (Sebastian Plesciuc) [#13064](https://github.com/nodejs/node/pull/13064)
* [[`511ee24310`](https://github.com/nodejs/node/commit/511ee24310)] - **test**: remove common.PORT from dgram test (Artur Vieira) [#12944](https://github.com/nodejs/node/pull/12944)
* [[`8a4f3b7dfc`](https://github.com/nodejs/node/commit/8a4f3b7dfc)] - **test**: bind to 0 in dgram-send-callback-buffer-length (Artur Vieira) [#12943](https://github.com/nodejs/node/pull/12943)
* [[`9fc47de8e6`](https://github.com/nodejs/node/commit/9fc47de8e6)] - **test**: use dynamic port in test-dgram-send-address-types (Artur Vieira) [#13007](https://github.com/nodejs/node/pull/13007)
* [[`8ef4fe0af2`](https://github.com/nodejs/node/commit/8ef4fe0af2)] - **test**: use dynamic port in test-dgram-send-callback-buffer (Artur Vieira) [#12942](https://github.com/nodejs/node/pull/12942)
* [[`96925e1b93`](https://github.com/nodejs/node/commit/96925e1b93)] - **test**: replace common.PORT in dgram test (Artur Vieira) [#12929](https://github.com/nodejs/node/pull/12929)
* [[`1af8b70c57`](https://github.com/nodejs/node/commit/1af8b70c57)] - **test**: allow for absent nobody user in setuid test (Rich Trott) [#13112](https://github.com/nodejs/node/pull/13112)
* [[`e29477ab25`](https://github.com/nodejs/node/commit/e29477ab25)] - **test**: shorten test-benchmark-http (Rich Trott) [#13109](https://github.com/nodejs/node/pull/13109)
* [[`595e5e3b23`](https://github.com/nodejs/node/commit/595e5e3b23)] - **test**: port disabled readline test (Rich Trott) [#13091](https://github.com/nodejs/node/pull/13091)
* [[`c60a7fa738`](https://github.com/nodejs/node/commit/c60a7fa738)] - **test**: move net reconnect error test to sequential (Artur G Vieira) [#13033](https://github.com/nodejs/node/pull/13033)
* [[`525497596a`](https://github.com/nodejs/node/commit/525497596a)] - **test**: refactor test-net-GH-5504 (Rich Trott) [#13025](https://github.com/nodejs/node/pull/13025)
* [[`658741b9d9`](https://github.com/nodejs/node/commit/658741b9d9)] - **test**: refactor test-https-set-timeout-server (Rich Trott) [#13032](https://github.com/nodejs/node/pull/13032)
* [[`fccc0bf6e6`](https://github.com/nodejs/node/commit/fccc0bf6e6)] - **test**: add mustCallAtLeast (Refael Ackermann) [#12935](https://github.com/nodejs/node/pull/12935)
* [[`6f216710eb`](https://github.com/nodejs/node/commit/6f216710eb)] - **test**: ignore spurious 'EMFILE' (Refael Ackermann) [#12698](https://github.com/nodejs/node/pull/12698)
* [[`6b1819cff5`](https://github.com/nodejs/node/commit/6b1819cff5)] - **test**: use dynamic port in test-cluster-dgram-reuse (Artur Vieira) [#12901](https://github.com/nodejs/node/pull/12901)
* [[`a593c74f81`](https://github.com/nodejs/node/commit/a593c74f81)] - **test**: refactor test-vm-new-script-new-context (Akshay Iyer) [#13035](https://github.com/nodejs/node/pull/13035)
* [[`7e5ed8bad9`](https://github.com/nodejs/node/commit/7e5ed8bad9)] - **test**: track callback invocations (Rich Trott) [#13010](https://github.com/nodejs/node/pull/13010)
* [[`47e3d00241`](https://github.com/nodejs/node/commit/47e3d00241)] - **test**: refactor test-dns-regress-6244.js (Rich Trott) [#13058](https://github.com/nodejs/node/pull/13058)
* [[`6933419cb9`](https://github.com/nodejs/node/commit/6933419cb9)] - **test**: add hasCrypto to tls-lookup (Daniel Bevenius) [#13047](https://github.com/nodejs/node/pull/13047)
* [[`0dd8b9a965`](https://github.com/nodejs/node/commit/0dd8b9a965)] - **test**: Improve N-API test coverage (Michael Dawson) [#13044](https://github.com/nodejs/node/pull/13044)
* [[`5debcceafc`](https://github.com/nodejs/node/commit/5debcceafc)] - **test**: add hasCrypto to tls-wrap-event-emmiter (Daniel Bevenius) [#13041](https://github.com/nodejs/node/pull/13041)
* [[`7906ed50fa`](https://github.com/nodejs/node/commit/7906ed50fa)] - **test**: add regex check in test-url-parse-invalid-input (Andrei Cioromila) [#12879](https://github.com/nodejs/node/pull/12879)
* [[`0c2edd27e6`](https://github.com/nodejs/node/commit/0c2edd27e6)] - **test**: fixed flaky test-net-connect-local-error (Sebastian Plesciuc) [#12964](https://github.com/nodejs/node/pull/12964)
* [[`47c3c58704`](https://github.com/nodejs/node/commit/47c3c58704)] - **test**: improve N-API test coverage (Michael Dawson) [#13006](https://github.com/nodejs/node/pull/13006)
* [[`88d2e699d8`](https://github.com/nodejs/node/commit/88d2e699d8)] - **test**: remove unneeded string splitting (Vse Mozhet Byt) [#12992](https://github.com/nodejs/node/pull/12992)
* [[`72e3dda93c`](https://github.com/nodejs/node/commit/72e3dda93c)] - **test**: use mustCall in tls-connect-given-socket (vperezma) [#12592](https://github.com/nodejs/node/pull/12592)
* [[`b7bc09fd60`](https://github.com/nodejs/node/commit/b7bc09fd60)] - **test**: add not-called check to heap-profiler test (Rich Trott) [#12985](https://github.com/nodejs/node/pull/12985)
* [[`b5ae22dd1c`](https://github.com/nodejs/node/commit/b5ae22dd1c)] - **test**: add hasCrypto check to https-agent-constructor (Daniel Bevenius) [#12987](https://github.com/nodejs/node/pull/12987)
* [[`945f208081`](https://github.com/nodejs/node/commit/945f208081)] - **test**: make the rest of tests path-independent (Vse Mozhet Byt) [#12972](https://github.com/nodejs/node/pull/12972)
* [[`9516aa19c1`](https://github.com/nodejs/node/commit/9516aa19c1)] - **test**: add common.mustCall() to NAPI exception test (Rich Trott) [#12959](https://github.com/nodejs/node/pull/12959)
* [[`84fc069b95`](https://github.com/nodejs/node/commit/84fc069b95)] - **test**: move test-dgram-bind-shared-ports to sequential (Rafael Fragoso) [#12452](https://github.com/nodejs/node/pull/12452)
* [[`642bd4dd6d`](https://github.com/nodejs/node/commit/642bd4dd6d)] - **test**: add a simple abort check in windows (Sreepurna Jasti) [#12914](https://github.com/nodejs/node/pull/12914)
* [[`56812c81a3`](https://github.com/nodejs/node/commit/56812c81a3)] - **test**: use dynamic port in test-https-connect-address-family (Artur G Vieira) [#12915](https://github.com/nodejs/node/pull/12915)
* [[`529e4f206a`](https://github.com/nodejs/node/commit/529e4f206a)] - **test**: make a test path-independent (Vse Mozhet Byt) [#12945](https://github.com/nodejs/node/pull/12945)
* [[`631cb42b4e`](https://github.com/nodejs/node/commit/631cb42b4e)] - **test**: favor deepStrictEqual over deepEqual (Rich Trott) [#12883](https://github.com/nodejs/node/pull/12883)
* [[`654afa2c19`](https://github.com/nodejs/node/commit/654afa2c19)] - **test**: improve n-api array func coverage (Michael Dawson) [#12890](https://github.com/nodejs/node/pull/12890)
* [[`bee250c232`](https://github.com/nodejs/node/commit/bee250c232)] - **test**: dynamic port in cluster disconnect (Sebastian Plesciuc) [#12545](https://github.com/nodejs/node/pull/12545)
* [[`6914aeaefd`](https://github.com/nodejs/node/commit/6914aeaefd)] - **test**: detect all types of aborts in windows (Gireesh Punathil) [#12856](https://github.com/nodejs/node/pull/12856)
* [[`cfe7b34058`](https://github.com/nodejs/node/commit/cfe7b34058)] - **test**: use assert regexp in tls no cert test (Artur Vieira) [#12891](https://github.com/nodejs/node/pull/12891)
* [[`317180ffe5`](https://github.com/nodejs/node/commit/317180ffe5)] - **test**: fix flaky test-https-client-get-url (Sebastian Plesciuc) [#12876](https://github.com/nodejs/node/pull/12876)
* [[`57a08e2f70`](https://github.com/nodejs/node/commit/57a08e2f70)] - **test**: remove obsolete lint config comments (Rich Trott) [#12868](https://github.com/nodejs/node/pull/12868)
* [[`94eed0fb11`](https://github.com/nodejs/node/commit/94eed0fb11)] - **test**: use dynamic port instead of common.PORT (Aditya Anand) [#12473](https://github.com/nodejs/node/pull/12473)
* [[`f72376d323`](https://github.com/nodejs/node/commit/f72376d323)] - **test**: add skipIfInspectorDisabled to debugger-pid (Daniel Bevenius) [#12882](https://github.com/nodejs/node/pull/12882)
* [[`771568a5a5`](https://github.com/nodejs/node/commit/771568a5a5)] - **test**: add test for timers benchmarks (Joyee Cheung) [#12851](https://github.com/nodejs/node/pull/12851)
* [[`dc4313c620`](https://github.com/nodejs/node/commit/dc4313c620)] - **test**: remove unused testpy code (Rich Trott) [#12844](https://github.com/nodejs/node/pull/12844)
* [[`0a734fec88`](https://github.com/nodejs/node/commit/0a734fec88)] - **test**: fix napi test_reference for recent V8 (Michaël Zasso) [#12864](https://github.com/nodejs/node/pull/12864)
* [[`42958d1a75`](https://github.com/nodejs/node/commit/42958d1a75)] - **test**: refactor test-querystring (Łukasz Szewczak) [#12661](https://github.com/nodejs/node/pull/12661)
* [[`152966dbb5`](https://github.com/nodejs/node/commit/152966dbb5)] - **test**: refactoring test with common.mustCall (weewey) [#12702](https://github.com/nodejs/node/pull/12702)
* [[`6058c4349f`](https://github.com/nodejs/node/commit/6058c4349f)] - **test**: refactored test-repl-persistent-history (cool88) [#12703](https://github.com/nodejs/node/pull/12703)
* [[`dac9f42a7e`](https://github.com/nodejs/node/commit/dac9f42a7e)] - **test**: remove common.PORT in test tls ticket cluster (Oscar Martinez) [#12715](https://github.com/nodejs/node/pull/12715)
* [[`d37f27a008`](https://github.com/nodejs/node/commit/d37f27a008)] - **test**: expand test coverage of readline (James M Snell) [#12755](https://github.com/nodejs/node/pull/12755)
* [[`a710e443a2`](https://github.com/nodejs/node/commit/a710e443a2)] - **test**: complete coverage of buffer (David Cai) [#12831](https://github.com/nodejs/node/pull/12831)
* [[`3fd890a06e`](https://github.com/nodejs/node/commit/3fd890a06e)] - **test**: add mustCall in timers-unrefed-in-callback (Zahidul Islam) [#12594](https://github.com/nodejs/node/pull/12594)
* [[`73d9c0f903`](https://github.com/nodejs/node/commit/73d9c0f903)] - **test**: port test for make_callback to n-api (Hitesh Kanwathirtha) [#12409](https://github.com/nodejs/node/pull/12409)
* [[`68c933c01e`](https://github.com/nodejs/node/commit/68c933c01e)] - **test**: fix flakyness with `yes.exe` (Refael Ackermann) [#12821](https://github.com/nodejs/node/pull/12821)
* [[`8b76c3e60c`](https://github.com/nodejs/node/commit/8b76c3e60c)] - **test**: reduce string concatenations (Vse Mozhet Byt) [#12735](https://github.com/nodejs/node/pull/12735)
* [[`f1d593cda1`](https://github.com/nodejs/node/commit/f1d593cda1)] - **test**: make tests cwd-independent (Vse Mozhet Byt) [#12812](https://github.com/nodejs/node/pull/12812)
* [[`94a120cf65`](https://github.com/nodejs/node/commit/94a120cf65)] - **test**: add coverage for error apis (Michael Dawson) [#12729](https://github.com/nodejs/node/pull/12729)
* [[`bc05436a89`](https://github.com/nodejs/node/commit/bc05436a89)] - **test**: add regex check in test-vm-is-context (jeyanthinath) [#12785](https://github.com/nodejs/node/pull/12785)
* [[`665695fbea`](https://github.com/nodejs/node/commit/665695fbea)] - **test**: add callback to fs.close() in test-fs-stat (Vse Mozhet Byt) [#12804](https://github.com/nodejs/node/pull/12804)
* [[`712596fc45`](https://github.com/nodejs/node/commit/712596fc45)] - **test**: add callback to fs.close() in test-fs-chmod (Vse Mozhet Byt) [#12795](https://github.com/nodejs/node/pull/12795)
* [[`f971916885`](https://github.com/nodejs/node/commit/f971916885)] - **test**: fix too optimistic guess in setproctitle (Vse Mozhet Byt) [#12792](https://github.com/nodejs/node/pull/12792)
* [[`4677766d21`](https://github.com/nodejs/node/commit/4677766d21)] - **test**: enable test-debugger-pid (Rich Trott) [#12770](https://github.com/nodejs/node/pull/12770)
* [[`ff001c12b0`](https://github.com/nodejs/node/commit/ff001c12b0)] - **test**: move WPT to its own testing module (Rich Trott) [#12736](https://github.com/nodejs/node/pull/12736)
* [[`b2ab41e5ae`](https://github.com/nodejs/node/commit/b2ab41e5ae)] - **test**: increase readline coverage (Anna Henningsen) [#12761](https://github.com/nodejs/node/pull/12761)
* [[`8aca66a1f3`](https://github.com/nodejs/node/commit/8aca66a1f3)] - **test**: fix warning in n-api reference test (Michael Dawson) [#12730](https://github.com/nodejs/node/pull/12730)
* [[`04796ee97f`](https://github.com/nodejs/node/commit/04796ee97f)] - **test**: increase coverage of buffer (David Cai) [#12714](https://github.com/nodejs/node/pull/12714)
* [[`133fb0c3b7`](https://github.com/nodejs/node/commit/133fb0c3b7)] - **test**: minor fixes to test-module-loading.js (Walter Huang) [#12728](https://github.com/nodejs/node/pull/12728)
* [[`9f7b54945e`](https://github.com/nodejs/node/commit/9f7b54945e)] - ***Revert*** "**test**: remove eslint comments" (Joyee Cheung) [#12743](https://github.com/nodejs/node/pull/12743)
* [[`10ccf56f89`](https://github.com/nodejs/node/commit/10ccf56f89)] - **test**: skipIfInspectorDisabled cluster-inspect-brk (Daniel Bevenius) [#12757](https://github.com/nodejs/node/pull/12757)
* [[`0142276977`](https://github.com/nodejs/node/commit/0142276977)] - **test**: replace indexOf with includes (gwer) [#12604](https://github.com/nodejs/node/pull/12604)
* [[`0324ac686c`](https://github.com/nodejs/node/commit/0324ac686c)] - **test**: add inspect-brk option to cluster module (dave-k) [#12503](https://github.com/nodejs/node/pull/12503)
* [[`d5db4d25dc`](https://github.com/nodejs/node/commit/d5db4d25dc)] - **test**: cleanup handles in test_environment (Anna Henningsen) [#12621](https://github.com/nodejs/node/pull/12621)
* [[`427cd293d5`](https://github.com/nodejs/node/commit/427cd293d5)] - **test**: add hasCrypto check to test-cli-node-options (Daniel Bevenius) [#12692](https://github.com/nodejs/node/pull/12692)
* [[`0101a8f1a6`](https://github.com/nodejs/node/commit/0101a8f1a6)] - **test**: add relative path to accommodate limit (coreybeaumont) [#12601](https://github.com/nodejs/node/pull/12601)
* [[`b16869c4e4`](https://github.com/nodejs/node/commit/b16869c4e4)] - **test**: remove AIX guard in fs-options-immutable (Sakthipriyan Vairamani (thefourtheye)) [#12687](https://github.com/nodejs/node/pull/12687)
* [[`a4fd9e5e6d`](https://github.com/nodejs/node/commit/a4fd9e5e6d)] - **test**: chdir before running test-cli-node-options (Daniel Bevenius) [#12660](https://github.com/nodejs/node/pull/12660)
* [[`d289678352`](https://github.com/nodejs/node/commit/d289678352)] - **test**: dynamic port in dgram tests (Sebastian Plesciuc) [#12623](https://github.com/nodejs/node/pull/12623)
* [[`28f535a923`](https://github.com/nodejs/node/commit/28f535a923)] - **test**: fixup test-http-hostname-typechecking (Anna Henningsen) [#12627](https://github.com/nodejs/node/pull/12627)
* [[`e927809eec`](https://github.com/nodejs/node/commit/e927809eec)] - **test**: dynamic port in parallel regress tests (Sebastian Plesciuc) [#12639](https://github.com/nodejs/node/pull/12639)
* [[`1d968030d4`](https://github.com/nodejs/node/commit/1d968030d4)] - **test**: add coverage for napi_cancel_async_work (Michael Dawson) [#12575](https://github.com/nodejs/node/pull/12575)
* [[`4241577112`](https://github.com/nodejs/node/commit/4241577112)] - **test**: test doc'd napi_get_value_int32 behaviour (Michael Dawson) [#12633](https://github.com/nodejs/node/pull/12633)
* [[`bda34bde56`](https://github.com/nodejs/node/commit/bda34bde56)] - **test**: remove obsolete lint comment (Rich Trott) [#12659](https://github.com/nodejs/node/pull/12659)
* [[`c8c5a528da`](https://github.com/nodejs/node/commit/c8c5a528da)] - **test**: make tests pass when built without inspector (Michaël Zasso) [#12622](https://github.com/nodejs/node/pull/12622)
* [[`d1d9ecfe6e`](https://github.com/nodejs/node/commit/d1d9ecfe6e)] - **test**: support unreleased V8 versions (Michaël Zasso) [#12619](https://github.com/nodejs/node/pull/12619)
* [[`75bfdad037`](https://github.com/nodejs/node/commit/75bfdad037)] - **test**: check that pending warning is emitted once (Rich Trott) [#12527](https://github.com/nodejs/node/pull/12527)
* [[`5e095f699e`](https://github.com/nodejs/node/commit/5e095f699e)] - **test**: verify listener leak is only emitted once (cjihrig) [#12502](https://github.com/nodejs/node/pull/12502)
* [[`4bcbefccce`](https://github.com/nodejs/node/commit/4bcbefccce)] - **test**: add coverage for vm's breakOnSigint option (cjihrig) [#12512](https://github.com/nodejs/node/pull/12512)
* [[`f3f9dd73aa`](https://github.com/nodejs/node/commit/f3f9dd73aa)] - **test**: skip tests using ca flags (Daniel Bevenius) [#12485](https://github.com/nodejs/node/pull/12485)
* [[`86a3ba0c4e`](https://github.com/nodejs/node/commit/86a3ba0c4e)] - **test**: dynamic port in cluster worker wait close (Sebastian Plesciuc) [#12466](https://github.com/nodejs/node/pull/12466)
* [[`6c912a8216`](https://github.com/nodejs/node/commit/6c912a8216)] - **test**: fix coverity UNINIT_CTOR cctest warning (Ben Noordhuis) [#12387](https://github.com/nodejs/node/pull/12387)
* [[`4fc11998b4`](https://github.com/nodejs/node/commit/4fc11998b4)] - **test**: add cwd ENOENT known issue test (cjihrig) [#12343](https://github.com/nodejs/node/pull/12343)
* [[`2e5188de92`](https://github.com/nodejs/node/commit/2e5188de92)] - **test**: remove common.PORT from multiple tests (Tarun Batra) [#12451](https://github.com/nodejs/node/pull/12451)
* [[`7044065f1a`](https://github.com/nodejs/node/commit/7044065f1a)] - **test**: change == to === in crypto test (Fabio Campinho) [#12405](https://github.com/nodejs/node/pull/12405)
* [[`f98db78f77`](https://github.com/nodejs/node/commit/f98db78f77)] - **test**: add internal/fs tests (DavidCai) [#12306](https://github.com/nodejs/node/pull/12306)
* [[`3d2181c5f0`](https://github.com/nodejs/node/commit/3d2181c5f0)] - **test**: run the addon tests last (Sebastian Van Sande) [#12062](https://github.com/nodejs/node/pull/12062)
* [[`8bd26d3aea`](https://github.com/nodejs/node/commit/8bd26d3aea)] - **test**: fix compiler warning in n-api test (Anna Henningsen) [#12318](https://github.com/nodejs/node/pull/12318)
* [[`3900cf66a5`](https://github.com/nodejs/node/commit/3900cf66a5)] - **test**: remove disabled test-dgram-send-error (Rich Trott) [#12330](https://github.com/nodejs/node/pull/12330)
* [[`9de2e159c4`](https://github.com/nodejs/node/commit/9de2e159c4)] - **test**: add second argument to assert.throws (Michaël Zasso) [#12270](https://github.com/nodejs/node/pull/12270)
* [[`0ec0272e10`](https://github.com/nodejs/node/commit/0ec0272e10)] - **test**: improve test coverage for n-api (Michael Dawson) [#12327](https://github.com/nodejs/node/pull/12327)
* [[`569f988be7`](https://github.com/nodejs/node/commit/569f988be7)] - **test**: remove disabled tls_server.js (Rich Trott) [#12275](https://github.com/nodejs/node/pull/12275)
* [[`2555780aa6`](https://github.com/nodejs/node/commit/2555780aa6)] - **test**: check curve algorithm is supported (Karl Cheng) [#12265](https://github.com/nodejs/node/pull/12265)
* [[`2d3d4ccb98`](https://github.com/nodejs/node/commit/2d3d4ccb98)] - **test**: add http benchmark test (Joyee Cheung) [#12121](https://github.com/nodejs/node/pull/12121)
* [[`b03f1f0c01`](https://github.com/nodejs/node/commit/b03f1f0c01)] - **test**: add basic cctest for base64.h (Alexey Orlenko) [#12238](https://github.com/nodejs/node/pull/12238)
* [[`971fe67dce`](https://github.com/nodejs/node/commit/971fe67dce)] - **test**: complete coverage for lib/assert.js (Rich Trott) [#12239](https://github.com/nodejs/node/pull/12239)
* [[`65c100ae8b`](https://github.com/nodejs/node/commit/65c100ae8b)] - **test**: remove disabled debugger test (Rich Trott) [#12199](https://github.com/nodejs/node/pull/12199)
* [[`610ac7d858`](https://github.com/nodejs/node/commit/610ac7d858)] - **test**: increase coverage of internal/socket_list (DavidCai) [#12066](https://github.com/nodejs/node/pull/12066)
* [[`2ff107dad7`](https://github.com/nodejs/node/commit/2ff107dad7)] - **test**: add case for url.parse throwing a URIError (Lovell Fuller) [#12135](https://github.com/nodejs/node/pull/12135)
* [[`5ccaba49f0`](https://github.com/nodejs/node/commit/5ccaba49f0)] - **test**: add variable arguments support for Argv (Daniel Bevenius) [#12166](https://github.com/nodejs/node/pull/12166)
* [[`9348f31c2a`](https://github.com/nodejs/node/commit/9348f31c2a)] - **test**: fix test-cli-syntax assertions on windows (Teddy Katz) [#12212](https://github.com/nodejs/node/pull/12212)
* [[`53828e8bff`](https://github.com/nodejs/node/commit/53828e8bff)] - **test**: extended test to makeCallback cb type check (Luca Maraschi) [#12140](https://github.com/nodejs/node/pull/12140)
* [[`9b05393362`](https://github.com/nodejs/node/commit/9b05393362)] - **test**: fix V8 test on big-endian machines (Anna Henningsen) [#12186](https://github.com/nodejs/node/pull/12186)
* [[`50bfef66f0`](https://github.com/nodejs/node/commit/50bfef66f0)] - **test**: synchronize WPT url test data (Daijiro Wachi) [#12058](https://github.com/nodejs/node/pull/12058)
* [[`92de91d570`](https://github.com/nodejs/node/commit/92de91d570)] - **test**: fix truncation of argv (Daniel Bevenius) [#12110](https://github.com/nodejs/node/pull/12110)
* [[`51b007aaa7`](https://github.com/nodejs/node/commit/51b007aaa7)] - **test**: add cctest for native URL class (James M Snell) [#12042](https://github.com/nodejs/node/pull/12042)
* [[`4f2e372716`](https://github.com/nodejs/node/commit/4f2e372716)] - **test**: add common.noop, default for common.mustCall() (James M Snell) [#12027](https://github.com/nodejs/node/pull/12027)
* [[`4929d12e99`](https://github.com/nodejs/node/commit/4929d12e99)] - **test**: add internal/socket_list tests (DavidCai) [#11989](https://github.com/nodejs/node/pull/11989)
* [[`64d0a73574`](https://github.com/nodejs/node/commit/64d0a73574)] - **test**: minor fixups for REPL eval tests (Anna Henningsen) [#11946](https://github.com/nodejs/node/pull/11946)
* [[`6aed32c579`](https://github.com/nodejs/node/commit/6aed32c579)] - **test**: add tests for unixtimestamp generation (Luca Maraschi) [#11886](https://github.com/nodejs/node/pull/11886)
* [[`1ff6796083`](https://github.com/nodejs/node/commit/1ff6796083)] - **test**: added net.connect lookup type check (Luca Maraschi) [#11873](https://github.com/nodejs/node/pull/11873)
* [[`7b830f4e4a`](https://github.com/nodejs/node/commit/7b830f4e4a)] - **test**: add more and refactor test cases to net.connect (Joyee Cheung) [#11847](https://github.com/nodejs/node/pull/11847)
* [[`474e9d64b5`](https://github.com/nodejs/node/commit/474e9d64b5)] - **test**: add more test cases of server.listen option (Joyee Cheung)
* [[`78cdd4baa4`](https://github.com/nodejs/node/commit/78cdd4baa4)] - **test**: include all stdio strings for fork() (Rich Trott) [#11783](https://github.com/nodejs/node/pull/11783)
* [[`b98004b79c`](https://github.com/nodejs/node/commit/b98004b79c)] - **test**: add hasCrypto check to tls-legacy-deprecated (Daniel Bevenius) [#11747](https://github.com/nodejs/node/pull/11747)
* [[`60c8115f63`](https://github.com/nodejs/node/commit/60c8115f63)] - **test**: clean up comments in test-url-format (Rich Trott) [#11679](https://github.com/nodejs/node/pull/11679)
* [[`1402fef098`](https://github.com/nodejs/node/commit/1402fef098)] - **test**: make tests pass when configured without-ssl (Daniel Bevenius) [#11631](https://github.com/nodejs/node/pull/11631)
* [[`acc3a80546`](https://github.com/nodejs/node/commit/acc3a80546)] - **test**: add two test cases for querystring (Daijiro Wachi) [#11551](https://github.com/nodejs/node/pull/11551)
* [[`a218fa381f`](https://github.com/nodejs/node/commit/a218fa381f)] - **test**: fix WPT.test()'s error handling (Timothy Gu) [#11436](https://github.com/nodejs/node/pull/11436)
* [[`dd2e135560`](https://github.com/nodejs/node/commit/dd2e135560)] - **test**: add two test cases for querystring (Daijiro Wachi) [#11481](https://github.com/nodejs/node/pull/11481)
* [[`82ddf96828`](https://github.com/nodejs/node/commit/82ddf96828)] - **test**: turn on WPT tests on empty param pairs (Joyee Cheung) [#11369](https://github.com/nodejs/node/pull/11369)
* [[`8bcc122349`](https://github.com/nodejs/node/commit/8bcc122349)] - **test**: improve querystring.parse assertion messages (Brian White) [#11234](https://github.com/nodejs/node/pull/11234)
* [[`dd1cf8bb37`](https://github.com/nodejs/node/commit/dd1cf8bb37)] - **test**: refactor test-http-response-statuscode (Rich Trott) [#11274](https://github.com/nodejs/node/pull/11274)
* [[`1544d8f04b`](https://github.com/nodejs/node/commit/1544d8f04b)] - **test**: improve test-buffer-includes.js (toboid) [#11203](https://github.com/nodejs/node/pull/11203)
* [[`f8cdaaa16a`](https://github.com/nodejs/node/commit/f8cdaaa16a)] - **test**: validate error message from buffer.equals (Sebastian Roeder) [#11215](https://github.com/nodejs/node/pull/11215)
* [[`901cb8cb5e`](https://github.com/nodejs/node/commit/901cb8cb5e)] - **test**: increase coverage of buffer (DavidCai) [#11122](https://github.com/nodejs/node/pull/11122)
* [[`78545039d6`](https://github.com/nodejs/node/commit/78545039d6)] - **test**: remove unnecessary eslint-disable max-len (Joyee Cheung) [#11049](https://github.com/nodejs/node/pull/11049)
* [[`6af10907a2`](https://github.com/nodejs/node/commit/6af10907a2)] - **test**: add msg validation to test-buffer-compare (Josh Hollandsworth) [#10807](https://github.com/nodejs/node/pull/10807)
* [[`775de9cc96`](https://github.com/nodejs/node/commit/775de9cc96)] - **test**: improve module version mismatch error check (cjihrig) [#10636](https://github.com/nodejs/node/pull/10636)
* [[`904b66d870`](https://github.com/nodejs/node/commit/904b66d870)] - **test**: increase coverage of Buffer.transcode (Joyee Cheung) [#10437](https://github.com/nodejs/node/pull/10437)
* [[`a180259e42`](https://github.com/nodejs/node/commit/a180259e42)] - **test,lib,doc**: use function declarations (Rich Trott) [#12711](https://github.com/nodejs/node/pull/12711)
* [[`98609fc1c4`](https://github.com/nodejs/node/commit/98609fc1c4)] - **timers**: do not use user object call/apply (Rich Trott) [#12960](https://github.com/nodejs/node/pull/12960)
* [[`b23d414c7e`](https://github.com/nodejs/node/commit/b23d414c7e)] - **tls**: do not wrap net.Socket with StreamWrap (Ruslan Bekenev) [#12799](https://github.com/nodejs/node/pull/12799)
* [[`bfa27d22f5`](https://github.com/nodejs/node/commit/bfa27d22f5)] - **tools**: update certdata.txt (Ben Noordhuis) [#13279](https://github.com/nodejs/node/pull/13279)
* [[`feb90d37ff`](https://github.com/nodejs/node/commit/feb90d37ff)] - **tools**: relax lint rule for regexps (Rich Trott) [#12807](https://github.com/nodejs/node/pull/12807)
* [[`53c88fa411`](https://github.com/nodejs/node/commit/53c88fa411)] - **tools**: remove unused code from test.py (Rich Trott) [#12806](https://github.com/nodejs/node/pull/12806)
* [[`595d4ec114`](https://github.com/nodejs/node/commit/595d4ec114)] - **tools**: ignore node_trace.*.log (Daijiro Wachi) [#12754](https://github.com/nodejs/node/pull/12754)
* [[`aea7269c45`](https://github.com/nodejs/node/commit/aea7269c45)] - **tools**: require function declarations (Rich Trott) [#12711](https://github.com/nodejs/node/pull/12711)
* [[`e7c3f4a97b`](https://github.com/nodejs/node/commit/e7c3f4a97b)] - **tools**: fix gyp to work on MacOSX without XCode (Shigeki Ohtsu) [iojs/io.js#1325](https://github.com/iojs/io.js/pull/1325)
* [[`a4b9c585b3`](https://github.com/nodejs/node/commit/a4b9c585b3)] - **tools**: enforce two arguments in assert.throws (Michaël Zasso) [#12270](https://github.com/nodejs/node/pull/12270)
* [[`b3f2e3b7e2`](https://github.com/nodejs/node/commit/b3f2e3b7e2)] - **tools**: replace custom assert.fail lint rule (Rich Trott) [#12287](https://github.com/nodejs/node/pull/12287)
* [[`8191af5b29`](https://github.com/nodejs/node/commit/8191af5b29)] - **tools**: replace custom new-with-error rule (Rich Trott) [#12249](https://github.com/nodejs/node/pull/12249)
* [[`61ebfa8d1f`](https://github.com/nodejs/node/commit/61ebfa8d1f)] - **tools**: add unescaped regexp dot rule to linter (Brian White) [#11834](https://github.com/nodejs/node/pull/11834)
* [[`20b18236de`](https://github.com/nodejs/node/commit/20b18236de)] - **tools**: add rule prefering common.mustNotCall() (James M Snell) [#12027](https://github.com/nodejs/node/pull/12027)
* [[`096508dfa9`](https://github.com/nodejs/node/commit/096508dfa9)] - **tools,lib**: enable strict equality lint rule (Rich Trott) [#12446](https://github.com/nodejs/node/pull/12446)
* [[`70cdfc5eb1`](https://github.com/nodejs/node/commit/70cdfc5eb1)] - **url**: expose WHATWG url.origin as ASCII (Timothy Gu) [#13126](https://github.com/nodejs/node/pull/13126)
* [[`06a617aa21`](https://github.com/nodejs/node/commit/06a617aa21)] - **url**: update IDNA error conditions (Rajaram Gaunker) [#12966](https://github.com/nodejs/node/pull/12966)
* [[`841bb4c61f`](https://github.com/nodejs/node/commit/841bb4c61f)] - **url**: fix C0 control and whitespace handling (Timothy Gu) [#12846](https://github.com/nodejs/node/pull/12846)
* [[`943dd5f9ed`](https://github.com/nodejs/node/commit/943dd5f9ed)] - **url**: handle windows drive letter in the file state (Daijiro Wachi) [#12808](https://github.com/nodejs/node/pull/12808)
* [[`8491c705b1`](https://github.com/nodejs/node/commit/8491c705b1)] - **url**: fix permanent deoptimizations (Brian White) [#12456](https://github.com/nodejs/node/pull/12456)
* [[`97ec72b76d`](https://github.com/nodejs/node/commit/97ec72b76d)] - **url**: refactor binding imports in internal/url (James M Snell) [#12717](https://github.com/nodejs/node/pull/12717)
* [[`b331ba6ca9`](https://github.com/nodejs/node/commit/b331ba6ca9)] - **url**: move to module.exports = {} pattern (James M Snell) [#12717](https://github.com/nodejs/node/pull/12717)
* [[`d457a986a0`](https://github.com/nodejs/node/commit/d457a986a0)] - **url**: port WHATWG URL API to internal/errors (Timothy Gu) [#12574](https://github.com/nodejs/node/pull/12574)
* [[`061c5da010`](https://github.com/nodejs/node/commit/061c5da010)] - **url**: use internal/util's getConstructorOf (Timothy Gu) [#12526](https://github.com/nodejs/node/pull/12526)
* [[`2841f478e4`](https://github.com/nodejs/node/commit/2841f478e4)] - **url**: improve WHATWG URL inspection (Timothy Gu) [#12253](https://github.com/nodejs/node/pull/12253)
* [[`aff5cc92b9`](https://github.com/nodejs/node/commit/aff5cc92b9)] - **url**: clean up WHATWG URL origin generation (Timothy Gu) [#12252](https://github.com/nodejs/node/pull/12252)
* [[`1b99d8ffe9`](https://github.com/nodejs/node/commit/1b99d8ffe9)] - **url**: disallow invalid IPv4 in IPv6 parser (Daijiro Wachi) [#12315](https://github.com/nodejs/node/pull/12315)
* [[`eb0492d51e`](https://github.com/nodejs/node/commit/eb0492d51e)] - **url**: remove javascript URL special case (Daijiro Wachi) [#12331](https://github.com/nodejs/node/pull/12331)
* [[`b470a85f07`](https://github.com/nodejs/node/commit/b470a85f07)] - **url**: trim leading slashes of file URL paths (Daijiro Wachi) [#12203](https://github.com/nodejs/node/pull/12203)
* [[`b76a350a19`](https://github.com/nodejs/node/commit/b76a350a19)] - **url**: avoid instanceof for WHATWG URL (Brian White) [#11690](https://github.com/nodejs/node/pull/11690)
* [[`c4469c49ec`](https://github.com/nodejs/node/commit/c4469c49ec)] - **url**: error when domainTo*() is called w/o argument (Timothy Gu) [#12134](https://github.com/nodejs/node/pull/12134)
* [[`f8f46f9917`](https://github.com/nodejs/node/commit/f8f46f9917)] - **url**: change path parsing for non-special URLs (Daijiro Wachi) [#12058](https://github.com/nodejs/node/pull/12058)
* [[`7139b93a8b`](https://github.com/nodejs/node/commit/7139b93a8b)] - **url**: add ToObject method to native URL class (James M Snell) [#12056](https://github.com/nodejs/node/pull/12056)
* [[`14a91957f8`](https://github.com/nodejs/node/commit/14a91957f8)] - **url**: use a class for WHATWG url\[context\] (Timothy Gu) [#11930](https://github.com/nodejs/node/pull/11930)
* [[`c515a985ea`](https://github.com/nodejs/node/commit/c515a985ea)] - **url**: spec-compliant URLSearchParams parser (Timothy Gu) [#11858](https://github.com/nodejs/node/pull/11858)
* [[`d77a7588cf`](https://github.com/nodejs/node/commit/d77a7588cf)] - **url**: spec-compliant URLSearchParams serializer (Timothy Gu) [#11626](https://github.com/nodejs/node/pull/11626)
* [[`99b27ce99a`](https://github.com/nodejs/node/commit/99b27ce99a)] - **url**: prioritize toString when stringifying (Timothy Gu) [#11737](https://github.com/nodejs/node/pull/11737)
* [[`b610a4db1c`](https://github.com/nodejs/node/commit/b610a4db1c)] - **url**: enforce valid UTF-8 in WHATWG parser (Timothy Gu) [#11436](https://github.com/nodejs/node/pull/11436)
* [[`147d2a6419`](https://github.com/nodejs/node/commit/147d2a6419)] - **url, test**: break up test-url.js (Joyee Cheung) [#11049](https://github.com/nodejs/node/pull/11049)
* [[`ef16319eff`](https://github.com/nodejs/node/commit/ef16319eff)] - **util**: fixup internal util exports (James M Snell) [#12998](https://github.com/nodejs/node/pull/12998)
* [[`d5925af8d7`](https://github.com/nodejs/node/commit/d5925af8d7)] - **util**: fix permanent deoptimizations (Brian White) [#12456](https://github.com/nodejs/node/pull/12456)
* [[`3c0dd45c88`](https://github.com/nodejs/node/commit/3c0dd45c88)] - **util**: move getConstructorOf() to internal (Timothy Gu) [#12526](https://github.com/nodejs/node/pull/12526)
* [[`a37273c1e4`](https://github.com/nodejs/node/commit/a37273c1e4)] - **util**: use V8 C++ API for inspecting Promises (Timothy Gu) [#12254](https://github.com/nodejs/node/pull/12254)
* [[`c8be718749`](https://github.com/nodejs/node/commit/c8be718749)] - **v8**: backport pieces from 18a26cfe174 from upstream v8 (Peter Marshall) [#13217](https://github.com/nodejs/node/pull/13217)
* [[`cfdcd6cf33`](https://github.com/nodejs/node/commit/cfdcd6cf33)] - **v8**: backport 43791ce02c8 from upstream v8 (kozyatinskiy) [#13217](https://github.com/nodejs/node/pull/13217)
* [[`1061e43739`](https://github.com/nodejs/node/commit/1061e43739)] - **v8**: backport faf5f52627c from upstream v8 (Peter Marshall) [#13217](https://github.com/nodejs/node/pull/13217)
* [[`a56f9698cb`](https://github.com/nodejs/node/commit/a56f9698cb)] - **v8**: backport 4f82f1d948c from upstream v8 (hpayer) [#13217](https://github.com/nodejs/node/pull/13217)
* [[`13a961e9dc`](https://github.com/nodejs/node/commit/13a961e9dc)] - **v8**: backport 4f82f1d948c from upstream v8 (hpayer) [#13217](https://github.com/nodejs/node/pull/13217)
* [[`188630b84c`](https://github.com/nodejs/node/commit/188630b84c)] - **v8**: backport a9e56f4f36d from upstream v8 (Peter Marshall) [#13217](https://github.com/nodejs/node/pull/13217)
* [[`0f3bfaf530`](https://github.com/nodejs/node/commit/0f3bfaf530)] - **v8**: backport bd59e7452be from upstream v8 (Michael Achenbach) [#13217](https://github.com/nodejs/node/pull/13217)
* [[`6d5ca4feb0`](https://github.com/nodejs/node/commit/6d5ca4feb0)] - **v8**: backport pieces of dab18fb0bbcdd (Anna Henningsen) [#12875](https://github.com/nodejs/node/pull/12875)
* [[`62eaa2a186`](https://github.com/nodejs/node/commit/62eaa2a186)] - **v8**: do not test v8 with -Werror (Anna Henningsen) [#12875](https://github.com/nodejs/node/pull/12875)
* [[`f118f7ae90`](https://github.com/nodejs/node/commit/f118f7ae90)] - **v8**: backport header diff from 2e4a68733803 (Anna Henningsen) [#12875](https://github.com/nodejs/node/pull/12875)
* [[`a947cf9a03`](https://github.com/nodejs/node/commit/a947cf9a03)] - **v8**: backport header diff from 94283dcf4459f (Anna Henningsen) [#12875](https://github.com/nodejs/node/pull/12875)
* [[`1bb880b595`](https://github.com/nodejs/node/commit/1bb880b595)] - **v8**: backport pieces of bf463c4dc0 and dc662e5b74 (Anna Henningsen) [#12875](https://github.com/nodejs/node/pull/12875)
* [[`04e646be52`](https://github.com/nodejs/node/commit/04e646be52)] - **v8**: backport header diff from da5b745dba387 (Anna Henningsen) [#12875](https://github.com/nodejs/node/pull/12875)
* [[`39834bc441`](https://github.com/nodejs/node/commit/39834bc441)] - **v8**: backport pieces of 6226576efa82ee (Anna Henningsen) [#12875](https://github.com/nodejs/node/pull/12875)
* [[`25430fd247`](https://github.com/nodejs/node/commit/25430fd247)] - **v8**: backport pieces from 99743ad460e (Anna Henningsen) [#12875](https://github.com/nodejs/node/pull/12875)
* [[`0f3e69db41`](https://github.com/nodejs/node/commit/0f3e69db41)] - **v8**: fix gcc 7 build errors (Zuzana Svetlikova) [#12676](https://github.com/nodejs/node/pull/12676)
* [[`b07e1a828c`](https://github.com/nodejs/node/commit/b07e1a828c)] - **v8**: fix gcc 7 build errors (Zuzana Svetlikova) [#12676](https://github.com/nodejs/node/pull/12676)
* [[`1052383f7c`](https://github.com/nodejs/node/commit/1052383f7c)] - **v8**: refactor struture of v8 module (James M Snell) [#12681](https://github.com/nodejs/node/pull/12681)
* [[`33a19b46ca`](https://github.com/nodejs/node/commit/33a19b46ca)] - **v8**: fix offsets for TypedArray deserialization (Anna Henningsen) [#12143](https://github.com/nodejs/node/pull/12143)
* [[`6b25c75cda`](https://github.com/nodejs/node/commit/6b25c75cda)] - **vm**: fix race condition with timeout param (Marcel Laverdet) [#13074](https://github.com/nodejs/node/pull/13074)
* [[`191bb5a358`](https://github.com/nodejs/node/commit/191bb5a358)] - **vm**: fix displayErrors in runIn.. functions (Marcel Laverdet) [#13074](https://github.com/nodejs/node/pull/13074)
* [[`1c93e8c94b`](https://github.com/nodejs/node/commit/1c93e8c94b)] - **win**: make buildable on VS2017 (Refael Ackermann) [#11852](https://github.com/nodejs/node/pull/11852)
* [[`ea01cd7adb`](https://github.com/nodejs/node/commit/ea01cd7adb)] - **zlib**: remove unused declaration (Anna Henningsen) [#12432](https://github.com/nodejs/node/pull/12432)
